.TH "ZIP_STAT_INIT" "3" "September 22, 2013" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_stat_init\fR
\- initialize zip_stat structure
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIvoid\fR
.PD 0
.HP 4n
\fBzip_stat_init\fR(\fIzip_stat_t\ *sb\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_stat_init\fR()
function initializes the members of a struct zip_stat.
The current members are described in
zip_stat(3),
but this function should be used to initialize it to
make sure none are missed.
The structure pointed to by
\fIsb\fR
must be allocated before calling
\fBzip_stat_init\fR().
.PP
This function should be used by functions provided to
zip_source_function(3)
when returning
\fRZIP_SOURCE_STAT\fR
information to make sure all fields are initialized.
.SH "RETURN VALUES"
If
\fIsb\fR
is valid, the function is always successful.
.SH "SEE ALSO"
libzip(3),
zip_stat(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
