// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: influxql.gen.go.tmpl

package kapacitor

import (
	"fmt"
	"reflect"
	"time"

	"github.com/influxdata/influxdb/influxql"
	"github.com/influxdata/kapacitor/models"
	"github.com/influxdata/kapacitor/pipeline"
)

type floatPointAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       influxql.FloatPointAggregator
}

func floatPopulateAuxFieldsAndTags(ap *influxql.FloatPoint, fieldsAndTags []string, fields models.Fields, tags models.Tags) {
	ap.Aux = make([]interface{}, len(fieldsAndTags))
	for i, name := range fieldsAndTags {
		if f, ok := fields[name]; ok {
			ap.Aux[i] = f
		} else {
			ap.Aux[i] = tags[name]
		}
	}
}

func (a *floatPointAggregator) AggregateBatch(b *models.Batch) error {
	for _, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(float64)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp float64", a.field, value)
		}
		ap := &influxql.FloatPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			floatPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			ap.Aux = []interface{}{p.Tags, p.Fields}
		}

		a.aggregator.AggregateFloat(ap)
	}
	return nil
}

func (a *floatPointAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(float64)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp float64", a.field, value)
	}
	ap := &influxql.FloatPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		floatPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateFloat(ap)
	return nil
}

type floatPointBulkAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       pipeline.FloatBulkPointAggregator
}

func (a *floatPointBulkAggregator) AggregateBatch(b *models.Batch) error {
	slice := make([]influxql.FloatPoint, len(b.Points))
	for i, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(float64)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp float64", a.field, value)
		}
		slice[i] = influxql.FloatPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			floatPopulateAuxFieldsAndTags(&slice[i], a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			slice[i].Aux = []interface{}{p.Tags, p.Fields}
		}
	}
	a.aggregator.AggregateFloatBulk(slice)
	return nil
}

func (a *floatPointBulkAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(float64)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp float64", a.field, value)
	}
	ap := &influxql.FloatPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		floatPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateFloat(ap)
	return nil
}

type floatPointEmitter struct {
	baseReduceContext
	emitter          influxql.FloatPointEmitter
	isSimpleSelector bool
	byName           bool
}

func (e *floatPointEmitter) EmitPoint() (models.Point, error) {
	slice := e.emitter.Emit()
	if len(slice) != 1 {
		return models.Point{}, ErrEmptyEmit
	}
	ap := slice[0]
	var t time.Time
	if e.pointTimes {
		if ap.Time == influxql.ZeroTime {
			t = e.time
		} else {
			t = time.Unix(0, ap.Time).UTC()
		}
	} else {
		t = e.time
	}

	var fields models.Fields
	var tags models.Tags
	if e.isSimpleSelector {
		tags = ap.Aux[0].(models.Tags)
		fields = ap.Aux[1].(models.Fields)
		if e.as != e.field {
			fields = fields.Copy()
			fields[e.as] = fields[e.field]
			delete(fields, e.field)
		}
	} else {
		tags = e.tags
		fields = map[string]interface{}{e.as: ap.Value}
	}

	return models.Point{
		Name:       e.name,
		Time:       t,
		Group:      e.group,
		Dimensions: e.dimensions,
		Tags:       tags,
		Fields:     fields,
	}, nil
}

func (e *floatPointEmitter) EmitBatch() models.Batch {
	slice := e.emitter.Emit()
	b := models.Batch{
		Name:   e.name,
		TMax:   e.time,
		Group:  e.group,
		ByName: e.dimensions.ByName,
		Tags:   e.tags,
		Points: make([]models.BatchPoint, len(slice)),
	}
	var t time.Time
	for i, ap := range slice {
		if e.pointTimes {
			if ap.Time == influxql.ZeroTime {
				t = e.time
			} else {
				t = time.Unix(0, ap.Time).UTC()
			}
		} else {
			t = e.time
		}
		var tags models.Tags
		if l := len(ap.Tags.KeyValues()); l > 0 {
			// Merge batch and point specific tags
			tags = make(models.Tags, len(e.tags)+l)
			for k, v := range e.tags {
				tags[k] = v
			}
			for k, v := range ap.Tags.KeyValues() {
				tags[k] = v
			}
		} else {
			tags = e.tags
		}
		b.Points[i] = models.BatchPoint{
			Time:   t,
			Tags:   tags,
			Fields: map[string]interface{}{e.as: ap.Value},
		}
		if t.After(b.TMax) {
			b.TMax = t
		}
	}
	return b
}

type integerPointAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       influxql.IntegerPointAggregator
}

func integerPopulateAuxFieldsAndTags(ap *influxql.IntegerPoint, fieldsAndTags []string, fields models.Fields, tags models.Tags) {
	ap.Aux = make([]interface{}, len(fieldsAndTags))
	for i, name := range fieldsAndTags {
		if f, ok := fields[name]; ok {
			ap.Aux[i] = f
		} else {
			ap.Aux[i] = tags[name]
		}
	}
}

func (a *integerPointAggregator) AggregateBatch(b *models.Batch) error {
	for _, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(int64)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp int64", a.field, value)
		}
		ap := &influxql.IntegerPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			integerPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			ap.Aux = []interface{}{p.Tags, p.Fields}
		}

		a.aggregator.AggregateInteger(ap)
	}
	return nil
}

func (a *integerPointAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(int64)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp int64", a.field, value)
	}
	ap := &influxql.IntegerPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		integerPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateInteger(ap)
	return nil
}

type integerPointBulkAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       pipeline.IntegerBulkPointAggregator
}

func (a *integerPointBulkAggregator) AggregateBatch(b *models.Batch) error {
	slice := make([]influxql.IntegerPoint, len(b.Points))
	for i, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(int64)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp int64", a.field, value)
		}
		slice[i] = influxql.IntegerPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			integerPopulateAuxFieldsAndTags(&slice[i], a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			slice[i].Aux = []interface{}{p.Tags, p.Fields}
		}
	}
	a.aggregator.AggregateIntegerBulk(slice)
	return nil
}

func (a *integerPointBulkAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(int64)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp int64", a.field, value)
	}
	ap := &influxql.IntegerPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		integerPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateInteger(ap)
	return nil
}

type integerPointEmitter struct {
	baseReduceContext
	emitter          influxql.IntegerPointEmitter
	isSimpleSelector bool
	byName           bool
}

func (e *integerPointEmitter) EmitPoint() (models.Point, error) {
	slice := e.emitter.Emit()
	if len(slice) != 1 {
		return models.Point{}, ErrEmptyEmit
	}
	ap := slice[0]
	var t time.Time
	if e.pointTimes {
		if ap.Time == influxql.ZeroTime {
			t = e.time
		} else {
			t = time.Unix(0, ap.Time).UTC()
		}
	} else {
		t = e.time
	}

	var fields models.Fields
	var tags models.Tags
	if e.isSimpleSelector {
		tags = ap.Aux[0].(models.Tags)
		fields = ap.Aux[1].(models.Fields)
		if e.as != e.field {
			fields = fields.Copy()
			fields[e.as] = fields[e.field]
			delete(fields, e.field)
		}
	} else {
		tags = e.tags
		fields = map[string]interface{}{e.as: ap.Value}
	}

	return models.Point{
		Name:       e.name,
		Time:       t,
		Group:      e.group,
		Dimensions: e.dimensions,
		Tags:       tags,
		Fields:     fields,
	}, nil
}

func (e *integerPointEmitter) EmitBatch() models.Batch {
	slice := e.emitter.Emit()
	b := models.Batch{
		Name:   e.name,
		TMax:   e.time,
		Group:  e.group,
		ByName: e.dimensions.ByName,
		Tags:   e.tags,
		Points: make([]models.BatchPoint, len(slice)),
	}
	var t time.Time
	for i, ap := range slice {
		if e.pointTimes {
			if ap.Time == influxql.ZeroTime {
				t = e.time
			} else {
				t = time.Unix(0, ap.Time).UTC()
			}
		} else {
			t = e.time
		}
		var tags models.Tags
		if l := len(ap.Tags.KeyValues()); l > 0 {
			// Merge batch and point specific tags
			tags = make(models.Tags, len(e.tags)+l)
			for k, v := range e.tags {
				tags[k] = v
			}
			for k, v := range ap.Tags.KeyValues() {
				tags[k] = v
			}
		} else {
			tags = e.tags
		}
		b.Points[i] = models.BatchPoint{
			Time:   t,
			Tags:   tags,
			Fields: map[string]interface{}{e.as: ap.Value},
		}
		if t.After(b.TMax) {
			b.TMax = t
		}
	}
	return b
}

type stringPointAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       influxql.StringPointAggregator
}

func stringPopulateAuxFieldsAndTags(ap *influxql.StringPoint, fieldsAndTags []string, fields models.Fields, tags models.Tags) {
	ap.Aux = make([]interface{}, len(fieldsAndTags))
	for i, name := range fieldsAndTags {
		if f, ok := fields[name]; ok {
			ap.Aux[i] = f
		} else {
			ap.Aux[i] = tags[name]
		}
	}
}

func (a *stringPointAggregator) AggregateBatch(b *models.Batch) error {
	for _, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(string)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp string", a.field, value)
		}
		ap := &influxql.StringPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			stringPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			ap.Aux = []interface{}{p.Tags, p.Fields}
		}

		a.aggregator.AggregateString(ap)
	}
	return nil
}

func (a *stringPointAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(string)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp string", a.field, value)
	}
	ap := &influxql.StringPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		stringPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateString(ap)
	return nil
}

type stringPointBulkAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       pipeline.StringBulkPointAggregator
}

func (a *stringPointBulkAggregator) AggregateBatch(b *models.Batch) error {
	slice := make([]influxql.StringPoint, len(b.Points))
	for i, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(string)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp string", a.field, value)
		}
		slice[i] = influxql.StringPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			stringPopulateAuxFieldsAndTags(&slice[i], a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			slice[i].Aux = []interface{}{p.Tags, p.Fields}
		}
	}
	a.aggregator.AggregateStringBulk(slice)
	return nil
}

func (a *stringPointBulkAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(string)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp string", a.field, value)
	}
	ap := &influxql.StringPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		stringPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateString(ap)
	return nil
}

type stringPointEmitter struct {
	baseReduceContext
	emitter          influxql.StringPointEmitter
	isSimpleSelector bool
	byName           bool
}

func (e *stringPointEmitter) EmitPoint() (models.Point, error) {
	slice := e.emitter.Emit()
	if len(slice) != 1 {
		return models.Point{}, ErrEmptyEmit
	}
	ap := slice[0]
	var t time.Time
	if e.pointTimes {
		if ap.Time == influxql.ZeroTime {
			t = e.time
		} else {
			t = time.Unix(0, ap.Time).UTC()
		}
	} else {
		t = e.time
	}

	var fields models.Fields
	var tags models.Tags
	if e.isSimpleSelector {
		tags = ap.Aux[0].(models.Tags)
		fields = ap.Aux[1].(models.Fields)
		if e.as != e.field {
			fields = fields.Copy()
			fields[e.as] = fields[e.field]
			delete(fields, e.field)
		}
	} else {
		tags = e.tags
		fields = map[string]interface{}{e.as: ap.Value}
	}

	return models.Point{
		Name:       e.name,
		Time:       t,
		Group:      e.group,
		Dimensions: e.dimensions,
		Tags:       tags,
		Fields:     fields,
	}, nil
}

func (e *stringPointEmitter) EmitBatch() models.Batch {
	slice := e.emitter.Emit()
	b := models.Batch{
		Name:   e.name,
		TMax:   e.time,
		Group:  e.group,
		ByName: e.dimensions.ByName,
		Tags:   e.tags,
		Points: make([]models.BatchPoint, len(slice)),
	}
	var t time.Time
	for i, ap := range slice {
		if e.pointTimes {
			if ap.Time == influxql.ZeroTime {
				t = e.time
			} else {
				t = time.Unix(0, ap.Time).UTC()
			}
		} else {
			t = e.time
		}
		var tags models.Tags
		if l := len(ap.Tags.KeyValues()); l > 0 {
			// Merge batch and point specific tags
			tags = make(models.Tags, len(e.tags)+l)
			for k, v := range e.tags {
				tags[k] = v
			}
			for k, v := range ap.Tags.KeyValues() {
				tags[k] = v
			}
		} else {
			tags = e.tags
		}
		b.Points[i] = models.BatchPoint{
			Time:   t,
			Tags:   tags,
			Fields: map[string]interface{}{e.as: ap.Value},
		}
		if t.After(b.TMax) {
			b.TMax = t
		}
	}
	return b
}

type booleanPointAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       influxql.BooleanPointAggregator
}

func booleanPopulateAuxFieldsAndTags(ap *influxql.BooleanPoint, fieldsAndTags []string, fields models.Fields, tags models.Tags) {
	ap.Aux = make([]interface{}, len(fieldsAndTags))
	for i, name := range fieldsAndTags {
		if f, ok := fields[name]; ok {
			ap.Aux[i] = f
		} else {
			ap.Aux[i] = tags[name]
		}
	}
}

func (a *booleanPointAggregator) AggregateBatch(b *models.Batch) error {
	for _, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(bool)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp bool", a.field, value)
		}
		ap := &influxql.BooleanPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			booleanPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			ap.Aux = []interface{}{p.Tags, p.Fields}
		}

		a.aggregator.AggregateBoolean(ap)
	}
	return nil
}

func (a *booleanPointAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(bool)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp bool", a.field, value)
	}
	ap := &influxql.BooleanPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		booleanPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateBoolean(ap)
	return nil
}

type booleanPointBulkAggregator struct {
	field            string
	topBottomInfo    *pipeline.TopBottomCallInfo
	isSimpleSelector bool
	aggregator       pipeline.BooleanBulkPointAggregator
}

func (a *booleanPointBulkAggregator) AggregateBatch(b *models.Batch) error {
	slice := make([]influxql.BooleanPoint, len(b.Points))
	for i, p := range b.Points {
		value, ok := p.Fields[a.field]
		if !ok {
			return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
		}
		typed, ok := value.(bool)
		if !ok {
			return fmt.Errorf("field %s has wrong type: got %T exp bool", a.field, value)
		}
		slice[i] = influxql.BooleanPoint{
			Name:  b.Name,
			Tags:  influxql.NewTags(p.Tags),
			Time:  p.Time.UnixNano(),
			Value: typed,
		}
		if a.topBottomInfo != nil {
			// We need to populate the Aux fields
			booleanPopulateAuxFieldsAndTags(&slice[i], a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
		}

		if a.isSimpleSelector {
			slice[i].Aux = []interface{}{p.Tags, p.Fields}
		}
	}
	a.aggregator.AggregateBooleanBulk(slice)
	return nil
}

func (a *booleanPointBulkAggregator) AggregatePoint(p *models.Point) error {
	value, ok := p.Fields[a.field]
	if !ok {
		return fmt.Errorf("field %s missing from point cannot aggregate", a.field)
	}
	typed, ok := value.(bool)
	if !ok {
		return fmt.Errorf("field %s has wrong type: got %T exp bool", a.field, value)
	}
	ap := &influxql.BooleanPoint{
		Name:  p.Name,
		Tags:  influxql.NewTags(p.Tags),
		Time:  p.Time.UnixNano(),
		Value: typed,
	}
	if a.topBottomInfo != nil {
		// We need to populate the Aux fields
		booleanPopulateAuxFieldsAndTags(ap, a.topBottomInfo.FieldsAndTags, p.Fields, p.Tags)
	}

	if a.isSimpleSelector {
		ap.Aux = []interface{}{p.Tags, p.Fields}
	}

	a.aggregator.AggregateBoolean(ap)
	return nil
}

type booleanPointEmitter struct {
	baseReduceContext
	emitter          influxql.BooleanPointEmitter
	isSimpleSelector bool
	byName           bool
}

func (e *booleanPointEmitter) EmitPoint() (models.Point, error) {
	slice := e.emitter.Emit()
	if len(slice) != 1 {
		return models.Point{}, ErrEmptyEmit
	}
	ap := slice[0]
	var t time.Time
	if e.pointTimes {
		if ap.Time == influxql.ZeroTime {
			t = e.time
		} else {
			t = time.Unix(0, ap.Time).UTC()
		}
	} else {
		t = e.time
	}

	var fields models.Fields
	var tags models.Tags
	if e.isSimpleSelector {
		tags = ap.Aux[0].(models.Tags)
		fields = ap.Aux[1].(models.Fields)
		if e.as != e.field {
			fields = fields.Copy()
			fields[e.as] = fields[e.field]
			delete(fields, e.field)
		}
	} else {
		tags = e.tags
		fields = map[string]interface{}{e.as: ap.Value}
	}

	return models.Point{
		Name:       e.name,
		Time:       t,
		Group:      e.group,
		Dimensions: e.dimensions,
		Tags:       tags,
		Fields:     fields,
	}, nil
}

func (e *booleanPointEmitter) EmitBatch() models.Batch {
	slice := e.emitter.Emit()
	b := models.Batch{
		Name:   e.name,
		TMax:   e.time,
		Group:  e.group,
		ByName: e.dimensions.ByName,
		Tags:   e.tags,
		Points: make([]models.BatchPoint, len(slice)),
	}
	var t time.Time
	for i, ap := range slice {
		if e.pointTimes {
			if ap.Time == influxql.ZeroTime {
				t = e.time
			} else {
				t = time.Unix(0, ap.Time).UTC()
			}
		} else {
			t = e.time
		}
		var tags models.Tags
		if l := len(ap.Tags.KeyValues()); l > 0 {
			// Merge batch and point specific tags
			tags = make(models.Tags, len(e.tags)+l)
			for k, v := range e.tags {
				tags[k] = v
			}
			for k, v := range ap.Tags.KeyValues() {
				tags[k] = v
			}
		} else {
			tags = e.tags
		}
		b.Points[i] = models.BatchPoint{
			Time:   t,
			Tags:   tags,
			Fields: map[string]interface{}{e.as: ap.Value},
		}
		if t.After(b.TMax) {
			b.TMax = t
		}
	}
	return b
}

// floatReduceContext uses composition to implement the reduceContext interface
type floatReduceContext struct {
	floatPointAggregator
	floatPointEmitter
}

// floatBulkReduceContext uses composition to implement the reduceContext interface
type floatBulkReduceContext struct {
	floatPointBulkAggregator
	floatPointEmitter
}

// floatIntegerReduceContext uses composition to implement the reduceContext interface
type floatIntegerReduceContext struct {
	floatPointAggregator
	integerPointEmitter
}

// floatBulkIntegerReduceContext uses composition to implement the reduceContext interface
type floatBulkIntegerReduceContext struct {
	floatPointBulkAggregator
	integerPointEmitter
}

// floatStringReduceContext uses composition to implement the reduceContext interface
type floatStringReduceContext struct {
	floatPointAggregator
	stringPointEmitter
}

// floatBulkStringReduceContext uses composition to implement the reduceContext interface
type floatBulkStringReduceContext struct {
	floatPointBulkAggregator
	stringPointEmitter
}

// floatBooleanReduceContext uses composition to implement the reduceContext interface
type floatBooleanReduceContext struct {
	floatPointAggregator
	booleanPointEmitter
}

// floatBulkBooleanReduceContext uses composition to implement the reduceContext interface
type floatBulkBooleanReduceContext struct {
	floatPointBulkAggregator
	booleanPointEmitter
}

// integerFloatReduceContext uses composition to implement the reduceContext interface
type integerFloatReduceContext struct {
	integerPointAggregator
	floatPointEmitter
}

// integerBulkFloatReduceContext uses composition to implement the reduceContext interface
type integerBulkFloatReduceContext struct {
	integerPointBulkAggregator
	floatPointEmitter
}

// integerReduceContext uses composition to implement the reduceContext interface
type integerReduceContext struct {
	integerPointAggregator
	integerPointEmitter
}

// integerBulkReduceContext uses composition to implement the reduceContext interface
type integerBulkReduceContext struct {
	integerPointBulkAggregator
	integerPointEmitter
}

// integerStringReduceContext uses composition to implement the reduceContext interface
type integerStringReduceContext struct {
	integerPointAggregator
	stringPointEmitter
}

// integerBulkStringReduceContext uses composition to implement the reduceContext interface
type integerBulkStringReduceContext struct {
	integerPointBulkAggregator
	stringPointEmitter
}

// integerBooleanReduceContext uses composition to implement the reduceContext interface
type integerBooleanReduceContext struct {
	integerPointAggregator
	booleanPointEmitter
}

// integerBulkBooleanReduceContext uses composition to implement the reduceContext interface
type integerBulkBooleanReduceContext struct {
	integerPointBulkAggregator
	booleanPointEmitter
}

// stringFloatReduceContext uses composition to implement the reduceContext interface
type stringFloatReduceContext struct {
	stringPointAggregator
	floatPointEmitter
}

// stringBulkFloatReduceContext uses composition to implement the reduceContext interface
type stringBulkFloatReduceContext struct {
	stringPointBulkAggregator
	floatPointEmitter
}

// stringIntegerReduceContext uses composition to implement the reduceContext interface
type stringIntegerReduceContext struct {
	stringPointAggregator
	integerPointEmitter
}

// stringBulkIntegerReduceContext uses composition to implement the reduceContext interface
type stringBulkIntegerReduceContext struct {
	stringPointBulkAggregator
	integerPointEmitter
}

// stringReduceContext uses composition to implement the reduceContext interface
type stringReduceContext struct {
	stringPointAggregator
	stringPointEmitter
}

// stringBulkReduceContext uses composition to implement the reduceContext interface
type stringBulkReduceContext struct {
	stringPointBulkAggregator
	stringPointEmitter
}

// stringBooleanReduceContext uses composition to implement the reduceContext interface
type stringBooleanReduceContext struct {
	stringPointAggregator
	booleanPointEmitter
}

// stringBulkBooleanReduceContext uses composition to implement the reduceContext interface
type stringBulkBooleanReduceContext struct {
	stringPointBulkAggregator
	booleanPointEmitter
}

// booleanFloatReduceContext uses composition to implement the reduceContext interface
type booleanFloatReduceContext struct {
	booleanPointAggregator
	floatPointEmitter
}

// booleanBulkFloatReduceContext uses composition to implement the reduceContext interface
type booleanBulkFloatReduceContext struct {
	booleanPointBulkAggregator
	floatPointEmitter
}

// booleanIntegerReduceContext uses composition to implement the reduceContext interface
type booleanIntegerReduceContext struct {
	booleanPointAggregator
	integerPointEmitter
}

// booleanBulkIntegerReduceContext uses composition to implement the reduceContext interface
type booleanBulkIntegerReduceContext struct {
	booleanPointBulkAggregator
	integerPointEmitter
}

// booleanStringReduceContext uses composition to implement the reduceContext interface
type booleanStringReduceContext struct {
	booleanPointAggregator
	stringPointEmitter
}

// booleanBulkStringReduceContext uses composition to implement the reduceContext interface
type booleanBulkStringReduceContext struct {
	booleanPointBulkAggregator
	stringPointEmitter
}

// booleanReduceContext uses composition to implement the reduceContext interface
type booleanReduceContext struct {
	booleanPointAggregator
	booleanPointEmitter
}

// booleanBulkReduceContext uses composition to implement the reduceContext interface
type booleanBulkReduceContext struct {
	booleanPointBulkAggregator
	booleanPointEmitter
}

func determineReduceContextCreateFn(method string, kind reflect.Kind, rc pipeline.ReduceCreater) (fn createReduceContextFunc, err error) {
	switch kind {

	case reflect.Float64:
		switch {

		case rc.CreateFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatReducer()
				return &floatReduceContext{
					floatPointAggregator: floatPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateFloatBulkReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatBulkReducer()
				return &floatBulkReduceContext{
					floatPointBulkAggregator: floatPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateFloatIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatIntegerReducer()
				return &floatIntegerReduceContext{
					floatPointAggregator: floatPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateFloatBulkIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatBulkIntegerReducer()
				return &floatBulkIntegerReduceContext{
					floatPointBulkAggregator: floatPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateFloatStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatStringReducer()
				return &floatStringReduceContext{
					floatPointAggregator: floatPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateFloatBulkStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatBulkStringReducer()
				return &floatBulkStringReduceContext{
					floatPointBulkAggregator: floatPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateFloatBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatBooleanReducer()
				return &floatBooleanReduceContext{
					floatPointAggregator: floatPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateFloatBulkBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateFloatBulkBooleanReducer()
				return &floatBulkBooleanReduceContext{
					floatPointBulkAggregator: floatPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		default:
			err = fmt.Errorf("cannot apply %s to float64 field", method)
		}

	case reflect.Int64:
		switch {

		case rc.CreateIntegerFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerFloatReducer()
				return &integerFloatReduceContext{
					integerPointAggregator: integerPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateIntegerBulkFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerBulkFloatReducer()
				return &integerBulkFloatReduceContext{
					integerPointBulkAggregator: integerPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerReducer()
				return &integerReduceContext{
					integerPointAggregator: integerPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateIntegerBulkReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerBulkReducer()
				return &integerBulkReduceContext{
					integerPointBulkAggregator: integerPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateIntegerStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerStringReducer()
				return &integerStringReduceContext{
					integerPointAggregator: integerPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateIntegerBulkStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerBulkStringReducer()
				return &integerBulkStringReduceContext{
					integerPointBulkAggregator: integerPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateIntegerBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerBooleanReducer()
				return &integerBooleanReduceContext{
					integerPointAggregator: integerPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateIntegerBulkBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateIntegerBulkBooleanReducer()
				return &integerBulkBooleanReduceContext{
					integerPointBulkAggregator: integerPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		default:
			err = fmt.Errorf("cannot apply %s to int64 field", method)
		}

	case reflect.String:
		switch {

		case rc.CreateStringFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringFloatReducer()
				return &stringFloatReduceContext{
					stringPointAggregator: stringPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateStringBulkFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringBulkFloatReducer()
				return &stringBulkFloatReduceContext{
					stringPointBulkAggregator: stringPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateStringIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringIntegerReducer()
				return &stringIntegerReduceContext{
					stringPointAggregator: stringPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateStringBulkIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringBulkIntegerReducer()
				return &stringBulkIntegerReduceContext{
					stringPointBulkAggregator: stringPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringReducer()
				return &stringReduceContext{
					stringPointAggregator: stringPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateStringBulkReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringBulkReducer()
				return &stringBulkReduceContext{
					stringPointBulkAggregator: stringPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateStringBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringBooleanReducer()
				return &stringBooleanReduceContext{
					stringPointAggregator: stringPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateStringBulkBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateStringBulkBooleanReducer()
				return &stringBulkBooleanReduceContext{
					stringPointBulkAggregator: stringPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		default:
			err = fmt.Errorf("cannot apply %s to string field", method)
		}

	case reflect.Bool:
		switch {

		case rc.CreateBooleanFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanFloatReducer()
				return &booleanFloatReduceContext{
					booleanPointAggregator: booleanPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateBooleanBulkFloatReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanBulkFloatReducer()
				return &booleanBulkFloatReduceContext{
					booleanPointBulkAggregator: booleanPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					floatPointEmitter: floatPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateBooleanIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanIntegerReducer()
				return &booleanIntegerReduceContext{
					booleanPointAggregator: booleanPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateBooleanBulkIntegerReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanBulkIntegerReducer()
				return &booleanBulkIntegerReduceContext{
					booleanPointBulkAggregator: booleanPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					integerPointEmitter: integerPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateBooleanStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanStringReducer()
				return &booleanStringReduceContext{
					booleanPointAggregator: booleanPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateBooleanBulkStringReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanBulkStringReducer()
				return &booleanBulkStringReduceContext{
					booleanPointBulkAggregator: booleanPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					stringPointEmitter: stringPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		case rc.CreateBooleanReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanReducer()
				return &booleanReduceContext{
					booleanPointAggregator: booleanPointAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}
		case rc.CreateBooleanBulkReducer != nil:
			fn = func(c baseReduceContext) reduceContext {
				a, e := rc.CreateBooleanBulkReducer()
				return &booleanBulkReduceContext{
					booleanPointBulkAggregator: booleanPointBulkAggregator{
						field:            c.field,
						topBottomInfo:    rc.TopBottomCallInfo,
						isSimpleSelector: rc.IsSimpleSelector,
						aggregator:       a,
					},
					booleanPointEmitter: booleanPointEmitter{
						baseReduceContext: c,
						emitter:           e,
						isSimpleSelector:  rc.IsSimpleSelector,
					},
				}
			}

		default:
			err = fmt.Errorf("cannot apply %s to bool field", method)
		}

	default:
		err = fmt.Errorf("invalid field kind: %v", kind)
	}
	return
}
