// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package devicefarm provides a client for AWS Device Farm.
package devicefarm

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateDevicePool = "CreateDevicePool"

// CreateDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the CreateDevicePool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDevicePool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDevicePool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDevicePoolRequest method.
//    req, resp := client.CreateDevicePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool
func (c *DeviceFarm) CreateDevicePoolRequest(input *CreateDevicePoolInput) (req *request.Request, output *CreateDevicePoolOutput) {
	op := &request.Operation{
		Name:       opCreateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevicePoolInput{}
	}

	output = &CreateDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDevicePool API operation for AWS Device Farm.
//
// Creates a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateDevicePool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePool
func (c *DeviceFarm) CreateDevicePool(input *CreateDevicePoolInput) (*CreateDevicePoolOutput, error) {
	req, out := c.CreateDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject
func (c *DeviceFarm) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS Device Farm.
//
// Creates a new project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProject
func (c *DeviceFarm) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRemoteAccessSession = "CreateRemoteAccessSession"

// CreateRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the CreateRemoteAccessSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRemoteAccessSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRemoteAccessSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRemoteAccessSessionRequest method.
//    req, resp := client.CreateRemoteAccessSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession
func (c *DeviceFarm) CreateRemoteAccessSessionRequest(input *CreateRemoteAccessSessionInput) (req *request.Request, output *CreateRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opCreateRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRemoteAccessSessionInput{}
	}

	output = &CreateRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRemoteAccessSession API operation for AWS Device Farm.
//
// Specifies and starts a remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateRemoteAccessSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSession
func (c *DeviceFarm) CreateRemoteAccessSession(input *CreateRemoteAccessSessionInput) (*CreateRemoteAccessSessionOutput, error) {
	req, out := c.CreateRemoteAccessSessionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUpload = "CreateUpload"

// CreateUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUploadRequest method.
//    req, resp := client.CreateUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload
func (c *DeviceFarm) CreateUploadRequest(input *CreateUploadInput) (req *request.Request, output *CreateUploadOutput) {
	op := &request.Operation{
		Name:       opCreateUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUploadInput{}
	}

	output = &CreateUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUpload API operation for AWS Device Farm.
//
// Uploads an app or test scripts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation CreateUpload for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUpload
func (c *DeviceFarm) CreateUpload(input *CreateUploadInput) (*CreateUploadOutput, error) {
	req, out := c.CreateUploadRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDevicePool = "DeleteDevicePool"

// DeleteDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevicePool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDevicePool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDevicePool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDevicePoolRequest method.
//    req, resp := client.DeleteDevicePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool
func (c *DeviceFarm) DeleteDevicePoolRequest(input *DeleteDevicePoolInput) (req *request.Request, output *DeleteDevicePoolOutput) {
	op := &request.Operation{
		Name:       opDeleteDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevicePoolInput{}
	}

	output = &DeleteDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDevicePool API operation for AWS Device Farm.
//
// Deletes a device pool given the pool ARN. Does not allow deletion of curated
// pools owned by the system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteDevicePool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePool
func (c *DeviceFarm) DeleteDevicePool(input *DeleteDevicePoolInput) (*DeleteDevicePoolOutput, error) {
	req, out := c.DeleteDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject
func (c *DeviceFarm) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS Device Farm.
//
// Deletes an AWS Device Farm project, given the project ARN.
//
// Note Deleting this resource does not stop an in-progress run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProject
func (c *DeviceFarm) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRemoteAccessSession = "DeleteRemoteAccessSession"

// DeleteRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRemoteAccessSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRemoteAccessSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRemoteAccessSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRemoteAccessSessionRequest method.
//    req, resp := client.DeleteRemoteAccessSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession
func (c *DeviceFarm) DeleteRemoteAccessSessionRequest(input *DeleteRemoteAccessSessionInput) (req *request.Request, output *DeleteRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opDeleteRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemoteAccessSessionInput{}
	}

	output = &DeleteRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRemoteAccessSession API operation for AWS Device Farm.
//
// Deletes a completed remote access session and its results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteRemoteAccessSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession
func (c *DeviceFarm) DeleteRemoteAccessSession(input *DeleteRemoteAccessSessionInput) (*DeleteRemoteAccessSessionOutput, error) {
	req, out := c.DeleteRemoteAccessSessionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRun = "DeleteRun"

// DeleteRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRun operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRun for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRun method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRunRequest method.
//    req, resp := client.DeleteRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun
func (c *DeviceFarm) DeleteRunRequest(input *DeleteRunInput) (req *request.Request, output *DeleteRunOutput) {
	op := &request.Operation{
		Name:       opDeleteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRunInput{}
	}

	output = &DeleteRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRun API operation for AWS Device Farm.
//
// Deletes the run, given the run ARN.
//
// Note Deleting this resource does not stop an in-progress run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRun
func (c *DeviceFarm) DeleteRun(input *DeleteRunInput) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUpload = "DeleteUpload"

// DeleteUploadRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUploadRequest method.
//    req, resp := client.DeleteUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload
func (c *DeviceFarm) DeleteUploadRequest(input *DeleteUploadInput) (req *request.Request, output *DeleteUploadOutput) {
	op := &request.Operation{
		Name:       opDeleteUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUploadInput{}
	}

	output = &DeleteUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUpload API operation for AWS Device Farm.
//
// Deletes an upload given the upload ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation DeleteUpload for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUpload
func (c *DeviceFarm) DeleteUpload(input *DeleteUploadInput) (*DeleteUploadOutput, error) {
	req, out := c.DeleteUploadRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccountSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccountSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings
func (c *DeviceFarm) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Device Farm.
//
// Returns the number of unmetered iOS and/or unmetered Android devices that
// have been purchased by the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettings
func (c *DeviceFarm) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a "aws/request.Request" representing the
// client's request for the GetDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDeviceRequest method.
//    req, resp := client.GetDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice
func (c *DeviceFarm) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	output = &GetDeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevice API operation for AWS Device Farm.
//
// Gets information about a unique device type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevice
func (c *DeviceFarm) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevicePool = "GetDevicePool"

// GetDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDevicePool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDevicePool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDevicePoolRequest method.
//    req, resp := client.GetDevicePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool
func (c *DeviceFarm) GetDevicePoolRequest(input *GetDevicePoolInput) (req *request.Request, output *GetDevicePoolOutput) {
	op := &request.Operation{
		Name:       opGetDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolInput{}
	}

	output = &GetDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicePool API operation for AWS Device Farm.
//
// Gets information about a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevicePool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePool
func (c *DeviceFarm) GetDevicePool(input *GetDevicePoolInput) (*GetDevicePoolOutput, error) {
	req, out := c.GetDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevicePoolCompatibility = "GetDevicePoolCompatibility"

// GetDevicePoolCompatibilityRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePoolCompatibility operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDevicePoolCompatibility for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDevicePoolCompatibility method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDevicePoolCompatibilityRequest method.
//    req, resp := client.GetDevicePoolCompatibilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility
func (c *DeviceFarm) GetDevicePoolCompatibilityRequest(input *GetDevicePoolCompatibilityInput) (req *request.Request, output *GetDevicePoolCompatibilityOutput) {
	op := &request.Operation{
		Name:       opGetDevicePoolCompatibility,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolCompatibilityInput{}
	}

	output = &GetDevicePoolCompatibilityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicePoolCompatibility API operation for AWS Device Farm.
//
// Gets information about compatibility with a device pool.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetDevicePoolCompatibility for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibility
func (c *DeviceFarm) GetDevicePoolCompatibility(input *GetDevicePoolCompatibilityInput) (*GetDevicePoolCompatibilityOutput, error) {
	req, out := c.GetDevicePoolCompatibilityRequest(input)
	err := req.Send()
	return out, err
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob
func (c *DeviceFarm) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Device Farm.
//
// Gets information about a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJob
func (c *DeviceFarm) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	err := req.Send()
	return out, err
}

const opGetOfferingStatus = "GetOfferingStatus"

// GetOfferingStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetOfferingStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetOfferingStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetOfferingStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetOfferingStatusRequest method.
//    req, resp := client.GetOfferingStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus
func (c *DeviceFarm) GetOfferingStatusRequest(input *GetOfferingStatusInput) (req *request.Request, output *GetOfferingStatusOutput) {
	op := &request.Operation{
		Name:       opGetOfferingStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOfferingStatusInput{}
	}

	output = &GetOfferingStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOfferingStatus API operation for AWS Device Farm.
//
// Gets the current status and future status of all offerings purchased by an
// AWS account. The response indicates how many offerings are currently available
// and the offerings that will be available in the next period. The API returns
// a NotEligible error if the user is not permitted to invoke the operation.
// Please contact aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com)
// if you believe that you should be able to invoke this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetOfferingStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeNotEligibleException "NotEligibleException"
//   Exception gets thrown when a user is not eligible to perform the specified
//   transaction.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatus
func (c *DeviceFarm) GetOfferingStatus(input *GetOfferingStatusInput) (*GetOfferingStatusOutput, error) {
	req, out := c.GetOfferingStatusRequest(input)
	err := req.Send()
	return out, err
}

// GetOfferingStatusPages iterates over the pages of a GetOfferingStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOfferingStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetOfferingStatus operation.
//    pageNum := 0
//    err := client.GetOfferingStatusPages(params,
//        func(page *GetOfferingStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) GetOfferingStatusPages(input *GetOfferingStatusInput, fn func(p *GetOfferingStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetOfferingStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetOfferingStatusOutput), lastPage)
	})
}

const opGetProject = "GetProject"

// GetProjectRequest generates a "aws/request.Request" representing the
// client's request for the GetProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetProjectRequest method.
//    req, resp := client.GetProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject
func (c *DeviceFarm) GetProjectRequest(input *GetProjectInput) (req *request.Request, output *GetProjectOutput) {
	op := &request.Operation{
		Name:       opGetProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	output = &GetProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProject API operation for AWS Device Farm.
//
// Gets information about a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProject
func (c *DeviceFarm) GetProject(input *GetProjectInput) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	err := req.Send()
	return out, err
}

const opGetRemoteAccessSession = "GetRemoteAccessSession"

// GetRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetRemoteAccessSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRemoteAccessSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRemoteAccessSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRemoteAccessSessionRequest method.
//    req, resp := client.GetRemoteAccessSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession
func (c *DeviceFarm) GetRemoteAccessSessionRequest(input *GetRemoteAccessSessionInput) (req *request.Request, output *GetRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opGetRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRemoteAccessSessionInput{}
	}

	output = &GetRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRemoteAccessSession API operation for AWS Device Farm.
//
// Returns a link to a currently running remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetRemoteAccessSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSession
func (c *DeviceFarm) GetRemoteAccessSession(input *GetRemoteAccessSessionInput) (*GetRemoteAccessSessionOutput, error) {
	req, out := c.GetRemoteAccessSessionRequest(input)
	err := req.Send()
	return out, err
}

const opGetRun = "GetRun"

// GetRunRequest generates a "aws/request.Request" representing the
// client's request for the GetRun operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRun for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRun method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRunRequest method.
//    req, resp := client.GetRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun
func (c *DeviceFarm) GetRunRequest(input *GetRunInput) (req *request.Request, output *GetRunOutput) {
	op := &request.Operation{
		Name:       opGetRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRunInput{}
	}

	output = &GetRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRun API operation for AWS Device Farm.
//
// Gets information about a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRun
func (c *DeviceFarm) GetRun(input *GetRunInput) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	err := req.Send()
	return out, err
}

const opGetSuite = "GetSuite"

// GetSuiteRequest generates a "aws/request.Request" representing the
// client's request for the GetSuite operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSuite for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSuite method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSuiteRequest method.
//    req, resp := client.GetSuiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite
func (c *DeviceFarm) GetSuiteRequest(input *GetSuiteInput) (req *request.Request, output *GetSuiteOutput) {
	op := &request.Operation{
		Name:       opGetSuite,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSuiteInput{}
	}

	output = &GetSuiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuite API operation for AWS Device Farm.
//
// Gets information about a suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetSuite for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuite
func (c *DeviceFarm) GetSuite(input *GetSuiteInput) (*GetSuiteOutput, error) {
	req, out := c.GetSuiteRequest(input)
	err := req.Send()
	return out, err
}

const opGetTest = "GetTest"

// GetTestRequest generates a "aws/request.Request" representing the
// client's request for the GetTest operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTest for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTest method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTestRequest method.
//    req, resp := client.GetTestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest
func (c *DeviceFarm) GetTestRequest(input *GetTestInput) (req *request.Request, output *GetTestOutput) {
	op := &request.Operation{
		Name:       opGetTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestInput{}
	}

	output = &GetTestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTest API operation for AWS Device Farm.
//
// Gets information about a test.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetTest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTest
func (c *DeviceFarm) GetTest(input *GetTestInput) (*GetTestOutput, error) {
	req, out := c.GetTestRequest(input)
	err := req.Send()
	return out, err
}

const opGetUpload = "GetUpload"

// GetUploadRequest generates a "aws/request.Request" representing the
// client's request for the GetUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetUploadRequest method.
//    req, resp := client.GetUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload
func (c *DeviceFarm) GetUploadRequest(input *GetUploadInput) (req *request.Request, output *GetUploadOutput) {
	op := &request.Operation{
		Name:       opGetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUploadInput{}
	}

	output = &GetUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUpload API operation for AWS Device Farm.
//
// Gets information about an upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation GetUpload for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUpload
func (c *DeviceFarm) GetUpload(input *GetUploadInput) (*GetUploadOutput, error) {
	req, out := c.GetUploadRequest(input)
	err := req.Send()
	return out, err
}

const opInstallToRemoteAccessSession = "InstallToRemoteAccessSession"

// InstallToRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the InstallToRemoteAccessSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See InstallToRemoteAccessSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InstallToRemoteAccessSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InstallToRemoteAccessSessionRequest method.
//    req, resp := client.InstallToRemoteAccessSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession
func (c *DeviceFarm) InstallToRemoteAccessSessionRequest(input *InstallToRemoteAccessSessionInput) (req *request.Request, output *InstallToRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opInstallToRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InstallToRemoteAccessSessionInput{}
	}

	output = &InstallToRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InstallToRemoteAccessSession API operation for AWS Device Farm.
//
// Installs an application to the device in a remote access session. For Android
// applications, the file must be in .apk format. For iOS applications, the
// file must be in .ipa format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation InstallToRemoteAccessSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSession
func (c *DeviceFarm) InstallToRemoteAccessSession(input *InstallToRemoteAccessSessionInput) (*InstallToRemoteAccessSessionOutput, error) {
	req, out := c.InstallToRemoteAccessSessionRequest(input)
	err := req.Send()
	return out, err
}

const opListArtifacts = "ListArtifacts"

// ListArtifactsRequest generates a "aws/request.Request" representing the
// client's request for the ListArtifacts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListArtifacts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListArtifacts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListArtifactsRequest method.
//    req, resp := client.ListArtifactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts
func (c *DeviceFarm) ListArtifactsRequest(input *ListArtifactsInput) (req *request.Request, output *ListArtifactsOutput) {
	op := &request.Operation{
		Name:       opListArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArtifactsInput{}
	}

	output = &ListArtifactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListArtifacts API operation for AWS Device Farm.
//
// Gets information about artifacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListArtifacts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifacts
func (c *DeviceFarm) ListArtifacts(input *ListArtifactsInput) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	err := req.Send()
	return out, err
}

// ListArtifactsPages iterates over the pages of a ListArtifacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListArtifacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListArtifacts operation.
//    pageNum := 0
//    err := client.ListArtifactsPages(params,
//        func(page *ListArtifactsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListArtifactsPages(input *ListArtifactsInput, fn func(p *ListArtifactsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListArtifactsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListArtifactsOutput), lastPage)
	})
}

const opListDevicePools = "ListDevicePools"

// ListDevicePoolsRequest generates a "aws/request.Request" representing the
// client's request for the ListDevicePools operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDevicePools for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDevicePools method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDevicePoolsRequest method.
//    req, resp := client.ListDevicePoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools
func (c *DeviceFarm) ListDevicePoolsRequest(input *ListDevicePoolsInput) (req *request.Request, output *ListDevicePoolsOutput) {
	op := &request.Operation{
		Name:       opListDevicePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicePoolsInput{}
	}

	output = &ListDevicePoolsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevicePools API operation for AWS Device Farm.
//
// Gets information about device pools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListDevicePools for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePools
func (c *DeviceFarm) ListDevicePools(input *ListDevicePoolsInput) (*ListDevicePoolsOutput, error) {
	req, out := c.ListDevicePoolsRequest(input)
	err := req.Send()
	return out, err
}

// ListDevicePoolsPages iterates over the pages of a ListDevicePools operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevicePools method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevicePools operation.
//    pageNum := 0
//    err := client.ListDevicePoolsPages(params,
//        func(page *ListDevicePoolsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListDevicePoolsPages(input *ListDevicePoolsInput, fn func(p *ListDevicePoolsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDevicePoolsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDevicePoolsOutput), lastPage)
	})
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListDevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDevicesRequest method.
//    req, resp := client.ListDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices
func (c *DeviceFarm) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	output = &ListDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDevices API operation for AWS Device Farm.
//
// Gets information about unique device types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListDevices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevices
func (c *DeviceFarm) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	err := req.Send()
	return out, err
}

// ListDevicesPages iterates over the pages of a ListDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDevices operation.
//    pageNum := 0
//    err := client.ListDevicesPages(params,
//        func(page *ListDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListDevicesPages(input *ListDevicesInput, fn func(p *ListDevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDevicesOutput), lastPage)
	})
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListJobs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListJobs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs
func (c *DeviceFarm) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for AWS Device Farm.
//
// Gets information about jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobs
func (c *DeviceFarm) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	err := req.Send()
	return out, err
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListJobsPages(input *ListJobsInput, fn func(p *ListJobsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsOutput), lastPage)
	})
}

const opListOfferingTransactions = "ListOfferingTransactions"

// ListOfferingTransactionsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferingTransactions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOfferingTransactions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOfferingTransactions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOfferingTransactionsRequest method.
//    req, resp := client.ListOfferingTransactionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions
func (c *DeviceFarm) ListOfferingTransactionsRequest(input *ListOfferingTransactionsInput) (req *request.Request, output *ListOfferingTransactionsOutput) {
	op := &request.Operation{
		Name:       opListOfferingTransactions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingTransactionsInput{}
	}

	output = &ListOfferingTransactionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferingTransactions API operation for AWS Device Farm.
//
// Returns a list of all historical purchases, renewals, and system renewal
// transactions for an AWS account. The list is paginated and ordered by a descending
// timestamp (most recent transactions are first). The API returns a NotEligible
// error if the user is not permitted to invoke the operation. Please contact
// aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com)
// if you believe that you should be able to invoke this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListOfferingTransactions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeNotEligibleException "NotEligibleException"
//   Exception gets thrown when a user is not eligible to perform the specified
//   transaction.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactions
func (c *DeviceFarm) ListOfferingTransactions(input *ListOfferingTransactionsInput) (*ListOfferingTransactionsOutput, error) {
	req, out := c.ListOfferingTransactionsRequest(input)
	err := req.Send()
	return out, err
}

// ListOfferingTransactionsPages iterates over the pages of a ListOfferingTransactions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferingTransactions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOfferingTransactions operation.
//    pageNum := 0
//    err := client.ListOfferingTransactionsPages(params,
//        func(page *ListOfferingTransactionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListOfferingTransactionsPages(input *ListOfferingTransactionsInput, fn func(p *ListOfferingTransactionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListOfferingTransactionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListOfferingTransactionsOutput), lastPage)
	})
}

const opListOfferings = "ListOfferings"

// ListOfferingsRequest generates a "aws/request.Request" representing the
// client's request for the ListOfferings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOfferings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOfferings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOfferingsRequest method.
//    req, resp := client.ListOfferingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings
func (c *DeviceFarm) ListOfferingsRequest(input *ListOfferingsInput) (req *request.Request, output *ListOfferingsOutput) {
	op := &request.Operation{
		Name:       opListOfferings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOfferingsInput{}
	}

	output = &ListOfferingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOfferings API operation for AWS Device Farm.
//
// Returns a list of products or offerings that the user can manage through
// the API. Each offering record indicates the recurring price per unit and
// the frequency for that offering. The API returns a NotEligible error if the
// user is not permitted to invoke the operation. Please contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com) if you believe that you should
// be able to invoke this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListOfferings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeNotEligibleException "NotEligibleException"
//   Exception gets thrown when a user is not eligible to perform the specified
//   transaction.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferings
func (c *DeviceFarm) ListOfferings(input *ListOfferingsInput) (*ListOfferingsOutput, error) {
	req, out := c.ListOfferingsRequest(input)
	err := req.Send()
	return out, err
}

// ListOfferingsPages iterates over the pages of a ListOfferings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOfferings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOfferings operation.
//    pageNum := 0
//    err := client.ListOfferingsPages(params,
//        func(page *ListOfferingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListOfferingsPages(input *ListOfferingsInput, fn func(p *ListOfferingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListOfferingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListOfferingsOutput), lastPage)
	})
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListProjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListProjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects
func (c *DeviceFarm) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS Device Farm.
//
// Gets information about projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjects
func (c *DeviceFarm) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	err := req.Send()
	return out, err
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListProjects operation.
//    pageNum := 0
//    err := client.ListProjectsPages(params,
//        func(page *ListProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListProjectsPages(input *ListProjectsInput, fn func(p *ListProjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListProjectsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListProjectsOutput), lastPage)
	})
}

const opListRemoteAccessSessions = "ListRemoteAccessSessions"

// ListRemoteAccessSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRemoteAccessSessions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRemoteAccessSessions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRemoteAccessSessions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRemoteAccessSessionsRequest method.
//    req, resp := client.ListRemoteAccessSessionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions
func (c *DeviceFarm) ListRemoteAccessSessionsRequest(input *ListRemoteAccessSessionsInput) (req *request.Request, output *ListRemoteAccessSessionsOutput) {
	op := &request.Operation{
		Name:       opListRemoteAccessSessions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRemoteAccessSessionsInput{}
	}

	output = &ListRemoteAccessSessionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRemoteAccessSessions API operation for AWS Device Farm.
//
// Returns a list of all currently running remote access sessions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListRemoteAccessSessions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessions
func (c *DeviceFarm) ListRemoteAccessSessions(input *ListRemoteAccessSessionsInput) (*ListRemoteAccessSessionsOutput, error) {
	req, out := c.ListRemoteAccessSessionsRequest(input)
	err := req.Send()
	return out, err
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuns operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRuns for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRuns method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRunsRequest method.
//    req, resp := client.ListRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns
func (c *DeviceFarm) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	output = &ListRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuns API operation for AWS Device Farm.
//
// Gets information about runs, given an AWS Device Farm project ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListRuns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRuns
func (c *DeviceFarm) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	err := req.Send()
	return out, err
}

// ListRunsPages iterates over the pages of a ListRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRuns operation.
//    pageNum := 0
//    err := client.ListRunsPages(params,
//        func(page *ListRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListRunsPages(input *ListRunsInput, fn func(p *ListRunsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRunsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRunsOutput), lastPage)
	})
}

const opListSamples = "ListSamples"

// ListSamplesRequest generates a "aws/request.Request" representing the
// client's request for the ListSamples operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSamples for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSamples method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSamplesRequest method.
//    req, resp := client.ListSamplesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples
func (c *DeviceFarm) ListSamplesRequest(input *ListSamplesInput) (req *request.Request, output *ListSamplesOutput) {
	op := &request.Operation{
		Name:       opListSamples,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSamplesInput{}
	}

	output = &ListSamplesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSamples API operation for AWS Device Farm.
//
// Gets information about samples, given an AWS Device Farm project ARN
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListSamples for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamples
func (c *DeviceFarm) ListSamples(input *ListSamplesInput) (*ListSamplesOutput, error) {
	req, out := c.ListSamplesRequest(input)
	err := req.Send()
	return out, err
}

// ListSamplesPages iterates over the pages of a ListSamples operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSamples method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSamples operation.
//    pageNum := 0
//    err := client.ListSamplesPages(params,
//        func(page *ListSamplesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListSamplesPages(input *ListSamplesInput, fn func(p *ListSamplesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSamplesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSamplesOutput), lastPage)
	})
}

const opListSuites = "ListSuites"

// ListSuitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSuites operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSuites for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSuites method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSuitesRequest method.
//    req, resp := client.ListSuitesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites
func (c *DeviceFarm) ListSuitesRequest(input *ListSuitesInput) (req *request.Request, output *ListSuitesOutput) {
	op := &request.Operation{
		Name:       opListSuites,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuitesInput{}
	}

	output = &ListSuitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuites API operation for AWS Device Farm.
//
// Gets information about suites.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListSuites for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuites
func (c *DeviceFarm) ListSuites(input *ListSuitesInput) (*ListSuitesOutput, error) {
	req, out := c.ListSuitesRequest(input)
	err := req.Send()
	return out, err
}

// ListSuitesPages iterates over the pages of a ListSuites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSuites operation.
//    pageNum := 0
//    err := client.ListSuitesPages(params,
//        func(page *ListSuitesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListSuitesPages(input *ListSuitesInput, fn func(p *ListSuitesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSuitesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSuitesOutput), lastPage)
	})
}

const opListTests = "ListTests"

// ListTestsRequest generates a "aws/request.Request" representing the
// client's request for the ListTests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTestsRequest method.
//    req, resp := client.ListTestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests
func (c *DeviceFarm) ListTestsRequest(input *ListTestsInput) (req *request.Request, output *ListTestsOutput) {
	op := &request.Operation{
		Name:       opListTests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestsInput{}
	}

	output = &ListTestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTests API operation for AWS Device Farm.
//
// Gets information about tests.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListTests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTests
func (c *DeviceFarm) ListTests(input *ListTestsInput) (*ListTestsOutput, error) {
	req, out := c.ListTestsRequest(input)
	err := req.Send()
	return out, err
}

// ListTestsPages iterates over the pages of a ListTests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTests operation.
//    pageNum := 0
//    err := client.ListTestsPages(params,
//        func(page *ListTestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListTestsPages(input *ListTestsInput, fn func(p *ListTestsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListTestsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListTestsOutput), lastPage)
	})
}

const opListUniqueProblems = "ListUniqueProblems"

// ListUniqueProblemsRequest generates a "aws/request.Request" representing the
// client's request for the ListUniqueProblems operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUniqueProblems for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUniqueProblems method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUniqueProblemsRequest method.
//    req, resp := client.ListUniqueProblemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems
func (c *DeviceFarm) ListUniqueProblemsRequest(input *ListUniqueProblemsInput) (req *request.Request, output *ListUniqueProblemsOutput) {
	op := &request.Operation{
		Name:       opListUniqueProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUniqueProblemsInput{}
	}

	output = &ListUniqueProblemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUniqueProblems API operation for AWS Device Farm.
//
// Gets information about unique problems.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListUniqueProblems for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblems
func (c *DeviceFarm) ListUniqueProblems(input *ListUniqueProblemsInput) (*ListUniqueProblemsOutput, error) {
	req, out := c.ListUniqueProblemsRequest(input)
	err := req.Send()
	return out, err
}

// ListUniqueProblemsPages iterates over the pages of a ListUniqueProblems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUniqueProblems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUniqueProblems operation.
//    pageNum := 0
//    err := client.ListUniqueProblemsPages(params,
//        func(page *ListUniqueProblemsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListUniqueProblemsPages(input *ListUniqueProblemsInput, fn func(p *ListUniqueProblemsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUniqueProblemsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUniqueProblemsOutput), lastPage)
	})
}

const opListUploads = "ListUploads"

// ListUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListUploads operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUploads for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUploads method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUploadsRequest method.
//    req, resp := client.ListUploadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads
func (c *DeviceFarm) ListUploadsRequest(input *ListUploadsInput) (req *request.Request, output *ListUploadsOutput) {
	op := &request.Operation{
		Name:       opListUploads,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUploadsInput{}
	}

	output = &ListUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUploads API operation for AWS Device Farm.
//
// Gets information about uploads, given an AWS Device Farm project ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ListUploads for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploads
func (c *DeviceFarm) ListUploads(input *ListUploadsInput) (*ListUploadsOutput, error) {
	req, out := c.ListUploadsRequest(input)
	err := req.Send()
	return out, err
}

// ListUploadsPages iterates over the pages of a ListUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUploads operation.
//    pageNum := 0
//    err := client.ListUploadsPages(params,
//        func(page *ListUploadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DeviceFarm) ListUploadsPages(input *ListUploadsInput, fn func(p *ListUploadsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUploadsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUploadsOutput), lastPage)
	})
}

const opPurchaseOffering = "PurchaseOffering"

// PurchaseOfferingRequest generates a "aws/request.Request" representing the
// client's request for the PurchaseOffering operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PurchaseOffering for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PurchaseOffering method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PurchaseOfferingRequest method.
//    req, resp := client.PurchaseOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering
func (c *DeviceFarm) PurchaseOfferingRequest(input *PurchaseOfferingInput) (req *request.Request, output *PurchaseOfferingOutput) {
	op := &request.Operation{
		Name:       opPurchaseOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PurchaseOfferingInput{}
	}

	output = &PurchaseOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PurchaseOffering API operation for AWS Device Farm.
//
// Immediately purchases offerings for an AWS account. Offerings renew with
// the latest total purchased quantity for an offering, unless the renewal was
// overridden. The API returns a NotEligible error if the user is not permitted
// to invoke the operation. Please contact aws-devicefarm-support@amazon.com
// (mailto:aws-devicefarm-support@amazon.com) if you believe that you should
// be able to invoke this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation PurchaseOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeNotEligibleException "NotEligibleException"
//   Exception gets thrown when a user is not eligible to perform the specified
//   transaction.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOffering
func (c *DeviceFarm) PurchaseOffering(input *PurchaseOfferingInput) (*PurchaseOfferingOutput, error) {
	req, out := c.PurchaseOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opRenewOffering = "RenewOffering"

// RenewOfferingRequest generates a "aws/request.Request" representing the
// client's request for the RenewOffering operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RenewOffering for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RenewOffering method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RenewOfferingRequest method.
//    req, resp := client.RenewOfferingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering
func (c *DeviceFarm) RenewOfferingRequest(input *RenewOfferingInput) (req *request.Request, output *RenewOfferingOutput) {
	op := &request.Operation{
		Name:       opRenewOffering,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewOfferingInput{}
	}

	output = &RenewOfferingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RenewOffering API operation for AWS Device Farm.
//
// Explicitly sets the quantity of devices to renew for an offering, starting
// from the effectiveDate of the next period. The API returns a NotEligible
// error if the user is not permitted to invoke the operation. Please contact
// aws-devicefarm-support@amazon.com (mailto:aws-devicefarm-support@amazon.com)
// if you believe that you should be able to invoke this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation RenewOffering for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeNotEligibleException "NotEligibleException"
//   Exception gets thrown when a user is not eligible to perform the specified
//   transaction.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOffering
func (c *DeviceFarm) RenewOffering(input *RenewOfferingInput) (*RenewOfferingOutput, error) {
	req, out := c.RenewOfferingRequest(input)
	err := req.Send()
	return out, err
}

const opScheduleRun = "ScheduleRun"

// ScheduleRunRequest generates a "aws/request.Request" representing the
// client's request for the ScheduleRun operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ScheduleRun for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ScheduleRun method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ScheduleRunRequest method.
//    req, resp := client.ScheduleRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun
func (c *DeviceFarm) ScheduleRunRequest(input *ScheduleRunInput) (req *request.Request, output *ScheduleRunOutput) {
	op := &request.Operation{
		Name:       opScheduleRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleRunInput{}
	}

	output = &ScheduleRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ScheduleRun API operation for AWS Device Farm.
//
// Schedules a run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation ScheduleRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeIdempotencyException "IdempotencyException"
//   An entity with the same name already exists.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRun
func (c *DeviceFarm) ScheduleRun(input *ScheduleRunInput) (*ScheduleRunOutput, error) {
	req, out := c.ScheduleRunRequest(input)
	err := req.Send()
	return out, err
}

const opStopRemoteAccessSession = "StopRemoteAccessSession"

// StopRemoteAccessSessionRequest generates a "aws/request.Request" representing the
// client's request for the StopRemoteAccessSession operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopRemoteAccessSession for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopRemoteAccessSession method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopRemoteAccessSessionRequest method.
//    req, resp := client.StopRemoteAccessSessionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession
func (c *DeviceFarm) StopRemoteAccessSessionRequest(input *StopRemoteAccessSessionInput) (req *request.Request, output *StopRemoteAccessSessionOutput) {
	op := &request.Operation{
		Name:       opStopRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRemoteAccessSessionInput{}
	}

	output = &StopRemoteAccessSessionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRemoteAccessSession API operation for AWS Device Farm.
//
// Ends a specified remote access session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation StopRemoteAccessSession for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSession
func (c *DeviceFarm) StopRemoteAccessSession(input *StopRemoteAccessSessionInput) (*StopRemoteAccessSessionOutput, error) {
	req, out := c.StopRemoteAccessSessionRequest(input)
	err := req.Send()
	return out, err
}

const opStopRun = "StopRun"

// StopRunRequest generates a "aws/request.Request" representing the
// client's request for the StopRun operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopRun for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopRun method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopRunRequest method.
//    req, resp := client.StopRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun
func (c *DeviceFarm) StopRunRequest(input *StopRunInput) (req *request.Request, output *StopRunOutput) {
	op := &request.Operation{
		Name:       opStopRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRunInput{}
	}

	output = &StopRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRun API operation for AWS Device Farm.
//
// Initiates a stop request for the current test run. AWS Device Farm will immediately
// stop the run on devices where tests have not started executing, and you will
// not be billed for these devices. On devices where tests have started executing,
// Setup Suite and Teardown Suite tests will run to completion before stopping
// execution on those devices. You will be billed for Setup, Teardown, and any
// tests that were in progress or already completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation StopRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRun
func (c *DeviceFarm) StopRun(input *StopRunInput) (*StopRunOutput, error) {
	req, out := c.StopRunRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDevicePool = "UpdateDevicePool"

// UpdateDevicePoolRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevicePool operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDevicePool for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDevicePool method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDevicePoolRequest method.
//    req, resp := client.UpdateDevicePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool
func (c *DeviceFarm) UpdateDevicePoolRequest(input *UpdateDevicePoolInput) (req *request.Request, output *UpdateDevicePoolOutput) {
	op := &request.Operation{
		Name:       opUpdateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevicePoolInput{}
	}

	output = &UpdateDevicePoolOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDevicePool API operation for AWS Device Farm.
//
// Modifies the name, description, and rules in a device pool given the attributes
// and the pool ARN. Rule updates are all-or-nothing, meaning they can only
// be updated as a whole (or not at all).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateDevicePool for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePool
func (c *DeviceFarm) UpdateDevicePool(input *UpdateDevicePoolInput) (*UpdateDevicePoolOutput, error) {
	req, out := c.UpdateDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject
func (c *DeviceFarm) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS Device Farm.
//
// Modifies the specified project name, given the project ARN and a new name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Device Farm's
// API operation UpdateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeArgumentException "ArgumentException"
//   An invalid argument was specified.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The specified entity was not found.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A limit was exceeded.
//
//   * ErrCodeServiceAccountException "ServiceAccountException"
//   There was a problem with the service account.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProject
func (c *DeviceFarm) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	err := req.Send()
	return out, err
}

// A container for account-level settings within AWS Device Farm.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/AccountSettings
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The AWS account number specified in the AccountSettings container.
	AwsAccountNumber *string `locationName:"awsAccountNumber" min:"2" type:"string"`

	// Returns the unmetered devices you have purchased or want to purchase.
	UnmeteredDevices map[string]*int64 `locationName:"unmeteredDevices" type:"map"`

	// Returns the unmetered remote access devices you have purchased or want to
	// purchase.
	UnmeteredRemoteAccessDevices map[string]*int64 `locationName:"unmeteredRemoteAccessDevices" type:"map"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetAwsAccountNumber sets the AwsAccountNumber field's value.
func (s *AccountSettings) SetAwsAccountNumber(v string) *AccountSettings {
	s.AwsAccountNumber = &v
	return s
}

// SetUnmeteredDevices sets the UnmeteredDevices field's value.
func (s *AccountSettings) SetUnmeteredDevices(v map[string]*int64) *AccountSettings {
	s.UnmeteredDevices = v
	return s
}

// SetUnmeteredRemoteAccessDevices sets the UnmeteredRemoteAccessDevices field's value.
func (s *AccountSettings) SetUnmeteredRemoteAccessDevices(v map[string]*int64) *AccountSettings {
	s.UnmeteredRemoteAccessDevices = v
	return s
}

// Represents the output of a test. Examples of artifacts include logs and screenshots.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Artifact
type Artifact struct {
	_ struct{} `type:"structure"`

	// The artifact's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The artifact's file extension.
	Extension *string `locationName:"extension" type:"string"`

	// The artifact's name.
	Name *string `locationName:"name" type:"string"`

	// The artifact's type.
	//
	// Allowed values include the following:
	//
	//    * UNKNOWN: An unknown type.
	//
	//    * SCREENSHOT: The screenshot type.
	//
	//    * DEVICE_LOG: The device log type.
	//
	//    * MESSAGE_LOG: The message log type.
	//
	//    * RESULT_LOG: The result log type.
	//
	//    * SERVICE_LOG: The service log type.
	//
	//    * WEBKIT_LOG: The web kit log type.
	//
	//    * INSTRUMENTATION_OUTPUT: The instrumentation type.
	//
	//    * EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by
	//    an Android fuzz test.
	//
	//    * CALABASH_JSON_OUTPUT: The Calabash JSON output type.
	//
	//    * CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
	//
	//    * CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
	//
	//    * CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
	//
	//    * AUTOMATION_OUTPUT: The automation output type.
	//
	//    * APPIUM_SERVER_OUTPUT: The Appium server output type.
	//
	//    * APPIUM_JAVA_OUTPUT: The Appium Java output type.
	//
	//    * APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
	//
	//    * APPIUM_PYTHON_OUTPUT: The Appium Python output type.
	//
	//    * APPIUM_PYTHON_XML_OUTPUT: The Appium Python XML output type.
	//
	//    * EXPLORER_EVENT_LOG: The Explorer event log output type.
	//
	//    * EXPLORER_SUMMARY_LOG: The Explorer summary log output type.
	//
	//    * APPLICATION_CRASH_REPORT: The application crash report output type.
	//
	//    * XCTEST_LOG: The XCode test output type.
	Type *string `locationName:"type" type:"string" enum:"ArtifactType"`

	// The pre-signed Amazon S3 URL that can be used with a corresponding GET request
	// to download the artifact's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Artifact) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Artifact) SetArn(v string) *Artifact {
	s.Arn = &v
	return s
}

// SetExtension sets the Extension field's value.
func (s *Artifact) SetExtension(v string) *Artifact {
	s.Extension = &v
	return s
}

// SetName sets the Name field's value.
func (s *Artifact) SetName(v string) *Artifact {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Artifact) SetType(v string) *Artifact {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Artifact) SetUrl(v string) *Artifact {
	s.Url = &v
	return s
}

// Represents the amount of CPU that an app is using on a physical device.
//
// Note that this does not represent system-wide CPU usage.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CPU
type CPU struct {
	_ struct{} `type:"structure"`

	// The CPU's architecture, for example x86 or ARM.
	Architecture *string `locationName:"architecture" type:"string"`

	// The clock speed of the device's CPU, expressed in hertz (Hz). For example,
	// a 1.2 GHz CPU is expressed as 1200000000.
	Clock *float64 `locationName:"clock" type:"double"`

	// The CPU's frequency.
	Frequency *string `locationName:"frequency" type:"string"`
}

// String returns the string representation
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CPU) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *CPU) SetArchitecture(v string) *CPU {
	s.Architecture = &v
	return s
}

// SetClock sets the Clock field's value.
func (s *CPU) SetClock(v float64) *CPU {
	s.Clock = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *CPU) SetFrequency(v string) *CPU {
	s.Frequency = &v
	return s
}

// Represents entity counters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Counters
type Counters struct {
	_ struct{} `type:"structure"`

	// The number of errored entities.
	Errored *int64 `locationName:"errored" type:"integer"`

	// The number of failed entities.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of passed entities.
	Passed *int64 `locationName:"passed" type:"integer"`

	// The number of skipped entities.
	Skipped *int64 `locationName:"skipped" type:"integer"`

	// The number of stopped entities.
	Stopped *int64 `locationName:"stopped" type:"integer"`

	// The total number of entities.
	Total *int64 `locationName:"total" type:"integer"`

	// The number of warned entities.
	Warned *int64 `locationName:"warned" type:"integer"`
}

// String returns the string representation
func (s Counters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Counters) GoString() string {
	return s.String()
}

// SetErrored sets the Errored field's value.
func (s *Counters) SetErrored(v int64) *Counters {
	s.Errored = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *Counters) SetFailed(v int64) *Counters {
	s.Failed = &v
	return s
}

// SetPassed sets the Passed field's value.
func (s *Counters) SetPassed(v int64) *Counters {
	s.Passed = &v
	return s
}

// SetSkipped sets the Skipped field's value.
func (s *Counters) SetSkipped(v int64) *Counters {
	s.Skipped = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Counters) SetStopped(v int64) *Counters {
	s.Stopped = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *Counters) SetTotal(v int64) *Counters {
	s.Total = &v
	return s
}

// SetWarned sets the Warned field's value.
func (s *Counters) SetWarned(v int64) *Counters {
	s.Warned = &v
	return s
}

// Represents a request to the create device pool operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePoolRequest
type CreateDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The device pool's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the device pool.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The device pool's rules.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDevicePoolInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDevicePoolInput) SetDescription(v string) *CreateDevicePoolInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDevicePoolInput) SetName(v string) *CreateDevicePoolInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateDevicePoolInput) SetProjectArn(v string) *CreateDevicePoolInput {
	s.ProjectArn = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateDevicePoolInput) SetRules(v []*Rule) *CreateDevicePoolInput {
	s.Rules = v
	return s
}

// Represents the result of a create device pool request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateDevicePoolResult
type CreateDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// The newly created device pool.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation
func (s CreateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *CreateDevicePoolOutput) SetDevicePool(v *DevicePool) *CreateDevicePoolOutput {
	s.DevicePool = v
	return s
}

// Represents a request to the create project operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProjectRequest
type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// The project's name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// Represents the result of a create project request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateProjectResult
type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The newly created project.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *CreateProjectOutput) SetProject(v *Project) *CreateProjectOutput {
	s.Project = v
	return s
}

// Creates the configuration settings for a remote access session, including
// the device model and type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSessionConfiguration
type CreateRemoteAccessSessionConfiguration struct {
	_ struct{} `type:"structure"`

	// Returns the billing method for purposes of configuring a remote access session.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`
}

// String returns the string representation
func (s CreateRemoteAccessSessionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRemoteAccessSessionConfiguration) GoString() string {
	return s.String()
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *CreateRemoteAccessSessionConfiguration) SetBillingMethod(v string) *CreateRemoteAccessSessionConfiguration {
	s.BillingMethod = &v
	return s
}

// Creates and submits a request to start a remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSessionRequest
type CreateRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The configuration information for the remote access session request.
	Configuration *CreateRemoteAccessSessionConfiguration `locationName:"configuration" type:"structure"`

	// The Amazon Resource Name (ARN) of the device for which you want to create
	// a remote access session.
	//
	// DeviceArn is a required field
	DeviceArn *string `locationName:"deviceArn" min:"32" type:"string" required:"true"`

	// The name of the remote access session that you wish to create.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (ARN) of the project for which you want to create
	// a remote access session.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRemoteAccessSessionInput"}
	if s.DeviceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceArn"))
	}
	if s.DeviceArn != nil && len(*s.DeviceArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceArn", 32))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateRemoteAccessSessionInput) SetConfiguration(v *CreateRemoteAccessSessionConfiguration) *CreateRemoteAccessSessionInput {
	s.Configuration = v
	return s
}

// SetDeviceArn sets the DeviceArn field's value.
func (s *CreateRemoteAccessSessionInput) SetDeviceArn(v string) *CreateRemoteAccessSessionInput {
	s.DeviceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRemoteAccessSessionInput) SetName(v string) *CreateRemoteAccessSessionInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateRemoteAccessSessionInput) SetProjectArn(v string) *CreateRemoteAccessSessionInput {
	s.ProjectArn = &v
	return s
}

// Represents the server response from a request to create a remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateRemoteAccessSessionResult
type CreateRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container that describes the remote access session when the request to
	// create a remote access session is sent.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation
func (s CreateRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *CreateRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *CreateRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

// Represents a request to the create upload operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUploadRequest
type CreateUploadInput struct {
	_ struct{} `type:"structure"`

	// The upload's content type (for example, "application/octet-stream").
	ContentType *string `locationName:"contentType" type:"string"`

	// The upload's file name. The name should not contain the '/' character. If
	// uploading an iOS app, the file name needs to end with the .ipa extension.
	// If uploading an Android app, the file name needs to end with the .apk extension.
	// For all others, the file name must end with the .zip file extension.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the upload.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The upload's upload type.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP: An Android upload.
	//
	//    * IOS_APP: An iOS upload.
	//
	//    * WEB_APP: A web appliction upload.
	//
	//    * EXTERNAL_DATA: An external data upload.
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package
	//    upload.
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package
	//    upload.
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package
	//    upload.
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
	//
	//    * CALABASH_TEST_PACKAGE: A Calabash test package upload.
	//
	//    * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
	//
	//    * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
	//
	//    * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
	//
	//    * XCTEST_TEST_PACKAGE: An XCode test package upload.
	//
	//    * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
	//
	// Note If you call CreateUpload with WEB_APP specified, AWS Device Farm throws
	// an ArgumentException error.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"UploadType"`
}

// String returns the string representation
func (s CreateUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUploadInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *CreateUploadInput) SetContentType(v string) *CreateUploadInput {
	s.ContentType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUploadInput) SetName(v string) *CreateUploadInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateUploadInput) SetProjectArn(v string) *CreateUploadInput {
	s.ProjectArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateUploadInput) SetType(v string) *CreateUploadInput {
	s.Type = &v
	return s
}

// Represents the result of a create upload request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateUploadResult
type CreateUploadOutput struct {
	_ struct{} `type:"structure"`

	// The newly created upload.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation
func (s CreateUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUploadOutput) GoString() string {
	return s.String()
}

// SetUpload sets the Upload field's value.
func (s *CreateUploadOutput) SetUpload(v *Upload) *CreateUploadOutput {
	s.Upload = v
	return s
}

// Represents a request to the delete device pool operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePoolRequest
type DeleteDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm device pool
	// you wish to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteDevicePoolInput) SetArn(v string) *DeleteDevicePoolInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete device pool request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteDevicePoolResult
type DeleteDevicePoolOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDevicePoolOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete project operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProjectRequest
type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm project you
	// wish to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteProjectInput) SetArn(v string) *DeleteProjectInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete project request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteProjectResult
type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// Represents the request to delete the specified remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSessionRequest
type DeleteRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the sesssion for which you want to delete
	// remote access.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteRemoteAccessSessionInput) SetArn(v string) *DeleteRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// The response from the server when a request is made to delete the remote
// access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSessionResult
type DeleteRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete run operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRunRequest
type DeleteRunInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the run you wish to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteRunInput) SetArn(v string) *DeleteRunInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete run request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRunResult
type DeleteRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRunOutput) GoString() string {
	return s.String()
}

// Represents a request to the delete upload operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUploadRequest
type DeleteUploadInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm upload you wish
	// to delete.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUploadInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteUploadInput) SetArn(v string) *DeleteUploadInput {
	s.Arn = &v
	return s
}

// Represents the result of a delete upload request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteUploadResult
type DeleteUploadOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUploadOutput) GoString() string {
	return s.String()
}

// Represents a device type that an app is tested against.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Device
type Device struct {
	_ struct{} `type:"structure"`

	// The device's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device's carrier.
	Carrier *string `locationName:"carrier" type:"string"`

	// Information about the device's CPU.
	Cpu *CPU `locationName:"cpu" type:"structure"`

	// The name of the fleet to which this device belongs.
	FleetName *string `locationName:"fleetName" type:"string"`

	// The type of fleet to which this device belongs. Possible values for fleet
	// type are PRIVATE and PUBLIC.
	FleetType *string `locationName:"fleetType" type:"string"`

	// The device's form factor.
	//
	// Allowed values include:
	//
	//    * PHONE: The phone form factor.
	//
	//    * TABLET: The tablet form factor.
	FormFactor *string `locationName:"formFactor" type:"string" enum:"DeviceFormFactor"`

	// The device's heap size, expressed in bytes.
	HeapSize *int64 `locationName:"heapSize" type:"long"`

	// The device's image name.
	Image *string `locationName:"image" type:"string"`

	// The device's manufacturer name.
	Manufacturer *string `locationName:"manufacturer" type:"string"`

	// The device's total memory size, expressed in bytes.
	Memory *int64 `locationName:"memory" type:"long"`

	// The device's model name.
	Model *string `locationName:"model" type:"string"`

	// The device's display name.
	Name *string `locationName:"name" type:"string"`

	// The device's operating system type.
	Os *string `locationName:"os" type:"string"`

	// The device's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID: The Android platform.
	//
	//    * IOS: The iOS platform.
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// The device's radio.
	Radio *string `locationName:"radio" type:"string"`

	// Specifies whether remote access has been enabled for the specified device.
	RemoteAccessEnabled *bool `locationName:"remoteAccessEnabled" type:"boolean"`

	// Represents the screen resolution of a device in height and width, expressed
	// in pixels.
	Resolution *Resolution `locationName:"resolution" type:"structure"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Device) SetArn(v string) *Device {
	s.Arn = &v
	return s
}

// SetCarrier sets the Carrier field's value.
func (s *Device) SetCarrier(v string) *Device {
	s.Carrier = &v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *Device) SetCpu(v *CPU) *Device {
	s.Cpu = v
	return s
}

// SetFleetName sets the FleetName field's value.
func (s *Device) SetFleetName(v string) *Device {
	s.FleetName = &v
	return s
}

// SetFleetType sets the FleetType field's value.
func (s *Device) SetFleetType(v string) *Device {
	s.FleetType = &v
	return s
}

// SetFormFactor sets the FormFactor field's value.
func (s *Device) SetFormFactor(v string) *Device {
	s.FormFactor = &v
	return s
}

// SetHeapSize sets the HeapSize field's value.
func (s *Device) SetHeapSize(v int64) *Device {
	s.HeapSize = &v
	return s
}

// SetImage sets the Image field's value.
func (s *Device) SetImage(v string) *Device {
	s.Image = &v
	return s
}

// SetManufacturer sets the Manufacturer field's value.
func (s *Device) SetManufacturer(v string) *Device {
	s.Manufacturer = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *Device) SetMemory(v int64) *Device {
	s.Memory = &v
	return s
}

// SetModel sets the Model field's value.
func (s *Device) SetModel(v string) *Device {
	s.Model = &v
	return s
}

// SetName sets the Name field's value.
func (s *Device) SetName(v string) *Device {
	s.Name = &v
	return s
}

// SetOs sets the Os field's value.
func (s *Device) SetOs(v string) *Device {
	s.Os = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Device) SetPlatform(v string) *Device {
	s.Platform = &v
	return s
}

// SetRadio sets the Radio field's value.
func (s *Device) SetRadio(v string) *Device {
	s.Radio = &v
	return s
}

// SetRemoteAccessEnabled sets the RemoteAccessEnabled field's value.
func (s *Device) SetRemoteAccessEnabled(v bool) *Device {
	s.RemoteAccessEnabled = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *Device) SetResolution(v *Resolution) *Device {
	s.Resolution = v
	return s
}

// Represents the total (metered or unmetered) minutes used by the resource
// to run tests. Contains the sum of minutes consumed by all children.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeviceMinutes
type DeviceMinutes struct {
	_ struct{} `type:"structure"`

	// When specified, represents only the sum of metered minutes used by the resource
	// to run tests.
	Metered *float64 `locationName:"metered" type:"double"`

	// When specified, represents the total minutes used by the resource to run
	// tests.
	Total *float64 `locationName:"total" type:"double"`

	// When specified, represents only the sum of unmetered minutes used by the
	// resource to run tests.
	Unmetered *float64 `locationName:"unmetered" type:"double"`
}

// String returns the string representation
func (s DeviceMinutes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceMinutes) GoString() string {
	return s.String()
}

// SetMetered sets the Metered field's value.
func (s *DeviceMinutes) SetMetered(v float64) *DeviceMinutes {
	s.Metered = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *DeviceMinutes) SetTotal(v float64) *DeviceMinutes {
	s.Total = &v
	return s
}

// SetUnmetered sets the Unmetered field's value.
func (s *DeviceMinutes) SetUnmetered(v float64) *DeviceMinutes {
	s.Unmetered = &v
	return s
}

// Represents a collection of device types.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DevicePool
type DevicePool struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The device pool's name.
	Name *string `locationName:"name" type:"string"`

	// Information about the device pool's rules.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The device pool's type.
	//
	// Allowed values include:
	//
	//    * CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//    * PRIVATE: A device pool that is created and managed by the device pool
	//    developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`
}

// String returns the string representation
func (s DevicePool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePool) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DevicePool) SetArn(v string) *DevicePool {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DevicePool) SetDescription(v string) *DevicePool {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DevicePool) SetName(v string) *DevicePool {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *DevicePool) SetRules(v []*Rule) *DevicePool {
	s.Rules = v
	return s
}

// SetType sets the Type field's value.
func (s *DevicePool) SetType(v string) *DevicePool {
	s.Type = &v
	return s
}

// Represents a device pool compatibility result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DevicePoolCompatibilityResult
type DevicePoolCompatibilityResult struct {
	_ struct{} `type:"structure"`

	// Whether the result was compatible with the device pool.
	Compatible *bool `locationName:"compatible" type:"boolean"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the compatibility.
	IncompatibilityMessages []*IncompatibilityMessage `locationName:"incompatibilityMessages" type:"list"`
}

// String returns the string representation
func (s DevicePoolCompatibilityResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePoolCompatibilityResult) GoString() string {
	return s.String()
}

// SetCompatible sets the Compatible field's value.
func (s *DevicePoolCompatibilityResult) SetCompatible(v bool) *DevicePoolCompatibilityResult {
	s.Compatible = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *DevicePoolCompatibilityResult) SetDevice(v *Device) *DevicePoolCompatibilityResult {
	s.Device = v
	return s
}

// SetIncompatibilityMessages sets the IncompatibilityMessages field's value.
func (s *DevicePoolCompatibilityResult) SetIncompatibilityMessages(v []*IncompatibilityMessage) *DevicePoolCompatibilityResult {
	s.IncompatibilityMessages = v
	return s
}

// Represents the request sent to retrieve the account settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettingsRequest
type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

// Represents the account settings return values from the GetAccountSettings
// request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetAccountSettingsResult
type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// A container for account-level settings within AWS Device Farm.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

// Represents a request to the get device request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceRequest
type GetDeviceInput struct {
	_ struct{} `type:"structure"`

	// The device type's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeviceInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetDeviceInput) SetArn(v string) *GetDeviceInput {
	s.Arn = &v
	return s
}

// Represents the result of a get device request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDeviceResult
type GetDeviceOutput struct {
	_ struct{} `type:"structure"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *GetDeviceOutput) SetDevice(v *Device) *GetDeviceOutput {
	s.Device = v
	return s
}

// Represents a request to the get device pool compatibility operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibilityRequest
type GetDevicePoolCompatibilityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the app that is associated with the specified device pool.
	AppArn *string `locationName:"appArn" min:"32" type:"string"`

	// The device pool's ARN.
	//
	// DevicePoolArn is a required field
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string" required:"true"`

	// The test type for the specified device pool.
	//
	// Allowed values include the following:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	TestType *string `locationName:"testType" type:"string" enum:"TestType"`
}

// String returns the string representation
func (s GetDevicePoolCompatibilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolCompatibilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePoolCompatibilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePoolCompatibilityInput"}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.DevicePoolArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DevicePoolArn"))
	}
	if s.DevicePoolArn != nil && len(*s.DevicePoolArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePoolArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *GetDevicePoolCompatibilityInput) SetAppArn(v string) *GetDevicePoolCompatibilityInput {
	s.AppArn = &v
	return s
}

// SetDevicePoolArn sets the DevicePoolArn field's value.
func (s *GetDevicePoolCompatibilityInput) SetDevicePoolArn(v string) *GetDevicePoolCompatibilityInput {
	s.DevicePoolArn = &v
	return s
}

// SetTestType sets the TestType field's value.
func (s *GetDevicePoolCompatibilityInput) SetTestType(v string) *GetDevicePoolCompatibilityInput {
	s.TestType = &v
	return s
}

// Represents the result of describe device pool compatibility request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolCompatibilityResult
type GetDevicePoolCompatibilityOutput struct {
	_ struct{} `type:"structure"`

	// Information about compatible devices.
	CompatibleDevices []*DevicePoolCompatibilityResult `locationName:"compatibleDevices" type:"list"`

	// Information about incompatible devices.
	IncompatibleDevices []*DevicePoolCompatibilityResult `locationName:"incompatibleDevices" type:"list"`
}

// String returns the string representation
func (s GetDevicePoolCompatibilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolCompatibilityOutput) GoString() string {
	return s.String()
}

// SetCompatibleDevices sets the CompatibleDevices field's value.
func (s *GetDevicePoolCompatibilityOutput) SetCompatibleDevices(v []*DevicePoolCompatibilityResult) *GetDevicePoolCompatibilityOutput {
	s.CompatibleDevices = v
	return s
}

// SetIncompatibleDevices sets the IncompatibleDevices field's value.
func (s *GetDevicePoolCompatibilityOutput) SetIncompatibleDevices(v []*DevicePoolCompatibilityResult) *GetDevicePoolCompatibilityOutput {
	s.IncompatibleDevices = v
	return s
}

// Represents a request to the get device pool operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolRequest
type GetDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The device pool's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetDevicePoolInput) SetArn(v string) *GetDevicePoolInput {
	s.Arn = &v
	return s
}

// Represents the result of a get device pool request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetDevicePoolResult
type GetDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// Represents a collection of device types.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *GetDevicePoolOutput) SetDevicePool(v *DevicePool) *GetDevicePoolOutput {
	s.DevicePool = v
	return s
}

// Represents a request to the get job operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJobRequest
type GetJobInput struct {
	_ struct{} `type:"structure"`

	// The job's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetJobInput) SetArn(v string) *GetJobInput {
	s.Arn = &v
	return s
}

// Represents the result of a get job request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetJobResult
type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// Represents a device.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *GetJobOutput) SetJob(v *Job) *GetJobOutput {
	s.Job = v
	return s
}

// Represents the request to retrieve the offering status for the specified
// customer or account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatusRequest
type GetOfferingStatusInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s GetOfferingStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOfferingStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOfferingStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOfferingStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetOfferingStatusInput) SetNextToken(v string) *GetOfferingStatusInput {
	s.NextToken = &v
	return s
}

// Returns the status result for a device offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetOfferingStatusResult
type GetOfferingStatusOutput struct {
	_ struct{} `type:"structure"`

	// When specified, gets the offering status for the current period.
	Current map[string]*OfferingStatus `locationName:"current" type:"map"`

	// When specified, gets the offering status for the next period.
	NextPeriod map[string]*OfferingStatus `locationName:"nextPeriod" type:"map"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s GetOfferingStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOfferingStatusOutput) GoString() string {
	return s.String()
}

// SetCurrent sets the Current field's value.
func (s *GetOfferingStatusOutput) SetCurrent(v map[string]*OfferingStatus) *GetOfferingStatusOutput {
	s.Current = v
	return s
}

// SetNextPeriod sets the NextPeriod field's value.
func (s *GetOfferingStatusOutput) SetNextPeriod(v map[string]*OfferingStatus) *GetOfferingStatusOutput {
	s.NextPeriod = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOfferingStatusOutput) SetNextToken(v string) *GetOfferingStatusOutput {
	s.NextToken = &v
	return s
}

// Represents a request to the get project operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProjectRequest
type GetProjectInput struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetProjectInput) SetArn(v string) *GetProjectInput {
	s.Arn = &v
	return s
}

// Represents the result of a get project request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetProjectResult
type GetProjectOutput struct {
	_ struct{} `type:"structure"`

	// Represents an operating-system neutral workspace for running and managing
	// tests.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s GetProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *GetProjectOutput) SetProject(v *Project) *GetProjectOutput {
	s.Project = v
	return s
}

// Represents the request to get information about the specified remote access
// session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSessionRequest
type GetRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session about which you
	// want to get session information.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRemoteAccessSessionInput) SetArn(v string) *GetRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// Represents the response from the server that lists detailed information about
// the remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRemoteAccessSessionResult
type GetRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container that lists detailed information about the remote access session.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation
func (s GetRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *GetRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *GetRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

// Represents a request to the get run operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRunRequest
type GetRunInput struct {
	_ struct{} `type:"structure"`

	// The run's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetRunInput) SetArn(v string) *GetRunInput {
	s.Arn = &v
	return s
}

// Represents the result of a get run request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetRunResult
type GetRunOutput struct {
	_ struct{} `type:"structure"`

	// Represents an app on a set of devices with a specific test and configuration.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation
func (s GetRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *GetRunOutput) SetRun(v *Run) *GetRunOutput {
	s.Run = v
	return s
}

// Represents a request to the get suite operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuiteRequest
type GetSuiteInput struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuiteInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetSuiteInput) SetArn(v string) *GetSuiteInput {
	s.Arn = &v
	return s
}

// Represents the result of a get suite request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetSuiteResult
type GetSuiteOutput struct {
	_ struct{} `type:"structure"`

	// Represents a collection of one or more tests.
	Suite *Suite `locationName:"suite" type:"structure"`
}

// String returns the string representation
func (s GetSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuiteOutput) GoString() string {
	return s.String()
}

// SetSuite sets the Suite field's value.
func (s *GetSuiteOutput) SetSuite(v *Suite) *GetSuiteOutput {
	s.Suite = v
	return s
}

// Represents a request to the get test operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestRequest
type GetTestInput struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTestInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetTestInput) SetArn(v string) *GetTestInput {
	s.Arn = &v
	return s
}

// Represents the result of a get test request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetTestResult
type GetTestOutput struct {
	_ struct{} `type:"structure"`

	// Represents a condition that is evaluated.
	Test *Test `locationName:"test" type:"structure"`
}

// String returns the string representation
func (s GetTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTestOutput) GoString() string {
	return s.String()
}

// SetTest sets the Test field's value.
func (s *GetTestOutput) SetTest(v *Test) *GetTestOutput {
	s.Test = v
	return s
}

// Represents a request to the get upload operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUploadRequest
type GetUploadInput struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUploadInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetUploadInput) SetArn(v string) *GetUploadInput {
	s.Arn = &v
	return s
}

// Represents the result of a get upload request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/GetUploadResult
type GetUploadOutput struct {
	_ struct{} `type:"structure"`

	// An app or a set of one or more tests to upload or that have been uploaded.
	Upload *Upload `locationName:"upload" type:"structure"`
}

// String returns the string representation
func (s GetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadOutput) GoString() string {
	return s.String()
}

// SetUpload sets the Upload field's value.
func (s *GetUploadOutput) SetUpload(v *Upload) *GetUploadOutput {
	s.Upload = v
	return s
}

// Represents information about incompatibility.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/IncompatibilityMessage
type IncompatibilityMessage struct {
	_ struct{} `type:"structure"`

	// A message about the incompatibility.
	Message *string `locationName:"message" type:"string"`

	// The type of incompatibility.
	//
	// Allowed values include:
	//
	//    * ARN: The ARN.
	//
	//    * FORM_FACTOR: The form factor (for example, phone or tablet).
	//
	//    * MANUFACTURER: The manufacturer.
	//
	//    * PLATFORM: The platform (for example, Android or iOS).
	Type *string `locationName:"type" type:"string" enum:"DeviceAttribute"`
}

// String returns the string representation
func (s IncompatibilityMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncompatibilityMessage) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *IncompatibilityMessage) SetMessage(v string) *IncompatibilityMessage {
	s.Message = &v
	return s
}

// SetType sets the Type field's value.
func (s *IncompatibilityMessage) SetType(v string) *IncompatibilityMessage {
	s.Type = &v
	return s
}

// Represents the request to install an Android application (in .apk format)
// or an iOS application (in .ipa format) as part of a remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSessionRequest
type InstallToRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the app about which you are requesting
	// information.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" min:"32" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the remote access session about which you
	// are requesting information.
	//
	// RemoteAccessSessionArn is a required field
	RemoteAccessSessionArn *string `locationName:"remoteAccessSessionArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s InstallToRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstallToRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstallToRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstallToRemoteAccessSessionInput"}
	if s.AppArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AppArn"))
	}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.RemoteAccessSessionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteAccessSessionArn"))
	}
	if s.RemoteAccessSessionArn != nil && len(*s.RemoteAccessSessionArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("RemoteAccessSessionArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *InstallToRemoteAccessSessionInput) SetAppArn(v string) *InstallToRemoteAccessSessionInput {
	s.AppArn = &v
	return s
}

// SetRemoteAccessSessionArn sets the RemoteAccessSessionArn field's value.
func (s *InstallToRemoteAccessSessionInput) SetRemoteAccessSessionArn(v string) *InstallToRemoteAccessSessionInput {
	s.RemoteAccessSessionArn = &v
	return s
}

// Represents the response from the server after AWS Device Farm makes a request
// to install to a remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/InstallToRemoteAccessSessionResult
type InstallToRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// An app or a set of one or more tests to upload or that have been uploaded.
	AppUpload *Upload `locationName:"appUpload" type:"structure"`
}

// String returns the string representation
func (s InstallToRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstallToRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetAppUpload sets the AppUpload field's value.
func (s *InstallToRemoteAccessSessionOutput) SetAppUpload(v *Upload) *InstallToRemoteAccessSessionOutput {
	s.AppUpload = v
	return s
}

// Represents a device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Job
type Job struct {
	_ struct{} `type:"structure"`

	// The job's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The job's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the job was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the job.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the job's result.
	Message *string `locationName:"message" type:"string"`

	// The job's name.
	Name *string `locationName:"name" type:"string"`

	// The job's result.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The job's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The job's status.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending status.
	//
	//    * PENDING_CONCURRENCY: A pending concurrency status.
	//
	//    * PENDING_DEVICE: A pending device status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SCHEDULING: A scheduling status.
	//
	//    * PREPARING: A preparing status.
	//
	//    * RUNNING: A running status.
	//
	//    * COMPLETED: A completed status.
	//
	//    * STOPPING: A stopping status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The job's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The job's type.
	//
	// Allowed values include the following:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Job) SetArn(v string) *Job {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Job) SetCounters(v *Counters) *Job {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Job) SetCreated(v time.Time) *Job {
	s.Created = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *Job) SetDevice(v *Device) *Job {
	s.Device = v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Job) SetDeviceMinutes(v *DeviceMinutes) *Job {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Job) SetMessage(v string) *Job {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Job) SetName(v string) *Job {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Job) SetResult(v string) *Job {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Job) SetStarted(v time.Time) *Job {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Job) SetStopped(v time.Time) *Job {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Job) SetType(v string) *Job {
	s.Type = &v
	return s
}

// Represents a request to the list artifacts operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifactsRequest
type ListArtifactsInput struct {
	_ struct{} `type:"structure"`

	// The Run, Job, Suite, or Test ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The artifacts' type.
	//
	// Allowed values include:
	//
	//    * FILE: The artifacts are files.
	//
	//    * LOG: The artifacts are logs.
	//
	//    * SCREENSHOT: The artifacts are screenshots.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactCategory"`
}

// String returns the string representation
func (s ListArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArtifactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListArtifactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListArtifactsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListArtifactsInput) SetArn(v string) *ListArtifactsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArtifactsInput) SetNextToken(v string) *ListArtifactsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListArtifactsInput) SetType(v string) *ListArtifactsInput {
	s.Type = &v
	return s
}

// Represents the result of a list artifacts operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListArtifactsResult
type ListArtifactsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the artifacts.
	Artifacts []*Artifact `locationName:"artifacts" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArtifactsOutput) GoString() string {
	return s.String()
}

// SetArtifacts sets the Artifacts field's value.
func (s *ListArtifactsOutput) SetArtifacts(v []*Artifact) *ListArtifactsOutput {
	s.Artifacts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListArtifactsOutput) SetNextToken(v string) *ListArtifactsOutput {
	s.NextToken = &v
	return s
}

// Represents the result of a list device pools request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePoolsRequest
type ListDevicePoolsInput struct {
	_ struct{} `type:"structure"`

	// The project ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The device pools' type.
	//
	// Allowed values include:
	//
	//    * CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	//    * PRIVATE: A device pool that is created and managed by the device pool
	//    developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`
}

// String returns the string representation
func (s ListDevicePoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicePoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicePoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicePoolsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListDevicePoolsInput) SetArn(v string) *ListDevicePoolsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePoolsInput) SetNextToken(v string) *ListDevicePoolsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListDevicePoolsInput) SetType(v string) *ListDevicePoolsInput {
	s.Type = &v
	return s
}

// Represents the result of a list device pools request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicePoolsResult
type ListDevicePoolsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the device pools.
	DevicePools []*DevicePool `locationName:"devicePools" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDevicePoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicePoolsOutput) GoString() string {
	return s.String()
}

// SetDevicePools sets the DevicePools field's value.
func (s *ListDevicePoolsOutput) SetDevicePools(v []*DevicePool) *ListDevicePoolsOutput {
	s.DevicePools = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicePoolsOutput) SetNextToken(v string) *ListDevicePoolsOutput {
	s.NextToken = &v
	return s
}

// Represents the result of a list devices request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicesRequest
type ListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevicesInput"}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListDevicesInput) SetArn(v string) *ListDevicesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesInput) SetNextToken(v string) *ListDevicesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list devices operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListDevicesResult
type ListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the devices.
	Devices []*Device `locationName:"devices" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *ListDevicesOutput) SetDevices(v []*Device) *ListDevicesOutput {
	s.Devices = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDevicesOutput) SetNextToken(v string) *ListDevicesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to the list jobs operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobsRequest
type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The jobs' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListJobsInput) SetArn(v string) *ListJobsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list jobs request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListJobsResult
type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the jobs.
	Jobs []*Job `locationName:"jobs" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*Job) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// Represents the request to list the offering transaction history.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactionsRequest
type ListOfferingTransactionsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListOfferingTransactionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingTransactionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingTransactionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingTransactionsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingTransactionsInput) SetNextToken(v string) *ListOfferingTransactionsInput {
	s.NextToken = &v
	return s
}

// Returns the transaction log of the specified offerings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingTransactionsResult
type ListOfferingTransactionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The audit log of subscriptions you have purchased and modified through AWS
	// Device Farm.
	OfferingTransactions []*OfferingTransaction `locationName:"offeringTransactions" type:"list"`
}

// String returns the string representation
func (s ListOfferingTransactionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingTransactionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingTransactionsOutput) SetNextToken(v string) *ListOfferingTransactionsOutput {
	s.NextToken = &v
	return s
}

// SetOfferingTransactions sets the OfferingTransactions field's value.
func (s *ListOfferingTransactionsOutput) SetOfferingTransactions(v []*OfferingTransaction) *ListOfferingTransactionsOutput {
	s.OfferingTransactions = v
	return s
}

// Represents the request to list all offerings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingsRequest
type ListOfferingsInput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListOfferingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOfferingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOfferingsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsInput) SetNextToken(v string) *ListOfferingsInput {
	s.NextToken = &v
	return s
}

// Represents the return values of the list of offerings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListOfferingsResult
type ListOfferingsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A value representing the list offering results.
	Offerings []*Offering `locationName:"offerings" type:"list"`
}

// String returns the string representation
func (s ListOfferingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOfferingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOfferingsOutput) SetNextToken(v string) *ListOfferingsOutput {
	s.NextToken = &v
	return s
}

// SetOfferings sets the Offerings field's value.
func (s *ListOfferingsOutput) SetOfferings(v []*Offering) *ListOfferingsOutput {
	s.Offerings = v
	return s
}

// Represents a request to the list projects operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjectsRequest
type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// Optional. If no Amazon Resource Name (ARN) is specified, then AWS Device
	// Farm returns a list of all projects for the AWS account. You can also specify
	// a project ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListProjectsInput) SetArn(v string) *ListProjectsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list projects request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListProjectsResult
type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the projects.
	Projects []*Project `locationName:"projects" type:"list"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*Project) *ListProjectsOutput {
	s.Projects = v
	return s
}

// Represents the request to return information about the remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessionsRequest
type ListRemoteAccessSessionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session about which you
	// are requesting information.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListRemoteAccessSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRemoteAccessSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRemoteAccessSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRemoteAccessSessionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListRemoteAccessSessionsInput) SetArn(v string) *ListRemoteAccessSessionsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRemoteAccessSessionsInput) SetNextToken(v string) *ListRemoteAccessSessionsInput {
	s.NextToken = &v
	return s
}

// Represents the response from the server after AWS Device Farm makes a request
// to return information about the remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRemoteAccessSessionsResult
type ListRemoteAccessSessionsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// A container representing the metadata from the service about each remote
	// access session you are requesting.
	RemoteAccessSessions []*RemoteAccessSession `locationName:"remoteAccessSessions" type:"list"`
}

// String returns the string representation
func (s ListRemoteAccessSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRemoteAccessSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRemoteAccessSessionsOutput) SetNextToken(v string) *ListRemoteAccessSessionsOutput {
	s.NextToken = &v
	return s
}

// SetRemoteAccessSessions sets the RemoteAccessSessions field's value.
func (s *ListRemoteAccessSessionsOutput) SetRemoteAccessSessions(v []*RemoteAccessSession) *ListRemoteAccessSessionsOutput {
	s.RemoteAccessSessions = v
	return s
}

// Represents a request to the list runs operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRunsRequest
type ListRunsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// runs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRunsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListRunsInput) SetArn(v string) *ListRunsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunsInput) SetNextToken(v string) *ListRunsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list runs request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListRunsResult
type ListRunsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the runs.
	Runs []*Run `locationName:"runs" type:"list"`
}

// String returns the string representation
func (s ListRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRunsOutput) SetNextToken(v string) *ListRunsOutput {
	s.NextToken = &v
	return s
}

// SetRuns sets the Runs field's value.
func (s *ListRunsOutput) SetRuns(v []*Run) *ListRunsOutput {
	s.Runs = v
	return s
}

// Represents a request to the list samples operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamplesRequest
type ListSamplesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// samples.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListSamplesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSamplesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSamplesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSamplesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListSamplesInput) SetArn(v string) *ListSamplesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSamplesInput) SetNextToken(v string) *ListSamplesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list samples request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSamplesResult
type ListSamplesOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the samples.
	Samples []*Sample `locationName:"samples" type:"list"`
}

// String returns the string representation
func (s ListSamplesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSamplesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSamplesOutput) SetNextToken(v string) *ListSamplesOutput {
	s.NextToken = &v
	return s
}

// SetSamples sets the Samples field's value.
func (s *ListSamplesOutput) SetSamples(v []*Sample) *ListSamplesOutput {
	s.Samples = v
	return s
}

// Represents a request to the list suites operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuitesRequest
type ListSuitesInput struct {
	_ struct{} `type:"structure"`

	// The suites' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListSuitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSuitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSuitesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListSuitesInput) SetArn(v string) *ListSuitesInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuitesInput) SetNextToken(v string) *ListSuitesInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list suites request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListSuitesResult
type ListSuitesOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the suites.
	Suites []*Suite `locationName:"suites" type:"list"`
}

// String returns the string representation
func (s ListSuitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuitesOutput) SetNextToken(v string) *ListSuitesOutput {
	s.NextToken = &v
	return s
}

// SetSuites sets the Suites field's value.
func (s *ListSuitesOutput) SetSuites(v []*Suite) *ListSuitesOutput {
	s.Suites = v
	return s
}

// Represents a request to the list tests operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestsRequest
type ListTestsInput struct {
	_ struct{} `type:"structure"`

	// The tests' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListTestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTestsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListTestsInput) SetArn(v string) *ListTestsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestsInput) SetNextToken(v string) *ListTestsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list tests request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListTestsResult
type ListTestsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the tests.
	Tests []*Test `locationName:"tests" type:"list"`
}

// String returns the string representation
func (s ListTestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTestsOutput) SetNextToken(v string) *ListTestsOutput {
	s.NextToken = &v
	return s
}

// SetTests sets the Tests field's value.
func (s *ListTestsOutput) SetTests(v []*Test) *ListTestsOutput {
	s.Tests = v
	return s
}

// Represents a request to the list unique problems operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblemsRequest
type ListUniqueProblemsInput struct {
	_ struct{} `type:"structure"`

	// The unique problems' ARNs.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListUniqueProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUniqueProblemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUniqueProblemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUniqueProblemsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListUniqueProblemsInput) SetArn(v string) *ListUniqueProblemsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUniqueProblemsInput) SetNextToken(v string) *ListUniqueProblemsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list unique problems request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUniqueProblemsResult
type ListUniqueProblemsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the unique problems.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	UniqueProblems map[string][]*UniqueProblem `locationName:"uniqueProblems" type:"map"`
}

// String returns the string representation
func (s ListUniqueProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUniqueProblemsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUniqueProblemsOutput) SetNextToken(v string) *ListUniqueProblemsOutput {
	s.NextToken = &v
	return s
}

// SetUniqueProblems sets the UniqueProblems field's value.
func (s *ListUniqueProblemsOutput) SetUniqueProblems(v map[string][]*UniqueProblem) *ListUniqueProblemsOutput {
	s.UniqueProblems = v
	return s
}

// Represents a request to the list uploads operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploadsRequest
type ListUploadsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project for which you want to list
	// uploads.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`
}

// String returns the string representation
func (s ListUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUploadsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}
	if s.NextToken != nil && len(*s.NextToken) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListUploadsInput) SetArn(v string) *ListUploadsInput {
	s.Arn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUploadsInput) SetNextToken(v string) *ListUploadsInput {
	s.NextToken = &v
	return s
}

// Represents the result of a list uploads request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ListUploadsResult
type ListUploadsOutput struct {
	_ struct{} `type:"structure"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the uploads.
	Uploads []*Upload `locationName:"uploads" type:"list"`
}

// String returns the string representation
func (s ListUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUploadsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUploadsOutput) SetNextToken(v string) *ListUploadsOutput {
	s.NextToken = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListUploadsOutput) SetUploads(v []*Upload) *ListUploadsOutput {
	s.Uploads = v
	return s
}

// Represents a latitude and longitude pair, expressed in geographic coordinate
// system degrees (for example 47.6204, -122.3491).
//
// Elevation is currently not supported.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Location
type Location struct {
	_ struct{} `type:"structure"`

	// The latitude.
	//
	// Latitude is a required field
	Latitude *float64 `locationName:"latitude" type:"double" required:"true"`

	// The longitude.
	//
	// Longitude is a required field
	Longitude *float64 `locationName:"longitude" type:"double" required:"true"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Location"}
	if s.Latitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Latitude"))
	}
	if s.Longitude == nil {
		invalidParams.Add(request.NewErrParamRequired("Longitude"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatitude sets the Latitude field's value.
func (s *Location) SetLatitude(v float64) *Location {
	s.Latitude = &v
	return s
}

// SetLongitude sets the Longitude field's value.
func (s *Location) SetLongitude(v float64) *Location {
	s.Longitude = &v
	return s
}

// A number representing the monetary amount for an offering or transaction.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/MonetaryAmount
type MonetaryAmount struct {
	_ struct{} `type:"structure"`

	// The numerical amount of an offering or transaction.
	Amount *float64 `locationName:"amount" type:"double"`

	// The currency code of a monetary amount. For example, USD means "U.S. dollars."
	CurrencyCode *string `locationName:"currencyCode" type:"string" enum:"CurrencyCode"`
}

// String returns the string representation
func (s MonetaryAmount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonetaryAmount) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *MonetaryAmount) SetAmount(v float64) *MonetaryAmount {
	s.Amount = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *MonetaryAmount) SetCurrencyCode(v string) *MonetaryAmount {
	s.CurrencyCode = &v
	return s
}

// Represents the metadata of a device offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Offering
type Offering struct {
	_ struct{} `type:"structure"`

	// A string describing the offering.
	Description *string `locationName:"description" type:"string"`

	// The ID that corresponds to a device offering.
	Id *string `locationName:"id" min:"32" type:"string"`

	// The platform of the device (e.g., ANDROID or IOS).
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// Specifies whether there are recurring charges for the offering.
	RecurringCharges []*RecurringCharge `locationName:"recurringCharges" type:"list"`

	// The type of offering (e.g., "RECURRING") for a device.
	Type *string `locationName:"type" type:"string" enum:"OfferingType"`
}

// String returns the string representation
func (s Offering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Offering) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Offering) SetDescription(v string) *Offering {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Offering) SetId(v string) *Offering {
	s.Id = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Offering) SetPlatform(v string) *Offering {
	s.Platform = &v
	return s
}

// SetRecurringCharges sets the RecurringCharges field's value.
func (s *Offering) SetRecurringCharges(v []*RecurringCharge) *Offering {
	s.RecurringCharges = v
	return s
}

// SetType sets the Type field's value.
func (s *Offering) SetType(v string) *Offering {
	s.Type = &v
	return s
}

// The status of the offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/OfferingStatus
type OfferingStatus struct {
	_ struct{} `type:"structure"`

	// The date on which the offering is effective.
	EffectiveOn *time.Time `locationName:"effectiveOn" type:"timestamp" timestampFormat:"unix"`

	// Represents the metadata of an offering status.
	Offering *Offering `locationName:"offering" type:"structure"`

	// The number of available devices in the offering.
	Quantity *int64 `locationName:"quantity" type:"integer"`

	// The type specified for the offering status.
	Type *string `locationName:"type" type:"string" enum:"OfferingTransactionType"`
}

// String returns the string representation
func (s OfferingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OfferingStatus) GoString() string {
	return s.String()
}

// SetEffectiveOn sets the EffectiveOn field's value.
func (s *OfferingStatus) SetEffectiveOn(v time.Time) *OfferingStatus {
	s.EffectiveOn = &v
	return s
}

// SetOffering sets the Offering field's value.
func (s *OfferingStatus) SetOffering(v *Offering) *OfferingStatus {
	s.Offering = v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *OfferingStatus) SetQuantity(v int64) *OfferingStatus {
	s.Quantity = &v
	return s
}

// SetType sets the Type field's value.
func (s *OfferingStatus) SetType(v string) *OfferingStatus {
	s.Type = &v
	return s
}

// Represents the metadata of an offering transaction.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/OfferingTransaction
type OfferingTransaction struct {
	_ struct{} `type:"structure"`

	// The cost of an offering transaction.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The date on which an offering transaction was created.
	CreatedOn *time.Time `locationName:"createdOn" type:"timestamp" timestampFormat:"unix"`

	// The status of an offering transaction.
	OfferingStatus *OfferingStatus `locationName:"offeringStatus" type:"structure"`

	// The transaction ID of the offering transaction.
	TransactionId *string `locationName:"transactionId" min:"32" type:"string"`
}

// String returns the string representation
func (s OfferingTransaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OfferingTransaction) GoString() string {
	return s.String()
}

// SetCost sets the Cost field's value.
func (s *OfferingTransaction) SetCost(v *MonetaryAmount) *OfferingTransaction {
	s.Cost = v
	return s
}

// SetCreatedOn sets the CreatedOn field's value.
func (s *OfferingTransaction) SetCreatedOn(v time.Time) *OfferingTransaction {
	s.CreatedOn = &v
	return s
}

// SetOfferingStatus sets the OfferingStatus field's value.
func (s *OfferingTransaction) SetOfferingStatus(v *OfferingStatus) *OfferingTransaction {
	s.OfferingStatus = v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *OfferingTransaction) SetTransactionId(v string) *OfferingTransaction {
	s.TransactionId = &v
	return s
}

// Represents a specific warning or failure.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Problem
type Problem struct {
	_ struct{} `type:"structure"`

	// Information about the associated device.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the associated job.
	Job *ProblemDetail `locationName:"job" type:"structure"`

	// A message about the problem's result.
	Message *string `locationName:"message" type:"string"`

	// The problem's result.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// Information about the associated run.
	Run *ProblemDetail `locationName:"run" type:"structure"`

	// Information about the associated suite.
	Suite *ProblemDetail `locationName:"suite" type:"structure"`

	// Information about the associated test.
	Test *ProblemDetail `locationName:"test" type:"structure"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Problem) GoString() string {
	return s.String()
}

// SetDevice sets the Device field's value.
func (s *Problem) SetDevice(v *Device) *Problem {
	s.Device = v
	return s
}

// SetJob sets the Job field's value.
func (s *Problem) SetJob(v *ProblemDetail) *Problem {
	s.Job = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Problem) SetMessage(v string) *Problem {
	s.Message = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Problem) SetResult(v string) *Problem {
	s.Result = &v
	return s
}

// SetRun sets the Run field's value.
func (s *Problem) SetRun(v *ProblemDetail) *Problem {
	s.Run = v
	return s
}

// SetSuite sets the Suite field's value.
func (s *Problem) SetSuite(v *ProblemDetail) *Problem {
	s.Suite = v
	return s
}

// SetTest sets the Test field's value.
func (s *Problem) SetTest(v *ProblemDetail) *Problem {
	s.Test = v
	return s
}

// Information about a problem detail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ProblemDetail
type ProblemDetail struct {
	_ struct{} `type:"structure"`

	// The problem detail's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The problem detail's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ProblemDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProblemDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProblemDetail) SetArn(v string) *ProblemDetail {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProblemDetail) SetName(v string) *ProblemDetail {
	s.Name = &v
	return s
}

// Represents an operating-system neutral workspace for running and managing
// tests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Project
type Project struct {
	_ struct{} `type:"structure"`

	// The project's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The project's name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Project) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Project) SetArn(v string) *Project {
	s.Arn = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *Project) SetCreated(v time.Time) *Project {
	s.Created = &v
	return s
}

// SetName sets the Name field's value.
func (s *Project) SetName(v string) *Project {
	s.Name = &v
	return s
}

// Represents a request for a purchase offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOfferingRequest
type PurchaseOfferingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the offering.
	OfferingId *string `locationName:"offeringId" min:"32" type:"string"`

	// The number of device slots you wish to purchase in an offering request.
	Quantity *int64 `locationName:"quantity" type:"integer"`
}

// String returns the string representation
func (s PurchaseOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PurchaseOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PurchaseOfferingInput"}
	if s.OfferingId != nil && len(*s.OfferingId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *PurchaseOfferingInput) SetOfferingId(v string) *PurchaseOfferingInput {
	s.OfferingId = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *PurchaseOfferingInput) SetQuantity(v int64) *PurchaseOfferingInput {
	s.Quantity = &v
	return s
}

// The result of the purchase offering (e.g., success or failure).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/PurchaseOfferingResult
type PurchaseOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the offering transaction for the purchase result.
	OfferingTransaction *OfferingTransaction `locationName:"offeringTransaction" type:"structure"`
}

// String returns the string representation
func (s PurchaseOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PurchaseOfferingOutput) GoString() string {
	return s.String()
}

// SetOfferingTransaction sets the OfferingTransaction field's value.
func (s *PurchaseOfferingOutput) SetOfferingTransaction(v *OfferingTransaction) *PurchaseOfferingOutput {
	s.OfferingTransaction = v
	return s
}

// Represents the set of radios and their states on a device. Examples of radios
// include Wi-Fi, GPS, Bluetooth, and NFC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Radios
type Radios struct {
	_ struct{} `type:"structure"`

	// True if Bluetooth is enabled at the beginning of the test; otherwise, false.
	Bluetooth *bool `locationName:"bluetooth" type:"boolean"`

	// True if GPS is enabled at the beginning of the test; otherwise, false.
	Gps *bool `locationName:"gps" type:"boolean"`

	// True if NFC is enabled at the beginning of the test; otherwise, false.
	Nfc *bool `locationName:"nfc" type:"boolean"`

	// True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
	Wifi *bool `locationName:"wifi" type:"boolean"`
}

// String returns the string representation
func (s Radios) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Radios) GoString() string {
	return s.String()
}

// SetBluetooth sets the Bluetooth field's value.
func (s *Radios) SetBluetooth(v bool) *Radios {
	s.Bluetooth = &v
	return s
}

// SetGps sets the Gps field's value.
func (s *Radios) SetGps(v bool) *Radios {
	s.Gps = &v
	return s
}

// SetNfc sets the Nfc field's value.
func (s *Radios) SetNfc(v bool) *Radios {
	s.Nfc = &v
	return s
}

// SetWifi sets the Wifi field's value.
func (s *Radios) SetWifi(v bool) *Radios {
	s.Wifi = &v
	return s
}

// Specifies whether charges for devices will be recurring.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RecurringCharge
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The cost of the recurring charge.
	Cost *MonetaryAmount `locationName:"cost" type:"structure"`

	// The frequency in which charges will recur.
	Frequency *string `locationName:"frequency" type:"string" enum:"RecurringChargeFrequency"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecurringCharge) GoString() string {
	return s.String()
}

// SetCost sets the Cost field's value.
func (s *RecurringCharge) SetCost(v *MonetaryAmount) *RecurringCharge {
	s.Cost = v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *RecurringCharge) SetFrequency(v string) *RecurringCharge {
	s.Frequency = &v
	return s
}

// Represents information about the remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RemoteAccessSession
type RemoteAccessSession struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The billing method of the remote access session. Possible values include
	// METERED or UNMETERED. For more information about metered devices, see AWS
	// Device Farm terminology (http://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology)."
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The date and time the remote access session was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	// Represents the total (metered or unmetered) minutes used by the resource
	// to run tests. Contains the sum of minutes consumed by all children.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// The endpoint for the remote access sesssion.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// A message about the remote access session.
	Message *string `locationName:"message" type:"string"`

	// The name of the remote access session.
	Name *string `locationName:"name" type:"string"`

	// The result of the remote access session. Can be any of the following:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The date and time the remote access session was started.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The status of the remote access session. Can be any of the following:
	//
	//    * PENDING: A pending status.
	//
	//    * PENDING_CONCURRENCY: A pending concurrency status.
	//
	//    * PENDING_DEVICE: A pending device status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SCHEDULING: A scheduling status.
	//
	//    * PREPARING: A preparing status.
	//
	//    * RUNNING: A running status.
	//
	//    * COMPLETED: A completed status.
	//
	//    * STOPPING: A stopping status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The date and time the remote access session was stopped.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s RemoteAccessSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAccessSession) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RemoteAccessSession) SetArn(v string) *RemoteAccessSession {
	s.Arn = &v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *RemoteAccessSession) SetBillingMethod(v string) *RemoteAccessSession {
	s.BillingMethod = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *RemoteAccessSession) SetCreated(v time.Time) *RemoteAccessSession {
	s.Created = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *RemoteAccessSession) SetDevice(v *Device) *RemoteAccessSession {
	s.Device = v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *RemoteAccessSession) SetDeviceMinutes(v *DeviceMinutes) *RemoteAccessSession {
	s.DeviceMinutes = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *RemoteAccessSession) SetEndpoint(v string) *RemoteAccessSession {
	s.Endpoint = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *RemoteAccessSession) SetMessage(v string) *RemoteAccessSession {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *RemoteAccessSession) SetName(v string) *RemoteAccessSession {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *RemoteAccessSession) SetResult(v string) *RemoteAccessSession {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *RemoteAccessSession) SetStarted(v time.Time) *RemoteAccessSession {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RemoteAccessSession) SetStatus(v string) *RemoteAccessSession {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *RemoteAccessSession) SetStopped(v time.Time) *RemoteAccessSession {
	s.Stopped = &v
	return s
}

// A request representing an offering renewal.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOfferingRequest
type RenewOfferingInput struct {
	_ struct{} `type:"structure"`

	// The ID of a request to renew an offering.
	OfferingId *string `locationName:"offeringId" min:"32" type:"string"`

	// The quantity requested in an offering renewal.
	Quantity *int64 `locationName:"quantity" type:"integer"`
}

// String returns the string representation
func (s RenewOfferingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewOfferingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewOfferingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenewOfferingInput"}
	if s.OfferingId != nil && len(*s.OfferingId) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("OfferingId", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOfferingId sets the OfferingId field's value.
func (s *RenewOfferingInput) SetOfferingId(v string) *RenewOfferingInput {
	s.OfferingId = &v
	return s
}

// SetQuantity sets the Quantity field's value.
func (s *RenewOfferingInput) SetQuantity(v int64) *RenewOfferingInput {
	s.Quantity = &v
	return s
}

// The result of a renewal offering.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/RenewOfferingResult
type RenewOfferingOutput struct {
	_ struct{} `type:"structure"`

	// Represents the status of the offering transaction for the renewal.
	OfferingTransaction *OfferingTransaction `locationName:"offeringTransaction" type:"structure"`
}

// String returns the string representation
func (s RenewOfferingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewOfferingOutput) GoString() string {
	return s.String()
}

// SetOfferingTransaction sets the OfferingTransaction field's value.
func (s *RenewOfferingOutput) SetOfferingTransaction(v *OfferingTransaction) *RenewOfferingOutput {
	s.OfferingTransaction = v
	return s
}

// Represents the screen resolution of a device in height and width, expressed
// in pixels.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Resolution
type Resolution struct {
	_ struct{} `type:"structure"`

	// The screen resolution's height, expressed in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The screen resolution's width, expressed in pixels.
	Width *int64 `locationName:"width" type:"integer"`
}

// String returns the string representation
func (s Resolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resolution) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *Resolution) SetHeight(v int64) *Resolution {
	s.Height = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *Resolution) SetWidth(v int64) *Resolution {
	s.Width = &v
	return s
}

// Represents a condition for a device pool.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// The rule's stringified attribute. For example, specify the value as "\"abc\"".
	//
	// Allowed values include:
	//
	//    * ARN: The ARN.
	//
	//    * FORM_FACTOR: The form factor (for example, phone or tablet).
	//
	//    * MANUFACTURER: The manufacturer.
	//
	//    * PLATFORM: The platform (for example, Android or iOS).
	Attribute *string `locationName:"attribute" type:"string" enum:"DeviceAttribute"`

	// The rule's operator.
	//
	//    * EQUALS: The equals operator.
	//
	//    * GREATER_THAN: The greater-than operator.
	//
	//    * IN: The in operator.
	//
	//    * LESS_THAN: The less-than operator.
	//
	//    * NOT_IN: The not-in operator.
	Operator *string `locationName:"operator" type:"string" enum:"RuleOperator"`

	// The rule's value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *Rule) SetAttribute(v string) *Rule {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *Rule) SetOperator(v string) *Rule {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Rule) SetValue(v string) *Rule {
	s.Value = &v
	return s
}

// Represents an app on a set of devices with a specific test and configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Run
type Run struct {
	_ struct{} `type:"structure"`

	// The run's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The total number of completed jobs.
	CompletedJobs *int64 `locationName:"completedJobs" type:"integer"`

	// The run's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the run was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents the total (metered or unmetered) minutes used by the test run.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the run's result.
	Message *string `locationName:"message" type:"string"`

	// The run's name.
	Name *string `locationName:"name" type:"string"`

	// The run's platform.
	//
	// Allowed values include:
	//
	//    * ANDROID: The Android platform.
	//
	//    * IOS: The iOS platform.
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// The run's result.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The run's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The run's status.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending status.
	//
	//    * PENDING_CONCURRENCY: A pending concurrency status.
	//
	//    * PENDING_DEVICE: A pending device status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SCHEDULING: A scheduling status.
	//
	//    * PREPARING: A preparing status.
	//
	//    * RUNNING: A running status.
	//
	//    * COMPLETED: A completed status.
	//
	//    * STOPPING: A stopping status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The run's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The total number of jobs for the run.
	TotalJobs *int64 `locationName:"totalJobs" type:"integer"`

	// The run's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation
func (s Run) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Run) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Run) SetArn(v string) *Run {
	s.Arn = &v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *Run) SetBillingMethod(v string) *Run {
	s.BillingMethod = &v
	return s
}

// SetCompletedJobs sets the CompletedJobs field's value.
func (s *Run) SetCompletedJobs(v int64) *Run {
	s.CompletedJobs = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Run) SetCounters(v *Counters) *Run {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Run) SetCreated(v time.Time) *Run {
	s.Created = &v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Run) SetDeviceMinutes(v *DeviceMinutes) *Run {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Run) SetMessage(v string) *Run {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Run) SetName(v string) *Run {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Run) SetPlatform(v string) *Run {
	s.Platform = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Run) SetResult(v string) *Run {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Run) SetStarted(v time.Time) *Run {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Run) SetStatus(v string) *Run {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Run) SetStopped(v time.Time) *Run {
	s.Stopped = &v
	return s
}

// SetTotalJobs sets the TotalJobs field's value.
func (s *Run) SetTotalJobs(v int64) *Run {
	s.TotalJobs = &v
	return s
}

// SetType sets the Type field's value.
func (s *Run) SetType(v string) *Run {
	s.Type = &v
	return s
}

// Represents a sample of performance data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Sample
type Sample struct {
	_ struct{} `type:"structure"`

	// The sample's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The sample's type.
	//
	// Must be one of the following values:
	//
	//    * CPU: A CPU sample type. This is expressed as the app processing CPU
	//    time (including child processes) as reported by process, as a percentage.
	//
	//    * MEMORY: A memory usage sample type. This is expressed as the total proportional
	//    set size of an app process, in kilobytes.
	//
	//    * NATIVE_AVG_DRAWTIME
	//
	//    * NATIVE_FPS
	//
	//    * NATIVE_FRAMES
	//
	//    * NATIVE_MAX_DRAWTIME
	//
	//    * NATIVE_MIN_DRAWTIME
	//
	//    * OPENGL_AVG_DRAWTIME
	//
	//    * OPENGL_FPS
	//
	//    * OPENGL_FRAMES
	//
	//    * OPENGL_MAX_DRAWTIME
	//
	//    * OPENGL_MIN_DRAWTIME
	//
	//    * RX
	//
	//    * RX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    sent, by app process.
	//
	//    * THREADS: A threads sample type. This is expressed as the total number
	//    of threads per app process.
	//
	//    * TX
	//
	//    * TX_RATE: The total number of bytes per second (TCP and UDP) that are
	//    received, by app process.
	Type *string `locationName:"type" type:"string" enum:"SampleType"`

	// The pre-signed Amazon S3 URL that can be used with a corresponding GET request
	// to download the sample's file.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Sample) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Sample) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Sample) SetArn(v string) *Sample {
	s.Arn = &v
	return s
}

// SetType sets the Type field's value.
func (s *Sample) SetType(v string) *Sample {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Sample) SetUrl(v string) *Sample {
	s.Url = &v
	return s
}

// Represents the settings for a run. Includes things like location, radio states,
// auxiliary apps, and network profiles.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRunConfiguration
type ScheduleRunConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of auxiliary apps for the run.
	AuxiliaryApps []*string `locationName:"auxiliaryApps" type:"list"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is metered.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The ARN of the extra data for the run. The extra data is a .zip file that
	// AWS Device Farm will extract to external data for Android or the app's sandbox
	// for iOS.
	ExtraDataPackageArn *string `locationName:"extraDataPackageArn" min:"32" type:"string"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// Reserved for internal use.
	NetworkProfileArn *string `locationName:"networkProfileArn" min:"32" type:"string"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`
}

// String returns the string representation
func (s ScheduleRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunConfiguration"}
	if s.ExtraDataPackageArn != nil && len(*s.ExtraDataPackageArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ExtraDataPackageArn", 32))
	}
	if s.NetworkProfileArn != nil && len(*s.NetworkProfileArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("NetworkProfileArn", 32))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuxiliaryApps sets the AuxiliaryApps field's value.
func (s *ScheduleRunConfiguration) SetAuxiliaryApps(v []*string) *ScheduleRunConfiguration {
	s.AuxiliaryApps = v
	return s
}

// SetBillingMethod sets the BillingMethod field's value.
func (s *ScheduleRunConfiguration) SetBillingMethod(v string) *ScheduleRunConfiguration {
	s.BillingMethod = &v
	return s
}

// SetExtraDataPackageArn sets the ExtraDataPackageArn field's value.
func (s *ScheduleRunConfiguration) SetExtraDataPackageArn(v string) *ScheduleRunConfiguration {
	s.ExtraDataPackageArn = &v
	return s
}

// SetLocale sets the Locale field's value.
func (s *ScheduleRunConfiguration) SetLocale(v string) *ScheduleRunConfiguration {
	s.Locale = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *ScheduleRunConfiguration) SetLocation(v *Location) *ScheduleRunConfiguration {
	s.Location = v
	return s
}

// SetNetworkProfileArn sets the NetworkProfileArn field's value.
func (s *ScheduleRunConfiguration) SetNetworkProfileArn(v string) *ScheduleRunConfiguration {
	s.NetworkProfileArn = &v
	return s
}

// SetRadios sets the Radios field's value.
func (s *ScheduleRunConfiguration) SetRadios(v *Radios) *ScheduleRunConfiguration {
	s.Radios = v
	return s
}

// Represents a request to the schedule run operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRunRequest
type ScheduleRunInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the app to schedule a run.
	AppArn *string `locationName:"appArn" min:"32" type:"string"`

	// Information about the settings for the run to be scheduled.
	Configuration *ScheduleRunConfiguration `locationName:"configuration" type:"structure"`

	// The ARN of the device pool for the run to be scheduled.
	//
	// DevicePoolArn is a required field
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string" required:"true"`

	// The name for the run to be scheduled.
	Name *string `locationName:"name" type:"string"`

	// The ARN of the project for the run to be scheduled.
	//
	// ProjectArn is a required field
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Information about the test for the run to be scheduled.
	//
	// Test is a required field
	Test *ScheduleRunTest `locationName:"test" type:"structure" required:"true"`
}

// String returns the string representation
func (s ScheduleRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunInput"}
	if s.AppArn != nil && len(*s.AppArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("AppArn", 32))
	}
	if s.DevicePoolArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DevicePoolArn"))
	}
	if s.DevicePoolArn != nil && len(*s.DevicePoolArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePoolArn", 32))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 32))
	}
	if s.Test == nil {
		invalidParams.Add(request.NewErrParamRequired("Test"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Test != nil {
		if err := s.Test.Validate(); err != nil {
			invalidParams.AddNested("Test", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppArn sets the AppArn field's value.
func (s *ScheduleRunInput) SetAppArn(v string) *ScheduleRunInput {
	s.AppArn = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *ScheduleRunInput) SetConfiguration(v *ScheduleRunConfiguration) *ScheduleRunInput {
	s.Configuration = v
	return s
}

// SetDevicePoolArn sets the DevicePoolArn field's value.
func (s *ScheduleRunInput) SetDevicePoolArn(v string) *ScheduleRunInput {
	s.DevicePoolArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleRunInput) SetName(v string) *ScheduleRunInput {
	s.Name = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ScheduleRunInput) SetProjectArn(v string) *ScheduleRunInput {
	s.ProjectArn = &v
	return s
}

// SetTest sets the Test field's value.
func (s *ScheduleRunInput) SetTest(v *ScheduleRunTest) *ScheduleRunInput {
	s.Test = v
	return s
}

// Represents the result of a schedule run request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRunResult
type ScheduleRunOutput struct {
	_ struct{} `type:"structure"`

	// Information about the scheduled run.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation
func (s ScheduleRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *ScheduleRunOutput) SetRun(v *Run) *ScheduleRunOutput {
	s.Run = v
	return s
}

// Represents additional test settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/ScheduleRunTest
type ScheduleRunTest struct {
	_ struct{} `type:"structure"`

	// The test's filter.
	Filter *string `locationName:"filter" type:"string"`

	// The test's parameters, such as test framework parameters and fixture settings.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The ARN of the uploaded test that will be run.
	TestPackageArn *string `locationName:"testPackageArn" min:"32" type:"string"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"TestType"`
}

// String returns the string representation
func (s ScheduleRunTest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunTest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleRunTest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleRunTest"}
	if s.TestPackageArn != nil && len(*s.TestPackageArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("TestPackageArn", 32))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ScheduleRunTest) SetFilter(v string) *ScheduleRunTest {
	s.Filter = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ScheduleRunTest) SetParameters(v map[string]*string) *ScheduleRunTest {
	s.Parameters = v
	return s
}

// SetTestPackageArn sets the TestPackageArn field's value.
func (s *ScheduleRunTest) SetTestPackageArn(v string) *ScheduleRunTest {
	s.TestPackageArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *ScheduleRunTest) SetType(v string) *ScheduleRunTest {
	s.Type = &v
	return s
}

// Represents the request to stop the remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSessionRequest
type StopRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the remote access session you wish to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StopRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRemoteAccessSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRemoteAccessSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRemoteAccessSessionInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopRemoteAccessSessionInput) SetArn(v string) *StopRemoteAccessSessionInput {
	s.Arn = &v
	return s
}

// Represents the response from the server that describes the remote access
// session when AWS Device Farm stops the session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRemoteAccessSessionResult
type StopRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`

	// A container representing the metadata from the service about the remote access
	// session you are stopping.
	RemoteAccessSession *RemoteAccessSession `locationName:"remoteAccessSession" type:"structure"`
}

// String returns the string representation
func (s StopRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRemoteAccessSessionOutput) GoString() string {
	return s.String()
}

// SetRemoteAccessSession sets the RemoteAccessSession field's value.
func (s *StopRemoteAccessSessionOutput) SetRemoteAccessSession(v *RemoteAccessSession) *StopRemoteAccessSessionOutput {
	s.RemoteAccessSession = v
	return s
}

// Represents the request to stop a specific run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRunRequest
type StopRunInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm run you wish
	// to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StopRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRunInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *StopRunInput) SetArn(v string) *StopRunInput {
	s.Arn = &v
	return s
}

// Represents the results of your stop run attempt.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopRunResult
type StopRunOutput struct {
	_ struct{} `type:"structure"`

	// Represents an app on a set of devices with a specific test and configuration.
	Run *Run `locationName:"run" type:"structure"`
}

// String returns the string representation
func (s StopRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRunOutput) GoString() string {
	return s.String()
}

// SetRun sets the Run field's value.
func (s *StopRunOutput) SetRun(v *Run) *StopRunOutput {
	s.Run = v
	return s
}

// Represents a collection of one or more tests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Suite
type Suite struct {
	_ struct{} `type:"structure"`

	// The suite's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The suite's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the suite was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents the total (metered or unmetered) minutes used by the test suite.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the suite's result.
	Message *string `locationName:"message" type:"string"`

	// The suite's name.
	Name *string `locationName:"name" type:"string"`

	// The suite's result.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The suite's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The suite's status.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending status.
	//
	//    * PENDING_CONCURRENCY: A pending concurrency status.
	//
	//    * PENDING_DEVICE: A pending device status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SCHEDULING: A scheduling status.
	//
	//    * PREPARING: A preparing status.
	//
	//    * RUNNING: A running status.
	//
	//    * COMPLETED: A completed status.
	//
	//    * STOPPING: A stopping status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The suite's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The suite's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation
func (s Suite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Suite) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Suite) SetArn(v string) *Suite {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Suite) SetCounters(v *Counters) *Suite {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Suite) SetCreated(v time.Time) *Suite {
	s.Created = &v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Suite) SetDeviceMinutes(v *DeviceMinutes) *Suite {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Suite) SetMessage(v string) *Suite {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Suite) SetName(v string) *Suite {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Suite) SetResult(v string) *Suite {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Suite) SetStarted(v time.Time) *Suite {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Suite) SetStatus(v string) *Suite {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Suite) SetStopped(v time.Time) *Suite {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Suite) SetType(v string) *Suite {
	s.Type = &v
	return s
}

// Represents a condition that is evaluated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Test
type Test struct {
	_ struct{} `type:"structure"`

	// The test's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The test's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the test was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents the total (metered or unmetered) minutes used by the test.
	DeviceMinutes *DeviceMinutes `locationName:"deviceMinutes" type:"structure"`

	// A message about the test's result.
	Message *string `locationName:"message" type:"string"`

	// The test's name.
	Name *string `locationName:"name" type:"string"`

	// The test's result.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending condition.
	//
	//    * PASSED: A passing condition.
	//
	//    * WARNED: A warning condition.
	//
	//    * FAILED: A failed condition.
	//
	//    * SKIPPED: A skipped condition.
	//
	//    * ERRORED: An error condition.
	//
	//    * STOPPED: A stopped condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The test's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The test's status.
	//
	// Allowed values include:
	//
	//    * PENDING: A pending status.
	//
	//    * PENDING_CONCURRENCY: A pending concurrency status.
	//
	//    * PENDING_DEVICE: A pending device status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SCHEDULING: A scheduling status.
	//
	//    * PREPARING: A preparing status.
	//
	//    * RUNNING: A running status.
	//
	//    * COMPLETED: A completed status.
	//
	//    * STOPPING: A stopping status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The test's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//    * BUILTIN_FUZZ: The built-in fuzz type.
	//
	//    * BUILTIN_EXPLORER: For Android, an app explorer that will traverse an
	//    Android app, interacting with it and capturing screenshots at the same
	//    time.
	//
	//    * APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	//    * APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	//    * APPIUM_PYTHON: The Appium Python type.
	//
	//    * APPIUM_WEB_JAVA_JUNIT: The Appium Java JUnit type for Web apps.
	//
	//    * APPIUM_WEB_JAVA_TESTNG: The Appium Java TestNG type for Web apps.
	//
	//    * APPIUM_WEB_PYTHON: The Appium Python type for Web apps.
	//
	//    * CALABASH: The Calabash type.
	//
	//    * INSTRUMENTATION: The Instrumentation type.
	//
	//    * UIAUTOMATION: The uiautomation type.
	//
	//    * UIAUTOMATOR: The uiautomator type.
	//
	//    * XCTEST: The XCode test type.
	//
	//    * XCTEST_UI: The XCode UI test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`
}

// String returns the string representation
func (s Test) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Test) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Test) SetArn(v string) *Test {
	s.Arn = &v
	return s
}

// SetCounters sets the Counters field's value.
func (s *Test) SetCounters(v *Counters) *Test {
	s.Counters = v
	return s
}

// SetCreated sets the Created field's value.
func (s *Test) SetCreated(v time.Time) *Test {
	s.Created = &v
	return s
}

// SetDeviceMinutes sets the DeviceMinutes field's value.
func (s *Test) SetDeviceMinutes(v *DeviceMinutes) *Test {
	s.DeviceMinutes = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Test) SetMessage(v string) *Test {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *Test) SetName(v string) *Test {
	s.Name = &v
	return s
}

// SetResult sets the Result field's value.
func (s *Test) SetResult(v string) *Test {
	s.Result = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *Test) SetStarted(v time.Time) *Test {
	s.Started = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Test) SetStatus(v string) *Test {
	s.Status = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *Test) SetStopped(v time.Time) *Test {
	s.Stopped = &v
	return s
}

// SetType sets the Type field's value.
func (s *Test) SetType(v string) *Test {
	s.Type = &v
	return s
}

// A collection of one or more problems, grouped by their result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UniqueProblem
type UniqueProblem struct {
	_ struct{} `type:"structure"`

	// A message about the unique problems' result.
	Message *string `locationName:"message" type:"string"`

	// Information about the problems.
	Problems []*Problem `locationName:"problems" type:"list"`
}

// String returns the string representation
func (s UniqueProblem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UniqueProblem) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *UniqueProblem) SetMessage(v string) *UniqueProblem {
	s.Message = &v
	return s
}

// SetProblems sets the Problems field's value.
func (s *UniqueProblem) SetProblems(v []*Problem) *UniqueProblem {
	s.Problems = v
	return s
}

// Represents a request to the update device pool operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePoolRequest
type UpdateDevicePoolInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resourc Name (ARN) of the Device Farm device pool you wish to
	// update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// A description of the device pool you wish to update.
	Description *string `locationName:"description" type:"string"`

	// A string representing the name of the device pool you wish to update.
	Name *string `locationName:"name" type:"string"`

	// Represents the rules you wish to modify for the device pool. Updating rules
	// is optional; however, if you choose to update rules for your request, the
	// update will replace the existing rules.
	Rules []*Rule `locationName:"rules" type:"list"`
}

// String returns the string representation
func (s UpdateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevicePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDevicePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDevicePoolInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateDevicePoolInput) SetArn(v string) *UpdateDevicePoolInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDevicePoolInput) SetDescription(v string) *UpdateDevicePoolInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDevicePoolInput) SetName(v string) *UpdateDevicePoolInput {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateDevicePoolInput) SetRules(v []*Rule) *UpdateDevicePoolInput {
	s.Rules = v
	return s
}

// Represents the result of an update device pool request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateDevicePoolResult
type UpdateDevicePoolOutput struct {
	_ struct{} `type:"structure"`

	// Represents a collection of device types.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`
}

// String returns the string representation
func (s UpdateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevicePoolOutput) GoString() string {
	return s.String()
}

// SetDevicePool sets the DevicePool field's value.
func (s *UpdateDevicePoolOutput) SetDevicePool(v *DevicePool) *UpdateDevicePoolOutput {
	s.DevicePool = v
	return s
}

// Represents a request to the update project operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProjectRequest
type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project whose name you wish to update.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// A string representing the new name of the project that you are updating.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateProjectInput) SetArn(v string) *UpdateProjectInput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// Represents the result of an update project request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/UpdateProjectResult
type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Represents an operating-system neutral workspace for running and managing
	// tests.
	Project *Project `locationName:"project" type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *UpdateProjectOutput) SetProject(v *Project) *UpdateProjectOutput {
	s.Project = v
	return s
}

// An app or a set of one or more tests to upload or that have been uploaded.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/Upload
type Upload struct {
	_ struct{} `type:"structure"`

	// The upload's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The upload's content type (for example, "application/octet-stream").
	ContentType *string `locationName:"contentType" type:"string"`

	// When the upload was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A message about the upload's result.
	Message *string `locationName:"message" type:"string"`

	// The upload's metadata. For example, for Android, this contains information
	// that is parsed from the manifest and is displayed in the AWS Device Farm
	// console after the associated app is uploaded.
	Metadata *string `locationName:"metadata" type:"string"`

	// The upload's file name.
	Name *string `locationName:"name" type:"string"`

	// The upload's status.
	//
	// Must be one of the following values:
	//
	//    * FAILED: A failed status.
	//
	//    * INITIALIZED: An initialized status.
	//
	//    * PROCESSING: A processing status.
	//
	//    * SUCCEEDED: A succeeded status.
	Status *string `locationName:"status" type:"string" enum:"UploadStatus"`

	// The upload's type.
	//
	// Must be one of the following values:
	//
	//    * ANDROID_APP: An Android upload.
	//
	//    * IOS_APP: An iOS upload.
	//
	//    * WEB_APP: A web appliction upload.
	//
	//    * EXTERNAL_DATA: An external data upload.
	//
	//    * APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
	//
	//    * APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package
	//    upload.
	//
	//    * APPIUM_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
	//
	//    * APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package
	//    upload.
	//
	//    * APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package
	//    upload.
	//
	//    * APPIUM_WEB_PYTHON_TEST_PACKAGE: An Appium Python test package upload.
	//
	//    * CALABASH_TEST_PACKAGE: A Calabash test package upload.
	//
	//    * INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
	//
	//    * UIAUTOMATION_TEST_PACKAGE: A uiautomation test package upload.
	//
	//    * UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
	//
	//    * XCTEST_TEST_PACKAGE: An XCode test package upload.
	//
	//    * XCTEST_UI_TEST_PACKAGE: An XCode UI test package upload.
	Type *string `locationName:"type" type:"string" enum:"UploadType"`

	// The pre-signed Amazon S3 URL that was used to store a file through a corresponding
	// PUT request.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Upload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Upload) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Upload) SetArn(v string) *Upload {
	s.Arn = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Upload) SetContentType(v string) *Upload {
	s.ContentType = &v
	return s
}

// SetCreated sets the Created field's value.
func (s *Upload) SetCreated(v time.Time) *Upload {
	s.Created = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Upload) SetMessage(v string) *Upload {
	s.Message = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *Upload) SetMetadata(v string) *Upload {
	s.Metadata = &v
	return s
}

// SetName sets the Name field's value.
func (s *Upload) SetName(v string) *Upload {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Upload) SetStatus(v string) *Upload {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Upload) SetType(v string) *Upload {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Upload) SetUrl(v string) *Upload {
	s.Url = &v
	return s
}

const (
	// ArtifactCategoryScreenshot is a ArtifactCategory enum value
	ArtifactCategoryScreenshot = "SCREENSHOT"

	// ArtifactCategoryFile is a ArtifactCategory enum value
	ArtifactCategoryFile = "FILE"

	// ArtifactCategoryLog is a ArtifactCategory enum value
	ArtifactCategoryLog = "LOG"
)

const (
	// ArtifactTypeUnknown is a ArtifactType enum value
	ArtifactTypeUnknown = "UNKNOWN"

	// ArtifactTypeScreenshot is a ArtifactType enum value
	ArtifactTypeScreenshot = "SCREENSHOT"

	// ArtifactTypeDeviceLog is a ArtifactType enum value
	ArtifactTypeDeviceLog = "DEVICE_LOG"

	// ArtifactTypeMessageLog is a ArtifactType enum value
	ArtifactTypeMessageLog = "MESSAGE_LOG"

	// ArtifactTypeVideoLog is a ArtifactType enum value
	ArtifactTypeVideoLog = "VIDEO_LOG"

	// ArtifactTypeResultLog is a ArtifactType enum value
	ArtifactTypeResultLog = "RESULT_LOG"

	// ArtifactTypeServiceLog is a ArtifactType enum value
	ArtifactTypeServiceLog = "SERVICE_LOG"

	// ArtifactTypeWebkitLog is a ArtifactType enum value
	ArtifactTypeWebkitLog = "WEBKIT_LOG"

	// ArtifactTypeInstrumentationOutput is a ArtifactType enum value
	ArtifactTypeInstrumentationOutput = "INSTRUMENTATION_OUTPUT"

	// ArtifactTypeExerciserMonkeyOutput is a ArtifactType enum value
	ArtifactTypeExerciserMonkeyOutput = "EXERCISER_MONKEY_OUTPUT"

	// ArtifactTypeCalabashJsonOutput is a ArtifactType enum value
	ArtifactTypeCalabashJsonOutput = "CALABASH_JSON_OUTPUT"

	// ArtifactTypeCalabashPrettyOutput is a ArtifactType enum value
	ArtifactTypeCalabashPrettyOutput = "CALABASH_PRETTY_OUTPUT"

	// ArtifactTypeCalabashStandardOutput is a ArtifactType enum value
	ArtifactTypeCalabashStandardOutput = "CALABASH_STANDARD_OUTPUT"

	// ArtifactTypeCalabashJavaXmlOutput is a ArtifactType enum value
	ArtifactTypeCalabashJavaXmlOutput = "CALABASH_JAVA_XML_OUTPUT"

	// ArtifactTypeAutomationOutput is a ArtifactType enum value
	ArtifactTypeAutomationOutput = "AUTOMATION_OUTPUT"

	// ArtifactTypeAppiumServerOutput is a ArtifactType enum value
	ArtifactTypeAppiumServerOutput = "APPIUM_SERVER_OUTPUT"

	// ArtifactTypeAppiumJavaOutput is a ArtifactType enum value
	ArtifactTypeAppiumJavaOutput = "APPIUM_JAVA_OUTPUT"

	// ArtifactTypeAppiumJavaXmlOutput is a ArtifactType enum value
	ArtifactTypeAppiumJavaXmlOutput = "APPIUM_JAVA_XML_OUTPUT"

	// ArtifactTypeAppiumPythonOutput is a ArtifactType enum value
	ArtifactTypeAppiumPythonOutput = "APPIUM_PYTHON_OUTPUT"

	// ArtifactTypeAppiumPythonXmlOutput is a ArtifactType enum value
	ArtifactTypeAppiumPythonXmlOutput = "APPIUM_PYTHON_XML_OUTPUT"

	// ArtifactTypeExplorerEventLog is a ArtifactType enum value
	ArtifactTypeExplorerEventLog = "EXPLORER_EVENT_LOG"

	// ArtifactTypeExplorerSummaryLog is a ArtifactType enum value
	ArtifactTypeExplorerSummaryLog = "EXPLORER_SUMMARY_LOG"

	// ArtifactTypeApplicationCrashReport is a ArtifactType enum value
	ArtifactTypeApplicationCrashReport = "APPLICATION_CRASH_REPORT"

	// ArtifactTypeXctestLog is a ArtifactType enum value
	ArtifactTypeXctestLog = "XCTEST_LOG"

	// ArtifactTypeVideo is a ArtifactType enum value
	ArtifactTypeVideo = "VIDEO"
)

const (
	// BillingMethodMetered is a BillingMethod enum value
	BillingMethodMetered = "METERED"

	// BillingMethodUnmetered is a BillingMethod enum value
	BillingMethodUnmetered = "UNMETERED"
)

const (
	// CurrencyCodeUsd is a CurrencyCode enum value
	CurrencyCodeUsd = "USD"
)

const (
	// DeviceAttributeArn is a DeviceAttribute enum value
	DeviceAttributeArn = "ARN"

	// DeviceAttributePlatform is a DeviceAttribute enum value
	DeviceAttributePlatform = "PLATFORM"

	// DeviceAttributeFormFactor is a DeviceAttribute enum value
	DeviceAttributeFormFactor = "FORM_FACTOR"

	// DeviceAttributeManufacturer is a DeviceAttribute enum value
	DeviceAttributeManufacturer = "MANUFACTURER"

	// DeviceAttributeRemoteAccessEnabled is a DeviceAttribute enum value
	DeviceAttributeRemoteAccessEnabled = "REMOTE_ACCESS_ENABLED"
)

const (
	// DeviceFormFactorPhone is a DeviceFormFactor enum value
	DeviceFormFactorPhone = "PHONE"

	// DeviceFormFactorTablet is a DeviceFormFactor enum value
	DeviceFormFactorTablet = "TABLET"
)

const (
	// DevicePlatformAndroid is a DevicePlatform enum value
	DevicePlatformAndroid = "ANDROID"

	// DevicePlatformIos is a DevicePlatform enum value
	DevicePlatformIos = "IOS"
)

const (
	// DevicePoolTypeCurated is a DevicePoolType enum value
	DevicePoolTypeCurated = "CURATED"

	// DevicePoolTypePrivate is a DevicePoolType enum value
	DevicePoolTypePrivate = "PRIVATE"
)

const (
	// ExecutionResultPending is a ExecutionResult enum value
	ExecutionResultPending = "PENDING"

	// ExecutionResultPassed is a ExecutionResult enum value
	ExecutionResultPassed = "PASSED"

	// ExecutionResultWarned is a ExecutionResult enum value
	ExecutionResultWarned = "WARNED"

	// ExecutionResultFailed is a ExecutionResult enum value
	ExecutionResultFailed = "FAILED"

	// ExecutionResultSkipped is a ExecutionResult enum value
	ExecutionResultSkipped = "SKIPPED"

	// ExecutionResultErrored is a ExecutionResult enum value
	ExecutionResultErrored = "ERRORED"

	// ExecutionResultStopped is a ExecutionResult enum value
	ExecutionResultStopped = "STOPPED"
)

const (
	// ExecutionStatusPending is a ExecutionStatus enum value
	ExecutionStatusPending = "PENDING"

	// ExecutionStatusPendingConcurrency is a ExecutionStatus enum value
	ExecutionStatusPendingConcurrency = "PENDING_CONCURRENCY"

	// ExecutionStatusPendingDevice is a ExecutionStatus enum value
	ExecutionStatusPendingDevice = "PENDING_DEVICE"

	// ExecutionStatusProcessing is a ExecutionStatus enum value
	ExecutionStatusProcessing = "PROCESSING"

	// ExecutionStatusScheduling is a ExecutionStatus enum value
	ExecutionStatusScheduling = "SCHEDULING"

	// ExecutionStatusPreparing is a ExecutionStatus enum value
	ExecutionStatusPreparing = "PREPARING"

	// ExecutionStatusRunning is a ExecutionStatus enum value
	ExecutionStatusRunning = "RUNNING"

	// ExecutionStatusCompleted is a ExecutionStatus enum value
	ExecutionStatusCompleted = "COMPLETED"

	// ExecutionStatusStopping is a ExecutionStatus enum value
	ExecutionStatusStopping = "STOPPING"
)

const (
	// OfferingTransactionTypePurchase is a OfferingTransactionType enum value
	OfferingTransactionTypePurchase = "PURCHASE"

	// OfferingTransactionTypeRenew is a OfferingTransactionType enum value
	OfferingTransactionTypeRenew = "RENEW"

	// OfferingTransactionTypeSystem is a OfferingTransactionType enum value
	OfferingTransactionTypeSystem = "SYSTEM"
)

const (
	// OfferingTypeRecurring is a OfferingType enum value
	OfferingTypeRecurring = "RECURRING"
)

const (
	// RecurringChargeFrequencyMonthly is a RecurringChargeFrequency enum value
	RecurringChargeFrequencyMonthly = "MONTHLY"
)

const (
	// RuleOperatorEquals is a RuleOperator enum value
	RuleOperatorEquals = "EQUALS"

	// RuleOperatorLessThan is a RuleOperator enum value
	RuleOperatorLessThan = "LESS_THAN"

	// RuleOperatorGreaterThan is a RuleOperator enum value
	RuleOperatorGreaterThan = "GREATER_THAN"

	// RuleOperatorIn is a RuleOperator enum value
	RuleOperatorIn = "IN"

	// RuleOperatorNotIn is a RuleOperator enum value
	RuleOperatorNotIn = "NOT_IN"
)

const (
	// SampleTypeCpu is a SampleType enum value
	SampleTypeCpu = "CPU"

	// SampleTypeMemory is a SampleType enum value
	SampleTypeMemory = "MEMORY"

	// SampleTypeThreads is a SampleType enum value
	SampleTypeThreads = "THREADS"

	// SampleTypeRxRate is a SampleType enum value
	SampleTypeRxRate = "RX_RATE"

	// SampleTypeTxRate is a SampleType enum value
	SampleTypeTxRate = "TX_RATE"

	// SampleTypeRx is a SampleType enum value
	SampleTypeRx = "RX"

	// SampleTypeTx is a SampleType enum value
	SampleTypeTx = "TX"

	// SampleTypeNativeFrames is a SampleType enum value
	SampleTypeNativeFrames = "NATIVE_FRAMES"

	// SampleTypeNativeFps is a SampleType enum value
	SampleTypeNativeFps = "NATIVE_FPS"

	// SampleTypeNativeMinDrawtime is a SampleType enum value
	SampleTypeNativeMinDrawtime = "NATIVE_MIN_DRAWTIME"

	// SampleTypeNativeAvgDrawtime is a SampleType enum value
	SampleTypeNativeAvgDrawtime = "NATIVE_AVG_DRAWTIME"

	// SampleTypeNativeMaxDrawtime is a SampleType enum value
	SampleTypeNativeMaxDrawtime = "NATIVE_MAX_DRAWTIME"

	// SampleTypeOpenglFrames is a SampleType enum value
	SampleTypeOpenglFrames = "OPENGL_FRAMES"

	// SampleTypeOpenglFps is a SampleType enum value
	SampleTypeOpenglFps = "OPENGL_FPS"

	// SampleTypeOpenglMinDrawtime is a SampleType enum value
	SampleTypeOpenglMinDrawtime = "OPENGL_MIN_DRAWTIME"

	// SampleTypeOpenglAvgDrawtime is a SampleType enum value
	SampleTypeOpenglAvgDrawtime = "OPENGL_AVG_DRAWTIME"

	// SampleTypeOpenglMaxDrawtime is a SampleType enum value
	SampleTypeOpenglMaxDrawtime = "OPENGL_MAX_DRAWTIME"
)

const (
	// TestTypeBuiltinFuzz is a TestType enum value
	TestTypeBuiltinFuzz = "BUILTIN_FUZZ"

	// TestTypeBuiltinExplorer is a TestType enum value
	TestTypeBuiltinExplorer = "BUILTIN_EXPLORER"

	// TestTypeAppiumJavaJunit is a TestType enum value
	TestTypeAppiumJavaJunit = "APPIUM_JAVA_JUNIT"

	// TestTypeAppiumJavaTestng is a TestType enum value
	TestTypeAppiumJavaTestng = "APPIUM_JAVA_TESTNG"

	// TestTypeAppiumPython is a TestType enum value
	TestTypeAppiumPython = "APPIUM_PYTHON"

	// TestTypeAppiumWebJavaJunit is a TestType enum value
	TestTypeAppiumWebJavaJunit = "APPIUM_WEB_JAVA_JUNIT"

	// TestTypeAppiumWebJavaTestng is a TestType enum value
	TestTypeAppiumWebJavaTestng = "APPIUM_WEB_JAVA_TESTNG"

	// TestTypeAppiumWebPython is a TestType enum value
	TestTypeAppiumWebPython = "APPIUM_WEB_PYTHON"

	// TestTypeCalabash is a TestType enum value
	TestTypeCalabash = "CALABASH"

	// TestTypeInstrumentation is a TestType enum value
	TestTypeInstrumentation = "INSTRUMENTATION"

	// TestTypeUiautomation is a TestType enum value
	TestTypeUiautomation = "UIAUTOMATION"

	// TestTypeUiautomator is a TestType enum value
	TestTypeUiautomator = "UIAUTOMATOR"

	// TestTypeXctest is a TestType enum value
	TestTypeXctest = "XCTEST"

	// TestTypeXctestUi is a TestType enum value
	TestTypeXctestUi = "XCTEST_UI"
)

const (
	// UploadStatusInitialized is a UploadStatus enum value
	UploadStatusInitialized = "INITIALIZED"

	// UploadStatusProcessing is a UploadStatus enum value
	UploadStatusProcessing = "PROCESSING"

	// UploadStatusSucceeded is a UploadStatus enum value
	UploadStatusSucceeded = "SUCCEEDED"

	// UploadStatusFailed is a UploadStatus enum value
	UploadStatusFailed = "FAILED"
)

const (
	// UploadTypeAndroidApp is a UploadType enum value
	UploadTypeAndroidApp = "ANDROID_APP"

	// UploadTypeIosApp is a UploadType enum value
	UploadTypeIosApp = "IOS_APP"

	// UploadTypeWebApp is a UploadType enum value
	UploadTypeWebApp = "WEB_APP"

	// UploadTypeExternalData is a UploadType enum value
	UploadTypeExternalData = "EXTERNAL_DATA"

	// UploadTypeAppiumJavaJunitTestPackage is a UploadType enum value
	UploadTypeAppiumJavaJunitTestPackage = "APPIUM_JAVA_JUNIT_TEST_PACKAGE"

	// UploadTypeAppiumJavaTestngTestPackage is a UploadType enum value
	UploadTypeAppiumJavaTestngTestPackage = "APPIUM_JAVA_TESTNG_TEST_PACKAGE"

	// UploadTypeAppiumPythonTestPackage is a UploadType enum value
	UploadTypeAppiumPythonTestPackage = "APPIUM_PYTHON_TEST_PACKAGE"

	// UploadTypeAppiumWebJavaJunitTestPackage is a UploadType enum value
	UploadTypeAppiumWebJavaJunitTestPackage = "APPIUM_WEB_JAVA_JUNIT_TEST_PACKAGE"

	// UploadTypeAppiumWebJavaTestngTestPackage is a UploadType enum value
	UploadTypeAppiumWebJavaTestngTestPackage = "APPIUM_WEB_JAVA_TESTNG_TEST_PACKAGE"

	// UploadTypeAppiumWebPythonTestPackage is a UploadType enum value
	UploadTypeAppiumWebPythonTestPackage = "APPIUM_WEB_PYTHON_TEST_PACKAGE"

	// UploadTypeCalabashTestPackage is a UploadType enum value
	UploadTypeCalabashTestPackage = "CALABASH_TEST_PACKAGE"

	// UploadTypeInstrumentationTestPackage is a UploadType enum value
	UploadTypeInstrumentationTestPackage = "INSTRUMENTATION_TEST_PACKAGE"

	// UploadTypeUiautomationTestPackage is a UploadType enum value
	UploadTypeUiautomationTestPackage = "UIAUTOMATION_TEST_PACKAGE"

	// UploadTypeUiautomatorTestPackage is a UploadType enum value
	UploadTypeUiautomatorTestPackage = "UIAUTOMATOR_TEST_PACKAGE"

	// UploadTypeXctestTestPackage is a UploadType enum value
	UploadTypeXctestTestPackage = "XCTEST_TEST_PACKAGE"

	// UploadTypeXctestUiTestPackage is a UploadType enum value
	UploadTypeXctestUiTestPackage = "XCTEST_UI_TEST_PACKAGE"
)
