// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package directconnect provides a client for AWS Direct Connect.
package directconnect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAllocateConnectionOnInterconnect = "AllocateConnectionOnInterconnect"

// AllocateConnectionOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the AllocateConnectionOnInterconnect operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AllocateConnectionOnInterconnect for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AllocateConnectionOnInterconnect method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AllocateConnectionOnInterconnectRequest method.
//    req, resp := client.AllocateConnectionOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
func (c *DirectConnect) AllocateConnectionOnInterconnectRequest(input *AllocateConnectionOnInterconnectInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAllocateConnectionOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateConnectionOnInterconnectInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateConnectionOnInterconnect API operation for AWS Direct Connect.
//
// Creates a hosted connection on an interconnect.
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the given interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocateConnectionOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnect
func (c *DirectConnect) AllocateConnectionOnInterconnect(input *AllocateConnectionOnInterconnectInput) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opAllocatePrivateVirtualInterface = "AllocatePrivateVirtualInterface"

// AllocatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePrivateVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AllocatePrivateVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AllocatePrivateVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AllocatePrivateVirtualInterfaceRequest method.
//    req, resp := client.AllocatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterfaceRequest(input *AllocatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a private virtual interface to be owned by a different customer.
//
// The owner of a connection calls this function to provision a private virtual
// interface which will be owned by another AWS customer.
//
// Virtual interfaces created using this function must be confirmed by the virtual
// interface owner by calling ConfirmPrivateVirtualInterface. Until this step
// has been completed, the virtual interface will be in 'Confirming' state,
// and will not be available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterface
func (c *DirectConnect) AllocatePrivateVirtualInterface(input *AllocatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opAllocatePublicVirtualInterface = "AllocatePublicVirtualInterface"

// AllocatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the AllocatePublicVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AllocatePublicVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AllocatePublicVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AllocatePublicVirtualInterfaceRequest method.
//    req, resp := client.AllocatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterfaceRequest(input *AllocatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// AllocatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Provisions a public virtual interface to be owned by a different customer.
//
// The owner of a connection calls this function to provision a public virtual
// interface which will be owned by another AWS customer.
//
// Virtual interfaces created using this function must be confirmed by the virtual
// interface owner by calling ConfirmPublicVirtualInterface. Until this step
// has been completed, the virtual interface will be in 'Confirming' state,
// and will not be available for handling traffic.
//
// When creating an IPv6 public virtual interface (addressFamily is 'ipv6'),
// the customer and amazon address fields should be left blank to use auto-assigned
// IPv6 space. Custom IPv6 Addresses are currently not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation AllocatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterface
func (c *DirectConnect) AllocatePublicVirtualInterface(input *AllocatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmConnection = "ConfirmConnection"

// ConfirmConnectionRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmConnectionRequest method.
//    req, resp := client.ConfirmConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnectionRequest(input *ConfirmConnectionInput) (req *request.Request, output *ConfirmConnectionOutput) {
	op := &request.Operation{
		Name:       opConfirmConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmConnectionInput{}
	}

	output = &ConfirmConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmConnection API operation for AWS Direct Connect.
//
// Confirm the creation of a hosted connection on an interconnect.
//
// Upon creation, the hosted connection is initially in the 'Ordering' state,
// and will remain in this state until the owner calls ConfirmConnection to
// confirm creation of the hosted connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnection
func (c *DirectConnect) ConfirmConnection(input *ConfirmConnectionInput) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmPrivateVirtualInterface = "ConfirmPrivateVirtualInterface"

// ConfirmPrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPrivateVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmPrivateVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmPrivateVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmPrivateVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceRequest(input *ConfirmPrivateVirtualInterfaceInput) (req *request.Request, output *ConfirmPrivateVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPrivateVirtualInterfaceInput{}
	}

	output = &ConfirmPrivateVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPrivateVirtualInterface API operation for AWS Direct Connect.
//
// Accept ownership of a private virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the virtual interface
// will be created and attached to the given virtual private gateway, and will
// be available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterface
func (c *DirectConnect) ConfirmPrivateVirtualInterface(input *ConfirmPrivateVirtualInterfaceInput) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmPublicVirtualInterface = "ConfirmPublicVirtualInterface"

// ConfirmPublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmPublicVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmPublicVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmPublicVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmPublicVirtualInterfaceRequest method.
//    req, resp := client.ConfirmPublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterfaceRequest(input *ConfirmPublicVirtualInterfaceInput) (req *request.Request, output *ConfirmPublicVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPublicVirtualInterfaceInput{}
	}

	output = &ConfirmPublicVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmPublicVirtualInterface API operation for AWS Direct Connect.
//
// Accept ownership of a public virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the specified virtual
// interface will be created and made available for handling traffic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation ConfirmPublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterface
func (c *DirectConnect) ConfirmPublicVirtualInterface(input *ConfirmPublicVirtualInterfaceInput) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBGPPeer = "CreateBGPPeer"

// CreateBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the CreateBGPPeer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateBGPPeer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateBGPPeer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateBGPPeerRequest method.
//    req, resp := client.CreateBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeerRequest(input *CreateBGPPeerInput) (req *request.Request, output *CreateBGPPeerOutput) {
	op := &request.Operation{
		Name:       opCreateBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBGPPeerInput{}
	}

	output = &CreateBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBGPPeer API operation for AWS Direct Connect.
//
// Creates a new BGP peer on a specified virtual interface. The BGP peer cannot
// be in the same address family (IPv4/IPv6) of an existing BGP peer on the
// virtual interface.
//
// You must create a BGP peer for the corresponding address family in order
// to access AWS resources that also use that address family.
//
// When creating a IPv6 BGP peer, the Amazon address and customer address fields
// must be left blank. IPv6 addresses are automatically assigned from Amazon's
// pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
//
// For a public virtual interface, the Autonomous System Number (ASN) must be
// private or already whitelisted for the virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeer
func (c *DirectConnect) CreateBGPPeer(input *CreateBGPPeerInput) (*CreateBGPPeerOutput, error) {
	req, out := c.CreateBGPPeerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS Direct Connect.
//
// Creates a new connection between the customer network and a specific AWS
// Direct Connect location.
//
// A connection links your internal network to an AWS Direct Connect location
// over a standard 1 gigabit or 10 gigabit Ethernet fiber-optic cable. One end
// of the cable is connected to your router, the other to an AWS Direct Connect
// router. An AWS Direct Connect location provides access to Amazon Web Services
// in the region it is associated with. You can establish connections with AWS
// Direct Connect locations in multiple regions, but a connection in one region
// does not provide connectivity to other regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnection
func (c *DirectConnect) CreateConnection(input *CreateConnectionInput) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInterconnect = "CreateInterconnect"

// CreateInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateInterconnect operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateInterconnect for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateInterconnect method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateInterconnectRequest method.
//    req, resp := client.CreateInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnectRequest(input *CreateInterconnectInput) (req *request.Request, output *Interconnect) {
	op := &request.Operation{
		Name:       opCreateInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInterconnectInput{}
	}

	output = &Interconnect{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInterconnect API operation for AWS Direct Connect.
//
// Creates a new interconnect between a AWS Direct Connect partner's network
// and a specific AWS Direct Connect location.
//
// An interconnect is a connection which is capable of hosting other connections.
// The AWS Direct Connect partner can use an interconnect to provide sub-1Gbps
// AWS Direct Connect service to tier 2 customers who do not have their own
// connections. Like a standard connection, an interconnect links the AWS Direct
// Connect partner's network to an AWS Direct Connect location over a standard
// 1 Gbps or 10 Gbps Ethernet fiber-optic cable. One end is connected to the
// partner's router, the other to an AWS Direct Connect router.
//
// For each end customer, the AWS Direct Connect partner provisions a connection
// on their interconnect by calling AllocateConnectionOnInterconnect. The end
// customer can then connect to AWS resources by creating a virtual interface
// on their connection, using the VLAN assigned to them by the AWS Direct Connect
// partner.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreateInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnect
func (c *DirectConnect) CreateInterconnect(input *CreateInterconnectInput) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePrivateVirtualInterface = "CreatePrivateVirtualInterface"

// CreatePrivateVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivateVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePrivateVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePrivateVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePrivateVirtualInterfaceRequest method.
//    req, resp := client.CreatePrivateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterfaceRequest(input *CreatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivateVirtualInterface API operation for AWS Direct Connect.
//
// Creates a new private virtual interface. A virtual interface is the VLAN
// that transports AWS Direct Connect traffic. A private virtual interface supports
// sending traffic to a single virtual private cloud (VPC).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePrivateVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterface
func (c *DirectConnect) CreatePrivateVirtualInterface(input *CreatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePublicVirtualInterface = "CreatePublicVirtualInterface"

// CreatePublicVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePublicVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePublicVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePublicVirtualInterfaceRequest method.
//    req, resp := client.CreatePublicVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterfaceRequest(input *CreatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicVirtualInterfaceInput{}
	}

	output = &VirtualInterface{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicVirtualInterface API operation for AWS Direct Connect.
//
// Creates a new public virtual interface. A virtual interface is the VLAN that
// transports AWS Direct Connect traffic. A public virtual interface supports
// sending traffic to public services of AWS such as Amazon Simple Storage Service
// (Amazon S3).
//
// When creating an IPv6 public virtual interface (addressFamily is 'ipv6'),
// the customer and amazon address fields should be left blank to use auto-assigned
// IPv6 space. Custom IPv6 Addresses are currently not supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation CreatePublicVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterface
func (c *DirectConnect) CreatePublicVirtualInterface(input *CreatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBGPPeer = "DeleteBGPPeer"

// DeleteBGPPeerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBGPPeer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBGPPeer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBGPPeer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBGPPeerRequest method.
//    req, resp := client.DeleteBGPPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeerRequest(input *DeleteBGPPeerInput) (req *request.Request, output *DeleteBGPPeerOutput) {
	op := &request.Operation{
		Name:       opDeleteBGPPeer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBGPPeerInput{}
	}

	output = &DeleteBGPPeerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBGPPeer API operation for AWS Direct Connect.
//
// Deletes a BGP peer on the specified virtual interface that matches the specified
// customer address and ASN. You cannot delete the last BGP peer from a virtual
// interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteBGPPeer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeer
func (c *DirectConnect) DeleteBGPPeer(input *DeleteBGPPeerInput) (*DeleteBGPPeerOutput, error) {
	req, out := c.DeleteBGPPeerRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteConnection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteConnection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &Connection{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Direct Connect.
//
// Deletes the connection.
//
// Deleting a connection only stops the AWS Direct Connect port hour and data
// transfer charges. You need to cancel separately with the providers any services
// or charges for cross-connects or network circuits that connect you to the
// AWS Direct Connect location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnection
func (c *DirectConnect) DeleteConnection(input *DeleteConnectionInput) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInterconnect = "DeleteInterconnect"

// DeleteInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInterconnect operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteInterconnect for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteInterconnect method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteInterconnectRequest method.
//    req, resp := client.DeleteInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnectRequest(input *DeleteInterconnectInput) (req *request.Request, output *DeleteInterconnectOutput) {
	op := &request.Operation{
		Name:       opDeleteInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInterconnectInput{}
	}

	output = &DeleteInterconnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInterconnect API operation for AWS Direct Connect.
//
// Deletes the specified interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnect
func (c *DirectConnect) DeleteInterconnect(input *DeleteInterconnectInput) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVirtualInterface = "DeleteVirtualInterface"

// DeleteVirtualInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualInterface operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVirtualInterface for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVirtualInterface method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVirtualInterfaceRequest method.
//    req, resp := client.DeleteVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterfaceRequest(input *DeleteVirtualInterfaceInput) (req *request.Request, output *DeleteVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualInterfaceInput{}
	}

	output = &DeleteVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVirtualInterface API operation for AWS Direct Connect.
//
// Deletes a virtual interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DeleteVirtualInterface for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterface
func (c *DirectConnect) DeleteVirtualInterface(input *DeleteVirtualInterfaceInput) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnectionLoa = "DescribeConnectionLoa"

// DescribeConnectionLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionLoa operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConnectionLoa for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConnectionLoa method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConnectionLoaRequest method.
//    req, resp := client.DescribeConnectionLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
func (c *DirectConnect) DescribeConnectionLoaRequest(input *DescribeConnectionLoaInput) (req *request.Request, output *DescribeConnectionLoaOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectionLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionLoaInput{}
	}

	output = &DescribeConnectionLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionLoa API operation for AWS Direct Connect.
//
// Returns the LOA-CFA for a Connection.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that your APN partner or service provider uses when establishing
// your cross connect to AWS at the colocation facility. For more information,
// see Requesting Cross Connects at AWS Direct Connect Locations (http://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoa
func (c *DirectConnect) DescribeConnectionLoa(input *DescribeConnectionLoaInput) (*DescribeConnectionLoaOutput, error) {
	req, out := c.DescribeConnectionLoaRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConnections for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConnections method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Direct Connect.
//
// Displays all connections in this region.
//
// If a connection ID is provided, the call returns only that particular connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnections
func (c *DirectConnect) DescribeConnections(input *DescribeConnectionsInput) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnectionsOnInterconnect = "DescribeConnectionsOnInterconnect"

// DescribeConnectionsOnInterconnectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionsOnInterconnect operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConnectionsOnInterconnect for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConnectionsOnInterconnect method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConnectionsOnInterconnectRequest method.
//    req, resp := client.DescribeConnectionsOnInterconnectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
func (c *DirectConnect) DescribeConnectionsOnInterconnectRequest(input *DescribeConnectionsOnInterconnectInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnectionsOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsOnInterconnectInput{}
	}

	output = &Connections{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionsOnInterconnect API operation for AWS Direct Connect.
//
// Return a list of connections that have been provisioned on the given interconnect.
//
// This is intended for use by AWS Direct Connect partners only.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeConnectionsOnInterconnect for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnect
func (c *DirectConnect) DescribeConnectionsOnInterconnect(input *DescribeConnectionsOnInterconnectInput) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInterconnectLoa = "DescribeInterconnectLoa"

// DescribeInterconnectLoaRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnectLoa operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInterconnectLoa for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInterconnectLoa method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInterconnectLoaRequest method.
//    req, resp := client.DescribeInterconnectLoaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
func (c *DirectConnect) DescribeInterconnectLoaRequest(input *DescribeInterconnectLoaInput) (req *request.Request, output *DescribeInterconnectLoaOutput) {
	op := &request.Operation{
		Name:       opDescribeInterconnectLoa,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectLoaInput{}
	}

	output = &DescribeInterconnectLoaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnectLoa API operation for AWS Direct Connect.
//
// Returns the LOA-CFA for an Interconnect.
//
// The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is
// a document that is used when establishing your cross connect to AWS at the
// colocation facility. For more information, see Requesting Cross Connects
// at AWS Direct Connect Locations (http://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html)
// in the AWS Direct Connect user guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnectLoa for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoa
func (c *DirectConnect) DescribeInterconnectLoa(input *DescribeInterconnectLoaInput) (*DescribeInterconnectLoaOutput, error) {
	req, out := c.DescribeInterconnectLoaRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInterconnects = "DescribeInterconnects"

// DescribeInterconnectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInterconnects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeInterconnects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeInterconnects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeInterconnectsRequest method.
//    req, resp := client.DescribeInterconnectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnectsRequest(input *DescribeInterconnectsInput) (req *request.Request, output *DescribeInterconnectsOutput) {
	op := &request.Operation{
		Name:       opDescribeInterconnects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectsInput{}
	}

	output = &DescribeInterconnectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInterconnects API operation for AWS Direct Connect.
//
// Returns a list of interconnects owned by the AWS account.
//
// If an interconnect ID is provided, it will only return this particular interconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeInterconnects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnects
func (c *DirectConnect) DescribeInterconnects(input *DescribeInterconnectsInput) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLocations = "DescribeLocations"

// DescribeLocationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLocations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLocations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLocations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLocationsRequest method.
//    req, resp := client.DescribeLocationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocationsRequest(input *DescribeLocationsInput) (req *request.Request, output *DescribeLocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationsInput{}
	}

	output = &DescribeLocationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLocations API operation for AWS Direct Connect.
//
// Returns the list of AWS Direct Connect locations in the current AWS region.
// These are the locations that may be selected when calling CreateConnection
// or CreateInterconnect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeLocations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocations
func (c *DirectConnect) DescribeLocations(input *DescribeLocationsInput) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for AWS Direct Connect.
//
// Describes the tags associated with the specified Direct Connect resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTags
func (c *DirectConnect) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVirtualGateways = "DescribeVirtualGateways"

// DescribeVirtualGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVirtualGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVirtualGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVirtualGatewaysRequest method.
//    req, resp := client.DescribeVirtualGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGatewaysRequest(input *DescribeVirtualGatewaysInput) (req *request.Request, output *DescribeVirtualGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualGatewaysInput{}
	}

	output = &DescribeVirtualGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualGateways API operation for AWS Direct Connect.
//
// Returns a list of virtual private gateways owned by the AWS account.
//
// You can create one or more AWS Direct Connect private virtual interfaces
// linking to a virtual private gateway. A virtual private gateway can be managed
// via Amazon Virtual Private Cloud (VPC) console or the EC2 CreateVpnGateway
// (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGateways
func (c *DirectConnect) DescribeVirtualGateways(input *DescribeVirtualGatewaysInput) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVirtualInterfaces = "DescribeVirtualInterfaces"

// DescribeVirtualInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVirtualInterfaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVirtualInterfaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVirtualInterfaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVirtualInterfacesRequest method.
//    req, resp := client.DescribeVirtualInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfacesRequest(input *DescribeVirtualInterfacesInput) (req *request.Request, output *DescribeVirtualInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualInterfacesInput{}
	}

	output = &DescribeVirtualInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVirtualInterfaces API operation for AWS Direct Connect.
//
// Displays all virtual interfaces for an AWS account. Virtual interfaces deleted
// fewer than 15 minutes before DescribeVirtualInterfaces is called are also
// returned. If a connection ID is included then only virtual interfaces associated
// with this connection will be returned. If a virtual interface ID is included
// then only a single virtual interface will be returned.
//
// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer.
//
// If a connection ID is provided, only virtual interfaces provisioned on the
// specified connection will be returned. If a virtual interface ID is provided,
// only this particular virtual interface will be returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation DescribeVirtualInterfaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfaces
func (c *DirectConnect) DescribeVirtualInterfaces(input *DescribeVirtualInterfacesInput) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	err := req.Send()
	return out, err
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TagResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TagResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for AWS Direct Connect.
//
// Adds the specified tags to the specified Direct Connect resource. Each Direct
// Connect resource can have a maximum of 50 tags.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the Direct Connect resource, this action updates
// its value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateTagKeysException "DuplicateTagKeysException"
//   A tag key was specified more than once.
//
//   * ErrCodeTooManyTagsException "TooManyTagsException"
//   You have reached the limit on the number of tags that can be assigned to
//   a Direct Connect resource.
//
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResource
func (c *DirectConnect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	err := req.Send()
	return out, err
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UntagResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UntagResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for AWS Direct Connect.
//
// Removes one or more tags from the specified Direct Connect resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Direct Connect's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServerException "ServerException"
//   A server-side error occurred during the API call. The error message will
//   contain additional details about the cause.
//
//   * ErrCodeClientException "ClientException"
//   The API was called with invalid parameters. The error message will contain
//   additional details about the cause.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResource
func (c *DirectConnect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	err := req.Send()
	return out, err
}

// Container for the parameters to the AllocateConnectionOnInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocateConnectionOnInterconnectRequest
type AllocateConnectionOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: "500Mbps"
	//
	// Default: None
	//
	// Values: 50M, 100M, 200M, 300M, 400M, or 500M
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// Name of the provisioned connection.
	//
	// Example: "500M Connection to AWS"
	//
	// Default: None
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// ID of the interconnect on which the connection will be provisioned.
	//
	// Example: dxcon-456abc78
	//
	// Default: None
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// Numeric account Id of the customer for whom the connection will be provisioned.
	//
	// Example: 123443215678
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the connection.
	//
	// Example: 101
	//
	// Default: None
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateConnectionOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateConnectionOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateConnectionOnInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateConnectionOnInterconnectInput) SetBandwidth(v string) *AllocateConnectionOnInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *AllocateConnectionOnInterconnectInput) SetConnectionName(v string) *AllocateConnectionOnInterconnectInput {
	s.ConnectionName = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *AllocateConnectionOnInterconnectInput) SetInterconnectId(v string) *AllocateConnectionOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocateConnectionOnInterconnectInput) SetOwnerAccount(v string) *AllocateConnectionOnInterconnectInput {
	s.OwnerAccount = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *AllocateConnectionOnInterconnectInput) SetVlan(v int64) *AllocateConnectionOnInterconnectInput {
	s.Vlan = &v
	return s
}

// Container for the parameters to the AllocatePrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePrivateVirtualInterfaceRequest
type AllocatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The connection ID on which the private virtual interface is provisioned.
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be provisioned.
	//
	// Default: None
	//
	// NewPrivateVirtualInterfaceAllocation is a required field
	NewPrivateVirtualInterfaceAllocation *NewPrivateVirtualInterfaceAllocation `locationName:"newPrivateVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new private virtual interface.
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPrivateVirtualInterfaceAllocation != nil {
		if err := s.NewPrivateVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetConnectionId(v string) *AllocatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterfaceAllocation sets the NewPrivateVirtualInterfaceAllocation field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterfaceAllocation(v *NewPrivateVirtualInterfaceAllocation) *AllocatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePrivateVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePrivateVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

// Container for the parameters to the AllocatePublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/AllocatePublicVirtualInterfaceRequest
type AllocatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// The connection ID on which the public virtual interface is provisioned.
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be provisioned.
	//
	// Default: None
	//
	// NewPublicVirtualInterfaceAllocation is a required field
	NewPublicVirtualInterfaceAllocation *NewPublicVirtualInterfaceAllocation `locationName:"newPublicVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new public virtual interface.
	//
	// Default: None
	//
	// OwnerAccount is a required field
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterfaceAllocation == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterfaceAllocation"))
	}
	if s.OwnerAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerAccount"))
	}
	if s.NewPublicVirtualInterfaceAllocation != nil {
		if err := s.NewPublicVirtualInterfaceAllocation.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterfaceAllocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetConnectionId(v string) *AllocatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterfaceAllocation sets the NewPublicVirtualInterfaceAllocation field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetNewPublicVirtualInterfaceAllocation(v *NewPublicVirtualInterfaceAllocation) *AllocatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterfaceAllocation = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *AllocatePublicVirtualInterfaceInput) SetOwnerAccount(v string) *AllocatePublicVirtualInterfaceInput {
	s.OwnerAccount = &v
	return s
}

// A structure containing information about a BGP peer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/BGPPeer
type BGPPeer struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// The state of the BGP peer.
	//
	//    * Verifying: The BGP peering addresses or ASN require validation before
	//    the BGP peer can be created. This state only applies to BGP peers on a
	//    public virtual interface.
	//
	//    * Pending: The BGP peer has been created, and is in this state until it
	//    is ready to be established.
	//
	//    * Available: The BGP peer can be established.
	//
	//    * Deleting: The BGP peer is in the process of being deleted.
	//
	//    * Deleted: The BGP peer has been deleted and cannot be established.
	BgpPeerState *string `locationName:"bgpPeerState" type:"string" enum:"BGPPeerState"`

	// The Up/Down state of the BGP peer.
	//
	//    * Up: The BGP peer is established.
	//
	//    * Down: The BGP peer is down.
	BgpStatus *string `locationName:"bgpStatus" type:"string" enum:"BGPStatus"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s BGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *BGPPeer) SetAddressFamily(v string) *BGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *BGPPeer) SetAmazonAddress(v string) *BGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *BGPPeer) SetAsn(v int64) *BGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *BGPPeer) SetAuthKey(v string) *BGPPeer {
	s.AuthKey = &v
	return s
}

// SetBgpPeerState sets the BgpPeerState field's value.
func (s *BGPPeer) SetBgpPeerState(v string) *BGPPeer {
	s.BgpPeerState = &v
	return s
}

// SetBgpStatus sets the BgpStatus field's value.
func (s *BGPPeer) SetBgpStatus(v string) *BGPPeer {
	s.BgpStatus = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *BGPPeer) SetCustomerAddress(v string) *BGPPeer {
	s.CustomerAddress = &v
	return s
}

// Container for the parameters to the ConfirmConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnectionRequest
type ConfirmConnectionInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *ConfirmConnectionInput) SetConnectionId(v string) *ConfirmConnectionInput {
	s.ConnectionId = &v
	return s
}

// The response received when ConfirmConnection is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmConnectionResponse
type ConfirmConnectionOutput struct {
	_ struct{} `type:"structure"`

	// State of the connection.
	//
	//    * Ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * Requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * Pending: The connection has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the connection is ready for use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The connection is in the process of being deleted.
	//
	//    * Deleted: The connection has been deleted.
	//
	//    * Rejected: A hosted connection in the 'Ordering' state will enter the
	//    'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`
}

// String returns the string representation
func (s ConfirmConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *ConfirmConnectionOutput) SetConnectionState(v string) *ConfirmConnectionOutput {
	s.ConnectionState = &v
	return s
}

// Container for the parameters to the ConfirmPrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterfaceRequest
type ConfirmPrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the virtual private gateway that will be attached to the virtual interface.
	//
	// A virtual private gateway can be managed via the Amazon Virtual Private Cloud
	// (VPC) console or the EC2 CreateVpnGateway (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
	// action.
	//
	// Default: None
	//
	// VirtualGatewayId is a required field
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPrivateVirtualInterfaceInput"}
	if s.VirtualGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayId"))
	}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualGatewayId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPrivateVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPrivateVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when ConfirmPrivateVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPrivateVirtualInterfaceResponse
type ConfirmPrivateVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPrivateVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPrivateVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// Container for the parameters to the ConfirmPublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterfaceRequest
type ConfirmPublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmPublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmPublicVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *ConfirmPublicVirtualInterfaceInput) SetVirtualInterfaceId(v string) *ConfirmPublicVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when ConfirmPublicVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ConfirmPublicVirtualInterfaceResponse
type ConfirmPublicVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *ConfirmPublicVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *ConfirmPublicVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// A connection represents the physical network connection between the AWS Direct
// Connect location and the customer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connection
type Connection struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps (for regular connections), or 500Mbps (for hosted connections)
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// State of the connection.
	//
	//    * Ordering: The initial state of a hosted connection provisioned on an
	//    interconnect. The connection stays in the ordering state until the owner
	//    of the hosted connection confirms or declines the connection order.
	//
	//    * Requested: The initial state of a standard connection. The connection
	//    stays in the requested state until the Letter of Authorization (LOA) is
	//    sent to the customer.
	//
	//    * Pending: The connection has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the connection is ready for use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The connection is in the process of being deleted.
	//
	//    * Deleted: The connection has been deleted.
	//
	//    * Rejected: A hosted connection in the 'Ordering' state will enter the
	//    'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`

	// The time of the most recent call to DescribeConnectionLoa for this Connection.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp" timestampFormat:"unix"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS account that will own the new connection.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the AWS Direct Connect service provider associated with the connection.
	PartnerName *string `locationName:"partnerName" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Connection) SetBandwidth(v string) *Connection {
	s.Bandwidth = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *Connection) SetConnectionId(v string) *Connection {
	s.ConnectionId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *Connection) SetConnectionName(v string) *Connection {
	s.ConnectionName = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *Connection) SetConnectionState(v string) *Connection {
	s.ConnectionState = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Connection) SetLoaIssueTime(v time.Time) *Connection {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Connection) SetLocation(v string) *Connection {
	s.Location = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Connection) SetOwnerAccount(v string) *Connection {
	s.OwnerAccount = &v
	return s
}

// SetPartnerName sets the PartnerName field's value.
func (s *Connection) SetPartnerName(v string) *Connection {
	s.PartnerName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Connection) SetRegion(v string) *Connection {
	s.Region = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *Connection) SetVlan(v int64) *Connection {
	s.Vlan = &v
	return s
}

// A structure containing a list of connections.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Connections
type Connections struct {
	_ struct{} `type:"structure"`

	// A list of connections.
	Connections []*Connection `locationName:"connections" type:"list"`
}

// String returns the string representation
func (s Connections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connections) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *Connections) SetConnections(v []*Connection) *Connections {
	s.Connections = v
	return s
}

// Container for the parameters to the CreateBGPPeer operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeerRequest
type CreateBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// Detailed information for the BGP peer to be created.
	//
	// Default: None
	NewBGPPeer *NewBGPPeer `locationName:"newBGPPeer" type:"structure"`

	// The ID of the virtual interface on which the BGP peer will be provisioned.
	//
	// Example: dxvif-456abc78
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s CreateBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerInput) GoString() string {
	return s.String()
}

// SetNewBGPPeer sets the NewBGPPeer field's value.
func (s *CreateBGPPeerInput) SetNewBGPPeer(v *NewBGPPeer) *CreateBGPPeerInput {
	s.NewBGPPeer = v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *CreateBGPPeerInput) SetVirtualInterfaceId(v string) *CreateBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when CreateBGPPeer is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateBGPPeerResponse
type CreateBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
	// location and the customer.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s CreateBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *CreateBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *CreateBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

// Container for the parameters to the CreateConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateConnectionRequest
type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	//
	// ConnectionName is a required field
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateConnectionInput) SetBandwidth(v string) *CreateConnectionInput {
	s.Bandwidth = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *CreateConnectionInput) SetConnectionName(v string) *CreateConnectionInput {
	s.ConnectionName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateConnectionInput) SetLocation(v string) *CreateConnectionInput {
	s.Location = &v
	return s
}

// Container for the parameters to the CreateInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreateInterconnectRequest
type CreateInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The port bandwidth
	//
	// Example: 1Gbps
	//
	// Default: None
	//
	// Available values: 1Gbps,10Gbps
	//
	// Bandwidth is a required field
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	//
	// Default: None
	//
	// InterconnectName is a required field
	InterconnectName *string `locationName:"interconnectName" type:"string" required:"true"`

	// Where the interconnect is located
	//
	// Example: EqSV5
	//
	// Default: None
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInterconnectInput"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.InterconnectName == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectName"))
	}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *CreateInterconnectInput) SetBandwidth(v string) *CreateInterconnectInput {
	s.Bandwidth = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *CreateInterconnectInput) SetInterconnectName(v string) *CreateInterconnectInput {
	s.InterconnectName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CreateInterconnectInput) SetLocation(v string) *CreateInterconnectInput {
	s.Location = &v
	return s
}

// Container for the parameters to the CreatePrivateVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePrivateVirtualInterfaceRequest
type CreatePrivateVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be created.
	//
	// Default: None
	//
	// NewPrivateVirtualInterface is a required field
	NewPrivateVirtualInterface *NewPrivateVirtualInterface `locationName:"newPrivateVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPrivateVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPrivateVirtualInterface"))
	}
	if s.NewPrivateVirtualInterface != nil {
		if err := s.NewPrivateVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPrivateVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetConnectionId(v string) *CreatePrivateVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPrivateVirtualInterface sets the NewPrivateVirtualInterface field's value.
func (s *CreatePrivateVirtualInterfaceInput) SetNewPrivateVirtualInterface(v *NewPrivateVirtualInterface) *CreatePrivateVirtualInterfaceInput {
	s.NewPrivateVirtualInterface = v
	return s
}

// Container for the parameters to the CreatePublicVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/CreatePublicVirtualInterfaceRequest
type CreatePublicVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be created.
	//
	// Default: None
	//
	// NewPublicVirtualInterface is a required field
	NewPublicVirtualInterface *NewPublicVirtualInterface `locationName:"newPublicVirtualInterface" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicVirtualInterfaceInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}
	if s.NewPublicVirtualInterface == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPublicVirtualInterface"))
	}
	if s.NewPublicVirtualInterface != nil {
		if err := s.NewPublicVirtualInterface.Validate(); err != nil {
			invalidParams.AddNested("NewPublicVirtualInterface", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *CreatePublicVirtualInterfaceInput) SetConnectionId(v string) *CreatePublicVirtualInterfaceInput {
	s.ConnectionId = &v
	return s
}

// SetNewPublicVirtualInterface sets the NewPublicVirtualInterface field's value.
func (s *CreatePublicVirtualInterfaceInput) SetNewPublicVirtualInterface(v *NewPublicVirtualInterface) *CreatePublicVirtualInterfaceInput {
	s.NewPublicVirtualInterface = v
	return s
}

// Container for the parameters to the DeleteBGPPeer operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeerRequest
type DeleteBGPPeerInput struct {
	_ struct{} `type:"structure"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual interface from which the BGP peer will be deleted.
	//
	// Example: dxvif-456abc78
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DeleteBGPPeerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerInput) GoString() string {
	return s.String()
}

// SetAsn sets the Asn field's value.
func (s *DeleteBGPPeerInput) SetAsn(v int64) *DeleteBGPPeerInput {
	s.Asn = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *DeleteBGPPeerInput) SetCustomerAddress(v string) *DeleteBGPPeerInput {
	s.CustomerAddress = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteBGPPeerInput) SetVirtualInterfaceId(v string) *DeleteBGPPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when DeleteBGPPeer is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteBGPPeerResponse
type DeleteBGPPeerOutput struct {
	_ struct{} `type:"structure"`

	// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
	// location and the customer.
	VirtualInterface *VirtualInterface `locationName:"virtualInterface" type:"structure"`
}

// String returns the string representation
func (s DeleteBGPPeerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBGPPeerOutput) GoString() string {
	return s.String()
}

// SetVirtualInterface sets the VirtualInterface field's value.
func (s *DeleteBGPPeerOutput) SetVirtualInterface(v *VirtualInterface) *DeleteBGPPeerOutput {
	s.VirtualInterface = v
	return s
}

// Container for the parameters to the DeleteConnection operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteConnectionRequest
type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DeleteConnectionInput) SetConnectionId(v string) *DeleteConnectionInput {
	s.ConnectionId = &v
	return s
}

// Container for the parameters to the DeleteInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectRequest
type DeleteInterconnectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DeleteInterconnectInput) SetInterconnectId(v string) *DeleteInterconnectInput {
	s.InterconnectId = &v
	return s
}

// The response received when DeleteInterconnect is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteInterconnectResponse
type DeleteInterconnectOutput struct {
	_ struct{} `type:"structure"`

	// State of the interconnect.
	//
	//    * Requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * Pending>: The interconnect has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The interconnect is in the process of being deleted.
	//
	//    * Deleted: The interconnect has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`
}

// String returns the string representation
func (s DeleteInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectOutput) GoString() string {
	return s.String()
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *DeleteInterconnectOutput) SetInterconnectState(v string) *DeleteInterconnectOutput {
	s.InterconnectState = &v
	return s
}

// Container for the parameters to the DeleteVirtualInterface operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterfaceRequest
type DeleteVirtualInterfaceInput struct {
	_ struct{} `type:"structure"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	//
	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualInterfaceInput"}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DeleteVirtualInterfaceInput) SetVirtualInterfaceId(v string) *DeleteVirtualInterfaceInput {
	s.VirtualInterfaceId = &v
	return s
}

// The response received when DeleteVirtualInterface is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DeleteVirtualInterfaceResponse
type DeleteVirtualInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *DeleteVirtualInterfaceOutput) SetVirtualInterfaceState(v string) *DeleteVirtualInterfaceOutput {
	s.VirtualInterfaceState = &v
	return s
}

// Container for the parameters to the DescribeConnectionLoa operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoaRequest
type DescribeConnectionLoaInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	//
	// ConnectionId is a required field
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the APN partner or service provider who establishes connectivity
	// on your behalf. If you supply this parameter, the LOA-CFA lists the provider
	// name alongside your company name as the requester of the cross connect.
	//
	// Default: None
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionLoaInput"}
	if s.ConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionLoaInput) SetConnectionId(v string) *DescribeConnectionLoaInput {
	s.ConnectionId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeConnectionLoaInput) SetLoaContentType(v string) *DescribeConnectionLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeConnectionLoaInput) SetProviderName(v string) *DescribeConnectionLoaInput {
	s.ProviderName = &v
	return s
}

// The response received when DescribeConnectionLoa is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionLoaResponse
type DescribeConnectionLoaOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the Letter of Authorization - Connecting Facility
	// Assignment (LOA-CFA) for a connection.
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeConnectionLoaOutput) SetLoa(v *Loa) *DescribeConnectionLoaOutput {
	s.Loa = v
	return s
}

// Container for the parameters to the DescribeConnections operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsRequest
type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeConnectionsInput) SetConnectionId(v string) *DescribeConnectionsInput {
	s.ConnectionId = &v
	return s
}

// Container for the parameters to the DescribeConnectionsOnInterconnect operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeConnectionsOnInterconnectRequest
type DescribeConnectionsOnInterconnectInput struct {
	_ struct{} `type:"structure"`

	// ID of the interconnect on which a list of connection is provisioned.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConnectionsOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOnInterconnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsOnInterconnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsOnInterconnectInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeConnectionsOnInterconnectInput) SetInterconnectId(v string) *DescribeConnectionsOnInterconnectInput {
	s.InterconnectId = &v
	return s
}

// Container for the parameters to the DescribeInterconnectLoa operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoaRequest
type DescribeInterconnectLoaInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	//
	// InterconnectId is a required field
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`

	// The name of the service provider who establishes connectivity on your behalf.
	// If you supply this parameter, the LOA-CFA lists the provider name alongside
	// your company name as the requester of the cross connect.
	//
	// Default: None
	ProviderName *string `locationName:"providerName" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectLoaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInterconnectLoaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInterconnectLoaInput"}
	if s.InterconnectId == nil {
		invalidParams.Add(request.NewErrParamRequired("InterconnectId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectLoaInput) SetInterconnectId(v string) *DescribeInterconnectLoaInput {
	s.InterconnectId = &v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *DescribeInterconnectLoaInput) SetLoaContentType(v string) *DescribeInterconnectLoaInput {
	s.LoaContentType = &v
	return s
}

// SetProviderName sets the ProviderName field's value.
func (s *DescribeInterconnectLoaInput) SetProviderName(v string) *DescribeInterconnectLoaInput {
	s.ProviderName = &v
	return s
}

// The response received when DescribeInterconnectLoa is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectLoaResponse
type DescribeInterconnectLoaOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the Letter of Authorization - Connecting Facility
	// Assignment (LOA-CFA) for a connection.
	Loa *Loa `locationName:"loa" type:"structure"`
}

// String returns the string representation
func (s DescribeInterconnectLoaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectLoaOutput) GoString() string {
	return s.String()
}

// SetLoa sets the Loa field's value.
func (s *DescribeInterconnectLoaOutput) SetLoa(v *Loa) *DescribeInterconnectLoaOutput {
	s.Loa = v
	return s
}

// Container for the parameters to the DescribeInterconnects operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeInterconnectsRequest
type DescribeInterconnectsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`
}

// String returns the string representation
func (s DescribeInterconnectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsInput) GoString() string {
	return s.String()
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *DescribeInterconnectsInput) SetInterconnectId(v string) *DescribeInterconnectsInput {
	s.InterconnectId = &v
	return s
}

// A structure containing a list of interconnects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Interconnects
type DescribeInterconnectsOutput struct {
	_ struct{} `type:"structure"`

	// A list of interconnects.
	Interconnects []*Interconnect `locationName:"interconnects" type:"list"`
}

// String returns the string representation
func (s DescribeInterconnectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsOutput) GoString() string {
	return s.String()
}

// SetInterconnects sets the Interconnects field's value.
func (s *DescribeInterconnectsOutput) SetInterconnects(v []*Interconnect) *DescribeInterconnectsOutput {
	s.Interconnects = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeLocationsInput
type DescribeLocationsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsInput) GoString() string {
	return s.String()
}

// A location is a network facility where AWS Direct Connect routers are available
// to be connected. Generally, these are colocation hubs where many network
// providers have equipment, and where cross connects can be delivered. Locations
// include a name and facility code, and must be provided when creating a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Locations
type DescribeLocationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of colocation hubs where network providers have equipment. Most regions
	// have multiple locations available.
	Locations []*Location `locationName:"locations" type:"list"`
}

// String returns the string representation
func (s DescribeLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsOutput) GoString() string {
	return s.String()
}

// SetLocations sets the Locations field's value.
func (s *DescribeLocationsOutput) SetLocations(v []*Location) *DescribeLocationsOutput {
	s.Locations = v
	return s
}

// Container for the parameters to the DescribeTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTagsRequest
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) of the Direct Connect resources.
	//
	// ResourceArns is a required field
	ResourceArns []*string `locationName:"resourceArns" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArns sets the ResourceArns field's value.
func (s *DescribeTagsInput) SetResourceArns(v []*string) *DescribeTagsInput {
	s.ResourceArns = v
	return s
}

// The response received when DescribeTags is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeTagsResponse
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	ResourceTags []*ResourceTag `locationName:"resourceTags" type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetResourceTags sets the ResourceTags field's value.
func (s *DescribeTagsOutput) SetResourceTags(v []*ResourceTag) *DescribeTagsOutput {
	s.ResourceTags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualGatewaysInput
type DescribeVirtualGatewaysInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysInput) GoString() string {
	return s.String()
}

// A structure containing a list of virtual private gateways.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualGateways
type DescribeVirtualGatewaysOutput struct {
	_ struct{} `type:"structure"`

	// A list of virtual private gateways.
	VirtualGateways []*VirtualGateway `locationName:"virtualGateways" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysOutput) GoString() string {
	return s.String()
}

// SetVirtualGateways sets the VirtualGateways field's value.
func (s *DescribeVirtualGatewaysOutput) SetVirtualGateways(v []*VirtualGateway) *DescribeVirtualGatewaysOutput {
	s.VirtualGateways = v
	return s
}

// Container for the parameters to the DescribeVirtualInterfaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/DescribeVirtualInterfacesRequest
type DescribeVirtualInterfacesInput struct {
	_ struct{} `type:"structure"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesInput) GoString() string {
	return s.String()
}

// SetConnectionId sets the ConnectionId field's value.
func (s *DescribeVirtualInterfacesInput) SetConnectionId(v string) *DescribeVirtualInterfacesInput {
	s.ConnectionId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *DescribeVirtualInterfacesInput) SetVirtualInterfaceId(v string) *DescribeVirtualInterfacesInput {
	s.VirtualInterfaceId = &v
	return s
}

// A structure containing a list of virtual interfaces.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualInterfaces
type DescribeVirtualInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// A list of virtual interfaces.
	VirtualInterfaces []*VirtualInterface `locationName:"virtualInterfaces" type:"list"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesOutput) GoString() string {
	return s.String()
}

// SetVirtualInterfaces sets the VirtualInterfaces field's value.
func (s *DescribeVirtualInterfacesOutput) SetVirtualInterfaces(v []*VirtualInterface) *DescribeVirtualInterfacesOutput {
	s.VirtualInterfaces = v
	return s
}

// An interconnect is a connection that can host other connections.
//
// Like a standard AWS Direct Connect connection, an interconnect represents
// the physical connection between an AWS Direct Connect partner's network and
// a specific Direct Connect location. An AWS Direct Connect partner who owns
// an interconnect can provision hosted connections on the interconnect for
// their end customers, thereby providing the end customers with connectivity
// to AWS services.
//
// The resources of the interconnect, including bandwidth and VLAN numbers,
// are shared by all of the hosted connections on the interconnect, and the
// owner of the interconnect determines how these resources are assigned.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Interconnect
type Interconnect struct {
	_ struct{} `type:"structure"`

	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	InterconnectName *string `locationName:"interconnectName" type:"string"`

	// State of the interconnect.
	//
	//    * Requested: The initial state of an interconnect. The interconnect stays
	//    in the requested state until the Letter of Authorization (LOA) is sent
	//    to the customer.
	//
	//    * Pending>: The interconnect has been approved, and is being initialized.
	//
	//    * Available: The network link is up, and the interconnect is ready for
	//    use.
	//
	//    * Down: The network link is down.
	//
	//    * Deleting: The interconnect is in the process of being deleted.
	//
	//    * Deleted: The interconnect has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`

	// The time of the most recent call to DescribeInterconnectLoa for this Interconnect.
	LoaIssueTime *time.Time `locationName:"loaIssueTime" type:"timestamp" timestampFormat:"unix"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Interconnect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Interconnect) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *Interconnect) SetBandwidth(v string) *Interconnect {
	s.Bandwidth = &v
	return s
}

// SetInterconnectId sets the InterconnectId field's value.
func (s *Interconnect) SetInterconnectId(v string) *Interconnect {
	s.InterconnectId = &v
	return s
}

// SetInterconnectName sets the InterconnectName field's value.
func (s *Interconnect) SetInterconnectName(v string) *Interconnect {
	s.InterconnectName = &v
	return s
}

// SetInterconnectState sets the InterconnectState field's value.
func (s *Interconnect) SetInterconnectState(v string) *Interconnect {
	s.InterconnectState = &v
	return s
}

// SetLoaIssueTime sets the LoaIssueTime field's value.
func (s *Interconnect) SetLoaIssueTime(v time.Time) *Interconnect {
	s.LoaIssueTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Interconnect) SetLocation(v string) *Interconnect {
	s.Location = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Interconnect) SetRegion(v string) *Interconnect {
	s.Region = &v
	return s
}

// A structure containing the Letter of Authorization - Connecting Facility
// Assignment (LOA-CFA) for a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Loa
type Loa struct {
	_ struct{} `type:"structure"`

	// The binary contents of the LOA-CFA document.
	//
	// LoaContent is automatically base64 encoded/decoded by the SDK.
	LoaContent []byte `locationName:"loaContent" type:"blob"`

	// A standard media type indicating the content type of the LOA-CFA document.
	// Currently, the only supported value is "application/pdf".
	//
	// Default: application/pdf
	LoaContentType *string `locationName:"loaContentType" type:"string" enum:"LoaContentType"`
}

// String returns the string representation
func (s Loa) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Loa) GoString() string {
	return s.String()
}

// SetLoaContent sets the LoaContent field's value.
func (s *Loa) SetLoaContent(v []byte) *Loa {
	s.LoaContent = v
	return s
}

// SetLoaContentType sets the LoaContentType field's value.
func (s *Loa) SetLoaContentType(v string) *Loa {
	s.LoaContentType = &v
	return s
}

// An AWS Direct Connect location where connections and interconnects can be
// requested.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Location
type Location struct {
	_ struct{} `type:"structure"`

	// The code used to indicate the AWS Direct Connect location.
	LocationCode *string `locationName:"locationCode" type:"string"`

	// The name of the AWS Direct Connect location. The name includes the colocation
	// partner name and the physical site of the lit building.
	LocationName *string `locationName:"locationName" type:"string"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// SetLocationCode sets the LocationCode field's value.
func (s *Location) SetLocationCode(v string) *Location {
	s.LocationCode = &v
	return s
}

// SetLocationName sets the LocationName field's value.
func (s *Location) SetLocationName(v string) *Location {
	s.LocationName = &v
	return s
}

// A structure containing information about a new BGP peer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewBGPPeer
type NewBGPPeer struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`
}

// String returns the string representation
func (s NewBGPPeer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewBGPPeer) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewBGPPeer) SetAddressFamily(v string) *NewBGPPeer {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewBGPPeer) SetAmazonAddress(v string) *NewBGPPeer {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewBGPPeer) SetAsn(v int64) *NewBGPPeer {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewBGPPeer) SetAuthKey(v string) *NewBGPPeer {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewBGPPeer) SetCustomerAddress(v string) *NewBGPPeer {
	s.CustomerAddress = &v
	return s
}

// A structure containing information about a new private virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPrivateVirtualInterface
type NewPrivateVirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	//
	// VirtualGatewayId is a required field
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualGatewayId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualGatewayId"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterface) SetAddressFamily(v string) *NewPrivateVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterface) SetAmazonAddress(v string) *NewPrivateVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterface) SetAsn(v int64) *NewPrivateVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterface) SetAuthKey(v string) *NewPrivateVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterface) SetCustomerAddress(v string) *NewPrivateVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *NewPrivateVirtualInterface) SetVirtualGatewayId(v string) *NewPrivateVirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterface) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterface) SetVlan(v int64) *NewPrivateVirtualInterface {
	s.Vlan = &v
	return s
}

// A structure containing information about a private virtual interface that
// will be provisioned on a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPrivateVirtualInterfaceAllocation
type NewPrivateVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPrivateVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPrivateVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAsn(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetAuthKey(v string) *NewPrivateVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPrivateVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPrivateVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPrivateVirtualInterfaceAllocation) SetVlan(v int64) *NewPrivateVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// A structure containing information about a new public virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPublicVirtualInterface
type NewPublicVirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterface) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterface) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterface"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterface) SetAddressFamily(v string) *NewPublicVirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterface) SetAmazonAddress(v string) *NewPublicVirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterface) SetAsn(v int64) *NewPublicVirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterface) SetAuthKey(v string) *NewPublicVirtualInterface {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterface) SetCustomerAddress(v string) *NewPublicVirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterface) SetVirtualInterfaceName(v string) *NewPublicVirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterface) SetVlan(v int64) *NewPublicVirtualInterface {
	s.Vlan = &v
	return s
}

// A structure containing information about a public virtual interface that
// will be provisioned on a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/NewPublicVirtualInterfaceAllocation
type NewPublicVirtualInterfaceAllocation struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	//
	// Asn is a required field
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	//
	// VirtualInterfaceName is a required field
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	//
	// Vlan is a required field
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`
}

// String returns the string representation
func (s NewPublicVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NewPublicVirtualInterfaceAllocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NewPublicVirtualInterfaceAllocation"}
	if s.Asn == nil {
		invalidParams.Add(request.NewErrParamRequired("Asn"))
	}
	if s.VirtualInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceName"))
	}
	if s.Vlan == nil {
		invalidParams.Add(request.NewErrParamRequired("Vlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAddressFamily(v string) *NewPublicVirtualInterfaceAllocation {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAmazonAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAsn(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetAuthKey(v string) *NewPublicVirtualInterfaceAllocation {
	s.AuthKey = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetCustomerAddress(v string) *NewPublicVirtualInterfaceAllocation {
	s.CustomerAddress = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *NewPublicVirtualInterfaceAllocation {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVirtualInterfaceName(v string) *NewPublicVirtualInterfaceAllocation {
	s.VirtualInterfaceName = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *NewPublicVirtualInterfaceAllocation) SetVlan(v int64) *NewPublicVirtualInterfaceAllocation {
	s.Vlan = &v
	return s
}

// The tags associated with a Direct Connect resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/ResourceTag
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The tags.
	Tags []*Tag `locationName:"tags" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceTag) SetResourceArn(v string) *ResourceTag {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTag) SetTags(v []*Tag) *ResourceTag {
	s.Tags = v
	return s
}

// A route filter prefix that the customer can advertise through Border Gateway
// Protocol (BGP) over a public virtual interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/RouteFilterPrefix
type RouteFilterPrefix struct {
	_ struct{} `type:"structure"`

	// CIDR notation for the advertised route. Multiple routes are separated by
	// commas.
	//
	// IPv6 CIDRs must be at least a /64 or shorter
	//
	// Example: 10.10.10.0/24,10.10.11.0/24,2001:db8::/64
	Cidr *string `locationName:"cidr" type:"string"`
}

// String returns the string representation
func (s RouteFilterPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteFilterPrefix) GoString() string {
	return s.String()
}

// SetCidr sets the Cidr field's value.
func (s *RouteFilterPrefix) SetCidr(v string) *RouteFilterPrefix {
	s.Cidr = &v
	return s
}

// Information about a tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the TagResource operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResourceRequest
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	//
	// Example: arn:aws:directconnect:us-east-1:123456789012:dxcon/dxcon-fg5678gh
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The list of tags to add.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// The response received when TagResource is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/TagResourceResponse
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the UntagResource operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResourceRequest
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Direct Connect resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// The response received when UntagResource is called.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UntagResourceResponse
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// You can create one or more AWS Direct Connect private virtual interfaces
// linking to your virtual private gateway.
//
// Virtual private gateways can be managed using the Amazon Virtual Private
// Cloud (Amazon VPC) console or the Amazon EC2 CreateVpnGateway action (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualGateway
type VirtualGateway struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// State of the virtual private gateway.
	//
	//    * Pending: This is the initial state after calling CreateVpnGateway.
	//
	//    * Available: Ready for use by a private virtual interface.
	//
	//    * Deleting: This is the initial state after calling DeleteVpnGateway.
	//
	//    * Deleted: In this state, a private virtual interface is unable to send
	//    traffic over this gateway.
	VirtualGatewayState *string `locationName:"virtualGatewayState" type:"string"`
}

// String returns the string representation
func (s VirtualGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualGateway) GoString() string {
	return s.String()
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualGateway) SetVirtualGatewayId(v string) *VirtualGateway {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualGatewayState sets the VirtualGatewayState field's value.
func (s *VirtualGateway) SetVirtualGatewayState(v string) *VirtualGateway {
	s.VirtualGatewayState = &v
	return s
}

// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/VirtualInterface
type VirtualInterface struct {
	_ struct{} `type:"structure"`

	// Indicates the address family for the BGP peer.
	//
	//    * ipv4: IPv4 address family
	//
	//    * ipv6: IPv6 address family
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30 or 2001:db8::1/125
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// A list of the BGP peers configured on this virtual interface.
	BgpPeers []*BGPPeer `locationName:"bgpPeers" type:"list"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30 or 2001:db8::2/125
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// Information for generating the customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS account that will own the new virtual interface.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// State of the virtual interface.
	//
	//    * Confirming: The creation of the virtual interface is pending confirmation
	//    from the virtual interface owner. If the owner of the virtual interface
	//    is different from the owner of the connection on which it is provisioned,
	//    then the virtual interface will remain in this state until it is confirmed
	//    by the virtual interface owner.
	//
	//    * Verifying: This state only applies to public virtual interfaces. Each
	//    public virtual interface needs validation before the virtual interface
	//    can be created.
	//
	//    * Pending: A virtual interface is in this state from the time that it
	//    is created until the virtual interface is ready to forward traffic.
	//
	//    * Available: A virtual interface that is able to forward traffic.
	//
	//    * Down: A virtual interface that is BGP down.
	//
	//    * Deleting: A virtual interface is in this state immediately after calling
	//    DeleteVirtualInterface until it can no longer forward traffic.
	//
	//    * Deleted: A virtual interface that cannot forward traffic.
	//
	//    * Rejected: The virtual interface owner has declined creation of the virtual
	//    interface. If a virtual interface in the 'Confirming' state is deleted
	//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
	//    state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	// The type of virtual interface.
	//
	// Example: private (Amazon VPC) or public (Amazon S3, Amazon DynamoDB, and
	// so on.)
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`
}

// String returns the string representation
func (s VirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualInterface) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *VirtualInterface) SetAddressFamily(v string) *VirtualInterface {
	s.AddressFamily = &v
	return s
}

// SetAmazonAddress sets the AmazonAddress field's value.
func (s *VirtualInterface) SetAmazonAddress(v string) *VirtualInterface {
	s.AmazonAddress = &v
	return s
}

// SetAsn sets the Asn field's value.
func (s *VirtualInterface) SetAsn(v int64) *VirtualInterface {
	s.Asn = &v
	return s
}

// SetAuthKey sets the AuthKey field's value.
func (s *VirtualInterface) SetAuthKey(v string) *VirtualInterface {
	s.AuthKey = &v
	return s
}

// SetBgpPeers sets the BgpPeers field's value.
func (s *VirtualInterface) SetBgpPeers(v []*BGPPeer) *VirtualInterface {
	s.BgpPeers = v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *VirtualInterface) SetConnectionId(v string) *VirtualInterface {
	s.ConnectionId = &v
	return s
}

// SetCustomerAddress sets the CustomerAddress field's value.
func (s *VirtualInterface) SetCustomerAddress(v string) *VirtualInterface {
	s.CustomerAddress = &v
	return s
}

// SetCustomerRouterConfig sets the CustomerRouterConfig field's value.
func (s *VirtualInterface) SetCustomerRouterConfig(v string) *VirtualInterface {
	s.CustomerRouterConfig = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *VirtualInterface) SetLocation(v string) *VirtualInterface {
	s.Location = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *VirtualInterface) SetOwnerAccount(v string) *VirtualInterface {
	s.OwnerAccount = &v
	return s
}

// SetRouteFilterPrefixes sets the RouteFilterPrefixes field's value.
func (s *VirtualInterface) SetRouteFilterPrefixes(v []*RouteFilterPrefix) *VirtualInterface {
	s.RouteFilterPrefixes = v
	return s
}

// SetVirtualGatewayId sets the VirtualGatewayId field's value.
func (s *VirtualInterface) SetVirtualGatewayId(v string) *VirtualInterface {
	s.VirtualGatewayId = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *VirtualInterface) SetVirtualInterfaceId(v string) *VirtualInterface {
	s.VirtualInterfaceId = &v
	return s
}

// SetVirtualInterfaceName sets the VirtualInterfaceName field's value.
func (s *VirtualInterface) SetVirtualInterfaceName(v string) *VirtualInterface {
	s.VirtualInterfaceName = &v
	return s
}

// SetVirtualInterfaceState sets the VirtualInterfaceState field's value.
func (s *VirtualInterface) SetVirtualInterfaceState(v string) *VirtualInterface {
	s.VirtualInterfaceState = &v
	return s
}

// SetVirtualInterfaceType sets the VirtualInterfaceType field's value.
func (s *VirtualInterface) SetVirtualInterfaceType(v string) *VirtualInterface {
	s.VirtualInterfaceType = &v
	return s
}

// SetVlan sets the Vlan field's value.
func (s *VirtualInterface) SetVlan(v int64) *VirtualInterface {
	s.Vlan = &v
	return s
}

// Indicates the address family for the BGP peer.
//
//    * ipv4: IPv4 address family
//
//    * ipv6: IPv6 address family
const (
	// AddressFamilyIpv4 is a AddressFamily enum value
	AddressFamilyIpv4 = "ipv4"

	// AddressFamilyIpv6 is a AddressFamily enum value
	AddressFamilyIpv6 = "ipv6"
)

// The state of the BGP peer.
//
//    * Verifying: The BGP peering addresses or ASN require validation before
//    the BGP peer can be created. This state only applies to BGP peers on a
//    public virtual interface.
//
//    * Pending: The BGP peer has been created, and is in this state until it
//    is ready to be established.
//
//    * Available: The BGP peer can be established.
//
//    * Deleting: The BGP peer is in the process of being deleted.
//
//    * Deleted: The BGP peer has been deleted and cannot be established.
const (
	// BGPPeerStateVerifying is a BGPPeerState enum value
	BGPPeerStateVerifying = "verifying"

	// BGPPeerStatePending is a BGPPeerState enum value
	BGPPeerStatePending = "pending"

	// BGPPeerStateAvailable is a BGPPeerState enum value
	BGPPeerStateAvailable = "available"

	// BGPPeerStateDeleting is a BGPPeerState enum value
	BGPPeerStateDeleting = "deleting"

	// BGPPeerStateDeleted is a BGPPeerState enum value
	BGPPeerStateDeleted = "deleted"
)

// The Up/Down state of the BGP peer.
//
//    * Up: The BGP peer is established.
//
//    * Down: The BGP peer is down.
const (
	// BGPStatusUp is a BGPStatus enum value
	BGPStatusUp = "up"

	// BGPStatusDown is a BGPStatus enum value
	BGPStatusDown = "down"
)

// State of the connection.
//
//    * Ordering: The initial state of a hosted connection provisioned on an
//    interconnect. The connection stays in the ordering state until the owner
//    of the hosted connection confirms or declines the connection order.
//
//    * Requested: The initial state of a standard connection. The connection
//    stays in the requested state until the Letter of Authorization (LOA) is
//    sent to the customer.
//
//    * Pending: The connection has been approved, and is being initialized.
//
//    * Available: The network link is up, and the connection is ready for use.
//
//    * Down: The network link is down.
//
//    * Deleting: The connection is in the process of being deleted.
//
//    * Deleted: The connection has been deleted.
//
//    * Rejected: A hosted connection in the 'Ordering' state will enter the
//    'Rejected' state if it is deleted by the end customer.
const (
	// ConnectionStateOrdering is a ConnectionState enum value
	ConnectionStateOrdering = "ordering"

	// ConnectionStateRequested is a ConnectionState enum value
	ConnectionStateRequested = "requested"

	// ConnectionStatePending is a ConnectionState enum value
	ConnectionStatePending = "pending"

	// ConnectionStateAvailable is a ConnectionState enum value
	ConnectionStateAvailable = "available"

	// ConnectionStateDown is a ConnectionState enum value
	ConnectionStateDown = "down"

	// ConnectionStateDeleting is a ConnectionState enum value
	ConnectionStateDeleting = "deleting"

	// ConnectionStateDeleted is a ConnectionState enum value
	ConnectionStateDeleted = "deleted"

	// ConnectionStateRejected is a ConnectionState enum value
	ConnectionStateRejected = "rejected"
)

// State of the interconnect.
//
//    * Requested: The initial state of an interconnect. The interconnect stays
//    in the requested state until the Letter of Authorization (LOA) is sent
//    to the customer.
//
//    * Pending>: The interconnect has been approved, and is being initialized.
//
//    * Available: The network link is up, and the interconnect is ready for
//    use.
//
//    * Down: The network link is down.
//
//    * Deleting: The interconnect is in the process of being deleted.
//
//    * Deleted: The interconnect has been deleted.
const (
	// InterconnectStateRequested is a InterconnectState enum value
	InterconnectStateRequested = "requested"

	// InterconnectStatePending is a InterconnectState enum value
	InterconnectStatePending = "pending"

	// InterconnectStateAvailable is a InterconnectState enum value
	InterconnectStateAvailable = "available"

	// InterconnectStateDown is a InterconnectState enum value
	InterconnectStateDown = "down"

	// InterconnectStateDeleting is a InterconnectState enum value
	InterconnectStateDeleting = "deleting"

	// InterconnectStateDeleted is a InterconnectState enum value
	InterconnectStateDeleted = "deleted"
)

// A standard media type indicating the content type of the LOA-CFA document.
// Currently, the only supported value is "application/pdf".
//
// Default: application/pdf
const (
	// LoaContentTypeApplicationPdf is a LoaContentType enum value
	LoaContentTypeApplicationPdf = "application/pdf"
)

// State of the virtual interface.
//
//    * Confirming: The creation of the virtual interface is pending confirmation
//    from the virtual interface owner. If the owner of the virtual interface
//    is different from the owner of the connection on which it is provisioned,
//    then the virtual interface will remain in this state until it is confirmed
//    by the virtual interface owner.
//
//    * Verifying: This state only applies to public virtual interfaces. Each
//    public virtual interface needs validation before the virtual interface
//    can be created.
//
//    * Pending: A virtual interface is in this state from the time that it
//    is created until the virtual interface is ready to forward traffic.
//
//    * Available: A virtual interface that is able to forward traffic.
//
//    * Down: A virtual interface that is BGP down.
//
//    * Deleting: A virtual interface is in this state immediately after calling
//    DeleteVirtualInterface until it can no longer forward traffic.
//
//    * Deleted: A virtual interface that cannot forward traffic.
//
//    * Rejected: The virtual interface owner has declined creation of the virtual
//    interface. If a virtual interface in the 'Confirming' state is deleted
//    by the virtual interface owner, the virtual interface will enter the 'Rejected'
//    state.
const (
	// VirtualInterfaceStateConfirming is a VirtualInterfaceState enum value
	VirtualInterfaceStateConfirming = "confirming"

	// VirtualInterfaceStateVerifying is a VirtualInterfaceState enum value
	VirtualInterfaceStateVerifying = "verifying"

	// VirtualInterfaceStatePending is a VirtualInterfaceState enum value
	VirtualInterfaceStatePending = "pending"

	// VirtualInterfaceStateAvailable is a VirtualInterfaceState enum value
	VirtualInterfaceStateAvailable = "available"

	// VirtualInterfaceStateDown is a VirtualInterfaceState enum value
	VirtualInterfaceStateDown = "down"

	// VirtualInterfaceStateDeleting is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleting = "deleting"

	// VirtualInterfaceStateDeleted is a VirtualInterfaceState enum value
	VirtualInterfaceStateDeleted = "deleted"

	// VirtualInterfaceStateRejected is a VirtualInterfaceState enum value
	VirtualInterfaceStateRejected = "rejected"
)
