// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elastictranscoder provides a client for Amazon Elastic Transcoder.
package elastictranscoder

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2012-09-25/jobs/{Id}",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelJob API operation for Amazon Elastic Transcoder.
//
// The CancelJob operation cancels an unfinished job.
//
// You can only cancel a job that has a status of Submitted. To prevent a pipeline
// from starting to process a job while you're getting the job identifier, use
// UpdatePipelineStatus to temporarily pause the pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation CancelJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource you are attempting to change is in use. For example, you are
//   attempting to delete a pipeline that is currently in use.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobResponse) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobResponse{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for Amazon Elastic Transcoder.
//
// When you create a job, Elastic Transcoder returns JSON data that includes
// the values that you specified plus information about the job that is created.
//
// If you have specified more than one output for your jobs (for example, one
// output for the Kindle Fire and another output for the Apple iPhone 4s), you
// currently must use the Elastic Transcoder API to list the jobs (as opposed
// to the AWS Console).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Too many operations for a given AWS account. For example, the number of pipelines
//   exceeds the maximum allowed.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) CreateJob(input *CreateJobInput) (*CreateJobResponse, error) {
	req, out := c.CreateJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePipelineRequest method.
//    req, resp := client.CreatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/pipelines",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	output = &CreatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipeline API operation for Amazon Elastic Transcoder.
//
// The CreatePipeline operation creates a pipeline with settings that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation CreatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Too many operations for a given AWS account. For example, the number of pipelines
//   exceeds the maximum allowed.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePreset = "CreatePreset"

// CreatePresetRequest generates a "aws/request.Request" representing the
// client's request for the CreatePreset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePreset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePreset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePresetRequest method.
//    req, resp := client.CreatePresetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) CreatePresetRequest(input *CreatePresetInput) (req *request.Request, output *CreatePresetOutput) {
	op := &request.Operation{
		Name:       opCreatePreset,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/presets",
	}

	if input == nil {
		input = &CreatePresetInput{}
	}

	output = &CreatePresetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePreset API operation for Amazon Elastic Transcoder.
//
// The CreatePreset operation creates a preset with settings that you specify.
//
// Elastic Transcoder checks the CreatePreset settings to ensure that they meet
// Elastic Transcoder requirements and to determine whether they comply with
// H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic
// Transcoder returns an HTTP 400 response (ValidationException) and does not
// create the preset. If the settings are valid for Elastic Transcoder but aren't
// strictly compliant with the H.264 standard, Elastic Transcoder creates the
// preset and returns a warning message in the response. This helps you determine
// whether your settings comply with the H.264 standard while giving you greater
// flexibility with respect to the video that Elastic Transcoder produces.
//
// Elastic Transcoder uses the H.264 video-compression format. For more information,
// see the International Telecommunication Union publication Recommendation
// ITU-T H.264: Advanced video coding for generic audiovisual services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation CreatePreset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Too many operations for a given AWS account. For example, the number of pipelines
//   exceeds the maximum allowed.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) CreatePreset(input *CreatePresetInput) (*CreatePresetOutput, error) {
	req, out := c.CreatePresetRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePipelineRequest method.
//    req, resp := client.DeletePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2012-09-25/pipelines/{Id}",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	output = &DeletePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePipeline API operation for Amazon Elastic Transcoder.
//
// The DeletePipeline operation removes a pipeline.
//
// You can only delete a pipeline that has never been used or that is not currently
// in use (doesn't contain any active jobs). If the pipeline is currently in
// use, DeletePipeline returns an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation DeletePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource you are attempting to change is in use. For example, you are
//   attempting to delete a pipeline that is currently in use.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePreset = "DeletePreset"

// DeletePresetRequest generates a "aws/request.Request" representing the
// client's request for the DeletePreset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePreset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePreset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePresetRequest method.
//    req, resp := client.DeletePresetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) DeletePresetRequest(input *DeletePresetInput) (req *request.Request, output *DeletePresetOutput) {
	op := &request.Operation{
		Name:       opDeletePreset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2012-09-25/presets/{Id}",
	}

	if input == nil {
		input = &DeletePresetInput{}
	}

	output = &DeletePresetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePreset API operation for Amazon Elastic Transcoder.
//
// The DeletePreset operation removes a preset that you've added in an AWS region.
//
// You can't delete the default presets that are included with Elastic Transcoder.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation DeletePreset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) DeletePreset(input *DeletePresetInput) (*DeletePresetOutput, error) {
	req, out := c.DeletePresetRequest(input)
	err := req.Send()
	return out, err
}

const opListJobsByPipeline = "ListJobsByPipeline"

// ListJobsByPipelineRequest generates a "aws/request.Request" representing the
// client's request for the ListJobsByPipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListJobsByPipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListJobsByPipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListJobsByPipelineRequest method.
//    req, resp := client.ListJobsByPipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ListJobsByPipelineRequest(input *ListJobsByPipelineInput) (req *request.Request, output *ListJobsByPipelineOutput) {
	op := &request.Operation{
		Name:       opListJobsByPipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/jobsByPipeline/{PipelineId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsByPipelineInput{}
	}

	output = &ListJobsByPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobsByPipeline API operation for Amazon Elastic Transcoder.
//
// The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
//
// Elastic Transcoder returns all of the jobs currently in the specified pipeline.
// The response body contains one element for each job that satisfies the search
// criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ListJobsByPipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ListJobsByPipeline(input *ListJobsByPipelineInput) (*ListJobsByPipelineOutput, error) {
	req, out := c.ListJobsByPipelineRequest(input)
	err := req.Send()
	return out, err
}

// ListJobsByPipelinePages iterates over the pages of a ListJobsByPipeline operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobsByPipeline method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobsByPipeline operation.
//    pageNum := 0
//    err := client.ListJobsByPipelinePages(params,
//        func(page *ListJobsByPipelineOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticTranscoder) ListJobsByPipelinePages(input *ListJobsByPipelineInput, fn func(p *ListJobsByPipelineOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsByPipelineRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsByPipelineOutput), lastPage)
	})
}

const opListJobsByStatus = "ListJobsByStatus"

// ListJobsByStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListJobsByStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListJobsByStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListJobsByStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListJobsByStatusRequest method.
//    req, resp := client.ListJobsByStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ListJobsByStatusRequest(input *ListJobsByStatusInput) (req *request.Request, output *ListJobsByStatusOutput) {
	op := &request.Operation{
		Name:       opListJobsByStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/jobsByStatus/{Status}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsByStatusInput{}
	}

	output = &ListJobsByStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobsByStatus API operation for Amazon Elastic Transcoder.
//
// The ListJobsByStatus operation gets a list of jobs that have a specified
// status. The response body contains one element for each job that satisfies
// the search criteria.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ListJobsByStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ListJobsByStatus(input *ListJobsByStatusInput) (*ListJobsByStatusOutput, error) {
	req, out := c.ListJobsByStatusRequest(input)
	err := req.Send()
	return out, err
}

// ListJobsByStatusPages iterates over the pages of a ListJobsByStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobsByStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobsByStatus operation.
//    pageNum := 0
//    err := client.ListJobsByStatusPages(params,
//        func(page *ListJobsByStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticTranscoder) ListJobsByStatusPages(input *ListJobsByStatusInput, fn func(p *ListJobsByStatusOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsByStatusRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsByStatusOutput), lastPage)
	})
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipelines operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPipelines for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPipelines method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPipelinesRequest method.
//    req, resp := client.ListPipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	output = &ListPipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipelines API operation for Amazon Elastic Transcoder.
//
// The ListPipelines operation gets a list of the pipelines associated with
// the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ListPipelines for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	err := req.Send()
	return out, err
}

// ListPipelinesPages iterates over the pages of a ListPipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPipelines operation.
//    pageNum := 0
//    err := client.ListPipelinesPages(params,
//        func(page *ListPipelinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticTranscoder) ListPipelinesPages(input *ListPipelinesInput, fn func(p *ListPipelinesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPipelinesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPipelinesOutput), lastPage)
	})
}

const opListPresets = "ListPresets"

// ListPresetsRequest generates a "aws/request.Request" representing the
// client's request for the ListPresets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPresets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPresets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPresetsRequest method.
//    req, resp := client.ListPresetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ListPresetsRequest(input *ListPresetsInput) (req *request.Request, output *ListPresetsOutput) {
	op := &request.Operation{
		Name:       opListPresets,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/presets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPresetsInput{}
	}

	output = &ListPresetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPresets API operation for Amazon Elastic Transcoder.
//
// The ListPresets operation gets a list of the default presets included with
// Elastic Transcoder and the presets that you've added in an AWS region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ListPresets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ListPresets(input *ListPresetsInput) (*ListPresetsOutput, error) {
	req, out := c.ListPresetsRequest(input)
	err := req.Send()
	return out, err
}

// ListPresetsPages iterates over the pages of a ListPresets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPresets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPresets operation.
//    pageNum := 0
//    err := client.ListPresetsPages(params,
//        func(page *ListPresetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticTranscoder) ListPresetsPages(input *ListPresetsInput, fn func(p *ListPresetsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPresetsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPresetsOutput), lastPage)
	})
}

const opReadJob = "ReadJob"

// ReadJobRequest generates a "aws/request.Request" representing the
// client's request for the ReadJob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReadJob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReadJob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReadJobRequest method.
//    req, resp := client.ReadJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ReadJobRequest(input *ReadJobInput) (req *request.Request, output *ReadJobOutput) {
	op := &request.Operation{
		Name:       opReadJob,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/jobs/{Id}",
	}

	if input == nil {
		input = &ReadJobInput{}
	}

	output = &ReadJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReadJob API operation for Amazon Elastic Transcoder.
//
// The ReadJob operation returns detailed information about a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ReadJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ReadJob(input *ReadJobInput) (*ReadJobOutput, error) {
	req, out := c.ReadJobRequest(input)
	err := req.Send()
	return out, err
}

const opReadPipeline = "ReadPipeline"

// ReadPipelineRequest generates a "aws/request.Request" representing the
// client's request for the ReadPipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReadPipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReadPipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReadPipelineRequest method.
//    req, resp := client.ReadPipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ReadPipelineRequest(input *ReadPipelineInput) (req *request.Request, output *ReadPipelineOutput) {
	op := &request.Operation{
		Name:       opReadPipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/pipelines/{Id}",
	}

	if input == nil {
		input = &ReadPipelineInput{}
	}

	output = &ReadPipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReadPipeline API operation for Amazon Elastic Transcoder.
//
// The ReadPipeline operation gets detailed information about a pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ReadPipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ReadPipeline(input *ReadPipelineInput) (*ReadPipelineOutput, error) {
	req, out := c.ReadPipelineRequest(input)
	err := req.Send()
	return out, err
}

const opReadPreset = "ReadPreset"

// ReadPresetRequest generates a "aws/request.Request" representing the
// client's request for the ReadPreset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReadPreset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReadPreset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReadPresetRequest method.
//    req, resp := client.ReadPresetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) ReadPresetRequest(input *ReadPresetInput) (req *request.Request, output *ReadPresetOutput) {
	op := &request.Operation{
		Name:       opReadPreset,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/presets/{Id}",
	}

	if input == nil {
		input = &ReadPresetInput{}
	}

	output = &ReadPresetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReadPreset API operation for Amazon Elastic Transcoder.
//
// The ReadPreset operation gets detailed information about a preset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation ReadPreset for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) ReadPreset(input *ReadPresetInput) (*ReadPresetOutput, error) {
	req, out := c.ReadPresetRequest(input)
	err := req.Send()
	return out, err
}

const opTestRole = "TestRole"

// TestRoleRequest generates a "aws/request.Request" representing the
// client's request for the TestRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestRoleRequest method.
//    req, resp := client.TestRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) TestRoleRequest(input *TestRoleInput) (req *request.Request, output *TestRoleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, TestRole, has been deprecated")
	}
	op := &request.Operation{
		Name:       opTestRole,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/roleTests",
	}

	if input == nil {
		input = &TestRoleInput{}
	}

	output = &TestRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestRole API operation for Amazon Elastic Transcoder.
//
// The TestRole operation tests the IAM role used to create the pipeline.
//
// The TestRole action lets you determine whether the IAM role you are using
// has sufficient permissions to let Elastic Transcoder perform tasks associated
// with the transcoding process. The action attempts to assume the specified
// IAM role, checks read access to the input and output buckets, and tries to
// send a test notification to Amazon SNS topics that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation TestRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) TestRole(input *TestRoleInput) (*TestRoleOutput, error) {
	req, out := c.TestRoleRequest(input)
	err := req.Send()
	return out, err
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipeline operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdatePipeline for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdatePipeline method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdatePipelineRequest method.
//    req, resp := client.UpdatePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "PUT",
		HTTPPath:   "/2012-09-25/pipelines/{Id}",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	output = &UpdatePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipeline API operation for Amazon Elastic Transcoder.
//
// Use the UpdatePipeline operation to update settings for a pipeline.
//
// When you change pipeline settings, your changes take effect immediately.
// Jobs that you have already submitted and that Elastic Transcoder has not
// started to process are affected in addition to jobs that you submit after
// you change settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation UpdatePipeline for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource you are attempting to change is in use. For example, you are
//   attempting to delete a pipeline that is currently in use.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opUpdatePipelineNotifications = "UpdatePipelineNotifications"

// UpdatePipelineNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipelineNotifications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdatePipelineNotifications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdatePipelineNotifications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdatePipelineNotificationsRequest method.
//    req, resp := client.UpdatePipelineNotificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) UpdatePipelineNotificationsRequest(input *UpdatePipelineNotificationsInput) (req *request.Request, output *UpdatePipelineNotificationsOutput) {
	op := &request.Operation{
		Name:       opUpdatePipelineNotifications,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/pipelines/{Id}/notifications",
	}

	if input == nil {
		input = &UpdatePipelineNotificationsInput{}
	}

	output = &UpdatePipelineNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipelineNotifications API operation for Amazon Elastic Transcoder.
//
// With the UpdatePipelineNotifications operation, you can update Amazon Simple
// Notification Service (Amazon SNS) notifications for a pipeline.
//
// When you update notifications for a pipeline, Elastic Transcoder returns
// the values that you specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation UpdatePipelineNotifications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource you are attempting to change is in use. For example, you are
//   attempting to delete a pipeline that is currently in use.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) UpdatePipelineNotifications(input *UpdatePipelineNotificationsInput) (*UpdatePipelineNotificationsOutput, error) {
	req, out := c.UpdatePipelineNotificationsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdatePipelineStatus = "UpdatePipelineStatus"

// UpdatePipelineStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipelineStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdatePipelineStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdatePipelineStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdatePipelineStatusRequest method.
//    req, resp := client.UpdatePipelineStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticTranscoder) UpdatePipelineStatusRequest(input *UpdatePipelineStatusInput) (req *request.Request, output *UpdatePipelineStatusOutput) {
	op := &request.Operation{
		Name:       opUpdatePipelineStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/2012-09-25/pipelines/{Id}/status",
	}

	if input == nil {
		input = &UpdatePipelineStatusInput{}
	}

	output = &UpdatePipelineStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipelineStatus API operation for Amazon Elastic Transcoder.
//
// The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that
// the pipeline stops or restarts the processing of jobs.
//
// Changing the pipeline status is useful if you want to cancel one or more
// jobs. You can't cancel jobs after Elastic Transcoder has started processing
// them; if you pause the pipeline to which you submitted the jobs, you have
// more time to get the job IDs for the jobs that you want to cancel, and to
// send a CancelJob request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Transcoder's
// API operation UpdatePipelineStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more required parameter values were not provided in the request.
//
//   * ErrCodeIncompatibleVersionException "IncompatibleVersionException"

//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist or is not available. For example, the
//   pipeline to which you're trying to add a job doesn't exist or is still being
//   created.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The resource you are attempting to change is in use. For example, you are
//   attempting to delete a pipeline that is currently in use.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   General authentication failure. The request was not signed correctly.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   Elastic Transcoder encountered an unexpected exception while trying to fulfill
//   the request.
//
func (c *ElasticTranscoder) UpdatePipelineStatus(input *UpdatePipelineStatusInput) (*UpdatePipelineStatusOutput, error) {
	req, out := c.UpdatePipelineStatusRequest(input)
	err := req.Send()
	return out, err
}

// The file to be used as album art. There can be multiple artworks associated
// with an audio file, to a maximum of 20.
//
// To remove artwork or leave the artwork empty, you can either set Artwork
// to null, or set the Merge Policy to "Replace" and use an empty Artwork array.
//
// To pass through existing artwork unchanged, set the Merge Policy to "Prepend",
// "Append", or "Fallback", and use an empty Artwork array.
type Artwork struct {
	_ struct{} `type:"structure"`

	// The format of album art, if any. Valid formats are .jpg and .png.
	AlbumArtFormat *string `type:"string"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your artwork.
	Encryption *Encryption `type:"structure"`

	// The name of the file to be used as album art. To determine which Amazon S3
	// bucket contains the specified file, Elastic Transcoder checks the pipeline
	// specified by PipelineId; the InputBucket object in that pipeline identifies
	// the bucket.
	//
	// If the file name includes a prefix, for example, cooking/pie.jpg, include
	// the prefix in the key. If the file isn't in the specified bucket, Elastic
	// Transcoder returns an error.
	InputKey *string `min:"1" type:"string"`

	// The maximum height of the output album art in pixels. If you specify auto,
	// Elastic Transcoder uses 600 as the default value. If you specify a numeric
	// value, enter an even integer between 32 and 3072, inclusive.
	MaxHeight *string `type:"string"`

	// The maximum width of the output album art in pixels. If you specify auto,
	// Elastic Transcoder uses 600 as the default value. If you specify a numeric
	// value, enter an even integer between 32 and 4096, inclusive.
	MaxWidth *string `type:"string"`

	// When you set PaddingPolicy to Pad, Elastic Transcoder may add white bars
	// to the top and bottom and/or left and right sides of the output album art
	// to make the total size of the output art match the values that you specified
	// for MaxWidth and MaxHeight.
	PaddingPolicy *string `type:"string"`

	// Specify one of the following values to control scaling of the output album
	// art:
	//
	//    * Fit: Elastic Transcoder scales the output art so it matches the value
	//    that you specified in either MaxWidth or MaxHeight without exceeding the
	//    other value.
	//
	//    * Fill: Elastic Transcoder scales the output art so it matches the value
	//    that you specified in either MaxWidth or MaxHeight and matches or exceeds
	//    the other value. Elastic Transcoder centers the output art and then crops
	//    it in the dimension (if any) that exceeds the maximum value.
	//
	//    * Stretch: Elastic Transcoder stretches the output art to match the values
	//    that you specified for MaxWidth and MaxHeight. If the relative proportions
	//    of the input art and the output art are different, the output art will
	//    be distorted.
	//
	//    * Keep: Elastic Transcoder does not scale the output art. If either dimension
	//    of the input art exceeds the values that you specified for MaxWidth and
	//    MaxHeight, Elastic Transcoder crops the output art.
	//
	//    * ShrinkToFit: Elastic Transcoder scales the output art down so that its
	//    dimensions match the values that you specified for at least one of MaxWidth
	//    and MaxHeight without exceeding either value. If you specify this option,
	//    Elastic Transcoder does not scale the art up.
	//
	//    * ShrinkToFill Elastic Transcoder scales the output art down so that its
	//    dimensions match the values that you specified for at least one of MaxWidth
	//    and MaxHeight without dropping below either value. If you specify this
	//    option, Elastic Transcoder does not scale the art up.
	SizingPolicy *string `type:"string"`
}

// String returns the string representation
func (s Artwork) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Artwork) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Artwork) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Artwork"}
	if s.InputKey != nil && len(*s.InputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlbumArtFormat sets the AlbumArtFormat field's value.
func (s *Artwork) SetAlbumArtFormat(v string) *Artwork {
	s.AlbumArtFormat = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Artwork) SetEncryption(v *Encryption) *Artwork {
	s.Encryption = v
	return s
}

// SetInputKey sets the InputKey field's value.
func (s *Artwork) SetInputKey(v string) *Artwork {
	s.InputKey = &v
	return s
}

// SetMaxHeight sets the MaxHeight field's value.
func (s *Artwork) SetMaxHeight(v string) *Artwork {
	s.MaxHeight = &v
	return s
}

// SetMaxWidth sets the MaxWidth field's value.
func (s *Artwork) SetMaxWidth(v string) *Artwork {
	s.MaxWidth = &v
	return s
}

// SetPaddingPolicy sets the PaddingPolicy field's value.
func (s *Artwork) SetPaddingPolicy(v string) *Artwork {
	s.PaddingPolicy = &v
	return s
}

// SetSizingPolicy sets the SizingPolicy field's value.
func (s *Artwork) SetSizingPolicy(v string) *Artwork {
	s.SizingPolicy = &v
	return s
}

// Options associated with your audio codec.
type AudioCodecOptions struct {
	_ struct{} `type:"structure"`

	// You can only choose an audio bit depth when you specify flac or pcm for the
	// value of Audio:Codec.
	//
	// The bit depth of a sample is how many bits of information are included in
	// the audio samples. The higher the bit depth, the better the audio, but the
	// larger the file.
	//
	// Valid values are 16 and 24.
	//
	// The most common bit depth is 24.
	BitDepth *string `type:"string"`

	// You can only choose an audio bit order when you specify pcm for the value
	// of Audio:Codec.
	//
	// The order the bits of a PCM sample are stored in.
	//
	// The supported value is LittleEndian.
	BitOrder *string `type:"string"`

	// You can only choose an audio profile when you specify AAC for the value of
	// Audio:Codec.
	//
	// Specify the AAC profile for the output file. Elastic Transcoder supports
	// the following profiles:
	//
	//    * auto: If you specify auto, Elastic Transcoder selects the profile based
	//    on the bit rate selected for the output file.
	//
	//    * AAC-LC: The most common AAC profile. Use for bit rates larger than 64
	//    kbps.
	//
	//    * HE-AAC: Not supported on some older players and devices. Use for bit
	//    rates between 40 and 80 kbps.
	//
	//    * HE-AACv2: Not supported on some players and devices. Use for bit rates
	//    less than 48 kbps.
	//
	// All outputs in a Smooth playlist must have the same value for Profile.
	//
	// If you created any presets before AAC profiles were added, Elastic Transcoder
	// automatically updated your presets to use AAC-LC. You can change the value
	// as required.
	Profile *string `type:"string"`

	// You can only choose whether an audio sample is signed when you specify pcm
	// for the value of Audio:Codec.
	//
	// Whether audio samples are represented with negative and positive numbers
	// (signed) or only positive numbers (unsigned).
	//
	// The supported value is Signed.
	Signed *string `type:"string"`
}

// String returns the string representation
func (s AudioCodecOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioCodecOptions) GoString() string {
	return s.String()
}

// SetBitDepth sets the BitDepth field's value.
func (s *AudioCodecOptions) SetBitDepth(v string) *AudioCodecOptions {
	s.BitDepth = &v
	return s
}

// SetBitOrder sets the BitOrder field's value.
func (s *AudioCodecOptions) SetBitOrder(v string) *AudioCodecOptions {
	s.BitOrder = &v
	return s
}

// SetProfile sets the Profile field's value.
func (s *AudioCodecOptions) SetProfile(v string) *AudioCodecOptions {
	s.Profile = &v
	return s
}

// SetSigned sets the Signed field's value.
func (s *AudioCodecOptions) SetSigned(v string) *AudioCodecOptions {
	s.Signed = &v
	return s
}

// Parameters required for transcoding audio.
type AudioParameters struct {
	_ struct{} `type:"structure"`

	// The method of organizing audio channels and tracks. Use Audio:Channels to
	// specify the number of channels in your output, and Audio:AudioPackingMode
	// to specify the number of tracks and their relation to the channels. If you
	// do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
	//
	// The following values are valid:
	//
	// SingleTrack, OneChannelPerTrack, and OneChannelPerTrackWithMosTo8Tracks
	//
	// When you specify SingleTrack, Elastic Transcoder creates a single track for
	// your output. The track can have up to eight channels. Use SingleTrack for
	// all non-mxf containers.
	//
	// The outputs of SingleTrack for a specific channel value and inputs are as
	// follows:
	//
	//    * 0 channels with any input: Audio omitted from the output
	//
	//    * 1, 2, or auto channels with no audio input: Audio omitted from the output
	//
	//    * 1 channel with any input with audio: One track with one channel, downmixed
	//    if necessary
	//
	//    * 2 channels with one track with one channel: One track with two identical
	//    channels
	//
	//    * 2 or auto channels with two tracks with one channel each: One track
	//    with two channels
	//
	//    * 2 or auto channels with one track with two channels: One track with
	//    two channels
	//
	//    * 2 channels with one track with multiple channels: One track with two
	//    channels
	//
	//    * auto channels with one track with one channel: One track with one channel
	//
	//    * auto channels with one track with multiple channels: One track with
	//    multiple channels
	//
	// When you specify OneChannelPerTrack, Elastic Transcoder creates a new track
	// for every channel in your output. Your output can have up to eight single-channel
	// tracks.
	//
	// The outputs of OneChannelPerTrack for a specific channel value and inputs
	// are as follows:
	//
	//    * 0 channels with any input: Audio omitted from the output
	//
	//    * 1, 2, or auto channels with no audio input: Audio omitted from the output
	//
	//    * 1 channel with any input with audio: One track with one channel, downmixed
	//    if necessary
	//
	//    * 2 channels with one track with one channel: Two tracks with one identical
	//    channel each
	//
	//    * 2 or auto channels with two tracks with one channel each: Two tracks
	//    with one channel each
	//
	//    * 2 or auto channels with one track with two channels: Two tracks with
	//    one channel each
	//
	//    * 2 channels with one track with multiple channels: Two tracks with one
	//    channel each
	//
	//    * auto channels with one track with one channel: One track with one channel
	//
	//    * auto channels with one track with multiple channels: Up to eight tracks
	//    with one channel each
	//
	// When you specify OneChannelPerTrackWithMosTo8Tracks, Elastic Transcoder creates
	// eight single-channel tracks for your output. All tracks that do not contain
	// audio data from an input channel are MOS, or Mit Out Sound, tracks.
	//
	// The outputs of OneChannelPerTrackWithMosTo8Tracks for a specific channel
	// value and inputs are as follows:
	//
	//    * 0 channels with any input: Audio omitted from the output
	//
	//    * 1, 2, or auto channels with no audio input: Audio omitted from the output
	//
	//    * 1 channel with any input with audio: One track with one channel, downmixed
	//    if necessary, plus six MOS tracks
	//
	//    * 2 channels with one track with one channel: Two tracks with one identical
	//    channel each, plus six MOS tracks
	//
	//    * 2 or auto channels with two tracks with one channel each: Two tracks
	//    with one channel each, plus six MOS tracks
	//
	//    * 2 or auto channels with one track with two channels: Two tracks with
	//    one channel each, plus six MOS tracks
	//
	//    * 2 channels with one track with multiple channels: Two tracks with one
	//    channel each, plus six MOS tracks
	//
	//    * auto channels with one track with one channel: One track with one channel,
	//    plus seven MOS tracks
	//
	//    * auto channels with one track with multiple channels: Up to eight tracks
	//    with one channel each, plus MOS tracks until there are eight tracks in
	//    all
	AudioPackingMode *string `type:"string"`

	// The bit rate of the audio stream in the output file, in kilobits/second.
	// Enter an integer between 64 and 320, inclusive.
	BitRate *string `type:"string"`

	// The number of audio channels in the output file. The following values are
	// valid:
	//
	// auto, 0, 1, 2
	//
	// One channel carries the information played by a single speaker. For example,
	// a stereo track with two channels sends one channel to the left speaker, and
	// the other channel to the right speaker. The output channels are organized
	// into tracks. If you want Elastic Transcoder to automatically detect the number
	// of audio channels in the input file and use that value for the output file,
	// select auto.
	//
	// The output of a specific channel value and inputs are as follows:
	//
	//    * auto channel specified, with any input: Pass through up to eight input
	//    channels.
	//
	//    * 0 channels specified, with any input: Audio omitted from the output.
	//
	//    * 1 channel specified, with at least one input channel: Mono sound.
	//
	//    * 2 channels specified, with any input: Two identical mono channels or
	//    stereo. For more information about tracks, see Audio:AudioPackingMode.
	//
	// For more information about how Elastic Transcoder organizes channels and
	// tracks, see Audio:AudioPackingMode.
	Channels *string `type:"string"`

	// The audio codec for the output file. Valid values include aac, flac, mp2,
	// mp3, pcm, and vorbis.
	Codec *string `type:"string"`

	// If you specified AAC for Audio:Codec, this is the AAC compression profile
	// to use. Valid values include:
	//
	// auto, AAC-LC, HE-AAC, HE-AACv2
	//
	// If you specify auto, Elastic Transcoder chooses a profile based on the bit
	// rate of the output file.
	CodecOptions *AudioCodecOptions `type:"structure"`

	// The sample rate of the audio stream in the output file, in Hertz. Valid values
	// include:
	//
	// auto, 22050, 32000, 44100, 48000, 96000
	//
	// If you specify auto, Elastic Transcoder automatically detects the sample
	// rate.
	SampleRate *string `type:"string"`
}

// String returns the string representation
func (s AudioParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AudioParameters) GoString() string {
	return s.String()
}

// SetAudioPackingMode sets the AudioPackingMode field's value.
func (s *AudioParameters) SetAudioPackingMode(v string) *AudioParameters {
	s.AudioPackingMode = &v
	return s
}

// SetBitRate sets the BitRate field's value.
func (s *AudioParameters) SetBitRate(v string) *AudioParameters {
	s.BitRate = &v
	return s
}

// SetChannels sets the Channels field's value.
func (s *AudioParameters) SetChannels(v string) *AudioParameters {
	s.Channels = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *AudioParameters) SetCodec(v string) *AudioParameters {
	s.Codec = &v
	return s
}

// SetCodecOptions sets the CodecOptions field's value.
func (s *AudioParameters) SetCodecOptions(v *AudioCodecOptions) *AudioParameters {
	s.CodecOptions = v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AudioParameters) SetSampleRate(v string) *AudioParameters {
	s.SampleRate = &v
	return s
}

// The CancelJobRequest structure.
type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job that you want to cancel.
	//
	// To get a list of the jobs (including their jobId) that have a status of Submitted,
	// use the ListJobsByStatus API action.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *CancelJobInput) SetId(v string) *CancelJobInput {
	s.Id = &v
	return s
}

// The response body contains a JSON object. If the job is successfully canceled,
// the value of Success is true.
type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// The file format of the output captions. If you leave this value blank, Elastic
// Transcoder returns an error.
type CaptionFormat struct {
	_ struct{} `type:"structure"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your caption formats.
	Encryption *Encryption `type:"structure"`

	// The format you specify determines whether Elastic Transcoder generates an
	// embedded or sidecar caption for this output.
	//
	//    * Valid Embedded Caption Formats:
	//
	// for FLAC: None
	//
	// For MP3: None
	//
	// For MP4: mov-text
	//
	// For MPEG-TS: None
	//
	// For ogg: None
	//
	// For webm: None
	//
	//    * Valid Sidecar Caption Formats: Elastic Transcoder supports dfxp (first
	//    div element only), scc, srt, and webvtt. If you want ttml or smpte-tt
	//    compatible captions, specify dfxp as your output format.
	//
	// For FMP4: dfxp
	//
	// Non-FMP4 outputs: All sidecar types
	//
	// fmp4 captions have an extension of .ismt
	Format *string `type:"string"`

	// The prefix for caption filenames, in the form description-{language}, where:
	//
	//    * description is a description of the video.
	//
	//    * {language} is a literal value that Elastic Transcoder replaces with
	//    the two- or three-letter code for the language of the caption in the output
	//    file names.
	//
	// If you don't include {language} in the file name pattern, Elastic Transcoder
	// automatically appends "{language}" to the value that you specify for the
	// description. In addition, Elastic Transcoder automatically appends the count
	// to the end of the segment files.
	//
	// For example, suppose you're transcoding into srt format. When you enter "Sydney-{language}-sunrise",
	// and the language of the captions is English (en), the name of the first caption
	// file is be Sydney-en-sunrise00000.srt.
	Pattern *string `type:"string"`
}

// String returns the string representation
func (s CaptionFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionFormat) GoString() string {
	return s.String()
}

// SetEncryption sets the Encryption field's value.
func (s *CaptionFormat) SetEncryption(v *Encryption) *CaptionFormat {
	s.Encryption = v
	return s
}

// SetFormat sets the Format field's value.
func (s *CaptionFormat) SetFormat(v string) *CaptionFormat {
	s.Format = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *CaptionFormat) SetPattern(v string) *CaptionFormat {
	s.Pattern = &v
	return s
}

// A source file for the input sidecar captions used during the transcoding
// process.
type CaptionSource struct {
	_ struct{} `type:"structure"`

	// The encryption settings, if any, that Elastic Transcoder needs to decyrpt
	// your caption sources, or that you want Elastic Transcoder to apply to your
	// caption sources.
	Encryption *Encryption `type:"structure"`

	// The name of the sidecar caption file that you want Elastic Transcoder to
	// include in the output file.
	Key *string `min:"1" type:"string"`

	// The label of the caption shown in the player when choosing a language. We
	// recommend that you put the caption language name here, in the language of
	// the captions.
	Label *string `min:"1" type:"string"`

	// A string that specifies the language of the caption. If you specified multiple
	// inputs with captions, the caption language must match in order to be included
	// in the output. Specify this as one of:
	//
	//    * 2-character ISO 639-1 code
	//
	//    * 3-character ISO 639-2 code
	//
	// For more information on ISO language codes and language names, see the List
	// of ISO 639-1 codes.
	Language *string `min:"1" type:"string"`

	// For clip generation or captions that do not start at the same time as the
	// associated video file, the TimeOffset tells Elastic Transcoder how much of
	// the video to encode before including captions.
	//
	// Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.
	TimeOffset *string `type:"string"`
}

// String returns the string representation
func (s CaptionSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaptionSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CaptionSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CaptionSource"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Label != nil && len(*s.Label) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Label", 1))
	}
	if s.Language != nil && len(*s.Language) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Language", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *CaptionSource) SetEncryption(v *Encryption) *CaptionSource {
	s.Encryption = v
	return s
}

// SetKey sets the Key field's value.
func (s *CaptionSource) SetKey(v string) *CaptionSource {
	s.Key = &v
	return s
}

// SetLabel sets the Label field's value.
func (s *CaptionSource) SetLabel(v string) *CaptionSource {
	s.Label = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CaptionSource) SetLanguage(v string) *CaptionSource {
	s.Language = &v
	return s
}

// SetTimeOffset sets the TimeOffset field's value.
func (s *CaptionSource) SetTimeOffset(v string) *CaptionSource {
	s.TimeOffset = &v
	return s
}

// The captions to be created, if any.
type Captions struct {
	_ struct{} `type:"structure"`

	// The array of file formats for the output captions. If you leave this value
	// blank, Elastic Transcoder returns an error.
	CaptionFormats []*CaptionFormat `type:"list"`

	// Source files for the input sidecar captions used during the transcoding process.
	// To omit all sidecar captions, leave CaptionSources blank.
	CaptionSources []*CaptionSource `deprecated:"true" type:"list"`

	// A policy that determines how Elastic Transcoder handles the existence of
	// multiple captions.
	//
	//    * MergeOverride: Elastic Transcoder transcodes both embedded and sidecar
	//    captions into outputs. If captions for a language are embedded in the
	//    input file and also appear in a sidecar file, Elastic Transcoder uses
	//    the sidecar captions and ignores the embedded captions for that language.
	//
	//    * MergeRetain: Elastic Transcoder transcodes both embedded and sidecar
	//    captions into outputs. If captions for a language are embedded in the
	//    input file and also appear in a sidecar file, Elastic Transcoder uses
	//    the embedded captions and ignores the sidecar captions for that language.
	//    If CaptionSources is empty, Elastic Transcoder omits all sidecar captions
	//    from the output files.
	//
	//    * Override: Elastic Transcoder transcodes only the sidecar captions that
	//    you specify in CaptionSources.
	//
	// MergePolicy cannot be null.
	MergePolicy *string `deprecated:"true" type:"string"`
}

// String returns the string representation
func (s Captions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Captions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Captions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Captions"}
	if s.CaptionSources != nil {
		for i, v := range s.CaptionSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionFormats sets the CaptionFormats field's value.
func (s *Captions) SetCaptionFormats(v []*CaptionFormat) *Captions {
	s.CaptionFormats = v
	return s
}

// SetCaptionSources sets the CaptionSources field's value.
func (s *Captions) SetCaptionSources(v []*CaptionSource) *Captions {
	s.CaptionSources = v
	return s
}

// SetMergePolicy sets the MergePolicy field's value.
func (s *Captions) SetMergePolicy(v string) *Captions {
	s.MergePolicy = &v
	return s
}

// Settings for one clip in a composition. All jobs in a playlist must have
// the same clip settings.
type Clip struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// Settings that determine when a clip begins and how long it lasts.
	TimeSpan *TimeSpan `type:"structure"`
}

// String returns the string representation
func (s Clip) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Clip) GoString() string {
	return s.String()
}

// SetTimeSpan sets the TimeSpan field's value.
func (s *Clip) SetTimeSpan(v *TimeSpan) *Clip {
	s.TimeSpan = v
	return s
}

// The CreateJobRequest structure.
type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// A section of the request body that provides information about the file that
	// is being transcoded.
	Input *JobInput `type:"structure"`

	// A section of the request body that provides information about the files that
	// are being transcoded.
	Inputs []*JobInput `type:"list"`

	// A section of the request body that provides information about the transcoded
	// (target) file. We strongly recommend that you use the Outputs syntax instead
	// of the Output syntax.
	Output *CreateJobOutput `type:"structure"`

	// The value, if any, that you want Elastic Transcoder to prepend to the names
	// of all files that this job creates, including output files, thumbnails, and
	// playlists.
	OutputKeyPrefix *string `min:"1" type:"string"`

	// A section of the request body that provides information about the transcoded
	// (target) files. We recommend that you use the Outputs syntax instead of the
	// Output syntax.
	Outputs []*CreateJobOutput `type:"list"`

	// The Id of the pipeline that you want Elastic Transcoder to use for transcoding.
	// The pipeline determines several settings, including the Amazon S3 bucket
	// from which Elastic Transcoder gets the files to transcode and the bucket
	// into which Elastic Transcoder puts the transcoded files.
	//
	// PipelineId is a required field
	PipelineId *string `type:"string" required:"true"`

	// If you specify a preset in PresetId for which the value of Container is fmp4
	// (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the
	// master playlists that you want Elastic Transcoder to create.
	//
	// The maximum number of master playlists in a job is 30.
	Playlists []*CreateJobPlaylist `type:"list"`

	// User-defined metadata that you want to associate with an Elastic Transcoder
	// job. You specify metadata in key/value pairs, and you can add up to 10 key/value
	// pairs per job. Elastic Transcoder does not guarantee that key/value pairs
	// are returned in the same order in which you specify them.
	UserMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.OutputKeyPrefix != nil && len(*s.OutputKeyPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKeyPrefix", 1))
	}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}
	if s.Inputs != nil {
		for i, v := range s.Inputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Inputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Output != nil {
		if err := s.Output.Validate(); err != nil {
			invalidParams.AddNested("Output", err.(request.ErrInvalidParams))
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Playlists != nil {
		for i, v := range s.Playlists {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Playlists", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInput sets the Input field's value.
func (s *CreateJobInput) SetInput(v *JobInput) *CreateJobInput {
	s.Input = v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *CreateJobInput) SetInputs(v []*JobInput) *CreateJobInput {
	s.Inputs = v
	return s
}

// SetOutput sets the Output field's value.
func (s *CreateJobInput) SetOutput(v *CreateJobOutput) *CreateJobInput {
	s.Output = v
	return s
}

// SetOutputKeyPrefix sets the OutputKeyPrefix field's value.
func (s *CreateJobInput) SetOutputKeyPrefix(v string) *CreateJobInput {
	s.OutputKeyPrefix = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateJobInput) SetOutputs(v []*CreateJobOutput) *CreateJobInput {
	s.Outputs = v
	return s
}

// SetPipelineId sets the PipelineId field's value.
func (s *CreateJobInput) SetPipelineId(v string) *CreateJobInput {
	s.PipelineId = &v
	return s
}

// SetPlaylists sets the Playlists field's value.
func (s *CreateJobInput) SetPlaylists(v []*CreateJobPlaylist) *CreateJobInput {
	s.Playlists = v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *CreateJobInput) SetUserMetadata(v map[string]*string) *CreateJobInput {
	s.UserMetadata = v
	return s
}

// The CreateJobOutput structure.
type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about the album art that you want Elastic Transcoder to add to
	// the file during transcoding. You can specify up to twenty album artworks
	// for each output. Settings for each artwork must be defined in the job for
	// the current output.
	AlbumArt *JobAlbumArt `type:"structure"`

	// You can configure Elastic Transcoder to transcode captions, or subtitles,
	// from one format to another. All captions must be in UTF-8. Elastic Transcoder
	// supports two types of captions:
	//
	//    * Embedded: Embedded captions are included in the same file as the audio
	//    and video. Elastic Transcoder supports only one embedded caption per language,
	//    to a maximum of 300 embedded captions per file.
	//
	// Valid input values include: CEA-608 (EIA-608, first non-empty channel only),
	//    CEA-708 (EIA-708, first non-empty channel only), and mov-text
	//
	// Valid outputs include: mov-text
	//
	// Elastic Transcoder supports a maximum of one embedded format per output.
	//
	//    * Sidecar: Sidecar captions are kept in a separate metadata file from
	//    the audio and video data. Sidecar captions require a player that is capable
	//    of understanding the relationship between the video file and the sidecar
	//    file. Elastic Transcoder supports only one sidecar caption per language,
	//    to a maximum of 20 sidecar captions per file.
	//
	// Valid input values include: dfxp (first div element only), ebu-tt, scc, smpt,
	//    srt, ttml (first div element only), and webvtt
	//
	// Valid outputs include: dfxp (first div element only), scc, srt, and webvtt.
	//
	// If you want ttml or smpte-tt compatible captions, specify dfxp as your output
	// format.
	//
	// Elastic Transcoder does not support OCR (Optical Character Recognition),
	// does not accept pictures as a valid input for captions, and is not available
	// for audio-only transcoding. Elastic Transcoder does not preserve text formatting
	// (for example, italics) during the transcoding process.
	//
	// To remove captions or leave the captions empty, set Captions to null. To
	// pass through existing captions unchanged, set the MergePolicy to MergeRetain,
	// and pass in a null CaptionSources array.
	//
	// For more information on embedded files, see the Subtitles Wikipedia page.
	//
	// For more information on sidecar files, see the Extensible Metadata Platform
	// and Sidecar file Wikipedia pages.
	Captions *Captions `type:"structure"`

	// You can create an output file that contains an excerpt from the input file.
	// This excerpt, called a clip, can come from the beginning, middle, or end
	// of the file. The Composition object contains settings for the clips that
	// make up an output file. For the current release, you can only specify settings
	// for a single clip per output file. The Composition object cannot be null.
	Composition []*Clip `deprecated:"true" type:"list"`

	// You can specify encryption settings for any output files that you want to
	// use for a transcoding job. This includes the output file and any watermarks,
	// thumbnails, album art, or captions that you want to use. You must specify
	// encryption settings for each file individually.
	Encryption *Encryption `type:"structure"`

	// The name to assign to the transcoded file. Elastic Transcoder saves the file
	// in the Amazon S3 bucket specified by the OutputBucket object in the pipeline
	// that is specified by the pipeline ID. If a file with the specified name already
	// exists in the output bucket, the job fails.
	Key *string `min:"1" type:"string"`

	// The Id of the preset to use for this job. The preset determines the audio,
	// video, and thumbnail settings that Elastic Transcoder uses for transcoding.
	PresetId *string `type:"string"`

	// The number of degrees clockwise by which you want Elastic Transcoder to rotate
	// the output relative to the input. Enter one of the following values: auto,
	// 0, 90, 180, 270. The value auto generally works only if the file that you're
	// transcoding contains rotation metadata.
	Rotate *string `type:"string"`

	// (Outputs in Fragmented MP4 or MPEG-TS format only.
	//
	// If you specify a preset in PresetId for which the value of Container is fmp4
	// (Fragmented MP4) or ts (MPEG-TS), SegmentDuration is the target maximum duration
	// of each segment in seconds. For HLSv3 format playlists, each media segment
	// is stored in a separate .ts file. For HLSv4 and Smooth playlists, all media
	// segments for an output are stored in a single file. Each segment is approximately
	// the length of the SegmentDuration, though individual segments might be shorter
	// or longer.
	//
	// The range of valid values is 1 to 60 seconds. If the duration of the video
	// is not evenly divisible by SegmentDuration, the duration of the last segment
	// is the remainder of total length/SegmentDuration.
	//
	// Elastic Transcoder creates an output-specific playlist for each output HLS
	// output that you specify in OutputKeys. To add an output to the master playlist
	// for this job, include it in the OutputKeys of the associated playlist.
	SegmentDuration *string `type:"string"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your thumbnail.
	ThumbnailEncryption *Encryption `type:"structure"`

	// Whether you want Elastic Transcoder to create thumbnails for your videos
	// and, if so, how you want Elastic Transcoder to name the files.
	//
	// If you don't want Elastic Transcoder to create thumbnails, specify "".
	//
	// If you do want Elastic Transcoder to create thumbnails, specify the information
	// that you want to include in the file name for each thumbnail. You can specify
	// the following values in any sequence:
	//
	//    * {count} (Required): If you want to create thumbnails, you must include
	//    {count} in the ThumbnailPattern object. Wherever you specify {count},
	//    Elastic Transcoder adds a five-digit sequence number (beginning with 00001)
	//    to thumbnail file names. The number indicates where a given thumbnail
	//    appears in the sequence of thumbnails for a transcoded file.
	//
	// If you specify a literal value and/or {resolution} but you omit {count},
	//    Elastic Transcoder returns a validation error and does not create the
	//    job.
	//
	//    * Literal values (Optional): You can specify literal values anywhere in
	//    the ThumbnailPattern object. For example, you can include them as a file
	//    name prefix or as a delimiter between {resolution} and {count}.
	//
	//    * {resolution} (Optional): If you want Elastic Transcoder to include the
	//    resolution in the file name, include {resolution} in the ThumbnailPattern
	//    object.
	//
	// When creating thumbnails, Elastic Transcoder automatically saves the files
	// in the format (.jpg or .png) that appears in the preset that you specified
	// in the PresetID value of CreateJobOutput. Elastic Transcoder also appends
	// the applicable file name extension.
	ThumbnailPattern *string `type:"string"`

	// Information about the watermarks that you want Elastic Transcoder to add
	// to the video during transcoding. You can specify up to four watermarks for
	// each output. Settings for each watermark must be defined in the preset for
	// the current output.
	Watermarks []*JobWatermark `type:"list"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobOutput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.AlbumArt != nil {
		if err := s.AlbumArt.Validate(); err != nil {
			invalidParams.AddNested("AlbumArt", err.(request.ErrInvalidParams))
		}
	}
	if s.Captions != nil {
		if err := s.Captions.Validate(); err != nil {
			invalidParams.AddNested("Captions", err.(request.ErrInvalidParams))
		}
	}
	if s.Watermarks != nil {
		for i, v := range s.Watermarks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Watermarks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlbumArt sets the AlbumArt field's value.
func (s *CreateJobOutput) SetAlbumArt(v *JobAlbumArt) *CreateJobOutput {
	s.AlbumArt = v
	return s
}

// SetCaptions sets the Captions field's value.
func (s *CreateJobOutput) SetCaptions(v *Captions) *CreateJobOutput {
	s.Captions = v
	return s
}

// SetComposition sets the Composition field's value.
func (s *CreateJobOutput) SetComposition(v []*Clip) *CreateJobOutput {
	s.Composition = v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *CreateJobOutput) SetEncryption(v *Encryption) *CreateJobOutput {
	s.Encryption = v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateJobOutput) SetKey(v string) *CreateJobOutput {
	s.Key = &v
	return s
}

// SetPresetId sets the PresetId field's value.
func (s *CreateJobOutput) SetPresetId(v string) *CreateJobOutput {
	s.PresetId = &v
	return s
}

// SetRotate sets the Rotate field's value.
func (s *CreateJobOutput) SetRotate(v string) *CreateJobOutput {
	s.Rotate = &v
	return s
}

// SetSegmentDuration sets the SegmentDuration field's value.
func (s *CreateJobOutput) SetSegmentDuration(v string) *CreateJobOutput {
	s.SegmentDuration = &v
	return s
}

// SetThumbnailEncryption sets the ThumbnailEncryption field's value.
func (s *CreateJobOutput) SetThumbnailEncryption(v *Encryption) *CreateJobOutput {
	s.ThumbnailEncryption = v
	return s
}

// SetThumbnailPattern sets the ThumbnailPattern field's value.
func (s *CreateJobOutput) SetThumbnailPattern(v string) *CreateJobOutput {
	s.ThumbnailPattern = &v
	return s
}

// SetWatermarks sets the Watermarks field's value.
func (s *CreateJobOutput) SetWatermarks(v []*JobWatermark) *CreateJobOutput {
	s.Watermarks = v
	return s
}

// Information about the master playlist.
type CreateJobPlaylist struct {
	_ struct{} `type:"structure"`

	// The format of the output playlist. Valid formats include HLSv3, HLSv4, and
	// Smooth.
	Format *string `type:"string"`

	// The HLS content protection settings, if any, that you want Elastic Transcoder
	// to apply to the output files associated with this playlist.
	HlsContentProtection *HlsContentProtection `type:"structure"`

	// The name that you want Elastic Transcoder to assign to the master playlist,
	// for example, nyc-vacation.m3u8. If the name includes a / character, the section
	// of the name before the last / must be identical for all Name objects. If
	// you create more than one master playlist, the values of all Name objects
	// must be unique.
	//
	// Elastic Transcoder automatically appends the relevant file extension to the
	// file name (.m3u8 for HLSv3 and HLSv4 playlists, and .ism and .ismc for Smooth
	// playlists). If you include a file extension in Name, the file name will have
	// two extensions.
	Name *string `min:"1" type:"string"`

	// For each output in this job that you want to include in a master playlist,
	// the value of the Outputs:Key object.
	//
	//    * If your output is not HLS or does not have a segment duration set, the
	//    name of the output file is a concatenation of OutputKeyPrefix and Outputs:Key:
	//
	// OutputKeyPrefixOutputs:Key
	//
	//    * If your output is HLSv3 and has a segment duration set, or is not included
	//    in a playlist, Elastic Transcoder creates an output playlist file with
	//    a file extension of .m3u8, and a series of .ts files that include a five-digit
	//    sequential counter beginning with 00000:
	//
	// OutputKeyPrefixOutputs:Key.m3u8
	//
	// OutputKeyPrefixOutputs:Key00000.ts
	//
	//    * If your output is HLSv4, has a segment duration set, and is included
	//    in an HLSv4 playlist, Elastic Transcoder creates an output playlist file
	//    with a file extension of _v4.m3u8. If the output is video, Elastic Transcoder
	//    also creates an output file with an extension of _iframe.m3u8:
	//
	// OutputKeyPrefixOutputs:Key_v4.m3u8
	//
	// OutputKeyPrefixOutputs:Key_iframe.m3u8
	//
	// OutputKeyPrefixOutputs:Key.ts
	//
	// Elastic Transcoder automatically appends the relevant file extension to the
	// file name. If you include a file extension in Output Key, the file name will
	// have two extensions.
	//
	// If you include more than one output in a playlist, any segment duration settings,
	// clip settings, or caption settings must be the same for all outputs in the
	// playlist. For Smooth playlists, the Audio:Profile, Video:Profile, and Video:FrameRate
	// to Video:KeyframesMaxDist ratio must be the same for all outputs.
	OutputKeys []*string `type:"list"`

	// The DRM settings, if any, that you want Elastic Transcoder to apply to the
	// output files associated with this playlist.
	PlayReadyDrm *PlayReadyDrm `type:"structure"`
}

// String returns the string representation
func (s CreateJobPlaylist) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobPlaylist) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobPlaylist) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobPlaylist"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PlayReadyDrm != nil {
		if err := s.PlayReadyDrm.Validate(); err != nil {
			invalidParams.AddNested("PlayReadyDrm", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *CreateJobPlaylist) SetFormat(v string) *CreateJobPlaylist {
	s.Format = &v
	return s
}

// SetHlsContentProtection sets the HlsContentProtection field's value.
func (s *CreateJobPlaylist) SetHlsContentProtection(v *HlsContentProtection) *CreateJobPlaylist {
	s.HlsContentProtection = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJobPlaylist) SetName(v string) *CreateJobPlaylist {
	s.Name = &v
	return s
}

// SetOutputKeys sets the OutputKeys field's value.
func (s *CreateJobPlaylist) SetOutputKeys(v []*string) *CreateJobPlaylist {
	s.OutputKeys = v
	return s
}

// SetPlayReadyDrm sets the PlayReadyDrm field's value.
func (s *CreateJobPlaylist) SetPlayReadyDrm(v *PlayReadyDrm) *CreateJobPlaylist {
	s.PlayReadyDrm = v
	return s
}

// The CreateJobResponse structure.
type CreateJobResponse struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the job that
	// is created.
	Job *Job `type:"structure"`
}

// String returns the string representation
func (s CreateJobResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobResponse) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *CreateJobResponse) SetJob(v *Job) *CreateJobResponse {
	s.Job = v
	return s
}

// The CreatePipelineRequest structure.
type CreatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that you want to use with this
	// pipeline.
	//
	// If you use either S3 or S3-AWS-KMS as your Encryption:Mode, you don't need
	// to provide a key with your job because a default key, known as an AWS-KMS
	// key, is created for you automatically. You need to provide an AWS-KMS key
	// only if you want to use a non-default AWS-KMS key, or if you are using an
	// Encryption:Mode of AES-PKCS7, AES-CTR, or AES-GCM.
	AwsKmsKeyArn *string `type:"string"`

	// The optional ContentConfig object specifies information about the Amazon
	// S3 bucket in which you want Elastic Transcoder to save transcoded files and
	// playlists: which bucket to use, which users you want to have access to the
	// files, the type of access you want users to have, and the storage class that
	// you want to assign to the files.
	//
	// If you specify values for ContentConfig, you must also specify values for
	// ThumbnailConfig.
	//
	// If you specify values for ContentConfig and ThumbnailConfig, omit the OutputBucket
	// object.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save transcoded files and playlists.
	//
	//    * Permissions (Optional): The Permissions object specifies which users
	//    you want to have access to transcoded files and the type of access you
	//    want them to have. You can grant permissions to a maximum of 30 users
	//    and/or predefined Amazon S3 groups.
	//
	//    * Grantee Type: Specify the type of value that appears in the Grantee
	//    object:
	//
	// Canonical: The value in the Grantee object is either the canonical user ID
	//    for an AWS account or an origin access identity for an Amazon CloudFront
	//    distribution. For more information about canonical user IDs, see Access
	//    Control List (ACL) Overview in the Amazon Simple Storage Service Developer
	//    Guide. For more information about using CloudFront origin access identities
	//    to require that users use CloudFront URLs instead of Amazon S3 URLs, see
	//    Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	// Email: The value in the Grantee object is the registered email address of
	//    an AWS account.
	//
	// Group: The value in the Grantee object is one of the following predefined
	//    Amazon S3 groups: AllUsers, AuthenticatedUsers, or LogDelivery.
	//
	//    * Grantee: The AWS user or group that you want to have access to transcoded
	//    files and playlists. To identify the user or group, you can specify the
	//    canonical user ID for an AWS account, an origin access identity for a
	//    CloudFront distribution, the registered email address of an AWS account,
	//    or a predefined Amazon S3 group
	//
	//    * Access: The permission that you want to give to the AWS user that you
	//    specified in Grantee. Permissions are granted on the files that Elastic
	//    Transcoder adds to the bucket, including playlists and video files. Valid
	//    values include:
	//
	// READ: The grantee can read the objects and metadata for objects that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the objects that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the video files and playlists
	//    that it stores in your Amazon S3 bucket.
	ContentConfig *PipelineOutputConfig `type:"structure"`

	// The Amazon S3 bucket in which you saved the media files that you want to
	// transcode.
	//
	// InputBucket is a required field
	InputBucket *string `type:"string" required:"true"`

	// The name of the pipeline. We recommend that the name be unique within the
	// AWS account, but uniqueness is not enforced.
	//
	// Constraints: Maximum 40 characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Simple Notification Service (Amazon SNS) topic that you want to
	// notify to report job status.
	//
	// To receive notifications, you must also subscribe to the new topic in the
	// Amazon SNS console.
	//
	//    * Progressing: The topic ARN for the Amazon Simple Notification Service
	//    (Amazon SNS) topic that you want to notify when Elastic Transcoder has
	//    started to process a job in this pipeline. This is the ARN that Amazon
	//    SNS returned when you created the topic. For more information, see Create
	//    a Topic in the Amazon Simple Notification Service Developer Guide.
	//
	//    * Completed: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder has finished processing a job in this pipeline.
	//    This is the ARN that Amazon SNS returned when you created the topic.
	//
	//    * Warning: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters a warning condition while processing
	//    a job in this pipeline. This is the ARN that Amazon SNS returned when
	//    you created the topic.
	//
	//    * Error: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters an error condition while processing
	//    a job in this pipeline. This is the ARN that Amazon SNS returned when
	//    you created the topic.
	Notifications *Notifications `type:"structure"`

	// The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded
	// files. (Use this, or use ContentConfig:Bucket plus ThumbnailConfig:Bucket.)
	//
	// Specify this value when all of the following are true:
	//
	//    * You want to save transcoded files, thumbnails (if any), and playlists
	//    (if any) together in one bucket.
	//
	//    * You do not want to specify the users or groups who have access to the
	//    transcoded files, thumbnails, and playlists.
	//
	//    * You do not want to specify the permissions that Elastic Transcoder grants
	//    to the files.
	//
	// When Elastic Transcoder saves files in OutputBucket, it grants full control
	//    over the files only to the AWS account that owns the role that is specified
	//    by Role.
	//
	//    * You want to associate the transcoded files and thumbnails with the Amazon
	//    S3 Standard storage class.
	//
	// If you want to save transcoded files and playlists in one bucket and thumbnails
	// in another bucket, specify which users can access the transcoded files or
	// the permissions the users have, or change the Amazon S3 storage class, omit
	// OutputBucket and specify values for ContentConfig and ThumbnailConfig instead.
	OutputBucket *string `type:"string"`

	// The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder
	// to use to create the pipeline.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The ThumbnailConfig object specifies several values, including the Amazon
	// S3 bucket in which you want Elastic Transcoder to save thumbnail files, which
	// users you want to have access to the files, the type of access you want users
	// to have, and the storage class that you want to assign to the files.
	//
	// If you specify values for ContentConfig, you must also specify values for
	// ThumbnailConfig even if you don't want to create thumbnails.
	//
	// If you specify values for ContentConfig and ThumbnailConfig, omit the OutputBucket
	// object.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save thumbnail files.
	//
	//    * Permissions (Optional): The Permissions object specifies which users
	//    and/or predefined Amazon S3 groups you want to have access to thumbnail
	//    files, and the type of access you want them to have. You can grant permissions
	//    to a maximum of 30 users and/or predefined Amazon S3 groups.
	//
	//    * GranteeType: Specify the type of value that appears in the Grantee object:
	//
	//
	// Canonical: The value in the Grantee object is either the canonical user ID
	//    for an AWS account or an origin access identity for an Amazon CloudFront
	//    distribution.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	// Email: The value in the Grantee object is the registered email address of
	//    an AWS account.
	//
	// Group: The value in the Grantee object is one of the following predefined
	//    Amazon S3 groups: AllUsers, AuthenticatedUsers, or LogDelivery.
	//
	//    * Grantee: The AWS user or group that you want to have access to thumbnail
	//    files. To identify the user or group, you can specify the canonical user
	//    ID for an AWS account, an origin access identity for a CloudFront distribution,
	//    the registered email address of an AWS account, or a predefined Amazon
	//    S3 group.
	//
	//    * Access: The permission that you want to give to the AWS user that you
	//    specified in Grantee. Permissions are granted on the thumbnail files that
	//    Elastic Transcoder adds to the bucket. Valid values include:
	//
	// READ: The grantee can read the thumbnails and metadata for objects that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the thumbnails that it stores
	//    in your Amazon S3 bucket.
	ThumbnailConfig *PipelineOutputConfig `type:"structure"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipelineInput"}
	if s.InputBucket == nil {
		invalidParams.Add(request.NewErrParamRequired("InputBucket"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.ContentConfig != nil {
		if err := s.ContentConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ThumbnailConfig != nil {
		if err := s.ThumbnailConfig.Validate(); err != nil {
			invalidParams.AddNested("ThumbnailConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsKmsKeyArn sets the AwsKmsKeyArn field's value.
func (s *CreatePipelineInput) SetAwsKmsKeyArn(v string) *CreatePipelineInput {
	s.AwsKmsKeyArn = &v
	return s
}

// SetContentConfig sets the ContentConfig field's value.
func (s *CreatePipelineInput) SetContentConfig(v *PipelineOutputConfig) *CreatePipelineInput {
	s.ContentConfig = v
	return s
}

// SetInputBucket sets the InputBucket field's value.
func (s *CreatePipelineInput) SetInputBucket(v string) *CreatePipelineInput {
	s.InputBucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePipelineInput) SetName(v string) *CreatePipelineInput {
	s.Name = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *CreatePipelineInput) SetNotifications(v *Notifications) *CreatePipelineInput {
	s.Notifications = v
	return s
}

// SetOutputBucket sets the OutputBucket field's value.
func (s *CreatePipelineInput) SetOutputBucket(v string) *CreatePipelineInput {
	s.OutputBucket = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreatePipelineInput) SetRole(v string) *CreatePipelineInput {
	s.Role = &v
	return s
}

// SetThumbnailConfig sets the ThumbnailConfig field's value.
func (s *CreatePipelineInput) SetThumbnailConfig(v *PipelineOutputConfig) *CreatePipelineInput {
	s.ThumbnailConfig = v
	return s
}

// When you create a pipeline, Elastic Transcoder returns the values that you
// specified in the request.
type CreatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline
	// that is created.
	Pipeline *Pipeline `type:"structure"`

	// Elastic Transcoder returns a warning if the resources used by your pipeline
	// are not in the same region as the pipeline.
	//
	// Using resources in the same region, such as your Amazon S3 buckets, Amazon
	// SNS notification topics, and AWS KMS key, reduces processing time and prevents
	// cross-regional charges.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *CreatePipelineOutput) SetPipeline(v *Pipeline) *CreatePipelineOutput {
	s.Pipeline = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *CreatePipelineOutput) SetWarnings(v []*Warning) *CreatePipelineOutput {
	s.Warnings = v
	return s
}

// The CreatePresetRequest structure.
type CreatePresetInput struct {
	_ struct{} `type:"structure"`

	// A section of the request body that specifies the audio parameters.
	Audio *AudioParameters `type:"structure"`

	// The container type for the output file. Valid values include flac, flv, fmp4,
	// gif, mp3, mp4, mpg, mxf, oga, ogg, ts, and webm.
	//
	// Container is a required field
	Container *string `type:"string" required:"true"`

	// A description of the preset.
	Description *string `type:"string"`

	// The name of the preset. We recommend that the name be unique within the AWS
	// account, but uniqueness is not enforced.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A section of the request body that specifies the thumbnail parameters, if
	// any.
	Thumbnails *Thumbnails `type:"structure"`

	// A section of the request body that specifies the video parameters.
	Video *VideoParameters `type:"structure"`
}

// String returns the string representation
func (s CreatePresetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePresetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePresetInput"}
	if s.Container == nil {
		invalidParams.Add(request.NewErrParamRequired("Container"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *CreatePresetInput) SetAudio(v *AudioParameters) *CreatePresetInput {
	s.Audio = v
	return s
}

// SetContainer sets the Container field's value.
func (s *CreatePresetInput) SetContainer(v string) *CreatePresetInput {
	s.Container = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePresetInput) SetDescription(v string) *CreatePresetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePresetInput) SetName(v string) *CreatePresetInput {
	s.Name = &v
	return s
}

// SetThumbnails sets the Thumbnails field's value.
func (s *CreatePresetInput) SetThumbnails(v *Thumbnails) *CreatePresetInput {
	s.Thumbnails = v
	return s
}

// SetVideo sets the Video field's value.
func (s *CreatePresetInput) SetVideo(v *VideoParameters) *CreatePresetInput {
	s.Video = v
	return s
}

// The CreatePresetResponse structure.
type CreatePresetOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the preset
	// that is created.
	Preset *Preset `type:"structure"`

	// If the preset settings don't comply with the standards for the video codec
	// but Elastic Transcoder created the preset, this message explains the reason
	// the preset settings don't meet the standard. Elastic Transcoder created the
	// preset because the settings might produce acceptable output.
	Warning *string `type:"string"`
}

// String returns the string representation
func (s CreatePresetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePresetOutput) GoString() string {
	return s.String()
}

// SetPreset sets the Preset field's value.
func (s *CreatePresetOutput) SetPreset(v *Preset) *CreatePresetOutput {
	s.Preset = v
	return s
}

// SetWarning sets the Warning field's value.
func (s *CreatePresetOutput) SetWarning(v string) *CreatePresetOutput {
	s.Warning = &v
	return s
}

// The DeletePipelineRequest structure.
type DeletePipelineInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline that you want to delete.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipelineInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePipelineInput) SetId(v string) *DeletePipelineInput {
	s.Id = &v
	return s
}

// The DeletePipelineResponse structure.
type DeletePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

// The DeletePresetRequest structure.
type DeletePresetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the preset for which you want to get detailed information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePresetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePresetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePresetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePresetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeletePresetInput) SetId(v string) *DeletePresetInput {
	s.Id = &v
	return s
}

// The DeletePresetResponse structure.
type DeletePresetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePresetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePresetOutput) GoString() string {
	return s.String()
}

// The detected properties of the input file. Elastic Transcoder identifies
// these values from the input file.
type DetectedProperties struct {
	_ struct{} `type:"structure"`

	// The detected duration of the input file, in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The detected file size of the input file, in bytes.
	FileSize *int64 `type:"long"`

	// The detected frame rate of the input file, in frames per second.
	FrameRate *string `type:"string"`

	// The detected height of the input file, in pixels.
	Height *int64 `type:"integer"`

	// The detected width of the input file, in pixels.
	Width *int64 `type:"integer"`
}

// String returns the string representation
func (s DetectedProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectedProperties) GoString() string {
	return s.String()
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *DetectedProperties) SetDurationMillis(v int64) *DetectedProperties {
	s.DurationMillis = &v
	return s
}

// SetFileSize sets the FileSize field's value.
func (s *DetectedProperties) SetFileSize(v int64) *DetectedProperties {
	s.FileSize = &v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *DetectedProperties) SetFrameRate(v string) *DetectedProperties {
	s.FrameRate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *DetectedProperties) SetHeight(v int64) *DetectedProperties {
	s.Height = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *DetectedProperties) SetWidth(v int64) *DetectedProperties {
	s.Width = &v
	return s
}

// The encryption settings, if any, that are used for decrypting your input
// files or encrypting your output files. If your input file is encrypted, you
// must specify the mode that Elastic Transcoder uses to decrypt your file,
// otherwise you must specify the mode you want Elastic Transcoder to use to
// encrypt your output files.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The series of random bits created by a random bit generator, unique for every
	// encryption operation, that you used to encrypt your input files or that you
	// want Elastic Transcoder to use to encrypt your output files. The initialization
	// vector must be base64-encoded, and it must be exactly 16 bytes long before
	// being base64-encoded.
	InitializationVector *string `type:"string"`

	// The data encryption key that you want Elastic Transcoder to use to encrypt
	// your output file, or that was used to encrypt your input file. The key must
	// be base64-encoded and it must be one of the following bit lengths before
	// being base64-encoded:
	//
	// 128, 192, or 256.
	//
	// The key must also be encrypted by using the Amazon Key Management Service.
	Key *string `type:"string"`

	// The MD5 digest of the key that you used to encrypt your input file, or that
	// you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder
	// uses the key digest as a checksum to make sure your key was not corrupted
	// in transit. The key MD5 must be base64-encoded, and it must be exactly 16
	// bytes long before being base64-encoded.
	KeyMd5 *string `type:"string"`

	// The specific server-side encryption mode that you want Elastic Transcoder
	// to use when decrypting your input files or encrypting your output files.
	// Elastic Transcoder supports the following options:
	//
	//    * S3: Amazon S3 creates and manages the keys used for encrypting your
	//    files.
	//
	//    * S3-AWS-KMS: Amazon S3 calls the Amazon Key Management Service, which
	//    creates and manages the keys that are used for encrypting your files.
	//    If you specify S3-AWS-KMS and you don't want to use the default key, you
	//    must add the AWS-KMS key that you want to use to your pipeline.
	//
	//    * AES-CBC-PKCS7: A padded cipher-block mode of operation originally used
	//    for HLS files.
	//
	//    * AES-CTR: AES Counter Mode.
	//
	//    * AES-GCM: AES Galois Counter Mode, a mode of operation that is an authenticated
	//    encryption format, meaning that a file, key, or initialization vector
	//    that has been tampered with fails the decryption process.
	//
	// For all three AES options, you must provide the following settings, which
	// must be base64-encoded:
	//
	//    * Key
	//
	//    * Key MD5
	//
	//    * Initialization Vector
	//
	// For the AES modes, your private encryption keys and your unencrypted data
	// are never stored by AWS; therefore, it is important that you safely manage
	// your encryption keys. If you lose them, you won't be able to unencrypt your
	// data.
	Mode *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *Encryption) SetInitializationVector(v string) *Encryption {
	s.InitializationVector = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Encryption) SetKey(v string) *Encryption {
	s.Key = &v
	return s
}

// SetKeyMd5 sets the KeyMd5 field's value.
func (s *Encryption) SetKeyMd5(v string) *Encryption {
	s.KeyMd5 = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *Encryption) SetMode(v string) *Encryption {
	s.Mode = &v
	return s
}

// The HLS content protection settings, if any, that you want Elastic Transcoder
// to apply to your output files.
type HlsContentProtection struct {
	_ struct{} `type:"structure"`

	// If Elastic Transcoder is generating your key for you, you must leave this
	// field blank.
	//
	// The series of random bits created by a random bit generator, unique for every
	// encryption operation, that you want Elastic Transcoder to use to encrypt
	// your output files. The initialization vector must be base64-encoded, and
	// it must be exactly 16 bytes before being base64-encoded.
	InitializationVector *string `type:"string"`

	// If you want Elastic Transcoder to generate a key for you, leave this field
	// blank.
	//
	// If you choose to supply your own key, you must encrypt the key by using AWS
	// KMS. The key must be base64-encoded, and it must be one of the following
	// bit lengths before being base64-encoded:
	//
	// 128, 192, or 256.
	Key *string `type:"string"`

	// If Elastic Transcoder is generating your key for you, you must leave this
	// field blank.
	//
	// The MD5 digest of the key that you want Elastic Transcoder to use to encrypt
	// your output file, and that you want Elastic Transcoder to use as a checksum
	// to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded,
	// and it must be exactly 16 bytes before being base64- encoded.
	KeyMd5 *string `type:"string"`

	// Specify whether you want Elastic Transcoder to write your HLS license key
	// to an Amazon S3 bucket. If you choose WithVariantPlaylists, LicenseAcquisitionUrl
	// must be left blank and Elastic Transcoder writes your data key into the same
	// bucket as the associated playlist.
	KeyStoragePolicy *string `type:"string"`

	// The location of the license key required to decrypt your HLS playlist. The
	// URL must be an absolute path, and is referenced in the URI attribute of the
	// EXT-X-KEY metadata tag in the playlist file.
	LicenseAcquisitionUrl *string `type:"string"`

	// The content protection method for your output. The only valid value is: aes-128.
	//
	// This value is written into the method attribute of the EXT-X-KEY metadata
	// tag in the output playlist.
	Method *string `type:"string"`
}

// String returns the string representation
func (s HlsContentProtection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HlsContentProtection) GoString() string {
	return s.String()
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *HlsContentProtection) SetInitializationVector(v string) *HlsContentProtection {
	s.InitializationVector = &v
	return s
}

// SetKey sets the Key field's value.
func (s *HlsContentProtection) SetKey(v string) *HlsContentProtection {
	s.Key = &v
	return s
}

// SetKeyMd5 sets the KeyMd5 field's value.
func (s *HlsContentProtection) SetKeyMd5(v string) *HlsContentProtection {
	s.KeyMd5 = &v
	return s
}

// SetKeyStoragePolicy sets the KeyStoragePolicy field's value.
func (s *HlsContentProtection) SetKeyStoragePolicy(v string) *HlsContentProtection {
	s.KeyStoragePolicy = &v
	return s
}

// SetLicenseAcquisitionUrl sets the LicenseAcquisitionUrl field's value.
func (s *HlsContentProtection) SetLicenseAcquisitionUrl(v string) *HlsContentProtection {
	s.LicenseAcquisitionUrl = &v
	return s
}

// SetMethod sets the Method field's value.
func (s *HlsContentProtection) SetMethod(v string) *HlsContentProtection {
	s.Method = &v
	return s
}

// The captions to be created, if any.
type InputCaptions struct {
	_ struct{} `type:"structure"`

	// Source files for the input sidecar captions used during the transcoding process.
	// To omit all sidecar captions, leave CaptionSources blank.
	CaptionSources []*CaptionSource `type:"list"`

	// A policy that determines how Elastic Transcoder handles the existence of
	// multiple captions.
	//
	//    * MergeOverride: Elastic Transcoder transcodes both embedded and sidecar
	//    captions into outputs. If captions for a language are embedded in the
	//    input file and also appear in a sidecar file, Elastic Transcoder uses
	//    the sidecar captions and ignores the embedded captions for that language.
	//
	//    * MergeRetain: Elastic Transcoder transcodes both embedded and sidecar
	//    captions into outputs. If captions for a language are embedded in the
	//    input file and also appear in a sidecar file, Elastic Transcoder uses
	//    the embedded captions and ignores the sidecar captions for that language.
	//    If CaptionSources is empty, Elastic Transcoder omits all sidecar captions
	//    from the output files.
	//
	//    * Override: Elastic Transcoder transcodes only the sidecar captions that
	//    you specify in CaptionSources.
	//
	// MergePolicy cannot be null.
	MergePolicy *string `type:"string"`
}

// String returns the string representation
func (s InputCaptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputCaptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputCaptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputCaptions"}
	if s.CaptionSources != nil {
		for i, v := range s.CaptionSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CaptionSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCaptionSources sets the CaptionSources field's value.
func (s *InputCaptions) SetCaptionSources(v []*CaptionSource) *InputCaptions {
	s.CaptionSources = v
	return s
}

// SetMergePolicy sets the MergePolicy field's value.
func (s *InputCaptions) SetMergePolicy(v string) *InputCaptions {
	s.MergePolicy = &v
	return s
}

// A section of the response body that provides information about the job that
// is created.
type Job struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the job.
	Arn *string `type:"string"`

	// The identifier that Elastic Transcoder assigned to the job. You use this
	// value to get settings for the job or to delete the job.
	Id *string `type:"string"`

	// A section of the request or response body that provides information about
	// the file that is being transcoded.
	Input *JobInput `type:"structure"`

	// Information about the files that you're transcoding. If you specified multiple
	// files for this job, Elastic Transcoder stitches the files together to make
	// one output.
	Inputs []*JobInput `type:"list"`

	// If you specified one output for a job, information about that output. If
	// you specified multiple outputs for a job, the Output object lists information
	// about the first output. This duplicates the information that is listed for
	// the first output in the Outputs object.
	//
	// Outputs recommended instead.
	//
	// A section of the request or response body that provides information about
	// the transcoded (target) file.
	Output *JobOutput `type:"structure"`

	// The value, if any, that you want Elastic Transcoder to prepend to the names
	// of all files that this job creates, including output files, thumbnails, and
	// playlists. We recommend that you add a / or some other delimiter to the end
	// of the OutputKeyPrefix.
	OutputKeyPrefix *string `min:"1" type:"string"`

	// Information about the output files. We recommend that you use the Outputs
	// syntax for all jobs, even when you want Elastic Transcoder to transcode a
	// file into only one format. Do not use both the Outputs and Output syntaxes
	// in the same request. You can create a maximum of 30 outputs per job.
	//
	// If you specify more than one output for a job, Elastic Transcoder creates
	// the files for each output in the order in which you specify them in the job.
	Outputs []*JobOutput `type:"list"`

	// The Id of the pipeline that you want Elastic Transcoder to use for transcoding.
	// The pipeline determines several settings, including the Amazon S3 bucket
	// from which Elastic Transcoder gets the files to transcode and the bucket
	// into which Elastic Transcoder puts the transcoded files.
	PipelineId *string `type:"string"`

	// Outputs in Fragmented MP4 or MPEG-TS format only.
	//
	// If you specify a preset in PresetId for which the value of Container is fmp4
	// (Fragmented MP4) or ts (MPEG-TS), Playlists contains information about the
	// master playlists that you want Elastic Transcoder to create.
	//
	// The maximum number of master playlists in a job is 30.
	Playlists []*Playlist `type:"list"`

	// The status of the job: Submitted, Progressing, Complete, Canceled, or Error.
	Status *string `type:"string"`

	// Details about the timing of a job.
	Timing *Timing `type:"structure"`

	// User-defined metadata that you want to associate with an Elastic Transcoder
	// job. You specify metadata in key/value pairs, and you can add up to 10 key/value
	// pairs per job. Elastic Transcoder does not guarantee that key/value pairs
	// are returned in the same order in which you specify them.
	//
	// Metadata keys and values must use characters from the following list:
	//
	//    * 0-9
	//
	//    * A-Z and a-z
	//
	//    * Space
	//
	//    * The following symbols: _.:/=+-%@
	UserMetadata map[string]*string `type:"map"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Job) SetArn(v string) *Job {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *Job) SetId(v string) *Job {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *Job) SetInput(v *JobInput) *Job {
	s.Input = v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *Job) SetInputs(v []*JobInput) *Job {
	s.Inputs = v
	return s
}

// SetOutput sets the Output field's value.
func (s *Job) SetOutput(v *JobOutput) *Job {
	s.Output = v
	return s
}

// SetOutputKeyPrefix sets the OutputKeyPrefix field's value.
func (s *Job) SetOutputKeyPrefix(v string) *Job {
	s.OutputKeyPrefix = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Job) SetOutputs(v []*JobOutput) *Job {
	s.Outputs = v
	return s
}

// SetPipelineId sets the PipelineId field's value.
func (s *Job) SetPipelineId(v string) *Job {
	s.PipelineId = &v
	return s
}

// SetPlaylists sets the Playlists field's value.
func (s *Job) SetPlaylists(v []*Playlist) *Job {
	s.Playlists = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Job) SetStatus(v string) *Job {
	s.Status = &v
	return s
}

// SetTiming sets the Timing field's value.
func (s *Job) SetTiming(v *Timing) *Job {
	s.Timing = v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *Job) SetUserMetadata(v map[string]*string) *Job {
	s.UserMetadata = v
	return s
}

// The .jpg or .png file associated with an audio file.
type JobAlbumArt struct {
	_ struct{} `type:"structure"`

	// The file to be used as album art. There can be multiple artworks associated
	// with an audio file, to a maximum of 20. Valid formats are .jpg and .png
	Artwork []*Artwork `type:"list"`

	// A policy that determines how Elastic Transcoder handles the existence of
	// multiple album artwork files.
	//
	//    * Replace: The specified album art replaces any existing album art.
	//
	//    * Prepend: The specified album art is placed in front of any existing
	//    album art.
	//
	//    * Append: The specified album art is placed after any existing album art.
	//
	//    * Fallback: If the original input file contains artwork, Elastic Transcoder
	//    uses that artwork for the output. If the original input does not contain
	//    artwork, Elastic Transcoder uses the specified album art file.
	MergePolicy *string `type:"string"`
}

// String returns the string representation
func (s JobAlbumArt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobAlbumArt) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobAlbumArt) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobAlbumArt"}
	if s.Artwork != nil {
		for i, v := range s.Artwork {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Artwork", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtwork sets the Artwork field's value.
func (s *JobAlbumArt) SetArtwork(v []*Artwork) *JobAlbumArt {
	s.Artwork = v
	return s
}

// SetMergePolicy sets the MergePolicy field's value.
func (s *JobAlbumArt) SetMergePolicy(v string) *JobAlbumArt {
	s.MergePolicy = &v
	return s
}

// Information about the file that you're transcoding.
type JobInput struct {
	_ struct{} `type:"structure"`

	// The aspect ratio of the input file. If you want Elastic Transcoder to automatically
	// detect the aspect ratio of the input file, specify auto. If you want to specify
	// the aspect ratio for the output file, enter one of the following values:
	//
	// 1:1, 4:3, 3:2, 16:9
	//
	// If you specify a value other than auto, Elastic Transcoder disables automatic
	// detection of the aspect ratio.
	AspectRatio *string `type:"string"`

	// The container type for the input file. If you want Elastic Transcoder to
	// automatically detect the container type of the input file, specify auto.
	// If you want to specify the container type for the input file, enter one of
	// the following values:
	//
	// 3gp, aac, asf, avi, divx, flv, m4a, mkv, mov, mp3, mp4, mpeg, mpeg-ps, mpeg-ts,
	// mxf, ogg, vob, wav, webm
	Container *string `type:"string"`

	// The detected properties of the input file.
	DetectedProperties *DetectedProperties `type:"structure"`

	// The encryption settings, if any, that are used for decrypting your input
	// files. If your input file is encrypted, you must specify the mode that Elastic
	// Transcoder uses to decrypt your file.
	Encryption *Encryption `type:"structure"`

	// The frame rate of the input file. If you want Elastic Transcoder to automatically
	// detect the frame rate of the input file, specify auto. If you want to specify
	// the frame rate for the input file, enter one of the following values:
	//
	// 10, 15, 23.97, 24, 25, 29.97, 30, 60
	//
	// If you specify a value other than auto, Elastic Transcoder disables automatic
	// detection of the frame rate.
	FrameRate *string `type:"string"`

	// You can configure Elastic Transcoder to transcode captions, or subtitles,
	// from one format to another. All captions must be in UTF-8. Elastic Transcoder
	// supports two types of captions:
	//
	//    * Embedded: Embedded captions are included in the same file as the audio
	//    and video. Elastic Transcoder supports only one embedded caption per language,
	//    to a maximum of 300 embedded captions per file.
	//
	// Valid input values include: CEA-608 (EIA-608, first non-empty channel only),
	//    CEA-708 (EIA-708, first non-empty channel only), and mov-text
	//
	// Valid outputs include: mov-text
	//
	// Elastic Transcoder supports a maximum of one embedded format per output.
	//
	//    * Sidecar: Sidecar captions are kept in a separate metadata file from
	//    the audio and video data. Sidecar captions require a player that is capable
	//    of understanding the relationship between the video file and the sidecar
	//    file. Elastic Transcoder supports only one sidecar caption per language,
	//    to a maximum of 20 sidecar captions per file.
	//
	// Valid input values include: dfxp (first div element only), ebu-tt, scc, smpt,
	//    srt, ttml (first div element only), and webvtt
	//
	// Valid outputs include: dfxp (first div element only), scc, srt, and webvtt.
	//
	// If you want ttml or smpte-tt compatible captions, specify dfxp as your output
	// format.
	//
	// Elastic Transcoder does not support OCR (Optical Character Recognition),
	// does not accept pictures as a valid input for captions, and is not available
	// for audio-only transcoding. Elastic Transcoder does not preserve text formatting
	// (for example, italics) during the transcoding process.
	//
	// To remove captions or leave the captions empty, set Captions to null. To
	// pass through existing captions unchanged, set the MergePolicy to MergeRetain,
	// and pass in a null CaptionSources array.
	//
	// For more information on embedded files, see the Subtitles Wikipedia page.
	//
	// For more information on sidecar files, see the Extensible Metadata Platform
	// and Sidecar file Wikipedia pages.
	InputCaptions *InputCaptions `type:"structure"`

	// Whether the input file is interlaced. If you want Elastic Transcoder to automatically
	// detect whether the input file is interlaced, specify auto. If you want to
	// specify whether the input file is interlaced, enter one of the following
	// values:
	//
	// true, false
	//
	// If you specify a value other than auto, Elastic Transcoder disables automatic
	// detection of interlacing.
	Interlaced *string `type:"string"`

	// The name of the file to transcode. Elsewhere in the body of the JSON block
	// is the the ID of the pipeline to use for processing the job. The InputBucket
	// object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to
	// get the file from.
	//
	// If the file name includes a prefix, such as cooking/lasagna.mpg, include
	// the prefix in the key. If the file isn't in the specified bucket, Elastic
	// Transcoder returns an error.
	Key *string `min:"1" type:"string"`

	// This value must be auto, which causes Elastic Transcoder to automatically
	// detect the resolution of the input file.
	Resolution *string `type:"string"`

	// Settings for clipping an input. Each input can have different clip settings.
	TimeSpan *TimeSpan `type:"structure"`
}

// String returns the string representation
func (s JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.InputCaptions != nil {
		if err := s.InputCaptions.Validate(); err != nil {
			invalidParams.AddNested("InputCaptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAspectRatio sets the AspectRatio field's value.
func (s *JobInput) SetAspectRatio(v string) *JobInput {
	s.AspectRatio = &v
	return s
}

// SetContainer sets the Container field's value.
func (s *JobInput) SetContainer(v string) *JobInput {
	s.Container = &v
	return s
}

// SetDetectedProperties sets the DetectedProperties field's value.
func (s *JobInput) SetDetectedProperties(v *DetectedProperties) *JobInput {
	s.DetectedProperties = v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *JobInput) SetEncryption(v *Encryption) *JobInput {
	s.Encryption = v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *JobInput) SetFrameRate(v string) *JobInput {
	s.FrameRate = &v
	return s
}

// SetInputCaptions sets the InputCaptions field's value.
func (s *JobInput) SetInputCaptions(v *InputCaptions) *JobInput {
	s.InputCaptions = v
	return s
}

// SetInterlaced sets the Interlaced field's value.
func (s *JobInput) SetInterlaced(v string) *JobInput {
	s.Interlaced = &v
	return s
}

// SetKey sets the Key field's value.
func (s *JobInput) SetKey(v string) *JobInput {
	s.Key = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *JobInput) SetResolution(v string) *JobInput {
	s.Resolution = &v
	return s
}

// SetTimeSpan sets the TimeSpan field's value.
func (s *JobInput) SetTimeSpan(v *TimeSpan) *JobInput {
	s.TimeSpan = v
	return s
}

// Outputs recommended instead.
//
// If you specified one output for a job, information about that output. If
// you specified multiple outputs for a job, the Output object lists information
// about the first output. This duplicates the information that is listed for
// the first output in the Outputs object.
type JobOutput struct {
	_ struct{} `type:"structure"`

	// The album art to be associated with the output file, if any.
	AlbumArt *JobAlbumArt `type:"structure"`

	// If Elastic Transcoder used a preset with a ColorSpaceConversionMode to transcode
	// the output file, the AppliedColorSpaceConversion parameter shows the conversion
	// used. If no ColorSpaceConversionMode was defined in the preset, this parameter
	// is not be included in the job response.
	AppliedColorSpaceConversion *string `type:"string"`

	// You can configure Elastic Transcoder to transcode captions, or subtitles,
	// from one format to another. All captions must be in UTF-8. Elastic Transcoder
	// supports two types of captions:
	//
	//    * Embedded: Embedded captions are included in the same file as the audio
	//    and video. Elastic Transcoder supports only one embedded caption per language,
	//    to a maximum of 300 embedded captions per file.
	//
	// Valid input values include: CEA-608 (EIA-608, first non-empty channel only),
	//    CEA-708 (EIA-708, first non-empty channel only), and mov-text
	//
	// Valid outputs include: mov-text
	//
	// Elastic Transcoder supports a maximum of one embedded format per output.
	//
	//    * Sidecar: Sidecar captions are kept in a separate metadata file from
	//    the audio and video data. Sidecar captions require a player that is capable
	//    of understanding the relationship between the video file and the sidecar
	//    file. Elastic Transcoder supports only one sidecar caption per language,
	//    to a maximum of 20 sidecar captions per file.
	//
	// Valid input values include: dfxp (first div element only), ebu-tt, scc, smpt,
	//    srt, ttml (first div element only), and webvtt
	//
	// Valid outputs include: dfxp (first div element only), scc, srt, and webvtt.
	//
	// If you want ttml or smpte-tt compatible captions, specify dfxp as your output
	// format.
	//
	// Elastic Transcoder does not support OCR (Optical Character Recognition),
	// does not accept pictures as a valid input for captions, and is not available
	// for audio-only transcoding. Elastic Transcoder does not preserve text formatting
	// (for example, italics) during the transcoding process.
	//
	// To remove captions or leave the captions empty, set Captions to null. To
	// pass through existing captions unchanged, set the MergePolicy to MergeRetain,
	// and pass in a null CaptionSources array.
	//
	// For more information on embedded files, see the Subtitles Wikipedia page.
	//
	// For more information on sidecar files, see the Extensible Metadata Platform
	// and Sidecar file Wikipedia pages.
	Captions *Captions `type:"structure"`

	// You can create an output file that contains an excerpt from the input file.
	// This excerpt, called a clip, can come from the beginning, middle, or end
	// of the file. The Composition object contains settings for the clips that
	// make up an output file. For the current release, you can only specify settings
	// for a single clip per output file. The Composition object cannot be null.
	Composition []*Clip `deprecated:"true" type:"list"`

	// Duration of the output file, in seconds.
	Duration *int64 `type:"long"`

	// Duration of the output file, in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your output files. If you choose to use encryption, you must specify a
	// mode to use. If you choose not to use encryption, Elastic Transcoder writes
	// an unencrypted file to your Amazon S3 bucket.
	Encryption *Encryption `type:"structure"`

	// File size of the output file, in bytes.
	FileSize *int64 `type:"long"`

	// Frame rate of the output file, in frames per second.
	FrameRate *string `type:"string"`

	// Height of the output file, in pixels.
	Height *int64 `type:"integer"`

	// A sequential counter, starting with 1, that identifies an output among the
	// outputs from the current job. In the Output syntax, this value is always
	// 1.
	Id *string `type:"string"`

	// The name to assign to the transcoded file. Elastic Transcoder saves the file
	// in the Amazon S3 bucket specified by the OutputBucket object in the pipeline
	// that is specified by the pipeline ID.
	Key *string `min:"1" type:"string"`

	// The value of the Id object for the preset that you want to use for this job.
	// The preset determines the audio, video, and thumbnail settings that Elastic
	// Transcoder uses for transcoding. To use a preset that you created, specify
	// the preset ID that Elastic Transcoder returned in the response when you created
	// the preset. You can also use the Elastic Transcoder system presets, which
	// you can get with ListPresets.
	PresetId *string `type:"string"`

	// The number of degrees clockwise by which you want Elastic Transcoder to rotate
	// the output relative to the input. Enter one of the following values:
	//
	// auto, 0, 90, 180, 270
	//
	// The value auto generally works only if the file that you're transcoding contains
	// rotation metadata.
	Rotate *string `type:"string"`

	// (Outputs in Fragmented MP4 or MPEG-TS format only.
	//
	// If you specify a preset in PresetId for which the value of Container is fmp4
	// (Fragmented MP4) or ts (MPEG-TS), SegmentDuration is the target maximum duration
	// of each segment in seconds. For HLSv3 format playlists, each media segment
	// is stored in a separate .ts file. For HLSv4, MPEG-DASH, and Smooth playlists,
	// all media segments for an output are stored in a single file. Each segment
	// is approximately the length of the SegmentDuration, though individual segments
	// might be shorter or longer.
	//
	// The range of valid values is 1 to 60 seconds. If the duration of the video
	// is not evenly divisible by SegmentDuration, the duration of the last segment
	// is the remainder of total length/SegmentDuration.
	//
	// Elastic Transcoder creates an output-specific playlist for each output HLS
	// output that you specify in OutputKeys. To add an output to the master playlist
	// for this job, include it in the OutputKeys of the associated playlist.
	SegmentDuration *string `type:"string"`

	// The status of one output in a job. If you specified only one output for the
	// job, Outputs:Status is always the same as Job:Status. If you specified more
	// than one output:
	//
	//    * Job:Status and Outputs:Status for all of the outputs is Submitted until
	//    Elastic Transcoder starts to process the first output.
	//
	//    * When Elastic Transcoder starts to process the first output, Outputs:Status
	//    for that output and Job:Status both change to Progressing. For each output,
	//    the value of Outputs:Status remains Submitted until Elastic Transcoder
	//    starts to process the output.
	//
	//    * Job:Status remains Progressing until all of the outputs reach a terminal
	//    status, either Complete or Error.
	//
	//    * When all of the outputs reach a terminal status, Job:Status changes
	//    to Complete only if Outputs:Status for all of the outputs is Complete.
	//    If Outputs:Status for one or more outputs is Error, the terminal status
	//    for Job:Status is also Error.
	//
	// The value of Status is one of the following: Submitted, Progressing, Complete,
	// Canceled, or Error.
	Status *string `type:"string"`

	// Information that further explains Status.
	StatusDetail *string `type:"string"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your thumbnail.
	ThumbnailEncryption *Encryption `type:"structure"`

	// Whether you want Elastic Transcoder to create thumbnails for your videos
	// and, if so, how you want Elastic Transcoder to name the files.
	//
	// If you don't want Elastic Transcoder to create thumbnails, specify "".
	//
	// If you do want Elastic Transcoder to create thumbnails, specify the information
	// that you want to include in the file name for each thumbnail. You can specify
	// the following values in any sequence:
	//
	//    * {count} (Required): If you want to create thumbnails, you must include
	//    {count} in the ThumbnailPattern object. Wherever you specify {count},
	//    Elastic Transcoder adds a five-digit sequence number (beginning with 00001)
	//    to thumbnail file names. The number indicates where a given thumbnail
	//    appears in the sequence of thumbnails for a transcoded file.
	//
	// If you specify a literal value and/or {resolution} but you omit {count},
	//    Elastic Transcoder returns a validation error and does not create the
	//    job.
	//
	//    * Literal values (Optional): You can specify literal values anywhere in
	//    the ThumbnailPattern object. For example, you can include them as a file
	//    name prefix or as a delimiter between {resolution} and {count}.
	//
	//    * {resolution} (Optional): If you want Elastic Transcoder to include the
	//    resolution in the file name, include {resolution} in the ThumbnailPattern
	//    object.
	//
	// When creating thumbnails, Elastic Transcoder automatically saves the files
	// in the format (.jpg or .png) that appears in the preset that you specified
	// in the PresetID value of CreateJobOutput. Elastic Transcoder also appends
	// the applicable file name extension.
	ThumbnailPattern *string `type:"string"`

	// Information about the watermarks that you want Elastic Transcoder to add
	// to the video during transcoding. You can specify up to four watermarks for
	// each output. Settings for each watermark must be defined in the preset that
	// you specify in Preset for the current output.
	//
	// Watermarks are added to the output video in the sequence in which you list
	// them in the job output—the first watermark in the list is added to the output
	// video first, the second watermark in the list is added next, and so on. As
	// a result, if the settings in a preset cause Elastic Transcoder to place all
	// watermarks in the same location, the second watermark that you add covers
	// the first one, the third one covers the second, and the fourth one covers
	// the third.
	Watermarks []*JobWatermark `type:"list"`

	// Specifies the width of the output file in pixels.
	Width *int64 `type:"integer"`
}

// String returns the string representation
func (s JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobOutput) GoString() string {
	return s.String()
}

// SetAlbumArt sets the AlbumArt field's value.
func (s *JobOutput) SetAlbumArt(v *JobAlbumArt) *JobOutput {
	s.AlbumArt = v
	return s
}

// SetAppliedColorSpaceConversion sets the AppliedColorSpaceConversion field's value.
func (s *JobOutput) SetAppliedColorSpaceConversion(v string) *JobOutput {
	s.AppliedColorSpaceConversion = &v
	return s
}

// SetCaptions sets the Captions field's value.
func (s *JobOutput) SetCaptions(v *Captions) *JobOutput {
	s.Captions = v
	return s
}

// SetComposition sets the Composition field's value.
func (s *JobOutput) SetComposition(v []*Clip) *JobOutput {
	s.Composition = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *JobOutput) SetDuration(v int64) *JobOutput {
	s.Duration = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *JobOutput) SetDurationMillis(v int64) *JobOutput {
	s.DurationMillis = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *JobOutput) SetEncryption(v *Encryption) *JobOutput {
	s.Encryption = v
	return s
}

// SetFileSize sets the FileSize field's value.
func (s *JobOutput) SetFileSize(v int64) *JobOutput {
	s.FileSize = &v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *JobOutput) SetFrameRate(v string) *JobOutput {
	s.FrameRate = &v
	return s
}

// SetHeight sets the Height field's value.
func (s *JobOutput) SetHeight(v int64) *JobOutput {
	s.Height = &v
	return s
}

// SetId sets the Id field's value.
func (s *JobOutput) SetId(v string) *JobOutput {
	s.Id = &v
	return s
}

// SetKey sets the Key field's value.
func (s *JobOutput) SetKey(v string) *JobOutput {
	s.Key = &v
	return s
}

// SetPresetId sets the PresetId field's value.
func (s *JobOutput) SetPresetId(v string) *JobOutput {
	s.PresetId = &v
	return s
}

// SetRotate sets the Rotate field's value.
func (s *JobOutput) SetRotate(v string) *JobOutput {
	s.Rotate = &v
	return s
}

// SetSegmentDuration sets the SegmentDuration field's value.
func (s *JobOutput) SetSegmentDuration(v string) *JobOutput {
	s.SegmentDuration = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *JobOutput) SetStatus(v string) *JobOutput {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *JobOutput) SetStatusDetail(v string) *JobOutput {
	s.StatusDetail = &v
	return s
}

// SetThumbnailEncryption sets the ThumbnailEncryption field's value.
func (s *JobOutput) SetThumbnailEncryption(v *Encryption) *JobOutput {
	s.ThumbnailEncryption = v
	return s
}

// SetThumbnailPattern sets the ThumbnailPattern field's value.
func (s *JobOutput) SetThumbnailPattern(v string) *JobOutput {
	s.ThumbnailPattern = &v
	return s
}

// SetWatermarks sets the Watermarks field's value.
func (s *JobOutput) SetWatermarks(v []*JobWatermark) *JobOutput {
	s.Watermarks = v
	return s
}

// SetWidth sets the Width field's value.
func (s *JobOutput) SetWidth(v int64) *JobOutput {
	s.Width = &v
	return s
}

// Watermarks can be in .png or .jpg format. If you want to display a watermark
// that is not rectangular, use the .png format, which supports transparency.
type JobWatermark struct {
	_ struct{} `type:"structure"`

	// The encryption settings, if any, that you want Elastic Transcoder to apply
	// to your watermarks.
	Encryption *Encryption `type:"structure"`

	// The name of the .png or .jpg file that you want to use for the watermark.
	// To determine which Amazon S3 bucket contains the specified file, Elastic
	// Transcoder checks the pipeline specified by Pipeline; the Input Bucket object
	// in that pipeline identifies the bucket.
	//
	// If the file name includes a prefix, for example, logos/128x64.png, include
	// the prefix in the key. If the file isn't in the specified bucket, Elastic
	// Transcoder returns an error.
	InputKey *string `min:"1" type:"string"`

	// The ID of the watermark settings that Elastic Transcoder uses to add watermarks
	// to the video during transcoding. The settings are in the preset specified
	// by Preset for the current output. In that preset, the value of Watermarks
	// Id tells Elastic Transcoder which settings to use.
	PresetWatermarkId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobWatermark) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobWatermark) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobWatermark) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobWatermark"}
	if s.InputKey != nil && len(*s.InputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputKey", 1))
	}
	if s.PresetWatermarkId != nil && len(*s.PresetWatermarkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PresetWatermarkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryption sets the Encryption field's value.
func (s *JobWatermark) SetEncryption(v *Encryption) *JobWatermark {
	s.Encryption = v
	return s
}

// SetInputKey sets the InputKey field's value.
func (s *JobWatermark) SetInputKey(v string) *JobWatermark {
	s.InputKey = &v
	return s
}

// SetPresetWatermarkId sets the PresetWatermarkId field's value.
func (s *JobWatermark) SetPresetWatermarkId(v string) *JobWatermark {
	s.PresetWatermarkId = &v
	return s
}

// The ListJobsByPipelineRequest structure.
type ListJobsByPipelineInput struct {
	_ struct{} `type:"structure"`

	// To list jobs in chronological order by the date and time that they were submitted,
	// enter true. To list jobs in reverse chronological order, enter false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`

	// The ID of the pipeline for which you want to get job information.
	//
	// PipelineId is a required field
	PipelineId *string `location:"uri" locationName:"PipelineId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListJobsByPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsByPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsByPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsByPipelineInput"}
	if s.PipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("PipelineId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscending sets the Ascending field's value.
func (s *ListJobsByPipelineInput) SetAscending(v string) *ListJobsByPipelineInput {
	s.Ascending = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListJobsByPipelineInput) SetPageToken(v string) *ListJobsByPipelineInput {
	s.PageToken = &v
	return s
}

// SetPipelineId sets the PipelineId field's value.
func (s *ListJobsByPipelineInput) SetPipelineId(v string) *ListJobsByPipelineInput {
	s.PipelineId = &v
	return s
}

// The ListJobsByPipelineResponse structure.
type ListJobsByPipelineOutput struct {
	_ struct{} `type:"structure"`

	// An array of Job objects that are in the specified pipeline.
	Jobs []*Job `type:"list"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the jobs in the specified pipeline fit on one page or when you've
	// reached the last page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListJobsByPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsByPipelineOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsByPipelineOutput) SetJobs(v []*Job) *ListJobsByPipelineOutput {
	s.Jobs = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListJobsByPipelineOutput) SetNextPageToken(v string) *ListJobsByPipelineOutput {
	s.NextPageToken = &v
	return s
}

// The ListJobsByStatusRequest structure.
type ListJobsByStatusInput struct {
	_ struct{} `type:"structure"`

	// To list jobs in chronological order by the date and time that they were submitted,
	// enter true. To list jobs in reverse chronological order, enter false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`

	// To get information about all of the jobs associated with the current AWS
	// account that have a given status, specify the following status: Submitted,
	// Progressing, Complete, Canceled, or Error.
	//
	// Status is a required field
	Status *string `location:"uri" locationName:"Status" type:"string" required:"true"`
}

// String returns the string representation
func (s ListJobsByStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsByStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsByStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsByStatusInput"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAscending sets the Ascending field's value.
func (s *ListJobsByStatusInput) SetAscending(v string) *ListJobsByStatusInput {
	s.Ascending = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListJobsByStatusInput) SetPageToken(v string) *ListJobsByStatusInput {
	s.PageToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListJobsByStatusInput) SetStatus(v string) *ListJobsByStatusInput {
	s.Status = &v
	return s
}

// The ListJobsByStatusResponse structure.
type ListJobsByStatusOutput struct {
	_ struct{} `type:"structure"`

	// An array of Job objects that have the specified status.
	Jobs []*Job `type:"list"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the jobs in the specified pipeline fit on one page or when you've
	// reached the last page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`
}

// String returns the string representation
func (s ListJobsByStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsByStatusOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsByStatusOutput) SetJobs(v []*Job) *ListJobsByStatusOutput {
	s.Jobs = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListJobsByStatusOutput) SetNextPageToken(v string) *ListJobsByStatusOutput {
	s.NextPageToken = &v
	return s
}

// The ListPipelineRequest structure.
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// To list pipelines in chronological order by the date and time that they were
	// created, enter true. To list pipelines in reverse chronological order, enter
	// false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// SetAscending sets the Ascending field's value.
func (s *ListPipelinesInput) SetAscending(v string) *ListPipelinesInput {
	s.Ascending = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListPipelinesInput) SetPageToken(v string) *ListPipelinesInput {
	s.PageToken = &v
	return s
}

// A list of the pipelines associated with the current AWS account.
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the pipelines fit on one page or when you've reached the last
	// page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`

	// An array of Pipeline objects.
	Pipelines []*Pipeline `type:"list"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPipelinesOutput) SetNextPageToken(v string) *ListPipelinesOutput {
	s.NextPageToken = &v
	return s
}

// SetPipelines sets the Pipelines field's value.
func (s *ListPipelinesOutput) SetPipelines(v []*Pipeline) *ListPipelinesOutput {
	s.Pipelines = v
	return s
}

// The ListPresetsRequest structure.
type ListPresetsInput struct {
	_ struct{} `type:"structure"`

	// To list presets in chronological order by the date and time that they were
	// created, enter true. To list presets in reverse chronological order, enter
	// false.
	Ascending *string `location:"querystring" locationName:"Ascending" type:"string"`

	// When Elastic Transcoder returns more than one page of results, use pageToken
	// in subsequent GET requests to get each successive page of results.
	PageToken *string `location:"querystring" locationName:"PageToken" type:"string"`
}

// String returns the string representation
func (s ListPresetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPresetsInput) GoString() string {
	return s.String()
}

// SetAscending sets the Ascending field's value.
func (s *ListPresetsInput) SetAscending(v string) *ListPresetsInput {
	s.Ascending = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *ListPresetsInput) SetPageToken(v string) *ListPresetsInput {
	s.PageToken = &v
	return s
}

// The ListPresetsResponse structure.
type ListPresetsOutput struct {
	_ struct{} `type:"structure"`

	// A value that you use to access the second and subsequent pages of results,
	// if any. When the presets fit on one page or when you've reached the last
	// page of results, the value of NextPageToken is null.
	NextPageToken *string `type:"string"`

	// An array of Preset objects.
	Presets []*Preset `type:"list"`
}

// String returns the string representation
func (s ListPresetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPresetsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListPresetsOutput) SetNextPageToken(v string) *ListPresetsOutput {
	s.NextPageToken = &v
	return s
}

// SetPresets sets the Presets field's value.
func (s *ListPresetsOutput) SetPresets(v []*Preset) *ListPresetsOutput {
	s.Presets = v
	return s
}

// The Amazon Simple Notification Service (Amazon SNS) topic or topics to notify
// in order to report job status.
//
// To receive notifications, you must also subscribe to the new topic in the
// Amazon SNS console.
type Notifications struct {
	_ struct{} `type:"structure"`

	// The Amazon SNS topic that you want to notify when Elastic Transcoder has
	// finished processing the job.
	Completed *string `type:"string"`

	// The Amazon SNS topic that you want to notify when Elastic Transcoder encounters
	// an error condition.
	Error *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) topic that you want to
	// notify when Elastic Transcoder has started to process the job.
	Progressing *string `type:"string"`

	// The Amazon SNS topic that you want to notify when Elastic Transcoder encounters
	// a warning condition.
	Warning *string `type:"string"`
}

// String returns the string representation
func (s Notifications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Notifications) GoString() string {
	return s.String()
}

// SetCompleted sets the Completed field's value.
func (s *Notifications) SetCompleted(v string) *Notifications {
	s.Completed = &v
	return s
}

// SetError sets the Error field's value.
func (s *Notifications) SetError(v string) *Notifications {
	s.Error = &v
	return s
}

// SetProgressing sets the Progressing field's value.
func (s *Notifications) SetProgressing(v string) *Notifications {
	s.Progressing = &v
	return s
}

// SetWarning sets the Warning field's value.
func (s *Notifications) SetWarning(v string) *Notifications {
	s.Warning = &v
	return s
}

// The Permission structure.
type Permission struct {
	_ struct{} `type:"structure"`

	// The permission that you want to give to the AWS user that is listed in Grantee.
	// Valid values include:
	//
	//    * READ: The grantee can read the thumbnails and metadata for thumbnails
	//    that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * READ_ACP: The grantee can read the object ACL for thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	//    * WRITE_ACP: The grantee can write the ACL for the thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	//    * FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions
	//    for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
	Access []*string `type:"list"`

	// The AWS user or group that you want to have access to transcoded files and
	// playlists. To identify the user or group, you can specify the canonical user
	// ID for an AWS account, an origin access identity for a CloudFront distribution,
	// the registered email address of an AWS account, or a predefined Amazon S3
	// group.
	Grantee *string `min:"1" type:"string"`

	// The type of value that appears in the Grantee object:
	//
	//    * Canonical: Either the canonical user ID for an AWS account or an origin
	//    access identity for an Amazon CloudFront distribution.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	//    * Email: The registered email address of an AWS account.
	//
	//    * Group: One of the following predefined Amazon S3 groups: AllUsers, AuthenticatedUsers,
	//    or LogDelivery.
	GranteeType *string `type:"string"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Permission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Permission"}
	if s.Grantee != nil && len(*s.Grantee) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Grantee", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccess sets the Access field's value.
func (s *Permission) SetAccess(v []*string) *Permission {
	s.Access = v
	return s
}

// SetGrantee sets the Grantee field's value.
func (s *Permission) SetGrantee(v string) *Permission {
	s.Grantee = &v
	return s
}

// SetGranteeType sets the GranteeType field's value.
func (s *Permission) SetGranteeType(v string) *Permission {
	s.GranteeType = &v
	return s
}

// The pipeline (queue) that is used to manage jobs.
type Pipeline struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the pipeline.
	Arn *string `type:"string"`

	// The AWS Key Management Service (AWS KMS) key that you want to use with this
	// pipeline.
	//
	// If you use either S3 or S3-AWS-KMS as your Encryption:Mode, you don't need
	// to provide a key with your job because a default key, known as an AWS-KMS
	// key, is created for you automatically. You need to provide an AWS-KMS key
	// only if you want to use a non-default AWS-KMS key, or if you are using an
	// Encryption:Mode of AES-PKCS7, AES-CTR, or AES-GCM.
	AwsKmsKeyArn *string `type:"string"`

	// Information about the Amazon S3 bucket in which you want Elastic Transcoder
	// to save transcoded files and playlists. Either you specify both ContentConfig
	// and ThumbnailConfig, or you specify OutputBucket.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save transcoded files and playlists.
	//
	//    * Permissions: A list of the users and/or predefined Amazon S3 groups
	//    you want to have access to transcoded files and playlists, and the type
	//    of access that you want them to have.
	//
	// GranteeType: The type of value that appears in the Grantee object:
	//
	// Canonical: Either the canonical user ID for an AWS account or an origin access
	//    identity for an Amazon CloudFront distribution.
	//
	// Email: The registered email address of an AWS account.
	//
	// Group: One of the following predefined Amazon S3 groups: AllUsers, AuthenticatedUsers,
	//    or LogDelivery.
	//
	// Grantee: The AWS user or group that you want to have access to transcoded
	//    files and playlists.
	//
	// Access: The permission that you want to give to the AWS user that is listed
	//    in Grantee. Valid values include:
	//
	// READ: The grantee can read the objects and metadata for objects that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the objects that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the video files and playlists
	//    that it stores in your Amazon S3 bucket.
	ContentConfig *PipelineOutputConfig `type:"structure"`

	// The identifier for the pipeline. You use this value to identify the pipeline
	// in which you want to perform a variety of operations, such as creating a
	// job or a preset.
	Id *string `type:"string"`

	// The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding
	// and the graphics files, if any, that you want to use for watermarks.
	InputBucket *string `type:"string"`

	// The name of the pipeline. We recommend that the name be unique within the
	// AWS account, but uniqueness is not enforced.
	//
	// Constraints: Maximum 40 characters
	Name *string `min:"1" type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) topic that you want to
	// notify to report job status.
	//
	// To receive notifications, you must also subscribe to the new topic in the
	// Amazon SNS console.
	//
	//    * Progressing (optional): The Amazon Simple Notification Service (Amazon
	//    SNS) topic that you want to notify when Elastic Transcoder has started
	//    to process the job.
	//
	//    * Completed (optional): The Amazon SNS topic that you want to notify when
	//    Elastic Transcoder has finished processing the job.
	//
	//    * Warning (optional): The Amazon SNS topic that you want to notify when
	//    Elastic Transcoder encounters a warning condition.
	//
	//    * Error (optional): The Amazon SNS topic that you want to notify when
	//    Elastic Transcoder encounters an error condition.
	Notifications *Notifications `type:"structure"`

	// The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded
	// files, thumbnails, and playlists. Either you specify this value, or you specify
	// both ContentConfig and ThumbnailConfig.
	OutputBucket *string `type:"string"`

	// The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses
	// to transcode jobs for this pipeline.
	Role *string `type:"string"`

	// The current status of the pipeline:
	//
	//    * Active: The pipeline is processing jobs.
	//
	//    * Paused: The pipeline is not currently processing jobs.
	Status *string `type:"string"`

	// Information about the Amazon S3 bucket in which you want Elastic Transcoder
	// to save thumbnail files. Either you specify both ContentConfig and ThumbnailConfig,
	// or you specify OutputBucket.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save thumbnail files.
	//
	//    * Permissions: A list of the users and/or predefined Amazon S3 groups
	//    you want to have access to thumbnail files, and the type of access that
	//    you want them to have.
	//
	// GranteeType: The type of value that appears in the Grantee object:
	//
	// Canonical: Either the canonical user ID for an AWS account or an origin access
	//    identity for an Amazon CloudFront distribution.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	// Email: The registered email address of an AWS account.
	//
	// Group: One of the following predefined Amazon S3 groups: AllUsers, AuthenticatedUsers,
	//    or LogDelivery.
	//
	// Grantee: The AWS user or group that you want to have access to thumbnail
	//    files.
	//
	// Access: The permission that you want to give to the AWS user that is listed
	//    in Grantee. Valid values include:
	//
	// READ: The grantee can read the thumbnails and metadata for thumbnails that
	//    Elastic Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the thumbnails that it stores
	//    in your Amazon S3 bucket.
	ThumbnailConfig *PipelineOutputConfig `type:"structure"`
}

// String returns the string representation
func (s Pipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Pipeline) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Pipeline) SetArn(v string) *Pipeline {
	s.Arn = &v
	return s
}

// SetAwsKmsKeyArn sets the AwsKmsKeyArn field's value.
func (s *Pipeline) SetAwsKmsKeyArn(v string) *Pipeline {
	s.AwsKmsKeyArn = &v
	return s
}

// SetContentConfig sets the ContentConfig field's value.
func (s *Pipeline) SetContentConfig(v *PipelineOutputConfig) *Pipeline {
	s.ContentConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *Pipeline) SetId(v string) *Pipeline {
	s.Id = &v
	return s
}

// SetInputBucket sets the InputBucket field's value.
func (s *Pipeline) SetInputBucket(v string) *Pipeline {
	s.InputBucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *Pipeline) SetName(v string) *Pipeline {
	s.Name = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *Pipeline) SetNotifications(v *Notifications) *Pipeline {
	s.Notifications = v
	return s
}

// SetOutputBucket sets the OutputBucket field's value.
func (s *Pipeline) SetOutputBucket(v string) *Pipeline {
	s.OutputBucket = &v
	return s
}

// SetRole sets the Role field's value.
func (s *Pipeline) SetRole(v string) *Pipeline {
	s.Role = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Pipeline) SetStatus(v string) *Pipeline {
	s.Status = &v
	return s
}

// SetThumbnailConfig sets the ThumbnailConfig field's value.
func (s *Pipeline) SetThumbnailConfig(v *PipelineOutputConfig) *Pipeline {
	s.ThumbnailConfig = v
	return s
}

// The PipelineOutputConfig structure.
type PipelineOutputConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded
	// files. Specify this value when all of the following are true:
	//
	//    * You want to save transcoded files, thumbnails (if any), and playlists
	//    (if any) together in one bucket.
	//
	//    * You do not want to specify the users or groups who have access to the
	//    transcoded files, thumbnails, and playlists.
	//
	//    * You do not want to specify the permissions that Elastic Transcoder grants
	//    to the files.
	//
	//    * You want to associate the transcoded files and thumbnails with the Amazon
	//    S3 Standard storage class.
	//
	// If you want to save transcoded files and playlists in one bucket and thumbnails
	// in another bucket, specify which users can access the transcoded files or
	// the permissions the users have, or change the Amazon S3 storage class, omit
	// OutputBucket and specify values for ContentConfig and ThumbnailConfig instead.
	Bucket *string `type:"string"`

	// Optional. The Permissions object specifies which users and/or predefined
	// Amazon S3 groups you want to have access to transcoded files and playlists,
	// and the type of access you want them to have. You can grant permissions to
	// a maximum of 30 users and/or predefined Amazon S3 groups.
	//
	// If you include Permissions, Elastic Transcoder grants only the permissions
	// that you specify. It does not grant full permissions to the owner of the
	// role specified by Role. If you want that user to have full control, you must
	// explicitly grant full control to the user.
	//
	// If you omit Permissions, Elastic Transcoder grants full control over the
	// transcoded files and playlists to the owner of the role specified by Role,
	// and grants no other permissions to any other user or group.
	Permissions []*Permission `type:"list"`

	// The Amazon S3 storage class, Standard or ReducedRedundancy, that you want
	// Elastic Transcoder to assign to the video files and playlists that it stores
	// in your Amazon S3 bucket.
	StorageClass *string `type:"string"`
}

// String returns the string representation
func (s PipelineOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipelineOutputConfig"}
	if s.Permissions != nil {
		for i, v := range s.Permissions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Permissions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PipelineOutputConfig) SetBucket(v string) *PipelineOutputConfig {
	s.Bucket = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *PipelineOutputConfig) SetPermissions(v []*Permission) *PipelineOutputConfig {
	s.Permissions = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *PipelineOutputConfig) SetStorageClass(v string) *PipelineOutputConfig {
	s.StorageClass = &v
	return s
}

// The PlayReady DRM settings, if any, that you want Elastic Transcoder to apply
// to the output files associated with this playlist.
//
// PlayReady DRM encrypts your media files using AES-CTR encryption.
//
// If you use DRM for an HLSv3 playlist, your outputs must have a master playlist.
type PlayReadyDrm struct {
	_ struct{} `type:"structure"`

	// The type of DRM, if any, that you want Elastic Transcoder to apply to the
	// output files associated with this playlist.
	Format *string `type:"string"`

	// The series of random bits created by a random bit generator, unique for every
	// encryption operation, that you want Elastic Transcoder to use to encrypt
	// your files. The initialization vector must be base64-encoded, and it must
	// be exactly 8 bytes long before being base64-encoded. If no initialization
	// vector is provided, Elastic Transcoder generates one for you.
	InitializationVector *string `type:"string"`

	// The DRM key for your file, provided by your DRM license provider. The key
	// must be base64-encoded, and it must be one of the following bit lengths before
	// being base64-encoded:
	//
	// 128, 192, or 256.
	//
	// The key must also be encrypted by using AWS KMS.
	Key *string `type:"string"`

	// The ID for your DRM key, so that your DRM license provider knows which key
	// to provide.
	//
	// The key ID must be provided in big endian, and Elastic Transcoder converts
	// it to little endian before inserting it into the PlayReady DRM headers. If
	// you are unsure whether your license server provides your key ID in big or
	// little endian, check with your DRM provider.
	KeyId *string `type:"string"`

	// The MD5 digest of the key used for DRM on your file, and that you want Elastic
	// Transcoder to use as a checksum to make sure your key was not corrupted in
	// transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes
	// before being base64-encoded.
	KeyMd5 *string `type:"string"`

	// The location of the license key required to play DRM content. The URL must
	// be an absolute path, and is referenced by the PlayReady header. The PlayReady
	// header is referenced in the protection header of the client manifest for
	// Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata
	// tags for HLS playlist outputs. An example URL looks like this: https://www.example.com/exampleKey/
	LicenseAcquisitionUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PlayReadyDrm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlayReadyDrm) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlayReadyDrm) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlayReadyDrm"}
	if s.LicenseAcquisitionUrl != nil && len(*s.LicenseAcquisitionUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseAcquisitionUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormat sets the Format field's value.
func (s *PlayReadyDrm) SetFormat(v string) *PlayReadyDrm {
	s.Format = &v
	return s
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *PlayReadyDrm) SetInitializationVector(v string) *PlayReadyDrm {
	s.InitializationVector = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PlayReadyDrm) SetKey(v string) *PlayReadyDrm {
	s.Key = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *PlayReadyDrm) SetKeyId(v string) *PlayReadyDrm {
	s.KeyId = &v
	return s
}

// SetKeyMd5 sets the KeyMd5 field's value.
func (s *PlayReadyDrm) SetKeyMd5(v string) *PlayReadyDrm {
	s.KeyMd5 = &v
	return s
}

// SetLicenseAcquisitionUrl sets the LicenseAcquisitionUrl field's value.
func (s *PlayReadyDrm) SetLicenseAcquisitionUrl(v string) *PlayReadyDrm {
	s.LicenseAcquisitionUrl = &v
	return s
}

// Use Only for Fragmented MP4 or MPEG-TS Outputs. If you specify a preset for
// which the value of Container is fmp4 (Fragmented MP4) or ts (MPEG-TS), Playlists
// contains information about the master playlists that you want Elastic Transcoder
// to create. We recommend that you create only one master playlist per output
// format. The maximum number of master playlists in a job is 30.
type Playlist struct {
	_ struct{} `type:"structure"`

	// The format of the output playlist. Valid formats include HLSv3, HLSv4, and
	// Smooth.
	Format *string `type:"string"`

	// The HLS content protection settings, if any, that you want Elastic Transcoder
	// to apply to the output files associated with this playlist.
	HlsContentProtection *HlsContentProtection `type:"structure"`

	// The name that you want Elastic Transcoder to assign to the master playlist,
	// for example, nyc-vacation.m3u8. If the name includes a / character, the section
	// of the name before the last / must be identical for all Name objects. If
	// you create more than one master playlist, the values of all Name objects
	// must be unique.
	//
	// Elastic Transcoder automatically appends the relevant file extension to the
	// file name (.m3u8 for HLSv3 and HLSv4 playlists, and .ism and .ismc for Smooth
	// playlists). If you include a file extension in Name, the file name will have
	// two extensions.
	Name *string `min:"1" type:"string"`

	// For each output in this job that you want to include in a master playlist,
	// the value of the Outputs:Key object.
	//
	//    * If your output is not HLS or does not have a segment duration set, the
	//    name of the output file is a concatenation of OutputKeyPrefix and Outputs:Key:
	//
	// OutputKeyPrefixOutputs:Key
	//
	//    * If your output is HLSv3 and has a segment duration set, or is not included
	//    in a playlist, Elastic Transcoder creates an output playlist file with
	//    a file extension of .m3u8, and a series of .ts files that include a five-digit
	//    sequential counter beginning with 00000:
	//
	// OutputKeyPrefixOutputs:Key.m3u8
	//
	// OutputKeyPrefixOutputs:Key00000.ts
	//
	//    * If your output is HLSv4, has a segment duration set, and is included
	//    in an HLSv4 playlist, Elastic Transcoder creates an output playlist file
	//    with a file extension of _v4.m3u8. If the output is video, Elastic Transcoder
	//    also creates an output file with an extension of _iframe.m3u8:
	//
	// OutputKeyPrefixOutputs:Key_v4.m3u8
	//
	// OutputKeyPrefixOutputs:Key_iframe.m3u8
	//
	// OutputKeyPrefixOutputs:Key.ts
	//
	// Elastic Transcoder automatically appends the relevant file extension to the
	// file name. If you include a file extension in Output Key, the file name will
	// have two extensions.
	//
	// If you include more than one output in a playlist, any segment duration settings,
	// clip settings, or caption settings must be the same for all outputs in the
	// playlist. For Smooth playlists, the Audio:Profile, Video:Profile, and Video:FrameRate
	// to Video:KeyframesMaxDist ratio must be the same for all outputs.
	OutputKeys []*string `type:"list"`

	// The DRM settings, if any, that you want Elastic Transcoder to apply to the
	// output files associated with this playlist.
	PlayReadyDrm *PlayReadyDrm `type:"structure"`

	// The status of the job with which the playlist is associated.
	Status *string `type:"string"`

	// Information that further explains the status.
	StatusDetail *string `type:"string"`
}

// String returns the string representation
func (s Playlist) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Playlist) GoString() string {
	return s.String()
}

// SetFormat sets the Format field's value.
func (s *Playlist) SetFormat(v string) *Playlist {
	s.Format = &v
	return s
}

// SetHlsContentProtection sets the HlsContentProtection field's value.
func (s *Playlist) SetHlsContentProtection(v *HlsContentProtection) *Playlist {
	s.HlsContentProtection = v
	return s
}

// SetName sets the Name field's value.
func (s *Playlist) SetName(v string) *Playlist {
	s.Name = &v
	return s
}

// SetOutputKeys sets the OutputKeys field's value.
func (s *Playlist) SetOutputKeys(v []*string) *Playlist {
	s.OutputKeys = v
	return s
}

// SetPlayReadyDrm sets the PlayReadyDrm field's value.
func (s *Playlist) SetPlayReadyDrm(v *PlayReadyDrm) *Playlist {
	s.PlayReadyDrm = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Playlist) SetStatus(v string) *Playlist {
	s.Status = &v
	return s
}

// SetStatusDetail sets the StatusDetail field's value.
func (s *Playlist) SetStatusDetail(v string) *Playlist {
	s.StatusDetail = &v
	return s
}

// Presets are templates that contain most of the settings for transcoding media
// files from one format to another. Elastic Transcoder includes some default
// presets for common formats, for example, several iPod and iPhone versions.
// You can also create your own presets for formats that aren't included among
// the default presets. You specify which preset you want to use when you create
// a job.
type Preset struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the preset.
	Arn *string `type:"string"`

	// A section of the response body that provides information about the audio
	// preset values.
	Audio *AudioParameters `type:"structure"`

	// The container type for the output file. Valid values include flac, flv, fmp4,
	// gif, mp3, mp4, mpg, mxf, oga, ogg, ts, and webm.
	Container *string `type:"string"`

	// A description of the preset.
	Description *string `type:"string"`

	// Identifier for the new preset. You use this value to get settings for the
	// preset or to delete it.
	Id *string `type:"string"`

	// The name of the preset.
	Name *string `min:"1" type:"string"`

	// A section of the response body that provides information about the thumbnail
	// preset values, if any.
	Thumbnails *Thumbnails `type:"structure"`

	// Whether the preset is a default preset provided by Elastic Transcoder (System)
	// or a preset that you have defined (Custom).
	Type *string `type:"string"`

	// A section of the response body that provides information about the video
	// preset values.
	Video *VideoParameters `type:"structure"`
}

// String returns the string representation
func (s Preset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Preset) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Preset) SetArn(v string) *Preset {
	s.Arn = &v
	return s
}

// SetAudio sets the Audio field's value.
func (s *Preset) SetAudio(v *AudioParameters) *Preset {
	s.Audio = v
	return s
}

// SetContainer sets the Container field's value.
func (s *Preset) SetContainer(v string) *Preset {
	s.Container = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Preset) SetDescription(v string) *Preset {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Preset) SetId(v string) *Preset {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Preset) SetName(v string) *Preset {
	s.Name = &v
	return s
}

// SetThumbnails sets the Thumbnails field's value.
func (s *Preset) SetThumbnails(v *Thumbnails) *Preset {
	s.Thumbnails = v
	return s
}

// SetType sets the Type field's value.
func (s *Preset) SetType(v string) *Preset {
	s.Type = &v
	return s
}

// SetVideo sets the Video field's value.
func (s *Preset) SetVideo(v *VideoParameters) *Preset {
	s.Video = v
	return s
}

// Settings for the size, location, and opacity of graphics that you want Elastic
// Transcoder to overlay over videos that are transcoded using this preset.
// You can specify settings for up to four watermarks. Watermarks appear in
// the specified size and location, and with the specified opacity for the duration
// of the transcoded video.
//
// Watermarks can be in .png or .jpg format. If you want to display a watermark
// that is not rectangular, use the .png format, which supports transparency.
//
// When you create a job that uses this preset, you specify the .png or .jpg
// graphics that you want Elastic Transcoder to include in the transcoded videos.
// You can specify fewer graphics in the job than you specify watermark settings
// in the preset, which allows you to use the same preset for up to four watermarks
// that have different dimensions.
type PresetWatermark struct {
	_ struct{} `type:"structure"`

	// The horizontal position of the watermark unless you specify a non-zero value
	// for HorizontalOffset:
	//
	//    * Left: The left edge of the watermark is aligned with the left border
	//    of the video.
	//
	//    * Right: The right edge of the watermark is aligned with the right border
	//    of the video.
	//
	//    * Center: The watermark is centered between the left and right borders.
	HorizontalAlign *string `type:"string"`

	// The amount by which you want the horizontal position of the watermark to
	// be offset from the position specified by HorizontalAlign:
	//
	//    * number of pixels (px): The minimum value is 0 pixels, and the maximum
	//    value is the value of MaxWidth.
	//
	//    * integer percentage (%): The range of valid values is 0 to 100.
	//
	// For example, if you specify Left for HorizontalAlign and 5px for HorizontalOffset,
	// the left side of the watermark appears 5 pixels from the left border of the
	// output video.
	//
	// HorizontalOffset is only valid when the value of HorizontalAlign is Left
	// or Right. If you specify an offset that causes the watermark to extend beyond
	// the left or right border and Elastic Transcoder has not added black bars,
	// the watermark is cropped. If Elastic Transcoder has added black bars, the
	// watermark extends into the black bars. If the watermark extends beyond the
	// black bars, it is cropped.
	//
	// Use the value of Target to specify whether you want to include the black
	// bars that are added by Elastic Transcoder, if any, in the offset calculation.
	HorizontalOffset *string `type:"string"`

	// A unique identifier for the settings for one watermark. The value of Id can
	// be up to 40 characters long.
	Id *string `min:"1" type:"string"`

	// The maximum height of the watermark in one of the following formats:
	//
	//    * number of pixels (px): The minimum value is 16 pixels, and the maximum
	//    value is the value of MaxHeight.
	//
	//    * integer percentage (%): The range of valid values is 0 to 100. Use the
	//    value of Target to specify whether you want Elastic Transcoder to include
	//    the black bars that are added by Elastic Transcoder, if any, in the calculation.
	//
	// If you specify the value in pixels, it must be less than or equal to the
	// value of MaxHeight.
	MaxHeight *string `type:"string"`

	// The maximum width of the watermark in one of the following formats:
	//
	//    * number of pixels (px): The minimum value is 16 pixels, and the maximum
	//    value is the value of MaxWidth.
	//
	//    * integer percentage (%): The range of valid values is 0 to 100. Use the
	//    value of Target to specify whether you want Elastic Transcoder to include
	//    the black bars that are added by Elastic Transcoder, if any, in the calculation.
	//
	// If you specify the value in pixels, it must be less than or equal to the
	//    value of MaxWidth.
	MaxWidth *string `type:"string"`

	// A percentage that indicates how much you want a watermark to obscure the
	// video in the location where it appears. Valid values are 0 (the watermark
	// is invisible) to 100 (the watermark completely obscures the video in the
	// specified location). The datatype of Opacity is float.
	//
	// Elastic Transcoder supports transparent .png graphics. If you use a transparent
	// .png, the transparent portion of the video appears as if you had specified
	// a value of 0 for Opacity. The .jpg file format doesn't support transparency.
	Opacity *string `type:"string"`

	// A value that controls scaling of the watermark:
	//
	//    * Fit: Elastic Transcoder scales the watermark so it matches the value
	//    that you specified in either MaxWidth or MaxHeight without exceeding the
	//    other value.
	//
	//    * Stretch: Elastic Transcoder stretches the watermark to match the values
	//    that you specified for MaxWidth and MaxHeight. If the relative proportions
	//    of the watermark and the values of MaxWidth and MaxHeight are different,
	//    the watermark will be distorted.
	//
	//    * ShrinkToFit: Elastic Transcoder scales the watermark down so that its
	//    dimensions match the values that you specified for at least one of MaxWidth
	//    and MaxHeight without exceeding either value. If you specify this option,
	//    Elastic Transcoder does not scale the watermark up.
	SizingPolicy *string `type:"string"`

	// A value that determines how Elastic Transcoder interprets values that you
	// specified for HorizontalOffset, VerticalOffset, MaxWidth, and MaxHeight:
	//
	//    * Content: HorizontalOffset and VerticalOffset values are calculated based
	//    on the borders of the video excluding black bars added by Elastic Transcoder,
	//    if any. In addition, MaxWidth and MaxHeight, if specified as a percentage,
	//    are calculated based on the borders of the video excluding black bars
	//    added by Elastic Transcoder, if any.
	//
	//    * Frame: HorizontalOffset and VerticalOffset values are calculated based
	//    on the borders of the video including black bars added by Elastic Transcoder,
	//    if any. In addition, MaxWidth and MaxHeight, if specified as a percentage,
	//    are calculated based on the borders of the video including black bars
	//    added by Elastic Transcoder, if any.
	Target *string `type:"string"`

	// The vertical position of the watermark unless you specify a non-zero value
	// for VerticalOffset:
	//
	//    * Top: The top edge of the watermark is aligned with the top border of
	//    the video.
	//
	//    * Bottom: The bottom edge of the watermark is aligned with the bottom
	//    border of the video.
	//
	//    * Center: The watermark is centered between the top and bottom borders.
	VerticalAlign *string `type:"string"`

	// VerticalOffset
	//
	// The amount by which you want the vertical position of the watermark to be
	// offset from the position specified by VerticalAlign:
	//
	//    * number of pixels (px): The minimum value is 0 pixels, and the maximum
	//    value is the value of MaxHeight.
	//
	//    * integer percentage (%): The range of valid values is 0 to 100.
	//
	// For example, if you specify Top for VerticalAlign and 5px for VerticalOffset,
	// the top of the watermark appears 5 pixels from the top border of the output
	// video.
	//
	// VerticalOffset is only valid when the value of VerticalAlign is Top or Bottom.
	//
	// If you specify an offset that causes the watermark to extend beyond the top
	// or bottom border and Elastic Transcoder has not added black bars, the watermark
	// is cropped. If Elastic Transcoder has added black bars, the watermark extends
	// into the black bars. If the watermark extends beyond the black bars, it is
	// cropped.
	//
	// Use the value of Target to specify whether you want Elastic Transcoder to
	// include the black bars that are added by Elastic Transcoder, if any, in the
	// offset calculation.
	VerticalOffset *string `type:"string"`
}

// String returns the string representation
func (s PresetWatermark) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PresetWatermark) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PresetWatermark) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PresetWatermark"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHorizontalAlign sets the HorizontalAlign field's value.
func (s *PresetWatermark) SetHorizontalAlign(v string) *PresetWatermark {
	s.HorizontalAlign = &v
	return s
}

// SetHorizontalOffset sets the HorizontalOffset field's value.
func (s *PresetWatermark) SetHorizontalOffset(v string) *PresetWatermark {
	s.HorizontalOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *PresetWatermark) SetId(v string) *PresetWatermark {
	s.Id = &v
	return s
}

// SetMaxHeight sets the MaxHeight field's value.
func (s *PresetWatermark) SetMaxHeight(v string) *PresetWatermark {
	s.MaxHeight = &v
	return s
}

// SetMaxWidth sets the MaxWidth field's value.
func (s *PresetWatermark) SetMaxWidth(v string) *PresetWatermark {
	s.MaxWidth = &v
	return s
}

// SetOpacity sets the Opacity field's value.
func (s *PresetWatermark) SetOpacity(v string) *PresetWatermark {
	s.Opacity = &v
	return s
}

// SetSizingPolicy sets the SizingPolicy field's value.
func (s *PresetWatermark) SetSizingPolicy(v string) *PresetWatermark {
	s.SizingPolicy = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *PresetWatermark) SetTarget(v string) *PresetWatermark {
	s.Target = &v
	return s
}

// SetVerticalAlign sets the VerticalAlign field's value.
func (s *PresetWatermark) SetVerticalAlign(v string) *PresetWatermark {
	s.VerticalAlign = &v
	return s
}

// SetVerticalOffset sets the VerticalOffset field's value.
func (s *PresetWatermark) SetVerticalOffset(v string) *PresetWatermark {
	s.VerticalOffset = &v
	return s
}

// The ReadJobRequest structure.
type ReadJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job for which you want to get detailed information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ReadJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReadJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ReadJobInput) SetId(v string) *ReadJobInput {
	s.Id = &v
	return s
}

// The ReadJobResponse structure.
type ReadJobOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the job.
	Job *Job `type:"structure"`
}

// String returns the string representation
func (s ReadJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *ReadJobOutput) SetJob(v *Job) *ReadJobOutput {
	s.Job = v
	return s
}

// The ReadPipelineRequest structure.
type ReadPipelineInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline to read.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ReadPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadPipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadPipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReadPipelineInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ReadPipelineInput) SetId(v string) *ReadPipelineInput {
	s.Id = &v
	return s
}

// The ReadPipelineResponse structure.
type ReadPipelineOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline.
	Pipeline *Pipeline `type:"structure"`

	// Elastic Transcoder returns a warning if the resources used by your pipeline
	// are not in the same region as the pipeline.
	//
	// Using resources in the same region, such as your Amazon S3 buckets, Amazon
	// SNS notification topics, and AWS KMS key, reduces processing time and prevents
	// cross-regional charges.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation
func (s ReadPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadPipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *ReadPipelineOutput) SetPipeline(v *Pipeline) *ReadPipelineOutput {
	s.Pipeline = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ReadPipelineOutput) SetWarnings(v []*Warning) *ReadPipelineOutput {
	s.Warnings = v
	return s
}

// The ReadPresetRequest structure.
type ReadPresetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the preset for which you want to get detailed information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ReadPresetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadPresetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadPresetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReadPresetInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ReadPresetInput) SetId(v string) *ReadPresetInput {
	s.Id = &v
	return s
}

// The ReadPresetResponse structure.
type ReadPresetOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the preset.
	Preset *Preset `type:"structure"`
}

// String returns the string representation
func (s ReadPresetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadPresetOutput) GoString() string {
	return s.String()
}

// SetPreset sets the Preset field's value.
func (s *ReadPresetOutput) SetPreset(v *Preset) *ReadPresetOutput {
	s.Preset = v
	return s
}

// The TestRoleRequest structure.
type TestRoleInput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// The Amazon S3 bucket that contains media files to be transcoded. The action
	// attempts to read from this bucket.
	//
	// InputBucket is a required field
	InputBucket *string `type:"string" required:"true"`

	// The Amazon S3 bucket that Elastic Transcoder writes transcoded media files
	// to. The action attempts to read from this bucket.
	//
	// OutputBucket is a required field
	OutputBucket *string `type:"string" required:"true"`

	// The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder
	// to test.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The ARNs of one or more Amazon Simple Notification Service (Amazon SNS) topics
	// that you want the action to send a test notification to.
	//
	// Topics is a required field
	Topics []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s TestRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestRoleInput"}
	if s.InputBucket == nil {
		invalidParams.Add(request.NewErrParamRequired("InputBucket"))
	}
	if s.OutputBucket == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputBucket"))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Topics == nil {
		invalidParams.Add(request.NewErrParamRequired("Topics"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputBucket sets the InputBucket field's value.
func (s *TestRoleInput) SetInputBucket(v string) *TestRoleInput {
	s.InputBucket = &v
	return s
}

// SetOutputBucket sets the OutputBucket field's value.
func (s *TestRoleInput) SetOutputBucket(v string) *TestRoleInput {
	s.OutputBucket = &v
	return s
}

// SetRole sets the Role field's value.
func (s *TestRoleInput) SetRole(v string) *TestRoleInput {
	s.Role = &v
	return s
}

// SetTopics sets the Topics field's value.
func (s *TestRoleInput) SetTopics(v []*string) *TestRoleInput {
	s.Topics = v
	return s
}

// The TestRoleResponse structure.
type TestRoleOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// If the Success element contains false, this value is an array of one or more
	// error messages that were generated during the test process.
	Messages []*string `type:"list"`

	// If the operation is successful, this value is true; otherwise, the value
	// is false.
	Success *string `type:"string"`
}

// String returns the string representation
func (s TestRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRoleOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *TestRoleOutput) SetMessages(v []*string) *TestRoleOutput {
	s.Messages = v
	return s
}

// SetSuccess sets the Success field's value.
func (s *TestRoleOutput) SetSuccess(v string) *TestRoleOutput {
	s.Success = &v
	return s
}

// Thumbnails for videos.
type Thumbnails struct {
	_ struct{} `type:"structure"`

	// To better control resolution and aspect ratio of thumbnails, we recommend
	// that you use the values MaxWidth, MaxHeight, SizingPolicy, and PaddingPolicy
	// instead of Resolution and AspectRatio. The two groups of settings are mutually
	// exclusive. Do not use them together.
	//
	// The aspect ratio of thumbnails. Valid values include:
	//
	// auto, 1:1, 4:3, 3:2, 16:9
	//
	// If you specify auto, Elastic Transcoder tries to preserve the aspect ratio
	// of the video in the output file.
	AspectRatio *string `type:"string"`

	// The format of thumbnails, if any. Valid values are jpg and png.
	//
	// You specify whether you want Elastic Transcoder to create thumbnails when
	// you create a job.
	Format *string `type:"string"`

	// The approximate number of seconds between thumbnails. Specify an integer
	// value.
	Interval *string `type:"string"`

	// The maximum height of thumbnails in pixels. If you specify auto, Elastic
	// Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric
	// value, enter an even integer between 32 and 3072.
	MaxHeight *string `type:"string"`

	// The maximum width of thumbnails in pixels. If you specify auto, Elastic Transcoder
	// uses 1920 (Full HD) as the default value. If you specify a numeric value,
	// enter an even integer between 32 and 4096.
	MaxWidth *string `type:"string"`

	// When you set PaddingPolicy to Pad, Elastic Transcoder may add black bars
	// to the top and bottom and/or left and right sides of thumbnails to make the
	// total size of the thumbnails match the values that you specified for thumbnail
	// MaxWidth and MaxHeight settings.
	PaddingPolicy *string `type:"string"`

	// To better control resolution and aspect ratio of thumbnails, we recommend
	// that you use the values MaxWidth, MaxHeight, SizingPolicy, and PaddingPolicy
	// instead of Resolution and AspectRatio. The two groups of settings are mutually
	// exclusive. Do not use them together.
	//
	// The width and height of thumbnail files in pixels. Specify a value in the
	// format width x height where both values are even integers. The values cannot
	// exceed the width and height that you specified in the Video:Resolution object.
	Resolution *string `type:"string"`

	// Specify one of the following values to control scaling of thumbnails:
	//
	//    * Fit: Elastic Transcoder scales thumbnails so they match the value that
	//    you specified in thumbnail MaxWidth or MaxHeight settings without exceeding
	//    the other value.
	//
	//    * Fill: Elastic Transcoder scales thumbnails so they match the value that
	//    you specified in thumbnail MaxWidth or MaxHeight settings and matches
	//    or exceeds the other value. Elastic Transcoder centers the image in thumbnails
	//    and then crops in the dimension (if any) that exceeds the maximum value.
	//
	//    * Stretch: Elastic Transcoder stretches thumbnails to match the values
	//    that you specified for thumbnail MaxWidth and MaxHeight settings. If the
	//    relative proportions of the input video and thumbnails are different,
	//    the thumbnails will be distorted.
	//
	//    * Keep: Elastic Transcoder does not scale thumbnails. If either dimension
	//    of the input video exceeds the values that you specified for thumbnail
	//    MaxWidth and MaxHeight settings, Elastic Transcoder crops the thumbnails.
	//
	//    * ShrinkToFit: Elastic Transcoder scales thumbnails down so that their
	//    dimensions match the values that you specified for at least one of thumbnail
	//    MaxWidth and MaxHeight without exceeding either value. If you specify
	//    this option, Elastic Transcoder does not scale thumbnails up.
	//
	//    * ShrinkToFill: Elastic Transcoder scales thumbnails down so that their
	//    dimensions match the values that you specified for at least one of MaxWidth
	//    and MaxHeight without dropping below either value. If you specify this
	//    option, Elastic Transcoder does not scale thumbnails up.
	SizingPolicy *string `type:"string"`
}

// String returns the string representation
func (s Thumbnails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Thumbnails) GoString() string {
	return s.String()
}

// SetAspectRatio sets the AspectRatio field's value.
func (s *Thumbnails) SetAspectRatio(v string) *Thumbnails {
	s.AspectRatio = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *Thumbnails) SetFormat(v string) *Thumbnails {
	s.Format = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *Thumbnails) SetInterval(v string) *Thumbnails {
	s.Interval = &v
	return s
}

// SetMaxHeight sets the MaxHeight field's value.
func (s *Thumbnails) SetMaxHeight(v string) *Thumbnails {
	s.MaxHeight = &v
	return s
}

// SetMaxWidth sets the MaxWidth field's value.
func (s *Thumbnails) SetMaxWidth(v string) *Thumbnails {
	s.MaxWidth = &v
	return s
}

// SetPaddingPolicy sets the PaddingPolicy field's value.
func (s *Thumbnails) SetPaddingPolicy(v string) *Thumbnails {
	s.PaddingPolicy = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *Thumbnails) SetResolution(v string) *Thumbnails {
	s.Resolution = &v
	return s
}

// SetSizingPolicy sets the SizingPolicy field's value.
func (s *Thumbnails) SetSizingPolicy(v string) *Thumbnails {
	s.SizingPolicy = &v
	return s
}

// Settings that determine when a clip begins and how long it lasts.
type TimeSpan struct {
	_ struct{} `type:"structure"`

	// The duration of the clip. The format can be either HH:mm:ss.SSS (maximum
	// value: 23:59:59.999; SSS is thousandths of a second) or sssss.SSS (maximum
	// value: 86399.999). If you don't specify a value, Elastic Transcoder creates
	// an output file from StartTime to the end of the file.
	//
	// If you specify a value longer than the duration of the input file, Elastic
	// Transcoder transcodes the file and returns a warning message.
	Duration *string `type:"string"`

	// The place in the input file where you want a clip to start. The format can
	// be either HH:mm:ss.SSS (maximum value: 23:59:59.999; SSS is thousandths of
	// a second) or sssss.SSS (maximum value: 86399.999). If you don't specify a
	// value, Elastic Transcoder starts at the beginning of the input file.
	StartTime *string `type:"string"`
}

// String returns the string representation
func (s TimeSpan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeSpan) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *TimeSpan) SetDuration(v string) *TimeSpan {
	s.Duration = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeSpan) SetStartTime(v string) *TimeSpan {
	s.StartTime = &v
	return s
}

// Details about the timing of a job.
type Timing struct {
	_ struct{} `type:"structure"`

	// The time the job finished transcoding, in epoch milliseconds.
	FinishTimeMillis *int64 `type:"long"`

	// The time the job began transcoding, in epoch milliseconds.
	StartTimeMillis *int64 `type:"long"`

	// The time the job was submitted to Elastic Transcoder, in epoch milliseconds.
	SubmitTimeMillis *int64 `type:"long"`
}

// String returns the string representation
func (s Timing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Timing) GoString() string {
	return s.String()
}

// SetFinishTimeMillis sets the FinishTimeMillis field's value.
func (s *Timing) SetFinishTimeMillis(v int64) *Timing {
	s.FinishTimeMillis = &v
	return s
}

// SetStartTimeMillis sets the StartTimeMillis field's value.
func (s *Timing) SetStartTimeMillis(v int64) *Timing {
	s.StartTimeMillis = &v
	return s
}

// SetSubmitTimeMillis sets the SubmitTimeMillis field's value.
func (s *Timing) SetSubmitTimeMillis(v int64) *Timing {
	s.SubmitTimeMillis = &v
	return s
}

// The UpdatePipelineRequest structure.
type UpdatePipelineInput struct {
	_ struct{} `type:"structure"`

	// The AWS Key Management Service (AWS KMS) key that you want to use with this
	// pipeline.
	//
	// If you use either S3 or S3-AWS-KMS as your Encryption:Mode, you don't need
	// to provide a key with your job because a default key, known as an AWS-KMS
	// key, is created for you automatically. You need to provide an AWS-KMS key
	// only if you want to use a non-default AWS-KMS key, or if you are using an
	// Encryption:Mode of AES-PKCS7, AES-CTR, or AES-GCM.
	AwsKmsKeyArn *string `type:"string"`

	// The optional ContentConfig object specifies information about the Amazon
	// S3 bucket in which you want Elastic Transcoder to save transcoded files and
	// playlists: which bucket to use, which users you want to have access to the
	// files, the type of access you want users to have, and the storage class that
	// you want to assign to the files.
	//
	// If you specify values for ContentConfig, you must also specify values for
	// ThumbnailConfig.
	//
	// If you specify values for ContentConfig and ThumbnailConfig, omit the OutputBucket
	// object.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save transcoded files and playlists.
	//
	//    * Permissions (Optional): The Permissions object specifies which users
	//    you want to have access to transcoded files and the type of access you
	//    want them to have. You can grant permissions to a maximum of 30 users
	//    and/or predefined Amazon S3 groups.
	//
	//    * Grantee Type: Specify the type of value that appears in the Grantee
	//    object:
	//
	// Canonical: The value in the Grantee object is either the canonical user ID
	//    for an AWS account or an origin access identity for an Amazon CloudFront
	//    distribution. For more information about canonical user IDs, see Access
	//    Control List (ACL) Overview in the Amazon Simple Storage Service Developer
	//    Guide. For more information about using CloudFront origin access identities
	//    to require that users use CloudFront URLs instead of Amazon S3 URLs, see
	//    Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	// Email: The value in the Grantee object is the registered email address of
	//    an AWS account.
	//
	// Group: The value in the Grantee object is one of the following predefined
	//    Amazon S3 groups: AllUsers, AuthenticatedUsers, or LogDelivery.
	//
	//    * Grantee: The AWS user or group that you want to have access to transcoded
	//    files and playlists. To identify the user or group, you can specify the
	//    canonical user ID for an AWS account, an origin access identity for a
	//    CloudFront distribution, the registered email address of an AWS account,
	//    or a predefined Amazon S3 group
	//
	//    * Access: The permission that you want to give to the AWS user that you
	//    specified in Grantee. Permissions are granted on the files that Elastic
	//    Transcoder adds to the bucket, including playlists and video files. Valid
	//    values include:
	//
	// READ: The grantee can read the objects and metadata for objects that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the objects that Elastic Transcoder
	//    adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the objects that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the video files and playlists
	//    that it stores in your Amazon S3 bucket.
	ContentConfig *PipelineOutputConfig `type:"structure"`

	// The ID of the pipeline that you want to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The Amazon S3 bucket in which you saved the media files that you want to
	// transcode and the graphics that you want to use as watermarks.
	InputBucket *string `type:"string"`

	// The name of the pipeline. We recommend that the name be unique within the
	// AWS account, but uniqueness is not enforced.
	//
	// Constraints: Maximum 40 characters
	Name *string `min:"1" type:"string"`

	// The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic
	// that you want to notify to report job status.
	//
	// To receive notifications, you must also subscribe to the new topic in the
	// Amazon SNS console.
	//
	//    * Progressing: The topic ARN for the Amazon Simple Notification Service
	//    (Amazon SNS) topic that you want to notify when Elastic Transcoder has
	//    started to process jobs that are added to this pipeline. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Completed: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder has finished processing a job. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Warning: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters a warning condition. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Error: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters an error condition. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	Notifications *Notifications `type:"structure"`

	// The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder
	// to use to transcode jobs for this pipeline.
	Role *string `type:"string"`

	// The ThumbnailConfig object specifies several values, including the Amazon
	// S3 bucket in which you want Elastic Transcoder to save thumbnail files, which
	// users you want to have access to the files, the type of access you want users
	// to have, and the storage class that you want to assign to the files.
	//
	// If you specify values for ContentConfig, you must also specify values for
	// ThumbnailConfig even if you don't want to create thumbnails.
	//
	// If you specify values for ContentConfig and ThumbnailConfig, omit the OutputBucket
	// object.
	//
	//    * Bucket: The Amazon S3 bucket in which you want Elastic Transcoder to
	//    save thumbnail files.
	//
	//    * Permissions (Optional): The Permissions object specifies which users
	//    and/or predefined Amazon S3 groups you want to have access to thumbnail
	//    files, and the type of access you want them to have. You can grant permissions
	//    to a maximum of 30 users and/or predefined Amazon S3 groups.
	//
	//    * GranteeType: Specify the type of value that appears in the Grantee object:
	//
	// Canonical: The value in the Grantee object is either the canonical user ID
	//    for an AWS account or an origin access identity for an Amazon CloudFront
	//    distribution.
	//
	// A canonical user ID is not the same as an AWS account number.
	//
	// Email: The value in the Grantee object is the registered email address of
	//    an AWS account.
	//
	// Group: The value in the Grantee object is one of the following predefined
	//    Amazon S3 groups: AllUsers, AuthenticatedUsers, or LogDelivery.
	//
	//    * Grantee: The AWS user or group that you want to have access to thumbnail
	//    files. To identify the user or group, you can specify the canonical user
	//    ID for an AWS account, an origin access identity for a CloudFront distribution,
	//    the registered email address of an AWS account, or a predefined Amazon
	//    S3 group.
	//
	//    * Access: The permission that you want to give to the AWS user that you
	//    specified in Grantee. Permissions are granted on the thumbnail files that
	//    Elastic Transcoder adds to the bucket. Valid values include:
	//
	// READ: The grantee can read the thumbnails and metadata for objects that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// READ_ACP: The grantee can read the object ACL for thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// WRITE_ACP: The grantee can write the ACL for the thumbnails that Elastic
	//    Transcoder adds to the Amazon S3 bucket.
	//
	// FULL_CONTROL: The grantee has READ, READ_ACP, and WRITE_ACP permissions for
	//    the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
	//
	//    * StorageClass: The Amazon S3 storage class, Standard or ReducedRedundancy,
	//    that you want Elastic Transcoder to assign to the thumbnails that it stores
	//    in your Amazon S3 bucket.
	ThumbnailConfig *PipelineOutputConfig `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ContentConfig != nil {
		if err := s.ContentConfig.Validate(); err != nil {
			invalidParams.AddNested("ContentConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.ThumbnailConfig != nil {
		if err := s.ThumbnailConfig.Validate(); err != nil {
			invalidParams.AddNested("ThumbnailConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsKmsKeyArn sets the AwsKmsKeyArn field's value.
func (s *UpdatePipelineInput) SetAwsKmsKeyArn(v string) *UpdatePipelineInput {
	s.AwsKmsKeyArn = &v
	return s
}

// SetContentConfig sets the ContentConfig field's value.
func (s *UpdatePipelineInput) SetContentConfig(v *PipelineOutputConfig) *UpdatePipelineInput {
	s.ContentConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdatePipelineInput) SetId(v string) *UpdatePipelineInput {
	s.Id = &v
	return s
}

// SetInputBucket sets the InputBucket field's value.
func (s *UpdatePipelineInput) SetInputBucket(v string) *UpdatePipelineInput {
	s.InputBucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePipelineInput) SetName(v string) *UpdatePipelineInput {
	s.Name = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *UpdatePipelineInput) SetNotifications(v *Notifications) *UpdatePipelineInput {
	s.Notifications = v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdatePipelineInput) SetRole(v string) *UpdatePipelineInput {
	s.Role = &v
	return s
}

// SetThumbnailConfig sets the ThumbnailConfig field's value.
func (s *UpdatePipelineInput) SetThumbnailConfig(v *PipelineOutputConfig) *UpdatePipelineInput {
	s.ThumbnailConfig = v
	return s
}

// The UpdatePipelineNotificationsRequest structure.
type UpdatePipelineNotificationsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline for which you want to change notification
	// settings.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic
	// that you want to notify to report job status.
	//
	// To receive notifications, you must also subscribe to the new topic in the
	// Amazon SNS console.
	//
	//    * Progressing: The topic ARN for the Amazon Simple Notification Service
	//    (Amazon SNS) topic that you want to notify when Elastic Transcoder has
	//    started to process jobs that are added to this pipeline. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Completed: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder has finished processing a job. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Warning: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters a warning condition. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	//    * Error: The topic ARN for the Amazon SNS topic that you want to notify
	//    when Elastic Transcoder encounters an error condition. This is the ARN
	//    that Amazon SNS returned when you created the topic.
	//
	// Notifications is a required field
	Notifications *Notifications `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineNotificationsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Notifications == nil {
		invalidParams.Add(request.NewErrParamRequired("Notifications"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdatePipelineNotificationsInput) SetId(v string) *UpdatePipelineNotificationsInput {
	s.Id = &v
	return s
}

// SetNotifications sets the Notifications field's value.
func (s *UpdatePipelineNotificationsInput) SetNotifications(v *Notifications) *UpdatePipelineNotificationsInput {
	s.Notifications = v
	return s
}

// The UpdatePipelineNotificationsResponse structure.
type UpdatePipelineNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline
	// associated with this notification.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineNotificationsOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineNotificationsOutput) SetPipeline(v *Pipeline) *UpdatePipelineNotificationsOutput {
	s.Pipeline = v
	return s
}

// When you update a pipeline, Elastic Transcoder returns the values that you
// specified in the request.
type UpdatePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The pipeline updated by this UpdatePipelineResponse call.
	Pipeline *Pipeline `type:"structure"`

	// Elastic Transcoder returns a warning if the resources used by your pipeline
	// are not in the same region as the pipeline.
	//
	// Using resources in the same region, such as your Amazon S3 buckets, Amazon
	// SNS notification topics, and AWS KMS key, reduces processing time and prevents
	// cross-regional charges.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineOutput) SetPipeline(v *Pipeline) *UpdatePipelineOutput {
	s.Pipeline = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *UpdatePipelineOutput) SetWarnings(v []*Warning) *UpdatePipelineOutput {
	s.Warnings = v
	return s
}

// The UpdatePipelineStatusRequest structure.
type UpdatePipelineStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline to update.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The desired status of the pipeline:
	//
	//    * Active: The pipeline is processing jobs.
	//
	//    * Paused: The pipeline is not currently processing jobs.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePipelineStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipelineStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipelineStatusInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdatePipelineStatusInput) SetId(v string) *UpdatePipelineStatusInput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdatePipelineStatusInput) SetStatus(v string) *UpdatePipelineStatusInput {
	s.Status = &v
	return s
}

// When you update status for a pipeline, Elastic Transcoder returns the values
// that you specified in the request.
type UpdatePipelineStatusOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline.
	Pipeline *Pipeline `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineStatusOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdatePipelineStatusOutput) SetPipeline(v *Pipeline) *UpdatePipelineStatusOutput {
	s.Pipeline = v
	return s
}

// The VideoParameters structure.
type VideoParameters struct {
	_ struct{} `type:"structure"`

	// To better control resolution and aspect ratio of output videos, we recommend
	// that you use the values MaxWidth, MaxHeight, SizingPolicy, PaddingPolicy,
	// and DisplayAspectRatio instead of Resolution and AspectRatio. The two groups
	// of settings are mutually exclusive. Do not use them together.
	//
	// The display aspect ratio of the video in the output file. Valid values include:
	//
	// auto, 1:1, 4:3, 3:2, 16:9
	//
	// If you specify auto, Elastic Transcoder tries to preserve the aspect ratio
	// of the input file.
	//
	// If you specify an aspect ratio for the output file that differs from aspect
	// ratio of the input file, Elastic Transcoder adds pillarboxing (black bars
	// on the sides) or letterboxing (black bars on the top and bottom) to maintain
	// the aspect ratio of the active region of the video.
	AspectRatio *string `type:"string"`

	// The bit rate of the video stream in the output file, in kilobits/second.
	// Valid values depend on the values of Level and Profile. If you specify auto,
	// Elastic Transcoder uses the detected bit rate of the input source. If you
	// specify a value other than auto, we recommend that you specify a value less
	// than or equal to the maximum H.264-compliant value listed for your level
	// and profile:
	//
	// Level - Maximum video bit rate in kilobits/second (baseline and main Profile)
	// : maximum video bit rate in kilobits/second (high Profile)
	//
	//    * 1 - 64 : 80
	//
	//    * 1b - 128 : 160
	//
	//    * 1.1 - 192 : 240
	//
	//    * 1.2 - 384 : 480
	//
	//    * 1.3 - 768 : 960
	//
	//    * 2 - 2000 : 2500
	//
	//    * 3 - 10000 : 12500
	//
	//    * 3.1 - 14000 : 17500
	//
	//    * 3.2 - 20000 : 25000
	//
	//    * 4 - 20000 : 25000
	//
	//    * 4.1 - 50000 : 62500
	BitRate *string `type:"string"`

	// The video codec for the output file. Valid values include gif, H.264, mpeg2,
	// vp8, and vp9. You can only specify vp8 and vp9 when the container type is
	// webm, gif when the container type is gif, and mpeg2 when the container type
	// is mpg.
	Codec *string `type:"string"`

	// Profile (H.264/VP8/VP9 Only)
	//
	// The H.264 profile that you want to use for the output file. Elastic Transcoder
	// supports the following profiles:
	//
	//    * baseline: The profile most commonly used for videoconferencing and for
	//    mobile applications.
	//
	//    * main: The profile used for standard-definition digital TV broadcasts.
	//
	//    * high: The profile used for high-definition digital TV broadcasts and
	//    for Blu-ray discs.
	//
	// Level (H.264 Only)
	//
	// The H.264 level that you want to use for the output file. Elastic Transcoder
	// supports the following levels:
	//
	// 1, 1b, 1.1, 1.2, 1.3, 2, 2.1, 2.2, 3, 3.1, 3.2, 4, 4.1
	//
	// MaxReferenceFrames (H.264 Only)
	//
	// Applicable only when the value of Video:Codec is H.264. The maximum number
	// of previously decoded frames to use as a reference for decoding future frames.
	// Valid values are integers 0 through 16, but we recommend that you not use
	// a value greater than the following:
	//
	// Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in
	// pixels * Height in pixels)), 16)
	//
	// where Width in pixels and Height in pixels represent either MaxWidth and
	// MaxHeight, or Resolution. Maximum decoded picture buffer in macroblocks depends
	// on the value of the Level object. See the list below. (A macroblock is a
	// block of pixels measuring 16x16.)
	//
	//    * 1 - 396
	//
	//    * 1b - 396
	//
	//    * 1.1 - 900
	//
	//    * 1.2 - 2376
	//
	//    * 1.3 - 2376
	//
	//    * 2 - 2376
	//
	//    * 2.1 - 4752
	//
	//    * 2.2 - 8100
	//
	//    * 3 - 8100
	//
	//    * 3.1 - 18000
	//
	//    * 3.2 - 20480
	//
	//    * 4 - 32768
	//
	//    * 4.1 - 32768
	//
	// MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)
	//
	// The maximum number of bits per second in a video buffer; the size of the
	// buffer is specified by BufferSize. Specify a value between 16 and 62,500.
	// You can reduce the bandwidth required to stream a video by reducing the maximum
	// bit rate, but this also reduces the quality of the video.
	//
	// BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)
	//
	// The maximum number of bits in any x seconds of the output video. This window
	// is commonly 10 seconds, the standard segment duration when you're using FMP4
	// or MPEG-TS for the container type of the output video. Specify an integer
	// greater than 0. If you specify MaxBitRate and omit BufferSize, Elastic Transcoder
	// sets BufferSize to 10 times the value of MaxBitRate.
	//
	// InterlacedMode (Optional, H.264/MPEG2 Only)
	//
	// The interlace mode for the output video.
	//
	// Interlaced video is used to double the perceived frame rate for a video by
	// interlacing two fields (one field on every other line, the other field on
	// the other lines) so that the human eye registers multiple pictures per frame.
	// Interlacing reduces the bandwidth required for transmitting a video, but
	// can result in blurred images and flickering.
	//
	// Valid values include Progressive (no interlacing, top to bottom), TopFirst
	// (top field first), BottomFirst (bottom field first), and Auto.
	//
	// If InterlaceMode is not specified, Elastic Transcoder uses Progressive for
	// the output. If Auto is specified, Elastic Transcoder interlaces the output.
	//
	// ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)
	//
	// The color space conversion Elastic Transcoder applies to the output video.
	// Color spaces are the algorithms used by the computer to store information
	// about how to render color. Bt.601 is the standard for standard definition
	// video, while Bt.709 is the standard for high definition video.
	//
	// Valid values include None, Bt709toBt601, Bt601toBt709, and Auto.
	//
	// If you chose Auto for ColorSpaceConversionMode and your output is interlaced,
	// your frame rate is one of 23.97, 24, 25, 29.97, 50, or 60, your SegmentDuration
	// is null, and you are using one of the resolution changes from the list below,
	// Elastic Transcoder applies the following color space conversions:
	//
	//    * Standard to HD, 720x480 to 1920x1080 - Elastic Transcoder applies Bt601ToBt709
	//
	//    * Standard to HD, 720x576 to 1920x1080 - Elastic Transcoder applies Bt601ToBt709
	//
	//    * HD to Standard, 1920x1080 to 720x480 - Elastic Transcoder applies Bt709ToBt601
	//
	//    * HD to Standard, 1920x1080 to 720x576 - Elastic Transcoder applies Bt709ToBt601
	//
	// Elastic Transcoder may change the behavior of the ColorspaceConversionModeAuto
	// mode in the future. All outputs in a playlist must use the same ColorSpaceConversionMode.
	//
	// If you do not specify a ColorSpaceConversionMode, Elastic Transcoder does
	// not change the color space of a file. If you are unsure what ColorSpaceConversionMode
	// was applied to your output file, you can check the AppliedColorSpaceConversion
	// parameter included in your job response. If your job does not have an AppliedColorSpaceConversion
	// in its response, no ColorSpaceConversionMode was applied.
	//
	// ChromaSubsampling
	//
	// The sampling pattern for the chroma (color) channels of the output video.
	// Valid values include yuv420p and yuv422p.
	//
	// yuv420p samples the chroma information of every other horizontal and every
	// other vertical line, yuv422p samples the color information of every horizontal
	// line and every other vertical line.
	//
	// LoopCount (Gif Only)
	//
	// The number of times you want the output gif to loop. Valid values include
	// Infinite and integers between 0 and 100, inclusive.
	CodecOptions map[string]*string `type:"map"`

	// The value that Elastic Transcoder adds to the metadata in the output file.
	DisplayAspectRatio *string `type:"string"`

	// Applicable only when the value of Video:Codec is one of H.264, MPEG2, or
	// VP8.
	//
	// Whether to use a fixed value for FixedGOP. Valid values are true and false:
	//
	//    * true: Elastic Transcoder uses the value of KeyframesMaxDist for the
	//    distance between key frames (the number of frames in a group of pictures,
	//    or GOP).
	//
	//    * false: The distance between key frames can vary.
	//
	// FixedGOP must be set to true for fmp4 containers.
	FixedGOP *string `type:"string"`

	// The frames per second for the video stream in the output file. Valid values
	// include:
	//
	// auto, 10, 15, 23.97, 24, 25, 29.97, 30, 60
	//
	// If you specify auto, Elastic Transcoder uses the detected frame rate of the
	// input source. If you specify a frame rate, we recommend that you perform
	// the following calculation:
	//
	// Frame rate = maximum recommended decoding speed in luma samples/second /
	// (width in pixels * height in pixels)
	//
	// where:
	//
	//    * width in pixels and height in pixels represent the Resolution of the
	//    output video.
	//
	//    * maximum recommended decoding speed in Luma samples/second is less than
	//    or equal to the maximum value listed in the following table, based on
	//    the value that you specified for Level.
	//
	// The maximum recommended decoding speed in Luma samples/second for each level
	// is described in the following list (Level - Decoding speed):
	//
	//    * 1 - 380160
	//
	//    * 1b - 380160
	//
	//    * 1.1 - 76800
	//
	//    * 1.2 - 1536000
	//
	//    * 1.3 - 3041280
	//
	//    * 2 - 3041280
	//
	//    * 2.1 - 5068800
	//
	//    * 2.2 - 5184000
	//
	//    * 3 - 10368000
	//
	//    * 3.1 - 27648000
	//
	//    * 3.2 - 55296000
	//
	//    * 4 - 62914560
	//
	//    * 4.1 - 62914560
	FrameRate *string `type:"string"`

	// Applicable only when the value of Video:Codec is one of H.264, MPEG2, or
	// VP8.
	//
	// The maximum number of frames between key frames. Key frames are fully encoded
	// frames; the frames between key frames are encoded based, in part, on the
	// content of the key frames. The value is an integer formatted as a string;
	// valid values are between 1 (every frame is a key frame) and 100000, inclusive.
	// A higher value results in higher compression but may also discernibly decrease
	// video quality.
	//
	// For Smooth outputs, the FrameRate must have a constant ratio to the KeyframesMaxDist.
	// This allows Smooth playlists to switch between different quality levels while
	// the file is being played.
	//
	// For example, an input file can have a FrameRate of 30 with a KeyframesMaxDist
	// of 90. The output file then needs to have a ratio of 1:3. Valid outputs would
	// have FrameRate of 30, 25, and 10, and KeyframesMaxDist of 90, 75, and 30,
	// respectively.
	//
	// Alternately, this can be achieved by setting FrameRate to auto and having
	// the same values for MaxFrameRate and KeyframesMaxDist.
	KeyframesMaxDist *string `type:"string"`

	// If you specify auto for FrameRate, Elastic Transcoder uses the frame rate
	// of the input video for the frame rate of the output video. Specify the maximum
	// frame rate that you want Elastic Transcoder to use when the frame rate of
	// the input video is greater than the desired maximum frame rate of the output
	// video. Valid values include: 10, 15, 23.97, 24, 25, 29.97, 30, 60.
	MaxFrameRate *string `type:"string"`

	// The maximum height of the output video in pixels. If you specify auto, Elastic
	// Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric
	// value, enter an even integer between 96 and 3072.
	MaxHeight *string `type:"string"`

	// The maximum width of the output video in pixels. If you specify auto, Elastic
	// Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric
	// value, enter an even integer between 128 and 4096.
	MaxWidth *string `type:"string"`

	// When you set PaddingPolicy to Pad, Elastic Transcoder may add black bars
	// to the top and bottom and/or left and right sides of the output video to
	// make the total size of the output video match the values that you specified
	// for MaxWidth and MaxHeight.
	PaddingPolicy *string `type:"string"`

	// To better control resolution and aspect ratio of output videos, we recommend
	// that you use the values MaxWidth, MaxHeight, SizingPolicy, PaddingPolicy,
	// and DisplayAspectRatio instead of Resolution and AspectRatio. The two groups
	// of settings are mutually exclusive. Do not use them together.
	//
	// The width and height of the video in the output file, in pixels. Valid values
	// are auto and width x height:
	//
	//    * auto: Elastic Transcoder attempts to preserve the width and height of
	//    the input file, subject to the following rules.
	//
	//    * width x height: The width and height of the output video in pixels.
	//
	// Note the following about specifying the width and height:
	//
	//    * The width must be an even integer between 128 and 4096, inclusive.
	//
	//    * The height must be an even integer between 96 and 3072, inclusive.
	//
	//    * If you specify a resolution that is less than the resolution of the
	//    input file, Elastic Transcoder rescales the output file to the lower resolution.
	//
	//    * If you specify a resolution that is greater than the resolution of the
	//    input file, Elastic Transcoder rescales the output to the higher resolution.
	//
	//    * We recommend that you specify a resolution for which the product of
	//    width and height is less than or equal to the applicable value in the
	//    following list (List - Max width x height value):
	//
	// 1 - 25344
	//
	// 1b - 25344
	//
	// 1.1 - 101376
	//
	// 1.2 - 101376
	//
	// 1.3 - 101376
	//
	// 2 - 101376
	//
	// 2.1 - 202752
	//
	// 2.2 - 404720
	//
	// 3 - 404720
	//
	// 3.1 - 921600
	//
	// 3.2 - 1310720
	//
	// 4 - 2097152
	//
	// 4.1 - 2097152
	Resolution *string `type:"string"`

	// Specify one of the following values to control scaling of the output video:
	//
	//    * Fit: Elastic Transcoder scales the output video so it matches the value
	//    that you specified in either MaxWidth or MaxHeight without exceeding the
	//    other value.
	//
	//    * Fill: Elastic Transcoder scales the output video so it matches the value
	//    that you specified in either MaxWidth or MaxHeight and matches or exceeds
	//    the other value. Elastic Transcoder centers the output video and then
	//    crops it in the dimension (if any) that exceeds the maximum value.
	//
	//    * Stretch: Elastic Transcoder stretches the output video to match the
	//    values that you specified for MaxWidth and MaxHeight. If the relative
	//    proportions of the input video and the output video are different, the
	//    output video will be distorted.
	//
	//    * Keep: Elastic Transcoder does not scale the output video. If either
	//    dimension of the input video exceeds the values that you specified for
	//    MaxWidth and MaxHeight, Elastic Transcoder crops the output video.
	//
	//    * ShrinkToFit: Elastic Transcoder scales the output video down so that
	//    its dimensions match the values that you specified for at least one of
	//    MaxWidth and MaxHeight without exceeding either value. If you specify
	//    this option, Elastic Transcoder does not scale the video up.
	//
	//    * ShrinkToFill: Elastic Transcoder scales the output video down so that
	//    its dimensions match the values that you specified for at least one of
	//    MaxWidth and MaxHeight without dropping below either value. If you specify
	//    this option, Elastic Transcoder does not scale the video up.
	SizingPolicy *string `type:"string"`

	// Settings for the size, location, and opacity of graphics that you want Elastic
	// Transcoder to overlay over videos that are transcoded using this preset.
	// You can specify settings for up to four watermarks. Watermarks appear in
	// the specified size and location, and with the specified opacity for the duration
	// of the transcoded video.
	//
	// Watermarks can be in .png or .jpg format. If you want to display a watermark
	// that is not rectangular, use the .png format, which supports transparency.
	//
	// When you create a job that uses this preset, you specify the .png or .jpg
	// graphics that you want Elastic Transcoder to include in the transcoded videos.
	// You can specify fewer graphics in the job than you specify watermark settings
	// in the preset, which allows you to use the same preset for up to four watermarks
	// that have different dimensions.
	Watermarks []*PresetWatermark `type:"list"`
}

// String returns the string representation
func (s VideoParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoParameters"}
	if s.Watermarks != nil {
		for i, v := range s.Watermarks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Watermarks", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAspectRatio sets the AspectRatio field's value.
func (s *VideoParameters) SetAspectRatio(v string) *VideoParameters {
	s.AspectRatio = &v
	return s
}

// SetBitRate sets the BitRate field's value.
func (s *VideoParameters) SetBitRate(v string) *VideoParameters {
	s.BitRate = &v
	return s
}

// SetCodec sets the Codec field's value.
func (s *VideoParameters) SetCodec(v string) *VideoParameters {
	s.Codec = &v
	return s
}

// SetCodecOptions sets the CodecOptions field's value.
func (s *VideoParameters) SetCodecOptions(v map[string]*string) *VideoParameters {
	s.CodecOptions = v
	return s
}

// SetDisplayAspectRatio sets the DisplayAspectRatio field's value.
func (s *VideoParameters) SetDisplayAspectRatio(v string) *VideoParameters {
	s.DisplayAspectRatio = &v
	return s
}

// SetFixedGOP sets the FixedGOP field's value.
func (s *VideoParameters) SetFixedGOP(v string) *VideoParameters {
	s.FixedGOP = &v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *VideoParameters) SetFrameRate(v string) *VideoParameters {
	s.FrameRate = &v
	return s
}

// SetKeyframesMaxDist sets the KeyframesMaxDist field's value.
func (s *VideoParameters) SetKeyframesMaxDist(v string) *VideoParameters {
	s.KeyframesMaxDist = &v
	return s
}

// SetMaxFrameRate sets the MaxFrameRate field's value.
func (s *VideoParameters) SetMaxFrameRate(v string) *VideoParameters {
	s.MaxFrameRate = &v
	return s
}

// SetMaxHeight sets the MaxHeight field's value.
func (s *VideoParameters) SetMaxHeight(v string) *VideoParameters {
	s.MaxHeight = &v
	return s
}

// SetMaxWidth sets the MaxWidth field's value.
func (s *VideoParameters) SetMaxWidth(v string) *VideoParameters {
	s.MaxWidth = &v
	return s
}

// SetPaddingPolicy sets the PaddingPolicy field's value.
func (s *VideoParameters) SetPaddingPolicy(v string) *VideoParameters {
	s.PaddingPolicy = &v
	return s
}

// SetResolution sets the Resolution field's value.
func (s *VideoParameters) SetResolution(v string) *VideoParameters {
	s.Resolution = &v
	return s
}

// SetSizingPolicy sets the SizingPolicy field's value.
func (s *VideoParameters) SetSizingPolicy(v string) *VideoParameters {
	s.SizingPolicy = &v
	return s
}

// SetWatermarks sets the Watermarks field's value.
func (s *VideoParameters) SetWatermarks(v []*PresetWatermark) *VideoParameters {
	s.Watermarks = v
	return s
}

// Elastic Transcoder returns a warning if the resources used by your pipeline
// are not in the same region as the pipeline.
//
// Using resources in the same region, such as your Amazon S3 buckets, Amazon
// SNS notification topics, and AWS KMS key, reduces processing time and prevents
// cross-regional charges.
type Warning struct {
	_ struct{} `type:"structure"`

	// The code of the cross-regional warning.
	Code *string `type:"string"`

	// The message explaining what resources are in a different region from the
	// pipeline.
	//
	// AWS KMS keys must be in the same region as the pipeline.
	Message *string `type:"string"`
}

// String returns the string representation
func (s Warning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Warning) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Warning) SetCode(v string) *Warning {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Warning) SetMessage(v string) *Warning {
	s.Message = &v
	return s
}
