// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sns provides a client for Amazon Simple Notification Service.
package sns

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddPermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddPermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddPermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddPermissionRequest method.
//    req, resp := client.AddPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission
func (c *SNS) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	output = &AddPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddPermission API operation for Amazon Simple Notification Service.
//
// Adds a statement to a topic's access control policy, granting access for
// the specified AWS accounts to the specified actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation AddPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission
func (c *SNS) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opCheckIfPhoneNumberIsOptedOut = "CheckIfPhoneNumberIsOptedOut"

// CheckIfPhoneNumberIsOptedOutRequest generates a "aws/request.Request" representing the
// client's request for the CheckIfPhoneNumberIsOptedOut operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CheckIfPhoneNumberIsOptedOut for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CheckIfPhoneNumberIsOptedOut method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CheckIfPhoneNumberIsOptedOutRequest method.
//    req, resp := client.CheckIfPhoneNumberIsOptedOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut
func (c *SNS) CheckIfPhoneNumberIsOptedOutRequest(input *CheckIfPhoneNumberIsOptedOutInput) (req *request.Request, output *CheckIfPhoneNumberIsOptedOutOutput) {
	op := &request.Operation{
		Name:       opCheckIfPhoneNumberIsOptedOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckIfPhoneNumberIsOptedOutInput{}
	}

	output = &CheckIfPhoneNumberIsOptedOutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CheckIfPhoneNumberIsOptedOut API operation for Amazon Simple Notification Service.
//
// Accepts a phone number and indicates whether the phone holder has opted out
// of receiving SMS messages from your account. You cannot send SMS messages
// to a number that is opted out.
//
// To resume sending messages, you can opt in the number by using the OptInPhoneNumber
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation CheckIfPhoneNumberIsOptedOut for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottledException "Throttled"
//   Indicates that the rate at which requests have been submitted for this action
//   exceeds the limit for your account.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut
func (c *SNS) CheckIfPhoneNumberIsOptedOut(input *CheckIfPhoneNumberIsOptedOutInput) (*CheckIfPhoneNumberIsOptedOutOutput, error) {
	req, out := c.CheckIfPhoneNumberIsOptedOutRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmSubscription = "ConfirmSubscription"

// ConfirmSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ConfirmSubscription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ConfirmSubscription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ConfirmSubscription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ConfirmSubscriptionRequest method.
//    req, resp := client.ConfirmSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription
func (c *SNS) ConfirmSubscriptionRequest(input *ConfirmSubscriptionInput) (req *request.Request, output *ConfirmSubscriptionOutput) {
	op := &request.Operation{
		Name:       opConfirmSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSubscriptionInput{}
	}

	output = &ConfirmSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConfirmSubscription API operation for Amazon Simple Notification Service.
//
// Verifies an endpoint owner's intent to receive messages by validating the
// token sent to the endpoint by an earlier Subscribe action. If the token is
// valid, the action creates a new subscription and returns its Amazon Resource
// Name (ARN). This call requires an AWS signature only when the AuthenticateOnUnsubscribe
// flag is set to "true".
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ConfirmSubscription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionLimitExceededException "SubscriptionLimitExceeded"
//   Indicates that the customer already owns the maximum allowed number of subscriptions.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription
func (c *SNS) ConfirmSubscription(input *ConfirmSubscriptionInput) (*ConfirmSubscriptionOutput, error) {
	req, out := c.ConfirmSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlatformApplication = "CreatePlatformApplication"

// CreatePlatformApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlatformApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePlatformApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePlatformApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePlatformApplicationRequest method.
//    req, resp := client.CreatePlatformApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication
func (c *SNS) CreatePlatformApplicationRequest(input *CreatePlatformApplicationInput) (req *request.Request, output *CreatePlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opCreatePlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlatformApplicationInput{}
	}

	output = &CreatePlatformApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlatformApplication API operation for Amazon Simple Notification Service.
//
// Creates a platform application object for one of the supported push notification
// services, such as APNS and GCM, to which devices and mobile apps may register.
// You must specify PlatformPrincipal and PlatformCredential attributes when
// using the CreatePlatformApplication action. The PlatformPrincipal is received
// from the notification service. For APNS/APNS_SANDBOX, PlatformPrincipal is
// "SSL certificate". For GCM, PlatformPrincipal is not applicable. For ADM,
// PlatformPrincipal is "client id". The PlatformCredential is also received
// from the notification service. For WNS, PlatformPrincipal is "Package Security
// Identifier". For MPNS, PlatformPrincipal is "TLS certificate". For Baidu,
// PlatformPrincipal is "API key".
//
// For APNS/APNS_SANDBOX, PlatformCredential is "private key". For GCM, PlatformCredential
// is "API key". For ADM, PlatformCredential is "client secret". For WNS, PlatformCredential
// is "secret key". For MPNS, PlatformCredential is "private key". For Baidu,
// PlatformCredential is "secret key". The PlatformApplicationArn that is returned
// when using CreatePlatformApplication is then used as an attribute for the
// CreatePlatformEndpoint action. For more information, see Using Amazon SNS
// Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
// For more information about obtaining the PlatformPrincipal and PlatformCredential
// for each of the supported push notification services, see Getting Started
// with Apple Push Notification Service (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-apns.html),
// Getting Started with Amazon Device Messaging (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-adm.html),
// Getting Started with Baidu Cloud Push (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-baidu.html),
// Getting Started with Google Cloud Messaging for Android (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-gcm.html),
// Getting Started with MPNS (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-mpns.html),
// or Getting Started with WNS (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-wns.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation CreatePlatformApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication
func (c *SNS) CreatePlatformApplication(input *CreatePlatformApplicationInput) (*CreatePlatformApplicationOutput, error) {
	req, out := c.CreatePlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlatformEndpoint = "CreatePlatformEndpoint"

// CreatePlatformEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlatformEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePlatformEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePlatformEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePlatformEndpointRequest method.
//    req, resp := client.CreatePlatformEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint
func (c *SNS) CreatePlatformEndpointRequest(input *CreatePlatformEndpointInput) (req *request.Request, output *CreatePlatformEndpointOutput) {
	op := &request.Operation{
		Name:       opCreatePlatformEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlatformEndpointInput{}
	}

	output = &CreatePlatformEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePlatformEndpoint API operation for Amazon Simple Notification Service.
//
// Creates an endpoint for a device and mobile app on one of the supported push
// notification services, such as GCM and APNS. CreatePlatformEndpoint requires
// the PlatformApplicationArn that is returned from CreatePlatformApplication.
// The EndpointArn that is returned when using CreatePlatformEndpoint can then
// be used by the Publish action to send a message to a mobile app or by the
// Subscribe action for subscription to a topic. The CreatePlatformEndpoint
// action is idempotent, so if the requester already owns an endpoint with the
// same device token and attributes, that endpoint's ARN is returned without
// creating a new endpoint. For more information, see Using Amazon SNS Mobile
// Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// When using CreatePlatformEndpoint with Baidu, two attributes must be provided:
// ChannelId and UserId. The token field must also contain the ChannelId. For
// more information, see Creating an Amazon SNS Endpoint for Baidu (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation CreatePlatformEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint
func (c *SNS) CreatePlatformEndpoint(input *CreatePlatformEndpointInput) (*CreatePlatformEndpointOutput, error) {
	req, out := c.CreatePlatformEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTopic = "CreateTopic"

// CreateTopicRequest generates a "aws/request.Request" representing the
// client's request for the CreateTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTopicRequest method.
//    req, resp := client.CreateTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic
func (c *SNS) CreateTopicRequest(input *CreateTopicInput) (req *request.Request, output *CreateTopicOutput) {
	op := &request.Operation{
		Name:       opCreateTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTopicInput{}
	}

	output = &CreateTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTopic API operation for Amazon Simple Notification Service.
//
// Creates a topic to which notifications can be published. Users can create
// at most 100,000 topics. For more information, see http://aws.amazon.com/sns
// (http://aws.amazon.com/sns/). This action is idempotent, so if the requester
// already owns a topic with the specified name, that topic's ARN is returned
// without creating a new topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation CreateTopic for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeTopicLimitExceededException "TopicLimitExceeded"
//   Indicates that the customer already owns the maximum allowed number of topics.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic
func (c *SNS) CreateTopic(input *CreateTopicInput) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteEndpoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteEndpoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint
func (c *SNS) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon Simple Notification Service.
//
// Deletes the endpoint for a device and mobile app from Amazon SNS. This action
// is idempotent. For more information, see Using Amazon SNS Mobile Push Notifications
// (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// When you delete an endpoint that is also subscribed to a topic, then you
// must also unsubscribe the endpoint from the topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint
func (c *SNS) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePlatformApplication = "DeletePlatformApplication"

// DeletePlatformApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlatformApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePlatformApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePlatformApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePlatformApplicationRequest method.
//    req, resp := client.DeletePlatformApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication
func (c *SNS) DeletePlatformApplicationRequest(input *DeletePlatformApplicationInput) (req *request.Request, output *DeletePlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opDeletePlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlatformApplicationInput{}
	}

	output = &DeletePlatformApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlatformApplication API operation for Amazon Simple Notification Service.
//
// Deletes a platform application object for one of the supported push notification
// services, such as APNS and GCM. For more information, see Using Amazon SNS
// Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation DeletePlatformApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication
func (c *SNS) DeletePlatformApplication(input *DeletePlatformApplicationInput) (*DeletePlatformApplicationOutput, error) {
	req, out := c.DeletePlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTopic = "DeleteTopic"

// DeleteTopicRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTopicRequest method.
//    req, resp := client.DeleteTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic
func (c *SNS) DeleteTopicRequest(input *DeleteTopicInput) (req *request.Request, output *DeleteTopicOutput) {
	op := &request.Operation{
		Name:       opDeleteTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTopicInput{}
	}

	output = &DeleteTopicOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTopic API operation for Amazon Simple Notification Service.
//
// Deletes a topic and all its subscriptions. Deleting a topic might prevent
// some messages previously sent to the topic from being delivered to subscribers.
// This action is idempotent, so deleting a topic that does not exist does not
// result in an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation DeleteTopic for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic
func (c *SNS) DeleteTopic(input *DeleteTopicInput) (*DeleteTopicOutput, error) {
	req, out := c.DeleteTopicRequest(input)
	err := req.Send()
	return out, err
}

const opGetEndpointAttributes = "GetEndpointAttributes"

// GetEndpointAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpointAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetEndpointAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetEndpointAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetEndpointAttributesRequest method.
//    req, resp := client.GetEndpointAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes
func (c *SNS) GetEndpointAttributesRequest(input *GetEndpointAttributesInput) (req *request.Request, output *GetEndpointAttributesOutput) {
	op := &request.Operation{
		Name:       opGetEndpointAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEndpointAttributesInput{}
	}

	output = &GetEndpointAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpointAttributes API operation for Amazon Simple Notification Service.
//
// Retrieves the endpoint attributes for a device on one of the supported push
// notification services, such as GCM and APNS. For more information, see Using
// Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation GetEndpointAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes
func (c *SNS) GetEndpointAttributes(input *GetEndpointAttributesInput) (*GetEndpointAttributesOutput, error) {
	req, out := c.GetEndpointAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetPlatformApplicationAttributes = "GetPlatformApplicationAttributes"

// GetPlatformApplicationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetPlatformApplicationAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPlatformApplicationAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPlatformApplicationAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPlatformApplicationAttributesRequest method.
//    req, resp := client.GetPlatformApplicationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes
func (c *SNS) GetPlatformApplicationAttributesRequest(input *GetPlatformApplicationAttributesInput) (req *request.Request, output *GetPlatformApplicationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetPlatformApplicationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPlatformApplicationAttributesInput{}
	}

	output = &GetPlatformApplicationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlatformApplicationAttributes API operation for Amazon Simple Notification Service.
//
// Retrieves the attributes of the platform application object for the supported
// push notification services, such as APNS and GCM. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation GetPlatformApplicationAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes
func (c *SNS) GetPlatformApplicationAttributes(input *GetPlatformApplicationAttributesInput) (*GetPlatformApplicationAttributesOutput, error) {
	req, out := c.GetPlatformApplicationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetSMSAttributes = "GetSMSAttributes"

// GetSMSAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetSMSAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSMSAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSMSAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSMSAttributesRequest method.
//    req, resp := client.GetSMSAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes
func (c *SNS) GetSMSAttributesRequest(input *GetSMSAttributesInput) (req *request.Request, output *GetSMSAttributesOutput) {
	op := &request.Operation{
		Name:       opGetSMSAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSMSAttributesInput{}
	}

	output = &GetSMSAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSMSAttributes API operation for Amazon Simple Notification Service.
//
// Returns the settings for sending SMS messages from your account.
//
// These settings are set with the SetSMSAttributes action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation GetSMSAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottledException "Throttled"
//   Indicates that the rate at which requests have been submitted for this action
//   exceeds the limit for your account.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes
func (c *SNS) GetSMSAttributes(input *GetSMSAttributesInput) (*GetSMSAttributesOutput, error) {
	req, out := c.GetSMSAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetSubscriptionAttributes = "GetSubscriptionAttributes"

// GetSubscriptionAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetSubscriptionAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSubscriptionAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSubscriptionAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSubscriptionAttributesRequest method.
//    req, resp := client.GetSubscriptionAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes
func (c *SNS) GetSubscriptionAttributesRequest(input *GetSubscriptionAttributesInput) (req *request.Request, output *GetSubscriptionAttributesOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSubscriptionAttributesInput{}
	}

	output = &GetSubscriptionAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSubscriptionAttributes API operation for Amazon Simple Notification Service.
//
// Returns all of the properties of a subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation GetSubscriptionAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes
func (c *SNS) GetSubscriptionAttributes(input *GetSubscriptionAttributesInput) (*GetSubscriptionAttributesOutput, error) {
	req, out := c.GetSubscriptionAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetTopicAttributes = "GetTopicAttributes"

// GetTopicAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetTopicAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetTopicAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetTopicAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetTopicAttributesRequest method.
//    req, resp := client.GetTopicAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes
func (c *SNS) GetTopicAttributesRequest(input *GetTopicAttributesInput) (req *request.Request, output *GetTopicAttributesOutput) {
	op := &request.Operation{
		Name:       opGetTopicAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTopicAttributesInput{}
	}

	output = &GetTopicAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTopicAttributes API operation for Amazon Simple Notification Service.
//
// Returns all of the properties of a topic. Topic properties returned might
// differ based on the authorization of the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation GetTopicAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes
func (c *SNS) GetTopicAttributes(input *GetTopicAttributesInput) (*GetTopicAttributesOutput, error) {
	req, out := c.GetTopicAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opListEndpointsByPlatformApplication = "ListEndpointsByPlatformApplication"

// ListEndpointsByPlatformApplicationRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointsByPlatformApplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListEndpointsByPlatformApplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListEndpointsByPlatformApplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListEndpointsByPlatformApplicationRequest method.
//    req, resp := client.ListEndpointsByPlatformApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication
func (c *SNS) ListEndpointsByPlatformApplicationRequest(input *ListEndpointsByPlatformApplicationInput) (req *request.Request, output *ListEndpointsByPlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opListEndpointsByPlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsByPlatformApplicationInput{}
	}

	output = &ListEndpointsByPlatformApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointsByPlatformApplication API operation for Amazon Simple Notification Service.
//
// Lists the endpoints and endpoint attributes for devices in a supported push
// notification service, such as GCM and APNS. The results for ListEndpointsByPlatformApplication
// are paginated and return a limited list of endpoints, up to 100. If additional
// records are available after the first page results, then a NextToken string
// will be returned. To receive the next page, you call ListEndpointsByPlatformApplication
// again using the NextToken string received from the previous call. When there
// are no more records to return, NextToken will be null. For more information,
// see Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListEndpointsByPlatformApplication for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication
func (c *SNS) ListEndpointsByPlatformApplication(input *ListEndpointsByPlatformApplicationInput) (*ListEndpointsByPlatformApplicationOutput, error) {
	req, out := c.ListEndpointsByPlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

// ListEndpointsByPlatformApplicationPages iterates over the pages of a ListEndpointsByPlatformApplication operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointsByPlatformApplication method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEndpointsByPlatformApplication operation.
//    pageNum := 0
//    err := client.ListEndpointsByPlatformApplicationPages(params,
//        func(page *ListEndpointsByPlatformApplicationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SNS) ListEndpointsByPlatformApplicationPages(input *ListEndpointsByPlatformApplicationInput, fn func(p *ListEndpointsByPlatformApplicationOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEndpointsByPlatformApplicationRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEndpointsByPlatformApplicationOutput), lastPage)
	})
}

const opListPhoneNumbersOptedOut = "ListPhoneNumbersOptedOut"

// ListPhoneNumbersOptedOutRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbersOptedOut operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPhoneNumbersOptedOut for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPhoneNumbersOptedOut method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPhoneNumbersOptedOutRequest method.
//    req, resp := client.ListPhoneNumbersOptedOutRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut
func (c *SNS) ListPhoneNumbersOptedOutRequest(input *ListPhoneNumbersOptedOutInput) (req *request.Request, output *ListPhoneNumbersOptedOutOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbersOptedOut,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPhoneNumbersOptedOutInput{}
	}

	output = &ListPhoneNumbersOptedOutOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbersOptedOut API operation for Amazon Simple Notification Service.
//
// Returns a list of phone numbers that are opted out, meaning you cannot send
// SMS messages to them.
//
// The results for ListPhoneNumbersOptedOut are paginated, and each page returns
// up to 100 phone numbers. If additional phone numbers are available after
// the first page of results, then a NextToken string will be returned. To receive
// the next page, you call ListPhoneNumbersOptedOut again using the NextToken
// string received from the previous call. When there are no more records to
// return, NextToken will be null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListPhoneNumbersOptedOut for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottledException "Throttled"
//   Indicates that the rate at which requests have been submitted for this action
//   exceeds the limit for your account.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut
func (c *SNS) ListPhoneNumbersOptedOut(input *ListPhoneNumbersOptedOutInput) (*ListPhoneNumbersOptedOutOutput, error) {
	req, out := c.ListPhoneNumbersOptedOutRequest(input)
	err := req.Send()
	return out, err
}

const opListPlatformApplications = "ListPlatformApplications"

// ListPlatformApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlatformApplications operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPlatformApplications for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPlatformApplications method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPlatformApplicationsRequest method.
//    req, resp := client.ListPlatformApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications
func (c *SNS) ListPlatformApplicationsRequest(input *ListPlatformApplicationsInput) (req *request.Request, output *ListPlatformApplicationsOutput) {
	op := &request.Operation{
		Name:       opListPlatformApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlatformApplicationsInput{}
	}

	output = &ListPlatformApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlatformApplications API operation for Amazon Simple Notification Service.
//
// Lists the platform application objects for the supported push notification
// services, such as APNS and GCM. The results for ListPlatformApplications
// are paginated and return a limited list of applications, up to 100. If additional
// records are available after the first page results, then a NextToken string
// will be returned. To receive the next page, you call ListPlatformApplications
// using the NextToken string received from the previous call. When there are
// no more records to return, NextToken will be null. For more information,
// see Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListPlatformApplications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications
func (c *SNS) ListPlatformApplications(input *ListPlatformApplicationsInput) (*ListPlatformApplicationsOutput, error) {
	req, out := c.ListPlatformApplicationsRequest(input)
	err := req.Send()
	return out, err
}

// ListPlatformApplicationsPages iterates over the pages of a ListPlatformApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlatformApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPlatformApplications operation.
//    pageNum := 0
//    err := client.ListPlatformApplicationsPages(params,
//        func(page *ListPlatformApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SNS) ListPlatformApplicationsPages(input *ListPlatformApplicationsInput, fn func(p *ListPlatformApplicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPlatformApplicationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPlatformApplicationsOutput), lastPage)
	})
}

const opListSubscriptions = "ListSubscriptions"

// ListSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSubscriptions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSubscriptions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSubscriptionsRequest method.
//    req, resp := client.ListSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions
func (c *SNS) ListSubscriptionsRequest(input *ListSubscriptionsInput) (req *request.Request, output *ListSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionsInput{}
	}

	output = &ListSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptions API operation for Amazon Simple Notification Service.
//
// Returns a list of the requester's subscriptions. Each call returns a limited
// list of subscriptions, up to 100. If there are more subscriptions, a NextToken
// is also returned. Use the NextToken parameter in a new ListSubscriptions
// call to get further results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListSubscriptions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions
func (c *SNS) ListSubscriptions(input *ListSubscriptionsInput) (*ListSubscriptionsOutput, error) {
	req, out := c.ListSubscriptionsRequest(input)
	err := req.Send()
	return out, err
}

// ListSubscriptionsPages iterates over the pages of a ListSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSubscriptions operation.
//    pageNum := 0
//    err := client.ListSubscriptionsPages(params,
//        func(page *ListSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SNS) ListSubscriptionsPages(input *ListSubscriptionsInput, fn func(p *ListSubscriptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSubscriptionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSubscriptionsOutput), lastPage)
	})
}

const opListSubscriptionsByTopic = "ListSubscriptionsByTopic"

// ListSubscriptionsByTopicRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscriptionsByTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSubscriptionsByTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSubscriptionsByTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSubscriptionsByTopicRequest method.
//    req, resp := client.ListSubscriptionsByTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic
func (c *SNS) ListSubscriptionsByTopicRequest(input *ListSubscriptionsByTopicInput) (req *request.Request, output *ListSubscriptionsByTopicOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionsByTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionsByTopicInput{}
	}

	output = &ListSubscriptionsByTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscriptionsByTopic API operation for Amazon Simple Notification Service.
//
// Returns a list of the subscriptions to a specific topic. Each call returns
// a limited list of subscriptions, up to 100. If there are more subscriptions,
// a NextToken is also returned. Use the NextToken parameter in a new ListSubscriptionsByTopic
// call to get further results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListSubscriptionsByTopic for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic
func (c *SNS) ListSubscriptionsByTopic(input *ListSubscriptionsByTopicInput) (*ListSubscriptionsByTopicOutput, error) {
	req, out := c.ListSubscriptionsByTopicRequest(input)
	err := req.Send()
	return out, err
}

// ListSubscriptionsByTopicPages iterates over the pages of a ListSubscriptionsByTopic operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSubscriptionsByTopic method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSubscriptionsByTopic operation.
//    pageNum := 0
//    err := client.ListSubscriptionsByTopicPages(params,
//        func(page *ListSubscriptionsByTopicOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SNS) ListSubscriptionsByTopicPages(input *ListSubscriptionsByTopicInput, fn func(p *ListSubscriptionsByTopicOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSubscriptionsByTopicRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSubscriptionsByTopicOutput), lastPage)
	})
}

const opListTopics = "ListTopics"

// ListTopicsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTopics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTopics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTopicsRequest method.
//    req, resp := client.ListTopicsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics
func (c *SNS) ListTopicsRequest(input *ListTopicsInput) (req *request.Request, output *ListTopicsOutput) {
	op := &request.Operation{
		Name:       opListTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsInput{}
	}

	output = &ListTopicsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopics API operation for Amazon Simple Notification Service.
//
// Returns a list of the requester's topics. Each call returns a limited list
// of topics, up to 100. If there are more topics, a NextToken is also returned.
// Use the NextToken parameter in a new ListTopics call to get further results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation ListTopics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics
func (c *SNS) ListTopics(input *ListTopicsInput) (*ListTopicsOutput, error) {
	req, out := c.ListTopicsRequest(input)
	err := req.Send()
	return out, err
}

// ListTopicsPages iterates over the pages of a ListTopics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTopics operation.
//    pageNum := 0
//    err := client.ListTopicsPages(params,
//        func(page *ListTopicsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SNS) ListTopicsPages(input *ListTopicsInput, fn func(p *ListTopicsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListTopicsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListTopicsOutput), lastPage)
	})
}

const opOptInPhoneNumber = "OptInPhoneNumber"

// OptInPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the OptInPhoneNumber operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See OptInPhoneNumber for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the OptInPhoneNumber method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the OptInPhoneNumberRequest method.
//    req, resp := client.OptInPhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber
func (c *SNS) OptInPhoneNumberRequest(input *OptInPhoneNumberInput) (req *request.Request, output *OptInPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opOptInPhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OptInPhoneNumberInput{}
	}

	output = &OptInPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OptInPhoneNumber API operation for Amazon Simple Notification Service.
//
// Use this request to opt in a phone number that is opted out, which enables
// you to resume sending SMS messages to the number.
//
// You can opt in a phone number only once every 30 days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation OptInPhoneNumber for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeThrottledException "Throttled"
//   Indicates that the rate at which requests have been submitted for this action
//   exceeds the limit for your account.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber
func (c *SNS) OptInPhoneNumber(input *OptInPhoneNumberInput) (*OptInPhoneNumberOutput, error) {
	req, out := c.OptInPhoneNumberRequest(input)
	err := req.Send()
	return out, err
}

const opPublish = "Publish"

// PublishRequest generates a "aws/request.Request" representing the
// client's request for the Publish operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Publish for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Publish method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PublishRequest method.
//    req, resp := client.PublishRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish
func (c *SNS) PublishRequest(input *PublishInput) (req *request.Request, output *PublishOutput) {
	op := &request.Operation{
		Name:       opPublish,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PublishInput{}
	}

	output = &PublishOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Publish API operation for Amazon Simple Notification Service.
//
// Sends a message to all of a topic's subscribed endpoints. When a messageId
// is returned, the message has been saved and Amazon SNS will attempt to deliver
// it to the topic's subscribers shortly. The format of the outgoing message
// to each subscribed endpoint depends on the notification protocol.
//
// To use the Publish action for sending a message to a mobile endpoint, such
// as an app on a Kindle device or mobile phone, you must specify the EndpointArn
// for the TargetArn parameter. The EndpointArn is returned when making a call
// with the CreatePlatformEndpoint action.
//
// For more information about formatting messages, see Send Custom Platform-Specific
// Payloads in Messages to Mobile Devices (http://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation Publish for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInvalidParameterValueException "ParameterValueInvalid"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeEndpointDisabledException "EndpointDisabled"
//   Exception error indicating endpoint disabled.
//
//   * ErrCodePlatformApplicationDisabledException "PlatformApplicationDisabled"
//   Exception error indicating platform application disabled.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish
func (c *SNS) Publish(input *PublishInput) (*PublishOutput, error) {
	req, out := c.PublishRequest(input)
	err := req.Send()
	return out, err
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemovePermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemovePermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req, resp := client.RemovePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission
func (c *SNS) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for Amazon Simple Notification Service.
//
// Removes a statement from a topic's access control policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation RemovePermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission
func (c *SNS) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opSetEndpointAttributes = "SetEndpointAttributes"

// SetEndpointAttributesRequest generates a "aws/request.Request" representing the
// client's request for the SetEndpointAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetEndpointAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetEndpointAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetEndpointAttributesRequest method.
//    req, resp := client.SetEndpointAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes
func (c *SNS) SetEndpointAttributesRequest(input *SetEndpointAttributesInput) (req *request.Request, output *SetEndpointAttributesOutput) {
	op := &request.Operation{
		Name:       opSetEndpointAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetEndpointAttributesInput{}
	}

	output = &SetEndpointAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetEndpointAttributes API operation for Amazon Simple Notification Service.
//
// Sets the attributes for an endpoint for a device on one of the supported
// push notification services, such as GCM and APNS. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation SetEndpointAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes
func (c *SNS) SetEndpointAttributes(input *SetEndpointAttributesInput) (*SetEndpointAttributesOutput, error) {
	req, out := c.SetEndpointAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetPlatformApplicationAttributes = "SetPlatformApplicationAttributes"

// SetPlatformApplicationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the SetPlatformApplicationAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetPlatformApplicationAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetPlatformApplicationAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetPlatformApplicationAttributesRequest method.
//    req, resp := client.SetPlatformApplicationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes
func (c *SNS) SetPlatformApplicationAttributesRequest(input *SetPlatformApplicationAttributesInput) (req *request.Request, output *SetPlatformApplicationAttributesOutput) {
	op := &request.Operation{
		Name:       opSetPlatformApplicationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetPlatformApplicationAttributesInput{}
	}

	output = &SetPlatformApplicationAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetPlatformApplicationAttributes API operation for Amazon Simple Notification Service.
//
// Sets the attributes of the platform application object for the supported
// push notification services, such as APNS and GCM. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
// For information on configuring attributes for message delivery status, see
// Using Amazon SNS Application Attributes for Message Delivery Status (http://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation SetPlatformApplicationAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes
func (c *SNS) SetPlatformApplicationAttributes(input *SetPlatformApplicationAttributesInput) (*SetPlatformApplicationAttributesOutput, error) {
	req, out := c.SetPlatformApplicationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetSMSAttributes = "SetSMSAttributes"

// SetSMSAttributesRequest generates a "aws/request.Request" representing the
// client's request for the SetSMSAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetSMSAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetSMSAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetSMSAttributesRequest method.
//    req, resp := client.SetSMSAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes
func (c *SNS) SetSMSAttributesRequest(input *SetSMSAttributesInput) (req *request.Request, output *SetSMSAttributesOutput) {
	op := &request.Operation{
		Name:       opSetSMSAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSMSAttributesInput{}
	}

	output = &SetSMSAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetSMSAttributes API operation for Amazon Simple Notification Service.
//
// Use this request to set the default settings for sending SMS messages and
// receiving daily SMS usage reports.
//
// You can override some of these settings for a single message when you use
// the Publish action with the MessageAttributes.entry.N parameter. For more
// information, see Sending an SMS Message (http://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html)
// in the Amazon SNS Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation SetSMSAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeThrottledException "Throttled"
//   Indicates that the rate at which requests have been submitted for this action
//   exceeds the limit for your account.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes
func (c *SNS) SetSMSAttributes(input *SetSMSAttributesInput) (*SetSMSAttributesOutput, error) {
	req, out := c.SetSMSAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetSubscriptionAttributes = "SetSubscriptionAttributes"

// SetSubscriptionAttributesRequest generates a "aws/request.Request" representing the
// client's request for the SetSubscriptionAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetSubscriptionAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetSubscriptionAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetSubscriptionAttributesRequest method.
//    req, resp := client.SetSubscriptionAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes
func (c *SNS) SetSubscriptionAttributesRequest(input *SetSubscriptionAttributesInput) (req *request.Request, output *SetSubscriptionAttributesOutput) {
	op := &request.Operation{
		Name:       opSetSubscriptionAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSubscriptionAttributesInput{}
	}

	output = &SetSubscriptionAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetSubscriptionAttributes API operation for Amazon Simple Notification Service.
//
// Allows a subscription owner to set an attribute of the topic to a new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation SetSubscriptionAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes
func (c *SNS) SetSubscriptionAttributes(input *SetSubscriptionAttributesInput) (*SetSubscriptionAttributesOutput, error) {
	req, out := c.SetSubscriptionAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetTopicAttributes = "SetTopicAttributes"

// SetTopicAttributesRequest generates a "aws/request.Request" representing the
// client's request for the SetTopicAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetTopicAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetTopicAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetTopicAttributesRequest method.
//    req, resp := client.SetTopicAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes
func (c *SNS) SetTopicAttributesRequest(input *SetTopicAttributesInput) (req *request.Request, output *SetTopicAttributesOutput) {
	op := &request.Operation{
		Name:       opSetTopicAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTopicAttributesInput{}
	}

	output = &SetTopicAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetTopicAttributes API operation for Amazon Simple Notification Service.
//
// Allows a topic owner to set an attribute of the topic to a new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation SetTopicAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes
func (c *SNS) SetTopicAttributes(input *SetTopicAttributesInput) (*SetTopicAttributesOutput, error) {
	req, out := c.SetTopicAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSubscribe = "Subscribe"

// SubscribeRequest generates a "aws/request.Request" representing the
// client's request for the Subscribe operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Subscribe for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Subscribe method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SubscribeRequest method.
//    req, resp := client.SubscribeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe
func (c *SNS) SubscribeRequest(input *SubscribeInput) (req *request.Request, output *SubscribeOutput) {
	op := &request.Operation{
		Name:       opSubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubscribeInput{}
	}

	output = &SubscribeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Subscribe API operation for Amazon Simple Notification Service.
//
// Prepares to subscribe an endpoint by sending the endpoint a confirmation
// message. To actually create a subscription, the endpoint owner must call
// the ConfirmSubscription action with the token from the confirmation message.
// Confirmation tokens are valid for three days.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation Subscribe for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubscriptionLimitExceededException "SubscriptionLimitExceeded"
//   Indicates that the customer already owns the maximum allowed number of subscriptions.
//
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe
func (c *SNS) Subscribe(input *SubscribeInput) (*SubscribeOutput, error) {
	req, out := c.SubscribeRequest(input)
	err := req.Send()
	return out, err
}

const opUnsubscribe = "Unsubscribe"

// UnsubscribeRequest generates a "aws/request.Request" representing the
// client's request for the Unsubscribe operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Unsubscribe for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Unsubscribe method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UnsubscribeRequest method.
//    req, resp := client.UnsubscribeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe
func (c *SNS) UnsubscribeRequest(input *UnsubscribeInput) (req *request.Request, output *UnsubscribeOutput) {
	op := &request.Operation{
		Name:       opUnsubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnsubscribeInput{}
	}

	output = &UnsubscribeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// Unsubscribe API operation for Amazon Simple Notification Service.
//
// Deletes a subscription. If the subscription requires authentication for deletion,
// only the owner of the subscription or the topic's owner can unsubscribe,
// and an AWS signature is required. If the Unsubscribe call does not require
// authentication and the requester is not the subscription owner, a final cancellation
// message is delivered to the endpoint, so that the endpoint owner can easily
// resubscribe to the topic if the Unsubscribe request was unintended.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Notification Service's
// API operation Unsubscribe for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameter"
//   Indicates that a request parameter does not comply with the associated constraints.
//
//   * ErrCodeInternalErrorException "InternalError"
//   Indicates an internal service error.
//
//   * ErrCodeAuthorizationErrorException "AuthorizationError"
//   Indicates that the user has been denied access to the requested resource.
//
//   * ErrCodeNotFoundException "NotFound"
//   Indicates that the requested resource does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe
func (c *SNS) Unsubscribe(input *UnsubscribeInput) (*UnsubscribeOutput, error) {
	req, out := c.UnsubscribeRequest(input)
	err := req.Send()
	return out, err
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermissionInput
type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS account IDs of the users (principals) who will be given access to
	// the specified actions. The users must have AWS accounts, but do not need
	// to be signed up for this service.
	//
	// AWSAccountId is a required field
	AWSAccountId []*string `type:"list" required:"true"`

	// The action you want to allow for the specified principal(s).
	//
	// Valid values: any Amazon SNS action name.
	//
	// ActionName is a required field
	ActionName []*string `type:"list" required:"true"`

	// A unique identifier for the new policy statement.
	//
	// Label is a required field
	Label *string `type:"string" required:"true"`

	// The ARN of the topic whose access control policy you wish to modify.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddPermissionInput"}
	if s.AWSAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AWSAccountId"))
	}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.Label == nil {
		invalidParams.Add(request.NewErrParamRequired("Label"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAWSAccountId sets the AWSAccountId field's value.
func (s *AddPermissionInput) SetAWSAccountId(v []*string) *AddPermissionInput {
	s.AWSAccountId = v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *AddPermissionInput) SetActionName(v []*string) *AddPermissionInput {
	s.ActionName = v
	return s
}

// SetLabel sets the Label field's value.
func (s *AddPermissionInput) SetLabel(v string) *AddPermissionInput {
	s.Label = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *AddPermissionInput) SetTopicArn(v string) *AddPermissionInput {
	s.TopicArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermissionOutput
type AddPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// The input for the CheckIfPhoneNumberIsOptedOut action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOutInput
type CheckIfPhoneNumberIsOptedOutInput struct {
	_ struct{} `type:"structure"`

	// The phone number for which you want to check the opt out status.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `locationName:"phoneNumber" type:"string" required:"true"`
}

// String returns the string representation
func (s CheckIfPhoneNumberIsOptedOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckIfPhoneNumberIsOptedOutInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckIfPhoneNumberIsOptedOutInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckIfPhoneNumberIsOptedOutInput"}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *CheckIfPhoneNumberIsOptedOutInput) SetPhoneNumber(v string) *CheckIfPhoneNumberIsOptedOutInput {
	s.PhoneNumber = &v
	return s
}

// The response from the CheckIfPhoneNumberIsOptedOut action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOutResponse
type CheckIfPhoneNumberIsOptedOutOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the phone number is opted out:
	//
	//    * true – The phone number is opted out, meaning you cannot publish SMS
	//    messages to it.
	//
	//    * false – The phone number is opted in, meaning you can publish SMS messages
	//    to it.
	IsOptedOut *bool `locationName:"isOptedOut" type:"boolean"`
}

// String returns the string representation
func (s CheckIfPhoneNumberIsOptedOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckIfPhoneNumberIsOptedOutOutput) GoString() string {
	return s.String()
}

// SetIsOptedOut sets the IsOptedOut field's value.
func (s *CheckIfPhoneNumberIsOptedOutOutput) SetIsOptedOut(v bool) *CheckIfPhoneNumberIsOptedOutOutput {
	s.IsOptedOut = &v
	return s
}

// Input for ConfirmSubscription action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscriptionInput
type ConfirmSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Disallows unauthenticated unsubscribes of the subscription. If the value
	// of this parameter is true and the request has an AWS signature, then only
	// the topic owner and the subscription owner can unsubscribe the endpoint.
	// The unsubscribe action requires AWS authentication.
	AuthenticateOnUnsubscribe *string `type:"string"`

	// Short-lived token sent to an endpoint during the Subscribe action.
	//
	// Token is a required field
	Token *string `type:"string" required:"true"`

	// The ARN of the topic for which you wish to confirm a subscription.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfirmSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmSubscriptionInput"}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticateOnUnsubscribe sets the AuthenticateOnUnsubscribe field's value.
func (s *ConfirmSubscriptionInput) SetAuthenticateOnUnsubscribe(v string) *ConfirmSubscriptionInput {
	s.AuthenticateOnUnsubscribe = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ConfirmSubscriptionInput) SetToken(v string) *ConfirmSubscriptionInput {
	s.Token = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *ConfirmSubscriptionInput) SetTopicArn(v string) *ConfirmSubscriptionInput {
	s.TopicArn = &v
	return s
}

// Response for ConfirmSubscriptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscriptionResponse
type ConfirmSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created subscription.
	SubscriptionArn *string `type:"string"`
}

// String returns the string representation
func (s ConfirmSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *ConfirmSubscriptionOutput) SetSubscriptionArn(v string) *ConfirmSubscriptionOutput {
	s.SubscriptionArn = &v
	return s
}

// Input for CreatePlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplicationInput
type CreatePlatformApplicationInput struct {
	_ struct{} `type:"structure"`

	// For a list of attributes, see SetPlatformApplicationAttributes (http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html)
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// Application names must be made up of only uppercase and lowercase ASCII letters,
	// numbers, underscores, hyphens, and periods, and must be between 1 and 256
	// characters long.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The following platforms are supported: ADM (Amazon Device Messaging), APNS
	// (Apple Push Notification Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlatformApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlatformApplicationInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreatePlatformApplicationInput) SetAttributes(v map[string]*string) *CreatePlatformApplicationInput {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePlatformApplicationInput) SetName(v string) *CreatePlatformApplicationInput {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *CreatePlatformApplicationInput) SetPlatform(v string) *CreatePlatformApplicationInput {
	s.Platform = &v
	return s
}

// Response from CreatePlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplicationResponse
type CreatePlatformApplicationOutput struct {
	_ struct{} `type:"structure"`

	// PlatformApplicationArn is returned.
	PlatformApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s CreatePlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformApplicationOutput) GoString() string {
	return s.String()
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *CreatePlatformApplicationOutput) SetPlatformApplicationArn(v string) *CreatePlatformApplicationOutput {
	s.PlatformApplicationArn = &v
	return s
}

// Input for CreatePlatformEndpoint action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpointInput
type CreatePlatformEndpointInput struct {
	_ struct{} `type:"structure"`

	// For a list of attributes, see SetEndpointAttributes (http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html).
	Attributes map[string]*string `type:"map"`

	// Arbitrary user data to associate with the endpoint. Amazon SNS does not use
	// this data. The data must be in UTF-8 format and less than 2KB.
	CustomUserData *string `type:"string"`

	// PlatformApplicationArn returned from CreatePlatformApplication is used to
	// create a an endpoint.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`

	// Unique identifier created by the notification service for an app on a device.
	// The specific name for Token will vary, depending on which notification service
	// is being used. For example, when using APNS as the notification service,
	// you need the device token. Alternatively, when using GCM or ADM, the device
	// token equivalent is called the registration ID.
	//
	// Token is a required field
	Token *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlatformEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlatformEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlatformEndpointInput"}
	if s.PlatformApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformApplicationArn"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreatePlatformEndpointInput) SetAttributes(v map[string]*string) *CreatePlatformEndpointInput {
	s.Attributes = v
	return s
}

// SetCustomUserData sets the CustomUserData field's value.
func (s *CreatePlatformEndpointInput) SetCustomUserData(v string) *CreatePlatformEndpointInput {
	s.CustomUserData = &v
	return s
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *CreatePlatformEndpointInput) SetPlatformApplicationArn(v string) *CreatePlatformEndpointInput {
	s.PlatformApplicationArn = &v
	return s
}

// SetToken sets the Token field's value.
func (s *CreatePlatformEndpointInput) SetToken(v string) *CreatePlatformEndpointInput {
	s.Token = &v
	return s
}

// Response from CreateEndpoint action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateEndpointResponse
type CreatePlatformEndpointOutput struct {
	_ struct{} `type:"structure"`

	// EndpointArn returned from CreateEndpoint action.
	EndpointArn *string `type:"string"`
}

// String returns the string representation
func (s CreatePlatformEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreatePlatformEndpointOutput) SetEndpointArn(v string) *CreatePlatformEndpointOutput {
	s.EndpointArn = &v
	return s
}

// Input for CreateTopic action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopicInput
type CreateTopicInput struct {
	_ struct{} `type:"structure"`

	// The name of the topic you want to create.
	//
	// Constraints: Topic names must be made up of only uppercase and lowercase
	// ASCII letters, numbers, underscores, and hyphens, and must be between 1 and
	// 256 characters long.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTopicInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateTopicInput) SetName(v string) *CreateTopicInput {
	s.Name = &v
	return s
}

// Response from CreateTopic action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopicResponse
type CreateTopicOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the created topic.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s CreateTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicOutput) GoString() string {
	return s.String()
}

// SetTopicArn sets the TopicArn field's value.
func (s *CreateTopicOutput) SetTopicArn(v string) *CreateTopicOutput {
	s.TopicArn = &v
	return s
}

// Input for DeleteEndpoint action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpointInput
type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// EndpointArn of endpoint to delete.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpointOutput
type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// Input for DeletePlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplicationInput
type DeletePlatformApplicationInput struct {
	_ struct{} `type:"structure"`

	// PlatformApplicationArn of platform application object to delete.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlatformApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlatformApplicationInput"}
	if s.PlatformApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformApplicationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *DeletePlatformApplicationInput) SetPlatformApplicationArn(v string) *DeletePlatformApplicationInput {
	s.PlatformApplicationArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplicationOutput
type DeletePlatformApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformApplicationOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopicInput
type DeleteTopicInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the topic you want to delete.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTopicInput"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *DeleteTopicInput) SetTopicArn(v string) *DeleteTopicInput {
	s.TopicArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopicOutput
type DeleteTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicOutput) GoString() string {
	return s.String()
}

// Endpoint for mobile app and device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Endpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Attributes for endpoint.
	Attributes map[string]*string `type:"map"`

	// EndpointArn for mobile app and device.
	EndpointArn *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Endpoint) SetAttributes(v map[string]*string) *Endpoint {
	s.Attributes = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// Input for GetEndpointAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributesInput
type GetEndpointAttributesInput struct {
	_ struct{} `type:"structure"`

	// EndpointArn for GetEndpointAttributes input.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetEndpointAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointAttributesInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *GetEndpointAttributesInput) SetEndpointArn(v string) *GetEndpointAttributesInput {
	s.EndpointArn = &v
	return s
}

// Response from GetEndpointAttributes of the EndpointArn.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributesResponse
type GetEndpointAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Attributes include the following:
	//
	//    * CustomUserData -- arbitrary user data to associate with the endpoint.
	//    Amazon SNS does not use this data. The data must be in UTF-8 format and
	//    less than 2KB.
	//
	//    * Enabled -- flag that enables/disables delivery to the endpoint. Amazon
	//    SNS will set this to false when a notification service indicates to Amazon
	//    SNS that the endpoint is invalid. Users can set it back to true, typically
	//    after updating Token.
	//
	//    * Token -- device token, also referred to as a registration id, for an
	//    app and mobile device. This is returned from the notification service
	//    when an app and mobile device are registered with the notification service.
	Attributes map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetEndpointAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetEndpointAttributesOutput) SetAttributes(v map[string]*string) *GetEndpointAttributesOutput {
	s.Attributes = v
	return s
}

// Input for GetPlatformApplicationAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributesInput
type GetPlatformApplicationAttributesInput struct {
	_ struct{} `type:"structure"`

	// PlatformApplicationArn for GetPlatformApplicationAttributesInput.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPlatformApplicationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlatformApplicationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlatformApplicationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlatformApplicationAttributesInput"}
	if s.PlatformApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformApplicationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *GetPlatformApplicationAttributesInput) SetPlatformApplicationArn(v string) *GetPlatformApplicationAttributesInput {
	s.PlatformApplicationArn = &v
	return s
}

// Response for GetPlatformApplicationAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributesResponse
type GetPlatformApplicationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Attributes include the following:
	//
	//    * EventEndpointCreated -- Topic ARN to which EndpointCreated event notifications
	//    should be sent.
	//
	//    * EventEndpointDeleted -- Topic ARN to which EndpointDeleted event notifications
	//    should be sent.
	//
	//    * EventEndpointUpdated -- Topic ARN to which EndpointUpdate event notifications
	//    should be sent.
	//
	//    * EventDeliveryFailure -- Topic ARN to which DeliveryFailure event notifications
	//    should be sent upon Direct Publish delivery failure (permanent) to one
	//    of the application's endpoints.
	Attributes map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetPlatformApplicationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlatformApplicationAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetPlatformApplicationAttributesOutput) SetAttributes(v map[string]*string) *GetPlatformApplicationAttributesOutput {
	s.Attributes = v
	return s
}

// The input for the GetSMSAttributes request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributesInput
type GetSMSAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of the individual attribute names, such as MonthlySpendLimit, for
	// which you want values.
	//
	// For all attribute names, see SetSMSAttributes (http://docs.aws.amazon.com/sns/latest/api/API_SetSMSAttributes.html).
	//
	// If you don't use this parameter, Amazon SNS returns all SMS attributes.
	Attributes []*string `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s GetSMSAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSMSAttributesInput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetSMSAttributesInput) SetAttributes(v []*string) *GetSMSAttributesInput {
	s.Attributes = v
	return s
}

// The response from the GetSMSAttributes request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributesResponse
type GetSMSAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The SMS attribute names and their values.
	Attributes map[string]*string `locationName:"attributes" type:"map"`
}

// String returns the string representation
func (s GetSMSAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSMSAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetSMSAttributesOutput) SetAttributes(v map[string]*string) *GetSMSAttributesOutput {
	s.Attributes = v
	return s
}

// Input for GetSubscriptionAttributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributesInput
type GetSubscriptionAttributesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the subscription whose properties you want to get.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetSubscriptionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSubscriptionAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSubscriptionAttributesInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *GetSubscriptionAttributesInput) SetSubscriptionArn(v string) *GetSubscriptionAttributesInput {
	s.SubscriptionArn = &v
	return s
}

// Response for GetSubscriptionAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributesResponse
type GetSubscriptionAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of the subscription's attributes. Attributes in this map include the
	// following:
	//
	//    * SubscriptionArn -- the subscription's ARN
	//
	//    * TopicArn -- the topic ARN that the subscription is associated with
	//
	//    * Owner -- the AWS account ID of the subscription's owner
	//
	//    * ConfirmationWasAuthenticated -- true if the subscription confirmation
	//    request was authenticated
	//
	//    * DeliveryPolicy -- the JSON serialization of the subscription's delivery
	//    policy
	//
	//    * EffectiveDeliveryPolicy -- the JSON serialization of the effective delivery
	//    policy that takes into account the topic delivery policy and account system
	//    defaults
	Attributes map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetSubscriptionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetSubscriptionAttributesOutput) SetAttributes(v map[string]*string) *GetSubscriptionAttributesOutput {
	s.Attributes = v
	return s
}

// Input for GetTopicAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributesInput
type GetTopicAttributesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the topic whose properties you want to get.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTopicAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTopicAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTopicAttributesInput"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *GetTopicAttributesInput) SetTopicArn(v string) *GetTopicAttributesInput {
	s.TopicArn = &v
	return s
}

// Response for GetTopicAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributesResponse
type GetTopicAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of the topic's attributes. Attributes in this map include the following:
	//
	//    * TopicArn -- the topic's ARN
	//
	//    * Owner -- the AWS account ID of the topic's owner
	//
	//    * Policy -- the JSON serialization of the topic's access control policy
	//
	//    * DisplayName -- the human-readable name used in the "From" field for
	//    notifications to email and email-json endpoints
	//
	//    * SubscriptionsPending -- the number of subscriptions pending confirmation
	//    on this topic
	//
	//    * SubscriptionsConfirmed -- the number of confirmed subscriptions on this
	//    topic
	//
	//    * SubscriptionsDeleted -- the number of deleted subscriptions on this
	//    topic
	//
	//    * DeliveryPolicy -- the JSON serialization of the topic's delivery policy
	//
	//    * EffectiveDeliveryPolicy -- the JSON serialization of the effective delivery
	//    policy that takes into account system defaults
	Attributes map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetTopicAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetTopicAttributesOutput) SetAttributes(v map[string]*string) *GetTopicAttributesOutput {
	s.Attributes = v
	return s
}

// Input for ListEndpointsByPlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplicationInput
type ListEndpointsByPlatformApplicationInput struct {
	_ struct{} `type:"structure"`

	// NextToken string is used when calling ListEndpointsByPlatformApplication
	// action to retrieve additional records that are available after the first
	// page results.
	NextToken *string `type:"string"`

	// PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsByPlatformApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsByPlatformApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsByPlatformApplicationInput"}
	if s.PlatformApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformApplicationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsByPlatformApplicationInput) SetNextToken(v string) *ListEndpointsByPlatformApplicationInput {
	s.NextToken = &v
	return s
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *ListEndpointsByPlatformApplicationInput) SetPlatformApplicationArn(v string) *ListEndpointsByPlatformApplicationInput {
	s.PlatformApplicationArn = &v
	return s
}

// Response for ListEndpointsByPlatformApplication action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplicationResponse
type ListEndpointsByPlatformApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Endpoints returned for ListEndpointsByPlatformApplication action.
	Endpoints []*Endpoint `type:"list"`

	// NextToken string is returned when calling ListEndpointsByPlatformApplication
	// action if additional records are available after the first page results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsByPlatformApplicationOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointsByPlatformApplicationOutput) SetEndpoints(v []*Endpoint) *ListEndpointsByPlatformApplicationOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsByPlatformApplicationOutput) SetNextToken(v string) *ListEndpointsByPlatformApplicationOutput {
	s.NextToken = &v
	return s
}

// The input for the ListPhoneNumbersOptedOut action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOutInput
type ListPhoneNumbersOptedOutInput struct {
	_ struct{} `type:"structure"`

	// A NextToken string is used when you call the ListPhoneNumbersOptedOut action
	// to retrieve additional records that are available after the first page of
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPhoneNumbersOptedOutInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersOptedOutInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersOptedOutInput) SetNextToken(v string) *ListPhoneNumbersOptedOutInput {
	s.NextToken = &v
	return s
}

// The response from the ListPhoneNumbersOptedOut action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOutResponse
type ListPhoneNumbersOptedOutOutput struct {
	_ struct{} `type:"structure"`

	// A NextToken string is returned when you call the ListPhoneNumbersOptedOut
	// action if additional records are available after the first page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of phone numbers that are opted out of receiving SMS messages. The
	// list is paginated, and each page can contain up to 100 phone numbers.
	PhoneNumbers []*string `locationName:"phoneNumbers" type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersOptedOutOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersOptedOutOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersOptedOutOutput) SetNextToken(v string) *ListPhoneNumbersOptedOutOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *ListPhoneNumbersOptedOutOutput) SetPhoneNumbers(v []*string) *ListPhoneNumbersOptedOutOutput {
	s.PhoneNumbers = v
	return s
}

// Input for ListPlatformApplications action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplicationsInput
type ListPlatformApplicationsInput struct {
	_ struct{} `type:"structure"`

	// NextToken string is used when calling ListPlatformApplications action to
	// retrieve additional records that are available after the first page results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListPlatformApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformApplicationsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformApplicationsInput) SetNextToken(v string) *ListPlatformApplicationsInput {
	s.NextToken = &v
	return s
}

// Response for ListPlatformApplications action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplicationsResponse
type ListPlatformApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// NextToken string is returned when calling ListPlatformApplications action
	// if additional records are available after the first page results.
	NextToken *string `type:"string"`

	// Platform applications returned when calling ListPlatformApplications action.
	PlatformApplications []*PlatformApplication `type:"list"`
}

// String returns the string representation
func (s ListPlatformApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformApplicationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlatformApplicationsOutput) SetNextToken(v string) *ListPlatformApplicationsOutput {
	s.NextToken = &v
	return s
}

// SetPlatformApplications sets the PlatformApplications field's value.
func (s *ListPlatformApplicationsOutput) SetPlatformApplications(v []*PlatformApplication) *ListPlatformApplicationsOutput {
	s.PlatformApplications = v
	return s
}

// Input for ListSubscriptionsByTopic action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopicInput
type ListSubscriptionsByTopicInput struct {
	_ struct{} `type:"structure"`

	// Token returned by the previous ListSubscriptionsByTopic request.
	NextToken *string `type:"string"`

	// The ARN of the topic for which you wish to find subscriptions.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListSubscriptionsByTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsByTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubscriptionsByTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubscriptionsByTopicInput"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionsByTopicInput) SetNextToken(v string) *ListSubscriptionsByTopicInput {
	s.NextToken = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *ListSubscriptionsByTopicInput) SetTopicArn(v string) *ListSubscriptionsByTopicInput {
	s.TopicArn = &v
	return s
}

// Response for ListSubscriptionsByTopic action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopicResponse
type ListSubscriptionsByTopicOutput struct {
	_ struct{} `type:"structure"`

	// Token to pass along to the next ListSubscriptionsByTopic request. This element
	// is returned if there are more subscriptions to retrieve.
	NextToken *string `type:"string"`

	// A list of subscriptions.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s ListSubscriptionsByTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsByTopicOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionsByTopicOutput) SetNextToken(v string) *ListSubscriptionsByTopicOutput {
	s.NextToken = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *ListSubscriptionsByTopicOutput) SetSubscriptions(v []*Subscription) *ListSubscriptionsByTopicOutput {
	s.Subscriptions = v
	return s
}

// Input for ListSubscriptions action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsInput
type ListSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// Token returned by the previous ListSubscriptions request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionsInput) SetNextToken(v string) *ListSubscriptionsInput {
	s.NextToken = &v
	return s
}

// Response for ListSubscriptions action
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsResponse
type ListSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// Token to pass along to the next ListSubscriptions request. This element is
	// returned if there are more subscriptions to retrieve.
	NextToken *string `type:"string"`

	// A list of subscriptions.
	Subscriptions []*Subscription `type:"list"`
}

// String returns the string representation
func (s ListSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSubscriptionsOutput) SetNextToken(v string) *ListSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *ListSubscriptionsOutput) SetSubscriptions(v []*Subscription) *ListSubscriptionsOutput {
	s.Subscriptions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopicsInput
type ListTopicsInput struct {
	_ struct{} `type:"structure"`

	// Token returned by the previous ListTopics request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTopicsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsInput) SetNextToken(v string) *ListTopicsInput {
	s.NextToken = &v
	return s
}

// Response for ListTopics action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopicsResponse
type ListTopicsOutput struct {
	_ struct{} `type:"structure"`

	// Token to pass along to the next ListTopics request. This element is returned
	// if there are additional topics to retrieve.
	NextToken *string `type:"string"`

	// A list of topic ARNs.
	Topics []*Topic `type:"list"`
}

// String returns the string representation
func (s ListTopicsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsOutput) SetNextToken(v string) *ListTopicsOutput {
	s.NextToken = &v
	return s
}

// SetTopics sets the Topics field's value.
func (s *ListTopicsOutput) SetTopics(v []*Topic) *ListTopicsOutput {
	s.Topics = v
	return s
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For
// more information, see Publish (http://docs.aws.amazon.com/sns/latest/api/API_Publish.html).
//
// Name, type, and value must not be empty or null. In addition, the message
// body should not be empty or null. All parts of the message attribute, including
// name, type, and value, are included in the message size restriction, which
// is currently 256 KB (262,144 bytes). For more information, see Using Amazon
// SNS Message Attributes (http://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/MessageAttributeValue
type MessageAttributeValue struct {
	_ struct{} `type:"structure"`

	// Binary type attributes can store any binary data, for example, compressed
	// data, encrypted data, or images.
	//
	// BinaryValue is automatically base64 encoded/decoded by the SDK.
	BinaryValue []byte `type:"blob"`

	// Amazon SNS supports the following logical data types: String, Number, and
	// Binary. For more information, see Message Attribute Data Types (http://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
	//
	// DataType is a required field
	DataType *string `type:"string" required:"true"`

	// Strings are Unicode with UTF8 binary encoding. For a list of code values,
	// see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string `type:"string"`
}

// String returns the string representation
func (s MessageAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageAttributeValue"}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBinaryValue sets the BinaryValue field's value.
func (s *MessageAttributeValue) SetBinaryValue(v []byte) *MessageAttributeValue {
	s.BinaryValue = v
	return s
}

// SetDataType sets the DataType field's value.
func (s *MessageAttributeValue) SetDataType(v string) *MessageAttributeValue {
	s.DataType = &v
	return s
}

// SetStringValue sets the StringValue field's value.
func (s *MessageAttributeValue) SetStringValue(v string) *MessageAttributeValue {
	s.StringValue = &v
	return s
}

// Input for the OptInPhoneNumber action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumberInput
type OptInPhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The phone number to opt in.
	//
	// PhoneNumber is a required field
	PhoneNumber *string `locationName:"phoneNumber" type:"string" required:"true"`
}

// String returns the string representation
func (s OptInPhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptInPhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptInPhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OptInPhoneNumberInput"}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *OptInPhoneNumberInput) SetPhoneNumber(v string) *OptInPhoneNumberInput {
	s.PhoneNumber = &v
	return s
}

// The response for the OptInPhoneNumber action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumberResponse
type OptInPhoneNumberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s OptInPhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptInPhoneNumberOutput) GoString() string {
	return s.String()
}

// Platform application object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PlatformApplication
type PlatformApplication struct {
	_ struct{} `type:"structure"`

	// Attributes for platform application object.
	Attributes map[string]*string `type:"map"`

	// PlatformApplicationArn for platform application object.
	PlatformApplicationArn *string `type:"string"`
}

// String returns the string representation
func (s PlatformApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformApplication) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PlatformApplication) SetAttributes(v map[string]*string) *PlatformApplication {
	s.Attributes = v
	return s
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *PlatformApplication) SetPlatformApplicationArn(v string) *PlatformApplication {
	s.PlatformApplicationArn = &v
	return s
}

// Input for Publish action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PublishInput
type PublishInput struct {
	_ struct{} `type:"structure"`

	// The message you want to send to the topic.
	//
	// If you want to send the same message to all transport protocols, include
	// the text of the message as a String value.
	//
	// If you want to send different messages for each transport protocol, set the
	// value of the MessageStructure parameter to json and use a JSON object for
	// the Message parameter.
	//
	// Constraints: Messages must be UTF-8 encoded strings at most 256 KB in size
	// (262144 bytes, not 262144 characters).
	//
	// JSON-specific constraints:
	//
	//    * Keys in the JSON object that correspond to supported transport protocols
	//    must have simple JSON string values.
	//
	//    * The values will be parsed (unescaped) before they are used in outgoing
	//    messages.
	//
	//    * Outbound notifications are JSON encoded (meaning that the characters
	//    will be reescaped for sending).
	//
	//    * Values have a minimum length of 0 (the empty string, "", is allowed).
	//
	//    * Values have a maximum length bounded by the overall message size (so,
	//    including multiple protocols may limit message sizes).
	//
	//    * Non-string values will cause the key to be ignored.
	//
	//    * Keys that do not correspond to supported transport protocols are ignored.
	//
	//    * Duplicate keys are not allowed.
	//
	//    * Failure to parse or validate any key or value in the message will cause
	//    the Publish call to return an error (no partial delivery).
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// Message attributes for Publish action.
	MessageAttributes map[string]*MessageAttributeValue `locationNameKey:"Name" locationNameValue:"Value" type:"map"`

	// Set MessageStructure to json if you want to send a different message for
	// each protocol. For example, using one publish action, you can send a short
	// message to your SMS subscribers and a longer message to your email subscribers.
	// If you set MessageStructure to json, the value of the Message parameter must:
	//
	//    * be a syntactically valid JSON object; and
	//
	//    * contain at least a top-level JSON key of "default" with a value that
	//    is a string.
	//
	// You can define other top-level keys that define the message you want to send
	// to a specific transport protocol (e.g., "http").
	//
	// For information about sending different messages for each protocol using
	// the AWS Management Console, go to Create Different Messages for Each Protocol
	// (http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol)
	// in the Amazon Simple Notification Service Getting Started Guide.
	//
	// Valid value: json
	MessageStructure *string `type:"string"`

	// The phone number to which you want to deliver an SMS message. Use E.164 format.
	//
	// If you don't specify a value for the PhoneNumber parameter, you must specify
	// a value for the TargetArn or TopicArn parameters.
	PhoneNumber *string `type:"string"`

	// Optional parameter to be used as the "Subject" line when the message is delivered
	// to email endpoints. This field will also be included, if present, in the
	// standard JSON messages delivered to other endpoints.
	//
	// Constraints: Subjects must be ASCII text that begins with a letter, number,
	// or punctuation mark; must not include line breaks or control characters;
	// and must be less than 100 characters long.
	Subject *string `type:"string"`

	// Either TopicArn or EndpointArn, but not both.
	//
	// If you don't specify a value for the TargetArn parameter, you must specify
	// a value for the PhoneNumber or TopicArn parameters.
	TargetArn *string `type:"string"`

	// The topic you want to publish to.
	//
	// If you don't specify a value for the TopicArn parameter, you must specify
	// a value for the PhoneNumber or TargetArn parameters.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s PublishInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishInput"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.MessageAttributes != nil {
		for i, v := range s.MessageAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MessageAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *PublishInput) SetMessage(v string) *PublishInput {
	s.Message = &v
	return s
}

// SetMessageAttributes sets the MessageAttributes field's value.
func (s *PublishInput) SetMessageAttributes(v map[string]*MessageAttributeValue) *PublishInput {
	s.MessageAttributes = v
	return s
}

// SetMessageStructure sets the MessageStructure field's value.
func (s *PublishInput) SetMessageStructure(v string) *PublishInput {
	s.MessageStructure = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *PublishInput) SetPhoneNumber(v string) *PublishInput {
	s.PhoneNumber = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *PublishInput) SetSubject(v string) *PublishInput {
	s.Subject = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *PublishInput) SetTargetArn(v string) *PublishInput {
	s.TargetArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *PublishInput) SetTopicArn(v string) *PublishInput {
	s.TopicArn = &v
	return s
}

// Response for Publish action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PublishResponse
type PublishOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier assigned to the published message.
	//
	// Length Constraint: Maximum 100 characters
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s PublishOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *PublishOutput) SetMessageId(v string) *PublishOutput {
	s.MessageId = &v
	return s
}

// Input for RemovePermission action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermissionInput
type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// The unique label of the statement you want to remove.
	//
	// Label is a required field
	Label *string `type:"string" required:"true"`

	// The ARN of the topic whose access control policy you wish to modify.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.Label == nil {
		invalidParams.Add(request.NewErrParamRequired("Label"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabel sets the Label field's value.
func (s *RemovePermissionInput) SetLabel(v string) *RemovePermissionInput {
	s.Label = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *RemovePermissionInput) SetTopicArn(v string) *RemovePermissionInput {
	s.TopicArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermissionOutput
type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

// Input for SetEndpointAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributesInput
type SetEndpointAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of the endpoint attributes. Attributes in this map include the following:
	//
	//    * CustomUserData -- arbitrary user data to associate with the endpoint.
	//    Amazon SNS does not use this data. The data must be in UTF-8 format and
	//    less than 2KB.
	//
	//    * Enabled -- flag that enables/disables delivery to the endpoint. Amazon
	//    SNS will set this to false when a notification service indicates to Amazon
	//    SNS that the endpoint is invalid. Users can set it back to true, typically
	//    after updating Token.
	//
	//    * Token -- device token, also referred to as a registration id, for an
	//    app and mobile device. This is returned from the notification service
	//    when an app and mobile device are registered with the notification service.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// EndpointArn used for SetEndpointAttributes action.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetEndpointAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetEndpointAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetEndpointAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetEndpointAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SetEndpointAttributesInput) SetAttributes(v map[string]*string) *SetEndpointAttributesInput {
	s.Attributes = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *SetEndpointAttributesInput) SetEndpointArn(v string) *SetEndpointAttributesInput {
	s.EndpointArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributesOutput
type SetEndpointAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetEndpointAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetEndpointAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetPlatformApplicationAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributesInput
type SetPlatformApplicationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A map of the platform application attributes. Attributes in this map include
	// the following:
	//
	//    * PlatformCredential -- The credential received from the notification
	//    service. For APNS/APNS_SANDBOX, PlatformCredential is private key. For
	//    GCM, PlatformCredential is "API key". For ADM, PlatformCredential is "client
	//    secret".
	//
	//    * PlatformPrincipal -- The principal received from the notification service.
	//    For APNS/APNS_SANDBOX, PlatformPrincipal is SSL certificate. For GCM,
	//    PlatformPrincipal is not applicable. For ADM, PlatformPrincipal is "client
	//    id".
	//
	//    * EventEndpointCreated -- Topic ARN to which EndpointCreated event notifications
	//    should be sent.
	//
	//    * EventEndpointDeleted -- Topic ARN to which EndpointDeleted event notifications
	//    should be sent.
	//
	//    * EventEndpointUpdated -- Topic ARN to which EndpointUpdate event notifications
	//    should be sent.
	//
	//    * EventDeliveryFailure -- Topic ARN to which DeliveryFailure event notifications
	//    should be sent upon Direct Publish delivery failure (permanent) to one
	//    of the application's endpoints.
	//
	//    * SuccessFeedbackRoleArn -- IAM role ARN used to give Amazon SNS write
	//    access to use CloudWatch Logs on your behalf.
	//
	//    * FailureFeedbackRoleArn -- IAM role ARN used to give Amazon SNS write
	//    access to use CloudWatch Logs on your behalf.
	//
	//    * SuccessFeedbackSampleRate -- Sample rate percentage (0-100) of successfully
	//    delivered messages.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// PlatformApplicationArn for SetPlatformApplicationAttributes action.
	//
	// PlatformApplicationArn is a required field
	PlatformApplicationArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetPlatformApplicationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPlatformApplicationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetPlatformApplicationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetPlatformApplicationAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.PlatformApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PlatformApplicationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SetPlatformApplicationAttributesInput) SetAttributes(v map[string]*string) *SetPlatformApplicationAttributesInput {
	s.Attributes = v
	return s
}

// SetPlatformApplicationArn sets the PlatformApplicationArn field's value.
func (s *SetPlatformApplicationAttributesInput) SetPlatformApplicationArn(v string) *SetPlatformApplicationAttributesInput {
	s.PlatformApplicationArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributesOutput
type SetPlatformApplicationAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetPlatformApplicationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPlatformApplicationAttributesOutput) GoString() string {
	return s.String()
}

// The input for the SetSMSAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributesInput
type SetSMSAttributesInput struct {
	_ struct{} `type:"structure"`

	// The default settings for sending SMS messages from your account. You can
	// set values for the following attribute names:
	//
	// MonthlySpendLimit – The maximum amount in USD that you are willing to spend
	// each month to send SMS messages. When Amazon SNS determines that sending
	// an SMS message would incur a cost that exceeds this limit, it stops sending
	// SMS messages within minutes.
	//
	// Amazon SNS stops sending SMS messages within minutes of the limit being crossed.
	// During that interval, if you continue to send SMS messages, you will incur
	// costs that exceed your limit.
	//
	// By default, the spend limit is set to the maximum allowed by Amazon SNS.
	// If you want to exceed the maximum, contact AWS Support (https://aws.amazon.com/premiumsupport/)
	// or your AWS sales representative for a service limit increase.
	//
	// DeliveryStatusIAMRole – The ARN of the IAM role that allows Amazon SNS to
	// write logs about SMS deliveries in CloudWatch Logs. For each SMS message
	// that you send, Amazon SNS writes a log that includes the message price, the
	// success or failure status, the reason for failure (if the message failed),
	// the message dwell time, and other information.
	//
	// DeliveryStatusSuccessSamplingRate – The percentage of successful SMS deliveries
	// for which Amazon SNS will write logs in CloudWatch Logs. The value can be
	// an integer from 0 - 100. For example, to write logs only for failed deliveries,
	// set this value to 0. To write logs for 10% of your successful deliveries,
	// set it to 10.
	//
	// DefaultSenderID – A string, such as your business brand, that is displayed
	// as the sender on the receiving device. Support for sender IDs varies by country.
	// The sender ID can be 1 - 11 alphanumeric characters, and it must contain
	// at least one letter.
	//
	// DefaultSMSType – The type of SMS message that you will send by default. You
	// can assign the following values:
	//
	//    * Promotional – (Default) Noncritical messages, such as marketing messages.
	//    Amazon SNS optimizes the message delivery to incur the lowest cost.
	//
	//    * Transactional – Critical messages that support customer transactions,
	//    such as one-time passcodes for multi-factor authentication. Amazon SNS
	//    optimizes the message delivery to achieve the highest reliability.
	//
	// UsageReportS3Bucket – The name of the Amazon S3 bucket to receive daily SMS
	// usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage
	// report as a CSV file to the bucket. The report includes the following information
	// for each SMS message that was successfully delivered by your account:
	//
	//    * Time that the message was published (in UTC)
	//
	//    * Message ID
	//
	//    * Destination phone number
	//
	//    * Message type
	//
	//    * Delivery status
	//
	//    * Message price (in USD)
	//
	//    * Part number (a message is split into multiple parts if it is too long
	//    for a single message)
	//
	//    * Total number of parts
	//
	// To receive the report, the bucket must have a policy that allows the Amazon
	// SNS service principle to perform the s3:PutObject and s3:GetBucketLocation
	// actions.
	//
	// For an example bucket policy and usage report, see Monitoring SMS Activity
	// (http://docs.aws.amazon.com/sns/latest/dg/sms_stats.html) in the Amazon SNS
	// Developer Guide.
	//
	// Attributes is a required field
	Attributes map[string]*string `locationName:"attributes" type:"map" required:"true"`
}

// String returns the string representation
func (s SetSMSAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSMSAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSMSAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSMSAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *SetSMSAttributesInput) SetAttributes(v map[string]*string) *SetSMSAttributesInput {
	s.Attributes = v
	return s
}

// The response for the SetSMSAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributesResponse
type SetSMSAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetSMSAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSMSAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetSubscriptionAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributesInput
type SetSubscriptionAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute you want to set. Only a subset of the subscriptions
	// attributes are mutable.
	//
	// Valid values: DeliveryPolicy | RawMessageDelivery
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute in JSON format.
	AttributeValue *string `type:"string"`

	// The ARN of the subscription to modify.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetSubscriptionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubscriptionAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSubscriptionAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSubscriptionAttributesInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *SetSubscriptionAttributesInput) SetAttributeName(v string) *SetSubscriptionAttributesInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *SetSubscriptionAttributesInput) SetAttributeValue(v string) *SetSubscriptionAttributesInput {
	s.AttributeValue = &v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *SetSubscriptionAttributesInput) SetSubscriptionArn(v string) *SetSubscriptionAttributesInput {
	s.SubscriptionArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributesOutput
type SetSubscriptionAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetSubscriptionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubscriptionAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetTopicAttributes action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributesInput
type SetTopicAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute you want to set. Only a subset of the topic's attributes
	// are mutable.
	//
	// Valid values: Policy | DisplayName | DeliveryPolicy
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute.
	AttributeValue *string `type:"string"`

	// The ARN of the topic to modify.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetTopicAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTopicAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTopicAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTopicAttributesInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *SetTopicAttributesInput) SetAttributeName(v string) *SetTopicAttributesInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *SetTopicAttributesInput) SetAttributeValue(v string) *SetTopicAttributesInput {
	s.AttributeValue = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *SetTopicAttributesInput) SetTopicArn(v string) *SetTopicAttributesInput {
	s.TopicArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributesOutput
type SetTopicAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTopicAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTopicAttributesOutput) GoString() string {
	return s.String()
}

// Input for Subscribe action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SubscribeInput
type SubscribeInput struct {
	_ struct{} `type:"structure"`

	// The endpoint that you want to receive notifications. Endpoints vary by protocol:
	//
	//    * For the http protocol, the endpoint is an URL beginning with "http://"
	//
	//    * For the https protocol, the endpoint is a URL beginning with "https://"
	//
	//    * For the email protocol, the endpoint is an email address
	//
	//    * For the email-json protocol, the endpoint is an email address
	//
	//    * For the sms protocol, the endpoint is a phone number of an SMS-enabled
	//    device
	//
	//    * For the sqs protocol, the endpoint is the ARN of an Amazon SQS queue
	//
	//    * For the application protocol, the endpoint is the EndpointArn of a mobile
	//    app and device.
	//
	//    * For the lambda protocol, the endpoint is the ARN of an AWS Lambda function.
	Endpoint *string `type:"string"`

	// The protocol you want to use. Supported protocols include:
	//
	//    * http -- delivery of JSON-encoded message via HTTP POST
	//
	//    * https -- delivery of JSON-encoded message via HTTPS POST
	//
	//    * email -- delivery of message via SMTP
	//
	//    * email-json -- delivery of JSON-encoded message via SMTP
	//
	//    * sms -- delivery of message via SMS
	//
	//    * sqs -- delivery of JSON-encoded message to an Amazon SQS queue
	//
	//    * application -- delivery of JSON-encoded message to an EndpointArn for
	//    a mobile app and device.
	//
	//    * lambda -- delivery of JSON-encoded message to an AWS Lambda function.
	//
	// Protocol is a required field
	Protocol *string `type:"string" required:"true"`

	// The ARN of the topic you want to subscribe to.
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeInput"}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *SubscribeInput) SetEndpoint(v string) *SubscribeInput {
	s.Endpoint = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *SubscribeInput) SetProtocol(v string) *SubscribeInput {
	s.Protocol = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *SubscribeInput) SetTopicArn(v string) *SubscribeInput {
	s.TopicArn = &v
	return s
}

// Response for Subscribe action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SubscribeResponse
type SubscribeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the subscription, if the service was able to create a subscription
	// immediately (without requiring endpoint owner confirmation).
	SubscriptionArn *string `type:"string"`
}

// String returns the string representation
func (s SubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeOutput) GoString() string {
	return s.String()
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *SubscribeOutput) SetSubscriptionArn(v string) *SubscribeOutput {
	s.SubscriptionArn = &v
	return s
}

// A wrapper type for the attributes of an Amazon SNS subscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscription
type Subscription struct {
	_ struct{} `type:"structure"`

	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`

	// The subscription's ARN.
	SubscriptionArn *string `type:"string"`

	// The ARN of the subscription's topic.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *Subscription) SetEndpoint(v string) *Subscription {
	s.Endpoint = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Subscription) SetOwner(v string) *Subscription {
	s.Owner = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Subscription) SetProtocol(v string) *Subscription {
	s.Protocol = &v
	return s
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *Subscription) SetSubscriptionArn(v string) *Subscription {
	s.SubscriptionArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *Subscription) SetTopicArn(v string) *Subscription {
	s.TopicArn = &v
	return s
}

// A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a
// topic's attributes, use GetTopicAttributes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Topic
type Topic struct {
	_ struct{} `type:"structure"`

	// The topic's ARN.
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s Topic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Topic) GoString() string {
	return s.String()
}

// SetTopicArn sets the TopicArn field's value.
func (s *Topic) SetTopicArn(v string) *Topic {
	s.TopicArn = &v
	return s
}

// Input for Unsubscribe action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/UnsubscribeInput
type UnsubscribeInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the subscription to be deleted.
	//
	// SubscriptionArn is a required field
	SubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnsubscribeInput"}
	if s.SubscriptionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionArn sets the SubscriptionArn field's value.
func (s *UnsubscribeInput) SetSubscriptionArn(v string) *UnsubscribeInput {
	s.SubscriptionArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/UnsubscribeOutput
type UnsubscribeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeOutput) GoString() string {
	return s.String()
}
