// Code generated by protoc-gen-gogo.
// source: raft.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import raftpb "github.com/coreos/etcd/raft/raftpb"

// skipping weak import gogoproto "github.com/gogo/protobuf/gogoproto"
// skipping weak import docker_protobuf_plugin "github.com/docker/swarmkit/protobuf/plugin"

import github_com_docker_swarmkit_api_deepcopy "github.com/docker/swarmkit/api/deepcopy"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftselector "github.com/docker/swarmkit/manager/raftselector"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"
import rafttime "time"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// StoreActionKind defines the operation to take on the store for the target of
// a storage action.
type StoreActionKind int32

const (
	StoreActionKindUnknown StoreActionKind = 0
	StoreActionKindCreate  StoreActionKind = 1
	StoreActionKindUpdate  StoreActionKind = 2
	StoreActionKindRemove  StoreActionKind = 3
)

var StoreActionKind_name = map[int32]string{
	0: "UNKNOWN",
	1: "STORE_ACTION_CREATE",
	2: "STORE_ACTION_UPDATE",
	3: "STORE_ACTION_REMOVE",
}
var StoreActionKind_value = map[string]int32{
	"UNKNOWN":             0,
	"STORE_ACTION_CREATE": 1,
	"STORE_ACTION_UPDATE": 2,
	"STORE_ACTION_REMOVE": 3,
}

func (x StoreActionKind) String() string {
	return proto.EnumName(StoreActionKind_name, int32(x))
}
func (StoreActionKind) EnumDescriptor() ([]byte, []int) { return fileDescriptorRaft, []int{0} }

type RaftMember struct {
	// RaftID specifies the internal ID used by the manager in a raft context, it can never be modified
	// and is used only for information purposes
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// NodeID is the node's ID.
	NodeID string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
	// Status provides the current status of the manager from the perspective of another manager.
	Status RaftMemberStatus `protobuf:"bytes,4,opt,name=status" json:"status"`
}

func (m *RaftMember) Reset()                    { *m = RaftMember{} }
func (*RaftMember) ProtoMessage()               {}
func (*RaftMember) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{0} }

type JoinRequest struct {
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *JoinRequest) Reset()                    { *m = JoinRequest{} }
func (*JoinRequest) ProtoMessage()               {}
func (*JoinRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{1} }

type JoinResponse struct {
	// RaftID is the ID assigned to the new member.
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// Members is the membership set of the cluster.
	Members []*RaftMember `protobuf:"bytes,2,rep,name=members" json:"members,omitempty"`
	// RemovedMembers is a list of members that have been removed from
	// the cluster, so the new node can avoid communicating with them.
	RemovedMembers []uint64 `protobuf:"varint,3,rep,packed,name=removed_members,json=removedMembers" json:"removed_members,omitempty"`
}

func (m *JoinResponse) Reset()                    { *m = JoinResponse{} }
func (*JoinResponse) ProtoMessage()               {}
func (*JoinResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{2} }

type LeaveRequest struct {
	Node *RaftMember `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
}

func (m *LeaveRequest) Reset()                    { *m = LeaveRequest{} }
func (*LeaveRequest) ProtoMessage()               {}
func (*LeaveRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{3} }

type LeaveResponse struct {
}

func (m *LeaveResponse) Reset()                    { *m = LeaveResponse{} }
func (*LeaveResponse) ProtoMessage()               {}
func (*LeaveResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{4} }

type ProcessRaftMessageRequest struct {
	Message *raftpb.Message `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *ProcessRaftMessageRequest) Reset()                    { *m = ProcessRaftMessageRequest{} }
func (*ProcessRaftMessageRequest) ProtoMessage()               {}
func (*ProcessRaftMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{5} }

type ProcessRaftMessageResponse struct {
}

func (m *ProcessRaftMessageResponse) Reset()                    { *m = ProcessRaftMessageResponse{} }
func (*ProcessRaftMessageResponse) ProtoMessage()               {}
func (*ProcessRaftMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{6} }

type ResolveAddressRequest struct {
	// raft_id is the ID to resolve to an address.
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
}

func (m *ResolveAddressRequest) Reset()                    { *m = ResolveAddressRequest{} }
func (*ResolveAddressRequest) ProtoMessage()               {}
func (*ResolveAddressRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{7} }

type ResolveAddressResponse struct {
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *ResolveAddressResponse) Reset()                    { *m = ResolveAddressResponse{} }
func (*ResolveAddressResponse) ProtoMessage()               {}
func (*ResolveAddressResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{8} }

// Contains one of many protobuf encoded objects to replicate
// over the raft backend with a request ID to track when the
// action is effectively applied
type InternalRaftRequest struct {
	ID     uint64         `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Action []*StoreAction `protobuf:"bytes,2,rep,name=action" json:"action,omitempty"`
}

func (m *InternalRaftRequest) Reset()                    { *m = InternalRaftRequest{} }
func (*InternalRaftRequest) ProtoMessage()               {}
func (*InternalRaftRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{9} }

// StoreAction defines a target and operation to apply on the storage system.
type StoreAction struct {
	Action StoreActionKind `protobuf:"varint,1,opt,name=action,proto3,enum=docker.swarmkit.v1.StoreActionKind" json:"action,omitempty"`
	// Types that are valid to be assigned to Target:
	//	*StoreAction_Node
	//	*StoreAction_Service
	//	*StoreAction_Task
	//	*StoreAction_Network
	//	*StoreAction_Cluster
	//	*StoreAction_Secret
	Target isStoreAction_Target `protobuf_oneof:"target"`
}

func (m *StoreAction) Reset()                    { *m = StoreAction{} }
func (*StoreAction) ProtoMessage()               {}
func (*StoreAction) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{10} }

type isStoreAction_Target interface {
	isStoreAction_Target()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StoreAction_Node struct {
	Node *Node `protobuf:"bytes,2,opt,name=node,oneof"`
}
type StoreAction_Service struct {
	Service *Service `protobuf:"bytes,3,opt,name=service,oneof"`
}
type StoreAction_Task struct {
	Task *Task `protobuf:"bytes,4,opt,name=task,oneof"`
}
type StoreAction_Network struct {
	Network *Network `protobuf:"bytes,5,opt,name=network,oneof"`
}
type StoreAction_Cluster struct {
	Cluster *Cluster `protobuf:"bytes,6,opt,name=cluster,oneof"`
}
type StoreAction_Secret struct {
	Secret *Secret `protobuf:"bytes,7,opt,name=secret,oneof"`
}

func (*StoreAction_Node) isStoreAction_Target()    {}
func (*StoreAction_Service) isStoreAction_Target() {}
func (*StoreAction_Task) isStoreAction_Target()    {}
func (*StoreAction_Network) isStoreAction_Target() {}
func (*StoreAction_Cluster) isStoreAction_Target() {}
func (*StoreAction_Secret) isStoreAction_Target()  {}

func (m *StoreAction) GetTarget() isStoreAction_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StoreAction) GetNode() *Node {
	if x, ok := m.GetTarget().(*StoreAction_Node); ok {
		return x.Node
	}
	return nil
}

func (m *StoreAction) GetService() *Service {
	if x, ok := m.GetTarget().(*StoreAction_Service); ok {
		return x.Service
	}
	return nil
}

func (m *StoreAction) GetTask() *Task {
	if x, ok := m.GetTarget().(*StoreAction_Task); ok {
		return x.Task
	}
	return nil
}

func (m *StoreAction) GetNetwork() *Network {
	if x, ok := m.GetTarget().(*StoreAction_Network); ok {
		return x.Network
	}
	return nil
}

func (m *StoreAction) GetCluster() *Cluster {
	if x, ok := m.GetTarget().(*StoreAction_Cluster); ok {
		return x.Cluster
	}
	return nil
}

func (m *StoreAction) GetSecret() *Secret {
	if x, ok := m.GetTarget().(*StoreAction_Secret); ok {
		return x.Secret
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StoreAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StoreAction_OneofMarshaler, _StoreAction_OneofUnmarshaler, _StoreAction_OneofSizer, []interface{}{
		(*StoreAction_Node)(nil),
		(*StoreAction_Service)(nil),
		(*StoreAction_Task)(nil),
		(*StoreAction_Network)(nil),
		(*StoreAction_Cluster)(nil),
		(*StoreAction_Secret)(nil),
	}
}

func _StoreAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StoreAction)
	// target
	switch x := m.Target.(type) {
	case *StoreAction_Node:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Node); err != nil {
			return err
		}
	case *StoreAction_Service:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Service); err != nil {
			return err
		}
	case *StoreAction_Task:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Task); err != nil {
			return err
		}
	case *StoreAction_Network:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Network); err != nil {
			return err
		}
	case *StoreAction_Cluster:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cluster); err != nil {
			return err
		}
	case *StoreAction_Secret:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Secret); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StoreAction.Target has unexpected type %T", x)
	}
	return nil
}

func _StoreAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StoreAction)
	switch tag {
	case 2: // target.node
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Node)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Node{msg}
		return true, err
	case 3: // target.service
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Service)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Service{msg}
		return true, err
	case 4: // target.task
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Task)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Task{msg}
		return true, err
	case 5: // target.network
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Network)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Network{msg}
		return true, err
	case 6: // target.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Cluster{msg}
		return true, err
	case 7: // target.secret
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Secret)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Secret{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StoreAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StoreAction)
	// target
	switch x := m.Target.(type) {
	case *StoreAction_Node:
		s := proto.Size(x.Node)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Service:
		s := proto.Size(x.Service)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Task:
		s := proto.Size(x.Task)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Network:
		s := proto.Size(x.Network)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Cluster:
		s := proto.Size(x.Cluster)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Secret:
		s := proto.Size(x.Secret)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*RaftMember)(nil), "docker.swarmkit.v1.RaftMember")
	proto.RegisterType((*JoinRequest)(nil), "docker.swarmkit.v1.JoinRequest")
	proto.RegisterType((*JoinResponse)(nil), "docker.swarmkit.v1.JoinResponse")
	proto.RegisterType((*LeaveRequest)(nil), "docker.swarmkit.v1.LeaveRequest")
	proto.RegisterType((*LeaveResponse)(nil), "docker.swarmkit.v1.LeaveResponse")
	proto.RegisterType((*ProcessRaftMessageRequest)(nil), "docker.swarmkit.v1.ProcessRaftMessageRequest")
	proto.RegisterType((*ProcessRaftMessageResponse)(nil), "docker.swarmkit.v1.ProcessRaftMessageResponse")
	proto.RegisterType((*ResolveAddressRequest)(nil), "docker.swarmkit.v1.ResolveAddressRequest")
	proto.RegisterType((*ResolveAddressResponse)(nil), "docker.swarmkit.v1.ResolveAddressResponse")
	proto.RegisterType((*InternalRaftRequest)(nil), "docker.swarmkit.v1.InternalRaftRequest")
	proto.RegisterType((*StoreAction)(nil), "docker.swarmkit.v1.StoreAction")
	proto.RegisterEnum("docker.swarmkit.v1.StoreActionKind", StoreActionKind_name, StoreActionKind_value)
}

type authenticatedWrapperRaftServer struct {
	local     RaftServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperRaftServer(local RaftServer, authorize func(context.Context, []string) error) RaftServer {
	return &authenticatedWrapperRaftServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperRaftServer) ProcessRaftMessage(ctx context.Context, r *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.ProcessRaftMessage(ctx, r)
}

func (p *authenticatedWrapperRaftServer) ResolveAddress(ctx context.Context, r *ResolveAddressRequest) (*ResolveAddressResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.ResolveAddress(ctx, r)
}

type authenticatedWrapperRaftMembershipServer struct {
	local     RaftMembershipServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperRaftMembershipServer(local RaftMembershipServer, authorize func(context.Context, []string) error) RaftMembershipServer {
	return &authenticatedWrapperRaftMembershipServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperRaftMembershipServer) Join(ctx context.Context, r *JoinRequest) (*JoinResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Join(ctx, r)
}

func (p *authenticatedWrapperRaftMembershipServer) Leave(ctx context.Context, r *LeaveRequest) (*LeaveResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Leave(ctx, r)
}

func (m *RaftMember) Copy() *RaftMember {
	if m == nil {
		return nil
	}
	o := &RaftMember{}
	o.CopyFrom(m)
	return o
}

func (m *RaftMember) CopyFrom(src interface{}) {

	o := src.(*RaftMember)
	*m = *o
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Status, &o.Status)
}

func (m *JoinRequest) Copy() *JoinRequest {
	if m == nil {
		return nil
	}
	o := &JoinRequest{}
	o.CopyFrom(m)
	return o
}

func (m *JoinRequest) CopyFrom(src interface{}) {

	o := src.(*JoinRequest)
	*m = *o
}

func (m *JoinResponse) Copy() *JoinResponse {
	if m == nil {
		return nil
	}
	o := &JoinResponse{}
	o.CopyFrom(m)
	return o
}

func (m *JoinResponse) CopyFrom(src interface{}) {

	o := src.(*JoinResponse)
	*m = *o
	if o.Members != nil {
		m.Members = make([]*RaftMember, len(o.Members))
		for i := range m.Members {
			m.Members[i] = &RaftMember{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Members[i], o.Members[i])
		}
	}

	if o.RemovedMembers != nil {
		m.RemovedMembers = make([]uint64, len(o.RemovedMembers))
		copy(m.RemovedMembers, o.RemovedMembers)
	}

}

func (m *LeaveRequest) Copy() *LeaveRequest {
	if m == nil {
		return nil
	}
	o := &LeaveRequest{}
	o.CopyFrom(m)
	return o
}

func (m *LeaveRequest) CopyFrom(src interface{}) {

	o := src.(*LeaveRequest)
	*m = *o
	if o.Node != nil {
		m.Node = &RaftMember{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Node, o.Node)
	}
}

func (m *LeaveResponse) Copy() *LeaveResponse {
	if m == nil {
		return nil
	}
	o := &LeaveResponse{}
	o.CopyFrom(m)
	return o
}

func (m *LeaveResponse) CopyFrom(src interface{}) {}
func (m *ProcessRaftMessageResponse) Copy() *ProcessRaftMessageResponse {
	if m == nil {
		return nil
	}
	o := &ProcessRaftMessageResponse{}
	o.CopyFrom(m)
	return o
}

func (m *ProcessRaftMessageResponse) CopyFrom(src interface{}) {}
func (m *ResolveAddressRequest) Copy() *ResolveAddressRequest {
	if m == nil {
		return nil
	}
	o := &ResolveAddressRequest{}
	o.CopyFrom(m)
	return o
}

func (m *ResolveAddressRequest) CopyFrom(src interface{}) {

	o := src.(*ResolveAddressRequest)
	*m = *o
}

func (m *ResolveAddressResponse) Copy() *ResolveAddressResponse {
	if m == nil {
		return nil
	}
	o := &ResolveAddressResponse{}
	o.CopyFrom(m)
	return o
}

func (m *ResolveAddressResponse) CopyFrom(src interface{}) {

	o := src.(*ResolveAddressResponse)
	*m = *o
}

func (m *InternalRaftRequest) Copy() *InternalRaftRequest {
	if m == nil {
		return nil
	}
	o := &InternalRaftRequest{}
	o.CopyFrom(m)
	return o
}

func (m *InternalRaftRequest) CopyFrom(src interface{}) {

	o := src.(*InternalRaftRequest)
	*m = *o
	if o.Action != nil {
		m.Action = make([]*StoreAction, len(o.Action))
		for i := range m.Action {
			m.Action[i] = &StoreAction{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Action[i], o.Action[i])
		}
	}

}

func (m *StoreAction) Copy() *StoreAction {
	if m == nil {
		return nil
	}
	o := &StoreAction{}
	o.CopyFrom(m)
	return o
}

func (m *StoreAction) CopyFrom(src interface{}) {

	o := src.(*StoreAction)
	*m = *o
	if o.Target != nil {
		switch o.Target.(type) {
		case *StoreAction_Node:
			v := StoreAction_Node{
				Node: &Node{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Node, o.GetNode())
			m.Target = &v
		case *StoreAction_Service:
			v := StoreAction_Service{
				Service: &Service{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Service, o.GetService())
			m.Target = &v
		case *StoreAction_Task:
			v := StoreAction_Task{
				Task: &Task{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Task, o.GetTask())
			m.Target = &v
		case *StoreAction_Network:
			v := StoreAction_Network{
				Network: &Network{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Network, o.GetNetwork())
			m.Target = &v
		case *StoreAction_Cluster:
			v := StoreAction_Cluster{
				Cluster: &Cluster{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Cluster, o.GetCluster())
			m.Target = &v
		case *StoreAction_Secret:
			v := StoreAction_Secret{
				Secret: &Secret{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Secret, o.GetSecret())
			m.Target = &v
		}
	}

}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Raft service

type RaftClient interface {
	// ProcessRaftMessage sends a raft message to be processed on a raft member, it is
	// called from the RaftMember willing to send a message to its destination ('To' field)
	ProcessRaftMessage(ctx context.Context, in *ProcessRaftMessageRequest, opts ...grpc.CallOption) (*ProcessRaftMessageResponse, error)
	// ResolveAddress returns the address where the node with the given ID can be reached.
	ResolveAddress(ctx context.Context, in *ResolveAddressRequest, opts ...grpc.CallOption) (*ResolveAddressResponse, error)
}

type raftClient struct {
	cc *grpc.ClientConn
}

func NewRaftClient(cc *grpc.ClientConn) RaftClient {
	return &raftClient{cc}
}

func (c *raftClient) ProcessRaftMessage(ctx context.Context, in *ProcessRaftMessageRequest, opts ...grpc.CallOption) (*ProcessRaftMessageResponse, error) {
	out := new(ProcessRaftMessageResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Raft/ProcessRaftMessage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *raftClient) ResolveAddress(ctx context.Context, in *ResolveAddressRequest, opts ...grpc.CallOption) (*ResolveAddressResponse, error) {
	out := new(ResolveAddressResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Raft/ResolveAddress", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Raft service

type RaftServer interface {
	// ProcessRaftMessage sends a raft message to be processed on a raft member, it is
	// called from the RaftMember willing to send a message to its destination ('To' field)
	ProcessRaftMessage(context.Context, *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error)
	// ResolveAddress returns the address where the node with the given ID can be reached.
	ResolveAddress(context.Context, *ResolveAddressRequest) (*ResolveAddressResponse, error)
}

func RegisterRaftServer(s *grpc.Server, srv RaftServer) {
	s.RegisterService(&_Raft_serviceDesc, srv)
}

func _Raft_ProcessRaftMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRaftMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServer).ProcessRaftMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Raft/ProcessRaftMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServer).ProcessRaftMessage(ctx, req.(*ProcessRaftMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Raft_ResolveAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServer).ResolveAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Raft/ResolveAddress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServer).ResolveAddress(ctx, req.(*ResolveAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Raft_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Raft",
	HandlerType: (*RaftServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessRaftMessage",
			Handler:    _Raft_ProcessRaftMessage_Handler,
		},
		{
			MethodName: "ResolveAddress",
			Handler:    _Raft_ResolveAddress_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "raft.proto",
}

// Client API for RaftMembership service

type RaftMembershipClient interface {
	// Join adds a RaftMember to the raft cluster.
	Join(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error)
	// Leave removes a RaftMember from the raft cluster.
	Leave(ctx context.Context, in *LeaveRequest, opts ...grpc.CallOption) (*LeaveResponse, error)
}

type raftMembershipClient struct {
	cc *grpc.ClientConn
}

func NewRaftMembershipClient(cc *grpc.ClientConn) RaftMembershipClient {
	return &raftMembershipClient{cc}
}

func (c *raftMembershipClient) Join(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error) {
	out := new(JoinResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.RaftMembership/Join", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *raftMembershipClient) Leave(ctx context.Context, in *LeaveRequest, opts ...grpc.CallOption) (*LeaveResponse, error) {
	out := new(LeaveResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.RaftMembership/Leave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RaftMembership service

type RaftMembershipServer interface {
	// Join adds a RaftMember to the raft cluster.
	Join(context.Context, *JoinRequest) (*JoinResponse, error)
	// Leave removes a RaftMember from the raft cluster.
	Leave(context.Context, *LeaveRequest) (*LeaveResponse, error)
}

func RegisterRaftMembershipServer(s *grpc.Server, srv RaftMembershipServer) {
	s.RegisterService(&_RaftMembership_serviceDesc, srv)
}

func _RaftMembership_Join_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftMembershipServer).Join(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.RaftMembership/Join",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftMembershipServer).Join(ctx, req.(*JoinRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RaftMembership_Leave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LeaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftMembershipServer).Leave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.RaftMembership/Leave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftMembershipServer).Leave(ctx, req.(*LeaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RaftMembership_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.RaftMembership",
	HandlerType: (*RaftMembershipServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Join",
			Handler:    _RaftMembership_Join_Handler,
		},
		{
			MethodName: "Leave",
			Handler:    _RaftMembership_Leave_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "raft.proto",
}

func (m *RaftMember) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMember) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.RaftID))
	}
	if len(m.NodeID) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if len(m.Addr) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Status.Size()))
	n1, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *JoinRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	return i, nil
}

func (m *JoinResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.RaftID))
	}
	if len(m.Members) > 0 {
		for _, msg := range m.Members {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRaft(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RemovedMembers) > 0 {
		dAtA3 := make([]byte, len(m.RemovedMembers)*10)
		var j2 int
		for _, num := range m.RemovedMembers {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRaft(dAtA, i, uint64(j2))
		i += copy(dAtA[i:], dAtA3[:j2])
	}
	return i, nil
}

func (m *LeaveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaveRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Node.Size()))
		n4, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *LeaveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaveResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ProcessRaftMessageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessRaftMessageRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Message != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Message.Size()))
		n5, err := m.Message.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *ProcessRaftMessageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessRaftMessageResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResolveAddressRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveAddressRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.RaftID))
	}
	return i, nil
}

func (m *ResolveAddressResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveAddressResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.Addr)))
		i += copy(dAtA[i:], m.Addr)
	}
	return i, nil
}

func (m *InternalRaftRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InternalRaftRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.ID))
	}
	if len(m.Action) > 0 {
		for _, msg := range m.Action {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRaft(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *StoreAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Action != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Action))
	}
	if m.Target != nil {
		nn6, err := m.Target.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	return i, nil
}

func (m *StoreAction_Node) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Node != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Node.Size()))
		n7, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *StoreAction_Service) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Service != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Service.Size()))
		n8, err := m.Service.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *StoreAction_Task) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Task != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Task.Size()))
		n9, err := m.Task.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *StoreAction_Network) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Network != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Network.Size()))
		n10, err := m.Network.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *StoreAction_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Cluster != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Cluster.Size()))
		n11, err := m.Cluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *StoreAction_Secret) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Secret != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Secret.Size()))
		n12, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func encodeFixed64Raft(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Raft(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintRaft(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}

type raftProxyRaftServer struct {
	local                       RaftServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyRaftServer(local RaftServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) RaftServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyRaftServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyRaftServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyRaftServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyRaftServer) ProcessRaftMessage(ctx context.Context, r *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.ProcessRaftMessage(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftClient(conn).ProcessRaftMessage(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.ProcessRaftMessage(ctx, r)
			}
			return nil, err
		}
		return NewRaftClient(conn).ProcessRaftMessage(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyRaftServer) ResolveAddress(ctx context.Context, r *ResolveAddressRequest) (*ResolveAddressResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.ResolveAddress(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftClient(conn).ResolveAddress(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.ResolveAddress(ctx, r)
			}
			return nil, err
		}
		return NewRaftClient(conn).ResolveAddress(modCtx, r)
	}
	return resp, err
}

type raftProxyRaftMembershipServer struct {
	local                       RaftMembershipServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyRaftMembershipServer(local RaftMembershipServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) RaftMembershipServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyRaftMembershipServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyRaftMembershipServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyRaftMembershipServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyRaftMembershipServer) Join(ctx context.Context, r *JoinRequest) (*JoinResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.Join(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftMembershipClient(conn).Join(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Join(ctx, r)
			}
			return nil, err
		}
		return NewRaftMembershipClient(conn).Join(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyRaftMembershipServer) Leave(ctx context.Context, r *LeaveRequest) (*LeaveResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.Leave(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftMembershipClient(conn).Leave(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Leave(ctx, r)
			}
			return nil, err
		}
		return NewRaftMembershipClient(conn).Leave(modCtx, r)
	}
	return resp, err
}

func (m *RaftMember) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovRaft(uint64(l))
	return n
}

func (m *JoinRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *JoinResponse) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	if len(m.Members) > 0 {
		for _, e := range m.Members {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	if len(m.RemovedMembers) > 0 {
		l = 0
		for _, e := range m.RemovedMembers {
			l += sovRaft(uint64(e))
		}
		n += 1 + sovRaft(uint64(l)) + l
	}
	return n
}

func (m *LeaveRequest) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *LeaveResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ProcessRaftMessageRequest) Size() (n int) {
	var l int
	_ = l
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *ProcessRaftMessageResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResolveAddressRequest) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	return n
}

func (m *ResolveAddressResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *InternalRaftRequest) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovRaft(uint64(m.ID))
	}
	if len(m.Action) > 0 {
		for _, e := range m.Action {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	return n
}

func (m *StoreAction) Size() (n int) {
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovRaft(uint64(m.Action))
	}
	if m.Target != nil {
		n += m.Target.Size()
	}
	return n
}

func (m *StoreAction_Node) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Service) Size() (n int) {
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Task) Size() (n int) {
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Network) Size() (n int) {
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Cluster) Size() (n int) {
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Secret) Size() (n int) {
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func sovRaft(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRaft(x uint64) (n int) {
	return sovRaft(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RaftMember) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftMember{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "RaftMemberStatus", "RaftMemberStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinRequest{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinResponse{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`Members:` + strings.Replace(fmt.Sprintf("%v", this.Members), "RaftMember", "RaftMember", 1) + `,`,
		`RemovedMembers:` + fmt.Sprintf("%v", this.RemovedMembers) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LeaveRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LeaveRequest{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "RaftMember", "RaftMember", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LeaveResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LeaveResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ProcessRaftMessageRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessRaftMessageRequest{`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Message", "raftpb.Message", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessRaftMessageResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessRaftMessageResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResolveAddressRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResolveAddressRequest{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResolveAddressResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResolveAddressResponse{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InternalRaftRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InternalRaftRequest{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "StoreAction", "StoreAction", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction{`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Node) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Node{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Service) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Service{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Task{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Network) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Network{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Cluster) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Cluster{`,
		`Cluster:` + strings.Replace(fmt.Sprintf("%v", this.Cluster), "Cluster", "Cluster", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Secret{`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "Secret", "Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRaft(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *RaftMember) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMember: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMember: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Members = append(m.Members, &RaftMember{})
			if err := m.Members[len(m.Members)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRaft
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRaft
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRaft
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RemovedMembers = append(m.RemovedMembers, v)
				}
			} else if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRaft
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RemovedMembers = append(m.RemovedMembers, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovedMembers", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &RaftMember{}
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessRaftMessageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessRaftMessageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessRaftMessageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &raftpb.Message{}
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessRaftMessageResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessRaftMessageResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessRaftMessageResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveAddressRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveAddressRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveAddressRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveAddressResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveAddressResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveAddressResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InternalRaftRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalRaftRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalRaftRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Action = append(m.Action, &StoreAction{})
			if err := m.Action[len(m.Action)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= (StoreActionKind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Node{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Node{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Service{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Service{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Task{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Task{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Network{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Network{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Cluster{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Secret{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Secret{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRaft(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRaft
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRaft
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRaft(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRaft = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRaft   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("raft.proto", fileDescriptorRaft) }

var fileDescriptorRaft = []byte{
	// 885 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x95, 0xcf, 0x73, 0xdb, 0x44,
	0x14, 0xc7, 0x2d, 0x59, 0x95, 0xe1, 0xb9, 0x89, 0x33, 0x1b, 0x12, 0x54, 0xc1, 0x28, 0xaa, 0xca,
	0x4c, 0xdd, 0x0e, 0x91, 0x07, 0xc1, 0x4c, 0x19, 0xe0, 0x12, 0x27, 0x9e, 0x89, 0x69, 0xeb, 0x74,
	0x94, 0x04, 0x7a, 0x0b, 0xb2, 0xb4, 0x71, 0x85, 0x63, 0xad, 0xd9, 0x5d, 0x3b, 0xc3, 0x85, 0xe9,
	0x91, 0xc9, 0x95, 0xe1, 0xc7, 0xa5, 0x27, 0x38, 0xf7, 0x0f, 0xe0, 0x2f, 0xc8, 0x70, 0xe2, 0x06,
	0xa7, 0x0c, 0xf5, 0x1f, 0x00, 0xff, 0x02, 0xb3, 0x2b, 0x29, 0x49, 0x1d, 0xc5, 0xc9, 0x25, 0x59,
	0xaf, 0x3e, 0xdf, 0xf7, 0xdd, 0xf7, 0x56, 0xef, 0x09, 0x80, 0x06, 0xfb, 0xdc, 0x1d, 0x52, 0xc2,
	0x09, 0x42, 0x11, 0x09, 0xfb, 0x98, 0xba, 0xec, 0x30, 0xa0, 0x83, 0x7e, 0xcc, 0xdd, 0xf1, 0x07,
	0xe6, 0x1c, 0xe9, 0x7e, 0x8d, 0x43, 0xce, 0x52, 0xc4, 0xac, 0xf2, 0x6f, 0x87, 0x38, 0xff, 0xb1,
	0xda, 0x8b, 0xf9, 0xb3, 0x51, 0xd7, 0x0d, 0xc9, 0xa0, 0x11, 0x12, 0x8a, 0x09, 0x6b, 0x60, 0x1e,
	0x46, 0x0d, 0x11, 0x52, 0xfe, 0x19, 0x76, 0x1b, 0x67, 0xe1, 0xcd, 0xb7, 0x7a, 0xa4, 0x47, 0xe4,
	0xb2, 0x21, 0x56, 0xd9, 0xee, 0xe2, 0xf0, 0x60, 0xd4, 0x8b, 0x93, 0x46, 0xfa, 0x2f, 0xdd, 0x74,
	0x5e, 0x2a, 0x00, 0x7e, 0xb0, 0xcf, 0x1f, 0xe3, 0x41, 0x17, 0x53, 0x74, 0x07, 0x2a, 0x22, 0xce,
	0x5e, 0x1c, 0x19, 0x8a, 0xad, 0xd4, 0xb5, 0x26, 0x4c, 0x4e, 0x56, 0x74, 0x01, 0xb4, 0x37, 0x7c,
	0x5d, 0x3c, 0x6a, 0x47, 0x02, 0x4a, 0x48, 0x84, 0x05, 0xa4, 0xda, 0x4a, 0xfd, 0xcd, 0x14, 0xea,
	0x90, 0x08, 0x0b, 0x48, 0x3c, 0x6a, 0x47, 0x08, 0x81, 0x16, 0x44, 0x11, 0x35, 0xca, 0x82, 0xf0,
	0xe5, 0x1a, 0x35, 0x41, 0x67, 0x3c, 0xe0, 0x23, 0x66, 0x68, 0xb6, 0x52, 0xaf, 0x7a, 0xef, 0xb9,
	0x17, 0xeb, 0xe0, 0x9e, 0x9d, 0x66, 0x5b, 0xb2, 0x4d, 0xed, 0xf8, 0x64, 0xa5, 0xe4, 0x67, 0x4a,
	0xe7, 0x36, 0x54, 0x3f, 0x27, 0x71, 0xe2, 0xe3, 0x6f, 0x46, 0x98, 0xf1, 0x53, 0x1b, 0xe5, 0xcc,
	0xc6, 0xf9, 0x49, 0x81, 0x9b, 0x29, 0xc3, 0x86, 0x24, 0x61, 0xf8, 0x7a, 0x59, 0x7d, 0x0c, 0x95,
	0x81, 0xb4, 0x65, 0x86, 0x6a, 0x97, 0xeb, 0x55, 0xcf, 0x9a, 0x7d, 0x3a, 0x3f, 0xc7, 0xd1, 0x5d,
	0xa8, 0x51, 0x3c, 0x20, 0x63, 0x1c, 0xed, 0xe5, 0x11, 0xca, 0x76, 0xb9, 0xae, 0xf9, 0xf3, 0xd9,
	0x76, 0x2a, 0x60, 0x4e, 0x13, 0x6e, 0x3e, 0xc2, 0xc1, 0x18, 0xe7, 0x87, 0xf7, 0x40, 0x13, 0xd5,
	0x92, 0x87, 0xba, 0xda, 0x4f, 0xb2, 0x4e, 0x0d, 0xe6, 0xb2, 0x18, 0x69, 0x72, 0xce, 0x23, 0xb8,
	0xf5, 0x84, 0x92, 0x10, 0x33, 0x96, 0xb2, 0x8c, 0x05, 0xbd, 0x53, 0x87, 0x7b, 0x22, 0x29, 0xb9,
	0x93, 0x99, 0xd4, 0xdc, 0xf4, 0x75, 0x71, 0x73, 0x30, 0x7f, 0xfe, 0x89, 0xf6, 0xfc, 0x67, 0xa7,
	0xe4, 0xbc, 0x0b, 0x66, 0x51, 0xb4, 0xcc, 0xeb, 0x33, 0x58, 0xf2, 0x31, 0x23, 0x07, 0x63, 0xbc,
	0x16, 0x45, 0x54, 0x40, 0x99, 0xcf, 0x75, 0x2a, 0xec, 0xbc, 0x0f, 0xcb, 0xd3, 0xea, 0xec, 0x82,
	0x8a, 0x6e, 0x71, 0x1f, 0x16, 0xdb, 0x09, 0xc7, 0x34, 0x09, 0x0e, 0x44, 0x9c, 0xdc, 0x69, 0x19,
	0xd4, 0x53, 0x13, 0x7d, 0x72, 0xb2, 0xa2, 0xb6, 0x37, 0x7c, 0x35, 0x8e, 0xd0, 0x03, 0xd0, 0x83,
	0x90, 0xc7, 0x24, 0xc9, 0x6e, 0x6f, 0xa5, 0xa8, 0x9a, 0xdb, 0x9c, 0x50, 0xbc, 0x26, 0x31, 0x3f,
	0xc3, 0x9d, 0x1f, 0xcb, 0x50, 0x3d, 0xb7, 0x8f, 0x3e, 0x3d, 0x0d, 0x24, 0x4c, 0xe6, 0xbd, 0x3b,
	0x57, 0x04, 0x7a, 0x18, 0x27, 0x51, 0x1e, 0x0c, 0xb9, 0xd9, 0x8d, 0xaa, 0xb2, 0xd8, 0x46, 0x91,
	0x54, 0xf4, 0xc9, 0x66, 0x29, 0xbd, 0x4d, 0xf4, 0x00, 0x2a, 0x0c, 0xd3, 0x71, 0x1c, 0x62, 0xd9,
	0x28, 0x55, 0xef, 0x9d, 0x42, 0xb7, 0x14, 0xd9, 0x2c, 0xf9, 0x39, 0x2d, 0x8c, 0x78, 0xc0, 0xfa,
	0x59, 0x23, 0x15, 0x1a, 0xed, 0x04, 0xac, 0x2f, 0x8c, 0x04, 0x27, 0x8c, 0x12, 0xcc, 0x0f, 0x09,
	0xed, 0x1b, 0x37, 0x2e, 0x37, 0xea, 0xa4, 0x88, 0x30, 0xca, 0x68, 0x21, 0x0c, 0x0f, 0x46, 0x8c,
	0x63, 0x6a, 0xe8, 0x97, 0x0b, 0xd7, 0x53, 0x44, 0x08, 0x33, 0x1a, 0x7d, 0x04, 0x3a, 0xc3, 0x21,
	0xc5, 0xdc, 0xa8, 0x48, 0x9d, 0x59, 0x9c, 0x99, 0x20, 0x36, 0x45, 0x7b, 0xcb, 0x55, 0xf3, 0x0d,
	0xd0, 0x79, 0x40, 0x7b, 0x98, 0xdf, 0xff, 0x4f, 0x81, 0xda, 0x54, 0x99, 0xd1, 0x5d, 0xa8, 0xec,
	0x76, 0x1e, 0x76, 0xb6, 0xbe, 0xec, 0x2c, 0x94, 0x4c, 0xf3, 0xe8, 0x85, 0xbd, 0x3c, 0x45, 0xec,
	0x26, 0xfd, 0x84, 0x1c, 0x26, 0xc8, 0x83, 0xc5, 0xed, 0x9d, 0x2d, 0xbf, 0xb5, 0xb7, 0xb6, 0xbe,
	0xd3, 0xde, 0xea, 0xec, 0xad, 0xfb, 0xad, 0xb5, 0x9d, 0xd6, 0x82, 0x62, 0xde, 0x3a, 0x7a, 0x61,
	0x2f, 0x4d, 0x89, 0xd6, 0x29, 0x0e, 0x38, 0xbe, 0xa0, 0xd9, 0x7d, 0xb2, 0x21, 0x34, 0x6a, 0xa1,
	0x66, 0x77, 0x18, 0x15, 0x69, 0xfc, 0xd6, 0xe3, 0xad, 0x2f, 0x5a, 0x0b, 0xe5, 0x42, 0x8d, 0x2f,
	0xa7, 0x81, 0xf9, 0xf6, 0xf7, 0xbf, 0x5a, 0xa5, 0xdf, 0x7f, 0xb3, 0xa6, 0xb3, 0xf3, 0x7e, 0x50,
	0x41, 0x13, 0xaf, 0x3a, 0x3a, 0x52, 0x00, 0x5d, 0xec, 0x42, 0xb4, 0x5a, 0x54, 0xc1, 0x4b, 0x7b,
	0xdf, 0x74, 0xaf, 0x8b, 0x67, 0xcd, 0xbd, 0xf4, 0xc7, 0xcb, 0x7f, 0x7f, 0x51, 0x6b, 0x30, 0x27,
	0xf9, 0xd5, 0x41, 0x90, 0x04, 0x3d, 0x4c, 0xd1, 0x77, 0x30, 0xff, 0x7a, 0xd7, 0xa2, 0x7b, 0x85,
	0x83, 0xaa, 0x68, 0x2e, 0x98, 0xf7, 0xaf, 0x83, 0xce, 0xf4, 0xf7, 0xfe, 0x52, 0x60, 0xfe, 0x6c,
	0x0a, 0xb2, 0x67, 0xf1, 0x10, 0x7d, 0x05, 0x9a, 0x98, 0xef, 0xa8, 0xb0, 0xc7, 0xcf, 0x7d, 0x1d,
	0x4c, 0xfb, 0x72, 0x60, 0x76, 0xd2, 0x21, 0xdc, 0x90, 0x53, 0x16, 0x15, 0x46, 0x38, 0x3f, 0xc4,
	0xcd, 0xdb, 0x33, 0x88, 0x99, 0x26, 0x4d, 0xe3, 0xf8, 0x95, 0x55, 0xfa, 0xfb, 0x95, 0x55, 0x7a,
	0x3e, 0xb1, 0x94, 0xe3, 0x89, 0xa5, 0xfc, 0x39, 0xb1, 0x94, 0x7f, 0x26, 0x96, 0xf2, 0xb4, 0xfc,
	0x54, 0xeb, 0xea, 0xf2, 0x03, 0xfd, 0xe1, 0xff, 0x01, 0x00, 0x00, 0xff, 0xff, 0xbc, 0x5a, 0xbd,
	0x08, 0x38, 0x08, 0x00, 0x00,
}
