// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package s3 provides a client for Amazon Simple Storage Service.
package s3

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AbortMultipartUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AbortMultipartUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AbortMultipartUploadRequest method.
//    req, resp := client.AbortMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AbortMultipartUploadOutput{}
	req.Data = output
	return
}

// AbortMultipartUpload API operation for Amazon Simple Storage Service.
//
// Aborts a multipart upload.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the List Parts operation and ensure the
// parts list is empty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation AbortMultipartUpload for usage and error information.
//
// Returned Error Codes:
//   * NoSuchUpload
//   The specified multipart upload does not exist.
//
func (c *S3) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CompleteMultipartUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CompleteMultipartUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CompleteMultipartUploadRequest method.
//    req, resp := client.CompleteMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *CompleteMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteMultipartUploadOutput{}
	req.Data = output
	return
}

// CompleteMultipartUpload API operation for Amazon Simple Storage Service.
//
// Completes a multipart upload by assembling previously uploaded parts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CompleteMultipartUpload for usage and error information.
func (c *S3) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCopyObject = "CopyObject"

// CopyObjectRequest generates a "aws/request.Request" representing the
// client's request for the CopyObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CopyObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CopyObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CopyObjectRequest method.
//    req, resp := client.CopyObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) CopyObjectRequest(input *CopyObjectInput) (req *request.Request, output *CopyObjectOutput) {
	op := &request.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CopyObjectOutput{}
	req.Data = output
	return
}

// CopyObject API operation for Amazon Simple Storage Service.
//
// Creates a copy of an object that is already stored in Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CopyObject for usage and error information.
//
// Returned Error Codes:
//   * ObjectNotInActiveTierError
//   The source object of the COPY operation is not in the active tier and is
//   only stored in Amazon Glacier.
//
func (c *S3) CopyObject(input *CopyObjectInput) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	err := req.Send()
	return out, err
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateBucket for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateBucket method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateBucketRequest method.
//    req, resp := client.CreateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateBucketOutput{}
	req.Data = output
	return
}

// CreateBucket API operation for Amazon Simple Storage Service.
//
// Creates a new bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//   * BucketAlreadyExists
//   The requested bucket name is not available. The bucket namespace is shared
//   by all users of the system. Please select a different name and try again.
//
//   * BucketAlreadyOwnedByYou

//
func (c *S3) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	err := req.Send()
	return out, err
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultipartUpload operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateMultipartUpload for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateMultipartUpload method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateMultipartUploadRequest method.
//    req, resp := client.CreateMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) (req *request.Request, output *CreateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateMultipartUploadOutput{}
	req.Data = output
	return
}

// CreateMultipartUpload API operation for Amazon Simple Storage Service.
//
// Initiates a multipart upload and returns an upload ID.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateMultipartUpload for usage and error information.
func (c *S3) CreateMultipartUpload(input *CreateMultipartUploadInput) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucket for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucket method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req, resp := client.DeleteBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketOutput{}
	req.Data = output
	return
}

// DeleteBucket API operation for Amazon Simple Storage Service.
//
// Deletes the bucket. All objects (including all object versions and Delete
// Markers) in the bucket must be deleted before the bucket itself can be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucket for usage and error information.
func (c *S3) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketCors operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketCors for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketCors method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketCorsRequest method.
//    req, resp := client.DeleteBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) (req *request.Request, output *DeleteBucketCorsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketCorsOutput{}
	req.Data = output
	return
}

// DeleteBucketCors API operation for Amazon Simple Storage Service.
//
// Deletes the cors configuration information set for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketCors for usage and error information.
func (c *S3) DeleteBucketCors(input *DeleteBucketCorsInput) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycle operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketLifecycle for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketLifecycle method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketLifecycleRequest method.
//    req, resp := client.DeleteBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) (req *request.Request, output *DeleteBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketLifecycleOutput{}
	req.Data = output
	return
}

// DeleteBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketLifecycle for usage and error information.
func (c *S3) DeleteBucketLifecycle(input *DeleteBucketLifecycleInput) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketPolicyRequest method.
//    req, resp := client.DeleteBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketPolicyOutput{}
	req.Data = output
	return
}

// DeleteBucketPolicy API operation for Amazon Simple Storage Service.
//
// Deletes the policy from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketPolicy for usage and error information.
func (c *S3) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketReplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketReplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketReplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketReplicationRequest method.
//    req, resp := client.DeleteBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) (req *request.Request, output *DeleteBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketReplicationOutput{}
	req.Data = output
	return
}

// DeleteBucketReplication API operation for Amazon Simple Storage Service.
//
// Deletes the replication configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketReplication for usage and error information.
func (c *S3) DeleteBucketReplication(input *DeleteBucketReplicationInput) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketTagging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketTagging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketTagging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketTaggingRequest method.
//    req, resp := client.DeleteBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketTaggingOutput{}
	req.Data = output
	return
}

// DeleteBucketTagging API operation for Amazon Simple Storage Service.
//
// Deletes the tags from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketTagging for usage and error information.
func (c *S3) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketWebsite operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBucketWebsite for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBucketWebsite method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBucketWebsiteRequest method.
//    req, resp := client.DeleteBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) (req *request.Request, output *DeleteBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteBucketWebsiteOutput{}
	req.Data = output
	return
}

// DeleteBucketWebsite API operation for Amazon Simple Storage Service.
//
// This operation removes the website configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketWebsite for usage and error information.
func (c *S3) DeleteBucketWebsite(input *DeleteBucketWebsiteInput) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteObjectRequest method.
//    req, resp := client.DeleteObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteObjectOutput{}
	req.Data = output
	return
}

// DeleteObject API operation for Amazon Simple Storage Service.
//
// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObject for usage and error information.
func (c *S3) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteObjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteObjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteObjectsRequest method.
//    req, resp := client.DeleteObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) (req *request.Request, output *DeleteObjectsOutput) {
	op := &request.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteObjectsOutput{}
	req.Data = output
	return
}

// DeleteObjects API operation for Amazon Simple Storage Service.
//
// This operation enables you to delete multiple objects from a bucket using
// a single HTTP request. You may specify up to 1000 keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjects for usage and error information.
func (c *S3) DeleteObjects(input *DeleteObjectsInput) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketAccelerateConfiguration = "GetBucketAccelerateConfiguration"

// GetBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAccelerateConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketAccelerateConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketAccelerateConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketAccelerateConfigurationRequest method.
//    req, resp := client.GetBucketAccelerateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketAccelerateConfigurationRequest(input *GetBucketAccelerateConfigurationInput) (req *request.Request, output *GetBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketAccelerateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &GetBucketAccelerateConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketAccelerateConfigurationOutput{}
	req.Data = output
	return
}

// GetBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the accelerate configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAccelerateConfiguration for usage and error information.
func (c *S3) GetBucketAccelerateConfiguration(input *GetBucketAccelerateConfigurationInput) (*GetBucketAccelerateConfigurationOutput, error) {
	req, out := c.GetBucketAccelerateConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketAclRequest method.
//    req, resp := client.GetBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) (req *request.Request, output *GetBucketAclOutput) {
	op := &request.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketAclOutput{}
	req.Data = output
	return
}

// GetBucketAcl API operation for Amazon Simple Storage Service.
//
// Gets the access control policy for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAcl for usage and error information.
func (c *S3) GetBucketAcl(input *GetBucketAclInput) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketCors operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketCors for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketCors method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketCorsRequest method.
//    req, resp := client.GetBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) (req *request.Request, output *GetBucketCorsOutput) {
	op := &request.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketCorsOutput{}
	req.Data = output
	return
}

// GetBucketCors API operation for Amazon Simple Storage Service.
//
// Returns the cors configuration for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketCors for usage and error information.
func (c *S3) GetBucketCors(input *GetBucketCorsInput) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLifecycle = "GetBucketLifecycle"

// GetBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycle operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketLifecycle for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketLifecycle method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketLifecycleRequest method.
//    req, resp := client.GetBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketLifecycleRequest(input *GetBucketLifecycleInput) (req *request.Request, output *GetBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketLifecycle,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLifecycleOutput{}
	req.Data = output
	return
}

// GetBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketLifecycleConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycle for usage and error information.
func (c *S3) GetBucketLifecycle(input *GetBucketLifecycleInput) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketLifecycleConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketLifecycleConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//    req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLifecycleConfigurationOutput{}
	req.Data = output
	return
}

// GetBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the lifecycle configuration information set on the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycleConfiguration for usage and error information.
func (c *S3) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLocation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketLocation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketLocation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketLocationRequest method.
//    req, resp := client.GetBucketLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) (req *request.Request, output *GetBucketLocationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLocationOutput{}
	req.Data = output
	return
}

// GetBucketLocation API operation for Amazon Simple Storage Service.
//
// Returns the region the bucket resides in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLocation for usage and error information.
func (c *S3) GetBucketLocation(input *GetBucketLocationInput) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLogging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketLogging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketLogging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketLoggingRequest method.
//    req, resp := client.GetBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) (req *request.Request, output *GetBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketLoggingOutput{}
	req.Data = output
	return
}

// GetBucketLogging API operation for Amazon Simple Storage Service.
//
// Returns the logging status of a bucket and the permissions users have to
// view and modify that status. To use GET, you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLogging for usage and error information.
func (c *S3) GetBucketLogging(input *GetBucketLoggingInput) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketNotification = "GetBucketNotification"

// GetBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotification operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketNotification for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketNotification method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketNotificationRequest method.
//    req, resp := client.GetBucketNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketNotificationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfigurationDeprecated) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketNotification,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	req = c.newRequest(op, input, output)
	output = &NotificationConfigurationDeprecated{}
	req.Data = output
	return
}

// GetBucketNotification API operation for Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketNotificationConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotification for usage and error information.
func (c *S3) GetBucketNotification(input *GetBucketNotificationConfigurationRequest) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketNotificationConfiguration = "GetBucketNotificationConfiguration"

// GetBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotificationConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketNotificationConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketNotificationConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketNotificationConfigurationRequest method.
//    req, resp := client.GetBucketNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketNotificationConfigurationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfiguration) {
	op := &request.Operation{
		Name:       opGetBucketNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	req = c.newRequest(op, input, output)
	output = &NotificationConfiguration{}
	req.Data = output
	return
}

// GetBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the notification configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotificationConfiguration for usage and error information.
func (c *S3) GetBucketNotificationConfiguration(input *GetBucketNotificationConfigurationRequest) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketPolicyRequest method.
//    req, resp := client.GetBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketPolicyOutput{}
	req.Data = output
	return
}

// GetBucketPolicy API operation for Amazon Simple Storage Service.
//
// Returns the policy of a specified bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketPolicy for usage and error information.
func (c *S3) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketReplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketReplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketReplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketReplicationRequest method.
//    req, resp := client.GetBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketReplicationRequest(input *GetBucketReplicationInput) (req *request.Request, output *GetBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketReplicationOutput{}
	req.Data = output
	return
}

// GetBucketReplication API operation for Amazon Simple Storage Service.
//
// Returns the replication configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketReplication for usage and error information.
func (c *S3) GetBucketReplication(input *GetBucketReplicationInput) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketRequestPayment = "GetBucketRequestPayment"

// GetBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketRequestPayment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketRequestPayment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketRequestPayment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketRequestPaymentRequest method.
//    req, resp := client.GetBucketRequestPaymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketRequestPaymentRequest(input *GetBucketRequestPaymentInput) (req *request.Request, output *GetBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opGetBucketRequestPayment,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &GetBucketRequestPaymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketRequestPaymentOutput{}
	req.Data = output
	return
}

// GetBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Returns the request payment configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketRequestPayment for usage and error information.
func (c *S3) GetBucketRequestPayment(input *GetBucketRequestPaymentInput) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketTagging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketTagging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketTagging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketTaggingRequest method.
//    req, resp := client.GetBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketTaggingOutput{}
	req.Data = output
	return
}

// GetBucketTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag set associated with the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketTagging for usage and error information.
func (c *S3) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketVersioning operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketVersioning for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketVersioning method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketVersioningRequest method.
//    req, resp := client.GetBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketVersioningOutput{}
	req.Data = output
	return
}

// GetBucketVersioning API operation for Amazon Simple Storage Service.
//
// Returns the versioning state of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketVersioning for usage and error information.
func (c *S3) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	err := req.Send()
	return out, err
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketWebsite operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBucketWebsite for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBucketWebsite method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBucketWebsiteRequest method.
//    req, resp := client.GetBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) (req *request.Request, output *GetBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBucketWebsiteOutput{}
	req.Data = output
	return
}

// GetBucketWebsite API operation for Amazon Simple Storage Service.
//
// Returns the website configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketWebsite for usage and error information.
func (c *S3) GetBucketWebsite(input *GetBucketWebsiteInput) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opGetObject = "GetObject"

// GetObjectRequest generates a "aws/request.Request" representing the
// client's request for the GetObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetObjectRequest method.
//    req, resp := client.GetObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetObjectRequest(input *GetObjectInput) (req *request.Request, output *GetObjectOutput) {
	op := &request.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectOutput{}
	req.Data = output
	return
}

// GetObject API operation for Amazon Simple Storage Service.
//
// Retrieves objects from Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObject for usage and error information.
//
// Returned Error Codes:
//   * NoSuchKey
//   The specified key does not exist.
//
func (c *S3) GetObject(input *GetObjectInput) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	err := req.Send()
	return out, err
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetObjectAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetObjectAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetObjectAclRequest method.
//    req, resp := client.GetObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) (req *request.Request, output *GetObjectAclOutput) {
	op := &request.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectAclOutput{}
	req.Data = output
	return
}

// GetObjectAcl API operation for Amazon Simple Storage Service.
//
// Returns the access control list (ACL) of an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * NoSuchKey
//   The specified key does not exist.
//
func (c *S3) GetObjectAcl(input *GetObjectAclInput) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	err := req.Send()
	return out, err
}

const opGetObjectTorrent = "GetObjectTorrent"

// GetObjectTorrentRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTorrent operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetObjectTorrent for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetObjectTorrent method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetObjectTorrentRequest method.
//    req, resp := client.GetObjectTorrentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) GetObjectTorrentRequest(input *GetObjectTorrentInput) (req *request.Request, output *GetObjectTorrentOutput) {
	op := &request.Operation{
		Name:       opGetObjectTorrent,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?torrent",
	}

	if input == nil {
		input = &GetObjectTorrentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetObjectTorrentOutput{}
	req.Data = output
	return
}

// GetObjectTorrent API operation for Amazon Simple Storage Service.
//
// Return torrent files from a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTorrent for usage and error information.
func (c *S3) GetObjectTorrent(input *GetObjectTorrentInput) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	err := req.Send()
	return out, err
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest generates a "aws/request.Request" representing the
// client's request for the HeadBucket operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See HeadBucket for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the HeadBucket method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the HeadBucketRequest method.
//    req, resp := client.HeadBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) HeadBucketRequest(input *HeadBucketInput) (req *request.Request, output *HeadBucketOutput) {
	op := &request.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &HeadBucketOutput{}
	req.Data = output
	return
}

// HeadBucket API operation for Amazon Simple Storage Service.
//
// This operation is useful to determine if a bucket exists and you have permission
// to access it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadBucket for usage and error information.
//
// Returned Error Codes:
//   * NoSuchBucket
//   The specified bucket does not exist.
//
func (c *S3) HeadBucket(input *HeadBucketInput) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	err := req.Send()
	return out, err
}

const opHeadObject = "HeadObject"

// HeadObjectRequest generates a "aws/request.Request" representing the
// client's request for the HeadObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See HeadObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the HeadObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the HeadObjectRequest method.
//    req, resp := client.HeadObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) HeadObjectRequest(input *HeadObjectInput) (req *request.Request, output *HeadObjectOutput) {
	op := &request.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &HeadObjectOutput{}
	req.Data = output
	return
}

// HeadObject API operation for Amazon Simple Storage Service.
//
// The HEAD operation retrieves metadata from an object without returning the
// object itself. This operation is useful if you're only interested in an object's
// metadata. To use HEAD, you must have READ access to the object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadObject for usage and error information.
//
// Returned Error Codes:
//   * NoSuchKey
//   The specified key does not exist.
//
func (c *S3) HeadObject(input *HeadObjectInput) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	err := req.Send()
	return out, err
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuckets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListBuckets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListBuckets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListBucketsRequest method.
//    req, resp := client.ListBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListBucketsRequest(input *ListBucketsInput) (req *request.Request, output *ListBucketsOutput) {
	op := &request.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBucketsOutput{}
	req.Data = output
	return
}

// ListBuckets API operation for Amazon Simple Storage Service.
//
// Returns a list of all buckets owned by the authenticated sender of the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBuckets for usage and error information.
func (c *S3) ListBuckets(input *ListBucketsInput) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	err := req.Send()
	return out, err
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartUploads operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListMultipartUploads for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListMultipartUploads method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListMultipartUploadsRequest method.
//    req, resp := client.ListMultipartUploadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListMultipartUploadsOutput{}
	req.Data = output
	return
}

// ListMultipartUploads API operation for Amazon Simple Storage Service.
//
// This operation lists in-progress multipart uploads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListMultipartUploads for usage and error information.
func (c *S3) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	err := req.Send()
	return out, err
}

// ListMultipartUploadsPages iterates over the pages of a ListMultipartUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultipartUploads operation.
//    pageNum := 0
//    err := client.ListMultipartUploadsPages(params,
//        func(page *ListMultipartUploadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(p *ListMultipartUploadsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMultipartUploadsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMultipartUploadsOutput), lastPage)
	})
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListObjectVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListObjectVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListObjectVersionsRequest method.
//    req, resp := client.ListObjectVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) (req *request.Request, output *ListObjectVersionsOutput) {
	op := &request.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListObjectVersionsOutput{}
	req.Data = output
	return
}

// ListObjectVersions API operation for Amazon Simple Storage Service.
//
// Returns metadata about all of the versions of objects in a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectVersions for usage and error information.
func (c *S3) ListObjectVersions(input *ListObjectVersionsInput) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	err := req.Send()
	return out, err
}

// ListObjectVersionsPages iterates over the pages of a ListObjectVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectVersions operation.
//    pageNum := 0
//    err := client.ListObjectVersionsPages(params,
//        func(page *ListObjectVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectVersionsPages(input *ListObjectVersionsInput, fn func(p *ListObjectVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListObjectVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListObjectVersionsOutput), lastPage)
	})
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListObjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListObjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListObjectsRequest method.
//    req, resp := client.ListObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListObjectsOutput{}
	req.Data = output
	return
}

// ListObjects API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjects for usage and error information.
//
// Returned Error Codes:
//   * NoSuchBucket
//   The specified bucket does not exist.
//
func (c *S3) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	err := req.Send()
	return out, err
}

// ListObjectsPages iterates over the pages of a ListObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjects operation.
//    pageNum := 0
//    err := client.ListObjectsPages(params,
//        func(page *ListObjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsPages(input *ListObjectsInput, fn func(p *ListObjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListObjectsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListObjectsOutput), lastPage)
	})
}

const opListObjectsV2 = "ListObjectsV2"

// ListObjectsV2Request generates a "aws/request.Request" representing the
// client's request for the ListObjectsV2 operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListObjectsV2 for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListObjectsV2 method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListObjectsV2Request method.
//    req, resp := client.ListObjectsV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListObjectsV2Request(input *ListObjectsV2Input) (req *request.Request, output *ListObjectsV2Output) {
	op := &request.Operation{
		Name:       opListObjectsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?list-type=2",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ContinuationToken"},
			OutputTokens:    []string{"NextContinuationToken"},
			LimitToken:      "MaxKeys",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsV2Input{}
	}

	req = c.newRequest(op, input, output)
	output = &ListObjectsV2Output{}
	req.Data = output
	return
}

// ListObjectsV2 API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. Note: ListObjectsV2 is the revised List Objects API and we recommend
// you use this revised API for new application development.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectsV2 for usage and error information.
//
// Returned Error Codes:
//   * NoSuchBucket
//   The specified bucket does not exist.
//
func (c *S3) ListObjectsV2(input *ListObjectsV2Input) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	err := req.Send()
	return out, err
}

// ListObjectsV2Pages iterates over the pages of a ListObjectsV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectsV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectsV2 operation.
//    pageNum := 0
//    err := client.ListObjectsV2Pages(params,
//        func(page *ListObjectsV2Output, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsV2Pages(input *ListObjectsV2Input, fn func(p *ListObjectsV2Output, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListObjectsV2Request(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListObjectsV2Output), lastPage)
	})
}

const opListParts = "ListParts"

// ListPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListParts operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListParts for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListParts method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPartsRequest method.
//    req, resp := client.ListPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPartsOutput{}
	req.Data = output
	return
}

// ListParts API operation for Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListParts for usage and error information.
func (c *S3) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	err := req.Send()
	return out, err
}

// ListPartsPages iterates over the pages of a ListParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParts operation.
//    pageNum := 0
//    err := client.ListPartsPages(params,
//        func(page *ListPartsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListPartsPages(input *ListPartsInput, fn func(p *ListPartsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPartsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPartsOutput), lastPage)
	})
}

const opPutBucketAccelerateConfiguration = "PutBucketAccelerateConfiguration"

// PutBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAccelerateConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketAccelerateConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketAccelerateConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketAccelerateConfigurationRequest method.
//    req, resp := client.PutBucketAccelerateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketAccelerateConfigurationRequest(input *PutBucketAccelerateConfigurationInput) (req *request.Request, output *PutBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketAccelerateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &PutBucketAccelerateConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketAccelerateConfigurationOutput{}
	req.Data = output
	return
}

// PutBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// Sets the accelerate configuration of an existing bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAccelerateConfiguration for usage and error information.
func (c *S3) PutBucketAccelerateConfiguration(input *PutBucketAccelerateConfigurationInput) (*PutBucketAccelerateConfigurationOutput, error) {
	req, out := c.PutBucketAccelerateConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketAclRequest method.
//    req, resp := client.PutBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) (req *request.Request, output *PutBucketAclOutput) {
	op := &request.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketAclOutput{}
	req.Data = output
	return
}

// PutBucketAcl API operation for Amazon Simple Storage Service.
//
// Sets the permissions on a bucket using access control lists (ACL).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAcl for usage and error information.
func (c *S3) PutBucketAcl(input *PutBucketAclInput) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketCors operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketCors for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketCors method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketCorsRequest method.
//    req, resp := client.PutBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) (req *request.Request, output *PutBucketCorsOutput) {
	op := &request.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketCorsOutput{}
	req.Data = output
	return
}

// PutBucketCors API operation for Amazon Simple Storage Service.
//
// Sets the cors configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketCors for usage and error information.
func (c *S3) PutBucketCors(input *PutBucketCorsInput) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycle operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketLifecycle for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketLifecycle method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketLifecycleRequest method.
//    req, resp := client.PutBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) (req *request.Request, output *PutBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketLifecycleOutput{}
	req.Data = output
	return
}

// PutBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketLifecycleConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycle for usage and error information.
func (c *S3) PutBucketLifecycle(input *PutBucketLifecycleInput) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketLifecycleConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketLifecycleConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//    req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketLifecycleConfigurationOutput{}
	req.Data = output
	return
}

// PutBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Sets lifecycle configuration for your bucket. If a lifecycle configuration
// exists, it replaces it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycleConfiguration for usage and error information.
func (c *S3) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLogging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketLogging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketLogging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketLoggingRequest method.
//    req, resp := client.PutBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) (req *request.Request, output *PutBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketLoggingOutput{}
	req.Data = output
	return
}

// PutBucketLogging API operation for Amazon Simple Storage Service.
//
// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. To set the logging status of
// a bucket, you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLogging for usage and error information.
func (c *S3) PutBucketLogging(input *PutBucketLoggingInput) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketNotification = "PutBucketNotification"

// PutBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotification operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketNotification for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketNotification method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketNotificationRequest method.
//    req, resp := client.PutBucketNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketNotificationRequest(input *PutBucketNotificationInput) (req *request.Request, output *PutBucketNotificationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketNotificationOutput{}
	req.Data = output
	return
}

// PutBucketNotification API operation for Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketNotificationConfiguraiton operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotification for usage and error information.
func (c *S3) PutBucketNotification(input *PutBucketNotificationInput) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotificationConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketNotificationConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketNotificationConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketNotificationConfigurationRequest method.
//    req, resp := client.PutBucketNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) (req *request.Request, output *PutBucketNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketNotificationConfigurationOutput{}
	req.Data = output
	return
}

// PutBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Enables notifications of specified events for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotificationConfiguration for usage and error information.
func (c *S3) PutBucketNotificationConfiguration(input *PutBucketNotificationConfigurationInput) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketPolicyRequest method.
//    req, resp := client.PutBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketPolicyOutput{}
	req.Data = output
	return
}

// PutBucketPolicy API operation for Amazon Simple Storage Service.
//
// Replaces a policy on a bucket. If the bucket already has a policy, the one
// in this request completely replaces it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketPolicy for usage and error information.
func (c *S3) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketReplication operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketReplication for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketReplication method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketReplicationRequest method.
//    req, resp := client.PutBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketReplicationRequest(input *PutBucketReplicationInput) (req *request.Request, output *PutBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketReplicationOutput{}
	req.Data = output
	return
}

// PutBucketReplication API operation for Amazon Simple Storage Service.
//
// Creates a new replication configuration (or replaces an existing one, if
// present).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketReplication for usage and error information.
func (c *S3) PutBucketReplication(input *PutBucketReplicationInput) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketRequestPayment = "PutBucketRequestPayment"

// PutBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketRequestPayment operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketRequestPayment for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketRequestPayment method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketRequestPaymentRequest method.
//    req, resp := client.PutBucketRequestPaymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketRequestPaymentRequest(input *PutBucketRequestPaymentInput) (req *request.Request, output *PutBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opPutBucketRequestPayment,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &PutBucketRequestPaymentInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketRequestPaymentOutput{}
	req.Data = output
	return
}

// PutBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Sets the request payment configuration for a bucket. By default, the bucket
// owner pays for downloads from the bucket. This configuration parameter enables
// the bucket owner (only) to specify that the person requesting the download
// will be charged for the download. Documentation on requester pays buckets
// can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketRequestPayment for usage and error information.
func (c *S3) PutBucketRequestPayment(input *PutBucketRequestPaymentInput) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketTagging operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketTagging for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketTagging method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketTaggingRequest method.
//    req, resp := client.PutBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketTaggingOutput{}
	req.Data = output
	return
}

// PutBucketTagging API operation for Amazon Simple Storage Service.
//
// Sets the tags for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketTagging for usage and error information.
func (c *S3) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketVersioning operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketVersioning for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketVersioning method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketVersioningRequest method.
//    req, resp := client.PutBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketVersioningOutput{}
	req.Data = output
	return
}

// PutBucketVersioning API operation for Amazon Simple Storage Service.
//
// Sets the versioning state of an existing bucket. To set the versioning state,
// you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketVersioning for usage and error information.
func (c *S3) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	err := req.Send()
	return out, err
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketWebsite operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutBucketWebsite for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutBucketWebsite method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutBucketWebsiteRequest method.
//    req, resp := client.PutBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) (req *request.Request, output *PutBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutBucketWebsiteOutput{}
	req.Data = output
	return
}

// PutBucketWebsite API operation for Amazon Simple Storage Service.
//
// Set the website configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketWebsite for usage and error information.
func (c *S3) PutBucketWebsite(input *PutBucketWebsiteInput) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	err := req.Send()
	return out, err
}

const opPutObject = "PutObject"

// PutObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutObjectRequest method.
//    req, resp := client.PutObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutObjectOutput{}
	req.Data = output
	return
}

// PutObject API operation for Amazon Simple Storage Service.
//
// Adds an object to a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObject for usage and error information.
func (c *S3) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	err := req.Send()
	return out, err
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectAcl operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutObjectAcl for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutObjectAcl method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutObjectAclRequest method.
//    req, resp := client.PutObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) (req *request.Request, output *PutObjectAclOutput) {
	op := &request.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutObjectAclOutput{}
	req.Data = output
	return
}

// PutObjectAcl API operation for Amazon Simple Storage Service.
//
// uses the acl subresource to set the access control list (ACL) permissions
// for an object that already exists in a bucket
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * NoSuchKey
//   The specified key does not exist.
//
func (c *S3) PutObjectAcl(input *PutObjectAclInput) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest generates a "aws/request.Request" representing the
// client's request for the RestoreObject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RestoreObject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RestoreObject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RestoreObjectRequest method.
//    req, resp := client.RestoreObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) (req *request.Request, output *RestoreObjectOutput) {
	op := &request.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreObjectOutput{}
	req.Data = output
	return
}

// RestoreObject API operation for Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation RestoreObject for usage and error information.
//
// Returned Error Codes:
//   * ObjectAlreadyInActiveTierError
//   This operation is not allowed against this storage tier
//
func (c *S3) RestoreObject(input *RestoreObjectInput) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	err := req.Send()
	return out, err
}

const opUploadPart = "UploadPart"

// UploadPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadPart operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadPart for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadPart method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadPartRequest method.
//    req, resp := client.UploadPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) UploadPartRequest(input *UploadPartInput) (req *request.Request, output *UploadPartOutput) {
	op := &request.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadPartOutput{}
	req.Data = output
	return
}

// UploadPart API operation for Amazon Simple Storage Service.
//
// Uploads a part in a multipart upload.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPart for usage and error information.
func (c *S3) UploadPart(input *UploadPartInput) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	err := req.Send()
	return out, err
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest generates a "aws/request.Request" representing the
// client's request for the UploadPartCopy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadPartCopy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadPartCopy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadPartCopyRequest method.
//    req, resp := client.UploadPartCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) (req *request.Request, output *UploadPartCopyOutput) {
	op := &request.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadPartCopyOutput{}
	req.Data = output
	return
}

// UploadPartCopy API operation for Amazon Simple Storage Service.
//
// Uploads a part by copying data from an existing object as data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPartCopy for usage and error information.
func (c *S3) UploadPartCopy(input *UploadPartCopyInput) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	err := req.Send()
	return out, err
}

// Specifies the days since the initiation of an Incomplete Multipart Upload
// that Lifecycle will wait before permanently removing all parts of the upload.
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Indicates the number of days that must pass since initiation for Lifecycle
	// to abort an Incomplete Multipart Upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AbortIncompleteMultipartUpload) SetDaysAfterInitiation(v int64) *AbortIncompleteMultipartUpload {
	s.DaysAfterInitiation = &v
	return s
}

type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AbortMultipartUploadInput) SetBucket(v string) *AbortMultipartUploadInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AbortMultipartUploadInput) SetKey(v string) *AbortMultipartUploadInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *AbortMultipartUploadInput) SetRequestPayer(v string) *AbortMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartUploadInput) SetUploadId(v string) *AbortMultipartUploadInput {
	s.UploadId = &v
	return s
}

type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *AbortMultipartUploadOutput) SetRequestCharged(v string) *AbortMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccelerateConfiguration) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AccelerateConfiguration) SetStatus(v string) *AccelerateConfiguration {
	s.Status = &v
	return s
}

type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *AccessControlPolicy) SetGrants(v []*Grant) *AccessControlPolicy {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AccessControlPolicy) SetOwner(v *Owner) *AccessControlPolicy {
	s.Owner = v
	return s
}

type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *Bucket) SetCreationDate(v time.Time) *Bucket {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bucket) SetName(v string) *Bucket {
	s.Name = &v
	return s
}

type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *BucketLifecycleConfiguration) SetRules(v []*LifecycleRule) *BucketLifecycleConfiguration {
	s.Rules = v
	return s
}

type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *BucketLoggingStatus) SetLoggingEnabled(v *LoggingEnabled) *BucketLoggingStatus {
	s.LoggingEnabled = v
	return s
}

type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// CORSRules is a required field
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSConfiguration"}
	if s.CORSRules == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCORSRules sets the CORSRules field's value.
func (s *CORSConfiguration) SetCORSRules(v []*CORSRule) *CORSConfiguration {
	s.CORSRules = v
	return s
}

type CORSRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a pre-flight OPTIONS request.
	AllowedHeaders []*string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// Identifies HTTP methods that the domain/origin specified in the rule is allowed
	// to execute.
	//
	// AllowedMethods is a required field
	AllowedMethods []*string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []*string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []*string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSRule"}
	if s.AllowedMethods == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedMethods"))
	}
	if s.AllowedOrigins == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedHeaders sets the AllowedHeaders field's value.
func (s *CORSRule) SetAllowedHeaders(v []*string) *CORSRule {
	s.AllowedHeaders = v
	return s
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CORSRule) SetAllowedMethods(v []*string) *CORSRule {
	s.AllowedMethods = v
	return s
}

// SetAllowedOrigins sets the AllowedOrigins field's value.
func (s *CORSRule) SetAllowedOrigins(v []*string) *CORSRule {
	s.AllowedOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *CORSRule) SetExposeHeaders(v []*string) *CORSRule {
	s.ExposeHeaders = v
	return s
}

// SetMaxAgeSeconds sets the MaxAgeSeconds field's value.
func (s *CORSRule) SetMaxAgeSeconds(v int64) *CORSRule {
	s.MaxAgeSeconds = &v
	return s
}

type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	CloudFunction *string `type:"string"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFunctionConfiguration) GoString() string {
	return s.String()
}

// SetCloudFunction sets the CloudFunction field's value.
func (s *CloudFunctionConfiguration) SetCloudFunction(v string) *CloudFunctionConfiguration {
	s.CloudFunction = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *CloudFunctionConfiguration) SetEvent(v string) *CloudFunctionConfiguration {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *CloudFunctionConfiguration) SetEvents(v []*string) *CloudFunctionConfiguration {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *CloudFunctionConfiguration) SetId(v string) *CloudFunctionConfiguration {
	s.Id = &v
	return s
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *CloudFunctionConfiguration) SetInvocationRole(v string) *CloudFunctionConfiguration {
	s.InvocationRole = &v
	return s
}

type CommonPrefix struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonPrefix) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *CommonPrefix) SetPrefix(v string) *CommonPrefix {
	s.Prefix = &v
	return s
}

type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure" payload:"MultipartUpload"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadInput) SetBucket(v string) *CompleteMultipartUploadInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadInput) SetKey(v string) *CompleteMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMultipartUpload sets the MultipartUpload field's value.
func (s *CompleteMultipartUploadInput) SetMultipartUpload(v *CompletedMultipartUpload) *CompleteMultipartUploadInput {
	s.MultipartUpload = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CompleteMultipartUploadInput) SetRequestPayer(v string) *CompleteMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartUploadInput) SetUploadId(v string) *CompleteMultipartUploadInput {
	s.UploadId = &v
	return s
}

type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	Bucket *string `type:"string"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	Key *string `min:"1" type:"string"`

	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadOutput) SetBucket(v string) *CompleteMultipartUploadOutput {
	s.Bucket = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *CompleteMultipartUploadOutput) SetETag(v string) *CompleteMultipartUploadOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CompleteMultipartUploadOutput) SetExpiration(v string) *CompleteMultipartUploadOutput {
	s.Expiration = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadOutput) SetKey(v string) *CompleteMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CompleteMultipartUploadOutput) SetLocation(v string) *CompleteMultipartUploadOutput {
	s.Location = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CompleteMultipartUploadOutput) SetRequestCharged(v string) *CompleteMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CompleteMultipartUploadOutput) SetSSEKMSKeyId(v string) *CompleteMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CompleteMultipartUploadOutput) SetServerSideEncryption(v string) *CompleteMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CompleteMultipartUploadOutput) SetVersionId(v string) *CompleteMultipartUploadOutput {
	s.VersionId = &v
	return s
}

type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	Parts []*CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

// SetParts sets the Parts field's value.
func (s *CompletedMultipartUpload) SetParts(v []*CompletedPart) *CompletedMultipartUpload {
	s.Parts = v
	return s
}

type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedPart) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CompletedPart) SetETag(v string) *CompletedPart {
	s.ETag = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *CompletedPart) SetPartNumber(v int64) *CompletedPart {
	s.PartNumber = &v
	return s
}

type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// SetHttpErrorCodeReturnedEquals sets the HttpErrorCodeReturnedEquals field's value.
func (s *Condition) SetHttpErrorCodeReturnedEquals(v string) *Condition {
	s.HttpErrorCodeReturnedEquals = &v
	return s
}

// SetKeyPrefixEquals sets the KeyPrefixEquals field's value.
func (s *Condition) SetKeyPrefixEquals(v string) *Condition {
	s.KeyPrefixEquals = &v
	return s
}

type CopyObjectInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective *string `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"MetadataDirective"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CopyObjectInput) SetACL(v string) *CopyObjectInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CopyObjectInput) SetBucket(v string) *CopyObjectInput {
	s.Bucket = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *CopyObjectInput) SetCacheControl(v string) *CopyObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CopyObjectInput) SetContentDisposition(v string) *CopyObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CopyObjectInput) SetContentEncoding(v string) *CopyObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CopyObjectInput) SetContentLanguage(v string) *CopyObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CopyObjectInput) SetContentType(v string) *CopyObjectInput {
	s.ContentType = &v
	return s
}

// SetCopySource sets the CopySource field's value.
func (s *CopyObjectInput) SetCopySource(v string) *CopyObjectInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfMatch(v string) *CopyObjectInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfModifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfNoneMatch(v string) *CopyObjectInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfUnmodifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKey(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CopyObjectInput) SetExpires(v time.Time) *CopyObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CopyObjectInput) SetGrantFullControl(v string) *CopyObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CopyObjectInput) SetGrantRead(v string) *CopyObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CopyObjectInput) SetGrantReadACP(v string) *CopyObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CopyObjectInput) SetGrantWriteACP(v string) *CopyObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CopyObjectInput) SetKey(v string) *CopyObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CopyObjectInput) SetMetadata(v map[string]*string) *CopyObjectInput {
	s.Metadata = v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *CopyObjectInput) SetMetadataDirective(v string) *CopyObjectInput {
	s.MetadataDirective = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CopyObjectInput) SetRequestPayer(v string) *CopyObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CopyObjectInput) SetSSECustomerKey(v string) *CopyObjectInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectInput) SetSSEKMSKeyId(v string) *CopyObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectInput) SetServerSideEncryption(v string) *CopyObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CopyObjectInput) SetStorageClass(v string) *CopyObjectInput {
	s.StorageClass = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CopyObjectInput) SetWebsiteRedirectLocation(v string) *CopyObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	CopyObjectResult *CopyObjectResult `type:"structure"`

	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

// SetCopyObjectResult sets the CopyObjectResult field's value.
func (s *CopyObjectOutput) SetCopyObjectResult(v *CopyObjectResult) *CopyObjectOutput {
	s.CopyObjectResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *CopyObjectOutput) SetCopySourceVersionId(v string) *CopyObjectOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CopyObjectOutput) SetExpiration(v string) *CopyObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CopyObjectOutput) SetRequestCharged(v string) *CopyObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectOutput) SetSSECustomerAlgorithm(v string) *CopyObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectOutput) SetSSECustomerKeyMD5(v string) *CopyObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectOutput) SetSSEKMSKeyId(v string) *CopyObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectOutput) SetServerSideEncryption(v string) *CopyObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CopyObjectOutput) SetVersionId(v string) *CopyObjectOutput {
	s.VersionId = &v
	return s
}

type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyObjectResult) SetETag(v string) *CopyObjectResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyObjectResult) SetLastModified(v time.Time) *CopyObjectResult {
	s.LastModified = &v
	return s
}

type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyPartResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyPartResult) SetETag(v string) *CopyPartResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyPartResult) SetLastModified(v time.Time) *CopyPartResult {
	s.LastModified = &v
	return s
}

type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the region where the bucket will be created. If you don't specify
	// a region, the bucket will be created in US Standard.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

type CreateBucketInput struct {
	_ struct{} `type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

type CreateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateMultipartUploadInput) SetACL(v string) *CreateMultipartUploadInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadInput) SetBucket(v string) *CreateMultipartUploadInput {
	s.Bucket = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *CreateMultipartUploadInput) SetCacheControl(v string) *CreateMultipartUploadInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CreateMultipartUploadInput) SetContentDisposition(v string) *CreateMultipartUploadInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CreateMultipartUploadInput) SetContentEncoding(v string) *CreateMultipartUploadInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CreateMultipartUploadInput) SetContentLanguage(v string) *CreateMultipartUploadInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateMultipartUploadInput) SetContentType(v string) *CreateMultipartUploadInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CreateMultipartUploadInput) SetExpires(v time.Time) *CreateMultipartUploadInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateMultipartUploadInput) SetGrantFullControl(v string) *CreateMultipartUploadInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateMultipartUploadInput) SetGrantRead(v string) *CreateMultipartUploadInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateMultipartUploadInput) SetGrantReadACP(v string) *CreateMultipartUploadInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateMultipartUploadInput) SetGrantWriteACP(v string) *CreateMultipartUploadInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadInput) SetKey(v string) *CreateMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateMultipartUploadInput) SetMetadata(v map[string]*string) *CreateMultipartUploadInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CreateMultipartUploadInput) SetRequestPayer(v string) *CreateMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKey(v string) *CreateMultipartUploadInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadInput) SetSSEKMSKeyId(v string) *CreateMultipartUploadInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadInput) SetServerSideEncryption(v string) *CreateMultipartUploadInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CreateMultipartUploadInput) SetStorageClass(v string) *CreateMultipartUploadInput {
	s.StorageClass = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CreateMultipartUploadInput) SetWebsiteRedirectLocation(v string) *CreateMultipartUploadInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *CreateMultipartUploadOutput) SetAbortDate(v time.Time) *CreateMultipartUploadOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *CreateMultipartUploadOutput) SetAbortRuleId(v string) *CreateMultipartUploadOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadOutput) SetBucket(v string) *CreateMultipartUploadOutput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadOutput) SetKey(v string) *CreateMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CreateMultipartUploadOutput) SetRequestCharged(v string) *CreateMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadOutput) SetSSEKMSKeyId(v string) *CreateMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadOutput) SetServerSideEncryption(v string) *CreateMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateMultipartUploadOutput) SetUploadId(v string) *CreateMultipartUploadOutput {
	s.UploadId = &v
	return s
}

type Delete struct {
	_ struct{} `type:"structure"`

	// Objects is a required field
	Objects []*ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Delete"}
	if s.Objects == nil {
		invalidParams.Add(request.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjects sets the Objects field's value.
func (s *Delete) SetObjects(v []*ObjectIdentifier) *Delete {
	s.Objects = v
	return s
}

// SetQuiet sets the Quiet field's value.
func (s *Delete) SetQuiet(v bool) *Delete {
	s.Quiet = &v
	return s
}

type DeleteBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketCorsInput) SetBucket(v string) *DeleteBucketCorsInput {
	s.Bucket = &v
	return s
}

type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

type DeleteBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

type DeleteBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleInput) SetBucket(v string) *DeleteBucketLifecycleInput {
	s.Bucket = &v
	return s
}

type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

type DeleteBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketPolicyInput) SetBucket(v string) *DeleteBucketPolicyInput {
	s.Bucket = &v
	return s
}

type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketReplicationInput) SetBucket(v string) *DeleteBucketReplicationInput {
	s.Bucket = &v
	return s
}

type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

type DeleteBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketTaggingInput) SetBucket(v string) *DeleteBucketTaggingInput {
	s.Bucket = &v
	return s
}

type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

type DeleteBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketWebsiteInput) SetBucket(v string) *DeleteBucketWebsiteInput {
	s.Bucket = &v
	return s
}

type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

// SetIsLatest sets the IsLatest field's value.
func (s *DeleteMarkerEntry) SetIsLatest(v bool) *DeleteMarkerEntry {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteMarkerEntry) SetKey(v string) *DeleteMarkerEntry {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DeleteMarkerEntry) SetLastModified(v time.Time) *DeleteMarkerEntry {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DeleteMarkerEntry) SetOwner(v *Owner) *DeleteMarkerEntry {
	s.Owner = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteMarkerEntry) SetVersionId(v string) *DeleteMarkerEntry {
	s.VersionId = &v
	return s
}

type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectInput) SetBucket(v string) *DeleteObjectInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteObjectInput) SetKey(v string) *DeleteObjectInput {
	s.Key = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectInput) SetMFA(v string) *DeleteObjectInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectInput) SetRequestPayer(v string) *DeleteObjectInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectInput) SetVersionId(v string) *DeleteObjectInput {
	s.VersionId = &v
	return s
}

type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeleteObjectOutput) SetDeleteMarker(v bool) *DeleteObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectOutput) SetRequestCharged(v string) *DeleteObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectOutput) SetVersionId(v string) *DeleteObjectOutput {
	s.VersionId = &v
	return s
}

type DeleteObjectsInput struct {
	_ struct{} `type:"structure" payload:"Delete"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Delete is a required field
	Delete *Delete `locationName:"Delete" type:"structure" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Delete == nil {
		invalidParams.Add(request.NewErrParamRequired("Delete"))
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectsInput) SetBucket(v string) *DeleteObjectsInput {
	s.Bucket = &v
	return s
}

// SetDelete sets the Delete field's value.
func (s *DeleteObjectsInput) SetDelete(v *Delete) *DeleteObjectsInput {
	s.Delete = v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectsInput) SetMFA(v string) *DeleteObjectsInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectsInput) SetRequestPayer(v string) *DeleteObjectsInput {
	s.RequestPayer = &v
	return s
}

type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	Deleted []*DeletedObject `type:"list" flattened:"true"`

	Errors []*Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *DeleteObjectsOutput) SetDeleted(v []*DeletedObject) *DeleteObjectsOutput {
	s.Deleted = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DeleteObjectsOutput) SetErrors(v []*Error) *DeleteObjectsOutput {
	s.Errors = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectsOutput) SetRequestCharged(v string) *DeleteObjectsOutput {
	s.RequestCharged = &v
	return s
}

type DeletedObject struct {
	_ struct{} `type:"structure"`

	DeleteMarker *bool `type:"boolean"`

	DeleteMarkerVersionId *string `type:"string"`

	Key *string `min:"1" type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletedObject) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeletedObject) SetDeleteMarker(v bool) *DeletedObject {
	s.DeleteMarker = &v
	return s
}

// SetDeleteMarkerVersionId sets the DeleteMarkerVersionId field's value.
func (s *DeletedObject) SetDeleteMarkerVersionId(v string) *DeletedObject {
	s.DeleteMarkerVersionId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeletedObject) SetKey(v string) *DeletedObject {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeletedObject) SetVersionId(v string) *DeletedObject {
	s.VersionId = &v
	return s
}

type Destination struct {
	_ struct{} `type:"structure"`

	// Amazon resource name (ARN) of the bucket where you want Amazon S3 to store
	// replicas of the object identified by the rule.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *Destination) SetBucket(v string) *Destination {
	s.Bucket = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Destination) SetStorageClass(v string) *Destination {
	s.StorageClass = &v
	return s
}

type Error struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Key *string `min:"1" type:"string"`

	Message *string `type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Error) SetCode(v string) *Error {
	s.Code = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Error) SetKey(v string) *Error {
	s.Key = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Error) SetMessage(v string) *Error {
	s.Message = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *Error) SetVersionId(v string) *Error {
	s.VersionId = &v
	return s
}

type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorDocument"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ErrorDocument) SetKey(v string) *ErrorDocument {
	s.Key = &v
	return s
}

// Container for key value pair that defines the criteria for the filter rule.
type FilterRule struct {
	_ struct{} `type:"structure"`

	// Object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. Maximum prefix length can be up to 1,024 characters.
	// Overlapping prefixes and suffixes are not supported. For more information,
	// go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Name *string `type:"string" enum:"FilterRuleName"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterRule) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FilterRule) SetName(v string) *FilterRule {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterRule) SetValue(v string) *FilterRule {
	s.Value = &v
	return s
}

type GetBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket for which the accelerate configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAccelerateConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAccelerateConfigurationInput) SetBucket(v string) *GetBucketAccelerateConfigurationInput {
	s.Bucket = &v
	return s
}

type GetBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetBucketAccelerateConfigurationOutput) SetStatus(v string) *GetBucketAccelerateConfigurationOutput {
	s.Status = &v
	return s
}

type GetBucketAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAclInput) SetBucket(v string) *GetBucketAclInput {
	s.Bucket = &v
	return s
}

type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetBucketAclOutput) SetGrants(v []*Grant) *GetBucketAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetBucketAclOutput) SetOwner(v *Owner) *GetBucketAclOutput {
	s.Owner = v
	return s
}

type GetBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketCorsInput) SetBucket(v string) *GetBucketCorsInput {
	s.Bucket = &v
	return s
}

type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

// SetCORSRules sets the CORSRules field's value.
func (s *GetBucketCorsOutput) SetCORSRules(v []*CORSRule) *GetBucketCorsOutput {
	s.CORSRules = v
	return s
}

type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

type GetBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleInput) SetBucket(v string) *GetBucketLifecycleInput {
	s.Bucket = &v
	return s
}

type GetBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleOutput) SetRules(v []*Rule) *GetBucketLifecycleOutput {
	s.Rules = v
	return s
}

type GetBucketLocationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLocationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLocationInput) SetBucket(v string) *GetBucketLocationInput {
	s.Bucket = &v
	return s
}

type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *GetBucketLocationOutput) SetLocationConstraint(v string) *GetBucketLocationOutput {
	s.LocationConstraint = &v
	return s
}

type GetBucketLoggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLoggingInput) SetBucket(v string) *GetBucketLoggingInput {
	s.Bucket = &v
	return s
}

type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *GetBucketLoggingOutput) SetLoggingEnabled(v *LoggingEnabled) *GetBucketLoggingOutput {
	s.LoggingEnabled = v
	return s
}

type GetBucketNotificationConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to get the notification configuration for.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketNotificationConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketNotificationConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketNotificationConfigurationRequest"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketNotificationConfigurationRequest) SetBucket(v string) *GetBucketNotificationConfigurationRequest {
	s.Bucket = &v
	return s
}

type GetBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyInput) SetBucket(v string) *GetBucketPolicyInput {
	s.Bucket = &v
	return s
}

type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The bucket policy as a JSON document.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetBucketPolicyOutput) SetPolicy(v string) *GetBucketPolicyOutput {
	s.Policy = &v
	return s
}

type GetBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketReplicationInput) SetBucket(v string) *GetBucketReplicationInput {
	s.Bucket = &v
	return s
}

type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *GetBucketReplicationOutput) SetReplicationConfiguration(v *ReplicationConfiguration) *GetBucketReplicationOutput {
	s.ReplicationConfiguration = v
	return s
}

type GetBucketRequestPaymentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketRequestPaymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketRequestPaymentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketRequestPaymentInput) SetBucket(v string) *GetBucketRequestPaymentInput {
	s.Bucket = &v
	return s
}

type GetBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	Payer *string `type:"string" enum:"Payer"`
}

// String returns the string representation
func (s GetBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// SetPayer sets the Payer field's value.
func (s *GetBucketRequestPaymentOutput) SetPayer(v string) *GetBucketRequestPaymentOutput {
	s.Payer = &v
	return s
}

type GetBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketTaggingInput) SetBucket(v string) *GetBucketTaggingInput {
	s.Bucket = &v
	return s
}

type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetBucketTaggingOutput) SetTagSet(v []*Tag) *GetBucketTaggingOutput {
	s.TagSet = v
	return s
}

type GetBucketVersioningInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketVersioningInput) SetBucket(v string) *GetBucketVersioningInput {
	s.Bucket = &v
	return s
}

type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *GetBucketVersioningOutput) SetMFADelete(v string) *GetBucketVersioningOutput {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBucketVersioningOutput) SetStatus(v string) *GetBucketVersioningOutput {
	s.Status = &v
	return s
}

type GetBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketWebsiteInput) SetBucket(v string) *GetBucketWebsiteInput {
	s.Bucket = &v
	return s
}

type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *GetBucketWebsiteOutput) SetErrorDocument(v *ErrorDocument) *GetBucketWebsiteOutput {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *GetBucketWebsiteOutput) SetIndexDocument(v *IndexDocument) *GetBucketWebsiteOutput {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *GetBucketWebsiteOutput) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *GetBucketWebsiteOutput {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *GetBucketWebsiteOutput) SetRoutingRules(v []*RoutingRule) *GetBucketWebsiteOutput {
	s.RoutingRules = v
	return s
}

type GetObjectAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectAclInput) SetBucket(v string) *GetObjectAclInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectAclInput) SetKey(v string) *GetObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectAclInput) SetRequestPayer(v string) *GetObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAclInput) SetVersionId(v string) *GetObjectAclInput {
	s.VersionId = &v
	return s
}

type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetObjectAclOutput) SetGrants(v []*Grant) *GetObjectAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetObjectAclOutput) SetOwner(v *Owner) *GetObjectAclOutput {
	s.Owner = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectAclOutput) SetRequestCharged(v string) *GetObjectAclOutput {
	s.RequestCharged = &v
	return s
}

type GetObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified.
	// Useful for downloading just a part of an object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectInput) SetBucket(v string) *GetObjectInput {
	s.Bucket = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *GetObjectInput) SetIfMatch(v string) *GetObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *GetObjectInput) SetIfModifiedSince(v time.Time) *GetObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *GetObjectInput) SetIfNoneMatch(v string) *GetObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *GetObjectInput) SetIfUnmodifiedSince(v time.Time) *GetObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectInput) SetKey(v string) *GetObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetObjectInput) SetPartNumber(v int64) *GetObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetObjectInput) SetRange(v string) *GetObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectInput) SetRequestPayer(v string) *GetObjectInput {
	s.RequestPayer = &v
	return s
}

// SetResponseCacheControl sets the ResponseCacheControl field's value.
func (s *GetObjectInput) SetResponseCacheControl(v string) *GetObjectInput {
	s.ResponseCacheControl = &v
	return s
}

// SetResponseContentDisposition sets the ResponseContentDisposition field's value.
func (s *GetObjectInput) SetResponseContentDisposition(v string) *GetObjectInput {
	s.ResponseContentDisposition = &v
	return s
}

// SetResponseContentEncoding sets the ResponseContentEncoding field's value.
func (s *GetObjectInput) SetResponseContentEncoding(v string) *GetObjectInput {
	s.ResponseContentEncoding = &v
	return s
}

// SetResponseContentLanguage sets the ResponseContentLanguage field's value.
func (s *GetObjectInput) SetResponseContentLanguage(v string) *GetObjectInput {
	s.ResponseContentLanguage = &v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *GetObjectInput) SetResponseContentType(v string) *GetObjectInput {
	s.ResponseContentType = &v
	return s
}

// SetResponseExpires sets the ResponseExpires field's value.
func (s *GetObjectInput) SetResponseExpires(v time.Time) *GetObjectInput {
	s.ResponseExpires = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectInput) SetSSECustomerAlgorithm(v string) *GetObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *GetObjectInput) SetSSECustomerKey(v string) *GetObjectInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectInput) SetSSECustomerKeyMD5(v string) *GetObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectInput) SetVersionId(v string) *GetObjectInput {
	s.VersionId = &v
	return s
}

type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *GetObjectOutput) SetAcceptRanges(v string) *GetObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GetObjectOutput) SetBody(v io.ReadCloser) *GetObjectOutput {
	s.Body = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetObjectOutput) SetCacheControl(v string) *GetObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetObjectOutput) SetContentDisposition(v string) *GetObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetObjectOutput) SetContentEncoding(v string) *GetObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *GetObjectOutput) SetContentLanguage(v string) *GetObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *GetObjectOutput) SetContentLength(v int64) *GetObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *GetObjectOutput) SetContentRange(v string) *GetObjectOutput {
	s.ContentRange = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetObjectOutput) SetContentType(v string) *GetObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *GetObjectOutput) SetDeleteMarker(v bool) *GetObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetObjectOutput) SetETag(v string) *GetObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetObjectOutput) SetExpiration(v string) *GetObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *GetObjectOutput) SetExpires(v string) *GetObjectOutput {
	s.Expires = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetObjectOutput) SetLastModified(v time.Time) *GetObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetObjectOutput) SetMetadata(v map[string]*string) *GetObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *GetObjectOutput) SetMissingMeta(v int64) *GetObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *GetObjectOutput) SetPartsCount(v int64) *GetObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *GetObjectOutput) SetReplicationStatus(v string) *GetObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectOutput) SetRequestCharged(v string) *GetObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *GetObjectOutput) SetRestore(v string) *GetObjectOutput {
	s.Restore = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectOutput) SetSSECustomerAlgorithm(v string) *GetObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectOutput) SetSSECustomerKeyMD5(v string) *GetObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *GetObjectOutput) SetSSEKMSKeyId(v string) *GetObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *GetObjectOutput) SetServerSideEncryption(v string) *GetObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *GetObjectOutput) SetStorageClass(v string) *GetObjectOutput {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectOutput) SetVersionId(v string) *GetObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *GetObjectOutput) SetWebsiteRedirectLocation(v string) *GetObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

type GetObjectTorrentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s GetObjectTorrentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTorrentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTorrentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTorrentInput) SetBucket(v string) *GetObjectTorrentInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectTorrentInput) SetKey(v string) *GetObjectTorrentInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectTorrentInput) SetRequestPayer(v string) *GetObjectTorrentInput {
	s.RequestPayer = &v
	return s
}

type GetObjectTorrentOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadCloser `type:"blob"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectTorrentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetObjectTorrentOutput) SetBody(v io.ReadCloser) *GetObjectTorrentOutput {
	s.Body = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectTorrentOutput) SetRequestCharged(v string) *GetObjectTorrentOutput {
	s.RequestCharged = &v
	return s
}

type Grant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *Grant) SetGrantee(v *Grantee) *Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *Grant) SetPermission(v string) *Grant {
	s.Permission = &v
	return s
}

type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type *string `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grantee"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *Grantee) SetDisplayName(v string) *Grantee {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Grantee) SetEmailAddress(v string) *Grantee {
	s.EmailAddress = &v
	return s
}

// SetID sets the ID field's value.
func (s *Grantee) SetID(v string) *Grantee {
	s.ID = &v
	return s
}

// SetType sets the Type field's value.
func (s *Grantee) SetType(v string) *Grantee {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Grantee) SetURI(v string) *Grantee {
	s.URI = &v
	return s
}

type HeadBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadBucketInput) SetBucket(v string) *HeadBucketInput {
	s.Bucket = &v
	return s
}

type HeadBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

type HeadObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified.
	// Useful querying about the size of the part and the number of parts in this
	// object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadObjectInput) SetBucket(v string) *HeadObjectInput {
	s.Bucket = &v
	return s
}

// SetIfMatch sets the IfMatch field's value.
func (s *HeadObjectInput) SetIfMatch(v string) *HeadObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *HeadObjectInput) SetIfModifiedSince(v time.Time) *HeadObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *HeadObjectInput) SetIfNoneMatch(v string) *HeadObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *HeadObjectInput) SetIfUnmodifiedSince(v time.Time) *HeadObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *HeadObjectInput) SetKey(v string) *HeadObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *HeadObjectInput) SetPartNumber(v int64) *HeadObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *HeadObjectInput) SetRange(v string) *HeadObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *HeadObjectInput) SetRequestPayer(v string) *HeadObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectInput) SetSSECustomerAlgorithm(v string) *HeadObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *HeadObjectInput) SetSSECustomerKey(v string) *HeadObjectInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectInput) SetSSECustomerKeyMD5(v string) *HeadObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectInput) SetVersionId(v string) *HeadObjectInput {
	s.VersionId = &v
	return s
}

type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s HeadObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *HeadObjectOutput) SetAcceptRanges(v string) *HeadObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *HeadObjectOutput) SetCacheControl(v string) *HeadObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *HeadObjectOutput) SetContentDisposition(v string) *HeadObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *HeadObjectOutput) SetContentEncoding(v string) *HeadObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *HeadObjectOutput) SetContentLanguage(v string) *HeadObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *HeadObjectOutput) SetContentLength(v int64) *HeadObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *HeadObjectOutput) SetContentType(v string) *HeadObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *HeadObjectOutput) SetDeleteMarker(v bool) *HeadObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *HeadObjectOutput) SetETag(v string) *HeadObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *HeadObjectOutput) SetExpiration(v string) *HeadObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *HeadObjectOutput) SetExpires(v string) *HeadObjectOutput {
	s.Expires = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *HeadObjectOutput) SetLastModified(v time.Time) *HeadObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *HeadObjectOutput) SetMetadata(v map[string]*string) *HeadObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *HeadObjectOutput) SetMissingMeta(v int64) *HeadObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *HeadObjectOutput) SetPartsCount(v int64) *HeadObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *HeadObjectOutput) SetReplicationStatus(v string) *HeadObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *HeadObjectOutput) SetRequestCharged(v string) *HeadObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *HeadObjectOutput) SetRestore(v string) *HeadObjectOutput {
	s.Restore = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectOutput) SetSSECustomerAlgorithm(v string) *HeadObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectOutput) SetSSECustomerKeyMD5(v string) *HeadObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *HeadObjectOutput) SetSSEKMSKeyId(v string) *HeadObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *HeadObjectOutput) SetServerSideEncryption(v string) *HeadObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *HeadObjectOutput) SetStorageClass(v string) *HeadObjectOutput {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectOutput) SetVersionId(v string) *HeadObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *HeadObjectOutput) SetWebsiteRedirectLocation(v string) *HeadObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (e.g. if the suffix is index.html and you make a request to samplebucket/images/
	// the data that is returned will be for the object with the key name images/index.html)
	// The suffix must not be empty and must not include a slash character.
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexDocument"}
	if s.Suffix == nil {
		invalidParams.Add(request.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuffix sets the Suffix field's value.
func (s *IndexDocument) SetSuffix(v string) *IndexDocument {
	s.Suffix = &v
	return s
}

type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Initiator) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Initiator) SetDisplayName(v string) *Initiator {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Initiator) SetID(v string) *Initiator {
	s.ID = &v
	return s
}

// Container for object key name prefix and suffix filtering rules.
type KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for key value pair that defines the criteria for the
	// filter rule.
	FilterRules []*FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyFilter) GoString() string {
	return s.String()
}

// SetFilterRules sets the FilterRules field's value.
func (s *KeyFilter) SetFilterRules(v []*FilterRule) *KeyFilter {
	s.FilterRules = v
	return s
}

// Container for specifying the AWS Lambda notification configuration.
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.LambdaFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *LambdaFunctionConfiguration) SetEvents(v []*string) *LambdaFunctionConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LambdaFunctionConfiguration) SetFilter(v *NotificationConfigurationFilter) *LambdaFunctionConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *LambdaFunctionConfiguration) SetId(v string) *LambdaFunctionConfiguration {
	s.Id = &v
	return s
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *LambdaFunctionConfiguration) SetLambdaFunctionArn(v string) *LambdaFunctionConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *LifecycleConfiguration) SetRules(v []*Rule) *LifecycleConfiguration {
	s.Rules = v
	return s
}

type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired; if set to false
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LifecycleExpiration) SetDate(v time.Time) *LifecycleExpiration {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *LifecycleExpiration) SetDays(v int64) *LifecycleExpiration {
	s.Days = &v
	return s
}

// SetExpiredObjectDeleteMarker sets the ExpiredObjectDeleteMarker field's value.
func (s *LifecycleExpiration) SetExpiredObjectDeleteMarker(v bool) *LifecycleExpiration {
	s.ExpiredObjectDeleteMarker = &v
	return s
}

type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	NoncurrentVersionTransitions []*NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transitions []*Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRule"}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *LifecycleRule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *LifecycleRule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *LifecycleRule) SetExpiration(v *LifecycleExpiration) *LifecycleRule {
	s.Expiration = v
	return s
}

// SetID sets the ID field's value.
func (s *LifecycleRule) SetID(v string) *LifecycleRule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *LifecycleRule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *LifecycleRule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransitions sets the NoncurrentVersionTransitions field's value.
func (s *LifecycleRule) SetNoncurrentVersionTransitions(v []*NoncurrentVersionTransition) *LifecycleRule {
	s.NoncurrentVersionTransitions = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRule) SetPrefix(v string) *LifecycleRule {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleRule) SetStatus(v string) *LifecycleRule {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *LifecycleRule) SetTransitions(v []*Transition) *LifecycleRule {
	s.Transitions = v
	return s
}

type ListBucketsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsInput) GoString() string {
	return s.String()
}

type ListBucketsOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*Bucket `locationNameList:"Bucket" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s ListBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *ListBucketsOutput) SetBuckets(v []*Bucket) *ListBucketsOutput {
	s.Buckets = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListBucketsOutput) SetOwner(v *Owner) *ListBucketsOutput {
	s.Owner = v
	return s
}

type ListMultipartUploadsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Together with upload-id-marker, this parameter specifies the multipart upload
	// after which listing should begin.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of multipart uploads, from 1 to 1,000, to return
	// in the response body. 1,000 is the maximum number of uploads that can be
	// returned in a response.
	MaxUploads *int64 `location:"querystring" locationName:"max-uploads" type:"integer"`

	// Lists in-progress uploads only for those keys that begin with the specified
	// prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Together with key-marker, specifies the multipart upload after which listing
	// should begin. If key-marker is not specified, the upload-id-marker parameter
	// is ignored.
	UploadIdMarker *string `location:"querystring" locationName:"upload-id-marker" type:"string"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultipartUploadsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsInput) SetBucket(v string) *ListMultipartUploadsInput {
	s.Bucket = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsInput) SetDelimiter(v string) *ListMultipartUploadsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsInput) SetEncodingType(v string) *ListMultipartUploadsInput {
	s.EncodingType = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsInput) SetKeyMarker(v string) *ListMultipartUploadsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsInput) SetMaxUploads(v int64) *ListMultipartUploadsInput {
	s.MaxUploads = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsInput) SetPrefix(v string) *ListMultipartUploadsInput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsInput) SetUploadIdMarker(v string) *ListMultipartUploadsInput {
	s.UploadIdMarker = &v
	return s
}

type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// Indicates whether the returned list of multipart uploads is truncated. A
	// value of true indicates that the list was truncated. The list can be truncated
	// if the number of multipart uploads exceeds the limit allowed or specified
	// by max uploads.
	IsTruncated *bool `type:"boolean"`

	// The key at or after which the listing began.
	KeyMarker *string `type:"string"`

	// Maximum number of multipart uploads that could have been included in the
	// response.
	MaxUploads *int64 `type:"integer"`

	// When a list is truncated, this element specifies the value that should be
	// used for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When a list is truncated, this element specifies the value that should be
	// used for the upload-id-marker request parameter in a subsequent request.
	NextUploadIdMarker *string `type:"string"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only keys starting with the specified prefix.
	Prefix *string `type:"string"`

	// Upload ID after which listing began.
	UploadIdMarker *string `type:"string"`

	Uploads []*MultipartUpload `locationName:"Upload" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsOutput) SetBucket(v string) *ListMultipartUploadsOutput {
	s.Bucket = &v
	return s
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListMultipartUploadsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListMultipartUploadsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsOutput) SetDelimiter(v string) *ListMultipartUploadsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsOutput) SetEncodingType(v string) *ListMultipartUploadsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListMultipartUploadsOutput) SetIsTruncated(v bool) *ListMultipartUploadsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetKeyMarker(v string) *ListMultipartUploadsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsOutput) SetMaxUploads(v int64) *ListMultipartUploadsOutput {
	s.MaxUploads = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextKeyMarker(v string) *ListMultipartUploadsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextUploadIdMarker sets the NextUploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.NextUploadIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsOutput) SetPrefix(v string) *ListMultipartUploadsOutput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.UploadIdMarker = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListMultipartUploadsOutput) SetUploads(v []*MultipartUpload) *ListMultipartUploadsOutput {
	s.Uploads = v
	return s
}

type ListObjectVersionsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Specifies the object version you want to start listing from.
	VersionIdMarker *string `location:"querystring" locationName:"version-id-marker" type:"string"`
}

// String returns the string representation
func (s ListObjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectVersionsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectVersionsInput) SetBucket(v string) *ListObjectVersionsInput {
	s.Bucket = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsInput) SetDelimiter(v string) *ListObjectVersionsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsInput) SetEncodingType(v string) *ListObjectVersionsInput {
	s.EncodingType = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsInput) SetKeyMarker(v string) *ListObjectVersionsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsInput) SetMaxKeys(v int64) *ListObjectVersionsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsInput) SetPrefix(v string) *ListObjectVersionsInput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsInput) SetVersionIdMarker(v string) *ListObjectVersionsInput {
	s.VersionIdMarker = &v
	return s
}

type ListObjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	DeleteMarkers []*DeleteMarkerEntry `locationName:"DeleteMarker" type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria. If your results were truncated, you can
	// make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker
	// response parameters as a starting place in another request to return the
	// rest of the results.
	IsTruncated *bool `type:"boolean"`

	// Marks the last Key returned in a truncated response.
	KeyMarker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// Use this value for the key marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// Use this value for the next version id marker parameter in a subsequent request.
	NextVersionIdMarker *string `type:"string"`

	Prefix *string `type:"string"`

	VersionIdMarker *string `type:"string"`

	Versions []*ObjectVersion `locationName:"Version" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListObjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectVersionsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectVersionsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDeleteMarkers sets the DeleteMarkers field's value.
func (s *ListObjectVersionsOutput) SetDeleteMarkers(v []*DeleteMarkerEntry) *ListObjectVersionsOutput {
	s.DeleteMarkers = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsOutput) SetDelimiter(v string) *ListObjectVersionsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsOutput) SetEncodingType(v string) *ListObjectVersionsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectVersionsOutput) SetIsTruncated(v bool) *ListObjectVersionsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsOutput) SetKeyMarker(v string) *ListObjectVersionsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsOutput) SetMaxKeys(v int64) *ListObjectVersionsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectVersionsOutput) SetName(v string) *ListObjectVersionsOutput {
	s.Name = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListObjectVersionsOutput) SetNextKeyMarker(v string) *ListObjectVersionsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextVersionIdMarker sets the NextVersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetNextVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.NextVersionIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsOutput) SetPrefix(v string) *ListObjectVersionsOutput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.VersionIdMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListObjectVersionsOutput) SetVersions(v []*ObjectVersion) *ListObjectVersionsOutput {
	s.Versions = v
	return s
}

type ListObjectsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request. Bucket owners need not specify this parameter in their
	// requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsInput) SetBucket(v string) *ListObjectsInput {
	s.Bucket = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsInput) SetDelimiter(v string) *ListObjectsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsInput) SetEncodingType(v string) *ListObjectsInput {
	s.EncodingType = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsInput) SetMarker(v string) *ListObjectsInput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsInput) SetMaxKeys(v int64) *ListObjectsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsInput) SetPrefix(v string) *ListObjectsInput {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsInput) SetRequestPayer(v string) *ListObjectsInput {
	s.RequestPayer = &v
	return s
}

type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Contents []*Object `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	Marker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// When response is truncated (the IsTruncated element value in the response
	// is true), you can use the key name in this field as marker in the subsequent
	// request to get next set of objects. Amazon S3 lists objects in alphabetical
	// order Note: This element is returned only if you have delimiter request parameter
	// specified. If response does not include the NextMaker and it is truncated,
	// you can use the value of the last Key in the response as the marker in the
	// subsequent request to get the next set of object keys.
	NextMarker *string `type:"string"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsOutput {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsOutput) SetContents(v []*Object) *ListObjectsOutput {
	s.Contents = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsOutput) SetDelimiter(v string) *ListObjectsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsOutput) SetEncodingType(v string) *ListObjectsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsOutput) SetIsTruncated(v bool) *ListObjectsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsOutput) SetMarker(v string) *ListObjectsOutput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsOutput) SetMaxKeys(v int64) *ListObjectsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsOutput) SetName(v string) *ListObjectsOutput {
	s.Name = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListObjectsOutput) SetNextMarker(v string) *ListObjectsOutput {
	s.NextMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsOutput) SetPrefix(v string) *ListObjectsOutput {
	s.Prefix = &v
	return s
}

type ListObjectsV2Input struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to list.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The owner field is not present in listV2 by default, if you want to return
	// owner field with each key in the result then set the fetch owner field to
	// true
	FetchOwner *bool `location:"querystring" locationName:"fetch-owner" type:"boolean"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request in V2 style. Bucket owners need not specify this parameter
	// in their requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `location:"querystring" locationName:"start-after" type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsV2Input"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsV2Input) SetBucket(v string) *ListObjectsV2Input {
	s.Bucket = &v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Input) SetContinuationToken(v string) *ListObjectsV2Input {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Input) SetDelimiter(v string) *ListObjectsV2Input {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Input) SetEncodingType(v string) *ListObjectsV2Input {
	s.EncodingType = &v
	return s
}

// SetFetchOwner sets the FetchOwner field's value.
func (s *ListObjectsV2Input) SetFetchOwner(v bool) *ListObjectsV2Input {
	s.FetchOwner = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Input) SetMaxKeys(v int64) *ListObjectsV2Input {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Input) SetPrefix(v string) *ListObjectsV2Input {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsV2Input) SetRequestPayer(v string) *ListObjectsV2Input {
	s.RequestPayer = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Input) SetStartAfter(v string) *ListObjectsV2Input {
	s.StartAfter = &v
	return s
}

type ListObjectsV2Output struct {
	_ struct{} `type:"structure"`

	// CommonPrefixes contains all (if there are any) keys between Prefix and the
	// next occurrence of the string specified by delimiter
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Metadata about each object returned.
	Contents []*Object `type:"list" flattened:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	// KeyCount is the number of keys returned with this request. KeyCount will
	// always be less than equals to MaxKeys field. Say you ask for 50 keys, your
	// result will include less than equals 50 keys
	KeyCount *int64 `type:"integer"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `type:"integer"`

	// Name of the bucket to list.
	Name *string `type:"string"`

	// NextContinuationToken is sent when isTruncated is true which means there
	// are more keys in the bucket that can be listed. The next list requests to
	// Amazon S3 can be continued with this NextContinuationToken. NextContinuationToken
	// is obfuscated and is not a real key
	NextContinuationToken *string `type:"string"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `type:"string"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Output) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsV2Output) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsV2Output {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsV2Output) SetContents(v []*Object) *ListObjectsV2Output {
	s.Contents = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Output) SetContinuationToken(v string) *ListObjectsV2Output {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Output) SetDelimiter(v string) *ListObjectsV2Output {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Output) SetEncodingType(v string) *ListObjectsV2Output {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsV2Output) SetIsTruncated(v bool) *ListObjectsV2Output {
	s.IsTruncated = &v
	return s
}

// SetKeyCount sets the KeyCount field's value.
func (s *ListObjectsV2Output) SetKeyCount(v int64) *ListObjectsV2Output {
	s.KeyCount = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Output) SetMaxKeys(v int64) *ListObjectsV2Output {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsV2Output) SetName(v string) *ListObjectsV2Output {
	s.Name = &v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListObjectsV2Output) SetNextContinuationToken(v string) *ListObjectsV2Output {
	s.NextContinuationToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Output) SetPrefix(v string) *ListObjectsV2Output {
	s.Prefix = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Output) SetStartAfter(v string) *ListObjectsV2Output {
	s.StartAfter = &v
	return s
}

type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsInput) SetBucket(v string) *ListPartsInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListPartsInput) SetKey(v string) *ListPartsInput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsInput) SetMaxParts(v int64) *ListPartsInput {
	s.MaxParts = &v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsInput) SetPartNumberMarker(v int64) *ListPartsInput {
	s.PartNumberMarker = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListPartsInput) SetRequestPayer(v string) *ListPartsInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsInput) SetUploadId(v string) *ListPartsInput {
	s.UploadId = &v
	return s
}

type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	Owner *Owner `type:"structure"`

	// Part number after which listing begins.
	PartNumberMarker *int64 `type:"integer"`

	Parts []*Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *ListPartsOutput) SetAbortDate(v time.Time) *ListPartsOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *ListPartsOutput) SetAbortRuleId(v string) *ListPartsOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsOutput) SetBucket(v string) *ListPartsOutput {
	s.Bucket = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *ListPartsOutput) SetInitiator(v *Initiator) *ListPartsOutput {
	s.Initiator = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListPartsOutput) SetIsTruncated(v bool) *ListPartsOutput {
	s.IsTruncated = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListPartsOutput) SetKey(v string) *ListPartsOutput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsOutput) SetMaxParts(v int64) *ListPartsOutput {
	s.MaxParts = &v
	return s
}

// SetNextPartNumberMarker sets the NextPartNumberMarker field's value.
func (s *ListPartsOutput) SetNextPartNumberMarker(v int64) *ListPartsOutput {
	s.NextPartNumberMarker = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListPartsOutput) SetOwner(v *Owner) *ListPartsOutput {
	s.Owner = v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsOutput) SetPartNumberMarker(v int64) *ListPartsOutput {
	s.PartNumberMarker = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *ListPartsOutput) SetParts(v []*Part) *ListPartsOutput {
	s.Parts = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *ListPartsOutput) SetRequestCharged(v string) *ListPartsOutput {
	s.RequestCharged = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ListPartsOutput) SetStorageClass(v string) *ListPartsOutput {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsOutput) SetUploadId(v string) *ListPartsOutput {
	s.UploadId = &v
	return s
}

type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	TargetBucket *string `type:"string"`

	TargetGrants []*TargetGrant `locationNameList:"Grant" type:"list"`

	// This element lets you specify a prefix for the keys that the log files will
	// be stored under.
	TargetPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingEnabled) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingEnabled"}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetBucket sets the TargetBucket field's value.
func (s *LoggingEnabled) SetTargetBucket(v string) *LoggingEnabled {
	s.TargetBucket = &v
	return s
}

// SetTargetGrants sets the TargetGrants field's value.
func (s *LoggingEnabled) SetTargetGrants(v []*TargetGrant) *LoggingEnabled {
	s.TargetGrants = v
	return s
}

// SetTargetPrefix sets the TargetPrefix field's value.
func (s *LoggingEnabled) SetTargetPrefix(v string) *LoggingEnabled {
	s.TargetPrefix = &v
	return s
}

type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultipartUpload) GoString() string {
	return s.String()
}

// SetInitiated sets the Initiated field's value.
func (s *MultipartUpload) SetInitiated(v time.Time) *MultipartUpload {
	s.Initiated = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *MultipartUpload) SetInitiator(v *Initiator) *MultipartUpload {
	s.Initiator = v
	return s
}

// SetKey sets the Key field's value.
func (s *MultipartUpload) SetKey(v string) *MultipartUpload {
	s.Key = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *MultipartUpload) SetOwner(v *Owner) *MultipartUpload {
	s.Owner = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *MultipartUpload) SetStorageClass(v string) *MultipartUpload {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *MultipartUpload) SetUploadId(v string) *MultipartUpload {
	s.UploadId = &v
	return s
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionExpiration) SetNoncurrentDays(v int64) *NoncurrentVersionExpiration {
	s.NoncurrentDays = &v
	return s
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
// versioning-enabled (or versioning is suspended), you can set this action
// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
// or GLACIER storage class at a specific period in the object's lifetime.
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionTransition) SetNoncurrentDays(v int64) *NoncurrentVersionTransition {
	s.NoncurrentDays = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *NoncurrentVersionTransition) SetStorageClass(v string) *NoncurrentVersionTransition {
	s.StorageClass = &v
	return s
}

// Container for specifying the notification configuration of the bucket. If
// this element is empty, notifications are turned off on the bucket.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	LambdaFunctionConfigurations []*LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	QueueConfigurations []*QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	TopicConfigurations []*TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.LambdaFunctionConfigurations != nil {
		for i, v := range s.LambdaFunctionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigurations != nil {
		for i, v := range s.QueueConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurations != nil {
		for i, v := range s.TopicConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionConfigurations sets the LambdaFunctionConfigurations field's value.
func (s *NotificationConfiguration) SetLambdaFunctionConfigurations(v []*LambdaFunctionConfiguration) *NotificationConfiguration {
	s.LambdaFunctionConfigurations = v
	return s
}

// SetQueueConfigurations sets the QueueConfigurations field's value.
func (s *NotificationConfiguration) SetQueueConfigurations(v []*QueueConfiguration) *NotificationConfiguration {
	s.QueueConfigurations = v
	return s
}

// SetTopicConfigurations sets the TopicConfigurations field's value.
func (s *NotificationConfiguration) SetTopicConfigurations(v []*TopicConfiguration) *NotificationConfiguration {
	s.TopicConfigurations = v
	return s
}

type NotificationConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetCloudFunctionConfiguration sets the CloudFunctionConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetCloudFunctionConfiguration(v *CloudFunctionConfiguration) *NotificationConfigurationDeprecated {
	s.CloudFunctionConfiguration = v
	return s
}

// SetQueueConfiguration sets the QueueConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetQueueConfiguration(v *QueueConfigurationDeprecated) *NotificationConfigurationDeprecated {
	s.QueueConfiguration = v
	return s
}

// SetTopicConfiguration sets the TopicConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetTopicConfiguration(v *TopicConfigurationDeprecated) *NotificationConfigurationDeprecated {
	s.TopicConfiguration = v
	return s
}

// Container for object key name filtering rules. For information about key
// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// Container for object key name prefix and suffix filtering rules.
	Key *KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *NotificationConfigurationFilter) SetKey(v *KeyFilter) *NotificationConfigurationFilter {
	s.Key = v
	return s
}

type Object struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	Key *string `min:"1" type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectStorageClass"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Object) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Object) SetETag(v string) *Object {
	s.ETag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Object) SetKey(v string) *Object {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Object) SetLastModified(v time.Time) *Object {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Object) SetOwner(v *Owner) *Object {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *Object) SetSize(v int64) *Object {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Object) SetStorageClass(v string) *Object {
	s.StorageClass = &v
	return s
}

type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectIdentifier"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ObjectIdentifier) SetKey(v string) *ObjectIdentifier {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectIdentifier) SetVersionId(v string) *ObjectIdentifier {
	s.VersionId = &v
	return s
}

type ObjectVersion struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectVersionStorageClass"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectVersion) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *ObjectVersion) SetETag(v string) *ObjectVersion {
	s.ETag = &v
	return s
}

// SetIsLatest sets the IsLatest field's value.
func (s *ObjectVersion) SetIsLatest(v bool) *ObjectVersion {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ObjectVersion) SetKey(v string) *ObjectVersion {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ObjectVersion) SetLastModified(v time.Time) *ObjectVersion {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ObjectVersion) SetOwner(v *Owner) *ObjectVersion {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *ObjectVersion) SetSize(v int64) *ObjectVersion {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ObjectVersion) SetStorageClass(v string) *ObjectVersion {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectVersion) SetVersionId(v string) *ObjectVersion {
	s.VersionId = &v
	return s
}

type Owner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `type:"string"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Owner) SetDisplayName(v string) *Owner {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Owner) SetID(v string) *Owner {
	s.ID = &v
	return s
}

type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Part) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Part) SetETag(v string) *Part {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Part) SetLastModified(v time.Time) *Part {
	s.LastModified = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *Part) SetPartNumber(v int64) *Part {
	s.PartNumber = &v
	return s
}

// SetSize sets the Size field's value.
func (s *Part) SetSize(v int64) *Part {
	s.Size = &v
	return s
}

type PutBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AccelerateConfiguration"`

	// Specifies the Accelerate Configuration you want to set for the bucket.
	//
	// AccelerateConfiguration is a required field
	AccelerateConfiguration *AccelerateConfiguration `locationName:"AccelerateConfiguration" type:"structure" required:"true"`

	// Name of the bucket for which the accelerate configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAccelerateConfigurationInput"}
	if s.AccelerateConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AccelerateConfiguration"))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccelerateConfiguration sets the AccelerateConfiguration field's value.
func (s *PutBucketAccelerateConfigurationInput) SetAccelerateConfiguration(v *AccelerateConfiguration) *PutBucketAccelerateConfigurationInput {
	s.AccelerateConfiguration = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAccelerateConfigurationInput) SetBucket(v string) *PutBucketAccelerateConfigurationInput {
	s.Bucket = &v
	return s
}

type PutBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s PutBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutBucketAclInput) SetACL(v string) *PutBucketAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutBucketAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutBucketAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAclInput) SetBucket(v string) *PutBucketAclInput {
	s.Bucket = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutBucketAclInput) SetGrantFullControl(v string) *PutBucketAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutBucketAclInput) SetGrantRead(v string) *PutBucketAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutBucketAclInput) SetGrantReadACP(v string) *PutBucketAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutBucketAclInput) SetGrantWrite(v string) *PutBucketAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutBucketAclInput) SetGrantWriteACP(v string) *PutBucketAclInput {
	s.GrantWriteACP = &v
	return s
}

type PutBucketAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclOutput) GoString() string {
	return s.String()
}

type PutBucketCorsInput struct {
	_ struct{} `type:"structure" payload:"CORSConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// CORSConfiguration is a required field
	CORSConfiguration *CORSConfiguration `locationName:"CORSConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CORSConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSConfiguration"))
	}
	if s.CORSConfiguration != nil {
		if err := s.CORSConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CORSConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketCorsInput) SetBucket(v string) *PutBucketCorsInput {
	s.Bucket = &v
	return s
}

// SetCORSConfiguration sets the CORSConfiguration field's value.
func (s *PutBucketCorsInput) SetCORSConfiguration(v *CORSConfiguration) *PutBucketCorsInput {
	s.CORSConfiguration = v
	return s
}

type PutBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *BucketLifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleConfigurationInput) SetBucket(v string) *PutBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleConfigurationInput) SetLifecycleConfiguration(v *BucketLifecycleConfiguration) *PutBucketLifecycleConfigurationInput {
	s.LifecycleConfiguration = v
	return s
}

type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketLifecycleInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleInput) SetBucket(v string) *PutBucketLifecycleInput {
	s.Bucket = &v
	return s
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleInput) SetLifecycleConfiguration(v *LifecycleConfiguration) *PutBucketLifecycleInput {
	s.LifecycleConfiguration = v
	return s
}

type PutBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleOutput) GoString() string {
	return s.String()
}

type PutBucketLoggingInput struct {
	_ struct{} `type:"structure" payload:"BucketLoggingStatus"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// BucketLoggingStatus is a required field
	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.BucketLoggingStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketLoggingStatus"))
	}
	if s.BucketLoggingStatus != nil {
		if err := s.BucketLoggingStatus.Validate(); err != nil {
			invalidParams.AddNested("BucketLoggingStatus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLoggingInput) SetBucket(v string) *PutBucketLoggingInput {
	s.Bucket = &v
	return s
}

// SetBucketLoggingStatus sets the BucketLoggingStatus field's value.
func (s *PutBucketLoggingInput) SetBucketLoggingStatus(v *BucketLoggingStatus) *PutBucketLoggingInput {
	s.BucketLoggingStatus = v
	return s
}

type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingOutput) GoString() string {
	return s.String()
}

type PutBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for specifying the notification configuration of the bucket. If
	// this element is empty, notifications are turned off on the bucket.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `locationName:"NotificationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketNotificationConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.NotificationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationConfiguration"))
	}
	if s.NotificationConfiguration != nil {
		if err := s.NotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketNotificationConfigurationInput) SetBucket(v string) *PutBucketNotificationConfigurationInput {
	s.Bucket = &v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *PutBucketNotificationConfigurationInput) SetNotificationConfiguration(v *NotificationConfiguration) *PutBucketNotificationConfigurationInput {
	s.NotificationConfiguration = v
	return s
}

type PutBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationOutput) GoString() string {
	return s.String()
}

type PutBucketNotificationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfigurationDeprecated `locationName:"NotificationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketNotificationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.NotificationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketNotificationInput) SetBucket(v string) *PutBucketNotificationInput {
	s.Bucket = &v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *PutBucketNotificationInput) SetNotificationConfiguration(v *NotificationConfigurationDeprecated) *PutBucketNotificationInput {
	s.NotificationConfiguration = v
	return s
}

type PutBucketNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationOutput) GoString() string {
	return s.String()
}

type PutBucketPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketPolicyInput) SetBucket(v string) *PutBucketPolicyInput {
	s.Bucket = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutBucketPolicyInput) SetPolicy(v string) *PutBucketPolicyInput {
	s.Policy = &v
	return s
}

type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

type PutBucketReplicationInput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	//
	// ReplicationConfiguration is a required field
	ReplicationConfiguration *ReplicationConfiguration `locationName:"ReplicationConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.ReplicationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfiguration"))
	}
	if s.ReplicationConfiguration != nil {
		if err := s.ReplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ReplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketReplicationInput) SetBucket(v string) *PutBucketReplicationInput {
	s.Bucket = &v
	return s
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *PutBucketReplicationInput) SetReplicationConfiguration(v *ReplicationConfiguration) *PutBucketReplicationInput {
	s.ReplicationConfiguration = v
	return s
}

type PutBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationOutput) GoString() string {
	return s.String()
}

type PutBucketRequestPaymentInput struct {
	_ struct{} `type:"structure" payload:"RequestPaymentConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// RequestPaymentConfiguration is a required field
	RequestPaymentConfiguration *RequestPaymentConfiguration `locationName:"RequestPaymentConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketRequestPaymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketRequestPaymentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.RequestPaymentConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestPaymentConfiguration"))
	}
	if s.RequestPaymentConfiguration != nil {
		if err := s.RequestPaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RequestPaymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketRequestPaymentInput) SetBucket(v string) *PutBucketRequestPaymentInput {
	s.Bucket = &v
	return s
}

// SetRequestPaymentConfiguration sets the RequestPaymentConfiguration field's value.
func (s *PutBucketRequestPaymentInput) SetRequestPaymentConfiguration(v *RequestPaymentConfiguration) *PutBucketRequestPaymentInput {
	s.RequestPaymentConfiguration = v
	return s
}

type PutBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

type PutBucketTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketTaggingInput) SetBucket(v string) *PutBucketTaggingInput {
	s.Bucket = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutBucketTaggingInput) SetTagging(v *Tagging) *PutBucketTaggingInput {
	s.Tagging = v
	return s
}

type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

type PutBucketVersioningInput struct {
	_ struct{} `type:"structure" payload:"VersioningConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.VersioningConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketVersioningInput) SetBucket(v string) *PutBucketVersioningInput {
	s.Bucket = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *PutBucketVersioningInput) SetMFA(v string) *PutBucketVersioningInput {
	s.MFA = &v
	return s
}

// SetVersioningConfiguration sets the VersioningConfiguration field's value.
func (s *PutBucketVersioningInput) SetVersioningConfiguration(v *VersioningConfiguration) *PutBucketVersioningInput {
	s.VersioningConfiguration = v
	return s
}

type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

type PutBucketWebsiteInput struct {
	_ struct{} `type:"structure" payload:"WebsiteConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// WebsiteConfiguration is a required field
	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.WebsiteConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteConfiguration"))
	}
	if s.WebsiteConfiguration != nil {
		if err := s.WebsiteConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebsiteConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketWebsiteInput) SetBucket(v string) *PutBucketWebsiteInput {
	s.Bucket = &v
	return s
}

// SetWebsiteConfiguration sets the WebsiteConfiguration field's value.
func (s *PutBucketWebsiteInput) SetWebsiteConfiguration(v *WebsiteConfiguration) *PutBucketWebsiteInput {
	s.WebsiteConfiguration = v
	return s
}

type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteOutput) GoString() string {
	return s.String()
}

type PutObjectAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectAclInput) SetACL(v string) *PutObjectAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutObjectAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutObjectAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectAclInput) SetBucket(v string) *PutObjectAclInput {
	s.Bucket = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectAclInput) SetGrantFullControl(v string) *PutObjectAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectAclInput) SetGrantRead(v string) *PutObjectAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectAclInput) SetGrantReadACP(v string) *PutObjectAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutObjectAclInput) SetGrantWrite(v string) *PutObjectAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectAclInput) SetGrantWriteACP(v string) *PutObjectAclInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectAclInput) SetKey(v string) *PutObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectAclInput) SetRequestPayer(v string) *PutObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectAclInput) SetVersionId(v string) *PutObjectAclInput {
	s.VersionId = &v
	return s
}

type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectAclOutput) SetRequestCharged(v string) *PutObjectAclOutput {
	s.RequestCharged = &v
	return s
}

type PutObjectInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the PUT operation was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the PUT operation was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectInput) SetACL(v string) *PutObjectInput {
	s.ACL = &v
	return s
}

// SetBody sets the Body field's value.
func (s *PutObjectInput) SetBody(v io.ReadSeeker) *PutObjectInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectInput) SetBucket(v string) *PutObjectInput {
	s.Bucket = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *PutObjectInput) SetCacheControl(v string) *PutObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *PutObjectInput) SetContentDisposition(v string) *PutObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *PutObjectInput) SetContentEncoding(v string) *PutObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *PutObjectInput) SetContentLanguage(v string) *PutObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *PutObjectInput) SetContentLength(v int64) *PutObjectInput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PutObjectInput) SetContentType(v string) *PutObjectInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *PutObjectInput) SetExpires(v time.Time) *PutObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectInput) SetGrantFullControl(v string) *PutObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectInput) SetGrantRead(v string) *PutObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectInput) SetGrantReadACP(v string) *PutObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectInput) SetGrantWriteACP(v string) *PutObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectInput) SetKey(v string) *PutObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutObjectInput) SetMetadata(v map[string]*string) *PutObjectInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectInput) SetRequestPayer(v string) *PutObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectInput) SetSSECustomerAlgorithm(v string) *PutObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *PutObjectInput) SetSSECustomerKey(v string) *PutObjectInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectInput) SetSSECustomerKeyMD5(v string) *PutObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectInput) SetSSEKMSKeyId(v string) *PutObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectInput) SetServerSideEncryption(v string) *PutObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *PutObjectInput) SetStorageClass(v string) *PutObjectInput {
	s.StorageClass = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *PutObjectInput) SetWebsiteRedirectLocation(v string) *PutObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *PutObjectOutput) SetETag(v string) *PutObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *PutObjectOutput) SetExpiration(v string) *PutObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectOutput) SetRequestCharged(v string) *PutObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectOutput) SetSSECustomerAlgorithm(v string) *PutObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectOutput) SetSSECustomerKeyMD5(v string) *PutObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectOutput) SetSSEKMSKeyId(v string) *PutObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectOutput) SetServerSideEncryption(v string) *PutObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectOutput) SetVersionId(v string) *PutObjectOutput {
	s.VersionId = &v
	return s
}

// Container for specifying an configuration when you want Amazon S3 to publish
// events to an Amazon Simple Queue Service (Amazon SQS) queue.
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SQS queue ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// QueueArn is a required field
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueueConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueueConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.QueueArn == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *QueueConfiguration) SetEvents(v []*string) *QueueConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *QueueConfiguration) SetFilter(v *NotificationConfigurationFilter) *QueueConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *QueueConfiguration) SetId(v string) *QueueConfiguration {
	s.Id = &v
	return s
}

// SetQueueArn sets the QueueArn field's value.
func (s *QueueConfiguration) SetQueueArn(v string) *QueueConfiguration {
	s.QueueArn = &v
	return s
}

type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *QueueConfigurationDeprecated) SetEvent(v string) *QueueConfigurationDeprecated {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *QueueConfigurationDeprecated) SetEvents(v []*string) *QueueConfigurationDeprecated {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *QueueConfigurationDeprecated) SetId(v string) *QueueConfigurationDeprecated {
	s.Id = &v
	return s
}

// SetQueue sets the Queue field's value.
func (s *QueueConfigurationDeprecated) SetQueue(v string) *QueueConfigurationDeprecated {
	s.Queue = &v
	return s
}

type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the sibling is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Redirect) GoString() string {
	return s.String()
}

// SetHostName sets the HostName field's value.
func (s *Redirect) SetHostName(v string) *Redirect {
	s.HostName = &v
	return s
}

// SetHttpRedirectCode sets the HttpRedirectCode field's value.
func (s *Redirect) SetHttpRedirectCode(v string) *Redirect {
	s.HttpRedirectCode = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Redirect) SetProtocol(v string) *Redirect {
	s.Protocol = &v
	return s
}

// SetReplaceKeyPrefixWith sets the ReplaceKeyPrefixWith field's value.
func (s *Redirect) SetReplaceKeyPrefixWith(v string) *Redirect {
	s.ReplaceKeyPrefixWith = &v
	return s
}

// SetReplaceKeyWith sets the ReplaceKeyWith field's value.
func (s *Redirect) SetReplaceKeyWith(v string) *Redirect {
	s.ReplaceKeyWith = &v
	return s
}

type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests will be redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectAllRequestsTo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedirectAllRequestsTo"}
	if s.HostName == nil {
		invalidParams.Add(request.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostName sets the HostName field's value.
func (s *RedirectAllRequestsTo) SetHostName(v string) *RedirectAllRequestsTo {
	s.HostName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *RedirectAllRequestsTo) SetProtocol(v string) *RedirectAllRequestsTo {
	s.Protocol = &v
	return s
}

// Container for replication rules. You can add as many as 1,000 rules. Total
// replication configuration size can be up to 2 MB.
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating
	// the objects.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// Container for information about a particular replication rule. Replication
	// configuration must have at least one rule and can contain up to 1,000 rules.
	//
	// Rules is a required field
	Rules []*ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicationConfiguration"}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRole sets the Role field's value.
func (s *ReplicationConfiguration) SetRole(v string) *ReplicationConfiguration {
	s.Role = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ReplicationConfiguration) SetRules(v []*ReplicationRule) *ReplicationConfiguration {
	s.Rules = v
	return s
}

type ReplicationRule struct {
	_ struct{} `type:"structure"`

	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Object keyname prefix identifying one or more objects to which the rule applies.
	// Maximum prefix length can be up to 1,024 characters. Overlapping prefixes
	// are not supported.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// The rule is ignored if status is not Enabled.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ReplicationRuleStatus"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicationRule"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ReplicationRule) SetDestination(v *Destination) *ReplicationRule {
	s.Destination = v
	return s
}

// SetID sets the ID field's value.
func (s *ReplicationRule) SetID(v string) *ReplicationRule {
	s.ID = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ReplicationRule) SetPrefix(v string) *ReplicationRule {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationRule) SetStatus(v string) *ReplicationRule {
	s.Status = &v
	return s
}

type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	//
	// Payer is a required field
	Payer *string `type:"string" required:"true" enum:"Payer"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestPaymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPaymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestPaymentConfiguration"}
	if s.Payer == nil {
		invalidParams.Add(request.NewErrParamRequired("Payer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayer sets the Payer field's value.
func (s *RequestPaymentConfiguration) SetPayer(v string) *RequestPaymentConfiguration {
	s.Payer = &v
	return s
}

type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *RestoreObjectInput) SetBucket(v string) *RestoreObjectInput {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RestoreObjectInput) SetKey(v string) *RestoreObjectInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *RestoreObjectInput) SetRequestPayer(v string) *RestoreObjectInput {
	s.RequestPayer = &v
	return s
}

// SetRestoreRequest sets the RestoreRequest field's value.
func (s *RestoreObjectInput) SetRestoreRequest(v *RestoreRequest) *RestoreObjectInput {
	s.RestoreRequest = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *RestoreObjectInput) SetVersionId(v string) *RestoreObjectInput {
	s.VersionId = &v
	return s
}

type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *RestoreObjectOutput) SetRequestCharged(v string) *RestoreObjectOutput {
	s.RequestCharged = &v
	return s
}

type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days
	//
	// Days is a required field
	Days *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreRequest"}
	if s.Days == nil {
		invalidParams.Add(request.NewErrParamRequired("Days"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *RestoreRequest) SetDays(v int64) *RestoreRequest {
	s.Days = &v
	return s
}

type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoutingRule"}
	if s.Redirect == nil {
		invalidParams.Add(request.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *RoutingRule) SetCondition(v *Condition) *RoutingRule {
	s.Condition = v
	return s
}

// SetRedirect sets the Redirect field's value.
func (s *RoutingRule) SetRedirect(v *Redirect) *RoutingRule {
	s.Redirect = v
	return s
}

type Rule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
	// versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
	// or GLACIER storage class at a specific period in the object's lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *Rule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *Rule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *Rule) SetExpiration(v *LifecycleExpiration) *Rule {
	s.Expiration = v
	return s
}

// SetID sets the ID field's value.
func (s *Rule) SetID(v string) *Rule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *Rule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *Rule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransition sets the NoncurrentVersionTransition field's value.
func (s *Rule) SetNoncurrentVersionTransition(v *NoncurrentVersionTransition) *Rule {
	s.NoncurrentVersionTransition = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *Rule) SetPrefix(v string) *Rule {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Rule) SetStatus(v string) *Rule {
	s.Status = &v
	return s
}

// SetTransition sets the Transition field's value.
func (s *Rule) SetTransition(v *Transition) *Rule {
	s.Transition = v
	return s
}

type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type Tagging struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tagging"}
	if s.TagSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *Tagging) SetTagSet(v []*Tag) *Tagging {
	s.TagSet = v
	return s
}

type TargetGrant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission *string `type:"string" enum:"BucketLogsPermission"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *TargetGrant) SetGrantee(v *Grantee) *TargetGrant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *TargetGrant) SetPermission(v string) *TargetGrant {
	s.Permission = &v
	return s
}

// Container for specifying the configuration when you want Amazon S3 to publish
// events to an Amazon Simple Notification Service (Amazon SNS) topic.
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *TopicConfiguration) SetEvents(v []*string) *TopicConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *TopicConfiguration) SetFilter(v *NotificationConfigurationFilter) *TopicConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *TopicConfiguration) SetId(v string) *TopicConfiguration {
	s.Id = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *TopicConfiguration) SetTopicArn(v string) *TopicConfiguration {
	s.TopicArn = &v
	return s
}

type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *TopicConfigurationDeprecated) SetEvent(v string) *TopicConfigurationDeprecated {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *TopicConfigurationDeprecated) SetEvents(v []*string) *TopicConfigurationDeprecated {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *TopicConfigurationDeprecated) SetId(v string) *TopicConfigurationDeprecated {
	s.Id = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *TopicConfigurationDeprecated) SetTopic(v string) *TopicConfigurationDeprecated {
	s.Topic = &v
	return s
}

type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Transition) SetDate(v time.Time) *Transition {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *Transition) SetDays(v int64) *Transition {
	s.Days = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Transition) SetStorageClass(v string) *Transition {
	s.StorageClass = &v
	return s
}

type UploadPartCopyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// The range of bytes to copy from the source object. The range value must use
	// the form bytes=first-last, where the first and last are the zero-based byte
	// offsets to copy. For example, bytes=0-9 indicates that you want to copy the
	// first ten bytes of the source. You can copy a range only if the source object
	// is greater than 5 GB.
	CopySourceRange *string `location:"header" locationName:"x-amz-copy-source-range" type:"string"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being copied. This is a positive integer between 1 and
	// 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being copied.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartCopyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartCopyInput) SetBucket(v string) *UploadPartCopyInput {
	s.Bucket = &v
	return s
}

// SetCopySource sets the CopySource field's value.
func (s *UploadPartCopyInput) SetCopySource(v string) *UploadPartCopyInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfModifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfNoneMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfUnmodifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceRange sets the CopySourceRange field's value.
func (s *UploadPartCopyInput) SetCopySourceRange(v string) *UploadPartCopyInput {
	s.CopySourceRange = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKey(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartCopyInput) SetKey(v string) *UploadPartCopyInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartCopyInput) SetPartNumber(v int64) *UploadPartCopyInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartCopyInput) SetRequestPayer(v string) *UploadPartCopyInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartCopyInput) SetSSECustomerKey(v string) *UploadPartCopyInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartCopyInput) SetUploadId(v string) *UploadPartCopyInput {
	s.UploadId = &v
	return s
}

type UploadPartCopyOutput struct {
	_ struct{} `type:"structure" payload:"CopyPartResult"`

	CopyPartResult *CopyPartResult `type:"structure"`

	// The version of the source object that was copied, if you have enabled versioning
	// on the source bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyOutput) GoString() string {
	return s.String()
}

// SetCopyPartResult sets the CopyPartResult field's value.
func (s *UploadPartCopyOutput) SetCopyPartResult(v *CopyPartResult) *UploadPartCopyOutput {
	s.CopyPartResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *UploadPartCopyOutput) SetCopySourceVersionId(v string) *UploadPartCopyOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartCopyOutput) SetRequestCharged(v string) *UploadPartCopyOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyOutput) SetSSECustomerAlgorithm(v string) *UploadPartCopyOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyOutput) SetSSECustomerKeyMD5(v string) *UploadPartCopyOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartCopyOutput) SetSSEKMSKeyId(v string) *UploadPartCopyOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartCopyOutput) SetServerSideEncryption(v string) *UploadPartCopyOutput {
	s.ServerSideEncryption = &v
	return s
}

type UploadPartInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the multipart upload was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being uploaded. This is a positive integer between 1
	// and 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being uploaded.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *UploadPartInput) SetBody(v io.ReadSeeker) *UploadPartInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartInput) SetBucket(v string) *UploadPartInput {
	s.Bucket = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *UploadPartInput) SetContentLength(v int64) *UploadPartInput {
	s.ContentLength = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartInput) SetKey(v string) *UploadPartInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartInput) SetPartNumber(v int64) *UploadPartInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartInput) SetRequestPayer(v string) *UploadPartInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartInput) SetSSECustomerAlgorithm(v string) *UploadPartInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartInput) SetSSECustomerKey(v string) *UploadPartInput {
	s.SSECustomerKey = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartInput) SetSSECustomerKeyMD5(v string) *UploadPartInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartInput) SetUploadId(v string) *UploadPartInput {
	s.UploadId = &v
	return s
}

type UploadPartOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UploadPartOutput) SetETag(v string) *UploadPartOutput {
	s.ETag = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartOutput) SetRequestCharged(v string) *UploadPartOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartOutput) SetSSECustomerAlgorithm(v string) *UploadPartOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartOutput) SetSSECustomerKeyMD5(v string) *UploadPartOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartOutput) SetSSEKMSKeyId(v string) *UploadPartOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartOutput) SetServerSideEncryption(v string) *UploadPartOutput {
	s.ServerSideEncryption = &v
	return s
}

type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADelete"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersioningConfiguration) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *VersioningConfiguration) SetMFADelete(v string) *VersioningConfiguration {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VersioningConfiguration) SetStatus(v string) *VersioningConfiguration {
	s.Status = &v
	return s
}

type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *WebsiteConfiguration) SetErrorDocument(v *ErrorDocument) *WebsiteConfiguration {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *WebsiteConfiguration) SetIndexDocument(v *IndexDocument) *WebsiteConfiguration {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *WebsiteConfiguration) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *WebsiteConfiguration {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *WebsiteConfiguration) SetRoutingRules(v []*RoutingRule) *WebsiteConfiguration {
	s.RoutingRules = v
	return s
}

const (
	// BucketAccelerateStatusEnabled is a BucketAccelerateStatus enum value
	BucketAccelerateStatusEnabled = "Enabled"

	// BucketAccelerateStatusSuspended is a BucketAccelerateStatus enum value
	BucketAccelerateStatusSuspended = "Suspended"
)

const (
	// BucketCannedACLPrivate is a BucketCannedACL enum value
	BucketCannedACLPrivate = "private"

	// BucketCannedACLPublicRead is a BucketCannedACL enum value
	BucketCannedACLPublicRead = "public-read"

	// BucketCannedACLPublicReadWrite is a BucketCannedACL enum value
	BucketCannedACLPublicReadWrite = "public-read-write"

	// BucketCannedACLAuthenticatedRead is a BucketCannedACL enum value
	BucketCannedACLAuthenticatedRead = "authenticated-read"
)

const (
	// BucketLocationConstraintEu is a BucketLocationConstraint enum value
	BucketLocationConstraintEu = "EU"

	// BucketLocationConstraintEuWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuWest1 = "eu-west-1"

	// BucketLocationConstraintUsWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest1 = "us-west-1"

	// BucketLocationConstraintUsWest2 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest2 = "us-west-2"

	// BucketLocationConstraintApSouth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSouth1 = "ap-south-1"

	// BucketLocationConstraintApSoutheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"

	// BucketLocationConstraintApSoutheast2 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"

	// BucketLocationConstraintApNortheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"

	// BucketLocationConstraintSaEast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintSaEast1 = "sa-east-1"

	// BucketLocationConstraintCnNorth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintCnNorth1 = "cn-north-1"

	// BucketLocationConstraintEuCentral1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuCentral1 = "eu-central-1"
)

const (
	// BucketLogsPermissionFullControl is a BucketLogsPermission enum value
	BucketLogsPermissionFullControl = "FULL_CONTROL"

	// BucketLogsPermissionRead is a BucketLogsPermission enum value
	BucketLogsPermissionRead = "READ"

	// BucketLogsPermissionWrite is a BucketLogsPermission enum value
	BucketLogsPermissionWrite = "WRITE"
)

const (
	// BucketVersioningStatusEnabled is a BucketVersioningStatus enum value
	BucketVersioningStatusEnabled = "Enabled"

	// BucketVersioningStatusSuspended is a BucketVersioningStatus enum value
	BucketVersioningStatusSuspended = "Suspended"
)

// Requests Amazon S3 to encode the object keys in the response and specifies
// the encoding method to use. An object key may contain any Unicode character;
// however, XML 1.0 parser cannot parse some characters, such as characters
// with an ASCII value from 0 to 10. For characters that are not supported in
// XML 1.0, you can add this parameter to request that Amazon S3 encode the
// keys in the response.
const (
	// EncodingTypeUrl is a EncodingType enum value
	EncodingTypeUrl = "url"
)

// Bucket event for which to send notifications.
const (
	// EventS3ReducedRedundancyLostObject is a Event enum value
	EventS3ReducedRedundancyLostObject = "s3:ReducedRedundancyLostObject"

	// EventS3ObjectCreated is a Event enum value
	EventS3ObjectCreated = "s3:ObjectCreated:*"

	// EventS3ObjectCreatedPut is a Event enum value
	EventS3ObjectCreatedPut = "s3:ObjectCreated:Put"

	// EventS3ObjectCreatedPost is a Event enum value
	EventS3ObjectCreatedPost = "s3:ObjectCreated:Post"

	// EventS3ObjectCreatedCopy is a Event enum value
	EventS3ObjectCreatedCopy = "s3:ObjectCreated:Copy"

	// EventS3ObjectCreatedCompleteMultipartUpload is a Event enum value
	EventS3ObjectCreatedCompleteMultipartUpload = "s3:ObjectCreated:CompleteMultipartUpload"

	// EventS3ObjectRemoved is a Event enum value
	EventS3ObjectRemoved = "s3:ObjectRemoved:*"

	// EventS3ObjectRemovedDelete is a Event enum value
	EventS3ObjectRemovedDelete = "s3:ObjectRemoved:Delete"

	// EventS3ObjectRemovedDeleteMarkerCreated is a Event enum value
	EventS3ObjectRemovedDeleteMarkerCreated = "s3:ObjectRemoved:DeleteMarkerCreated"
)

const (
	// ExpirationStatusEnabled is a ExpirationStatus enum value
	ExpirationStatusEnabled = "Enabled"

	// ExpirationStatusDisabled is a ExpirationStatus enum value
	ExpirationStatusDisabled = "Disabled"
)

const (
	// FilterRuleNamePrefix is a FilterRuleName enum value
	FilterRuleNamePrefix = "prefix"

	// FilterRuleNameSuffix is a FilterRuleName enum value
	FilterRuleNameSuffix = "suffix"
)

const (
	// MFADeleteEnabled is a MFADelete enum value
	MFADeleteEnabled = "Enabled"

	// MFADeleteDisabled is a MFADelete enum value
	MFADeleteDisabled = "Disabled"
)

const (
	// MFADeleteStatusEnabled is a MFADeleteStatus enum value
	MFADeleteStatusEnabled = "Enabled"

	// MFADeleteStatusDisabled is a MFADeleteStatus enum value
	MFADeleteStatusDisabled = "Disabled"
)

const (
	// MetadataDirectiveCopy is a MetadataDirective enum value
	MetadataDirectiveCopy = "COPY"

	// MetadataDirectiveReplace is a MetadataDirective enum value
	MetadataDirectiveReplace = "REPLACE"
)

const (
	// ObjectCannedACLPrivate is a ObjectCannedACL enum value
	ObjectCannedACLPrivate = "private"

	// ObjectCannedACLPublicRead is a ObjectCannedACL enum value
	ObjectCannedACLPublicRead = "public-read"

	// ObjectCannedACLPublicReadWrite is a ObjectCannedACL enum value
	ObjectCannedACLPublicReadWrite = "public-read-write"

	// ObjectCannedACLAuthenticatedRead is a ObjectCannedACL enum value
	ObjectCannedACLAuthenticatedRead = "authenticated-read"

	// ObjectCannedACLAwsExecRead is a ObjectCannedACL enum value
	ObjectCannedACLAwsExecRead = "aws-exec-read"

	// ObjectCannedACLBucketOwnerRead is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerRead = "bucket-owner-read"

	// ObjectCannedACLBucketOwnerFullControl is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerFullControl = "bucket-owner-full-control"
)

const (
	// ObjectStorageClassStandard is a ObjectStorageClass enum value
	ObjectStorageClassStandard = "STANDARD"

	// ObjectStorageClassReducedRedundancy is a ObjectStorageClass enum value
	ObjectStorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// ObjectStorageClassGlacier is a ObjectStorageClass enum value
	ObjectStorageClassGlacier = "GLACIER"
)

const (
	// ObjectVersionStorageClassStandard is a ObjectVersionStorageClass enum value
	ObjectVersionStorageClassStandard = "STANDARD"
)

const (
	// PayerRequester is a Payer enum value
	PayerRequester = "Requester"

	// PayerBucketOwner is a Payer enum value
	PayerBucketOwner = "BucketOwner"
)

const (
	// PermissionFullControl is a Permission enum value
	PermissionFullControl = "FULL_CONTROL"

	// PermissionWrite is a Permission enum value
	PermissionWrite = "WRITE"

	// PermissionWriteAcp is a Permission enum value
	PermissionWriteAcp = "WRITE_ACP"

	// PermissionRead is a Permission enum value
	PermissionRead = "READ"

	// PermissionReadAcp is a Permission enum value
	PermissionReadAcp = "READ_ACP"
)

const (
	// ProtocolHttp is a Protocol enum value
	ProtocolHttp = "http"

	// ProtocolHttps is a Protocol enum value
	ProtocolHttps = "https"
)

const (
	// ReplicationRuleStatusEnabled is a ReplicationRuleStatus enum value
	ReplicationRuleStatusEnabled = "Enabled"

	// ReplicationRuleStatusDisabled is a ReplicationRuleStatus enum value
	ReplicationRuleStatusDisabled = "Disabled"
)

const (
	// ReplicationStatusComplete is a ReplicationStatus enum value
	ReplicationStatusComplete = "COMPLETE"

	// ReplicationStatusPending is a ReplicationStatus enum value
	ReplicationStatusPending = "PENDING"

	// ReplicationStatusFailed is a ReplicationStatus enum value
	ReplicationStatusFailed = "FAILED"

	// ReplicationStatusReplica is a ReplicationStatus enum value
	ReplicationStatusReplica = "REPLICA"
)

// If present, indicates that the requester was successfully charged for the
// request.
const (
	// RequestChargedRequester is a RequestCharged enum value
	RequestChargedRequester = "requester"
)

// Confirms that the requester knows that she or he will be charged for the
// request. Bucket owners need not specify this parameter in their requests.
// Documentation on downloading objects from requester pays buckets can be found
// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
const (
	// RequestPayerRequester is a RequestPayer enum value
	RequestPayerRequester = "requester"
)

const (
	// ServerSideEncryptionAes256 is a ServerSideEncryption enum value
	ServerSideEncryptionAes256 = "AES256"

	// ServerSideEncryptionAwsKms is a ServerSideEncryption enum value
	ServerSideEncryptionAwsKms = "aws:kms"
)

const (
	// StorageClassStandard is a StorageClass enum value
	StorageClassStandard = "STANDARD"

	// StorageClassReducedRedundancy is a StorageClass enum value
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"
)

const (
	// TransitionStorageClassGlacier is a TransitionStorageClass enum value
	TransitionStorageClassGlacier = "GLACIER"

	// TransitionStorageClassStandardIa is a TransitionStorageClass enum value
	TransitionStorageClassStandardIa = "STANDARD_IA"
)

const (
	// TypeCanonicalUser is a Type enum value
	TypeCanonicalUser = "CanonicalUser"

	// TypeAmazonCustomerByEmail is a Type enum value
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"

	// TypeGroup is a Type enum value
	TypeGroup = "Group"
)
