// This file was generated by go generate; DO NOT EDIT

package display

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "30"

// Version is deprecated. Use CLDRVersion.
const Version = "30"

var parents = [252]int16{
	// Entry 0 - 3F
	-1, -1, -1, -1, -1, 4, 4, 4,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, 19, -1, 21, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, 36, 36, 36,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, 48, 48, 48, -1, -1, 53, 54,
	54, 54, 54, 54, 54, 54, 54, 54,
	// Entry 40 - 7F
	54, 54, 54, 54, 54, 54, 54, 54,
	54, -1, -1, -1, -1, 76, -1, -1,
	-1, -1, -1, 82, 82, 82, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, 124, -1, -1,
	// Entry 80 - BF
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, 178, -1, -1, -1, -1,
	183, -1, -1, 186, -1, -1, -1, -1,
	// Entry C0 - FF
	-1, -1, 193, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	207, 207, 207, -1, 211, 211, 211, -1,
	215, -1, 217, 217, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, -1, -1, -1,
	231, -1, -1, -1, -1, -1, -1, -1,
	-1, -1, -1, -1, -1, 244, -1, -1,
	-1, -1, 249, -1,
}

// Number of keys: 612
var (
	langIndex = tagIndex{
		"aaabaeafakamanarasavayazbabebgbibmbnbobrbscacechcocrcscucvcydadedvdzeeel" +
			"eneoeseteufafffifjfofrfygagdglgngugvhahehihohrhthuhyhziaidieigiiikio" +
			"isitiujajvkakgkikjkkklkmknkokrkskukvkwkylalblglilnloltlulvmgmhmimkml" +
			"mnmrmsmtmynandnengnlnnnonrnvnyocojomorospapiplpsptqurmrnrorurwsascsd" +
			"sesgsiskslsmsnsosqsrssstsusvswtatetgthtitktntotrtstttyugukuruzvevivo" +
			"wawoxhyiyozazhzu",
		"aceachadaadyaebafhagqainakkakzalealnaltanganparcarnaroarparqarsarwaryarz" +
			"asaaseastavkawabalbanbarbasbaxbbcbbjbejbembewbezbfdbfqbgnbhobikbinbj" +
			"nbkmblabpybqibrabrhbrxbssbuabugbumbynbyvcadcarcaycchcebcggchbchgchkc" +
			"hmchnchochpchrchyckbcopcpscrhcrscsbdakdardavdeldendgrdindjedoidsbdtp" +
			"duadumdyodyudzgebuefieglegyekaelxenmesuewoextfanfilfitfonfrcfrmfrofr" +
			"pfrrfrsfurgaagaggangaygbagbzgezgilglkgmhgohgomgongorgotgrbgrcgswgucg" +
			"urguzgwihaihakhawhifhilhithmnhsbhsnhupibaibbiloinhizhjamjbojgojmcjpr" +
			"jrbjutkaakabkackajkamkawkbdkblkcgkdekeakenkfokgpkhakhokhqkhwkiukkjkl" +
			"nkmbkoikokkoskpekrckrikrjkrlkruksbksfkshkumkutladlaglahlamlezlfnlijl" +
			"ivlktlmolollozlrcltglualuilunluolusluylzhlzzmadmafmagmaimakmanmasmde" +
			"mdfmdrmenmermfemgamghmgomicminmncmnimohmosmrjmuamulmusmwlmwrmwvmyemy" +
			"vmznnannapnaqndsnewnianiunjonmgnnhnognonnovnqonsonusnwcnymnynnyonzio" +
			"saotapagpalpampappaupcdpcmpdcpdtpeopflphnpmspntponprgproqucqugrajrap" +
			"rarrgnrifrofromrtmruerugruprwksadsahsamsaqsassatsazsbasbpscnscosdcsd" +
			"hseesehseiselsessgasgsshishnshusidslislysmasmjsmnsmssnksogsrnsrrssys" +
			"tqsuksussuxswbsycsyrszltcytemteotertettigtivtkltkrtlhtlitlytmhtogtpi" +
			"trutrvtsdtsittttumtvltwqtyvtzmudmugaumbundvaivecvepvlsvmfvotvrovunwa" +
			"ewalwarwaswbpwuuxalxmfxogyaoyapyavybbyrlyuezapzblzeazenzghzunzxxzza",
		"",
	}
	langTagsLong = []string{ // 23 elements
		"ar-001",
		"az-Arab",
		"de-AT",
		"de-CH",
		"en-AU",
		"en-CA",
		"en-GB",
		"en-US",
		"es-419",
		"es-ES",
		"es-MX",
		"fa-AF",
		"fr-CA",
		"fr-CH",
		"nds-NL",
		"nl-BE",
		"pt-BR",
		"pt-PT",
		"ro-MD",
		"sr-Latn",
		"sw-CD",
		"zh-Hans",
		"zh-Hant",
	}
)

var langHeaders = [252]header{
	{ // af
		afLangStr,
		afLangIdx,
	},
	{ // agq
		"AkanÀmalìÀlabìBɛ̀làlusànBùugɨlìaBɨ̀ŋgalìChɛ̂Dzamɛ̀Gɨ̀lêʔKɨŋgeleSɨ̀kpanìs" +
			"KpɛɛshìaKɨ̀fàlàŋsiKɨtsɔŋkaŋEndìHɔŋgalìaÈndònɛshìaEgbòÈtalìaDzàkpànêD" +
			"zàbvànêKɨmɛ̀kùulîaMàlaeBùumɛsɛ̀Nɛ̀kpalìDɔ̂sKpuwndzabìKpɔlìsKpotùwgîi" +
			"LùmanyìaLushìaLùwandàSòmalìSuedìsTamìTàeTʉʉkìsÙkɛlɛnìaUudùwVìyɛtnàmê" +
			"YulùbaChàenêZulùAghem",
		[]uint16{ // 188 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0020, 0x002b,
			0x002b, 0x002b, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0045, 0x0045, 0x0045, 0x0045, 0x004f, 0x0058, 0x0058, 0x0064,
			0x0064, 0x0064, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x007e,
			0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x008b,
			0x008b, 0x0090, 0x0090, 0x0090, 0x0090, 0x009b, 0x009b, 0x009b,
			// Entry 40 - 7F
			0x009b, 0x00a9, 0x00a9, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b6, 0x00b6, 0x00c1, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d4, 0x00d4, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00e2, 0x00e2, 0x00ee, 0x00ee, 0x00ee,
			0x00f9, 0x00f9, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x010a, 0x010a, 0x0112,
			// Entry 80 - BF
			0x0112, 0x011d, 0x011d, 0x011d, 0x011d, 0x0127, 0x012e, 0x0137,
			0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0146, 0x0146, 0x014b, 0x014b, 0x014b, 0x014f, 0x014f, 0x014f,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0164,
			0x016a, 0x016a, 0x016a, 0x0177, 0x0177, 0x0177, 0x0177, 0x0177,
			0x0177, 0x017e, 0x017e, 0x0186, 0x018b, 0x018b, 0x018b, 0x018b,
			0x018b, 0x018b, 0x018b, 0x0190,
		},
	},
	{ // ak
		"AkanAmarikArabikBelarus kasaBɔlgeria kasaBengali kasaKyɛk kasaGyaamanGre" +
			"ek kasaBorɔfoSpain kasaPɛɛhyia kasaFrɛnkyeHausaHindiHangri kasaIndon" +
			"ihyia kasaIgboItaly kasaGyapan kasaGyabanis kasaKambodia kasaKorea k" +
			"asaMalay kasaBɛɛmis kasaNɛpal kasaDɛɛkyePungyabi kasaPɔland kasaPɔɔt" +
			"ugal kasaRomenia kasaRahyia kasaRewanda kasaSomalia kasaSweden kasaT" +
			"amil kasaTaeland kasaTɛɛki kasaUkren kasaUrdu kasaViɛtnam kasaYoruba" +
			"Kyaena kasaZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x001c, 0x002a,
			0x002a, 0x002a, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0036, 0x0036, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0051, 0x0058, 0x0058, 0x0062,
			0x0062, 0x0062, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x007d,
			0x007d, 0x0082, 0x0082, 0x0082, 0x0082, 0x008d, 0x008d, 0x008d,
			// Entry 40 - 7F
			0x008d, 0x009c, 0x009c, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0,
			0x00aa, 0x00aa, 0x00b5, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00cf, 0x00cf, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00f0, 0x00f0, 0x00f0,
			0x00fb, 0x00fb, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103,
			0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0110, 0x0110, 0x011c,
			// Entry 80 - BF
			0x011c, 0x012b, 0x012b, 0x012b, 0x012b, 0x0137, 0x0142, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x0165, 0x0165, 0x016f, 0x016f, 0x016f, 0x017b, 0x017b, 0x017b,
			0x017b, 0x017b, 0x0187, 0x0187, 0x0187, 0x0187, 0x0187, 0x0191,
			0x019a, 0x019a, 0x019a, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01ad, 0x01ad, 0x01b8, 0x01bc,
		},
	},
	{ // am
		amLangStr,
		amLangIdx,
	},
	{ // ar
		arLangStr,
		arLangIdx,
	},
	{ // ar-EG
		"الدنماركية",
		[]uint16{ // 32 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014,
		},
	},
	{ // ar-LY
		"الغورانيةاللاووالسواحيليةالتيغرينيةالمابودونجونيةصوربيا العلياسامي الجنو" +
			"بيةالكرواتية الصربيةالسواحيلية الكونغولية",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			// Entry 40 - 7F
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			// Entry 80 - BF
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			// Entry C0 - FF
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			// Entry 100 - 13F
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			// Entry 140 - 17F
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			// Entry 180 - 1BF
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			// Entry 1C0 - 1FF
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b,
			// Entry 200 - 23F
			0x007b, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			// Entry 240 - 27F
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x00b5, 0x00de,
		},
	},
	{ // ar-SA
		"الغورانيةاللاووالأوريةالسواحيليةالتيغرينيةالمابودونجونيةصوربيا العلياسام" +
			"ي الجنوبيةالكرواتية الصربيةالسواحيلية الكونغولية",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			// Entry 40 - 7F
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e,
			0x001e, 0x001e, 0x001e, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			// Entry 80 - BF
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			// Entry C0 - FF
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			// Entry 100 - 13F
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			// Entry 140 - 17F
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 180 - 1BF
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 1C0 - 1FF
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 200 - 23F
			0x0089, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			// Entry 240 - 27F
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00c3, 0x00ec,
		},
	},
	{ // as
		"অসমীয়া",
		[]uint16{ // 10 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0015,
		},
	},
	{ // asa
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKichekiKijerumaniKigiri" +
			"kiKiingeredhaKihithpaniaKiajemiKifaranthaKihauthaKihindiKihungariKii" +
			"ndonethiaKiigboKiitaliaanoKijapaniKijavaKikambodiaKikoreaKimalesiaKi" +
			"burmaKinepaliKiholandhiKipunjabiKipolandiKirenoKiromaniaKiruthiKinya" +
			"randwaKithomaliKithwidiKitamilKitailandiKiturukiKiukraniaKiurduKivie" +
			"tinamuKiyorubaKichinaKidhuluKipare",
		[]uint16{ // 206 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0042, 0x0042, 0x0042, 0x0042, 0x004a, 0x0055, 0x0055, 0x0060,
			0x0060, 0x0060, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0071,
			0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0079,
			0x0079, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089, 0x0089, 0x0089,
			// Entry 40 - 7F
			0x0089, 0x0095, 0x0095, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x00a6, 0x00a6, 0x00ae, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00be, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00ce, 0x00ce, 0x00d5, 0x00d5, 0x00d5,
			0x00dd, 0x00dd, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00f0, 0x00f0, 0x00f9,
			// Entry 80 - BF
			0x00f9, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x0108, 0x010f, 0x011a,
			0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x011a, 0x011a, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123,
			0x012b, 0x012b, 0x0132, 0x0132, 0x0132, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0144, 0x0144, 0x0144, 0x0144, 0x0144, 0x014d,
			0x0153, 0x0153, 0x0153, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x015e, 0x0166, 0x0166, 0x016d, 0x0174, 0x0174, 0x0174, 0x0174,
			0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174,
			// Entry C0 - FF
			0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x0174,
			0x0174, 0x0174, 0x0174, 0x0174, 0x0174, 0x017a,
		},
	},
	{ // ast
		"afarabkhazianuavestanínafrikaansakanamháricuaragonésárabeasamésaváricuay" +
			"maraazerbaixanubashkirbielorrusubúlgarubislamabambarabengalíntibetan" +
			"ubretónbosniucatalánchechenuchamorrocorsucreechecueslávicu eclesiást" +
			"icuchuvashgalésdanésalemándivehidzongkhaewegrieguinglésesperantoespa" +
			"ñolestoniuvascupersafulahfinlandésfixanuferoésfrancésfrisón occiden" +
			"talirlandésgaélicu escocésgalleguguaraníguyaratímanésḥausahebréuhind" +
			"ihiri motucroatahaitianuhúngaruarmeniuhererointerlinguaindonesiuinte" +
			"rlingueigboyi de Sichuáninupiaqidoislandésitalianuinuktitutxaponésxa" +
			"vanésxeorxanukongokikuyukuanyamakazaquistanínkalaallisutḥemercanarés" +
			"coreanukanuricachemiréscurdukomicórnicukirguistanínllatínluxemburgué" +
			"sgandalimburguéslingalalaosianulituanuluba-katangaletónmalgaxemarsha" +
			"llésmaorímacedoniumalayalammongolmarathimalayumaltésbirmanunaurundeb" +
			"ele del nortenepalésndonganeerlandésnoruegu Nynorsknoruegu Bokmålnde" +
			"bele del surnavajonyanjaoccitanuojibwaoromooriyaoséticupunyabípalipo" +
			"lacupashtuportuguésquechuaromancherundirumanurusukinyarwandasánscrit" +
			"usardusindhisami del nortesangocingaléseslovacueslovenusamoanushonas" +
			"omalínalbanuserbiuswatisotho del sursondanéssuecusuaḥilitamiltelugut" +
			"axiquistaníntailandéstigrinyaturcomanutswanatonganuturcutsongatártar" +
			"utahitianuuigurucraínurduuzbequistanínvendavietnamínvolapükvalónwolo" +
			"fxhosayiddishyorubazhuangchinuzulúachinésacoliadangmeadygheárabe de " +
			"Túnezafrihiliaghemainuacadianualabamaaleutgheg d’Albaniaaltai del su" +
			"ringlés antiguuangikaaraméumapuchearaonaarapahoárabe d’Arxeliaarawak" +
			"árabe de Marruecosárabe d’Exiptuasullingua de signos americanaastur" +
			"ianukotavaawadhibaluchibalinésbávarubasaabamunbatak tobaghomalabejab" +
			"embabetawibenabafutbadagabalochi occidentalbhojpuribikolbinibanjarko" +
			"msiksikabishnupriyabakhtiaribrajbrahuibodoakooseburiatbuginésbulubli" +
			"nmedumbacaddocaribecayugaatsamcebuanuchigachibchachagataichuukésmari" +
			"xíriga chinookchoctawchipewyanucheroquicheyennekurdu centralcópticuc" +
			"apiznonturcu de Crimeafrancés criollu seselwakashubianudakotadargwat" +
			"aitadelawareslavedogribdinkazarmadogribaxu sorbiudusun centraldualan" +
			"eerlandés mediujola-fonyidyuladazagaembúefikemilianuexipciu antiguue" +
			"kajukelamitainglés mediuyupik centralewondoestremeñufangfilipínfinla" +
			"ndés de Tornedalenfonfrancés cajunfrancés mediufrancés antiguuarpita" +
			"nufrisón del nortefrisón orientalfriulianugagagauzchinu gangayogbaya" +
			"dari zoroastrianugeezgilbertésgilakialtualemán mediualtualemán antig" +
			"uugoan konkanigondigorontalogóticugrebogriegu antiguualemán de Suiza" +
			"wayuufrafragusiigwichʼinhaidachinu hakkahawaianuhindi de Fijihiligay" +
			"nonhititahmongaltu sorbiuchinu xianghupaibanibibioilokoingushingrian" +
			"uinglés criollu xamaicanulojbanngombamachamexudeo-persaxudeo-árabeju" +
			"tlandéskara-kalpakkabileñukachinjjukambakawikabardianukanembutyapmak" +
			"ondecabuverdianukenyangkorokaingangkhasikhotanéskoyra chiinikhowarki" +
			"rmanjkikakokalenjinkimbundukomi-permyakkonkanikosraeanukpellekaracha" +
			"y-balkarkriokinaray-akarelianukurukhshambalabafiacolonianukumykkuten" +
			"ailadinolangilahndalambalezghianulingua franca novaligurianulivonian" +
			"ulakotalombardumongoloziluri del nortelatgalianuluba-lulualuisenolun" +
			"daluomizoluyiachinu lliterariulazmadurésmafamagahimaithilimakasarman" +
			"dingomasáimabamokshamandarmendemerumorisyenírlandés mediumakhuwa-mee" +
			"ttometa’micmacminangkabaumanchúmanipurimohawkmossimari occidentalmun" +
			"dangmúltiples llingüescreekmirandésmarwarimentawaimyeneerzyamazander" +
			"anichinu min nannapolitanunamabaxu alemánnewariniasniueanuao nagakwa" +
			"siongiemboonnogainoruegu antiguunovialn’kosotho del nortenuernewari " +
			"clásicunyamwezinyankolenyoronzimaosageturcu otomanupangasinanpahlavi" +
			"pampangapapiamentopalauanupícarunixerianu simplificáualemán de Penns" +
			"ylvaniaplautdietschpersa antiguualemán palatinufeniciupiamontéspónti" +
			"cupohnpeianuprusianuprovenzal antiguukʼicheʼquichua del altiplanu de" +
			" Chimborazorajasthanínrapanuirarotonganuromañolrifianuromboromanírot" +
			"umanurusynrovianaaromanianurwasandavéssakhaaraméu samaritanusamburus" +
			"asaksantalisaurashtrangambaysangusicilianuscotssardu sassaréskurdu d" +
			"el sursénecasenaseriselkupkoyraboro senniirlandés antiguusamogitianu" +
			"tachelhitshanárabe chadianusidamobaxu silesianuselayaréssami del sur" +
			"lule samiinari samiskolt samisoninkesogdianusranan tongoserersahofri" +
			"són de Saterlandsukumasususumeriucomorianusiriacu clásicusiriacusile" +
			"sianutulutimnetesoterenatetumtigretivtokelautsakhurklingontlingittal" +
			"ixíntamashektonga nyasatok pisinturoyotarokotsakoniutsimshiantati mu" +
			"sulmántumbukatuvalutasawaqtuvinianutamazight del Atles centraludmurt" +
			"ugaríticuumbundurootvaivenecianuvepsiuflamencu occidentalfranconianu" +
			" del Mainvóticuvorovunjowalserwolayttawaraywashowarlpirichinu wucalm" +
			"ucomingrelianusogayaoyapésyangbenyembanheengatucantonészapotecasimbó" +
			"licu Blisszeelandészenagatamazight estándar de Marruecoszuniensin co" +
			"nteníu llingüísticuzazaárabe estándar modernualemán d’Austriaaltuale" +
			"mán de Suizainglés d’Australiainglés de Canadáinglés de Gran Bretaña" +
			"inglés d’Estaos Xuníosespañol d’América Llatinaespañol européuespaño" +
			"l de Méxicufrancés de Canadáfrancés de Suizabaxu saxónflamencuportug" +
			"ués del Brasilportugués européumoldavuserbo-croatasuaḥili del Conguc" +
			"hinu simplificáuchinu tradicional",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0018, 0x0021, 0x0025, 0x002e, 0x0037,
			0x003d, 0x0044, 0x004c, 0x0052, 0x005d, 0x0064, 0x006e, 0x0076,
			0x007d, 0x0084, 0x008d, 0x0095, 0x009c, 0x00a2, 0x00aa, 0x00b2,
			0x00ba, 0x00bf, 0x00c3, 0x00c8, 0x00df, 0x00e6, 0x00ec, 0x00f2,
			0x00f9, 0x00ff, 0x0107, 0x010a, 0x0110, 0x0117, 0x0120, 0x0128,
			0x012f, 0x0134, 0x0139, 0x013e, 0x0148, 0x014e, 0x0155, 0x015d,
			0x016f, 0x0178, 0x0189, 0x0190, 0x0198, 0x01a1, 0x01a7, 0x01ae,
			0x01b5, 0x01ba, 0x01c3, 0x01c9, 0x01d1, 0x01d9, 0x01e0, 0x01e6,
			// Entry 40 - 7F
			0x01f1, 0x01fa, 0x0205, 0x0209, 0x0217, 0x021e, 0x0221, 0x022a,
			0x0232, 0x023b, 0x0243, 0x024b, 0x0253, 0x0258, 0x025e, 0x0266,
			0x0274, 0x027f, 0x0286, 0x028e, 0x0295, 0x029b, 0x02a6, 0x02ab,
			0x02af, 0x02b7, 0x02c4, 0x02cb, 0x02d8, 0x02dd, 0x02e8, 0x02ef,
			0x02f7, 0x02fe, 0x030a, 0x0310, 0x0317, 0x0322, 0x0328, 0x0331,
			0x033a, 0x0340, 0x0347, 0x034d, 0x0354, 0x035b, 0x0360, 0x0371,
			0x0379, 0x037f, 0x038a, 0x0399, 0x03a8, 0x03b7, 0x03bd, 0x03c3,
			0x03cb, 0x03d1, 0x03d6, 0x03db, 0x03e3, 0x03eb, 0x03ef, 0x03f5,
			// Entry 80 - BF
			0x03fb, 0x0405, 0x040c, 0x0414, 0x0419, 0x041f, 0x0423, 0x042e,
			0x0438, 0x043d, 0x0443, 0x0451, 0x0456, 0x045f, 0x0467, 0x046f,
			0x0476, 0x047b, 0x0483, 0x0489, 0x048f, 0x0494, 0x04a1, 0x04aa,
			0x04af, 0x04b8, 0x04bd, 0x04c3, 0x04d1, 0x04db, 0x04e3, 0x04ec,
			0x04f2, 0x04f9, 0x04fe, 0x0504, 0x050c, 0x0515, 0x051a, 0x0521,
			0x0525, 0x0533, 0x0538, 0x0542, 0x054a, 0x0550, 0x0555, 0x055a,
			0x0561, 0x0567, 0x056d, 0x0572, 0x0577, 0x057f, 0x0584, 0x058b,
			0x0591, 0x05a1, 0x05a9, 0x05ae, 0x05b2, 0x05ba, 0x05c1, 0x05c6,
			// Entry C0 - FF
			0x05d6, 0x05e3, 0x05f2, 0x05f8, 0x05ff, 0x0606, 0x060c, 0x0613,
			0x0625, 0x0625, 0x062b, 0x063e, 0x064f, 0x0652, 0x066d, 0x0676,
			0x067c, 0x0682, 0x0689, 0x0691, 0x0698, 0x069d, 0x06a2, 0x06ac,
			0x06b3, 0x06b7, 0x06bc, 0x06c2, 0x06c6, 0x06cb, 0x06d1, 0x06e3,
			0x06eb, 0x06f0, 0x06f4, 0x06fa, 0x06fd, 0x0704, 0x070f, 0x0718,
			0x071c, 0x0722, 0x0726, 0x072c, 0x0732, 0x073a, 0x073e, 0x0742,
			0x0749, 0x074e, 0x0754, 0x075a, 0x075f, 0x0766, 0x076b, 0x0772,
			0x077a, 0x0782, 0x0786, 0x0795, 0x079c, 0x07a6, 0x07ae, 0x07b6,
			// Entry 100 - 13F
			0x07c3, 0x07cb, 0x07d3, 0x07e2, 0x07fa, 0x0804, 0x080a, 0x0810,
			0x0815, 0x081d, 0x0822, 0x0828, 0x082d, 0x0832, 0x0837, 0x0842,
			0x084f, 0x0854, 0x0865, 0x086f, 0x0874, 0x087a, 0x087f, 0x0883,
			0x088b, 0x089a, 0x08a0, 0x08a7, 0x08b4, 0x08c1, 0x08c7, 0x08d1,
			0x08d5, 0x08dd, 0x08f5, 0x08f8, 0x0906, 0x0914, 0x0924, 0x092c,
			0x093d, 0x094d, 0x0956, 0x0958, 0x095e, 0x0967, 0x096b, 0x0970,
			0x0981, 0x0985, 0x098f, 0x0995, 0x09a6, 0x09b9, 0x09c5, 0x09ca,
			0x09d3, 0x09da, 0x09df, 0x09ed, 0x09fd, 0x0a02, 0x0a08, 0x0a0d,
			// Entry 140 - 17F
			0x0a16, 0x0a1b, 0x0a26, 0x0a2e, 0x0a3b, 0x0a45, 0x0a4b, 0x0a50,
			0x0a5b, 0x0a66, 0x0a6a, 0x0a6e, 0x0a74, 0x0a79, 0x0a7f, 0x0a87,
			0x0aa0, 0x0aa6, 0x0aac, 0x0ab3, 0x0abe, 0x0aca, 0x0ad4, 0x0adf,
			0x0ae8, 0x0aee, 0x0af1, 0x0af6, 0x0afa, 0x0b04, 0x0b0b, 0x0b0f,
			0x0b16, 0x0b22, 0x0b29, 0x0b2d, 0x0b35, 0x0b3a, 0x0b43, 0x0b4f,
			0x0b55, 0x0b5e, 0x0b62, 0x0b6a, 0x0b72, 0x0b7e, 0x0b85, 0x0b8e,
			0x0b94, 0x0ba3, 0x0ba7, 0x0bb0, 0x0bb9, 0x0bbf, 0x0bc7, 0x0bcc,
			0x0bd5, 0x0bda, 0x0be1, 0x0be7, 0x0bec, 0x0bf2, 0x0bf7, 0x0c00,
			// Entry 180 - 1BF
			0x0c12, 0x0c1b, 0x0c24, 0x0c2a, 0x0c32, 0x0c37, 0x0c3b, 0x0c49,
			0x0c53, 0x0c5d, 0x0c64, 0x0c69, 0x0c6c, 0x0c70, 0x0c75, 0x0c85,
			0x0c88, 0x0c90, 0x0c94, 0x0c9a, 0x0ca2, 0x0ca9, 0x0cb1, 0x0cb7,
			0x0cbb, 0x0cc1, 0x0cc7, 0x0ccc, 0x0cd0, 0x0cd8, 0x0ce8, 0x0cf6,
			0x0cfd, 0x0d03, 0x0d0e, 0x0d15, 0x0d1d, 0x0d23, 0x0d28, 0x0d37,
			0x0d3e, 0x0d52, 0x0d57, 0x0d60, 0x0d67, 0x0d6f, 0x0d74, 0x0d79,
			0x0d84, 0x0d91, 0x0d9b, 0x0d9f, 0x0dab, 0x0db1, 0x0db5, 0x0dbc,
			0x0dc3, 0x0dc9, 0x0dd2, 0x0dd7, 0x0de6, 0x0dec, 0x0df2, 0x0e01,
			// Entry 1C0 - 1FF
			0x0e05, 0x0e14, 0x0e1c, 0x0e24, 0x0e29, 0x0e2e, 0x0e33, 0x0e40,
			0x0e4a, 0x0e51, 0x0e59, 0x0e63, 0x0e6b, 0x0e72, 0x0e88, 0x0e9f,
			0x0eab, 0x0eb8, 0x0ec8, 0x0ecf, 0x0ed9, 0x0ee1, 0x0eeb, 0x0ef3,
			0x0f04, 0x0f0d, 0x0f30, 0x0f3c, 0x0f43, 0x0f4e, 0x0f56, 0x0f5d,
			0x0f62, 0x0f69, 0x0f71, 0x0f76, 0x0f7d, 0x0f87, 0x0f8a, 0x0f93,
			0x0f98, 0x0faa, 0x0fb1, 0x0fb6, 0x0fbd, 0x0fc7, 0x0fce, 0x0fd3,
			0x0fdc, 0x0fe1, 0x0ff0, 0x0ffd, 0x1004, 0x1008, 0x100c, 0x1012,
			0x1021, 0x1032, 0x103d, 0x1046, 0x104a, 0x1059, 0x105f, 0x106d,
			// Entry 200 - 23F
			0x1077, 0x1083, 0x108c, 0x1096, 0x10a0, 0x10a7, 0x10af, 0x10bb,
			0x10c0, 0x10c4, 0x10d8, 0x10de, 0x10e2, 0x10e9, 0x10f2, 0x1102,
			0x1109, 0x1112, 0x1116, 0x111b, 0x111f, 0x1125, 0x112a, 0x112f,
			0x1132, 0x1139, 0x1140, 0x1147, 0x114e, 0x1156, 0x115e, 0x1169,
			0x1172, 0x1178, 0x117e, 0x1186, 0x118f, 0x119d, 0x11a4, 0x11aa,
			0x11b1, 0x11ba, 0x11d5, 0x11db, 0x11e5, 0x11ec, 0x11f0, 0x11f3,
			0x11fc, 0x1202, 0x1215, 0x1229, 0x1230, 0x1234, 0x1239, 0x123f,
			0x1247, 0x124c, 0x1251, 0x1259, 0x1261, 0x1268, 0x1273, 0x1277,
			// Entry 240 - 27F
			0x127a, 0x1280, 0x1287, 0x128c, 0x1295, 0x129e, 0x12a6, 0x12b6,
			0x12c0, 0x12c6, 0x12e6, 0x12ea, 0x1308, 0x130c, 0x1324, 0x1324,
			0x1337, 0x134b, 0x1360, 0x1372, 0x138a, 0x13a4, 0x13c1, 0x13d2,
			0x13e5, 0x13e5, 0x13f8, 0x1409, 0x1414, 0x141c, 0x1431, 0x1444,
			0x144b, 0x1457, 0x146a, 0x147c, 0x148d,
		},
	},
	{ // az
		azLangStr,
		azLangIdx,
	},
	{ // az-Cyrl
		"афарабхазафрикаансаканамһарарагонәрәбассамаварајмараазәрбајҹанбашгырдбел" +
			"арусбулгарбисламабамбарабенгалтибетбретонбосниаккаталанчеченчаморок" +
			"орсикачехславјанчувашуелсданимаркаалманмалдивдзонгаевејунанинҝилисе" +
			"сперантоиспанестонбаскфарсфулафинфиҹифарерфрансызгәрби фризирландшо" +
			"тланд келтгалисијагуаранигуҹаратманксһаусаивритһиндхорватһаити крео" +
			"лмаҹарермәниһерероинтерлингвеиндонезијаигбоидоисландиталјанинуктиту" +
			"тјапонјаваҝүрҹүкикујукуанјамагазахкалааллисуткхмерканнадакорејакану" +
			"рикәшмиркүрдкомикорнгырғызлатынлүксембурггандалимбурглингалалаослит" +
			"валуба-катангалатышмалагасмаршалмаоримакедонмалајаламмонголмаратһим" +
			"алајмалтабирманнаурушимали ндебеленепалндонгаһолланднүнорск норвечб" +
			"окмал норвечҹәнуби ндебеленавајонјанҹаокситаноромоодијаосетинпәнҹаб" +
			"полјакпуштупортугалкечуароманшрундирумынрускинјарвандасанскритсарди" +
			"нсиндһишимали самисангосинһаласловаксловенсамоашонасомалиалбансербс" +
			"ватисесотосунданисвечсуаһилитамилтелугутаҹиктајтигринтүркмәнсванато" +
			"нгантүрксонгататартахитиујғурукрајнаурдуөзбәквендавјетнамволапүквал" +
			"унволофхосаидишјорубачинзулуакинадангмеадуҝеагһемајнуалеутҹәнуби ал" +
			"тајанҝикаарауканҹаарапаһоасуастуријаавадһибаллибасабембабенабхочпур" +
			"ибинисиксикәбодобуҝинблинсебуанчигачукизмаричоктаучерокичејенсоранс" +
			"ејшел креолудакотадаргватаитадогрибзармаашағы сорбдуаладиоладазагае" +
			"мбуефикекаҹукевондофилиппинфонфриулгагезгилбертгоронталоИсвечрә алм" +
			"анҹасыгусигвичинһавајһилигајнонмонгјухары сорбһупаибанибибиоилокоин" +
			"гушлоғбаннгомбамачамкабилекачинжукамбакабарда-чәркәзтвимакондекабув" +
			"ердианкорохазикојра чииникакокаленҹинкимбундуконканикпеллегарачај-б" +
			"алкаркарелкурухшамбалабафиакөлнкумыксефардланҝиләзҝилакоталозишимал" +
			"и лурилуба-лулуалундалуомизолујиамадуризмагаһимаитилимакасармасајмо" +
			"кшамендемеруморисиенмахува-мееттометаʼмикмакминангкабанманипүримоһа" +
			"вкмосимундангчохсајлы дилләркрикмирандерзјамазандараннеаполитаннама" +
			"невариниаснијуанквасионҝиембоонногајнгошимали сотонуернјанколпангас" +
			"инанпампангапапјаментопалајанниҝер креолпрусскичерапануираротонганр" +
			"омбоароманруасандавесахасамбурусанталнгамбајсангусиҹилијаскотссенак" +
			"ојраборо сеннитачелитшанҹәнуби самилуле самиинари самисколт самисон" +
			"инкесранан тонгосаһосукумакоморсуријатимнетесотетумтигреклингонток " +
			"писинтарокотумбукатувалутасавагтувинјанМәркәзи Атлас тамазиҹәсиудму" +
			"ртумбундурутваивунјоваллесваламоварајкалмыксогајангбенјембакантонта" +
			"мазизунидил мәзмуну јохдурзазамүасир стандарт әрәбАвстрија алманҹас" +
			"ыИсвечрә јүксәк алманҹасыАвстралија инҝилисҹәсиКанада инҝилисҹәсиБр" +
			"итанија инҝилисҹәсиАмерика инҝилисҹәсиЛатын Америкасы испанҹасыКаст" +
			"илија испанҹасыМексика испанҹасыКанада франсызҹасыИсвечрә франсызҹа" +
			"сыашағы саксонфламандБразилија португалҹасыПортугалија португалҹасы" +
			"Конго суаһилиҹәсисадәләшмиш чинәнәнәви чин",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0008, 0x0012, 0x0012, 0x0024, 0x002c, 0x0036, 0x0042,
			0x004a, 0x0054, 0x005c, 0x0068, 0x007c, 0x008a, 0x0098, 0x00a4,
			0x00b2, 0x00c0, 0x00cc, 0x00d6, 0x00e2, 0x00f0, 0x00fe, 0x0108,
			0x0114, 0x0122, 0x0122, 0x0128, 0x0136, 0x0140, 0x0148, 0x015a,
			0x0164, 0x0170, 0x017c, 0x0182, 0x018c, 0x019a, 0x01ac, 0x01b6,
			0x01c0, 0x01c8, 0x01d0, 0x01d8, 0x01de, 0x01e6, 0x01f0, 0x01fe,
			0x0211, 0x021d, 0x0234, 0x0244, 0x0252, 0x0260, 0x026a, 0x0274,
			0x027e, 0x0286, 0x0286, 0x0292, 0x02a7, 0x02b1, 0x02bd, 0x02c9,
			// Entry 40 - 7F
			0x02df, 0x02f3, 0x02f3, 0x02fb, 0x02fb, 0x02fb, 0x0301, 0x030d,
			0x031b, 0x032d, 0x0337, 0x033f, 0x0349, 0x0349, 0x0355, 0x0365,
			0x036f, 0x0385, 0x038f, 0x039d, 0x03a9, 0x03b5, 0x03c1, 0x03c9,
			0x03d1, 0x03d9, 0x03e5, 0x03ef, 0x0403, 0x040d, 0x041b, 0x0429,
			0x0431, 0x043b, 0x0452, 0x045c, 0x046a, 0x0476, 0x0480, 0x048e,
			0x04a0, 0x04ac, 0x04ba, 0x04c4, 0x04ce, 0x04da, 0x04e4, 0x04ff,
			0x0509, 0x0515, 0x0523, 0x053e, 0x0557, 0x0572, 0x057e, 0x058a,
			0x0598, 0x0598, 0x05a2, 0x05ac, 0x05b8, 0x05c4, 0x05c4, 0x05d0,
			// Entry 80 - BF
			0x05da, 0x05ea, 0x05f4, 0x0600, 0x060a, 0x0614, 0x061a, 0x0630,
			0x0640, 0x064c, 0x0658, 0x066d, 0x0677, 0x0685, 0x0691, 0x069d,
			0x06a7, 0x06af, 0x06bb, 0x06c5, 0x06cd, 0x06d7, 0x06e3, 0x06ef,
			0x06f9, 0x0707, 0x0711, 0x071d, 0x0727, 0x072d, 0x0739, 0x0747,
			0x0751, 0x075d, 0x0765, 0x076f, 0x0779, 0x0785, 0x078f, 0x079d,
			0x07a5, 0x07af, 0x07b9, 0x07c7, 0x07d5, 0x07df, 0x07e9, 0x07f1,
			0x07f9, 0x0805, 0x0805, 0x080b, 0x0813, 0x081b, 0x081b, 0x0829,
			0x0833, 0x0833, 0x0833, 0x083d, 0x0845, 0x0845, 0x0845, 0x084f,
			// Entry C0 - FF
			0x084f, 0x0866, 0x0866, 0x0872, 0x0872, 0x0884, 0x0884, 0x0892,
			0x0892, 0x0892, 0x0892, 0x0892, 0x0892, 0x0898, 0x0898, 0x08a8,
			0x08a8, 0x08b4, 0x08b4, 0x08be, 0x08be, 0x08c6, 0x08c6, 0x08c6,
			0x08c6, 0x08c6, 0x08d0, 0x08d0, 0x08d8, 0x08d8, 0x08d8, 0x08d8,
			0x08e8, 0x08e8, 0x08f0, 0x08f0, 0x08f0, 0x08fe, 0x08fe, 0x08fe,
			0x08fe, 0x08fe, 0x0906, 0x0906, 0x0906, 0x0910, 0x0910, 0x0918,
			0x0918, 0x0918, 0x0918, 0x0918, 0x0918, 0x0924, 0x092c, 0x092c,
			0x092c, 0x0936, 0x093e, 0x093e, 0x094a, 0x094a, 0x0956, 0x0960,
			// Entry 100 - 13F
			0x096a, 0x096a, 0x096a, 0x096a, 0x0983, 0x0983, 0x098f, 0x099b,
			0x09a5, 0x09a5, 0x09a5, 0x09b1, 0x09b1, 0x09bb, 0x09bb, 0x09ce,
			0x09ce, 0x09d8, 0x09d8, 0x09e2, 0x09e2, 0x09ee, 0x09f6, 0x09fe,
			0x09fe, 0x09fe, 0x0a0a, 0x0a0a, 0x0a0a, 0x0a0a, 0x0a16, 0x0a16,
			0x0a16, 0x0a26, 0x0a26, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c,
			0x0a2c, 0x0a2c, 0x0a36, 0x0a3a, 0x0a3a, 0x0a3a, 0x0a3a, 0x0a3a,
			0x0a3a, 0x0a40, 0x0a4e, 0x0a4e, 0x0a4e, 0x0a4e, 0x0a4e, 0x0a4e,
			0x0a60, 0x0a60, 0x0a60, 0x0a60, 0x0a81, 0x0a81, 0x0a81, 0x0a89,
			// Entry 140 - 17F
			0x0a95, 0x0a95, 0x0a95, 0x0a9f, 0x0a9f, 0x0ab3, 0x0ab3, 0x0abb,
			0x0ad0, 0x0ad0, 0x0ad8, 0x0ae0, 0x0aec, 0x0af6, 0x0b00, 0x0b00,
			0x0b00, 0x0b0c, 0x0b18, 0x0b22, 0x0b22, 0x0b22, 0x0b22, 0x0b22,
			0x0b2e, 0x0b38, 0x0b3c, 0x0b46, 0x0b46, 0x0b61, 0x0b61, 0x0b67,
			0x0b75, 0x0b8b, 0x0b8b, 0x0b93, 0x0b93, 0x0b9b, 0x0b9b, 0x0bb0,
			0x0bb0, 0x0bb0, 0x0bb8, 0x0bc8, 0x0bd8, 0x0bd8, 0x0be6, 0x0be6,
			0x0bf2, 0x0c0d, 0x0c0d, 0x0c0d, 0x0c17, 0x0c21, 0x0c2f, 0x0c39,
			0x0c41, 0x0c4b, 0x0c4b, 0x0c57, 0x0c61, 0x0c61, 0x0c61, 0x0c6b,
			// Entry 180 - 1BF
			0x0c6b, 0x0c6b, 0x0c6b, 0x0c77, 0x0c77, 0x0c77, 0x0c7f, 0x0c94,
			0x0c94, 0x0ca7, 0x0ca7, 0x0cb1, 0x0cb7, 0x0cbf, 0x0cc9, 0x0cc9,
			0x0cc9, 0x0cd7, 0x0cd7, 0x0ce3, 0x0cf1, 0x0cff, 0x0cff, 0x0d09,
			0x0d09, 0x0d13, 0x0d13, 0x0d1d, 0x0d25, 0x0d35, 0x0d35, 0x0d4e,
			0x0d58, 0x0d64, 0x0d7a, 0x0d7a, 0x0d8a, 0x0d96, 0x0d9e, 0x0d9e,
			0x0dac, 0x0dc9, 0x0dd1, 0x0ddd, 0x0ddd, 0x0ddd, 0x0ddd, 0x0de7,
			0x0dfb, 0x0dfb, 0x0e0f, 0x0e17, 0x0e17, 0x0e23, 0x0e2b, 0x0e37,
			0x0e37, 0x0e43, 0x0e55, 0x0e5f, 0x0e5f, 0x0e5f, 0x0e65, 0x0e7a,
			// Entry 1C0 - 1FF
			0x0e82, 0x0e82, 0x0e82, 0x0e90, 0x0e90, 0x0e90, 0x0e90, 0x0e90,
			0x0ea4, 0x0ea4, 0x0eb4, 0x0ec8, 0x0ed6, 0x0ed6, 0x0eeb, 0x0eeb,
			0x0eeb, 0x0eeb, 0x0eeb, 0x0eeb, 0x0eeb, 0x0eeb, 0x0eeb, 0x0ef5,
			0x0ef5, 0x0efd, 0x0efd, 0x0efd, 0x0f0b, 0x0f1f, 0x0f1f, 0x0f1f,
			0x0f29, 0x0f29, 0x0f29, 0x0f29, 0x0f29, 0x0f35, 0x0f3b, 0x0f49,
			0x0f51, 0x0f51, 0x0f5f, 0x0f5f, 0x0f6b, 0x0f6b, 0x0f79, 0x0f83,
			0x0f93, 0x0f9d, 0x0f9d, 0x0f9d, 0x0f9d, 0x0fa5, 0x0fa5, 0x0fa5,
			0x0fc2, 0x0fc2, 0x0fc2, 0x0fd0, 0x0fd6, 0x0fd6, 0x0fd6, 0x0fd6,
			// Entry 200 - 23F
			0x0fd6, 0x0feb, 0x0ffc, 0x100f, 0x1022, 0x1030, 0x1030, 0x1047,
			0x1047, 0x104f, 0x104f, 0x105b, 0x105b, 0x105b, 0x1065, 0x1065,
			0x1071, 0x1071, 0x1071, 0x107b, 0x1083, 0x1083, 0x108d, 0x1097,
			0x1097, 0x1097, 0x1097, 0x10a5, 0x10a5, 0x10a5, 0x10a5, 0x10a5,
			0x10b6, 0x10b6, 0x10c2, 0x10c2, 0x10c2, 0x10c2, 0x10d0, 0x10dc,
			0x10ea, 0x10fa, 0x1128, 0x1134, 0x1134, 0x1142, 0x1148, 0x114e,
			0x114e, 0x114e, 0x114e, 0x114e, 0x114e, 0x114e, 0x1158, 0x1164,
			0x1170, 0x117a, 0x117a, 0x117a, 0x117a, 0x1186, 0x1186, 0x118e,
			// Entry 240 - 27F
			0x118e, 0x118e, 0x119c, 0x11a6, 0x11a6, 0x11b2, 0x11b2, 0x11b2,
			0x11b2, 0x11b2, 0x11be, 0x11c6, 0x11e8, 0x11f0, 0x1216, 0x1216,
			0x1239, 0x1267, 0x1292, 0x12b5, 0x12de, 0x1303, 0x1333, 0x1358,
			0x1379, 0x1379, 0x139c, 0x13c1, 0x13d8, 0x13e6, 0x1411, 0x1440,
			0x1440, 0x1440, 0x1461, 0x147c, 0x1491,
		},
	},
	{ // bas
		"Hɔp u akanHɔp u amhārìkHɔp u arâbHɔp u bièlòrûsHɔp u bûlgârHɔp u bɛŋgàli" +
			"Hɔp u cɛ̂kHɔp u jamânHɔp u gri ᷇kyàHɔp u ŋgisìHɔp u panyāHɔp u pɛrsì" +
			"àHɔp u pulàsiHɔp u ɓausaHɔp u hindìHɔp u hɔŋgrìiHɔp u indònesìàHɔp " +
			"u iɓòHɔp u italìàHɔp u yapànHɔp u yavàHɔp u kmɛ̂rHɔp u kɔrēàHɔp u ma" +
			"kɛ᷆Hɔp u birmànHɔp u nepa᷆lHɔp u nlɛ̀ndiHɔp u pɛnjàbiHɔp u pɔlɔ̄nàHɔ" +
			"p u pɔtɔ̄kìHɔp u rùmanìàHɔp u ruslàndHɔp u ruāndàHɔp u somàlîHɔp u s" +
			"uɛ᷆dHɔp u tamu᷆lHɔp u tâyHɔp u tûrkHɔp u ukrǎnìàHɔp u urdùHɔp u vyɛ̄" +
			"dnàmHɔp u yorūbàHɔp u kinàHɔp u zulùƁàsàa",
		[]uint16{ // 214 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x001b, 0x001b,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0039, 0x0048,
			0x0048, 0x0048, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0085, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00be,
			0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00be, 0x00cb,
			0x00cb, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00e9, 0x00e9, 0x00e9,
			// Entry 40 - 7F
			0x00e9, 0x00fc, 0x00fc, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0117, 0x0117, 0x0124, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0130, 0x013e, 0x013e, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x014d, 0x014d, 0x015c, 0x015c, 0x016a, 0x016a, 0x016a,
			0x0179, 0x0179, 0x0189, 0x0189, 0x0189, 0x0189, 0x0189, 0x0189,
			0x0189, 0x0189, 0x0189, 0x0189, 0x0189, 0x0199, 0x0199, 0x01ab,
			// Entry 80 - BF
			0x01ab, 0x01bd, 0x01bd, 0x01bd, 0x01bd, 0x01ce, 0x01dd, 0x01ec,
			0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec,
			0x01ec, 0x01ec, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb,
			0x020a, 0x020a, 0x0219, 0x0219, 0x0219, 0x0224, 0x0224, 0x0224,
			0x0224, 0x0224, 0x0230, 0x0230, 0x0230, 0x0230, 0x0230, 0x0241,
			0x024d, 0x024d, 0x024d, 0x025f, 0x025f, 0x025f, 0x025f, 0x025f,
			0x025f, 0x026e, 0x026e, 0x027a, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			// Entry C0 - FF
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0286, 0x0286, 0x0286, 0x028e,
		},
	},
	{ // be
		"афарскаяабхазскаяафрыкаансаканамхарскаяарагонскаяарабскаяасамскаяаварска" +
			"яаймараазербайджанскаябашкірскаябеларускаябалгарскаябісламабамбараб" +
			"енгальскаятыбецкаябрэтонскаябаснійскаякаталанскаячачэнскаячаморакар" +
			"сіканскаячэшскаяцаркоўнаславянскаячувашскаявалійскаядацкаянямецкаям" +
			"альдыўскаядзонг-кээвегрэчаскаяанглійскаяэсперантаіспанскаяэстонская" +
			"баскскаяфарсіфулафінскаяфіджыйскаяфарэрскаяфранцузскаязаходняя фрыз" +
			"скаяірландскаяшатландская гэльскаягалісійскаягуаранігуджарацімэнска" +
			"яхаусаіўрытхіндзіхарвацкаягаіцянская крэольскаявенгерскаяармянскаяг" +
			"ерэраінтэрлінгваінданезійскаяінтэрлінгвэігбасычуаньская йіідаісланд" +
			"скаяітальянскаяінуктытутяпонскаяяванскаягрузінскаякікуйюкуаньямаказ" +
			"ахскаягрэнландскаякхмерскаяканадакарэйскаяканурыкашмірскаякурдскаяк" +
			"омікорнскаякіргізскаялацінскаялюксембургскаягандалімбургскаялінгала" +
			"лаоскаялітоўскаялуба-катангалатышскаямалагасійскаямаршальскаямаарым" +
			"акедонскаямалаяламмангольскаямаратхімалайскаямальтыйскаябірманскаян" +
			"аурупаўночная ндэбеленепальскаяндонганідэрландскаянарвежская (нюнош" +
			"к)нарвежская (букмол)паўднёвая ндэбеленаваханьянджааксітанскаяаджыб" +
			"вааромаорыяасецінскаяпанджабіпольскаяпуштупартугальскаякечуарэтарам" +
			"анскаярундзірумынскаярускаяруандасанскрытсардзінскаясіндхіпаўночнас" +
			"аамскаясангасінгальскаяславацкаяславенскаясамоашонасамаліалбанскаяс" +
			"ербскаясуаціпаўднёвая сотасундашведскаясуахілітамільскаятэлугутаджы" +
			"кскаятайскаятыгрыньятуркменскаятсванатанганскаятурэцкаятсонгататарс" +
			"каятаіціуйгурскаяукраінскаяурдуузбекскаявендав’етнамскаявалапюквало" +
			"нскаявалофкосаідышёрубакітайскаязулуачэхадангмэадыгейскаяагемайнска" +
			"яакадскаяалеуцкаяпаўднёваалтайскаястараанглійскаяангікаарамейскаяма" +
			"пудунгунарапахаасуастурыйскаяавадхібалійскаябасаабембабеназаходняя " +
			"белуджскаябхаджпурыэдаблэкфутбодабурацкаябугісбіленсебуаначыгачыбча" +
			"чуукмарычоктачэрокішэйенцэнтральнакурдскаякопцкаясэсэльвадакотадарг" +
			"інскаятаітадогрыбзарманіжнялужыцкаядуаладжола-фоньідазагаэмбуэфікст" +
			"аражытнаегіпецкаяэкаджукэвондафіліпінскаяфонстарафранцузскаяфрыульс" +
			"каягагагаузскаягеэзкірыбацігаранталастаражытнагрэчаскаяшвейцарская " +
			"нямецкаягусіігуіч’інгавайскаяхілігайнонхмонгверхнялужыцкаяхупаібані" +
			"бібіяілаканаінгушскаяложбаннгомбамачамбэкабільскаякачынскаядджукамб" +
			"акабардзінскаят’япмакондэкабувердыянукоракхасікойра чыінікакокаленд" +
			"жынкімбундукомі-пярмяцкаяканканікпелекарачай-балкарскаякарэльскаяку" +
			"рухшамбалабафіякёльнскаякумыцкаяладыналангілезгінскаялакотамонгалоз" +
			"іпаўночная лурылуба-касаілундалуомізолуйямадурскаямагахімайтхілімак" +
			"асармандынгмаасаймакшанскаямендэмерумарысьенмакуўа-меетаметамікмакм" +
			"інангкабаумейтэймохакмосімундангнекалькі моўмускогімірандыйскаяэрзя" +
			"нскаямазандэранскаянеапалітанскаянаманіжненямецкаянеўарыніасніўэнгу" +
			"мбанг’ембоннагайскаястаранарвежскаянкопаўночная сотануэрньянколепан" +
			"гасінанпампангапап’яментупалаунігерыйскі піджынстараперсідскаяфінік" +
			"ійскаяпрускаястараправансальскаякічэраджастханскаярапануіраратонгро" +
			"мбаарумунскаяруасандаўэякуцкаясамбурусанталінгамбайсангусіцылійская" +
			"шатландскаяпаўднёвакурдскаясенакайрабора сэністараірландскаяташэльх" +
			"ітшанпаўднёвасаамскаялуле-саамскаяінары-саамскаяколта-саамскаясанін" +
			"кесранан-тонгасахасукумашумерскаякаморскаясірыйскаятэмнэтэсотэтумты" +
			"грэклінганток-пісінтарокатумбукатувалутасаўактувінскаяцэнтральнаатл" +
			"аская тамазіхтудмурцкаяумбундукораньваівунджовальшскаяволайтаварайв" +
			"арлпірыкалмыцкаясогаянгбэнйембакантонскі дыялект кітайскайсапатэкст" +
			"андартная мараканская тамазіхтзуніняма моўнага матэрыялузазакісучас" +
			"ная стандартная арабскаяаўстрыйская нямецкаяшвейцарская стандартная" +
			" нямецкаяаўстралійская англійскаяканадская англійскаябрытанская англ" +
			"ійскаяамерыканская англійскаялацінаамерыканская іспанскаяеўрапейска" +
			"я іспанскаямексіканская іспанскаяканадская французскаяшвейцарская ф" +
			"ранцузскаяніжнесаксонскаяфламандскаябразільская партугальскаяеўрапе" +
			"йская партугальскаямалдаўская румынскаясербскахарвацкаякангалезская" +
			" суахіліспрошчаная кітайскаятрадыцыйная кітайская",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0010, 0x0022, 0x0022, 0x0034, 0x003c, 0x004e, 0x0062,
			0x0072, 0x0082, 0x0092, 0x009e, 0x00bc, 0x00d0, 0x00e4, 0x00f8,
			0x0106, 0x0114, 0x012a, 0x013a, 0x014e, 0x0162, 0x0178, 0x018a,
			0x0196, 0x01ae, 0x01ae, 0x01bc, 0x01e0, 0x01f2, 0x0204, 0x0210,
			0x0220, 0x0236, 0x0245, 0x024b, 0x025d, 0x0271, 0x0283, 0x0295,
			0x02a7, 0x02b7, 0x02c1, 0x02c9, 0x02d7, 0x02eb, 0x02fd, 0x0313,
			0x0334, 0x0348, 0x036f, 0x0385, 0x0393, 0x03a5, 0x03b3, 0x03bd,
			0x03c7, 0x03d3, 0x03d3, 0x03e5, 0x040e, 0x0422, 0x0434, 0x0440,
			// Entry 40 - 7F
			0x0456, 0x0470, 0x0486, 0x048e, 0x04a9, 0x04a9, 0x04af, 0x04c3,
			0x04d9, 0x04eb, 0x04fb, 0x050b, 0x051f, 0x051f, 0x052b, 0x053b,
			0x054d, 0x0565, 0x0577, 0x0583, 0x0595, 0x05a1, 0x05b5, 0x05c5,
			0x05cd, 0x05dd, 0x05f1, 0x0603, 0x061f, 0x0629, 0x063f, 0x064d,
			0x065b, 0x066d, 0x0684, 0x0696, 0x06b0, 0x06c6, 0x06d0, 0x06e6,
			0x06f6, 0x070c, 0x071a, 0x072c, 0x0742, 0x0756, 0x0760, 0x0781,
			0x0795, 0x07a1, 0x07bb, 0x07de, 0x0801, 0x0822, 0x082e, 0x083c,
			0x0852, 0x0860, 0x086a, 0x0872, 0x0886, 0x0896, 0x0896, 0x08a6,
			// Entry 80 - BF
			0x08b0, 0x08ca, 0x08d4, 0x08ee, 0x08fa, 0x090c, 0x0918, 0x0924,
			0x0934, 0x094a, 0x0956, 0x0976, 0x0980, 0x0996, 0x09a8, 0x09bc,
			0x09c6, 0x09ce, 0x09da, 0x09ec, 0x09fc, 0x0a06, 0x0a21, 0x0a2b,
			0x0a3b, 0x0a49, 0x0a5d, 0x0a69, 0x0a7d, 0x0a8b, 0x0a9b, 0x0ab1,
			0x0abd, 0x0ad1, 0x0ae1, 0x0aed, 0x0aff, 0x0b09, 0x0b1b, 0x0b2f,
			0x0b37, 0x0b49, 0x0b53, 0x0b6a, 0x0b78, 0x0b8a, 0x0b94, 0x0b9c,
			0x0ba4, 0x0bae, 0x0bae, 0x0bc0, 0x0bc8, 0x0bd0, 0x0bd0, 0x0bde,
			0x0bf2, 0x0bf2, 0x0bf2, 0x0bfa, 0x0c08, 0x0c18, 0x0c18, 0x0c28,
			// Entry C0 - FF
			0x0c28, 0x0c4a, 0x0c68, 0x0c74, 0x0c88, 0x0c9c, 0x0c9c, 0x0caa,
			0x0caa, 0x0caa, 0x0caa, 0x0caa, 0x0caa, 0x0cb0, 0x0cb0, 0x0cc6,
			0x0cc6, 0x0cd2, 0x0cd2, 0x0ce4, 0x0ce4, 0x0cee, 0x0cee, 0x0cee,
			0x0cee, 0x0cee, 0x0cf8, 0x0cf8, 0x0d00, 0x0d00, 0x0d00, 0x0d25,
			0x0d37, 0x0d37, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d4b, 0x0d4b, 0x0d4b,
			0x0d4b, 0x0d4b, 0x0d53, 0x0d53, 0x0d63, 0x0d6d, 0x0d6d, 0x0d77,
			0x0d77, 0x0d77, 0x0d77, 0x0d77, 0x0d77, 0x0d85, 0x0d8d, 0x0d97,
			0x0d97, 0x0d9f, 0x0da7, 0x0da7, 0x0db1, 0x0db1, 0x0dbd, 0x0dc7,
			// Entry 100 - 13F
			0x0deb, 0x0df9, 0x0df9, 0x0df9, 0x0e09, 0x0e09, 0x0e15, 0x0e29,
			0x0e33, 0x0e33, 0x0e33, 0x0e3f, 0x0e3f, 0x0e49, 0x0e49, 0x0e63,
			0x0e63, 0x0e6d, 0x0e6d, 0x0e82, 0x0e82, 0x0e8e, 0x0e96, 0x0e9e,
			0x0e9e, 0x0ec4, 0x0ed2, 0x0ed2, 0x0ed2, 0x0ed2, 0x0ede, 0x0ede,
			0x0ede, 0x0ef4, 0x0ef4, 0x0efa, 0x0efa, 0x0efa, 0x0f1a, 0x0f1a,
			0x0f1a, 0x0f1a, 0x0f2e, 0x0f32, 0x0f46, 0x0f46, 0x0f46, 0x0f46,
			0x0f46, 0x0f4e, 0x0f5e, 0x0f5e, 0x0f5e, 0x0f5e, 0x0f5e, 0x0f5e,
			0x0f70, 0x0f70, 0x0f70, 0x0f96, 0x0fbd, 0x0fbd, 0x0fbd, 0x0fc7,
			// Entry 140 - 17F
			0x0fd6, 0x0fd6, 0x0fd6, 0x0fe8, 0x0fe8, 0x0ffc, 0x0ffc, 0x1006,
			0x1022, 0x1022, 0x102a, 0x1032, 0x103e, 0x104c, 0x105e, 0x105e,
			0x105e, 0x106a, 0x1076, 0x1084, 0x1084, 0x1084, 0x1084, 0x1084,
			0x1098, 0x10aa, 0x10b2, 0x10bc, 0x10bc, 0x10d6, 0x10d6, 0x10df,
			0x10ed, 0x1105, 0x1105, 0x110d, 0x110d, 0x1117, 0x1117, 0x112c,
			0x112c, 0x112c, 0x1134, 0x1146, 0x1156, 0x1171, 0x117f, 0x117f,
			0x1189, 0x11ac, 0x11ac, 0x11ac, 0x11c0, 0x11ca, 0x11d8, 0x11e2,
			0x11f4, 0x1204, 0x1204, 0x1210, 0x121a, 0x121a, 0x121a, 0x122e,
			// Entry 180 - 1BF
			0x122e, 0x122e, 0x122e, 0x123a, 0x123a, 0x1244, 0x124c, 0x1267,
			0x1267, 0x127a, 0x127a, 0x1284, 0x128a, 0x1292, 0x129a, 0x129a,
			0x129a, 0x12ac, 0x12ac, 0x12b8, 0x12c8, 0x12d6, 0x12e4, 0x12f0,
			0x12f0, 0x1304, 0x1304, 0x130e, 0x1316, 0x1326, 0x1326, 0x133d,
			0x1345, 0x1351, 0x1367, 0x1367, 0x1373, 0x137d, 0x1385, 0x1385,
			0x1393, 0x13aa, 0x13b8, 0x13d0, 0x13d0, 0x13d0, 0x13d0, 0x13e2,
			0x13fe, 0x13fe, 0x141a, 0x1422, 0x143c, 0x1448, 0x1450, 0x1458,
			0x1458, 0x1464, 0x1475, 0x1487, 0x14a5, 0x14a5, 0x14ab, 0x14c6,
			// Entry 1C0 - 1FF
			0x14ce, 0x14ce, 0x14ce, 0x14de, 0x14de, 0x14de, 0x14de, 0x14de,
			0x14f2, 0x14f2, 0x1502, 0x1517, 0x1521, 0x1521, 0x1542, 0x1542,
			0x1542, 0x1560, 0x1560, 0x1576, 0x1576, 0x1576, 0x1576, 0x1584,
			0x15aa, 0x15b2, 0x15b2, 0x15ce, 0x15dc, 0x15ec, 0x15ec, 0x15ec,
			0x15f6, 0x15f6, 0x15f6, 0x15f6, 0x15f6, 0x160a, 0x1610, 0x161e,
			0x162c, 0x162c, 0x163a, 0x163a, 0x1648, 0x1648, 0x1656, 0x1660,
			0x1676, 0x168c, 0x168c, 0x16ac, 0x16ac, 0x16b4, 0x16b4, 0x16b4,
			0x16cf, 0x16ed, 0x16ed, 0x16ff, 0x1705, 0x1705, 0x1705, 0x1705,
			// Entry 200 - 23F
			0x1705, 0x1725, 0x173e, 0x1759, 0x1774, 0x1782, 0x1782, 0x1799,
			0x1799, 0x17a1, 0x17a1, 0x17ad, 0x17ad, 0x17bf, 0x17d1, 0x17d1,
			0x17e3, 0x17e3, 0x17e3, 0x17ed, 0x17f5, 0x17f5, 0x17ff, 0x1809,
			0x1809, 0x1809, 0x1809, 0x1817, 0x1817, 0x1817, 0x1817, 0x1817,
			0x1828, 0x1828, 0x1834, 0x1834, 0x1834, 0x1834, 0x1842, 0x184e,
			0x185c, 0x186e, 0x18a3, 0x18b5, 0x18b5, 0x18c3, 0x18cf, 0x18d5,
			0x18d5, 0x18d5, 0x18d5, 0x18d5, 0x18d5, 0x18d5, 0x18e1, 0x18f3,
			0x1901, 0x190b, 0x190b, 0x191b, 0x191b, 0x192d, 0x192d, 0x1935,
			// Entry 240 - 27F
			0x1935, 0x1935, 0x1941, 0x194b, 0x194b, 0x197f, 0x198d, 0x198d,
			0x198d, 0x198d, 0x19cb, 0x19d3, 0x19fd, 0x1a09, 0x1a41, 0x1a41,
			0x1a68, 0x1aa6, 0x1ad5, 0x1afc, 0x1b25, 0x1b52, 0x1b89, 0x1bb2,
			0x1bdd, 0x1bdd, 0x1c06, 0x1c33, 0x1c51, 0x1c67, 0x1c98, 0x1cc9,
			0x1cf0, 0x1d10, 0x1d37, 0x1d5e, 0x1d87,
		},
	},
	{ // bem
		"Ichi AkanIchi AmhariIchi ArabIchi BelarusIchi BulgarianiIchi BengaliIchi" +
			" ChekiIchi JemaniIchi GrikiIchi SunguIchi SpanishiIchi PesiaIchi Fre" +
			"nchiIchi HausaIchi HinduIchi HangarianIchi IndonesianiIchi IboIchi I" +
			"talianiIchi JapanisiIchi JavanisiIchi KhmerIchi KorianiIchi Maleshan" +
			"iIchi BurmaIchi NepaliIchi DachiIchi PunjabiIchi PolishiIchi Potogis" +
			"iIchi RomanianiIchi RusianiIchi RwandaIchi SomaliaIchi SwideniIchi T" +
			"amilIchi ThaiIchi TakishiIchi UkranianiIchi UruduIchi VietinamuIchi " +
			"YorubaIchi ChainisiIchi ZuluIchibemba",
		[]uint16{ // 219 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x0029, 0x0038,
			0x0038, 0x0038, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0063, 0x006d, 0x006d, 0x007a,
			0x007a, 0x007a, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x009a,
			0x009a, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00b2, 0x00b2, 0x00b2,
			// Entry 40 - 7F
			0x00b2, 0x00c2, 0x00c2, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ca,
			0x00d7, 0x00d7, 0x00e4, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1,
			0x00f1, 0x00f1, 0x00fb, 0x00fb, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0115, 0x0115, 0x011f, 0x011f, 0x011f,
			0x012a, 0x012a, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0140, 0x0140, 0x014c,
			// Entry 80 - BF
			0x014c, 0x0159, 0x0159, 0x0159, 0x0159, 0x0167, 0x0173, 0x017e,
			0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e, 0x017e,
			0x017e, 0x017e, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a, 0x018a,
			0x0196, 0x0196, 0x01a0, 0x01a0, 0x01a0, 0x01a9, 0x01a9, 0x01a9,
			0x01a9, 0x01a9, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01b5, 0x01c3,
			0x01cd, 0x01cd, 0x01cd, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01e6, 0x01e6, 0x01f3, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			// Entry C0 - FF
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc, 0x01fc,
			0x01fc, 0x01fc, 0x0205,
		},
	},
	{ // bez
		"HiakanHiamhariHiharabuHibelarusiHibulgariaHibanglaHichekiHijerumaniHigir" +
			"ikiHiingerezaHihispaniaHiajemiHifaransaHihausaHihindiHihungariHiindo" +
			"nesiaHiiboHiitalianoHijapaniHijavaHikambodiaHikoreaHimalesiaHiburmaH" +
			"inepaliHiholanziHipunjabiHipolandiHilenoHilomaniaHilusiHinyarwandaHi" +
			"somaliHiswidiHitamilHitailandHitulukiHiukraniaHiurduHivietinamuHiyor" +
			"ubaHichinaHizuluHibena",
		[]uint16{ // 221 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0055, 0x0055, 0x005f,
			0x005f, 0x005f, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x006f,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x0076,
			0x0076, 0x007d, 0x007d, 0x007d, 0x007d, 0x0086, 0x0086, 0x0086,
			// Entry 40 - 7F
			0x0086, 0x0091, 0x0091, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0142,
			0x0148, 0x0148, 0x0148, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
			0x0153, 0x015b, 0x015b, 0x0162, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			// Entry C0 - FF
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0168, 0x0168, 0x016e,
		},
	},
	{ // bg
		bgLangStr,
		bgLangIdx,
	},
	{ // bm
		"akankanamarikikanlarabukanbiyelorisikanbuligarikanbamanakanbɛngalikancɛk" +
			"ikanalimaɲikangɛrɛsikanangilɛkanesipaɲolkanperisanikantubabukanawusa" +
			"kaninidikanoŋirikanƐndonezikanigibokanitalikanzapɔnekanjavanekankamb" +
			"ojikankorekanmalɛzikanbirimanikannepalekanolandekanpɛnijabikanpolone" +
			"kanpɔritigalikanrumanikanirisikanruwandakansomalikansuwɛdikantamulik" +
			"antayikanturikikanukɛrɛnikanurudukanwiyɛtinamukanyorubakansiniwakanz" +
			"ulukan",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0011, 0x0011,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x0027, 0x0032,
			0x0032, 0x003b, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0064, 0x006e, 0x006e, 0x007a,
			0x007a, 0x007a, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x0096,
			0x0096, 0x009e, 0x009e, 0x009e, 0x009e, 0x00a7, 0x00a7, 0x00a7,
			// Entry 40 - 7F
			0x00a7, 0x00b3, 0x00b3, 0x00bb, 0x00bb, 0x00bb, 0x00bb, 0x00bb,
			0x00c3, 0x00c3, 0x00cd, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00f1, 0x00f1, 0x00fc, 0x00fc, 0x00fc,
			0x0105, 0x0105, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x011a, 0x011a, 0x0123,
			// Entry 80 - BF
			0x0123, 0x0131, 0x0131, 0x0131, 0x0131, 0x013a, 0x0142, 0x014c,
			0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c,
			0x014c, 0x014c, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155,
			0x015f, 0x015f, 0x0168, 0x0168, 0x0168, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0184,
			0x018c, 0x018c, 0x018c, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a,
			0x019a, 0x01a3, 0x01a3, 0x01ac, 0x01b3,
		},
	},
	{ // bn
		bnLangStr,
		bnLangIdx,
	},
	{ // bn-IN
		"কোলোনিয়ান",
		[]uint16{ // 377 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x001e,
		},
	},
	{ // bo
		"བོད་སྐད་རྫོང་ཁདབྱིན་ཇིའི་སྐད།ཧིན་དིཉི་ཧོང་སྐད་ནེ་པ་ལིཨུ་རུ་སུ་སྐད་རྒྱ་སྐ" +
			"ད་ཟ་ཟའ་སྐད།དབྱིན་ཇིའི་སྐད། (ཁེ་ན་ཌ་)དབྱིན་ཇིའི་སྐད། (དབྱིན་ལན་)དབྱ" +
			"ིན་ཇིའི་སྐད། (ཨ་རི་)",
		[]uint16{ // 598 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x002a, 0x002a, 0x002a, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			// Entry 40 - 7F
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f,
			0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f,
			// Entry 80 - BF
			0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry C0 - FF
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 100 - 13F
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 140 - 17F
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 180 - 1BF
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 1C0 - 1FF
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 200 - 23F
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			// Entry 240 - 27F
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00f9, 0x00f9, 0x00f9,
			0x00f9, 0x00f9, 0x00f9, 0x013e, 0x0189, 0x01c8,
		},
	},
	{}, // bo-IN
	{ // br
		"afarabkhazegavestegafrikaansakanamharegaragonegarabegasamegavaraymaraaze" +
			"rbaidjanegbachkirbelarusegbulgaregbislamabambarabengalitibetanegbrez" +
			"honegbosnegkatalanegtchetchenegchamorrukorsegkritchekegslavoneg iliz" +
			"tchouvatchkembraegdanegalamanegdivehidzongkhaewegresianegsaoznegespe" +
			"rantegspagnolegestonegeuskaregpersegfinnegfidjiegfaeroeggallegfrizeg" +
			" ar Cʼhornôgiwerzhonegskoseggalizegguaranigujaratimanaveghaousahebra" +
			"eghindihiri motukroateghaitieghungaregarmenianeghererointerlinguaind" +
			"onezeginterlingueigboyieg Sichuaninupiaqidoislandegitalianeginuktitu" +
			"tjapanegjavanegjorjianegkongokikuyukwanyamakazakkhmerkanaregkoreaneg" +
			"kanourikashmirikurdegkerneveuregkirgizlatinluksembourgeggandalimbour" +
			"geglingalalaoseglituanegluba-katangalatviegmalgachegmarshallmaorimak" +
			"edonegmalayalammongolegmarathimalaysegmaltegbirmanegnauruegndebele a" +
			"n Norzhnepalegndonganederlandegnorvegeg nynorsknorvegeg bokmålndebel" +
			"e ar Sunavacʼhonyanjaokitanegojibwaoriyaosetegpunjabipalipolonegpach" +
			"toportugalegkechuaegromañchegrundiroumanegrusianegkinyarwandasanskri" +
			"tegsardegsindhisámi an Norzhsangosinghalegslovakegslovenegsamoanshon" +
			"asomalialbanegserbegswatisotho ar Susundanegsvedegswahilitamilegtelo" +
			"ugoutadjikthaitigrignaturkmenegtswanatongaturkegtsongatatartahitiane" +
			"gouigouregukrainegourdououzbekegvendavietnamegvolapükwallonegwolofxh" +
			"osayiddishyoroubazhuangsinaegzoulouegachinegacoliadangmeadygeiegarab" +
			"eg Tuniziaafrihiliaghemainouegakadegalabamaegaleouteggegegaltaieg ar" +
			" Suhensaoznegangikaarameegaraoukanegaraonaarapahoarabeg Aljeriaarawa" +
			"kegarabeg Marokoarabeg Egiptasuyezh sinoù Amerikaasturianegawadhibal" +
			"outchibalinegbavariegbasaabedawiegbembabenabaloutchi ar Cʼhornôgbhoj" +
			"puribikolbinibrajbrahwegbodoakoosebouriatbugiblincaddokaribegatsamce" +
			"buanochibchamariegchoktawchipewyancherokeecheyennekurdeg soranikopte" +
			"gturkeg Krimeakachoubegdakotadargwadelawaredogribdinkadogriizelsorab" +
			"egnederlandeg krenndyulaembuefikhenegiptegekajukelamegkrennsaoznegew" +
			"ondofangfilipinegfinneg traoñienn an Tornefongalleg cajunkrenncʼhall" +
			"eghencʼhallegarpitanegfrizeg an Norzhfrizeg ar Reterfrioulaneggagaga" +
			"ouzegsinaeg Gangayogbayagezeggilbertegkrennalamaneg uhelhenalamaneg " +
			"uhelgorontalogoteggrebohencʼhresianegalamaneg Suishaidasinaeg Hakkah" +
			"awaieghiligaynonhmonguhelsorabegsinaeg Xianhupaibanibibioingouchegkr" +
			"eoleg Jamaikayuzev-persegyuzev-arabegkarakalpakkabilegkachinkambakab" +
			"ardegkabuverdianukhasikhotanegkimbundukonkanikosraekpellekaratchay-b" +
			"alkarkareliegkurukhkolunegkutenailadinolahndalambalezgilingua franca" +
			" novaliguriegmongoloziluba-lulualuisenolundaluolushailuyiasinaeg len" +
			"negelmagahimaithilimasaimokshamandarmendemorisegkrenniwerzhonegmanch" +
			"oumanipurimohawkmarieg ar Cʼhornôgyezhoù liesmuskogimirandegerzasina" +
			"eg Min Nannapolitanegalamaneg izelnewariniasniueaoegnogayhennorsegno" +
			"vialsotho an Norzhnewari klaselnyamwezinyankolenyoroosageturkeg otom" +
			"anpangasinanpahlavipampangapapiamentopalaupikardegalamaneg Pennsylva" +
			"niahenbersegfenikianegpiemontegpontegpohnpeihenbruseghenbrovañsegkic" +
			"huaeg Chimborazorajasthanirapanuirarotongaromagnolegromboromaniegaro" +
			"umanegrwasandaweyakoutegarameeg ar Samaritanedsasaksantalisikiliegsk" +
			"otegsasaresegheniwerzhonegtachelitegshanarabeg Tchadsidamosámi ar Su" +
			"sámi Luleåsámi Inarisámi Skoltsoninkesogdiegserersumeregkomoregsirie" +
			"g klaselsiriegsileziegtoulouegterenotetumtigreanegtivtokelauklingont" +
			"inglittamachegnyasa tongatok pisinturoyoegtsimshiantumbukatuvalutouv" +
			"atamazigteg Kreizatlasoudmourtegougaritegumbunduyezh dianavvaivenezi" +
			"egvepsegflandrezeg ar c’hornôgvotyakegvoroegwalserwalamowaraywashosi" +
			"naeg WukalmoukmegrelegyaoyapegkantonegzapotegBlisszelandegzenagatama" +
			"cheg Maroko standartzunidiyezharabeg modernalamaneg Aostriaalamaneg " +
			"uhel Suissaozneg Aostraliasaozneg Kanadasaozneg Breizh-Veursaozneg A" +
			"merikaspagnoleg Amerika latinspagnoleg Europaspagnoleg Mecʼhikogalle" +
			"g Kanadagalleg Suissaksoneg izelflandrezegportugaleg Brazilportugale" +
			"g Europamoldovegserb-kroategswahili Kongosinaeg eeunaetsinaeg hengou" +
			"nel",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000c, 0x0013, 0x001c, 0x0020, 0x0027, 0x002f,
			0x0035, 0x003b, 0x003f, 0x0045, 0x0052, 0x0059, 0x0062, 0x006a,
			0x0071, 0x0078, 0x007f, 0x0088, 0x0091, 0x0097, 0x00a0, 0x00ab,
			0x00b3, 0x00b9, 0x00bc, 0x00c3, 0x00d0, 0x00da, 0x00e2, 0x00e7,
			0x00ef, 0x00f5, 0x00fd, 0x0100, 0x0109, 0x0110, 0x011a, 0x0123,
			0x012a, 0x0132, 0x0138, 0x0138, 0x013e, 0x0145, 0x014c, 0x0152,
			0x0166, 0x0170, 0x0176, 0x017d, 0x0184, 0x018c, 0x0193, 0x0199,
			0x01a0, 0x01a5, 0x01ae, 0x01b5, 0x01bc, 0x01c4, 0x01ce, 0x01d4,
			// Entry 40 - 7F
			0x01df, 0x01e8, 0x01f3, 0x01f7, 0x0203, 0x020a, 0x020d, 0x0215,
			0x021e, 0x0227, 0x022e, 0x0235, 0x023e, 0x0243, 0x0249, 0x0251,
			0x0256, 0x0256, 0x025b, 0x0262, 0x026a, 0x0271, 0x0279, 0x027f,
			0x027f, 0x028a, 0x0290, 0x0295, 0x02a2, 0x02a7, 0x02b1, 0x02b8,
			0x02be, 0x02c6, 0x02d2, 0x02d9, 0x02e2, 0x02ea, 0x02ef, 0x02f8,
			0x0301, 0x0309, 0x0310, 0x0318, 0x031e, 0x0326, 0x032d, 0x033d,
			0x0344, 0x034a, 0x0355, 0x0365, 0x0375, 0x0382, 0x038b, 0x0391,
			0x0399, 0x039f, 0x039f, 0x03a4, 0x03aa, 0x03b1, 0x03b5, 0x03bc,
			// Entry 80 - BF
			0x03c2, 0x03cc, 0x03d4, 0x03de, 0x03e3, 0x03eb, 0x03f3, 0x03fe,
			0x0408, 0x040e, 0x0414, 0x0422, 0x0427, 0x0430, 0x0438, 0x0440,
			0x0446, 0x044b, 0x0451, 0x0458, 0x045e, 0x0463, 0x046e, 0x0476,
			0x047c, 0x0483, 0x048a, 0x0492, 0x0498, 0x049c, 0x04a4, 0x04ad,
			0x04b3, 0x04b8, 0x04be, 0x04c4, 0x04c9, 0x04d3, 0x04dc, 0x04e4,
			0x04ea, 0x04f2, 0x04f7, 0x0500, 0x0508, 0x0510, 0x0515, 0x051a,
			0x0521, 0x0528, 0x052e, 0x0534, 0x053c, 0x0543, 0x0548, 0x054f,
			0x0557, 0x0565, 0x056d, 0x0572, 0x0579, 0x057f, 0x0588, 0x0590,
			// Entry C0 - FF
			0x0595, 0x05a2, 0x05ac, 0x05b2, 0x05b9, 0x05c3, 0x05c9, 0x05d0,
			0x05de, 0x05de, 0x05e6, 0x05f3, 0x05ff, 0x0602, 0x0615, 0x061f,
			0x061f, 0x0625, 0x062e, 0x0635, 0x063d, 0x0642, 0x0642, 0x0642,
			0x0642, 0x064a, 0x064f, 0x064f, 0x0653, 0x0653, 0x0653, 0x066a,
			0x0672, 0x0677, 0x067b, 0x067b, 0x067b, 0x067b, 0x067b, 0x067b,
			0x067f, 0x0686, 0x068a, 0x0690, 0x0697, 0x069b, 0x069b, 0x069f,
			0x069f, 0x06a4, 0x06ab, 0x06ab, 0x06b0, 0x06b7, 0x06b7, 0x06be,
			0x06be, 0x06be, 0x06c4, 0x06c4, 0x06cb, 0x06d4, 0x06dc, 0x06e4,
			// Entry 100 - 13F
			0x06f1, 0x06f7, 0x06f7, 0x0704, 0x0704, 0x070d, 0x0713, 0x0719,
			0x0719, 0x0721, 0x0721, 0x0727, 0x072c, 0x072c, 0x0731, 0x073c,
			0x073c, 0x073c, 0x074d, 0x074d, 0x0752, 0x0752, 0x0756, 0x075a,
			0x075a, 0x0764, 0x076a, 0x0770, 0x077c, 0x077c, 0x0782, 0x0782,
			0x0786, 0x078f, 0x07a9, 0x07ac, 0x07b8, 0x07c6, 0x07d2, 0x07db,
			0x07ea, 0x07f9, 0x0803, 0x0805, 0x080e, 0x0818, 0x081c, 0x0821,
			0x0821, 0x0826, 0x082f, 0x082f, 0x0841, 0x0851, 0x0851, 0x0851,
			0x085a, 0x085f, 0x0864, 0x0873, 0x0880, 0x0880, 0x0880, 0x0880,
			// Entry 140 - 17F
			0x0880, 0x0885, 0x0891, 0x0898, 0x0898, 0x08a2, 0x08a2, 0x08a7,
			0x08b2, 0x08bd, 0x08c1, 0x08c5, 0x08cb, 0x08cb, 0x08d4, 0x08d4,
			0x08e3, 0x08e3, 0x08e3, 0x08e3, 0x08ef, 0x08fb, 0x08fb, 0x0905,
			0x090c, 0x0912, 0x0912, 0x0917, 0x0917, 0x091f, 0x091f, 0x091f,
			0x091f, 0x092b, 0x092b, 0x092b, 0x092b, 0x0930, 0x0938, 0x0938,
			0x0938, 0x0938, 0x0938, 0x0938, 0x0940, 0x0940, 0x0947, 0x094d,
			0x0953, 0x0963, 0x0963, 0x0963, 0x096b, 0x0971, 0x0971, 0x0971,
			0x0978, 0x0978, 0x097f, 0x0985, 0x0985, 0x098b, 0x0990, 0x0995,
			// Entry 180 - 1BF
			0x09a7, 0x09af, 0x09af, 0x09af, 0x09af, 0x09b4, 0x09b8, 0x09b8,
			0x09b8, 0x09c2, 0x09c9, 0x09ce, 0x09d1, 0x09d7, 0x09dc, 0x09eb,
			0x09eb, 0x09eb, 0x09eb, 0x09f1, 0x09f9, 0x09f9, 0x09f9, 0x09fe,
			0x09fe, 0x0a04, 0x0a0a, 0x0a0f, 0x0a0f, 0x0a16, 0x0a25, 0x0a25,
			0x0a25, 0x0a25, 0x0a25, 0x0a2c, 0x0a34, 0x0a3a, 0x0a3a, 0x0a4e,
			0x0a4e, 0x0a5a, 0x0a61, 0x0a69, 0x0a69, 0x0a69, 0x0a69, 0x0a6d,
			0x0a6d, 0x0a7b, 0x0a86, 0x0a86, 0x0a93, 0x0a99, 0x0a9d, 0x0aa1,
			0x0aa5, 0x0aa5, 0x0aa5, 0x0aaa, 0x0ab3, 0x0ab9, 0x0ab9, 0x0ac7,
			// Entry 1C0 - 1FF
			0x0ac7, 0x0ad4, 0x0adc, 0x0ae4, 0x0ae9, 0x0ae9, 0x0aee, 0x0afb,
			0x0b05, 0x0b0c, 0x0b14, 0x0b1e, 0x0b23, 0x0b2b, 0x0b2b, 0x0b40,
			0x0b40, 0x0b49, 0x0b49, 0x0b53, 0x0b5c, 0x0b62, 0x0b69, 0x0b72,
			0x0b7f, 0x0b7f, 0x0b92, 0x0b9c, 0x0ba3, 0x0bac, 0x0bb6, 0x0bb6,
			0x0bbb, 0x0bc3, 0x0bc3, 0x0bc3, 0x0bc3, 0x0bcc, 0x0bcf, 0x0bd6,
			0x0bde, 0x0bf4, 0x0bf4, 0x0bf9, 0x0c00, 0x0c00, 0x0c00, 0x0c00,
			0x0c08, 0x0c0e, 0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c17, 0x0c17,
			0x0c17, 0x0c24, 0x0c24, 0x0c2e, 0x0c32, 0x0c3e, 0x0c44, 0x0c44,
			// Entry 200 - 23F
			0x0c44, 0x0c4f, 0x0c5b, 0x0c66, 0x0c71, 0x0c78, 0x0c7f, 0x0c7f,
			0x0c84, 0x0c84, 0x0c84, 0x0c84, 0x0c84, 0x0c8b, 0x0c92, 0x0c9f,
			0x0ca5, 0x0cad, 0x0cb5, 0x0cb5, 0x0cb5, 0x0cbb, 0x0cc0, 0x0cc9,
			0x0ccc, 0x0cd3, 0x0cd3, 0x0cda, 0x0ce1, 0x0ce1, 0x0ce9, 0x0cf4,
			0x0cfd, 0x0d05, 0x0d05, 0x0d05, 0x0d0e, 0x0d0e, 0x0d15, 0x0d1b,
			0x0d1b, 0x0d20, 0x0d35, 0x0d3f, 0x0d48, 0x0d4f, 0x0d5a, 0x0d5d,
			0x0d65, 0x0d6b, 0x0d84, 0x0d84, 0x0d8c, 0x0d92, 0x0d92, 0x0d98,
			0x0d9e, 0x0da3, 0x0da8, 0x0da8, 0x0db1, 0x0db8, 0x0dc0, 0x0dc0,
			// Entry 240 - 27F
			0x0dc3, 0x0dc8, 0x0dc8, 0x0dc8, 0x0dc8, 0x0dd0, 0x0dd7, 0x0ddc,
			0x0de4, 0x0dea, 0x0e02, 0x0e06, 0x0e0c, 0x0e0c, 0x0e19, 0x0e19,
			0x0e29, 0x0e3b, 0x0e4c, 0x0e5a, 0x0e6d, 0x0e7c, 0x0e93, 0x0ea3,
			0x0eb6, 0x0eb6, 0x0ec3, 0x0ece, 0x0edb, 0x0ee5, 0x0ef6, 0x0f07,
			0x0f0f, 0x0f1b, 0x0f28, 0x0f36, 0x0f46,
		},
	},
	{ // brx
		"अब्खाज़ियन्अवस्तन्अफ्रीकीअकनअम्हारिक्आर्गोनीअरबीअसामीअवारिक्आयमाराअज़रबै" +
			"जानीबशख़िर्बैलोरूसियन्बल्गैरियन्बिस्लामाबांबाराबंगलातिब्बतीब्रटोंब" +
			"ोस्नियाईकातालान्चेचेन्चामोरोकोर्सीकन्क्रीचेक्चर्च स्लाविक्चुवाश्वै" +
			"ल्श्डैनीश्ज़र्मनदीवेहीभुटानीएवेग्रीकअंग्रेज़ीएस्पेरान्तोस्पैनिशऐस्" +
			"टोनियन्बास्क्फार्सीफुलाह्फिनिश्फ़ीजीफिरोज़ीफ्रांसीसीपश्चीमी फ्रीज़" +
			"ियन्आईरिशस्कॉट्स् गैलिक्गैलिशियन्गुआरानीगुजरातीमैंक्सहउसाहिब्रुहिं" +
			"दीहीरी मोटुक्रोएशन्हाईशीयन्हंगैरीयन्अरमेनियन्हेरेरोईन्टरलिंग्वाइन्" +
			"डोनेशियन्ईन्टरलिंग्वेईग्बोसीचुआन् यीइनुपियाक़्ईडोआईस्लैंडिक्ईटालिय" +
			"न्इनूक्टीटूत्जापानीजावानीसजॉर्जियन्कॉंगोकिकुयुकुआनयामाक़ज़ाख़्कलाल" +
			"ीसुतख्मेरकन्नड्कोरीयन्कनुरीकश्मिरीकुर्दीकोमीकौर्नवॉलीकिरग़ीज़्लैटी" +
			"न्लुक्समबुर्गीगांडालींबुर्गीलिंगालालाओसीयन्लिथुआनियन्लुबा कटांगाला" +
			"टवियन् (लैट्टीश)मालागासीमार्शलीमाओरीमैसेडोनियन्मलयालममोंगोलियनमराठ" +
			"ीमलायमालटीज़्बर्मीनाऊरूउत्तर न्दबेलेनेपालीन्डोंगाडच्नॉर्वेजियन् नी" +
			"नॉर्स्क्नोर्वेगी बोकमालदक्षिणी न्दबेलेनावाहोन्यानजाओक्सीतानओहीबवाओ" +
			"रोमो (अफ़ान)उड़ियाओस्सेटीपंजाबीपालीपोलिशपख़्तुपुर्तगालीक्वेचुआरेह्" +
			"टो-रोमान्सकिरून्दीरूमानीयन्रुसीकिन्यारुआण्डासंस्कृत्सार्दीनीसिंधीउ" +
			"त्तरी सामीसांग्रोसींहालास्लोवाक्स्लोवेनियन्सामोअनशोनासोमालीआल्बेनि" +
			"यन्सर्बियन्स्वाटिसुन्दानीस्वीडिशस्वाहिलीतमिळतेलुगुताजिक्थाईतिग्रीन" +
			"्यातुर्कमेनत्स्वानाटॉंगातुर्कीसोंगाटाटर्टाहिटिउईग़ुरयूक्रेनियन्ऊर्" +
			"दुउज़बेक्वेंडावियेतनामीवोलापोकवालुनवोलोफख़ोसायीद्दीशयोरूबाज़ुआंगची" +
			"नीज़ुलूअचेहनीअकोलीअडांगमेअडीगेअफ्रीहीलीऐनूअकाडिनीअलुटपुरानी अंग्रे" +
			"ज़ीअंगीकाअरामाईकअरापाहोअरावाकअवधीबलूचीबालिनीबास्क़्बेजाबेंबाभोजपुर" +
			"ीबिकोल्बिनीसीकसीकाब्रजबड़ोबुरियातबुगीनीब्लीनकाद्दौकारीब्आत्समचेबुआ" +
			"नोचीबचाचगताईचुकेसेमारीचीनूक् जार्गन्चौक्टोचिपेवियान्चीरोकीशायान्कॉ" +
			"प्टीक्तुर्की क्रिमियाकाशुबियान्डकौटादर्गवादलावार्स्लेव्डोगरीब्डींग" +
			"काडोगरीसोर्बियन्डुआलामध्य डचद्युआलाएफीक्प्राचीन मिस्रीएकाजुकएलामीम" +
			"ध्य अंग्रेज़ीएवौंडोफाँग्फिलिपिनोफोनमध्य फ्रांसीसीपुरानी फ्रांसीसीउ" +
			"त्तरी फ्रीज़ियन्पूर्वी फ्रीज़ियन्फ्रीउलीअन्गागायोग्बायागीज़्गीलबर्" +
			"टीमध्य उच्चस्तरी जर्मनपुरानी उच्चस्तरी जर्मनगाँडीगोरंटालोगॉथिकग्रे" +
			"बोप्राचीन यूनानीस्वीस जर्मनग्वीचलीनहईडाहवाईअनहीलीगैनोनहीत्तीह्मौंग" +
			"ऊपरी सौर्बियनहूपाईबान्ईलोकोईंगुषलोजबानयहुदी फ़ारसीयहुदी अरबीकारा क" +
			"लपककाबील्कचीन्जुकंबाकावीकबार्डी भाषात्याप्कोरोख़ासीख़ोतानीकींबुंडु" +
			"कोंकणीकोस्राईयन्क्पेलेकराचय् बलकार्करेलियन्कुरुख़्कुमीक्कुतेनाईलाड" +
			"़ीनोलाह्डांलांबालेज़गीयानमोंगोलोज़ीलुबा लुलुआलुईसेनोलुंडालुओलुशाईम" +
			"ादुरीमघीमैथीलीमक्सरमांडींगोमसाईमोक्षामंदारमेंदेमध्य आईरीश भाषामीकम" +
			"ाकमिनंगकाबाउमांचुमणीपुरीमोहोकमोस्सीक्रीकमीरांडीमारवाड़ीऐर्ज़ियानेआ" +
			"पोलिटननीजी स्तरिय जर्मननेवारीनियासनियुइआननोगाईपुरानी नॉर्स्न्गकोपु" +
			"रानी नेवारीन्यामवेज़ीन्यानकोलेन्यौरोन्ज़ीमाओसेजतुर्की ओटोमानपांगास" +
			"ीननपहलवीपंपंगापापीआमेन्तोपालाऊपुरानी फ़ारसीफीनीसीपोहनपीपुरानी प्रो" +
			"वाँसालराजस्थानीरापानुईरारोटोंगारुमानीआरोमानीसंडावेयकुट्समारीती आरा" +
			"माईक़सासकसंतालीसीसीलीअनस्कॉटसेलकुपपुरानी आईरीशशानसीदामोपश्चीमी साम" +
			"ीलुले सामीईनारी सामीस्कोल्ट् सामीसोनिंगकेसोगडीयनस्रनान् टॉंगोसेरेर" +
			"सुकुमासुसुसुमेरिअनपारंपरीक सिरिआकसिरिआकतीमनेतेरेनोतेतुमटीग्रेटीव्ट" +
			"ोकेलौक्लींगदनट्लिंगीततमाशेकन्यासा टॉंगातोक पिसीनत्सीमशीआन्टुँबुकाट" +
			"ुवालुटुवीउड़मुर्तउगारितीउंबुंडुरुटवाईवोटीकवालामोवारयवाशोकालमीकयाओय" +
			"ापीज़ज़ापोतेकब्लीस चिन्हज़ेनागाज़ुनीरिक्तज़ाज़ाजर्मन (ऑस्ट्रिया)उच" +
			"्च स्तरिय स्वीस जर्मनअंग्रेज़ी (ऑस्ट्रेलिया का)अंग्रेज़ी (कनाडाई)अ" +
			"ंग्रेजी (ब्रिटिश)अंग्रेज़ी (अमरिकी)लैटिन अमरिकी स्पैनिशईवेरियाई स्" +
			"पैनिशफ्रांसीसी (कनाडाई)फ्रांसीसी (स्वीस)फ्लेमीमोल्डेवियन्सर्बो-क्र" +
			"ोएशन्चीनी (सरलीकृत)चीनी (पारम्परिक)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0021, 0x0036, 0x004b, 0x0054, 0x006f, 0x0084,
			0x0090, 0x009f, 0x00b4, 0x00c6, 0x00e4, 0x00f9, 0x011a, 0x0138,
			0x0150, 0x0165, 0x0174, 0x0189, 0x019b, 0x01b6, 0x01ce, 0x01e0,
			0x01f2, 0x020d, 0x0219, 0x0225, 0x024a, 0x025c, 0x026e, 0x0280,
			0x0292, 0x02a4, 0x02b6, 0x02bf, 0x02ce, 0x02e9, 0x030a, 0x031f,
			0x033d, 0x034f, 0x0361, 0x0373, 0x0385, 0x0394, 0x03a9, 0x03c4,
			0x03f8, 0x0407, 0x0432, 0x044d, 0x0462, 0x0477, 0x0489, 0x0495,
			0x04a7, 0x04b6, 0x04cf, 0x04e7, 0x04ff, 0x051a, 0x0535, 0x0547,
			// Entry 40 - 7F
			0x056b, 0x058f, 0x05b3, 0x05c2, 0x05de, 0x05fc, 0x0605, 0x0626,
			0x063e, 0x065f, 0x0671, 0x0686, 0x06a1, 0x06b0, 0x06c2, 0x06da,
			0x06f2, 0x070a, 0x0719, 0x072b, 0x0740, 0x074f, 0x0764, 0x0776,
			0x0782, 0x079d, 0x07b8, 0x07ca, 0x07ee, 0x07fd, 0x0818, 0x082d,
			0x0845, 0x0863, 0x0882, 0x08b2, 0x08ca, 0x08df, 0x08ee, 0x090f,
			0x0921, 0x093c, 0x094b, 0x0957, 0x096f, 0x097e, 0x098d, 0x09b2,
			0x09c4, 0x09d9, 0x09e2, 0x0a22, 0x0a4d, 0x0a78, 0x0a8a, 0x0a9f,
			0x0ab7, 0x0ac9, 0x0aea, 0x0afc, 0x0b11, 0x0b23, 0x0b2f, 0x0b3e,
			// Entry 80 - BF
			0x0b50, 0x0b6b, 0x0b80, 0x0ba8, 0x0bc0, 0x0bdb, 0x0be7, 0x0c0e,
			0x0c26, 0x0c3e, 0x0c4d, 0x0c6c, 0x0c81, 0x0c96, 0x0cae, 0x0ccf,
			0x0ce1, 0x0ced, 0x0cff, 0x0d1d, 0x0d35, 0x0d47, 0x0d47, 0x0d5f,
			0x0d74, 0x0d8c, 0x0d98, 0x0daa, 0x0dbc, 0x0dc5, 0x0de3, 0x0dfb,
			0x0e13, 0x0e22, 0x0e34, 0x0e43, 0x0e52, 0x0e64, 0x0e76, 0x0e97,
			0x0ea6, 0x0ebb, 0x0eca, 0x0ee5, 0x0efa, 0x0f09, 0x0f18, 0x0f27,
			0x0f3c, 0x0f4e, 0x0f60, 0x0f6c, 0x0f7b, 0x0f8d, 0x0f9c, 0x0fb1,
			0x0fc0, 0x0fc0, 0x0fdb, 0x0fdb, 0x0fe4, 0x0ff9, 0x0ff9, 0x1005,
			// Entry C0 - FF
			0x1005, 0x1005, 0x1033, 0x1045, 0x105a, 0x105a, 0x105a, 0x106f,
			0x106f, 0x106f, 0x1081, 0x1081, 0x1081, 0x1081, 0x1081, 0x1081,
			0x1081, 0x108d, 0x109c, 0x10ae, 0x10ae, 0x10c3, 0x10c3, 0x10c3,
			0x10c3, 0x10cf, 0x10de, 0x10de, 0x10de, 0x10de, 0x10de, 0x10de,
			0x10f3, 0x1105, 0x1111, 0x1111, 0x1111, 0x1126, 0x1126, 0x1126,
			0x1132, 0x1132, 0x113e, 0x113e, 0x1153, 0x1165, 0x1165, 0x1174,
			0x1174, 0x1186, 0x1198, 0x1198, 0x11a7, 0x11bc, 0x11bc, 0x11cb,
			0x11da, 0x11ec, 0x11f8, 0x1220, 0x1232, 0x1250, 0x1262, 0x1274,
			// Entry 100 - 13F
			0x1274, 0x128c, 0x128c, 0x12b7, 0x12b7, 0x12d5, 0x12e4, 0x12f6,
			0x12f6, 0x130b, 0x131d, 0x1332, 0x1344, 0x1344, 0x1353, 0x136e,
			0x136e, 0x137d, 0x1390, 0x1390, 0x13a5, 0x13a5, 0x13a5, 0x13b4,
			0x13b4, 0x13dc, 0x13ee, 0x13fd, 0x1425, 0x1425, 0x1437, 0x1437,
			0x1446, 0x145e, 0x145e, 0x1467, 0x1467, 0x148f, 0x14bd, 0x14bd,
			0x14ee, 0x151f, 0x153d, 0x1543, 0x1543, 0x1543, 0x154f, 0x1561,
			0x1561, 0x1570, 0x1588, 0x1588, 0x15c0, 0x15fe, 0x15fe, 0x160d,
			0x1625, 0x1634, 0x1646, 0x166e, 0x168d, 0x168d, 0x168d, 0x168d,
			// Entry 140 - 17F
			0x16a5, 0x16b1, 0x16b1, 0x16c3, 0x16c3, 0x16de, 0x16f0, 0x1702,
			0x1727, 0x1727, 0x1733, 0x1742, 0x1742, 0x1751, 0x1760, 0x1760,
			0x1760, 0x1772, 0x1772, 0x1772, 0x1794, 0x17b0, 0x17b0, 0x17c9,
			0x17db, 0x17ea, 0x17f0, 0x17fc, 0x1808, 0x182a, 0x182a, 0x183c,
			0x183c, 0x183c, 0x183c, 0x1848, 0x1848, 0x1857, 0x186c, 0x186c,
			0x186c, 0x186c, 0x186c, 0x186c, 0x1884, 0x1884, 0x1896, 0x18b4,
			0x18c6, 0x18eb, 0x18eb, 0x18eb, 0x1903, 0x1918, 0x1918, 0x1918,
			0x1918, 0x192a, 0x193f, 0x1954, 0x1954, 0x1969, 0x1978, 0x1993,
			// Entry 180 - 1BF
			0x1993, 0x1993, 0x1993, 0x1993, 0x1993, 0x19a2, 0x19b1, 0x19b1,
			0x19b1, 0x19cd, 0x19e2, 0x19f1, 0x19fa, 0x1a09, 0x1a09, 0x1a09,
			0x1a09, 0x1a1b, 0x1a1b, 0x1a24, 0x1a36, 0x1a45, 0x1a5d, 0x1a69,
			0x1a69, 0x1a7b, 0x1a8a, 0x1a99, 0x1a99, 0x1a99, 0x1ac2, 0x1ac2,
			0x1ac2, 0x1ad4, 0x1af2, 0x1b01, 0x1b16, 0x1b25, 0x1b37, 0x1b37,
			0x1b37, 0x1b37, 0x1b46, 0x1b5b, 0x1b73, 0x1b73, 0x1b73, 0x1b8b,
			0x1b8b, 0x1b8b, 0x1ba6, 0x1ba6, 0x1bd5, 0x1be7, 0x1bf6, 0x1c0b,
			0x1c0b, 0x1c0b, 0x1c0b, 0x1c1a, 0x1c3f, 0x1c3f, 0x1c4e, 0x1c4e,
			// Entry 1C0 - 1FF
			0x1c4e, 0x1c73, 0x1c91, 0x1cac, 0x1cbe, 0x1cd3, 0x1cdf, 0x1d04,
			0x1d1f, 0x1d2e, 0x1d40, 0x1d61, 0x1d70, 0x1d70, 0x1d70, 0x1d70,
			0x1d70, 0x1d95, 0x1d95, 0x1da7, 0x1da7, 0x1da7, 0x1db9, 0x1db9,
			0x1dea, 0x1dea, 0x1dea, 0x1e05, 0x1e1a, 0x1e35, 0x1e35, 0x1e35,
			0x1e35, 0x1e47, 0x1e47, 0x1e47, 0x1e47, 0x1e5c, 0x1e5c, 0x1e6e,
			0x1e7d, 0x1eab, 0x1eab, 0x1eb7, 0x1ec9, 0x1ec9, 0x1ec9, 0x1ec9,
			0x1ee1, 0x1ef0, 0x1ef0, 0x1ef0, 0x1ef0, 0x1ef0, 0x1ef0, 0x1f02,
			0x1f02, 0x1f24, 0x1f24, 0x1f24, 0x1f2d, 0x1f2d, 0x1f3f, 0x1f3f,
			// Entry 200 - 23F
			0x1f3f, 0x1f61, 0x1f7a, 0x1f96, 0x1fbb, 0x1fd3, 0x1fe8, 0x200d,
			0x201c, 0x201c, 0x201c, 0x202e, 0x203a, 0x2052, 0x2052, 0x207d,
			0x208f, 0x208f, 0x208f, 0x209e, 0x209e, 0x20b0, 0x20bf, 0x20d1,
			0x20dd, 0x20ef, 0x20ef, 0x2107, 0x211f, 0x211f, 0x2131, 0x2153,
			0x216c, 0x216c, 0x216c, 0x216c, 0x218a, 0x218a, 0x219f, 0x21b1,
			0x21b1, 0x21bd, 0x21bd, 0x21d5, 0x21ea, 0x21ff, 0x2208, 0x2211,
			0x2211, 0x2211, 0x2211, 0x2211, 0x2220, 0x2220, 0x2220, 0x2220,
			0x2232, 0x223e, 0x224a, 0x224a, 0x224a, 0x225c, 0x225c, 0x225c,
			// Entry 240 - 27F
			0x2265, 0x2277, 0x2277, 0x2277, 0x2277, 0x2277, 0x228f, 0x22ae,
			0x22ae, 0x22c3, 0x22c3, 0x22d2, 0x22e1, 0x22f3, 0x22f3, 0x22f3,
			0x2320, 0x235f, 0x23a5, 0x23d5, 0x2405, 0x2435, 0x246d, 0x249b,
			0x249b, 0x249b, 0x24cb, 0x24f8, 0x24f8, 0x250a, 0x250a, 0x250a,
			0x252b, 0x2553, 0x2553, 0x2577, 0x25a1,
		},
	},
	{ // bs
		"afarskiabhaskiavestanskiafrikansakanamharskiaragonskiarapskiasamskiavars" +
			"kiajmaraazerbejdžanskibaškirskibjeloruskibugarskibislamabambarabenga" +
			"lskitibetanskibretonskibosanskikatalonskičečenskičamorokorzikanskikr" +
			"ičeškistaroslavenskičuvaškivelškidanskinjemačkidivehidžongaevegrčkie" +
			"ngleskiesperantošpanskiestonskibaskijskiperzijskifulahfinskifidžijsk" +
			"ifarskifrancuskizapadni frizijskiirskiškotski galskigalicijskigvaran" +
			"igudžaratimankshausahebrejskihinduhiri motuhrvatskihaićanskimađarski" +
			"armenskihererointerlingvaindonezijskiinterlingveigbosičuan jiinupiak" +
			"idoislandskitalijanskiinuktitutjapanskijavanskigruzijskikongokikujuk" +
			"uanjamakazačkikalalisutskikmerskikanadakorejskikanurikašmirskikurdsk" +
			"ikomikornskikirgiškilatinskiluksemburškigandalimburškilingalalaoškil" +
			"itvanskiluba-katangalatvijskimalagaškimaršalskimaorskimakedonskimala" +
			"jalammongolskimaratimalajskimalteškiburmanskinaurusjeverni ndebelene" +
			"palskindongaholandskinorveški (Nynorsk)norveški (Bokmal)južni ndebel" +
			"enavahonjanjaoksitanskiojibvaoromoorijskiosetskipandžapskipalipoljsk" +
			"ipaštuportugalskikečuareto-romanskirundirumunskiruskikinjarvandasans" +
			"kritsardinijskisindisjeverni samisangosinhaleškislovačkislovenskisam" +
			"oanskišonasomalskialbanskisrpskisvatijužni sotosundanskišvedskisvahi" +
			"litamilskitelugutadžičkitajlandskitigrinjaturkmenskitsvanatonganskit" +
			"urskitsongatatarskitahićanskiujgurskiukrajinskiurduuzbečkivendavijet" +
			"namskivolapukvalunvolofhosajidišjorubanskizuangkineskizuluacehneskia" +
			"koliadangmejskiadigejskiafrihiliaghemainuakadijskialeutskijužni alta" +
			"istaroengleskiangikaaramejskimapuškiarapahoaravakasuasturijskiavadhi" +
			"balučibalinezijskibasabamunskigomalabejabembabenabafutzapadni belučk" +
			"ibojpuribikolbinikomsiksikabrajbodoakoskiburiatbugiškibulublinmedumb" +
			"akadokaripskikajugaatsamcebuanočigačibčačagataičukeskimaričinukski ž" +
			"argončoktavčipvijanskičirokičejenskicentralnokurdskikoptskikrimski t" +
			"urskiseselva kreolski francuskikašubijanskidakotadargvataitadelavers" +
			"lavedogribdinkazarmadogridonjolužičkosrpskidualasrednjovjekovni hola" +
			"ndskijola-fonidiuladazagaembuefikstaroegipatskiekajukelamitskisrednj" +
			"ovjekovni engleskievondofangfilipinofonsrednjovjekovni francuskistar" +
			"ofrancuskisjeverni frizijskiistočnofrizijskifriulijskigagagauškigajo" +
			"gbajastaroetiopskigilbertskisrednjovjekovni gornjonjemačkistaronjema" +
			"čkigondigorontalogotskigrebostarogrčkinjemački (Švicarska)gusigviči" +
			"nhaidahavajskihiligajnonhititehmonggornjolužičkosrpskihupaibanibibio" +
			"ilokoingušetskilojbanngombamakamejudeo-perzijskijudeo-arapskikara-ka" +
			"lpakkabilekačinkajukambakavikabardijskikanembutjapmakondezelenortski" +
			"korokasikotanizijskikojra činikakokalenjinkimbundukomi-permskikonkan" +
			"ikosrejskikpelekaračaj-balkarkriokarelijskikuruškišambalabafiakelnsk" +
			"ikumikkutenailadinolangilandalambalezgijskilakotamongolozisjeverni l" +
			"uriluba-lulualuisenolundaluomizoluhijamadureškimafamagahimaitilimaka" +
			"sarmandingomasaimabamokšamandarmendemerumauricijski kreolskisrednjov" +
			"jekovni irskimakuva-metometamikmakminangkabaumančumanipurimohavkmosi" +
			"mundangviše jezikakriškimirandeškimarvarimjeneerzijamazanderanskinap" +
			"olitanskinamadonjonjemačkinevariniasniueankvasiongiembonnogaistarono" +
			"rdijskinkosjeverni sotonuerklasični nevarinjamvezinjankolenjoronzima" +
			"osageosmanski turskipangasinskipahlavipampangapapiamentopalauanskini" +
			"gerijski pidžinstaroperzijskifeničanskiponpejskipruskistaroprovansal" +
			"skikičerajastanirapanuirarotonganromboromaniarumunskiruasandavejakut" +
			"skisamaritanski aramejskisamburusasaksantalingambajsangusicilijanski" +
			"škotskijužni kurdskisenekasenaselkupkojraboro senistaroirskitahelhi" +
			"tšančadski arapskisidamojužni samilule samiinari samiskolt samisonin" +
			"kesogdiensrananski tongoserersahosukumasususumerskikomorskiklasični " +
			"sirijskisirijskitimnetesoterenotetumtigretivtokelauklingonskitlingit" +
			"tamašeknjasa tongatok pisintarokotsimšiantumbukatuvalutasavaktuvinij" +
			"skicentralnoatlaski tamazigtudmurtugaritskiumbundukorijenskivaivotsk" +
			"ivunjovalservalamovarejvašovarlpirikalmiksogajaojapeškijangbenjembak" +
			"antonskizapotečkiblis simbolizenagastandardni marokanski tamazigtzun" +
			"ibez lingvističkog sadržajazazamoderni standardni arapskigornjonjema" +
			"čki (Švicarska)donjosaksonskiflamanskimoldavskisrpskohrvatskikinesk" +
			"i (pojednostavljeni)kineski (tradicionalni)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0007, 0x000e, 0x0018, 0x0020, 0x0024, 0x002c, 0x0035,
			0x003c, 0x0043, 0x004a, 0x0050, 0x005f, 0x0069, 0x0073, 0x007b,
			0x0082, 0x0089, 0x0092, 0x009c, 0x00a5, 0x00ad, 0x00b7, 0x00c1,
			0x00c8, 0x00d3, 0x00d6, 0x00dd, 0x00eb, 0x00f4, 0x00fb, 0x0101,
			0x010a, 0x0110, 0x0117, 0x011a, 0x0120, 0x0128, 0x0131, 0x0139,
			0x0141, 0x014a, 0x0153, 0x0158, 0x015e, 0x0168, 0x016e, 0x0177,
			0x0188, 0x018d, 0x019c, 0x01a6, 0x01ad, 0x01b7, 0x01bc, 0x01c1,
			0x01ca, 0x01cf, 0x01d8, 0x01e0, 0x01ea, 0x01f3, 0x01fb, 0x0201,
			// Entry 40 - 7F
			0x020c, 0x0218, 0x0223, 0x0227, 0x0231, 0x0238, 0x023b, 0x0244,
			0x024e, 0x0257, 0x025f, 0x0267, 0x0270, 0x0275, 0x027b, 0x0283,
			0x028b, 0x0297, 0x029e, 0x02a4, 0x02ac, 0x02b2, 0x02bc, 0x02c3,
			0x02c7, 0x02ce, 0x02d7, 0x02df, 0x02ec, 0x02f1, 0x02fb, 0x0302,
			0x0309, 0x0312, 0x031e, 0x0327, 0x0331, 0x033b, 0x0342, 0x034c,
			0x0355, 0x035e, 0x0364, 0x036c, 0x0375, 0x037e, 0x0383, 0x0393,
			0x039b, 0x03a1, 0x03aa, 0x03bd, 0x03cf, 0x03dd, 0x03e3, 0x03e9,
			0x03f3, 0x03f9, 0x03fe, 0x0405, 0x040c, 0x0417, 0x041b, 0x0422,
			// Entry 80 - BF
			0x0428, 0x0433, 0x0439, 0x0446, 0x044b, 0x0453, 0x0458, 0x0463,
			0x046b, 0x0476, 0x047b, 0x0488, 0x048d, 0x0498, 0x04a1, 0x04aa,
			0x04b3, 0x04b8, 0x04c0, 0x04c8, 0x04ce, 0x04d3, 0x04de, 0x04e7,
			0x04ef, 0x04f6, 0x04fe, 0x0504, 0x050e, 0x0518, 0x0520, 0x052a,
			0x0530, 0x0539, 0x053f, 0x0545, 0x054d, 0x0558, 0x0560, 0x056a,
			0x056e, 0x0576, 0x057b, 0x0586, 0x058d, 0x0592, 0x0597, 0x059b,
			0x05a1, 0x05ab, 0x05b0, 0x05b7, 0x05bb, 0x05c4, 0x05c9, 0x05d4,
			0x05dd, 0x05dd, 0x05e5, 0x05ea, 0x05ee, 0x05f7, 0x05f7, 0x05ff,
			// Entry C0 - FF
			0x05ff, 0x060b, 0x0618, 0x061e, 0x0627, 0x062f, 0x062f, 0x0636,
			0x0636, 0x0636, 0x063c, 0x063c, 0x063c, 0x063f, 0x063f, 0x0649,
			0x0649, 0x064f, 0x0656, 0x0662, 0x0662, 0x0666, 0x066e, 0x066e,
			0x0674, 0x0678, 0x067d, 0x067d, 0x0681, 0x0686, 0x0686, 0x0696,
			0x069d, 0x06a2, 0x06a6, 0x06a6, 0x06a9, 0x06b0, 0x06b0, 0x06b0,
			0x06b4, 0x06b4, 0x06b8, 0x06be, 0x06c4, 0x06cc, 0x06d0, 0x06d4,
			0x06db, 0x06df, 0x06e7, 0x06ed, 0x06f2, 0x06f9, 0x06fe, 0x0705,
			0x070d, 0x0715, 0x0719, 0x072a, 0x0731, 0x073d, 0x0744, 0x074d,
			// Entry 100 - 13F
			0x075d, 0x0764, 0x0764, 0x0772, 0x078c, 0x0799, 0x079f, 0x07a5,
			0x07aa, 0x07b1, 0x07b6, 0x07bc, 0x07c1, 0x07c6, 0x07cb, 0x07df,
			0x07df, 0x07e4, 0x07fd, 0x0806, 0x080b, 0x0811, 0x0815, 0x0819,
			0x0819, 0x0827, 0x082d, 0x0836, 0x084e, 0x084e, 0x0854, 0x0854,
			0x0858, 0x0860, 0x0860, 0x0863, 0x0863, 0x087c, 0x088a, 0x088a,
			0x089c, 0x08ad, 0x08b7, 0x08b9, 0x08c2, 0x08c2, 0x08c6, 0x08cb,
			0x08cb, 0x08d8, 0x08e2, 0x08e2, 0x0901, 0x090f, 0x090f, 0x0914,
			0x091d, 0x0923, 0x0928, 0x0933, 0x0949, 0x0949, 0x0949, 0x094d,
			// Entry 140 - 17F
			0x0954, 0x0959, 0x0959, 0x0961, 0x0961, 0x096b, 0x0971, 0x0976,
			0x098b, 0x098b, 0x098f, 0x0993, 0x0999, 0x099e, 0x09a9, 0x09a9,
			0x09a9, 0x09af, 0x09b5, 0x09bb, 0x09ca, 0x09d7, 0x09d7, 0x09e2,
			0x09e8, 0x09ee, 0x09f2, 0x09f7, 0x09fb, 0x0a06, 0x0a0d, 0x0a11,
			0x0a18, 0x0a23, 0x0a23, 0x0a27, 0x0a27, 0x0a2b, 0x0a37, 0x0a42,
			0x0a42, 0x0a42, 0x0a46, 0x0a4e, 0x0a56, 0x0a62, 0x0a69, 0x0a72,
			0x0a77, 0x0a86, 0x0a8a, 0x0a8a, 0x0a94, 0x0a9c, 0x0aa4, 0x0aa9,
			0x0ab0, 0x0ab5, 0x0abc, 0x0ac2, 0x0ac7, 0x0acc, 0x0ad1, 0x0ada,
			// Entry 180 - 1BF
			0x0ada, 0x0ada, 0x0ada, 0x0ae0, 0x0ae0, 0x0ae5, 0x0ae9, 0x0af6,
			0x0af6, 0x0b00, 0x0b07, 0x0b0c, 0x0b0f, 0x0b13, 0x0b19, 0x0b19,
			0x0b19, 0x0b23, 0x0b27, 0x0b2d, 0x0b34, 0x0b3b, 0x0b43, 0x0b48,
			0x0b4c, 0x0b52, 0x0b58, 0x0b5d, 0x0b61, 0x0b75, 0x0b8a, 0x0b95,
			0x0b99, 0x0b9f, 0x0baa, 0x0bb0, 0x0bb8, 0x0bbe, 0x0bc2, 0x0bc2,
			0x0bc9, 0x0bd5, 0x0bdc, 0x0be7, 0x0bee, 0x0bee, 0x0bf3, 0x0bf9,
			0x0c06, 0x0c06, 0x0c12, 0x0c16, 0x0c24, 0x0c2a, 0x0c2e, 0x0c34,
			0x0c34, 0x0c3a, 0x0c42, 0x0c47, 0x0c55, 0x0c55, 0x0c58, 0x0c65,
			// Entry 1C0 - 1FF
			0x0c69, 0x0c79, 0x0c81, 0x0c89, 0x0c8e, 0x0c93, 0x0c98, 0x0ca7,
			0x0cb2, 0x0cb9, 0x0cc1, 0x0ccb, 0x0cd5, 0x0cd5, 0x0ce7, 0x0ce7,
			0x0ce7, 0x0cf5, 0x0cf5, 0x0d00, 0x0d00, 0x0d00, 0x0d09, 0x0d0f,
			0x0d20, 0x0d25, 0x0d25, 0x0d2e, 0x0d35, 0x0d3f, 0x0d3f, 0x0d3f,
			0x0d44, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d4a, 0x0d53, 0x0d56, 0x0d5d,
			0x0d65, 0x0d7b, 0x0d82, 0x0d87, 0x0d8e, 0x0d8e, 0x0d95, 0x0d9a,
			0x0da6, 0x0dae, 0x0dae, 0x0dbc, 0x0dc2, 0x0dc6, 0x0dc6, 0x0dcc,
			0x0dda, 0x0de4, 0x0de4, 0x0dec, 0x0df0, 0x0dff, 0x0e05, 0x0e05,
			// Entry 200 - 23F
			0x0e05, 0x0e10, 0x0e19, 0x0e23, 0x0e2d, 0x0e34, 0x0e3b, 0x0e4a,
			0x0e4f, 0x0e53, 0x0e53, 0x0e59, 0x0e5d, 0x0e65, 0x0e6d, 0x0e7f,
			0x0e87, 0x0e87, 0x0e87, 0x0e8c, 0x0e90, 0x0e96, 0x0e9b, 0x0ea0,
			0x0ea3, 0x0eaa, 0x0eaa, 0x0eb4, 0x0ebb, 0x0ebb, 0x0ec3, 0x0ece,
			0x0ed7, 0x0ed7, 0x0edd, 0x0edd, 0x0ee6, 0x0ee6, 0x0eed, 0x0ef3,
			0x0efa, 0x0f04, 0x0f1d, 0x0f23, 0x0f2c, 0x0f33, 0x0f3d, 0x0f40,
			0x0f40, 0x0f40, 0x0f40, 0x0f40, 0x0f46, 0x0f46, 0x0f4b, 0x0f51,
			0x0f57, 0x0f5c, 0x0f61, 0x0f69, 0x0f69, 0x0f6f, 0x0f6f, 0x0f73,
			// Entry 240 - 27F
			0x0f76, 0x0f7e, 0x0f85, 0x0f8a, 0x0f8a, 0x0f93, 0x0f9d, 0x0fa9,
			0x0fa9, 0x0faf, 0x0fcd, 0x0fd1, 0x0fed, 0x0ff1, 0x100b, 0x100b,
			0x100b, 0x1027, 0x1027, 0x1027, 0x1027, 0x1027, 0x1027, 0x1027,
			0x1027, 0x1027, 0x1027, 0x1027, 0x1035, 0x103e, 0x103e, 0x103e,
			0x1047, 0x1055, 0x1055, 0x106f, 0x1086,
		},
	},
	{ // bs-Cyrl
		"афарскиабказијскиавестанскиафриканерскиаканамхарскиарагонежанскиарапскиа" +
			"семијскиаварскиајмараазербејџанскибашкирбелорускибугарскибисламабам" +
			"барабенгласкитибетанскибретонскибосанскикаталонскичеченскичаморокор" +
			"зиканскикричешкистарословенскичувашкивелшкиданскинемачкидивехијскиџ" +
			"онгаевегрчкиенглескиесперантошпанскиестонскибаскијскиперсијскифулах" +
			"финскифиджијскифарскифранцускифризијскиирскишкотски галскигалскигва" +
			"ранигуџаратиманксхаусахебрејскихиндихири мотухрватскихаитскимађарск" +
			"ијерменскихерероинтерлингваиндонежанскимеђујезичкиигбосичуан јиунуп" +
			"иакидоисландскииталијанскиинуктитутјапанскијаванскигрузијскиконгоки" +
			"кујукуањамакозачкикалалисуткмерскиканадакорејскиканурикашмирскикурд" +
			"скикомикорнишкикиргискилатинскилуксембуршкигандалимбургишлингалалао" +
			"скилитванскилуба-катангалетонскималагасијскимаршалскимаорскимакедон" +
			"скималајаламмонголскимаратималајскимелтешкибурманскинаурусеверни нд" +
			"ебеленепалскиндонгахоландскинорвешки њорскнорвешки бокмалјужни ндеб" +
			"еленавахоњањапровансалскиојибваоромооријскиосетскипанџабскипалипољс" +
			"кипаштунскипортугалскиквенчарето-романскирундирумунскирускикинјаруа" +
			"ндасанскритсардињаскисиндисеверни самисангосингалескисловачкисловен" +
			"ачкисамоанскишонасомалскиалбанскисрпскисватисесотосунданскишведскис" +
			"вахилитамилскителугутађиктајландскитигрињатуркменскитсванатонгатурс" +
			"китсонгататарскитахићанскиујгурскиукрајинскиурдуузбечкивендавијетна" +
			"мскиволапуквалунволофксхосајидишјорубажуангкинескизулуачинескиаколи" +
			"адангмејскиадигејскиафрихилиаинуакадијскиаљутјужни алтаистароенглес" +
			"киангикаармајскиароканијскиарапахоаравакастуријскиавадхибалучибалин" +
			"езијскибасабејабембабојпурибиколбинисисикабрајбуриатбугинежанскибли" +
			"нкадокарипскиатсамскицебуаночибчачагатаичукескимаричинукскичоктавск" +
			"ичипвијанскичерокичејенскикоптскикримеански турскикашубијанскидакот" +
			"адаргваделаверславскидогрибдинкадогриниски сорбијанскидуаласредњи х" +
			"оландскиђулаефикскистароегипатскиекајукеламитскисредњи енглескиевон" +
			"дофангтагалогфонсредњи францускистарофранцускисеверно-фризијскиисто" +
			"чни фризијскифриулијскигагајогбајаџизгилбертшкисредњи високи немачк" +
			"истаронемачкигондигоронталоготскигребостарогрчкишвајцарски немачкиг" +
			"вич’инхаидахавајскихилигајнонхититехмонггорњи сорбијскихупаибанилок" +
			"оингвишкилојбанјудео-персијскијудео-арапскикара-калпашкикабилекачин" +
			"ђукамбакавикабардијскитјапкорокасикотанешкикимбундуконканикосреанск" +
			"икпелекарачај-балкаркарелијскикурукхкумиккутенаиладиноландаламбалез" +
			"гианмонголозилуба-лулуалуисенолундалуолушаимадурешкимагахимаитилима" +
			"касармандингомасаимокшамандармендесредњи ирскимикмакминангкабауманч" +
			"уманипуримахавскимосивише језикакришкимирандешкимарвариерзијанеапол" +
			"итанскиниски немачкиневариниасниуеанногаистари норскин’косеверни со" +
			"токласични неварињамвезињанколењоронзимаосагеотомански турскипангас" +
			"инскипахлавипампангапапиаментопалауанскистароперсијскифеничанскипон" +
			"пејскистаропровансалскирађастанирапануираротонганроманиароманијскис" +
			"андавејакутсамаритански арамејскисасаксанталисицилијанскишкотскисел" +
			"капстароирскишансидамојужни самилуле самиинари самисколтски језиксо" +
			"нинкесоџијенскисранански тонгосерерсукумасусусумерскикоморскикласич" +
			"ни сиријскисиријскитимнетеренотетумтигретивтокелауклингонскитлингит" +
			"тамашекњаса тонгаток писинтсимшиантумбукатувалутувинијскиудмуртугар" +
			"итскиумбундурутваивотскиваламоварајвашокалмикјаојапешкикантонскизап" +
			"отечкиблисимболизенагазунибез лингвистичког садржајазазаАустријски " +
			"немачкиШвајцарски високи немачкиАустралијски енглескиКанадски енгле" +
			"скиБритански енглескиСАД енглескиЛатино-амерички шпанскиИберијски ш" +
			"панскиКанадски францускиШвајцарски францускифламанскиБразилски порт" +
			"угалскиИберијски португалскимолдавскисрпскохрватскикинески (поједно" +
			"стављен)кинески (традиционални)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x0022, 0x0036, 0x004e, 0x0056, 0x0066, 0x0080,
			0x008e, 0x00a0, 0x00ae, 0x00ba, 0x00d4, 0x00e0, 0x00f2, 0x0102,
			0x0110, 0x011e, 0x0130, 0x0144, 0x0156, 0x0166, 0x017a, 0x018a,
			0x0196, 0x01ac, 0x01b2, 0x01bc, 0x01d8, 0x01e6, 0x01f2, 0x01fe,
			0x020c, 0x0220, 0x022a, 0x0230, 0x023a, 0x024a, 0x025c, 0x026a,
			0x027a, 0x028c, 0x029e, 0x02a8, 0x02b4, 0x02c6, 0x02d2, 0x02e4,
			0x02f6, 0x0300, 0x031b, 0x0327, 0x0335, 0x0345, 0x034f, 0x0359,
			0x036b, 0x0375, 0x0386, 0x0396, 0x03a4, 0x03b4, 0x03c6, 0x03d2,
			// Entry 40 - 7F
			0x03e8, 0x0400, 0x0416, 0x041e, 0x042f, 0x043d, 0x0443, 0x0455,
			0x046b, 0x047d, 0x048d, 0x049d, 0x04af, 0x04b9, 0x04c5, 0x04d3,
			0x04e1, 0x04f3, 0x0501, 0x050d, 0x051d, 0x0529, 0x053b, 0x0549,
			0x0551, 0x0561, 0x0571, 0x0581, 0x0599, 0x05a3, 0x05b5, 0x05c3,
			0x05cf, 0x05e1, 0x05f8, 0x0608, 0x0620, 0x0632, 0x0640, 0x0654,
			0x0666, 0x0678, 0x0684, 0x0694, 0x06a4, 0x06b6, 0x06c0, 0x06dd,
			0x06ed, 0x06f9, 0x070b, 0x0726, 0x0743, 0x075c, 0x0768, 0x0770,
			0x0788, 0x0794, 0x079e, 0x07ac, 0x07ba, 0x07cc, 0x07d4, 0x07e0,
			// Entry 80 - BF
			0x07f2, 0x0808, 0x0814, 0x082d, 0x0837, 0x0847, 0x0851, 0x0867,
			0x0877, 0x088b, 0x0895, 0x08ac, 0x08b6, 0x08ca, 0x08da, 0x08ee,
			0x0900, 0x0908, 0x0918, 0x0928, 0x0934, 0x093e, 0x094a, 0x095c,
			0x096a, 0x0978, 0x0988, 0x0994, 0x099e, 0x09b2, 0x09c0, 0x09d4,
			0x09e0, 0x09ea, 0x09f6, 0x0a02, 0x0a12, 0x0a26, 0x0a36, 0x0a4a,
			0x0a52, 0x0a60, 0x0a6a, 0x0a80, 0x0a8e, 0x0a98, 0x0aa2, 0x0aae,
			0x0ab8, 0x0ac4, 0x0ace, 0x0adc, 0x0ae4, 0x0af4, 0x0afe, 0x0b14,
			0x0b26, 0x0b26, 0x0b36, 0x0b36, 0x0b3e, 0x0b50, 0x0b50, 0x0b58,
			// Entry C0 - FF
			0x0b58, 0x0b6d, 0x0b87, 0x0b93, 0x0ba3, 0x0bb9, 0x0bb9, 0x0bc7,
			0x0bc7, 0x0bc7, 0x0bd3, 0x0bd3, 0x0bd3, 0x0bd3, 0x0bd3, 0x0be7,
			0x0be7, 0x0bf3, 0x0bff, 0x0c17, 0x0c17, 0x0c1f, 0x0c1f, 0x0c1f,
			0x0c1f, 0x0c27, 0x0c31, 0x0c31, 0x0c31, 0x0c31, 0x0c31, 0x0c31,
			0x0c3f, 0x0c49, 0x0c51, 0x0c51, 0x0c51, 0x0c5d, 0x0c5d, 0x0c5d,
			0x0c65, 0x0c65, 0x0c65, 0x0c65, 0x0c71, 0x0c89, 0x0c89, 0x0c91,
			0x0c91, 0x0c99, 0x0ca9, 0x0ca9, 0x0cb9, 0x0cc7, 0x0cc7, 0x0cd1,
			0x0cdf, 0x0ced, 0x0cf5, 0x0d05, 0x0d17, 0x0d2d, 0x0d39, 0x0d49,
			// Entry 100 - 13F
			0x0d49, 0x0d57, 0x0d57, 0x0d78, 0x0d78, 0x0d90, 0x0d9c, 0x0da8,
			0x0da8, 0x0db6, 0x0dc4, 0x0dd0, 0x0dda, 0x0dda, 0x0de4, 0x0e05,
			0x0e05, 0x0e0f, 0x0e2e, 0x0e2e, 0x0e36, 0x0e36, 0x0e36, 0x0e44,
			0x0e44, 0x0e60, 0x0e6c, 0x0e7e, 0x0e9b, 0x0e9b, 0x0ea7, 0x0ea7,
			0x0eaf, 0x0ebd, 0x0ebd, 0x0ec3, 0x0ec3, 0x0ee2, 0x0efe, 0x0efe,
			0x0f1f, 0x0f40, 0x0f54, 0x0f58, 0x0f58, 0x0f58, 0x0f60, 0x0f6a,
			0x0f6a, 0x0f70, 0x0f84, 0x0f84, 0x0fac, 0x0fc4, 0x0fc4, 0x0fce,
			0x0fe0, 0x0fec, 0x0ff6, 0x100a, 0x102d, 0x102d, 0x102d, 0x102d,
			// Entry 140 - 17F
			0x103c, 0x1046, 0x1046, 0x1056, 0x1056, 0x106a, 0x1076, 0x1080,
			0x109d, 0x109d, 0x10a5, 0x10ad, 0x10ad, 0x10b7, 0x10c7, 0x10c7,
			0x10c7, 0x10d3, 0x10d3, 0x10d3, 0x10f0, 0x1109, 0x1109, 0x1122,
			0x112e, 0x1138, 0x113c, 0x1146, 0x114e, 0x1164, 0x1164, 0x116c,
			0x116c, 0x116c, 0x116c, 0x1174, 0x1174, 0x117c, 0x118e, 0x118e,
			0x118e, 0x118e, 0x118e, 0x118e, 0x119e, 0x119e, 0x11ac, 0x11c0,
			0x11ca, 0x11e5, 0x11e5, 0x11e5, 0x11f9, 0x1205, 0x1205, 0x1205,
			0x1205, 0x120f, 0x121d, 0x1229, 0x1229, 0x1233, 0x123d, 0x124b,
			// Entry 180 - 1BF
			0x124b, 0x124b, 0x124b, 0x124b, 0x124b, 0x1255, 0x125d, 0x125d,
			0x125d, 0x1270, 0x127e, 0x1288, 0x128e, 0x1298, 0x1298, 0x1298,
			0x1298, 0x12aa, 0x12aa, 0x12b6, 0x12c4, 0x12d2, 0x12e2, 0x12ec,
			0x12ec, 0x12f6, 0x1302, 0x130c, 0x130c, 0x130c, 0x1323, 0x1323,
			0x1323, 0x132f, 0x1345, 0x134f, 0x135f, 0x136f, 0x1377, 0x1377,
			0x1377, 0x138c, 0x1398, 0x13ac, 0x13ba, 0x13ba, 0x13ba, 0x13c6,
			0x13c6, 0x13c6, 0x13e0, 0x13e0, 0x13f9, 0x1405, 0x140d, 0x1419,
			0x1419, 0x1419, 0x1419, 0x1423, 0x143a, 0x143a, 0x1443, 0x145a,
			// Entry 1C0 - 1FF
			0x145a, 0x1477, 0x1485, 0x1493, 0x149b, 0x14a5, 0x14af, 0x14ce,
			0x14e4, 0x14f2, 0x1502, 0x1516, 0x152a, 0x152a, 0x152a, 0x152a,
			0x152a, 0x1546, 0x1546, 0x155a, 0x155a, 0x155a, 0x156c, 0x156c,
			0x158e, 0x158e, 0x158e, 0x15a0, 0x15ae, 0x15c2, 0x15c2, 0x15c2,
			0x15c2, 0x15ce, 0x15ce, 0x15ce, 0x15ce, 0x15e4, 0x15e4, 0x15f2,
			0x15fc, 0x1627, 0x1627, 0x1631, 0x163f, 0x163f, 0x163f, 0x163f,
			0x1657, 0x1665, 0x1665, 0x1665, 0x1665, 0x1665, 0x1665, 0x1671,
			0x1671, 0x1685, 0x1685, 0x1685, 0x168b, 0x168b, 0x1697, 0x1697,
			// Entry 200 - 23F
			0x1697, 0x16aa, 0x16bb, 0x16ce, 0x16e9, 0x16f7, 0x170b, 0x1728,
			0x1732, 0x1732, 0x1732, 0x173e, 0x1746, 0x1756, 0x1766, 0x1787,
			0x1797, 0x1797, 0x1797, 0x17a1, 0x17a1, 0x17ad, 0x17b7, 0x17c1,
			0x17c7, 0x17d5, 0x17d5, 0x17e9, 0x17f7, 0x17f7, 0x1805, 0x1818,
			0x1829, 0x1829, 0x1829, 0x1829, 0x1839, 0x1839, 0x1847, 0x1853,
			0x1853, 0x1867, 0x1867, 0x1873, 0x1885, 0x1893, 0x1899, 0x189f,
			0x189f, 0x189f, 0x189f, 0x189f, 0x18ab, 0x18ab, 0x18ab, 0x18ab,
			0x18b7, 0x18c1, 0x18c9, 0x18c9, 0x18c9, 0x18d5, 0x18d5, 0x18d5,
			// Entry 240 - 27F
			0x18db, 0x18e9, 0x18e9, 0x18e9, 0x18e9, 0x18fb, 0x190d, 0x1921,
			0x1921, 0x192d, 0x192d, 0x1935, 0x1967, 0x196f, 0x196f, 0x196f,
			0x1992, 0x19c2, 0x19eb, 0x1a0c, 0x1a2f, 0x1a46, 0x1a72, 0x1a93,
			0x1a93, 0x1a93, 0x1ab6, 0x1add, 0x1add, 0x1aef, 0x1b18, 0x1b41,
			0x1b53, 0x1b6f, 0x1b6f, 0x1b9c, 0x1bc7,
		},
	},
	{ // ca
		caLangStr,
		caLangIdx,
	},
	{ // ce
		"абхазхойнафрикаансаканамхаройнӀаьрбийнассамийназербайджанийнбашкирийнбел" +
			"орусийнболгарийнбамбарабенгалийнтибетхойнбретонийнбоснийнкаталонийн" +
			"нохчийнкорсиканийнчехийнчувашийнваллийндатхойннемцойндзонг-кээвегре" +
			"кийнингалсанэсперантоиспанхойнэстонийнбаскийнгӀажарийнфиннийнфиджиф" +
			"арерийнфранцузийнмалхбузен-фризийнирландхойнгалисийнгуаранигуджарат" +
			"имэнийнхаусажугтийнхиндихорватийнгаитийнвенгрийнэрмалойниндонезихой" +
			"нигбосычуаньисландхойнитальянийнинуктитутяпонийняванийнгуьржийнкику" +
			"йюказахийнгренландхойнкхмерийнканнадакорейнкашмирикурдийнкорнуоллий" +
			"нгӀиргӀизойнлатинанлюксембургхойнгандалингалалаоссийнлитвахойнлуба-" +
			"катангалатышийнмалагасийнмаоримакедонхойнмалаяламмонголийнмаратхима" +
			"лайнмальтойнбирманийнкъилбаседа ндебелинепалхойнголландхойннорвегий" +
			"н нюнорскнорвегийн букмолоромоорипанджабиполякийнпуштупортугалихойн" +
			"кечуароманшийнрундирумынийноьрсийнкиньяруандасанскритсиндхикъилбасе" +
			"да саамийнсангосингалхойнсловакийнсловенийншонасомалиалбанойнсербий" +
			"нсунданхойншведийнсуахилитамилхойнтелугутаджикийнтайнтигриньятуркме" +
			"нийнтонганийнтуркойнгӀезалойнуйгурийнукраинийнурдуузбекийнвьетнамхо" +
			"йнволофкосайорубакитайнзулуагхӀемарауканхойнасубембабенамалхбузен-б" +
			"елуджийнбодочигачерокиюккъерчу курдийнтаитазармасорбийндуаладьола-ф" +
			"оньиэмбуфилиппинийнгагаузийншвейцарин немцойнгусиигавайнлакхара сер" +
			"бийннгомбамачамекабилийнкамбамакондекабувердьянукойра чииникаленджи" +
			"нкоми-пермякийнконканишамбалабафиалангилакотакъилбаседа лурилуо (Ке" +
			"ни а, Танзани а)лухьямасаимерумаврикин креолийнмакуа-мееттометамоха" +
			"укмундангмазандеранхойннамалахара германхойнквасионконуэрньянколеки" +
			"черомборуандасамбурусангусенакойраборо сеннитахелхитсаамийн (къилба" +
			")луле-саамийнинари-саамийнскольт-саамийнтесотасавактамазигхтийнбоьвз" +
			"уш боцу моттваивунджоварлпирисогамороккон стандартан тамазигхтийнме" +
			"ттан чулацам боцушХӀинца болу стандартан Ӏаьрбийнавстрин немцойншве" +
			"йцарин лакхара немцойнАвстралин ингалсанканадан ингалсанбританин ин" +
			"галсанамерикан ингалсанлатинан американ испанхойневропан испанхойнм" +
			"ексикан испанхойнканадан французийншвейцарин французийнлахара саксо" +
			"нийнфламандийнбразилин португалихойневропан португалихойнмолдавийнс" +
			"уахили (Конго)атта китайнламастан китайн",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0012, 0x0012, 0x0024, 0x002c, 0x003c, 0x003c,
			0x004c, 0x005c, 0x005c, 0x005c, 0x0078, 0x008a, 0x009e, 0x00b0,
			0x00b0, 0x00be, 0x00d0, 0x00e2, 0x00f4, 0x0102, 0x0116, 0x0124,
			0x0124, 0x013a, 0x013a, 0x0146, 0x0146, 0x0156, 0x0164, 0x0172,
			0x0180, 0x0180, 0x018f, 0x0195, 0x01a3, 0x01b3, 0x01c5, 0x01d7,
			0x01e7, 0x01f5, 0x0207, 0x0207, 0x0215, 0x021f, 0x022f, 0x0243,
			0x0264, 0x0278, 0x0278, 0x0288, 0x0296, 0x02a8, 0x02b4, 0x02be,
			0x02cc, 0x02d6, 0x02d6, 0x02e8, 0x02f6, 0x0306, 0x0316, 0x0316,
			// Entry 40 - 7F
			0x0316, 0x032e, 0x032e, 0x0336, 0x0344, 0x0344, 0x0344, 0x0358,
			0x036c, 0x037e, 0x038c, 0x039a, 0x03aa, 0x03aa, 0x03b6, 0x03b6,
			0x03c6, 0x03de, 0x03ee, 0x03fc, 0x0408, 0x0408, 0x0416, 0x0424,
			0x0424, 0x043a, 0x0450, 0x045e, 0x047a, 0x0484, 0x0484, 0x0492,
			0x04a2, 0x04b4, 0x04cb, 0x04db, 0x04ef, 0x04ef, 0x04f9, 0x050f,
			0x051f, 0x0531, 0x053f, 0x054b, 0x055b, 0x056d, 0x056d, 0x0590,
			0x05a2, 0x05a2, 0x05b8, 0x05d9, 0x05f8, 0x05f8, 0x05f8, 0x05f8,
			0x05f8, 0x05f8, 0x0602, 0x0608, 0x0608, 0x0618, 0x0618, 0x0628,
			// Entry 80 - BF
			0x0632, 0x064c, 0x0656, 0x0668, 0x0672, 0x0682, 0x0690, 0x06a6,
			0x06b6, 0x06b6, 0x06c2, 0x06e5, 0x06ef, 0x0703, 0x0715, 0x0727,
			0x0727, 0x072f, 0x073b, 0x074b, 0x0759, 0x0759, 0x0759, 0x076d,
			0x077b, 0x0789, 0x079b, 0x07a7, 0x07b9, 0x07c1, 0x07d1, 0x07e5,
			0x07e5, 0x07f7, 0x0805, 0x0805, 0x0817, 0x0817, 0x0827, 0x0839,
			0x0841, 0x0851, 0x0851, 0x0867, 0x0867, 0x0867, 0x0871, 0x0879,
			0x0879, 0x0885, 0x0885, 0x0891, 0x0899, 0x0899, 0x0899, 0x0899,
			0x0899, 0x0899, 0x0899, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5,
			// Entry C0 - FF
			0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08a5, 0x08bb, 0x08bb, 0x08bb,
			0x08bb, 0x08bb, 0x08bb, 0x08bb, 0x08bb, 0x08c1, 0x08c1, 0x08c1,
			0x08c1, 0x08c1, 0x08c1, 0x08c1, 0x08c1, 0x08c1, 0x08c1, 0x08c1,
			0x08c1, 0x08c1, 0x08cb, 0x08cb, 0x08d3, 0x08d3, 0x08d3, 0x08f8,
			0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8,
			0x08f8, 0x08f8, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900,
			0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0900, 0x0908, 0x0908,
			0x0908, 0x0908, 0x0908, 0x0908, 0x0908, 0x0908, 0x0914, 0x0914,
			// Entry 100 - 13F
			0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0933, 0x0933,
			0x093d, 0x093d, 0x093d, 0x093d, 0x093d, 0x0947, 0x0947, 0x0955,
			0x0955, 0x095f, 0x095f, 0x0974, 0x0974, 0x0974, 0x097c, 0x097c,
			0x097c, 0x097c, 0x097c, 0x097c, 0x097c, 0x097c, 0x097c, 0x097c,
			0x097c, 0x0992, 0x0992, 0x0992, 0x0992, 0x0992, 0x0992, 0x0992,
			0x0992, 0x0992, 0x0992, 0x0992, 0x09a4, 0x09a4, 0x09a4, 0x09a4,
			0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09a4,
			0x09a4, 0x09a4, 0x09a4, 0x09a4, 0x09c5, 0x09c5, 0x09c5, 0x09cf,
			// Entry 140 - 17F
			0x09cf, 0x09cf, 0x09cf, 0x09db, 0x09db, 0x09db, 0x09db, 0x09db,
			0x09f8, 0x09f8, 0x09f8, 0x09f8, 0x09f8, 0x09f8, 0x09f8, 0x09f8,
			0x09f8, 0x09f8, 0x0a04, 0x0a10, 0x0a10, 0x0a10, 0x0a10, 0x0a10,
			0x0a20, 0x0a20, 0x0a20, 0x0a2a, 0x0a2a, 0x0a2a, 0x0a2a, 0x0a2a,
			0x0a38, 0x0a50, 0x0a50, 0x0a50, 0x0a50, 0x0a50, 0x0a50, 0x0a65,
			0x0a65, 0x0a65, 0x0a65, 0x0a77, 0x0a77, 0x0a92, 0x0aa0, 0x0aa0,
			0x0aa0, 0x0aa0, 0x0aa0, 0x0aa0, 0x0aa0, 0x0aa0, 0x0aae, 0x0ab8,
			0x0ab8, 0x0ab8, 0x0ab8, 0x0ab8, 0x0ac2, 0x0ac2, 0x0ac2, 0x0ac2,
			// Entry 180 - 1BF
			0x0ac2, 0x0ac2, 0x0ac2, 0x0ace, 0x0ace, 0x0ace, 0x0ace, 0x0aeb,
			0x0aeb, 0x0aeb, 0x0aeb, 0x0aeb, 0x0b12, 0x0b12, 0x0b1c, 0x0b1c,
			0x0b1c, 0x0b1c, 0x0b1c, 0x0b1c, 0x0b1c, 0x0b1c, 0x0b1c, 0x0b26,
			0x0b26, 0x0b26, 0x0b26, 0x0b26, 0x0b2e, 0x0b4f, 0x0b4f, 0x0b66,
			0x0b6e, 0x0b6e, 0x0b6e, 0x0b6e, 0x0b6e, 0x0b7a, 0x0b7a, 0x0b7a,
			0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b88, 0x0b88,
			0x0ba4, 0x0ba4, 0x0ba4, 0x0bac, 0x0bcd, 0x0bcd, 0x0bcd, 0x0bcd,
			0x0bcd, 0x0bd9, 0x0bd9, 0x0bd9, 0x0bd9, 0x0bd9, 0x0bdf, 0x0bdf,
			// Entry 1C0 - 1FF
			0x0be7, 0x0be7, 0x0be7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7,
			0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7,
			0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7, 0x0bf7,
			0x0bf7, 0x0bff, 0x0bff, 0x0bff, 0x0bff, 0x0bff, 0x0bff, 0x0bff,
			0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c15, 0x0c15,
			0x0c15, 0x0c15, 0x0c23, 0x0c23, 0x0c23, 0x0c23, 0x0c23, 0x0c2d,
			0x0c2d, 0x0c2d, 0x0c2d, 0x0c2d, 0x0c2d, 0x0c35, 0x0c35, 0x0c35,
			0x0c52, 0x0c52, 0x0c52, 0x0c62, 0x0c62, 0x0c62, 0x0c62, 0x0c62,
			// Entry 200 - 23F
			0x0c62, 0x0c7f, 0x0c96, 0x0caf, 0x0cca, 0x0cca, 0x0cca, 0x0cca,
			0x0cca, 0x0cca, 0x0cca, 0x0cca, 0x0cca, 0x0cca, 0x0cca, 0x0cca,
			0x0cca, 0x0cca, 0x0cca, 0x0cca, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2,
			0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2,
			0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2, 0x0cd2,
			0x0ce0, 0x0ce0, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0d18, 0x0d1e,
			0x0d1e, 0x0d1e, 0x0d1e, 0x0d1e, 0x0d1e, 0x0d1e, 0x0d2a, 0x0d2a,
			0x0d2a, 0x0d2a, 0x0d2a, 0x0d3a, 0x0d3a, 0x0d3a, 0x0d3a, 0x0d42,
			// Entry 240 - 27F
			0x0d42, 0x0d42, 0x0d42, 0x0d42, 0x0d42, 0x0d42, 0x0d42, 0x0d42,
			0x0d42, 0x0d42, 0x0d80, 0x0d80, 0x0da6, 0x0da6, 0x0de1, 0x0de1,
			0x0dfe, 0x0e2e, 0x0e51, 0x0e70, 0x0e91, 0x0eb2, 0x0ee4, 0x0f05,
			0x0f28, 0x0f28, 0x0f4b, 0x0f72, 0x0f91, 0x0fa5, 0x0fd0, 0x0ff9,
			0x100b, 0x100b, 0x1026, 0x103b, 0x1058,
		},
	},
	{ // cgg
		"OrukaniOrumarikiOruharabuOruberarusiOruburugariyaOrubengariOruceekiOrugi" +
			"rimaaniOruguriikiOrungyerezaOrusupaaniOrupaasiyaOrufaransaOruhausaOr" +
			"uhindiOruhangareOruindoneziaOruiboOruyitareOrujapaaniOrujavaOrukambo" +
			"diyaOrukoreyaOrumalesiyaOruburumaOrunepaliOrudaakiOrupungyabiOrupoor" +
			"iOrupocugoOruromaniaOrurrashaOrunyarwandaOrusomaariOruswidiOrutamiri" +
			"OrutailandiOrukurukiOrukurainiOru-UruduOruviyetinaamuOruyorubaOrucha" +
			"inaOruzuruRukiga",
		[]uint16{ // 247 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0031,
			0x0031, 0x0031, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0064, 0x0064, 0x006e,
			0x006e, 0x006e, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x008a,
			0x008a, 0x0092, 0x0092, 0x0092, 0x0092, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b7, 0x00b7, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00e8, 0x00f1, 0x00f1, 0x00f1,
			0x00fa, 0x00fa, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x010d, 0x010d, 0x0115,
			// Entry 80 - BF
			0x0115, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013d,
			0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d,
			0x013d, 0x013d, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0163, 0x0163, 0x0163,
			0x0163, 0x0163, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x0176,
			0x017f, 0x017f, 0x017f, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x0196, 0x0196, 0x019f, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry C0 - FF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01ac,
		},
	},
	{ // chr
		"ᎠᏩᎳᎠᏆᏏᎠᏂᎠᎬᎿᎨᏍᏛᎠᎧᎾᎠᎹᎭᎵᎩᎠᏩᎪᏂᏏᎡᎳᏈᎠᏌᎻᏏᎠᏩᎵᎧᎠᏱᎹᎳᎠᏎᏆᏣᏂᏆᏍᎯᎩᎠᏇᎳᎷᏏᏊᎵᎨᎵᎠᏂᏈᏍᎳᎹᏆᎻᏆᎳᏇᏂ" +
			"ᎦᎳᏘᏇᏔᏂᏇᏙᏂᏆᏍᏂᎠᏂᎨᏔᎳᏂᏤᏤᏂᏣᎼᎶᎪᎵᏍᎢᎧᏂᏤᎩᏧᏂᎳᏫᏍᏗ ᏍᎳᏫᎪᏧᏩᏏᏪᎵᏏᏕᏂᏍᏙᎢᏥᏗᏪᎯᏓᏐᏅᎧᎡᏪᎠᏂ" +
			"ᎪᎢᎩᎵᏏᎡᏍᏇᎳᏂᏙᏍᏆᏂᎡᏍᏙᏂᎠᏂᏆᏍᎨᏇᏏᎠᏂᏊᎳᏂᏈᏂᏍᏫᏥᎠᏂᏇᎶᎡᏍᎦᎸᏥᏭᏕᎵᎬ ᏗᏜ ᏟᏏᎠᏂᎨᎵᎩᏍᎦᏗ ᎨᎵᎩ" +
			"ᎦᎵᏏᎠᏂᏆᎳᏂᎫᏣᎳᏘᎹᎾᎧᏏᎭᎤᏌᎠᏂᏈᎷᎯᏂᏗᎧᎶᎡᏏᏂᎮᏏᎠᏂ ᏟᏲᎵᎲᏂᎦᎵᎠᏂᎮᎴᎶᎠᏰᏟ ᎦᏬᏂᎯᏍᏗᎢᏂᏙᏂᏏᎠᎢᎦ" +
			"ᎪᏏᏧᏩᏂ ᏱᎢᏙᏧᏁᏍᏓᎸᎯᎢᎩᎬᏩᎵᏲᏥᎢᎢᏄᎦᏘᏚᏣᏩᏂᏏᏆᏌ ᏣᏩᏦᏥᎠᏂᎩᎫᏳᎫᏩᏂᎠᎹᎧᏌᎧᎧᎳᎵᏑᏘᎩᎻᎷᎧᎾᏓᎪᎵᎠ" +
			"ᏂᎧᏄᎵᎧᏏᎻᎵᎫᏗᏏᎪᎻᏎᎷᎭᎩᎵᏣᎢᏍᎳᏘᏂᎸᎦᏏᎻᏋᎢᏍᎦᏂᏓᎴᎹᏊᎵᏏᎵᏂᎦᎳᎳᎣᎵᏚᏩᏂᎠᏂᎷᏆ-ᎧᏔᎦᎳᏘᏫᎠᏂᎹᎳᎦᏏ" +
			"ᎹᏌᎵᏏᎹᏫᎹᏎᏙᏂᎠᎹᎳᏯᎳᎻᎹᏂᎪᎵᎠᏂᎹᎳᏘᎹᎴᎹᎵᏘᏍᏋᎻᏍᏃᎤᎷᏧᏴᏢ ᏂᏕᏇᎴᏁᏆᎵᎾᏙᎦᏛᏥᏃᎵᏪᏥᏂ ᎾᎵᏍᎩᏃᎵᏪ" +
			"ᏥᏂ ᏉᎧᎹᎵᏧᎦᎾᏮ ᏂᏕᏇᎴᎾᏩᎰᏂᏯᏂᏣᎠᏏᏔᏂᎣᎶᎼᎣᏗᎠᎣᏎᏘᎧᏡᏂᏣᏈᏉᎵᏍᏆᏍᏙᏉᏧᎩᏍᎨᏧᏩᎠᏂᎶᎺᏂᎷᏂᏗᎶᎹᏂᎠ" +
			"ᏂᏲᏅᎯᎩᏂᏯᏩᏂᏓᏍᏂᏍᎩᏗᏌᏗᏂᎠᏂᏏᏂᏗᏧᏴᏢ ᏗᏜ ᏌᎻᏌᏂᎪᏏᎾᎭᎳᏍᎶᏩᎩᏍᎶᏫᏂᎠᏂᏌᎼᏯᏂᏠᎾᏐᎹᎵᎠᎵᏇᏂᏎᏈᎠᏂ" +
			"ᏍᏩᏘᏧᎦᎾᏮ ᏗᏜ ᏐᏠᏑᏂᏓᏂᏏᏍᏫᏗᏏᏍᏩᎯᎵᏔᎻᎵᏖᎷᎦᏔᏥᎩᏔᏱᏘᎩᎵᏂᎠᎠᏂᎬᎾᏧᏩᎾᏙᎾᎦᏂᎠᎬᎾᏦᎾᎦᏔᏔᏔᎯᏘᎠᏂ" +
			"ᏫᎦᏳᎧᎴᏂᎠᏂᎤᎵᏚᎤᏍᏇᎩᏫᏂᏓᏫᎡᏘᎾᎻᏍᏬᎳᏊᎩᏩᎷᎾᏬᎶᏫᏠᏌᏱᏗᏍᏲᏄᏆᏓᎶᏂᎨᏑᎷᎠᏥᏂᏏᎠᏓᎾᎦᎺᎠᏗᎨᎠᎨᎹᎠᏱᏄ" +
			"ᎠᎵᎤᏘᏧᎦᎾᏮ ᏗᏜ ᎠᎵᏔᎢᎠᎾᎩᎧᎹᏊᏤᎠᏩᏈᎰᎠᏑᎠᏍᏚᎵᎠᏂᎠᏩᏗᏆᎵᏁᏏᏆᏌᎠᏇᎹᏆᏇᎾᏉᏣᏊᎵᏈᏂᏏᎩᏏᎧᏉᏙᏈᎥᎩᏂ" +
			"ᏍᏟᏂᎧᏳᎦᏎᏆᏃᏥᎦᏧᎨᏎᎹᎵᎠᏣᏓᏣᎳᎩᏣᏰᏂᎠᏰᏟ ᎫᏗᏏᏎᏎᎵᏩ ᏟᏲᎵ ᎠᏂᎦᎸᏓᎪᏔᏓᎳᏆᏔᎢᏔᎩᏟ ᎤᏄᎳᏥᏌᎹᎡᎳᏗ" +
			" ᏐᏈᎠᏂᏚᎠᎳᏦᎳ-ᏬᏱᏓᏌᎦᎡᎻᏊᎡᏫᎩᎨᎧᏧᎧᎡᏬᏂᏙᎠᏈᎵᎩᏠᏂᏞᎤᎵᎠᏂᎦᎩᏏᎩᏇᏘᏏᎪᎶᏂᏔᏃᏍᏫᏏ ᎠᏂᏓᏥᎫᏏᏈᏥᏂᎭᏩ" +
			"ᎼᎯᎵᎨᎾᏂᎭᎼᏂᎩᎦᎸᎳᏗᎨ ᏐᎵᏈᎠᏂᎠᏂᎱᏆᎢᏆᏂᎢᏈᏈᎣᎢᎶᎪᎢᏂᎫᏏᎶᏣᏆᏂᎾᎪᏆᎹᏣᎺᎧᏈᎴᎧᏥᏂᏥᏧᎧᎻᏆᎧᏆᏗᎠᏂᏔ" +
			"ᏯᏆᎹᎪᏕᎧᏊᏪᏗᎠᏄᎪᎶᎧᏏᎪᏱᎳ ᏥᏂᎧᎪᎧᎴᏂᏥᏂᎩᎻᏊᏚᎧᏂᎧᏂᏇᎴᎧᎳᏣᏱ-ᏆᎵᎧᎵᎧᎴᎵᎠᏂᎫᎷᎩᏝᎻᏆᎸᏆᏫᎠᎪᎶᏂᎠ" +
			"ᏂᎫᎻᎧᎳᏗᏃᎳᏂᎩᎴᏏᎦᏂᎳᎪᏓᎶᏏᏧᏴᏢ ᏗᏜ ᎷᎵᎷᏆ-ᎷᎷᎠᎷᎾᏓᎷᎣᎻᏐᎷᏱᎠᎹᏚᎴᏏᎹᎦᎯᎹᏟᎵᎹᎧᏌᎹᏌᏱᎼᎧᏌᎺᎾᏕ" +
			"ᎺᎷᎼᎵᏏᎡᏂᎹᎫᏩ-ᎻᏙᎺᎳ’ᎻᎧᎹᎩᎻᎾᎧᏆᎤᎺᏂᏉᎵᎼᎭᎩᎼᏍᏏᎽᏂᏓᎩᏧᏈᏍᏗ ᏗᎦᏬᏂᎯᏍᏗᎠᎫᏌᎻᎳᏕᏏᎡᏏᏯᎹᏌᏕᎳᏂ" +
			"ᏂᏯᏆᎵᏔᏂᎾᎹᏁᏩᎵᏂᎠᏏᏂᏳᏫᏯᏂᏆᏏᏲᎾᏥᏰᎹᏊᏂᏃᎦᏱᎾᎪᏧᏴᏢ ᏗᏜ ᏐᏠᏄᏪᎵᏂᏯᎾᎪᎴᏇᎦᏏᎠᏂᏆᎹᏆᎾᎦᏆᏈᏯᎺᎾᏙ" +
			"ᏆᎳᎤᏩᏂᎾᎩᎵᎠᏂ ᏈᏥᏂᏡᏏᎠᏂᎩᏤᎳᏆᏄᏫᎳᎶᏙᎾᎦᏂᎶᎹᏉᎠᏬᎹᏂᎠᏂᏆᏌᏅᏓᏫᏌᎧᎾᏌᎹᏊᎷᏌᏂᏔᎵᎾᎦᎹᏇᏌᏁᎫᏏᏏᎵᎠ" +
			"ᏂᏍᎦᏗᏏᏂᎦᏎᎾᎪᏱᎳᏈᎶ ᏎᏂᏔᏤᎵᎯᏘᏝᏂᏧᎦᎾᏮ ᏗᏜ ᏌᎻᎷᎴ ᏌᎻᎢᎾᎵ ᏌᎻᏍᎪᎵᏘ ᏌᎻᏐᏂᏂᎨᏏᎳᎾᏂ ᏙᏃᎪᏌᎰ" +
			"ᏑᎫᎹᎪᎼᎵᎠᏂᏏᎵᎠᎩᏘᎹᏁᏖᏐᏖᏚᎼᏢᏓᏥᏟᎦᎾᏙᎩ ᏈᏏᏂᏔᎶᎪᏛᎹᏊᎧᏚᏩᎷᏔᏌᏩᎩᏚᏫᏂᎠᏂᎠᏰᏟ ᎡᎶᎯ ᏓᏟᎶᏍᏗᏓᏅ" +
			"Ꭲ ᏔᎹᏏᏘᎤᏚᎷᏘᎤᎹᏊᏅᏚᎤᎾᏍᎦᎸᏩᏱᏭᎾᏦᏩᎵᏎᎵᏬᎳᏱᏔᏩᎴᎧᎳᎻᎧᏐᎦᏰᎾᎦᏇᏂᏰᎹᏋᎨᎾᏙᏂᏏᎠᏟᎶᏍᏗ ᎼᎶᎪ ᏔᎹ" +
			"ᏏᏘᏑᏂᏝ ᎦᏬᏂᎯᏍᏗ ᎦᎸᏛᎢ ᏱᎩᏌᏌᎪᎯᏊ ᎢᎬᏥᎩ ᎠᏟᎶᏍᏗ ᎡᎳᏈᎠᏟᏯᏂ ᎠᏂᏓᏥᏍᏫᏏ ᎦᎸᎳᏗ ᎠᏂᏓᏥᎡᎳᏗᏜ" +
			" ᎩᎵᏏᎨᎾᏓ ᎩᎵᏏᎩᎵᏏᏲ ᎩᎵᏏᎠᎹᏰᏟ ᎩᎵᏏᏔᏘᏂ ᎠᎹᏰᏟ ᏍᏆᏂᎠᏂᏍᏆᏂᏱ ᏍᏆᏂᏍᏆᏂᏱ ᏍᏆᏂᎨᎾᏓ ᎦᎸᏥᏍᏫᏏ " +
			"ᎦᎸᏥᎡᎳᏗ ᏁᏛᎳᏂᏊᎵᏥᎥᎻ ᏛᏥᏆᏏᎵᎢ ᏉᏧᎦᎵᏉᏥᎦᎳ ᏉᏧᎦᎵᎹᎵᏙᏫᎠ ᏣᎹᏂᎠᏂᎧᏂᎪ ᏍᏩᎯᎵᎠᎯᏗᎨ ᏓᎶᏂᎨᎤ" +
			"ᏦᏍᏗ ᏓᎶᏂᎨ",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0009, 0x0018, 0x0018, 0x002a, 0x0033, 0x0042, 0x0051,
			0x005a, 0x0066, 0x0072, 0x007e, 0x008d, 0x009c, 0x00a8, 0x00ba,
			0x00c6, 0x00d2, 0x00de, 0x00ea, 0x00f3, 0x0102, 0x010e, 0x0117,
			0x0120, 0x0132, 0x0132, 0x0138, 0x0157, 0x0160, 0x0169, 0x0172,
			0x017b, 0x0184, 0x0190, 0x0196, 0x01a2, 0x01ab, 0x01bd, 0x01c6,
			0x01d8, 0x01e1, 0x01ed, 0x01f6, 0x01ff, 0x020b, 0x0217, 0x0220,
			0x0240, 0x0249, 0x025c, 0x026b, 0x0274, 0x0280, 0x028c, 0x0295,
			0x02a1, 0x02aa, 0x02aa, 0x02b9, 0x02cf, 0x02e1, 0x02e1, 0x02ea,
			// Entry 40 - 7F
			0x0306, 0x0318, 0x0318, 0x0321, 0x0331, 0x0331, 0x0337, 0x034f,
			0x0361, 0x0370, 0x037c, 0x0389, 0x0395, 0x0395, 0x039e, 0x03ad,
			0x03b6, 0x03c5, 0x03ce, 0x03d7, 0x03e3, 0x03ec, 0x03f8, 0x0401,
			0x0407, 0x0410, 0x041f, 0x0428, 0x043d, 0x0446, 0x0455, 0x0461,
			0x0467, 0x0479, 0x0489, 0x0498, 0x04a4, 0x04b0, 0x04b6, 0x04c5,
			0x04d4, 0x04e6, 0x04ef, 0x04f5, 0x0501, 0x050a, 0x0513, 0x0529,
			0x0532, 0x053b, 0x0541, 0x055d, 0x0579, 0x0592, 0x059b, 0x05a7,
			0x05b3, 0x05b3, 0x05bc, 0x05c5, 0x05d1, 0x05dd, 0x05dd, 0x05e6,
			// Entry 80 - BF
			0x05ef, 0x05fb, 0x0604, 0x0613, 0x061c, 0x062b, 0x0634, 0x0646,
			0x0655, 0x0664, 0x066d, 0x0684, 0x068d, 0x0699, 0x06a5, 0x06b7,
			0x06c3, 0x06c9, 0x06d2, 0x06de, 0x06ea, 0x06f3, 0x070d, 0x071c,
			0x0728, 0x0734, 0x073d, 0x0746, 0x074f, 0x0755, 0x0764, 0x0770,
			0x0779, 0x0785, 0x078e, 0x0797, 0x079d, 0x07ac, 0x07b2, 0x07c4,
			0x07cd, 0x07d9, 0x07e2, 0x07f4, 0x0800, 0x0809, 0x0812, 0x0818,
			0x0821, 0x082a, 0x082a, 0x0836, 0x083c, 0x0848, 0x0848, 0x0857,
			0x0860, 0x0860, 0x0860, 0x0869, 0x0872, 0x0872, 0x0872, 0x087e,
			// Entry C0 - FF
			0x087e, 0x089e, 0x089e, 0x08aa, 0x08aa, 0x08b3, 0x08b3, 0x08bf,
			0x08bf, 0x08bf, 0x08bf, 0x08bf, 0x08bf, 0x08c5, 0x08c5, 0x08d7,
			0x08d7, 0x08e0, 0x08e0, 0x08ec, 0x08ec, 0x08f5, 0x08f5, 0x08f5,
			0x08f5, 0x08f5, 0x08fe, 0x08fe, 0x0904, 0x0904, 0x0904, 0x0904,
			0x0910, 0x0910, 0x0916, 0x0916, 0x0916, 0x0922, 0x0922, 0x0922,
			0x0922, 0x0922, 0x0928, 0x0928, 0x0928, 0x0937, 0x0937, 0x093d,
			0x093d, 0x093d, 0x093d, 0x0946, 0x0946, 0x094f, 0x0955, 0x0955,
			0x0955, 0x095e, 0x0964, 0x0964, 0x096d, 0x096d, 0x0976, 0x097f,
			// Entry 100 - 13F
			0x0992, 0x0992, 0x0992, 0x0992, 0x09b5, 0x09b5, 0x09be, 0x09c7,
			0x09d0, 0x09d0, 0x09d0, 0x09e3, 0x09e3, 0x09e9, 0x09e9, 0x09ff,
			0x09ff, 0x0a08, 0x0a08, 0x0a15, 0x0a15, 0x0a1e, 0x0a27, 0x0a30,
			0x0a30, 0x0a30, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a3c, 0x0a48, 0x0a48,
			0x0a48, 0x0a54, 0x0a54, 0x0a5a, 0x0a5a, 0x0a5a, 0x0a5a, 0x0a5a,
			0x0a5a, 0x0a5a, 0x0a69, 0x0a6c, 0x0a6c, 0x0a6c, 0x0a6c, 0x0a6c,
			0x0a6c, 0x0a72, 0x0a7e, 0x0a7e, 0x0a7e, 0x0a7e, 0x0a7e, 0x0a7e,
			0x0a8d, 0x0a8d, 0x0a8d, 0x0a8d, 0x0aa3, 0x0aa3, 0x0aa3, 0x0aa9,
			// Entry 140 - 17F
			0x0ab2, 0x0ab2, 0x0ab2, 0x0abb, 0x0abb, 0x0aca, 0x0aca, 0x0ad6,
			0x0af5, 0x0af5, 0x0b01, 0x0b0a, 0x0b16, 0x0b1f, 0x0b2b, 0x0b2b,
			0x0b2b, 0x0b37, 0x0b40, 0x0b49, 0x0b49, 0x0b49, 0x0b49, 0x0b49,
			0x0b52, 0x0b5b, 0x0b61, 0x0b6a, 0x0b6a, 0x0b79, 0x0b79, 0x0b82,
			0x0b8b, 0x0b9d, 0x0b9d, 0x0ba3, 0x0ba3, 0x0ba9, 0x0ba9, 0x0bb9,
			0x0bb9, 0x0bb9, 0x0bbf, 0x0bce, 0x0bda, 0x0bda, 0x0be6, 0x0be6,
			0x0bec, 0x0c05, 0x0c05, 0x0c05, 0x0c14, 0x0c1d, 0x0c29, 0x0c32,
			0x0c41, 0x0c4a, 0x0c4a, 0x0c53, 0x0c5c, 0x0c5c, 0x0c5c, 0x0c68,
			// Entry 180 - 1BF
			0x0c68, 0x0c68, 0x0c68, 0x0c71, 0x0c71, 0x0c71, 0x0c77, 0x0c8e,
			0x0c8e, 0x0c9e, 0x0c9e, 0x0ca7, 0x0cad, 0x0cb3, 0x0cbc, 0x0cbc,
			0x0cbc, 0x0cc8, 0x0cc8, 0x0cd1, 0x0cda, 0x0ce3, 0x0ce3, 0x0cec,
			0x0cec, 0x0cf5, 0x0cf5, 0x0cfe, 0x0d04, 0x0d13, 0x0d13, 0x0d23,
			0x0d2c, 0x0d38, 0x0d47, 0x0d47, 0x0d53, 0x0d5c, 0x0d65, 0x0d65,
			0x0d71, 0x0d93, 0x0d9c, 0x0da8, 0x0da8, 0x0da8, 0x0da8, 0x0db1,
			0x0dc0, 0x0dc0, 0x0dd2, 0x0dd8, 0x0dd8, 0x0de1, 0x0dea, 0x0df9,
			0x0df9, 0x0e02, 0x0e14, 0x0e1d, 0x0e1d, 0x0e1d, 0x0e23, 0x0e3a,
			// Entry 1C0 - 1FF
			0x0e43, 0x0e43, 0x0e43, 0x0e52, 0x0e52, 0x0e52, 0x0e52, 0x0e52,
			0x0e61, 0x0e61, 0x0e70, 0x0e82, 0x0e91, 0x0e91, 0x0eaa, 0x0eaa,
			0x0eaa, 0x0eaa, 0x0eaa, 0x0eaa, 0x0eaa, 0x0eaa, 0x0eaa, 0x0eb6,
			0x0eb6, 0x0ebc, 0x0ebc, 0x0ebc, 0x0ec8, 0x0eda, 0x0eda, 0x0eda,
			0x0ee3, 0x0ee3, 0x0ee3, 0x0ee3, 0x0ee3, 0x0ef5, 0x0ef8, 0x0f04,
			0x0f0d, 0x0f0d, 0x0f19, 0x0f19, 0x0f25, 0x0f25, 0x0f31, 0x0f3a,
			0x0f49, 0x0f52, 0x0f52, 0x0f52, 0x0f5b, 0x0f61, 0x0f61, 0x0f61,
			0x0f77, 0x0f77, 0x0f77, 0x0f86, 0x0f8c, 0x0f8c, 0x0f8c, 0x0f8c,
			// Entry 200 - 23F
			0x0f8c, 0x0fa6, 0x0fb3, 0x0fc3, 0x0fd6, 0x0fe2, 0x0fe2, 0x0ff8,
			0x0ff8, 0x0ffe, 0x0ffe, 0x1007, 0x1007, 0x1007, 0x1016, 0x1016,
			0x1022, 0x1022, 0x1022, 0x102b, 0x1031, 0x1031, 0x103a, 0x1043,
			0x1043, 0x1043, 0x1043, 0x104c, 0x104c, 0x104c, 0x104c, 0x104c,
			0x105c, 0x105c, 0x1065, 0x1065, 0x1065, 0x1065, 0x1071, 0x107a,
			0x1086, 0x1095, 0x10ce, 0x10da, 0x10da, 0x10e9, 0x10f8, 0x10fe,
			0x10fe, 0x10fe, 0x10fe, 0x10fe, 0x10fe, 0x10fe, 0x1107, 0x1113,
			0x111f, 0x1125, 0x1125, 0x1125, 0x1125, 0x1131, 0x1131, 0x1137,
			// Entry 240 - 27F
			0x1137, 0x1137, 0x1146, 0x114f, 0x114f, 0x115e, 0x115e, 0x115e,
			0x115e, 0x115e, 0x1184, 0x118a, 0x11b4, 0x11ba, 0x11ea, 0x11ea,
			0x1203, 0x1226, 0x123c, 0x124f, 0x1265, 0x127b, 0x129b, 0x12b7,
			0x12cd, 0x12cd, 0x12e0, 0x12f3, 0x1309, 0x131f, 0x1338, 0x1351,
			0x1370, 0x1370, 0x1386, 0x139f, 0x13b8,
		},
	},
	{ // ckb
		"ئەمهەرینجیعەرەبیئاسامیئازەربایجانیبێلاڕووسیبۆلگاریبەنگلادێشیبرێتونیبۆسنی" +
			"كاتالۆنیچەكیوێلزیدانماركیئاڵمانییۆنانیئینگلیزیئێسپیرانتۆئیسپانیئیست" +
			"ۆنیباسکیفارسیفینلەندیفەرانسیفریسیی ڕۆژاوائیرلەندیگالیسیگووارانیگوجا" +
			"راتیهیبرێهیندیكرواتیهەنگاری (مەجاری)ئەرمەنیئێەندونیزیئیسلەندیئیتالی" +
			"ژاپۆنیجاڤانیگۆرجستانیکازاخیکوردیكرگیزیلاتینیلينگالالاویلیتوانیلێتۆن" +
			"یماكێدۆنیمەنگۆلیماراتینیپالیهۆڵەندینۆروێژیئۆرییاپەنجابیپۆڵۆنیایی (ل" +
			"ەهستانی)پەشتووپورتوگالیڕۆمانیڕووسیسانسکريتسيندیسینهەلیسلۆڤاكیسلۆڤێن" +
			"یسۆمالیئاڵبانیسەربیسێسۆتۆسودانیسویدیتامیلیتەلۆگویتاجیکیتایلەندیتیگر" +
			"ینیایتورکمانیتورکیئويخووریئۆكراینیئۆردووئوزبەکیڤیەتنامیچینیزولوکورد" +
			"یی ناوەندیمازەندەرانیکوردیی باشووریسامی باشووریزمانی نەناسراوئازەرب" +
			"ایجانی باشووریئینگلیزیی ئۆسترالیاییئینگلیزیی کەنەداییئینگلیزیی بریت" +
			"انیاییئینگلیزیی ئەمەریکاییپورتوگاڵی برازیلپورتوگاڵی (پورتوگاڵ)",
		[]uint16{ // 608 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014,
			0x0020, 0x002c, 0x002c, 0x002c, 0x0044, 0x0044, 0x0056, 0x0064,
			0x0064, 0x0064, 0x0078, 0x0078, 0x0086, 0x0090, 0x00a0, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a8, 0x00a8, 0x00a8, 0x00b2, 0x00c2,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00dc, 0x00ec, 0x0100, 0x010e,
			0x011c, 0x0126, 0x0130, 0x0130, 0x0140, 0x0140, 0x0140, 0x014e,
			0x0167, 0x0177, 0x0177, 0x0183, 0x0193, 0x01a3, 0x01a3, 0x01a3,
			0x01ad, 0x01b7, 0x01b7, 0x01c3, 0x01c3, 0x01e0, 0x01ee, 0x01ee,
			// Entry 40 - 7F
			0x01ee, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0202, 0x0212,
			0x021e, 0x021e, 0x022a, 0x0236, 0x0248, 0x0248, 0x0248, 0x0248,
			0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x0254, 0x025e,
			0x025e, 0x025e, 0x026a, 0x0276, 0x0276, 0x0276, 0x0276, 0x0284,
			0x028c, 0x029a, 0x029a, 0x02a6, 0x02a6, 0x02a6, 0x02a6, 0x02b6,
			0x02b6, 0x02c4, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0, 0x02d0,
			0x02dc, 0x02dc, 0x02ea, 0x02ea, 0x02f8, 0x02f8, 0x02f8, 0x02f8,
			0x02f8, 0x02f8, 0x02f8, 0x0304, 0x0304, 0x0312, 0x0312, 0x0337,
			// Entry 80 - BF
			0x0343, 0x0355, 0x0355, 0x0355, 0x0355, 0x0361, 0x036b, 0x036b,
			0x037b, 0x037b, 0x0385, 0x0385, 0x0385, 0x0393, 0x03a1, 0x03af,
			0x03af, 0x03af, 0x03bb, 0x03c9, 0x03d3, 0x03d3, 0x03df, 0x03eb,
			0x03f5, 0x03f5, 0x0401, 0x040f, 0x041b, 0x042b, 0x043d, 0x044d,
			0x044d, 0x044d, 0x0457, 0x0457, 0x0457, 0x0457, 0x0467, 0x0477,
			0x0483, 0x0491, 0x0491, 0x04a1, 0x04a1, 0x04a1, 0x04a1, 0x04a1,
			0x04a1, 0x04a1, 0x04a1, 0x04a9, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			// Entry C0 - FF
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			// Entry 100 - 13F
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			// Entry 140 - 17F
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			// Entry 180 - 1BF
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc, 0x04cc,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			// Entry 1C0 - 1FF
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd,
			0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd, 0x04fd,
			// Entry 200 - 23F
			0x04fd, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514,
			0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514,
			0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514,
			0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514,
			0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514,
			0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x0514, 0x052f, 0x052f,
			0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f,
			0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f,
			// Entry 240 - 27F
			0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f,
			0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x052f, 0x0556,
			0x0556, 0x0556, 0x057f, 0x05a2, 0x05c9, 0x05f0, 0x05f0, 0x05f0,
			0x05f0, 0x05f0, 0x05f0, 0x05f0, 0x05f0, 0x05f0, 0x060f, 0x0634,
		},
	},
	{ // cs
		csLangStr,
		csLangIdx,
	},
	{ // cy
		"AffaregAbchasegAfestanegAffricânegAcanegAmharegAragonegArabegAsamegAfare" +
			"gAymaregAserbaijanegBashcortegBelarwsegBwlgaregBislamaBambaregBengal" +
			"egTibetegLlydawegBosniegCatalanegTsietsienegTsiamorroCorsegCriTsiece" +
			"gHen SlafonegTshwfashegCymraegDanegAlmaenegDifehiDzongkhaEweGroegSae" +
			"snegEsperantoSbaenegEstonegBasgegPersegFfwlaFfinnegFfijïegFfaröegFfr" +
			"angegFfriseg y GorllewinGwyddelegGaeleg yr AlbanGalisiegGuaraníGwjar" +
			"atiManawegHawsaHebraegHindiCroategCreol HaitiHwngaregArmenegHereroIn" +
			"terlinguaIndonesegInterlingueIgboNwoswInwpiacegIdoIslandegEidalegInw" +
			"ctitwtJapaneegJafanaegGeorgegCongoKikuyuKuanyamaCasachegKalaallisutC" +
			"hmeregKannadaCoreegCanwriCashmiregCwrdegComiCernywegCirgisegLladinLw" +
			"csembwrgegGandaLimbwrgegLingalaLaoegLithwanegLuba-KatangaLatfiegMala" +
			"gasegMarsialegMaoriMacedonegMalayalamMongolegMarathiMaleiegMaltegByr" +
			"manegNawrŵegNdebele GogleddolNepalegNdongaIseldiregNorwyeg NynorskNo" +
			"rwyeg BokmålNdebele DeheuolNafahoNianjaOcsitanegOjibwaOromoOriyaOset" +
			"egPwnjabegPaliPwylegPashtoPortiwgeegQuechuaRománshRwndiRwmanegRwsegC" +
			"iniarŵandegSansgritSardegSindhiSami GogleddolSangoSinhalegSlofacegSl" +
			"ofenegSamöegShonaSomalegAlbanegSerbegSwatiSesotheg DeheuolSwndanegSw" +
			"edegSwahiliTamilegTeluguTajicegThaiTigrinyaTwrcmenegTswanaTongegTyrc" +
			"egTsongaegTataregTahitïegUighurWcreinegWrdwWsbecegFendegFietnamegFol" +
			"apükWalwnegWoloffXhosaIddew-AlmaenegIorwbaTsieineegSwlwAcehnegAcoliA" +
			"dangmegCircaseg GorllewinolArabeg TunisiaAffrihiliAghemegAinŵegAcade" +
			"gAlabamäegAlewtegGhegeg AlbaniaAltäeg DeheuolHen SaesnegAngikaAramae" +
			"gArawcanegAraonaegArapahoArabeg AlgeriaArawacegArabeg MorocoArabeg y" +
			"r AifftAswIaith Arwyddion AmericaAstwrianegAwadhiBalwtsiBalïegBasâeg" +
			"BamwmegBejäegBembegBenaBaffwtegBadagaBalochi GorllewinolBhojpuriBini" +
			"ComegSiksikaBrahuiBodoAcwsegBwriategBugineseBwlwBlinCadoCaribegAtsam" +
			"egCebuanoTsigaChuukeseMariegSioctoTsierocîCheyenneCwrdeg SoraniCopte" +
			"gTyrceg y CrimeaFfrangeg Seselwa CreoleDacotaegDargwaTaitaDogribDinc" +
			"aZarmaegDogriSorbeg IsafDiwalegIseldireg CanolJola-FonyiDazagaEmbwEf" +
			"ikHen EifftegEkajukElamegSaesneg CanolEwondoExtremaduregFfilipinegFf" +
			"inneg TornedalFonFfrangeg CajwnFfrangeg CanolHen FfrangegArpitanegFf" +
			"riseg GogleddolFfriseg y DwyrainFfriwlegGaGagauzGaioGbaiaDareg y Zor" +
			"oastriaidGeezGilbertegAlmaeneg Uchel CanolHen Almaeneg UchelGorontal" +
			"oGothegHen RoegAlmaeneg y SwistirGusiiGwichʼinHaidaHawäiegHiligaynon" +
			"HethegHmongegSorbeg UchafHupaIbanegIbibioIlocanegIngwsiegLojbanNgomb" +
			"aMatsiameIddew-BersiegIddew-ArabegCara-CalpacegCabilegKachinJjuCamba" +
			"Circaseg DwyreiniolTyapegMacondegCaboferdianegKoroCàsegKoyra ChiiniC" +
			"howaregKakoKalenjinKimbunduKomi-PermyakConcaniKpelleKarachay-BalkarC" +
			"arelegKurukhShambalaBaffiaCwlenegCwmicegIddew-SbaenegLangiLahndaLamb" +
			"aLezghegLakotaLombardegMongoLoziLuri GogleddolLatgalegLuba-LuluaLwnd" +
			"aLŵoLwshaiegLwyiaMadwregMagahiMaithiliMacasaregMandingoMasaiMocsiaMa" +
			"ndaregMendegMêrwMorisyenGwyddeleg CanolMakhuwa-MeettoMetaMicmacegMin" +
			"angkabauManshwManipwriMohocegMosiMari GorllewinolMundangMwy nag un i" +
			"aithCreekMirandegMarwariErzyaMasanderaniNapliegNamaAlmaeneg IselNewa" +
			"egNiasNiueanAo NagaKwasioNgiemboonNogaiHen NorsegN’KoSotho Gogleddol" +
			"NŵeregHen NewariNiamweziNiancoleNioroNzimegOsagegTyrceg OtomanPangas" +
			"inegPahlafiPampangaPapiamentoPalawanPicardegPidgin NigeriaAlmaeneg P" +
			"ensylfaniaHen BersiegAlmaeneg PalatinPhoenicegPiedmontegPontegPohnpe" +
			"ianegPrwsegHen BrofensalegK’iche’RajasthanegRapanŵiRaratongegRomboRo" +
			"maniRotumanegAromanegRwaSandäwegSakhaAramaeg SamariaSambŵrwSasacegSa" +
			"ntaliNgambeiegSangwSisilegSgotegSasareseg SardiniaCwrdeg DeheuolSene" +
			"caSenaSeriSelcypegKoyraboro SenniHen WyddelegSamogitegTachelhitShanA" +
			"rabeg ChadSidamoIs-silesiegSami DeheuolSami LwleSami InariSami Scolt" +
			"SonincegSogdegSranan TongoSereregSahoFfriseg SaterlandSwcwmaSwsŵegSw" +
			"meregComoregHen SyriegSyriegSilesiegTuluTimnegTesoTerenaTetumegTigre" +
			"gTifegTocelawegTsakhuregKlingonLlingitTalyshegTamashecegTok PisinTar" +
			"okoTsaconegTwmbwcaTwfalwegTasawaqTwfwniegTamaseit Canolbarth MorocoF" +
			"otiacegWgaritegUmbunduY GwraiddFaiegFenisegFepsFflemeg GorllewinolFo" +
			"tegFunjoWalseregWalamoWinarayegWashoWarlpiriCalmycegSogaIangbenIemba" +
			"egCantoneegZapotecegBlisssymbolsZêlandegTamaseit SafonolZuniDim cynn" +
			"wys ieithyddolZazäegArabeg Modern SafonolAserbaijaneg DeheuolAlmaene" +
			"g AwstriaAlmaeneg Safonol y SwistirSaesneg AwstraliaSaesneg CanadaSa" +
			"esneg PrydainSaesneg AmericaSbaeneg America LadinSbaeneg EwropSbaene" +
			"g MecsicoFfrangeg CanadaFfrangeg y SwistirSacsoneg IselFflemegPortiw" +
			"geeg BrasilPortiwgeeg EwropMoldofegSerbo-CroategSwahili’r CongoTsiei" +
			"neeg SymledigTsieineeg Traddodiadol",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0007, 0x000f, 0x0018, 0x0023, 0x0029, 0x0030, 0x0038,
			0x003e, 0x0044, 0x004a, 0x0051, 0x005d, 0x0067, 0x0070, 0x0078,
			0x007f, 0x0087, 0x008f, 0x0096, 0x009e, 0x00a5, 0x00ae, 0x00b9,
			0x00c2, 0x00c8, 0x00cb, 0x00d2, 0x00de, 0x00e8, 0x00ef, 0x00f4,
			0x00fc, 0x0102, 0x010a, 0x010d, 0x0112, 0x0119, 0x0122, 0x0129,
			0x0130, 0x0136, 0x013c, 0x0141, 0x0148, 0x0150, 0x0158, 0x0160,
			0x0173, 0x017c, 0x018b, 0x0193, 0x019b, 0x01a3, 0x01aa, 0x01af,
			0x01b6, 0x01bb, 0x01bb, 0x01c2, 0x01cd, 0x01d5, 0x01dc, 0x01e2,
			// Entry 40 - 7F
			0x01ed, 0x01f6, 0x0201, 0x0205, 0x020a, 0x0213, 0x0216, 0x021e,
			0x0225, 0x022e, 0x0236, 0x023e, 0x0245, 0x024a, 0x0250, 0x0258,
			0x0260, 0x026b, 0x0272, 0x0279, 0x027f, 0x0285, 0x028e, 0x0294,
			0x0298, 0x02a0, 0x02a8, 0x02ae, 0x02ba, 0x02bf, 0x02c8, 0x02cf,
			0x02d4, 0x02dd, 0x02e9, 0x02f0, 0x02f9, 0x0302, 0x0307, 0x0310,
			0x0319, 0x0321, 0x0328, 0x032f, 0x0335, 0x033d, 0x0345, 0x0356,
			0x035d, 0x0363, 0x036c, 0x037b, 0x038a, 0x0399, 0x039f, 0x03a5,
			0x03ae, 0x03b4, 0x03b9, 0x03be, 0x03c4, 0x03cc, 0x03d0, 0x03d6,
			// Entry 80 - BF
			0x03dc, 0x03e6, 0x03ed, 0x03f5, 0x03fa, 0x0401, 0x0406, 0x0413,
			0x041b, 0x0421, 0x0427, 0x0435, 0x043a, 0x0442, 0x044a, 0x0452,
			0x0459, 0x045e, 0x0465, 0x046c, 0x0472, 0x0477, 0x0487, 0x048f,
			0x0495, 0x049c, 0x04a3, 0x04a9, 0x04b0, 0x04b4, 0x04bc, 0x04c5,
			0x04cb, 0x04d1, 0x04d7, 0x04df, 0x04e6, 0x04ef, 0x04f5, 0x04fd,
			0x0501, 0x0508, 0x050e, 0x0517, 0x051f, 0x0526, 0x052c, 0x0531,
			0x053f, 0x0545, 0x0545, 0x054e, 0x0552, 0x0559, 0x055e, 0x0566,
			0x057a, 0x0588, 0x0591, 0x0598, 0x059f, 0x05a5, 0x05af, 0x05b6,
			// Entry C0 - FF
			0x05c4, 0x05d3, 0x05de, 0x05e4, 0x05eb, 0x05f4, 0x05fc, 0x0603,
			0x0611, 0x0611, 0x0619, 0x0626, 0x0635, 0x0638, 0x064f, 0x0659,
			0x0659, 0x065f, 0x0666, 0x066d, 0x066d, 0x0674, 0x067b, 0x067b,
			0x067b, 0x0682, 0x0688, 0x0688, 0x068c, 0x0694, 0x069a, 0x06ad,
			0x06b5, 0x06b5, 0x06b9, 0x06b9, 0x06be, 0x06c5, 0x06c5, 0x06c5,
			0x06c5, 0x06cb, 0x06cf, 0x06d5, 0x06dd, 0x06e5, 0x06e9, 0x06ed,
			0x06ed, 0x06f1, 0x06f8, 0x06f8, 0x06ff, 0x0706, 0x070b, 0x070b,
			0x070b, 0x0713, 0x0719, 0x0719, 0x071f, 0x071f, 0x0728, 0x0730,
			// Entry 100 - 13F
			0x073d, 0x0743, 0x0743, 0x0752, 0x0769, 0x0769, 0x0771, 0x0777,
			0x077c, 0x077c, 0x077c, 0x0782, 0x0787, 0x078e, 0x0793, 0x079e,
			0x079e, 0x07a5, 0x07b4, 0x07be, 0x07be, 0x07c4, 0x07c8, 0x07cc,
			0x07cc, 0x07d7, 0x07dd, 0x07e3, 0x07f0, 0x07f0, 0x07f6, 0x0802,
			0x0802, 0x080c, 0x081c, 0x081f, 0x082d, 0x083b, 0x0847, 0x0850,
			0x0861, 0x0872, 0x087a, 0x087c, 0x0882, 0x0882, 0x0886, 0x088b,
			0x089f, 0x08a3, 0x08ac, 0x08ac, 0x08c0, 0x08d2, 0x08d2, 0x08d2,
			0x08db, 0x08e1, 0x08e1, 0x08e9, 0x08fb, 0x08fb, 0x08fb, 0x0900,
			// Entry 140 - 17F
			0x0909, 0x090e, 0x090e, 0x0916, 0x0916, 0x0920, 0x0926, 0x092d,
			0x0939, 0x0939, 0x093d, 0x0943, 0x0949, 0x0951, 0x0959, 0x0959,
			0x0959, 0x095f, 0x0965, 0x096d, 0x097a, 0x0986, 0x0986, 0x0993,
			0x099a, 0x09a0, 0x09a3, 0x09a8, 0x09a8, 0x09bb, 0x09bb, 0x09c1,
			0x09c9, 0x09d6, 0x09d6, 0x09da, 0x09da, 0x09e0, 0x09e0, 0x09ec,
			0x09f4, 0x09f4, 0x09f8, 0x0a00, 0x0a08, 0x0a14, 0x0a1b, 0x0a1b,
			0x0a21, 0x0a30, 0x0a30, 0x0a30, 0x0a37, 0x0a3d, 0x0a45, 0x0a4b,
			0x0a52, 0x0a59, 0x0a59, 0x0a66, 0x0a6b, 0x0a71, 0x0a76, 0x0a7d,
			// Entry 180 - 1BF
			0x0a7d, 0x0a7d, 0x0a7d, 0x0a83, 0x0a8c, 0x0a91, 0x0a95, 0x0aa3,
			0x0aab, 0x0ab5, 0x0ab5, 0x0aba, 0x0abe, 0x0ac6, 0x0acb, 0x0acb,
			0x0acb, 0x0ad2, 0x0ad2, 0x0ad8, 0x0ae0, 0x0ae9, 0x0af1, 0x0af6,
			0x0af6, 0x0afc, 0x0b04, 0x0b0a, 0x0b0f, 0x0b17, 0x0b26, 0x0b34,
			0x0b38, 0x0b40, 0x0b4b, 0x0b51, 0x0b59, 0x0b60, 0x0b64, 0x0b74,
			0x0b7b, 0x0b8b, 0x0b90, 0x0b98, 0x0b9f, 0x0b9f, 0x0b9f, 0x0ba4,
			0x0baf, 0x0baf, 0x0bb6, 0x0bba, 0x0bc7, 0x0bcd, 0x0bd1, 0x0bd7,
			0x0bde, 0x0be4, 0x0bed, 0x0bf2, 0x0bfc, 0x0bfc, 0x0c02, 0x0c11,
			// Entry 1C0 - 1FF
			0x0c18, 0x0c22, 0x0c2a, 0x0c32, 0x0c37, 0x0c3d, 0x0c43, 0x0c50,
			0x0c5a, 0x0c61, 0x0c69, 0x0c73, 0x0c7a, 0x0c82, 0x0c90, 0x0ca4,
			0x0ca4, 0x0caf, 0x0cbf, 0x0cc8, 0x0cd2, 0x0cd8, 0x0ce3, 0x0ce9,
			0x0cf8, 0x0d03, 0x0d03, 0x0d0e, 0x0d16, 0x0d20, 0x0d20, 0x0d20,
			0x0d25, 0x0d2b, 0x0d34, 0x0d34, 0x0d34, 0x0d3c, 0x0d3f, 0x0d48,
			0x0d4d, 0x0d5c, 0x0d64, 0x0d6b, 0x0d72, 0x0d72, 0x0d7b, 0x0d80,
			0x0d87, 0x0d8d, 0x0d9f, 0x0dad, 0x0db3, 0x0db7, 0x0dbb, 0x0dc3,
			0x0dd2, 0x0dde, 0x0de7, 0x0df0, 0x0df4, 0x0dff, 0x0e05, 0x0e10,
			// Entry 200 - 23F
			0x0e10, 0x0e1c, 0x0e25, 0x0e2f, 0x0e39, 0x0e41, 0x0e47, 0x0e53,
			0x0e5a, 0x0e5e, 0x0e6f, 0x0e75, 0x0e7c, 0x0e83, 0x0e8a, 0x0e94,
			0x0e9a, 0x0ea2, 0x0ea6, 0x0eac, 0x0eb0, 0x0eb6, 0x0ebd, 0x0ec3,
			0x0ec8, 0x0ed1, 0x0eda, 0x0ee1, 0x0ee8, 0x0ef0, 0x0efa, 0x0efa,
			0x0f03, 0x0f03, 0x0f09, 0x0f11, 0x0f11, 0x0f11, 0x0f18, 0x0f20,
			0x0f27, 0x0f2f, 0x0f49, 0x0f51, 0x0f59, 0x0f60, 0x0f69, 0x0f6e,
			0x0f75, 0x0f79, 0x0f8c, 0x0f8c, 0x0f91, 0x0f91, 0x0f96, 0x0f9e,
			0x0fa4, 0x0fad, 0x0fb2, 0x0fba, 0x0fba, 0x0fc2, 0x0fc2, 0x0fc6,
			// Entry 240 - 27F
			0x0fc6, 0x0fc6, 0x0fcd, 0x0fd4, 0x0fd4, 0x0fdd, 0x0fe6, 0x0ff2,
			0x0ffb, 0x0ffb, 0x100b, 0x100f, 0x1025, 0x102c, 0x1041, 0x1055,
			0x1065, 0x107f, 0x1090, 0x109e, 0x10ad, 0x10bc, 0x10d1, 0x10de,
			0x10ed, 0x10ed, 0x10fc, 0x110e, 0x111b, 0x1122, 0x1133, 0x1143,
			0x114b, 0x1158, 0x1169, 0x117b, 0x1191,
		},
	},
	{ // da
		daLangStr,
		daLangIdx,
	},
	{ // dav
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKitaita",
		[]uint16{ // 265 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0170,
		},
	},
	{ // de
		deLangStr,
		deLangIdx,
	},
	{ // de-AT
		"Hausakaribische SpracheChibcha-SpracheDelawarischFriulanischHawaiianisch" +
			"Miao-SpracheMuskogee-SpracheNiueanischPangasinensischSchlesischmoder" +
			"nes HocharabischSerbokroatisch",
		[]uint16{ // 610 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 40 - 7F
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry 80 - BF
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			// Entry C0 - FF
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0026,
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
			// Entry 100 - 13F
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
			0x0026, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 140 - 17F
			0x003c, 0x003c, 0x003c, 0x0048, 0x0048, 0x0048, 0x0048, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			// Entry 180 - 1BF
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064,
			0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x0064, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e,
			// Entry 1C0 - 1FF
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			// Entry 200 - 23F
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d,
			0x007d, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			// Entry 240 - 27F
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x00aa,
		},
	},
	{ // de-CH
		"WeissrussischAceh-SpracheAcholi-SpracheBasaa-SpracheBikol-SpracheBini-Sp" +
			"racheChibcha-SpracheDinka-SprachePangwe-SpracheGbaya-SpracheKimbundu" +
			"-SpracheMuskogee-SpracheAltpreussisch",
		[]uint16{ // 472 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 40 - 7F
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			// Entry 80 - BF
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x000d,
			0x000d, 0x000d, 0x000d, 0x000d, 0x000d, 0x0019, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			// Entry C0 - FF
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0041, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			// Entry 100 - 13F
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			// Entry 140 - 17F
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0084, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			// Entry 180 - 1BF
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			// Entry 1C0 - 1FF
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00b1,
		},
	},
	{ // de-LU
		"Belarussisch",
		[]uint16{ // 15 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c,
		},
	},
	{ // dje
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senniKoree" +
			" senniMaleezi senniBurme senniNeepal senniHolandee senniPunjaabi sen" +
			"niiPolonee senniPortugee senniRumaani senniRuusi senniRwanda senniSo" +
			"maali senniSuweede senniTamil senniTaailandu senniTurku senniUkreen " +
			"senniUrdu senniVietnaam senniYorbance senniSinuwa senniZulu senniZar" +
			"maciine",
		[]uint16{ // 270 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0111, 0x0111, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0140, 0x0140, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x015d, 0x015d, 0x016a,
			// Entry 80 - BF
			0x016a, 0x0178, 0x0178, 0x0178, 0x0178, 0x0185, 0x0190, 0x019c,
			0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c,
			0x019c, 0x019c, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
			0x01b6, 0x01b6, 0x01c1, 0x01c1, 0x01c1, 0x01d0, 0x01d0, 0x01d0,
			0x01d0, 0x01d0, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db, 0x01e7,
			0x01f1, 0x01f1, 0x01f1, 0x01ff, 0x01ff, 0x01ff, 0x01ff, 0x01ff,
			0x01ff, 0x020d, 0x020d, 0x0219, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			// Entry C0 - FF
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			// Entry 100 - 13F
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x0223,
			0x0223, 0x0223, 0x0223, 0x0223, 0x0223, 0x022d,
		},
	},
	{ // dsb
		"afaršćinaabchazšćinaafrikansakanšćinaamharšćinaaragonšćinaarabšćinaasamš" +
			"ćinaawaršćinaaymaršćinaazerbajdžanšćinabaškiršćinaběłorušćinabulgar" +
			"šćinabislamšćinabambarabengalšćinatibetšćinabretonšćinabosnišćinaka" +
			"tanlanšćinačamoršćinakorsišćinakričešćinawalizišćinadanšćinanimšćina" +
			"divehidzongkhaewegrichišćinaengelšćinaesperantošpańšćinaestišćinabas" +
			"kišćinapersišćinafinšćinafidžišćinaferejšćinafrancojšćinafrizišćinai" +
			"ršćinašotišćinagalicišćinaguaranigudžaratšćinamanšćinahausahebrejšći" +
			"nahindišćinachorwatšćinahaitišćinahungoršćinaarmeńšćinainterlinguain" +
			"donešćinaigbosichuan yiinupiakidoislandšćinaitalšćinainuitšćinajapań" +
			"šćinajavašćinageorgišćinakikuyukazachšćinagrönlandšćinakambodžanšći" +
			"nakannadšćinakorejańšćinakašmiršćinakurdišćinakornišćinakirgišćinała" +
			"tyńšćinaluxemburgšćinagandšćinalimburšćinalingalalaošćinalitawšćinal" +
			"uba-katangaletišćinamalgašćinamaorišćinamakedońšćinamalajamšćinamong" +
			"olšćinamaratišćinamalajšćinamaltašćinaburmašćinanaurušćinapódpołnocn" +
			"e ndebelenepalšćinanižozemšćinanorwegske nynorsknorwegske bokmålnava" +
			"hookcitanšćinaoromoorojišćinapandžabšćinapólšćinapaštunšćinaportugal" +
			"šćinakečuaretoromańšćinakirundišćinarumunšćinarušćinakinjarwandasan" +
			"skritsardinšćinasindšćinalapšćinasangosingalšćinasłowakšćinasłowjeńš" +
			"ćinasamošćinašonšćinasomališćinaalbanšćinaserbišćinasiswatipódpołdn" +
			"jowa sotšćina (Sesotho)sundanšćinašwedšćinaswahilišćinatamilšćinatel" +
			"ugšćinatadžikišćinathailandšćinatigrinjaturkmeńšćinatswanatonganšćin" +
			"aturkojšćinatsongatataršćinatahitišćinaujguršćinaukrainšćinaurdušćin" +
			"ausbekšćinavietnamšćinavolapükwalonšćinawolofxhosajidišćinajorubšćin" +
			"azhuangchinšćinazuluaghemanglosaksojšćinaarawkašćinapareasturšćinabe" +
			"mbabenabodobugišćinachigachoctawšćinacherokeesoranitaitazarmadolnose" +
			"rbšćinadualajola-fonyiembufilipinšćinagagauzšćinagotišćinašwicarska " +
			"nimšćinagusiihawaiišćinagórnoserbšćinangombamachamekabylšćinakambama" +
			"kondekapverdšćinakoyra chiinikalenjinkomi-permyakkonkanišambalabafia" +
			"langilakotšćinaluoluhyamasaišćinamerumauriciska kreolšćinamakhuwa-me" +
			"ettometa’mohawkšćinamundangkriknamadolnonimšćinakwasion’konuernyanko" +
			"leprusčinakʼicheʼromborwasamburusangusicilianišćinasenakoyra sennita" +
			"šelhitpódpołdnjowa samišćinalule-samišćinainari-samišćinaskolt-sami" +
			"šćinasaterfrizišćinatesotasawaqcentralnoatlaski tamazightnjeznata r" +
			"ěcvaivunjosogastandardny marokkański tamazightžedno rěcne wopśimjeś" +
			"emoderna wusokoarabšćinaawstriska nimšćinašwicarska wusokonimšćinaaw" +
			"stralska engelšćinakanadiska engelšćinabritiska engelšćinaameriska e" +
			"ngelšćinałatyńskoamerikańska špańšćinaeuropejska špańšćinamexikańska" +
			" špańšćinakanadiska francojšćinašwicarska francojšćinaflamšćinabrazi" +
			"lska portugalšćinaeuropejska portugalšćinamoldawišćinaserbochorwatšć" +
			"inakongojska swahilišćinachinšćina (zjadnorjona)chinšćina (tradicion" +
			"alna)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000b, 0x0018, 0x0018, 0x0020, 0x002b, 0x0037, 0x0044,
			0x004f, 0x005a, 0x0065, 0x0071, 0x0084, 0x0092, 0x00a1, 0x00ae,
			0x00bb, 0x00c2, 0x00cf, 0x00db, 0x00e8, 0x00f4, 0x0103, 0x0103,
			0x0110, 0x011c, 0x011f, 0x0129, 0x0129, 0x0129, 0x0136, 0x0140,
			0x014a, 0x0150, 0x0158, 0x015b, 0x0168, 0x0174, 0x017d, 0x018a,
			0x0195, 0x01a1, 0x01ad, 0x01ad, 0x01b7, 0x01c4, 0x01d0, 0x01de,
			0x01ea, 0x01f3, 0x01ff, 0x020c, 0x0213, 0x0223, 0x022d, 0x0232,
			0x023f, 0x024b, 0x024b, 0x0259, 0x0265, 0x0272, 0x027f, 0x027f,
			// Entry 40 - 7F
			0x028a, 0x0297, 0x0297, 0x029b, 0x02a5, 0x02ac, 0x02af, 0x02bc,
			0x02c7, 0x02d3, 0x02e0, 0x02eb, 0x02f8, 0x02f8, 0x02fe, 0x02fe,
			0x030b, 0x031b, 0x032c, 0x0339, 0x0348, 0x0348, 0x0356, 0x0362,
			0x0362, 0x036e, 0x037a, 0x0388, 0x0398, 0x03a3, 0x03b0, 0x03b7,
			0x03c1, 0x03cd, 0x03d9, 0x03e4, 0x03f0, 0x03f0, 0x03fc, 0x040b,
			0x0419, 0x0426, 0x0433, 0x043f, 0x044b, 0x0457, 0x0463, 0x0478,
			0x0484, 0x0484, 0x0493, 0x04a4, 0x04b5, 0x04b5, 0x04bb, 0x04bb,
			0x04c9, 0x04c9, 0x04ce, 0x04da, 0x04da, 0x04e9, 0x04e9, 0x04f4,
			// Entry 80 - BF
			0x0502, 0x0511, 0x0517, 0x0528, 0x0536, 0x0542, 0x054b, 0x0556,
			0x055e, 0x056b, 0x0576, 0x0580, 0x0585, 0x0592, 0x05a0, 0x05b0,
			0x05bb, 0x05c6, 0x05d3, 0x05df, 0x05eb, 0x05f2, 0x0615, 0x0622,
			0x062e, 0x063c, 0x0648, 0x0654, 0x0663, 0x0672, 0x067a, 0x0689,
			0x068f, 0x069c, 0x06a9, 0x06af, 0x06bb, 0x06c8, 0x06d4, 0x06e1,
			0x06ec, 0x06f8, 0x06f8, 0x0706, 0x070e, 0x071a, 0x071f, 0x0724,
			0x072f, 0x073b, 0x0741, 0x074c, 0x0750, 0x0750, 0x0750, 0x0750,
			0x0750, 0x0750, 0x0750, 0x0755, 0x0755, 0x0755, 0x0755, 0x0755,
			// Entry C0 - FF
			0x0755, 0x0755, 0x0767, 0x0767, 0x0767, 0x0774, 0x0774, 0x0774,
			0x0774, 0x0774, 0x0774, 0x0774, 0x0774, 0x0778, 0x0778, 0x0784,
			0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784, 0x0784,
			0x0784, 0x0784, 0x0789, 0x0789, 0x078d, 0x078d, 0x078d, 0x078d,
			0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d, 0x078d,
			0x078d, 0x078d, 0x0791, 0x0791, 0x0791, 0x079c, 0x079c, 0x079c,
			0x079c, 0x079c, 0x079c, 0x079c, 0x079c, 0x079c, 0x07a1, 0x07a1,
			0x07a1, 0x07a1, 0x07a1, 0x07a1, 0x07af, 0x07af, 0x07b7, 0x07b7,
			// Entry 100 - 13F
			0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd, 0x07bd,
			0x07c2, 0x07c2, 0x07c2, 0x07c2, 0x07c2, 0x07c7, 0x07c7, 0x07d7,
			0x07d7, 0x07dc, 0x07dc, 0x07e6, 0x07e6, 0x07e6, 0x07ea, 0x07ea,
			0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea, 0x07ea,
			0x07ea, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x07f8,
			0x07f8, 0x07f8, 0x07f8, 0x07f8, 0x0805, 0x0805, 0x0805, 0x0805,
			0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805, 0x0805,
			0x0805, 0x0810, 0x0810, 0x0810, 0x0825, 0x0825, 0x0825, 0x082a,
			// Entry 140 - 17F
			0x082a, 0x082a, 0x082a, 0x0837, 0x0837, 0x0837, 0x0837, 0x0837,
			0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848, 0x0848,
			0x0848, 0x0848, 0x084e, 0x0855, 0x0855, 0x0855, 0x0855, 0x0855,
			0x0861, 0x0861, 0x0861, 0x0866, 0x0866, 0x0866, 0x0866, 0x0866,
			0x086d, 0x087b, 0x087b, 0x087b, 0x087b, 0x087b, 0x087b, 0x0887,
			0x0887, 0x0887, 0x0887, 0x088f, 0x088f, 0x089b, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08aa, 0x08af,
			0x08af, 0x08af, 0x08af, 0x08af, 0x08b4, 0x08b4, 0x08b4, 0x08b4,
			// Entry 180 - 1BF
			0x08b4, 0x08b4, 0x08b4, 0x08c0, 0x08c0, 0x08c0, 0x08c0, 0x08c0,
			0x08c0, 0x08c0, 0x08c0, 0x08c0, 0x08c3, 0x08c3, 0x08c8, 0x08c8,
			0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08d4,
			0x08d4, 0x08d4, 0x08d4, 0x08d4, 0x08d8, 0x08ef, 0x08ef, 0x08fd,
			0x0904, 0x0904, 0x0904, 0x0904, 0x0904, 0x0911, 0x0911, 0x0911,
			0x0918, 0x0918, 0x091c, 0x091c, 0x091c, 0x091c, 0x091c, 0x091c,
			0x091c, 0x091c, 0x091c, 0x0920, 0x092f, 0x092f, 0x092f, 0x092f,
			0x092f, 0x0935, 0x0935, 0x0935, 0x0935, 0x0935, 0x093b, 0x093b,
			// Entry 1C0 - 1FF
			0x093f, 0x093f, 0x093f, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947,
			0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947,
			0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0947, 0x0950,
			0x0950, 0x0959, 0x0959, 0x0959, 0x0959, 0x0959, 0x0959, 0x0959,
			0x095e, 0x095e, 0x095e, 0x095e, 0x095e, 0x095e, 0x0961, 0x0961,
			0x0961, 0x0961, 0x0968, 0x0968, 0x0968, 0x0968, 0x0968, 0x096d,
			0x097d, 0x097d, 0x097d, 0x097d, 0x097d, 0x0981, 0x0981, 0x0981,
			0x098c, 0x098c, 0x098c, 0x0995, 0x0995, 0x0995, 0x0995, 0x0995,
			// Entry 200 - 23F
			0x0995, 0x09af, 0x09bf, 0x09d0, 0x09e1, 0x09e1, 0x09e1, 0x09e1,
			0x09e1, 0x09e1, 0x09f2, 0x09f2, 0x09f2, 0x09f2, 0x09f2, 0x09f2,
			0x09f2, 0x09f2, 0x09f2, 0x09f2, 0x09f6, 0x09f6, 0x09f6, 0x09f6,
			0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6,
			0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6, 0x09f6,
			0x09fd, 0x09fd, 0x0a17, 0x0a17, 0x0a17, 0x0a17, 0x0a24, 0x0a27,
			0x0a27, 0x0a27, 0x0a27, 0x0a27, 0x0a27, 0x0a27, 0x0a2c, 0x0a2c,
			0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a2c, 0x0a30,
			// Entry 240 - 27F
			0x0a30, 0x0a30, 0x0a30, 0x0a30, 0x0a30, 0x0a30, 0x0a30, 0x0a30,
			0x0a30, 0x0a30, 0x0a51, 0x0a51, 0x0a6b, 0x0a6b, 0x0a84, 0x0a84,
			0x0a98, 0x0ab3, 0x0aca, 0x0ae0, 0x0af5, 0x0b0a, 0x0b2e, 0x0b46,
			0x0b5f, 0x0b5f, 0x0b77, 0x0b90, 0x0b90, 0x0b9b, 0x0bb4, 0x0bce,
			0x0bdc, 0x0bef, 0x0c07, 0x0c20, 0x0c3b,
		},
	},
	{ // dua
		"duálá",
		[]uint16{ // 274 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007,
		},
	},
	{ // dyo
		"akanamharikarabbelarusbulgaaribengalisekalmangreekangleespañolpersanfran" +
			"sehausaenduongruaindoneesiigboitaliensaponeesavaneekmeerkoreemaleesi" +
			"birmaninepaleesneerlandepenjabipoloneesportugeesrumeenrusruandasomal" +
			"isueditamiltayturkiukrainurduvietnamyorubasinuasulujoola",
		[]uint16{ // 276 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x0016, 0x001e,
			0x001e, 0x001e, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x002d, 0x002d, 0x002d, 0x002d, 0x0032, 0x0037, 0x0037, 0x003f,
			0x003f, 0x003f, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x004b,
			0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x0050,
			0x0050, 0x0054, 0x0054, 0x0054, 0x0054, 0x005a, 0x005a, 0x005a,
			// Entry 40 - 7F
			0x005a, 0x0063, 0x0063, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
			0x006e, 0x006e, 0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c,
			0x007c, 0x007c, 0x0081, 0x0081, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0086, 0x0086, 0x0086, 0x008d, 0x008d, 0x0094, 0x0094, 0x0094,
			0x009c, 0x009c, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00ac, 0x00ac, 0x00b4,
			// Entry 80 - BF
			0x00b4, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00c3, 0x00c6, 0x00cc,
			0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d7, 0x00d7, 0x00dc, 0x00dc, 0x00dc, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00ea,
			0x00ee, 0x00ee, 0x00ee, 0x00f5, 0x00f5, 0x00f5, 0x00f5, 0x00f5,
			0x00f5, 0x00fb, 0x00fb, 0x0100, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			// Entry C0 - FF
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			// Entry 100 - 13F
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0109,
		},
	},
	{ // dz
		"ཨ་ཕར་ཁཨཱབ་ཁ་ཟི་ཡ་ཁཨཕ་རི་ཀཱནས་ཁཨམ་ཧ་རིཀ་ཁཨེ་ར་བིཀ་ཁཨ་ས་མིས་ཁཨ་ཛར་བྷའི་ཇཱན" +
			"་ཁབེལ་ཨ་རུས་ཁབཱལ་གེ་རི་ཡཱན་ཁབངྒ་ལ་ཁབོད་ཁབྷོས་ནི་ཡཱན་ཁཀེ་ཊ་ལཱན་ཁཅེཀ" +
			"་ཁཝེལཤ་ཁཌེ་ནིཤ་ཁཇཱར་མཱན་ཁདི་བེ་ཧི་ཁརྫོང་ཁགྲིཀ་ཁཨིང་ལིཤ་ཁཨེས་པ་རཱན་" +
			"ཏོ་ཁཨིས་པེ་ནིཤ་ཁཨེས་ཊོ་ནི་ཡཱན་ཁབཱསཀ་ཁཔར་ཤི་ཡཱན་ཁཕི་ནིཤ་ཁཕི་ཇི་ཡཱན་" +
			"ཁཕཱ་རོ་ཨིས་ཁཕྲནཅ་ཁནུབ་ཕྼི་སི་ཡན་ཁཨཱའི་རིཤ་ཁགལ་ཨིས་ཨི་ཡན་ཁགུ་ཝ་ར་ནི" +
			"་ཁགུ་ཇ་ར་ཏི་ཁཧཝ་ས་ཁཧེ་བྲུ་ཁཧིན་དི་ཁཀྲོ་ཨེ་ཤི་ཡཱན་ཁཧེ་ཏི་ཡཱན་ཁཧཱང་ག" +
			"ྷ་རི་ཡཱན་ཁཨར་མི་ནི་ཡཱན་ཁཨིན་ཌོ་ནེ་ཤི་ཡཱན་ཁཨིག་བོ་ཁཨ་ཡིས་ལེན་ཌིཀ་ཁཨ" +
			"ི་ཊ་ལི་ཡཱན་ཁཇཱ་པཱ་ནིས་ཁཇཱ་བ་ནིས་ཁཇཽ་ཇི་ཡཱན་ཁཀ་ཛགས་ཁཁེ་མེར་ཁཀ་ན་ཌ་ཁ" +
			"ཀོ་རི་ཡཱན་ཁཀཱཤ་མི་རི་ཁཀར་ཌིཤ་ཁཀིར་གིས་ཁལེ་ཊིན་ཁལག་ཛམ་བོརྒ་ཁལཱ་ཝོས་" +
			"ཁལི་ཐུ་ཝེ་ནི་ཡཱན་ཁལཊ་བི་ཡཱན་ཁམ་ལ་ག་སི་ཁམ་ཨོ་རི་ཁམ་སེ་ཌོ་ནི་ཡཱན་ཁམ་" +
			"ལ་ཡ་ལམ་ཁམ་ར་ཐི་ཁམ་ལེ་ཁམཱལ་ཊ་ཁབར་མིས་ཁནེ་པཱལི་ཁཌཆ་ཁནོར་ཝེ་ཇི་ཡཱན་ནོ" +
			"རསཀ་ཁནོར་ཝེ་ཇི་ཡཱན་བོཀ་མཱལ་ཁཨོ་རི་ཡ་ཁཔཱན་ཇ་བི་ཁཔོ་ལིཤ་ཁཔཱཤ་ཏོ་ཁཔོར" +
			"་ཅུ་གིས་ཁཀྭེ་ཆུ་ཨ་ཁརོ་མེ་ནིཤ་ཁརོ་མེ་ནི་ཡཱན་ཁཨུ་རུ་སུའི་ཁསཾསྐྲྀཏ་ཁས" +
			"ིན་དཱི་ཁསིང་ཧ་ལ་ཁསུ་ལོ་བཱཀ་ཁསུ་ལོ་བི་ནི་ཡཱན་ཁསོ་མ་ལི་ཁཨཱལ་བེ་ནི་ཡཱ" +
			"ན་ཁསཱར་བྷི་ཡཱན་ཁསཱུན་ད་ནིས་ཁསུའི་ཌིཤ་ཁསྭཱ་ཧི་ལི་ཁཏ་མིལ་ཁཏེ་ལུ་གུ་ཁ" +
			"ཏ་ཇིཀ་ཁཐཱའི་ཁཏིག་རི་ཉ་ཁཊཱརཀ་མེན་ཁཊོང་གྷན་ཁཊཱར་ཀིཤ་ཁཊ་ཊར་ཁཝི་གུར་ཁཡ" +
			"ུ་ཀེ་རེ་ནི་ཡཱན་ཁཨུར་དུ་ཁཨུས་བེཀ་ཁབེཊ་ནཱ་མིས་ཁཝོ་ལོཕ་ཁཞོ་ས་ཁཡོ་རུ་བ" +
			"་ཁརྒྱ་མི་ཁཟུ་ལུ་ཁད་ཀོ་ཏ་ཁཕི་ལི་པི་ནོ་ཁསུ་ཡིས་ཇཱར་མཱན་ཁཧ་ཝ་ཡིའི་ཁཀ་" +
			"ཆིན་ཁཀོ་རོ་ཁམན་ཇུ་ཁཤཱན་ཁཁ་ངོ་མ་ཤེསཔསྐད་རིག་ནང་དོན་མེདཔཨཱོས་ཊྲི་ཡཱན" +
			"་ཇཱར་མཱན་ཁསུ་ཡིས་གི་མཐོ་སའི་ཇཱར་མཱན་ཁཨཱོས་ཊྲེ་ལི་ཡཱན་ཨིང་ལིཤ་ཁཀེ་ན" +
			"་ཌི་ཡཱན་ཨིང་ལིཤ་ཁབྲི་ཊིཤ་ཨིང་ལིཤ་ཁཡུ་ཨེས་ཨིང་ལིཤ་ཁལེ་ཊིན་ཨ་མེ་རི་ཀ" +
			"ཱན་གི་ཨིས་པེ་ནིཤ་ཁཡུ་རོབ་ཀྱི་ཨིས་པེ་ནིཤ་ཁཀེ་ན་ཌི་ཡཱན་ཕྲནཅ་ཁསུ་ཡིས་" +
			"ཕྲནཅ་ཁཕྷེལེ་མིཤ་ཁབྲ་ཛི་ལི་ཡཱན་པོར་ཅུ་གིས་ཁཨི་བེ་རི་ཡཱན་པོར་ཅུ་གིས་" +
			"ཁརྒྱ་མི་ཁ་འཇམ་སངམསྔ་དུས་ཀྱི་རྒྱ་མི་ཁ",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0012, 0x0036, 0x0036, 0x005a, 0x005a, 0x0078, 0x0078,
			0x0096, 0x00b1, 0x00b1, 0x00b1, 0x00de, 0x00de, 0x00ff, 0x012c,
			0x012c, 0x012c, 0x0141, 0x0150, 0x0150, 0x0177, 0x0195, 0x0195,
			0x0195, 0x0195, 0x0195, 0x01a4, 0x01a4, 0x01a4, 0x01b6, 0x01ce,
			0x01e9, 0x0207, 0x0219, 0x0219, 0x022b, 0x0246, 0x0270, 0x0294,
			0x02c1, 0x02d3, 0x02f4, 0x02f4, 0x030c, 0x032d, 0x034e, 0x0360,
			0x038d, 0x03ab, 0x03ab, 0x03d5, 0x03f6, 0x0417, 0x0417, 0x0429,
			0x0441, 0x0459, 0x0459, 0x0486, 0x04a7, 0x04d4, 0x04fe, 0x04fe,
			// Entry 40 - 7F
			0x04fe, 0x0534, 0x0534, 0x054c, 0x054c, 0x054c, 0x054c, 0x0579,
			0x05a0, 0x05a0, 0x05c1, 0x05df, 0x0600, 0x0600, 0x0600, 0x0600,
			0x0615, 0x0615, 0x062d, 0x0642, 0x0663, 0x0663, 0x0684, 0x069c,
			0x069c, 0x069c, 0x06b7, 0x06cf, 0x06f3, 0x06f3, 0x06f3, 0x06f3,
			0x070b, 0x073e, 0x073e, 0x075f, 0x077d, 0x077d, 0x0798, 0x07c8,
			0x07e6, 0x07e6, 0x07fe, 0x0810, 0x0825, 0x083d, 0x083d, 0x083d,
			0x0858, 0x0858, 0x0864, 0x08a3, 0x08e8, 0x08e8, 0x08e8, 0x08e8,
			0x08e8, 0x08e8, 0x08e8, 0x0903, 0x0903, 0x0921, 0x0921, 0x0939,
			// Entry 80 - BF
			0x0951, 0x0975, 0x0993, 0x09b4, 0x09b4, 0x09de, 0x0a02, 0x0a02,
			0x0a1d, 0x0a1d, 0x0a38, 0x0a38, 0x0a38, 0x0a53, 0x0a74, 0x0aa7,
			0x0aa7, 0x0aa7, 0x0ac2, 0x0aef, 0x0b16, 0x0b16, 0x0b16, 0x0b3a,
			0x0b58, 0x0b79, 0x0b8e, 0x0bac, 0x0bc1, 0x0bd3, 0x0bf1, 0x0c0f,
			0x0c0f, 0x0c2a, 0x0c45, 0x0c45, 0x0c57, 0x0c57, 0x0c6f, 0x0ca2,
			0x0cba, 0x0cd5, 0x0cd5, 0x0cf9, 0x0cf9, 0x0cf9, 0x0d11, 0x0d23,
			0x0d23, 0x0d3e, 0x0d3e, 0x0d56, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			// Entry C0 - FF
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b,
			// Entry 100 - 13F
			0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d6b, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83, 0x0d83,
			0x0d83, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0daa,
			0x0daa, 0x0daa, 0x0daa, 0x0daa, 0x0dda, 0x0dda, 0x0dda, 0x0dda,
			// Entry 140 - 17F
			0x0dda, 0x0dda, 0x0dda, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8,
			0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8,
			0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8, 0x0df8,
			0x0df8, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d, 0x0e0d,
			0x0e0d, 0x0e0d, 0x0e0d, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			// Entry 180 - 1BF
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22, 0x0e22,
			0x0e22, 0x0e22, 0x0e22, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			// Entry 1C0 - 1FF
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e37,
			0x0e37, 0x0e37, 0x0e37, 0x0e37, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			// Entry 200 - 23F
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46,
			0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e46, 0x0e67, 0x0e67,
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			// Entry 240 - 27F
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0e67,
			0x0e67, 0x0e67, 0x0e67, 0x0e67, 0x0ea0, 0x0ea0, 0x0ea0, 0x0ea0,
			0x0ee2, 0x0f33, 0x0f7e, 0x0fbd, 0x0ff0, 0x1020, 0x1086, 0x10cb,
			0x10cb, 0x10cb, 0x1101, 0x1128, 0x1128, 0x1149, 0x1194, 0x11df,
			0x11df, 0x11df, 0x11df, 0x120f, 0x1248,
		},
	},
	{ // ebu
		"KĩakanKĩamhariKĩarabuKĩmbelarusiKĩbulgariaKĩbanglaKĩchekiKĩnjeremaniKĩng" +
			"rikiKĩthunguKĩhispaniaKĩanjemiKĩfaransaKĩhausaKĩhindĩKĩhungariKĩindo" +
			"nesiaKĩigboKĩitalianoKĩnjapaniKĩjavaKĩkambodiaKĩkoreaKĩmalesiaKĩburm" +
			"aKĩnepaliKĩholanziKĩpunjabiKĩpolandiKĩrenoKĩromaniaKĩrusiKĩnyarwanda" +
			"KĩsomaliKĩswidiKĩtamilKĩtailandiKĩturukiKĩukraniaKĩurduKĩvietinamuKĩ" +
			"yorubaKĩchinaKĩzuluKĩembu",
		[]uint16{ // 279 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0024, 0x002f,
			0x002f, 0x002f, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x004c, 0x004c, 0x004c, 0x004c, 0x0055, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x007c,
			0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x0084,
			0x0084, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00bf, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00d1, 0x00d1, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00eb, 0x00eb, 0x00eb,
			0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x0108, 0x0108, 0x0112,
			// Entry 80 - BF
			0x0112, 0x0119, 0x0119, 0x0119, 0x0119, 0x0123, 0x012a, 0x0136,
			0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0163, 0x0163, 0x0163, 0x0163, 0x0163, 0x016d,
			0x0174, 0x0174, 0x0174, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0189, 0x0189, 0x0191, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			// Entry C0 - FF
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			// Entry 100 - 13F
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198, 0x019f,
		},
	},
	{ // ee
		"abkhaziagbeafrikaangbeblugbeamhariagbeArabiagbeassamegbeaymargbeazerbaij" +
			"angbebelarusiagbebulgariagbebambaragbeBengaligbetibetagbebretongbebo" +
			"sniagbekatalagbetsɛkgbewalesgbedenmarkgbeGermaniagbedivehgbedzongkha" +
			"gbeEʋegbegrisigbeYevugbeesperantogbeSpanishgbeestoniagbebasqugbepers" +
			"iagbefinlanɖgbefidzigbeFransegbeirelanɖgbegalatagbeguarangbegujarati" +
			"hausagbehebrigbeHindigbekroatiagbehaitigbehungarigbearmeniagbeIndone" +
			"siagbeigbogbeicelanɖgbeItaliagbeJapangbedzavangbegɔgiagbekazakhstang" +
			"bekhmergbekannadagbeKoreagbekashmirgbekurdiagbekirghistangbelatinlak" +
			"sembɔggbelingalalaogbelithuaniagbelatviagbemalagasegbemaorgbemakedon" +
			"iagbemalayagbemongoliagbemarathiagbemalaygbemaltagbeburmagbedziehe n" +
			"debelegbenepalgbeHollandgbenɔweigbe ninɔsknɔweigbe bokmålnyanjagbeor" +
			"iyagbeossetiagbepundzabgbePolishgbepashtogbePortuguesegbekwetsuagber" +
			"omanshgberundigberomaniagbeRussiagberuwandagbesanskrigbesindhgbedzie" +
			"he samigbesangogbesinhalgbeslovakiagbesloveniagbesamoagbeshonagbesom" +
			"aliagbealbaniagbeserbiagbeswatgbeanyiehe sothogbeswedengbeswahilitam" +
			"ilgbetelegugbetadzikistangbeThailandgbetigrinyagbetɛkmengbetswanagbe" +
			"tongagbeTurkishgbetsongagbetahitigbeuighurgbeukraingbeurdugbeuzbekis" +
			"tangbevendagbevietnamgbewolofgbexhosagbeyorubagbeChinagbezulugbeaghe" +
			"mgbeasagbebembagbebenagbebodogbeembugbeefigbefilipingbeswizerlanɖtɔw" +
			"o ƒe germaniagbehawaigbecape verdegbelahndagbeluyiagbegbegbɔgblɔ sɔg" +
			"bɔwodziehe sothogberombogberwagbesakagbekomorogbetetumgbetok pisigbe" +
			"gbegbɔgblɔ manyawalsegbecantongbegbegbɔgblɔ manɔmeeGermaniagbe (Aust" +
			"ria)Germaniagbe (Switzerland)Yevugbe (Australia)Yevugbe (Canada)Yevu" +
			"gbe (Britain)Yevugbe (America)Spanishgbe (Latin America)Spanishgbe (" +
			"Europe)Spanishgbe (Mexico)Fransegbe (Canada)Fransegbe (Switzerland)F" +
			"lemishgbePortuguesegbe (Brazil)Portuguesegbe (Europe)serbo-croatiagb" +
			"etsainagbeblema tsainagbe",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000b, 0x000b, 0x0016, 0x001c, 0x0026, 0x0026,
			0x002f, 0x0038, 0x0038, 0x0040, 0x004d, 0x004d, 0x0059, 0x0064,
			0x0064, 0x006e, 0x0078, 0x0081, 0x008a, 0x0093, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x00a4, 0x00a4, 0x00a4, 0x00ac, 0x00b6,
			0x00c1, 0x00c9, 0x00d4, 0x00db, 0x00e3, 0x00ea, 0x00f6, 0x0100,
			0x010a, 0x0112, 0x011b, 0x011b, 0x0126, 0x012e, 0x012e, 0x0137,
			0x0137, 0x0142, 0x0142, 0x014b, 0x0154, 0x015c, 0x015c, 0x0164,
			0x016c, 0x0174, 0x0174, 0x017e, 0x0186, 0x0190, 0x019a, 0x019a,
			// Entry 40 - 7F
			0x019a, 0x01a6, 0x01a6, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01b8,
			0x01c1, 0x01c1, 0x01c9, 0x01d2, 0x01db, 0x01db, 0x01db, 0x01db,
			0x01e8, 0x01e8, 0x01f0, 0x01fa, 0x0202, 0x0202, 0x020c, 0x0215,
			0x0215, 0x0215, 0x0222, 0x0227, 0x0234, 0x0234, 0x0234, 0x023b,
			0x0241, 0x024d, 0x024d, 0x0256, 0x0261, 0x0261, 0x0268, 0x0274,
			0x027d, 0x0288, 0x0293, 0x029b, 0x02a3, 0x02ab, 0x02ab, 0x02bc,
			0x02c4, 0x02c4, 0x02ce, 0x02df, 0x02f0, 0x02f0, 0x02f0, 0x02f9,
			0x02f9, 0x02f9, 0x02f9, 0x0301, 0x030b, 0x0315, 0x0315, 0x031e,
			// Entry 80 - BF
			0x0327, 0x0334, 0x033e, 0x0348, 0x0350, 0x035a, 0x0363, 0x036d,
			0x0377, 0x0377, 0x037f, 0x038d, 0x0395, 0x039e, 0x03a9, 0x03b4,
			0x03bc, 0x03c4, 0x03ce, 0x03d8, 0x03e1, 0x03e8, 0x03f8, 0x03f8,
			0x0401, 0x0408, 0x0410, 0x0419, 0x0427, 0x0432, 0x043d, 0x0447,
			0x0450, 0x0458, 0x0462, 0x046b, 0x046b, 0x0474, 0x047d, 0x0486,
			0x048d, 0x049a, 0x04a2, 0x04ac, 0x04ac, 0x04ac, 0x04b4, 0x04bc,
			0x04bc, 0x04c5, 0x04c5, 0x04cd, 0x04d4, 0x04d4, 0x04d4, 0x04d4,
			0x04d4, 0x04d4, 0x04d4, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc,
			// Entry C0 - FF
			0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc,
			0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2, 0x04e2,
			0x04e2, 0x04e2, 0x04ea, 0x04ea, 0x04f1, 0x04f1, 0x04f1, 0x04f1,
			0x04f1, 0x04f1, 0x04f1, 0x04f1, 0x04f1, 0x04f1, 0x04f1, 0x04f1,
			0x04f1, 0x04f1, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8,
			0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8,
			0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8,
			// Entry 100 - 13F
			0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8,
			0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8,
			0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04f8, 0x04ff, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f,
			0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f,
			0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f, 0x050f,
			0x050f, 0x050f, 0x050f, 0x050f, 0x052f, 0x052f, 0x052f, 0x052f,
			// Entry 140 - 17F
			0x052f, 0x052f, 0x052f, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537,
			0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537,
			0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537,
			0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537, 0x0537,
			0x0537, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544,
			0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544,
			0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x0544,
			0x0544, 0x0544, 0x0544, 0x0544, 0x0544, 0x054d, 0x054d, 0x054d,
			// Entry 180 - 1BF
			0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d,
			0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x054d, 0x0555, 0x0555,
			0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555,
			0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555,
			0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555, 0x0555,
			0x0555, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b,
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b,
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x057a,
			// Entry 1C0 - 1FF
			0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a,
			0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a,
			0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a,
			0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a, 0x057a,
			0x0582, 0x0582, 0x0582, 0x0582, 0x0582, 0x0582, 0x0588, 0x0588,
			0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f,
			0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f,
			0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f,
			// Entry 200 - 23F
			0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f,
			0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x058f, 0x0598, 0x0598,
			0x0598, 0x0598, 0x0598, 0x0598, 0x0598, 0x0598, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab,
			0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05ab, 0x05bd, 0x05bd,
			0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05bd, 0x05c5,
			0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05c5,
			// Entry 240 - 27F
			0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05c5, 0x05ce, 0x05ce, 0x05ce,
			0x05ce, 0x05ce, 0x05ce, 0x05ce, 0x05e3, 0x05e3, 0x05e3, 0x05e3,
			0x05f8, 0x0611, 0x0624, 0x0634, 0x0645, 0x0656, 0x0670, 0x0683,
			0x0696, 0x0696, 0x06a8, 0x06bf, 0x06bf, 0x06c9, 0x06df, 0x06f5,
			0x06f5, 0x0705, 0x0705, 0x070e, 0x071d,
		},
	},
	{ // el
		elLangStr,
		elLangIdx,
	},
	{ // en
		enLangStr,
		enLangIdx,
	},
	{ // en-AU
		"United States EnglishMoldovan",
		[]uint16{ // 609 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 180 - 1BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 1C0 - 1FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 200 - 23F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 240 - 27F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0015, 0x0015, 0x0015,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015,
			0x001d,
		},
	},
	{ // en-IN
		"BengaliOriya",
		[]uint16{ // 124 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x000c,
		},
	},
	{ // en-NZ
		"Māori",
		[]uint16{ // 103 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
		},
	},
	{ // eo
		"afaraabĥazaafrikansatwamharaarabaasamaajmaraazerbajĝanabaŝkirabelorusabu" +
			"lgarabislamobengalatibetabretonabosniakatalunakorsikaĉeĥakimradanage" +
			"rmanamahladzonkogrekaanglaesperantohispanaestonaeŭskapersafinnafiĝia" +
			"feroafrancafrisairlandagaelagalegagvaraniaguĝaratahaŭsahebreahindakr" +
			"oatahaitia kreolahungaraarmenainterlingvaoindoneziaokcidentaloeskima" +
			"islandaitalainuitajapanajavakartvelakazaĥagronlandakmerakanarakoreak" +
			"aŝmirakurdakirgizalatinoluksemburgalingalalaŭalitovalatvamalagasamao" +
			"riamakedonamalajalamamongolamaratamalajamaltabirmanauranepalanederla" +
			"ndanovnorvegadannorvegaokcitanaoromaorijopanĝabapolapaŝtoaportugalak" +
			"eĉuaromanĉaburundarumanarusaruandasanskritosindasangoasinhalaslovaka" +
			"slovenasamoaŝonasomalaalbanaserbasvaziasotasundasvedasvahilatamilate" +
			"luguataĝikatajatigrajaturkmenacvanatongaaturkacongatataraujguraukrai" +
			"naurduouzbekavjetnamavolapukovolofaksosajidajorubaĝuangaĉinazuluaibi" +
			"bioefikafilipinahavajaklingonanekonata lingvonelingvaĵobrazilportuga" +
			"laeŭropportugalaserbo-Kroataĉina simpligitaĉina tradicia",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0005, 0x000c, 0x000c, 0x0015, 0x0017, 0x001d, 0x001d,
			0x0022, 0x0027, 0x0027, 0x002d, 0x0039, 0x0041, 0x0049, 0x0050,
			0x0057, 0x0057, 0x005e, 0x0064, 0x006b, 0x0071, 0x0079, 0x0079,
			0x0079, 0x0080, 0x0080, 0x0086, 0x0086, 0x0086, 0x008b, 0x008f,
			0x0096, 0x009b, 0x00a1, 0x00a1, 0x00a6, 0x00ab, 0x00b4, 0x00bb,
			0x00c1, 0x00c7, 0x00cc, 0x00cc, 0x00d1, 0x00d7, 0x00dc, 0x00e2,
			0x00e7, 0x00ee, 0x00f3, 0x00f9, 0x0101, 0x010a, 0x010a, 0x0110,
			0x0116, 0x011b, 0x011b, 0x0121, 0x012e, 0x0135, 0x013b, 0x013b,
			// Entry 40 - 7F
			0x0147, 0x0150, 0x015b, 0x015b, 0x015b, 0x0161, 0x0161, 0x0168,
			0x016d, 0x0173, 0x0179, 0x017d, 0x0185, 0x0185, 0x0185, 0x0185,
			0x018c, 0x0195, 0x019a, 0x01a0, 0x01a5, 0x01a5, 0x01ad, 0x01b2,
			0x01b2, 0x01b2, 0x01b9, 0x01bf, 0x01ca, 0x01ca, 0x01ca, 0x01d1,
			0x01d6, 0x01dc, 0x01dc, 0x01e1, 0x01e9, 0x01e9, 0x01ef, 0x01f7,
			0x0201, 0x0208, 0x020e, 0x0214, 0x0219, 0x021e, 0x0223, 0x0223,
			0x0229, 0x0229, 0x0233, 0x023d, 0x0247, 0x0247, 0x0247, 0x0247,
			0x024f, 0x024f, 0x0254, 0x0259, 0x0259, 0x0261, 0x0261, 0x0265,
			// Entry 80 - BF
			0x026c, 0x0275, 0x027b, 0x0283, 0x028a, 0x0290, 0x0294, 0x029a,
			0x02a3, 0x02a3, 0x02a8, 0x02a8, 0x02ae, 0x02b5, 0x02bc, 0x02c3,
			0x02c8, 0x02cd, 0x02d3, 0x02d9, 0x02de, 0x02e4, 0x02e8, 0x02ed,
			0x02f2, 0x02f9, 0x02ff, 0x0306, 0x030d, 0x0311, 0x0318, 0x0320,
			0x0325, 0x032b, 0x0330, 0x0335, 0x033b, 0x033b, 0x0341, 0x0348,
			0x034d, 0x0353, 0x0353, 0x035b, 0x0363, 0x0363, 0x0369, 0x036e,
			0x0372, 0x0378, 0x037f, 0x0384, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry C0 - FF
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry 100 - 13F
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0394,
			0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x0394, 0x0394,
			0x0394, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			// Entry 140 - 17F
			0x039c, 0x039c, 0x039c, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 180 - 1BF
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 1C0 - 1FF
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			// Entry 200 - 23F
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2, 0x03a2,
			0x03a2, 0x03a2, 0x03a2, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa,
			0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa,
			0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03b9, 0x03b9,
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			// Entry 240 - 27F
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03b9,
			0x03b9, 0x03b9, 0x03b9, 0x03b9, 0x03c4, 0x03c4, 0x03c4, 0x03c4,
			0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4,
			0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03c4, 0x03d3, 0x03e2,
			0x03e2, 0x03ee, 0x03ee, 0x03fe, 0x040c,
		},
	},
	{ // es
		esLangStr,
		esLangIdx,
	},
	{ // es-419
		es419LangStr,
		es419LangIdx,
	},
	{ // es-AR
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-BO
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-CL
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-CO
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-CR
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-DO
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-EC
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-GT
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-HN
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-MX
		"bashkireuskeralaopunyabíkiroundisiswatisuajiliwolofacehnésarapahobasabam" +
			"unbhojpurineerlandés medievalinglés medievalfrancés medievalgan (Chi" +
			"na)alemán de la alta edad mediagriego antiguokejia (China)xiang (Chi" +
			"na)irlandés medievalmin nan (Chino)sotho septentrionalárabe chadiano" +
			"tamazight marroquí estándarsuajili del Congo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 40 - 7F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0019, 0x0019, 0x0019,
			// Entry 80 - BF
			0x0019, 0x0019, 0x0019, 0x0019, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0028, 0x0028, 0x0028,
			0x0028, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry C0 - FF
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x0043,
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0047, 0x004c, 0x004c,
			0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			// Entry 100 - 13F
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054, 0x0054,
			0x0054, 0x0054, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
			0x0068, 0x0068, 0x0068, 0x0068, 0x0078, 0x0078, 0x0078, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00b1, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			// Entry 140 - 17F
			0x00bf, 0x00bf, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			// Entry 180 - 1BF
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00eb, 0x00eb,
			0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
			0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
			0x00eb, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa,
			0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x00fa, 0x010d,
			// Entry 1C0 - 1FF
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x010d, 0x011c, 0x011c, 0x011c,
			// Entry 200 - 23F
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			// Entry 240 - 27F
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139,
			0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139,
			0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139,
			0x0139, 0x0139, 0x014a,
		},
	},
	{ // es-NI
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-PA
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-PE
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-PR
		"siswatiwolofacehnésarapahobhojpurigriego antiguosotho septentrional",
		[]uint16{ // 448 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			// Entry C0 - FF
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			// Entry 100 - 13F
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			// Entry 140 - 17F
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			// Entry 180 - 1BF
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0044,
		},
	},
	{ // es-PY
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // es-SV
		"siswatiwolofacehnésarapahobhojpurigriego antiguosotho septentrional",
		[]uint16{ // 448 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			// Entry C0 - FF
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			// Entry 100 - 13F
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			// Entry 140 - 17F
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			// Entry 180 - 1BF
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0044,
		},
	},
	{ // es-US
		"kiroundisiswatisetchwanawolofacehnésarapahobasabamunbhojpuriburiatneerla" +
			"ndés medievalinglés medievalfrancés medievalalemán de la alta edad m" +
			"ediagriego antiguohakalto sorbiocriollo caboverdianolushaiirlandés m" +
			"edievalnansotho septentrionalpcmárabe chadianowuuswahili del Congo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x000f, 0x000f, 0x000f,
			0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f, 0x000f,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x001d, 0x001d,
			0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
			// Entry C0 - FF
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x0030, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x003d, 0x0043, 0x0043, 0x0043, 0x0043,
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			// Entry 100 - 13F
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x0043, 0x0043, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0067, 0x0067, 0x0067, 0x0067,
			0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0078, 0x0078, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0095, 0x0095, 0x0095, 0x0095,
			0x0095, 0x0095, 0x0095, 0x00a3, 0x00a3, 0x00a3, 0x00a3, 0x00a3,
			// Entry 140 - 17F
			0x00a3, 0x00a3, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			// Entry 180 - 1BF
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00f3,
			// Entry 1C0 - 1FF
			0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3,
			0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6,
			0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x0105, 0x0105, 0x0105,
			// Entry 200 - 23F
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0108, 0x0108, 0x0108, 0x0108,
			// Entry 240 - 27F
			0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
			0x0108, 0x0108, 0x0119,
		},
	},
	{ // es-VE
		"euskeralaopunyabísiswatisuajilisetswanawolofacehnésarapahobhojpurigriego" +
			" antiguosotho septentrionaltamazight marroquí estándarsuajili del Co" +
			"ngo",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			// Entry 40 - 7F
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x000a,
			0x000a, 0x000a, 0x000a, 0x000a, 0x000a, 0x0012, 0x0012, 0x0012,
			// Entry 80 - BF
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			// Entry 100 - 13F
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 140 - 17F
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 180 - 1BF
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 200 - 23F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			// Entry 240 - 27F
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0093,
		},
	},
	{ // et
		etLangStr,
		etLangIdx,
	},
	{ // eu
		"afareraabkhazeraafrikaansaakaneraamhareraaragoieraarabieraassameraavarer" +
			"aaimaraazerbaijanerabashkirrerabielorrusierabulgarierabislamabambare" +
			"rabengaleratibeterabretoierabosnierakatalanatxetxenierachamorrerakor" +
			"sikeratxekieraElizako eslavierachuvasheragaleseradanieraalemanadiveh" +
			"ieradzongkhaeweeragrezieraingelesaesperantoaespainieraestonieraeuska" +
			"rapersierafulafinlandierafijierafaroerafrantsesafrisieragaelikoaesko" +
			"ziako gaelikoagalizieraguaranieragujarateramanxerahausahebreerahindi" +
			"akroazieraHaitiko kreolerahungarieraarmenierahererainterlinguaindone" +
			"sierainterlingueigboerasichuan yiaidoislandieraitalierainuiterajapon" +
			"ierajaverageorgierakikongoakikuyuerakuanyamakazakherakalaallisuterak" +
			"hemererakannaderakoreerakanurierakashmirerakurduerakomierakornubiera" +
			"kirgizeralatinaluxenburgeraganderalimburgeralingalalaoseralituaniera" +
			"luba-katangeraletonieramalagasyeramarshalleramaorieramazedonieramala" +
			"yalameramongolieramaratheramalaysieramalteraburmatarranaurueraiparra" +
			"ldeko ndebeleeranepalerandongeranederlanderanynorsk norvegierabokmal" +
			"a (Norvegia)hegoaldeko ndebeleranavahoeranyanjaokzitanieraoromoeraor" +
			"iyaosetierapunjaberapolonierapaxtueraportugesaquechueraerromantxerar" +
			"undieraerrumanieraerrusierakinyaruandasanskritoasardinierasindhiaipa" +
			"rraldeko samierasangoerasinhalaeslovakieraeslovenierasamoerashoneras" +
			"omalieraalbanieraserbieraswatierahegoaldeko sothoerasundanerasuedier" +
			"aswahilitamileratelugueratajikistanerathailandieratigriñeraturkmenie" +
			"ratswaneratongeraturkieratsongeratatareratahitierauigurreraukrainera" +
			"urduauzbekeravenderavietnameravolapükavalonierawoloferaxhoserayiddis" +
			"hayoruberatxinerazulueraacehneraacholieraadangmeraadygheraaghemeraai" +
			"nueraaleuterahegoaldeko altaieraangikeramaputxeaarapahoaasuaasturier" +
			"aawadhierabalierabasaabemberabenerabhojpureraedoerasiksikerabodoerab" +
			"uginerabilenacebuerachigerachuukeramarierachoctawtxerokieracheyenner" +
			"asoraniaseselwa frantses-kreoleradakoteradargverataiteradogriberazar" +
			"merabehe-sorabieradualerafonyi joleradazagaembuaefikeraakajukaewonde" +
			"ratagalogafonafriulieragagagauzerage’ezgilberteragorontaloaalemana (" +
			"Suitza)gusiieragwichʼinhawaiierahiligainonahmonggoi-sorabierahuperai" +
			"baneraibibioerailokaneraingusheralojbanerangombamachamerakabilerajin" +
			"gpoerakaijikamberakabardierakatabamakonderaCabo Verdeko kreolakoroak" +
			"ashiakoyra chiinierakakoakalenjinerakimbunduakomi-permyakerakonkanie" +
			"rakpelleakarachayera-balkarerakarelierakurukherashambalerabafierakol" +
			"onierakumykeraladineralangieralezgieralakoteralozieraiparraldeko lur" +
			"eratxiluberalunderaluoeramizoaluhyeramadureramagahieramaithileramaka" +
			"sareramasaieramokxeramendeeramerueraMauritaniako kreoleramakhuwa-mee" +
			"ttoerameteramikmakeraminangkabaueramanipureramohawkeramoreeramudange" +
			"rahizkuntza anitzakcreeramiranderaerzieramazandaranderanapolieraname" +
			"ranewareraniasaniuerakwasierangiembooneranogaieran’koerapedieranuere" +
			"raankolerapangasinanerapampangerapapiamentoapalaueraNigeriako pidgin" +
			"aprusierak’iche’rarapa nuirarotongeraromboeraaromaniarwaerasandaweas" +
			"akherasamburuerasantalerangambayerasanguerasizilieraeskozierasenerak" +
			"oyraboro senniatachelhitashanerahegoaldeko samieralule samierainari-" +
			"samieraskolt samierasoninkerasrananerasahoasukumerakomoreeraasiriera" +
			"temneatesoeratetumatigreaklingoneratok pisinatarokoatumbukeratuvalue" +
			"ratasawaqatuveraMaroko erdialdeko tamazightaudmurteraumbundueraerroa" +
			"vaieravunjoawalsererawelaytasamererakalmykerasogerajangbenerayembaka" +
			"ntoneratamazight estandarrazuñiaez dago eduki linguistikorikzazakiaa" +
			"rabiera moderno estandarraAustriako alemanaaleman garaia (Suitza)Aus" +
			"traliako ingelesaKanadako ingelesaBritainia Handiko ingelesaAEBko in" +
			"gelesaLatinoamerikako espainieraespainiera (Europa)Mexikoko espainie" +
			"raKanadako frantsesaSuitzako frantsesabehe-saxoieraflandrieraBrasilg" +
			"o portugesaportugesa (Europa)moldavieraserbokroazieraKongoko swahili" +
			"atxinera soilduatxinera tradizionala",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0007, 0x0010, 0x0010, 0x001a, 0x0021, 0x0029, 0x0032,
			0x003a, 0x0042, 0x0049, 0x004f, 0x005c, 0x0067, 0x0074, 0x007e,
			0x0085, 0x008e, 0x0097, 0x009f, 0x00a8, 0x00b0, 0x00b8, 0x00c3,
			0x00cd, 0x00d6, 0x00d6, 0x00de, 0x00ef, 0x00f9, 0x0101, 0x0108,
			0x010f, 0x0118, 0x0120, 0x0126, 0x012e, 0x0136, 0x0140, 0x014a,
			0x0153, 0x015a, 0x0162, 0x0166, 0x0171, 0x0178, 0x017f, 0x0188,
			0x0190, 0x0198, 0x01aa, 0x01b3, 0x01bd, 0x01c7, 0x01ce, 0x01d3,
			0x01db, 0x01e1, 0x01e1, 0x01ea, 0x01fa, 0x0204, 0x020d, 0x0213,
			// Entry 40 - 7F
			0x021e, 0x0229, 0x0234, 0x023b, 0x0246, 0x0246, 0x0249, 0x0253,
			0x025b, 0x0263, 0x026c, 0x0272, 0x027b, 0x0283, 0x028c, 0x0294,
			0x029d, 0x02ab, 0x02b4, 0x02bd, 0x02c4, 0x02cd, 0x02d7, 0x02df,
			0x02e6, 0x02f0, 0x02f9, 0x02ff, 0x030b, 0x0312, 0x031c, 0x0323,
			0x032a, 0x0334, 0x0342, 0x034b, 0x0356, 0x0361, 0x0369, 0x0374,
			0x0380, 0x038a, 0x0393, 0x039d, 0x03a4, 0x03ae, 0x03b6, 0x03cc,
			0x03d4, 0x03dc, 0x03e8, 0x03fa, 0x040c, 0x0420, 0x0429, 0x042f,
			0x043a, 0x043a, 0x0442, 0x0447, 0x044f, 0x0458, 0x0458, 0x0461,
			// Entry 80 - BF
			0x0469, 0x0472, 0x047b, 0x0487, 0x048f, 0x049a, 0x04a3, 0x04ae,
			0x04b8, 0x04c2, 0x04c9, 0x04dc, 0x04e4, 0x04eb, 0x04f6, 0x0501,
			0x0508, 0x050f, 0x0518, 0x0521, 0x0529, 0x0531, 0x0544, 0x054d,
			0x0555, 0x055c, 0x0564, 0x056d, 0x057a, 0x0586, 0x0590, 0x059b,
			0x05a3, 0x05aa, 0x05b2, 0x05ba, 0x05c2, 0x05cb, 0x05d4, 0x05dd,
			0x05e2, 0x05ea, 0x05f1, 0x05fb, 0x0604, 0x060d, 0x0615, 0x061c,
			0x0624, 0x062c, 0x062c, 0x0633, 0x063a, 0x0642, 0x064b, 0x0654,
			0x065c, 0x065c, 0x065c, 0x0664, 0x066b, 0x066b, 0x066b, 0x0673,
			// Entry C0 - FF
			0x0673, 0x0686, 0x0686, 0x068e, 0x068e, 0x0696, 0x0696, 0x069e,
			0x069e, 0x069e, 0x069e, 0x069e, 0x069e, 0x06a2, 0x06a2, 0x06ab,
			0x06ab, 0x06b4, 0x06b4, 0x06bb, 0x06bb, 0x06c0, 0x06c0, 0x06c0,
			0x06c0, 0x06c0, 0x06c7, 0x06c7, 0x06cd, 0x06cd, 0x06cd, 0x06cd,
			0x06d7, 0x06d7, 0x06dd, 0x06dd, 0x06dd, 0x06e6, 0x06e6, 0x06e6,
			0x06e6, 0x06e6, 0x06ed, 0x06ed, 0x06ed, 0x06f5, 0x06f5, 0x06fb,
			0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x0702, 0x0709, 0x0709,
			0x0709, 0x0711, 0x0718, 0x0718, 0x071f, 0x071f, 0x0729, 0x0733,
			// Entry 100 - 13F
			0x073a, 0x073a, 0x073a, 0x073a, 0x0753, 0x0753, 0x075b, 0x0763,
			0x076a, 0x076a, 0x076a, 0x0773, 0x0773, 0x077a, 0x077a, 0x0788,
			0x0788, 0x078f, 0x078f, 0x079b, 0x079b, 0x07a1, 0x07a6, 0x07ad,
			0x07ad, 0x07ad, 0x07b4, 0x07b4, 0x07b4, 0x07b4, 0x07bc, 0x07bc,
			0x07bc, 0x07c4, 0x07c4, 0x07c8, 0x07c8, 0x07c8, 0x07c8, 0x07c8,
			0x07c8, 0x07c8, 0x07d1, 0x07d3, 0x07dc, 0x07dc, 0x07dc, 0x07dc,
			0x07dc, 0x07e3, 0x07ed, 0x07ed, 0x07ed, 0x07ed, 0x07ed, 0x07ed,
			0x07f7, 0x07f7, 0x07f7, 0x07f7, 0x0807, 0x0807, 0x0807, 0x080f,
			// Entry 140 - 17F
			0x0818, 0x0818, 0x0818, 0x0821, 0x0821, 0x082c, 0x082c, 0x0831,
			0x083e, 0x083e, 0x0844, 0x084b, 0x0854, 0x085d, 0x0866, 0x0866,
			0x0866, 0x086f, 0x0875, 0x087e, 0x087e, 0x087e, 0x087e, 0x087e,
			0x0886, 0x088f, 0x0894, 0x089b, 0x089b, 0x08a5, 0x08a5, 0x08ab,
			0x08b4, 0x08c7, 0x08c7, 0x08cc, 0x08cc, 0x08d2, 0x08d2, 0x08e1,
			0x08e1, 0x08e1, 0x08e6, 0x08f1, 0x08fa, 0x0909, 0x0913, 0x0913,
			0x091a, 0x092f, 0x092f, 0x092f, 0x0938, 0x0941, 0x094b, 0x0952,
			0x095b, 0x0963, 0x0963, 0x096b, 0x0973, 0x0973, 0x0973, 0x097b,
			// Entry 180 - 1BF
			0x097b, 0x097b, 0x097b, 0x0983, 0x0983, 0x0983, 0x098a, 0x099c,
			0x099c, 0x09a5, 0x09a5, 0x09ac, 0x09b2, 0x09b7, 0x09be, 0x09be,
			0x09be, 0x09c6, 0x09c6, 0x09cf, 0x09d9, 0x09e3, 0x09e3, 0x09eb,
			0x09eb, 0x09f2, 0x09f2, 0x09fa, 0x0a01, 0x0a16, 0x0a16, 0x0a27,
			0x0a2d, 0x0a36, 0x0a44, 0x0a44, 0x0a4e, 0x0a57, 0x0a5e, 0x0a5e,
			0x0a67, 0x0a78, 0x0a7e, 0x0a87, 0x0a87, 0x0a87, 0x0a87, 0x0a8e,
			0x0a9c, 0x0a9c, 0x0aa5, 0x0aab, 0x0aab, 0x0ab3, 0x0ab8, 0x0abe,
			0x0abe, 0x0ac6, 0x0ad2, 0x0ada, 0x0ada, 0x0ada, 0x0ae3, 0x0aea,
			// Entry 1C0 - 1FF
			0x0af1, 0x0af1, 0x0af1, 0x0af9, 0x0af9, 0x0af9, 0x0af9, 0x0af9,
			0x0b06, 0x0b06, 0x0b10, 0x0b1b, 0x0b23, 0x0b23, 0x0b34, 0x0b34,
			0x0b34, 0x0b34, 0x0b34, 0x0b34, 0x0b34, 0x0b34, 0x0b34, 0x0b3c,
			0x0b3c, 0x0b49, 0x0b49, 0x0b49, 0x0b51, 0x0b5c, 0x0b5c, 0x0b5c,
			0x0b64, 0x0b64, 0x0b64, 0x0b64, 0x0b64, 0x0b6c, 0x0b72, 0x0b7a,
			0x0b81, 0x0b81, 0x0b8b, 0x0b8b, 0x0b94, 0x0b94, 0x0b9e, 0x0ba6,
			0x0baf, 0x0bb8, 0x0bb8, 0x0bb8, 0x0bb8, 0x0bbe, 0x0bbe, 0x0bbe,
			0x0bce, 0x0bce, 0x0bce, 0x0bd8, 0x0bdf, 0x0bdf, 0x0bdf, 0x0bdf,
			// Entry 200 - 23F
			0x0bdf, 0x0bf1, 0x0bfd, 0x0c0a, 0x0c17, 0x0c20, 0x0c20, 0x0c29,
			0x0c29, 0x0c2e, 0x0c2e, 0x0c36, 0x0c36, 0x0c36, 0x0c3f, 0x0c3f,
			0x0c47, 0x0c47, 0x0c47, 0x0c4d, 0x0c54, 0x0c54, 0x0c5a, 0x0c60,
			0x0c60, 0x0c60, 0x0c60, 0x0c6a, 0x0c6a, 0x0c6a, 0x0c6a, 0x0c6a,
			0x0c74, 0x0c74, 0x0c7b, 0x0c7b, 0x0c7b, 0x0c7b, 0x0c84, 0x0c8d,
			0x0c95, 0x0c9b, 0x0cb7, 0x0cc0, 0x0cc0, 0x0cca, 0x0ccf, 0x0cd5,
			0x0cd5, 0x0cd5, 0x0cd5, 0x0cd5, 0x0cd5, 0x0cd5, 0x0cdb, 0x0ce4,
			0x0ceb, 0x0cf3, 0x0cf3, 0x0cf3, 0x0cf3, 0x0cfc, 0x0cfc, 0x0d02,
			// Entry 240 - 27F
			0x0d02, 0x0d02, 0x0d0c, 0x0d11, 0x0d11, 0x0d1a, 0x0d1a, 0x0d1a,
			0x0d1a, 0x0d1a, 0x0d2e, 0x0d34, 0x0d50, 0x0d57, 0x0d72, 0x0d72,
			0x0d83, 0x0d99, 0x0dad, 0x0dbe, 0x0dd8, 0x0de6, 0x0e00, 0x0e13,
			0x0e26, 0x0e26, 0x0e38, 0x0e4a, 0x0e57, 0x0e61, 0x0e73, 0x0e85,
			0x0e8f, 0x0e9d, 0x0ead, 0x0ebc, 0x0ed0,
		},
	},
	{ // ewo
		"Ǹkɔ́bɔ akánǸkɔ́bɔ amáriaǸkɔ́bɔ arábiaǸkɔ́bɔ belarúsianǸkɔ́bɔ buləgárianǸ" +
			"kɔ́bɔ bɛngalíǸkɔ́bɔ tsɛ́gǸkɔ́bɔ ndzámanǸkɔ́bɔ gəlɛ́gǸkɔ́bɔ éngəlísǹk" +
			"ɔ́bɔ kpənyáǹkɔ́bɔ fɛ́rəsianǸkɔ́bɔ fulɛnsíǸkɔ́bɔ aúsáǸkɔ́bɔ hindíǸkɔ" +
			"́bɔ ungáríanǸkɔ́bɔ ɛndonésianǸkɔ́bɔ ibóǸkɔ́bɔ etáliɛnǸkɔ́bɔ hapɔ́nǸ" +
			"kɔ́bɔ havanísǸkɔ́bɔ kəmɛ́rǸkɔ́bɔ koréanǸkɔ́bɔ malɛ́sianǸkɔ́bɔ birəmá" +
			"nǹkɔ́bɔ nefálianǸkɔ́bɔ nɛrəlándíaǹkɔ́bɔ funəhábiaǹkɔ́bɔ fólisǹkɔ́bɔ " +
			"fɔtugɛ́sńkɔ́bɔ románíaǹkɔ́bɔ rúsianǹkɔ́bɔ ruwandáǹkɔ́bɔ somáliaǹkɔ́b" +
			"ɔ suwɛ́dǹkɔ́bɔ tamílǹkɔ́bɔ táilanǹkɔ́bɔ túrəkiǹkɔ́bɔ ukeléniaǹkɔ́bɔ" +
			" urudúǹkɔ́bɔ hiɛdənámǹkɔ́bɔ yorúbaǸkɔ́bɔ tsainísǹkɔ́bɔ zulúewondo",
		[]uint16{ // 287 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0022, 0x0022,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x004a, 0x0061,
			0x0061, 0x0061, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x009a, 0x009a, 0x009a, 0x009a, 0x00ae, 0x00c3, 0x00c3, 0x00d6,
			0x00d6, 0x00d6, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0112,
			0x0112, 0x0123, 0x0123, 0x0123, 0x0123, 0x0138, 0x0138, 0x0138,
			// Entry 40 - 7F
			0x0138, 0x014f, 0x014f, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x0172, 0x0172, 0x0185, 0x0198, 0x0198, 0x0198, 0x0198, 0x0198,
			0x0198, 0x0198, 0x01ac, 0x01ac, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be, 0x01be,
			0x01be, 0x01be, 0x01be, 0x01d4, 0x01d4, 0x01e8, 0x01e8, 0x01e8,
			0x01fc, 0x01fc, 0x0215, 0x0215, 0x0215, 0x0215, 0x0215, 0x0215,
			0x0215, 0x0215, 0x0215, 0x0215, 0x0215, 0x022b, 0x022b, 0x023c,
			// Entry 80 - BF
			0x023c, 0x0252, 0x0252, 0x0252, 0x0252, 0x0266, 0x0278, 0x028b,
			0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b, 0x028b,
			0x028b, 0x028b, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e, 0x029e,
			0x02b1, 0x02b1, 0x02c2, 0x02c2, 0x02c2, 0x02d4, 0x02d4, 0x02d4,
			0x02d4, 0x02d4, 0x02e7, 0x02e7, 0x02e7, 0x02e7, 0x02e7, 0x02fb,
			0x030c, 0x030c, 0x030c, 0x0322, 0x0322, 0x0322, 0x0322, 0x0322,
			0x0322, 0x0334, 0x0334, 0x0347, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			// Entry C0 - FF
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			// Entry 100 - 13F
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357,
			0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x0357, 0x035d,
		},
	},
	{ // fa
		faLangStr,
		faLangIdx,
	},
	{ // fa-AF
		"افریکانساسامیآذربایجانیباشقیریمالدیویهسپانویفنلندیآیرلندیکروشیاییاندونیز" +
			"یاییآیسلندیایتالویجاپانیکوریاییقرغزیمغلینیپالیهالندینارویژیپولندیپر" +
			"تگالیالبانیاییسویدنیسواحلیتاجکیکردی سورانی",
		[]uint16{ // 257 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x001a, 0x001a, 0x001a, 0x002e, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x0058,
			0x0058, 0x0058, 0x0058, 0x0058, 0x0064, 0x0064, 0x0064, 0x0064,
			0x0064, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			// Entry 40 - 7F
			0x0082, 0x0098, 0x0098, 0x0098, 0x0098, 0x0098, 0x0098, 0x00a6,
			0x00b4, 0x00b4, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0,
			0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f8, 0x00f8, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0112,
			// Entry 80 - BF
			0x0112, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120,
			0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120,
			0x0120, 0x0120, 0x0120, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132,
			0x013e, 0x014a, 0x014a, 0x014a, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			// Entry C0 - FF
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			// Entry 100 - 13F
			0x0169,
		},
	},
	{ // ff
		"AkaanAmarikAarabeereBelaruuseBulgariireBengaliCekkereDocceereGerkeEngele" +
			"ereEspañolPerseerePulaarFarayseereHawsaŋkooreHinndiHongariireEndones" +
			"iireIgibooreItaliyeereSaponeereSawaneereKemeereKoreereMalayeereBurme" +
			"eseNepaaleereDacceerePunjabeerePoloneerePurtugeereRomaneereRiisRuwaa" +
			"nndeereSomaliiSweedeereTamilTaayTurkeereUkereneereUrduWiyetnameereYo" +
			"rrubaaSinuwaareSuluŋkoore",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000b, 0x000b,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001d, 0x0027,
			0x0027, 0x0027, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x003d, 0x003d, 0x003d, 0x003d, 0x0042, 0x004b, 0x004b, 0x0053,
			0x0053, 0x0053, 0x005b, 0x0061, 0x0061, 0x0061, 0x0061, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0077,
			0x0077, 0x007d, 0x007d, 0x007d, 0x007d, 0x0087, 0x0087, 0x0087,
			// Entry 40 - 7F
			0x0087, 0x0092, 0x0092, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x00a4, 0x00a4, 0x00ad, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6,
			0x00b6, 0x00b6, 0x00bd, 0x00bd, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			0x00c4, 0x00c4, 0x00c4, 0x00cd, 0x00cd, 0x00d5, 0x00d5, 0x00d5,
			0x00df, 0x00df, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00f1, 0x00f1, 0x00fa,
			// Entry 80 - BF
			0x00fa, 0x0104, 0x0104, 0x0104, 0x0104, 0x010d, 0x0111, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x011d, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124,
			0x012d, 0x012d, 0x0132, 0x0132, 0x0132, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013e, 0x013e, 0x013e, 0x013e, 0x013e, 0x0148,
			0x014c, 0x014c, 0x014c, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158,
			0x0158, 0x0160, 0x0160, 0x0169, 0x0174,
		},
	},
	{ // fi
		fiLangStr,
		fiLangIdx,
	},
	{ // fil
		filLangStr,
		filLangIdx,
	},
	{ // fo
		"afarabkhasisktafrikaansakanamharisktaragonisktarabisktassamesisktavarisk" +
			"taymaraaserbajdsjansktbashkirhvitarussisktbulgarsktbislamabambaraben" +
			"galskttibetsktbretonsktbosnisktkatalanitjetjensktchamorrokorsikanskt" +
			"kekkisktkirkju slávisktchuvashwalisisktdanskttýsktdivehidzongkhaeweg" +
			"riksktensktesperantospansktestisktbaskisktpersisktfulahfinsktfijimál" +
			"føroysktfransktvestur frísisktírsktskotskt gælisktgalisisktguaranigu" +
			"jaratimanxhausahebraiskthindikroatiskthaitisktungarsktarmensktherero" +
			"interlinguaindonesisktinterlingueigbosichuan yiidoíslendsktitalsktin" +
			"uktitutjapansktjavansktgeorgisktkikuyukuanyamakazakhkalaallisutkhmer" +
			"kannadakoreansktkanurikashmirikurdisktkomicornisktkyrgyzlatínluksemb" +
			"orgsktgandalimburgisktlingalalaosktlitavisktluba-katangalettisktmala" +
			"gassisktmarshallesisktmaorimakedónsktmalayalammongolsktmarathimalaii" +
			"sktmaltisktburmesisktnaurunorður ndebelenepalsktndongahálendsktnýnor" +
			"sktnorskt bókmálsuður ndebelenavajonyanjaoccitansktoromooriyaossetis" +
			"ktpunjabipólsktpashtoportugiskisktquechuaretoromansktrundirumensktru" +
			"ssisktkinyarwandasanskritsardisktsindhinorður sámisktsangosingalesis" +
			"ktslovakisktslovensktsámoisktshonasomalisktalbansktserbisktswatiskts" +
			"esothosundanesisktsvensktswahilitamilskttelugutajiktailendskttigriny" +
			"aturkmenskttswanatongansktturkiskttsongatatartahitisktuyghurukrainsk" +
			"turduusbekisktvendavjetnamesisktvolapykkwalloonwolofxhosajiddisktyor" +
			"ubakinesisktsuluachineseadangmeadygheaghemainualeutsuður altaiangika" +
			"mapuchearapahoasuasturiansktawadhibalinesisktbasaabembabenavestur ba" +
			"lochibhojpuribinisiksikabodobakossibuginesisktblincebuanochigachuuke" +
			"semarichoctawcherokeecheyennemiðkurdisktseselwa creole fransktdakota" +
			"dargwataitadogribsarmalágt sorbiandualajola-fonyidazagaembuefikekaju" +
			"kewondofilipinisktfonfriulisktgagagauzgan kinesisktgeezkiribatisktgo" +
			"rontalotýskt (Sveis)gusiigwich’inhakka kinesiskthawaiianskthiligayno" +
			"nhmongovara sorbianxiang kinesiskthupaibanibibioilokoinguishlojbanng" +
			"ombamachamekabylekachinjjukambakabardinskttyapmakondegrønhøvdaoyggja" +
			"rsktkorokhasikoyra chiinikakokalenjinkimbundukomi-permyakkonkanikpel" +
			"lekarachay-balkarkarelsktkurukhshambalabafiakølnsktkumykladinolangil" +
			"ahndalezghianlakotalozinorður luriluba-lulualundaluomizoluyiamadures" +
			"isktmagahimaithilimakasarmasaimokshamendemerumorisyenmakhuwa-meettom" +
			"etaʼmicmacminangkabaumanupurimohawkmossimundangymisk málcreekmirande" +
			"siskterzyamazanderanimin nan kinesisktnapolitansktnamalágt týsktnewa" +
			"riniasniueankwasiongiemboonnogainʼkonorður sothonuernyankolepangasin" +
			"anpampangapapiamentopalauannigeriskt pidginprusslansktkʼicheʼrapanui" +
			"rarotongisktromboaromensktrwasandawesakhasamburusantalingambaysangus" +
			"isilansktskotsktsuður kurdisktsenakoyraboro sennitachelhitshansuður " +
			"sámisktlule sámisktinari samiskolt sámisktsoninkesranan tongosahosuk" +
			"umakomorisktsyriactimnetesotetumtigreklingonskttok pisintarokotumbuk" +
			"atuvalutasawaqtuvinianmiðatlasfjøll tamazightudmurtumbundurootvaivun" +
			"jowalserwolayttawaraywarlpiriwu kinesisktkalmyksogayangbenyembakanto" +
			"nesisktvanligt marokanskt tamazightzunieinki málsligt innihaldzazanú" +
			"tíðar vanligt arabiskthøgt týskt (Sveis)lágt saksisktflamsktportugis" +
			"kiskt (Brasilia)portugiskiskt (Evropa)moldavisktserbokroatisktkongo " +
			"svahilieinkult kinesisktvanligt kinesiskt",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x000e, 0x0017, 0x001b, 0x0024, 0x002e,
			0x0036, 0x0041, 0x0049, 0x004f, 0x005e, 0x0065, 0x0072, 0x007b,
			0x0082, 0x0089, 0x0092, 0x009a, 0x00a3, 0x00ab, 0x00b3, 0x00bd,
			0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00e8, 0x00ef, 0x00f8, 0x00fe,
			0x0104, 0x010a, 0x0112, 0x0115, 0x011c, 0x0121, 0x012a, 0x0131,
			0x0138, 0x0140, 0x0148, 0x014d, 0x0153, 0x015b, 0x0164, 0x016b,
			0x017b, 0x0181, 0x0191, 0x019a, 0x01a1, 0x01a9, 0x01ad, 0x01b2,
			0x01bb, 0x01c0, 0x01c0, 0x01c9, 0x01d1, 0x01d9, 0x01e1, 0x01e7,
			// Entry 40 - 7F
			0x01f2, 0x01fd, 0x0208, 0x020c, 0x0216, 0x0216, 0x0219, 0x0223,
			0x022a, 0x0233, 0x023b, 0x0243, 0x024c, 0x024c, 0x0252, 0x025a,
			0x0260, 0x026b, 0x0270, 0x0277, 0x0280, 0x0286, 0x028e, 0x0296,
			0x029a, 0x02a2, 0x02a8, 0x02ae, 0x02bb, 0x02c0, 0x02cb, 0x02d2,
			0x02d8, 0x02e1, 0x02ed, 0x02f5, 0x0301, 0x030f, 0x0314, 0x031f,
			0x0328, 0x0331, 0x0338, 0x0341, 0x0349, 0x0353, 0x0358, 0x0367,
			0x036f, 0x0375, 0x037f, 0x0388, 0x0397, 0x03a5, 0x03ab, 0x03b1,
			0x03bb, 0x03bb, 0x03c0, 0x03c5, 0x03ce, 0x03d5, 0x03d5, 0x03dc,
			// Entry 80 - BF
			0x03e2, 0x03ef, 0x03f6, 0x0402, 0x0407, 0x040f, 0x0417, 0x0422,
			0x042a, 0x0432, 0x0438, 0x0448, 0x044d, 0x0459, 0x0463, 0x046c,
			0x0475, 0x047a, 0x0483, 0x048b, 0x0493, 0x049b, 0x04a2, 0x04ae,
			0x04b5, 0x04bc, 0x04c4, 0x04ca, 0x04cf, 0x04d9, 0x04e1, 0x04eb,
			0x04f1, 0x04fa, 0x0502, 0x0508, 0x050d, 0x0516, 0x051c, 0x0525,
			0x0529, 0x0532, 0x0537, 0x0544, 0x054c, 0x0553, 0x0558, 0x055d,
			0x0565, 0x056b, 0x056b, 0x0574, 0x0578, 0x0580, 0x0580, 0x0587,
			0x058d, 0x058d, 0x058d, 0x0592, 0x0596, 0x0596, 0x0596, 0x059b,
			// Entry C0 - FF
			0x059b, 0x05a7, 0x05a7, 0x05ad, 0x05ad, 0x05b4, 0x05b4, 0x05bb,
			0x05bb, 0x05bb, 0x05bb, 0x05bb, 0x05bb, 0x05be, 0x05be, 0x05c9,
			0x05c9, 0x05cf, 0x05cf, 0x05da, 0x05da, 0x05df, 0x05df, 0x05df,
			0x05df, 0x05df, 0x05e4, 0x05e4, 0x05e8, 0x05e8, 0x05e8, 0x05f6,
			0x05fe, 0x05fe, 0x0602, 0x0602, 0x0602, 0x0609, 0x0609, 0x0609,
			0x0609, 0x0609, 0x060d, 0x0614, 0x0614, 0x061f, 0x061f, 0x0623,
			0x0623, 0x0623, 0x0623, 0x0623, 0x0623, 0x062a, 0x062f, 0x062f,
			0x062f, 0x0637, 0x063b, 0x063b, 0x0642, 0x0642, 0x064a, 0x0652,
			// Entry 100 - 13F
			0x065e, 0x065e, 0x065e, 0x065e, 0x0674, 0x0674, 0x067a, 0x0680,
			0x0685, 0x0685, 0x0685, 0x068b, 0x068b, 0x0690, 0x0690, 0x069d,
			0x069d, 0x06a2, 0x06a2, 0x06ac, 0x06ac, 0x06b2, 0x06b6, 0x06ba,
			0x06ba, 0x06ba, 0x06c0, 0x06c0, 0x06c0, 0x06c0, 0x06c6, 0x06c6,
			0x06c6, 0x06d1, 0x06d1, 0x06d4, 0x06d4, 0x06d4, 0x06d4, 0x06d4,
			0x06d4, 0x06d4, 0x06dd, 0x06df, 0x06e5, 0x06f2, 0x06f2, 0x06f2,
			0x06f2, 0x06f6, 0x0701, 0x0701, 0x0701, 0x0701, 0x0701, 0x0701,
			0x070a, 0x070a, 0x070a, 0x070a, 0x0718, 0x0718, 0x0718, 0x071d,
			// Entry 140 - 17F
			0x0727, 0x0727, 0x0736, 0x0741, 0x0741, 0x074b, 0x074b, 0x0750,
			0x075d, 0x076c, 0x0770, 0x0774, 0x077a, 0x077f, 0x0786, 0x0786,
			0x0786, 0x078c, 0x0792, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799,
			0x079f, 0x07a5, 0x07a8, 0x07ad, 0x07ad, 0x07b8, 0x07b8, 0x07bc,
			0x07c3, 0x07d8, 0x07d8, 0x07dc, 0x07dc, 0x07e1, 0x07e1, 0x07ed,
			0x07ed, 0x07ed, 0x07f1, 0x07f9, 0x0801, 0x080d, 0x0814, 0x0814,
			0x081a, 0x0829, 0x0829, 0x0829, 0x0831, 0x0837, 0x083f, 0x0844,
			0x084c, 0x0851, 0x0851, 0x0857, 0x085c, 0x0862, 0x0862, 0x086a,
			// Entry 180 - 1BF
			0x086a, 0x086a, 0x086a, 0x0870, 0x0870, 0x0870, 0x0874, 0x0880,
			0x0880, 0x088a, 0x088a, 0x088f, 0x0892, 0x0896, 0x089b, 0x089b,
			0x089b, 0x08a6, 0x08a6, 0x08ac, 0x08b4, 0x08bb, 0x08bb, 0x08c0,
			0x08c0, 0x08c6, 0x08c6, 0x08cb, 0x08cf, 0x08d7, 0x08d7, 0x08e5,
			0x08eb, 0x08f1, 0x08fc, 0x08fc, 0x0904, 0x090a, 0x090f, 0x090f,
			0x0916, 0x0920, 0x0925, 0x0931, 0x0931, 0x0931, 0x0931, 0x0936,
			0x0941, 0x0952, 0x095e, 0x0962, 0x096e, 0x0974, 0x0978, 0x097e,
			0x097e, 0x0984, 0x098d, 0x0992, 0x0992, 0x0992, 0x0997, 0x09a4,
			// Entry 1C0 - 1FF
			0x09a8, 0x09a8, 0x09a8, 0x09b0, 0x09b0, 0x09b0, 0x09b0, 0x09b0,
			0x09ba, 0x09ba, 0x09c2, 0x09cc, 0x09d3, 0x09d3, 0x09e3, 0x09e3,
			0x09e3, 0x09e3, 0x09e3, 0x09e3, 0x09e3, 0x09e3, 0x09e3, 0x09ee,
			0x09ee, 0x09f7, 0x09f7, 0x09f7, 0x09fe, 0x0a0a, 0x0a0a, 0x0a0a,
			0x0a0f, 0x0a0f, 0x0a0f, 0x0a0f, 0x0a0f, 0x0a18, 0x0a1b, 0x0a22,
			0x0a27, 0x0a27, 0x0a2e, 0x0a2e, 0x0a35, 0x0a35, 0x0a3c, 0x0a41,
			0x0a4b, 0x0a52, 0x0a52, 0x0a61, 0x0a61, 0x0a65, 0x0a65, 0x0a65,
			0x0a74, 0x0a74, 0x0a74, 0x0a7d, 0x0a81, 0x0a81, 0x0a81, 0x0a81,
			// Entry 200 - 23F
			0x0a81, 0x0a90, 0x0a9d, 0x0aa7, 0x0ab5, 0x0abc, 0x0abc, 0x0ac8,
			0x0ac8, 0x0acc, 0x0acc, 0x0ad2, 0x0ad2, 0x0ad2, 0x0adb, 0x0adb,
			0x0ae1, 0x0ae1, 0x0ae1, 0x0ae6, 0x0aea, 0x0aea, 0x0aef, 0x0af4,
			0x0af4, 0x0af4, 0x0af4, 0x0afe, 0x0afe, 0x0afe, 0x0afe, 0x0afe,
			0x0b07, 0x0b07, 0x0b0d, 0x0b0d, 0x0b0d, 0x0b0d, 0x0b14, 0x0b1a,
			0x0b21, 0x0b29, 0x0b42, 0x0b48, 0x0b48, 0x0b4f, 0x0b53, 0x0b56,
			0x0b56, 0x0b56, 0x0b56, 0x0b56, 0x0b56, 0x0b56, 0x0b5b, 0x0b61,
			0x0b69, 0x0b6e, 0x0b6e, 0x0b76, 0x0b82, 0x0b88, 0x0b88, 0x0b8c,
			// Entry 240 - 27F
			0x0b8c, 0x0b8c, 0x0b93, 0x0b98, 0x0b98, 0x0ba4, 0x0ba4, 0x0ba4,
			0x0ba4, 0x0ba4, 0x0bc0, 0x0bc4, 0x0bdc, 0x0be0, 0x0bfb, 0x0bfb,
			0x0bfb, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f,
			0x0c0f, 0x0c0f, 0x0c0f, 0x0c0f, 0x0c1d, 0x0c24, 0x0c3c, 0x0c52,
			0x0c5c, 0x0c6a, 0x0c77, 0x0c88, 0x0c99,
		},
	},
	{ // fr
		frLangStr,
		frLangIdx,
	},
	{ // fr-BE
		"gujaratisame du Nordfranco-provençalancien haut-allemandgotiqueaosame du" +
			" Sudsame de Lulesame d’Inarisame skolt",
		[]uint16{ // 517 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			// Entry 40 - 7F
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			// Entry 80 - BF
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			// Entry C0 - FF
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			// Entry 100 - 13F
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			// Entry 140 - 17F
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			// Entry 180 - 1BF
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			// Entry 1C0 - 1FF
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			// Entry 200 - 23F
			0x0042, 0x004d, 0x0059, 0x0067, 0x0071,
		},
	},
	{ // fr-CA
		frCALangStr,
		frCALangIdx,
	},
	{ // fr-CH
		"goudjratiallemand de Pennsylvaniekurde méridional",
		[]uint16{ // 500 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 40 - 7F
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 80 - BF
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry C0 - FF
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 100 - 13F
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 140 - 17F
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 180 - 1BF
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			// Entry 1C0 - 1FF
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0032,
		},
	},
	{ // fur
		"afarabcazianavestanafrikaansamaricaragonêsarapassamêsavaraymaràazerbaija" +
			"nibielorùsbulgarbengalêstibetanbretonbosniaccatalancecenchamorrocors" +
			"creececsclâf de glesiegalêsdanêstodescgrêcinglêsesperantospagnûlesto" +
			"nbascpersianfulahfinlandêsfizianfaroêsfrancêsfrisiangaelic irlandêsg" +
			"aelic scozêsgalizianguaranìgujaratimanxebraichindicravuathaitianongj" +
			"arêsarmenindonesianigboinupiaqidoislandêstalianinuktitutgjaponêsgjeo" +
			"rgjiankazackalaallisutkhmerkannadacoreancurdcornualiêslatinlussembur" +
			"ghêslimburghêslingalalaolituanletonmalagasymaorimacedonmalayalammong" +
			"ulmarathimalêsmaltêsndebele setentrionâlnepalêsolandêsnorvegjês nyno" +
			"rsknorvegjês bokmålnavajoocitanoriyaoseticpunjabipolacpashtoportughê" +
			"squechuarumançromenrussanscritsardegnûlsindhisami setentrionâlsangos" +
			"inalêsslovacslovensamoansomalalbanêsserpswatisotho meridionâlsundanê" +
			"ssvedêsswahilitamiltelegutagicthaiturcmenturctartartahitianuigurucra" +
			"inurduuzbecvendavietnamitevalonwolofxhosayiddishyorubacinêszuluvieri" +
			" inglêsaramaicasturiancopticsclâfvieri egjizianfilipinvieri francêsf" +
			"urlangoticvieri grêcladinlenghis multiplismirandêsnapoletanbas todes" +
			"cvieri norvegjêssotho setentrionâlturc otomanpapiamentovieri persian" +
			"vieri provenzâlsicilianscozêsvieri irlandêssumerictetumindeterminade" +
			"todesc de Austriealt todesc de Svuizareinglês australianinglês canad" +
			"êsinglês britanicingles merecanspagnûl de Americhe Latinespagnûl ib" +
			"ericfrancês dal Canadefrancês de Svuizareflamantportughês brasilianp" +
			"ortughês ibericmoldâfcinês semplificâtcinês tradizionâl",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000c, 0x0013, 0x001c, 0x001c, 0x0022, 0x002b,
			0x002f, 0x0037, 0x003b, 0x0042, 0x004d, 0x004d, 0x0056, 0x005c,
			0x005c, 0x005c, 0x0065, 0x006c, 0x0072, 0x0079, 0x0080, 0x0085,
			0x008d, 0x0091, 0x0095, 0x0098, 0x00a8, 0x00a8, 0x00ae, 0x00b4,
			0x00ba, 0x00ba, 0x00ba, 0x00ba, 0x00bf, 0x00c6, 0x00cf, 0x00d7,
			0x00dc, 0x00e0, 0x00e7, 0x00ec, 0x00f6, 0x00fc, 0x0103, 0x010b,
			0x0112, 0x0122, 0x0130, 0x0138, 0x0140, 0x0148, 0x014c, 0x014c,
			0x0152, 0x0157, 0x0157, 0x015e, 0x0165, 0x016e, 0x0173, 0x0173,
			// Entry 40 - 7F
			0x0173, 0x017d, 0x017d, 0x0181, 0x0181, 0x0188, 0x018b, 0x0194,
			0x019a, 0x01a3, 0x01ac, 0x01ac, 0x01b6, 0x01b6, 0x01b6, 0x01b6,
			0x01bb, 0x01c6, 0x01cb, 0x01d2, 0x01d8, 0x01d8, 0x01d8, 0x01dc,
			0x01dc, 0x01e7, 0x01e7, 0x01ec, 0x01fa, 0x01fa, 0x0205, 0x020c,
			0x020f, 0x0215, 0x0215, 0x021a, 0x0222, 0x0222, 0x0227, 0x022e,
			0x0237, 0x023d, 0x0244, 0x024a, 0x0251, 0x0251, 0x0251, 0x0266,
			0x026e, 0x026e, 0x0276, 0x0288, 0x029a, 0x029a, 0x02a0, 0x02a0,
			0x02a6, 0x02a6, 0x02a6, 0x02ab, 0x02b1, 0x02b8, 0x02b8, 0x02bd,
			// Entry 80 - BF
			0x02c3, 0x02cd, 0x02d4, 0x02db, 0x02db, 0x02e0, 0x02e3, 0x02e3,
			0x02eb, 0x02f5, 0x02fb, 0x030d, 0x0312, 0x031a, 0x0320, 0x0326,
			0x032c, 0x032c, 0x0331, 0x0339, 0x033d, 0x0342, 0x0353, 0x035c,
			0x0363, 0x036a, 0x036f, 0x0375, 0x037a, 0x037e, 0x037e, 0x0385,
			0x0385, 0x0385, 0x0389, 0x0389, 0x038f, 0x0397, 0x039c, 0x03a2,
			0x03a6, 0x03ab, 0x03b0, 0x03ba, 0x03ba, 0x03bf, 0x03c4, 0x03c9,
			0x03d0, 0x03d6, 0x03d6, 0x03dc, 0x03e0, 0x03e0, 0x03e0, 0x03e0,
			0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0, 0x03e0,
			// Entry C0 - FF
			0x03e0, 0x03e0, 0x03ed, 0x03ed, 0x03f4, 0x03f4, 0x03f4, 0x03f4,
			0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03f4, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc, 0x03fc,
			// Entry 100 - 13F
			0x03fc, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402, 0x0402,
			0x0402, 0x0402, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408, 0x0408,
			0x0408, 0x0416, 0x0416, 0x0416, 0x0416, 0x0416, 0x0416, 0x0416,
			0x0416, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x042b, 0x042b,
			0x042b, 0x042b, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431,
			0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431, 0x0431,
			0x0431, 0x0436, 0x0436, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			// Entry 140 - 17F
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441, 0x0441,
			0x0441, 0x0441, 0x0441, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			// Entry 180 - 1BF
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446, 0x0446,
			0x0446, 0x0457, 0x0457, 0x0460, 0x0460, 0x0460, 0x0460, 0x0460,
			0x0460, 0x0460, 0x0469, 0x0469, 0x0473, 0x0473, 0x0473, 0x0473,
			0x0473, 0x0473, 0x0473, 0x0473, 0x0483, 0x0483, 0x0483, 0x0496,
			// Entry 1C0 - 1FF
			0x0496, 0x0496, 0x0496, 0x0496, 0x0496, 0x0496, 0x0496, 0x04a1,
			0x04a1, 0x04a1, 0x04a1, 0x04ab, 0x04ab, 0x04ab, 0x04ab, 0x04ab,
			0x04ab, 0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04b8, 0x04b8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8, 0x04c8,
			0x04d0, 0x04d7, 0x04d7, 0x04d7, 0x04d7, 0x04d7, 0x04d7, 0x04d7,
			0x04d7, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6,
			// Entry 200 - 23F
			0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6,
			0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04e6, 0x04ed, 0x04ed, 0x04ed,
			0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04ed, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2,
			0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04f2, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			// Entry 240 - 27F
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff, 0x04ff,
			0x0510, 0x0526, 0x0538, 0x0548, 0x0558, 0x0566, 0x0581, 0x0590,
			0x0590, 0x0590, 0x05a3, 0x05b7, 0x05b7, 0x05be, 0x05d2, 0x05e3,
			0x05ea, 0x05ea, 0x05ea, 0x05fd, 0x0610,
		},
	},
	{ // fy
		"AfarAbchazyskAvestyskAfrikaanskAkanAmhaarskAragoneeskArabyskAssameeskAva" +
			"ryskAymaraAzerbeidzjaanskBasjkierskWyt-RussyskBulgaarskBislamaBambar" +
			"aBengaalskTibetaanskBretonskBosnyskKatalaanskTsjetsjeenskChamorroKor" +
			"sikaanskCreeTsjechyskKerkslavyskTsjoevasjyskWelskDeenskDútskDivehiDz" +
			"ongkhaEweGryksIngelskEsperantoSpaanskEstlânskBaskyskPerzyskFulahFins" +
			"kFijyskFaeröerskFrânskWest-FryskIerskSchotsk GaelicGalisyskGuaraníGu" +
			"jaratiManksHausaHebreeuwskHindiHiri MotuKroatyskHaïtiaanskHongaarskA" +
			"rmeenskHereroInterlinguaYndonezyskInterlingueIgboSichuan YiInupiaqId" +
			"oYslânsItaliaanskInuktitutJapansJavaanskGeorgyskKongoKikuyuKuanyamaK" +
			"azachsGrienlânsKhmerKannadaKoreaanskKanuriKasjmiriKoerdyskKomiCornis" +
			"hKirgizyskLatynLuxemburgsGandaLimburgsLingalaLaotiaanskLitouwsLuba-K" +
			"atangaLetlânsMalagasyskMarshalleesMaoriMacedonyskMalayalamMongoolsMa" +
			"rathiMaleisMalteesBirmeesNauruaanskNoard-NdbeleNepaleesNdongaNederlâ" +
			"nskNoors - NynorskNoors - BokmålSûd-NdbeleNavajoNyanjaOccitaanskOjib" +
			"waOromoOdiaOssetyskPunjabiPaliPoalskPasjtoePortugeeskQuechuaReto-Rom" +
			"aanskKirundiRoemeenskRussyskKinyarwandaSanskrietSardinyskSindhiNoard" +
			"-SamyskSangoSingaleesSlowaaksSloveenskSamoaanskShonaSomalyskAlbanees" +
			"kServyskSwaziSûd-SothoSoendaneeskZweedsSwahiliTamilTeluguTadzjieksTh" +
			"aisTigrinyaTurkmeensTswanaTongaanskTurksTsongaTataarsTahityskOeigoer" +
			"sOekraïensUrduOezbeeksVendaVietnameesVolapükWaalsWolofXhosaJiddyskYo" +
			"rubaZhuangSineeskZuluAtjeeskAkoliAdangmeAdygheAfrihiliAghemAinuAkkad" +
			"yskAleutSûd-AltaïskâldingelskAngikaArameeskAraukaanskArapahoArawakAs" +
			"uAsturyskAwadhiBaloetsjyskBalineeskBasaBamounGhomala’BejaBembaBenaBa" +
			"futBhojpuriBikolBiniKomSiksikaBrajBodoAkooseBuriatBugineeskBuluBlinM" +
			"edumbaKaddoKaribyskCayugaAtsamCebuanoChigaChibchaChagataiChuukeeskMa" +
			"riChinook-jargonChoctawChipewyanCherokeeCheyenneSoranîKoptyskKrim-Ta" +
			"taarskKasjoebyskDakotaDargwaTaitaDelawareSlaveDogribDinkaZarmaDogriN" +
			"edersorbyskDualaMiddelnederlânskJola-FonyiDyulaDazagaEmbuEfikAldegyp" +
			"tyskEkajukElamityskMiddelingelskEwondoFangFilipynskFonMiddelfrânskAl" +
			"dfrânskNoard-FryskEast-FryskFriulyskGaGayoGbayaGeezGilberteeskMiddel" +
			"heechdútskAlsheechdútskGondiGorontaloGothyskGreboAldgryksSwitsers Dú" +
			"tskGusiiGwichʼinHaidaHawaïaanskHiligaynonHettityskHmongOppersorbyskH" +
			"upaIbanIbibioIlokoIngoesjLojbanNgombaMachameJudeo-PerzyskJudeo-Araby" +
			"skKarakalpaksKabyleKachinJjuKambaKawiKabardyskKanembuTyapMakondeKaap" +
			"verdysk CreoolsKoroKhasiKhotaneeskKoyra ChiiniKakoKalenjinKimbunduKo" +
			"nkaniKosraeaanskKpelleKarachay-BalkarKarelyskKurukhShambalaBafiaKöls" +
			"chKoemuksKutenaiLadinoLangiLahndaLambaLezgyskLakotaMongoLoziLuba-Lul" +
			"uaLuisenoLundaLuoLushaiLuyiaMadureesMafaMagahiMaithiliMakassaarsMand" +
			"ingoMasaiMabaMokshaMandarMendeMeruMorisyenMiddeliersMakhuwa-MeettoMe" +
			"ta’Mi’kmaqMinangkabauMantsjoeManipoeriMohawkMossiMundangMeardere tal" +
			"enCreekMirandeesMarwariMyeneErzjaNapolitaanskNamaLaagduitsNewariNias" +
			"NiueaanskNgumbaNgiemboonNogaiAldnoarskN’koNoard-SothoNuerKlassiek Ne" +
			"wariNyamweziNyankoleNyoroNzimaOsageOttomaansk-TurksPangasinanPahlavi" +
			"PampangaPapiamentsPalauaanskAldperzyskFoenisyskPohnpeiaanskAldproven" +
			"çaalsRajasthaniRapanuiRarotonganRomboRomaniAromaniaanskRwaSandaweJa" +
			"koetsSamaritaansk-ArameeskSamburuSasakSantaliNgambaySanguSiciliaansk" +
			"SchotsSenecaSenaSelkupKoyraboro SenniAldyrskTashelhiytShanTsjadysk A" +
			"rabyskSidamoSûd-SamyskLule SamiInari SamiSkolt SamiSoninkeSogdyskSra" +
			"nantongoSererSahoSukumaSoesoeSoemeryskShimaoreKlassiek SyryskSyryskT" +
			"imneTesoTerenoTetunTigreTivTokelausKlingonTlingitTamashekNyasa Tonga" +
			"Tok PisinTarokoTsimshianToemboekaTuvaluaanskTasawaqTuvinyskTamazight" +
			" (Sintraal-Marokko)OedmoertsOegarityskUmbunduRootVaiVotyskVunjoWalse" +
			"rWalamoWarayWashoKalmykSogaYaoYapeesYangbenYembaKantoneeskZapotecBli" +
			"ssymbolenZenagaStandert Marokkaanske TamazightZuniGjin linguïstyske " +
			"ynhâldZazaModern standert ArabyskEastenryks DútskSwitsersk Heechdúts" +
			"kAustralysk IngelskKanadeesk IngelskBritsk IngelskAmerikaansk Ingels" +
			"kLatynsk-Amerikaansk SpaanskEuropeesk SpaanskMeksikaansk SpaanskKana" +
			"deesk FrânskSwitserse FrânskVlaamsBrazyljaansk PortugeesEuropees Por" +
			"tugeesMoldavyskServokroatyskCongo SwahiliFerienfâldich SineeskTradis" +
			"joneel Sineesk",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0015, 0x001f, 0x0023, 0x002b, 0x0035,
			0x003c, 0x0045, 0x004c, 0x0052, 0x0061, 0x006b, 0x0076, 0x007f,
			0x0086, 0x008d, 0x0096, 0x00a0, 0x00a8, 0x00af, 0x00b9, 0x00c5,
			0x00cd, 0x00d8, 0x00dc, 0x00e5, 0x00f0, 0x00fc, 0x0101, 0x0107,
			0x010d, 0x0113, 0x011b, 0x011e, 0x0123, 0x012a, 0x0133, 0x013a,
			0x0143, 0x014a, 0x0151, 0x0156, 0x015b, 0x0161, 0x016b, 0x0172,
			0x017c, 0x0181, 0x018f, 0x0197, 0x019f, 0x01a7, 0x01ac, 0x01b1,
			0x01bb, 0x01c0, 0x01c9, 0x01d1, 0x01dc, 0x01e5, 0x01ed, 0x01f3,
			// Entry 40 - 7F
			0x01fe, 0x0208, 0x0213, 0x0217, 0x0221, 0x0228, 0x022b, 0x0232,
			0x023c, 0x0245, 0x024b, 0x0253, 0x025b, 0x0260, 0x0266, 0x026e,
			0x0275, 0x027f, 0x0284, 0x028b, 0x0294, 0x029a, 0x02a2, 0x02aa,
			0x02ae, 0x02b5, 0x02be, 0x02c3, 0x02cd, 0x02d2, 0x02da, 0x02e1,
			0x02eb, 0x02f2, 0x02fe, 0x0306, 0x0310, 0x031b, 0x0320, 0x032a,
			0x0333, 0x033b, 0x0342, 0x0348, 0x034f, 0x0356, 0x0360, 0x036c,
			0x0374, 0x037a, 0x0385, 0x0394, 0x03a3, 0x03ae, 0x03b4, 0x03ba,
			0x03c4, 0x03ca, 0x03cf, 0x03d3, 0x03db, 0x03e2, 0x03e6, 0x03ec,
			// Entry 80 - BF
			0x03f3, 0x03fd, 0x0404, 0x0411, 0x0418, 0x0421, 0x0428, 0x0433,
			0x043c, 0x0445, 0x044b, 0x0457, 0x045c, 0x0465, 0x046d, 0x0476,
			0x047f, 0x0484, 0x048c, 0x0495, 0x049c, 0x04a1, 0x04ab, 0x04b6,
			0x04bc, 0x04c3, 0x04c8, 0x04ce, 0x04d7, 0x04dc, 0x04e4, 0x04ed,
			0x04f3, 0x04fc, 0x0501, 0x0507, 0x050e, 0x0516, 0x051e, 0x0528,
			0x052c, 0x0534, 0x0539, 0x0543, 0x054b, 0x0550, 0x0555, 0x055a,
			0x0561, 0x0567, 0x056d, 0x0574, 0x0578, 0x057f, 0x0584, 0x058b,
			0x0591, 0x0591, 0x0599, 0x059e, 0x05a2, 0x05aa, 0x05aa, 0x05af,
			// Entry C0 - FF
			0x05af, 0x05bc, 0x05c7, 0x05cd, 0x05d5, 0x05df, 0x05df, 0x05e6,
			0x05e6, 0x05e6, 0x05ec, 0x05ec, 0x05ec, 0x05ef, 0x05ef, 0x05f7,
			0x05f7, 0x05fd, 0x0608, 0x0611, 0x0611, 0x0615, 0x061b, 0x061b,
			0x0625, 0x0629, 0x062e, 0x062e, 0x0632, 0x0637, 0x0637, 0x0637,
			0x063f, 0x0644, 0x0648, 0x0648, 0x064b, 0x0652, 0x0652, 0x0652,
			0x0656, 0x0656, 0x065a, 0x0660, 0x0666, 0x066f, 0x0673, 0x0677,
			0x067e, 0x0683, 0x068b, 0x0691, 0x0696, 0x069d, 0x06a2, 0x06a9,
			0x06b1, 0x06ba, 0x06be, 0x06cc, 0x06d3, 0x06dc, 0x06e4, 0x06ec,
			// Entry 100 - 13F
			0x06f3, 0x06fa, 0x06fa, 0x0707, 0x0707, 0x0711, 0x0717, 0x071d,
			0x0722, 0x072a, 0x072f, 0x0735, 0x073a, 0x073f, 0x0744, 0x0750,
			0x0750, 0x0755, 0x0766, 0x0770, 0x0775, 0x077b, 0x077f, 0x0783,
			0x0783, 0x078e, 0x0794, 0x079d, 0x07aa, 0x07aa, 0x07b0, 0x07b0,
			0x07b4, 0x07bd, 0x07bd, 0x07c0, 0x07c0, 0x07cd, 0x07d7, 0x07d7,
			0x07e2, 0x07ec, 0x07f4, 0x07f6, 0x07f6, 0x07f6, 0x07fa, 0x07ff,
			0x07ff, 0x0803, 0x080e, 0x080e, 0x081f, 0x082d, 0x082d, 0x0832,
			0x083b, 0x0842, 0x0847, 0x084f, 0x085e, 0x085e, 0x085e, 0x0863,
			// Entry 140 - 17F
			0x086c, 0x0871, 0x0871, 0x087c, 0x087c, 0x0886, 0x088f, 0x0894,
			0x08a0, 0x08a0, 0x08a4, 0x08a8, 0x08ae, 0x08b3, 0x08ba, 0x08ba,
			0x08ba, 0x08c0, 0x08c6, 0x08cd, 0x08da, 0x08e7, 0x08e7, 0x08f2,
			0x08f8, 0x08fe, 0x0901, 0x0906, 0x090a, 0x0913, 0x091a, 0x091e,
			0x0925, 0x0938, 0x0938, 0x093c, 0x093c, 0x0941, 0x094b, 0x0957,
			0x0957, 0x0957, 0x095b, 0x0963, 0x096b, 0x096b, 0x0972, 0x097d,
			0x0983, 0x0992, 0x0992, 0x0992, 0x099a, 0x09a0, 0x09a8, 0x09ad,
			0x09b4, 0x09bb, 0x09c2, 0x09c8, 0x09cd, 0x09d3, 0x09d8, 0x09df,
			// Entry 180 - 1BF
			0x09df, 0x09df, 0x09df, 0x09e5, 0x09e5, 0x09ea, 0x09ee, 0x09ee,
			0x09ee, 0x09f8, 0x09ff, 0x0a04, 0x0a07, 0x0a0d, 0x0a12, 0x0a12,
			0x0a12, 0x0a1a, 0x0a1e, 0x0a24, 0x0a2c, 0x0a36, 0x0a3e, 0x0a43,
			0x0a47, 0x0a4d, 0x0a53, 0x0a58, 0x0a5c, 0x0a64, 0x0a6e, 0x0a7c,
			0x0a83, 0x0a8c, 0x0a97, 0x0a9f, 0x0aa8, 0x0aae, 0x0ab3, 0x0ab3,
			0x0aba, 0x0ac8, 0x0acd, 0x0ad6, 0x0add, 0x0add, 0x0ae2, 0x0ae7,
			0x0ae7, 0x0ae7, 0x0af3, 0x0af7, 0x0b00, 0x0b06, 0x0b0a, 0x0b13,
			0x0b13, 0x0b19, 0x0b22, 0x0b27, 0x0b30, 0x0b30, 0x0b36, 0x0b41,
			// Entry 1C0 - 1FF
			0x0b45, 0x0b54, 0x0b5c, 0x0b64, 0x0b69, 0x0b6e, 0x0b73, 0x0b83,
			0x0b8d, 0x0b94, 0x0b9c, 0x0ba6, 0x0bb0, 0x0bb0, 0x0bb0, 0x0bb0,
			0x0bb0, 0x0bba, 0x0bba, 0x0bc3, 0x0bc3, 0x0bc3, 0x0bcf, 0x0bcf,
			0x0bde, 0x0bde, 0x0bde, 0x0be8, 0x0bef, 0x0bf9, 0x0bf9, 0x0bf9,
			0x0bfe, 0x0c04, 0x0c04, 0x0c04, 0x0c04, 0x0c10, 0x0c13, 0x0c1a,
			0x0c21, 0x0c36, 0x0c3d, 0x0c42, 0x0c49, 0x0c49, 0x0c50, 0x0c55,
			0x0c60, 0x0c66, 0x0c66, 0x0c66, 0x0c6c, 0x0c70, 0x0c70, 0x0c76,
			0x0c85, 0x0c8c, 0x0c8c, 0x0c96, 0x0c9a, 0x0caa, 0x0cb0, 0x0cb0,
			// Entry 200 - 23F
			0x0cb0, 0x0cbb, 0x0cc4, 0x0cce, 0x0cd8, 0x0cdf, 0x0ce6, 0x0cf1,
			0x0cf6, 0x0cfa, 0x0cfa, 0x0d00, 0x0d06, 0x0d0f, 0x0d17, 0x0d26,
			0x0d2c, 0x0d2c, 0x0d2c, 0x0d31, 0x0d35, 0x0d3b, 0x0d40, 0x0d45,
			0x0d48, 0x0d50, 0x0d50, 0x0d57, 0x0d5e, 0x0d5e, 0x0d66, 0x0d71,
			0x0d7a, 0x0d7a, 0x0d80, 0x0d80, 0x0d89, 0x0d89, 0x0d92, 0x0d9d,
			0x0da4, 0x0dac, 0x0dc8, 0x0dd1, 0x0ddb, 0x0de2, 0x0de6, 0x0de9,
			0x0de9, 0x0de9, 0x0de9, 0x0de9, 0x0def, 0x0def, 0x0df4, 0x0dfa,
			0x0e00, 0x0e05, 0x0e0a, 0x0e0a, 0x0e0a, 0x0e10, 0x0e10, 0x0e14,
			// Entry 240 - 27F
			0x0e17, 0x0e1d, 0x0e24, 0x0e29, 0x0e29, 0x0e33, 0x0e3a, 0x0e46,
			0x0e46, 0x0e4c, 0x0e6b, 0x0e6f, 0x0e89, 0x0e8d, 0x0ea4, 0x0ea4,
			0x0eb5, 0x0eca, 0x0edc, 0x0eed, 0x0efb, 0x0f0e, 0x0f29, 0x0f3a,
			0x0f4d, 0x0f4d, 0x0f5e, 0x0f6f, 0x0f6f, 0x0f75, 0x0f8b, 0x0f9d,
			0x0fa6, 0x0fb3, 0x0fc0, 0x0fd6, 0x0fea,
		},
	},
	{ // ga
		"AfáirisAbcáisisAivéistisAfracáinisAcáinisAmáirisAragóinisAraibisAsaimisA" +
			"váirisAidhmirisAsarbaiseáinisBaiscírisBealarúisisBulgáirisBioslaimis" +
			"BeangáilisTibéidisBriotáinisBoisnisCatalóinisSeisnisSeamóirisCorsaic" +
			"isCraísSeicisSlavais na hEaglaiseSuvaisisBreatnaisDanmhairgisGearmái" +
			"nisDivéihisSeoinicisGréigisBéarlaEsperantoSpáinnisEastóinisBascaisPe" +
			"irsisFuláinisFionlainnisFidsisFaróisFraincisFreaslainnis IartharachG" +
			"aeilgeGaeilge na hAlbanGailísisGuaráinisGúisearáitisManainnisHásaisE" +
			"abhraisHiondúisMotúis HíríCróitisCriól HáítíochUngáirisAirméinisHeir" +
			"éirisInterlinguaIndinéisisInterlingueÍogbóisIniúipiaicisIdoÍoslainn" +
			"isIodáilisIonúitisSeapáinisIáivisSeoirsisCongóisCiocúisCuainiáimisCa" +
			"saicisKalaallisutCiméirisCannadaisCóiréisCanúirisCaismírisCoirdisCoi" +
			"misCoirnisCirgisisLaidinLucsambuirgisLugandaisLiongáilisLaoisisLiotu" +
			"áinisLúba-CataingisLaitvisMalagáisisMairsillisMaoraisMacadóinisMail" +
			"éalaimisMongóilisMaraitisMalaeisMáltaisBurmaisNárúisNdeibéilis an T" +
			"uaiscirtNeipeailisNdongaisOllainnisNua-IoruaisIoruais BokmålNdeibéil" +
			"is an DeiscirtNavachóisSiséivisOcsatáinisÓisibisOraimisOirísisOiséit" +
			"isPuinseáibisPáilisPolainnisPaistisPortaingéilisCeatsuaisRómainisRúi" +
			"ndisRómáinisRúisisCiniaruaindisSanscraitSairdínisSindisSáimis Thuaid" +
			"hSangóisSiolóinisSlóvaicisSlóivéinisSamóisSeoinisSomáilisAlbáinisSei" +
			"rbisSuaisisSeasóitisSundaisSualainnisSvahaílisTamailisTeileagúisTáid" +
			"sícisTéalainnisTigrinisTuircméinisSuáinisTongaisTuircisSongaisTatair" +
			"isTaihítisUigiúirisÚcráinisUrdúisÚisbéiceastáinisVeindisVítneaimisVo" +
			"lapükVallúnaisVolaifisCóisisGiúdaisIarúibisSiuáingisSínisSúlúisAdaig" +
			"éisAidhniúisAcáidisSean-BhéarlaAramaisMapúitsisAstúirisBailísBaváir" +
			"isBeimbisBuiriáitisBuiginisSeabúáinisMairisSeiricisCoptaisCaisiúibis" +
			"TaitaZarmaisSorbais ÍochtarachMeán-OllainnisSean-ÉigiptisMeán-Bhéarl" +
			"aFilipínisMeán-FhraincisSean-FhraincisFreaslainnis an TuaiscirtFriúi" +
			"lisAetóipisMeán-Ard-GhearmáinisSean-Ard-GhearmáinisSean-GhréigisGear" +
			"máinis EilvéiseachUaúisHaicéisHaváisHiondúis FhidsíHilgeanóinisHitis" +
			"MongaisSorbais UachtarachHúipisIbibisIongúisLojbanIútlainnisCara-Cha" +
			"lpáisConcáinisCairéilisCurúicisLaidínisPuinseáibis IartharachLiogúir" +
			"isLiovóinisLombairdisMeindisMeán-GhaeilgeManapúirisMóháicisMairis Ia" +
			"rtharachIlteangachaMioraindéisMarmhairisGearmáinis ÍochtarachNíobhai" +
			"sSean-LochlainnisSútúis an TuaiscirtSean-PheirsisPrúisisCuitséisRoma" +
			"inisArómáinisSachaisAramais ShamárachSantáilisSicilisAlbainisSean-Gh" +
			"aeilgeTachelhitSáimis LuleSogdánaisSuiméirisSiricisSiléisisKlingonUd" +
			"mairtisTeanga AnaithnidVeinéisisPléimeannais IartharachCailmícisCant" +
			"ainisSéalainnisZúinisGan ábhar teangeolaíochAraibis ChaighdeánachGea" +
			"rmáinis OstarachArd-Ghearmáinis EilvéiseachBéarla AstrálachBéarla Ce" +
			"anadachBéarla BriotanachBéarla MeiriceánachSpáinnis Mheiriceá Laidin" +
			"ighSpáinnis EorpachSpáinnis MheicsiceachFraincis CheanadachFraincis " +
			"EilvéiseachSacsainis ÍochtarachPléimeannaisPortaingéilis na Brasaíle" +
			"Portaingéilis IbéarachMoldáivisSeirbea-ChróitisSvahaílis an ChongóSí" +
			"nis ShimplitheSínis Thraidisiúnta",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0008, 0x0011, 0x001b, 0x0026, 0x002e, 0x0036, 0x0040,
			0x0047, 0x004e, 0x0056, 0x005f, 0x006e, 0x0078, 0x0084, 0x008e,
			0x0098, 0x0098, 0x00a3, 0x00ac, 0x00b7, 0x00be, 0x00c9, 0x00d0,
			0x00da, 0x00e3, 0x00e9, 0x00ef, 0x0103, 0x010b, 0x0114, 0x011f,
			0x012a, 0x0133, 0x013c, 0x013c, 0x0144, 0x014b, 0x0154, 0x015d,
			0x0167, 0x016e, 0x0175, 0x017e, 0x0189, 0x018f, 0x0196, 0x019e,
			0x01b5, 0x01bc, 0x01cd, 0x01d6, 0x01e0, 0x01ee, 0x01f7, 0x01fe,
			0x0206, 0x020f, 0x021d, 0x0225, 0x0237, 0x0240, 0x024a, 0x0254,
			// Entry 40 - 7F
			0x025f, 0x026a, 0x0275, 0x027e, 0x027e, 0x028b, 0x028e, 0x0299,
			0x02a2, 0x02ab, 0x02b5, 0x02bc, 0x02c4, 0x02cc, 0x02d4, 0x02e0,
			0x02e8, 0x02f3, 0x02fc, 0x0305, 0x030e, 0x0317, 0x0321, 0x0328,
			0x032e, 0x0335, 0x033d, 0x0343, 0x0350, 0x0359, 0x0359, 0x0364,
			0x036b, 0x0376, 0x0385, 0x038c, 0x0397, 0x03a1, 0x03a8, 0x03b3,
			0x03c0, 0x03ca, 0x03d2, 0x03d9, 0x03e1, 0x03e8, 0x03f0, 0x0408,
			0x0412, 0x041a, 0x0423, 0x042e, 0x043d, 0x0454, 0x045e, 0x0467,
			0x0472, 0x047a, 0x0481, 0x0489, 0x0492, 0x049e, 0x04a5, 0x04ae,
			// Entry 80 - BF
			0x04b5, 0x04c3, 0x04cc, 0x04d5, 0x04dd, 0x04e7, 0x04ee, 0x04fb,
			0x0504, 0x050e, 0x0514, 0x0523, 0x052b, 0x0535, 0x053f, 0x054b,
			0x0552, 0x0559, 0x0562, 0x056b, 0x0572, 0x0579, 0x0583, 0x058a,
			0x0594, 0x059e, 0x05a6, 0x05b1, 0x05bc, 0x05c7, 0x05cf, 0x05db,
			0x05e3, 0x05ea, 0x05f1, 0x05f8, 0x0600, 0x0609, 0x0613, 0x061d,
			0x0624, 0x0637, 0x063e, 0x0649, 0x0651, 0x065b, 0x0663, 0x066a,
			0x0672, 0x067b, 0x0685, 0x068b, 0x0693, 0x0693, 0x0693, 0x0693,
			0x069c, 0x069c, 0x069c, 0x069c, 0x06a6, 0x06ae, 0x06ae, 0x06ae,
			// Entry C0 - FF
			0x06ae, 0x06ae, 0x06bb, 0x06bb, 0x06c2, 0x06cc, 0x06cc, 0x06cc,
			0x06cc, 0x06cc, 0x06cc, 0x06cc, 0x06cc, 0x06cc, 0x06cc, 0x06d5,
			0x06d5, 0x06d5, 0x06d5, 0x06dc, 0x06e5, 0x06e5, 0x06e5, 0x06e5,
			0x06e5, 0x06e5, 0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec,
			0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06ec,
			0x06ec, 0x06ec, 0x06ec, 0x06ec, 0x06f7, 0x06ff, 0x06ff, 0x06ff,
			0x06ff, 0x06ff, 0x06ff, 0x06ff, 0x06ff, 0x070b, 0x070b, 0x070b,
			0x070b, 0x070b, 0x0711, 0x0711, 0x0711, 0x0711, 0x0719, 0x0719,
			// Entry 100 - 13F
			0x0719, 0x0720, 0x0720, 0x0720, 0x0720, 0x072b, 0x072b, 0x072b,
			0x0730, 0x0730, 0x0730, 0x0730, 0x0730, 0x0737, 0x0737, 0x074a,
			0x074a, 0x074a, 0x0759, 0x0759, 0x0759, 0x0759, 0x0759, 0x0759,
			0x0759, 0x0767, 0x0767, 0x0767, 0x0775, 0x0775, 0x0775, 0x0775,
			0x0775, 0x077f, 0x077f, 0x077f, 0x077f, 0x078e, 0x079c, 0x079c,
			0x07b5, 0x07b5, 0x07be, 0x07be, 0x07be, 0x07be, 0x07be, 0x07be,
			0x07be, 0x07c7, 0x07c7, 0x07c7, 0x07dd, 0x07f2, 0x07f2, 0x07f2,
			0x07f2, 0x07f2, 0x07f2, 0x0800, 0x0818, 0x081e, 0x081e, 0x081e,
			// Entry 140 - 17F
			0x081e, 0x081e, 0x0826, 0x082d, 0x083e, 0x084b, 0x0850, 0x0857,
			0x0869, 0x0869, 0x0870, 0x0870, 0x0876, 0x0876, 0x087e, 0x087e,
			0x087e, 0x0884, 0x0884, 0x0884, 0x0884, 0x0884, 0x088f, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d,
			0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x089d, 0x08a7, 0x08a7,
			0x08a7, 0x08a7, 0x08a7, 0x08a7, 0x08b1, 0x08ba, 0x08ba, 0x08ba,
			0x08ba, 0x08ba, 0x08ba, 0x08c3, 0x08c3, 0x08da, 0x08da, 0x08da,
			// Entry 180 - 1BF
			0x08da, 0x08e4, 0x08ee, 0x08ee, 0x08f8, 0x08f8, 0x08f8, 0x08f8,
			0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8,
			0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8, 0x08f8,
			0x08f8, 0x08f8, 0x08f8, 0x08ff, 0x08ff, 0x08ff, 0x090d, 0x090d,
			0x090d, 0x090d, 0x090d, 0x090d, 0x0918, 0x0922, 0x0922, 0x0933,
			0x0933, 0x093e, 0x093e, 0x094a, 0x0954, 0x0954, 0x0954, 0x0954,
			0x0954, 0x0954, 0x0954, 0x0954, 0x096b, 0x096b, 0x096b, 0x0974,
			0x0974, 0x0974, 0x0974, 0x0974, 0x0984, 0x0984, 0x0984, 0x0999,
			// Entry 1C0 - 1FF
			0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999,
			0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999, 0x0999,
			0x0999, 0x09a6, 0x09a6, 0x09a6, 0x09a6, 0x09a6, 0x09a6, 0x09ae,
			0x09ae, 0x09b7, 0x09b7, 0x09b7, 0x09b7, 0x09b7, 0x09b7, 0x09b7,
			0x09b7, 0x09bf, 0x09bf, 0x09bf, 0x09bf, 0x09ca, 0x09ca, 0x09ca,
			0x09d1, 0x09e3, 0x09e3, 0x09e3, 0x09ed, 0x09ed, 0x09ed, 0x09ed,
			0x09f4, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x09fc,
			0x09fc, 0x0a09, 0x0a09, 0x0a12, 0x0a12, 0x0a12, 0x0a12, 0x0a12,
			// Entry 200 - 23F
			0x0a12, 0x0a12, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a1e, 0x0a28, 0x0a28,
			0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a32, 0x0a32, 0x0a32,
			0x0a39, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42,
			0x0a42, 0x0a42, 0x0a42, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49,
			0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49, 0x0a49,
			0x0a49, 0x0a49, 0x0a49, 0x0a52, 0x0a52, 0x0a52, 0x0a62, 0x0a62,
			0x0a6c, 0x0a6c, 0x0a84, 0x0a84, 0x0a84, 0x0a84, 0x0a84, 0x0a84,
			0x0a84, 0x0a84, 0x0a84, 0x0a84, 0x0a84, 0x0a8e, 0x0a8e, 0x0a8e,
			// Entry 240 - 27F
			0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a97, 0x0a97, 0x0a97,
			0x0aa2, 0x0aa2, 0x0aa2, 0x0aa9, 0x0ac2, 0x0ac2, 0x0ad8, 0x0ad8,
			0x0aec, 0x0b09, 0x0b1b, 0x0b2c, 0x0b3e, 0x0b53, 0x0b71, 0x0b82,
			0x0b98, 0x0b98, 0x0bab, 0x0bc0, 0x0bd5, 0x0be2, 0x0bfd, 0x0c15,
			0x0c1f, 0x0c30, 0x0c45, 0x0c56, 0x0c6b,
		},
	},
	{ // gd
		"AfarAbchasaisAvestanaisAfraganaisAkanAmtharaisAragonaisArabaisAsamaisAva" +
			"raisAymaraAsarbaideànaisBashkirBealaruisisBulgaraisBislamaBambaraBan" +
			"glaTibeitisBreatnaisBosnaisCatalanaisDeideanaisChamorroCorsaisCreeSe" +
			"icisSlàbhais na h-EaglaiseChuvashCuimrisDanmhairgisGearmailtisDivehi" +
			"DzongkhaEweGreugaisBeurlaEsperantoSpàinntisEastoinisBasgaisPeirsisFu" +
			"lahFionnlannaisFìdisFàrothaisFraingisFrìoslannais ShiarachGaeilgeGài" +
			"dhligGailìsisGuaraníGujaratiGaelgHausaEabhraHindisHiri MotuCròthaisi" +
			"sCrìtheol HaidhtiUngairisAirmeinisHereroInterlinguaInnd-InnsisInterl" +
			"ingueIgboYi SichuanInupiaqIdoInnis TìlisEadailtisInuktitutSeapanaisD" +
			"eàbhanaisCairtbheilisKongoKikuyuKuanyamaCasachaisKalaallisutCmèarKan" +
			"nadaCoirèanaisKanuriCaismirisCùrdaisKomiCòrnaisCìorgasaisLaideannLug" +
			"samburgaisGandaCànan LimburgLingalaLàthoLiotuainisLuba-KatangaLaitbh" +
			"eisMalagasaisMarshallaisMāoriMasadonaisMalayalamMongolaisMarathiMala" +
			"idhisMaltaisBurmaisNabhruNdebele ThuathachNeapàlaisNdongaDuitsisNyno" +
			"rsk na NirribhidhBokmål na NirribhidhNdebele DheasachNavajoNyanjaOgs" +
			"atanaisOjibwaOromoOdiaOsseticPanjabiPaliPòlainnisPashtoPortagailisQu" +
			"echuaRumainsKirundiRomàinisRuisisKinyarwandaSanskritSàrdaisSindhiSàm" +
			"ais ThuathachSangoSinhalaSlòbhacaisSlòbhainisSamothaisShonaSomàilisA" +
			"lbàinisSèirbisSwatiSesothoCànan SundaSuainisKiswahiliTaimilisTeluguT" +
			"aidigisCànan nan TàidhTigrinyaTurcmanaisTswanaTongaTurcaisTsongaTata" +
			"raisCànan TahitiÙigiuraisUcràinisÙrduUsbagaisVendaBhiet-NamaisVolapü" +
			"kWalloonWolofXhosaIùdhaisYorubaZhuangSìnisZuluBasa AcèhAcoliAdangmeA" +
			"dygheArabais ThuiniseachAfrihiliAghemAinuAcadaisAlabamaAleutaisAlbài" +
			"nis GhegeachAltais DheasachSeann-BheurlaAngikaAramaisMapudungunAraon" +
			"aArapahoArabais AildireachArawakArabais MhorocachArabais Èipheiteach" +
			"AsuCainnt-shanais na h-AimeireagaAstùraisKotavaAwadhiBaluchìCànan Ba" +
			"liBasaaBamunBatak TobaGhomalaBejaBembaBetawiBenaBafutBadagaBalochi S" +
			"hiarachBhojpuriBikolBiniBanjarKomSiksikaBishnupriyaBakhtiariBrajBrah" +
			"uiBodoAkooseBuriatCànan nam BugisBuluBlinMedumbaCaddoCaribCayugaAtsa" +
			"mCebuanoChigaChibchaChagataiCànan ChuukMariChinuk WawaChoctawChipewy" +
			"anCherokeeCheyenneCùrdais MheadhanachCoptaisCapiznonTurcais Chriomac" +
			"hSeiseallaisCaisiubaisDakotaDargwaTaitaDelawareSlaveyDogribDinkaZarm" +
			"aDogriSòrbais ÌochdarachDusun MheadhanachDualaMeadhan-DhuitsisJola-F" +
			"onyiDyulaDazagaEmbuEfikÈipheitis ÀrsaidhEkajukElamaisMeadhan-Bheurla" +
			"Yupik MheadhanachEwondoCànan na h-ExtremaduraFangFilipinisMeänkieliF" +
			"onFraingis nan CajunMeadhan-FhraingisSeann-FhraingisArpitanFrìoslann" +
			"ais ThuathachFrìoslannais EarachFriùilisGaGagauzGanGayoGbayaDari Zor" +
			"oastrachGe’ezCiribeasaisGilakiMeadhan-Àrd-GearmailtisSeann-Àrd-Gearm" +
			"ailtisKonkani GoaGondiGorontaloGotaisGreboGreugais ÀrsaidhGearmailti" +
			"s EilbheiseachWayuuFrafraGusiiGwichʼinHaidaHakkaCànan Hawai’iHindis " +
			"FhìditheachHiligaynonCànan HetHmongSòrbais UachdarachXiangHupaIbanIb" +
			"ibioIlokoIngushBeurla Crìtheolach DiameugaLojbanNgombaMachamePeirsis" +
			" IùdhachArabais IùdhachKara-KalpakKabyleKachinJjuKambaKawiCabardaisK" +
			"anembuTyapMakondeKabuverdianuKenyangKoroKaingangKhasiCànan KhotanKoy" +
			"ra ChiiniKhowarKirmanjkiKakoKalenjinKimbunduKomi-PermyakKonkaniKpell" +
			"eKarachay-BalkarKrioKinaray-aCairealaisKurukhShambalaBafiaGearmailti" +
			"s ChologneKumykKutenaiLadinoLangiLahndaLambaLeasgaisLingua Franca No" +
			"vaLiogùraisLakhótaLombardaisMongoLoziLuri ThuathachLuba-LuluaLuiseño" +
			"LundaLuoMizoLuyiaSìnis an LitreachaisLazCànan MadhuraMafaMagahiMaith" +
			"iliMakasarMandingoMaasaiMabaMokshaMandarMendeMeruMorisyenMeadhan-Gha" +
			"eilgeMakhuwa-MeettoMeta’Mi’kmaqMinangkabauManchuManipuriMohawkMossiM" +
			"ari ShiarachMundangIomadh cànanCreekMiorandaisMarwariMentawaiMyeneEr" +
			"zyaMazanderaniMin NanEadailtis NapoliNamaGearmailtis ÌochdarachNewar" +
			"iNiasCànan NiueAo NagaKwasioNgiemboonNogaiSeann-LochlannaisNovialN’K" +
			"oSesotho sa LeboaNuerNewari ChlasaigeachNyamweziNyankoleNyoroNzimaOs" +
			"ageTurcais OtomanachPangasinanPahlaviPampangaPapiamentuPalabhaisPica" +
			"rdBeurla NigèiriachGearmailtis PhennsylvaniaPlautdietschSeann-Pheirs" +
			"isPhenicisPiedmonteseCànan PohnpeiPruisisSeann-PhrovençalK’iche’Quic" +
			"hua Àrd-tìr ChimborazoRajasthaniRapa NuiCànan RarotongaRomagnolRombo" +
			"RomanaisRusynRovianaAromanaisRwaSandaweSakhaAramais ShamaritanachSam" +
			"buruSasakSantaliSaurashtraNgambaySanguSisilisAlbaisSassareseCùrdais " +
			"DheasachSenecaSenaSeriSelkupKoyraboro SenniSeann-GhaeilgeTachelhitSh" +
			"anArabais SeàdachSidamoSelayarSàmais DheasachSàmais LuleSàmais Inari" +
			"Sàmais SkoltSoninkeSranan TongoSererSahoSukumaSusuCànan SumerComorai" +
			"sSuraidheac ChlasaigeachSuraidheacTuluTimneTesoTerênaTetumTigreTivTo" +
			"kelauTsakhurKlingonTlingitTalyshTamashekNyasa TongaTok PisinTuroyoTa" +
			"rokoTsimshianTatiTumbukaTubhaluTasawaqCànan TuvaTamazight an Atlais " +
			"MheadhanaichUdmurtUmbunduRootVaiVepsFlannrais SiarachVõroVunjoGearma" +
			"iltis WallisWolayttaWarayWashoWarlpiriWuKalmykSogaYaoCànan YapYangbe" +
			"nYembaNheengatuCantonaisZapotecComharran BlissCànan ZeelandZenagaTam" +
			"azight Stannardach MorocoZuñiSusbaint nach eil ’na chànanZazakiNuadh" +
			"-Arabais StannardachGearmailtis na h-OstaireÀrd-Ghearmailtis na h-Ei" +
			"lbheiseBeurla AstràiliaBeurla ChanadaBeurla BhreatainnBeurla na h-Ai" +
			"meireagaSpàinntis na h-Aimeireaga LaidinneachSpàinntis EòrpachSpàinn" +
			"tis MheagsagachFraingis ChanadaFraingis EilbheiseachSagsannais Ìochd" +
			"arachFlannraisPortagailis BhraisileachPortagailis EòrpachMoldobhaisS" +
			"èirb-ChròthaisisKiswahili na CongoSìnis ShimplichteSìnis Thradaisea" +
			"nta",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0017, 0x0021, 0x0025, 0x002e, 0x0037,
			0x003e, 0x0045, 0x004c, 0x0052, 0x0061, 0x0068, 0x0073, 0x007c,
			0x0083, 0x008a, 0x0090, 0x0098, 0x00a1, 0x00a8, 0x00b2, 0x00bc,
			0x00c4, 0x00cb, 0x00cf, 0x00d5, 0x00ec, 0x00f3, 0x00fa, 0x0105,
			0x0110, 0x0116, 0x011e, 0x0121, 0x0129, 0x012f, 0x0138, 0x0142,
			0x014b, 0x0152, 0x0159, 0x015e, 0x016a, 0x0170, 0x017a, 0x0182,
			0x0198, 0x019f, 0x01a8, 0x01b1, 0x01b9, 0x01c1, 0x01c6, 0x01cb,
			0x01d1, 0x01d7, 0x01e0, 0x01eb, 0x01fc, 0x0204, 0x020d, 0x0213,
			// Entry 40 - 7F
			0x021e, 0x0229, 0x0234, 0x0238, 0x0242, 0x0249, 0x024c, 0x0258,
			0x0261, 0x026a, 0x0273, 0x027e, 0x028a, 0x028f, 0x0295, 0x029d,
			0x02a6, 0x02b1, 0x02b7, 0x02be, 0x02c9, 0x02cf, 0x02d8, 0x02e0,
			0x02e4, 0x02ec, 0x02f7, 0x02ff, 0x030c, 0x0311, 0x031f, 0x0326,
			0x032c, 0x0336, 0x0342, 0x034b, 0x0355, 0x0360, 0x0366, 0x0370,
			0x0379, 0x0382, 0x0389, 0x0392, 0x0399, 0x03a0, 0x03a6, 0x03b7,
			0x03c1, 0x03c7, 0x03ce, 0x03e3, 0x03f8, 0x0408, 0x040e, 0x0414,
			0x041e, 0x0424, 0x0429, 0x042d, 0x0434, 0x043b, 0x043f, 0x0449,
			// Entry 80 - BF
			0x044f, 0x045a, 0x0461, 0x0468, 0x046f, 0x0478, 0x047e, 0x0489,
			0x0491, 0x0499, 0x049f, 0x04b0, 0x04b5, 0x04bc, 0x04c7, 0x04d2,
			0x04db, 0x04e0, 0x04e9, 0x04f2, 0x04fa, 0x04ff, 0x0506, 0x0512,
			0x0519, 0x0522, 0x052a, 0x0530, 0x0538, 0x0549, 0x0551, 0x055b,
			0x0561, 0x0566, 0x056d, 0x0573, 0x057b, 0x0588, 0x0592, 0x059b,
			0x05a0, 0x05a8, 0x05ad, 0x05b9, 0x05c1, 0x05c8, 0x05cd, 0x05d2,
			0x05da, 0x05e0, 0x05e6, 0x05ec, 0x05f0, 0x05fa, 0x05ff, 0x0606,
			0x060c, 0x061f, 0x0627, 0x062c, 0x0630, 0x0637, 0x063e, 0x0646,
			// Entry C0 - FF
			0x0658, 0x0667, 0x0674, 0x067a, 0x0681, 0x068b, 0x0691, 0x0698,
			0x06aa, 0x06aa, 0x06b0, 0x06c1, 0x06d5, 0x06d8, 0x06f6, 0x06ff,
			0x0705, 0x070b, 0x0713, 0x071e, 0x071e, 0x0723, 0x0728, 0x0732,
			0x0739, 0x073d, 0x0742, 0x0748, 0x074c, 0x0751, 0x0757, 0x0767,
			0x076f, 0x0774, 0x0778, 0x077e, 0x0781, 0x0788, 0x0793, 0x079c,
			0x07a0, 0x07a6, 0x07aa, 0x07b0, 0x07b6, 0x07c6, 0x07ca, 0x07ce,
			0x07d5, 0x07da, 0x07df, 0x07e5, 0x07ea, 0x07f1, 0x07f6, 0x07fd,
			0x0805, 0x0811, 0x0815, 0x0820, 0x0827, 0x0830, 0x0838, 0x0840,
			// Entry 100 - 13F
			0x0854, 0x085b, 0x0863, 0x0874, 0x087f, 0x0889, 0x088f, 0x0895,
			0x089a, 0x08a2, 0x08a8, 0x08ae, 0x08b3, 0x08b8, 0x08bd, 0x08d1,
			0x08e2, 0x08e7, 0x08f7, 0x0901, 0x0906, 0x090c, 0x0910, 0x0914,
			0x0914, 0x0927, 0x092d, 0x0934, 0x0943, 0x0954, 0x095a, 0x0971,
			0x0975, 0x097e, 0x0988, 0x098b, 0x099d, 0x09ae, 0x09bd, 0x09c4,
			0x09db, 0x09ef, 0x09f8, 0x09fa, 0x0a00, 0x0a03, 0x0a07, 0x0a0c,
			0x0a1c, 0x0a23, 0x0a2e, 0x0a34, 0x0a4c, 0x0a62, 0x0a6d, 0x0a72,
			0x0a7b, 0x0a81, 0x0a86, 0x0a97, 0x0aaf, 0x0ab4, 0x0aba, 0x0abf,
			// Entry 140 - 17F
			0x0ac8, 0x0acd, 0x0ad2, 0x0ae2, 0x0af5, 0x0aff, 0x0b09, 0x0b0e,
			0x0b21, 0x0b26, 0x0b2a, 0x0b2e, 0x0b34, 0x0b39, 0x0b3f, 0x0b3f,
			0x0b5b, 0x0b61, 0x0b67, 0x0b6e, 0x0b7e, 0x0b8e, 0x0b8e, 0x0b99,
			0x0b9f, 0x0ba5, 0x0ba8, 0x0bad, 0x0bb1, 0x0bba, 0x0bc1, 0x0bc5,
			0x0bcc, 0x0bd8, 0x0bdf, 0x0be3, 0x0beb, 0x0bf0, 0x0bfd, 0x0c09,
			0x0c0f, 0x0c18, 0x0c1c, 0x0c24, 0x0c2c, 0x0c38, 0x0c3f, 0x0c3f,
			0x0c45, 0x0c54, 0x0c58, 0x0c61, 0x0c6b, 0x0c71, 0x0c79, 0x0c7e,
			0x0c92, 0x0c97, 0x0c9e, 0x0ca4, 0x0ca9, 0x0caf, 0x0cb4, 0x0cbc,
			// Entry 180 - 1BF
			0x0cce, 0x0cd8, 0x0cd8, 0x0ce0, 0x0cea, 0x0cef, 0x0cf3, 0x0d01,
			0x0d01, 0x0d0b, 0x0d13, 0x0d18, 0x0d1b, 0x0d1f, 0x0d24, 0x0d39,
			0x0d3c, 0x0d4a, 0x0d4e, 0x0d54, 0x0d5c, 0x0d63, 0x0d6b, 0x0d71,
			0x0d75, 0x0d7b, 0x0d81, 0x0d86, 0x0d8a, 0x0d92, 0x0da2, 0x0db0,
			0x0db7, 0x0dc0, 0x0dcb, 0x0dd1, 0x0dd9, 0x0ddf, 0x0de4, 0x0df1,
			0x0df8, 0x0e05, 0x0e0a, 0x0e14, 0x0e1b, 0x0e23, 0x0e28, 0x0e2d,
			0x0e38, 0x0e3f, 0x0e4f, 0x0e53, 0x0e6a, 0x0e70, 0x0e74, 0x0e7f,
			0x0e86, 0x0e8c, 0x0e95, 0x0e9a, 0x0eab, 0x0eb1, 0x0eb7, 0x0ec7,
			// Entry 1C0 - 1FF
			0x0ecb, 0x0ede, 0x0ee6, 0x0eee, 0x0ef3, 0x0ef8, 0x0efd, 0x0f0e,
			0x0f18, 0x0f1f, 0x0f27, 0x0f31, 0x0f3a, 0x0f40, 0x0f52, 0x0f6b,
			0x0f77, 0x0f85, 0x0f85, 0x0f8d, 0x0f98, 0x0f98, 0x0fa6, 0x0fad,
			0x0fbe, 0x0fc9, 0x0fe5, 0x0fef, 0x0ff7, 0x1007, 0x100f, 0x100f,
			0x1014, 0x101c, 0x101c, 0x1021, 0x1028, 0x1031, 0x1034, 0x103b,
			0x1040, 0x1055, 0x105c, 0x1061, 0x1068, 0x1072, 0x1079, 0x107e,
			0x1085, 0x108b, 0x1094, 0x10a5, 0x10ab, 0x10af, 0x10b3, 0x10b9,
			0x10c8, 0x10d6, 0x10d6, 0x10df, 0x10e3, 0x10f3, 0x10f9, 0x10f9,
			// Entry 200 - 23F
			0x1100, 0x1110, 0x111c, 0x1129, 0x1136, 0x113d, 0x113d, 0x1149,
			0x114e, 0x1152, 0x1152, 0x1158, 0x115c, 0x1168, 0x1170, 0x1187,
			0x1191, 0x1191, 0x1195, 0x119a, 0x119e, 0x11a5, 0x11aa, 0x11af,
			0x11b2, 0x11b9, 0x11c0, 0x11c7, 0x11ce, 0x11d4, 0x11dc, 0x11e7,
			0x11f0, 0x11f6, 0x11fc, 0x11fc, 0x1205, 0x1209, 0x1210, 0x1217,
			0x121e, 0x1229, 0x1249, 0x124f, 0x124f, 0x1256, 0x125a, 0x125d,
			0x125d, 0x1261, 0x1272, 0x1272, 0x1272, 0x1277, 0x127c, 0x128e,
			0x1296, 0x129b, 0x12a0, 0x12a8, 0x12aa, 0x12b0, 0x12b0, 0x12b4,
			// Entry 240 - 27F
			0x12b7, 0x12c1, 0x12c8, 0x12cd, 0x12d6, 0x12df, 0x12e6, 0x12f5,
			0x1303, 0x1309, 0x1325, 0x132a, 0x1349, 0x134f, 0x1368, 0x1368,
			0x1380, 0x13a0, 0x13b1, 0x13bf, 0x13d0, 0x13e6, 0x140c, 0x141f,
			0x1435, 0x1435, 0x1445, 0x145a, 0x1470, 0x1479, 0x1491, 0x14a5,
			0x14af, 0x14c2, 0x14d4, 0x14e6, 0x14fa,
		},
	},
	{ // gl
		"afarabkhazoafricánerakánamáricoaragonésárabeasamésavaraimaráacerbaixanob" +
			"askirbielorrusobúlgarobislamabambarobengalítibetanobretónbosníacocat" +
			"alánchechenochamorrocorsochecoeslavo eclesiásticochuvashgalésdinamar" +
			"quésalemándivehidzongkhaewegregoinglésesperantoespañolestonianoéusca" +
			"ropersafulafinésfidxianoferoésfrancésfrisónirlandésgaélico escocésga" +
			"legoguaraníguxaratímanxhausahebreohindicroatahaitianohúngaroarmenioh" +
			"ererointerlinguaindonesioiboyi sichuanésidoislandésitalianoinuktitut" +
			"xaponésxavanésxeorxianokongokikuyukuanyamacasacogroenlandés occident" +
			"alkhmercanaréscoreanocanuricachemirkurdokomicórnicoquirguizlatínluxe" +
			"mburguésgandalimburguéslingalalaosianolituanoluba-katangaletónmalgax" +
			"emarshalésmaorímacedoniomalabarmongolmarathimalaiomaltésbirmanonauru" +
			"ndebele do nortenepalíndongaholandésnoruegués nynorsknoruegués bokma" +
			"lndebele do surnavajochewaoccitanooromooriyaosetiopanxabianopolacopa" +
			"shtuportuguésquechuaromancherundiromanésrusoruandéssánscritosardosin" +
			"dhisaami do nortesangocingaléseslovacoeslovenosamoanoshonasomalíalba" +
			"nésserbioswatisesothosundanéssuecosuahilitámiltelugútaxicotailandést" +
			"igriñaturcomántswanatonganésturcotsongatártarotahitianouigurucraínou" +
			"rdúuzbecovendavietnamitavolapukvalónwólofxhosayiddishyorubachinészul" +
			"úachinésacholíadangmeadigueoaghemainualeutianoaltai meridionalangik" +
			"aarameomapuchearapahoeasuasturianoawadhibalinésbasaabembabenabaluchi" +
			" occidentalbhojpuribinisiksikábodobuginésblincebuanokigachuukesemari" +
			"choctawcheroquicheiénkurdo soraníseselwa (crioulo das Seixeles)dakot" +
			"adargwataitadogribzarmabaixo sorabiodualajola-fonyidazagaembuefikexi" +
			"pcio antigoekajukewondofilipinofonfriulianogagagauzge’ezkiribatianog" +
			"orontalogrego antigoalemán suízogusiigwichʼinhawaianohiligaynonhmong" +
			"alto sorbiohupaibanibibioilokoingushlojbanngombamachamekabilekachinj" +
			"jukambacabardianotyapmakondecaboverdianokorokhasikoyra chiinikakokal" +
			"enjinkimbundukomi permiokonkanikpellecarachaio-bálcaracareliokurukhs" +
			"hambalabafiakölschkumykladinolangilezguilakotaloziluri do norteluba-" +
			"lulualundaluomizoluyiamadurésmagahimaithilimakasarmasaimokshamendeme" +
			"rucrioulo mauricianomakhuwa-meettometa’micmacminangkabaumanipurimoha" +
			"wkmossimundangvarias linguascreekmirandéserzyamazandaranínapolitanon" +
			"amabaixo alemánnewariniasniuanokwasiongiemboonnogain’kosesotho sa le" +
			"boanuernyankolepangasinanpampangapapiamentopalauanopidgin nixerianop" +
			"rusianoquichérapanuirarotonganoromboaromanésrwasandawesakhasamburusa" +
			"ntalingambaysangusicilianoescocéskurdo meridionalsenakoyraboro senni" +
			"tachelhitshansaami meridionalsaami de Lulesaami de Inarisaami de Sko" +
			"ltsoninkesranan tongosahosukumacomorianosiríacotimnetesotetuntigrékl" +
			"ingontok pisintarokotumbukatuvaluanotasawaqtuvanianotamazight do Mar" +
			"rocos Centraludmurtoumbunduraízvaivunjowalserwolayttawaray-waraywalr" +
			"piricalmucosogayangbenyembacantonéstamazight de Marrocos estándarzun" +
			"isen contido lingüísticozazakiárabe estándar modernoalemán austríaco" +
			"alto alemán suízoinglés australianoinglés canadianoinglés británicoi" +
			"nglés dos Estados Unidosespañol latinoamericanocastelánespañol de Mé" +
			"xicofrancés canadianofrancés suízobaixo saxónflamencoportugués brasi" +
			"leiroportugués europeomoldavoserbocroatasuahili congoléschinés simpl" +
			"ificadochinés tradicional",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000b, 0x000b, 0x0015, 0x001a, 0x0022, 0x002b,
			0x0031, 0x0038, 0x003c, 0x0043, 0x004e, 0x0054, 0x005e, 0x0066,
			0x006d, 0x0074, 0x007c, 0x0084, 0x008b, 0x0094, 0x009c, 0x00a4,
			0x00ac, 0x00b1, 0x00b1, 0x00b6, 0x00ca, 0x00d1, 0x00d7, 0x00e3,
			0x00ea, 0x00f0, 0x00f8, 0x00fb, 0x0100, 0x0107, 0x0110, 0x0118,
			0x0121, 0x0129, 0x012e, 0x0132, 0x0138, 0x0140, 0x0147, 0x014f,
			0x0156, 0x015f, 0x0170, 0x0176, 0x017e, 0x0187, 0x018b, 0x0190,
			0x0196, 0x019b, 0x019b, 0x01a1, 0x01a9, 0x01b1, 0x01b8, 0x01be,
			// Entry 40 - 7F
			0x01c9, 0x01d2, 0x01d2, 0x01d5, 0x01e2, 0x01e2, 0x01e5, 0x01ee,
			0x01f6, 0x01ff, 0x0207, 0x020f, 0x0218, 0x021d, 0x0223, 0x022b,
			0x0231, 0x0248, 0x024d, 0x0255, 0x025c, 0x0262, 0x026a, 0x026f,
			0x0273, 0x027b, 0x0283, 0x0289, 0x0296, 0x029b, 0x02a6, 0x02ad,
			0x02b5, 0x02bc, 0x02c8, 0x02ce, 0x02d5, 0x02df, 0x02e5, 0x02ee,
			0x02f5, 0x02fb, 0x0302, 0x0308, 0x030f, 0x0316, 0x031b, 0x032b,
			0x0332, 0x0338, 0x0341, 0x0353, 0x0364, 0x0372, 0x0378, 0x037d,
			0x0385, 0x0385, 0x038a, 0x038f, 0x0395, 0x039f, 0x039f, 0x03a5,
			// Entry 80 - BF
			0x03ab, 0x03b5, 0x03bc, 0x03c4, 0x03c9, 0x03d1, 0x03d5, 0x03dd,
			0x03e7, 0x03ec, 0x03f2, 0x0400, 0x0405, 0x040e, 0x0416, 0x041e,
			0x0425, 0x042a, 0x0431, 0x0439, 0x043f, 0x0444, 0x044b, 0x0454,
			0x0459, 0x0460, 0x0466, 0x046d, 0x0473, 0x047d, 0x0485, 0x048e,
			0x0494, 0x049d, 0x04a2, 0x04a8, 0x04b0, 0x04b9, 0x04be, 0x04c6,
			0x04cb, 0x04d1, 0x04d6, 0x04e0, 0x04e7, 0x04ed, 0x04f3, 0x04f8,
			0x04ff, 0x0505, 0x0505, 0x050c, 0x0511, 0x0519, 0x0520, 0x0527,
			0x052e, 0x052e, 0x052e, 0x0533, 0x0537, 0x0537, 0x0537, 0x0540,
			// Entry C0 - FF
			0x0540, 0x0550, 0x0550, 0x0556, 0x055c, 0x0563, 0x0563, 0x056b,
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056e, 0x056e, 0x0577,
			0x0577, 0x057d, 0x057d, 0x0585, 0x0585, 0x058a, 0x058a, 0x058a,
			0x058a, 0x058a, 0x058f, 0x058f, 0x0593, 0x0593, 0x0593, 0x05a5,
			0x05ad, 0x05ad, 0x05b1, 0x05b1, 0x05b1, 0x05b9, 0x05b9, 0x05b9,
			0x05b9, 0x05b9, 0x05bd, 0x05bd, 0x05bd, 0x05c5, 0x05c5, 0x05c9,
			0x05c9, 0x05c9, 0x05c9, 0x05c9, 0x05c9, 0x05d0, 0x05d4, 0x05d4,
			0x05d4, 0x05dc, 0x05e0, 0x05e0, 0x05e7, 0x05e7, 0x05ef, 0x05f6,
			// Entry 100 - 13F
			0x0603, 0x0603, 0x0603, 0x0603, 0x0621, 0x0621, 0x0627, 0x062d,
			0x0632, 0x0632, 0x0632, 0x0638, 0x0638, 0x063d, 0x063d, 0x064a,
			0x064a, 0x064f, 0x064f, 0x0659, 0x0659, 0x065f, 0x0663, 0x0667,
			0x0667, 0x0675, 0x067b, 0x067b, 0x067b, 0x067b, 0x0681, 0x0681,
			0x0681, 0x0689, 0x0689, 0x068c, 0x068c, 0x068c, 0x068c, 0x068c,
			0x068c, 0x068c, 0x0695, 0x0697, 0x069d, 0x069d, 0x069d, 0x069d,
			0x069d, 0x06a4, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af,
			0x06b8, 0x06b8, 0x06b8, 0x06c4, 0x06d2, 0x06d2, 0x06d2, 0x06d7,
			// Entry 140 - 17F
			0x06e0, 0x06e0, 0x06e0, 0x06e8, 0x06e8, 0x06f2, 0x06f2, 0x06f7,
			0x0702, 0x0702, 0x0706, 0x070a, 0x0710, 0x0715, 0x071b, 0x071b,
			0x071b, 0x0721, 0x0727, 0x072e, 0x072e, 0x072e, 0x072e, 0x072e,
			0x0734, 0x073a, 0x073d, 0x0742, 0x0742, 0x074c, 0x074c, 0x0750,
			0x0757, 0x0763, 0x0763, 0x0767, 0x0767, 0x076c, 0x076c, 0x0778,
			0x0778, 0x0778, 0x077c, 0x0784, 0x078c, 0x0797, 0x079e, 0x079e,
			0x07a4, 0x07b6, 0x07b6, 0x07b6, 0x07bd, 0x07c3, 0x07cb, 0x07d0,
			0x07d7, 0x07dc, 0x07dc, 0x07e2, 0x07e7, 0x07e7, 0x07e7, 0x07ed,
			// Entry 180 - 1BF
			0x07ed, 0x07ed, 0x07ed, 0x07f3, 0x07f3, 0x07f3, 0x07f7, 0x0804,
			0x0804, 0x080e, 0x080e, 0x0813, 0x0816, 0x081a, 0x081f, 0x081f,
			0x081f, 0x0827, 0x0827, 0x082d, 0x0835, 0x083c, 0x083c, 0x0841,
			0x0841, 0x0847, 0x0847, 0x084c, 0x0850, 0x0862, 0x0862, 0x0870,
			0x0877, 0x087d, 0x0888, 0x0888, 0x0890, 0x0896, 0x089b, 0x089b,
			0x08a2, 0x08b0, 0x08b5, 0x08be, 0x08be, 0x08be, 0x08be, 0x08c3,
			0x08cf, 0x08cf, 0x08d9, 0x08dd, 0x08ea, 0x08f0, 0x08f4, 0x08fa,
			0x08fa, 0x0900, 0x0909, 0x090e, 0x090e, 0x090e, 0x0914, 0x0924,
			// Entry 1C0 - 1FF
			0x0928, 0x0928, 0x0928, 0x0930, 0x0930, 0x0930, 0x0930, 0x0930,
			0x093a, 0x093a, 0x0942, 0x094c, 0x0954, 0x0954, 0x0964, 0x0964,
			0x0964, 0x0964, 0x0964, 0x0964, 0x0964, 0x0964, 0x0964, 0x096c,
			0x096c, 0x0973, 0x0973, 0x0973, 0x097a, 0x0985, 0x0985, 0x0985,
			0x098a, 0x098a, 0x098a, 0x098a, 0x098a, 0x0993, 0x0996, 0x099d,
			0x09a2, 0x09a2, 0x09a9, 0x09a9, 0x09b0, 0x09b0, 0x09b7, 0x09bc,
			0x09c5, 0x09cd, 0x09cd, 0x09dd, 0x09dd, 0x09e1, 0x09e1, 0x09e1,
			0x09f0, 0x09f0, 0x09f0, 0x09f9, 0x09fd, 0x09fd, 0x09fd, 0x09fd,
			// Entry 200 - 23F
			0x09fd, 0x0a0d, 0x0a1a, 0x0a28, 0x0a36, 0x0a3d, 0x0a3d, 0x0a49,
			0x0a49, 0x0a4d, 0x0a4d, 0x0a53, 0x0a53, 0x0a53, 0x0a5c, 0x0a5c,
			0x0a64, 0x0a64, 0x0a64, 0x0a69, 0x0a6d, 0x0a6d, 0x0a72, 0x0a78,
			0x0a78, 0x0a78, 0x0a78, 0x0a7f, 0x0a7f, 0x0a7f, 0x0a7f, 0x0a7f,
			0x0a88, 0x0a88, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a8e, 0x0a95, 0x0a9e,
			0x0aa5, 0x0aae, 0x0acb, 0x0ad2, 0x0ad2, 0x0ad9, 0x0ade, 0x0ae1,
			0x0ae1, 0x0ae1, 0x0ae1, 0x0ae1, 0x0ae1, 0x0ae1, 0x0ae6, 0x0aec,
			0x0af4, 0x0aff, 0x0aff, 0x0b07, 0x0b07, 0x0b0e, 0x0b0e, 0x0b12,
			// Entry 240 - 27F
			0x0b12, 0x0b12, 0x0b19, 0x0b1e, 0x0b1e, 0x0b27, 0x0b27, 0x0b27,
			0x0b27, 0x0b27, 0x0b46, 0x0b4a, 0x0b63, 0x0b69, 0x0b81, 0x0b81,
			0x0b93, 0x0ba6, 0x0bb9, 0x0bca, 0x0bdc, 0x0bf6, 0x0c0e, 0x0c17,
			0x0c2a, 0x0c2a, 0x0c3c, 0x0c4b, 0x0c57, 0x0c5f, 0x0c74, 0x0c86,
			0x0c8d, 0x0c98, 0x0ca9, 0x0cbd, 0x0cd0,
		},
	},
	{ // gsw
		"AfarAbchasischAvestischAfrikaansAkanAmharischAragonesischArabischAssames" +
			"ischAwarischAymaraAserbaidschanischBaschkirischWiissrussischBulgaari" +
			"schBislamaBambaraBengalischTibeetischBrötoonischBosnischKatalaanisch" +
			"TschetscheenischChamorroKorsischCreeTschechischChileslawischTschuwas" +
			"chischWalisischTänischTüütschMalediivischDschongkhaEweGriechischÄngl" +
			"ischEschperantoSchpanischEestnischBaskischPersischFulFinnischFidschi" +
			"anischFäröischFranzösischFriesischIirischSchottisch-GäälischGalizisc" +
			"hGuaraniGujaratiManx-GäälischHaussaHebräischHindiHiri-MotuKroazischH" +
			"aitischUngarischArmenischHereroInterlinguaIndonesischInterlingueIgbo" +
			"Sezuanischs YiInupiakIdoIisländischItaliänischInukitutJapanischJavan" +
			"ischGeorgischKongolesischKikuyu-SchpraachKwanyamaKasachischGröönländ" +
			"ischKambodschanischKannadaKoreaanischKanuri-SchpraachKaschmirischKur" +
			"dischKomi-SchpraachKornischKirgiisischLatiinLuxemburgischGanda-Schpr" +
			"aachLimburgischLingalaLaozischLitauischLubaLettischMadagassischMarsc" +
			"hallesischMaoriMazedonischMalayalamMongolischMarathiMalaiischMaltesi" +
			"schBirmanischNauruischNord-Ndebele-SchpraachNepalesischNdongaNiderlä" +
			"ndischNorwegisch NynorskNorwegisch BokmålSüüd-Ndebele-SchpraachNavaj" +
			"o-SchpraachChewa-SchpraachOkzitanischOjibwa-SchpraachOromoOrijaOssez" +
			"ischPandschabischPaliPolnischPaschtuPortugiisischQuechuaRätoromanisc" +
			"hRundi-SchpraachRumänischRussischRuandischSanschkritSardischSindhiNo" +
			"rd-SamischSangoSinghalesischSlowakischSlowenischSamoanischSchhonaSom" +
			"aliAlbanischSerbischSwaziSüüd-Sotho-SchpraachSundanesischSchwedischS" +
			"uaheliTamilischTeluguTadschikischThailändischTigrinjaTurkmenischTswa" +
			"na-SchpraachTongaischTürkischTsongaTatarischTahitischUigurischUkrain" +
			"ischUrduUsbekischVenda-SchpraachVietnamesischVolapükWallonischWolofX" +
			"hosaJiddischYorubaZhuangChineesischZuluAcehAcholiAdangmeAdygaiAfrihi" +
			"liAinuAkkadischAleutischSüüd-AltaischAltänglischAngikaAramääischArau" +
			"kanischArapahoArawakAschturianischAwadhiBelutschischBalinesischBasaa" +
			"BedauyeBembaBhodschpuriBikolischBiniBlackfoot-SchpraachBraj-BhakhaBu" +
			"rjatischBugineesischBlinCaddoKariibischAtsamCebuanoTschibtschaTschag" +
			"ataischTrukesischTscheremissischChinookChoctawChipewyanCherokeeCheye" +
			"nneKoptischKrimtatarischKaschubischTakotaTargiinischDelaware-Schpraa" +
			"chSlaveyTogribTinkaTogriNidersorbischTualaMittelniderländischTiulaEf" +
			"ikischAltägyptischEkajukElamischMittelänglischEwondoPangwe-Schpraach" +
			"FilipinoFonMittelfranzösischAltfranzösischNordfriesischOschtfriesisc" +
			"hFriulischGaGayoGbayaGeezGilbertesischMittelhochtüütschAlthochtüütsc" +
			"hGondiMongondouGotischGreboAltgriechischSchwiizertüütschKutchinischH" +
			"aidaHawaiianischHiligaynonischHethitischMiaoObersorbischHupaIbanisch" +
			"IlokanoInguschischLojbanischJüüdisch-PersischJüüdisch-ArabischKaraka" +
			"lpakischKabylischKachin-SchpraachJjuKambaKawiKabardinischTyapKoroKha" +
			"sischSakischKimbundu-SchpraachKonkaniKosraeanischKpelle-SchpraachKar" +
			"atschaiisch-BalkarischKarelischOraon-SchpraachKumükischKutenai-Schpr" +
			"aachLadinoLahndanischLambanischLesgischMongoRotse-SchpraachLuba-Lulu" +
			"aLuiseno-SchpraachLunda-SchpraachLuo-SchpraachLushai-SchpraachMadure" +
			"sischKhottaMaithiliMakassarischManding-SchpraachMassai-SchpraachMoks" +
			"chamordwinischMandaresischMende-SchpraachMittelirischMicmac-Schpraac" +
			"hMinangkabau-SchpraachMandschurischMeithei-SchpraachMohawk-Schpraach" +
			"Mossi-SchpraachMehrschpraachigMuskogee-SchpraachMirandesischMarwaris" +
			"chErzyaNeapolitanischNidertüütschNewarischNias-SchpraachNiue-Schpraa" +
			"chNogaischAltnordischN’KoNord-Sotho-SchpraachAlt-NewariNyamwezi-Schp" +
			"raachNyankoleNyoroNzimaOsage-SchpraachOsmanischPangasinanischMittelp" +
			"ersischPampanggan-SchpraachPapiamentoPalauAltpersischPhönikischPonap" +
			"eanischAltprovenzalischRajasthaniOschterinsel-SchpraachRarotonganisc" +
			"hZigüünerschpraachAromunischSandawe-SchpraachJakutischSamaritanischS" +
			"asakSantaliSizilianischSchottischSelkupischAltirischSchan-SchpraachS" +
			"idamoSüüd-SamischLule-SamischInari-SamischSkolt-SamischSoninke-Schpr" +
			"aachSogdischSrananischSerer-SchpraachSukuma-SchpraachSusuSumerischAl" +
			"tsyrischSyrischTemneTereno-SchpraachTetum-SchpraachTigreTiv-Schpraac" +
			"hTokelauanischKlingonischTlingit-SchpraachTamaseqTsonga-SchpraachNeu" +
			"melanesischTsimshian-SchpraachTumbuka-SchpraachElliceanischTuwinisch" +
			"UdmurtischUgaritischMbundu-SchpraachRootVai-SchpraachWotischWalamo-S" +
			"chpraachWarayWasho-SchpraachKalmückischYao-SchpraachYapesischZapotek" +
			"ischBliss-SymboolZenagaZuni-SchpraachKän schpraachliche InhaltZazaÖs" +
			"chtriichischs TüütschSchwiizer HochtüütschAuschtralischs ÄnglischKan" +
			"adischs ÄnglischBritischs ÄnglischAmerikanischs ÄnglischLatiinamerik" +
			"anischs SchpanischIbeerischs SchpanischKanadischs FranzösischSchwiiz" +
			"er FranzösischFläämischBrasilianischs PortugiisischIberischs Portugi" +
			"isischMoldawischSerbo-KroatischVeräifachts ChineesischTradizionells " +
			"Chineesisch",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0017, 0x0020, 0x0024, 0x002d, 0x0039,
			0x0041, 0x004c, 0x0054, 0x005a, 0x006b, 0x0077, 0x0084, 0x008f,
			0x0096, 0x009d, 0x00a7, 0x00b1, 0x00bd, 0x00c5, 0x00d1, 0x00e1,
			0x00e9, 0x00f1, 0x00f5, 0x0100, 0x010d, 0x011b, 0x0124, 0x012c,
			0x0135, 0x0141, 0x014b, 0x014e, 0x0158, 0x0161, 0x016c, 0x0176,
			0x017f, 0x0187, 0x018f, 0x0192, 0x019a, 0x01a7, 0x01b1, 0x01bd,
			0x01c6, 0x01cd, 0x01e2, 0x01eb, 0x01f2, 0x01fa, 0x0209, 0x020f,
			0x0219, 0x021e, 0x0227, 0x0230, 0x0238, 0x0241, 0x024a, 0x0250,
			// Entry 40 - 7F
			0x025b, 0x0266, 0x0271, 0x0275, 0x0283, 0x028a, 0x028d, 0x0299,
			0x02a5, 0x02ad, 0x02b6, 0x02bf, 0x02c8, 0x02d4, 0x02e4, 0x02ec,
			0x02f6, 0x0306, 0x0315, 0x031c, 0x0327, 0x0337, 0x0343, 0x034b,
			0x0359, 0x0361, 0x036c, 0x0372, 0x037f, 0x038e, 0x0399, 0x03a0,
			0x03a8, 0x03b1, 0x03b5, 0x03bd, 0x03c9, 0x03d8, 0x03dd, 0x03e8,
			0x03f1, 0x03fb, 0x0402, 0x040b, 0x0415, 0x041f, 0x0428, 0x043e,
			0x0449, 0x044f, 0x045d, 0x046f, 0x0481, 0x0499, 0x04a9, 0x04b8,
			0x04c3, 0x04d3, 0x04d8, 0x04dd, 0x04e6, 0x04f3, 0x04f7, 0x04ff,
			// Entry 80 - BF
			0x0506, 0x0513, 0x051a, 0x0528, 0x0537, 0x0541, 0x0549, 0x0552,
			0x055c, 0x0564, 0x056a, 0x0576, 0x057b, 0x0588, 0x0592, 0x059c,
			0x05a6, 0x05ad, 0x05b3, 0x05bc, 0x05c4, 0x05c9, 0x05df, 0x05eb,
			0x05f5, 0x05fc, 0x0605, 0x060b, 0x0617, 0x0624, 0x062c, 0x0637,
			0x0647, 0x0650, 0x0659, 0x065f, 0x0668, 0x0671, 0x067a, 0x0684,
			0x0688, 0x0691, 0x06a0, 0x06ad, 0x06b5, 0x06bf, 0x06c4, 0x06c9,
			0x06d1, 0x06d7, 0x06dd, 0x06e8, 0x06ec, 0x06f0, 0x06f6, 0x06fd,
			0x0703, 0x0703, 0x070b, 0x070b, 0x070f, 0x0718, 0x0718, 0x0721,
			// Entry C0 - FF
			0x0721, 0x0730, 0x073c, 0x0742, 0x074e, 0x0759, 0x0759, 0x0760,
			0x0760, 0x0760, 0x0766, 0x0766, 0x0766, 0x0766, 0x0766, 0x0774,
			0x0774, 0x077a, 0x0786, 0x0791, 0x0791, 0x0796, 0x0796, 0x0796,
			0x0796, 0x079d, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2,
			0x07ad, 0x07b6, 0x07ba, 0x07ba, 0x07ba, 0x07cd, 0x07cd, 0x07cd,
			0x07d8, 0x07d8, 0x07d8, 0x07d8, 0x07e2, 0x07ee, 0x07ee, 0x07f2,
			0x07f2, 0x07f7, 0x0801, 0x0801, 0x0806, 0x080d, 0x080d, 0x0818,
			0x0825, 0x082f, 0x083e, 0x0845, 0x084c, 0x0855, 0x085d, 0x0865,
			// Entry 100 - 13F
			0x0865, 0x086d, 0x086d, 0x087a, 0x087a, 0x0885, 0x088b, 0x0896,
			0x0896, 0x08a8, 0x08ae, 0x08b4, 0x08b9, 0x08b9, 0x08be, 0x08cb,
			0x08cb, 0x08d0, 0x08e4, 0x08e4, 0x08e9, 0x08e9, 0x08e9, 0x08f1,
			0x08f1, 0x08fe, 0x0904, 0x090c, 0x091b, 0x091b, 0x0921, 0x0921,
			0x0931, 0x0939, 0x0939, 0x093c, 0x093c, 0x094e, 0x095d, 0x095d,
			0x096a, 0x0978, 0x0981, 0x0983, 0x0983, 0x0983, 0x0987, 0x098c,
			0x098c, 0x0990, 0x099d, 0x099d, 0x09b0, 0x09c0, 0x09c0, 0x09c5,
			0x09ce, 0x09d5, 0x09da, 0x09e7, 0x09f9, 0x09f9, 0x09f9, 0x09f9,
			// Entry 140 - 17F
			0x0a04, 0x0a09, 0x0a09, 0x0a15, 0x0a15, 0x0a23, 0x0a2d, 0x0a31,
			0x0a3d, 0x0a3d, 0x0a41, 0x0a49, 0x0a49, 0x0a50, 0x0a5b, 0x0a5b,
			0x0a5b, 0x0a65, 0x0a65, 0x0a65, 0x0a78, 0x0a8b, 0x0a8b, 0x0a99,
			0x0aa2, 0x0ab2, 0x0ab5, 0x0aba, 0x0abe, 0x0aca, 0x0aca, 0x0ace,
			0x0ace, 0x0ace, 0x0ace, 0x0ad2, 0x0ad2, 0x0ada, 0x0ae1, 0x0ae1,
			0x0ae1, 0x0ae1, 0x0ae1, 0x0ae1, 0x0af3, 0x0af3, 0x0afa, 0x0b06,
			0x0b16, 0x0b2f, 0x0b2f, 0x0b2f, 0x0b38, 0x0b47, 0x0b47, 0x0b47,
			0x0b47, 0x0b51, 0x0b62, 0x0b68, 0x0b68, 0x0b73, 0x0b7d, 0x0b85,
			// Entry 180 - 1BF
			0x0b85, 0x0b85, 0x0b85, 0x0b85, 0x0b85, 0x0b8a, 0x0b99, 0x0b99,
			0x0b99, 0x0ba3, 0x0bb4, 0x0bc3, 0x0bd0, 0x0be0, 0x0be0, 0x0be0,
			0x0be0, 0x0beb, 0x0beb, 0x0bf1, 0x0bf9, 0x0c05, 0x0c16, 0x0c26,
			0x0c26, 0x0c38, 0x0c44, 0x0c53, 0x0c53, 0x0c53, 0x0c5f, 0x0c5f,
			0x0c5f, 0x0c6f, 0x0c84, 0x0c91, 0x0ca2, 0x0cb2, 0x0cc1, 0x0cc1,
			0x0cc1, 0x0cd0, 0x0ce2, 0x0cee, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cfd,
			0x0cfd, 0x0cfd, 0x0d0b, 0x0d0b, 0x0d19, 0x0d22, 0x0d30, 0x0d3e,
			0x0d3e, 0x0d3e, 0x0d3e, 0x0d46, 0x0d51, 0x0d51, 0x0d57, 0x0d6b,
			// Entry 1C0 - 1FF
			0x0d6b, 0x0d75, 0x0d87, 0x0d8f, 0x0d94, 0x0d99, 0x0da8, 0x0db1,
			0x0dbf, 0x0dcd, 0x0de1, 0x0deb, 0x0df0, 0x0df0, 0x0df0, 0x0df0,
			0x0df0, 0x0dfb, 0x0dfb, 0x0e06, 0x0e06, 0x0e06, 0x0e12, 0x0e12,
			0x0e22, 0x0e22, 0x0e22, 0x0e2c, 0x0e42, 0x0e50, 0x0e50, 0x0e50,
			0x0e50, 0x0e63, 0x0e63, 0x0e63, 0x0e63, 0x0e6d, 0x0e6d, 0x0e7e,
			0x0e87, 0x0e94, 0x0e94, 0x0e99, 0x0ea0, 0x0ea0, 0x0ea0, 0x0ea0,
			0x0eac, 0x0eb6, 0x0eb6, 0x0eb6, 0x0eb6, 0x0eb6, 0x0eb6, 0x0ec0,
			0x0ec0, 0x0ec9, 0x0ec9, 0x0ec9, 0x0ed8, 0x0ed8, 0x0ede, 0x0ede,
			// Entry 200 - 23F
			0x0ede, 0x0eec, 0x0ef8, 0x0f05, 0x0f12, 0x0f23, 0x0f2b, 0x0f35,
			0x0f44, 0x0f44, 0x0f44, 0x0f54, 0x0f58, 0x0f61, 0x0f61, 0x0f6b,
			0x0f72, 0x0f72, 0x0f72, 0x0f77, 0x0f77, 0x0f87, 0x0f96, 0x0f9b,
			0x0fa8, 0x0fb5, 0x0fb5, 0x0fc0, 0x0fd1, 0x0fd1, 0x0fd8, 0x0fe8,
			0x0ff6, 0x0ff6, 0x0ff6, 0x0ff6, 0x1009, 0x1009, 0x101a, 0x1026,
			0x1026, 0x102f, 0x102f, 0x1039, 0x1043, 0x1053, 0x1057, 0x1064,
			0x1064, 0x1064, 0x1064, 0x1064, 0x106b, 0x106b, 0x106b, 0x106b,
			0x107b, 0x1080, 0x108f, 0x108f, 0x108f, 0x109b, 0x109b, 0x109b,
			// Entry 240 - 27F
			0x10a8, 0x10b1, 0x10b1, 0x10b1, 0x10b1, 0x10b1, 0x10bc, 0x10c9,
			0x10c9, 0x10cf, 0x10cf, 0x10dd, 0x10f7, 0x10fb, 0x10fb, 0x10fb,
			0x1115, 0x112c, 0x1144, 0x1158, 0x116b, 0x1182, 0x11a0, 0x11b5,
			0x11b5, 0x11b5, 0x11cc, 0x11e2, 0x11e2, 0x11ed, 0x1209, 0x1220,
			0x122a, 0x1239, 0x1239, 0x1251, 0x126a,
		},
	},
	{ // gu
		guLangStr,
		guLangIdx,
	},
	{ // guz
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluEkegusii",
		[]uint16{ // 320 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0171,
		},
	},
	{ // gv
		"Gaelg",
		[]uint16{ // 55 elements
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005,
		},
	},
	{ // ha
		"AkanAmharikLarabciBelarusanciBulgaranciBengaliHarshen CakJamusanciGirkan" +
			"ciTuranciIspaniyanciParisanciFaransanciHausaHarshen HindiHarshen Hun" +
			"gariHarshen IndunusiyaInyamuranciItaliyanciJapananciJabananciHarshen" +
			" KimarHarshen KoreyaHarshen MalaiBurmanciNepaliHolanciPunjabiHarshen" +
			" PolanHarshen PortugalRomaniyanciRashanciKiniyaruwandaSomaliHarshen " +
			"SuwedanTamilThaiHarshen TurkiyyaHarshen YukurenHarshen UrduHarshen B" +
			"iyetinamYarbanciHarshen SinHarshen Zulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x001d, 0x0027,
			0x0027, 0x0027, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0042, 0x0042, 0x0042, 0x0042, 0x004a, 0x0051, 0x0051, 0x005c,
			0x005c, 0x005c, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006f,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x0074,
			0x0074, 0x0081, 0x0081, 0x0081, 0x0081, 0x0090, 0x0090, 0x0090,
			// Entry 40 - 7F
			0x0090, 0x00a2, 0x00a2, 0x00ad, 0x00ad, 0x00ad, 0x00ad, 0x00ad,
			0x00b7, 0x00b7, 0x00c0, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
			0x00c9, 0x00c9, 0x00d6, 0x00d6, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4, 0x00e4,
			0x00e4, 0x00e4, 0x00e4, 0x00f1, 0x00f1, 0x00f9, 0x00f9, 0x00f9,
			0x00ff, 0x00ff, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x010d, 0x010d, 0x011a,
			// Entry 80 - BF
			0x011a, 0x012a, 0x012a, 0x012a, 0x012a, 0x0135, 0x013d, 0x014a,
			0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
			0x014a, 0x014a, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x015f, 0x015f, 0x0164, 0x0164, 0x0164, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0168, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0187,
			0x0193, 0x0193, 0x0193, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4,
			0x01a4, 0x01ac, 0x01ac, 0x01b7, 0x01c3,
		},
	},
	{ // haw
		"ʻAlapiaWaleKenemakaKelemāniaHelenePelekāniaPanioloPīkīPalaniʻAilikiHeber" +
			"aʻĪkāliaKepanīKōleaLākinaMāoriHōlaniPukikīLūkiaKāmoaKuekeneTongaPola" +
			"polaWiekanamaPākēKuikilani KelemāniaʻŌlelo HawaiʻiʻIke ʻole ‘ia a kū" +
			"pono ʻole paha ka ʻōleloPelekāne Nū HōlaniPelekāne KanakāPelekānia P" +
			"ekekānePelekānia ʻAmelikaPalani KanakāKuikilaniPukikī PalakilaPākē H" +
			"oʻomaʻalahi ʻiaPākē Kuʻuna",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x000c, 0x0014,
			0x001e, 0x001e, 0x001e, 0x001e, 0x0024, 0x002e, 0x002e, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x003b, 0x003b, 0x0041,
			0x0041, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			// Entry 40 - 7F
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			0x0059, 0x0059, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060,
			0x0060, 0x0060, 0x0060, 0x0060, 0x0066, 0x0066, 0x0066, 0x0066,
			0x0066, 0x0066, 0x0066, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x0073, 0x0073,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073,
			0x0073, 0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a,
			// Entry 80 - BF
			0x007a, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x0094, 0x0099, 0x0099, 0x0099, 0x0099, 0x00a1, 0x00a1, 0x00a1,
			0x00a1, 0x00a1, 0x00a1, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			// Entry C0 - FF
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			// Entry 100 - 13F
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00c4, 0x00c4, 0x00c4, 0x00c4,
			// Entry 140 - 17F
			0x00c4, 0x00c4, 0x00c4, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 180 - 1BF
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 1C0 - 1FF
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			// Entry 200 - 23F
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5,
			0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			// Entry 240 - 27F
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0107, 0x0107, 0x011c, 0x012d, 0x0141, 0x0155, 0x0155, 0x0155,
			0x0155, 0x0155, 0x0163, 0x016c, 0x016c, 0x016c, 0x017c, 0x017c,
			0x017c, 0x017c, 0x017c, 0x0196, 0x01a4,
		},
	},
	{ // he
		heLangStr,
		heLangIdx,
	},
	{ // hi
		hiLangStr,
		hiLangIdx,
	},
	{ // hr
		hrLangStr,
		hrLangIdx,
	},
	{ // hsb
		"afaršćinaabchazišćinaafrikaanšćinaakanšćinaamharšćinaaragonšćinaarabšćin" +
			"aasamšćinaawaršćinaaymaršćinaazerbajdźanšćinabaškiršćinaběłorušćinab" +
			"ołharšćinabislamšćinabambarabengalšćinatibetšćinabretonšćinabosnišći" +
			"nakatalanšćinačamoršćinakorsišćinakričěšćinawalizišćinadanšćinaněmči" +
			"nadivehidzongkhaewegrjekšćinajendźelšćinaesperantošpanišćinaestišćin" +
			"abaskišćinapersišćinafinšćinafidźišćinafäröšćinafrancošćinafrizišćin" +
			"airšćinašotiska gelšćinagalicišćinaguaranigujaratimanšćinahausahebre" +
			"jšćinahindišćinachorwatšćinahaitišćinamadźaršćinaarmenšćinainterling" +
			"uaindonešćinaigbosichuan yiinupiakidoislandšćinaitalšćinainuitšćinaj" +
			"apanšćinajavašćinageorgišćinakikuyukazachšćinagröndlandšćinakhmeršći" +
			"nakannadšćinakorejšćinakašmiršćinakurdišćinakornišćinakirgišćinałaćo" +
			"nšćinaluxemburgšćinagandšćinalimburšćinalingalalaošćinalitawšćinalub" +
			"a-katangaletišćinamalagassišćinamaoršćinamakedonšćinamalajamšćinamon" +
			"golšćinamaratišćinamalajšćinamaltašćinaburmašćinanaurušćinasewjero-n" +
			"debelenepalšćinanižozemšćinanorwegšćina (nynorsk)norwegšćina (bokmål" +
			")navahookcitanšćinaoromoorijšćinapandźabšćinapólšćinapaštunšćinaport" +
			"ugalšćinakečuaretoromanšćinakirundišćinarumunšćinarušćinakinjarwanda" +
			"sanskritsardinšćinasindhišćinasewjerosamišćinasangosinghalšćinasłowa" +
			"kšćinasłowjenšćinasamoašćinašonašćinasomališćinaalbanšćinaserbišćina" +
			"siswatijužnosotšćina (Sesotho)sundanezišćinašwedšćinasuahelšćinatami" +
			"lšćinatelugutadźikšćinathailandšćinatigrinšćinaturkmenšćinatswanaton" +
			"gašćinaturkowšćinatsongatataršćinatahitišćinaujguršćinaukrainšćinaur" +
			"dušćinauzbekšćinavietnamšćinavolapükwalonšćinawolofxhosajidišćinajor" +
			"ubašćinazhuangchinšćinazulušćinaaghemšćinaanglosakšćinaarawkanšćinap" +
			"areasturšćinabembabenabodobuginezišćinachigachoctawšćinacherokeesora" +
			"nitaitazarmadelnjoserbšćinadualajola-fonyiembufilipinšćinagagauzišći" +
			"nagotšćinašwicarska němčinagusiihawaiišćinahornjoserbšćinangombamach" +
			"amekabylšćinakambamakondekapverdšćinakoyra chiinikalenjinpermska kom" +
			"išćinakonkanišambalabafialangilakotaluoluhyamasaišćinamerumauriciska" +
			" kreolšćinamakhuwa-meettometa’mohawkšćinamundangkriknamadelnjoněmčin" +
			"akwasion’konuernyankoleprušćinakʼicheʼromborwasamburusangusicilšćina" +
			"senakoyra sennitašelhitjužnosamišćinalule-samišćinainari-samišćinask" +
			"olt-samišćinasaterfrizišćinatesotasawaqtamazight (srjedźny Marokko)n" +
			"jeznata rěčvaivunjosogatamazightžadyn rěčny wobsahmoderna wysokoarab" +
			"šćinaawstriska němčinašwicarska wysokoněmčinaawstralska jendźelšćin" +
			"akanadiska jendźelšćinabritiska jendźelšćinaameriska jendźelšćinałać" +
			"onskoameriska španišćinaeuropska španišćinamexiska španišćinakanadis" +
			"ka francošćinašwicarska francošćinaflamšćinabrazilska portugalšćinae" +
			"uropska portugalšćinamoldawšćinaserbochorwatšćinakongoska suahelšćin" +
			"achinšćina (zjednorjena)chinšćina (tradicionalna)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000b, 0x0019, 0x0019, 0x0028, 0x0033, 0x003f, 0x004c,
			0x0057, 0x0062, 0x006d, 0x0079, 0x008c, 0x009a, 0x00a9, 0x00b7,
			0x00c4, 0x00cb, 0x00d8, 0x00e4, 0x00f1, 0x00fd, 0x010b, 0x010b,
			0x0118, 0x0124, 0x0127, 0x0132, 0x0132, 0x0132, 0x013f, 0x0149,
			0x0152, 0x0158, 0x0160, 0x0163, 0x016f, 0x017e, 0x0187, 0x0194,
			0x019f, 0x01ab, 0x01b7, 0x01b7, 0x01c1, 0x01ce, 0x01db, 0x01e8,
			0x01f4, 0x01fd, 0x0210, 0x021d, 0x0224, 0x022c, 0x0236, 0x023b,
			0x0248, 0x0254, 0x0254, 0x0262, 0x026e, 0x027c, 0x0288, 0x0288,
			// Entry 40 - 7F
			0x0293, 0x02a0, 0x02a0, 0x02a4, 0x02ae, 0x02b5, 0x02b8, 0x02c5,
			0x02d0, 0x02dc, 0x02e8, 0x02f3, 0x0300, 0x0300, 0x0306, 0x0306,
			0x0313, 0x0324, 0x0330, 0x033d, 0x0349, 0x0349, 0x0357, 0x0363,
			0x0363, 0x036f, 0x037b, 0x0389, 0x0399, 0x03a4, 0x03b1, 0x03b8,
			0x03c2, 0x03ce, 0x03da, 0x03e5, 0x03f5, 0x03f5, 0x0400, 0x040e,
			0x041c, 0x0429, 0x0436, 0x0442, 0x044e, 0x045a, 0x0466, 0x0475,
			0x0481, 0x0481, 0x0490, 0x04a7, 0x04be, 0x04be, 0x04c4, 0x04c4,
			0x04d2, 0x04d2, 0x04d7, 0x04e2, 0x04e2, 0x04f1, 0x04f1, 0x04fc,
			// Entry 80 - BF
			0x050a, 0x0519, 0x051f, 0x052f, 0x053d, 0x0549, 0x0552, 0x055d,
			0x0565, 0x0572, 0x057f, 0x0591, 0x0596, 0x05a4, 0x05b2, 0x05c1,
			0x05cd, 0x05d9, 0x05e6, 0x05f2, 0x05fe, 0x0605, 0x061f, 0x062f,
			0x063b, 0x0648, 0x0654, 0x065a, 0x0668, 0x0677, 0x0684, 0x0692,
			0x0698, 0x06a4, 0x06b1, 0x06b7, 0x06c3, 0x06d0, 0x06dc, 0x06e9,
			0x06f4, 0x0700, 0x0700, 0x070e, 0x0716, 0x0722, 0x0727, 0x072c,
			0x0737, 0x0744, 0x074a, 0x0755, 0x0760, 0x0760, 0x0760, 0x0760,
			0x0760, 0x0760, 0x0760, 0x076c, 0x076c, 0x076c, 0x076c, 0x076c,
			// Entry C0 - FF
			0x076c, 0x076c, 0x077b, 0x077b, 0x077b, 0x0789, 0x0789, 0x0789,
			0x0789, 0x0789, 0x0789, 0x0789, 0x0789, 0x078d, 0x078d, 0x0799,
			0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799, 0x0799,
			0x0799, 0x0799, 0x079e, 0x079e, 0x07a2, 0x07a2, 0x07a2, 0x07a2,
			0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2, 0x07a2,
			0x07a2, 0x07a2, 0x07a6, 0x07a6, 0x07a6, 0x07b5, 0x07b5, 0x07b5,
			0x07b5, 0x07b5, 0x07b5, 0x07b5, 0x07b5, 0x07b5, 0x07ba, 0x07ba,
			0x07ba, 0x07ba, 0x07ba, 0x07ba, 0x07c8, 0x07c8, 0x07d0, 0x07d0,
			// Entry 100 - 13F
			0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6, 0x07d6,
			0x07db, 0x07db, 0x07db, 0x07db, 0x07db, 0x07e0, 0x07e0, 0x07f1,
			0x07f1, 0x07f6, 0x07f6, 0x0800, 0x0800, 0x0800, 0x0804, 0x0804,
			0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0804, 0x0804,
			0x0804, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812, 0x0812,
			0x0812, 0x0812, 0x0812, 0x0812, 0x0820, 0x0820, 0x0820, 0x0820,
			0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820, 0x0820,
			0x0820, 0x082a, 0x082a, 0x082a, 0x083e, 0x083e, 0x083e, 0x0843,
			// Entry 140 - 17F
			0x0843, 0x0843, 0x0843, 0x0850, 0x0850, 0x0850, 0x0850, 0x0850,
			0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0861,
			0x0861, 0x0861, 0x0867, 0x086e, 0x086e, 0x086e, 0x086e, 0x086e,
			0x087a, 0x087a, 0x087a, 0x087f, 0x087f, 0x087f, 0x087f, 0x087f,
			0x0886, 0x0894, 0x0894, 0x0894, 0x0894, 0x0894, 0x0894, 0x08a0,
			0x08a0, 0x08a0, 0x08a0, 0x08a8, 0x08a8, 0x08bb, 0x08c2, 0x08c2,
			0x08c2, 0x08c2, 0x08c2, 0x08c2, 0x08c2, 0x08c2, 0x08ca, 0x08cf,
			0x08cf, 0x08cf, 0x08cf, 0x08cf, 0x08d4, 0x08d4, 0x08d4, 0x08d4,
			// Entry 180 - 1BF
			0x08d4, 0x08d4, 0x08d4, 0x08da, 0x08da, 0x08da, 0x08da, 0x08da,
			0x08da, 0x08da, 0x08da, 0x08da, 0x08dd, 0x08dd, 0x08e2, 0x08e2,
			0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08e2, 0x08ee,
			0x08ee, 0x08ee, 0x08ee, 0x08ee, 0x08f2, 0x0909, 0x0909, 0x0917,
			0x091e, 0x091e, 0x091e, 0x091e, 0x091e, 0x092b, 0x092b, 0x092b,
			0x0932, 0x0932, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936, 0x0936,
			0x0936, 0x0936, 0x0936, 0x093a, 0x0949, 0x0949, 0x0949, 0x0949,
			0x0949, 0x094f, 0x094f, 0x094f, 0x094f, 0x094f, 0x0955, 0x0955,
			// Entry 1C0 - 1FF
			0x0959, 0x0959, 0x0959, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961,
			0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961,
			0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x0961, 0x096b,
			0x096b, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974, 0x0974,
			0x0979, 0x0979, 0x0979, 0x0979, 0x0979, 0x0979, 0x097c, 0x097c,
			0x097c, 0x097c, 0x0983, 0x0983, 0x0983, 0x0983, 0x0983, 0x0988,
			0x0994, 0x0994, 0x0994, 0x0994, 0x0994, 0x0998, 0x0998, 0x0998,
			0x09a3, 0x09a3, 0x09a3, 0x09ac, 0x09ac, 0x09ac, 0x09ac, 0x09ac,
			// Entry 200 - 23F
			0x09ac, 0x09bd, 0x09cd, 0x09de, 0x09ef, 0x09ef, 0x09ef, 0x09ef,
			0x09ef, 0x09ef, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a00,
			0x0a00, 0x0a00, 0x0a00, 0x0a00, 0x0a04, 0x0a04, 0x0a04, 0x0a04,
			0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04,
			0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04, 0x0a04,
			0x0a0b, 0x0a0b, 0x0a28, 0x0a28, 0x0a28, 0x0a28, 0x0a36, 0x0a39,
			0x0a39, 0x0a39, 0x0a39, 0x0a39, 0x0a39, 0x0a39, 0x0a3e, 0x0a3e,
			0x0a3e, 0x0a3e, 0x0a3e, 0x0a3e, 0x0a3e, 0x0a3e, 0x0a3e, 0x0a42,
			// Entry 240 - 27F
			0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42, 0x0a42,
			0x0a42, 0x0a42, 0x0a4b, 0x0a4b, 0x0a60, 0x0a60, 0x0a79, 0x0a79,
			0x0a8c, 0x0aa6, 0x0ac0, 0x0ad9, 0x0af1, 0x0b09, 0x0b29, 0x0b3f,
			0x0b54, 0x0b54, 0x0b6b, 0x0b83, 0x0b83, 0x0b8e, 0x0ba7, 0x0bbf,
			0x0bcc, 0x0bdf, 0x0bf5, 0x0c0e, 0x0c29,
		},
	},
	{ // hu
		huLangStr,
		huLangIdx,
	},
	{ // hy
		hyLangStr,
		hyLangIdx,
	},
	{ // id
		idLangStr,
		idLangIdx,
	},
	{ // ig
		"AkanAmariikịArabiikịBelaruusuBọlụgarịaBengaliCheekịJamaanGiriikịOyiboPan" +
			"yaPeshanFụrenchAwụsaHindiMagịyaIndonisiaIgboItaloJapaneseJavaKeme, E" +
			"titiKoriaMaleyiMịanmaNepaliDọọchPunjabiPoliishiPotokiRumeniaRọshanRụ" +
			"wandaSomaliSụwidiishiTamụlụTaịTọkiishiUkureenịUruduViyetịnaamụYoruba" +
			"MandarịịnịZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000e, 0x000e,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0021, 0x0030,
			0x0030, 0x0030, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0045, 0x0045, 0x0045, 0x0045, 0x004e, 0x0053, 0x0053, 0x0058,
			0x0058, 0x0058, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0067,
			0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x006e,
			0x006e, 0x0073, 0x0073, 0x0073, 0x0073, 0x007b, 0x007b, 0x007b,
			// Entry 40 - 7F
			0x007b, 0x0084, 0x0084, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
			0x008d, 0x008d, 0x0095, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x0099, 0x0099, 0x00a4, 0x00a4, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00a9, 0x00a9, 0x00a9, 0x00af, 0x00af, 0x00b7, 0x00b7, 0x00b7,
			0x00bd, 0x00bd, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00d5,
			// Entry 80 - BF
			0x00d5, 0x00db, 0x00db, 0x00db, 0x00db, 0x00e2, 0x00ea, 0x00f3,
			0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3,
			0x00f3, 0x00f3, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x00f9,
			0x0105, 0x0105, 0x010f, 0x010f, 0x010f, 0x0114, 0x0114, 0x0114,
			0x0114, 0x0114, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128,
			0x012d, 0x012d, 0x012d, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x0142, 0x0142, 0x0152, 0x0156,
		},
	},
	{ // ii
		"ꄓꇩꉙꑱꇩꉙꑭꀠꑸꉙꃔꇩꉙꆈꌠꉙꑴꄊꆺꉙꏝꀪꉙꁍꄨꑸꉙꊉꇩꉙꍏꇩꉙꅉꀋꌠꅇꂷꀠꑟꁍꄨꑸꉙꈝꐯꍏꇩꉙꀎꋏꍏꇩꉙ",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0012, 0x0012, 0x001e,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
			// Entry 40 - 7F
			0x0027, 0x0027, 0x0027, 0x0027, 0x0030, 0x0030, 0x0030, 0x0030,
			0x003c, 0x003c, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			// Entry 80 - BF
			0x0045, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry C0 - FF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 100 - 13F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 140 - 17F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 180 - 1BF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 1C0 - 1FF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 200 - 23F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			// Entry 240 - 27F
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0084, 0x0084,
			0x0084, 0x0084, 0x0084, 0x0093, 0x00a2,
		},
	},
	{ // is
		isLangStr,
		isLangIdx,
	},
	{ // it
		itLangStr,
		itLangIdx,
	},
	{ // ja
		jaLangStr,
		jaLangIdx,
	},
	{ // jgo
		"AlâbɛNjámanŊgɛlɛ̂kAŋgɛlúshiFɛlánciShinwâNdaꞌacú-pʉɔ yi pɛ́ ká kɛ́ jí",
		[]uint16{ // 559 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
			0x000e, 0x000e, 0x000e, 0x000e, 0x0019, 0x0025, 0x0025, 0x0025,
			0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x0025, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			// Entry 40 - 7F
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			// Entry 80 - BF
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry C0 - FF
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry 100 - 13F
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			// Entry 140 - 17F
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 180 - 1BF
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 1C0 - 1FF
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			// Entry 200 - 23F
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c, 0x005c,
		},
	},
	{ // jmc
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKim" +
			"achame",
		[]uint16{ // 340 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x01a2,
		},
	},
	{ // ka
		kaLangStr,
		kaLangIdx,
	},
	{ // kab
		"TakanitTamahrictTaɛrabtTabilarusitTabulgaritTabengalitTačikitTalmantTagr" +
			"ikitTaglizitTaspenyulitTafarisitTafransistTahwasitTahenditTahungarit" +
			"TandunisitTigbutTaṭalyanitTajapunitTajavanitTakemritTakuritTamalawit" +
			"TaburmisitTanipalitTadučitTapunjabitTapulunitTapurtugalitTarumanitTa" +
			"rusitTaruwanditTaṣumalitTaswiditTaṭamulitTaṭaylunditTaṭurkitTukranit" +
			"TurdutTabyiṭnamitTayurubitTacinwat, TamundarintTazulutTaqbaylit",
		[]uint16{ // 345 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0023, 0x002d,
			0x002d, 0x002d, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x0037, 0x0037, 0x0037, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0046, 0x0046, 0x0046, 0x0046, 0x004e, 0x0056, 0x0056, 0x0061,
			0x0061, 0x0061, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x007c,
			0x007c, 0x0084, 0x0084, 0x0084, 0x0084, 0x008e, 0x008e, 0x008e,
			// Entry 40 - 7F
			0x008e, 0x0098, 0x0098, 0x009e, 0x009e, 0x009e, 0x009e, 0x009e,
			0x00aa, 0x00aa, 0x00b3, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00c4, 0x00c4, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d4, 0x00d4, 0x00de, 0x00de, 0x00de,
			0x00e7, 0x00e7, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef,
			0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00f9, 0x00f9, 0x0102,
			// Entry 80 - BF
			0x0102, 0x010e, 0x010e, 0x010e, 0x010e, 0x0117, 0x011e, 0x0128,
			0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128,
			0x0128, 0x0128, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133, 0x0133,
			0x013b, 0x013b, 0x0146, 0x0146, 0x0146, 0x0153, 0x0153, 0x0153,
			0x0153, 0x0153, 0x015d, 0x015d, 0x015d, 0x015d, 0x015d, 0x0165,
			0x016b, 0x016b, 0x016b, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0181, 0x0181, 0x0196, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry C0 - FF
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry 100 - 13F
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			// Entry 140 - 17F
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d, 0x019d,
			0x01a6,
		},
	},
	{ // kam
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKikamba",
		[]uint16{ // 348 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0170,
		},
	},
	{ // kde
		"ChakanChamhaliChalabuChibelalusiChibulgaliaChibanglaChichechiChidyeluman" +
			"iChigilichiChiingelezaChihispaniaChiajemiChifalansaChihausaChihindiC" +
			"hihungaliChiiongonesiaChiigboChiitalianoChidyapaniChidyavaChikambodi" +
			"aChikoleaChimalesiaChibulmaChinepaliChiholanziChipunjabiChipolandiCh" +
			"ilenoChilomaniaChilusiChinyalwandaChisomaliChiswidiChitamilChitailan" +
			"diChituluchiChiuklaniaChiulduChivietinamuChiyolubaChichinaChizuluChi" +
			"makonde",
		[]uint16{ // 353 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0020, 0x002b,
			0x002b, 0x002b, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0049, 0x0049, 0x0049, 0x0049, 0x0053, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x0083,
			0x0083, 0x008b, 0x008b, 0x008b, 0x008b, 0x0095, 0x0095, 0x0095,
			// Entry 40 - 7F
			0x0095, 0x00a2, 0x00a2, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b4, 0x00b4, 0x00be, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00d1, 0x00d1, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00d9,
			0x00d9, 0x00d9, 0x00d9, 0x00e3, 0x00e3, 0x00eb, 0x00eb, 0x00eb,
			0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x0108, 0x0108, 0x0112,
			// Entry 80 - BF
			0x0112, 0x0119, 0x0119, 0x0119, 0x0119, 0x0123, 0x012a, 0x0136,
			0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136, 0x0136,
			0x0136, 0x0136, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x01a3,
		},
	},
	{ // kea
		"abkáziuafrikanerakanamárikuárabiasamesaimaraazerbaijanubaxkirbielorusubú" +
			"lgarubambarabengalitibetanubretãubosniukatalãutxetxenukórsikutxekutx" +
			"uvaxigalesdinamarkesalimãudzonkaevegreguinglessperantuspanholstonian" +
			"ubaskupersafinlandesfijianufaroesfransesfríziu osidentalirlandesgale" +
			"guguaranigujaratimanksauzaebraikuindikroataaitianuúngaruarméniuindon" +
			"éziuibonuosuislandesitalianuinuktitutjaponesjavanesjorjianukikuiuka" +
			"zakgroenlandeskmerkanareskorianukaxmirakurdukórnikukirgizlatinluxemb" +
			"urgeslugandalausianulituanesletãumalgaximaorimasedóniumalaialammarat" +
			"imaláiumaltesbirmanesnepalesolandesnorueges nynorsknorueges bokmålor" +
			"omoodíapandjabipulakupaxtopurtugeskexuaromanxirumenurusukiniaruandas" +
			"ánskritusindisingalesslovakuslovéniusomalialbanessérviusundanessuek" +
			"usuaílitamiltelugutadjikitailandestigriniaturkmenutonganesturkutatar" +
			"uigurukranianuurduuzbekivietnamitauolofkozaiorubaxineszuluaghemarauk" +
			"anuasubembabenabodoxigaxerokikurdu sentraltaitazarmasórbiu baxuduala" +
			"jola-fonyiembufilipinugagauzalimãu suísugusiiavaianusórbiu altuñomba" +
			"matxamekabilakambakabuverdianukoira txiinikalenjinkomi-permiakkonkan" +
			"ibafiakuaziokitxekoiraboro seniinari samitamazait di Atlas Sentrallí" +
			"ngua diskonxedusen kontiudu linguístikuárabi mudernualimãu austriaku" +
			"altu alimãu suisuingles australianuingles kanadianuingles britanikui" +
			"ngles merkanuspanhol latinu-merkanuspanhol europeuspanhol mexikanufr" +
			"anses kanadianufranses suisuflamengupurtuges brazilerupurtuges europ" +
			"eurumenu moldávikusuaíli kongolesxines simplifikaduxines tradisional",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0008, 0x0008, 0x0011, 0x0015, 0x001d, 0x001d,
			0x0023, 0x0029, 0x0029, 0x002f, 0x003a, 0x0040, 0x0049, 0x0051,
			0x0051, 0x0058, 0x005f, 0x0067, 0x006e, 0x0074, 0x007c, 0x0084,
			0x0084, 0x008c, 0x008c, 0x0091, 0x0091, 0x0098, 0x009d, 0x00a7,
			0x00ae, 0x00ae, 0x00b4, 0x00b7, 0x00bc, 0x00c2, 0x00ca, 0x00d1,
			0x00d9, 0x00de, 0x00e3, 0x00e3, 0x00ec, 0x00f3, 0x00f9, 0x0100,
			0x0111, 0x0119, 0x0119, 0x011f, 0x0126, 0x012e, 0x0133, 0x0137,
			0x013e, 0x0142, 0x0142, 0x0148, 0x014f, 0x0156, 0x015e, 0x015e,
			// Entry 40 - 7F
			0x015e, 0x0168, 0x0168, 0x016b, 0x0170, 0x0170, 0x0170, 0x0178,
			0x0180, 0x0189, 0x0190, 0x0197, 0x019f, 0x019f, 0x01a5, 0x01a5,
			0x01aa, 0x01b5, 0x01b9, 0x01c0, 0x01c7, 0x01c7, 0x01ce, 0x01d3,
			0x01d3, 0x01db, 0x01e1, 0x01e6, 0x01f1, 0x01f8, 0x01f8, 0x01f8,
			0x0200, 0x0208, 0x0208, 0x020e, 0x0215, 0x0215, 0x021a, 0x0224,
			0x022d, 0x022d, 0x0233, 0x023a, 0x0240, 0x0248, 0x0248, 0x0248,
			0x024f, 0x024f, 0x0256, 0x0266, 0x0276, 0x0276, 0x0276, 0x0276,
			0x0276, 0x0276, 0x027b, 0x0280, 0x0280, 0x0288, 0x0288, 0x028e,
			// Entry 80 - BF
			0x0293, 0x029b, 0x02a0, 0x02a7, 0x02a7, 0x02ad, 0x02b1, 0x02bc,
			0x02c6, 0x02c6, 0x02cb, 0x02cb, 0x02cb, 0x02d3, 0x02da, 0x02e3,
			0x02e3, 0x02e3, 0x02e9, 0x02f0, 0x02f7, 0x02f7, 0x02f7, 0x02ff,
			0x0304, 0x030b, 0x0310, 0x0316, 0x031d, 0x0326, 0x032e, 0x0336,
			0x0336, 0x033e, 0x0343, 0x0343, 0x0348, 0x0348, 0x034d, 0x0356,
			0x035a, 0x0360, 0x0360, 0x036a, 0x036a, 0x036a, 0x036f, 0x0373,
			0x0373, 0x0379, 0x0379, 0x037e, 0x0382, 0x0382, 0x0382, 0x0382,
			0x0382, 0x0382, 0x0382, 0x0387, 0x0387, 0x0387, 0x0387, 0x0387,
			// Entry C0 - FF
			0x0387, 0x0387, 0x0387, 0x0387, 0x0387, 0x038f, 0x038f, 0x038f,
			0x038f, 0x038f, 0x038f, 0x038f, 0x038f, 0x0392, 0x0392, 0x0392,
			0x0392, 0x0392, 0x0392, 0x0392, 0x0392, 0x0392, 0x0392, 0x0392,
			0x0392, 0x0392, 0x0397, 0x0397, 0x039b, 0x039b, 0x039b, 0x039b,
			0x039b, 0x039b, 0x039b, 0x039b, 0x039b, 0x039b, 0x039b, 0x039b,
			0x039b, 0x039b, 0x039f, 0x039f, 0x039f, 0x039f, 0x039f, 0x039f,
			0x039f, 0x039f, 0x039f, 0x039f, 0x039f, 0x039f, 0x03a3, 0x03a3,
			0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a3, 0x03a9, 0x03a9,
			// Entry 100 - 13F
			0x03b6, 0x03b6, 0x03b6, 0x03b6, 0x03b6, 0x03b6, 0x03b6, 0x03b6,
			0x03bb, 0x03bb, 0x03bb, 0x03bb, 0x03bb, 0x03c0, 0x03c0, 0x03cc,
			0x03cc, 0x03d1, 0x03d1, 0x03db, 0x03db, 0x03db, 0x03df, 0x03df,
			0x03df, 0x03df, 0x03df, 0x03df, 0x03df, 0x03df, 0x03df, 0x03df,
			0x03df, 0x03e7, 0x03e7, 0x03e7, 0x03e7, 0x03e7, 0x03e7, 0x03e7,
			0x03e7, 0x03e7, 0x03e7, 0x03e7, 0x03ed, 0x03ed, 0x03ed, 0x03ed,
			0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed,
			0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03fb, 0x03fb, 0x03fb, 0x0400,
			// Entry 140 - 17F
			0x0400, 0x0400, 0x0400, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0413, 0x0413, 0x0413, 0x0413, 0x0413, 0x0413, 0x0413, 0x0413,
			0x0413, 0x0413, 0x0419, 0x0420, 0x0420, 0x0420, 0x0420, 0x0420,
			0x0426, 0x0426, 0x0426, 0x042b, 0x042b, 0x042b, 0x042b, 0x042b,
			0x042b, 0x0437, 0x0437, 0x0437, 0x0437, 0x0437, 0x0437, 0x0443,
			0x0443, 0x0443, 0x0443, 0x044b, 0x044b, 0x0457, 0x045e, 0x045e,
			0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x045e, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			// Entry 180 - 1BF
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463, 0x0463,
			0x0463, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			// Entry 1C0 - 1FF
			0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469, 0x0469,
			0x0469, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e,
			0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e,
			0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e,
			0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e, 0x046e,
			0x047c, 0x047c, 0x047c, 0x047c, 0x047c, 0x047c, 0x047c, 0x047c,
			// Entry 200 - 23F
			0x047c, 0x047c, 0x047c, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x049f, 0x049f, 0x049f, 0x049f, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			// Entry 240 - 27F
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04ca, 0x04ca, 0x04d8, 0x04d8,
			0x04e9, 0x04fb, 0x050d, 0x051d, 0x052d, 0x053b, 0x0551, 0x0560,
			0x0570, 0x0570, 0x0581, 0x058e, 0x058e, 0x0596, 0x05a8, 0x05b8,
			0x05c9, 0x05c9, 0x05d9, 0x05eb, 0x05fc,
		},
	},
	{ // khq
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senni, Gam" +
			"e hereKoree senniMaleezi senniBurme senniNeepal senniHolandee senniP" +
			"unjaabi senniiPolonee senniPortugee senniRumaani senniRuusi senniRwa" +
			"nda senniSomaali senniSuweede senniTamil senniTaailandu senniTurku s" +
			"enniUkreen senniUrdu senniVietnaam senniYorbance senniSinuwa senni, " +
			"MandareŋJulu senniKoyra ciini",
		[]uint16{ // 360 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0134, 0x0134, 0x013f, 0x013f, 0x013f,
			0x014b, 0x014b, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
			0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0168, 0x0168, 0x0175,
			// Entry 80 - BF
			0x0175, 0x0183, 0x0183, 0x0183, 0x0183, 0x0190, 0x019b, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01c1, 0x01c1, 0x01cc, 0x01cc, 0x01cc, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01f2,
			0x01fc, 0x01fc, 0x01fc, 0x020a, 0x020a, 0x020a, 0x020a, 0x020a,
			0x020a, 0x0218, 0x0218, 0x022f, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry C0 - FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 100 - 13F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 140 - 17F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0244,
		},
	},
	{ // ki
		"KiakanKiamhariKĩarabuKibelarusiKibulgariaKibanglaKicheckiKĩnjeremaniKigi" +
			"rikiGĩthungũKihispaniaKiajemiKĩbaranjaKihausaKĩhĩndĩKihungariKiindon" +
			"esiaKiigboKĩtalianoKĩnjabaniKijavaGikuyuKikambodiaKikoreaKimalesiaKi" +
			"burmaKinepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKĩraciaKinyar" +
			"wandaKĩcumarĩKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietin" +
			"amuKiyorubaKĩcainaKizulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x0046, 0x0046, 0x0046, 0x0046, 0x004e, 0x0058, 0x0058, 0x0062,
			0x0062, 0x0062, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0073,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007a,
			0x007a, 0x0084, 0x0084, 0x0084, 0x0084, 0x008d, 0x008d, 0x008d,
			// Entry 40 - 7F
			0x008d, 0x0098, 0x0098, 0x009e, 0x009e, 0x009e, 0x009e, 0x009e,
			0x00a8, 0x00a8, 0x00b2, 0x00b8, 0x00b8, 0x00b8, 0x00be, 0x00be,
			0x00be, 0x00be, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00d8, 0x00d8, 0x00df, 0x00df, 0x00df,
			0x00e7, 0x00e7, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f9, 0x00f9, 0x0102,
			// Entry 80 - BF
			0x0102, 0x0108, 0x0108, 0x0108, 0x0108, 0x0111, 0x0119, 0x0124,
			0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124, 0x0124,
			0x0124, 0x0124, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x0135, 0x0135, 0x013c, 0x013c, 0x013c, 0x0146, 0x0146, 0x0146,
			0x0146, 0x0146, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x0157,
			0x015d, 0x015d, 0x015d, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
			0x0168, 0x0170, 0x0170, 0x0178, 0x017e,
		},
	},
	{ // kk
		kkLangStr,
		kkLangIdx,
	},
	{ // kkj
		"yamannumbu buykakɔ",
		[]uint16{ // 363 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 40 - 7F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 80 - BF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry C0 - FF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 100 - 13F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			// Entry 140 - 17F
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x0013,
		},
	},
	{ // kl
		"kalaallisut",
		[]uint16{ // 82 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x000b,
		},
	},
	{ // kln
		"kutitab Akakutitab Amariekkutitab Arabukkutitab Belarusakutitab Bulgaria" +
			"kutitab Bengalikutitab Chekkutitab Chermanikutitab Greecekutitab Uin" +
			"geresakutitab Espianikkutitab Persiakutitab Kifaransakutitab Hausaku" +
			"titab Maindiikkutitab Hangarikutitab Indonesiakutitab Igbokutitab Ta" +
			"lianekkutitap Japankutitap Javanesekutitab Kher nebo Kwenkutitab Kor" +
			"eakutitab Malaykutitab Burmakutitab Nepalikutitab Boakutitab Punjabk" +
			"utitap Polandkutitab Portugalkutitab Romaniekkutitab Russiakutitab K" +
			"inyarwandakutitab Somaliekkutitab Swedenkutitab Tamilkutitab Thailan" +
			"dkutitab Turkeykutitab Ukrainekutitab Urdukutitab Vietnamkutitab Yor" +
			"ubakutitab Chinakutitab ZuluKalenjin",
		[]uint16{ // 364 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000b, 0x001a, 0x001a,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0038, 0x0048,
			0x0048, 0x0048, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0073, 0x0073, 0x0073, 0x0073, 0x0081, 0x0092, 0x0092, 0x00a2,
			0x00a2, 0x00a2, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00c1,
			0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00ce,
			0x00ce, 0x00de, 0x00de, 0x00de, 0x00de, 0x00ed, 0x00ed, 0x00ed,
			// Entry 40 - 7F
			0x00ed, 0x00fe, 0x00fe, 0x010a, 0x010a, 0x010a, 0x010a, 0x010a,
			0x011a, 0x011a, 0x0127, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x014d, 0x014d, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x015a, 0x0167, 0x0167, 0x0174, 0x0174, 0x0174,
			0x0182, 0x0182, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x018d, 0x018d, 0x018d, 0x018d, 0x019b, 0x019b, 0x01a9,
			// Entry 80 - BF
			0x01a9, 0x01b9, 0x01b9, 0x01b9, 0x01b9, 0x01c9, 0x01d7, 0x01ea,
			0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea,
			0x01ea, 0x01ea, 0x01fa, 0x01fa, 0x01fa, 0x01fa, 0x01fa, 0x01fa,
			0x0208, 0x0208, 0x0215, 0x0215, 0x0215, 0x0225, 0x0225, 0x0225,
			0x0225, 0x0225, 0x0233, 0x0233, 0x0233, 0x0233, 0x0233, 0x0242,
			0x024e, 0x024e, 0x024e, 0x025d, 0x025d, 0x025d, 0x025d, 0x025d,
			0x025d, 0x026b, 0x026b, 0x0278, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry C0 - FF
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry 100 - 13F
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			// Entry 140 - 17F
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284, 0x0284,
			0x0284, 0x0284, 0x0284, 0x028c,
		},
	},
	{ // km
		kmLangStr,
		kmLangIdx,
	},
	{ // kn
		knLangStr,
		knLangIdx,
	},
	{ // ko
		koLangStr,
		koLangIdx,
	},
	{}, // ko-KP
	{ // kok
		"अफारअबखेज़ियनअफ्रिकान्सत्विअमहारिक्अरेबिक्असामीऐमराअज़रबैजानीबष्किरबैलोर" +
			"ुसियन्बल्गेरियनबिसलमाबंगालीतिबेतियनब्रेटनकटलानकोर्शियनज़ेक्वेळ्ष्ड" +
			"ानिषजर्मनभूटानीग्रीक्आंग्लइस्परान्टोस्पानिषइस्टोनियन्बास्कपर्षियन्" +
			"फिन्निष्फिजीफेरोस्फ्रेन्चफ्रिशियन्ऐरिषस्काटस् गेलिक्गेलीशियनगौरानी" +
			"गुजरातीहौसाहेब्रुहिन्दीक्रोयेषियन्हंगेरियन्आर्मीनियन्इन्टरलिंग्वाइ" +
			"न्डोनेषियनइन्टरलिंग्इनूपेयाक्आईस्लान्डिकइटालियनइन्युकट्टजापनीस्जाव" +
			"नीस्जार्जियन्कज़ख्ग्रीनलान्डिककंबोडियनकन्नडाकोरियन्कश्मीरीकुर्दिषक" +
			"िर्गिज़लाटिनलिंगालालाओतियन्लिथुआनियन्लाट्वियन् (लेट्टिष्)मलागसीमाओ" +
			"रीमसीडोनियन्मळियाळममंगोलियन्मराठीमलयमालतीस्बर्मीज़्नौरोनेपाळीडच्नो" +
			"र्वेजियनओसिटान्ओरोमो (अफान)ओरियापंजाबीपोलिषपाष्टो (पुष्टो)पोर्चुगी" +
			"ज़्क्वेच्वारहटो-रोमान्स्किरुन्दीरोमानियन्रष्यन्किन्यार्वान्डासंस्क" +
			"ृतसिंधीसांग्रोसिन्हलीस्स्लोवाकस्लोवेनियन्समोनशोनासोमाळीआल्बेनियन्स" +
			"ेर्बियन्सिस्वातीसेसोथोसुंदनीसस्वीदीषस्वाहिलीतमिळतेलुगूतजिकथाईतिग्र" +
			"िन्यातुर्कमनसेत्स्वानातोंगातुर्किषत्सोगातटारउधूरयुक्रेनियन्उर्दूउज" +
			"़बेकवियत्नामीज़ओलापुकउलोफ़झ़ौसाइद्दिष्यूरुबाझ्हुन्गचीनीस्जुलूतगालो" +
			"गकोंकणीमोल्डावियन्सेर्बो-क्रोयेषियन्",
		[]uint16{ // 610 elements
			// Entry 0 - 3F
			0x0000, 0x000c, 0x0027, 0x0027, 0x0045, 0x0051, 0x0069, 0x0069,
			0x007e, 0x008d, 0x008d, 0x0099, 0x00b7, 0x00c9, 0x00ea, 0x0105,
			0x0117, 0x0117, 0x0129, 0x0141, 0x0153, 0x0153, 0x0162, 0x0162,
			0x0162, 0x017a, 0x017a, 0x0189, 0x0189, 0x0189, 0x019b, 0x01aa,
			0x01b9, 0x01b9, 0x01cb, 0x01cb, 0x01dd, 0x01ec, 0x020a, 0x021f,
			0x023d, 0x024c, 0x0264, 0x0264, 0x027c, 0x0288, 0x029a, 0x02af,
			0x02ca, 0x02d6, 0x02fe, 0x0316, 0x0328, 0x033d, 0x033d, 0x0349,
			0x035b, 0x036d, 0x036d, 0x038e, 0x038e, 0x03a9, 0x03c7, 0x03c7,
			// Entry 40 - 7F
			0x03eb, 0x040c, 0x042a, 0x042a, 0x042a, 0x0445, 0x0445, 0x0466,
			0x047b, 0x0496, 0x04ab, 0x04c0, 0x04db, 0x04db, 0x04db, 0x04db,
			0x04ea, 0x050e, 0x0526, 0x0538, 0x054d, 0x054d, 0x0562, 0x0577,
			0x0577, 0x0577, 0x058f, 0x059e, 0x059e, 0x059e, 0x059e, 0x05b3,
			0x05cb, 0x05e9, 0x05e9, 0x061f, 0x0631, 0x0631, 0x0640, 0x065e,
			0x0673, 0x068e, 0x069d, 0x06a6, 0x06bb, 0x06d3, 0x06df, 0x06df,
			0x06f1, 0x06f1, 0x06fa, 0x06fa, 0x0718, 0x0718, 0x0718, 0x0718,
			0x072d, 0x072d, 0x074b, 0x075a, 0x075a, 0x076c, 0x076c, 0x077b,
			// Entry 80 - BF
			0x07a2, 0x07c3, 0x07db, 0x0800, 0x0818, 0x0833, 0x0845, 0x086f,
			0x0884, 0x0884, 0x0893, 0x0893, 0x08a8, 0x08c3, 0x08d8, 0x08f9,
			0x0905, 0x0911, 0x0923, 0x0941, 0x095c, 0x0974, 0x0986, 0x099b,
			0x09b0, 0x09c8, 0x09d4, 0x09e6, 0x09f2, 0x09fb, 0x0a19, 0x0a2e,
			0x0a4c, 0x0a5b, 0x0a70, 0x0a82, 0x0a8e, 0x0a8e, 0x0a9a, 0x0abb,
			0x0aca, 0x0adc, 0x0adc, 0x0afd, 0x0b0f, 0x0b0f, 0x0b1e, 0x0b2d,
			0x0b42, 0x0b54, 0x0b69, 0x0b7b, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			// Entry C0 - FF
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			// Entry 100 - 13F
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87, 0x0b87,
			0x0b87, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			// Entry 140 - 17F
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99,
			0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0b99, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 180 - 1BF
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 1C0 - 1FF
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 200 - 23F
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			// Entry 240 - 27F
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab, 0x0bab,
			0x0bcc, 0x0c00,
		},
	},
	{ // ks
		"اَفاراَبخازِیاناَویستَناَفریٖکانٛزاَکاناَمہاریاَراگونیعربیاسٲمۍاَوارِکای" +
			"مارااَزَربیجانیبَشکیٖربیلَروٗشیَنبینابِسلامابَمبارابَنٛگٲلۍتِبتیبری" +
			"ٹَنبوسنِیَنکَتلانچیچَنکَموروکارسِکَنکریچیٚکچٔرچ سلاوِکچُواشویٚلشڈین" +
			"ِشجٔرمَندِویہیزونٛگکھاایٖویوٗنٲنیاَنٛگیٖزۍایٚسپَرینٹوسپینِشایٚسٹونی" +
			"َنباسکفارسیفُلاہفِنِشفِجیَنفَروسفریٚنچمغربی فرِشیَناَیرِشسکوٹِش گیے" +
			"لِکگیلِشِیَنگُوارَنیگُجرٲتیمینٛکسہاوساعبرٲنۍہِندیہِری موتوٗکروشِیَن" +
			"ہیتِیاںہَنٛگیریَناَرمینیَنہیٚریٖرواِنٹَرلِنٛگوااِنڈونیشیااِنٹَر لِن" +
			"ٛنگویےاِگبوسِچوان یٖیاِنُپِیاکاِڈوآیِسلینڈِکاِٹیلیَناِنُکتِتوٗجاپٲن" +
			"ۍجَوَنیٖزجارجِیَنکونٛگوکِکُیوٗکُوانیاماکازَخکَلالِسُتخَمیرکَنَڑکوری" +
			"َنکَنوٗریکٲشُرکُردِشکومیکورنِشکِرگِزلاتیٖنیلُکھزیمبورگِشگاندالِمبٔر" +
			"گِشلِنگالالاولِتھوانِیَنلوُبا کَتَنٛگالَتوِیَنمَلاگَسیمارشَلیٖزماور" +
			"یمیکَڈونیَنمٔلیالَممَنٛگولیمَرٲٹھۍمَلَےمَلتیٖسبٔمیٖزناورُشُمال ڈَبی" +
			"لنیٚپٲلۍڈونٛگاڈَچناروییَن نَے نورسکناروییَن بوکمالجنوب ڈیٚبیلنَواجو" +
			"نِیَنجااوکسیٖٹَناوجِبوااوٚرومواوٚرِیااوٚسیٚٹِکپَنجٲبۍپالیپالِشپَشتو" +
			"ٗپُرتَگیٖزکُویشُوارومانشرُندیرومٲنیروٗسیکِنیاوِنداسَنسکرٕتسراڈیٖنیس" +
			"ِندیشُمٲلی سَمیسَنگوسِنہالاسلووَکسلووینیَنسَمواَنشوناسومٲلیالبانِیَ" +
			"نسٔربِیَنسواتیجنوبی ستھوسَنڈَنیٖزسویٖڈِشسواہِلیتَمِلتیلگوٗتاجِکتھاے" +
			"ٹِگرِنیاتُرکمینسواناٹونٛگاتُرکِشژونٛگاتَتارتاہیشِیَنیوٗکرینیٲییاُرد" +
			"وٗاُزبیکوینداوِیَتنَمیٖزوولَپُکوَلوٗنوولوفکھوسایِدِشیورُبازُہانٛگچی" +
			"ٖنیزُلوٗاَچَےنیٖزاَکولیاَدَنٛگمیےاَدَیٖگیےاَفرِہِلیاینوٗاَکادِیَناَ" +
			"لویتیجنوٗبی اَلتاییپرون اَنٛگریٖزیاَنٛگِکااَرَمیکایرو کونِیَناَراپا" +
			"ہواَراوَکایسٹوٗریَناَوَدیبَلوٗچیبالِنیٖزباسابیجابیٚمبابوجپوٗریبِکول" +
			"بِنیسِکسِکابرٛجبُرِیَتبَگنیٖزبٕلِنکاڈوکارِباتسَمسیباونوچیٖبچاچھَگتا" +
			"ےچُکیٖزماریچِنوٗک جارگَنچوکتَوشیپویانچیٚروکیشییونکاپٹِککرٕمیٖن تُرک" +
			"یکَشوٗبِیَنڈکوٹادَرگواڈیٚلوییَرسلیوڈاگرِبڈِنکاڈوگریبوٚنِم ساربِیَند" +
			"ُوالاوَستی پُرتُگالیڈِیوٗلاایٚفِکقدیٖمی مِصریایٚکاجُکایٚلامایِٹوَسط" +
			"ی اَنٛگریٖزۍایٚوونڈوفینٛگفِلِپیٖنوفونوسطی فریٚنچپرون فریٚنچشُمٲلی ف" +
			"رِشیَنمشرِقی فرِشیَنفروٗلِیَنگاگیےیوگبایاگیٖزگِلبٔرٹیٖزوَسطی ہاے جٔ" +
			"رمَنپرون ہاے جٔرمَنگوندیگورینٹیلوگوتھِکگرِبوقدیٖم یوٗنٲنیسٕوِس جٔرم" +
			"َنگُوِچ اِنہَیداہوایِیَنہِلیٖگینَنہِتایِتہمونٛگہیٚرِم ساربِیَنہُپاا" +
			"ِباناِلوکواِنٛگُشلوجبانجوڈیو فارسیجوڈیو عربیکارا کَلپَککَبایِلکاچِن" +
			"جُوٗکامباکَویکَبارڈِیَنتَیَپکوروکھاسیکھوتَنیٖزکِمبُندوٗکونکَنیکوسری" +
			"یَنکَپیلیکراچیے بَلکارکَریلِیَنکُرُکھکُمِککُتینَےلیڈِنولَہَندالَمبا" +
			"لیزگِیَنمونٛگولوزیلوٗبا لوٗلُوالویِسینولُندالُوولُسہاےمَدُریٖزمَگاے" +
			"میتَھلیمَکَسارمَندِنٛگومَساےموکشامَندَرمیندیےوَستی ایرِشمِکمیکمِنَن" +
			"ٛگکَباومانٛچوٗمَنیپوٗریموہاکموسیواریاہ زبانکریٖکمِراندیٖزمارواڑیایٚ" +
			"رزِیانیٖپالیٹَنبوٚنِم جٔرمَننیٚوارینِیاسنِیویَننوگاےپرون نارسیایٚن " +
			"کوشمالی ستھوکلاسِکَل نیوارینِیَمویٚزینِیَنکولنِیورونَظیٖمااوٚسیجاوٹ" +
			"ومَن تُرکِشپَنٛگاسِنَنپَہلَویپَمپَنٛگاپَپِیامیٚنٹوپَلااُواںپرون فار" +
			"سیفونیٖشیَنپانپیٚیَنپرون پروویٚنچَلراجِستھٲنۍرَپانویرَروٹونٛگَنرومَ" +
			"نیاَرومانیسَندَویےیاکُتسَمارِتَن اَرامیکسَسَکسَنتالیسِچِلِیَنسکاٹسس" +
			"یٚلکُپپرون ایرِششانسِداموجنوٗبی سَمیلولیے سَمیاِناری سَمیسکولٹ سَمی" +
			"سونِنکیےسوگڈِیَنسرٛانَن ٹونٛگوسیٚریرسُکُماسُسوٗسُمیریَنسیٖریٲییٹِمن" +
			"یےٹیٚریٚنوٹیٹَمٹاےگریےتیٖوٹوکیٖلاوکِلِنگونٹِلِنگِتتاماشیکنیاسا ٹونٛ" +
			"گاٹاک پِسِنژھِمشِیانتُمبُکاتُوالوٗتُویٖنیَناُدمُرتاُگارتِکیُمبُندوٗ" +
			"روٗٹواےووتِکوالامووَریےواشوکالمِکیاویَپیٖززَپوتیٚکزیناگازوٗنیکانٛہہ" +
			" تہِ لِسانیاتی مواد نہٕزازاآسٹرِیَن جٔرمَنسٕوِس ہاےجٔرمَنآسٹریلیَن ا" +
			"َنٛگریٖزۍکینَڈِیٲیی اَنٛگریٖزۍبَرطانوی اَنٛگریٖزۍیوٗ ایٚس اَنٛگریٖز" +
			"ۍلیٹٕن امریٖکی سپینِشلِبیریَن سپینِشکَنیڈیَن فریٚنچسٕوٕس فریٚنچفلیٚ" +
			"مِشبرازیٖلی پُتَگیٖزلِبیریَن پُرتَگیٖزمولداوِیَنسیٚربو کروشِیَنسیٚو" +
			"د چیٖنیرِوٲجی چیٖنی",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000a, 0x001e, 0x002e, 0x0044, 0x004e, 0x005c, 0x006c,
			0x0074, 0x007e, 0x008c, 0x0098, 0x00ae, 0x00bc, 0x00d2, 0x00da,
			0x00e8, 0x00f6, 0x0106, 0x0110, 0x011c, 0x012c, 0x0138, 0x0142,
			0x014e, 0x015e, 0x0164, 0x016c, 0x0181, 0x018b, 0x0195, 0x019f,
			0x01ab, 0x01b7, 0x01c7, 0x01cf, 0x01dd, 0x01ef, 0x0205, 0x0211,
			0x0225, 0x022d, 0x0237, 0x0241, 0x024b, 0x0257, 0x0261, 0x026d,
			0x0286, 0x0292, 0x02ab, 0x02bd, 0x02cd, 0x02db, 0x02e7, 0x02f1,
			0x02fd, 0x0307, 0x031a, 0x032a, 0x0338, 0x034c, 0x035e, 0x036e,
			// Entry 40 - 7F
			0x0388, 0x039c, 0x03bb, 0x03c5, 0x03d8, 0x03ea, 0x03f2, 0x0406,
			0x0416, 0x042a, 0x0436, 0x0446, 0x0456, 0x0462, 0x0470, 0x0482,
			0x048c, 0x049e, 0x04a8, 0x04b2, 0x04be, 0x04cc, 0x04d6, 0x04e2,
			0x04ea, 0x04f6, 0x0502, 0x0510, 0x052a, 0x0534, 0x0546, 0x0554,
			0x055a, 0x0570, 0x058b, 0x059b, 0x05ab, 0x05bd, 0x05c7, 0x05db,
			0x05eb, 0x05fb, 0x0609, 0x0613, 0x0621, 0x062d, 0x0637, 0x064c,
			0x065a, 0x0666, 0x066c, 0x068e, 0x06ab, 0x06c0, 0x06cc, 0x06da,
			0x06ec, 0x06fa, 0x0708, 0x0716, 0x0728, 0x0736, 0x073e, 0x0748,
			// Entry 80 - BF
			0x0754, 0x0766, 0x0776, 0x0782, 0x078c, 0x0798, 0x07a2, 0x07b6,
			0x07c6, 0x07d6, 0x07e0, 0x07f5, 0x07ff, 0x080d, 0x0819, 0x082b,
			0x0839, 0x0841, 0x084d, 0x085f, 0x086f, 0x0879, 0x088c, 0x089e,
			0x08ac, 0x08ba, 0x08c4, 0x08d0, 0x08da, 0x08e2, 0x08f2, 0x0900,
			0x090a, 0x0916, 0x0922, 0x092e, 0x0938, 0x094a, 0x094a, 0x0960,
			0x096c, 0x0978, 0x0982, 0x0998, 0x09a6, 0x09b2, 0x09bc, 0x09c6,
			0x09d0, 0x09dc, 0x09ea, 0x09f4, 0x09fe, 0x0a10, 0x0a1c, 0x0a30,
			0x0a42, 0x0a42, 0x0a54, 0x0a54, 0x0a5e, 0x0a70, 0x0a70, 0x0a7e,
			// Entry C0 - FF
			0x0a7e, 0x0a99, 0x0ab6, 0x0ac6, 0x0ad4, 0x0aeb, 0x0aeb, 0x0afb,
			0x0afb, 0x0afb, 0x0b09, 0x0b09, 0x0b09, 0x0b09, 0x0b09, 0x0b1d,
			0x0b1d, 0x0b29, 0x0b37, 0x0b47, 0x0b47, 0x0b4f, 0x0b4f, 0x0b4f,
			0x0b4f, 0x0b57, 0x0b63, 0x0b63, 0x0b63, 0x0b63, 0x0b63, 0x0b63,
			0x0b73, 0x0b7d, 0x0b85, 0x0b85, 0x0b85, 0x0b93, 0x0b93, 0x0b93,
			0x0b9b, 0x0b9b, 0x0b9b, 0x0b9b, 0x0ba9, 0x0bb7, 0x0bb7, 0x0bc1,
			0x0bc1, 0x0bc9, 0x0bd3, 0x0bd3, 0x0bdd, 0x0beb, 0x0beb, 0x0bf7,
			0x0c05, 0x0c11, 0x0c19, 0x0c32, 0x0c3e, 0x0c4c, 0x0c5a, 0x0c64,
			// Entry 100 - 13F
			0x0c64, 0x0c70, 0x0c70, 0x0c89, 0x0c89, 0x0c9d, 0x0ca7, 0x0cb3,
			0x0cb3, 0x0cc5, 0x0ccd, 0x0cd9, 0x0ce3, 0x0ce3, 0x0ced, 0x0d0a,
			0x0d0a, 0x0d16, 0x0d33, 0x0d33, 0x0d41, 0x0d41, 0x0d41, 0x0d4d,
			0x0d4d, 0x0d64, 0x0d74, 0x0d88, 0x0da7, 0x0da7, 0x0db7, 0x0db7,
			0x0dc1, 0x0dd3, 0x0dd3, 0x0dd9, 0x0dd9, 0x0dee, 0x0e03, 0x0e03,
			0x0e1e, 0x0e39, 0x0e4b, 0x0e4f, 0x0e4f, 0x0e4f, 0x0e59, 0x0e63,
			0x0e63, 0x0e6b, 0x0e7f, 0x0e7f, 0x0e9d, 0x0eb9, 0x0eb9, 0x0ec3,
			0x0ed5, 0x0ee1, 0x0eeb, 0x0f04, 0x0f1b, 0x0f1b, 0x0f1b, 0x0f1b,
			// Entry 140 - 17F
			0x0f2c, 0x0f36, 0x0f36, 0x0f46, 0x0f46, 0x0f5a, 0x0f68, 0x0f74,
			0x0f91, 0x0f91, 0x0f99, 0x0fa3, 0x0fa3, 0x0faf, 0x0fbd, 0x0fbd,
			0x0fbd, 0x0fc9, 0x0fc9, 0x0fc9, 0x0fde, 0x0ff1, 0x0ff1, 0x1006,
			0x1014, 0x101e, 0x1026, 0x1030, 0x1038, 0x104c, 0x104c, 0x1056,
			0x1056, 0x1056, 0x1056, 0x105e, 0x105e, 0x1068, 0x107a, 0x107a,
			0x107a, 0x107a, 0x107a, 0x107a, 0x108c, 0x108c, 0x109a, 0x10aa,
			0x10b6, 0x10cf, 0x10cf, 0x10cf, 0x10e1, 0x10ed, 0x10ed, 0x10ed,
			0x10ed, 0x10f7, 0x1105, 0x1111, 0x1111, 0x111f, 0x1129, 0x1139,
			// Entry 180 - 1BF
			0x1139, 0x1139, 0x1139, 0x1139, 0x1139, 0x1145, 0x114d, 0x114d,
			0x114d, 0x1166, 0x1176, 0x1180, 0x1188, 0x1194, 0x1194, 0x1194,
			0x1194, 0x11a4, 0x11a4, 0x11ae, 0x11bc, 0x11ca, 0x11dc, 0x11e6,
			0x11e6, 0x11f0, 0x11fc, 0x1208, 0x1208, 0x1208, 0x121d, 0x121d,
			0x121d, 0x1229, 0x1241, 0x124f, 0x1261, 0x126b, 0x1273, 0x1273,
			0x1273, 0x1288, 0x1292, 0x12a4, 0x12b2, 0x12b2, 0x12b2, 0x12c2,
			0x12c2, 0x12c2, 0x12d6, 0x12d6, 0x12ef, 0x12fd, 0x1307, 0x1315,
			0x1315, 0x1315, 0x1315, 0x131f, 0x1332, 0x1332, 0x133f, 0x1352,
			// Entry 1C0 - 1FF
			0x1352, 0x136f, 0x1383, 0x1393, 0x139f, 0x13ad, 0x13b9, 0x13d4,
			0x13ea, 0x13f8, 0x140a, 0x1422, 0x1434, 0x1434, 0x1434, 0x1434,
			0x1434, 0x1447, 0x1447, 0x1459, 0x1459, 0x1459, 0x146b, 0x146b,
			0x1488, 0x1488, 0x1488, 0x149c, 0x14aa, 0x14c0, 0x14c0, 0x14c0,
			0x14c0, 0x14cc, 0x14cc, 0x14cc, 0x14cc, 0x14dc, 0x14dc, 0x14ec,
			0x14f6, 0x1517, 0x1517, 0x1521, 0x152f, 0x152f, 0x152f, 0x152f,
			0x1541, 0x154b, 0x154b, 0x154b, 0x154b, 0x154b, 0x154b, 0x1559,
			0x1559, 0x156c, 0x156c, 0x156c, 0x1572, 0x1572, 0x157e, 0x157e,
			// Entry 200 - 23F
			0x157e, 0x1593, 0x15a6, 0x15bb, 0x15ce, 0x15de, 0x15ee, 0x1609,
			0x1615, 0x1615, 0x1615, 0x1621, 0x162b, 0x163b, 0x163b, 0x163b,
			0x164b, 0x164b, 0x164b, 0x1657, 0x1657, 0x1667, 0x1671, 0x167f,
			0x1687, 0x1697, 0x1697, 0x16a7, 0x16b7, 0x16b7, 0x16c5, 0x16dc,
			0x16ed, 0x16ed, 0x16ed, 0x16ed, 0x16ff, 0x16ff, 0x170d, 0x171b,
			0x171b, 0x172d, 0x172d, 0x173b, 0x174b, 0x175d, 0x1765, 0x176b,
			0x176b, 0x176b, 0x176b, 0x176b, 0x1775, 0x1775, 0x1775, 0x1775,
			0x1781, 0x178b, 0x1793, 0x1793, 0x1793, 0x179f, 0x179f, 0x179f,
			// Entry 240 - 27F
			0x17a5, 0x17b1, 0x17b1, 0x17b1, 0x17b1, 0x17b1, 0x17c1, 0x17c1,
			0x17c1, 0x17cd, 0x17cd, 0x17d7, 0x180d, 0x1815, 0x1815, 0x1815,
			0x1832, 0x184f, 0x1876, 0x189f, 0x18c4, 0x18e8, 0x190e, 0x192b,
			0x192b, 0x192b, 0x1948, 0x195f, 0x195f, 0x196d, 0x198e, 0x19b1,
			0x19c5, 0x19e2, 0x19e2, 0x19f7, 0x1a0e,
		},
	},
	{ // ksb
		"KiakanKiamhaliKialabuKibelaausiKibulgaliaKibanglaKicheckiKijeumaniKigiik" +
			"iKiingeezaKihispaniaKiajemiKifalansaKihausaKihindiKihungaiKiindonesi" +
			"aKiigboKiitalianoKijapaniKijavaKikambodiaKikoleaKimalesiaKibulmaKine" +
			"paliKiholanziKipunjabiKipolandiKilenoKiomaniaKilusiKinyalwandaKisoma" +
			"liKiswidiKitamilKitailandiKituukiKiuklaniaKiulduKivietinamuKiyolubaK" +
			"ichinaKizuluKishambaa",
		[]uint16{ // 375 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0042, 0x0042, 0x0042, 0x0042, 0x0049, 0x0052, 0x0052, 0x005c,
			0x005c, 0x005c, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x006c,
			0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0073,
			0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x0082, 0x0082, 0x0082,
			// Entry 40 - 7F
			0x0082, 0x008d, 0x008d, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x009d, 0x009d, 0x00a5, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00ab, 0x00ab, 0x00b5, 0x00b5, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00c5, 0x00c5, 0x00cc, 0x00cc, 0x00cc,
			0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00e6, 0x00e6, 0x00ef,
			// Entry 80 - BF
			0x00ef, 0x00f5, 0x00f5, 0x00f5, 0x00f5, 0x00fd, 0x0103, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116,
			0x011d, 0x011d, 0x0124, 0x0124, 0x0124, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x013e,
			0x0144, 0x0144, 0x0144, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f,
			0x014f, 0x0157, 0x0157, 0x015e, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry C0 - FF
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry 100 - 13F
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			// Entry 140 - 17F
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016d,
		},
	},
	{ // ksf
		"riakanriamarikriarabribɛlɔrísribulgaríribɛngáliricɛ́kridjɛrmanrigrɛ́krii" +
			"ngɛrísrikpanyáripɛrsánripɛrɛsǝ́rikaksariíndíriɔngrɔáriindonɛsíriigbo" +
			"riitalyɛ́nrijapɔ́ŋrijawanɛ́rikmɛrrikɔrɛɛ́rimalaíribirmánrinepalɛ́riɔ" +
			"lándɛ́ripɛnjabíripɔlɔ́nripɔrtugɛ́rirɔmánrirísrirwandarisomalíriswɛ́d" +
			"ǝritamúlritaíriturkriukrɛ́nriurdúriwyɛtnámriyúubaricinɔárizúlurikpa",
		[]uint16{ // 376 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035, 0x0035,
			0x0035, 0x0035, 0x0035, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0050, 0x005b, 0x005b, 0x0064,
			0x0064, 0x0064, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x007b, 0x0082,
			0x0082, 0x008a, 0x008a, 0x008a, 0x008a, 0x0095, 0x0095, 0x0095,
			// Entry 40 - 7F
			0x0095, 0x00a1, 0x00a1, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00b3, 0x00b3, 0x00be, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
			0x00c9, 0x00c9, 0x00d0, 0x00d0, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc, 0x00dc,
			0x00dc, 0x00dc, 0x00dc, 0x00e4, 0x00e4, 0x00ed, 0x00ed, 0x00ed,
			0x00f8, 0x00f8, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0110, 0x0110, 0x011b,
			// Entry 80 - BF
			0x011b, 0x0128, 0x0128, 0x0128, 0x0128, 0x0131, 0x0137, 0x013f,
			0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x013f, 0x013f, 0x0148, 0x0148, 0x0148, 0x0148, 0x0148, 0x0148,
			0x0153, 0x0153, 0x015b, 0x015b, 0x015b, 0x0161, 0x0161, 0x0161,
			0x0161, 0x0161, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0171,
			0x0178, 0x0178, 0x0178, 0x0183, 0x0183, 0x0183, 0x0183, 0x0183,
			0x0183, 0x018b, 0x018b, 0x0194, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry C0 - FF
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry 100 - 13F
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			// Entry 140 - 17F
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x01a0,
		},
	},
	{ // ksh
		"AfahreschAbchahseschAvästahneschAfrikaansAkahneschAmhahreschArrajonehses" +
			"chArahbeschAßamehseschAvahreschAimahreschAsserbaidschahneschBaschkih" +
			"reschWiißrußeschBulljahreschBislahmeschBambaraBängjahleschTibehtesch" +
			"BettohneschBoßneschKattalahneschTschätschehneschChamorruKorseschTsch" +
			"äscheschKerscheßlahweschTschowascheschWallihseschDähneschDeutschDiv" +
			"ehjeschButahneschEweJrihscheschÄngleschEsperantoSchpahneschÄßneschBa" +
			"skeschPärseschFulfuldeFinneschFihdscheschFärröhreschFranzühseschWäßf" +
			"rihseschIhreschJallihzeschJuwarahneschGutscharateschMangxHaußaHebräh" +
			"jeschHinndiKrowateschHa’iihteschUnnjarreschArmehneschHerrehrode Inte" +
			"rlinguaIndonehseschIgboIhdoIßlänndeschEtalljähneschInuktitutJapahnes" +
			"chJavahneschJe’orjeschRekohjoOschivamboKassakkeschJröhnländeschKhmer" +
			"KannadaKorrejaaneschKanuhreschKaschmihreschKurrdeschKohmeschKornesch" +
			"KirjihseschLateijneschLuxemborjeschLuganndaLemburjeschLingjallaLahoo" +
			"teschLittoueschKilubaLätteschMadajaßkeschMaschallehseschMa’ohreschMa" +
			"zedohneschMallajalamMongjohleschMarrahteschMallaijeschMaltehseschBur" +
			"mehseschNauruheschNood-NdebeleNepallehseschNdongjahneschHolländeschN" +
			"eu NorrwehjeschNorrwehjesch BokmålNavvachoSchi-SchewaOriijaOßeetesch" +
			"PanschaabeschPollneschPaschtuuneschPochtojeseschKättschowaRätoromaan" +
			"eschK-RundeschRumäneschRußßeschKinja-RuandeschSanskritSinndiNood-Lap" +
			"pländeschSangjoSingjaleeseschẞlovakeschẞloveeneschSammohaneschSchi-S" +
			"chonaSomahleschAlbahneschSärbeschSi-SwateschSöd-SootoSindanehseschSc" +
			"hwehdeschSuahehleschTamihleschTelluhjuTadschihkeschTailändeschTijren" +
			"ejahneschTörkmehneschSe-ZwahneschTongjahneschTörkeschXi-Zongjahnesch" +
			"TattahreschTahihteschUj’juhreschUkraineschUrdu/HindiUßbehkeschWendaV" +
			"ijätnammehseschVolapükWalohneschWoloffIsi-KhohsaJiddeschJoruhbaSchin" +
			"ehsesch (Mandarin)SuhluAschenehseschAdangmeschAdygehjschTonehsesch A" +
			"rahbeschAfrehihleschAghehmeschAijnuAkahdeschAle’uhteschAhl ÄngleschA" +
			"njikahneschArrappahoAljehresch ArahbeschMarokahnesch ArahbeschÄjipte" +
			"sch ArahbeschPareAmärrekahnesche BlendeschprohchAstuhrejahneschAwahd" +
			"eschBeluhtscheschBalinehseschBaireschBasaa-SchprohcheBembaBenaBhohds" +
			"chpureschEdoBischnuprejahneschBrahjeschBrahuijeschBoddoBurejahteschB" +
			"ujinehseschBilihneschZebuwahneschKihja-SchprohchTrukehseschMahreschT" +
			"schoktohTschärrokehTschäjännZäntrahl-KurrdeschKopteschKaschuhbeschDa" +
			"kohteschDarjihneschDawedahneschDohjribeschDjermaNiddersorbeschDu’ala" +
			"MeddelnehderlängschJola-FonyischDassajahneschKîembuÄffikschEmilijahn" +
			"eschAhl ÄjipteschEkajukeschMeddelängleschZäntrahl-JuppikEwonndoFilli" +
			"pihneschFohneschFrijauhleschJahJi’is-Ahl-ÄttejohpeschJillbättehsesch" +
			"JorontalohschSchwitzerdütschHauajahneschHiligaynonHmongBovversorrbes" +
			"chHupaIbahneschIbibioIlokahneschEngjuscheschIngjrijahneschJamaikahne" +
			"sch-ÄngleschLodschbahnNjombaJühdesch-PärseschJütteschKabyhleschKamba" +
			" vun KehnijaKabadihneschChimakondeKapvärdeschKoro vun de Älfebeijnkö" +
			"ßKhasiKojra TschihniKakoKaländjihneschKimbunduKon’kahneschKpäleKara" +
			"tschaj-Balkahresch-TörkeschKarehleschKorocheschBafijahneschKölschKum" +
			"ykeschLadihneschLangode Landa-SchproocheLesjeschLakotaSilohziNood-Lu" +
			"hreschTschilubaSchilunndaLuoLuhjeschMokschahMeitei-ManipuhreschMunda" +
			"ng-ongerscheidlijje Schprohche-KrihkMirandehseschÄrsjahneschNapollet" +
			"ahneschNewahreschGyeleNjijembohnNojalNood-SohtoK’ische’KiromboArroma" +
			"hneschJackuteschNjambaijKojraboro SenniTaschelhitteschLule-Läpplände" +
			"schInahri LappländeschKommohreschSührejakkeschTetumschTigreKlingjohn" +
			"eschTok PisinTasawaqTuvinijahneschTamasicht ussem meddlere AtlasUdmu" +
			"chteschUmbundesch-onbikannte-Schprooch-WalserdütschWelahmoWaray-Wara" +
			"yKalmükkeschJämmbahKanton-SchinehseschSuhñikein SchproochSahsajeschS" +
			"chtandatt ArahbeschSödasserbaidschahneschDeutsch uß ÖhßterichDeutsch" +
			" uß de SchweijzÄnglesch uß AußtrahlijeÄnglesch uß KanadaÄnglesch uß " +
			"JruhßbrettannijeAmärrekahnesch ÄngleschSchpahnesch uß Latting-Ammärr" +
			"ikaSchpahnesch en SchpahnejeSchpahnesch en MäxikohFranzühsesch uß Ka" +
			"nadaFranzühsesch uß de SchweijzNehdersaksesch en de NederlängFlähmes" +
			"chBrasilljaanesch PochtojeseschPochtojesesch uß PochtojallSärbokowat" +
			"eschSchinehsesch (eijfache Schreff)Schinehsesch (tradizjonälle Schre" +
			"ff)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0009, 0x0014, 0x0021, 0x002a, 0x0033, 0x003d, 0x004b,
			0x0054, 0x0060, 0x0069, 0x0073, 0x0086, 0x0093, 0x00a0, 0x00ac,
			0x00b7, 0x00be, 0x00cb, 0x00d5, 0x00e0, 0x00e9, 0x00f6, 0x0107,
			0x010f, 0x0117, 0x0117, 0x0124, 0x0135, 0x0143, 0x014e, 0x0157,
			0x015e, 0x0168, 0x0172, 0x0175, 0x0180, 0x0189, 0x0192, 0x019d,
			0x01a6, 0x01ae, 0x01b7, 0x01bf, 0x01c7, 0x01d2, 0x01df, 0x01ec,
			0x01fa, 0x0201, 0x0201, 0x020c, 0x0218, 0x0226, 0x022b, 0x0231,
			0x023d, 0x0243, 0x0243, 0x024d, 0x025a, 0x0265, 0x026f, 0x0277,
			// Entry 40 - 7F
			0x0285, 0x0291, 0x0291, 0x0295, 0x0295, 0x0295, 0x0299, 0x02a6,
			0x02b4, 0x02bd, 0x02c7, 0x02d1, 0x02dd, 0x02dd, 0x02e4, 0x02ee,
			0x02f9, 0x0308, 0x030d, 0x0314, 0x0321, 0x032b, 0x0338, 0x0341,
			0x0349, 0x0351, 0x035c, 0x0367, 0x0374, 0x037c, 0x0387, 0x0390,
			0x039a, 0x03a4, 0x03aa, 0x03b3, 0x03c0, 0x03cf, 0x03db, 0x03e7,
			0x03f1, 0x03fd, 0x0408, 0x0413, 0x041e, 0x0429, 0x0433, 0x043f,
			0x044c, 0x0459, 0x0465, 0x0475, 0x0489, 0x0489, 0x0491, 0x049c,
			0x049c, 0x049c, 0x049c, 0x04a2, 0x04ac, 0x04b9, 0x04b9, 0x04c2,
			// Entry 80 - BF
			0x04cf, 0x04dc, 0x04e7, 0x04f6, 0x0500, 0x050a, 0x0514, 0x0523,
			0x052b, 0x052b, 0x0531, 0x0543, 0x0549, 0x0557, 0x0563, 0x0570,
			0x057c, 0x0587, 0x0591, 0x059b, 0x05a4, 0x05af, 0x05b9, 0x05c6,
			0x05d1, 0x05dc, 0x05e6, 0x05ee, 0x05fb, 0x0607, 0x0616, 0x0623,
			0x062f, 0x063b, 0x0644, 0x0653, 0x065e, 0x0668, 0x0675, 0x067f,
			0x0689, 0x0694, 0x0699, 0x06aa, 0x06b2, 0x06bc, 0x06c2, 0x06cc,
			0x06d4, 0x06db, 0x06db, 0x06f2, 0x06f7, 0x0704, 0x0704, 0x070e,
			0x0718, 0x072c, 0x0738, 0x0742, 0x0747, 0x0750, 0x0750, 0x075d,
			// Entry C0 - FF
			0x075d, 0x075d, 0x076a, 0x0776, 0x0776, 0x0776, 0x0776, 0x077f,
			0x0793, 0x0793, 0x0793, 0x07a9, 0x07bd, 0x07c1, 0x07e1, 0x07f0,
			0x07f0, 0x07f9, 0x0806, 0x0812, 0x081a, 0x082a, 0x082a, 0x082a,
			0x082a, 0x082a, 0x082f, 0x082f, 0x0833, 0x0833, 0x0833, 0x0833,
			0x0842, 0x0842, 0x0845, 0x0845, 0x0845, 0x0845, 0x0857, 0x0857,
			0x0860, 0x086b, 0x0870, 0x0870, 0x087c, 0x0888, 0x0888, 0x0892,
			0x0892, 0x0892, 0x0892, 0x0892, 0x0892, 0x089e, 0x08ad, 0x08ad,
			0x08ad, 0x08b8, 0x08c0, 0x08c0, 0x08c9, 0x08c9, 0x08d5, 0x08e0,
			// Entry 100 - 13F
			0x08f3, 0x08fb, 0x08fb, 0x08fb, 0x08fb, 0x0907, 0x0911, 0x091c,
			0x0928, 0x0928, 0x0928, 0x0933, 0x0933, 0x0939, 0x0939, 0x0947,
			0x0947, 0x094f, 0x0963, 0x0970, 0x0970, 0x097d, 0x0984, 0x098d,
			0x099a, 0x09a8, 0x09b2, 0x09b2, 0x09c1, 0x09d1, 0x09d8, 0x09d8,
			0x09d8, 0x09e5, 0x09e5, 0x09ed, 0x09ed, 0x09ed, 0x09ed, 0x09ed,
			0x09ed, 0x09ed, 0x09f9, 0x09fc, 0x09fc, 0x09fc, 0x09fc, 0x09fc,
			0x09fc, 0x0a15, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25,
			0x0a32, 0x0a32, 0x0a32, 0x0a32, 0x0a42, 0x0a42, 0x0a42, 0x0a42,
			// Entry 140 - 17F
			0x0a42, 0x0a42, 0x0a42, 0x0a4e, 0x0a4e, 0x0a58, 0x0a58, 0x0a5d,
			0x0a6c, 0x0a6c, 0x0a70, 0x0a79, 0x0a7f, 0x0a8a, 0x0a96, 0x0aa4,
			0x0abb, 0x0ac5, 0x0acb, 0x0acb, 0x0ade, 0x0ade, 0x0ae7, 0x0ae7,
			0x0af1, 0x0af1, 0x0af1, 0x0b02, 0x0b02, 0x0b0e, 0x0b0e, 0x0b0e,
			0x0b18, 0x0b24, 0x0b24, 0x0b3f, 0x0b3f, 0x0b44, 0x0b44, 0x0b52,
			0x0b52, 0x0b52, 0x0b56, 0x0b65, 0x0b6d, 0x0b6d, 0x0b7b, 0x0b7b,
			0x0b81, 0x0ba1, 0x0ba1, 0x0ba1, 0x0bab, 0x0bb5, 0x0bb5, 0x0bc1,
			0x0bc8, 0x0bd1, 0x0bd1, 0x0bdb, 0x0be0, 0x0bf3, 0x0bf3, 0x0bfb,
			// Entry 180 - 1BF
			0x0bfb, 0x0bfb, 0x0bfb, 0x0c01, 0x0c01, 0x0c01, 0x0c08, 0x0c15,
			0x0c15, 0x0c1e, 0x0c1e, 0x0c28, 0x0c2b, 0x0c2b, 0x0c33, 0x0c33,
			0x0c33, 0x0c33, 0x0c33, 0x0c33, 0x0c33, 0x0c33, 0x0c33, 0x0c33,
			0x0c33, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b,
			0x0c3b, 0x0c3b, 0x0c3b, 0x0c3b, 0x0c4e, 0x0c4e, 0x0c4e, 0x0c4e,
			0x0c55, 0x0c72, 0x0c77, 0x0c84, 0x0c84, 0x0c84, 0x0c84, 0x0c90,
			0x0c90, 0x0c90, 0x0c9f, 0x0c9f, 0x0c9f, 0x0ca9, 0x0ca9, 0x0ca9,
			0x0ca9, 0x0cae, 0x0cb8, 0x0cbd, 0x0cbd, 0x0cbd, 0x0cbd, 0x0cc7,
			// Entry 1C0 - 1FF
			0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7,
			0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7,
			0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7, 0x0cc7,
			0x0cc7, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3, 0x0cd3,
			0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0cda, 0x0ce6, 0x0ce6, 0x0ce6,
			0x0cf0, 0x0cf0, 0x0cf0, 0x0cf0, 0x0cf0, 0x0cf0, 0x0cf8, 0x0cf8,
			0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8, 0x0cf8,
			0x0d07, 0x0d07, 0x0d07, 0x0d16, 0x0d16, 0x0d16, 0x0d16, 0x0d16,
			// Entry 200 - 23F
			0x0d16, 0x0d16, 0x0d29, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d3d,
			0x0d3d, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d3d, 0x0d48, 0x0d48,
			0x0d56, 0x0d56, 0x0d56, 0x0d56, 0x0d56, 0x0d56, 0x0d5e, 0x0d63,
			0x0d63, 0x0d63, 0x0d63, 0x0d70, 0x0d70, 0x0d70, 0x0d70, 0x0d70,
			0x0d79, 0x0d79, 0x0d79, 0x0d79, 0x0d79, 0x0d79, 0x0d79, 0x0d79,
			0x0d80, 0x0d8e, 0x0dac, 0x0db7, 0x0db7, 0x0dc1, 0x0dd7, 0x0dd7,
			0x0dd7, 0x0dd7, 0x0dd7, 0x0dd7, 0x0dd7, 0x0dd7, 0x0dd7, 0x0de4,
			0x0deb, 0x0df6, 0x0df6, 0x0df6, 0x0df6, 0x0e02, 0x0e02, 0x0e02,
			// Entry 240 - 27F
			0x0e02, 0x0e02, 0x0e02, 0x0e0a, 0x0e0a, 0x0e1d, 0x0e1d, 0x0e1d,
			0x0e1d, 0x0e1d, 0x0e1d, 0x0e23, 0x0e31, 0x0e3b, 0x0e4f, 0x0e66,
			0x0e7d, 0x0e94, 0x0eae, 0x0ec2, 0x0ee1, 0x0efa, 0x0f1c, 0x0f35,
			0x0f4c, 0x0f4c, 0x0f64, 0x0f81, 0x0fa0, 0x0faa, 0x0fc7, 0x0fe3,
			0x0fe3, 0x0ff2, 0x0ff2, 0x1011, 0x1036,
		},
	},
	{ // kw
		"kernewek",
		[]uint16{ // 90 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0008,
		},
	},
	{ // ky
		kyLangStr,
		kyLangIdx,
	},
	{ // lag
		"KɨakáaniKɨmʉháariKɨaráabuKɨberalúusiKɨbulugáriaKɨbangálaKɨchéekiKɨjerʉmá" +
			"aniKɨgiríkiKɨɨngeréesaKɨhispániaKɨajéemiKɨfaráansaKɨhaúusaKɨhíindiKɨ" +
			"hungáriKɨɨndonésiaKiígiboKɨtaliáanoKɨjapáaniKɨjáavaKɨkambódiaKɨkoréa" +
			"KɨmelésiaKɨbáamaKɨnepáaliKɨholáanziKɨpúnjabiKɨpólandiKɨréenoKɨromaní" +
			"aKɨrúusiKɨnyarwáandaKɨsómáaliKɨswíidiKɨtamíiliKɨtáilandiKɨturúukiKɨu" +
			"kɨraníaKɨúrduKɨvietináamuKɨyorúubaKɨchíinaKɨzúuluKɨlaangi",
		[]uint16{ // 381 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x002d, 0x003a,
			0x003a, 0x003a, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0045, 0x0045, 0x0045, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f,
			0x005d, 0x005d, 0x005d, 0x005d, 0x0067, 0x0075, 0x0075, 0x0081,
			0x0081, 0x0081, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x0097,
			0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x0097, 0x00a1,
			0x00a1, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00b6, 0x00b6, 0x00b6,
			// Entry 40 - 7F
			0x00b6, 0x00c4, 0x00c4, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00d8, 0x00d8, 0x00e3, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00f8, 0x00f8, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x010c, 0x010c, 0x0115, 0x0115, 0x0115,
			0x0120, 0x0120, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c, 0x012c,
			0x012c, 0x012c, 0x012c, 0x012c, 0x012c, 0x0137, 0x0137, 0x0142,
			// Entry 80 - BF
			0x0142, 0x014b, 0x014b, 0x014b, 0x014b, 0x0156, 0x015f, 0x016d,
			0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d,
			0x016d, 0x016d, 0x0179, 0x0179, 0x0179, 0x0179, 0x0179, 0x0179,
			0x0183, 0x0183, 0x018e, 0x018e, 0x018e, 0x019a, 0x019a, 0x019a,
			0x019a, 0x019a, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01b2,
			0x01ba, 0x01ba, 0x01ba, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8,
			0x01c8, 0x01d3, 0x01d3, 0x01dd, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry C0 - FF
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry 100 - 13F
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			// Entry 140 - 17F
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6,
			0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01ef,
		},
	},
	{ // lb
		"AfarAbchaseschAvesteschAfrikaansAkanAmhareschAragoneseschArabeschAssames" +
			"eschAwareschAymaraAserbaidschaneschBaschkireschWäissrusseschBulgares" +
			"chBislamaBambara-SproochBengaleschTibeteschBretoneschBosneschKatalan" +
			"eschTschetscheneschChamorro-SproochKorseschCreeTschecheschKierchesla" +
			"weschTschuwascheschWaliseschDäneschDäitschMaldiveschBhutaneschEwe-Sp" +
			"roochGriicheschEngleschEsperantoSpueneschEstneschBaskeschPerseschFul" +
			"FinneschFidschianeschFäröeschFranséischWestfrieseschIreschSchottesch" +
			"t GälleschGalizeschGuaraniGujaratiManxHausaHebräeschHindiHiri-MotuKr" +
			"oateschHaitianeschUngareschArmeneschHerero-SproochInterlinguaIndones" +
			"eschInterlingueIgbo-SproochSichuan YiInupiakIdo-SproochIslänneschIta" +
			"lieneschInukitutJapaneschJavaneschGeorgeschKongoleseschKikuyu-Sprooc" +
			"hKwanyamaKasacheschGrönlänneschKambodschaneschKannadaKoreaneschKanur" +
			"i-SproochKaschmireschKurdeschKomi-SproochKorneschKirgiseschLatäinLët" +
			"zebuergeschGanda-SproochLimburgeschLingalaLaoteschLitaueschLuba-Kata" +
			"ngaLetteschMalagassi-SproochMarschalleseschMaoriMazedoneschMalayalam" +
			"MongoleschMarathiMalaieschMalteseschBirmaneschNaurueschNord-Ndebele-" +
			"SproochNepaleseschNdongaHollänneschNorwegesch NynorskNorwegesch Bokm" +
			"ålSüd-Ndebele-SproochNavajoNyanja-SproochOkzitaneschOjibwa-SproochO" +
			"romoOrijaOsseteschPandschabeschPaliPolneschPaschtuPortugiseschQuechu" +
			"aRätoromaneschRundi-SproochRumäneschRusseschRuandeschSanskritSardesc" +
			"hSindhiNordsameschSangoSinghaleseschSlowakeschSloweneschSamoaneschSh" +
			"onaSomaliAlbaneschSerbeschSwaziSüd-Sotho-SproochSundaneseschSchwedes" +
			"chSuaheliTamileschTeluguTadschikeschThailänneschTigrinjaTurkmeneschT" +
			"swana-SproochTongaeschTierkeschTsongaTatareschTahiteschUigureschUkra" +
			"ineschUrduUsbekeschVenda-SproochVietnameseschVolapükWallouneschWolof" +
			"XhosaJiddeschYorubaZhuangChineseschZuluAceh-SproochAcholi-SproochAda" +
			"ngmeAdygéieschTunesescht ArabeschAfrihiliAghemAinu-SproochAkkadeschA" +
			"labamaAleuteschGegeschSüd-AlaeschAlengleschAngikaAramäeschMapudungun" +
			"AraonaArapaho-SproochAlgerescht ArabeschArawak-SproochMarokkanescht " +
			"ArabeschEgyptescht ArabeschAsu (Tanzania)Amerikanesch ZeechesproochA" +
			"sturianeschKotavaAwadhiBelutscheschBalineseschBaireschBasaa-SproochB" +
			"amunBatak TobaGhomálá’BedauyeBemba-SproochBetawiBenaBafutBadagaBhods" +
			"chpuriBikol-SproochBini-SproochBanjareseschKomBlackfoot-SproochBishn" +
			"upriyaBachtiareschBraj-BhakhaBrahuiBodoAkooseBurjateschBugineseschBu" +
			"luBlinMedumbaCaddoKaribeschCayugaAtsamCebuanoKigaChibcha-SproochTsch" +
			"agataeschTrukeseschMariChinookChoctawChipewyanCherokeeCheyenneSorani" +
			"KopteschCapiznonKrimtatareschKaschubeschDakota-SproochDargineschTait" +
			"aDelaware-SproochSlaveDogribDinka-SproochZarmaDogriNiddersorbeschZen" +
			"tral-DusunDualaMëttelhollänneschJola-FonyiDyula-SproochDazagaKiembuE" +
			"fikEmilianeschEgypteschEkajukElameschMëttelengleschYup’ikEwondoExtre" +
			"madureschPangwe-SproochFilipinoMeänkieliFon-SproochCajunMëttelfransé" +
			"ischAlfranséischFrankoprovenzaleschNordfrieseschOstfrieseschFriulesc" +
			"hGa-SproochGagauseschGan-ChineseschGayoGbaya-SproochZoroastrianescht" +
			" DariGeezGilberteseschGilakiMëttelhéichdäitschAlhéichdäitschGoan-Kon" +
			"kaniGondi-SproochMongondouGoteschGrebo-SproochAlgriicheschSchwäizerd" +
			"äitschWayuuFarefareGusii-SproochKutchin-SproochHaida-SproochHakka-C" +
			"hineseschHawaieschFidschi-HindiHiligaynon-SproochHethiteschMiao-Spro" +
			"ochUewersorbeschXiang-ChineseschHupaIbanIbibioIlokano-SproochIngusch" +
			"eschIschoreschJamaikanesch-KreoleschLojbanNgombaMachameJiddesch-Pers" +
			"eschJiddesch-ArabeschJüteschKarakalpakeschKabyleschKachin-SproochJju" +
			"KambaKawiKabardineschKanembuTyapMakondeKabuverdianuKenyangKoroKainga" +
			"ngKhasi-SproochSakeschKoyra ChiiniKhowarKirmanjkiKakoKalenjinKimbund" +
			"u-SproochKomi-PermiakKonkaniKosraeaneschKpelle-SproochKaratschaiesch" +
			"-BalkareschKrioKinaray-aKareleschOraon-SproochShambalaBafiaKölschKum" +
			"ükeschKutenai-SproochLadinoLangiLahndaLamba-SproochLesgeschLingua F" +
			"ranca NovaLigureschLiveschLakota-SproochLombardeschMongoRotse-Sprooc" +
			"hLettgalleschLuba-LuluaLuiseno-SproochLunda-SproochLuo-SproochLushai" +
			"-SproochOlulujiaKlassescht ChineseschLasesch SproochMadureseschMafaK" +
			"hottaMaithiliMakassareschManding-SproochMassai-SproochMabaMokshaMand" +
			"areseschMende-SproochMeru-SproochMorisyenMëttelireschMakhuwa-MeettoM" +
			"eta’Micmac-SproochMinangkabau-SproochMandschureschMeithei-SproochMoh" +
			"awk-SproochMossi-SproochWest-MariMundangMéisproochegMuskogee-Sprooch" +
			"MirandeseschMarwariMentawaiMyeneErsja-MordwineschMazandaraniMin-Nan-" +
			"ChineseschNeapolitaneschNamaNidderdäitschNewariNias-SproochNiue-Spro" +
			"ochAo NagaKwasioNgiemboonNogaiAlnordeschNovialN’KoNord-Sotho-Sprooch" +
			"NuerAl-NewariNyamwezi-SproochNyankoleNyoroNzimaOsage-SproochOsmanesc" +
			"hPangasinan-SproochMëttelperseschPampanggan-SproochPapiamentoPalauPi" +
			"cardeschPennsylvaniadäitschPlattdäitschAlperseschPfälzesch DäitschPh" +
			"önikeschPiemonteseschPonteschPonapeaneschPreiseschAlprovenzaleschQu" +
			"iché-SproochKichwa (Chimborazo-Gebidder)RajasthaniOuschterinsel-Spro" +
			"ochRarotonganeschRomagnolTarifitRomboRomaniRotumaneschRussineschRovi" +
			"anaAromuneschRwaSandawe-SproochJakuteschSamaritaneschSamburuSasakSan" +
			"taliSaurashtraNgambaySanguSizilianeschSchotteschSassareseschSenecaSe" +
			"naSeriSelkupeschKoyra SenniAlireschSamogiteschTaschelhitSchan-Sprooc" +
			"hTschadesch-ArabeschSidamoNidderschleseschSelayarSüdsameschLule-Lapp" +
			"eschInari-LappeschSkolt-LappeschSoninke-SproochSogdeschSrananeschSer" +
			"er-SproochSahoSaterfrieseschSukuma-SproochSusuSumereschKomoreschAlsy" +
			"reschSyreschSchleseschTuluTemneTesoTereno-SproochTetum-SproochTigreT" +
			"iv-SproochTokelauaneschTsachureschKlingoneschTlingit-SproochTaleschT" +
			"amaseqTsonga-SproochNeimelaneseschTuroyoSeediqTsakoneschTsimshian-Sp" +
			"roochTateschTumbuka-SproochElliceaneschTasawaqTuwineschMëttlert-Atla" +
			"s-TamazightUdmurteschUgariteschMbundu-SproochRootVai-SproochVenezesc" +
			"hWepseschWestflämeschMainfränkeschWoteschVoroVunjoWalliserdäitschWal" +
			"amo-SproochWarayWasho-SproochWu-ChineseschKalmückeschMingrelesch Spr" +
			"oochSogaYao-SproochYapeseschYangbenYembaNheengatuKantoneseschZapotek" +
			"eschBliss-SymbolerSeelänneschZenagaMarokkanescht Standard-TamazightZ" +
			"uni-SproochKeng SproochinhalterZazaModernt HéicharabeschÉisträichesc" +
			"ht DäitschSchwäizer HéichdäitschAustralescht EngleschKanadescht Engl" +
			"eschBritescht EngleschAmerikanescht EngleschLatäinamerikanescht Spue" +
			"neschEuropäescht SpueneschMexikanescht SpueneschKanadescht Franséisc" +
			"hSchwäizer FranséischFlämeschBrasilianescht PortugiseschEuropäescht " +
			"PortugiseschMoldaweschSerbo-KroateschKongo-SwahiliChinesesch (verein" +
			"facht)Chinesesch (traditionell)",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000e, 0x0017, 0x0020, 0x0024, 0x002d, 0x0039,
			0x0041, 0x004c, 0x0054, 0x005a, 0x006b, 0x0077, 0x0085, 0x008f,
			0x0096, 0x00a5, 0x00af, 0x00b8, 0x00c2, 0x00ca, 0x00d5, 0x00e4,
			0x00f4, 0x00fc, 0x0100, 0x010b, 0x011a, 0x0128, 0x0131, 0x0139,
			0x0141, 0x014b, 0x0155, 0x0160, 0x016a, 0x0172, 0x017b, 0x0184,
			0x018c, 0x0194, 0x019c, 0x019f, 0x01a7, 0x01b4, 0x01be, 0x01c9,
			0x01d6, 0x01dc, 0x01f1, 0x01fa, 0x0201, 0x0209, 0x020d, 0x0212,
			0x021c, 0x0221, 0x022a, 0x0233, 0x023e, 0x0247, 0x0250, 0x025e,
			// Entry 40 - 7F
			0x0269, 0x0274, 0x027f, 0x028b, 0x0295, 0x029c, 0x02a7, 0x02b2,
			0x02bd, 0x02c5, 0x02ce, 0x02d7, 0x02e0, 0x02ec, 0x02fa, 0x0302,
			0x030c, 0x031a, 0x0329, 0x0330, 0x033a, 0x0348, 0x0354, 0x035c,
			0x0368, 0x0370, 0x037a, 0x0381, 0x0390, 0x039d, 0x03a8, 0x03af,
			0x03b7, 0x03c0, 0x03cc, 0x03d4, 0x03e5, 0x03f4, 0x03f9, 0x0404,
			0x040d, 0x0417, 0x041e, 0x0427, 0x0431, 0x043b, 0x0444, 0x0458,
			0x0463, 0x0469, 0x0475, 0x0487, 0x0499, 0x04ad, 0x04b3, 0x04c1,
			0x04cc, 0x04da, 0x04df, 0x04e4, 0x04ed, 0x04fa, 0x04fe, 0x0506,
			// Entry 80 - BF
			0x050d, 0x0519, 0x0520, 0x052e, 0x053b, 0x0545, 0x054d, 0x0556,
			0x055e, 0x0566, 0x056c, 0x0577, 0x057c, 0x0589, 0x0593, 0x059d,
			0x05a7, 0x05ac, 0x05b2, 0x05bb, 0x05c3, 0x05c8, 0x05da, 0x05e6,
			0x05f0, 0x05f7, 0x0600, 0x0606, 0x0612, 0x061f, 0x0627, 0x0632,
			0x0640, 0x0649, 0x0652, 0x0658, 0x0661, 0x066a, 0x0673, 0x067d,
			0x0681, 0x068a, 0x0697, 0x06a4, 0x06ac, 0x06b7, 0x06bc, 0x06c1,
			0x06c9, 0x06cf, 0x06d5, 0x06df, 0x06e3, 0x06ef, 0x06fd, 0x0704,
			0x070f, 0x0722, 0x072a, 0x072f, 0x073b, 0x0744, 0x074b, 0x0754,
			// Entry C0 - FF
			0x075b, 0x0767, 0x0771, 0x0777, 0x0781, 0x078b, 0x0791, 0x07a0,
			0x07b3, 0x07b3, 0x07c1, 0x07d7, 0x07ea, 0x07f8, 0x0812, 0x081e,
			0x0824, 0x082a, 0x0836, 0x0841, 0x0849, 0x0856, 0x085b, 0x0865,
			0x0871, 0x0878, 0x0885, 0x088b, 0x088f, 0x0894, 0x089a, 0x089a,
			0x08a5, 0x08b2, 0x08be, 0x08ca, 0x08cd, 0x08de, 0x08e9, 0x08f5,
			0x0900, 0x0906, 0x090a, 0x0910, 0x091a, 0x0925, 0x0929, 0x092d,
			0x0934, 0x0939, 0x0942, 0x0948, 0x094d, 0x0954, 0x0958, 0x0967,
			0x0974, 0x097e, 0x0982, 0x0989, 0x0990, 0x0999, 0x09a1, 0x09a9,
			// Entry 100 - 13F
			0x09af, 0x09b7, 0x09bf, 0x09cc, 0x09cc, 0x09d7, 0x09e5, 0x09ef,
			0x09f4, 0x0a04, 0x0a09, 0x0a0f, 0x0a1c, 0x0a21, 0x0a26, 0x0a34,
			0x0a41, 0x0a46, 0x0a59, 0x0a63, 0x0a70, 0x0a76, 0x0a7c, 0x0a80,
			0x0a8b, 0x0a94, 0x0a9a, 0x0aa2, 0x0ab1, 0x0ab9, 0x0abf, 0x0acd,
			0x0adb, 0x0ae3, 0x0aed, 0x0af8, 0x0afd, 0x0b0f, 0x0b1c, 0x0b2f,
			0x0b3c, 0x0b48, 0x0b51, 0x0b5b, 0x0b65, 0x0b73, 0x0b77, 0x0b84,
			0x0b99, 0x0b9d, 0x0baa, 0x0bb0, 0x0bc5, 0x0bd5, 0x0be1, 0x0bee,
			0x0bf7, 0x0bfe, 0x0c0b, 0x0c17, 0x0c29, 0x0c2e, 0x0c36, 0x0c43,
			// Entry 140 - 17F
			0x0c52, 0x0c5f, 0x0c6f, 0x0c78, 0x0c85, 0x0c97, 0x0ca1, 0x0cad,
			0x0cba, 0x0cca, 0x0cce, 0x0cd2, 0x0cd8, 0x0ce7, 0x0cf2, 0x0cfc,
			0x0d12, 0x0d18, 0x0d1e, 0x0d25, 0x0d36, 0x0d47, 0x0d4f, 0x0d5d,
			0x0d66, 0x0d74, 0x0d77, 0x0d7c, 0x0d80, 0x0d8c, 0x0d93, 0x0d97,
			0x0d9e, 0x0daa, 0x0db1, 0x0db5, 0x0dbd, 0x0dca, 0x0dd1, 0x0ddd,
			0x0de3, 0x0dec, 0x0df0, 0x0df8, 0x0e08, 0x0e14, 0x0e1b, 0x0e27,
			0x0e35, 0x0e4e, 0x0e52, 0x0e5b, 0x0e64, 0x0e71, 0x0e79, 0x0e7e,
			0x0e85, 0x0e8f, 0x0e9e, 0x0ea4, 0x0ea9, 0x0eaf, 0x0ebc, 0x0ec4,
			// Entry 180 - 1BF
			0x0ed6, 0x0edf, 0x0ee6, 0x0ef4, 0x0eff, 0x0f04, 0x0f11, 0x0f11,
			0x0f1d, 0x0f27, 0x0f36, 0x0f43, 0x0f4e, 0x0f5c, 0x0f64, 0x0f79,
			0x0f88, 0x0f93, 0x0f97, 0x0f9d, 0x0fa5, 0x0fb1, 0x0fc0, 0x0fce,
			0x0fd2, 0x0fd8, 0x0fe4, 0x0ff1, 0x0ffd, 0x1005, 0x1012, 0x1020,
			0x1027, 0x1035, 0x1048, 0x1055, 0x1064, 0x1072, 0x107f, 0x1088,
			0x108f, 0x109c, 0x10ac, 0x10b8, 0x10bf, 0x10c7, 0x10cc, 0x10dd,
			0x10e8, 0x10fa, 0x1108, 0x110c, 0x111a, 0x1120, 0x112c, 0x1138,
			0x113f, 0x1145, 0x114e, 0x1153, 0x115d, 0x1163, 0x1169, 0x117b,
			// Entry 1C0 - 1FF
			0x117f, 0x1188, 0x1198, 0x11a0, 0x11a5, 0x11aa, 0x11b7, 0x11c0,
			0x11d2, 0x11e1, 0x11f3, 0x11fd, 0x1202, 0x120c, 0x120c, 0x1220,
			0x122d, 0x1237, 0x124a, 0x1255, 0x1262, 0x126a, 0x1276, 0x127f,
			0x128e, 0x129d, 0x12b9, 0x12c3, 0x12d8, 0x12e6, 0x12ee, 0x12f5,
			0x12fa, 0x1300, 0x130b, 0x1315, 0x131c, 0x1326, 0x1329, 0x1338,
			0x1341, 0x134e, 0x1355, 0x135a, 0x1361, 0x136b, 0x1372, 0x1377,
			0x1383, 0x138d, 0x1399, 0x1399, 0x139f, 0x13a3, 0x13a7, 0x13b1,
			0x13bc, 0x13c4, 0x13cf, 0x13d9, 0x13e6, 0x13f9, 0x13ff, 0x140f,
			// Entry 200 - 23F
			0x1416, 0x1421, 0x142e, 0x143c, 0x144a, 0x1459, 0x1461, 0x146b,
			0x1478, 0x147c, 0x148a, 0x1498, 0x149c, 0x14a5, 0x14ae, 0x14b7,
			0x14be, 0x14c8, 0x14cc, 0x14d1, 0x14d5, 0x14e3, 0x14f0, 0x14f5,
			0x1500, 0x150d, 0x1518, 0x1523, 0x1532, 0x1539, 0x1540, 0x154e,
			0x155c, 0x1562, 0x1568, 0x1572, 0x1583, 0x158a, 0x1599, 0x15a5,
			0x15ac, 0x15b5, 0x15ce, 0x15d8, 0x15e2, 0x15f0, 0x15f4, 0x15ff,
			0x1608, 0x1610, 0x161d, 0x162b, 0x1632, 0x1636, 0x163b, 0x164b,
			0x1659, 0x165e, 0x166b, 0x166b, 0x1678, 0x1684, 0x1697, 0x169b,
			// Entry 240 - 27F
			0x16a6, 0x16af, 0x16b6, 0x16bb, 0x16c4, 0x16d0, 0x16db, 0x16e9,
			0x16f5, 0x16fb, 0x171b, 0x1727, 0x173b, 0x173f, 0x1755, 0x1755,
			0x176e, 0x1787, 0x179c, 0x17af, 0x17c1, 0x17d7, 0x17f5, 0x180b,
			0x1821, 0x1821, 0x1837, 0x184d, 0x184d, 0x1856, 0x1871, 0x188a,
			0x1894, 0x18a3, 0x18b0, 0x18c8, 0x18e1,
		},
	},
	{ // lg
		"Lu-akaaniLu-amharikiLuwarabuLubelarusiLubulugariyaLubengaliLuceekeLudaak" +
			"iLugereeki/LuyonaaniLungerezaLusipanyaLuperusiLufalansaLuhawuzaLuhin" +
			"duLuhangareLuyindonezyaLuyiboLuyitaleLujapaniLunnajjavaLukmeLukoreya" +
			"LugandaLumalayiLubbamaLunepaliLuholandiLupunjabiLupolandiLupotugiizi" +
			"LulomaniyaLulasaLunarwandaLusomaliyaLuswideniLutamiiruLuttaayiLutake" +
			"LuyukurayineLu-uruduLuvyetinaamuLuyorubaLucayinaLuzzulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001c, 0x001c, 0x001c, 0x001c, 0x001c, 0x001c, 0x0026, 0x0032,
			0x0032, 0x0032, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x0049, 0x0049, 0x0049, 0x0049, 0x005c, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x007f,
			0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x007f, 0x0087,
			0x0087, 0x008e, 0x008e, 0x008e, 0x008e, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b1, 0x00b1, 0x00b9, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00c8, 0x00c8, 0x00d0, 0x00d0, 0x00d0, 0x00d0,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d7, 0x00d7, 0x00d7,
			0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7, 0x00d7,
			0x00d7, 0x00d7, 0x00d7, 0x00df, 0x00df, 0x00e6, 0x00e6, 0x00e6,
			0x00ee, 0x00ee, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x0100, 0x0100, 0x0109,
			// Entry 80 - BF
			0x0109, 0x0114, 0x0114, 0x0114, 0x0114, 0x011e, 0x0124, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138,
			0x0141, 0x0141, 0x014a, 0x014a, 0x014a, 0x0152, 0x0152, 0x0152,
			0x0152, 0x0152, 0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0164,
			0x016c, 0x016c, 0x016c, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0180, 0x0180, 0x0188, 0x018f,
		},
	},
	{ // lkt
		"Abkhaz IyápiAvestan IyápiAfrikaans IyápiAmharic IyápiArab IyápiAssamese " +
			"IyápiAvaric IyápiAzerbaijani IyápiBashkir IyápiBelarus IyápiBulgar I" +
			"yápiBengali IyápiTibetan IyápiBosnia IyápiCatalan IyápiChechen Iyápi" +
			"Maštíŋča Oyáte IyápiCzech IyápiChuvash IyápiWales IyápiDane IyápiIyá" +
			"šiča IyápiGreece IyápiWašíčuiyapiEsperanto IyápiSpayóla IyápiEstoni" +
			"a IyápiBasque IyápiPersian IyápiFinnish IyápiFiji IyápiFaroese Iyápi" +
			"Wašíču Ikčéka IyápiIrish IyápiGalician IyápiGuarani IyápiGujarati Iy" +
			"ápiHausa IyápiHebrew IyápiHindi IyápiCroatian IyápiHaiti IyápiHunga" +
			"ry IyápiArmenia IyápiIndonesia IyápiIgbo IyápiIceland IyápiItalia Iy" +
			"ápiKisúŋla IyápiJava IyápiGeoria IyápiKazakh IyápiKhmer IyápiKannad" +
			"a IyápiKorea IyápiKashmir IyápiKurd IyápiKirghiz IyápiLatin IyápiLux" +
			"embourg IyápiLao IyápiLithuania IyápiltLatvia IyápiMalagasy IyápiMao" +
			"ri IyápiMacedonia IyápiMalayalam IyápiMarathi IyápiMalay IyápiMaltes" +
			"e IyápiBurmese IyápiNepal IyápiDutch IyápiŠináglegleǧa IyápiȞaȟátȟuŋ" +
			"waŋ IyápiOriya IyápiPunjabi IyápiPolish IyápiPashto IyápiPortuguese " +
			"IyápiQuechua IyápiRomansh IyápiRomanian IyápiRussia IyápiSanskrit Iy" +
			"ápiSindhi IyápiSinhala IyápiSlovak IyápiSlovenian IyápiSomali Iyápi" +
			"Albanian IyápiSerbia IyápiSundanese IyápiSwedish IyápiSwahili IyápiT" +
			"amil IyápiTelugu IyápiTajik IyápiThai IyápiTigrinya IyápiTurkmen Iyá" +
			"piTongan IyápiTurkish IyápiTatar IyápiUyghur IyápiUkrain IyápiUrdu I" +
			"yápiUzbek IyápiVietnamese IyápiWolof IyápiXhosa IyápiYoruba IyápiPȟe" +
			"čhókaŋ Háŋska IyápiZulu IyápiAdyghe IyápiItóǧata Altai IyápiMaȟpíya" +
			" Tȟó IyápiBaluchi IyápiBamun IyápiBeja IyápiBuriat IyápiMari IyápiCh" +
			"erokee IyápiŠahíyela IyápiCoptic IyápiCrimean Turkish IyápiDakȟótiya" +
			"piDargwa IyápiDogri IyápiFilipino IyápiGbaya IyápiHawaiian IyápiIngu" +
			"sh IyápiKara-Kalpak IyápiKabardian IyápiLahnda IyápiLakȟólʼiyapiMizo" +
			" IyápiNamipuri IyápiComonian IyápiTukté iyápi tȟaŋíŋ šniZaza IyápiŠa" +
			"gláša WašíčuiyapiMílahaŋska WašíčuiyapiWiyóȟpeyata Spayóla IyápiSpay" +
			"ólaȟča IyápiFlemish IyápiPȟečhókaŋ Háŋska Iyápi IkčékaPȟečhókaŋ Háŋ" +
			"ska Iyápi Ȟče",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000d, 0x001b, 0x002b, 0x002b, 0x0039, 0x0039,
			0x0044, 0x0053, 0x0060, 0x0060, 0x0072, 0x0080, 0x008e, 0x009b,
			0x009b, 0x009b, 0x00a9, 0x00b7, 0x00b7, 0x00c4, 0x00d2, 0x00e0,
			0x00e0, 0x00e0, 0x00fa, 0x0106, 0x0106, 0x0114, 0x0120, 0x012b,
			0x013c, 0x013c, 0x013c, 0x013c, 0x0149, 0x0157, 0x0167, 0x0176,
			0x0184, 0x0191, 0x019f, 0x019f, 0x01ad, 0x01b8, 0x01c6, 0x01df,
			0x01df, 0x01eb, 0x01eb, 0x01fa, 0x0208, 0x0217, 0x0217, 0x0223,
			0x0230, 0x023c, 0x023c, 0x024b, 0x0257, 0x0265, 0x0273, 0x0273,
			// Entry 40 - 7F
			0x0273, 0x0283, 0x0283, 0x028e, 0x028e, 0x028e, 0x028e, 0x029c,
			0x02a9, 0x02a9, 0x02b9, 0x02c4, 0x02d1, 0x02d1, 0x02d1, 0x02d1,
			0x02de, 0x02de, 0x02ea, 0x02f8, 0x0304, 0x0304, 0x0312, 0x031d,
			0x031d, 0x031d, 0x032b, 0x0337, 0x0348, 0x0348, 0x0348, 0x0348,
			0x0352, 0x0364, 0x0364, 0x0371, 0x0380, 0x0380, 0x038c, 0x039c,
			0x03ac, 0x03ac, 0x03ba, 0x03c6, 0x03d4, 0x03e2, 0x03e2, 0x03e2,
			0x03ee, 0x03ee, 0x03fa, 0x03fa, 0x03fa, 0x03fa, 0x0410, 0x0410,
			0x0410, 0x0428, 0x0428, 0x0434, 0x0434, 0x0442, 0x0442, 0x044f,
			// Entry 80 - BF
			0x045c, 0x046d, 0x047b, 0x0489, 0x0489, 0x0498, 0x04a5, 0x04a5,
			0x04b4, 0x04b4, 0x04c1, 0x04c1, 0x04c1, 0x04cf, 0x04dc, 0x04ec,
			0x04ec, 0x04ec, 0x04f9, 0x0508, 0x0515, 0x0515, 0x0515, 0x0525,
			0x0533, 0x0541, 0x054d, 0x055a, 0x0566, 0x0571, 0x0580, 0x058e,
			0x058e, 0x059b, 0x05a9, 0x05a9, 0x05b5, 0x05b5, 0x05c2, 0x05cf,
			0x05da, 0x05e6, 0x05e6, 0x05f7, 0x05f7, 0x05f7, 0x0603, 0x060f,
			0x060f, 0x061c, 0x061c, 0x0639, 0x0644, 0x0644, 0x0644, 0x0644,
			0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651, 0x0651,
			// Entry C0 - FF
			0x0651, 0x0667, 0x0667, 0x0667, 0x0667, 0x0667, 0x0667, 0x067d,
			0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d, 0x067d,
			0x067d, 0x067d, 0x068b, 0x068b, 0x068b, 0x068b, 0x0697, 0x0697,
			0x0697, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2,
			0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06a2,
			0x06a2, 0x06a2, 0x06a2, 0x06a2, 0x06af, 0x06af, 0x06af, 0x06af,
			0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af, 0x06af,
			0x06af, 0x06af, 0x06ba, 0x06ba, 0x06ba, 0x06ba, 0x06c9, 0x06da,
			// Entry 100 - 13F
			0x06da, 0x06e7, 0x06e7, 0x06fd, 0x06fd, 0x06fd, 0x070a, 0x0717,
			0x0717, 0x0717, 0x0717, 0x0717, 0x0717, 0x0717, 0x0723, 0x0723,
			0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723,
			0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723, 0x0723,
			0x0723, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732,
			0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x0732, 0x073e,
			0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e,
			0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e, 0x073e,
			// Entry 140 - 17F
			0x073e, 0x073e, 0x073e, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d,
			0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x074d, 0x075a, 0x075a,
			0x075a, 0x075a, 0x075a, 0x075a, 0x075a, 0x075a, 0x075a, 0x076c,
			0x076c, 0x076c, 0x076c, 0x076c, 0x076c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x077c,
			0x077c, 0x077c, 0x077c, 0x077c, 0x077c, 0x0789, 0x0789, 0x0789,
			// Entry 180 - 1BF
			0x0789, 0x0789, 0x0789, 0x0798, 0x0798, 0x0798, 0x0798, 0x0798,
			0x0798, 0x0798, 0x0798, 0x0798, 0x0798, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07a3,
			0x07a3, 0x07a3, 0x07a3, 0x07a3, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			// Entry 1C0 - 1FF
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			// Entry 200 - 23F
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2,
			0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07b2, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1,
			0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07c1, 0x07de, 0x07de,
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			// Entry 240 - 27F
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07de,
			0x07de, 0x07de, 0x07de, 0x07de, 0x07de, 0x07e9, 0x07e9, 0x07e9,
			0x07e9, 0x07e9, 0x07e9, 0x07e9, 0x0802, 0x081d, 0x083a, 0x084e,
			0x084e, 0x084e, 0x084e, 0x084e, 0x084e, 0x085c, 0x085c, 0x085c,
			0x085c, 0x085c, 0x085c, 0x0882, 0x08a5,
		},
	},
	{ // ln
		"akanliamarikilialabolibyelorisílibiligalilibengalilitshekɛlialemáligelek" +
			"ilingɛlɛ́salisipanyelipelésanɛlifalansɛ́hausalihindiliongililindonez" +
			"iigbolitalianolizapɔlizavalikambodzalikoreyalingálalimalezilibilimál" +
			"inepalɛlifalamálipendzabilipolonɛlipulutugɛ́siliromanilirisíkinyarwa" +
			"ndalisomalilisuwedɛlitamulilitayelitilikilikrɛniliurduliviyetinámiyo" +
			"rubalisinwazulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000d, 0x000d,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033, 0x0033,
			0x0033, 0x0033, 0x0033, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0059, 0x0059, 0x0062,
			0x0062, 0x0062, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x007f,
			0x007f, 0x0086, 0x0086, 0x0086, 0x0086, 0x008e, 0x008e, 0x008e,
			// Entry 40 - 7F
			0x008e, 0x0097, 0x0097, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x00a4, 0x00a4, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00bb, 0x00bb, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d3, 0x00d3, 0x00dc, 0x00dc, 0x00dc,
			0x00e5, 0x00e5, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee,
			0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00f8, 0x00f8, 0x0101,
			// Entry 80 - BF
			0x0101, 0x0110, 0x0110, 0x0110, 0x0110, 0x0118, 0x011f, 0x012a,
			0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a, 0x012a,
			0x012a, 0x012a, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132,
			0x013b, 0x013b, 0x0143, 0x0143, 0x0143, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0151, 0x0151, 0x0151, 0x0151, 0x0151, 0x0159,
			0x015f, 0x015f, 0x015f, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x0172, 0x0172, 0x0179, 0x017d,
		},
	},
	{ // lo
		loLangStr,
		loLangIdx,
	},
	{ // lrc
		"آذأربایئجانیآفریکانسآکانأمھأریأرأڤیآسامیآذأربایئجانی ھارگەباشکیریبئلاروٙ" +
			"سیبولغاریبامبارابأنگالیتأبأتیبئرئتونبوسنیاییکاتالانچئچئنیکوریسکانچو" +
			"اشیڤئلزیدانمارکیآلمانیزوٙنگخائڤئیوٙنانیئینگیلیسیئسپئرانتوئسپانیاییئ" +
			"ستونیاییباسکیفارسیفأنلاندیفیجیفاروٙسیفآرانسئ ئیفئریسی أفتونئشینئیرل" +
			"أندیگالیسیگوٙآرانیگوجأراتیمانکسھائوساعئبریھئنیکوروڤاتیھاییتیمأجاریأ" +
			"رمأنیأندونئزیاییئیگبوسی چوان ییئیسلأندیئیتالیاییئینوکتیتوٙتجاپوٙنیج" +
			"اڤئ ییگورجیکیکیوٙقأزاقکالالیسوٙتخئمئرکانادکورئ ییکأشمیریکوردی کورما" +
			"نجیکورنیشقئرقیزیلاتینلوٙکزامبوٙرگیگاندالینگالالاولیتوڤانیاییلوٙبا ک" +
			"اتانگالاتوڤیاییمالاگاشیمائوریمأقدوٙنیمالایامموغولیمأراتیمالاییمالتی" +
			"بئرمئ یینئدئبئلئ شومالینئپالیھولأندینورڤئجی نینورسکنورڤئجی بوٙکمالئ" +
			"وروموٙئوریاپأنجابیلأھئستانیپأشتوٙپورتئغالیکوچوٙارومانشراندیرومانیای" +
			"یروٙسیکینیاروآنداسانسکئریتسئندیسامی شومالیسانگوسینھالائسلوڤاکیئسلوڤ" +
			"ئنیاییشوناسوٙمالیآلبانیسئربیسوٙدانیسوٙئدیسأڤاحیلیتامیلتئلئگوتاجیکیت" +
			"ایلأندیتیگرینیاتورکأمأنیتوٙنگانتورکیتاتارئویغوٙرئوکراینیئوردوٙئوزبأ" +
			"کیڤییئتنامیڤولوفخوٙسایوروباچینیزولوآقئمماپوٙچئآسوٙبیمابئنابألوٙچی أ" +
			"قتوٙنئشینبودوچیگاچوروٙکیکوردی سوٙرانیتایتازارماسوربی ھاریدوٙالاجولا" +
			" فوٙنییئمبوفیلیپینیگاگائوزآلمانی سوٙئیسیگوٙسیھاڤاییسوربی ڤارونئگوٙمب" +
			"اماچامئکابیلئکامباماکوٙندئکاباردینوکی یورا چینیکالئجینکومی پئرمیاکک" +
			"وٙنکانیشامبالابافیالانگیلاکوٙتالۊری شومالیلوٙلوٙئیاماساییمئروموٙریس" +
			"یماخوڤا میتومئتاٛموٙھاڤکموٙندانگمازأندأرانیناماآلمانی ھاریکئڤاسیوٙن" +
			"ئکوٙنیوٙئرنیان کوٙلئکیچیرومبورئڤاسامبوٙروٙسانگوٙکوردی ھارگەسئناکیار" +
			"ابورو سئنیتاچئلھیتسامی ھارگەلۉلئ سامیئیناری سامیئسکولت سامیتئسوتاسا" +
			"ڤاقتامازیغ مینجاییزوٙن نادیارڤایڤوٙنجوٙڤارلپیریسوٙگاتامازیغ مأراکئش" +
			"یبی نئشوٙعروی مدرنآذأری ھارگەآلمانی ئوتریشیآلمانی سوٙییسیئینگیلیسی " +
			"ئوستارالیاییئینگیلیسی کاناداییئینگیلیسی بئریتانیاییئینگیلیسی ئمریکا" +
			"ییئسپانیایی ئمریکا لاتینئسپانیایی ئوروٙپائسپانیایی مئکزیکفآرانسئ ئی" +
			" کانادافآرانسئ ئی سوٙییسآلمانی ھارگە جافئلاماندیپورتئغالی بئرئزیلپور" +
			"تئغالی ئوروٙپاییرومانیایی مولداڤیسأڤاحیلی کونگوچینی سادە بیەچینی سو" +
			"نأتی",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0018, 0x0018, 0x0028, 0x0030, 0x003c, 0x003c,
			0x0046, 0x0050, 0x0050, 0x0050, 0x0073, 0x0081, 0x0093, 0x00a1,
			0x00a1, 0x00af, 0x00bd, 0x00c9, 0x00d7, 0x00e7, 0x00f5, 0x0101,
			0x0101, 0x0111, 0x0111, 0x0111, 0x0111, 0x011b, 0x0125, 0x0135,
			0x0141, 0x0141, 0x014f, 0x0155, 0x0163, 0x0175, 0x0187, 0x0199,
			0x01ab, 0x01b5, 0x01bf, 0x01bf, 0x01cf, 0x01d7, 0x01e5, 0x01f8,
			0x0217, 0x0227, 0x0227, 0x0233, 0x0243, 0x0253, 0x025d, 0x0269,
			0x0273, 0x027b, 0x027b, 0x028b, 0x0297, 0x02a3, 0x02af, 0x02af,
			// Entry 40 - 7F
			0x02af, 0x02c5, 0x02c5, 0x02cf, 0x02e1, 0x02e1, 0x02e1, 0x02f1,
			0x0303, 0x0319, 0x0327, 0x0334, 0x033e, 0x033e, 0x034a, 0x034a,
			0x0354, 0x0368, 0x0372, 0x037c, 0x0389, 0x0389, 0x0397, 0x03b2,
			0x03b2, 0x03be, 0x03cc, 0x03d6, 0x03f0, 0x03fa, 0x03fa, 0x0408,
			0x040e, 0x0424, 0x043d, 0x044f, 0x045f, 0x045f, 0x046b, 0x047b,
			0x0489, 0x0495, 0x04a1, 0x04ad, 0x04b7, 0x04c6, 0x04c6, 0x04e3,
			0x04ef, 0x04ef, 0x04fd, 0x051a, 0x0537, 0x0537, 0x0537, 0x0537,
			0x0537, 0x0537, 0x0545, 0x054f, 0x054f, 0x055d, 0x055d, 0x056f,
			// Entry 80 - BF
			0x057b, 0x058d, 0x0599, 0x05a5, 0x05af, 0x05c1, 0x05cb, 0x05e1,
			0x05f3, 0x05f3, 0x05fd, 0x0612, 0x061c, 0x062a, 0x063a, 0x0650,
			0x0650, 0x0658, 0x0666, 0x0672, 0x067c, 0x067c, 0x067c, 0x068a,
			0x0696, 0x06a6, 0x06b0, 0x06bc, 0x06c8, 0x06d8, 0x06e8, 0x06fa,
			0x06fa, 0x0708, 0x0712, 0x0712, 0x071c, 0x071c, 0x072a, 0x073a,
			0x0746, 0x0754, 0x0754, 0x0766, 0x0766, 0x0766, 0x0770, 0x077a,
			0x077a, 0x0786, 0x0786, 0x078e, 0x0796, 0x0796, 0x0796, 0x0796,
			0x0796, 0x0796, 0x0796, 0x079e, 0x079e, 0x079e, 0x079e, 0x079e,
			// Entry C0 - FF
			0x079e, 0x079e, 0x079e, 0x079e, 0x079e, 0x07ac, 0x07ac, 0x07ac,
			0x07ac, 0x07ac, 0x07ac, 0x07ac, 0x07ac, 0x07b4, 0x07b4, 0x07b4,
			0x07b4, 0x07b4, 0x07b4, 0x07b4, 0x07b4, 0x07b4, 0x07b4, 0x07b4,
			0x07b4, 0x07b4, 0x07bc, 0x07bc, 0x07c4, 0x07c4, 0x07c4, 0x07e7,
			0x07e7, 0x07e7, 0x07e7, 0x07e7, 0x07e7, 0x07e7, 0x07e7, 0x07e7,
			0x07e7, 0x07e7, 0x07ef, 0x07ef, 0x07ef, 0x07ef, 0x07ef, 0x07ef,
			0x07ef, 0x07ef, 0x07ef, 0x07ef, 0x07ef, 0x07ef, 0x07f7, 0x07f7,
			0x07f7, 0x07f7, 0x07f7, 0x07f7, 0x07f7, 0x07f7, 0x0805, 0x0805,
			// Entry 100 - 13F
			0x081e, 0x081e, 0x081e, 0x081e, 0x081e, 0x081e, 0x081e, 0x081e,
			0x0828, 0x0828, 0x0828, 0x0828, 0x0828, 0x0832, 0x0832, 0x0845,
			0x0845, 0x0851, 0x0851, 0x0866, 0x0866, 0x0866, 0x086e, 0x086e,
			0x086e, 0x086e, 0x086e, 0x086e, 0x086e, 0x086e, 0x086e, 0x086e,
			0x086e, 0x087e, 0x087e, 0x087e, 0x087e, 0x087e, 0x087e, 0x087e,
			0x087e, 0x087e, 0x087e, 0x087e, 0x088c, 0x088c, 0x088c, 0x088c,
			0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c, 0x088c,
			0x088c, 0x088c, 0x088c, 0x088c, 0x08a7, 0x08a7, 0x08a7, 0x08b1,
			// Entry 140 - 17F
			0x08b1, 0x08b1, 0x08b1, 0x08bd, 0x08bd, 0x08bd, 0x08bd, 0x08bd,
			0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			0x08d0, 0x08d0, 0x08e0, 0x08ec, 0x08ec, 0x08ec, 0x08ec, 0x08ec,
			0x08f8, 0x08f8, 0x08f8, 0x0902, 0x0902, 0x0902, 0x0902, 0x0902,
			0x0912, 0x0924, 0x0924, 0x0924, 0x0924, 0x0924, 0x0924, 0x093a,
			0x093a, 0x093a, 0x093a, 0x0948, 0x0948, 0x095f, 0x096f, 0x096f,
			0x096f, 0x096f, 0x096f, 0x096f, 0x096f, 0x096f, 0x097d, 0x0987,
			0x0987, 0x0987, 0x0987, 0x0987, 0x0991, 0x0991, 0x0991, 0x0991,
			// Entry 180 - 1BF
			0x0991, 0x0991, 0x0991, 0x099f, 0x099f, 0x099f, 0x099f, 0x09b4,
			0x09b4, 0x09b4, 0x09b4, 0x09b4, 0x09ba, 0x09ba, 0x09c6, 0x09c6,
			0x09c6, 0x09c6, 0x09c6, 0x09c6, 0x09c6, 0x09c6, 0x09c6, 0x09d2,
			0x09d2, 0x09d2, 0x09d2, 0x09d2, 0x09da, 0x09e8, 0x09e8, 0x09fd,
			0x0a07, 0x0a07, 0x0a07, 0x0a07, 0x0a07, 0x0a15, 0x0a15, 0x0a15,
			0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25, 0x0a25,
			0x0a3b, 0x0a3b, 0x0a3b, 0x0a43, 0x0a58, 0x0a58, 0x0a58, 0x0a58,
			0x0a58, 0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a68, 0x0a72, 0x0a72,
			// Entry 1C0 - 1FF
			0x0a7e, 0x0a7e, 0x0a7e, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91,
			0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91,
			0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91, 0x0a91,
			0x0a91, 0x0a99, 0x0a99, 0x0a99, 0x0a99, 0x0a99, 0x0a99, 0x0a99,
			0x0aa3, 0x0aa3, 0x0aa3, 0x0aa3, 0x0aa3, 0x0aa3, 0x0aab, 0x0aab,
			0x0aab, 0x0aab, 0x0abd, 0x0abd, 0x0abd, 0x0abd, 0x0abd, 0x0ac9,
			0x0ac9, 0x0ac9, 0x0ac9, 0x0ade, 0x0ade, 0x0ae6, 0x0ae6, 0x0ae6,
			0x0b01, 0x0b01, 0x0b01, 0x0b11, 0x0b11, 0x0b11, 0x0b11, 0x0b11,
			// Entry 200 - 23F
			0x0b11, 0x0b24, 0x0b35, 0x0b4a, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f,
			0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f,
			0x0b5f, 0x0b5f, 0x0b5f, 0x0b5f, 0x0b67, 0x0b67, 0x0b67, 0x0b67,
			0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67,
			0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67, 0x0b67,
			0x0b75, 0x0b75, 0x0b92, 0x0b92, 0x0b92, 0x0b92, 0x0ba7, 0x0bad,
			0x0bad, 0x0bad, 0x0bad, 0x0bad, 0x0bad, 0x0bad, 0x0bbb, 0x0bbb,
			0x0bbb, 0x0bbb, 0x0bbb, 0x0bcb, 0x0bcb, 0x0bcb, 0x0bcb, 0x0bd5,
			// Entry 240 - 27F
			0x0bd5, 0x0bd5, 0x0bd5, 0x0bd5, 0x0bd5, 0x0bd5, 0x0bd5, 0x0bd5,
			0x0bd5, 0x0bd5, 0x0bf4, 0x0bf4, 0x0c03, 0x0c03, 0x0c14, 0x0c29,
			0x0c44, 0x0c5f, 0x0c8a, 0x0cad, 0x0cd6, 0x0cf9, 0x0d23, 0x0d44,
			0x0d63, 0x0d63, 0x0d83, 0x0da3, 0x0dbf, 0x0dd1, 0x0df2, 0x0e17,
			0x0e38, 0x0e38, 0x0e53, 0x0e6b, 0x0e80,
		},
	},
	{ // lt
		ltLangStr,
		ltLangIdx,
	},
	{ // lu
		"LiakanLiamharikiArabiBelarusiBulegariBengaliTshekiLizelumaniGilikiLingel" +
			"esaLihispaniaMpepajemiMfwàlànsaHausaHindiHongiliLindoneziaIgboLitali" +
			"LiyapaniJavaLikoreyaTshilubaLimalezianepaliolandiLipunjabiMpoloniMpu" +
			"tulugɛsiLiromaniLirisikinyarwandaLisomaliLisuwidiMtamuiliNtailandiNt" +
			"ulukiNkraniUrduLiviyetinamuNyorubashinɛNzulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0010, 0x0010,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001d, 0x0025,
			0x0025, 0x0025, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x003c, 0x003c, 0x003c, 0x003c, 0x0042, 0x004b, 0x004b, 0x0055,
			0x0055, 0x0055, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x006e,
			0x006e, 0x0073, 0x0073, 0x0073, 0x0073, 0x007a, 0x007a, 0x007a,
			// Entry 40 - 7F
			0x007a, 0x0084, 0x0084, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
			0x008e, 0x008e, 0x0096, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00b3, 0x00b3, 0x00b3, 0x00b3, 0x00b3,
			0x00b9, 0x00b9, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf,
			// Entry 80 - BF
			0x00cf, 0x00db, 0x00db, 0x00db, 0x00db, 0x00e3, 0x00e9, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x0104, 0x0104, 0x010c, 0x010c, 0x010c, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x0122,
			0x0126, 0x0126, 0x0126, 0x0132, 0x0132, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0139, 0x0139, 0x013f, 0x0144,
		},
	},
	{ // luo
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluDholuo",
		[]uint16{ // 397 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x016f,
		},
	},
	{ // luy
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiLusunguKihispaniaKiajemiKifaransaKihausaLuhindiKihungariKiindones" +
			"iaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaKin" +
			"epaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKiso" +
			"maliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyoru" +
			"baKichinaKizuluLuluhia",
		[]uint16{ // 399 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0052, 0x0052, 0x005c,
			0x005c, 0x005c, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x006c,
			0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0073,
			0x0073, 0x007a, 0x007a, 0x007a, 0x007a, 0x0083, 0x0083, 0x0083,
			// Entry 40 - 7F
			0x0083, 0x008e, 0x008e, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094,
			0x009e, 0x009e, 0x00a6, 0x00ac, 0x00ac, 0x00ac, 0x00ac, 0x00ac,
			0x00ac, 0x00ac, 0x00b6, 0x00b6, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00cd,
			0x00d5, 0x00d5, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00de, 0x00e7, 0x00e7, 0x00f0,
			// Entry 80 - BF
			0x00f0, 0x00f6, 0x00f6, 0x00f6, 0x00f6, 0x00ff, 0x0105, 0x0110,
			0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110, 0x0110,
			0x0110, 0x0110, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
			0x011f, 0x011f, 0x0126, 0x0126, 0x0126, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0130, 0x0138, 0x0138, 0x0138, 0x0138, 0x0138, 0x0141,
			0x0147, 0x0147, 0x0147, 0x0152, 0x0152, 0x0152, 0x0152, 0x0152,
			0x0152, 0x015a, 0x015a, 0x0161, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry C0 - FF
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 100 - 13F
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 140 - 17F
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			// Entry 180 - 1BF
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x016e,
		},
	},
	{ // lv
		lvLangStr,
		lvLangIdx,
	},
	{ // mas
		"nkʉtʉ́k ɔ́ɔ̄ lAkannkʉtʉ́k ɔ́ɔ̄ lAmharinkʉtʉ́k ɔ́ɔ̄ lmarabunkʉtʉ́k ɔ́ɔ̄ l" +
			"Belarusinkʉtʉ́k ɔ́ɔ̄ lBulgarialnkʉtʉ́k ɔ́ɔ̄ lBengalinkʉtʉ́k ɔ́ɔ̄ lch" +
			"ekinkʉtʉ́k ɔ́ɔ̄ ljerumaninkʉtʉ́k ɔ́ɔ̄ lgirikinkʉtʉ́k ɔ́ɔ̄ nkɨ́resank" +
			"ʉtʉ́k ɔ́ɔ̄ lspaniankʉtʉ́k ɔ́ɔ̄ lpersiankʉtʉ́k ɔ́ɔ̄ faransankʉtʉ́k ɔ" +
			"́ɔ̄ hausankʉtʉ́k ɔ́ɔ̄ lmoindinkʉtʉ́k ɔ́ɔ̄ lhungarinkʉtʉ́k ɔ́ɔ̄ Indo" +
			"nesiankʉtʉ́k ɔ́ɔ̄ Igbonkʉtʉ́k ɔ́ɔ̄ ltaliannkʉtʉ́k ɔ́ɔ̄ japaninkʉtʉ́k" +
			" ɔ́ɔ̄ ljanankʉtʉ́k ɔ́ɔ̄ lkambodiankʉtʉ́k ɔ́ɔ̄ lkoreankʉtʉ́k ɔ́ɔ̄ mal" +
			"aynkʉtʉ́k ɔ́ɔ̄ lBurmankʉtʉ́k ɔ́ɔ̄ lnepalinkʉtʉ́k ɔ́ɔ̄ lduchinkʉtʉ́k " +
			"ɔ́ɔ̄ lpunjabinkʉtʉ́k ɔ́ɔ̄ lpolandnkʉtʉ́k ɔ́ɔ̄ lportuguesenkʉtʉ́k ɔ́" +
			"ɔ̄ lromaniankʉtʉ́k ɔ́ɔ̄ lrusinkʉtʉ́k ɔ́ɔ̄ lruwandankʉtʉ́k ɔ́ɔ̄ lchu" +
			"marinkʉtʉ́k ɔ́ɔ̄ lswidinkʉtʉ́k ɔ́ɔ̄ ltamilnkʉtʉ́k ɔ́ɔ̄ ltainkʉtʉ́k ɔ" +
			"́ɔ̄ lturukinkʉtʉ́k ɔ́ɔ̄ lkraniankʉtʉ́k ɔ́ɔ̄ lurdunkʉtʉ́k ɔ́ɔ̄ lviet" +
			"inamunkʉtʉ́k ɔ́ɔ̄ lyorubankʉtʉ́k ɔ́ɔ̄ lchinankʉtʉ́k ɔ́ɔ̄ lzuluMaa",
		[]uint16{ // 408 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0019, 0x0034, 0x0034,
			0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x004f, 0x006c, 0x0089,
			0x0089, 0x0089, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6,
			0x00a6, 0x00a6, 0x00a6, 0x00c0, 0x00c0, 0x00c0, 0x00c0, 0x00c0,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00f8, 0x0116, 0x0116, 0x0131,
			0x0131, 0x0131, 0x014c, 0x014c, 0x014c, 0x014c, 0x014c, 0x0167,
			0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0167, 0x0180,
			0x0180, 0x019b, 0x019b, 0x019b, 0x019b, 0x01b7, 0x01b7, 0x01b7,
			// Entry 40 - 7F
			0x01b7, 0x01d4, 0x01d4, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec,
			0x0207, 0x0207, 0x0221, 0x023a, 0x023a, 0x023a, 0x023a, 0x023a,
			0x023a, 0x023a, 0x0257, 0x0257, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271, 0x0271,
			0x0271, 0x0271, 0x0271, 0x028a, 0x028a, 0x02a4, 0x02a4, 0x02a4,
			0x02bf, 0x02bf, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9,
			0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02d9, 0x02f5, 0x02f5, 0x0310,
			// Entry 80 - BF
			0x0310, 0x032f, 0x032f, 0x032f, 0x032f, 0x034b, 0x0364, 0x0380,
			0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380, 0x0380,
			0x0380, 0x0380, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c, 0x039c,
			0x03b6, 0x03b6, 0x03d0, 0x03d0, 0x03d0, 0x03e8, 0x03e8, 0x03e8,
			0x03e8, 0x03e8, 0x0403, 0x0403, 0x0403, 0x0403, 0x0403, 0x041e,
			0x0437, 0x0437, 0x0437, 0x0455, 0x0455, 0x0455, 0x0455, 0x0455,
			0x0455, 0x0470, 0x0470, 0x048a, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry C0 - FF
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 100 - 13F
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 140 - 17F
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			// Entry 180 - 1BF
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04a6,
		},
	},
	{ // mer
		"KĩakaniKĩamarĩkiKĩarabuKĩbelarusiKĩbulugĩriaKĩbangiraKĩchekiKĩnjamanĩKĩn" +
			"girikiKĩngerethaKĩspĩniKĩpasiaKĩfuransiKĩhausaKĩhĩndiKĩhangarĩKĩindo" +
			"nesiaKĩigboKĩitalĩKĩjapaniKĩjavaKĩkambodiaKĩkoreaKĩmalesiaKĩburmaKĩn" +
			"epaliKĩholandiKĩpunjabuKĩpolandiKĩpochogoKĩromaniaKĩrashiaKĩrwandaKĩ" +
			"somaliKĩswideniKĩtamiluKĩthailandiKĩtakĩKĩukirĩniKĩurduKĩvietinamuKĩ" +
			"yorubaKĩchinaKĩzuluKĩmĩrũ",
		[]uint16{ // 413 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0013, 0x0013,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x0026, 0x0033,
			0x0033, 0x0033, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x0050, 0x0050, 0x0050, 0x0050, 0x005a, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0088,
			0x0088, 0x0091, 0x0091, 0x0091, 0x0091, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af,
			0x00b8, 0x00b8, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d3, 0x00d3, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00e5, 0x00e5, 0x00ed, 0x00ed, 0x00ed,
			0x00f6, 0x00f6, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
			0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x010a, 0x010a, 0x0114,
			// Entry 80 - BF
			0x0114, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013a,
			0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a,
			0x013a, 0x013a, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143, 0x0143,
			0x014d, 0x014d, 0x0156, 0x0156, 0x0156, 0x0162, 0x0162, 0x0162,
			0x0162, 0x0162, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x0175,
			0x017c, 0x017c, 0x017c, 0x0188, 0x0188, 0x0188, 0x0188, 0x0188,
			0x0188, 0x0191, 0x0191, 0x0199, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry C0 - FF
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 100 - 13F
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 140 - 17F
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			// Entry 180 - 1BF
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a0,
			0x01a0, 0x01a0, 0x01a0, 0x01a0, 0x01a9,
		},
	},
	{ // mfe
		"akanamarikarabbielorisbilgarbengalitchekalmangrekangleespagnolpersanfran" +
			"sehaoussahindihongrwaindonezienigboitalienzaponezavanekhmer, santral" +
			"koreenmalebirmannepaleolandepenjabipoloneportigerouminrisrwandasomal" +
			"iswedwatamoulthaïtirkikrenienourdouvietnamienyorubasinwa, mandarinzo" +
			"uloukreol morisien",
		[]uint16{ // 414 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x0016, 0x001c,
			0x001c, 0x001c, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023,
			0x0023, 0x0023, 0x0023, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x002d, 0x002d, 0x002d, 0x002d, 0x0031, 0x0036, 0x0036, 0x003e,
			0x003e, 0x003e, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x0051,
			0x0051, 0x0056, 0x0056, 0x0056, 0x0056, 0x005d, 0x005d, 0x005d,
			// Entry 40 - 7F
			0x005d, 0x0067, 0x0067, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x0072, 0x0072, 0x0078, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e,
			0x007e, 0x007e, 0x008c, 0x008c, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092, 0x0092,
			0x0092, 0x0092, 0x0092, 0x0096, 0x0096, 0x009c, 0x009c, 0x009c,
			0x00a2, 0x00a2, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
			0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00b5,
			// Entry 80 - BF
			0x00b5, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00c2, 0x00c5, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00d1, 0x00d1, 0x00d1, 0x00d1, 0x00d1, 0x00d1,
			0x00d7, 0x00d7, 0x00dd, 0x00dd, 0x00dd, 0x00e2, 0x00e2, 0x00e2,
			0x00e2, 0x00e2, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00ee,
			0x00f4, 0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x00fe,
			0x00fe, 0x0104, 0x0104, 0x0113, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry C0 - FF
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 100 - 13F
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 140 - 17F
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			// Entry 180 - 1BF
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0119,
			0x0119, 0x0119, 0x0119, 0x0119, 0x0119, 0x0127,
		},
	},
	{ // mg
		"AkanAmharikaAraboBielorosyBiolgaraBengaliTsekyAlemaninaGrikaAnglisyEspan" +
			"iolaPersaFrantsayhaoussahindihongroàIndonezianinaigboItalianinaJapon" +
			"eyJavaneykhmerKoreaninaMalagasyMalayBirmanaNepaleHolandeyPenjabiPolo" +
			"neyPortiogeyRomanianinaRosianinaRoandeSomalianinaSoisaTamoilaTaioane" +
			"yTiorkaOkrainianinaOrdòVietnamianinaYôrobàSinoa, MandarinZolò",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000c, 0x000c,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x001a, 0x0022,
			0x0022, 0x0022, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029,
			0x0029, 0x0029, 0x0029, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x0037, 0x0037, 0x0037, 0x0037, 0x003c, 0x0043, 0x0043, 0x004c,
			0x004c, 0x004c, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0060,
			0x0060, 0x0065, 0x0065, 0x0065, 0x0065, 0x006d, 0x006d, 0x006d,
			// Entry 40 - 7F
			0x006d, 0x007a, 0x007a, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e,
			0x0088, 0x0088, 0x008f, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x0096, 0x0096, 0x009b, 0x009b, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4,
			0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00ac, 0x00ac, 0x00ac, 0x00ac,
			0x00ac, 0x00ac, 0x00ac, 0x00b1, 0x00b1, 0x00b8, 0x00b8, 0x00b8,
			0x00be, 0x00be, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00cd, 0x00cd, 0x00d4,
			// Entry 80 - BF
			0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00f1, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0107, 0x0107, 0x010e, 0x010e, 0x010e, 0x0116, 0x0116, 0x0116,
			0x0116, 0x0116, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x0128,
			0x012d, 0x012d, 0x012d, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a,
			0x013a, 0x0142, 0x0142, 0x0151, 0x0156,
		},
	},
	{ // mgh
		"IkanImhariIarabuIbelausiIbulgariaIbanglaIchekiIjerimaniIgirikiIngilishiI" +
			"hispaniolaIajemiIfaransaIhausaIhindiIhungariIgboItalianoIjapaniIjava" +
			"IkambodiaIkoreaImalesiaIburmaInepaliIholanziIpunjabiIpolandiNrenoIro" +
			"maniaIrisiInyarandaIsomaliIswidiItamilItailandiIturukiIukranIhurduIv" +
			"yetinamuIyorubaIchinaIzuluMakua",
		[]uint16{ // 416 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000a, 0x000a,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0018, 0x0021,
			0x0021, 0x0021, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x0037, 0x0037, 0x0037, 0x0037, 0x003e, 0x0047, 0x0047, 0x0052,
			0x0052, 0x0052, 0x0058, 0x0058, 0x0058, 0x0058, 0x0058, 0x0060,
			0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0060, 0x0066,
			0x0066, 0x006c, 0x006c, 0x006c, 0x006c, 0x0074, 0x0074, 0x0074,
			// Entry 40 - 7F
			0x0074, 0x0074, 0x0074, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078,
			0x0080, 0x0080, 0x0087, 0x008c, 0x008c, 0x008c, 0x008c, 0x008c,
			0x008c, 0x008c, 0x0095, 0x0095, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b,
			0x009b, 0x009b, 0x009b, 0x00a3, 0x00a3, 0x00a9, 0x00a9, 0x00a9,
			0x00b0, 0x00b0, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00c0, 0x00c0, 0x00c8,
			// Entry 80 - BF
			0x00c8, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00d5, 0x00da, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00f0, 0x00f0, 0x00f6, 0x00f6, 0x00f6, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x010c,
			0x0112, 0x0112, 0x0112, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x0123, 0x0123, 0x0129, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry C0 - FF
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 100 - 13F
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 140 - 17F
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			// Entry 180 - 1BF
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x0133,
		},
	},
	{ // mgo
		"metaʼngam tisɔʼ",
		[]uint16{ // 559 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 180 - 1BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 1C0 - 1FF
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 200 - 23F
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0012,
		},
	},
	{ // mk
		mkLangStr,
		mkLangIdx,
	},
	{ // ml
		mlLangStr,
		mlLangIdx,
	},
	{ // mn
		mnLangStr,
		mnLangIdx,
	},
	{ // mr
		mrLangStr,
		mrLangIdx,
	},
	{ // ms
		msLangStr,
		msLangIdx,
	},
	{ // mt
		"AfarAbkażjanAvestanAfrikansAkanAmharikuAragoniżGħarbiAssamiżAvarikAymara" +
			"AżerbajġaniBashkirBelarussuBulgaruBislamaBambaraBengaliTibetjanBreto" +
			"nBożnijakuKatalanChechenChamorroKorsikuCreeĊekSlaviku tal-KnisjaChuv" +
			"ashWelshDaniżĠermaniżDivehiDzongkhaEweGriegIngliżEsperantoSpanjolEst" +
			"onjanBaskPersjanFulahFinlandiżFiġjanFaroeseFranċiżFrisian tal-Punent" +
			"IrlandiżGalliku SkoċċiżGaliċjanGuaraniGujaratiManxHausaEbrajkHindiHi" +
			"ri MotuKroatCreole ta’ HaitiUngeriżArmenHereroInterlinguaIndoneżjanI" +
			"nterlingueIgboSichuan YiInupjakIdoIżlandiżTaljanInuktitutĠappuniżĠav" +
			"aniżĠorġjanKongoKikujuKuanyamaKażakKalallisutKhmerKannadaKoreanKanur" +
			"iKashmiriKurdKomiKornikuKirgiżLatinLussemburgiżGandaLimburgishLingal" +
			"janLaosjanLitwanLuba-KatangaLatvjanMalagasyMarshalljaniżMaoriMaċedon" +
			"janMalayalamMongoljanMarathiMalayMaltiBurmiżNaurujanNdebeli tat-Tram" +
			"untanaNepaliżNdongaOlandiżNinorsk NorveġiżBokmal NorveġiżNdebele tan" +
			"-NofsinharNavajoNyanjaOċċitanOġibwaOromoOdiaOssettikuPunjabiPaliPoll" +
			"akkPashtoPortugiżQuechuaRomanzRundiRumenRussuKinjarwandaSanskritSard" +
			"injanSindhiSami tat-TramuntanaSangoSinhalaSlovakkSlovenSamoanShonaSo" +
			"maliAlbaniżSerbSwatiSoto tan-NofsinharSundaniżŻvezjaSwahiliTamilTelu" +
			"guTajikTajlandiżTigrinyaTurkmeniTswanaTonganTorkTsongaTatarTaħitjanU" +
			"yghurUkrenurUzbekVendaVjetnamiżVolapukWalloonWolofXhosaYiddishYoruba" +
			"ZhuangĊiniżZuluAċiniżAkoliAdangmeAdygheAfriħiliAghemAjnuAkkadjenAleu" +
			"tAltai tan-NofsinharIngliż AntikAngikaAramajkMapucheArapahoArawakAsu" +
			"AsturianAwadhiBaluċiBaliniżBasaBejaBembaBenaBhojpuriBikolBiniSiksika" +
			"BrajBodoBurjatBugineseBlinKaddoKaribAtsamCebuanoChigaChibchaChagatai" +
			"ĊukiżMariChinook JargonChoctawĊipewjanCherokeeCheyenneKurd Ċentrali" +
			"KoptikuTork tal-KrimeaFranċiż tas-Seselwa CreoleKashubianDakotaDargw" +
			"aTaitaDelawerjanSlavDogribDinkaZarmaDogriSorbjan KomuniDwalaOlandiż " +
			"MedjevaliJola-FonyiDyulaDazagaEmbuEfikEġizzjan (Antik)EkajukElamitIn" +
			"gliż MedjevaliEwondoFangFilippinFonFranċiż MedjevaliFranċiż AntikFri" +
			"juljanGaGayoGbayaGeezGilbertjanĠermaniż Medjevali PulitĠermaniż Anti" +
			"k, PulitGondiGorontaloGotikuGreboGrieg, AntikĠermaniż tal-IżvizzeraG" +
			"usiiGwiċinHaidaĦawajjanHiligaynonHittiteHmongSorbjan ta’ FuqHupaIban" +
			"IbibioIlokoIngushLojbanNgombaMachameLhudi-PersjanLhudi-GħarbiKara-Ka" +
			"lpakKabuljanKachinJjuKambaKawiKabardianTyapMakondeCape VerdjanKoroKh" +
			"asiKotaniżKoyra ChiiniKakoKalenjinKimbunduKonkaniKosrejanKpelleKarac" +
			"hay-BalkarKareljanKuruxShambalaBafiaKolonjanKumykKutenajLadinoLangiL" +
			"ahndaLambaLeżgjanLakotaMongoLożiLuri tat-TramuntanaLuba-LuluwaLuisen" +
			"oLundaLuoMizoLuyiaMaduriżMagahiMaithiliMakasarMandingoMasaiMokshaMan" +
			"darMendeMeruMorisyenIrlandiż MedjevaliMakhuwa-MeettoMetàMicmacMinang" +
			"kabauManchuManipuriMohawkMossiMundangLingwi DiversiKriekMirandiżMarw" +
			"ariErzyaMazanderaniNaplitanNamaĠermaniż KomuniNewariNijasNiueanKwasi" +
			"oNgiemboonNogaiNors AntikN’KoSoto tat-TramuntanaNuerNewari KlassikuN" +
			"jamweżiNyankoleNyoroNzimaOsaġjanTork OttomanPangasinjanPahlaviPampan" +
			"gaPapiamentoPalawjanPidgin NiġerjanPersjan AntikFeniċjuPonpejanPruss" +
			"uProvenzal AntikK’iche’RaġastaniRapanwiRarotonganiRomboRomaneskAroma" +
			"njanRwaSandaweSakhaSamaritan AramajkSamburuSasakSantaliNgambaySanguS" +
			"qalliSkoċċiżSenaSelkupKoyraboro SenniIrlandiż AntikTachelhitShanSida" +
			"moSami tan-NofsinharLule SamiInari SamiSkolt SamiSoninkeSogdienSrana" +
			"n TongoSererSahoSukumaSusuSumerjanKomorjanSirjanTimneTesoTerenoTetum" +
			"TigreTivTokelauKlingonTlingitTamashekNyasa TongaTok PisinTarokoTsims" +
			"hianTumbukaTuvaluTasawaqTuvinjanTamazight tal-Atlas ĊentraliUdmurtUg" +
			"aritikuUmbunduRootVaiVotikVunjoWalserWalamoWarayWashoKalmykSogaYaoYa" +
			"peseYangbenYembaKantoniżZapotecZenagaTamazight Standard tal-MarokkZu" +
			"niBla kontenut lingwistikuZazaGħarbi Standard ModernĠermaniż Awstrij" +
			"akĠermaniż ŻvizzeruIngliż AwstraljanIngliż KanadiżIngliż BrittanikuI" +
			"ngliż AmerikanSpanjol Latin AmerikanSpanjol EwropewSpanjol tal-Messi" +
			"kuFranċiż KanadiżFranċiż ŻvizzeruSassonu KomuniFjammingPortugiż tal-" +
			"BrażilPortugiż EwropewMoldovanSerbo-KroatSwahili tar-Repubblika Demo" +
			"kratika tal-KongoĊiniż SimplifikatĊiniż Tradizzjonali",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0014, 0x001c, 0x0020, 0x0028, 0x0031,
			0x0038, 0x0040, 0x0046, 0x004c, 0x0059, 0x0060, 0x0069, 0x0070,
			0x0077, 0x007e, 0x0085, 0x008d, 0x0093, 0x009d, 0x00a4, 0x00ab,
			0x00b3, 0x00ba, 0x00be, 0x00c2, 0x00d4, 0x00db, 0x00e0, 0x00e6,
			0x00f0, 0x00f6, 0x00fe, 0x0101, 0x0106, 0x010d, 0x0116, 0x011d,
			0x0125, 0x0129, 0x0130, 0x0135, 0x013f, 0x0146, 0x014d, 0x0156,
			0x0168, 0x0171, 0x0183, 0x018c, 0x0193, 0x019b, 0x019f, 0x01a4,
			0x01aa, 0x01af, 0x01b8, 0x01bd, 0x01cf, 0x01d7, 0x01dc, 0x01e2,
			// Entry 40 - 7F
			0x01ed, 0x01f8, 0x0203, 0x0207, 0x0211, 0x0218, 0x021b, 0x0225,
			0x022b, 0x0234, 0x023e, 0x0247, 0x0250, 0x0255, 0x025b, 0x0263,
			0x0269, 0x0273, 0x0278, 0x027f, 0x0285, 0x028b, 0x0293, 0x0297,
			0x029b, 0x02a2, 0x02a9, 0x02ae, 0x02bb, 0x02c0, 0x02ca, 0x02d3,
			0x02da, 0x02e0, 0x02ec, 0x02f3, 0x02fb, 0x0309, 0x030e, 0x0319,
			0x0322, 0x032b, 0x0332, 0x0337, 0x033c, 0x0343, 0x034b, 0x0361,
			0x0369, 0x036f, 0x0377, 0x0389, 0x039a, 0x03af, 0x03b5, 0x03bb,
			0x03c4, 0x03cb, 0x03d0, 0x03d4, 0x03dd, 0x03e4, 0x03e8, 0x03ef,
			// Entry 80 - BF
			0x03f5, 0x03fe, 0x0405, 0x040b, 0x0410, 0x0415, 0x041a, 0x0425,
			0x042d, 0x0436, 0x043c, 0x044f, 0x0454, 0x045b, 0x0462, 0x0468,
			0x046e, 0x0473, 0x0479, 0x0481, 0x0485, 0x048a, 0x049c, 0x04a5,
			0x04ac, 0x04b3, 0x04b8, 0x04be, 0x04c3, 0x04cd, 0x04d5, 0x04dd,
			0x04e3, 0x04e9, 0x04ed, 0x04f3, 0x04f8, 0x0501, 0x0507, 0x050c,
			0x050e, 0x0513, 0x0518, 0x0522, 0x0529, 0x0530, 0x0535, 0x053a,
			0x0541, 0x0547, 0x054d, 0x0554, 0x0558, 0x0560, 0x0565, 0x056c,
			0x0572, 0x0572, 0x057b, 0x0580, 0x0584, 0x058c, 0x058c, 0x0591,
			// Entry C0 - FF
			0x0591, 0x05a4, 0x05b1, 0x05b7, 0x05be, 0x05c5, 0x05c5, 0x05cc,
			0x05cc, 0x05cc, 0x05d2, 0x05d2, 0x05d2, 0x05d5, 0x05d5, 0x05dd,
			0x05dd, 0x05e3, 0x05ea, 0x05f2, 0x05f2, 0x05f6, 0x05f6, 0x05f6,
			0x05f6, 0x05fa, 0x05ff, 0x05ff, 0x0603, 0x0603, 0x0603, 0x0603,
			0x060b, 0x0610, 0x0614, 0x0614, 0x0614, 0x061b, 0x061b, 0x061b,
			0x061f, 0x061f, 0x0623, 0x0623, 0x0629, 0x0631, 0x0631, 0x0635,
			0x0635, 0x063a, 0x063f, 0x063f, 0x0644, 0x064b, 0x0650, 0x0657,
			0x065f, 0x0666, 0x066a, 0x0678, 0x067f, 0x0688, 0x0690, 0x0698,
			// Entry 100 - 13F
			0x06a6, 0x06ad, 0x06ad, 0x06bc, 0x06d8, 0x06e1, 0x06e7, 0x06ed,
			0x06f2, 0x06fc, 0x0700, 0x0706, 0x070b, 0x0710, 0x0715, 0x0723,
			0x0723, 0x0728, 0x073a, 0x0744, 0x0749, 0x074f, 0x0753, 0x0757,
			0x0757, 0x0768, 0x076e, 0x0774, 0x0785, 0x0785, 0x078b, 0x078b,
			0x078f, 0x0797, 0x0797, 0x079a, 0x079a, 0x07ad, 0x07bc, 0x07bc,
			0x07bc, 0x07bc, 0x07c5, 0x07c7, 0x07c7, 0x07c7, 0x07cb, 0x07d0,
			0x07d0, 0x07d4, 0x07de, 0x07de, 0x07f8, 0x080f, 0x080f, 0x0814,
			0x081d, 0x0823, 0x0828, 0x0834, 0x084d, 0x084d, 0x084d, 0x0852,
			// Entry 140 - 17F
			0x0859, 0x085e, 0x085e, 0x0867, 0x0867, 0x0871, 0x0878, 0x087d,
			0x088e, 0x088e, 0x0892, 0x0896, 0x089c, 0x08a1, 0x08a7, 0x08a7,
			0x08a7, 0x08ad, 0x08b3, 0x08ba, 0x08c7, 0x08d4, 0x08d4, 0x08df,
			0x08e7, 0x08ed, 0x08f0, 0x08f5, 0x08f9, 0x0902, 0x0902, 0x0906,
			0x090d, 0x0919, 0x0919, 0x091d, 0x091d, 0x0922, 0x092a, 0x0936,
			0x0936, 0x0936, 0x093a, 0x0942, 0x094a, 0x094a, 0x0951, 0x0959,
			0x095f, 0x096e, 0x096e, 0x096e, 0x0976, 0x097b, 0x0983, 0x0988,
			0x0990, 0x0995, 0x099c, 0x09a2, 0x09a7, 0x09ad, 0x09b2, 0x09ba,
			// Entry 180 - 1BF
			0x09ba, 0x09ba, 0x09ba, 0x09c0, 0x09c0, 0x09c5, 0x09ca, 0x09dd,
			0x09dd, 0x09e8, 0x09ef, 0x09f4, 0x09f7, 0x09fb, 0x0a00, 0x0a00,
			0x0a00, 0x0a08, 0x0a08, 0x0a0e, 0x0a16, 0x0a1d, 0x0a25, 0x0a2a,
			0x0a2a, 0x0a30, 0x0a36, 0x0a3b, 0x0a3f, 0x0a47, 0x0a5a, 0x0a68,
			0x0a6d, 0x0a73, 0x0a7e, 0x0a84, 0x0a8c, 0x0a92, 0x0a97, 0x0a97,
			0x0a9e, 0x0aac, 0x0ab1, 0x0aba, 0x0ac1, 0x0ac1, 0x0ac1, 0x0ac6,
			0x0ad1, 0x0ad1, 0x0ad9, 0x0add, 0x0aee, 0x0af4, 0x0af9, 0x0aff,
			0x0aff, 0x0b05, 0x0b0e, 0x0b13, 0x0b1d, 0x0b1d, 0x0b23, 0x0b36,
			// Entry 1C0 - 1FF
			0x0b3a, 0x0b49, 0x0b52, 0x0b5a, 0x0b5f, 0x0b64, 0x0b6c, 0x0b78,
			0x0b83, 0x0b8a, 0x0b92, 0x0b9c, 0x0ba4, 0x0ba4, 0x0bb4, 0x0bb4,
			0x0bb4, 0x0bc1, 0x0bc1, 0x0bc9, 0x0bc9, 0x0bc9, 0x0bd1, 0x0bd7,
			0x0be6, 0x0bf1, 0x0bf1, 0x0bfb, 0x0c02, 0x0c0d, 0x0c0d, 0x0c0d,
			0x0c12, 0x0c1a, 0x0c1a, 0x0c1a, 0x0c1a, 0x0c23, 0x0c26, 0x0c2d,
			0x0c32, 0x0c43, 0x0c4a, 0x0c4f, 0x0c56, 0x0c56, 0x0c5d, 0x0c62,
			0x0c68, 0x0c72, 0x0c72, 0x0c72, 0x0c72, 0x0c76, 0x0c76, 0x0c7c,
			0x0c8b, 0x0c9a, 0x0c9a, 0x0ca3, 0x0ca7, 0x0ca7, 0x0cad, 0x0cad,
			// Entry 200 - 23F
			0x0cad, 0x0cbf, 0x0cc8, 0x0cd2, 0x0cdc, 0x0ce3, 0x0cea, 0x0cf6,
			0x0cfb, 0x0cff, 0x0cff, 0x0d05, 0x0d09, 0x0d11, 0x0d19, 0x0d19,
			0x0d1f, 0x0d1f, 0x0d1f, 0x0d24, 0x0d28, 0x0d2e, 0x0d33, 0x0d38,
			0x0d3b, 0x0d42, 0x0d42, 0x0d49, 0x0d50, 0x0d50, 0x0d58, 0x0d63,
			0x0d6c, 0x0d6c, 0x0d72, 0x0d72, 0x0d7b, 0x0d7b, 0x0d82, 0x0d88,
			0x0d8f, 0x0d97, 0x0db4, 0x0dba, 0x0dc3, 0x0dca, 0x0dce, 0x0dd1,
			0x0dd1, 0x0dd1, 0x0dd1, 0x0dd1, 0x0dd6, 0x0dd6, 0x0ddb, 0x0de1,
			0x0de7, 0x0dec, 0x0df1, 0x0df1, 0x0df1, 0x0df7, 0x0df7, 0x0dfb,
			// Entry 240 - 27F
			0x0dfe, 0x0e04, 0x0e0b, 0x0e10, 0x0e10, 0x0e19, 0x0e20, 0x0e20,
			0x0e20, 0x0e26, 0x0e43, 0x0e47, 0x0e5f, 0x0e63, 0x0e7a, 0x0e7a,
			0x0e8e, 0x0ea2, 0x0eb4, 0x0ec4, 0x0ed6, 0x0ee6, 0x0efc, 0x0f0b,
			0x0f1e, 0x0f1e, 0x0f30, 0x0f43, 0x0f51, 0x0f59, 0x0f6e, 0x0f7f,
			0x0f87, 0x0f92, 0x0fbe, 0x0fd1, 0x0fe6,
		},
	},
	{ // mua
		"akaŋamharikarabiyabelarussiyabulgariabengaliasyekyagermaŋgrekzah Anglofo" +
			"ŋEspaniyaPersiazah sǝr Franssǝhaussahindihungariyaindonesiyaigboita" +
			"liyazah sǝr JapoŋjavaniyakmerkoreamalasiyabirmaniaNepaliyazah sǝr ma" +
			" kasǝŋPǝnjabiPoloniyaZah sǝr PortugalRomaniyaRussiyaZah sǝr RwandaSo" +
			"maliyaSwediaTamulthTurkUkrainiaUrduVietnamiyaYorubazah SyiŋZuluMUNDA" +
			"Ŋ",
		[]uint16{ // 425 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000c, 0x000c,
			0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x001e, 0x0026,
			0x0026, 0x0026, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e, 0x002e,
			0x002e, 0x002e, 0x002e, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x003b, 0x003b, 0x003b, 0x003b, 0x003f, 0x004c, 0x004c, 0x0054,
			0x0054, 0x0054, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0071,
			0x0071, 0x0076, 0x0076, 0x0076, 0x0076, 0x007f, 0x007f, 0x007f,
			// Entry 40 - 7F
			0x007f, 0x0089, 0x0089, 0x008d, 0x008d, 0x008d, 0x008d, 0x008d,
			0x0094, 0x0094, 0x00a3, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00ab, 0x00ab, 0x00af, 0x00af, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00bc, 0x00bc, 0x00c4, 0x00c4, 0x00c4,
			0x00cc, 0x00cc, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00e7, 0x00e7, 0x00ef,
			// Entry 80 - BF
			0x00ef, 0x0100, 0x0100, 0x0100, 0x0100, 0x0108, 0x010f, 0x011e,
			0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e,
			0x011e, 0x011e, 0x0126, 0x0126, 0x0126, 0x0126, 0x0126, 0x0126,
			0x012c, 0x012c, 0x0131, 0x0131, 0x0131, 0x0133, 0x0133, 0x0133,
			0x0133, 0x0133, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x013f,
			0x0143, 0x0143, 0x0143, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x0153, 0x0153, 0x015c, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry C0 - FF
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 100 - 13F
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 140 - 17F
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			// Entry 180 - 1BF
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160, 0x0160,
			0x0167,
		},
	},
	{ // my
		myLangStr,
		myLangIdx,
	},
	{ // mzn
		"آبخازیآفریکانسآکانامهریعربیآسامیآذری ِترکیباشقیریبلاروسیبلغاریبامباراییب" +
			"نگالیتبتیبرِتونیبوسنیاییکاتالونیچچنیکورسیکانچکیچوواشیولزیدانمارکیآل" +
			"مانیدزونگخااوه\u200cیییونانیانگلیسیاسپرانتوایسپانیولیاستونیاییباسکی" +
			"فارسیفینیشفیجیاییفاروییفرانسویغربی فیریزیایریشگالیکگورانیگجراتیمانک" +
			"سهوساعبریهندیکرواتیهائتیاییمجاریارمنیاندونزیاییایگبوسیچوئان ییایسلن" +
			"دیایتالیاییانوکتیتوتجاپونیجاواییگرجیکیکویوقزاقیکالائلیسوتخمریکانّاد" +
			"اکُره\u200cییکشمیریکوردیکورنیشقرقیزیلاتینلوکزامبورگیگاندالینگالالائ" +
			"وییلتونیاییلوبا-کاتانگالاتویاییمالاگاسیمائوریمقدونیمالایالاممغولیما" +
			"راتیمالاییمالتیبرمه\u200cییشمالی ندبلهنپالیهلندینروژی نینورسکنروژی " +
			"بوکمالاورومواوریاپنجابیلهستونیپشتوپرتغالیقوئچوئارومانشروندیرومانیای" +
			"یروسیکنیاروآنداییسانسکریتسندیشمالی سامیسانگوسینهالااسلواکیاسلوونیای" +
			"یشوناسومالیاییآلبانیاییصربیسوندانسیسوئدیسواحیلیتامیلیتلوگوییتاجیکیت" +
			"اییتیگرینیاییترکمونیتونگانیترکیتاتاریئوغوریاوکراینیاردوازبکیویتنامی" +
			"وولفیخوسایوروباچینیزولوآقمماپوچهآسوبمباییبناییغربی بلوچیبدوییچیگاچر" +
			"وکیاییمیونی کوردیتایتازارماییپایین صربیدوئالاییجولا-فونیامبوفیلیپین" +
			"وگاگائوزیسوییس آلمانیگوسیهاواییاییبالایی صربینگومباماچامهقبایلیکامب" +
			"اییماکوندهکیپ وُردیکویرا چیینیکالنجینکومی-پرمیاککونکانیشامبالابافیا" +
			"ییلانگیلاکوتاشمالی لُریلوئولوییاماساییمِروییموریسینماخوئا-میتومِتاء" +
			"موهاکموندانگمازرونیناماپایین آلمانیکوئاسیونئکونوئرنیانکولهکئیچه" +
			"\u200cئیرومبوروآییسامبوروسانگووجنوبی کردیسِناییکویرابورا سنیتاچلهیتج" +
			"نوبی سامیلوله سامیایناری سامیسکولت سامیتسوییتاساواقیمیونی اطلس تامز" +
			"یقینشناسی\u200cیه زوونواییوونجوییوالرپیریسوگامراکش ِاستاندارد ِتاما" +
			"زیقتیاین زوون بشناسی\u200cیه نیّهمدرن استاندارد عربیجنوبی آذری ترکی" +
			"اتریش ِآلمانیسوییس ِآلمانیاسترالیای ِانگلیسیکانادای ِانگلیسیبریتیش " +
			"انگلیسیامریکن انگلیسیجنوبی آمریکای ِایسپانیولیاروپای ِایسپانیولیمکز" +
			"یک ِایسپانیولیکانادای ِفرانسویسوییس ِفرانسویپایین ساکسونیفلمیشبرزیل" +
			" ِپرتغالیاروپای ِپرتغالیمولداویکنگو سواحیلیساده چینیسنتی چینی",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000c, 0x000c, 0x001c, 0x0024, 0x002e, 0x002e,
			0x0036, 0x0040, 0x0040, 0x0040, 0x0053, 0x0061, 0x006f, 0x007b,
			0x007b, 0x008d, 0x0099, 0x00a1, 0x00af, 0x00bf, 0x00cf, 0x00d7,
			0x00d7, 0x00e7, 0x00e7, 0x00ed, 0x00ed, 0x00f9, 0x0101, 0x0111,
			0x011d, 0x011d, 0x012b, 0x0138, 0x0144, 0x0152, 0x0162, 0x0176,
			0x0188, 0x0192, 0x019c, 0x019c, 0x01a6, 0x01b4, 0x01c0, 0x01ce,
			0x01e3, 0x01ed, 0x01ed, 0x01f7, 0x0203, 0x020f, 0x0219, 0x0221,
			0x0229, 0x0231, 0x0231, 0x023d, 0x024d, 0x0257, 0x0261, 0x0261,
			// Entry 40 - 7F
			0x0261, 0x0275, 0x0275, 0x027f, 0x0292, 0x0292, 0x0292, 0x02a0,
			0x02b2, 0x02c4, 0x02d0, 0x02dc, 0x02e4, 0x02e4, 0x02f0, 0x02f0,
			0x02fa, 0x030e, 0x0316, 0x0324, 0x0333, 0x0333, 0x033f, 0x0349,
			0x0349, 0x0355, 0x0361, 0x036b, 0x0381, 0x038b, 0x038b, 0x0399,
			0x03a5, 0x03b5, 0x03cc, 0x03dc, 0x03ec, 0x03ec, 0x03f8, 0x0404,
			0x0416, 0x0420, 0x042c, 0x0438, 0x0442, 0x0451, 0x0451, 0x0466,
			0x0470, 0x0470, 0x047a, 0x0493, 0x04aa, 0x04aa, 0x04aa, 0x04aa,
			0x04aa, 0x04aa, 0x04b6, 0x04c0, 0x04c0, 0x04cc, 0x04cc, 0x04da,
			// Entry 80 - BF
			0x04e2, 0x04f0, 0x04fe, 0x050a, 0x0514, 0x0526, 0x052e, 0x0546,
			0x0556, 0x0556, 0x055e, 0x0571, 0x057b, 0x0589, 0x0597, 0x05ab,
			0x05ab, 0x05b3, 0x05c5, 0x05d7, 0x05df, 0x05df, 0x05df, 0x05ef,
			0x05f9, 0x0607, 0x0613, 0x0621, 0x062d, 0x0635, 0x0649, 0x0657,
			0x0657, 0x0665, 0x066d, 0x066d, 0x0679, 0x0679, 0x0685, 0x0695,
			0x069d, 0x06a7, 0x06a7, 0x06b5, 0x06b5, 0x06b5, 0x06bf, 0x06c7,
			0x06c7, 0x06d3, 0x06d3, 0x06db, 0x06e3, 0x06e3, 0x06e3, 0x06e3,
			0x06e3, 0x06e3, 0x06e3, 0x06e9, 0x06e9, 0x06e9, 0x06e9, 0x06e9,
			// Entry C0 - FF
			0x06e9, 0x06e9, 0x06e9, 0x06e9, 0x06e9, 0x06f5, 0x06f5, 0x06f5,
			0x06f5, 0x06f5, 0x06f5, 0x06f5, 0x06f5, 0x06fb, 0x06fb, 0x06fb,
			0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb, 0x06fb,
			0x06fb, 0x06fb, 0x0707, 0x0707, 0x0711, 0x0711, 0x0711, 0x0724,
			0x0724, 0x0724, 0x0724, 0x0724, 0x0724, 0x0724, 0x0724, 0x0724,
			0x0724, 0x0724, 0x072e, 0x072e, 0x072e, 0x072e, 0x072e, 0x072e,
			0x072e, 0x072e, 0x072e, 0x072e, 0x072e, 0x072e, 0x0736, 0x0736,
			0x0736, 0x0736, 0x0736, 0x0736, 0x0736, 0x0736, 0x0746, 0x0746,
			// Entry 100 - 13F
			0x075b, 0x075b, 0x075b, 0x075b, 0x075b, 0x075b, 0x075b, 0x075b,
			0x0765, 0x0765, 0x0765, 0x0765, 0x0765, 0x0773, 0x0773, 0x0786,
			0x0786, 0x0796, 0x0796, 0x07a7, 0x07a7, 0x07a7, 0x07af, 0x07af,
			0x07af, 0x07af, 0x07af, 0x07af, 0x07af, 0x07af, 0x07af, 0x07af,
			0x07af, 0x07bf, 0x07bf, 0x07bf, 0x07bf, 0x07bf, 0x07bf, 0x07bf,
			0x07bf, 0x07bf, 0x07bf, 0x07bf, 0x07cf, 0x07cf, 0x07cf, 0x07cf,
			0x07cf, 0x07cf, 0x07cf, 0x07cf, 0x07cf, 0x07cf, 0x07cf, 0x07cf,
			0x07cf, 0x07cf, 0x07cf, 0x07cf, 0x07e6, 0x07e6, 0x07e6, 0x07ee,
			// Entry 140 - 17F
			0x07ee, 0x07ee, 0x07ee, 0x0800, 0x0800, 0x0800, 0x0800, 0x0800,
			0x0815, 0x0815, 0x0815, 0x0815, 0x0815, 0x0815, 0x0815, 0x0815,
			0x0815, 0x0815, 0x0821, 0x082d, 0x082d, 0x082d, 0x082d, 0x082d,
			0x0839, 0x0839, 0x0839, 0x0847, 0x0847, 0x0847, 0x0847, 0x0847,
			0x0855, 0x0866, 0x0866, 0x0866, 0x0866, 0x0866, 0x0866, 0x087b,
			0x087b, 0x087b, 0x087b, 0x0889, 0x0889, 0x089e, 0x08ac, 0x08ac,
			0x08ac, 0x08ac, 0x08ac, 0x08ac, 0x08ac, 0x08ac, 0x08ba, 0x08c8,
			0x08c8, 0x08c8, 0x08c8, 0x08c8, 0x08d2, 0x08d2, 0x08d2, 0x08d2,
			// Entry 180 - 1BF
			0x08d2, 0x08d2, 0x08d2, 0x08de, 0x08de, 0x08de, 0x08de, 0x08f1,
			0x08f1, 0x08f1, 0x08f1, 0x08f1, 0x08f9, 0x08f9, 0x0903, 0x0903,
			0x0903, 0x0903, 0x0903, 0x0903, 0x0903, 0x0903, 0x0903, 0x090f,
			0x090f, 0x090f, 0x090f, 0x090f, 0x091b, 0x0929, 0x0929, 0x093e,
			0x0948, 0x0948, 0x0948, 0x0948, 0x0948, 0x0952, 0x0952, 0x0952,
			0x0960, 0x0960, 0x0960, 0x0960, 0x0960, 0x0960, 0x0960, 0x0960,
			0x096e, 0x096e, 0x096e, 0x0976, 0x098d, 0x098d, 0x098d, 0x098d,
			0x098d, 0x099b, 0x099b, 0x099b, 0x099b, 0x099b, 0x09a3, 0x09a3,
			// Entry 1C0 - 1FF
			0x09ab, 0x09ab, 0x09ab, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb,
			0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb,
			0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb, 0x09bb,
			0x09bb, 0x09cc, 0x09cc, 0x09cc, 0x09cc, 0x09cc, 0x09cc, 0x09cc,
			0x09d6, 0x09d6, 0x09d6, 0x09d6, 0x09d6, 0x09d6, 0x09e0, 0x09e0,
			0x09e0, 0x09e0, 0x09ee, 0x09ee, 0x09ee, 0x09ee, 0x09ee, 0x09fa,
			0x09fa, 0x09fa, 0x09fa, 0x0a0d, 0x0a0d, 0x0a19, 0x0a19, 0x0a19,
			0x0a32, 0x0a32, 0x0a32, 0x0a40, 0x0a40, 0x0a40, 0x0a40, 0x0a40,
			// Entry 200 - 23F
			0x0a40, 0x0a53, 0x0a64, 0x0a79, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c,
			0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c,
			0x0a8c, 0x0a8c, 0x0a8c, 0x0a8c, 0x0a96, 0x0a96, 0x0a96, 0x0a96,
			0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96,
			0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96, 0x0a96,
			0x0aa6, 0x0aa6, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ac8, 0x0ae4, 0x0aec,
			0x0aec, 0x0aec, 0x0aec, 0x0aec, 0x0aec, 0x0aec, 0x0afa, 0x0afa,
			0x0afa, 0x0afa, 0x0afa, 0x0b0a, 0x0b0a, 0x0b0a, 0x0b0a, 0x0b12,
			// Entry 240 - 27F
			0x0b12, 0x0b12, 0x0b12, 0x0b12, 0x0b12, 0x0b12, 0x0b12, 0x0b12,
			0x0b12, 0x0b12, 0x0b46, 0x0b46, 0x0b72, 0x0b72, 0x0b96, 0x0bb2,
			0x0bcb, 0x0be4, 0x0c07, 0x0c26, 0x0c41, 0x0c5c, 0x0c8c, 0x0caf,
			0x0cd0, 0x0cd0, 0x0cef, 0x0d0a, 0x0d23, 0x0d2d, 0x0d48, 0x0d65,
			0x0d73, 0x0d73, 0x0d8a, 0x0d9b, 0x0dac,
		},
	},
	{ // naq
		"AkangowabAmharicgowabArabiǁî gowabBelarusanǁî gowabBulgariaǁî gowabBenga" +
			"liǁî gowabCzechǁî gowabDuitsXriksEngelsSpaansPersiaǁî gowabFransHaus" +
			"agowabHindigowabHungariaǁî gowabIndonesiaǁî gowabIgbogowabItaliansJa" +
			"paneesJavaneseKhmerǁî gowab, CentralKoreaǁî gowabMalayǁî gowabBurmes" +
			"ǁî gowabNepalǁî gowabHollandsPunjabigowabPoleǁî gowabPortugeesRoman" +
			"iaǁî gowabRussiaǁî gowabRwandaǁî gowabSomaliǁî gowabSwedeǁî gowabTam" +
			"ilǁî gowabThaiǁî gowabTurkeǁî gowabUkrainiaǁî gowabUrduǁî gowabVietn" +
			"amǁî gowabYorubabChineesǁî gowab, MandarinniZulubKhoekhoegowab",
		[]uint16{ // 436 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0015, 0x0015,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0037, 0x0049,
			0x0049, 0x0049, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x006e, 0x006e, 0x006e, 0x006e, 0x0073, 0x0079, 0x0079, 0x007f,
			0x007f, 0x007f, 0x008f, 0x008f, 0x008f, 0x008f, 0x008f, 0x0094,
			0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x0094, 0x009e,
			0x009e, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00ba, 0x00ba, 0x00ba,
			// Entry 40 - 7F
			0x00ba, 0x00cd, 0x00cd, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00de, 0x00de, 0x00e6, 0x00ee, 0x00ee, 0x00ee, 0x00ee, 0x00ee,
			0x00ee, 0x00ee, 0x0106, 0x0106, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0124, 0x0124, 0x0134, 0x0134, 0x0134,
			0x0143, 0x0143, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x014b,
			0x014b, 0x014b, 0x014b, 0x014b, 0x014b, 0x0157, 0x0157, 0x0165,
			// Entry 80 - BF
			0x0165, 0x016e, 0x016e, 0x016e, 0x016e, 0x017f, 0x018f, 0x019f,
			0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f, 0x019f,
			0x019f, 0x019f, 0x01af, 0x01af, 0x01af, 0x01af, 0x01af, 0x01af,
			0x01be, 0x01be, 0x01cd, 0x01cd, 0x01cd, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x01fc,
			0x020a, 0x020a, 0x020a, 0x021b, 0x021b, 0x021b, 0x021b, 0x021b,
			0x021b, 0x0222, 0x0222, 0x023f, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry C0 - FF
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 100 - 13F
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 140 - 17F
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			// Entry 180 - 1BF
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244, 0x0244,
			0x0244, 0x0244, 0x0244, 0x0251,
		},
	},
	{ // nd
		"isi-Akhaniisi-Amaharikhiisi-Alabhuisi-Bhelarashiyaniisi-Bulgariaisi-Bhen" +
			"galiisi-Czechisi-Jalimaniisi-Gilikiisi-Ngisiisi-Sipeyiniisi-Pheshiya" +
			"niisi-Fulentshiisi-Hausaisi-Hindiisi-Hangariisi-Indonesiaisi-Igboisi" +
			"-Italianoisi-Japhaniisi-Javaisi-Khambodiyaisi-Koriyaisi-Malayiisi-Bu" +
			"rmaisiNdebeleisi-Nepaliisi-Dutchisi-Phunjabiisi-Pholoshiisi-Potukezi" +
			"isi-Romaniisi-Rashiyaisi-Ruwandaisi-Somaliisi-Swidishiisi-Thamilisi-" +
			"Thayiisi-Thekishiisi-Ukrainisi-Uduisi-Vietnameseisi-Yorubhaisi-China" +
			"isi-Zulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0022, 0x0034, 0x0040,
			0x0040, 0x0040, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c, 0x004c,
			0x004c, 0x004c, 0x004c, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0061, 0x0061, 0x0061, 0x0061, 0x006b, 0x0074, 0x0074, 0x0080,
			0x0080, 0x0080, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x009b,
			0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x009b, 0x00a4,
			0x00a4, 0x00ad, 0x00ad, 0x00ad, 0x00ad, 0x00b8, 0x00b8, 0x00b8,
			// Entry 40 - 7F
			0x00b8, 0x00c5, 0x00c5, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00d9, 0x00d9, 0x00e4, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00fa, 0x00fa, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
			0x0104, 0x0104, 0x0104, 0x010e, 0x010e, 0x0117, 0x0117, 0x0121,
			0x012b, 0x012b, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0140, 0x0140, 0x014c,
			// Entry 80 - BF
			0x014c, 0x0158, 0x0158, 0x0158, 0x0158, 0x0162, 0x016d, 0x0178,
			0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178, 0x0178,
			0x0178, 0x0178, 0x0182, 0x0182, 0x0182, 0x0182, 0x0182, 0x0182,
			0x018e, 0x018e, 0x0198, 0x0198, 0x0198, 0x01a1, 0x01a1, 0x01a1,
			0x01a1, 0x01a1, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01b7,
			0x01be, 0x01be, 0x01be, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
			0x01cc, 0x01d7, 0x01d7, 0x01e0, 0x01e8,
		},
	},
	{ // ne
		neLangStr,
		neLangIdx,
	},
	{ // nl
		nlLangStr,
		nlLangIdx,
	},
	{ // nmg
		"Kiɛl akanKiɛl amariaKiɛl b’árabeKiɛl belarussieKiɛl bulgariaKiɛl bengali" +
			"aKiɛl bó tchɛkJámanKiɛl bó grɛkNgɛ̄lɛ̄nPaŋáKiɛl pɛrsiaFalaKiɛl máwús" +
			"áKiɛl b’indienKiɛl b’ɔ́ngroisKiɛl indonesieKiɛl ikboKiɛl italiaKiɛl" +
			" bó japonɛ̌Kiɛl bó javanɛ̌Kiɛl bó mɛrKiɛl koréKiɛl Malɛ̌siāKiɛl birm" +
			"aniaKiɛl nepalKiɛl bóllandaisKiɛl pɛndjabiKiɛl pɔlɔŋeKiɛl bó pɔ̄rtug" +
			"ɛ̂Kiɛl bó rumɛ̂nKiɛl russiaKiɛl rwandāKiɛl somaliāKiɛl bó suedoisKi" +
			"ɛl tamulKiɛl thaïKiɛl bó turkKiɛl b’ukrɛ̄nienKiɛl úrduKiɛl viɛtnamY" +
			"orúbâKiɛl bó chinoisZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0036, 0x0044,
			0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0068, 0x0068, 0x0068, 0x0068, 0x0077, 0x0083, 0x0083, 0x0089,
			0x0089, 0x0089, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x00a9,
			0x00a9, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00cd, 0x00cd, 0x00cd,
			// Entry 40 - 7F
			0x00cd, 0x00dc, 0x00dc, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6,
			0x00f2, 0x00f2, 0x0105, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
			0x0118, 0x0118, 0x0126, 0x0126, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0131, 0x0142, 0x0142, 0x0150, 0x0150, 0x0150,
			0x015b, 0x015b, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x017b, 0x017b, 0x018a,
			// Entry 80 - BF
			0x018a, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01b3, 0x01bf, 0x01cc,
			0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc, 0x01cc,
			0x01cc, 0x01cc, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01eb, 0x01eb, 0x01f6, 0x01f6, 0x01f6, 0x0201, 0x0201, 0x0201,
			0x0201, 0x0201, 0x020f, 0x020f, 0x020f, 0x020f, 0x020f, 0x0224,
			0x022f, 0x022f, 0x022f, 0x023d, 0x023d, 0x023d, 0x023d, 0x023d,
			0x023d, 0x0245, 0x0245, 0x0256, 0x025a,
		},
	},
	{ // nn
		"afarabkhasiskavestiskafrikaansakanamhariskaragonskarabiskassamesiskavari" +
			"skaymaraaserbajdsjanskbasjkirskkviterussiskbulgarskbislamabambaraben" +
			"galitibetanskbretonskbosniskkatalansktsjetsjenskchamorrokorsikanskcr" +
			"eetsjekkiskkyrkjeslavisktsjuvanskwalisiskdansktyskdivehidzongkhaeweg" +
			"reskengelskesperantospanskestiskbaskiskpersiskfulfuldefinskfijianskf" +
			"ærøyskfranskvestfrisiskirskskotsk-gæliskgaliciskguaranigujaratimanx" +
			"hausahebraiskhindihiri motukroatiskhaitiskungarskarmenskhererointerl" +
			"inguaindonesiskinterlingueibosichuan-yiinupiakidoislandskitalienskin" +
			"uittiskjapanskjavanesiskgeorgiskkikongokikuyukuanyamakasakhiskgrønla" +
			"ndsk (kalaallisut)khmerkannadakoreanskkanurikasjmirikurdiskkomikorni" +
			"skkirgisisklatinluxemburgskgandalimburgisklingalalaotisklitauiskluba" +
			"-katangalatviskmadagassiskmarshallesiskmaorimakedonskmalayalammongol" +
			"skmarathimalayiskmaltesiskburmesisknaurunord-ndebelenepalskndonganed" +
			"erlandsknynorskbokmålsør-ndebelenavajonyanjaoksitanskojibwaoromoodia" +
			"ossetiskpanjabipalipolskpashtoportugisiskquechuaretoromanskrundirume" +
			"nskrussiskkinjarwandasanskritsardinsksindhinordsamisksangosingalesis" +
			"kslovakiskslovensksamoanskshonasomalialbanskserbiskswatisørsothosund" +
			"anesisksvenskswahilitamiltelugutadsjikiskthaitigrinjaturkmensktswana" +
			"tongansktyrkisktsongatatarisktahitiskuiguriskukrainskurduusbekiskven" +
			"davietnamesiskvolapykvallonskwolofxhosajiddiskjorubazhuangkinesiskzu" +
			"luachinesiskacoliadangmeadygeiskafrihiliaghemainuakkadiskaleutisksør" +
			"-altajgammalengelskangikaarameiskmapudungunarapahoarawakasu (Tanzani" +
			"a)asturiskavadhibaluchibalinesiskbasabamunbejabembabena (Tanzania)bh" +
			"ojpuribikolbinisiksikabrajbodobakossiburjatiskbuginesiskblincaddocar" +
			"ibatsamcebuanokigachibchatsjagataiskchuukesiskmarichinookchoctawchip" +
			"ewianskcherokeecheyennesoranikoptiskkrimtatariskseselwa (fransk-kreo" +
			"lsk)kasjubiskdakotadargwataitadelawareslavejdogribdinkazarmadogrilåg" +
			"sorbiskdualamellomnederlandskjola-fonyidyuladazagaembuefikgammalegyp" +
			"tiskekajukelamitemellomengelskewondofangfilippinskfonmellomfranskgam" +
			"malfransknordfrisiskaustfrisiskfriuliskgagayogbayageezgilbertesemell" +
			"omhøgtyskgammalhøgtyskgondigorontalogotiskgrebogammalgresksveitserty" +
			"skgusiigwichinhaidahawaiiskhiligaynonhettittiskhmonghøgsorbiskhupaib" +
			"anibibioilokoingusjisklojbanngombamachamejødepersiskjødearabiskkarak" +
			"alpakiskkabylekachinjjukambakawikabardisktyapmakondekabuverdianukoro" +
			"khasikhotanesiskkoyra chiinikakokalenjinkimbundukonkanikosraeanskkpe" +
			"llekarachay-balkarkarelskkurukhshambalabafiakølnskkumykkutenailadino" +
			"langilahndalambalezghianlakotamongolozinord-luriskluba-lulualuisenol" +
			"undaluolushaiolulujiamaduresiskmagahimaithilimakasarmandingomasaimok" +
			"shamandarmendemerumorisyenmellomirskMakhuwa-Meettometa’micmacminangk" +
			"abaumandsjumanipurimohawkmossimundangfleire språkcreekmirandesiskmar" +
			"warierziamazanderaninapolitansknamalågtysknewariniasniuiskkwasiongie" +
			"mboonnogaigammalnorskn’konordsothonuerklassisk newarisknyamwezinyank" +
			"olenyoronzimaosageottomansk tyrkiskpangasinanpahlavipampangapapiamen" +
			"topalauisknigeriansk pidgingammalpersiskfønikiskponapiskprøyssiskgam" +
			"malprovençalskk’icherajasthanirapanuirarotonganskromboromaniarumensk" +
			"rwasandawesakhasamaritansk arameisksamburusasaksantalingambaysangusi" +
			"cilianskskotsksenaselkupiskKoyraboro Sennigammalirsktachelhitshansid" +
			"amosørsamisklulesamiskenaresamiskskoltesamisksoninkesogdisksranan to" +
			"ngoserersahosukumasususumeriskshimaoreklassisk syrisksyrisktemneteso" +
			"terenotetumtigrétivitokelauklingontlingittamasjektonga (Nyasa)tok pi" +
			"sintarokotsimshiantumbukatuvalutasawaqtuvinisksentral-tamazightudmur" +
			"tugaritiskumbundurotvaivotiskvunjowalsertyskwolayttawaraywashokalmyk" +
			"isksogayaoyapesiskyangbenyembakantonesiskzapotecblissymbolzenagastan" +
			"dard marokkansk tamazightzuniutan språkleg innhaldzazamoderne standa" +
			"rdarabiskbritisk engelsklågsaksiskflamskmoldaviskserbokroatiskforenk" +
			"la kinesisktradisjonell kinesisk",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0015, 0x001e, 0x0022, 0x002a, 0x0032,
			0x0039, 0x0043, 0x004a, 0x0050, 0x005e, 0x0067, 0x0073, 0x007b,
			0x0082, 0x0089, 0x0090, 0x0099, 0x00a1, 0x00a8, 0x00b1, 0x00bc,
			0x00c4, 0x00ce, 0x00d2, 0x00db, 0x00e8, 0x00f1, 0x00f9, 0x00fe,
			0x0102, 0x0108, 0x0110, 0x0113, 0x0118, 0x011f, 0x0128, 0x012e,
			0x0134, 0x013b, 0x0142, 0x014a, 0x014f, 0x0157, 0x0160, 0x0166,
			0x0171, 0x0175, 0x0183, 0x018b, 0x0192, 0x019a, 0x019e, 0x01a3,
			0x01ab, 0x01b0, 0x01b9, 0x01c1, 0x01c8, 0x01cf, 0x01d6, 0x01dc,
			// Entry 40 - 7F
			0x01e7, 0x01f1, 0x01fc, 0x01ff, 0x0209, 0x0210, 0x0213, 0x021b,
			0x0224, 0x022d, 0x0234, 0x023e, 0x0246, 0x024d, 0x0253, 0x025b,
			0x0264, 0x027d, 0x0282, 0x0289, 0x0291, 0x0297, 0x029f, 0x02a6,
			0x02aa, 0x02b1, 0x02ba, 0x02bf, 0x02ca, 0x02cf, 0x02d9, 0x02e0,
			0x02e7, 0x02ef, 0x02fb, 0x0302, 0x030d, 0x031a, 0x031f, 0x0328,
			0x0331, 0x0339, 0x0340, 0x0348, 0x0351, 0x035a, 0x035f, 0x036b,
			0x0372, 0x0378, 0x0383, 0x038a, 0x0391, 0x039d, 0x03a3, 0x03a9,
			0x03b2, 0x03b8, 0x03bd, 0x03c1, 0x03c9, 0x03d0, 0x03d4, 0x03d9,
			// Entry 80 - BF
			0x03df, 0x03ea, 0x03f1, 0x03fc, 0x0401, 0x0408, 0x040f, 0x041a,
			0x0422, 0x042a, 0x0430, 0x043a, 0x043f, 0x044a, 0x0453, 0x045b,
			0x0463, 0x0468, 0x046e, 0x0475, 0x047c, 0x0481, 0x048a, 0x0495,
			0x049b, 0x04a2, 0x04a7, 0x04ad, 0x04b7, 0x04bb, 0x04c3, 0x04cc,
			0x04d2, 0x04da, 0x04e1, 0x04e7, 0x04ef, 0x04f7, 0x04ff, 0x0507,
			0x050b, 0x0513, 0x0518, 0x0524, 0x052b, 0x0533, 0x0538, 0x053d,
			0x0544, 0x054a, 0x0550, 0x0558, 0x055c, 0x0566, 0x056b, 0x0572,
			0x057a, 0x057a, 0x0582, 0x0587, 0x058b, 0x0593, 0x0593, 0x059b,
			// Entry C0 - FF
			0x059b, 0x05a5, 0x05b2, 0x05b8, 0x05c0, 0x05ca, 0x05ca, 0x05d1,
			0x05d1, 0x05d1, 0x05d7, 0x05d7, 0x05d7, 0x05e5, 0x05e5, 0x05ed,
			0x05ed, 0x05f3, 0x05fa, 0x0604, 0x0604, 0x0608, 0x060d, 0x060d,
			0x060d, 0x0611, 0x0616, 0x0616, 0x0625, 0x0625, 0x0625, 0x0625,
			0x062d, 0x0632, 0x0636, 0x0636, 0x0636, 0x063d, 0x063d, 0x063d,
			0x0641, 0x0641, 0x0645, 0x064c, 0x0655, 0x065f, 0x065f, 0x0663,
			0x0663, 0x0668, 0x066d, 0x066d, 0x0672, 0x0679, 0x067d, 0x0684,
			0x068f, 0x0699, 0x069d, 0x06a4, 0x06ab, 0x06b6, 0x06be, 0x06c6,
			// Entry 100 - 13F
			0x06cc, 0x06d3, 0x06d3, 0x06df, 0x06f7, 0x0700, 0x0706, 0x070c,
			0x0711, 0x0719, 0x071f, 0x0725, 0x072a, 0x072f, 0x0734, 0x073f,
			0x073f, 0x0744, 0x0755, 0x075f, 0x0764, 0x076a, 0x076e, 0x0772,
			0x0772, 0x0780, 0x0786, 0x078d, 0x079a, 0x079a, 0x07a0, 0x07a0,
			0x07a4, 0x07ae, 0x07ae, 0x07b1, 0x07b1, 0x07bd, 0x07c9, 0x07c9,
			0x07d4, 0x07df, 0x07e7, 0x07e9, 0x07e9, 0x07e9, 0x07ed, 0x07f2,
			0x07f2, 0x07f6, 0x0800, 0x0800, 0x080e, 0x081c, 0x081c, 0x0821,
			0x082a, 0x0830, 0x0835, 0x0840, 0x084c, 0x084c, 0x084c, 0x0851,
			// Entry 140 - 17F
			0x0858, 0x085d, 0x085d, 0x0865, 0x0865, 0x086f, 0x0879, 0x087e,
			0x0889, 0x0889, 0x088d, 0x0891, 0x0897, 0x089c, 0x08a5, 0x08a5,
			0x08a5, 0x08ab, 0x08b1, 0x08b8, 0x08c4, 0x08d0, 0x08d0, 0x08dd,
			0x08e3, 0x08e9, 0x08ec, 0x08f1, 0x08f5, 0x08fe, 0x08fe, 0x0902,
			0x0909, 0x0915, 0x0915, 0x0919, 0x0919, 0x091e, 0x0929, 0x0935,
			0x0935, 0x0935, 0x0939, 0x0941, 0x0949, 0x0949, 0x0950, 0x095a,
			0x0960, 0x096f, 0x096f, 0x096f, 0x0976, 0x097c, 0x0984, 0x0989,
			0x0990, 0x0995, 0x099c, 0x09a2, 0x09a7, 0x09ad, 0x09b2, 0x09ba,
			// Entry 180 - 1BF
			0x09ba, 0x09ba, 0x09ba, 0x09c0, 0x09c0, 0x09c5, 0x09c9, 0x09d4,
			0x09d4, 0x09de, 0x09e5, 0x09ea, 0x09ed, 0x09f3, 0x09fb, 0x09fb,
			0x09fb, 0x0a05, 0x0a05, 0x0a0b, 0x0a13, 0x0a1a, 0x0a22, 0x0a27,
			0x0a27, 0x0a2d, 0x0a33, 0x0a38, 0x0a3c, 0x0a44, 0x0a4e, 0x0a5c,
			0x0a63, 0x0a69, 0x0a74, 0x0a7b, 0x0a83, 0x0a89, 0x0a8e, 0x0a8e,
			0x0a95, 0x0aa2, 0x0aa7, 0x0ab2, 0x0ab9, 0x0ab9, 0x0ab9, 0x0abe,
			0x0ac9, 0x0ac9, 0x0ad4, 0x0ad8, 0x0ae0, 0x0ae6, 0x0aea, 0x0af0,
			0x0af0, 0x0af6, 0x0aff, 0x0b04, 0x0b0f, 0x0b0f, 0x0b15, 0x0b1e,
			// Entry 1C0 - 1FF
			0x0b22, 0x0b33, 0x0b3b, 0x0b43, 0x0b48, 0x0b4d, 0x0b52, 0x0b63,
			0x0b6d, 0x0b74, 0x0b7c, 0x0b86, 0x0b8e, 0x0b8e, 0x0b9f, 0x0b9f,
			0x0b9f, 0x0bac, 0x0bac, 0x0bb5, 0x0bb5, 0x0bb5, 0x0bbd, 0x0bc7,
			0x0bd9, 0x0be1, 0x0be1, 0x0beb, 0x0bf2, 0x0bfe, 0x0bfe, 0x0bfe,
			0x0c03, 0x0c09, 0x0c09, 0x0c09, 0x0c09, 0x0c11, 0x0c14, 0x0c1b,
			0x0c20, 0x0c34, 0x0c3b, 0x0c40, 0x0c47, 0x0c47, 0x0c4e, 0x0c53,
			0x0c5d, 0x0c63, 0x0c63, 0x0c63, 0x0c63, 0x0c67, 0x0c67, 0x0c70,
			0x0c7f, 0x0c89, 0x0c89, 0x0c92, 0x0c96, 0x0c96, 0x0c9c, 0x0c9c,
			// Entry 200 - 23F
			0x0c9c, 0x0ca6, 0x0cb0, 0x0cbb, 0x0cc7, 0x0cce, 0x0cd5, 0x0ce1,
			0x0ce6, 0x0cea, 0x0cea, 0x0cf0, 0x0cf4, 0x0cfc, 0x0d04, 0x0d13,
			0x0d19, 0x0d19, 0x0d19, 0x0d1e, 0x0d22, 0x0d28, 0x0d2d, 0x0d33,
			0x0d37, 0x0d3e, 0x0d3e, 0x0d45, 0x0d4c, 0x0d4c, 0x0d54, 0x0d61,
			0x0d6a, 0x0d6a, 0x0d70, 0x0d70, 0x0d79, 0x0d79, 0x0d80, 0x0d86,
			0x0d8d, 0x0d95, 0x0da6, 0x0dac, 0x0db5, 0x0dbc, 0x0dbf, 0x0dc2,
			0x0dc2, 0x0dc2, 0x0dc2, 0x0dc2, 0x0dc8, 0x0dc8, 0x0dcd, 0x0dd7,
			0x0ddf, 0x0de4, 0x0de9, 0x0de9, 0x0de9, 0x0df2, 0x0df2, 0x0df6,
			// Entry 240 - 27F
			0x0df9, 0x0e01, 0x0e08, 0x0e0d, 0x0e0d, 0x0e18, 0x0e1f, 0x0e29,
			0x0e29, 0x0e2f, 0x0e4c, 0x0e50, 0x0e66, 0x0e6a, 0x0e81, 0x0e81,
			0x0e81, 0x0e81, 0x0e81, 0x0e81, 0x0e90, 0x0e90, 0x0e90, 0x0e90,
			0x0e90, 0x0e90, 0x0e90, 0x0e90, 0x0e9b, 0x0ea1, 0x0ea1, 0x0ea1,
			0x0eaa, 0x0eb7, 0x0eb7, 0x0ec8, 0x0edd,
		},
	},
	{ // nnh
		"nzǎmɔ̂ɔnngilísèShwóŋò menkesaŋfelaŋséeShwóŋò pʉa mbasǎShwóŋò pamomShwóŋò" +
			" pʉa nzsekàʼaShwóŋò pafudShwóŋò pʉ̀a njinikomShwóŋò pakɔsiShwóŋò mbu" +
			"luShwóŋò ngáŋtÿɔʼShwóŋò pʉa YɔɔnmendiShwóŋò pʉa shÿó BɛgtùaShwóŋò ng" +
			"iembɔɔnShwóŋò pʉa shÿó MbafìaShwóŋò Tsaŋ",
		[]uint16{ // 580 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x0015, 0x0015, 0x0015,
			0x0015, 0x0015, 0x0015, 0x0028, 0x0028, 0x0028, 0x0028, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry 40 - 7F
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry 80 - BF
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry C0 - FF
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0047, 0x0056, 0x0056,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x007e, 0x007e, 0x007e,
			0x007e, 0x007e, 0x007e, 0x007e, 0x0097, 0x0097, 0x0097, 0x0097,
			0x0097, 0x0097, 0x0097, 0x00a8, 0x00a8, 0x00a8, 0x00b7, 0x00b7,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			// Entry 100 - 13F
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce,
			0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00ce, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			// Entry 140 - 17F
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			// Entry 180 - 1BF
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			// Entry 1C0 - 1FF
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			// Entry 200 - 23F
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			// Entry 240 - 27F
			0x011b, 0x011b, 0x0138, 0x0147,
		},
	},
	{ // no
		noLangStr,
		noLangIdx,
	},
	{ // nus
		"Thok aka̱niThok bunyniThok JalabniThok bäläruthaThok bälga̱a̱rianiThok b" +
			"ängaliThok cikThok jarmaniThok girikniThok liŋli̱thniThok i̱thpaani" +
			"aniThok perthianiThok pɔrɔthaniThok ɣowthaniThok ɣändiniThok ɣänga̱a" +
			"̱riɛniThok indunithianiThok i̱gboniThok i̱talianiThok japanniThok j" +
			"abanithniThok kameeriThok kurianiThok mayɛyniThok bormi̱thniThok nap" +
			"alniThok da̱cThok puɔnjabaniThok pölicniThok puɔtigaliThok ji̱ römTh" +
			"ok ra̱ciaaniThok ruaandaniThok thomaalianiThok i̱thwidicniThok tamil" +
			"niThok tayniThok turkicniThok ukeraaniniThok udoniThok betnaamniThok" +
			" yurubaniThok caynaThok dhuluniThok Nath",
		[]uint16{ // 449 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x0017, 0x0017,
			0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0023, 0x0033, 0x0048,
			0x0048, 0x0048, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x005d, 0x005d, 0x005d, 0x005d, 0x005d,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0075, 0x0086, 0x0086, 0x0098,
			0x0098, 0x0098, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00a6, 0x00b6,
			0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00b6, 0x00c4,
			0x00c4, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00e9, 0x00e9, 0x00e9,
			// Entry 40 - 7F
			0x00e9, 0x00fa, 0x00fa, 0x0107, 0x0107, 0x0107, 0x0107, 0x0107,
			0x0116, 0x0116, 0x0122, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x013d, 0x013d, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0149, 0x0156, 0x0156, 0x0166, 0x0166, 0x0166,
			0x0172, 0x0172, 0x017c, 0x017c, 0x017c, 0x017c, 0x017c, 0x017c,
			0x017c, 0x017c, 0x017c, 0x017c, 0x017c, 0x018c, 0x018c, 0x0199,
			// Entry 80 - BF
			0x0199, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01b6, 0x01c5, 0x01d3,
			0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3, 0x01d3,
			0x01d3, 0x01d3, 0x01e3, 0x01e3, 0x01e3, 0x01e3, 0x01e3, 0x01e3,
			0x01f4, 0x01f4, 0x0200, 0x0200, 0x0200, 0x020a, 0x020a, 0x020a,
			0x020a, 0x020a, 0x0217, 0x0217, 0x0217, 0x0217, 0x0217, 0x0226,
			0x0230, 0x0230, 0x0230, 0x023e, 0x023e, 0x023e, 0x023e, 0x023e,
			0x023e, 0x024b, 0x024b, 0x0255, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry C0 - FF
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 100 - 13F
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 140 - 17F
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 180 - 1BF
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261, 0x0261,
			// Entry 1C0 - 1FF
			0x026a,
		},
	},
	{ // nyn
		"OrukaniOrumarikiOruharabuOruberarusiOruburugariyaOrubengariOruceekiOrugi" +
			"rimaaniOruguriikiOrungyerezaOrusupaaniOrupaasiyaOrufaransaOruhausaOr" +
			"uhindiOruhangareOruindoneziaOruiboOruyitareOrujapaaniOrujavaOrukambo" +
			"diyaOrukoreyaOrumalesiyaOruburumaOrunepaliOrudaakiOrupungyabiOrupoor" +
			"iOrupocugoOruromaniaOrurrashaOrunyarwandaOrusomaariOruswidiOrutamiri" +
			"OrutailandiOrukurukiOrukurainiOru-UruduOruviyetinaamuOruyorubaOrucha" +
			"inaOruzuruRunyankore",
		[]uint16{ // 452 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0010, 0x0010,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0031,
			0x0031, 0x0031, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
			0x003b, 0x003b, 0x003b, 0x0043, 0x0043, 0x0043, 0x0043, 0x0043,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0064, 0x0064, 0x006e,
			0x006e, 0x006e, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x008a,
			0x008a, 0x0092, 0x0092, 0x0092, 0x0092, 0x009c, 0x009c, 0x009c,
			// Entry 40 - 7F
			0x009c, 0x00a8, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00b7, 0x00b7, 0x00c1, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00d4, 0x00d4, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd, 0x00dd,
			0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00e8, 0x00f1, 0x00f1, 0x00f1,
			0x00fa, 0x00fa, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x0102, 0x0102, 0x010d, 0x010d, 0x0115,
			// Entry 80 - BF
			0x0115, 0x011e, 0x011e, 0x011e, 0x011e, 0x0128, 0x0131, 0x013d,
			0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d,
			0x013d, 0x013d, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0163, 0x0163, 0x0163,
			0x0163, 0x0163, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x0176,
			0x017f, 0x017f, 0x017f, 0x018d, 0x018d, 0x018d, 0x018d, 0x018d,
			0x018d, 0x0196, 0x0196, 0x019f, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry C0 - FF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 100 - 13F
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 140 - 17F
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 180 - 1BF
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6, 0x01a6,
			// Entry 1C0 - 1FF
			0x01a6, 0x01a6, 0x01a6, 0x01b0,
		},
	},
	{ // om
		"AfrikootaAfaan SidaamaaArabiffaaAfaan AzerbaijaniAfaan BelarusiaAfaan Bu" +
			"lgariyaAfaan BaangladeshiAfaan BosniyaaAfaan KatalaaAfaan CzechWelis" +
			"hiffaaAfaan DeenmaarkAfaan JarmaniiAfaan GiriikiIngliffaAfaan Espera" +
			"ntooAfaan IspeenAfaan IstooniyaAfaan BaskuuAfaan PersiaAfaan Fiilaan" +
			"diAfaan FaroeseAfaan FaransaayiiAfaan FirisiyaaniAfaan AyirishiiScot" +
			"s GaelicAfaan GalishiiAfaan GuaraniAfaan GujaratiAfaan HebrewAfaan H" +
			"indiiAfaan CroatianAfaan HangaariInterlinguaAfaan IndoneziyaAyiislan" +
			"diffaaAfaan XaaliyaaniAfaan JapaniiAfaan JavaAfaan GeorgianAfaan Kan" +
			"nadaAfaan KoreaAfaan LaatiniAfaan LiituniyaaAfaan LativiyaaAfaan Mac" +
			"edooniyaaMalayaalamiffaaAfaan MaratiiMalaayiffaaAfaan MaltesiiAfaan " +
			"NepaliiAfaan DachiiAfaan NorwegianAfaan NorweyiiAfaan OccitOromooAfa" +
			"an PunjabiiAfaan PolandiiAfaan PorchugaalAfaan RomaniyaaAfaan Rushiy" +
			"aaAfaan SinhaleseAfaan SlovakAfaan IslovaniyaaAfaan AlbaniyaaAfaan S" +
			"erbiyaAfaan SudaaniiAfaan SuwidiinSuwahiliiAfaan TamiliiAfaan Telugu" +
			"Afaan TayiiAfaan TigireeLammii TurkiiAfaan TurkiiAfaan UkreeniiAfaan" +
			" UrduAfaan UzbekAfaan VeetinamAfaan XhosaChineseAfaan ZuuluAfaan Fil" +
			"ippiniiAfaan KilingonAfaan Portugali (Braazil)Afaan Protuguese",
		[]uint16{ // 608 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0009, 0x0017, 0x0017,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0031, 0x0031, 0x0040, 0x004f,
			0x004f, 0x004f, 0x0061, 0x0061, 0x0061, 0x006f, 0x007c, 0x007c,
			0x007c, 0x007c, 0x007c, 0x0087, 0x0087, 0x0087, 0x0092, 0x00a1,
			0x00af, 0x00af, 0x00af, 0x00af, 0x00bc, 0x00c4, 0x00d4, 0x00e0,
			0x00ef, 0x00fb, 0x0107, 0x0107, 0x0116, 0x0116, 0x0123, 0x0134,
			0x0145, 0x0154, 0x0160, 0x016e, 0x017b, 0x0189, 0x0189, 0x0189,
			0x0195, 0x01a1, 0x01a1, 0x01af, 0x01af, 0x01bd, 0x01bd, 0x01bd,
			// Entry 40 - 7F
			0x01c8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01d8, 0x01e6,
			0x01f6, 0x01f6, 0x0203, 0x020d, 0x021b, 0x021b, 0x021b, 0x021b,
			0x021b, 0x021b, 0x021b, 0x0228, 0x0233, 0x0233, 0x0233, 0x0233,
			0x0233, 0x0233, 0x0233, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0250, 0x0250, 0x025f, 0x025f, 0x025f, 0x025f, 0x0271,
			0x0280, 0x0280, 0x028d, 0x0298, 0x02a6, 0x02a6, 0x02a6, 0x02a6,
			0x02b3, 0x02b3, 0x02bf, 0x02ce, 0x02dc, 0x02dc, 0x02dc, 0x02dc,
			0x02e7, 0x02e7, 0x02ed, 0x02ed, 0x02ed, 0x02fb, 0x02fb, 0x0309,
			// Entry 80 - BF
			0x0309, 0x0319, 0x0319, 0x0319, 0x0319, 0x0328, 0x0336, 0x0336,
			0x0336, 0x0336, 0x0336, 0x0336, 0x0336, 0x0345, 0x0351, 0x0362,
			0x0362, 0x0362, 0x0362, 0x0371, 0x037e, 0x037e, 0x037e, 0x038c,
			0x039a, 0x03a3, 0x03b0, 0x03bc, 0x03bc, 0x03c7, 0x03d4, 0x03e1,
			0x03e1, 0x03e1, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03ed, 0x03fb,
			0x0405, 0x0410, 0x0410, 0x041e, 0x041e, 0x041e, 0x041e, 0x0429,
			0x0429, 0x0429, 0x0429, 0x0430, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			// Entry C0 - FF
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			// Entry 100 - 13F
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b, 0x043b,
			0x043b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 140 - 17F
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 180 - 1BF
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 1C0 - 1FF
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			// Entry 200 - 23F
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b, 0x044b,
			0x044b, 0x044b, 0x044b, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			// Entry 240 - 27F
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459,
			0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0459, 0x0472, 0x0482,
		},
	},
	{ // or
		"ଅଫାର୍ଆବ୍ଖାଜିଆନ୍ଅବେସ୍ତନଆଫ୍ରିକାନସ୍ଅକନ୍ଆମହାରକିଆର୍ଗୋନୀଆରବିକ୍ଆସାମୀଆଭାରିକ୍ଆୟମା" +
			"ରାଆଜେରବାଇଜାନିବଶଖିର୍ବେଲାରୁଷିଆନ୍ବୁଲଗେରିଆନ୍ବିସଲାମାବାମ୍ବାରାବଙ୍ଗାଳୀତିବେ" +
			"ତାନ୍ବ୍ରେଟନ୍କାଟଲାନ୍କାଟାଲାନ୍ଚେଚନ୍ଚାମୋରୋକୋର୍ସିକାନ୍କ୍ରୀଚେକ୍ଚର୍ଚ୍ଚ ସ୍ଲା" +
			"ଭିକ୍ଚୁଭାଶ୍ୱେଲ୍ସଡାନ୍ନିସ୍ଜର୍ମାନ୍ଡିଭେହୀଭୂଟାନୀଇୱେଗ୍ରୀକ୍ଇଂରାଜୀଏସ୍ପାରେଣ୍" +
			"ଟୋସ୍ପାନିସ୍ଏସ୍ତୋନିଆନ୍ବାସ୍କ୍ୱିପର୍ସିଆନ୍ଫୁଲାହଫିନ୍ନିସ୍ଫିଜିଫାରୋଏସେଫ୍ରେଞ୍" +
			"ଚପଶ୍ଚିମ ଫ୍ରିସିୟନ୍ଇରିସ୍ସ୍କଟିସ୍ ଗାଏଲିକ୍ଗାଲସିଆନ୍ଗୁଆରାନୀଗୁଜୁରାଟୀମାଁକ୍ସ" +
			"ହୌସାହେବ୍ର୍ୟୁହିନ୍ଦୀହିରି ମୋଟୁକ୍ରୋଆଟିଆନ୍ହୈତାୟିନ୍ହଙ୍ଗେରିଆନ୍ଆର୍ମେନିଆନ୍ହ" +
			"େରେରୋଇର୍ଣ୍ଟଲିଙ୍ଗୁଆଇଣ୍ଡୋନେସିଆନ୍ଇର୍ଣ୍ଟରଲିଙ୍ଗୁଇଇଗ୍ବୋସିଚୁଆନ୍ ୟୀଇନୁପିୟା" +
			"କ୍ଇଡୋଆଇସଲାଣ୍ଡିକ୍ଇଟାଲିଆନ୍ଇନକୀଟୁତ୍ଜାପାନୀଜ୍ଜାଭାନୀଜ୍ଜର୍ଜିଆନ୍କଙ୍ଗୋକୀକୁୟ" +
			"ୁକ୍ୱାନ୍ୟାମ୍କାଜାକ୍ଗ୍ରୀନଲାଣ୍ଡିକ୍ଖ୍ମେର୍କନ୍ନଡକୋରିଆନ୍କନୁରୀକାଶ୍ମିରୀକୁର୍ଦ" +
			"୍ଦିଶ୍କୋମିକୋର୍ନିସ୍କିରଗିଜ୍ଲାଟିନ୍ଲକ୍ସେମବର୍ଗିସ୍ଗନ୍ଦାଲିମ୍ବୁର୍ଗିସ୍ଲିଙ୍ଗା" +
			"ଲାଲାଓଲିଥୁଆନିଆନ୍ଲ୍ୟୁବା-କାଟାଙ୍ଗାଲାଟଭିଆନ୍ମାଲାଗାସୀମାର୍ଶାଲୀଜ୍ମାଓରୀମାକଡୋ" +
			"ନିଆନ୍ମାଲାୟଲମ୍ମଙ୍ଗୋଲିଆନ୍ମରାଠୀମାଲୟମାଲଟୀଜ୍ବର୍ମୀଜ୍ନାଉରୁଉତ୍ତର ନେଡବେଲେନେ" +
			"ପାଳୀଡୋଙ୍ଗାଡଚ୍ନରୱେଜିଆନ୍ ନିୟୋର୍ସ୍କନରୱେଜିଆନ୍ ବୋକମଲ୍ଦକ୍ଷିଣ ନେଡବେଲେନାଭା" +
			"ଜୋନିୟାଞ୍ଜଓସିଟାନ୍ଓଜିୱାଓରୋମୋଓଡ଼ିଆଓସେଟିକ୍ପଞ୍ଜାବୀପାଲିପୋଲିଶ୍ପାସ୍ତୋପର୍ତ୍" +
			"ତୁଗ୍ରୀଜ୍କ୍ୱେଚୁଆରେହେଟୋ-ରୋମାନ୍ସରୁଣ୍ଡିରୋମାନିଆନ୍ରଷିଆନ୍କିନ୍ୟାରୱାଣ୍ଡାସଂସ" +
			"୍କୃତସର୍ଦିନିଆନ୍ସିନ୍ଧୀଉତ୍ତର ସାମିସାଙ୍ଗୋସିଂହଳସ୍ଲୋଭାକ୍ସ୍ଲୋଭେନିଆନ୍ସାମୋଆନ" +
			"୍ଶୋନାସୋମାଲିଆଆଲବାନିଆନ୍ସର୍ବିଆନ୍ସ୍ବାତୀସେସୋଥୋସୁଦାନୀଜ୍ସ୍ୱେଡିସ୍ସ୍ୱାହିଲ୍ତ" +
			"ାମିଲ୍ତେଲୁଗୁତାଜିକ୍ଥାଇଟ୍ରିଗିନିଆତୁର୍କମେନ୍ସେସ୍ବାନାଟୋଙ୍ଗାତୁର୍କିସ୍ସୋଂଗାତ" +
			"ାତାର୍ତାହିତିଆନ୍ୟୁଘୁର୍ୟୁକ୍ରାନିଆନ୍ଉର୍ଦ୍ଦୁଉଜବେକ୍ଭେଣ୍ଡାଭିଏତନାମିଜ୍ବୋଲାପୁ" +
			"କୱାଲୁନ୍ୱୋଲଫ୍ଖୋସାୟିଡିସ୍ୟୋରୁବାଜୁଆଙ୍ଗଚାଇନୀଜ୍ଜୁଲୁଆଚାଇନୀଜ୍ଆକୋଲିଆଦାଙ୍ଗେମ" +
			"୍ଅଦ୍ୟଘେଆଫ୍ରିହିଲିଆଇନୁଆକାଡିଆନ୍ଆଲେଇଟୁଦକ୍ଷିଣ ଆଲ୍ଟାଇପୁରୁଣା ଇଁରାଜୀଅଁଗୀକା" +
			"ଆରାମାଇକ୍ଆରାଉକାନିଆନ୍ଆରାପାହୋଆରୱକଆଷ୍ଟୁରିଆନ୍ଆୱାଧିବାଲୁଚିବାଲିନୀଜ୍ବାସାବେଜ" +
			"ାବେମ୍ବାଭୋଜପୁରୀବିକୋଲ୍ବିନିବିକ୍ସିକାବ୍ରାଜ୍ବୁରିଆଟ୍ବୁଗୀନୀଜ୍ବ୍ଲିନ୍କାଡୋକାର" +
			"ିବ୍ଆତ୍ସମ୍ସୀବୁଆନୋଚିବ୍ଚାଛଗତାଇଚୁକୀସେମାରୀଚିନୁକ୍ ଜାରଗାଁନ୍ଚୋଟୱାଚିପେୱାନ୍ଚ" +
			"େରୋକୀଚେଚେନାକପ୍ଟିକ୍କ୍ରୀମିନ୍ ତୁର୍କୀସ୍କାଶୁବିଆନ୍ଡାକୋଟାଡାରାଗ୍ୱାଡେଲାୱେର୍" +
			"ସ୍ଲେଭ୍ଡୋଗ୍ରିବ୍ଦିଙ୍କାଡୋଗ୍ରୀନିଚଳା ସର୍ବିଆନ୍ଡୁଆନାମଧ୍ୟ ପର୍ତ୍ତୁଗାଲୀଡୁଆଲା" +
			"ଏଫିକ୍ପ୍ରାଚୀନ୍ ମିଶିରିଏକାଜୁକ୍ଏଲାମାଇଟ୍ମଧ୍ୟ ଇଁରାଜୀଇୱୋଣ୍ଡୋଫାଙ୍ଗଫିଲିପିନୋ" +
			"ଫନ୍ମଧ୍ୟ ଫ୍ରେଞ୍ଚପୁରୁଣା ଫ୍ରେଞ୍ଚଉତ୍ତର ଫ୍ରିସିୟାନ୍ପୂର୍ବ ଫ୍ରିସିୟାନ୍ଫ୍ରିୟ" +
			"ୁଲୀୟାନ୍ଗାଗାୟୋଗବାୟାଗୀଜ୍ଜିବ୍ରାଟୀଜ୍ମିଡିଲ୍ ହାଇ ଜର୍ମାନ୍ପୁରୁଣା ହାଇ ଜର୍ମା" +
			"ନ୍ଗୋଣ୍ଡିଗୋରୋଣ୍ଟାଲୋଗୋଥିକ୍ଗ୍ରେବୋପ୍ରାଚୀନ୍ ୟୁନାନୀସ୍ବିସ୍ ଜର୍ମାନ୍ସ୍ବିଚ୍ " +
			"ଇନ୍ହାଇଡାହାୱାଇନ୍ହିଲିଗୈନନ୍ହିତୀତେହଁଙ୍ଗଉପର ସର୍ବିଆନ୍ହୁପାଇବାନ୍ଇଲୋକୋଇଁଙ୍ଗ" +
			"ୁଶ୍ଲୋଜବାନ୍ଜୁଡେଓ-ପର୍ସିଆନ୍ଜୁଡେଓ-ଆରବୀକ୍କାରା-କଲ୍ପକ୍କବାଇଲ୍କଚିନ୍ଜ୍ଜୁକମ୍ବ" +
			"ାକାୱିକାବାର୍ଡିଆନ୍ତ୍ୟାପ୍କୋରୋଖାସୀଖୋତାନୀଜ୍କିମ୍ବୁଣ୍ଡୁକୋନକାନୀକୋସରୈନ୍କୈପେ" +
			"ଲେକରାଚୟ-ବଲ୍କାରକାରେଲିୟାନ୍କୁରୁଖକୁମୀକ୍କୁତେନାଉଲାଦିନୋଲାହାଣ୍ଡାଲାମ୍ବାଲେଜଗ" +
			"ିୟାନ୍ମଙ୍ଗୋଲୋଜିଲୁବା-ଲୁଲୁଆଲୁଇସେନୋଲୁଣ୍ଡାଲୁଓଲୁସାଉମାଦୁରୀସ୍ମାଗାହୀମୈଥିଳୀମ" +
			"କାସର୍ମାଣ୍ଡିଙ୍ଗୋମାସାଇମୋକ୍ଷମନ୍ଦାରମେଣ୍ଡେମଧ୍ୟ ଇରିଶ୍ମିକମୌକ୍ମିନାଙ୍ଗାବାଉମ" +
			"ାଞ୍ଚୁମଣିପୁରୀମୋହୌକମୋସିବିବିଧ ଭାଷାମାନକ୍ରୀକ୍ମିରାଣ୍ଡିଜ୍ମାରୱାରୀଏର୍ଜୟାନୀପ" +
			"ୋଲିଟାନ୍ଲୋ ଜର୍ମାନ୍ନେୱାରୀନୀୟାସ୍ନିୟୁଆନ୍ନୋଗାଇପୁରୁଣା ନର୍ସଏନ୍କୋଉତ୍ତରୀ ସୋ" +
			"ଥୋପାରମ୍ପରିକ ନେୱାରୀନ୍ୟାମୱେଜୀନ୍ୟାନକୋଲ୍ନ୍ୟାରୋଞ୍ଜିମାୱୌସେଜ୍ଓଟ୍ଟୋମନ୍ ତୁର" +
			"୍କିସ୍ପାଙ୍ଗାସିନିଆନ୍ପାହ୍ଲାଭିପାମ୍ପାଙ୍ଗାପାପିୟାମିଣ୍ଟୋପାଲାଉଆନ୍ପୁରୁଣା ପର୍" +
			"ସିଆନ୍ଫୋନେସିଆନ୍ପୋହପିଏନ୍ପୁରୁଣା ପ୍ରେଭେନେସିଆଲ୍ରାଜସ୍ଥାନୀରାପାନୁଇରାରୋତୋଙ୍" +
			"ଗନ୍ରୋମାନିଆରୋମାନିଆନ୍ସଣ୍ଡାୱେୟାକୁଟ୍ସାମୌରିଟନ୍ ଆରମାଇକ୍ସାସାକ୍ସାନ୍ତାଳିସିଶ" +
			"ିଲିଆନ୍ସ୍କଟସ୍ସେଲ୍କପ୍ପୁରୁଣା ଇରିଶ୍ଶାନ୍ସିଦାମୋଦକ୍ଷିଣ ସାମିଲୁଲେ ସାମିଇନାରୀ" +
			" ସାମିସ୍କୋଲ୍ଟ ସାମୀସୋନିଙ୍କେସୋଗଡିଏନ୍ଶାରାନା ଟୋଙ୍ଗୋଶେରେର୍ସୁକୁମାଶୁଶୁସୁମେରି" +
			"ଆନ୍କ୍ଲାସିକାଲ୍ ସିରିକ୍ସିରିକ୍ତିମନେତେରେନୋତେତୁମ୍ଟାଇଗ୍ରେତୀଭ୍ଟୋକେଲାଉକ୍ଲିଙ" +
			"୍ଗନ୍ତ୍ଲିଙ୍ଗିଟ୍ତାମାଶେକ୍ନ୍ୟାସା ଟୋଙ୍ଗୋଟୋକ୍ ପିସିନ୍ତିସିମିସିଆନ୍ଟୁମ୍ବୁକାତ" +
			"ୁଭାଲୁତୁଭିନିଆନ୍ଉଦମୂର୍ତ୍ତୟୁଗୋରଟିକ୍ଉମ୍ବୁଣ୍ଡୁମୂଳଭାଇଭୋଟିକ୍ୱାଲମୋୱାରୈୱାସୋ" +
			"କାଲ୍ମୀକ୍ୟାଓୟାପୀସ୍ଜାପୋଟେକ୍ବ୍ଲିସିମ୍ବଲସ୍ଜେନାଗାଜୁନୀକୌଣସି ଲିଙ୍ଗୁଇଷ୍ଟ ସା" +
			"ମଗ୍ରୀ ନାହିଁଜାଜାଅଷ୍ଟ୍ରିଆନ୍ ଜର୍ମାନସ୍ବିସ୍ ହାଇ ଜର୍ମାନ୍ଅଷ୍ଟ୍ରେଲିଆନ୍ ଇଁର" +
			"ାଜୀକାନାଡିଆନ୍ ଇଁରାଜୀବ୍ରିଟିଶ୍ ଇଁରାଜୀୟୁ.ଏସ୍. ଇଁରାଜୀଲାଟିନ୍ ଆମେରିକାନ୍ ସ" +
			"୍ପାନିଶ୍ଲେବେରିଆନ୍ ସ୍ପାନିଶ୍କାନାଡିଆନ୍ ଫ୍ରେଞ୍ଚସ୍ବିସ୍ ଫ୍ରେଞ୍ଚ୍ଫ୍ଲେମିଶ୍ବ" +
			"୍ରାଜିଲିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍ଲେବେରିଆନ୍ ପର୍ତ୍ତୁଗୀଜ୍ମୋଲଡୋଭିଆନ୍ସର୍ବୋ-କ୍ରୋଆଟି" +
			"ଆନ୍ସରଳିକରଣ ଚାଇନୀଜ୍ପାରମ୍ପରିକ ଚାଇନୀଜ୍",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000f, 0x002d, 0x0042, 0x0060, 0x006c, 0x0081, 0x0096,
			0x00a8, 0x00b7, 0x00cc, 0x00de, 0x00ff, 0x0111, 0x0132, 0x0150,
			0x0165, 0x017d, 0x0192, 0x01aa, 0x01bf, 0x01d4, 0x01ec, 0x01fb,
			0x020d, 0x022b, 0x0237, 0x0243, 0x026e, 0x0280, 0x028f, 0x02a7,
			0x02bc, 0x02ce, 0x02e0, 0x02e9, 0x02fb, 0x030d, 0x032e, 0x0346,
			0x0364, 0x037c, 0x0394, 0x03a3, 0x03bb, 0x03c7, 0x03dc, 0x03f1,
			0x041f, 0x042e, 0x0459, 0x0471, 0x0486, 0x049e, 0x04b0, 0x04bc,
			0x04d4, 0x04e6, 0x04ff, 0x051d, 0x0535, 0x0553, 0x0571, 0x0583,
			// Entry 40 - 7F
			0x05aa, 0x05ce, 0x05f8, 0x0607, 0x0623, 0x063e, 0x0647, 0x0668,
			0x0680, 0x0698, 0x06b0, 0x06c8, 0x06e0, 0x06ef, 0x0701, 0x071f,
			0x0731, 0x0758, 0x076a, 0x0779, 0x078e, 0x079d, 0x07b5, 0x07d3,
			0x07df, 0x07f7, 0x080c, 0x081e, 0x0845, 0x0854, 0x0878, 0x0890,
			0x0899, 0x08b7, 0x08e2, 0x08fa, 0x0912, 0x0930, 0x093f, 0x095d,
			0x0975, 0x0993, 0x09a2, 0x09ae, 0x09c3, 0x09d8, 0x09e7, 0x0a0c,
			0x0a1e, 0x0a30, 0x0a39, 0x0a70, 0x0a9e, 0x0ac6, 0x0ad8, 0x0aed,
			0x0b02, 0x0b11, 0x0b20, 0x0b2f, 0x0b44, 0x0b59, 0x0b65, 0x0b77,
			// Entry 80 - BF
			0x0b89, 0x0bb0, 0x0bc5, 0x0bed, 0x0bff, 0x0c1a, 0x0c2c, 0x0c53,
			0x0c68, 0x0c86, 0x0c98, 0x0cb4, 0x0cc6, 0x0cd5, 0x0ced, 0x0d0e,
			0x0d23, 0x0d2f, 0x0d44, 0x0d5f, 0x0d77, 0x0d89, 0x0d9b, 0x0db3,
			0x0dcb, 0x0de3, 0x0df5, 0x0e07, 0x0e19, 0x0e22, 0x0e3d, 0x0e58,
			0x0e70, 0x0e82, 0x0e9a, 0x0ea9, 0x0ebb, 0x0ed6, 0x0ee8, 0x0f09,
			0x0f1e, 0x0f30, 0x0f42, 0x0f60, 0x0f75, 0x0f87, 0x0f96, 0x0fa2,
			0x0fb4, 0x0fc6, 0x0fd8, 0x0fed, 0x0ff9, 0x1011, 0x1020, 0x103b,
			0x104d, 0x104d, 0x1068, 0x1068, 0x1074, 0x108c, 0x108c, 0x109e,
			// Entry C0 - FF
			0x109e, 0x10c3, 0x10e8, 0x10fa, 0x1112, 0x1133, 0x1133, 0x1148,
			0x1148, 0x1148, 0x1154, 0x1154, 0x1154, 0x1154, 0x1154, 0x1172,
			0x1172, 0x1181, 0x1193, 0x11ab, 0x11ab, 0x11b7, 0x11b7, 0x11b7,
			0x11b7, 0x11c3, 0x11d5, 0x11d5, 0x11d5, 0x11d5, 0x11d5, 0x11d5,
			0x11ea, 0x11fc, 0x1208, 0x1208, 0x1208, 0x1220, 0x1220, 0x1220,
			0x1232, 0x1232, 0x1232, 0x1232, 0x1247, 0x125f, 0x125f, 0x1271,
			0x1271, 0x127d, 0x128f, 0x128f, 0x12a1, 0x12b6, 0x12b6, 0x12c8,
			0x12d7, 0x12e9, 0x12f5, 0x1320, 0x132f, 0x1347, 0x1359, 0x136b,
			// Entry 100 - 13F
			0x136b, 0x1380, 0x1380, 0x13b1, 0x13b1, 0x13cc, 0x13de, 0x13f6,
			0x13f6, 0x140e, 0x1420, 0x1438, 0x144a, 0x144a, 0x145c, 0x1484,
			0x1484, 0x1493, 0x14c1, 0x14c1, 0x14d0, 0x14d0, 0x14d0, 0x14df,
			0x14df, 0x150a, 0x151f, 0x1537, 0x1556, 0x1556, 0x156b, 0x156b,
			0x157a, 0x1592, 0x1592, 0x159b, 0x159b, 0x15bd, 0x15e5, 0x15e5,
			0x1613, 0x1641, 0x1665, 0x166b, 0x166b, 0x166b, 0x1677, 0x1686,
			0x1686, 0x1692, 0x16b0, 0x16b0, 0x16e2, 0x1714, 0x1714, 0x1726,
			0x1744, 0x1756, 0x1768, 0x1793, 0x17bb, 0x17bb, 0x17bb, 0x17bb,
			// Entry 140 - 17F
			0x17d7, 0x17e6, 0x17e6, 0x17fb, 0x17fb, 0x1816, 0x1828, 0x1837,
			0x1859, 0x1859, 0x1865, 0x1874, 0x1874, 0x1883, 0x189b, 0x189b,
			0x189b, 0x18b0, 0x18b0, 0x18b0, 0x18d8, 0x18fa, 0x18fa, 0x1919,
			0x192b, 0x193a, 0x1946, 0x1955, 0x1961, 0x1982, 0x1982, 0x1994,
			0x1994, 0x1994, 0x1994, 0x19a0, 0x19a0, 0x19ac, 0x19c4, 0x19c4,
			0x19c4, 0x19c4, 0x19c4, 0x19c4, 0x19e2, 0x19e2, 0x19f7, 0x1a0c,
			0x1a1e, 0x1a40, 0x1a40, 0x1a40, 0x1a5e, 0x1a6d, 0x1a6d, 0x1a6d,
			0x1a6d, 0x1a7f, 0x1a94, 0x1aa6, 0x1aa6, 0x1abe, 0x1ad0, 0x1aeb,
			// Entry 180 - 1BF
			0x1aeb, 0x1aeb, 0x1aeb, 0x1aeb, 0x1aeb, 0x1afa, 0x1b06, 0x1b06,
			0x1b06, 0x1b22, 0x1b37, 0x1b49, 0x1b52, 0x1b61, 0x1b61, 0x1b61,
			0x1b61, 0x1b79, 0x1b79, 0x1b8b, 0x1b9d, 0x1baf, 0x1bcd, 0x1bdc,
			0x1bdc, 0x1beb, 0x1bfd, 0x1c0f, 0x1c0f, 0x1c0f, 0x1c2b, 0x1c2b,
			0x1c2b, 0x1c40, 0x1c61, 0x1c73, 0x1c88, 0x1c97, 0x1ca3, 0x1ca3,
			0x1ca3, 0x1cc8, 0x1cda, 0x1cf8, 0x1d0d, 0x1d0d, 0x1d0d, 0x1d1f,
			0x1d1f, 0x1d1f, 0x1d3d, 0x1d3d, 0x1d59, 0x1d6b, 0x1d7d, 0x1d92,
			0x1d92, 0x1d92, 0x1d92, 0x1da1, 0x1dc0, 0x1dc0, 0x1dcf, 0x1dee,
			// Entry 1C0 - 1FF
			0x1dee, 0x1e1c, 0x1e37, 0x1e52, 0x1e64, 0x1e76, 0x1e88, 0x1eb9,
			0x1ee0, 0x1ef8, 0x1f16, 0x1f3a, 0x1f52, 0x1f52, 0x1f52, 0x1f52,
			0x1f52, 0x1f7d, 0x1f7d, 0x1f98, 0x1f98, 0x1f98, 0x1fb0, 0x1fb0,
			0x1fea, 0x1fea, 0x1fea, 0x2005, 0x201a, 0x203b, 0x203b, 0x203b,
			0x203b, 0x204d, 0x204d, 0x204d, 0x204d, 0x206b, 0x206b, 0x2080,
			0x2092, 0x20c3, 0x20c3, 0x20d5, 0x20ed, 0x20ed, 0x20ed, 0x20ed,
			0x2108, 0x211a, 0x211a, 0x211a, 0x211a, 0x211a, 0x211a, 0x212f,
			0x212f, 0x2151, 0x2151, 0x2151, 0x215d, 0x215d, 0x216f, 0x216f,
			// Entry 200 - 23F
			0x216f, 0x218e, 0x21a7, 0x21c3, 0x21e5, 0x21fd, 0x2215, 0x223a,
			0x224c, 0x224c, 0x224c, 0x225e, 0x226a, 0x2285, 0x2285, 0x22b6,
			0x22c8, 0x22c8, 0x22c8, 0x22d7, 0x22d7, 0x22e9, 0x22fb, 0x2310,
			0x231c, 0x2331, 0x2331, 0x234c, 0x236a, 0x236a, 0x2382, 0x23a7,
			0x23c6, 0x23c6, 0x23c6, 0x23c6, 0x23e7, 0x23e7, 0x23ff, 0x2411,
			0x2411, 0x242c, 0x242c, 0x2447, 0x2462, 0x247d, 0x2486, 0x248f,
			0x248f, 0x248f, 0x248f, 0x248f, 0x24a1, 0x24a1, 0x24a1, 0x24a1,
			0x24b0, 0x24bc, 0x24c8, 0x24c8, 0x24c8, 0x24e0, 0x24e0, 0x24e0,
			// Entry 240 - 27F
			0x24e9, 0x24fb, 0x24fb, 0x24fb, 0x24fb, 0x24fb, 0x2513, 0x2537,
			0x2537, 0x2549, 0x2549, 0x2555, 0x25a9, 0x25b5, 0x25b5, 0x25b5,
			0x25e6, 0x2618, 0x264f, 0x267d, 0x26a8, 0x26cc, 0x2713, 0x2747,
			0x2747, 0x2747, 0x2778, 0x27a3, 0x27a3, 0x27bb, 0x27fe, 0x283b,
			0x2859, 0x2887, 0x2887, 0x28b2, 0x28e3,
		},
	},
	{ // os
		"абхазагавестӕафрикаансараббагавайрагтӕтӕйрагбашкирагболгайрагбосниагката" +
			"лайнагцӕцӕйнагчехагчувашагданиагнемыцагбердзейнаганглисагесперантои" +
			"спайнагестойнагбаскагперсайнагфиннагфиджифарерагфранцагирландиагуир" +
			"агхорватагвенгериагсомихагиталиагяпойнаггуырдзиагкурдаглатинагмӕчъи" +
			"дониронпортугалиагуырыссагкитайагадыгейаграгон англисагбурятагкопта" +
			"грагон египтагфилиппинаграгон францаграгон бердзейнагмӕхъӕлонкӕсгон" +
			"бӕлхъӕронхъуымыхъхъаглекъагцигайнагнӕзонгӕ ӕвзагавстралиаг немыцагш" +
			"вйецариаг немыцагавстралиаг англисагканадӕйаг англисагбритайнаг анг" +
			"лисагамерикаг англисаглатинаг америкаг англисагевропӕйаг англисагка" +
			"надӕйаг францагшвейцариаг францагбразилиаг португалиагевропӕйаг пол" +
			"тугалиагӕнцонгонд китайагтрадицион китайаг",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x000e, 0x001a, 0x002c, 0x002c, 0x002c, 0x002c,
			0x003a, 0x003a, 0x0048, 0x0048, 0x0058, 0x0068, 0x0068, 0x007a,
			0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x0088, 0x009c, 0x00ac,
			0x00ac, 0x00ac, 0x00ac, 0x00b6, 0x00b6, 0x00c4, 0x00c4, 0x00d0,
			0x00de, 0x00de, 0x00de, 0x00de, 0x00f2, 0x0102, 0x0114, 0x0124,
			0x0134, 0x0140, 0x0152, 0x0152, 0x015e, 0x0168, 0x0176, 0x0184,
			0x0184, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196,
			0x01a0, 0x01a0, 0x01a0, 0x01b0, 0x01b0, 0x01c2, 0x01d0, 0x01d0,
			// Entry 40 - 7F
			0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0, 0x01d0,
			0x01de, 0x01de, 0x01ec, 0x01ec, 0x01fe, 0x01fe, 0x01fe, 0x01fe,
			0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x01fe, 0x020a,
			0x020a, 0x020a, 0x020a, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218,
			0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0218, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228, 0x0228,
			0x0228, 0x0228, 0x0228, 0x0228, 0x0230, 0x0230, 0x0230, 0x0230,
			// Entry 80 - BF
			0x0230, 0x0246, 0x0246, 0x0246, 0x0246, 0x0246, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256, 0x0256,
			0x0256, 0x0256, 0x0256, 0x0264, 0x0264, 0x0264, 0x0264, 0x0264,
			0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274, 0x0274,
			// Entry C0 - FF
			0x0274, 0x0274, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f, 0x028f,
			0x028f, 0x028f, 0x028f, 0x028f, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d, 0x029d,
			// Entry 100 - 13F
			0x029d, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9,
			0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9,
			0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9, 0x02a9,
			0x02a9, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2, 0x02c2,
			0x02c2, 0x02d6, 0x02d6, 0x02d6, 0x02d6, 0x02d6, 0x02ef, 0x02ef,
			0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef,
			0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef, 0x02ef,
			0x02ef, 0x02ef, 0x02ef, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e,
			// Entry 140 - 17F
			0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e,
			0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x030e, 0x031e, 0x031e,
			0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x031e,
			0x031e, 0x031e, 0x031e, 0x031e, 0x031e, 0x032a, 0x032a, 0x032a,
			0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a,
			0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a, 0x032a,
			0x032a, 0x033c, 0x033c, 0x033c, 0x033c, 0x033c, 0x033c, 0x033c,
			0x033c, 0x0354, 0x0354, 0x0354, 0x0354, 0x0354, 0x0354, 0x0360,
			// Entry 180 - 1BF
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			// Entry 1C0 - 1FF
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360, 0x0360,
			0x0360, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			// Entry 200 - 23F
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370,
			0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0370, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			// Entry 240 - 27F
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389, 0x0389,
			0x03ac, 0x03cf, 0x03f4, 0x0417, 0x043a, 0x045b, 0x048b, 0x04ae,
			0x04ae, 0x04ae, 0x04cf, 0x04f2, 0x04f2, 0x04f2, 0x051b, 0x0544,
			0x0544, 0x0544, 0x0544, 0x0565, 0x0586,
		},
	},
	{ // pa
		paLangStr,
		paLangIdx,
	},
	{ // pa-Arab
		"پنجابی",
		[]uint16{ // 126 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c,
		},
	},
	{ // pl
		plLangStr,
		plLangIdx,
	},
	{ // prg
		"prūsiskan",
		[]uint16{ // 472 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 180 - 1BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 1C0 - 1FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
		},
	},
	{ // ps
		"امهاريعربيآساميبېلاروسيبلغاريبوسنيالمانيیونانيانګریزيحبشيباسکيفارسيفینلن" +
			"ډيفرانسويعبريهنديارمنيایټالويجاپانیکرديلاتینيملغاسيمقدونيمغوليملایا" +
			"نېپاليهالېنډيپولنډيپښتوپورتګاليروسيسنسکریټالبانيسویډنیتاجکيترکمنيتا" +
			"تارازبکيچینيبلوڅي",
		[]uint16{ // 211 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x000c,
			0x0014, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x002e, 0x003a,
			0x003a, 0x003a, 0x003a, 0x003a, 0x003a, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0050, 0x0050, 0x0050, 0x0050, 0x005c, 0x006a, 0x006a, 0x006a,
			0x0072, 0x007c, 0x0086, 0x0086, 0x0094, 0x0094, 0x0094, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2,
			0x00aa, 0x00b2, 0x00b2, 0x00b2, 0x00b2, 0x00b2, 0x00bc, 0x00bc,
			// Entry 40 - 7F
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00ca, 0x00ca, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6,
			0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00d6, 0x00de,
			0x00de, 0x00de, 0x00de, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00f6, 0x00f6, 0x00f6, 0x0102,
			0x0102, 0x010c, 0x010c, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116,
			0x0122, 0x0122, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x013c,
			// Entry 80 - BF
			0x0144, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x015c, 0x015c,
			0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a,
			0x016a, 0x016a, 0x016a, 0x0176, 0x0176, 0x0176, 0x0176, 0x0176,
			0x0182, 0x0182, 0x0182, 0x0182, 0x018c, 0x018c, 0x018c, 0x0198,
			0x0198, 0x0198, 0x0198, 0x0198, 0x01a2, 0x01a2, 0x01a2, 0x01a2,
			0x01a2, 0x01ac, 0x01ac, 0x01ac, 0x01ac, 0x01ac, 0x01ac, 0x01ac,
			0x01ac, 0x01ac, 0x01ac, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			// Entry C0 - FF
			0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01b4, 0x01b4, 0x01be,
		},
	},
	{ // pt
		ptLangStr,
		ptLangIdx,
	},
	{ // pt-PT
		ptPTLangStr,
		ptPTLangIdx,
	},
	{ // qu
		"Afrikaans SimiAmarico SimiArabe SimiAsames SimiAzerbaiyano SimiBaskir Si" +
			"miBielorruso SimiBulgaro SimiBangla SimiTibetano SimiBreton SimiBosn" +
			"io SimiCatalan SimiCorso SimiCheco SimiGales SimiDanes SimiAleman Si" +
			"miDivehi SimiGriego SimiIngles SimiEspañol SimiEstonio SimiEuskera S" +
			"imiPersa SimiFulah SimiFines SimiFeroes SimiFrances SimiFrison SimiI" +
			"rlandes SimiGaelico Escoces SimiGallego SimiGujarati SimiHausa SimiH" +
			"ebreo SimiHindi SimiCroata SimiHaitiano Criollo SimiHungaro SimiArme" +
			"nio SimiIndonesio SimiIgbo SimiYi SimiIslandes SimiItaliano SimiInuk" +
			"titut SimiJapones SimiGeorgiano SimiKazajo SimiGroenlandes SimiKhmer" +
			" SimiKannada SimiCoreano SimiKirghiz SimiLuxemburgues SimiLao SimiLi" +
			"tuano SimiLeton SimiMaori SimiMacedonio SimiMalayalam SimiMongol Sim" +
			"iMarathi SimiMalayo SimiMaltes SimiNepali SimiNeerlandes SimiNoruego" +
			" SimiOccitano SimiOdia SimiPunyabi SimiPolaco SimiPashto SimiPortugu" +
			"es SimiRunasimiRomanche SimiRumano SimiRuso SimiKinyarwanda SimiSans" +
			"crito SimiSindhi SimiChincha Sami SimiCingales SimiEslovaco SimiEslo" +
			"veno SimiAlbanes SimiSerbio SimiSueco SimiSuajili SimiTamil SimiTelu" +
			"gu SimiTayiko SimiTailandes SimiTigriña SimiTurcomano SimiSetsuana S" +
			"imiTurco SimiTartaro SimiUigur SimiUcraniano SimiUrdu SimiUzbeko Sim" +
			"iVietnamita SimiWolof SimiIsixhosa SimiYoruba SimiChino SimiIsizulu " +
			"SimiMapuche SimiCheroqui SimiChawpi Kurdo SimiBajo Sorbio SimiFilipi" +
			"no SimiAlsaciano SimiHmong Daw SimiAlto Sorbio SimiKonkani SimiMohaw" +
			"k SimiSesotho Sa Leboa SimiPapiamento SimiKʼicheʼ SimiSakha SimiQull" +
			"a Sami SimiSami Lule SimiSami Inari SimiSami Skolt SimiSiriaco Simi",
		[]uint16{ // 529 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x000e, 0x001a, 0x001a,
			0x0024, 0x002f, 0x002f, 0x002f, 0x003f, 0x004a, 0x0059, 0x0065,
			0x0065, 0x0065, 0x0070, 0x007d, 0x0088, 0x0093, 0x009f, 0x009f,
			0x009f, 0x00a9, 0x00a9, 0x00b3, 0x00b3, 0x00b3, 0x00bd, 0x00c7,
			0x00d2, 0x00dd, 0x00dd, 0x00dd, 0x00e8, 0x00f3, 0x00f3, 0x0100,
			0x010c, 0x0118, 0x0122, 0x012c, 0x0136, 0x0136, 0x0141, 0x014d,
			0x0158, 0x0165, 0x0179, 0x0185, 0x0185, 0x0192, 0x0192, 0x019c,
			0x01a7, 0x01b1, 0x01b1, 0x01bc, 0x01d1, 0x01dd, 0x01e9, 0x01e9,
			// Entry 40 - 7F
			0x01e9, 0x01f7, 0x01f7, 0x0200, 0x0207, 0x0207, 0x0207, 0x0214,
			0x0221, 0x022f, 0x023b, 0x023b, 0x0249, 0x0249, 0x0249, 0x0249,
			0x0254, 0x0264, 0x026e, 0x027a, 0x0286, 0x0286, 0x0286, 0x0286,
			0x0286, 0x0286, 0x0292, 0x0292, 0x02a3, 0x02a3, 0x02a3, 0x02a3,
			0x02ab, 0x02b7, 0x02b7, 0x02c1, 0x02c1, 0x02c1, 0x02cb, 0x02d9,
			0x02e7, 0x02f2, 0x02fe, 0x0309, 0x0314, 0x0314, 0x0314, 0x0314,
			0x031f, 0x031f, 0x032e, 0x032e, 0x033a, 0x033a, 0x033a, 0x033a,
			0x0347, 0x0347, 0x0347, 0x0350, 0x0350, 0x035c, 0x035c, 0x0367,
			// Entry 80 - BF
			0x0372, 0x0380, 0x0388, 0x0395, 0x0395, 0x03a0, 0x03a9, 0x03b9,
			0x03c7, 0x03c7, 0x03d2, 0x03e3, 0x03e3, 0x03f0, 0x03fd, 0x040a,
			0x040a, 0x040a, 0x040a, 0x0416, 0x0421, 0x0421, 0x0421, 0x0421,
			0x042b, 0x0437, 0x0441, 0x044c, 0x0457, 0x0465, 0x0472, 0x0480,
			0x048d, 0x048d, 0x0497, 0x0497, 0x04a3, 0x04a3, 0x04ad, 0x04bb,
			0x04c4, 0x04cf, 0x04cf, 0x04de, 0x04de, 0x04de, 0x04e8, 0x04f5,
			0x04f5, 0x0500, 0x0500, 0x050a, 0x0516, 0x0516, 0x0516, 0x0516,
			0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0516,
			// Entry C0 - FF
			0x0516, 0x0516, 0x0516, 0x0516, 0x0516, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522,
			0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x0522, 0x052f, 0x052f,
			// Entry 100 - 13F
			0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540,
			0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0540, 0x0550,
			0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550,
			0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550, 0x0550,
			0x0550, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d, 0x055d,
			0x055d, 0x055d, 0x055d, 0x055d, 0x056b, 0x056b, 0x056b, 0x056b,
			// Entry 140 - 17F
			0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x056b, 0x0579,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589,
			0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0589, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			// Entry 180 - 1BF
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x0595,
			0x0595, 0x0595, 0x0595, 0x0595, 0x0595, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0,
			0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05a0, 0x05b5,
			// Entry 1C0 - 1FF
			0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5, 0x05b5,
			0x05b5, 0x05b5, 0x05b5, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4,
			0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4, 0x05c4,
			0x05c4, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2,
			0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2, 0x05d2,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc, 0x05dc,
			// Entry 200 - 23F
			0x05dc, 0x05eb, 0x05f9, 0x0608, 0x0617, 0x0617, 0x0617, 0x0617,
			0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617, 0x0617,
			0x0623,
		},
	},
	{ // rm
		"afarabchasianavesticafrikaansakanamaricaragonaisarabassamiavaricaymaraas" +
			"erbeidschanicbaschkirbielorussbulgarbislamabambarabengaltibetanbreto" +
			"nbosniaccatalantschetschenchamorrocorscreetschecslav da baselgiatsch" +
			"uvaschkimricdanaistudestgmaledivicdzongkhaewegrecenglaisesperantospa" +
			"gnolestonbascpersianfulahfinlandaisfidschianferraisfranzosfrisirland" +
			"aisgaelic scotgalicianguaranigujaratimanxhaussaebraichindihiri motuc" +
			"roathaitianungaraisarmenhererointerlinguaindonaisinterlingueigbosich" +
			"uan yiinupiakidoislandaistalianinuktitutgiapunaisjavanaisgeorgiankon" +
			"gokikuyukuanyamacasacgrönlandaiscambodschankannadacoreankanurikashmi" +
			"ricurdkomicornickirghislatinluxemburgaisgandalimburgaislingalalaotli" +
			"tuanluba-katangalettonmalagassimarschallaismaorimacedonmalayalammong" +
			"olicmarathimalaicmaltaisbirmannaurundebele dal nordnepalaisndongaoll" +
			"andaisnorvegiais nynorsknorvegais bokmålndebele dal sidnavajonyanjao" +
			"ccitanojibwaoromooriyaosseticpunjabipalipolacpaschtoportugaisquechua" +
			"rumantschrundirumenrusskinyarwandasanscritsardsindhisami dal nordsan" +
			"gosingalaisslovacslovensamoanshonasomalialbanaisserbswazisotho dal s" +
			"idsundanaissvedaissuahilitamiltelugutadjiktailandaistigrinyaturkment" +
			"swanatongatirctsongatatartahitianuiguricucranaisurduusbecvendavietna" +
			"maisvolapukvallonwolofxhosajiddicyorubazhuangchinaiszuluacehacoliand" +
			"angmeadygaiafrihiliainuaccadicaleuticaltaic dal sidenglais veglangik" +
			"aarameicaraucanicarapahoarawakasturianawadhibelutschibalinaisbasaabe" +
			"dschabembabhojpuribikolbinisiksikabrajburiatbugiblincaddocaribicatsa" +
			"mcebuanochibchatschagataicchuukaismaripatuà chinookchoctawchipewyanc" +
			"herokeecheyennecoptictirc crimeankaschubicdakotadargwadelawareslavey" +
			"dogribdinkadogribass sorbdualaollandais mesaundiulaefikegipzian vegl" +
			"ekajukelamiticenglais mesaunewondofangfilippinofonfranzos mesaunfran" +
			"zos veglfris dal nordfris da l’ostfriulangagayogbayageezgilbertaistu" +
			"destg mesaunvegl tudestg da scrittiragondigorontalogoticgrebogrec ve" +
			"gltudestg svizzergwichʼinhaidahawaianhiligaynonettitichmongaut sorbh" +
			"upaibanilocanoingushlojbangiudaic-persiangiudaic-arabkarakalpakkabyl" +
			"ekachinjjukambakawikabardictyapkorokhasikhotanaiskimbundukonkanikosr" +
			"aeankpellekarachay-balkarcareliankurukhkumukkutenailadinolahndalamba" +
			"lezghianlomongoloziluba-lulualuisenolundaluolushaimaduraismagahimait" +
			"hilimakassarmandingomasaimokshamandarmendeirlandais mesaunmicmacmina" +
			"ngkabaumanchumanipurimohawkmossiplurilingcreekmirandaismarwarierzyan" +
			"eapolitanbass tudestgnewariniasniuenogainordic vegln’kosotho dal nor" +
			"dnewari classicnyamwezinyankolenyoronzimaosagetirc ottomanpangasinan" +
			"pahlavipampangapapiamentopalaupersian veglfenizianponapeanprovenzal " +
			"veglrajasthanirapanuirarotongaromaniaromunicsandawejakutarameic sama" +
			"ritansasaksantalisicilianscotselkupirlandais veglshansidamosami dal " +
			"sidsami lulesami inarisami skoltsoninkesogdiansranan tongoserersukum" +
			"asususumericsiric classicsirictemneterenotetumtigretivtokelauklingon" +
			"ictlingittamasheqlingua tsongatok pisintsimshiantumbukatuvalutuvinia" +
			"nudmurtugariticmbundulinguas betg determinadasvaivoticwalamowaraywas" +
			"hokalmukyaoyapaiszapotecsimbols da Blisszenagazuninagins cuntegns li" +
			"nguisticszazatudestg austriacenglais australianenglais canadaisengla" +
			"is britannicenglais americanspagnol latinamericanspagnol ibericfranz" +
			"os canadaisfranzos svizzerflamportugais brasilianportugais iberianmo" +
			"ldavserbo-croatchinais simplifitgàchinais tradiziunal",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x000d, 0x0014, 0x001d, 0x0021, 0x0027, 0x0030,
			0x0034, 0x003a, 0x0040, 0x0046, 0x0055, 0x005d, 0x0066, 0x006c,
			0x0073, 0x007a, 0x0080, 0x0087, 0x008d, 0x0094, 0x009b, 0x00a6,
			0x00ae, 0x00b2, 0x00b6, 0x00bc, 0x00cc, 0x00d6, 0x00dc, 0x00e2,
			0x00e9, 0x00f2, 0x00fa, 0x00fd, 0x0101, 0x0108, 0x0111, 0x0118,
			0x011d, 0x0121, 0x0128, 0x012d, 0x0137, 0x0140, 0x0147, 0x014e,
			0x0152, 0x015b, 0x0166, 0x016e, 0x0175, 0x017d, 0x0181, 0x0187,
			0x018d, 0x0192, 0x019b, 0x01a0, 0x01a7, 0x01af, 0x01b4, 0x01ba,
			// Entry 40 - 7F
			0x01c5, 0x01cd, 0x01d8, 0x01dc, 0x01e6, 0x01ed, 0x01f0, 0x01f9,
			0x01ff, 0x0208, 0x0211, 0x0219, 0x0221, 0x0226, 0x022c, 0x0234,
			0x0239, 0x0245, 0x0250, 0x0257, 0x025d, 0x0263, 0x026b, 0x026f,
			0x0273, 0x0279, 0x0280, 0x0285, 0x0291, 0x0296, 0x02a0, 0x02a7,
			0x02ab, 0x02b1, 0x02bd, 0x02c3, 0x02cc, 0x02d8, 0x02dd, 0x02e4,
			0x02ed, 0x02f5, 0x02fc, 0x0302, 0x0309, 0x030f, 0x0314, 0x0324,
			0x032c, 0x0332, 0x033b, 0x034d, 0x035e, 0x036d, 0x0373, 0x0379,
			0x0380, 0x0386, 0x038b, 0x0390, 0x0397, 0x039e, 0x03a2, 0x03a7,
			// Entry 80 - BF
			0x03ae, 0x03b7, 0x03be, 0x03c7, 0x03cc, 0x03d1, 0x03d5, 0x03e0,
			0x03e8, 0x03ec, 0x03f2, 0x03ff, 0x0404, 0x040d, 0x0413, 0x0419,
			0x041f, 0x0424, 0x042a, 0x0432, 0x0436, 0x043b, 0x0448, 0x0451,
			0x0458, 0x045f, 0x0464, 0x046a, 0x0470, 0x047a, 0x0482, 0x0489,
			0x048f, 0x0494, 0x0498, 0x049e, 0x04a3, 0x04ab, 0x04b2, 0x04ba,
			0x04be, 0x04c3, 0x04c8, 0x04d2, 0x04d9, 0x04df, 0x04e4, 0x04e9,
			0x04ef, 0x04f5, 0x04fb, 0x0502, 0x0506, 0x050a, 0x050f, 0x0517,
			0x051d, 0x051d, 0x0525, 0x0525, 0x0529, 0x0530, 0x0530, 0x0537,
			// Entry C0 - FF
			0x0537, 0x0545, 0x0551, 0x0557, 0x055e, 0x0567, 0x0567, 0x056e,
			0x056e, 0x056e, 0x0574, 0x0574, 0x0574, 0x0574, 0x0574, 0x057c,
			0x057c, 0x0582, 0x058b, 0x0593, 0x0593, 0x0598, 0x0598, 0x0598,
			0x0598, 0x059f, 0x05a4, 0x05a4, 0x05a4, 0x05a4, 0x05a4, 0x05a4,
			0x05ac, 0x05b1, 0x05b5, 0x05b5, 0x05b5, 0x05bc, 0x05bc, 0x05bc,
			0x05c0, 0x05c0, 0x05c0, 0x05c0, 0x05c6, 0x05ca, 0x05ca, 0x05ce,
			0x05ce, 0x05d3, 0x05da, 0x05da, 0x05df, 0x05e6, 0x05e6, 0x05ed,
			0x05f8, 0x0600, 0x0604, 0x0612, 0x0619, 0x0622, 0x062a, 0x0632,
			// Entry 100 - 13F
			0x0632, 0x0638, 0x0638, 0x0644, 0x0644, 0x064d, 0x0653, 0x0659,
			0x0659, 0x0661, 0x0667, 0x066d, 0x0672, 0x0672, 0x0677, 0x0680,
			0x0680, 0x0685, 0x0695, 0x0695, 0x069a, 0x069a, 0x069a, 0x069e,
			0x069e, 0x06ab, 0x06b1, 0x06b9, 0x06c7, 0x06c7, 0x06cd, 0x06cd,
			0x06d1, 0x06da, 0x06da, 0x06dd, 0x06dd, 0x06eb, 0x06f7, 0x06f7,
			0x0704, 0x0713, 0x071a, 0x071c, 0x071c, 0x071c, 0x0720, 0x0725,
			0x0725, 0x0729, 0x0733, 0x0733, 0x0741, 0x075a, 0x075a, 0x075f,
			0x0768, 0x076d, 0x0772, 0x077b, 0x078a, 0x078a, 0x078a, 0x078a,
			// Entry 140 - 17F
			0x0793, 0x0798, 0x0798, 0x079f, 0x079f, 0x07a9, 0x07b0, 0x07b5,
			0x07bd, 0x07bd, 0x07c1, 0x07c5, 0x07c5, 0x07cc, 0x07d2, 0x07d2,
			0x07d2, 0x07d8, 0x07d8, 0x07d8, 0x07e7, 0x07f3, 0x07f3, 0x07fd,
			0x0803, 0x0809, 0x080c, 0x0811, 0x0815, 0x081d, 0x081d, 0x0821,
			0x0821, 0x0821, 0x0821, 0x0825, 0x0825, 0x082a, 0x0833, 0x0833,
			0x0833, 0x0833, 0x0833, 0x0833, 0x083b, 0x083b, 0x0842, 0x084a,
			0x0850, 0x085f, 0x085f, 0x085f, 0x0867, 0x086d, 0x086d, 0x086d,
			0x086d, 0x0872, 0x0879, 0x087f, 0x087f, 0x0885, 0x088a, 0x0892,
			// Entry 180 - 1BF
			0x0892, 0x0892, 0x0892, 0x0892, 0x0892, 0x0899, 0x089d, 0x089d,
			0x089d, 0x08a7, 0x08ae, 0x08b3, 0x08b6, 0x08bc, 0x08bc, 0x08bc,
			0x08bc, 0x08c4, 0x08c4, 0x08ca, 0x08d2, 0x08da, 0x08e2, 0x08e7,
			0x08e7, 0x08ed, 0x08f3, 0x08f8, 0x08f8, 0x08f8, 0x0908, 0x0908,
			0x0908, 0x090e, 0x0919, 0x091f, 0x0927, 0x092d, 0x0932, 0x0932,
			0x0932, 0x093b, 0x0940, 0x0949, 0x0950, 0x0950, 0x0950, 0x0955,
			0x0955, 0x0955, 0x095f, 0x095f, 0x096b, 0x0971, 0x0975, 0x0979,
			0x0979, 0x0979, 0x0979, 0x097e, 0x0989, 0x0989, 0x098f, 0x099d,
			// Entry 1C0 - 1FF
			0x099d, 0x09ab, 0x09b3, 0x09bb, 0x09c0, 0x09c5, 0x09ca, 0x09d6,
			0x09e0, 0x09e7, 0x09ef, 0x09f9, 0x09fe, 0x09fe, 0x09fe, 0x09fe,
			0x09fe, 0x0a0a, 0x0a0a, 0x0a12, 0x0a12, 0x0a12, 0x0a1a, 0x0a1a,
			0x0a28, 0x0a28, 0x0a28, 0x0a32, 0x0a39, 0x0a42, 0x0a42, 0x0a42,
			0x0a42, 0x0a48, 0x0a48, 0x0a48, 0x0a48, 0x0a50, 0x0a50, 0x0a57,
			0x0a5c, 0x0a6d, 0x0a6d, 0x0a72, 0x0a79, 0x0a79, 0x0a79, 0x0a79,
			0x0a81, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0a8b,
			0x0a8b, 0x0a99, 0x0a99, 0x0a99, 0x0a9d, 0x0a9d, 0x0aa3, 0x0aa3,
			// Entry 200 - 23F
			0x0aa3, 0x0aaf, 0x0ab8, 0x0ac2, 0x0acc, 0x0ad3, 0x0ada, 0x0ae6,
			0x0aeb, 0x0aeb, 0x0aeb, 0x0af1, 0x0af5, 0x0afc, 0x0afc, 0x0b09,
			0x0b0e, 0x0b0e, 0x0b0e, 0x0b13, 0x0b13, 0x0b19, 0x0b1e, 0x0b23,
			0x0b26, 0x0b2d, 0x0b2d, 0x0b36, 0x0b3d, 0x0b3d, 0x0b45, 0x0b52,
			0x0b5b, 0x0b5b, 0x0b5b, 0x0b5b, 0x0b64, 0x0b64, 0x0b6b, 0x0b71,
			0x0b71, 0x0b79, 0x0b79, 0x0b7f, 0x0b87, 0x0b8d, 0x0ba6, 0x0ba9,
			0x0ba9, 0x0ba9, 0x0ba9, 0x0ba9, 0x0bae, 0x0bae, 0x0bae, 0x0bae,
			0x0bb4, 0x0bb9, 0x0bbe, 0x0bbe, 0x0bbe, 0x0bc4, 0x0bc4, 0x0bc4,
			// Entry 240 - 27F
			0x0bc7, 0x0bcd, 0x0bcd, 0x0bcd, 0x0bcd, 0x0bcd, 0x0bd4, 0x0be4,
			0x0be4, 0x0bea, 0x0bea, 0x0bee, 0x0c09, 0x0c0d, 0x0c0d, 0x0c0d,
			0x0c1d, 0x0c1d, 0x0c2f, 0x0c3f, 0x0c50, 0x0c60, 0x0c75, 0x0c83,
			0x0c83, 0x0c83, 0x0c93, 0x0ca2, 0x0ca2, 0x0ca6, 0x0cb9, 0x0cca,
			0x0cd0, 0x0cdb, 0x0cdb, 0x0cef, 0x0d02,
		},
	},
	{ // rn
		"IgikaniIkimuharikiIcarabuIkibelarusiyaIkinyabuligariyaIkibengaliIgicekeI" +
			"kidageIkigerekiIcongerezaIcesipanyoloIgiperisiIgifaransaIgihawusaIgi" +
			"hindiIkinyahongiriyaIkinyendoziyaIkiguboIgitaliyaniIkiyapaniIkinyeja" +
			"vaIgikambodiyaIkinyakoreyaIkinyamaleziyaIkinyabirimaniyaIkinepaliIgi" +
			"holandiIgipunjabiIkinyapolonyeIgiporutugariIkirundiIkinyarumaniyaIki" +
			"rusiyaIkinyarwandaIgisomaliIgisuweduwaIgitamiliIkinyatayilandiIgitur" +
			"ukiyaIkinyayukereniInyeyuruduIkinyaviyetinamuIkiyorubaIgishinwaIkizu" +
			"lu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0012, 0x0012,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0026, 0x0036,
			0x0036, 0x0036, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
			0x004e, 0x004e, 0x004e, 0x004e, 0x0057, 0x0061, 0x0061, 0x006d,
			0x006d, 0x006d, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089,
			0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x00a0, 0x00a0, 0x00a0,
			// Entry 40 - 7F
			0x00a0, 0x00ad, 0x00ad, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00bf, 0x00bf, 0x00c8, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00de, 0x00de, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
			0x00ea, 0x00ea, 0x00ea, 0x00f8, 0x00f8, 0x0108, 0x0108, 0x0108,
			0x0111, 0x0111, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x0125, 0x0125, 0x0132,
			// Entry 80 - BF
			0x0132, 0x013f, 0x013f, 0x013f, 0x0147, 0x0155, 0x015e, 0x016a,
			0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a,
			0x016a, 0x016a, 0x0173, 0x0173, 0x0173, 0x0173, 0x0173, 0x0173,
			0x017e, 0x017e, 0x0187, 0x0187, 0x0187, 0x0196, 0x0196, 0x0196,
			0x0196, 0x0196, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01a1, 0x01af,
			0x01b9, 0x01b9, 0x01b9, 0x01c9, 0x01c9, 0x01c9, 0x01c9, 0x01c9,
			0x01c9, 0x01d2, 0x01d2, 0x01db, 0x01e2,
		},
	},
	{ // ro
		roLangStr,
		roLangIdx,
	},
	{ // ro-MD
		"wolayttaswahili (R. D. Congo)",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 80 - BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry C0 - FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 100 - 13F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 140 - 17F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 180 - 1BF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 1C0 - 1FF
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 200 - 23F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			// Entry 240 - 27F
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
			0x0008, 0x0008, 0x001d,
		},
	},
	{ // rof
		"KiakaniKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigi" +
			"rikiKiingerezaKihispaniaKiajemiKyifaransaKihausaKihindiKihungariKiin" +
			"donesiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKibur" +
			"maKinepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwand" +
			"aKisomaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuK" +
			"iyorubaKichinaKizuluKihorombo",
		[]uint16{ // 481 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0056, 0x0056, 0x0060,
			0x0060, 0x0060, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0071,
			0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x0078,
			0x0078, 0x007f, 0x007f, 0x007f, 0x007f, 0x0088, 0x0088, 0x0088,
			// Entry 40 - 7F
			0x0088, 0x0093, 0x0093, 0x0099, 0x0099, 0x0099, 0x0099, 0x0099,
			0x00a3, 0x00a3, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00bb, 0x00bb, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2, 0x00c2,
			0x00c2, 0x00c2, 0x00c2, 0x00cb, 0x00cb, 0x00d2, 0x00d2, 0x00d2,
			0x00da, 0x00da, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00ec, 0x00ec, 0x00f5,
			// Entry 80 - BF
			0x00f5, 0x00fb, 0x00fb, 0x00fb, 0x00fb, 0x0104, 0x010a, 0x0115,
			0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115, 0x0115,
			0x0115, 0x0115, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x0124, 0x0124, 0x012b, 0x012b, 0x012b, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013d, 0x013d, 0x013d, 0x013d, 0x013d, 0x0146,
			0x014c, 0x014c, 0x014c, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157,
			0x0157, 0x015f, 0x015f, 0x0166, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry C0 - FF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 100 - 13F
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 140 - 17F
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 180 - 1BF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			// Entry 1C0 - 1FF
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c, 0x016c,
			0x0175,
		},
	},
	{ // ru
		ruLangStr,
		ruLangIdx,
	},
	{}, // ru-UA
	{ // rw
		"IkinyafurikaneriInyetuwiInyamuharikiIcyarabuIcyasamiziInyazeribayijaniIk" +
			"ibelarusiyaUrunyabuligariyaIkibengaliInyebiritoniInyebosiniyaIgikata" +
			"laniIgicekeIkigaluwaIkidaninwaIkidageIkigerekiIcyongerezaIcyesiperan" +
			"toIcyesipanyoloIcyesitoniyaIkibasikiInyeperisiIgifinilandeInyefaroyi" +
			"ziIgifaransaIgifiriziyaniIkirilandiIkigaluwa cy’IgisweduwaIkigalisiy" +
			"aInyaguwaraniInyegujaratiIgiheburayoIgihindiIgikorowasiyaIgihongiriy" +
			"aIkinyarumeniyaUrurimi GahuzamiryangoIkinyendoziyaUruhuzandimiIgisil" +
			"andeIgitaliyaniIkiyapaniInyejavaInyejeworujiyaIgikambodiyaIgikanadaI" +
			"gikoreyaInyekuridishiInkerigiziIkilatiniIlingalaIkilawotiyaniIkilitu" +
			"waniyaIkinyaletoviyaniIkimasedoniyaniIkimalayalamiIkimongoliIkimarat" +
			"iIkimalayiIkimalitezeIkinepaliIkinerilandeInyenoruveji (Nyonorusiki)" +
			"IkinoruvejiInyogusitaniInyoriyaIgipunjabiIgipoloneImpashitoIgiporutu" +
			"galiIkinyarumaniyaIkirusiyaKinyarwandaIgisansikiriIgisindiInyesimpal" +
			"ezeIgisilovakiIkinyasiloveniyaIgisomaliIcyalubaniyaIgiseribeInyeseso" +
			"toInyesudaniIgisuweduwaIgiswahiliIgitamiliIgiteluguIgitayiInyatigiri" +
			"nyaInyeturukimeniIgiturukiyaIkiwiguriIkinyayukereniInyeyuruduInyeyuz" +
			"ubekiIkinyaviyetinamuInyehawusaInyeyidishiInyezuluIkinyafilipineInye" +
			"kilingoniInyeporutigali (Brezili)Inyeporutigali (Igiporutigali)Inyes" +
			"eribiya na Korowasiya",
		[]uint16{ // 610 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0018, 0x0024, 0x0024,
			0x002c, 0x0036, 0x0036, 0x0036, 0x0046, 0x0046, 0x0053, 0x0063,
			0x0063, 0x0063, 0x006d, 0x006d, 0x0079, 0x0085, 0x0090, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0097, 0x0097, 0x0097, 0x00a0, 0x00aa,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00ba, 0x00c5, 0x00d2, 0x00df,
			0x00eb, 0x00f4, 0x00fe, 0x00fe, 0x010a, 0x010a, 0x0116, 0x0120,
			0x012d, 0x0137, 0x0150, 0x015b, 0x0167, 0x0173, 0x0173, 0x0173,
			0x017e, 0x0186, 0x0186, 0x0193, 0x0193, 0x019f, 0x01ad, 0x01ad,
			// Entry 40 - 7F
			0x01c3, 0x01d0, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01dc, 0x01e6,
			0x01f1, 0x01f1, 0x01fa, 0x0202, 0x0210, 0x0210, 0x0210, 0x0210,
			0x0210, 0x0210, 0x021c, 0x0225, 0x022e, 0x022e, 0x022e, 0x023b,
			0x023b, 0x023b, 0x0245, 0x024e, 0x024e, 0x024e, 0x024e, 0x0256,
			0x0263, 0x0270, 0x0270, 0x0280, 0x0280, 0x0280, 0x0280, 0x028f,
			0x029c, 0x02a6, 0x02af, 0x02b8, 0x02c3, 0x02c3, 0x02c3, 0x02c3,
			0x02cc, 0x02cc, 0x02d8, 0x02f2, 0x02fd, 0x02fd, 0x02fd, 0x02fd,
			0x0309, 0x0309, 0x0309, 0x0311, 0x0311, 0x031b, 0x031b, 0x0324,
			// Entry 80 - BF
			0x032d, 0x033a, 0x033a, 0x033a, 0x033a, 0x0348, 0x0351, 0x035c,
			0x0368, 0x0368, 0x0370, 0x0370, 0x0370, 0x037d, 0x0388, 0x0398,
			0x0398, 0x0398, 0x03a1, 0x03ad, 0x03b6, 0x03b6, 0x03c0, 0x03ca,
			0x03d5, 0x03df, 0x03e8, 0x03f1, 0x03f1, 0x03f8, 0x0405, 0x0413,
			0x0413, 0x0413, 0x041e, 0x041e, 0x041e, 0x041e, 0x0427, 0x0435,
			0x043f, 0x044b, 0x044b, 0x045b, 0x045b, 0x045b, 0x045b, 0x0465,
			0x0470, 0x0470, 0x0470, 0x0470, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			// Entry C0 - FF
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			// Entry 100 - 13F
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478, 0x0478,
			0x0478, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 140 - 17F
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 180 - 1BF
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 1C0 - 1FF
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			// Entry 200 - 23F
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486, 0x0486,
			0x0486, 0x0486, 0x0486, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			// Entry 240 - 27F
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493,
			0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x0493, 0x04ab, 0x04c9,
			0x04c9, 0x04e3,
		},
	},
	{ // rwk
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKir" +
			"uwa",
		[]uint16{ // 487 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 180 - 1BF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 1C0 - 1FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x019f,
		},
	},
	{ // sah
		"АбхаастыыАппырыкааныстыыАмхаардыыАраабтыыАваардыыАдьырбайдьаанныыБөлөрүү" +
			"стүүБулҕаардыыБенгаллыыТибиэттииБосныйалыыКаталаанныыЧэчиэннииЧиэхт" +
			"ииДаатскайдыыНиэмэстииГириэктииАаҥыллыыЫспаанныыЭстиэнийэлииПиэрист" +
			"ииПииннииБоронсуустууБэҥгиэрдииЭрмээннииЫтаалыйалыыДьоппуоннууКурус" +
			"ууннууХаһаахтыыКэриэйдииКыргыстыыЛатыынныыМоҕуоллууМалаайдыыНьыпаал" +
			"лыыПандьаабтыыПортугааллыыРумыынныыНууччалыыСловаактыыАлбаанныыТамы" +
			"ллыыТөлүгүлүүТадьыыктыыТатаардыыУйгуурдууУкрайыыньыстыыҮзбиэктииКыт" +
			"айдыыЗуулулууАлеуттууАстуурдууКиин куурдууПилипииннииНагаайдыысаха " +
			"тыла",
		[]uint16{ // 489 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0012, 0x0012, 0x0030, 0x0030, 0x0042, 0x0042,
			0x0052, 0x0052, 0x0062, 0x0062, 0x0082, 0x0082, 0x0098, 0x00ac,
			0x00ac, 0x00ac, 0x00be, 0x00d0, 0x00d0, 0x00e4, 0x00fa, 0x010c,
			0x010c, 0x010c, 0x010c, 0x011a, 0x011a, 0x011a, 0x011a, 0x0130,
			0x0142, 0x0142, 0x0142, 0x0142, 0x0154, 0x0164, 0x0164, 0x0176,
			0x018e, 0x018e, 0x01a0, 0x01a0, 0x01ae, 0x01ae, 0x01ae, 0x01c6,
			0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01c6,
			0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01c6, 0x01da, 0x01ec, 0x01ec,
			// Entry 40 - 7F
			0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec, 0x01ec,
			0x0202, 0x0202, 0x0218, 0x0218, 0x022e, 0x022e, 0x022e, 0x022e,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0252, 0x0252, 0x0252, 0x0252,
			0x0252, 0x0252, 0x0264, 0x0276, 0x0276, 0x0276, 0x0276, 0x0276,
			0x0276, 0x0276, 0x0276, 0x0276, 0x0276, 0x0276, 0x0276, 0x0276,
			0x0276, 0x0288, 0x0288, 0x029a, 0x029a, 0x029a, 0x029a, 0x029a,
			0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02ae,
			0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02ae, 0x02c4, 0x02c4, 0x02c4,
			// Entry 80 - BF
			0x02c4, 0x02dc, 0x02dc, 0x02dc, 0x02dc, 0x02ee, 0x0300, 0x0300,
			0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0300, 0x0314, 0x0314,
			0x0314, 0x0314, 0x0314, 0x0326, 0x0326, 0x0326, 0x0326, 0x0326,
			0x0326, 0x0326, 0x0336, 0x0348, 0x035c, 0x035c, 0x035c, 0x035c,
			0x035c, 0x035c, 0x035c, 0x035c, 0x036e, 0x036e, 0x0380, 0x039c,
			0x039c, 0x03ae, 0x03ae, 0x03ae, 0x03ae, 0x03ae, 0x03ae, 0x03ae,
			0x03ae, 0x03ae, 0x03ae, 0x03be, 0x03ce, 0x03ce, 0x03ce, 0x03ce,
			0x03ce, 0x03ce, 0x03ce, 0x03ce, 0x03ce, 0x03ce, 0x03ce, 0x03de,
			// Entry C0 - FF
			0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de,
			0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03de, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0, 0x03f0,
			// Entry 100 - 13F
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			// Entry 140 - 17F
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			// Entry 180 - 1BF
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x041d, 0x041d, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			// Entry 1C0 - 1FF
			0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f, 0x042f,
			0x0440,
		},
	},
	{ // saq
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKisampur",
		[]uint16{ // 491 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 1C0 - 1FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0171,
		},
	},
	{ // sbp
		"IshiyakaniIshiyamuhaliIshiyalabuIshibelalusiIshibulugaliaIshibangilaIshi" +
			"shekiIshijelumaniIshigilikiIshingelesaIshihisipaniyaIshiajemiIshifal" +
			"ansaIshihawusaIshihindiIshihungaliIshihindonesiaIshihigiboIshihitali" +
			"yanoIshijapaniIshijavaIshikambodiaIshikoleyaIshimalesiyaIshibulumaIs" +
			"hinepaliIshiholansiIshipunjabiIshipolandiIshilenoIshilomaniyaIshilus" +
			"iIshinyalwandaIshisomaliIshiswidiIshitamiliIshitayilandiIshitulukiIs" +
			"hiyukilaniyaIshiwuludiIshivietinamuIshiyolubaIshishinaIshisuluIshisa" +
			"ngu",
		[]uint16{ // 496 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0016, 0x0016,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x002c, 0x0039,
			0x0039, 0x0039, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044, 0x0044,
			0x0044, 0x0044, 0x0044, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0063, 0x006e, 0x006e, 0x007c,
			0x007c, 0x007c, 0x0085, 0x0085, 0x0085, 0x0085, 0x0085, 0x0090,
			0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x0090, 0x009a,
			0x009a, 0x00a3, 0x00a3, 0x00a3, 0x00a3, 0x00ae, 0x00ae, 0x00ae,
			// Entry 40 - 7F
			0x00ae, 0x00bc, 0x00bc, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00d4, 0x00d4, 0x00de, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00e6,
			0x00e6, 0x00e6, 0x00f2, 0x00f2, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc, 0x00fc,
			0x00fc, 0x00fc, 0x00fc, 0x0108, 0x0108, 0x0112, 0x0112, 0x0112,
			0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0132, 0x0132, 0x013d,
			// Entry 80 - BF
			0x013d, 0x0145, 0x0145, 0x0145, 0x0145, 0x0151, 0x0159, 0x0166,
			0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166, 0x0166,
			0x0166, 0x0166, 0x0170, 0x0170, 0x0170, 0x0170, 0x0170, 0x0170,
			0x0179, 0x0179, 0x0183, 0x0183, 0x0183, 0x0190, 0x0190, 0x0190,
			0x0190, 0x0190, 0x019a, 0x019a, 0x019a, 0x019a, 0x019a, 0x01a8,
			0x01b2, 0x01b2, 0x01b2, 0x01bf, 0x01bf, 0x01bf, 0x01bf, 0x01bf,
			0x01bf, 0x01c9, 0x01c9, 0x01d2, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry C0 - FF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 100 - 13F
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 140 - 17F
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 180 - 1BF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			// Entry 1C0 - 1FF
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da,
			0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01da, 0x01e3,
		},
	},
	{ // se
		"afrikánsagiellaaragoniagiellaarábagiellavilges-ruoššagiellabulgáriagiell" +
			"abengalgiellatibetagiellabretonagiellabosniagiellakatalánagiellacors" +
			"icagiellačeahkagiellakymragielladánskkagielladuiskkagielladivehigiel" +
			"ladzongkhagiellagreikkagiellaeaŋgalsgiellaspánskkagiellaesttegiellap" +
			"ersijagiellasuomagiellafidjigiellafearagiellafránskkagiellaoarjifrii" +
			"sagiellaiirragiellagujaratagiellamanksgiellahaussagiellahindigiellak" +
			"roátiagiellahaitigiellaungárgiellaarmeenagiellaindonesiagiellaislánd" +
			"dagiellaitáliagiellajapánagiellajavagiellageorgiagiellakazakgiellaka" +
			"mbodiagiellakoreagiellakurdigiellakomigiellakornagiellaláhtengiellal" +
			"uxemburggagiellalaogiellaliettuvagiellalátviagiellamaorigiellamakedo" +
			"niagiellamongoliagiellamaltagiellaburmagiellanepaligiellahollánddagi" +
			"ellaođđadárogiellagirjedárogiellaoksitánagiellapanjabigiellapolskkag" +
			"iellaportugálagiellaromanšgiellaromániagiellaruoššagiellasardigiella" +
			"davvisámegiellaslovákiagiellaslovenagiellasamoagiellaalbánagiellaser" +
			"biagiellaruoŧagiellaŧaigielladurkagiellatahitigiellaukrainagiellaurd" +
			"ugiellavietnamgiellavallonagiellakiinnágiellaacehgiellaboares eaŋgal" +
			"asgiellaasturiagiellamarigiellafilippiinnagiellahawaiigiellagárjilgi" +
			"ellamokšagiellaersagiellasisiliagiellaselkupagiellalullisámegiellaju" +
			"levsámegiellaanárašgiellanuortalašgiellashimaorigiellaudmurtagiellad" +
			"ovdameahttun giellakantongiellaserbokroatiagiellaálki kiinágiellaárb" +
			"evirolaš kiinnágiella",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0010, 0x0010, 0x0010, 0x001e,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x003f, 0x004e,
			0x004e, 0x004e, 0x005a, 0x0066, 0x0073, 0x007f, 0x008e, 0x008e,
			0x008e, 0x009b, 0x009b, 0x00a8, 0x00a8, 0x00a8, 0x00b3, 0x00c1,
			0x00ce, 0x00da, 0x00e8, 0x00e8, 0x00f5, 0x0103, 0x0103, 0x0112,
			0x011d, 0x011d, 0x012a, 0x012a, 0x0135, 0x0140, 0x014b, 0x015a,
			0x016b, 0x0176, 0x0176, 0x0176, 0x0176, 0x0184, 0x018f, 0x019b,
			0x019b, 0x01a6, 0x01a6, 0x01b4, 0x01bf, 0x01cb, 0x01d8, 0x01d8,
			// Entry 40 - 7F
			0x01d8, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01e7, 0x01f6,
			0x0203, 0x0203, 0x0210, 0x021a, 0x0227, 0x0227, 0x0227, 0x0227,
			0x0232, 0x0232, 0x0240, 0x0240, 0x024b, 0x024b, 0x024b, 0x0256,
			0x0260, 0x026b, 0x026b, 0x0278, 0x0289, 0x0289, 0x0289, 0x0289,
			0x0292, 0x02a0, 0x02a0, 0x02ad, 0x02ad, 0x02ad, 0x02b8, 0x02c7,
			0x02c7, 0x02d5, 0x02d5, 0x02d5, 0x02e0, 0x02eb, 0x02eb, 0x02eb,
			0x02f7, 0x02f7, 0x0307, 0x0318, 0x0328, 0x0328, 0x0328, 0x0328,
			0x0337, 0x0337, 0x0337, 0x0337, 0x0337, 0x0344, 0x0344, 0x0351,
			// Entry 80 - BF
			0x0351, 0x0361, 0x0361, 0x036e, 0x036e, 0x037c, 0x038a, 0x038a,
			0x038a, 0x0395, 0x0395, 0x03a5, 0x03a5, 0x03a5, 0x03b4, 0x03c1,
			0x03cc, 0x03cc, 0x03cc, 0x03d9, 0x03e5, 0x03e5, 0x03e5, 0x03e5,
			0x03f1, 0x03f1, 0x03f1, 0x03f1, 0x03f1, 0x03fb, 0x03fb, 0x03fb,
			0x03fb, 0x03fb, 0x0406, 0x0406, 0x0406, 0x0412, 0x0412, 0x041f,
			0x0429, 0x0429, 0x0429, 0x0436, 0x0436, 0x0443, 0x0443, 0x0443,
			0x0443, 0x0443, 0x0443, 0x0450, 0x0450, 0x045a, 0x045a, 0x045a,
			0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a, 0x045a,
			// Entry C0 - FF
			0x045a, 0x045a, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470,
			0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x0470, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d, 0x047d,
			0x047d, 0x047d, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			// Entry 100 - 13F
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487, 0x0487,
			0x0487, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498, 0x0498,
			// Entry 140 - 17F
			0x0498, 0x0498, 0x0498, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04a4,
			0x04a4, 0x04a4, 0x04a4, 0x04a4, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			// Entry 180 - 1BF
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1, 0x04b1,
			0x04b1, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd,
			0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04bd, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			// Entry 1C0 - 1FF
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7, 0x04c7,
			0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04d4, 0x04e1,
			0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1, 0x04e1,
			// Entry 200 - 23F
			0x04e1, 0x04f1, 0x0501, 0x050f, 0x051f, 0x051f, 0x051f, 0x051f,
			0x051f, 0x051f, 0x051f, 0x051f, 0x051f, 0x051f, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d, 0x052d,
			0x052d, 0x052d, 0x052d, 0x053a, 0x053a, 0x053a, 0x054e, 0x054e,
			0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e,
			0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x054e,
			// Entry 240 - 27F
			0x054e, 0x054e, 0x054e, 0x054e, 0x054e, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a, 0x055a,
			0x055a, 0x056c, 0x056c, 0x057e, 0x0599,
		},
	},
	{ // se-FI
		"vilgesruoššagiellabengalagiellafižigiellaarmenagiellakazakhgiellakamboža" +
			"giellanepalagiellapanjabagiellathaigiellavietnamagiellaačehgiellakom" +
			"oragiellastandárda arábagiellanuortariikkalaš duiskkagiellašveicalaš" +
			" duiskkagiellaaustrálialaš eaŋgalsgiellakanádalaš eaŋgalsgiellabriht" +
			"talaš eaŋgalsgiellaamerihkálaš eaŋgalsgiellalatiinna-amerihkalaš spá" +
			"nskkagiellaespánjalaš spánskkagiellameksikolaš spánskkagiellakanádal" +
			"aš fránskkagiellašveicalaš fránskkagiellabelgialaš hollánddagiellabr" +
			"asilialaš portugálagiellaportugálalaš portugálagiellamoldávialaš rom" +
			"ániagiellaálkes kiinnágiella",
		[]uint16{ // 612 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014,
			0x0014, 0x0014, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x0021,
			0x0021, 0x0021, 0x0021, 0x0021, 0x0021, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x0038, 0x0038,
			// Entry 40 - 7F
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0044, 0x0044, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e,
			0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x006b, 0x006b, 0x006b,
			// Entry 80 - BF
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083,
			0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry C0 - FF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 100 - 13F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 140 - 17F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 180 - 1BF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 1C0 - 1FF
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			// Entry 200 - 23F
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e,
			0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x008e, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			// Entry 240 - 27F
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x00b1, 0x00b1,
			0x00cf, 0x00e8, 0x0105, 0x011f, 0x0139, 0x0155, 0x017a, 0x0196,
			0x01b1, 0x01b1, 0x01cc, 0x01e7, 0x01e7, 0x0202, 0x021f, 0x023e,
			0x025a, 0x025a, 0x025a, 0x026e,
		},
	},
	{ // seh
		"akanamáricoárabebielo-russobúlgarobengalitchecoalemãogregoinglêsespanhol" +
			"persafrancêshausahindihúngaroindonésioiboitalianojaponêsjavanêscmerc" +
			"oreanomalaiobirmanêsnepalêsholandêspanjabipolonêsportuguêsromenoruss" +
			"okinyarwandasomalisuecotâmiltailandêsturcoucranianourduvietnamitaior" +
			"ubáchinêszulusena",
		[]uint16{ // 502 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000c, 0x000c,
			0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x0012, 0x001d, 0x0025,
			0x0025, 0x0025, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0039, 0x0039, 0x0039, 0x0039, 0x003e, 0x0045, 0x0045, 0x004d,
			0x004d, 0x004d, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005f,
			0x005f, 0x0064, 0x0064, 0x0064, 0x0064, 0x006c, 0x006c, 0x006c,
			// Entry 40 - 7F
			0x006c, 0x0076, 0x0076, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079,
			0x0081, 0x0081, 0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091,
			0x0091, 0x0091, 0x0095, 0x0095, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x009c, 0x009c, 0x009c, 0x00a2, 0x00a2, 0x00ab, 0x00ab, 0x00ab,
			0x00b3, 0x00b3, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc,
			0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00bc, 0x00c3, 0x00c3, 0x00cb,
			// Entry 80 - BF
			0x00cb, 0x00d5, 0x00d5, 0x00d5, 0x00d5, 0x00db, 0x00e0, 0x00eb,
			0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb, 0x00eb,
			0x00eb, 0x00eb, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1, 0x00f1,
			0x00f6, 0x00f6, 0x00fc, 0x00fc, 0x00fc, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x0114,
			0x0118, 0x0118, 0x0118, 0x0122, 0x0122, 0x0122, 0x0122, 0x0122,
			0x0122, 0x0129, 0x0129, 0x0130, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry C0 - FF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 100 - 13F
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 140 - 17F
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 180 - 1BF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			// Entry 1C0 - 1FF
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x0134, 0x0134, 0x0134, 0x0138,
		},
	},
	{ // ses
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senniKoree" +
			" senniMaleezi senniBurme senniNeepal senniHolandee senniPunjaabi sen" +
			"niiPolonee senniPortugee senniRumaani senniRuusi senniRwanda senniSo" +
			"maali senniSuweede senniTamil senniTaailandu senniTurku senniUkreen " +
			"senniUrdu senniVietnaam senniYorbance senniSinuwa senni, MandareŋZul" +
			"u senniKoyraboro senni",
		[]uint16{ // 505 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x0111, 0x0111, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x011c, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0140, 0x0140, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
			0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x015d, 0x015d, 0x016a,
			// Entry 80 - BF
			0x016a, 0x0178, 0x0178, 0x0178, 0x0178, 0x0185, 0x0190, 0x019c,
			0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c, 0x019c,
			0x019c, 0x019c, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
			0x01b6, 0x01b6, 0x01c1, 0x01c1, 0x01c1, 0x01d0, 0x01d0, 0x01d0,
			0x01d0, 0x01d0, 0x01db, 0x01db, 0x01db, 0x01db, 0x01db, 0x01e7,
			0x01f1, 0x01f1, 0x01f1, 0x01ff, 0x01ff, 0x01ff, 0x01ff, 0x01ff,
			0x01ff, 0x020d, 0x020d, 0x0224, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry C0 - FF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 100 - 13F
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 140 - 17F
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 180 - 1BF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			// Entry 1C0 - 1FF
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x023d,
		},
	},
	{ // sg
		"AkâanAmarîkiArâboBielörûsiBulugäriBengäliTyêkiZâmaniGerêkiAnglëeEspanyöl" +
			"FarsîFarânziHaüsäHîndiHongruäaEnndonezïiÏgböÊnndeZaponëeZavanëeKmêre" +
			"KoreyëenMalëeMiamära, BirimäniNepalëeHolandëePenzäbïPolonëePortugëe," +
			" PûraRumëenRûsiRuandäaSängöSomalïiSueduäaTämûliThâiTûrûkuUkrêniÛrduV" +
			"ietnämYorubaShinuäaZûlu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x0014, 0x001f, 0x0028,
			0x0028, 0x0028, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030, 0x0030,
			0x0030, 0x0030, 0x0030, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x003d, 0x003d, 0x003d, 0x003d, 0x0044, 0x004b, 0x004b, 0x0054,
			0x0054, 0x0054, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0069,
			0x0069, 0x006f, 0x006f, 0x006f, 0x006f, 0x0078, 0x0078, 0x0078,
			// Entry 40 - 7F
			0x0078, 0x0083, 0x0083, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x008f, 0x008f, 0x0097, 0x009f, 0x009f, 0x009f, 0x009f, 0x009f,
			0x009f, 0x009f, 0x00a5, 0x00a5, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00ae, 0x00b4, 0x00b4, 0x00c7, 0x00c7, 0x00c7,
			0x00cf, 0x00cf, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00e1, 0x00e1, 0x00e9,
			// Entry 80 - BF
			0x00e9, 0x00f9, 0x00f9, 0x00f9, 0x00f9, 0x0100, 0x0105, 0x010d,
			0x010d, 0x010d, 0x010d, 0x010d, 0x0114, 0x0114, 0x0114, 0x0114,
			0x0114, 0x0114, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x0124, 0x0124, 0x012c, 0x012c, 0x012c, 0x0131, 0x0131, 0x0131,
			0x0131, 0x0131, 0x0139, 0x0139, 0x0139, 0x0139, 0x0139, 0x0140,
			0x0145, 0x0145, 0x0145, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
			0x014d, 0x0153, 0x0153, 0x015b, 0x0160,
		},
	},
	{ // shi
		"ⵜⴰⴽⴰⵏⵜⵜⴰⵎⵀⴰⵔⵉⵜⵜⴰⵄⵔⴰⴱⵜⵜⴰⴱⵉⵍⴰⵔⵓⵙⵜⵜⴰⴱⵍⵖⴰⵔⵉⵜⵜⴰⴱⵏⵖⴰⵍⵉⵜⵜⴰⵜⵛⵉⴽⵉⵜⵜⴰⵍⵉⵎⴰⵏⵜⵜⴰⴳⵔⵉⴳⵉ" +
			"ⵜⵜⴰⵏⴳⵍⵉⵣⵜⵜⴰⵙⴱⵏⵢⵓⵍⵉⵜⵜⴰⴼⵓⵔⵙⵉⵜⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜⵜⴰⵀⴰⵡⵙⴰⵜⵜⴰⵀⵉⵏⴷⵉⵜⵜⴰⵀⵏⵖⴰⵔⵉⵜⵜⴰⵏⴷ" +
			"ⵓⵏⵉⵙⵉⵜⵜⵉⴳⴱⵓⵜⵜⴰⵟⴰⵍⵢⴰⵏⵜⵜⴰⵊⴰⴱⴱⵓⵏⵉⵜⵜⴰⵊⴰⴼⴰⵏⵉⵜⵜⴰⵅⵎⵉⵔⵜⵜⴰⴽⵓⵔⵉⵜⵜⴰⵎⴰⵍⴰⵡⵉⵜⵜⴰⴱ" +
			"ⵉⵔⵎⴰⵏⵉⵜⵜⴰⵏⵉⴱⴰⵍⵉⵜⵜⴰⵀⵓⵍⴰⵏⴷⵉⵜⵜⴰⴱⵏⵊⴰⴱⵉⵜⵜⴰⴱⵓⵍⵓⵏⵉⵜⵜⴰⴱⵕⵟⵇⵉⵣⵜⵜⴰⵔⵓⵎⴰⵏⵉⵜⵜⴰⵔⵓ" +
			"ⵙⵉⵜⵜⴰⵔⵓⵡⴰⵏⴷⵉⵜⵜⴰⵙⵓⵎⴰⵍⵉⵜⵜⴰⵙⵡⵉⴷⵉⵜⵜⴰⵜⴰⵎⵉⵍⵜⵜⴰⵜⴰⵢⵍⴰⵏⴷⵉⵜⵜⴰⵜⵓⵔⴽⵉⵜⵜⵓⴽⵔⴰⵏⵉⵜⵜ" +
			"ⵓⵔⴷⵓⵜⵜⴰⴼⵉⵜⵏⴰⵎⵉⵜⵜⴰⵢⵔⵓⴱⴰⵜⵜⴰⵛⵉⵏⵡⵉⵜⵜⴰⵣⵓⵍⵓⵜⵜⴰⵛⵍⵃⵉⵜ",
		[]uint16{ // 508 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x002a, 0x002a,
			0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x005d, 0x0078,
			0x0078, 0x0078, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00db, 0x00f3, 0x00f3, 0x0111,
			0x0111, 0x0111, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0147,
			0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x015f,
			0x015f, 0x0177, 0x0177, 0x0177, 0x0177, 0x0192, 0x0192, 0x0192,
			// Entry 40 - 7F
			0x0192, 0x01b0, 0x01b0, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
			0x01dd, 0x01dd, 0x01fb, 0x0216, 0x0216, 0x0216, 0x0216, 0x0216,
			0x0216, 0x0216, 0x022b, 0x022b, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x025b, 0x025b, 0x0279, 0x0279, 0x0279,
			0x0294, 0x0294, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2,
			0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02cd, 0x02cd, 0x02e8,
			// Entry 80 - BF
			0x02e8, 0x0303, 0x0303, 0x0303, 0x0303, 0x031e, 0x0333, 0x0351,
			0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0351, 0x0351, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c,
			0x0384, 0x0384, 0x039c, 0x039c, 0x039c, 0x03bd, 0x03bd, 0x03bd,
			0x03bd, 0x03bd, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03ed,
			0x03ff, 0x03ff, 0x03ff, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x0435, 0x0435, 0x044d, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry C0 - FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 100 - 13F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 140 - 17F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 180 - 1BF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 1C0 - 1FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0477,
		},
	},
	{ // shi-Latn
		"TakantTamharitTaɛrabtTabilarustTablɣaritTabnɣalitTatcikitTalimantTagrigi" +
			"tTangliztTasbnyulitTafursitTafransistTahawsatTahinditTahnɣaritTandun" +
			"isitTigbutTaṭalyantTajabbunitTajavanitTaxmirtTakuritTamalawitTabirma" +
			"nitTanibalitTahulanditTabnjabitTabulunitTabṛṭqiztTarumanitTarusitTar" +
			"uwanditTasumalitTaswiditTatamiltTataylanditTaturkitTukranitTurdutTaf" +
			"itnamitTayrubatTacinwitTazulutTashelḥiyt",
		[]uint16{ // 508 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0020, 0x002a,
			0x002a, 0x002a, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x003c, 0x003c, 0x003c, 0x003c, 0x003c,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004c, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0066, 0x0066, 0x0066, 0x0066, 0x0066, 0x0070,
			0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0070, 0x0078,
			0x0078, 0x0080, 0x0080, 0x0080, 0x0080, 0x008a, 0x008a, 0x008a,
			// Entry 40 - 7F
			0x008a, 0x0094, 0x0094, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x00a5, 0x00a5, 0x00af, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6, 0x00c6,
			0x00c6, 0x00c6, 0x00c6, 0x00cf, 0x00cf, 0x00d9, 0x00d9, 0x00d9,
			0x00e2, 0x00e2, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00f5, 0x00f5, 0x00fe,
			// Entry 80 - BF
			0x00fe, 0x010b, 0x010b, 0x010b, 0x010b, 0x0114, 0x011b, 0x0125,
			0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125, 0x0125,
			0x0125, 0x0125, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e, 0x012e,
			0x0136, 0x0136, 0x013e, 0x013e, 0x013e, 0x0149, 0x0149, 0x0149,
			0x0149, 0x0149, 0x0151, 0x0151, 0x0151, 0x0151, 0x0151, 0x0159,
			0x015f, 0x015f, 0x015f, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0171, 0x0171, 0x0179, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry C0 - FF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 100 - 13F
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 140 - 17F
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 180 - 1BF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			// Entry 1C0 - 1FF
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x0180, 0x018c,
		},
	},
	{ // si
		siLangStr,
		siLangIdx,
	},
	{ // sk
		skLangStr,
		skLangIdx,
	},
	{ // sl
		slLangStr,
		slLangIdx,
	},
	{ // smn
		"afarabhasiakielâafrikaansakankielâamharakielâaragoniakielâarabiakielâass" +
			"amkielâavarkielâaymarakielâazerbaidžankielâbaškirkielâvielgisruošâki" +
			"elâbulgariakielâbislamabambarakielâbanglakielâtiibetkielâbretonkielâ" +
			"bosniakielâkatalankielâtšetšenkielâchamorrokielâkorsikakielâtšeekiki" +
			"elâkirkkoslaavitšuvaskielâkymrikielâtanskakielâsaksakielâdivehikielâ" +
			"Dzongkhaewekielâkreikakielâeŋgâlâskielâesperantokielâespanjakielâees" +
			"tikielâbaskikielâpersiakielâfulakielâsuomâkielâfidžikielâfäärikielâr" +
			"anskakielâviestârfriisiiirikielâskottilâš gaelikielâgaliciakielâguar" +
			"anikielâgudžaratikielâmankshausakielâhepreakielâhindikielâkroatiakie" +
			"lâHaiti kreoliuŋgarkielâarmeniakielâhererokielâinterlinguaindonesiak" +
			"ielâigbokielâidoislandkielâitaliakielâinuktitutjaapaankielâjaavakiel" +
			"âgeorgiakielâkikujukielâkuanjamakazakkielâkalaallisutkhmerkielâkann" +
			"adakoreakielâkanurikielâkashmirkielâkurdikielâkomikielâkornikielâkir" +
			"giskielâläättinkielâluxemburgkielâlugandalimburgkielâlingalalaokielâ" +
			"liettuakielâkatangalubalatviakielâmalagaskielâmarshallkielâmaorikiel" +
			"âmakedoniakielâmalajammongoliakielâmarathikielâmalaijimaltakielâbur" +
			"makielânaurukielâtave-nbedelenepalkielândongahollandkielâtárukielâ n" +
			"ynorsktárukielâ bokmålmaadâ-nbedelenavajokielânjanžaoksitanoromokiel" +
			"âorijaossetkielâpandžabipuolakielâpaštuportugalkielâquechuaretoroom" +
			"aankielârundiromaniakielâruošâkielâruandakielâsanskritsardiniakielâs" +
			"indhitavekielâsangosinhalaslovakiakielâsloveniakielâsamoakielâshonas" +
			"omalikielâalbaniakielâserbiakielâswazikielâmaadâsothosundakielâruotâ" +
			"kielâswahilikielâtamilkielâtelugutadžikkielâthaikielâtigrinyakielâtu" +
			"rkmenkielâtswanakielâtongakielâtuurkikielâtsongakielâtatarkielâtahit" +
			"ikielâuigurkielâukrainakielâurduuzbekkielâvendakielâvietnamkielâvola" +
			"pükwalloonkielâwolofkielâxhosakielâjiddishyorubakielâmandarinkiinaki" +
			"elâzulukielâatšehkielâadangmeadygeaghemainukielâaleutkielâmaadâaltai" +
			"kielâangikamapudungunarapahokielâasukielâasturiakielâawadhikielâbali" +
			"kielâbasaakielâbembakielâbenakielâbhožpurikielâbinikielâsiksikakielâ" +
			"bodokielâbugikielâblinkielâcebuanokielâkigakielâchuukkielâmarikielâc" +
			"hoctawkielâcherokeekielâcheyennekielâsorani kurdikielâSeychellij kre" +
			"oliranskadakotakielâdargikielâtaitakielâdogribkielâzarmakielâvyeliso" +
			"rbidualakielâjola-fonyidazakielâembukielâefikkielâekajukewondokielâf" +
			"ilipinokielâfonkielâfriulikielâgakielâge’ezkiribatikielâgorontalokie" +
			"lâtoovláš kreikakielâSveitsi saksakielâgusiikielâgwich’inkielâhawaij" +
			"ikielâhiligainokielâhmongkielâpajesorbihupakielâibankielâibibiokielâ" +
			"ilocanoinguškielâlojbanngombamachamekabylkielâkachinjjukambakielâkab" +
			"ardikielâtyapmakondeKap Verde kreolikorokhasikoyra chiinikakokalenji" +
			"kielâkimbundukonkanikpellekielâkarachai-balkarkielâkärjilkielâkurukh" +
			"kielâshambalabafiakölnkielâkumykkielâladinokielâlangokielâlezgikielâ" +
			"lakotakielâlozitavelurilulualubalundaluolusailuhyamadurakielâmagahim" +
			"aithilimakasarmasaikielâmokšakielâmendekielâmerukielâmorisyenmakua-m" +
			"eettometa’micmacminangkabaumanipurimohawkkielâmooreviestârmarimundan" +
			"gmaŋgâ kielâmuskogeekielâmirandeskielâersäkielâmazandaraninapolikiel" +
			"ânamanewariniaskielâniuekielâkwasiongiemboonnogaikielâtoovláš táruk" +
			"ielân’kotavesothonuernyankolekielâpangasinankielâpampangakielâpapiam" +
			"entupalaukielâNigeria pidgintoovláš preussikielâki’che’rapanuiraroto" +
			"ngaromboroomaankielâaromaniakielârwasandawejakutkielâsamburukielâsan" +
			"talikielângambaysangusisiliakielâskootikielâsenakoyraboro sennitašel" +
			"hitshankielâmaadâsämikielâjuulevsämikielâanarâškielânuorttâlâškielâs" +
			"oninkesranantongosahosukumakielâkomorikielâsyyriakielâtemnekielâates" +
			"otetumtigrekielâklingonkielâtok pisintarokotumbukakielâtuvalukielâta" +
			"sawaqtuvakielâKoskâatlas tamazightudmurtkielâumbunduruotâsvaikielâve" +
			"psäkielâvunjowalliskielâwolaitakielâwaraykielâkalmukkielâsogayangben" +
			"yembakantonkielâstandard tamazightzunikielâij kielâlâš siskáldâszaza" +
			"kielâstandard arabiakielâNuorttâriijkâ saksakielâSveitsi pajesaksaki" +
			"elâAustralia eŋgâlâskielâKanada eŋgâlâskielâBritannia eŋgâlâskielâAm" +
			"erika eŋgâlâskielâLäättin-Amerika espanjakielâEspanja espanjakielâMe" +
			"ksiko espanjakielâKanada ranskakielâSveitsi ranskakielâVuáládâhenâmi" +
			"j saksakielâhollandkielâ (flaami)Brasilia portugalkielâPortugal port" +
			"ugalkielâKongo swahilikielâoovtâkiärdánis kiinakielâärbivuáválâš kii" +
			"nakielâ",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0004, 0x0011, 0x0011, 0x001a, 0x0024, 0x0030, 0x003e,
			0x004a, 0x0055, 0x005f, 0x006b, 0x007d, 0x008a, 0x009e, 0x00ac,
			0x00b3, 0x00c0, 0x00cc, 0x00d8, 0x00e4, 0x00f0, 0x00fd, 0x010c,
			0x011a, 0x0127, 0x0127, 0x0134, 0x0140, 0x014d, 0x0158, 0x0164,
			0x016f, 0x017b, 0x0183, 0x018c, 0x0198, 0x01a8, 0x01b7, 0x01c4,
			0x01cf, 0x01da, 0x01e6, 0x01f0, 0x01fc, 0x0208, 0x0215, 0x0221,
			0x022f, 0x0239, 0x0250, 0x025d, 0x026a, 0x027a, 0x027f, 0x028a,
			0x0296, 0x02a1, 0x02a1, 0x02ae, 0x02ba, 0x02c6, 0x02d3, 0x02df,
			// Entry 40 - 7F
			0x02ea, 0x02f9, 0x02f9, 0x0303, 0x0303, 0x0303, 0x0306, 0x0312,
			0x031e, 0x0327, 0x0334, 0x033f, 0x034c, 0x034c, 0x0358, 0x0360,
			0x036b, 0x0376, 0x0381, 0x0388, 0x0393, 0x039f, 0x03ac, 0x03b7,
			0x03c1, 0x03cc, 0x03d8, 0x03e7, 0x03f6, 0x03fd, 0x040a, 0x0411,
			0x041a, 0x0427, 0x0432, 0x043e, 0x044b, 0x0459, 0x0464, 0x0473,
			0x047a, 0x0488, 0x0495, 0x049c, 0x04a7, 0x04b2, 0x04bd, 0x04c9,
			0x04d4, 0x04da, 0x04e7, 0x04fa, 0x050d, 0x051b, 0x0527, 0x052e,
			0x0535, 0x0535, 0x0540, 0x0545, 0x0550, 0x0559, 0x0559, 0x0564,
			// Entry 80 - BF
			0x056a, 0x0578, 0x057f, 0x0590, 0x0595, 0x05a2, 0x05af, 0x05bb,
			0x05c3, 0x05d1, 0x05d7, 0x05e1, 0x05e6, 0x05ed, 0x05fb, 0x0609,
			0x0614, 0x0619, 0x0625, 0x0632, 0x063e, 0x0649, 0x0654, 0x065f,
			0x066b, 0x0678, 0x0683, 0x0689, 0x0696, 0x06a0, 0x06ae, 0x06bb,
			0x06c7, 0x06d2, 0x06de, 0x06ea, 0x06f5, 0x0701, 0x070c, 0x0719,
			0x071d, 0x0728, 0x0733, 0x0740, 0x0748, 0x0755, 0x0760, 0x076b,
			0x0772, 0x077e, 0x077e, 0x0791, 0x079b, 0x07a7, 0x07a7, 0x07ae,
			0x07b3, 0x07b3, 0x07b3, 0x07b8, 0x07c2, 0x07c2, 0x07c2, 0x07cd,
			// Entry C0 - FF
			0x07cd, 0x07de, 0x07de, 0x07e4, 0x07e4, 0x07ee, 0x07ee, 0x07fb,
			0x07fb, 0x07fb, 0x07fb, 0x07fb, 0x07fb, 0x0804, 0x0804, 0x0811,
			0x0811, 0x081d, 0x081d, 0x0827, 0x0827, 0x0832, 0x0832, 0x0832,
			0x0832, 0x0832, 0x083d, 0x083d, 0x0847, 0x0847, 0x0847, 0x0847,
			0x0856, 0x0856, 0x0860, 0x0860, 0x0860, 0x086d, 0x086d, 0x086d,
			0x086d, 0x086d, 0x0877, 0x0877, 0x0877, 0x0881, 0x0881, 0x088b,
			0x088b, 0x088b, 0x088b, 0x088b, 0x088b, 0x0898, 0x08a2, 0x08a2,
			0x08a2, 0x08ad, 0x08b7, 0x08b7, 0x08c4, 0x08c4, 0x08d2, 0x08e0,
			// Entry 100 - 13F
			0x08f2, 0x08f2, 0x08f2, 0x08f2, 0x0909, 0x0909, 0x0915, 0x0920,
			0x092b, 0x092b, 0x092b, 0x0937, 0x0937, 0x0942, 0x0942, 0x094c,
			0x094c, 0x0957, 0x0957, 0x0961, 0x0961, 0x096b, 0x0975, 0x097f,
			0x097f, 0x097f, 0x0985, 0x0985, 0x0985, 0x0985, 0x0991, 0x0991,
			0x0991, 0x099f, 0x099f, 0x09a8, 0x09a8, 0x09a8, 0x09a8, 0x09a8,
			0x09a8, 0x09a8, 0x09b4, 0x09bc, 0x09bc, 0x09bc, 0x09bc, 0x09bc,
			0x09bc, 0x09c3, 0x09d1, 0x09d1, 0x09d1, 0x09d1, 0x09d1, 0x09d1,
			0x09e0, 0x09e0, 0x09e0, 0x09f6, 0x0a09, 0x0a09, 0x0a09, 0x0a14,
			// Entry 140 - 17F
			0x0a24, 0x0a24, 0x0a24, 0x0a31, 0x0a31, 0x0a40, 0x0a40, 0x0a4b,
			0x0a54, 0x0a54, 0x0a5e, 0x0a68, 0x0a74, 0x0a7b, 0x0a87, 0x0a87,
			0x0a87, 0x0a8d, 0x0a93, 0x0a9a, 0x0a9a, 0x0a9a, 0x0a9a, 0x0a9a,
			0x0aa5, 0x0aab, 0x0aae, 0x0ab9, 0x0ab9, 0x0ac6, 0x0ac6, 0x0aca,
			0x0ad1, 0x0ae1, 0x0ae1, 0x0ae5, 0x0ae5, 0x0aea, 0x0aea, 0x0af6,
			0x0af6, 0x0af6, 0x0afa, 0x0b07, 0x0b0f, 0x0b0f, 0x0b16, 0x0b16,
			0x0b22, 0x0b37, 0x0b37, 0x0b37, 0x0b44, 0x0b50, 0x0b58, 0x0b5d,
			0x0b68, 0x0b73, 0x0b73, 0x0b7f, 0x0b8a, 0x0b8a, 0x0b8a, 0x0b95,
			// Entry 180 - 1BF
			0x0b95, 0x0b95, 0x0b95, 0x0ba1, 0x0ba1, 0x0ba1, 0x0ba5, 0x0bad,
			0x0bad, 0x0bb6, 0x0bb6, 0x0bbb, 0x0bbe, 0x0bc3, 0x0bc8, 0x0bc8,
			0x0bc8, 0x0bd4, 0x0bd4, 0x0bda, 0x0be2, 0x0be9, 0x0be9, 0x0bf4,
			0x0bf4, 0x0c00, 0x0c00, 0x0c0b, 0x0c15, 0x0c1d, 0x0c1d, 0x0c29,
			0x0c30, 0x0c36, 0x0c41, 0x0c41, 0x0c49, 0x0c55, 0x0c5a, 0x0c66,
			0x0c6d, 0x0c7b, 0x0c89, 0x0c97, 0x0c97, 0x0c97, 0x0c97, 0x0ca2,
			0x0cad, 0x0cad, 0x0cb9, 0x0cbd, 0x0cbd, 0x0cc3, 0x0ccd, 0x0cd7,
			0x0cd7, 0x0cdd, 0x0ce6, 0x0cf1, 0x0d06, 0x0d06, 0x0d0c, 0x0d15,
			// Entry 1C0 - 1FF
			0x0d19, 0x0d19, 0x0d19, 0x0d27, 0x0d27, 0x0d27, 0x0d27, 0x0d27,
			0x0d37, 0x0d37, 0x0d45, 0x0d4f, 0x0d5a, 0x0d5a, 0x0d68, 0x0d68,
			0x0d68, 0x0d68, 0x0d68, 0x0d68, 0x0d68, 0x0d68, 0x0d68, 0x0d7f,
			0x0d7f, 0x0d8a, 0x0d8a, 0x0d8a, 0x0d91, 0x0d9a, 0x0d9a, 0x0d9a,
			0x0d9f, 0x0dac, 0x0dac, 0x0dac, 0x0dac, 0x0dba, 0x0dbd, 0x0dc4,
			0x0dcf, 0x0dcf, 0x0ddc, 0x0ddc, 0x0de9, 0x0de9, 0x0df0, 0x0df5,
			0x0e02, 0x0e0e, 0x0e0e, 0x0e0e, 0x0e0e, 0x0e12, 0x0e12, 0x0e12,
			0x0e21, 0x0e21, 0x0e21, 0x0e2a, 0x0e34, 0x0e34, 0x0e34, 0x0e34,
			// Entry 200 - 23F
			0x0e34, 0x0e45, 0x0e56, 0x0e64, 0x0e77, 0x0e7e, 0x0e7e, 0x0e89,
			0x0e89, 0x0e8d, 0x0e8d, 0x0e99, 0x0e99, 0x0e99, 0x0ea5, 0x0ea5,
			0x0eb1, 0x0eb1, 0x0eb1, 0x0ebc, 0x0ec1, 0x0ec1, 0x0ec6, 0x0ed1,
			0x0ed1, 0x0ed1, 0x0ed1, 0x0ede, 0x0ede, 0x0ede, 0x0ede, 0x0ede,
			0x0ee7, 0x0ee7, 0x0eed, 0x0eed, 0x0eed, 0x0eed, 0x0efa, 0x0f06,
			0x0f0d, 0x0f17, 0x0f2c, 0x0f38, 0x0f38, 0x0f3f, 0x0f46, 0x0f4f,
			0x0f4f, 0x0f5b, 0x0f5b, 0x0f5b, 0x0f5b, 0x0f5b, 0x0f60, 0x0f6c,
			0x0f79, 0x0f84, 0x0f84, 0x0f84, 0x0f84, 0x0f90, 0x0f90, 0x0f94,
			// Entry 240 - 27F
			0x0f94, 0x0f94, 0x0f9b, 0x0fa0, 0x0fa0, 0x0fac, 0x0fac, 0x0fac,
			0x0fac, 0x0fac, 0x0fbe, 0x0fc8, 0x0fe2, 0x0fec, 0x1001, 0x1001,
			0x101c, 0x1033, 0x104d, 0x1064, 0x107e, 0x1096, 0x10b5, 0x10ca,
			0x10df, 0x10df, 0x10f2, 0x1106, 0x1124, 0x113a, 0x1151, 0x1168,
			0x1168, 0x1168, 0x117b, 0x1198, 0x11b5,
		},
	},
	{ // sn
		"chiAkanichiAmaricchiArabuchiBelarusichiBulgarianchiBengalichiCzechchiJer" +
			"imanichiGreekChirunguchiSpanishchiPeshiyachiFurenchichiHausachiHindi" +
			"chiHungarichiIndonesiachiIgbochiTarianachiJapanichiJavachiKhemachiKo" +
			"riachiMalaychiBurmachiNepalichiDutchchiPunjabichiPolishchiPutukezich" +
			"iRomanianchiRashiyachiRwandachiShonachiSomalichiSwedishchiTamilchiTh" +
			"aichiTurkishchiUkreniachiUrduchiVietnamchiYorubachiChinesechiZulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a, 0x003a,
			0x003a, 0x003a, 0x003a, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0055, 0x005d, 0x005d, 0x0067,
			0x0067, 0x0067, 0x0071, 0x0071, 0x0071, 0x0071, 0x0071, 0x007c,
			0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x007c, 0x0084,
			0x0084, 0x008c, 0x008c, 0x008c, 0x008c, 0x0096, 0x0096, 0x0096,
			// Entry 40 - 7F
			0x0096, 0x00a2, 0x00a2, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
			0x00b3, 0x00b3, 0x00bc, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00c3, 0x00cb, 0x00cb, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3, 0x00d3,
			0x00d3, 0x00d3, 0x00d3, 0x00db, 0x00db, 0x00e3, 0x00e3, 0x00e3,
			0x00ec, 0x00ec, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00fe, 0x00fe, 0x0107,
			// Entry 80 - BF
			0x0107, 0x0112, 0x0112, 0x0112, 0x0112, 0x011d, 0x0127, 0x0130,
			0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130,
			0x0130, 0x0138, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
			0x014b, 0x014b, 0x0153, 0x0153, 0x0153, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x017f, 0x017f, 0x017f, 0x017f, 0x017f,
			0x017f, 0x0188, 0x0188, 0x0192, 0x0199,
		},
	},
	{ // so
		"AkanAxmaariCarabiBeleruusiyaanBulgeeriyaanBangaaliJeegJarmalGiriikIngiri" +
			"isiIsbaanishFaarisiFaransiisFiriisiyan GalbeedHawsaHindiHangariyaanI" +
			"ndunuusiyaanIgboTalyaaniJabbaaniisJafaaniisKamboodhianKuuriyaanMalaa" +
			"yBurmeseNebaaliHolandaysBunjaabiBoolishBoortaqiisRomankaRuushRwandaS" +
			"oomaaliSwiidhisTamiilTaaylandaysTurkishYukreeniyaanUrduuFiitnaamaysY" +
			"oruubaJayniisZuulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0004, 0x000b, 0x000b,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x001e, 0x002a,
			0x002a, 0x002a, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0036, 0x0036, 0x0036, 0x0036, 0x0036,
			0x003c, 0x003c, 0x003c, 0x003c, 0x0042, 0x004b, 0x004b, 0x0054,
			0x0054, 0x0054, 0x005b, 0x005b, 0x005b, 0x005b, 0x005b, 0x0064,
			0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x007b,
			0x007b, 0x0080, 0x0080, 0x0080, 0x0080, 0x008b, 0x008b, 0x008b,
			// Entry 40 - 7F
			0x008b, 0x0098, 0x0098, 0x009c, 0x009c, 0x009c, 0x009c, 0x009c,
			0x00a4, 0x00a4, 0x00ae, 0x00b7, 0x00b7, 0x00b7, 0x00b7, 0x00b7,
			0x00b7, 0x00b7, 0x00c2, 0x00c2, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb, 0x00cb,
			0x00cb, 0x00cb, 0x00cb, 0x00d1, 0x00d1, 0x00d8, 0x00d8, 0x00d8,
			0x00df, 0x00df, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
			0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00f0, 0x00f0, 0x00f7,
			// Entry 80 - BF
			0x00f7, 0x0101, 0x0101, 0x0101, 0x0101, 0x0108, 0x010d, 0x0113,
			0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113, 0x0113,
			0x0113, 0x0113, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b, 0x011b,
			0x0123, 0x0123, 0x0129, 0x0129, 0x0129, 0x0134, 0x0134, 0x0134,
			0x0134, 0x0134, 0x013b, 0x013b, 0x013b, 0x013b, 0x013b, 0x0147,
			0x014c, 0x014c, 0x014c, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157,
			0x0157, 0x015e, 0x015e, 0x0165, 0x016a,
		},
	},
	{ // sq
		sqLangStr,
		sqLangIdx,
	},
	{ // sr
		srLangStr,
		srLangIdx,
	},
	{ // sr-Cyrl-BA
		"бјелорускибамананканбанглахаићански креолскилаошкисинхалскиисикосаисизул" +
			"умапудунгуншвајцарски немачкимохокн’којужни шилхацентралноатласки т" +
			"амашекстандардни марокански тамашек",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014,
			0x0014, 0x0028, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0057, 0x0057, 0x0057, 0x0057,
			// Entry 40 - 7F
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			// Entry 80 - BF
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0083,
			0x0083, 0x0083, 0x0083, 0x0083, 0x0091, 0x0091, 0x0091, 0x0091,
			0x0091, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091, 0x0091,
			// Entry C0 - FF
			0x0091, 0x0091, 0x0091, 0x0091, 0x0091, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			// Entry 100 - 13F
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00a5, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			// Entry 140 - 17F
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			// Entry 180 - 1BF
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
			0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00db, 0x00db,
			// Entry 1C0 - 1FF
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			// Entry 200 - 23F
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0, 0x00f0,
			0x00f0, 0x00f0, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f,
			0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f,
			0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f,
			// Entry 240 - 27F
			0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f, 0x011f,
			0x011f, 0x011f, 0x0157,
		},
	},
	{ // sr-Cyrl-ME
		"бјелорускибамананканбанглафулаххаићански креолскилаошкиисикосаисизулумап" +
			"удунгунмохокн’којужни шилхацентралноатласки тамашекстандардни марок" +
			"ански тамашек",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0014,
			0x0014, 0x0028, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x0061, 0x0061, 0x0061, 0x0061,
			// Entry 40 - 7F
			0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061,
			0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061,
			0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061,
			0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061, 0x0061,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			// Entry 80 - BF
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d,
			0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x006d, 0x007b,
			0x007b, 0x007b, 0x007b, 0x007b, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry C0 - FF
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			// Entry 100 - 13F
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			// Entry 140 - 17F
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			// Entry 180 - 1BF
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x009d,
			0x009d, 0x009d, 0x009d, 0x009d, 0x009d, 0x00a7, 0x00a7, 0x00a7,
			0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00b0, 0x00b0,
			// Entry 1C0 - 1FF
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00b0, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			// Entry 200 - 23F
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			// Entry 240 - 27F
			0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4, 0x00f4,
			0x00f4, 0x00f4, 0x012c,
		},
	},
	{ // sr-Cyrl-XK
		"бамананканбанглафулаххаићански креолскилаошкисинхалскиисикосаисизулушвај" +
			"царски немачкимохокн’којужни шилхацентралноатласки тамашекстандардн" +
			"и марокански тамашек",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0014, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
			0x0020, 0x0020, 0x0020, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x004d, 0x004d, 0x004d, 0x004d,
			// Entry 40 - 7F
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d, 0x004d,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			// Entry 80 - BF
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b,
			0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x006b, 0x0079,
			0x0079, 0x0079, 0x0079, 0x0079, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			// Entry C0 - FF
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			// Entry 100 - 13F
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087, 0x0087,
			0x0087, 0x0087, 0x0087, 0x0087, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			// Entry 140 - 17F
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			// Entry 180 - 1BF
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
			0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00bd, 0x00bd,
			// Entry 1C0 - 1FF
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd, 0x00bd,
			0x00bd, 0x00bd, 0x00bd, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			// Entry 200 - 23F
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2, 0x00d2,
			0x00d2, 0x00d2, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			// Entry 240 - 27F
			0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101, 0x0101,
			0x0101, 0x0101, 0x0139,
		},
	},
	{ // sr-Latn
		srLatnLangStr,
		srLatnLangIdx,
	},
	{ // sr-Latn-BA
		"bjeloruskibamanankanbanglahaićanski kreolskilaoškisinhalskiisikosaisizul" +
			"umapudungunšvajcarski nemačkimohokn’kojužni šilhacentralnoatlaski ta" +
			"mašekstandardni marokanski tamašek",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x000a,
			0x000a, 0x0014, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x002d, 0x002d, 0x002d, 0x002d,
			// Entry 40 - 7F
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			// Entry 80 - BF
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d,
			0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x003d, 0x0044,
			0x0044, 0x0044, 0x0044, 0x0044, 0x004b, 0x004b, 0x004b, 0x004b,
			0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x004b,
			// Entry C0 - FF
			0x004b, 0x004b, 0x004b, 0x004b, 0x004b, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			// Entry 100 - 13F
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055, 0x0055,
			0x0055, 0x0055, 0x0055, 0x0055, 0x0069, 0x0069, 0x0069, 0x0069,
			// Entry 140 - 17F
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			// Entry 180 - 1BF
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x006e, 0x006e, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0074, 0x0074,
			// Entry 1C0 - 1FF
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074, 0x0074,
			0x0074, 0x0074, 0x0074, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			// Entry 200 - 23F
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			// Entry 240 - 27F
			0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a, 0x009a,
			0x009a, 0x009a, 0x00b8,
		},
	},
	{ // sr-Latn-ME
		"bjeloruskibamanankanbanglafulahhaićanski kreolskilaoškiisikosaisizulumap" +
			"udungunmohokn’kojužni šilhacentralnoatlaski tamašekstandardni maroka" +
			"nski tamašek",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x000a,
			0x000a, 0x0014, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
			0x001a, 0x001a, 0x001a, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f, 0x001f,
			0x001f, 0x001f, 0x001f, 0x001f, 0x0032, 0x0032, 0x0032, 0x0032,
			// Entry 40 - 7F
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032, 0x0032,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			// Entry 80 - BF
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0040,
			0x0040, 0x0040, 0x0040, 0x0040, 0x0047, 0x0047, 0x0047, 0x0047,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
			// Entry C0 - FF
			0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			// Entry 100 - 13F
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			// Entry 140 - 17F
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			// Entry 180 - 1BF
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0056, 0x0056, 0x0056,
			0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056,
			0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056,
			0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x0056, 0x005c, 0x005c,
			// Entry 1C0 - 1FF
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c, 0x005c,
			0x005c, 0x005c, 0x005c, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			// Entry 200 - 23F
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
			0x0069, 0x0069, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			// Entry 240 - 27F
			0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082, 0x0082,
			0x0082, 0x0082, 0x00a0,
		},
	},
	{ // sr-Latn-XK
		"bamanankanbanglafulahhaićanski kreolskilaoškisinhalskiisikosaisizulušvaj" +
			"carski nemačkimohokn’kojužni šilhacentralnoatlaski tamašekstandardni" +
			" marokanski tamašek",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x000a, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0028, 0x0028, 0x0028, 0x0028,
			// Entry 40 - 7F
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			// Entry 80 - BF
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x002f,
			0x002f, 0x002f, 0x002f, 0x002f, 0x002f, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x003f,
			0x003f, 0x003f, 0x003f, 0x003f, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			// Entry C0 - FF
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			// Entry 100 - 13F
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046, 0x0046,
			0x0046, 0x0046, 0x0046, 0x0046, 0x005a, 0x005a, 0x005a, 0x005a,
			// Entry 140 - 17F
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			// Entry 180 - 1BF
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005f, 0x005f, 0x005f,
			0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f,
			0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f,
			0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x005f, 0x0065, 0x0065,
			// Entry 1C0 - 1FF
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			// Entry 200 - 23F
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x0072, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b,
			0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b,
			0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b,
			// Entry 240 - 27F
			0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b,
			0x008b, 0x008b, 0x00a9,
		},
	},
	{ // sv
		svLangStr,
		svLangIdx,
	},
	{ // sv-FI
		"kirgiziska",
		[]uint16{ // 91 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			// Entry 40 - 7F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x000a,
		},
	},
	{ // sw
		swLangStr,
		swLangIdx,
	},
	{ // sw-CD
		"KiakanKiazabajaniKimanksiKikirigiziKilimburgiKimasedoniaKiyidiKiarabu ch" +
			"a AljeriaKibuginiKigwichiinKihupaKiingushKilojbanKikachinKikoyra Chi" +
			"iniKikakoKikomipermyakKikurukhKikumykKilambamakKimokshaKimikmakiKimo" +
			"hokiKimossiKingiemboonKiinkoPijini ya NijeriaKikiicheKiarabu cha Cha" +
			"diKitongo cha SrananKikomoroKisiriaKiudumurtiKirootKiwalserKiarabu c" +
			"ha Dunia Kilichosanifishwa",
		[]uint16{ // 591 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011,
			0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0011, 0x0019, 0x0019,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019,
			// Entry 40 - 7F
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019,
			0x0019, 0x0019, 0x0023, 0x0023, 0x0023, 0x0023, 0x002d, 0x002d,
			0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x002d, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			// Entry 80 - BF
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			// Entry C0 - FF
			0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e, 0x003e,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0051,
			0x0051, 0x0051, 0x0051, 0x0051, 0x0051, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			// Entry 100 - 13F
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059, 0x0059,
			// Entry 140 - 17F
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0069, 0x0069, 0x0069, 0x0069, 0x0071, 0x0071,
			0x0071, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079,
			0x0079, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081,
			0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x0081, 0x008f,
			0x008f, 0x008f, 0x0095, 0x0095, 0x0095, 0x00a2, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00a2, 0x00aa, 0x00aa, 0x00aa,
			0x00aa, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b8, 0x00b8,
			// Entry 180 - 1BF
			0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8,
			0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00b8, 0x00bb, 0x00bb, 0x00bb,
			0x00bb, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00c3,
			0x00c3, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00d4, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00e6, 0x00e6, 0x00e6, 0x00e6, 0x00ec, 0x00ec,
			// Entry 1C0 - 1FF
			0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec,
			0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00ec, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0105,
			0x0105, 0x0105, 0x0105, 0x0105, 0x0105, 0x0116, 0x0116, 0x0116,
			// Entry 200 - 23F
			0x0116, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116, 0x0116, 0x0128,
			0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0128, 0x0130, 0x0130,
			0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137, 0x0137,
			0x0137, 0x0137, 0x0137, 0x0141, 0x0141, 0x0141, 0x0147, 0x0147,
			0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x014f,
			0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f,
			// Entry 240 - 27F
			0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f,
			0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x0172,
		},
	},
	{ // sw-KE
		"KitwiKiazabajaniKilimbugishKimasedoniaKiodiaKiwaloonainKiarabu cha Aljer" +
			"iaKibuginiKikurdi cha KatiKisorbian cha ChiniKigiriki cha KaleKisorb" +
			"ia cha JuuKingushiKilojbaniKikachinKikoyra ChiiniKikakoKikomipermyak" +
			"KikurukhKilambaKimokshaKimicmacKimohokiKiingiemboonKiin’koPijini ya " +
			"NijeriascoKikoyraboro SenniKiarabu cha ChadiKiscran TongoKicomoroKis" +
			"yriaLugha ya Central Atlas TamazightKiudumurtiKirootKiwalserTamazigh" +
			"t Sanifu ya MorokoKiarabu cha Sasa Kilichosanifishwa",
		[]uint16{ // 591 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x0005, 0x0005,
			0x0005, 0x0005, 0x0005, 0x0005, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			// Entry 40 - 7F
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010,
			0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x001b, 0x001b,
			0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x001b, 0x0026,
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
			0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
			0x0026, 0x0026, 0x0026, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			// Entry 80 - BF
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x002c,
			0x002c, 0x002c, 0x002c, 0x002c, 0x002c, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0034, 0x0037, 0x0037, 0x0037, 0x0037,
			// Entry C0 - FF
			0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037, 0x0037,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x004a,
			0x004a, 0x004a, 0x004a, 0x004a, 0x004a, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052, 0x0052,
			// Entry 100 - 13F
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062,
			0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0062, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			// Entry 140 - 17F
			0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086, 0x0086,
			0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096, 0x009e, 0x009e,
			0x009e, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00a7, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af,
			0x00af, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af, 0x00bd,
			0x00bd, 0x00bd, 0x00c3, 0x00c3, 0x00c3, 0x00d0, 0x00d0, 0x00d0,
			0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00df, 0x00df,
			// Entry 180 - 1BF
			0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df, 0x00df,
			0x00df, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
			0x00f7, 0x00f7, 0x0103, 0x0103, 0x0103, 0x0103, 0x010c, 0x010c,
			// Entry 1C0 - 1FF
			0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c,
			0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x010c, 0x011d, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d, 0x011d,
			0x011d, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120, 0x0120,
			0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0142, 0x0142, 0x0142,
			// Entry 200 - 23F
			0x0142, 0x0142, 0x0142, 0x0142, 0x0142, 0x0142, 0x0142, 0x014f,
			0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x014f, 0x0157, 0x0157,
			0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e, 0x015e,
			0x015e, 0x015e, 0x017e, 0x0188, 0x0188, 0x0188, 0x018e, 0x018e,
			0x018e, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e, 0x0196,
			0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196,
			// Entry 240 - 27F
			0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196, 0x0196,
			0x0196, 0x0196, 0x01b0, 0x01b0, 0x01b0, 0x01b0, 0x01d2,
		},
	},
	{ // ta
		taLangStr,
		taLangIdx,
	},
	{ // te
		teLangStr,
		teLangIdx,
	},
	{ // teo
		"KiakanKiamhariKiarabuKibelarusiKibulgariaKibanglaKicheckiKijerumaniKigir" +
			"ikiKingerezaKihispaniaKiajemiKifaransaKihausaKihindiKihungariKiindon" +
			"esiaKiigboKiitalianoKijapaniKijavaKikambodiaKikoreaKimalesiaKiburmaK" +
			"inepaliKiholanziKipunjabiKipolandiKirenoKiromaniaKirusiKinyarwandaKi" +
			"somaliKiswidiKitamilKitailandiKiturukiKiukraniaKiurduKivietinamuKiyo" +
			"rubaKichinaKizuluKiteso",
		[]uint16{ // 533 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006, 0x000e, 0x000e,
			0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x0015, 0x001f, 0x0029,
			0x0029, 0x0029, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031, 0x0031,
			0x0031, 0x0031, 0x0031, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0043, 0x0043, 0x0043, 0x0043, 0x004b, 0x0054, 0x0054, 0x005e,
			0x005e, 0x005e, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006e,
			0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x006e, 0x0075,
			0x0075, 0x007c, 0x007c, 0x007c, 0x007c, 0x0085, 0x0085, 0x0085,
			// Entry 40 - 7F
			0x0085, 0x0090, 0x0090, 0x0096, 0x0096, 0x0096, 0x0096, 0x0096,
			0x00a0, 0x00a0, 0x00a8, 0x00ae, 0x00ae, 0x00ae, 0x00ae, 0x00ae,
			0x00ae, 0x00ae, 0x00b8, 0x00b8, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00bf, 0x00c8, 0x00c8, 0x00cf, 0x00cf, 0x00cf,
			0x00d7, 0x00d7, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e9, 0x00e9, 0x00f2,
			// Entry 80 - BF
			0x00f2, 0x00f8, 0x00f8, 0x00f8, 0x00f8, 0x0101, 0x0107, 0x0112,
			0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112, 0x0112,
			0x0112, 0x0112, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a, 0x011a,
			0x0121, 0x0121, 0x0128, 0x0128, 0x0128, 0x0132, 0x0132, 0x0132,
			0x0132, 0x0132, 0x013a, 0x013a, 0x013a, 0x013a, 0x013a, 0x0143,
			0x0149, 0x0149, 0x0149, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
			0x0154, 0x015c, 0x015c, 0x0163, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry C0 - FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 100 - 13F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 140 - 17F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 180 - 1BF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 1C0 - 1FF
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			// Entry 200 - 23F
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169,
			0x0169, 0x0169, 0x0169, 0x0169, 0x016f,
		},
	},
	{ // th
		thLangStr,
		thLangIdx,
	},
	{ // ti
		"አፍሪቃንሰኛትዊአምሐረኛዓረበኛአዜርባይጃንኛቤላራሻኛቡልጋሪኛበንጋሊኛብሬቶንቦስኒያንካታላንቼክኛወልሽዴኒሽጀርመንግሪከኛእ" +
			"ንግሊዝኛኤስፐራንቶስፓኒሽኤስቶኒአንባስክኛፐርሲያኛፊኒሽፋሮኛፈረንሳይኛፍሪሰኛአይሪሽእስኮትስ ጌልክኛጋለቪኛጓራ" +
			"ኒጉጃራቲኛዕብራስጥሕንደኛክሮሽያንኛሀንጋሪኛኢንቴር ቋንቋእንዶኑሲኛአይስላንደኛጣሊያንኛጃፓንኛጃቫንኛጊዮርጊያኛ" +
			"ካማደኛኮሪያኛኩርድሽኪሩጋዚላቲንኛሊቱአኒየንላቲቪያንማክዶኒኛማላያላምኛማራቲኛማላይኛማልቲስኛኔፖሊኛደችኖርዌይኛ" +
			" (ናይ ኝኖርስክ)ኖርዌጂያንኦኪታንኛኦሪያፑንጃቢኛፖሊሽፓሽቶፖርቱጋሊኛሮማኒያንራሽኛስንሃልኛስሎቨክኛስቁቪኛአልቤኒ" +
			"ኛሰርቢኛሰሴቶሱዳንኛስዊድንኛሰዋሂሊኛታሚልኛተሉጉኛታይኛትግርኛናይ ቱርኪ ሰብዓይ (ቱርካዊ)ቱርከኛዩክረኒኛኡር" +
			"ዱኛኡዝበክኛቪትናምኛዞሳኛዪዲሽዙሉኛታጋሎገኛክሊንግኦንኛፖርቱጋልኛ (ናይ ብራዚል)ፖርቱጋልኛ (ናይ ፖርቱጋል)" +
			"ሰርቦ- ክሮዊታን",
		[]uint16{ // 610 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0015, 0x001b, 0x002a, 0x002a,
			0x0036, 0x0036, 0x0036, 0x0036, 0x004e, 0x004e, 0x005d, 0x006c,
			0x006c, 0x006c, 0x007b, 0x007b, 0x0087, 0x0096, 0x00a2, 0x00a2,
			0x00a2, 0x00a2, 0x00a2, 0x00ab, 0x00ab, 0x00ab, 0x00b4, 0x00bd,
			0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00d5, 0x00e7, 0x00f9, 0x0105,
			0x0117, 0x0123, 0x0132, 0x0132, 0x013b, 0x013b, 0x0144, 0x0156,
			0x0162, 0x016e, 0x018a, 0x0196, 0x019f, 0x01ae, 0x01ae, 0x01ae,
			0x01bd, 0x01c9, 0x01c9, 0x01db, 0x01db, 0x01ea, 0x01ea, 0x01ea,
			// Entry 40 - 7F
			0x0200, 0x0212, 0x0212, 0x0212, 0x0212, 0x0212, 0x0212, 0x0227,
			0x0236, 0x0236, 0x0242, 0x024e, 0x0260, 0x0260, 0x0260, 0x0260,
			0x0260, 0x0260, 0x0260, 0x026c, 0x0278, 0x0278, 0x0278, 0x0284,
			0x0284, 0x0284, 0x0290, 0x029c, 0x029c, 0x029c, 0x029c, 0x029c,
			0x029c, 0x02ae, 0x02ae, 0x02bd, 0x02bd, 0x02bd, 0x02bd, 0x02cc,
			0x02de, 0x02de, 0x02ea, 0x02f6, 0x0305, 0x0305, 0x0305, 0x0305,
			0x0311, 0x0311, 0x0317, 0x033f, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0360, 0x0360, 0x0360, 0x0369, 0x0369, 0x0378, 0x0378, 0x0381,
			// Entry 80 - BF
			0x038a, 0x039c, 0x039c, 0x039c, 0x039c, 0x03ab, 0x03b4, 0x03b4,
			0x03b4, 0x03b4, 0x03b4, 0x03b4, 0x03b4, 0x03c3, 0x03d2, 0x03de,
			0x03de, 0x03de, 0x03de, 0x03ed, 0x03f9, 0x03f9, 0x0402, 0x040e,
			0x041d, 0x042c, 0x0438, 0x0444, 0x0444, 0x044d, 0x0459, 0x0485,
			0x0485, 0x0485, 0x0491, 0x0491, 0x0491, 0x0491, 0x0491, 0x04a0,
			0x04ac, 0x04bb, 0x04bb, 0x04ca, 0x04ca, 0x04ca, 0x04ca, 0x04d3,
			0x04dc, 0x04dc, 0x04dc, 0x04dc, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			// Entry C0 - FF
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			// Entry 100 - 13F
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5, 0x04e5,
			0x04e5, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 140 - 17F
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 180 - 1BF
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 1C0 - 1FF
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			// Entry 200 - 23F
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4, 0x04f4,
			0x04f4, 0x04f4, 0x04f4, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			// Entry 240 - 27F
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509,
			0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0509, 0x0531, 0x055c,
			0x055c, 0x0576,
		},
	},
	{ // to
		"lea fakaʻafālalea fakaʻapakasialea fakaʻavesitanilea fakaʻafilikanalea f" +
			"akaʻakanilea fakaʻamelikilea fakaʻalakonilea fakaʻalepealea fakaʻasa" +
			"mialea fakaʻavalikilea fakaʻaimalalea fakaʻasapaisanilea fakapasikil" +
			"ilea fakapelalusilea fakapulukalialea fakapisilamalea fakapamipalale" +
			"a fakapengikalilea fakatipetilea fakapeletonilea fakaposinialea faka" +
			"katalanilea fakaseselea fakakamololea fakakōsikalea fakakelīlea faka" +
			"sekilea fakasilavia-fakasiasilea fakasuvasalea fakauēlesilea fakaten" +
			"imaʻakelea fakasiamanelea fakativehilea fakatisōngikalea fakaʻeuelea" +
			" fakakalisilea fakapālangilea fakaʻesipulanitolea fakasipēnisilea fa" +
			"kaʻesitōnialea fakapāsikilea fakapēsialea fakafulālea fakafinilanile" +
			"a fakafisilea fakafaloelea fakafalanisēlea fakafilisia-hihifolea fak" +
			"aʻaelanilea fakakaelikilea fakakalisialea fakakualanilea fakakutalat" +
			"ilea fakamangikīlea fakahausalea fakahepelūlea fakahinitīlea fakahil" +
			"i-motulea fakakuloisialea fakahaitilea fakahungakalialea fakaʻāmenia" +
			"lea fakahelelolea fakavahaʻalealea fakaʻinitōnesialea fakavahaʻaling" +
			"ikēlea fakaʻikipōlea fakasisiuani-īlea fakaʻinupiakilea fakaʻitolea " +
			"fakaʻaisilanilea fakaʻītalilea fakaʻinuketitutilea fakasiapanilea fa" +
			"kasavalea fakaseōsialea fakakongikōlea fakakikuiulea fakakuaniamalea" +
			" fakakasakilea fakakalaʻalisutilea fakakamipōtialea fakakanatalea fa" +
			"kakōlealea fakakanulilea fakakāsimilalea fakakulitīlea fakakomilea f" +
			"akakoniualilea fakakīsisilea fakalatinalea fakalakisimipekilea fakak" +
			"anitalea fakalimipūlikilea lingikalalea fakalaulea fakalituanialea f" +
			"akalupa-katangalea fakalativialea fakamalakasilea fakamāsololea faka" +
			"maulilea fakamasitōnialea fakaʻinitia-malāialamilea fakamongokōliale" +
			"a fakamalatilea fakamaleilea fakamalitalea fakapemalea fakanaululea " +
			"fakanetepele-tokelaulea fakanepalilea fakanetongikālea fakahōlanilea" +
			" fakanoauē-ninosikilea fakanouaē-pokimalilea fakanetepele-tongalea f" +
			"akanavaholea fakanianisalea fakaʻokitanelea fakaʻosipiuālea fakaʻolo" +
			"molea faka-ʻotialea fakaʻosetikilea fakapūnusapilea fakapālilea faka" +
			"polanilea fakapasitōlea fakapotukalilea fakakuetisalea fakalaito-lom" +
			"ēnialea fakaluanitilea fakalōmenialea fakalūsialea fakakiniāuanital" +
			"ea fakasanisukulitilea fakasaletīnialea fakasīnitilea fakasami-tokel" +
			"aulea fakasangikōlea fakasingihalalea fakasolāvakilea fakasolovenial" +
			"ea fakahaʻamoalea fakasionalea fakasomalilea fakaʻalapēnialea fakasē" +
			"pialea fakasuatilea fakasoto-tongalea fakasunitālea fakasuētenilea f" +
			"akasuahililea fakatamililea fakaʻinitia-telukulea fakatāsikilea faka" +
			"tailanilea fakatikilinialea fakatēkimenilea fakatisuanalea fakatonga" +
			"lea fakatoakelea fakatisongalea fakatatalelea fakatahitilea fakaʻuik" +
			"ūlilea fakaʻūkalaʻinelea fakaʻūtūlea fakaʻusipekilea fakavenitālea " +
			"fakavietinamilea fakavolapikilea fakaʻualonialea fakaʻuolofolea faka" +
			"tōsalea fakaītisilea fakaʻiōlupalea fakasuangilea fakasiainalea faka" +
			"sululea fakaʻatisēlea fakaʻakolilea fakaʻatangimēlea fakaʻatikēlea f" +
			"akaʻalepea-tunīsialea fakaʻafilihililea fakaʻakihemilea fakaʻainulea" +
			" fakaʻakatialea fakaʻalapamalea fakaʻaleutilea fakaʻalapēnia-kekilea" +
			" fakaʻalitai-tongalea fakapālangi-motuʻalea fakaʻangikalea fakaʻalām" +
			"itilea fakamapuselea fakaʻalaonalea fakaʻalapaholea fakaʻalepea-ʻais" +
			"ilialea fakaʻalauakilea fakaʻalepea-molokolea fakaʻalepea-ʻisipitele" +
			"a fakaʻasulea fakaʻilonga-ʻamelikalea fakaʻasitūlialea fakakotavalea" +
			" fakaʻauatilea fakapalusilea fakapalilea fakapavālialea fakapasaʻale" +
			"a fakapamunilea fakatōpe-pētekilea fakakomalalea fakapesalea fakapēm" +
			"ipalea fakapetavilea fakapenalea fakapafutilea fakapatakalea fakapal" +
			"usi-hihifolea fakaposipulilea fakapikolilea fakapinilea fakapanisali" +
			"lea fakakomelea fakasikesikālea fakapisinupilialea fakapakitiālilea " +
			"fakapalailea fakapalahuilea fakapōtolea fakaʻakōselea fakapuliatilea" +
			" fakapukisilea fakapululea fakapilinilea fakametūmipalea fakakatolea" +
			" fakakalipalea fakakaiukalea fakaʻatisamilea fakasepuanolea fakakika" +
			"lea fakasīpisalea fakasakatāilea fakatūkelea fakamalīlea fakasinuki-" +
			"takotelea fakasokitaulea fakasipeuianilea fakaselokīlea fakaseienele" +
			"a fakakūtisi-lolotolea fakakopitikalea fakakapisenolea fakatoake-kil" +
			"imealea fakaseselua-falanisēlea fakakasiupialea fakatakotalea fakata" +
			"lakuālea fakataitalea fakatelaualelea fakasilavelea fakatōkelipilea " +
			"fakatingikālea fakatisāmalea fakatokililea fakasōpia-hifolea fakatus" +
			"uni-lolotolea fakatualalea fakahōlani-lotolotolea fakaiola-fonīlea f" +
			"akatiulalea fakatasakalea fakaʻemipūlea fakaʻefikilea fakaʻemilialea" +
			" fakaʻisipitemuʻalea fakaʻekaiukilea fakaʻelamitelea fakapālangi-lot" +
			"olotolea fakaiūpiki-lolotolea fakaʻeuōnitolea fakaʻekisitematulalea " +
			"fakafangilea fakafilipainilea fakafinilani-tōnetalelea fakafōngilea " +
			"fakafalanisē-kasunilea fakafalanisē-lotolotolea fakafalanisē-motuʻal" +
			"ea fakaʻāpitanolea fakafilisia-tokelaulea fakafilisia-hahakelea faka" +
			"fulilānilea fakakālea fakakakausilea fakasiaina-kanilea fakakaiolea " +
			"fakakapaialea fakateli-soloasitelialea fakasiʻisilea fakakilipasilea" +
			" fakakilakilea fakasiamane-hake-lotolotolea fakasiamane-hake-motuʻal" +
			"ea fakakonikanī-koanilea fakakonitīlea fakakolonitalolea fakakotikal" +
			"ea fakakēpolea fakakalisimuʻalea fakasiamane-suisilanilea fakaʻuaiūl" +
			"ea fakafalefalelea fakakusīlea fakaʻuīsinilea fakahaitalea fakasiain" +
			"a-hakalea fakahauaiʻilea fakahinitī-fisilea fakahilikainonilea fakah" +
			"ititelea fakamōngilea fakasōpia-hakelea fakasiaina-siangilea fakahup" +
			"alea fakaʻipanilea fakaʻipipiolea fakaʻilokolea fakaʻingusilea fakaʻ" +
			"ingilianilea fakapālangi-samaikalea fakalosipanilea fakanikōmipalea " +
			"fakamasamelea fakaʻiuteo-pēsialea fakaʻiuteo-ʻalepealea fakaʻiutilan" +
			"ilea fakakala-kalipakilea fakakapilelea fakakasinilea fakasisūlea fa" +
			"kakamipalea fakakavilea fakakapālitialea fakakanēmipulea fakatiapile" +
			"a fakamakōnitelea fakakapuvelitianulea fakakeniangilea fakakololea f" +
			"akakaingangilea fakakāsilea fakakōtanilea fakakoila-sīnilea fakakoua" +
			"lilea fakakilimanisikīlea fakakakolea fakakalenisinilea fakakimipūni" +
			"tulea fakakomi-pelemiakilea fakakonikanīlea fakakosilaelea fakakepel" +
			"elea fakakalate-palakililea fakakiliolea fakakinaraiālea fakakalelia" +
			"lea fakakulukilea fakasiamipalalea fakapafialea fakakolongialea faka" +
			"kumikilea fakakutenailea fakalatinolea fakalangilea fakalānitalea fa" +
			"kalamipālea fakalesikialea fakakavakava-foʻoulea fakalikulialea faka" +
			"livonialea fakalakotalea fakalomipātilea fakamongikōlea fakalosilea " +
			"fakaluli-tokelaulea fakalatakalelea fakalupa-lulualea fakaluisenolea" +
			" fakalunitālea fakaluolea fakamisolea fakaluīalea fakasiaina-faʻutoh" +
			"ilea fakalasulea fakamatulalea fakamafalea fakamakahilea fakamaitili" +
			"lea fakamakasalilea fakamanitīngikolea fakamasailea fakamapalea faka" +
			"mokisiālea fakamanetalilea fakamenetīlea fakamelulea fakamolisienile" +
			"a fakaʻaelani-lotolotolea fakamakūa-meʻetolea fakametālea fakamikema" +
			"kilea fakaminangikapaulea fakamanisūlea fakamanipulilea fakamohaukil" +
			"ea fakamosilea fakamali-hihifolea fakamunitangilea tuifiolea fakakil" +
			"ekilea fakamilanitēsilea fakamaliwalilea fakamenitauailea fakamienel" +
			"ea fakaʻelisialea fakamasanitelanilea fakasiaina-mininanilea fakanap" +
			"oletanolea fakanamalea fakasiamane-hifolea fakaneualilea fakaniasile" +
			"a fakaniuēlea fakaʻaonasalea fakakuasiolea fakangiemipōnilea fakanok" +
			"ailea fakanoauē-motuʻalea fakanovialelea fakanikōlea fakasoto-tokela" +
			"ulea fakanuelilea fakaneuali-motuʻalea fakaniamiuesilea fakanianikol" +
			"elea fakaniololea fakanesimalea fakaʻosēselea fakatoake-ʻotomanilea " +
			"fakapangasinanilea fakapālavilea fakapamipangalea fakapapiamēnitolea" +
			" fakapalaulea fakapikātilea fakanaisilialea fakasiamane-penisilivani" +
			"alea fakasiamane-lafalafalea fakapēsia-motuʻalea fakasiamane-palatin" +
			"elea fakafoinikialea fakapiemonitelea fakaponitikilea fakaponapēlea " +
			"fakapulūsialea fakapolovenisi-motuʻalea fakakīsēlea fakakuitisa-simi" +
			"polasolea fakalasasitanilea fakalapanuilea fakalalotongalea fakaloma" +
			"niololea fakalifilea fakalomipōlea fakalomanilea fakalotumalea fakal" +
			"usinilea fakalovianalea fakaʻalomanialea fakaluālea fakasanitauelea " +
			"fakasakalea fakasamalitani-ʻalāmitilea fakasamipululea fakasasakilea" +
			" fakasanitalilea fakasaulasitilālea fakangāmipailea fakasangulea fak" +
			"asisīlialea fakasikotilanilea fakasaletīnia-sasalesulea faka-tonga ‘" +
			"o Ketesilea fakasenekalea fakasenalea fakaselilea fakaselikupilea fa" +
			"kakoilapolo-senilea fakaʻaelani-motuʻalea fakasamositialea fakatasel" +
			"ihitilea fakasianilea fakaʻalepea-sātilea fakasitamolea fakasilesia-" +
			"hifolea fakaselaiālea fakasami-tongalea fakasami-lulelea fakasami-ʻi" +
			"nalilea fakasami-sikolitalea fakasoninekēlea fakasokitianalea fakasu" +
			"lanane-tongikōlea fakasēlēlelea fakasaholea fakafilisia-satēlanilea " +
			"fakasukumalea fakasusūlea fakasumelialea fakakomololea fakasuliāiā-m" +
			"uʻalea fakasuliāiālea fakasilesialea fakatululea fakatimenēlea fakat" +
			"esolea fakatelenolea fakatetumulea fakatikilēlea fakativilea fakatok" +
			"elaulea fakasākulilea fakakilingonilea fakatilingikītelea fakatalisi" +
			"lea fakatamasiekilea fakaniasa-tongalea fakatoki-pisinilea fakatuloi" +
			"olea fakatalokolea fakasakōnialea fakatisīmisianilea fakatati-mosele" +
			"milea fakatumepukalea fakatūvalulea fakatasauakilea fakatuvīnialea f" +
			"akatamasaiti-ʻatilasi-lolotolea fakaʻutimulitilea fakaʻūkalitilea fa" +
			"kaʻumipūnitulea fakaʻilonga-tefitolea fakavailea fakavenēsialea faka" +
			"vepisilea fakavelamingi-hihifolea fakafalanikoni-lolotolea fakavotik" +
			"ilea fakavōlolea fakavūnisolea fakaʻualiselilea fakaʻuolaitalea faka" +
			"ʻualailea fakaʻuasiōlea fakaʻuālipililea fakasiaina-uūlea fakakalim" +
			"ikilea fakamingilelialea fakasokalea fakaʻiaolea fakaʻiapilea fakaʻi" +
			"angipenilea fakaʻiēmipalea fakaneʻēngatūlea fakakuangitongilea fakas" +
			"apotekilea fakaʻilonga-pilisilea fakasēlanilea fakasenakalea fakatam" +
			"asaiti-molokolea fakasuniʻikai ha lealea fakasāsālea fakaʻalepea (mā" +
			"mani)lea fakasiamane-ʻaositulialea fakasiamane-hake-suisilanilea fak" +
			"apālangi-ʻaositelēlialea fakapālangi-kānatalea fakapilitānialea faka" +
			"pālangi-ʻamelikalea fakasipēnisi lātini-ʻamelikalea fakasipēnisi-‘iu" +
			"lopelea fakasipēnisi-mekisikoulea fakafalanisē-kānatalea fakafalanis" +
			"ē-suisilanilea fakasakisoni-hifolea fakahōlani-pelesiumelea fakapot" +
			"ukali-palāsililea fakapotukali-ʻiulopelea fakamolitāvialea fakakuloi" +
			"sia-sēpialea fakasuahili-kongikōlea fakasiaina-fakafaingofualea faka" +
			"siaina-tukufakaholo",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0010, 0x0022, 0x0035, 0x0048, 0x0057, 0x0068, 0x0079,
			0x0089, 0x0099, 0x00aa, 0x00ba, 0x00ce, 0x00de, 0x00ee, 0x00ff,
			0x010f, 0x011f, 0x0130, 0x013e, 0x014e, 0x015d, 0x016d, 0x0179,
			0x0187, 0x0196, 0x01a3, 0x01af, 0x01c8, 0x01d6, 0x01e5, 0x01f8,
			0x0207, 0x0215, 0x0227, 0x0234, 0x0242, 0x0252, 0x0267, 0x0278,
			0x028b, 0x029a, 0x02a8, 0x02b5, 0x02c5, 0x02d1, 0x02de, 0x02ef,
			0x0305, 0x0315, 0x0324, 0x0333, 0x0342, 0x0352, 0x0362, 0x036f,
			0x037e, 0x038d, 0x039e, 0x03ae, 0x03bb, 0x03cd, 0x03de, 0x03ec,
			// Entry 40 - 7F
			0x03fe, 0x0413, 0x042a, 0x043a, 0x044d, 0x045f, 0x046c, 0x047e,
			0x048e, 0x04a3, 0x04b2, 0x04be, 0x04cd, 0x04dd, 0x04eb, 0x04fb,
			0x0509, 0x051e, 0x0530, 0x053e, 0x054c, 0x055a, 0x056b, 0x057a,
			0x0586, 0x0596, 0x05a5, 0x05b3, 0x05c7, 0x05d5, 0x05e8, 0x05f5,
			0x0600, 0x0610, 0x0624, 0x0633, 0x0643, 0x0652, 0x065f, 0x0671,
			0x068d, 0x06a0, 0x06ae, 0x06bb, 0x06c9, 0x06d5, 0x06e2, 0x06fa,
			0x0708, 0x071a, 0x0729, 0x0740, 0x0757, 0x076d, 0x077b, 0x078a,
			0x079b, 0x07ad, 0x07bc, 0x07cb, 0x07dc, 0x07ed, 0x07fa, 0x0808,
			// Entry 80 - BF
			0x0817, 0x0827, 0x0836, 0x084c, 0x085b, 0x086b, 0x0879, 0x088d,
			0x08a1, 0x08b3, 0x08c2, 0x08d6, 0x08e6, 0x08f7, 0x0908, 0x0919,
			0x0929, 0x0936, 0x0944, 0x0957, 0x0965, 0x0972, 0x0984, 0x0993,
			0x09a3, 0x09b2, 0x09c0, 0x09d7, 0x09e6, 0x09f5, 0x0a06, 0x0a17,
			0x0a26, 0x0a33, 0x0a40, 0x0a4f, 0x0a5d, 0x0a6b, 0x0a7c, 0x0a91,
			0x0aa0, 0x0ab1, 0x0ac0, 0x0ad1, 0x0ae1, 0x0af2, 0x0b02, 0x0b0f,
			0x0b1d, 0x0b2e, 0x0b3c, 0x0b4a, 0x0b56, 0x0b66, 0x0b75, 0x0b88,
			0x0b98, 0x0bb1, 0x0bc4, 0x0bd5, 0x0be3, 0x0bf3, 0x0c04, 0x0c14,
			// Entry C0 - FF
			0x0c2c, 0x0c42, 0x0c5a, 0x0c6a, 0x0c7c, 0x0c8a, 0x0c9a, 0x0cab,
			0x0cc5, 0x0cc5, 0x0cd6, 0x0ced, 0x0d07, 0x0d14, 0x0d2e, 0x0d41,
			0x0d4f, 0x0d5e, 0x0d6c, 0x0d78, 0x0d88, 0x0d97, 0x0da5, 0x0dba,
			0x0dc8, 0x0dd4, 0x0de3, 0x0df1, 0x0dfd, 0x0e0b, 0x0e19, 0x0e2e,
			0x0e3e, 0x0e4c, 0x0e58, 0x0e68, 0x0e74, 0x0e85, 0x0e98, 0x0eaa,
			0x0eb7, 0x0ec6, 0x0ed3, 0x0ee3, 0x0ef2, 0x0f00, 0x0f0c, 0x0f1a,
			0x0f2b, 0x0f37, 0x0f45, 0x0f53, 0x0f64, 0x0f73, 0x0f7f, 0x0f8e,
			0x0f9e, 0x0fab, 0x0fb8, 0x0fcd, 0x0fdc, 0x0fed, 0x0ffc, 0x100a,
			// Entry 100 - 13F
			0x1020, 0x1030, 0x1040, 0x1055, 0x106e, 0x107e, 0x108c, 0x109c,
			0x10a9, 0x10b9, 0x10c7, 0x10d8, 0x10e8, 0x10f7, 0x1105, 0x1118,
			0x112d, 0x113a, 0x1152, 0x1164, 0x1171, 0x117f, 0x118f, 0x119e,
			0x11ae, 0x11c4, 0x11d5, 0x11e6, 0x11ff, 0x1215, 0x1227, 0x123e,
			0x124b, 0x125c, 0x1276, 0x1284, 0x129c, 0x12b6, 0x12cf, 0x12e1,
			0x12f8, 0x130e, 0x131f, 0x132a, 0x1339, 0x134c, 0x1358, 0x1366,
			0x137f, 0x138e, 0x139e, 0x13ac, 0x13c9, 0x13e5, 0x13fc, 0x140b,
			0x141d, 0x142b, 0x1438, 0x144b, 0x1464, 0x1473, 0x1483, 0x1490,
			// Entry 140 - 17F
			0x14a1, 0x14ae, 0x14c1, 0x14d1, 0x14e5, 0x14f8, 0x1506, 0x1514,
			0x1527, 0x153c, 0x1548, 0x1557, 0x1567, 0x1576, 0x1586, 0x1599,
			0x15b1, 0x15c1, 0x15d2, 0x15e0, 0x15f6, 0x160e, 0x1620, 0x1635,
			0x1643, 0x1651, 0x165e, 0x166c, 0x1678, 0x168a, 0x169b, 0x16a8,
			0x16b9, 0x16ce, 0x16de, 0x16ea, 0x16fb, 0x1708, 0x1717, 0x172a,
			0x1738, 0x174d, 0x1759, 0x176b, 0x177e, 0x1794, 0x17a5, 0x17b4,
			0x17c2, 0x17d9, 0x17e6, 0x17f7, 0x1806, 0x1814, 0x1825, 0x1832,
			0x1842, 0x1850, 0x185f, 0x186d, 0x187a, 0x1889, 0x1898, 0x18a7,
			// Entry 180 - 1BF
			0x18be, 0x18cd, 0x18dc, 0x18ea, 0x18fb, 0x190b, 0x1917, 0x192b,
			0x193b, 0x194d, 0x195c, 0x196b, 0x1976, 0x1982, 0x198f, 0x19a7,
			0x19b3, 0x19c1, 0x19cd, 0x19db, 0x19ea, 0x19fa, 0x1a0e, 0x1a1b,
			0x1a27, 0x1a37, 0x1a47, 0x1a56, 0x1a62, 0x1a73, 0x1a8c, 0x1aa2,
			0x1aaf, 0x1abf, 0x1ad3, 0x1ae2, 0x1af2, 0x1b01, 0x1b0d, 0x1b20,
			0x1b31, 0x1b3b, 0x1b49, 0x1b5c, 0x1b6c, 0x1b7d, 0x1b8a, 0x1b9a,
			0x1bae, 0x1bc5, 0x1bd7, 0x1be3, 0x1bf7, 0x1c05, 0x1c12, 0x1c1f,
			0x1c2f, 0x1c3d, 0x1c50, 0x1c5d, 0x1c73, 0x1c82, 0x1c8f, 0x1ca3,
			// Entry 1C0 - 1FF
			0x1cb0, 0x1cc6, 0x1cd7, 0x1ce8, 0x1cf5, 0x1d03, 0x1d13, 0x1d2a,
			0x1d3d, 0x1d4c, 0x1d5d, 0x1d71, 0x1d7e, 0x1d8d, 0x1d9d, 0x1dba,
			0x1dd2, 0x1de8, 0x1e00, 0x1e10, 0x1e21, 0x1e31, 0x1e40, 0x1e50,
			0x1e6a, 0x1e78, 0x1e92, 0x1ea4, 0x1eb3, 0x1ec4, 0x1ed5, 0x1ee1,
			0x1ef0, 0x1efe, 0x1f0c, 0x1f1a, 0x1f29, 0x1f3b, 0x1f47, 0x1f57,
			0x1f63, 0x1f80, 0x1f90, 0x1f9e, 0x1fae, 0x1fc2, 0x1fd3, 0x1fe0,
			0x1ff0, 0x2002, 0x201d, 0x2037, 0x2045, 0x2051, 0x205d, 0x206d,
			0x2083, 0x209b, 0x20ac, 0x20be, 0x20cb, 0x20e1, 0x20ef, 0x2103,
			// Entry 200 - 23F
			0x2112, 0x2124, 0x2135, 0x2149, 0x215e, 0x216f, 0x2180, 0x2199,
			0x21a9, 0x21b5, 0x21ce, 0x21dc, 0x21e9, 0x21f8, 0x2206, 0x221d,
			0x222e, 0x223d, 0x2249, 0x2258, 0x2264, 0x2272, 0x2280, 0x228f,
			0x229b, 0x22aa, 0x22b9, 0x22ca, 0x22de, 0x22ec, 0x22fd, 0x2310,
			0x2323, 0x2331, 0x233f, 0x234f, 0x2363, 0x2378, 0x2388, 0x2397,
			0x23a7, 0x23b7, 0x23d9, 0x23ec, 0x23fe, 0x2412, 0x2429, 0x2434,
			0x2444, 0x2452, 0x246a, 0x2483, 0x2491, 0x249e, 0x24ad, 0x24bf,
			0x24d0, 0x24df, 0x24ef, 0x2502, 0x2514, 0x2524, 0x2536, 0x2542,
			// Entry 240 - 27F
			0x254f, 0x255d, 0x2570, 0x2581, 0x2595, 0x25a8, 0x25b8, 0x25cf,
			0x25de, 0x25ec, 0x2604, 0x2610, 0x261d, 0x262b, 0x2645, 0x2645,
			0x2660, 0x267e, 0x269d, 0x26b5, 0x26c7, 0x26e1, 0x2704, 0x271f,
			0x273a, 0x273a, 0x2753, 0x276e, 0x2783, 0x279c, 0x27b6, 0x27cf,
			0x27e1, 0x27f8, 0x2810, 0x282c, 0x2847,
		},
	},
	{ // tr
		trLangStr,
		trLangIdx,
	},
	{ // twq
		"Akan senniAmhaarik senniLaaraw senniBelaruus senniBulagaari senniBengali" +
			" senniCek senniAlmaŋ senniGrek senniInglisi senniEspaaɲe senniFarsi " +
			"senniFransee senniHawsance senniInduu senniHungaari senniIndoneesi s" +
			"enniIboo senniItaali senniJaponee senniJavanee senniKmeer senni, Gam" +
			"e hereKoree senniMaleezi senniBurme senniNeepal senniHolandee senniP" +
			"unjaabi senniiPolonee senniPortugee senniRumaani senniRuusi senniRwa" +
			"nda senniSomaali senniSuweede senniTamil senniTaailandu senniTurku s" +
			"enniUkreen senniUrdu senniVietnaam senniYorbance senniSinuwa senni, " +
			"MandareŋZulu senniTasawaq senni",
		[]uint16{ // 553 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a, 0x0018, 0x0018,
			0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0024, 0x0032, 0x0041,
			0x0041, 0x0041, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e, 0x004e,
			0x004e, 0x004e, 0x004e, 0x0057, 0x0057, 0x0057, 0x0057, 0x0057,
			0x0063, 0x0063, 0x0063, 0x0063, 0x006d, 0x007a, 0x007a, 0x0088,
			0x0088, 0x0088, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x00a0,
			0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00ae,
			0x00ae, 0x00b9, 0x00b9, 0x00b9, 0x00b9, 0x00c7, 0x00c7, 0x00c7,
			// Entry 40 - 7F
			0x00c7, 0x00d6, 0x00d6, 0x00e0, 0x00e0, 0x00e0, 0x00e0, 0x00e0,
			0x00ec, 0x00ec, 0x00f9, 0x0106, 0x0106, 0x0106, 0x0106, 0x0106,
			0x0106, 0x0106, 0x011c, 0x011c, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127, 0x0127,
			0x0127, 0x0127, 0x0127, 0x0134, 0x0134, 0x013f, 0x013f, 0x013f,
			0x014b, 0x014b, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
			0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0168, 0x0168, 0x0175,
			// Entry 80 - BF
			0x0175, 0x0183, 0x0183, 0x0183, 0x0183, 0x0190, 0x019b, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4, 0x01b4,
			0x01c1, 0x01c1, 0x01cc, 0x01cc, 0x01cc, 0x01db, 0x01db, 0x01db,
			0x01db, 0x01db, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01e6, 0x01f2,
			0x01fc, 0x01fc, 0x01fc, 0x020a, 0x020a, 0x020a, 0x020a, 0x020a,
			0x020a, 0x0218, 0x0218, 0x022f, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry C0 - FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 100 - 13F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 140 - 17F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 180 - 1BF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 1C0 - 1FF
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			// Entry 200 - 23F
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239, 0x0239,
			0x0246,
		},
	},
	{ // tzm
		"TakanitTamharitTaεrabtTabilarusitTabelɣaritTabinɣalitTačiktTalmanitTayun" +
			"anitTanglizttasbelyunitTafarisitTafṛansistTahawsatTahinditTahenɣarit" +
			"TindunisitTigbutTaṭalyantTajappunitTajavanitTaxmert ,TalammastTakuri" +
			"tTamalizitTaburmanitTanippalitTahulanḍitTabenjabitTappulunitTaburtuɣ" +
			"alitTaṛumanitTarusitTarwanditTaṣumalitTaswiditTatamiltTaṭaytTaturkit" +
			"TukranitTurdutTaviṭnamitTayurubatTacinwit,MandarintazulutTamaziɣt n " +
			"laṭlaṣ",
		[]uint16{ // 555 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0017, 0x0022, 0x002d,
			0x002d, 0x002d, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x0038, 0x0038, 0x0038, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x0047, 0x0047, 0x0047, 0x0047, 0x0050, 0x0058, 0x0058, 0x0063,
			0x0063, 0x0063, 0x006c, 0x006c, 0x006c, 0x006c, 0x006c, 0x0078,
			0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0078, 0x0080,
			0x0080, 0x0088, 0x0088, 0x0088, 0x0088, 0x0093, 0x0093, 0x0093,
			// Entry 40 - 7F
			0x0093, 0x009d, 0x009d, 0x00a3, 0x00a3, 0x00a3, 0x00a3, 0x00a3,
			0x00ae, 0x00ae, 0x00b8, 0x00c1, 0x00c1, 0x00c1, 0x00c1, 0x00c1,
			0x00c1, 0x00c1, 0x00d3, 0x00d3, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da, 0x00da,
			0x00da, 0x00da, 0x00da, 0x00e3, 0x00e3, 0x00ed, 0x00ed, 0x00ed,
			0x00f7, 0x00f7, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x0103,
			0x0103, 0x0103, 0x0103, 0x0103, 0x0103, 0x010d, 0x010d, 0x0117,
			// Entry 80 - BF
			0x0117, 0x0124, 0x0124, 0x0124, 0x0124, 0x012f, 0x0136, 0x013f,
			0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x013f, 0x013f, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a, 0x014a,
			0x0152, 0x0152, 0x015a, 0x015a, 0x015a, 0x0162, 0x0162, 0x0162,
			0x0162, 0x0162, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x0172,
			0x0178, 0x0178, 0x0178, 0x0184, 0x0184, 0x0184, 0x0184, 0x0184,
			0x0184, 0x018d, 0x018d, 0x019e, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry C0 - FF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 100 - 13F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 140 - 17F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 180 - 1BF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 1C0 - 1FF
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			// Entry 200 - 23F
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5, 0x01a5,
			0x01a5, 0x01a5, 0x01bb,
		},
	},
	{ // ug
		"ئافارچەئابخازچەئاۋېستاچەئافرىكانچەئاكانچەئامھارچەئاراگونچەئەرەبچەئاسامچە" +
			"ئاۋارچەئايماراچەئەزەربەيجانچەباشقىرتچەبېلارۇسچەبۇلغارچەبىسلاماچەبام" +
			"باراچەبېنگالچەتىبەتچەبىرېتونچەبوسىنچەكاتالانچەچېچىنچەچامورروچەكورسۇ" +
			"چەكرىچەچېخچەقەدىمكى سلاۋيانچەچۇۋاشچەۋېلشچەدانىشچەگېرمانچەدىۋېخچەزوڭ" +
			"خاچەئېۋېچەگىرېكچەئىنگلىزچەئېسپرانتوچەئىسپانچەئېستونچەباسكىچەپارسچەف" +
			"ۇلاھچەفىنچەفىجىچەفائېروچەفىرانسۇزچەغەربىي فىرسچەئىرېلاندچەشوتلاندىي" +
			"ە گايلچىسىگالىچەگۇئارانىچەگۇجاراتچەمانچەخائۇساچەئىبرانىيچەھىندىچەھى" +
			"رى موتۇچەكىرودىچەھايتىچەۋېنگىرچەئەرمېنچەخېرېروچەئارىلىق تىلھىندونېز" +
			"چەئىنتىرلىڭچەئىگبوچەيىچە (سىچۈەن)ئىنۇپىكچەئىدوچەئىسلاندچەئىتالىيانچ" +
			"ەئىنۇكتىتۇتچەياپونچەياۋاچەگىرۇزچەكونگوچەكىكۇيۇچەكىۋانياماچەقازاقچەگ" +
			"ىرېنلاندچەكىمېرچەكانناداچەكورېيەچەكانۇرچەكەشمىرچەكۇردچەكومىچەكورنىش" +
			"چەقىرغىزچەلاتىنچەلىيۇكسېمبۇرگچەگانداچەلىمبۇرگچەلىنگالاچەلائوسچەلىتۋ" +
			"انىچەلۇبا-كاتانگاچەلاتچەمالاگاسچەمارشالچەماۋرىچەماكېدونچەمالايالامچ" +
			"ەموڭغۇلچەماراتىچەمالايچەمالتاچەبىرماچەناۋرۇچەشىمالى ندەبەلەچەنېپالچ" +
			"ەندونگاچەگوللاندچەيېڭى نورۋېگچەنورۋىگىيە بوكمالچەجەنۇبى ندەبەلەچەنا" +
			"ۋاخوچەنىيانجاچەئوكسىتچەئوجىبۋاچەئوروموچەئودىياچەئوسسېتچەچەپەنجابچەپ" +
			"الىچەپولەكچەپۇشتۇچەپورتۇگالچەكېچىۋاچەرومانسچەرۇندىچەرومىنچەرۇسچەكېن" +
			"ىيەرىۋانداچەسانسكرىتچەساردىنىيەچەسىندىچەشىمالىي سامىچەسانگوچەسىنگال" +
			"چەسىلوۋاكچەسىلوۋېنچەساموئاچەشوناچەسومالىچەئالبانچەسېربچەسىۋاتىچەسوت" +
			"وچەسۇنداچەشىۋېدچەسىۋاھىلچەتامىلچەتېلۇگۇچەتاجىكچەتايلاندچەتىگرىنياچە" +
			"تۈركمەنچەسىۋاناچەتونگانچەتۈركچەسونگاچەتاتارچەتاختىچەئۇيغۇرچەئۇكرائى" +
			"نچەئوردۇچەئۆزبېكچەۋېنداچەۋىيېتنامچەۋولاپۇكچەۋاللۇنچەۋولوفچەخوساچەيى" +
			"ددىشچەيورۇباچەجۇاڭچەخەنزۇچەزۇلۇچەئاتجېچەئاچولىچەئاداڭمېچەئادىگېيچەئ" +
			"افرىخىلىچەئاگەمچەئاينۇچەئاككادچەئالېيۇتچەجەنۇبى ئالتاي تىللىرىقەدىم" +
			"كى ئىنگلىزچەئانگىكاچەئارامۇچەماپۇدۇنگۇنچەئاراپاخوچەئاراۋاكچەئاسۇچەئ" +
			"استۇرىيەچەئاۋادىچەبېلۇجىچەبالىچەباساچەبامۇنچەگومالاچەبېجاچەبېمباچەب" +
			"ېناچەبافۇتچەبوجپۇرىچەبىكولچەبىنىچەكومچەسىكسىكاچەبىراجچەبودوچەئاكۇسچ" +
			"ەبۇرىياتچەبۇگىچەبۇلۇچەبىلىنچەمېدۇمباچەكاددوچەكارىبچەكايۇگاچەئاتسامچ" +
			"ەسېبۇچەچىگاچەچىبچاچەچاغاتايچەچۇكچەمارىچەچىنۇك-ژارگونچەچوكتاۋچەچىپېۋ" +
			"يانچەچېروكىچەچېيېنچەمەركىزىي كۇردچەكوپتىكچەقىرىم تۈركچەكاسزۇبىچەداك" +
			"وتاچەدارگىۋاچەتايتاچەدېلاۋارېچەسلاۋچەدوگرىبچەدىنكاچەزارماچەدوگرىچەت" +
			"ۆۋەن سوربچەدۇئالاچەئوتتۇرا گوللاندىيەچەجولاچەدىيۇلاچەدازاگاچەئېمبۇچ" +
			"ەئېفىكچەقەدىمكى مىسىرچەئېكاجۇكچەئېلامىتچەئوتتۇرا ئەسىر ئىنگلىزچەئېۋ" +
			"وندوچەفاڭچەفىلىپپىنچەفونچەئوتتۇرا ئەسىر فىرانسۇزچەقەدىمكى فىرانسۇزچ" +
			"ەشىمالى فىرىزيەچەشەرقى فىرىزيەچەفىرىئۇلىچەگاچەگايوچەگىباياچەگىزچەگى" +
			"لبېرتچەئوتتۇرا ئەسىر ئېگىزلىك گېرمانچەقەدىمكى ئېگىزلىك گېرمانچەگوند" +
			"ىچەگورونتالوچەگوتچەگرېبوچەقەدىمكى گىرېكچەگېرمانچە شىۋىتسارىيەگۇسىچە" +
			"گىۋىچىنچەھەيدەچەھاۋايچەخىلىگاينونچەخىتتىتچەمۆڭچەئۈستۈن سوربچەخۇپاچە" +
			"ئىبانچەئىبىبىئوچەئىلوكانوچەئىنگۇشچەلوجبانچەنگومباچەماچامچەئىبرانى پ" +
			"ارسچەئىبرانى ئەرەبچەقارا-قالپاقچەكابىلېچەكاچىنچەجۇچەكامباچەكاۋىچەكا" +
			"باردەيچەكانېمبۇچەتياپچەماكوندېچەكابۇۋېردىيانچەكوروچەكاسىچەخوتەنچەكو" +
			"يرا چىنىچەكاكوچەكالېنجىنچەكىمبۇندۇچەكونكانچەكوسرايېچەكىپەللېچەقاراچ" +
			"اي-بالقارچەكارەلچەكۇرۇخچەشامبالاچەبافىياچەكولىشچەقۇمۇقچەكۇتەنايچەلا" +
			"دىنوچەلانگىچەلانداچەلامباچەلېزگىنچەمونگوچەلوزىچەلۇبا-لۇئاچەلۇيسېنگو" +
			"چەلۇنداچەلۇئوچەمىزوچەلۇياچەمادۇرېسچەمافاچەماگاخىچەمايتىلىچەماكاسارچ" +
			"ەماندىنگوچەماسايچەماباچەموكشاچەماندارچەمېندېچەمېرۇچەمورىسيېنچەئوتتۇ" +
			"را ئەسىر ئىرېلاندچەماكۇۋاچەمېتاچە’مىكماكچەمىناڭكابائۇچەمانجۇچەمانىپ" +
			"ۇرچەموخاۋكچەموسسىچەمۇنداڭچەكۆپ تىللاركىرىكچەمىراندېسچەمارۋارىچەميېن" +
			"ېچەئېرزاچەناپولىچەناماچەتۆۋەن گېرمانچەنېۋارىچەنىئاسچەنيۇئېچەكۋاسىيو" +
			"چەنگېمبۇنچەنوغايچەقەدىمكى نورۋېگچەنىكوچەشىمالىي سوتوچەمۇئېرچەنېۋارچ" +
			"ەنيامۋېزىچەنىيانكولېچەنىئوروچەنىزەماچەئوساگېلارچەئوسمان تۈركچەپانگا" +
			"سىنانچەپەھلەۋىچەپامپانگاچەپاپىيامېنتوچەپالاۋچەقەدىمكى پارىسچەفىنىكى" +
			"يەچەپوناپېئانچەقەدىمكى پروۋېنچالچەراجاستانچەراپانىيچەرومبوچەسىگانچە" +
			"ئارومانچەرىۋاچەسانداۋېچەساخاچەسامارىتانچەسامبۇرۇچەساساكچەسانتالچەنگ" +
			"امبايچەسانگۇچەسىتسىلىيەچەشوتلاندىيەچەسېكنېكاچەسېناچەسېلكاپچەشەرقىي " +
			"سوڭخايچەقەدىمكى ئىرېلاندچەشىلخاچەشانچەچاد ئەرەبچەسىداموچەجەنۇبىي سا" +
			"مىچەلۇلې سامىچەئىنارى سامىچەسكولت سامىچەسونىنكەچەسوغدىچەسىرانان-توڭ" +
			"وچەسېرېرچەساخوچەسۇكۇماچەسۇسۇچەسۈمەرچەكومورىچەقەدىمىي سۇرىيەچەسۇرىيە" +
			"چەتېمنېچەتېسوچەتېرېناچەتېتۇمچەتىگرېچەتىۋچەتوكېلاۋچەكىلىنگونچەتىلىنگ" +
			"ىتچەتاماشېكچەنياسا توڭانچەتوك-پىسىنچەتوروكوچەسىمشيانچەتۇمبۇكاچەتۇۋا" +
			"لۇچەشىمالىي سوڭخايچەتوۋاچەمەركىزىي ئاتلاس تامازايتچەئۇدمۇرتچەئۇگارى" +
			"تىكچەئۇمبۇندۇچەغول تىلۋايچەۋوتېچەۋۇنجوچەۋالسېرچەۋولايتاچەۋارايچەۋاش" +
			"وچەقالماقچەسوگاچەياۋچەياپچەياڭبەنچەيېمباچەگۇاڭدوڭچەزاپوتېكچەبىلىس ب" +
			"ەلگىلىرىزېناگاچەئۆلچەملىك ماراكەش تامازىتچەزۇنىچەتىل مەزمۇنى يوقزاز" +
			"اچەھازىرقى زامان ئۆلچەملىك ئەرەبچەئاۋستىرىيە گېرمانچەشىۋىتسارىيە ئې" +
			"گىزلىك گېرمانچەئاۋسترالىيە ئىنگلىزچەكانادا ئىنگلىزچەئەنگلىيە ئىنگلى" +
			"زچەئامېرىكا ئىنگلىزچەلاتىن ئامېرىكا ئىسپانچەياۋروپا ئىسپانچەمېكسىكا" +
			" ئىسپانچەكانادا فىرانسۇزچەشىۋىتسارىيە فىرانسۇزچەبىرازىلىيە پورتۇگالچ" +
			"ەياۋروپا پورتۇگالچەسېرب-كرودىيەچەكونگو سىۋالىچەئاددىي خەنچەمۇرەككەپ" +
			" خەنچە",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x001e, 0x0030, 0x0044, 0x0052, 0x0062, 0x0074,
			0x0082, 0x0090, 0x009e, 0x00b0, 0x00ca, 0x00dc, 0x00ee, 0x00fe,
			0x0110, 0x0122, 0x0132, 0x0140, 0x0152, 0x0160, 0x0172, 0x0180,
			0x0192, 0x01a0, 0x01aa, 0x01b4, 0x01d5, 0x01e3, 0x01ef, 0x01fd,
			0x020d, 0x021b, 0x0229, 0x0235, 0x0243, 0x0255, 0x026b, 0x027b,
			0x028b, 0x0299, 0x02a5, 0x02b3, 0x02bd, 0x02c9, 0x02d9, 0x02ed,
			0x0306, 0x031a, 0x033f, 0x034b, 0x035f, 0x0371, 0x037b, 0x038b,
			0x039f, 0x03ad, 0x03c2, 0x03d2, 0x03e0, 0x03f0, 0x0400, 0x0410,
			// Entry 40 - 7F
			0x0425, 0x0439, 0x044f, 0x045d, 0x0474, 0x0486, 0x0492, 0x04a4,
			0x04ba, 0x04d2, 0x04e0, 0x04ec, 0x04fa, 0x0508, 0x0518, 0x052e,
			0x053c, 0x0552, 0x0560, 0x0572, 0x0582, 0x0590, 0x05a0, 0x05ac,
			0x05b8, 0x05c8, 0x05d8, 0x05e6, 0x0602, 0x0610, 0x0622, 0x0634,
			0x0642, 0x0654, 0x066f, 0x0679, 0x068b, 0x069b, 0x06a9, 0x06bb,
			0x06d1, 0x06e1, 0x06f1, 0x06ff, 0x070d, 0x071b, 0x0729, 0x0748,
			0x0756, 0x0766, 0x0778, 0x0791, 0x07b4, 0x07d3, 0x07e3, 0x07f5,
			0x0805, 0x0817, 0x0827, 0x0837, 0x084b, 0x085b, 0x0867, 0x0875,
			// Entry 80 - BF
			0x0883, 0x0897, 0x08a7, 0x08b7, 0x08c5, 0x08d3, 0x08dd, 0x08fb,
			0x090f, 0x0925, 0x0933, 0x094e, 0x095c, 0x096c, 0x097e, 0x0990,
			0x09a0, 0x09ac, 0x09bc, 0x09cc, 0x09d8, 0x09e8, 0x09f4, 0x0a02,
			0x0a10, 0x0a22, 0x0a30, 0x0a40, 0x0a4e, 0x0a60, 0x0a74, 0x0a86,
			0x0a96, 0x0aa6, 0x0ab2, 0x0ac0, 0x0ace, 0x0adc, 0x0aec, 0x0b00,
			0x0b0e, 0x0b1e, 0x0b2c, 0x0b40, 0x0b52, 0x0b62, 0x0b70, 0x0b7c,
			0x0b8c, 0x0b9c, 0x0ba8, 0x0bb6, 0x0bc2, 0x0bd0, 0x0be0, 0x0bf2,
			0x0c04, 0x0c04, 0x0c1a, 0x0c28, 0x0c36, 0x0c46, 0x0c46, 0x0c58,
			// Entry C0 - FF
			0x0c58, 0x0c80, 0x0ca1, 0x0cb3, 0x0cc3, 0x0cdb, 0x0cdb, 0x0cef,
			0x0cef, 0x0cef, 0x0d01, 0x0d01, 0x0d01, 0x0d0d, 0x0d0d, 0x0d23,
			0x0d23, 0x0d33, 0x0d43, 0x0d4f, 0x0d4f, 0x0d5b, 0x0d69, 0x0d69,
			0x0d79, 0x0d85, 0x0d93, 0x0d93, 0x0d9f, 0x0dad, 0x0dad, 0x0dad,
			0x0dbf, 0x0dcd, 0x0dd9, 0x0dd9, 0x0de3, 0x0df5, 0x0df5, 0x0df5,
			0x0e03, 0x0e03, 0x0e0f, 0x0e1d, 0x0e2f, 0x0e3b, 0x0e47, 0x0e55,
			0x0e67, 0x0e75, 0x0e83, 0x0e93, 0x0ea3, 0x0eaf, 0x0ebb, 0x0ec9,
			0x0edb, 0x0ee5, 0x0ef1, 0x0f0c, 0x0f1c, 0x0f30, 0x0f40, 0x0f4e,
			// Entry 100 - 13F
			0x0f6b, 0x0f7b, 0x0f7b, 0x0f92, 0x0f92, 0x0fa4, 0x0fb4, 0x0fc6,
			0x0fd4, 0x0fe8, 0x0ff4, 0x1004, 0x1012, 0x1020, 0x102e, 0x1045,
			0x1045, 0x1055, 0x107c, 0x1088, 0x1098, 0x10a8, 0x10b6, 0x10c4,
			0x10c4, 0x10e1, 0x10f3, 0x1105, 0x1131, 0x1131, 0x1143, 0x1143,
			0x114d, 0x1161, 0x1161, 0x116b, 0x116b, 0x1199, 0x11bc, 0x11bc,
			0x11db, 0x11f8, 0x120c, 0x1214, 0x1214, 0x1214, 0x1220, 0x1230,
			0x1230, 0x123a, 0x124c, 0x124c, 0x1287, 0x12b7, 0x12b7, 0x12c5,
			0x12db, 0x12e5, 0x12f3, 0x1310, 0x1337, 0x1337, 0x1337, 0x1343,
			// Entry 140 - 17F
			0x1355, 0x1363, 0x1363, 0x1371, 0x1371, 0x1389, 0x1399, 0x13a3,
			0x13bc, 0x13bc, 0x13c8, 0x13d6, 0x13ea, 0x13fe, 0x140e, 0x140e,
			0x140e, 0x141e, 0x142e, 0x143c, 0x1457, 0x1474, 0x1474, 0x148d,
			0x149d, 0x14ab, 0x14b3, 0x14c1, 0x14cd, 0x14e1, 0x14f3, 0x14ff,
			0x1511, 0x152d, 0x152d, 0x1539, 0x1539, 0x1545, 0x1553, 0x156a,
			0x156a, 0x156a, 0x1576, 0x158a, 0x159e, 0x159e, 0x15ae, 0x15c0,
			0x15d2, 0x15f1, 0x15f1, 0x15f1, 0x15ff, 0x160d, 0x161f, 0x162f,
			0x163d, 0x164b, 0x165d, 0x166d, 0x167b, 0x1689, 0x1697, 0x16a7,
			// Entry 180 - 1BF
			0x16a7, 0x16a7, 0x16a7, 0x16a7, 0x16a7, 0x16b5, 0x16c1, 0x16c1,
			0x16c1, 0x16d6, 0x16ea, 0x16f8, 0x1704, 0x1710, 0x171c, 0x171c,
			0x171c, 0x172e, 0x173a, 0x174a, 0x175c, 0x176e, 0x1782, 0x1790,
			0x179c, 0x17aa, 0x17ba, 0x17c8, 0x17d4, 0x17e8, 0x1816, 0x1826,
			0x1835, 0x1845, 0x185f, 0x186d, 0x187f, 0x188f, 0x189d, 0x189d,
			0x18ad, 0x18c0, 0x18ce, 0x18e2, 0x18f4, 0x18f4, 0x1902, 0x1910,
			0x1910, 0x1910, 0x1920, 0x192c, 0x1947, 0x1957, 0x1965, 0x1973,
			0x1973, 0x1985, 0x1997, 0x19a5, 0x19c4, 0x19c4, 0x19d0, 0x19eb,
			// Entry 1C0 - 1FF
			0x19f9, 0x1a07, 0x1a1b, 0x1a31, 0x1a41, 0x1a51, 0x1a67, 0x1a80,
			0x1a98, 0x1aaa, 0x1abe, 0x1ad8, 0x1ae6, 0x1ae6, 0x1ae6, 0x1ae6,
			0x1ae6, 0x1b03, 0x1b03, 0x1b17, 0x1b17, 0x1b17, 0x1b2d, 0x1b2d,
			0x1b52, 0x1b52, 0x1b52, 0x1b66, 0x1b78, 0x1b78, 0x1b78, 0x1b78,
			0x1b86, 0x1b94, 0x1b94, 0x1b94, 0x1b94, 0x1ba6, 0x1bb2, 0x1bc4,
			0x1bd0, 0x1be6, 0x1bf8, 0x1c06, 0x1c16, 0x1c16, 0x1c28, 0x1c36,
			0x1c4c, 0x1c64, 0x1c64, 0x1c64, 0x1c76, 0x1c82, 0x1c82, 0x1c92,
			0x1caf, 0x1cd2, 0x1cd2, 0x1ce0, 0x1cea, 0x1cff, 0x1d0f, 0x1d0f,
			// Entry 200 - 23F
			0x1d0f, 0x1d2a, 0x1d3f, 0x1d58, 0x1d6f, 0x1d81, 0x1d8f, 0x1daa,
			0x1db8, 0x1dc4, 0x1dc4, 0x1dd4, 0x1de0, 0x1dee, 0x1dfe, 0x1e1d,
			0x1e2d, 0x1e2d, 0x1e2d, 0x1e3b, 0x1e47, 0x1e57, 0x1e65, 0x1e73,
			0x1e7d, 0x1e8f, 0x1e8f, 0x1ea3, 0x1eb7, 0x1eb7, 0x1ec9, 0x1ee2,
			0x1ef7, 0x1ef7, 0x1f07, 0x1f07, 0x1f19, 0x1f19, 0x1f2b, 0x1f3b,
			0x1f5a, 0x1f66, 0x1f98, 0x1faa, 0x1fc0, 0x1fd4, 0x1fe1, 0x1feb,
			0x1feb, 0x1feb, 0x1feb, 0x1feb, 0x1ff7, 0x1ff7, 0x2005, 0x2015,
			0x2027, 0x2035, 0x2041, 0x2041, 0x2041, 0x2051, 0x2051, 0x205d,
			// Entry 240 - 27F
			0x2067, 0x2071, 0x2081, 0x208f, 0x208f, 0x20a1, 0x20b3, 0x20d0,
			0x20d0, 0x20e0, 0x2114, 0x2120, 0x213c, 0x2148, 0x2183, 0x2183,
			0x21a8, 0x21e0, 0x2209, 0x2228, 0x224b, 0x226e, 0x229a, 0x22b9,
			0x22d8, 0x22d8, 0x22f9, 0x2324, 0x2324, 0x2324, 0x234d, 0x2370,
			0x2370, 0x238b, 0x23a6, 0x23bd, 0x23d8,
		},
	},
	{ // uk
		ukLangStr,
		ukLangIdx,
	},
	{ // ur
		urLangStr,
		urLangIdx,
	},
	{ // ur-IN
		"افریقیکروشینجاوانیزجارجيائىکلالیسٹکنڑکرداودھیسورانی کردیزرمہمگہیمسائیمعی" +
			"اری مراقشی تمازیقیجدید معیاری عربیآسان چینی",
		[]uint16{ // 612 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			// Entry 40 - 7F
			0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018, 0x0018,
			0x0018, 0x0018, 0x0018, 0x0026, 0x0036, 0x0036, 0x0036, 0x0036,
			0x0036, 0x0044, 0x0044, 0x004a, 0x004a, 0x004a, 0x004a, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			// Entry 80 - BF
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			// Entry C0 - FF
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050, 0x0050,
			0x0050, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			// Entry 100 - 13F
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x006f,
			0x006f, 0x006f, 0x006f, 0x006f, 0x006f, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			// Entry 140 - 17F
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			// Entry 180 - 1BF
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077, 0x0077,
			0x0077, 0x0077, 0x0077, 0x007f, 0x007f, 0x007f, 0x007f, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 1C0 - 1FF
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 200 - 23F
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			// Entry 240 - 27F
			0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089, 0x0089,
			0x0089, 0x0089, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf, 0x00cf,
			0x00cf, 0x00cf, 0x00cf, 0x00e0,
		},
	},
	{ // uz
		uzLangStr,
		uzLangIdx,
	},
	{ // uz-Arab
		"دریپشتواوزبیک",
		[]uint16{ // 170 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 40 - 7F
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
			// Entry 80 - BF
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e, 0x000e,
			0x000e, 0x001a,
		},
	},
	{ // uz-Cyrl
		"афарчаабхазчаафрикаансаканчаамхарчаарагонарабчаассомчааварчааймараозарба" +
			"йжончабошқирдчабеларусчаболгарчабисламабамбарчабенгалчатибетчабрето" +
			"нчабоснийчакаталончачечен тиличаморрокорсиканчачехчаславянча (черко" +
			"в)чуваш тилиуэлсчадатчанемисчадивехидзонгкаэвечагрекчаинглизчаэспер" +
			"антоиспанчаэстончабаскчафорсийфулаҳфинчафижичафарерчафранцузчағарби" +
			"й фризчаирландчашотландча гаеликгалицийчагуаранигужаротчамэнчахауса" +
			"ибронийҳиндихорватчагаитянчавенгерчаарманчагерероинтерлингваиндонез" +
			"чаигбоидоисландчаиталянчаинуктитутяпончаяванчагрузинчакикуюқозоқчаг" +
			"ренландчахмерчаканнадакорейсчаканурикашмирчакурдчакорнчақирғизчалот" +
			"инчалюксембургчагандачалингалчалаосчалитвачалуба-катангалатишчамала" +
			"гасийчамаршалл тилимаоримакедончамалаяламмўғулчамаратхималай тилмал" +
			"тачабирманчашимолий ндебеленепалчаголландчанорвегча нюнорскнорвегча" +
			" бокмалжанубий ндебелчачеваокситанчаоромоодияпанжобчаполякчапуштупор" +
			"тугалчакечуароманшчарундируминчарусчакиняруандасанскритсиндҳишимоли" +
			"й саамчасангосингалчасловакчасловенчашонасомаличаалбанчасербчасвати" +
			"сунданчашведчасуахилитамилчателугутожикчатайчатигринячатуркманчатон" +
			"ганчатуркчататарчауйғурчаукраинчаурдуўзбекчавендаветнамчаволапюквол" +
			"офчахосаиддишйорубахитойчазулуачинадангмэадигейагемчаайнуалеутангик" +
			"амапудунгунарапахоасучаастурийчаавадхибаличабасаабембабеначабхожпур" +
			"ибинибодочабугийчаблинчасебуанчачигачачуукчамаричоктавчачерокишайен" +
			"нсорани-курдчадакотчадаргинчатаитачадогрибзармақуйи-сорбчадуалачади" +
			"ола-фогнидазагаэмбучаэфикэкажукэвондончафилипинчафонфриулчагагеэзги" +
			"лбертчагоронталонемисча (Швейцария)гусиигвичингавайчахилигайнонхмон" +
			"гчаюқори сорбчахупа тилиибан тилиибибоилокоингушчангомбамачаме тили" +
			"кабилчакажикамбачамакондечакабувердианукойра-чииникакокаленжинчакон" +
			"канчашамбалабафиячакёлнчалангичалакотачалакотачашимолий лурилушайлу" +
			"ҳямасайчамокша тилимендемеручаморисьенмахува-миттометамикмакминангк" +
			"абауманипурчамогавкмоссимундангбир нечта тилкрикчамирандесэрзянчама" +
			"зандераннаманиуэчаквасионгиембуннконуэрчанянколепапияментокичэромбо" +
			"чааруминруанда тилисахасамбуручасанталисангучасенакойраборо-сеннита" +
			"шелхитжанубий саамчалуле-саамчаинари-саамчасколт-саамчасаҳочакоморч" +
			"асуриячатесотигретасавакмарказий атлас тамазигхтномаълум тилваивунж" +
			"овалсерчаволяттасогаянгбенкантончатамазигхтТил таркиби йўқстандарт " +
			"арабчаинглизча (Британия)инглизча (Америка)фламандчаконго-суахилисо" +
			"ддалаштирилган хитойчаанъанавий хитойча",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x000c, 0x001a, 0x001a, 0x002c, 0x0038, 0x0046, 0x0052,
			0x005e, 0x006c, 0x0078, 0x0084, 0x009c, 0x00ae, 0x00c0, 0x00d0,
			0x00de, 0x00ee, 0x00fe, 0x010c, 0x011c, 0x012c, 0x013e, 0x0151,
			0x015f, 0x0173, 0x0173, 0x017d, 0x019c, 0x01af, 0x01bb, 0x01c5,
			0x01d3, 0x01df, 0x01ed, 0x01f7, 0x0203, 0x0213, 0x0225, 0x0233,
			0x0241, 0x024d, 0x0259, 0x0263, 0x026d, 0x0279, 0x0287, 0x0299,
			0x02b2, 0x02c2, 0x02e1, 0x02f3, 0x0301, 0x0313, 0x031d, 0x0327,
			0x0335, 0x033f, 0x033f, 0x034f, 0x035f, 0x036f, 0x037d, 0x0389,
			// Entry 40 - 7F
			0x039f, 0x03b1, 0x03b1, 0x03b9, 0x03b9, 0x03b9, 0x03bf, 0x03cf,
			0x03df, 0x03f1, 0x03fd, 0x0409, 0x0419, 0x0419, 0x0423, 0x0423,
			0x0431, 0x0445, 0x0451, 0x045f, 0x046f, 0x047b, 0x048b, 0x0497,
			0x0497, 0x04a3, 0x04b3, 0x04c1, 0x04d9, 0x04e7, 0x04e7, 0x04f7,
			0x0503, 0x0511, 0x0528, 0x0536, 0x054c, 0x0563, 0x056d, 0x057f,
			0x058f, 0x059d, 0x05ab, 0x05bc, 0x05ca, 0x05da, 0x05da, 0x05f7,
			0x0605, 0x0605, 0x0617, 0x0636, 0x0653, 0x0672, 0x0672, 0x067a,
			0x068c, 0x068c, 0x0696, 0x069e, 0x069e, 0x06ae, 0x06ae, 0x06bc,
			// Entry 80 - BF
			0x06c6, 0x06da, 0x06e4, 0x06f4, 0x06fe, 0x070c, 0x0716, 0x072a,
			0x073a, 0x073a, 0x0746, 0x0761, 0x076b, 0x077b, 0x078b, 0x079b,
			0x079b, 0x07a3, 0x07b3, 0x07c1, 0x07cd, 0x07d7, 0x07d7, 0x07e7,
			0x07f3, 0x0801, 0x080f, 0x081b, 0x0829, 0x0833, 0x0845, 0x0857,
			0x0857, 0x0867, 0x0873, 0x0873, 0x0881, 0x0881, 0x088f, 0x089f,
			0x08a7, 0x08b5, 0x08bf, 0x08cf, 0x08dd, 0x08dd, 0x08eb, 0x08f3,
			0x08fd, 0x0909, 0x0909, 0x0917, 0x091f, 0x0927, 0x0927, 0x0935,
			0x0941, 0x0941, 0x0941, 0x094d, 0x0955, 0x0955, 0x0955, 0x095f,
			// Entry C0 - FF
			0x095f, 0x095f, 0x095f, 0x096b, 0x096b, 0x097f, 0x097f, 0x098d,
			0x098d, 0x098d, 0x098d, 0x098d, 0x098d, 0x0997, 0x0997, 0x09a9,
			0x09a9, 0x09b5, 0x09b5, 0x09c1, 0x09c1, 0x09cb, 0x09cb, 0x09cb,
			0x09cb, 0x09cb, 0x09d5, 0x09d5, 0x09e1, 0x09e1, 0x09e1, 0x09e1,
			0x09f1, 0x09f1, 0x09f9, 0x09f9, 0x09f9, 0x09f9, 0x09f9, 0x09f9,
			0x09f9, 0x09f9, 0x0a05, 0x0a05, 0x0a05, 0x0a13, 0x0a13, 0x0a1f,
			0x0a1f, 0x0a1f, 0x0a1f, 0x0a1f, 0x0a1f, 0x0a2f, 0x0a3b, 0x0a3b,
			0x0a3b, 0x0a47, 0x0a4f, 0x0a4f, 0x0a5f, 0x0a5f, 0x0a6b, 0x0a77,
			// Entry 100 - 13F
			0x0a90, 0x0a90, 0x0a90, 0x0a90, 0x0a90, 0x0a90, 0x0a9e, 0x0aae,
			0x0abc, 0x0abc, 0x0abc, 0x0ac8, 0x0ac8, 0x0ad2, 0x0ad2, 0x0ae7,
			0x0ae7, 0x0af5, 0x0af5, 0x0b0a, 0x0b0a, 0x0b16, 0x0b22, 0x0b2a,
			0x0b2a, 0x0b2a, 0x0b36, 0x0b36, 0x0b36, 0x0b36, 0x0b48, 0x0b48,
			0x0b48, 0x0b5a, 0x0b5a, 0x0b60, 0x0b60, 0x0b60, 0x0b60, 0x0b60,
			0x0b60, 0x0b60, 0x0b6e, 0x0b72, 0x0b72, 0x0b72, 0x0b72, 0x0b72,
			0x0b72, 0x0b7a, 0x0b8c, 0x0b8c, 0x0b8c, 0x0b8c, 0x0b8c, 0x0b8c,
			0x0b9e, 0x0b9e, 0x0b9e, 0x0b9e, 0x0bc1, 0x0bc1, 0x0bc1, 0x0bcb,
			// Entry 140 - 17F
			0x0bd7, 0x0bd7, 0x0bd7, 0x0be5, 0x0be5, 0x0bf9, 0x0bf9, 0x0c07,
			0x0c1e, 0x0c1e, 0x0c2f, 0x0c40, 0x0c4a, 0x0c54, 0x0c62, 0x0c62,
			0x0c62, 0x0c62, 0x0c6e, 0x0c83, 0x0c83, 0x0c83, 0x0c83, 0x0c83,
			0x0c91, 0x0c91, 0x0c99, 0x0ca7, 0x0ca7, 0x0ca7, 0x0ca7, 0x0ca7,
			0x0cb9, 0x0cd1, 0x0cd1, 0x0cd1, 0x0cd1, 0x0cd1, 0x0cd1, 0x0ce6,
			0x0ce6, 0x0ce6, 0x0cee, 0x0d02, 0x0d02, 0x0d02, 0x0d12, 0x0d12,
			0x0d12, 0x0d12, 0x0d12, 0x0d12, 0x0d12, 0x0d12, 0x0d20, 0x0d2e,
			0x0d3a, 0x0d3a, 0x0d3a, 0x0d3a, 0x0d48, 0x0d48, 0x0d48, 0x0d48,
			// Entry 180 - 1BF
			0x0d48, 0x0d48, 0x0d48, 0x0d68, 0x0d68, 0x0d68, 0x0d68, 0x0d7f,
			0x0d7f, 0x0d7f, 0x0d7f, 0x0d7f, 0x0d7f, 0x0d89, 0x0d91, 0x0d91,
			0x0d91, 0x0d91, 0x0d91, 0x0d91, 0x0d91, 0x0d91, 0x0d91, 0x0d9f,
			0x0d9f, 0x0db2, 0x0db2, 0x0dbc, 0x0dc8, 0x0dd8, 0x0dd8, 0x0def,
			0x0df7, 0x0e03, 0x0e19, 0x0e19, 0x0e2b, 0x0e37, 0x0e41, 0x0e41,
			0x0e4f, 0x0e67, 0x0e73, 0x0e83, 0x0e83, 0x0e83, 0x0e83, 0x0e91,
			0x0ea5, 0x0ea5, 0x0ea5, 0x0ead, 0x0ead, 0x0ead, 0x0ead, 0x0eb9,
			0x0eb9, 0x0ec5, 0x0ed5, 0x0ed5, 0x0ed5, 0x0ed5, 0x0edb, 0x0edb,
			// Entry 1C0 - 1FF
			0x0ee7, 0x0ee7, 0x0ee7, 0x0ef5, 0x0ef5, 0x0ef5, 0x0ef5, 0x0ef5,
			0x0ef5, 0x0ef5, 0x0ef5, 0x0f09, 0x0f09, 0x0f09, 0x0f09, 0x0f09,
			0x0f09, 0x0f09, 0x0f09, 0x0f09, 0x0f09, 0x0f09, 0x0f09, 0x0f09,
			0x0f09, 0x0f11, 0x0f11, 0x0f11, 0x0f11, 0x0f11, 0x0f11, 0x0f11,
			0x0f1f, 0x0f1f, 0x0f1f, 0x0f1f, 0x0f1f, 0x0f2b, 0x0f40, 0x0f40,
			0x0f48, 0x0f48, 0x0f5a, 0x0f5a, 0x0f68, 0x0f68, 0x0f68, 0x0f76,
			0x0f76, 0x0f76, 0x0f76, 0x0f76, 0x0f76, 0x0f7e, 0x0f7e, 0x0f7e,
			0x0f9b, 0x0f9b, 0x0f9b, 0x0fab, 0x0fab, 0x0fab, 0x0fab, 0x0fab,
			// Entry 200 - 23F
			0x0fab, 0x0fc6, 0x0fdb, 0x0ff2, 0x1009, 0x1009, 0x1009, 0x1009,
			0x1009, 0x1015, 0x1015, 0x1015, 0x1015, 0x1015, 0x1023, 0x1023,
			0x1031, 0x1031, 0x1031, 0x1031, 0x1039, 0x1039, 0x1039, 0x1043,
			0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043,
			0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043, 0x1043,
			0x1051, 0x1051, 0x107f, 0x107f, 0x107f, 0x107f, 0x1096, 0x109c,
			0x109c, 0x109c, 0x109c, 0x109c, 0x109c, 0x109c, 0x10a6, 0x10b6,
			0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10c4, 0x10cc,
			// Entry 240 - 27F
			0x10cc, 0x10cc, 0x10d8, 0x10d8, 0x10d8, 0x10e8, 0x10e8, 0x10e8,
			0x10e8, 0x10e8, 0x10fa, 0x10fa, 0x1116, 0x1116, 0x1133, 0x1133,
			0x1133, 0x1133, 0x1133, 0x1133, 0x1156, 0x1177, 0x1177, 0x1177,
			0x1177, 0x1177, 0x1177, 0x1177, 0x1177, 0x1189, 0x1189, 0x1189,
			0x1189, 0x1189, 0x11a2, 0x11d1, 0x11f2,
		},
	},
	{ // vai
		"ꕉꕪꘋꕉꕆꕌꔸꕞꕌꖝꔆꕞꖩꔻꗂꔠꗸꘋꗩꕭꔷꗿꗡꕧꕮꔧꗥꗷꘋꕶꕱꕐꘊꔧꗨꗡꔻꘂꘋꗱꘋꔻꕌꖙꕢꔦꔺꖽꔟꗸꘋꔤꖆꕇꔻꘂꘋꔤꕼꔤꕚꔷꘂꘋꕧꕐꕇꔧꕧꕙꕇꔧ" +
			"ꕃꘈꗢꖏꔸꘂꘋꕮꔒꔀꗩꕆꔻꕇꕐꔷꗍꔿꖛꕨꔬꗁꔒꔻꕶꕿꕃꔤꖄꕆꕇꘂꘋꗐꖺꔻꘂꘋꕟꖙꕡꖇꕮꔷꖬꔨꗵꘋꕚꕆꔷꕚꔤꗋꕃꖳꖴꔓꕇꘂꘋꖺꖦꔲꕩꕯ" +
			"ꕆꔧꖎꖄꕑꕦꕇꔧꖮꖨꕙꔤ",
		[]uint16{ // 560 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0015, 0x0015,
			0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x001e, 0x002a, 0x0036,
			0x0036, 0x0036, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x003f, 0x003f, 0x003f, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045,
			0x004e, 0x004e, 0x004e, 0x004e, 0x0057, 0x005d, 0x005d, 0x0066,
			0x0066, 0x0066, 0x0075, 0x0075, 0x0075, 0x0075, 0x0075, 0x007e,
			0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x007e, 0x0087,
			0x0087, 0x008d, 0x008d, 0x008d, 0x008d, 0x0099, 0x0099, 0x0099,
			// Entry 40 - 7F
			0x0099, 0x00ab, 0x00ab, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00c0, 0x00c0, 0x00cc, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00e1, 0x00e1, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed, 0x00ed,
			0x00ed, 0x00ed, 0x00ed, 0x00f6, 0x00f6, 0x00ff, 0x00ff, 0x00ff,
			0x0108, 0x0108, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e,
			0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x0117, 0x0117, 0x0120,
			// Entry 80 - BF
			0x0120, 0x012c, 0x012c, 0x012c, 0x012c, 0x013b, 0x014a, 0x0153,
			0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
			0x0153, 0x0153, 0x015c, 0x015c, 0x015c, 0x015c, 0x015c, 0x015c,
			0x0168, 0x0168, 0x0171, 0x0171, 0x0171, 0x0177, 0x0177, 0x0177,
			0x0177, 0x0177, 0x017d, 0x017d, 0x017d, 0x017d, 0x017d, 0x018f,
			0x0195, 0x0195, 0x0195, 0x01a4, 0x01a4, 0x01a4, 0x01a4, 0x01a4,
			0x01a4, 0x01ad, 0x01ad, 0x01b6, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry C0 - FF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 100 - 13F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 140 - 17F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 180 - 1BF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 1C0 - 1FF
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			// Entry 200 - 23F
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01c2,
		},
	},
	{ // vai-Latn
		"AkaŋAmiháriLahabuBhelarusaŋBhɔgerɛŋBhɛŋgáliChɛJamáĩHɛlɛŋPooPanyɛĩPɛɛsiyɛ" +
			"ŋFɛŋsiHawusaHíiŋdiHɔŋgérɛŋÍndonisiyɛŋÍgboItáliyɛŋJapaníĩJavaníĩKimɛ" +
			"ɛ̃ tɛKoríyɛŋMaléeeBhɛmísiNipaliDɔchiPuŋjabhiPɔ́lésiPotokíiRomíniyɛŋ" +
			"RɔshiyɛŋRawundaSomáliSúwídɛŋTamíliTáiTɔ́kiYukureniyɛŋƆduViyamíĩYórób" +
			"haChaniĩZúluVai",
		[]uint16{ // 560 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0005, 0x000d, 0x000d,
			0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x0013, 0x001e, 0x0029,
			0x0029, 0x0029, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0038, 0x0038, 0x0038, 0x0038, 0x0038,
			0x003f, 0x003f, 0x003f, 0x003f, 0x0047, 0x004a, 0x004a, 0x0052,
			0x0052, 0x0052, 0x005e, 0x005e, 0x005e, 0x005e, 0x005e, 0x0065,
			0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x0065, 0x006b,
			0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0080, 0x0080, 0x0080,
			// Entry 40 - 7F
			0x0080, 0x008e, 0x008e, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x009e, 0x009e, 0x00a7, 0x00b0, 0x00b0, 0x00b0, 0x00b0, 0x00b0,
			0x00b0, 0x00b0, 0x00bd, 0x00bd, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7, 0x00c7,
			0x00c7, 0x00c7, 0x00c7, 0x00ce, 0x00ce, 0x00d7, 0x00d7, 0x00d7,
			0x00dd, 0x00dd, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3,
			0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00e3, 0x00ec, 0x00ec, 0x00f6,
			// Entry 80 - BF
			0x00f6, 0x00fe, 0x00fe, 0x00fe, 0x00fe, 0x010a, 0x0115, 0x011c,
			0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c, 0x011c,
			0x011c, 0x011c, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123,
			0x012e, 0x012e, 0x0135, 0x0135, 0x0135, 0x0139, 0x0139, 0x0139,
			0x0139, 0x0139, 0x0140, 0x0140, 0x0140, 0x0140, 0x0140, 0x014d,
			0x0151, 0x0151, 0x0151, 0x015a, 0x015a, 0x015a, 0x015a, 0x015a,
			0x015a, 0x0163, 0x0163, 0x016a, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry C0 - FF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 100 - 13F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 140 - 17F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 180 - 1BF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 1C0 - 1FF
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			// Entry 200 - 23F
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
			0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x0172,
		},
	},
	{ // vi
		viLangStr,
		viLangIdx,
	},
	{ // vun
		"KiakanyiKiamharyiKyiarabuKyibelarusiKyibulgaryiaKyibanglaKyicheckiKyijer" +
			"umaniKyigirikiKyingerezaKyihispaniaKyiajemiKyifaransaKyihausaKyihind" +
			"iKyihungariKyiindonesiaKyiigboKyiitalianoKyijapaniKyijavaKyikambodia" +
			"KyikoreaKyimalesiaKyiburmaKyinepaliKyiholanziKyipunjabiKyipolandiKyi" +
			"renoKyiromaniaKyirusiKyinyarwandaKyisomalyiKyiswidiKyitamilKyitailan" +
			"diKyiturukyiKyiukraniaKyiurduKyivietinamuKyiyorubaKyichinaKyizuluKyi" +
			"vunjo",
		[]uint16{ // 567 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0008, 0x0011, 0x0011,
			0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0019, 0x0024, 0x0030,
			0x0030, 0x0030, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0042, 0x0042, 0x0042, 0x0042, 0x0042,
			0x004d, 0x004d, 0x004d, 0x004d, 0x0056, 0x0060, 0x0060, 0x006b,
			0x006b, 0x006b, 0x0073, 0x0073, 0x0073, 0x0073, 0x0073, 0x007d,
			0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x007d, 0x0085,
			0x0085, 0x008d, 0x008d, 0x008d, 0x008d, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00aa, 0x00aa, 0x00aa, 0x00aa, 0x00aa,
			0x00b5, 0x00b5, 0x00be, 0x00c5, 0x00c5, 0x00c5, 0x00c5, 0x00c5,
			0x00c5, 0x00c5, 0x00d0, 0x00d0, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
			0x00d8, 0x00d8, 0x00d8, 0x00e2, 0x00e2, 0x00ea, 0x00ea, 0x00ea,
			0x00f3, 0x00f3, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd,
			0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x00fd, 0x0107, 0x0107, 0x0111,
			// Entry 80 - BF
			0x0111, 0x0118, 0x0118, 0x0118, 0x0118, 0x0122, 0x0129, 0x0135,
			0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
			0x0135, 0x0135, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f, 0x013f,
			0x0147, 0x0147, 0x014f, 0x014f, 0x014f, 0x015a, 0x015a, 0x015a,
			0x015a, 0x015a, 0x0164, 0x0164, 0x0164, 0x0164, 0x0164, 0x016e,
			0x0175, 0x0175, 0x0175, 0x0181, 0x0181, 0x0181, 0x0181, 0x0181,
			0x0181, 0x018a, 0x018a, 0x0192, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry C0 - FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 100 - 13F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 140 - 17F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 180 - 1BF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 1C0 - 1FF
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			// Entry 200 - 23F
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199,
			0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x0199, 0x01a1,
		},
	},
	{ // wae
		"AbčasišAfrikánsAmharišArabišAssamesišAymaraSerbaidšanišWísrussišBulgariš" +
			"BengališTibetišBosnišKatalanišTšečišWalisišDänišTitšMalediwišButaniš" +
			"GričišEnglišSchpanišEstnišBaskišPersišFinišFidšianišWälšIrišGalizišG" +
			"uaraniGujaratiHausaHebräišHindiKroatišHaitianišUngarišArmenišIndones" +
			"išIgboIisländišItalienišJapanišGeorgišKazačišKambodšanišKannadaKorea" +
			"nišKašmirišKurdišKirgisišLatinišLuxemburgišLingalaLaotišLitauišLetti" +
			"šMalagásiMaoriMazedonišMalayalamMongolišMarathiMalaíšMaltesišBurmes" +
			"išNordndebeleNepalesišHoländišNorwegiš NynorskNorwegiš BokmålNyanjaO" +
			"riyaOsétišPandšabišPolnišPaštuPortugisišQuečuaRätromanišRundiRumäniš" +
			"RusišRuandišSanskritSindhiNordsamišSangoSingalesišSlowakišSlowenišSa" +
			"moanišShonaSomališAlbanišSerbišSwaziSüdsothoSundanesišSchwedišSuahel" +
			"išTamilišTeluguTadšikišThailändišTigrinjaTurkmenišTswanaTongaTürkišT" +
			"songaTaitišUigurišUkrainišUrduUsbekišVendaVietnamesišWolofXhosaYorub" +
			"aChinesišZuluEfikFilipinišHawaíanišNordsothoJakutišTetumNiwmelanesiš" +
			"Unbekannti SchpračWalserÖštričišes TitšSchwizer HočtitšAuštrališes E" +
			"nglišKanadišes EnglišBritišes EnglišAmerikanišes EnglišLatiamerikani" +
			"šes SchpanišIberišes SchpanišKanadišes WälšSchwizer WälšFlämišBrasi" +
			"lianišes PortugisišIberišes PortugisišVereifačts ChinesišTraditionel" +
			"ls Chinesiš",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0009, 0x0009, 0x0012, 0x0012, 0x001a, 0x001a,
			0x0021, 0x002b, 0x002b, 0x0031, 0x003f, 0x003f, 0x004a, 0x0053,
			0x0053, 0x0053, 0x005c, 0x0064, 0x0064, 0x006b, 0x0075, 0x0075,
			0x0075, 0x0075, 0x0075, 0x007e, 0x007e, 0x007e, 0x0086, 0x008d,
			0x0092, 0x009c, 0x00a4, 0x00a4, 0x00ac, 0x00b3, 0x00b3, 0x00bc,
			0x00c3, 0x00ca, 0x00d1, 0x00d1, 0x00d7, 0x00e2, 0x00e2, 0x00e8,
			0x00e8, 0x00ed, 0x00ed, 0x00f5, 0x00fc, 0x0104, 0x0104, 0x0109,
			0x0112, 0x0117, 0x0117, 0x011f, 0x0129, 0x0131, 0x0139, 0x0139,
			// Entry 40 - 7F
			0x0139, 0x0143, 0x0143, 0x0147, 0x0147, 0x0147, 0x0147, 0x0152,
			0x015c, 0x015c, 0x0164, 0x0164, 0x016c, 0x016c, 0x016c, 0x016c,
			0x0175, 0x0175, 0x0182, 0x0189, 0x0192, 0x0192, 0x019c, 0x01a3,
			0x01a3, 0x01a3, 0x01ac, 0x01b4, 0x01c0, 0x01c0, 0x01c0, 0x01c7,
			0x01ce, 0x01d6, 0x01d6, 0x01dd, 0x01e6, 0x01e6, 0x01eb, 0x01f5,
			0x01fe, 0x0207, 0x020e, 0x0216, 0x021f, 0x0228, 0x0228, 0x0233,
			0x023d, 0x023d, 0x0247, 0x0258, 0x0269, 0x0269, 0x0269, 0x026f,
			0x026f, 0x026f, 0x026f, 0x0274, 0x027c, 0x0287, 0x0287, 0x028e,
			// Entry 80 - BF
			0x0294, 0x029f, 0x02a6, 0x02b2, 0x02b7, 0x02c0, 0x02c6, 0x02ce,
			0x02d6, 0x02d6, 0x02dc, 0x02e6, 0x02eb, 0x02f6, 0x02ff, 0x0308,
			0x0311, 0x0316, 0x031e, 0x0326, 0x032d, 0x0332, 0x033b, 0x0346,
			0x034f, 0x0358, 0x0360, 0x0366, 0x0370, 0x037c, 0x0384, 0x038e,
			0x0394, 0x0399, 0x03a1, 0x03a7, 0x03a7, 0x03ae, 0x03b6, 0x03bf,
			0x03c3, 0x03cb, 0x03d0, 0x03dc, 0x03dc, 0x03dc, 0x03e1, 0x03e6,
			0x03e6, 0x03ec, 0x03ec, 0x03f5, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			// Entry C0 - FF
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			// Entry 100 - 13F
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9,
			0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03f9, 0x03fd,
			0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd, 0x03fd,
			0x03fd, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407, 0x0407,
			// Entry 140 - 17F
			0x0407, 0x0407, 0x0407, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			// Entry 180 - 1BF
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412,
			0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x0412, 0x041b,
			// Entry 1C0 - 1FF
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b, 0x041b,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			// Entry 200 - 23F
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423,
			0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0423, 0x0428, 0x0428,
			0x0428, 0x0428, 0x0428, 0x0428, 0x0428, 0x0428, 0x0428, 0x0428,
			0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435,
			0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0435, 0x0448, 0x0448,
			0x0448, 0x0448, 0x0448, 0x0448, 0x0448, 0x0448, 0x0448, 0x044e,
			0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			// Entry 240 - 27F
			0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e, 0x044e,
			0x0462, 0x0474, 0x0489, 0x049b, 0x04ac, 0x04c1, 0x04dc, 0x04ef,
			0x04ef, 0x04ef, 0x0500, 0x050f, 0x050f, 0x0517, 0x0531, 0x0546,
			0x0546, 0x0546, 0x0546, 0x055b, 0x0572,
		},
	},
	{ // xog
		"OluakaaniOluamharikiOluwarabuOlubelarusiOlubulugariyaOlubengaliOluceekeO" +
			"ludaakiOluyonaaniOlungerezaOlusipanyaOluperusiOlufalansaOluhawuzaOlu" +
			"hinduOluhangareOluyindonezyaOluyiboOluyitaleOlujapaniOlunnajjavaOluk" +
			"meOlukoreyaOlumalayiOlubbamaOlunepaliOluholandiOlupunjabiOlupolandiO" +
			"lupotugiiziOlulomaniyaOlulasaOlunarwandaOlusomaliyaOluswideniOlutami" +
			"iruOluttaayiOlutakeOluyukurayineOlu-uruduOluvyetinaamuOluyorubaOluca" +
			"yinaOluzzuluOlusoga",
		[]uint16{ // 576 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0009, 0x0014, 0x0014,
			0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x001d, 0x0028, 0x0035,
			0x0035, 0x0035, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f,
			0x003f, 0x003f, 0x003f, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
			0x004f, 0x004f, 0x004f, 0x004f, 0x0059, 0x0063, 0x0063, 0x006d,
			0x006d, 0x006d, 0x0076, 0x0076, 0x0076, 0x0076, 0x0076, 0x0080,
			0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089,
			0x0089, 0x0091, 0x0091, 0x0091, 0x0091, 0x009b, 0x009b, 0x009b,
			// Entry 40 - 7F
			0x009b, 0x00a8, 0x00a8, 0x00af, 0x00af, 0x00af, 0x00af, 0x00af,
			0x00b8, 0x00b8, 0x00c1, 0x00cc, 0x00cc, 0x00cc, 0x00cc, 0x00cc,
			0x00cc, 0x00cc, 0x00d2, 0x00d2, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db, 0x00db,
			0x00db, 0x00db, 0x00db, 0x00e4, 0x00e4, 0x00ec, 0x00ec, 0x00ec,
			0x00f5, 0x00f5, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
			0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x0109, 0x0109, 0x0113,
			// Entry 80 - BF
			0x0113, 0x011f, 0x011f, 0x011f, 0x011f, 0x012a, 0x0131, 0x013c,
			0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x0151, 0x0151, 0x015b, 0x015b, 0x015b, 0x0164, 0x0164, 0x0164,
			0x0164, 0x0164, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x0178,
			0x0181, 0x0181, 0x0181, 0x018e, 0x018e, 0x018e, 0x018e, 0x018e,
			0x018e, 0x0197, 0x0197, 0x01a0, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry C0 - FF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 100 - 13F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 140 - 17F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 180 - 1BF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 1C0 - 1FF
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			// Entry 200 - 23F
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8,
			0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01a8, 0x01af,
		},
	},
	{ // yav
		"akánɛamalíképakaspielúsebulgálɛpengálɛ́ɛcɛ́kɛ́ɛŋndiámanyavánɛíŋgilísénu" +
			"ɛspanyɔ́lɛnupɛ́lisɛfeleŋsípakasíndíɔ́ŋgɛíndonísiɛíboitáliɛndiámanyá" +
			"vanɛkímɛɛkolíemáliɛbímanɛnunipálɛnilándɛnupunsapíɛ́nupolonɛ́ɛnupɔlit" +
			"ukɛ́ɛnulumɛ́ŋɛnulúsenuluándɛ́ɛnusomalíɛnusuetuanutámulenutáyɛnutúluk" +
			"enukeleniɛ́ŋɛnulutúnufiɛtnamíɛŋnuyolúpasinúɛnusulúnuasue",
		[]uint16{ // 579 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0007, 0x000f, 0x000f,
			0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x0016, 0x001e, 0x0027,
			0x0027, 0x0027, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034, 0x0034,
			0x0034, 0x0034, 0x0034, 0x0040, 0x0040, 0x0040, 0x0040, 0x0040,
			0x004a, 0x004a, 0x004a, 0x004a, 0x0052, 0x005e, 0x005e, 0x006e,
			0x006e, 0x006e, 0x007a, 0x007a, 0x007a, 0x007a, 0x007a, 0x0083,
			0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0083, 0x0088,
			0x0088, 0x008e, 0x008e, 0x008e, 0x008e, 0x0097, 0x0097, 0x0097,
			// Entry 40 - 7F
			0x0097, 0x00a3, 0x00a3, 0x00a7, 0x00a7, 0x00a7, 0x00a7, 0x00a7,
			0x00af, 0x00af, 0x00b7, 0x00bf, 0x00bf, 0x00bf, 0x00bf, 0x00bf,
			0x00bf, 0x00bf, 0x00c7, 0x00c7, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd, 0x00cd,
			0x00cd, 0x00cd, 0x00cd, 0x00d4, 0x00d4, 0x00dc, 0x00dc, 0x00dc,
			0x00e6, 0x00e6, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef,
			0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00ef, 0x00fd, 0x00fd, 0x010a,
			// Entry 80 - BF
			0x010a, 0x011a, 0x011a, 0x011a, 0x011a, 0x0127, 0x012e, 0x013c,
			0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c, 0x013c,
			0x013c, 0x013c, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147,
			0x014f, 0x014f, 0x0158, 0x0158, 0x0158, 0x0160, 0x0160, 0x0160,
			0x0160, 0x0160, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0179,
			0x0180, 0x0180, 0x0180, 0x0190, 0x0190, 0x0190, 0x0190, 0x0190,
			0x0190, 0x0199, 0x0199, 0x01a0, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry C0 - FF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 100 - 13F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 140 - 17F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 180 - 1BF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 1C0 - 1FF
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 200 - 23F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 240 - 27F
			0x01a7, 0x01a7, 0x01ad,
		},
	},
	{ // yi
		"אַפֿאַראַפֿריקאַנסאַמהאַרישאַראַגאנישאַראַבישאַסאַמישאַזערביידזשאַנישבעל" +
			"אַרוסישבולגאַרישבענגאַלישטיבעטישברעטאנישבאסנישקאַטאַלאנישטשעכישקלוי" +
			"סטער־סלאַווישוועלשישדענישדײַטשגריכישענגלישעספּעראַנטאשפּאַנישעסטישב" +
			"אַסקישפּערסישפֿינישפֿידזשיפֿאַראישפֿראַנצויזישמערב־פֿריזישאירישסקאט" +
			"יש געלישגאַלישישמאַנקסהאַוסאַהעברעאישהינדיקראאַטישאונגערישאַרמענישא" +
			"ינדאנעזישאידאאיסלאַנדישאיטאַליענישיאַפּאַנישיאַוואַנעזישגרוזינישקאַ" +
			"זאַכישכמערקאַנאַדאַקארעאישקורדישקארנישקירגיזישלאטיינישלוקסעמבורגישל" +
			"אַאליטווישלעטישמאַארישמאַקעדאנישמאַלאַיאַלאַםמאנגאלישמאַלטעזישבירמא" +
			"ַנישנעפּאַלישהאלענדישנײַ־נארוועגישנארוועגישאקסיטאַנישאסעטישפּוילישפ" +
			"ּאַשטאָפּארטוגעזישרומענישרוסישסאַנסקריטסאַרדישסינדהינארדסאַמישסינהא" +
			"ַלישסלאוואַקישסלאווענישסאַמאאַניששאנאַסאמאַלישאַלבאַנישסערביששוועדי" +
			"שסוואַהילישטאַמילטורקמענישטאָטערישאוקראַאינישאורדואוזבעקישוויעטנאַמ" +
			"עזישוואלאַפּוקייִדישכינעזישזולואַקאַדישאַלט ענגלישאַראַמישבאַלינעזי" +
			"שבײַערישסעבואַנישקרים־טערקישקאַשובישאונטער־סארבישזשאלא־פֿאנימיטל ענ" +
			"גלישפֿיליפּינאאַלט־פֿראַנצויזישדרום־פֿריזישמזרח־פֿריזישמיטל הויכדוי" +
			"טשאַלט־ הויכדויטשגאטישאוראַלט־גריכישפידזשי הינדיאייבער־סארבישלאזשבא" +
			"ָןיידיש־פערסישלאַדינאליווישמיזאנאַפּאליטַנישנידערדײַטשאַלט פּערסישפ" +
			"ּרייסישרוסינישסיציליאַנישסקאטסאַלט־אירישאונטער שלעזישslyסומערישקאמא" +
			"ריששלעזישטיגרעאומבאַוואוסטע שפּראַךמערב פֿלעמישפֿלעמישסערבא־קראאַטי" +
			"שקאנגא־סוואַהיליש",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x000e, 0x000e, 0x000e, 0x0024, 0x0024, 0x0036, 0x004a,
			0x005a, 0x006a, 0x006a, 0x006a, 0x008a, 0x008a, 0x009e, 0x00b0,
			0x00b0, 0x00b0, 0x00c2, 0x00d0, 0x00e0, 0x00ec, 0x0102, 0x0102,
			0x0102, 0x0102, 0x0102, 0x010e, 0x0130, 0x0130, 0x013e, 0x0148,
			0x0152, 0x0152, 0x0152, 0x0152, 0x015e, 0x016a, 0x0180, 0x0190,
			0x019a, 0x01a8, 0x01b6, 0x01b6, 0x01c2, 0x01d0, 0x01e0, 0x01f8,
			0x0210, 0x021a, 0x0231, 0x0241, 0x0241, 0x0241, 0x024d, 0x025b,
			0x026b, 0x0275, 0x0275, 0x0285, 0x0285, 0x0295, 0x02a5, 0x02a5,
			// Entry 40 - 7F
			0x02a5, 0x02b9, 0x02b9, 0x02b9, 0x02b9, 0x02b9, 0x02c1, 0x02d5,
			0x02eb, 0x02eb, 0x02ff, 0x0317, 0x0327, 0x0327, 0x0327, 0x0327,
			0x0339, 0x0339, 0x0341, 0x0353, 0x0361, 0x0361, 0x0361, 0x036d,
			0x036d, 0x0379, 0x0389, 0x0399, 0x03b1, 0x03b1, 0x03b1, 0x03b1,
			0x03b9, 0x03c7, 0x03c7, 0x03d1, 0x03d1, 0x03d1, 0x03df, 0x03f3,
			0x040d, 0x041d, 0x041d, 0x041d, 0x042f, 0x0441, 0x0441, 0x0441,
			0x0453, 0x0453, 0x0463, 0x047d, 0x048f, 0x048f, 0x048f, 0x048f,
			0x04a3, 0x04a3, 0x04a3, 0x04a3, 0x04af, 0x04af, 0x04af, 0x04bd,
			// Entry 80 - BF
			0x04cd, 0x04e3, 0x04e3, 0x04e3, 0x04e3, 0x04f1, 0x04fb, 0x04fb,
			0x050d, 0x051b, 0x0527, 0x053b, 0x053b, 0x054d, 0x0561, 0x0573,
			0x0587, 0x0591, 0x05a1, 0x05b3, 0x05bf, 0x05bf, 0x05bf, 0x05bf,
			0x05cd, 0x05e1, 0x05ed, 0x05ed, 0x05ed, 0x05ed, 0x05ed, 0x05ff,
			0x05ff, 0x05ff, 0x05ff, 0x05ff, 0x060f, 0x060f, 0x060f, 0x0625,
			0x062f, 0x063f, 0x063f, 0x0659, 0x066d, 0x066d, 0x066d, 0x066d,
			0x0679, 0x0679, 0x0679, 0x0687, 0x068f, 0x068f, 0x068f, 0x068f,
			0x068f, 0x068f, 0x068f, 0x068f, 0x068f, 0x069f, 0x069f, 0x069f,
			// Entry C0 - FF
			0x069f, 0x069f, 0x06b4, 0x06b4, 0x06c4, 0x06c4, 0x06c4, 0x06c4,
			0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4, 0x06c4,
			0x06c4, 0x06c4, 0x06c4, 0x06d8, 0x06e6, 0x06e6, 0x06e6, 0x06e6,
			0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6,
			0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6,
			0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6,
			0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06e6, 0x06f8, 0x06f8, 0x06f8,
			0x06f8, 0x06f8, 0x06f8, 0x06f8, 0x06f8, 0x06f8, 0x06f8, 0x06f8,
			// Entry 100 - 13F
			0x06f8, 0x06f8, 0x06f8, 0x070e, 0x070e, 0x071e, 0x071e, 0x071e,
			0x071e, 0x071e, 0x071e, 0x071e, 0x071e, 0x071e, 0x071e, 0x0738,
			0x0738, 0x0738, 0x0738, 0x074e, 0x074e, 0x074e, 0x074e, 0x074e,
			0x074e, 0x074e, 0x074e, 0x074e, 0x0763, 0x0763, 0x0763, 0x0763,
			0x0763, 0x0777, 0x0777, 0x0777, 0x0777, 0x0777, 0x0799, 0x0799,
			0x07b1, 0x07c9, 0x07c9, 0x07c9, 0x07c9, 0x07c9, 0x07c9, 0x07c9,
			0x07c9, 0x07c9, 0x07c9, 0x07c9, 0x07e4, 0x0801, 0x0801, 0x0801,
			0x0801, 0x080b, 0x080b, 0x0827, 0x0827, 0x0827, 0x0827, 0x0827,
			// Entry 140 - 17F
			0x0827, 0x0827, 0x0827, 0x0827, 0x083e, 0x083e, 0x083e, 0x083e,
			0x0858, 0x0858, 0x0858, 0x0858, 0x0858, 0x0858, 0x0858, 0x0858,
			0x0858, 0x0868, 0x0868, 0x0868, 0x0880, 0x0880, 0x0880, 0x0880,
			0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880,
			0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880,
			0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880,
			0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880, 0x0880,
			0x0880, 0x0880, 0x0880, 0x088e, 0x088e, 0x088e, 0x088e, 0x088e,
			// Entry 180 - 1BF
			0x088e, 0x088e, 0x089a, 0x089a, 0x089a, 0x089a, 0x089a, 0x089a,
			0x089a, 0x089a, 0x089a, 0x089a, 0x089a, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2, 0x08a2,
			0x08a2, 0x08a2, 0x08bc, 0x08bc, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			// Entry 1C0 - 1FF
			0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0, 0x08d0,
			0x08d0, 0x08e7, 0x08e7, 0x08e7, 0x08e7, 0x08e7, 0x08e7, 0x08f7,
			0x08f7, 0x08f7, 0x08f7, 0x08f7, 0x08f7, 0x08f7, 0x08f7, 0x08f7,
			0x08f7, 0x08f7, 0x08f7, 0x0905, 0x0905, 0x0905, 0x0905, 0x0905,
			0x0905, 0x0905, 0x0905, 0x0905, 0x0905, 0x0905, 0x0905, 0x0905,
			0x091b, 0x0925, 0x0925, 0x0925, 0x0925, 0x0925, 0x0925, 0x0925,
			0x0925, 0x0939, 0x0939, 0x0939, 0x0939, 0x0939, 0x0939, 0x0952,
			// Entry 200 - 23F
			0x0955, 0x0955, 0x0955, 0x0955, 0x0955, 0x0955, 0x0955, 0x0955,
			0x0955, 0x0955, 0x0955, 0x0955, 0x0955, 0x0963, 0x0971, 0x0971,
			0x0971, 0x097d, 0x097d, 0x097d, 0x097d, 0x097d, 0x097d, 0x0987,
			0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987,
			0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987,
			0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x0987, 0x09b0, 0x09b0,
			0x09b0, 0x09b0, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7,
			0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7,
			// Entry 240 - 27F
			0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7,
			0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7,
			0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7,
			0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09c7, 0x09d5, 0x09d5, 0x09d5,
			0x09d5, 0x09f1, 0x0a11,
		},
	},
	{ // yo
		"Èdè AfrikaniÈdè AkaniÈdè AmarikiÈdè ArabikiTi AssamÈdè AzerbaijaniÈdè Be" +
			"larusiÈdè BugariaÈdè BengaliÈdè BretoniÈdè BosniaÈdè CatalaÈdè seeki" +
			"Èdè WelshiÈdè Ilẹ̀ DenmarkÈdè Ilẹ̀ GemaniÈdè GirikiÈdè Gẹ̀ẹ́sìÈdè E" +
			"sperantoÈdè SipanisiÈdè EstoniaÈdè BaskiÈdè PasiaÈdè FinisiÈdè Faroe" +
			"siÈdè FaranséÈdè FrisiaÈdè IrelandÈdè Gaelik ti Ilu ScotlandÈdè Gali" +
			"ciaÈdè GuaraniÈdè GujaratiÈdè HausaÈdè HeberuÈdè HindiÈdè KroatiaÈdè" +
			" HungariaÈdè Ile ArmeniaÈdè pipoÈdè IndonasiaIru ÈdèÈdè IboÈdè Icela" +
			"ndicÈdè ItalianiÈdè JapanisiÈdè JavanasiÈdè GeorgiaÈdè kameriÈdè Kan" +
			"nadaÈdè KoriaÈdè LatiniÈdè LithuaniaÈdè LatvianuÈdè MacedoniaÈdè mar" +
			"athiÈdè MalayaÈdè MaltaÈdè BumiisiÈdè NepaliÈdè DukiÈdè NorwayÈdè Oc" +
			"citaniÈdè PunjabiÈdè Ilẹ̀ PolandiÈdè PọtugiÈdè RomaniaÈdè ̣RọọsiaÈdè" +
			" RuwandaÈdè awon ara IndoÈdè SindhiÈdè SinhaleseÈdè SlovakiÈdè Slove" +
			"niaÈdè ara SomaliaÈdè AlbaniaÈdè SerbiaÈdè SesotoÈdè SudaniÈdè Suwid" +
			"iisiÈdè SwahiliÈdè TamiliÈdè TeluguÈdè TaiÈdè TigrinyaÈdè TurkmenÈdè" +
			" TọọkisiÈdè UkaniaÈdè UduÈdè UzbekÈdè JetinamuÈdè XhosaÈdè YiddishiÈ" +
			"dè YorùbáÈdè MandariÈdè ṢuluÈdè TagalogiÈdè KlingoniÈdè Serbo-Croati" +
			"ani",
		[]uint16{ // 610 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x000e, 0x0019, 0x0026, 0x0026,
			0x0033, 0x003b, 0x003b, 0x003b, 0x004c, 0x004c, 0x005a, 0x0067,
			0x0067, 0x0067, 0x0074, 0x0074, 0x0081, 0x008d, 0x0099, 0x0099,
			0x0099, 0x0099, 0x0099, 0x00a4, 0x00a4, 0x00a4, 0x00b0, 0x00c5,
			0x00d9, 0x00d9, 0x00d9, 0x00d9, 0x00e5, 0x00f9, 0x0108, 0x0116,
			0x0123, 0x012e, 0x0139, 0x0139, 0x0145, 0x0145, 0x0152, 0x0160,
			0x016c, 0x0179, 0x0195, 0x01a2, 0x01af, 0x01bd, 0x01bd, 0x01c8,
			0x01d4, 0x01df, 0x01df, 0x01ec, 0x01ec, 0x01fa, 0x020b, 0x020b,
			// Entry 40 - 7F
			0x0215, 0x0224, 0x022d, 0x0236, 0x0236, 0x0236, 0x0236, 0x0245,
			0x0253, 0x0253, 0x0261, 0x026f, 0x027c, 0x027c, 0x027c, 0x027c,
			0x027c, 0x027c, 0x0288, 0x0295, 0x02a0, 0x02a0, 0x02a0, 0x02a0,
			0x02a0, 0x02a0, 0x02a0, 0x02ac, 0x02ac, 0x02ac, 0x02ac, 0x02ac,
			0x02ac, 0x02bb, 0x02bb, 0x02c9, 0x02c9, 0x02c9, 0x02c9, 0x02d8,
			0x02d8, 0x02d8, 0x02e5, 0x02f1, 0x02fc, 0x0309, 0x0309, 0x0309,
			0x0315, 0x0315, 0x031f, 0x031f, 0x032b, 0x032b, 0x032b, 0x032b,
			0x0339, 0x0339, 0x0339, 0x0339, 0x0339, 0x0346, 0x0346, 0x035b,
			// Entry 80 - BF
			0x035b, 0x0369, 0x0369, 0x0369, 0x0369, 0x0376, 0x0388, 0x0395,
			0x03a8, 0x03a8, 0x03b4, 0x03b4, 0x03b4, 0x03c3, 0x03d0, 0x03de,
			0x03de, 0x03de, 0x03ef, 0x03fc, 0x0408, 0x0408, 0x0414, 0x0420,
			0x042f, 0x043c, 0x0448, 0x0454, 0x0454, 0x045d, 0x046b, 0x0478,
			0x0478, 0x0478, 0x0489, 0x0489, 0x0489, 0x0489, 0x0489, 0x0495,
			0x049e, 0x04a9, 0x04a9, 0x04b7, 0x04b7, 0x04b7, 0x04b7, 0x04c2,
			0x04d0, 0x04de, 0x04de, 0x04eb, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			// Entry C0 - FF
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			// Entry 100 - 13F
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7, 0x04f7,
			0x04f7, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 140 - 17F
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 180 - 1BF
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 1C0 - 1FF
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			// Entry 200 - 23F
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505, 0x0505,
			0x0505, 0x0505, 0x0505, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			// Entry 240 - 27F
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513, 0x0513,
			0x0513, 0x0528,
		},
	},
	{ // yo-BJ
		"Èdè Ilɛ̀ DenmarkÈdè Ilɛ̀ GemaniÈdè Gɛ̀ɛ́sìÈdè Ilɛ̀ PolandiÈdè PɔtugiÈdè " +
			"̣RɔɔsiaÈdè TɔɔkisiÈdè Shulu",
		[]uint16{ // 181 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014,
			0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			// Entry 40 - 7F
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039,
			0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x0039, 0x004d,
			// Entry 80 - BF
			0x004d, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x006a, 0x006a,
			0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
			0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
			0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a, 0x006a,
			0x006a, 0x006a, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079,
			0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079, 0x0079,
			0x0079, 0x0079, 0x0079, 0x0079, 0x0084,
		},
	},
	{ // yue
		"阿法文阿布哈茲文阿緯斯陀文南非荷蘭文阿坎文阿姆哈拉文阿拉貢文阿拉伯文阿薩姆文阿瓦爾文艾馬拉文亞塞拜然文巴什客爾文白俄羅斯文保加利亞文比斯拉馬文班" +
			"巴拉文孟加拉文藏文布列塔尼文波士尼亞文加泰羅尼亞文車臣文查莫洛文科西嘉文克裡文捷克文宗教斯拉夫文楚瓦什文威爾斯文丹麥文德文迪維西文宗" +
			"卡文埃維文希臘文英文世界文西班牙文愛沙尼亞文巴斯克文波斯文富拉文芬蘭文斐濟文法羅文法文西弗里西亞文愛爾蘭文蘇格蘭蓋爾文加利西亞文瓜拉" +
			"尼文古吉拉特文曼島文豪撒文希伯來文北印度文西里莫圖土文克羅埃西亞文海地文匈牙利文亞美尼亞文赫雷羅文國際文印尼文國際文（E）伊布文四川" +
			"彝文依奴皮維克文伊多文冰島文義大利文因紐特文日文爪哇文喬治亞文剛果文吉庫尤文廣亞馬文哈薩克文格陵蘭文高棉文坎那達文韓文卡努裡文喀什米" +
			"爾文庫爾德文科米文康瓦耳文吉爾吉斯文拉丁文盧森堡文干達文林堡文林加拉文寮文立陶宛文魯巴加丹加文拉脫維亞文馬拉加什文馬紹爾文毛利文馬其" +
			"頓文馬來亞拉姆文蒙古文馬拉地文馬來文馬爾他文緬甸文諾魯文北地畢列文尼泊爾文恩東加文荷蘭文耐諾斯克挪威文巴克摩挪威文南地畢列文納瓦霍文" +
			"尼揚賈文奧克西坦文奧杰布瓦文奧羅莫文歐利亞文奧塞提文旁遮普文巴利文波蘭文普什圖文葡萄牙文蓋楚瓦文羅曼斯文隆迪文羅馬尼亞文俄文盧安達文" +
			"梵文撒丁文信德文北方薩米文桑戈文僧伽羅文斯洛伐克文斯洛維尼亞文薩摩亞文塞內加爾文索馬利文阿爾巴尼亞文塞爾維亞文斯瓦特文塞索托文巽他文" +
			"瑞典文史瓦希里文坦米爾文泰盧固文塔吉克文泰文提格利尼亞文土庫曼文突尼西亞文東加文土耳其文特松加文韃靼文大溪地文維吾爾文烏克蘭文烏都文" +
			"烏茲別克文溫達文越南文沃拉普克文瓦隆文沃洛夫文科薩文意第緒文約魯巴文壯文中文祖魯文亞齊文阿僑利文阿當莫文阿迪各文突尼斯阿拉伯文阿弗里" +
			"希利文亞罕文阿伊努文阿卡德文阿拉巴馬文阿留申文蓋格阿爾巴尼亞文南阿爾泰文古英文昂加文阿拉米文馬普切文阿拉奧納文阿拉帕霍文阿爾及利亞阿" +
			"拉伯文阿拉瓦克文摩洛哥阿拉伯文埃及阿拉伯文阿蘇文美國手語阿斯圖里亞文科塔瓦文阿瓦文俾路支文峇里文巴伐利亞文巴薩文巴姆穆文巴塔克托巴文" +
			"戈馬拉文貝扎文別姆巴文貝塔維文貝納文富特文巴達加文西俾路支文博傑普爾文比科爾文比尼文班亞爾文康姆文錫克錫卡文比什奴普萊利亞文巴赫蒂亞" +
			"里文布拉杰文布拉維文博多文阿庫色文布里阿特文布吉斯文布魯文比林文梅敦巴文卡多文加勒比文卡尤加文阿燦文宿霧文奇加文奇布查文查加文處奇斯" +
			"文馬里文契奴克文喬克托文奇佩瓦揚文柴羅基文沙伊安文索拉尼庫爾德文科普特文卡皮茲文克里米亞半島的土耳其文；克里米亞半島的塔塔爾文法語克" +
			"里奧爾混合語卡舒布文達科他文達爾格瓦文台塔文德拉瓦文斯拉夫多格里布文丁卡文扎爾馬文多格來文下索布文中部杜順文杜亞拉文中古荷蘭文朱拉文" +
			"迪尤拉文達薩文恩布文埃菲克文埃米利安文古埃及文艾卡朱克文埃蘭文中古英文中尤皮克文依汪都文埃斯特雷馬杜拉文芳族文菲律賓文托爾訥芬蘭文豐" +
			"文卡真法文中古法文古法文法蘭克-普羅旺斯文北弗里西亞文東弗里西亞文弗留利文加族文加告茲文贛語加約文葛巴亞文索羅亞斯德教達里文吉茲文吉" +
			"爾伯特群島文吉拉基文中古高地德文古高地日耳曼文孔卡尼文岡德文科隆達羅文哥德文格列博文古希臘文德文（瑞士）瓦尤文弗拉弗拉文古西文圭契文" +
			"海達文客家話夏威夷文斐濟印地文希利蓋農文赫梯文孟文上索布文湘語胡帕文伊班文伊比比奧文伊洛闊文印古什文英格裏亞文牙買加克裏奧爾英文邏輯" +
			"文恩格姆巴文馬恰美文猶太教-波斯文猶太阿拉伯文日德蘭文卡拉卡爾帕克文卡比爾文卡琴文卡捷文卡姆巴文卡威文卡巴爾達文卡念布文卡塔布文馬孔" +
			"德文卡布威爾第文肯揚文科羅文坎剛文卡西文和闐文西桑海文科瓦文北紮紮其文卡庫文卡倫金文金邦杜文科米-彼爾米亞克文貢根文科斯雷恩文克佩列" +
			"文卡拉柴-包爾卡爾文塞拉利昂克裏奧爾文基那來阿文卡累利阿文庫魯科文尚巴拉文巴菲亞文科隆文庫密克文庫特奈文拉迪諾文朗吉文拉亨達文蘭巴文" +
			"列茲干文新共同語言利古里亞文利伏尼亞文拉科塔文倫巴底文芒戈文洛齊文北盧爾文拉特加萊文魯巴魯魯亞文路易塞諾文盧恩達文盧奧文盧晒文盧雅文" +
			"文言文拉茲文馬都拉文馬法文馬加伊文邁蒂利文望加錫文曼丁哥文馬賽文馬巴文莫克沙文曼達文門德文梅魯文克里奧文（模里西斯）中古愛爾蘭文馬夸" +
			"文美塔文米克馬克文米南卡堡文滿族文曼尼普裡文莫霍克文莫西文西馬裏文蒙當文多種語言克里克文米蘭德斯文馬爾尼裡文明打威文姆耶內文厄爾茲亞" +
			"文馬贊德蘭文閩南語拿波里文納馬文低地德文尼瓦爾文尼亞斯文紐埃文阿沃那加文夸西奧文恩甘澎文諾蓋文古諾爾斯文諾維亞文曼德文字 (N’Ko" +
			")北索托文努埃爾文古尼瓦爾文尼揚韋齊文尼揚科萊文尼奧囉文尼茲馬文歐塞奇文鄂圖曼土耳其文潘加辛文巴列維文潘帕嘉文帕皮阿門托文帛琉文庇卡底文" +
			"尼日利亞皮欽語賓夕法尼亞德文門諾低地德文古波斯文普法爾茨德文腓尼基文皮埃蒙特文旁狄希臘文波那貝文普魯士文古普羅旺斯文基切文欽博拉索海" +
			"蘭蓋丘亞文拉賈斯坦諸文復活島文拉羅通加文羅馬格諾里文里菲亞諾文蘭博文吉普賽文羅圖馬島文盧森尼亞文羅維阿納文羅馬尼亞語系羅瓦文桑達韋文" +
			"雅庫特文薩瑪利亞阿拉姆文薩布魯文撒撒克文散塔利文索拉什特拉文甘拜文桑古文西西里文蘇格蘭文薩丁尼亞-薩薩里文南庫爾德文塞訥卡文賽納文瑟" +
			"里文瑟爾卡普文東桑海文古愛爾蘭文薩莫吉希亞文希爾哈文撣文阿拉伯文（查德）希達摩文下西利西亞文塞拉亞文南薩米文魯勒薩米文伊納裡薩米文斯" +
			"科特薩米文索尼基文索格底亞納文蘇拉南東墎文塞雷爾文薩霍文沙特菲士蘭文蘇庫馬文蘇蘇文蘇美文葛摩文古敘利亞文敘利亞文西利西亞文圖盧文提姆" +
			"文特索文泰雷諾文泰頓文蒂格雷文提夫文托克勞文查庫爾文克林貢文特林基特文塔里什文塔馬奇克文東加文（尼亞薩）托比辛文圖羅尤文太魯閣文特薩" +
			"克尼恩文欽西安文穆斯林塔特文圖姆布卡文吐瓦魯文北桑海文土凡文塔馬齊格特文沃蒂艾克文烏加列文姆本杜文根語言瓦伊文威尼斯文維普森文西佛蘭" +
			"德文美茵-法蘭克尼亞文沃提克文佛羅文溫舊文瓦瑟文瓦拉莫文瓦瑞文瓦紹文沃皮瑞文吳語卡爾梅克文明格列爾文索加文瑤文雅浦文洋卞文耶姆巴文奈" +
			"恩加圖文粵語薩波特克文布列斯符號西蘭文澤納加文標準摩洛哥塔馬塞特文祖尼文無語言內容扎扎文現代標準阿拉伯文高地德文（瑞士）低地薩克遜文" +
			"佛蘭芒文摩爾多瓦文塞爾維亞克羅埃西亞文史瓦希里文（剛果）簡體中文繁體中文",
		[]uint16{ // 613 elements
			// Entry 0 - 3F
			0x0000, 0x0009, 0x0018, 0x0027, 0x0036, 0x003f, 0x004e, 0x005a,
			0x0066, 0x0072, 0x007e, 0x008a, 0x0099, 0x00a8, 0x00b7, 0x00c6,
			0x00d5, 0x00e1, 0x00ed, 0x00f3, 0x0102, 0x0111, 0x0123, 0x012c,
			0x0138, 0x0144, 0x014d, 0x0156, 0x0168, 0x0174, 0x0180, 0x0189,
			0x018f, 0x019b, 0x01a4, 0x01ad, 0x01b6, 0x01bc, 0x01c5, 0x01d1,
			0x01e0, 0x01ec, 0x01f5, 0x01fe, 0x0207, 0x0210, 0x0219, 0x021f,
			0x0231, 0x023d, 0x024f, 0x025e, 0x026a, 0x0279, 0x0282, 0x028b,
			0x0297, 0x02a3, 0x02b5, 0x02c7, 0x02d0, 0x02dc, 0x02eb, 0x02f7,
			// Entry 40 - 7F
			0x0300, 0x0309, 0x0319, 0x0322, 0x032e, 0x0340, 0x0349, 0x0352,
			0x035e, 0x036a, 0x0370, 0x0379, 0x0385, 0x038e, 0x039a, 0x03a6,
			0x03b2, 0x03be, 0x03c7, 0x03d3, 0x03d9, 0x03e5, 0x03f4, 0x0400,
			0x0409, 0x0415, 0x0424, 0x042d, 0x0439, 0x0442, 0x044b, 0x0457,
			0x045d, 0x0469, 0x047b, 0x048a, 0x0499, 0x04a5, 0x04ae, 0x04ba,
			0x04cc, 0x04d5, 0x04e1, 0x04ea, 0x04f6, 0x04ff, 0x0508, 0x0517,
			0x0523, 0x052f, 0x0538, 0x054d, 0x055f, 0x056e, 0x057a, 0x0586,
			0x0595, 0x05a4, 0x05b0, 0x05bc, 0x05c8, 0x05d4, 0x05dd, 0x05e6,
			// Entry 80 - BF
			0x05f2, 0x05fe, 0x060a, 0x0616, 0x061f, 0x062e, 0x0634, 0x0640,
			0x0646, 0x064f, 0x0658, 0x0667, 0x0670, 0x067c, 0x068b, 0x069d,
			0x06a9, 0x06b8, 0x06c4, 0x06d6, 0x06e5, 0x06f1, 0x06fd, 0x0706,
			0x070f, 0x071e, 0x072a, 0x0736, 0x0742, 0x0748, 0x075a, 0x0766,
			0x0775, 0x077e, 0x078a, 0x0796, 0x079f, 0x07ab, 0x07b7, 0x07c3,
			0x07cc, 0x07db, 0x07e4, 0x07ed, 0x07fc, 0x0805, 0x0811, 0x081a,
			0x0826, 0x0832, 0x0838, 0x083e, 0x0847, 0x0850, 0x085c, 0x0868,
			0x0874, 0x0889, 0x089b, 0x08a4, 0x08b0, 0x08bc, 0x08cb, 0x08d7,
			// Entry C0 - FF
			0x08ef, 0x08fe, 0x0907, 0x0910, 0x091c, 0x0928, 0x0937, 0x0946,
			0x0961, 0x0961, 0x0970, 0x0985, 0x0997, 0x09a0, 0x09ac, 0x09be,
			0x09ca, 0x09d3, 0x09df, 0x09e8, 0x09f7, 0x0a00, 0x0a0c, 0x0a1e,
			0x0a2a, 0x0a33, 0x0a3f, 0x0a4b, 0x0a54, 0x0a5d, 0x0a69, 0x0a78,
			0x0a87, 0x0a93, 0x0a9c, 0x0aa8, 0x0ab1, 0x0ac0, 0x0ad8, 0x0aea,
			0x0af6, 0x0b02, 0x0b0b, 0x0b17, 0x0b26, 0x0b32, 0x0b3b, 0x0b44,
			0x0b50, 0x0b59, 0x0b65, 0x0b71, 0x0b7a, 0x0b83, 0x0b8c, 0x0b98,
			0x0ba1, 0x0bad, 0x0bb6, 0x0bc2, 0x0bce, 0x0bdd, 0x0be9, 0x0bf5,
			// Entry 100 - 13F
			0x0c0a, 0x0c16, 0x0c22, 0x0c67, 0x0c82, 0x0c8e, 0x0c9a, 0x0ca9,
			0x0cb2, 0x0cbe, 0x0cc7, 0x0cd6, 0x0cdf, 0x0ceb, 0x0cf7, 0x0d03,
			0x0d12, 0x0d1e, 0x0d2d, 0x0d36, 0x0d42, 0x0d4b, 0x0d54, 0x0d60,
			0x0d6f, 0x0d7b, 0x0d8a, 0x0d93, 0x0d9f, 0x0dae, 0x0dba, 0x0dd2,
			0x0ddb, 0x0de7, 0x0df9, 0x0dff, 0x0e0b, 0x0e17, 0x0e20, 0x0e39,
			0x0e4b, 0x0e5d, 0x0e69, 0x0e72, 0x0e7e, 0x0e84, 0x0e8d, 0x0e99,
			0x0eb4, 0x0ebd, 0x0ed2, 0x0ede, 0x0ef0, 0x0f05, 0x0f11, 0x0f1a,
			0x0f29, 0x0f32, 0x0f3e, 0x0f4a, 0x0f5c, 0x0f65, 0x0f74, 0x0f7d,
			// Entry 140 - 17F
			0x0f86, 0x0f8f, 0x0f98, 0x0fa4, 0x0fb3, 0x0fc2, 0x0fcb, 0x0fd1,
			0x0fdd, 0x0fe3, 0x0fec, 0x0ff5, 0x1004, 0x1010, 0x101c, 0x102b,
			0x1046, 0x104f, 0x105e, 0x106a, 0x107d, 0x108f, 0x109b, 0x10b0,
			0x10bc, 0x10c5, 0x10ce, 0x10da, 0x10e3, 0x10f2, 0x10fe, 0x110a,
			0x1116, 0x1128, 0x1131, 0x113a, 0x1143, 0x114c, 0x1155, 0x1161,
			0x116a, 0x1179, 0x1182, 0x118e, 0x119a, 0x11b3, 0x11bc, 0x11cb,
			0x11d7, 0x11f0, 0x120b, 0x121a, 0x1229, 0x1235, 0x1241, 0x124d,
			0x1256, 0x1262, 0x126e, 0x127a, 0x1283, 0x128f, 0x1298, 0x12a4,
			// Entry 180 - 1BF
			0x12b3, 0x12c2, 0x12d1, 0x12dd, 0x12e9, 0x12f2, 0x12fb, 0x1307,
			0x1316, 0x1328, 0x1337, 0x1343, 0x134c, 0x1355, 0x135e, 0x1367,
			0x1370, 0x137c, 0x1385, 0x1391, 0x139d, 0x13a9, 0x13b5, 0x13be,
			0x13c7, 0x13d3, 0x13dc, 0x13e5, 0x13ee, 0x140c, 0x141e, 0x1427,
			0x1430, 0x143f, 0x144e, 0x1457, 0x1466, 0x1472, 0x147b, 0x1487,
			0x1490, 0x149c, 0x14a8, 0x14b7, 0x14c6, 0x14d2, 0x14de, 0x14ed,
			0x14fc, 0x1505, 0x1511, 0x151a, 0x1526, 0x1532, 0x153e, 0x1547,
			0x1556, 0x1562, 0x156e, 0x1577, 0x1586, 0x1592, 0x15a7, 0x15b3,
			// Entry 1C0 - 1FF
			0x15bf, 0x15ce, 0x15dd, 0x15ec, 0x15f8, 0x1604, 0x1610, 0x1625,
			0x1631, 0x163d, 0x1649, 0x165b, 0x1664, 0x1670, 0x1685, 0x169a,
			0x16ac, 0x16b8, 0x16ca, 0x16d6, 0x16e5, 0x16f4, 0x1700, 0x170c,
			0x171e, 0x1727, 0x1745, 0x1757, 0x1763, 0x1772, 0x1784, 0x1793,
			0x179c, 0x17a8, 0x17b7, 0x17c6, 0x17d5, 0x17e7, 0x17f0, 0x17fc,
			0x1808, 0x1820, 0x182c, 0x1838, 0x1844, 0x1856, 0x185f, 0x1868,
			0x1874, 0x1880, 0x1899, 0x18a8, 0x18b4, 0x18bd, 0x18c6, 0x18d5,
			0x18e1, 0x18f0, 0x1902, 0x190e, 0x1914, 0x192c, 0x1938, 0x194a,
			// Entry 200 - 23F
			0x1956, 0x1962, 0x1971, 0x1983, 0x1995, 0x19a1, 0x19b3, 0x19c5,
			0x19d1, 0x19da, 0x19ec, 0x19f8, 0x1a01, 0x1a0a, 0x1a13, 0x1a22,
			0x1a2e, 0x1a3d, 0x1a46, 0x1a4f, 0x1a58, 0x1a64, 0x1a6d, 0x1a79,
			0x1a82, 0x1a8e, 0x1a9a, 0x1aa6, 0x1ab5, 0x1ac1, 0x1ad0, 0x1ae8,
			0x1af4, 0x1b00, 0x1b0c, 0x1b1e, 0x1b2a, 0x1b3c, 0x1b4b, 0x1b57,
			0x1b63, 0x1b6c, 0x1b7e, 0x1b8d, 0x1b99, 0x1ba5, 0x1bae, 0x1bb7,
			0x1bc3, 0x1bcf, 0x1bde, 0x1bf7, 0x1c03, 0x1c0c, 0x1c15, 0x1c1e,
			0x1c2a, 0x1c33, 0x1c3c, 0x1c48, 0x1c4e, 0x1c5d, 0x1c6c, 0x1c75,
			// Entry 240 - 27F
			0x1c7b, 0x1c84, 0x1c8d, 0x1c99, 0x1ca8, 0x1cae, 0x1cbd, 0x1ccc,
			0x1cd5, 0x1ce1, 0x1cff, 0x1d08, 0x1d17, 0x1d20, 0x1d38, 0x1d38,
			0x1d38, 0x1d50, 0x1d50, 0x1d50, 0x1d50, 0x1d50, 0x1d50, 0x1d50,
			0x1d50, 0x1d50, 0x1d50, 0x1d50, 0x1d62, 0x1d6e, 0x1d6e, 0x1d6e,
			0x1d7d, 0x1d9b, 0x1db6, 0x1dc2, 0x1dce,
		},
	},
	{ // zgh
		"ⵜⴰⴽⴰⵏⵜⵜⴰⵎⵀⴰⵔⵉⵜⵜⴰⵄⵔⴰⴱⵜⵜⴰⴱⵉⵍⴰⵔⵓⵙⵜⵜⴰⴱⵍⵖⴰⵔⵉⵜⵜⴰⴱⵏⵖⴰⵍⵉⵜⵜⴰⵜⵛⵉⴽⵉⵜⵜⴰⵍⵉⵎⴰⵏⵜⵜⴰⴳⵔⵉⴳⵉ" +
			"ⵜⵜⴰⵏⴳⵍⵉⵣⵜⵜⴰⵙⴱⵏⵢⵓⵍⵉⵜⵜⴰⴼⵓⵔⵙⵉⵜⵜⴰⴼⵔⴰⵏⵙⵉⵙⵜⵜⴰⵀⴰⵡⵙⴰⵜⵜⴰⵀⵉⵏⴷⵉⵜⵜⴰⵀⵏⵖⴰⵔⵉⵜⵜⴰⵏⴷ" +
			"ⵓⵏⵉⵙⵉⵜⵜⵉⴳⴱⵓⵜⵜⴰⵟⴰⵍⵢⴰⵏⵜⵜⴰⵊⴰⴱⴱⵓⵏⵉⵜⵜⴰⵊⴰⴱⴰⵏⵉⵜⵜⴰⵅⵎⵉⵔⵜⵜⴰⴽⵓⵔⵉⵜⵜⴰⵎⴰⵍⴰⵡⵉⵜⵜⴰⴱ" +
			"ⵉⵔⵎⴰⵏⵉⵜⵜⴰⵏⵉⴱⴰⵍⵉⵜⵜⴰⵀⵓⵍⴰⵏⴷⵉⵜⵜⴰⴱⵏⵊⴰⴱⵉⵜⵜⴰⴱⵓⵍⵓⵏⵉⵜⵜⴰⴱⵕⵟⵇⵉⵣⵜⵜⴰⵔⵓⵎⴰⵏⵉⵜⵜⴰⵔⵓ" +
			"ⵙⵉⵜⵜⴰⵔⵓⵡⴰⵏⴷⵉⵜⵜⴰⵙⵓⵎⴰⵍⵉⵜⵜⴰⵙⵡⵉⴷⵉⵜⵜⴰⵜⴰⵎⵉⵍⵜⵜⴰⵜⴰⵢⵍⴰⵏⴷⵉⵜⵜⴰⵜⵓⵔⴽⵉⵜⵜⵓⴽⵔⴰⵏⵉⵜⵜ" +
			"ⵓⵔⴷⵓⵜⵜⴰⴱⵉⵜⵏⴰⵎⵉⵜⵜⴰⵢⵔⵓⴱⴰⵜⵜⴰⵛⵉⵏⵡⵉⵜⵜⴰⵣⵓⵍⵓⵜⵜⴰⵎⴰⵣⵉⵖⵜ",
		[]uint16{ // 587 elements
			// Entry 0 - 3F
			0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012, 0x002a, 0x002a,
			0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x003f, 0x005d, 0x0078,
			0x0078, 0x0078, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093, 0x0093,
			0x0093, 0x0093, 0x0093, 0x00ab, 0x00ab, 0x00ab, 0x00ab, 0x00ab,
			0x00c3, 0x00c3, 0x00c3, 0x00c3, 0x00db, 0x00f3, 0x00f3, 0x0111,
			0x0111, 0x0111, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0147,
			0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x0147, 0x015f,
			0x015f, 0x0177, 0x0177, 0x0177, 0x0177, 0x0192, 0x0192, 0x0192,
			// Entry 40 - 7F
			0x0192, 0x01b0, 0x01b0, 0x01c2, 0x01c2, 0x01c2, 0x01c2, 0x01c2,
			0x01dd, 0x01dd, 0x01fb, 0x0216, 0x0216, 0x0216, 0x0216, 0x0216,
			0x0216, 0x0216, 0x022b, 0x022b, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x025b, 0x025b, 0x0279, 0x0279, 0x0279,
			0x0294, 0x0294, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2,
			0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02b2, 0x02cd, 0x02cd, 0x02e8,
			// Entry 80 - BF
			0x02e8, 0x0303, 0x0303, 0x0303, 0x0303, 0x031e, 0x0333, 0x0351,
			0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351, 0x0351,
			0x0351, 0x0351, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c, 0x036c,
			0x0384, 0x0384, 0x039c, 0x039c, 0x039c, 0x03bd, 0x03bd, 0x03bd,
			0x03bd, 0x03bd, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03d5, 0x03ed,
			0x03ff, 0x03ff, 0x03ff, 0x041d, 0x041d, 0x041d, 0x041d, 0x041d,
			0x041d, 0x0435, 0x0435, 0x044d, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry C0 - FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 100 - 13F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 140 - 17F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 180 - 1BF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 1C0 - 1FF
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 200 - 23F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			// Entry 240 - 27F
			0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462, 0x0462,
			0x0462, 0x0462, 0x047a,
		},
	},
	{ // zh
		zhLangStr,
		zhLangIdx,
	},
	{ // zh-Hant
		zhHantLangStr,
		zhHantLangIdx,
	},
	{ // zh-Hant-HK
		"阿法爾文阿塞拜疆文巴什基爾文布里多尼文波斯尼亞文加泰隆尼亞文世界語加里西亞文印度文克羅地亞文意大利文格魯吉亞文坎納達文老撾文馬拉加斯文馬拉雅拉姆" +
			"文馬耳他文奧里雅文盧旺達文信德語斯洛文尼亞文修納文索馬里文泰米爾文湯加文烏爾都文克里米亞韃靼文塞舌爾克里奧爾法文斯拉夫文吉爾伯特文瑞" +
			"士德文苗語猶太波斯文扎扎其文克裡奧爾文盧歐文毛里裘斯克里奧爾文西非書面語言（N’ko）尼日利亞皮欽文阿羅馬尼亞語瓦爾皮里文廣東話摩洛" +
			"哥標準塔馬齊格特文南阿塞拜疆文奧地利德文瑞士德語澳洲英文加拿大英文英國英文美國英文拉丁美洲西班牙文歐洲西班牙文墨西哥西班牙文加拿大法" +
			"文瑞士法文荷蘭低地德文比利時荷蘭文巴西葡萄牙語歐洲葡萄牙文摩爾多瓦羅馬尼亞文剛果史瓦希里文",
		[]uint16{ // 611 elements
			// Entry 0 - 3F
			0x0000, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c, 0x000c,
			0x000c, 0x000c, 0x000c, 0x000c, 0x001b, 0x002a, 0x002a, 0x002a,
			0x002a, 0x002a, 0x002a, 0x002a, 0x0039, 0x0048, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a,
			0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x005a, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063, 0x0063,
			0x0063, 0x0063, 0x0063, 0x0072, 0x0072, 0x0072, 0x0072, 0x0072,
			0x0072, 0x007b, 0x007b, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			// Entry 40 - 7F
			0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a, 0x008a,
			0x0096, 0x0096, 0x0096, 0x0096, 0x00a5, 0x00a5, 0x00a5, 0x00a5,
			0x00a5, 0x00a5, 0x00a5, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1, 0x00b1,
			0x00ba, 0x00ba, 0x00ba, 0x00ba, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
			0x00db, 0x00db, 0x00db, 0x00db, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7, 0x00e7,
			0x00e7, 0x00e7, 0x00e7, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3,
			// Entry 80 - BF
			0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00f3, 0x00ff,
			0x00ff, 0x00ff, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x011a,
			0x011a, 0x0123, 0x012f, 0x012f, 0x012f, 0x012f, 0x012f, 0x012f,
			0x012f, 0x012f, 0x013b, 0x013b, 0x013b, 0x013b, 0x013b, 0x013b,
			0x013b, 0x0144, 0x0144, 0x0144, 0x0144, 0x0144, 0x0144, 0x0144,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			// Entry C0 - FF
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150, 0x0150,
			// Entry 100 - 13F
			0x0150, 0x0150, 0x0150, 0x0165, 0x0180, 0x0180, 0x0180, 0x0180,
			0x0180, 0x0180, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
			0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
			0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
			0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
			0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c, 0x018c,
			0x018c, 0x018c, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b, 0x019b,
			0x019b, 0x019b, 0x019b, 0x019b, 0x01a7, 0x01a7, 0x01a7, 0x01a7,
			// Entry 140 - 17F
			0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01a7, 0x01ad,
			0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01ad,
			0x01ad, 0x01ad, 0x01ad, 0x01ad, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc, 0x01bc,
			0x01bc, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8, 0x01c8,
			0x01c8, 0x01c8, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7,
			0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7,
			// Entry 180 - 1BF
			0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01d7,
			0x01d7, 0x01d7, 0x01d7, 0x01d7, 0x01e0, 0x01e0, 0x01e0, 0x01e0,
			0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0,
			0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01fb, 0x01fb, 0x01fb,
			0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb,
			0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb,
			0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb,
			0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x01fb, 0x0219, 0x0219,
			// Entry 1C0 - 1FF
			0x0219, 0x0219, 0x0219, 0x0219, 0x0219, 0x0219, 0x0219, 0x0219,
			0x0219, 0x0219, 0x0219, 0x0219, 0x0219, 0x0219, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x022e,
			0x022e, 0x022e, 0x022e, 0x022e, 0x022e, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			// Entry 200 - 23F
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240, 0x0240,
			0x0240, 0x0240, 0x0240, 0x024f, 0x024f, 0x024f, 0x024f, 0x024f,
			// Entry 240 - 27F
			0x024f, 0x024f, 0x024f, 0x024f, 0x024f, 0x0258, 0x0258, 0x0258,
			0x0258, 0x0258, 0x0279, 0x0279, 0x0279, 0x0279, 0x0279, 0x028b,
			0x029a, 0x02a6, 0x02b2, 0x02c1, 0x02cd, 0x02d9, 0x02f1, 0x0303,
			0x0318, 0x0318, 0x0327, 0x0333, 0x0345, 0x0357, 0x0369, 0x037b,
			0x0396, 0x0396, 0x03ab,
		},
	},
	{ // zu
		zuLangStr,
		zuLangIdx,
	},
}

const afLangStr string = "" + // Size: 3015 bytes
	"AfarAbkasiesAfrikaansAkanAmhariesAragoneesArabiesAssameesAvariesAymaraAz" +
	"erbeidjansBaskirBelo-RussiesBulgaarsBislamaBambaraBengaalsTibettaansBret" +
	"onsBosniesKatalaansTsjetsjenChamorroKorsikaansTsjeggiesKerkslawiesChuvas" +
	"hWalliesDeensDuitsDivehiDzongkhaEweGrieksEngelsEsperantoSpaansEstniesBas" +
	"kiesPersiesFulahFinsFidjiaansFaroeesFransWes-FriesIersSkotse GalliesGali" +
	"siesGuaraniGoedjaratiManxHausaHebreeusHindiKroatiesHaïtiaansHongaarsArme" +
	"ensHereroInterlinguaIndonesiesInterlingueIgboSichuan YiIdoYslandsItaliaa" +
	"nsInnuïtiesJapanneesJavaansGeorgiesKongoleesKikuyuKuanyamaKazaksKalaalli" +
	"sutKhmerKannadaKoreaansKanuriKasjmirsKoerdiesKomiKorniesKirgisiesLatynLu" +
	"xemburgsGandaLimburgsLingaalsLaoLitausLuba-KatangaLettiesMalgassiesMarsh" +
	"alleesMaoriMasedoniesMalabaarsMongoolsMarathiMaleisMalteesBirmaansNauruN" +
	"oord-NdebeleNepaleesNdongaNederlandsNoorweegse NynorskNoorse BokmålSuid-" +
	"NdebeleNavajoNyanjaOksitaansOromoOriyaOssetiesPandjabiPoolsPasjtoPortuge" +
	"esQuechuaReto-RomaansRundiRoemeensRussiesRwandeesSanskritSardiniesSindhi" +
	"Noord-SamiSangoSinhalaSlowaaksSloweensSamoaansShonaSomaliesAlbaneesSerwi" +
	"esSwaziSuid-SothoSundaneesSweedsSwahiliTamilTeloegoeTadzjieksThaiTigriny" +
	"aTurkmeensTswanaTongaansTurksTsongaTataarsTahitiesUighurOekraïensOerdoeO" +
	"ezbeeksVendaViëtnameesVolapükWalloonWolofXhosaJiddisjYorubaSjineesZoeloe" +
	"AsjineesAkoliAdangmeAdygheAghemAinuAleutSuid-AltaiAngikaArameesMapucheAr" +
	"apahoAsuAsturiesAwadhiBalineesBasaaBembaBenaWes-BalochiBhojpuriBiniSiksi" +
	"kaBodoBugineesBlinCebuanoSjigaChuukeesMariChoctawCherokeesCheyenneesSora" +
	"ni KoerdiesKoptiesSeselwa FranskreoolsDakotaansDakotaTaitaDogribZarmaLae" +
	" SorbiesDualaJola-FonyiDazagaEmbuEfikAntieke EgiptiesEkajukEwondoFilippy" +
	"nsFonFriuliaansGaaGagauzGeezGilberteesGorontaloGotiesAntieke GrieksSwits" +
	"erse DuitsGusiiGwichʼinHawaiiesHiligaynonHetitiesHmongHoog-SorbiesHupaIb" +
	"aneesIbibioIlokoIngushLojbanNgombaMachameKabyleKachinJjuKambaKabardiaans" +
	"TyapMakondeKabuverdianuKoroKhasiKoyra ChiiniKakoKalenjinKimbunduKomi-Per" +
	"myaksKonkaniKpelleesKarachay-BalkarKareliesKurukhShambalaBafiaKeulsKumyk" +
	"LadinoLangiLezghiesLakotaLoziNoord-LuriLuba-LuluaLundaLuoMizoLuyiaMadure" +
	"esMagahiMaithiliMakasarMasaiMokshaMendeMeruMorisjenMakhuwa-MeettoMeta’Mi" +
	"cmacMinangkabausManipuriMohawkMossiMundangVeelvuldige taleKreekMirandees" +
	"ErzyaMasanderaniNeapolitaansNamaLae DuitsNewariNiasNiueanKwasioNgiemboon" +
	"NogaiN’KoNoord-SothoNuerNyankolePangasinanPampangaPapiamentoPalauaansNig" +
	"eriese PidginFenisiesPruisiesK’iche’RapanuiRarotongaansRomboAromaniesRwa" +
	"SandaweesSakhaansSamburuSantaliesNgambaySanguSisiliaansSkotsSuid-Koerdie" +
	"sSenaKoyraboro SenniTachelhitShanSuid-SamiLule SamiInari SamiSkolt SamiS" +
	"oninkeSranan TongoSahoSukumaComoraansSirieseTimneTesoTetoemTigreKlingonT" +
	"ok PisinTarokoToemboekaTuvaluTasawaqTuvineesSentraal Atlas TamazightUdmu" +
	"rtUmbunduRootVaiVunjoWalserWolayttaWarayWarlpiriKalmykSogaYangbenYembaKa" +
	"ntoneesStandaard Marokkaanse TamazightZuniGeen linguistiese inhoudZazaMo" +
	"derne Standaard ArabiesSwitserse hoog-DuitsSpaans (Suid-Amerika)Nedersak" +
	"siesVlaamsMoldawiesSerwo-KroatiesSwahili (Kongo)"

var afLangIdx = []uint16{ // 611 elements
	// Entry 0 - 3F
	0x0000, 0x0004, 0x000c, 0x000c, 0x0015, 0x0019, 0x0021, 0x002a,
	0x0031, 0x0039, 0x0040, 0x0046, 0x0052, 0x0058, 0x0064, 0x006c,
	0x0073, 0x007a, 0x0082, 0x008c, 0x0093, 0x009a, 0x00a3, 0x00ac,
	0x00b4, 0x00be, 0x00be, 0x00c7, 0x00d2, 0x00d9, 0x00e0, 0x00e5,
	0x00ea, 0x00f0, 0x00f8, 0x00fb, 0x0101, 0x0107, 0x0110, 0x0116,
	0x011d, 0x0124, 0x012b, 0x0130, 0x0134, 0x013d, 0x0144, 0x0149,
	0x0152, 0x0156, 0x0164, 0x016c, 0x0173, 0x017d, 0x0181, 0x0186,
	0x018e, 0x0193, 0x0193, 0x019b, 0x01a5, 0x01ad, 0x01b4, 0x01ba,
	// Entry 40 - 7F
	0x01c5, 0x01cf, 0x01da, 0x01de, 0x01e8, 0x01e8, 0x01eb, 0x01f2,
	0x01fb, 0x0205, 0x020e, 0x0215, 0x021d, 0x0226, 0x022c, 0x0234,
	0x023a, 0x0245, 0x024a, 0x0251, 0x0259, 0x025f, 0x0267, 0x026f,
	0x0273, 0x027a, 0x0283, 0x0288, 0x0292, 0x0297, 0x029f, 0x02a7,
	0x02aa, 0x02b0, 0x02bc, 0x02c3, 0x02cd, 0x02d8, 0x02dd, 0x02e7,
	0x02f0, 0x02f8, 0x02ff, 0x0305, 0x030c, 0x0314, 0x0319, 0x0326,
	0x032e, 0x0334, 0x033e, 0x0350, 0x035e, 0x036a, 0x0370, 0x0376,
	0x037f, 0x037f, 0x0384, 0x0389, 0x0391, 0x0399, 0x0399, 0x039e,
	// Entry 80 - BF
	0x03a4, 0x03ad, 0x03b4, 0x03c0, 0x03c5, 0x03cd, 0x03d4, 0x03dc,
	0x03e4, 0x03ed, 0x03f3, 0x03fd, 0x0402, 0x0409, 0x0411, 0x0419,
	0x0421, 0x0426, 0x042e, 0x0436, 0x043d, 0x0442, 0x044c, 0x0455,
	0x045b, 0x0462, 0x0467, 0x046f, 0x0478, 0x047c, 0x0484, 0x048d,
	0x0493, 0x049b, 0x04a0, 0x04a6, 0x04ad, 0x04b5, 0x04bb, 0x04c5,
	0x04cb, 0x04d3, 0x04d8, 0x04e3, 0x04eb, 0x04f2, 0x04f7, 0x04fc,
	0x0503, 0x0509, 0x0509, 0x0510, 0x0516, 0x051e, 0x0523, 0x052a,
	0x0530, 0x0530, 0x0530, 0x0535, 0x0539, 0x0539, 0x0539, 0x053e,
	// Entry C0 - FF
	0x053e, 0x0548, 0x0548, 0x054e, 0x0555, 0x055c, 0x055c, 0x0563,
	0x0563, 0x0563, 0x0563, 0x0563, 0x0563, 0x0566, 0x0566, 0x056e,
	0x056e, 0x0574, 0x0574, 0x057c, 0x057c, 0x0581, 0x0581, 0x0581,
	0x0581, 0x0581, 0x0586, 0x0586, 0x058a, 0x058a, 0x058a, 0x0595,
	0x059d, 0x059d, 0x05a1, 0x05a1, 0x05a1, 0x05a8, 0x05a8, 0x05a8,
	0x05a8, 0x05a8, 0x05ac, 0x05ac, 0x05ac, 0x05b4, 0x05b4, 0x05b8,
	0x05b8, 0x05b8, 0x05b8, 0x05b8, 0x05b8, 0x05bf, 0x05c4, 0x05c4,
	0x05c4, 0x05cc, 0x05d0, 0x05d0, 0x05d7, 0x05d7, 0x05e0, 0x05ea,
	// Entry 100 - 13F
	0x05f9, 0x0600, 0x0600, 0x0600, 0x0614, 0x0614, 0x061d, 0x0623,
	0x0628, 0x0628, 0x0628, 0x062e, 0x062e, 0x0633, 0x0633, 0x063e,
	0x063e, 0x0643, 0x0643, 0x064d, 0x064d, 0x0653, 0x0657, 0x065b,
	0x065b, 0x066b, 0x0671, 0x0671, 0x0671, 0x0671, 0x0677, 0x0677,
	0x0677, 0x0680, 0x0680, 0x0683, 0x0683, 0x0683, 0x0683, 0x0683,
	0x0683, 0x0683, 0x068d, 0x0690, 0x0696, 0x0696, 0x0696, 0x0696,
	0x0696, 0x069a, 0x06a4, 0x06a4, 0x06a4, 0x06a4, 0x06a4, 0x06a4,
	0x06ad, 0x06b3, 0x06b3, 0x06c1, 0x06d0, 0x06d0, 0x06d0, 0x06d5,
	// Entry 140 - 17F
	0x06de, 0x06de, 0x06de, 0x06e6, 0x06e6, 0x06f0, 0x06f8, 0x06fd,
	0x0709, 0x0709, 0x070d, 0x0714, 0x071a, 0x071f, 0x0725, 0x0725,
	0x0725, 0x072b, 0x0731, 0x0738, 0x0738, 0x0738, 0x0738, 0x0738,
	0x073e, 0x0744, 0x0747, 0x074c, 0x074c, 0x0757, 0x0757, 0x075b,
	0x0762, 0x076e, 0x076e, 0x0772, 0x0772, 0x0777, 0x0777, 0x0783,
	0x0783, 0x0783, 0x0787, 0x078f, 0x0797, 0x07a4, 0x07ab, 0x07ab,
	0x07b3, 0x07c2, 0x07c2, 0x07c2, 0x07ca, 0x07d0, 0x07d8, 0x07dd,
	0x07e2, 0x07e7, 0x07e7, 0x07ed, 0x07f2, 0x07f2, 0x07f2, 0x07fa,
	// Entry 180 - 1BF
	0x07fa, 0x07fa, 0x07fa, 0x0800, 0x0800, 0x0800, 0x0804, 0x080e,
	0x080e, 0x0818, 0x0818, 0x081d, 0x0820, 0x0824, 0x0829, 0x0829,
	0x0829, 0x0831, 0x0831, 0x0837, 0x083f, 0x0846, 0x0846, 0x084b,
	0x084b, 0x0851, 0x0851, 0x0856, 0x085a, 0x0862, 0x0862, 0x0870,
	0x0877, 0x087d, 0x0889, 0x0889, 0x0891, 0x0897, 0x089c, 0x089c,
	0x08a3, 0x08b3, 0x08b8, 0x08c1, 0x08c1, 0x08c1, 0x08c1, 0x08c6,
	0x08d1, 0x08d1, 0x08dd, 0x08e1, 0x08ea, 0x08f0, 0x08f4, 0x08fa,
	0x08fa, 0x0900, 0x0909, 0x090e, 0x090e, 0x090e, 0x0914, 0x091f,
	// Entry 1C0 - 1FF
	0x0923, 0x0923, 0x0923, 0x092b, 0x092b, 0x092b, 0x092b, 0x092b,
	0x0935, 0x0935, 0x093d, 0x0947, 0x0950, 0x0950, 0x0960, 0x0960,
	0x0960, 0x0960, 0x0960, 0x0968, 0x0968, 0x0968, 0x0968, 0x0970,
	0x0970, 0x097b, 0x097b, 0x097b, 0x0982, 0x098e, 0x098e, 0x098e,
	0x0993, 0x0993, 0x0993, 0x0993, 0x0993, 0x099c, 0x099f, 0x09a8,
	0x09b0, 0x09b0, 0x09b7, 0x09b7, 0x09c0, 0x09c0, 0x09c7, 0x09cc,
	0x09d6, 0x09db, 0x09db, 0x09e8, 0x09e8, 0x09ec, 0x09ec, 0x09ec,
	0x09fb, 0x09fb, 0x09fb, 0x0a04, 0x0a08, 0x0a08, 0x0a08, 0x0a08,
	// Entry 200 - 23F
	0x0a08, 0x0a11, 0x0a1a, 0x0a24, 0x0a2e, 0x0a35, 0x0a35, 0x0a41,
	0x0a41, 0x0a45, 0x0a45, 0x0a4b, 0x0a4b, 0x0a4b, 0x0a54, 0x0a54,
	0x0a5b, 0x0a5b, 0x0a5b, 0x0a60, 0x0a64, 0x0a64, 0x0a6a, 0x0a6f,
	0x0a6f, 0x0a6f, 0x0a6f, 0x0a76, 0x0a76, 0x0a76, 0x0a76, 0x0a76,
	0x0a7f, 0x0a7f, 0x0a85, 0x0a85, 0x0a85, 0x0a85, 0x0a8e, 0x0a94,
	0x0a9b, 0x0aa3, 0x0abb, 0x0ac1, 0x0ac1, 0x0ac8, 0x0acc, 0x0acf,
	0x0acf, 0x0acf, 0x0acf, 0x0acf, 0x0acf, 0x0acf, 0x0ad4, 0x0ada,
	0x0ae2, 0x0ae7, 0x0ae7, 0x0aef, 0x0aef, 0x0af5, 0x0af5, 0x0af9,
	// Entry 240 - 27F
	0x0af9, 0x0af9, 0x0b00, 0x0b05, 0x0b05, 0x0b0e, 0x0b0e, 0x0b0e,
	0x0b0e, 0x0b0e, 0x0b2d, 0x0b31, 0x0b49, 0x0b4d, 0x0b66, 0x0b66,
	0x0b66, 0x0b7a, 0x0b7a, 0x0b7a, 0x0b7a, 0x0b7a, 0x0b8f, 0x0b8f,
	0x0b8f, 0x0b8f, 0x0b8f, 0x0b8f, 0x0b9b, 0x0ba1, 0x0ba1, 0x0ba1,
	0x0baa, 0x0bb8, 0x0bc7,
} // Size: 1246 bytes

const amLangStr string = "" + // Size: 6791 bytes
	"አፋርኛአብሐዚኛአቬስታንአፍሪካንኛአካንኛአማርኛአራጎንስዓረብኛአሳሜዛዊአቫሪክአያማርኛአዘርባጃንኛባስኪርኛቤላራሻኛቡልጋሪ" +
	"ኛቢስላምኛባምባርኛቤንጋሊኛቲቤታንኛብሬቶንኛቦስኒያንኛካታላንኛችችንቻሞሮኮርሲካኛክሪቼክኛቸርች ስላቪክቹቫሽወልሽዴኒሽ" +
	"ጀርመንዲቬህድዞንግኻኛኢዊግሪክኛእንግሊዝኛኤስፐራንቶስፓንሽኛኢስቶኒያንኛባስክኛፐርሺያኛፉላህፊኒሽፊጂኛፋሮኛፈረንሳይኛ" +
	"የምዕራብ ፍሪስኛአይሪሽየስኮቲሽ ጌልክኛጋሊሺያጓራኒኛጉጃርቲኛማንክስኛሃውሳኛዕብራስጥሒንዱኛክሮሽያንኛሃይትኛሀንጋሪኛ" +
	"አርመናዊሄሬሮኢንቴርሊንጓኢንዶኔዥኛእንተርሊንግወኢግቦኛሲቹንዪኛእኑፒያቅኛኢዶአይስላንድኛጣሊያንኛእኑክቲቱትኛጃፓንኛጃ" +
	"ቫንኛጆርጂያንኮንጎኛኪኩዩኩንያማካዛክኛካላሊሱትኛክህመርኛካናዳኛኮሪያኛካኑሪካሽሚርኛኩርድሽኛኮሚኮርኒሽኪርጊዝኛላቲንኛ" +
	"ሉክዘምበርገርኛጋንዳኛሊምቡርጊሽሊንጋላኛላኦስኛሉቴንያንኛሉባ ካታንጋላትቪያንማላጋስኛማርሻሌዝኛማኦሪኛማሴዶንኛማላያላ" +
	"ምኛሞንጎላዊኛማራቲኛማላይኛማልቲስኛቡርማኛናኡሩሰሜን ንዴብሌኔፓሊኛንዶንጋደችየኖርዌይ ናይኖርስክየኖርዌይ ቦክማልደቡ" +
	"ብ ንደቤሌናቫጆንያንጃኦኪታንኛኦሮሞኛኦዲያኛኦሴቲክፑንጃብኛፖሊሽኛፓሽቶኛፖርቹጋልኛኵቿኛሮማንሽሩንዲኛሮማኒያንራሽያኛኪ" +
	"ንያርዋንድኛሳንስክሪትኛሳርዲንያንኛሲንድሂኛሰሜናዊ ሳሚሳንጎኛሲንሃልኛስሎቫክኛስሎቪኛሳሞአኛሾናኛሱማልኛአልባንያንኛሰ" +
	"ርቢኛስዋቲኛደቡባዊ ሶቶሱዳንኛስዊድንኛስዋሂሊኛታሚልኛተሉጉኛታጂኪኛታይኛትግርኛቱርክሜንኛጽዋናዊኛቶንጋኛቱርክኛጾንጋኛ" +
	"ታታርኛታሂታንኛኡዊግሁርኛዩክሬንኛኡርዱኛኡዝቤክኛቬንዳቪየትናምኛቮላፑክኛዋሎንዎሎፍኛዞሳኛይዲሽኛዮሩባዊኛዡዋንግኛቻይን" +
	"ኛዙሉኛአቻይንኛአኮሊኛአዳንግሜአድይግሄአፍሪሂሊአገምአይኑአካዲያንአላባማአልዩትደቡባዊ አልታይአንጊካአራማይክማፑቼአራ" +
	"ኦናአራፓሆየአልጄሪያ ዓረብኛአራዋክአሱየአሜሪካ የምልክት ቋንቋአውስትሪያንአዋድሂባሉቺባሊኔስባቫሪያንባሳባሙንባታካ " +
	"ቶባቤጃቤምባቤታዊቤናባፉትባዳጋየምዕራብ ባሎቺቦጁሪቢኮልቢኒባንጃርሲክሲካቢሹንፑሪያባክህቲያሪብራጅብራሁዪቦዶአኮስቡሪያ" +
	"ትቡጊኔዝቡሉብሊንካዶካሪብካዩጋአትሳምካቡዋኖቺጋኛቺብቻቻጋታይቹክስማሪቺኑክ ጃርጎንቾክታዋቺፔውያንቼሮኬኛችዬኔየሶራኒ " +
	"ኩርድኛኮፕቲክካፒዝኖንክሪሚያን ተርኪሽሰሰላዊ ክሬኦሊ ፈረንሳይኛዳኮታዳርግዋታይታኛዳላዌርዶግሪብዲንካዛርማኛዶግሪየታ" +
	"ችኛው ሰርቢያንኛሴንተራል ዱሰንዱዋላኛጆላ ፎንያኛድዩላዳዛጋኢቦኛኤፊክየጥንታዊ ግብጽኛኤካጁክሴንተራል ዩፒክኤዎንዶፊ" +
	"ሊፒንኛፎንካጁን ፍሬንችአርፒታንፍሩሊያንጋጋጉዝኛጋን ቻይንኛግዕዝኛጅልበርትስጎሮንታሎየጥንታዊ ግሪክየስዊዝ ጀርመንጉ" +
	"ስሊኛግዊቺንሃካ ቻይንኛሃዊያኛሂሊጋይኖንህሞንግየላይኛው ሶርቢያንኛዢያንግ ቻይንኛሁፓኢባንኢቢቦኢሎኮኢንጉሽሎጅባንንጎ" +
	"ባኛማቻሜኛካብይልካቺንካጅካምባካባርዲያንታያፕማኮንዴካቡቨርዲያኑኮሮክሃሲኮይራ ቺኒካኮካለንጂንኪምቡንዱኮሚ ፔርምያክኮ" +
	"ንካኒክፔሌካራቻይ-ባልካርካረሊኛኩሩክሻምባላባፊያኮሎኝያንኩማይክላዲኖላንጊሌዝጊያንላኮታሎዚኛሰሜናዊ ሉሪሉባ-ሉሏሉንዳ" +
	"ሉኦሚዞሉዪያማዱረስማጋሂማይተሊማካሳርማሳይሞክሻሜንዴሜሩሞሪሲየኛማኩዋ ሜቶሜታሚክማክሚናንግካባኡማኒፑሪሞሃውክሞሲሙንዳ" +
	"ንግባለብዙ ቋንቋዎችክሪክሚራንዴዝኛኤርዝያማዛንደራኒሚን ኛን ቻይንኛኒአፖሊታንናማየታችኛው ጀርመንነዋሪኒአስኒዩአንኛ" +
	"ኦ ናጋክዋሲዮኒጊምቡንኖጋይንኮሰሜናዊ ሶቶኑዌርክላሲክ ኔዋሪኒያንኮልኛፓንጋሲናንኛፓምፓንጋፓፒአሜንቶፓላኡአንየናይጄሪ" +
	"ያ ፒጂንፐሩሳንኛኪቼቺምቦራዞ ሃይላንድ ኩቹዋራፓኑኢራሮቶንጋሮምቦአሮማንያንርዋሳንዳዌሳክሃሳምቡሩሳንታሊንጋምባይሳንጉ" +
	"ሲሲሊያንኛስኮትስደቡባዊ ኩርዲሽሴናኮይራቦሮ ሴኒታቼልሂትሻንቻዲያን ዓረብኛሲዳምኛደቡባዊ ሳሚሉሌ ሳሚኢናሪ ሳሚስኮል" +
	"ት ሳሚሶኒንኬስራናን ቶንጎሳሆኛሱኩማኮሞሪያንክላሲክ ኔይራሲሪያክቲምኔቴሶቴተምትግረክሊንጎንኛቶክ ፒሲንታሮኮቱምቡካቱ" +
	"ቫሉታሳዋቅቱቪንያንኛመካከለኛ አትላስ ታማዚግትኡድሙርትኡምቡንዱሩትቫይቩንጆዋልሰርወላይትኛዋራይዋርልፒሪዉ ቻይንኛካል" +
	"ማይክሶጋያንግቤንኛየምባካንቶኒዝብሊስይምቦልስመደበኛ የሞሮኮ ታማዚግትዙኒቋንቋዊ ይዘት አይደለምዛዛዘመናዊ መደበኛ " +
	"ዓረብኛየኦስትሪያ ጀርመንየስዊዝ ከፍተኛ ጀርመንኛየአውስትራሊያ እንግሊዝኛየካናዳ እንግሊዝኛየብሪቲሽ እንግሊዝኛየአ" +
	"ሜሪካ እንግሊዝኛየላቲን አሜሪካ ስፓኒሽየአውሮፓ ስፓንሽኛየሜክሲኮ ስፓንሽኛየካናዳ ፈረንሳይኛየስዊዝ ፈረንሳይኛየታ" +
	"ችኛው ሳክሰንፍሌሚሽየብራዚል ፖርቹጋልኛየአውሮፓ ፖርቹጋልኛሞልዳቪያንኛሰርቦ-ክሮኤሽያኛኮንጎ ስዋሂሊቀለል ያለ ቻይ" +
	"ንኛባህላዊ ቻይንኛ"

var amLangIdx = []uint16{ // 613 elements
	// Entry 0 - 3F
	0x0000, 0x000c, 0x001b, 0x002a, 0x003c, 0x0048, 0x0054, 0x0063,
	0x006f, 0x007e, 0x008a, 0x0099, 0x00ae, 0x00bd, 0x00cc, 0x00db,
	0x00ea, 0x00f9, 0x0108, 0x0117, 0x0126, 0x0138, 0x0147, 0x0150,
	0x0159, 0x0168, 0x016e, 0x0177, 0x018d, 0x0196, 0x019f, 0x01a8,
	0x01b4, 0x01bd, 0x01cf, 0x01d5, 0x01e1, 0x01f3, 0x0205, 0x0214,
	0x0229, 0x0235, 0x0244, 0x024d, 0x0256, 0x025f, 0x0268, 0x027a,
	0x0296, 0x02a2, 0x02be, 0x02ca, 0x02d6, 0x02e5, 0x02f4, 0x0300,
	0x030f, 0x031b, 0x031b, 0x032d, 0x0339, 0x0348, 0x0357, 0x0360,
	// Entry 40 - 7F
	0x0375, 0x0387, 0x039f, 0x03ab, 0x03ba, 0x03cc, 0x03d2, 0x03e7,
	0x03f6, 0x040b, 0x0417, 0x0423, 0x0432, 0x043e, 0x0447, 0x0453,
	0x045f, 0x0471, 0x0480, 0x048c, 0x0498, 0x04a1, 0x04b0, 0x04bf,
	0x04c5, 0x04d1, 0x04e0, 0x04ec, 0x0507, 0x0513, 0x0525, 0x0534,
	0x0540, 0x0552, 0x0565, 0x0574, 0x0583, 0x0595, 0x05a1, 0x05b0,
	0x05c2, 0x05d4, 0x05e0, 0x05ec, 0x05fb, 0x0607, 0x0610, 0x0626,
	0x0632, 0x063e, 0x0644, 0x0666, 0x0682, 0x0698, 0x06a1, 0x06ad,
	0x06bc, 0x06bc, 0x06c8, 0x06d4, 0x06e0, 0x06ef, 0x06ef, 0x06fb,
	// Entry 80 - BF
	0x0707, 0x0719, 0x0722, 0x072e, 0x073a, 0x0749, 0x0755, 0x076d,
	0x0782, 0x0797, 0x07a6, 0x07b9, 0x07c5, 0x07d4, 0x07e3, 0x07ef,
	0x07fb, 0x0804, 0x0810, 0x0825, 0x0831, 0x083d, 0x0850, 0x085c,
	0x086b, 0x087a, 0x0886, 0x0892, 0x089e, 0x08a7, 0x08b3, 0x08c5,
	0x08d4, 0x08e0, 0x08ec, 0x08f8, 0x0904, 0x0913, 0x0925, 0x0934,
	0x0940, 0x094f, 0x0958, 0x096a, 0x0979, 0x0982, 0x098e, 0x0997,
	0x09a3, 0x09b2, 0x09c1, 0x09cd, 0x09d6, 0x09e5, 0x09f1, 0x0a00,
	0x0a0f, 0x0a0f, 0x0a1e, 0x0a27, 0x0a30, 0x0a3f, 0x0a4b, 0x0a57,
	// Entry C0 - FF
	0x0a57, 0x0a70, 0x0a70, 0x0a7c, 0x0a8b, 0x0a94, 0x0aa0, 0x0aac,
	0x0acb, 0x0acb, 0x0ad7, 0x0ad7, 0x0ad7, 0x0add, 0x0b06, 0x0b1b,
	0x0b1b, 0x0b27, 0x0b30, 0x0b3c, 0x0b4b, 0x0b51, 0x0b5a, 0x0b6a,
	0x0b6a, 0x0b70, 0x0b79, 0x0b82, 0x0b88, 0x0b91, 0x0b9a, 0x0bb3,
	0x0bbc, 0x0bc5, 0x0bcb, 0x0bd7, 0x0bd7, 0x0be3, 0x0bf5, 0x0c07,
	0x0c10, 0x0c1c, 0x0c22, 0x0c2b, 0x0c37, 0x0c43, 0x0c49, 0x0c52,
	0x0c52, 0x0c58, 0x0c61, 0x0c6a, 0x0c76, 0x0c82, 0x0c8b, 0x0c94,
	0x0ca0, 0x0ca9, 0x0caf, 0x0cc5, 0x0cd1, 0x0ce0, 0x0cec, 0x0cf5,
	// Entry 100 - 13F
	0x0d0e, 0x0d1a, 0x0d29, 0x0d45, 0x0d71, 0x0d71, 0x0d7a, 0x0d86,
	0x0d92, 0x0d9e, 0x0d9e, 0x0daa, 0x0db3, 0x0dbf, 0x0dc8, 0x0dea,
	0x0e03, 0x0e0f, 0x0e0f, 0x0e22, 0x0e2b, 0x0e34, 0x0e3d, 0x0e46,
	0x0e46, 0x0e62, 0x0e6e, 0x0e6e, 0x0e6e, 0x0e87, 0x0e93, 0x0e93,
	0x0e93, 0x0ea2, 0x0ea2, 0x0ea8, 0x0ebe, 0x0ebe, 0x0ebe, 0x0ecd,
	0x0ecd, 0x0ecd, 0x0edc, 0x0edf, 0x0eeb, 0x0efe, 0x0efe, 0x0efe,
	0x0efe, 0x0f0a, 0x0f1c, 0x0f1c, 0x0f1c, 0x0f1c, 0x0f1c, 0x0f1c,
	0x0f2b, 0x0f2b, 0x0f2b, 0x0f44, 0x0f5d, 0x0f5d, 0x0f5d, 0x0f69,
	// Entry 140 - 17F
	0x0f75, 0x0f75, 0x0f88, 0x0f94, 0x0f94, 0x0fa6, 0x0fa6, 0x0fb2,
	0x0fd4, 0x0fed, 0x0ff3, 0x0ffc, 0x1005, 0x100e, 0x101a, 0x101a,
	0x101a, 0x1026, 0x1032, 0x103e, 0x103e, 0x103e, 0x103e, 0x103e,
	0x104a, 0x1053, 0x1059, 0x1062, 0x1062, 0x1074, 0x1074, 0x107d,
	0x1089, 0x109e, 0x109e, 0x10a4, 0x10a4, 0x10ad, 0x10ad, 0x10bd,
	0x10bd, 0x10bd, 0x10c3, 0x10d2, 0x10e1, 0x10f7, 0x1103, 0x1103,
	0x110c, 0x1125, 0x1125, 0x1125, 0x1131, 0x113a, 0x1146, 0x114f,
	0x115e, 0x116a, 0x116a, 0x1173, 0x117c, 0x117c, 0x117c, 0x118b,
	// Entry 180 - 1BF
	0x118b, 0x118b, 0x118b, 0x1194, 0x1194, 0x1194, 0x119d, 0x11b0,
	0x11b0, 0x11bd, 0x11bd, 0x11c6, 0x11cc, 0x11d2, 0x11db, 0x11db,
	0x11db, 0x11e7, 0x11e7, 0x11f0, 0x11fc, 0x1208, 0x1208, 0x1211,
	0x1211, 0x121a, 0x121a, 0x1223, 0x1229, 0x1238, 0x1238, 0x1248,
	0x124e, 0x125a, 0x126f, 0x126f, 0x127b, 0x1287, 0x128d, 0x128d,
	0x129c, 0x12b8, 0x12c1, 0x12d3, 0x12d3, 0x12d3, 0x12d3, 0x12df,
	0x12f1, 0x130b, 0x131d, 0x1323, 0x133f, 0x1348, 0x1351, 0x1360,
	0x136a, 0x1376, 0x1385, 0x138e, 0x138e, 0x138e, 0x1394, 0x13a7,
	// Entry 1C0 - 1FF
	0x13b0, 0x13c6, 0x13c6, 0x13d8, 0x13d8, 0x13d8, 0x13d8, 0x13d8,
	0x13ed, 0x13ed, 0x13fc, 0x140e, 0x141d, 0x141d, 0x1439, 0x1439,
	0x1439, 0x1439, 0x1439, 0x1439, 0x1439, 0x1439, 0x1439, 0x1448,
	0x1448, 0x144e, 0x1477, 0x1477, 0x1483, 0x1492, 0x1492, 0x1492,
	0x149b, 0x149b, 0x149b, 0x149b, 0x149b, 0x14ad, 0x14b3, 0x14bf,
	0x14c8, 0x14c8, 0x14d4, 0x14d4, 0x14e0, 0x14e0, 0x14ef, 0x14f8,
	0x150a, 0x1516, 0x1516, 0x152f, 0x152f, 0x1535, 0x1535, 0x1535,
	0x154b, 0x154b, 0x154b, 0x155a, 0x1560, 0x1579, 0x1585, 0x1585,
	// Entry 200 - 23F
	0x1585, 0x1598, 0x15a5, 0x15b5, 0x15c8, 0x15d4, 0x15d4, 0x15ea,
	0x15ea, 0x15f3, 0x15f3, 0x15fc, 0x15fc, 0x15fc, 0x160b, 0x1621,
	0x162d, 0x162d, 0x162d, 0x1636, 0x163c, 0x163c, 0x1645, 0x164e,
	0x164e, 0x164e, 0x164e, 0x1660, 0x1660, 0x1660, 0x1660, 0x1660,
	0x1670, 0x1670, 0x1679, 0x1679, 0x1679, 0x1679, 0x1685, 0x168e,
	0x169a, 0x16ac, 0x16d8, 0x16e7, 0x16e7, 0x16f6, 0x16fc, 0x1702,
	0x1702, 0x1702, 0x1702, 0x1702, 0x1702, 0x1702, 0x170b, 0x1717,
	0x1726, 0x172f, 0x172f, 0x173e, 0x174e, 0x175d, 0x175d, 0x1763,
	// Entry 240 - 27F
	0x1763, 0x1763, 0x1775, 0x177e, 0x177e, 0x178d, 0x178d, 0x17a5,
	0x17a5, 0x17a5, 0x17ce, 0x17d4, 0x17fa, 0x1800, 0x1826, 0x1826,
	0x1845, 0x186e, 0x1899, 0x18b8, 0x18da, 0x18fc, 0x1922, 0x1941,
	0x1960, 0x1960, 0x197f, 0x199e, 0x19ba, 0x19c6, 0x19e8, 0x1a0a,
	0x1a1f, 0x1a3b, 0x1a51, 0x1a6e, 0x1a87,
} // Size: 1250 bytes

const arLangStr string = "" + // Size: 10039 bytes
	"الأفاريةالأبخازيةالأفستيةالأفريقانيةالأكانيةالأمهريةالأراغونيةالعربيةالأ" +
	"ساميةالأواريةالأيماراالأذربيجانيةالباشكيريةالبيلاروسيةالبلغاريةالبيسلام" +
	"يةالبامباراالبنغاليةالتبتيةالبريتونيةالبوسنيةالكتالانيةالشيشانيةالتشامو" +
	"روالكورسيكيةالكرىالتشيكيةسلافية كنسيةالتشوفاشيالويلزيةالدانماركيةالألما" +
	"نيةالمالديفيةالزونخايةالإيوياليونانيةالإنجليزيةالإسبرانتوالإسبانيةالإست" +
	"ونيةلغة الباسكالفارسيةالفولانيةالفنلنديةالفيجيةالفارويةالفرنسيةالفريزيا" +
	"نالأيرلنديةالغيلية الأسكتلنديةالجاليكيةالغوارانيةالغوجاراتيةالمنكيةالهو" +
	"ساالعبريةالهنديةالهيري موتوالكرواتيةالكريولية الهايتيةالهنغاريةالأرميني" +
	"ةالهيريرواللّغة الوسيطةالإندونيسيةالإنترلينجالإيجبوالسيتشيون ييالإينبيا" +
	"كالإيدوالأيسلنديةالإيطاليةالإينكتيتتاليابانيةالجاويةالجورجيةالكونغوالكي" +
	"كيوالكيونياماالكازاخستانيةالكالاليستالخميريةالكاناداالكوريةالكانيوريالك" +
	"شميريةالكرديةالكوميالكورنيةالقيرغيزيةاللاتينيةاللكسمبورغيةالجانداالليمب" +
	"رجيشيةاللينجالااللاويةالليتوانيةاللبا-كاتانجااللاتفيةالمالاجاشيةالمارشا" +
	"ليةالماوريةالمقدونيةالمالايالاميةالمنغوليةالماراثيةالماليزيةالمالطيةالب" +
	"ورميةالنوروالنديبيل الشماليةالنيباليةالندونجاالهولنديةالنرويجية نينورسك" +
	"النرويجية بوكمالالنديبيل الجنوبيالنافاجوالنيانجاالأوكيتانيةالأوجيبواالأ" +
	"وروميةاللغة الأوريةالأوسيتيكالبنجابيةالباليةالبولنديةالبشتونيةالبرتغالي" +
	"ةالكويتشواالرومانشيةالرنديالرومانيةالروسيةالكينياروانداالسنسكريتيةالسرد" +
	"ينيةالسنديةالسامي الشماليةالسانجوالسنهاليةالسلوفاكيةالسلوفانيةالساموائي" +
	"ةالشوناالصوماليةالألبانيةالصربيةالسواتيالسوتو الجنوبيةالسوندانيةالسويدي" +
	"ةالسواحليةالتاميليةالتيلوجوالطاجيكيةالتايلانديةالتغرينيةالتركمانيةالتسو" +
	"انيةالتونغيةالتركيةالسونجاالتتريةالتاهيتيةالأويغوريةالأوكرانيةالأورديةا" +
	"لأوزبكيةالفينداالفيتناميةلغة الفولابوكالولونيةالولوفيةالخوسااليديشيةالي" +
	"وروبيةالزهيونجالصينيةالزولوالأتشينيزيةالأكوليةالأدانجميةالأديغةالأفريهي" +
	"ليةالأغمالآينويةالأكاديةالأليوتيةالألطائية الجنوبيةالإنجليزية القديمةال" +
	"أنجيكاالآراميةالمابودونغونيةالأراباهواللهجة النجديةالأراواكيةالآسوالأست" +
	"ريةالأواديةالبلوشيةاللغة الباليةالباسابامنلغة الغومالاالبيجاالبيمبابينا" +
	"لغة البافوتالبلوشية الغربيةالبهوجبوريةالبيكوليةالبينيةلغة الكومالسيكسيك" +
	"يةالبراجيةالبودوأكوسالبرياتيةالبجينيزيةلغة البولوالبلينيةلغة الميدومباا" +
	"لكادوالكاريبيةالكايوجيةالأتسامالسيبونيةتشيغاالتشيبشاالتشاجاتايالتشكيزية" +
	"الماريالشينوك جارجونالشوكتوالشيباوايانالشيروكيالشايانالسورانية الكرديةا" +
	"لقبطيةلغة تتار القرمالفرنسية الكريولية السيشيليةالكاشبايانالداكوتاالدار" +
	"جواتيتاالديلويرالسلافيةالدوجريبالدنكاالزارميةالدوجريةصوربيا السفلىالديو" +
	"لاالهولندية الوسطىجولا فونياالدايلاالقرعانيةإمبوالإفيكالمصرية القديمةال" +
	"إكاجكالإمايتالإنجليزية الوسطىالإيوندوالفانجالفلبينيةالفونالفرنسية الوسط" +
	"ىالفرنسية القديمةالفريزينية الشماليةالفريزينية الشرقيةالفريلايانالجاالغ" +
	"اغوزالغان الصينيةالجايوالجبياالجعزيةلغة أهل جبل طارقالألمانية العليا ال" +
	"وسطىالألمانية العليا القديمةالجنديالجورونتالوالقوطيةالجريبواليونانية ال" +
	"قديمةالألمانية السويسريةالغيزيةغوتشنالهيداالهاكا الصينيةلغة أهل الهاواي" +
	"الهيليجينونالحثيةالهمونجيةالصوربية العلياشيانغ الصينيةالهباالإيبانالإيب" +
	"يبيويةالإيلوكوالإنجوشيةاللوجباننغومباالماتشاميةالفارسية اليهوديةالعربية" +
	" اليهوديةالكارا-كالباكالقبيليةالكاتشينالجوالكامباالكويالكاباردايانكانمبو" +
	"التايابيةماكوندهكابوفيرديانوالكوروالكازيةالخوتانيزكويرا تشينيلغة الكاكو" +
	"كالينجينالكيمبندوكومي-بيرماياكالكونكانيةالكوسراينالكبيلالكاراتشاي-بالكا" +
	"رالكاريليةالكوروخشامبالالغة البافيالغة الكولونيانالقموقيةالكتيناياللادي" +
	"نولانجياللاهندااللامباالليزجيةلاكوتامنغولىاللوزياللرية الشماليةاللبا-لؤ" +
	"لؤاللوسينواللوندااللوالميزولغة اللوياالمادريزالماجاالمايثيليالماكاسارال" +
	"ماندينغالماسايماباالموكشاالماندارالميندالميروالمورسيانيةالأيرلندية الوس" +
	"طىماخاوا-ميتوميتاالميكماكيونيةالمينانجكاباوالمانشوالمانيبوريةالموهوكالم" +
	"وسيمندنجلغات متعددةالكريكالميرانديزالمارواريةالأرزيةالمازندرانيةمين-نان" +
	" الصينيةالنابوليةلغة الناماالألمانية السفلىالنواريةالنياسالنيويكواسيولغة" +
	" النجيمبونالنوجايالنورس القديمأنكوالسوتو الشماليةالنويرالنوارية التقليدي" +
	"ةالنيامويزيالنيانكولالنيوروالنزيماالأوساجالتركية العثمانيةالبانجاسينانا" +
	"لبهلويةالبامبانجاالبابيامينتوالبالوانالبدجنية النيجيريةالفارسية القديمة" +
	"الفينيقيةالبوهنبيايانالبروسياويةالبروفانسية القديمةكيشيالراجاسثانيةالرا" +
	"بانيالراروتونجانيالرومبوالغجريةالأرومانيانالرواالسانداويالساخيةالآرامية" +
	" السامريةسامبوروالساساكالسانتالينامبيسانغوالصقليةالأسكتلنديةالكردية الجن" +
	"وبيةالسنيكاسيناالسيلكبكويرابورو سينيالأيرلندية القديمةتشلحيتالشانالعربي" +
	"ة التشاديةالسيداموالسامي الجنوبياللول ساميالإيناري ساميالسكولت ساميالسو" +
	"نينكالسوجدينالسرانان تونجوالسررلغة الساهوالسوكوماالسوسوالسوماريةالقمرية" +
	"سريانية تقليديةالسريانيةالتيمنتيسوالتيرينوالتيتمالتيغريةالتيفالتوكيلاوا" +
	"لكلينجونالتلينغيتيةالتاماشيكتونجا - نياساالتوك بيسينلغة التاروكوالتسيمش" +
	"يانالتامبوكاالتوفالوتاساواقالتوفيةالأمازيغية وسط الأطلسالأدمرتاليجاريتي" +
	"كالأمبندوالجذرالفايالفوتيكالفونجوالوالسرالولاياتاالوارايالواشووارلبيريا" +
	"لوو الصينيةالكالميكالسوغاالياواليابيزيانجبنيمباالكَنْتُونيةالزابوتيكرمو" +
	"ز المعايير الأساسيةالزيناجاالتمازيغية المغربية القياسيةالزونيةبدون محتو" +
	"ى لغويزازاالعربية الرسمية الحديثةالألمانية النمساويةالألمانية العليا ال" +
	"سويسريةالإنجليزية الأستراليةالإنجليزية الكنديةالإنجليزية البريطانيةالإن" +
	"جليزية الأمريكيةالإسبانية أمريكا اللاتينيةالإسبانية الأوروبيةالإسبانية " +
	"المكسيكيةالفرنسية الكنديةالفرنسية السويسريةالسكسونية السفلىالفلمنكيةالب" +
	"رتغالية البرازيليةالبرتغالية الأوروبيةالمولدوفيةصربية-كرواتيةالكونغو ال" +
	"سواحليةالصينية المبسطةالصينية التقليدية"

var arLangIdx = []uint16{ // 613 elements
	// Entry 0 - 3F
	0x0000, 0x0010, 0x0022, 0x0032, 0x0048, 0x0058, 0x0068, 0x007c,
	0x008a, 0x009a, 0x00aa, 0x00ba, 0x00d2, 0x00e6, 0x00fc, 0x010e,
	0x0122, 0x0134, 0x0146, 0x0154, 0x0168, 0x0178, 0x018c, 0x019e,
	0x01b0, 0x01c4, 0x01ce, 0x01de, 0x01f5, 0x0207, 0x0217, 0x022d,
	0x023f, 0x0253, 0x0265, 0x0271, 0x0283, 0x0297, 0x02ab, 0x02bd,
	0x02cf, 0x02e2, 0x02f2, 0x0304, 0x0316, 0x0324, 0x0334, 0x0344,
	0x0356, 0x036a, 0x038f, 0x03a1, 0x03b5, 0x03cb, 0x03d9, 0x03e5,
	0x03f3, 0x0401, 0x0416, 0x0428, 0x044b, 0x045d, 0x046f, 0x047f,
	// Entry 40 - 7F
	0x049a, 0x04b0, 0x04c4, 0x04d2, 0x04e9, 0x04fb, 0x0507, 0x051b,
	0x052d, 0x0541, 0x0553, 0x0561, 0x0571, 0x057f, 0x058d, 0x05a1,
	0x05bb, 0x05cf, 0x05df, 0x05ef, 0x05fd, 0x060f, 0x0621, 0x062f,
	0x063b, 0x064b, 0x065f, 0x0671, 0x0689, 0x0697, 0x06af, 0x06c1,
	0x06cf, 0x06e3, 0x06fc, 0x070c, 0x0722, 0x0736, 0x0746, 0x0758,
	0x0772, 0x0784, 0x0796, 0x07a8, 0x07b8, 0x07c8, 0x07d4, 0x07f5,
	0x0807, 0x0817, 0x0829, 0x084a, 0x0869, 0x0888, 0x0898, 0x08a8,
	0x08be, 0x08d0, 0x08e2, 0x08fb, 0x090d, 0x091f, 0x092d, 0x093f,
	// Entry 80 - BF
	0x0951, 0x0965, 0x0977, 0x098b, 0x0997, 0x09a9, 0x09b7, 0x09d1,
	0x09e7, 0x09f9, 0x0a07, 0x0a24, 0x0a32, 0x0a44, 0x0a58, 0x0a6c,
	0x0a80, 0x0a8c, 0x0a9e, 0x0ab0, 0x0abe, 0x0acc, 0x0ae9, 0x0afd,
	0x0b0d, 0x0b1f, 0x0b31, 0x0b41, 0x0b53, 0x0b69, 0x0b7b, 0x0b8f,
	0x0ba1, 0x0bb1, 0x0bbf, 0x0bcd, 0x0bdb, 0x0bed, 0x0c01, 0x0c15,
	0x0c25, 0x0c37, 0x0c45, 0x0c59, 0x0c72, 0x0c82, 0x0c92, 0x0c9e,
	0x0cae, 0x0cc0, 0x0cd0, 0x0cde, 0x0cea, 0x0d00, 0x0d10, 0x0d24,
	0x0d32, 0x0d32, 0x0d48, 0x0d52, 0x0d62, 0x0d72, 0x0d72, 0x0d84,
	// Entry C0 - FF
	0x0d84, 0x0da7, 0x0dca, 0x0dda, 0x0dea, 0x0e06, 0x0e06, 0x0e18,
	0x0e18, 0x0e33, 0x0e47, 0x0e47, 0x0e47, 0x0e51, 0x0e51, 0x0e61,
	0x0e61, 0x0e71, 0x0e81, 0x0e9a, 0x0e9a, 0x0ea6, 0x0eae, 0x0eae,
	0x0ec5, 0x0ed1, 0x0edf, 0x0edf, 0x0ee7, 0x0efc, 0x0efc, 0x0f1b,
	0x0f31, 0x0f43, 0x0f51, 0x0f51, 0x0f62, 0x0f76, 0x0f76, 0x0f76,
	0x0f86, 0x0f86, 0x0f92, 0x0f9a, 0x0fac, 0x0fc0, 0x0fd3, 0x0fe3,
	0x0ffc, 0x1008, 0x101a, 0x102c, 0x103a, 0x104c, 0x1056, 0x1066,
	0x107a, 0x108c, 0x1098, 0x10b3, 0x10c1, 0x10d7, 0x10e7, 0x10f5,
	// Entry 100 - 13F
	0x1116, 0x1124, 0x1124, 0x113e, 0x1174, 0x1188, 0x1198, 0x11a8,
	0x11b0, 0x11c0, 0x11d0, 0x11e0, 0x11ec, 0x11fc, 0x120c, 0x1225,
	0x1225, 0x1233, 0x1252, 0x1265, 0x1273, 0x1285, 0x128d, 0x1299,
	0x1299, 0x12b6, 0x12c4, 0x12d2, 0x12f3, 0x12f3, 0x1303, 0x1303,
	0x130f, 0x1321, 0x1321, 0x132b, 0x132b, 0x1348, 0x1367, 0x1367,
	0x138c, 0x13af, 0x13c3, 0x13cb, 0x13d9, 0x13f2, 0x13fe, 0x140a,
	0x140a, 0x1418, 0x1435, 0x1435, 0x1461, 0x148f, 0x148f, 0x149b,
	0x14b1, 0x14bf, 0x14cd, 0x14ee, 0x1513, 0x1513, 0x1513, 0x1521,
	// Entry 140 - 17F
	0x152b, 0x1537, 0x1552, 0x156e, 0x156e, 0x1584, 0x1590, 0x15a2,
	0x15bf, 0x15d8, 0x15e2, 0x15f0, 0x1606, 0x1616, 0x1628, 0x1628,
	0x1628, 0x1638, 0x1644, 0x1658, 0x1679, 0x1698, 0x1698, 0x16b1,
	0x16c1, 0x16d1, 0x16d9, 0x16e7, 0x16f1, 0x1709, 0x1715, 0x1727,
	0x1735, 0x174d, 0x174d, 0x1759, 0x1759, 0x1767, 0x1779, 0x178e,
	0x178e, 0x178e, 0x17a1, 0x17b1, 0x17c3, 0x17dc, 0x17f0, 0x1802,
	0x180e, 0x182f, 0x182f, 0x182f, 0x1841, 0x184f, 0x185d, 0x1872,
	0x188d, 0x189d, 0x18ad, 0x18bd, 0x18c7, 0x18d7, 0x18e5, 0x18f5,
	// Entry 180 - 1BF
	0x18f5, 0x18f5, 0x18f5, 0x1901, 0x1901, 0x190d, 0x1919, 0x1936,
	0x1936, 0x1949, 0x1959, 0x1967, 0x196f, 0x197b, 0x198e, 0x198e,
	0x198e, 0x199e, 0x199e, 0x19aa, 0x19bc, 0x19ce, 0x19e0, 0x19ee,
	0x19f6, 0x1a04, 0x1a14, 0x1a20, 0x1a2c, 0x1a42, 0x1a63, 0x1a78,
	0x1a80, 0x1a9a, 0x1ab4, 0x1ac2, 0x1ad8, 0x1ae6, 0x1af2, 0x1af2,
	0x1afc, 0x1b11, 0x1b1d, 0x1b31, 0x1b45, 0x1b45, 0x1b45, 0x1b53,
	0x1b6b, 0x1b87, 0x1b99, 0x1bac, 0x1bcb, 0x1bdb, 0x1be7, 0x1bf3,
	0x1bf3, 0x1bff, 0x1c18, 0x1c26, 0x1c3f, 0x1c3f, 0x1c47, 0x1c64,
	// Entry 1C0 - 1FF
	0x1c70, 0x1c93, 0x1ca7, 0x1cb9, 0x1cc7, 0x1cd5, 0x1ce3, 0x1d04,
	0x1d1c, 0x1d2c, 0x1d40, 0x1d58, 0x1d68, 0x1d68, 0x1d8b, 0x1d8b,
	0x1d8b, 0x1daa, 0x1daa, 0x1dbc, 0x1dbc, 0x1dbc, 0x1dd4, 0x1dea,
	0x1e0f, 0x1e17, 0x1e17, 0x1e2f, 0x1e3f, 0x1e59, 0x1e59, 0x1e59,
	0x1e67, 0x1e75, 0x1e75, 0x1e75, 0x1e75, 0x1e8b, 0x1e95, 0x1ea7,
	0x1eb5, 0x1ed6, 0x1ee4, 0x1ef2, 0x1f04, 0x1f04, 0x1f0e, 0x1f18,
	0x1f26, 0x1f3c, 0x1f3c, 0x1f5b, 0x1f69, 0x1f71, 0x1f71, 0x1f7f,
	0x1f9a, 0x1fbd, 0x1fbd, 0x1fc9, 0x1fd3, 0x1ff2, 0x2002, 0x2002,
	// Entry 200 - 23F
	0x2002, 0x201d, 0x2030, 0x2049, 0x2060, 0x2070, 0x2080, 0x209b,
	0x20a5, 0x20b8, 0x20b8, 0x20c8, 0x20d4, 0x20e6, 0x20f4, 0x2111,
	0x2123, 0x2123, 0x2123, 0x212f, 0x2137, 0x2147, 0x2153, 0x2163,
	0x216d, 0x217f, 0x217f, 0x2191, 0x21a7, 0x21a7, 0x21b9, 0x21d0,
	0x21e5, 0x21e5, 0x21fc, 0x21fc, 0x2210, 0x2210, 0x2222, 0x2232,
	0x2240, 0x224e, 0x2276, 0x2284, 0x2298, 0x22a8, 0x22b2, 0x22bc,
	0x22bc, 0x22bc, 0x22bc, 0x22bc, 0x22ca, 0x22ca, 0x22d8, 0x22e6,
	0x22f8, 0x2306, 0x2312, 0x2322, 0x2339, 0x2349, 0x2349, 0x2355,
	// Entry 240 - 27F
	0x235f, 0x236d, 0x2379, 0x2381, 0x2381, 0x2399, 0x23ab, 0x23d5,
	0x23d5, 0x23e5, 0x241b, 0x2429, 0x2445, 0x244d, 0x2479, 0x2479,
	0x249e, 0x24d0, 0x24f9, 0x251c, 0x2545, 0x256c, 0x259e, 0x25c3,
	0x25e8, 0x25e8, 0x2607, 0x262a, 0x2649, 0x265b, 0x2684, 0x26ab,
	0x26bf, 0x26d8, 0x26f9, 0x2716, 0x2737,
} // Size: 1250 bytes

const azLangStr string = "" + // Size: 3713 bytes
	"afarabxazavestanafrikaansakanamhararaqonərəbassamavaraymaraazərbaycanbaş" +
	"qırdbelarusbolqarbislamabambarabenqaltibetbretonbosniakkatalançeçençamor" +
	"okorsikakriçexslavyançuvaşuelsdanimarkaalmanmaldivdzonqaeveyunaningilise" +
	"sperantoispanestonbaskfarsfulafinficifarerfransızqərbi frizirlandŞotland" +
	"iya keltcəsiqalisiyaquaraniqucaratmankshausaivrithindhiri motuxorvathait" +
	"i kreolmacarermənihererointerlinquaindoneziyainterlinqveiqbosiçuan yiinu" +
	"piaqidoislanditalyaninuktitutyaponyavagürcükonqokikuyukuanyamaqazaxkalaa" +
	"llisutkxmerkannadakoreyakanurikəşmirkürdkomikornqırğızlatınlüksemburqqan" +
	"dalimburqlinqalalaoslitvaluba-katanqalatışmalaqasmarşalmaorimakedonmalay" +
	"alammonqolmarathimalaymaltabirmannauruşimali ndebelenepalndonqahollandnü" +
	"norsk norveçbokmal norveçcənubi ndebelenavayonyancaoksitanocibvaoromoodi" +
	"yaosetinpəncabpalipolyakpuştuportuqalkeçuaromanşrundirumınruskinyarvanda" +
	"sanskritsardinsindhişimali samisanqosinhalaslovakslovensamoaşonasomalial" +
	"banserbsvatisesotosundanisveçsuahilitamilteluqutaciktaytiqrintürkmənsvan" +
	"atonqatürksonqatatartaxitiuyğurukraynaurduözbəkvendavyetnamvolapükvalunv" +
	"olofxosaidişyorubaçjuançinzuluakinakoliadanqmeadugeafrihiliaqhemaynuakka" +
	"daleutcənubi altayqədim ingilisangikaaramikmapuçearapahoaravakasuasturiy" +
	"aavadhibalucballibasabejabembabenaqərbi bəlucbxoçpuribikolbinisiksikəbra" +
	"jbodoburyatbuginblinkeddokaribatsamsebuançiqaçibçaçağatayçukizmariçinuk " +
	"ləhçəsiçoktauçipevyançerokiçeyensorankoptkrım türkcəsikaşubyandakotadarq" +
	"vataitadelaverslaveydoqribdinkazarmadoqriaşağı sorbdualaorta hollanddiol" +
	"adyuladazaqaembuefikqədim misirekacukelamitorta ingilisevondofangfilippi" +
	"nfonorta fransızqədim fransızşimali frisfriulqaqaqauzqanqayoqabayaqezqil" +
	"bertorta yüksək almanqədim almanqondiqorontalogotçaqreboqədim yunanİsveç" +
	"rə almancasıqusiqviçinhaydahakkahavayhiliqaynonhittitmonqyuxarı sorbsyan" +
	"hupaibanibibioilokoinquşloğbannqombamaçamivrit-farsivrit-ərəbqaraqalpaqk" +
	"abilekaçinjukambakavikabarda-çərkəztiyapmakondkabuverdiankoroxazixotanko" +
	"yra çiinikakokalencinkimbundukomi-permyakkonkanikosreyankpelleqaraçay-ba" +
	"lkarkarelkuruxşambalabafiakölnkumıkkutenaysefardlangiqərbi pəncablambalə" +
	"zgilakotamonqolozişimali luriluba-lulualuysenolundaluomizoluyiamadurizma" +
	"qahimaitilimakasarməndinqomasaymokşamandarmendemerumorisienorta irlandma" +
	"xuva-meettometa’mikmakminanqkabanmançumanipürimohavkmosimundanqçoxsaylı " +
	"dillərkrikmirandmaruarierzyamazandaranMin Nanneapolitannamaaşağı almanne" +
	"variniasniyuankvasiongiemboonnoqayqədim norsnqoşimal sotonuernyamvezinya" +
	"nkolnyoronzimaosageosmanpanqasinanpəhləvipampanqapapyamentopalayanniger " +
	"kreolqədim farsfoyenikponpeyqədim provansalkiçeracastanirapanuirarotonqa" +
	"nromboromanaromanruasandavesaxasamaritansamburusasaksantalnqambaysanqusi" +
	"ciliyaskotscənubi kürdsenaselkupkoyraboro senniqədim irlandtaçelitşansid" +
	"amocənubi samilule samiinari samiskolt samisoninkesoqdiyensranan tonqose" +
	"rersahosukumasususumeryankomorsuriyatimnetesoterenotetumtiqretivtokelayk" +
	"linqontlinqittamaşeknyasa tonqatok pisintarokosimşyantumbukatuvalutasava" +
	"qtuvinyanMərkəzi Atlas tamazicəsiudmurtuqaritumbundurutvaivotikvunyovall" +
	"esvalamovarayvaşovalpirivukalmıksoqayaoyapizyanqbenyembakantonzapotekbli" +
	"simbolszenaqatamazizunidil məzmunu yoxdurzazamüasir standart ərəbcənubi " +
	"azərbaycanAvstriya almancasıİsveçrə yüksək almancasıAvstraliya ingiliscə" +
	"siKanada ingiliscəsiBritaniya ingiliscəsiAmerika ingiliscəsiLatın Amerik" +
	"ası ispancasıKastiliya ispancasıMeksika ispancasıKanada fransızcasıİsveç" +
	"rə fransızcasıaşağı saksonflamandBraziliya portuqalcasıPortuqaliya portu" +
	"qalcasımoldavserb-xorvatKonqo suahilicəsisadələşmiş çinənənəvi çin"

var azLangIdx = []uint16{ // 613 elements
	// Entry 0 - 3F
	0x0000, 0x0004, 0x0009, 0x0010, 0x0019, 0x001d, 0x0022, 0x0028,
	0x002e, 0x0033, 0x0037, 0x003d, 0x0048, 0x0051, 0x0058, 0x005e,
	0x0065, 0x006c, 0x0072, 0x0077, 0x007d, 0x0084, 0x008b, 0x0092,
	0x0099, 0x00a0, 0x00a3, 0x00a7, 0x00ae, 0x00b5, 0x00b9, 0x00c2,
	0x00c7, 0x00cd, 0x00d3, 0x00d6, 0x00db, 0x00e2, 0x00eb, 0x00f0,
	0x00f5, 0x00f9, 0x00fd, 0x0101, 0x0104, 0x0108, 0x010d, 0x0115,
	0x0120, 0x0126, 0x013b, 0x0143, 0x014a, 0x0151, 0x0156, 0x015b,
	0x0160, 0x0164, 0x016d, 0x0173, 0x017e, 0x0183, 0x018a, 0x0190,
	// Entry 40 - 7F
	0x019b, 0x01a5, 0x01b0, 0x01b4, 0x01be, 0x01c5, 0x01c8, 0x01ce,
	0x01d5, 0x01de, 0x01e3, 0x01e7, 0x01ee, 0x01f3, 0x01f9, 0x0201,
	0x0206, 0x0211, 0x0216, 0x021d, 0x0223, 0x0229, 0x0231, 0x0236,
	0x023a, 0x023e, 0x0247, 0x024d, 0x0258, 0x025d, 0x0264, 0x026b,
	0x026f, 0x0274, 0x0280, 0x0287, 0x028e, 0x0295, 0x029a, 0x02a1,
	0x02aa, 0x02b0, 0x02b7, 0x02bc, 0x02c1, 0x02c7, 0x02cc, 0x02db,
	0x02e0, 0x02e6, 0x02ed, 0x02fd, 0x030b, 0x031a, 0x0320, 0x0326,
	0x032d, 0x0333, 0x0338, 0x033d, 0x0343, 0x034a, 0x034e, 0x0354,
	// Entry 80 - BF
	0x035a, 0x0362, 0x0368, 0x036f, 0x0374, 0x037a, 0x037d, 0x0388,
	0x0390, 0x0396, 0x039c, 0x03a8, 0x03ad, 0x03b4, 0x03ba, 0x03c0,
	0x03c5, 0x03ca, 0x03d0, 0x03d5, 0x03d9, 0x03de, 0x03e4, 0x03ea,
	0x03f0, 0x03f7, 0x03fc, 0x0402, 0x0407, 0x040a, 0x0410, 0x0419,
	0x041e, 0x0423, 0x0428, 0x042d, 0x0432, 0x0438, 0x043e, 0x0445,
	0x0449, 0x0450, 0x0455, 0x045c, 0x0464, 0x0469, 0x046e, 0x0472,
	0x0477, 0x047d, 0x0483, 0x0487, 0x048b, 0x048f, 0x0494, 0x049b,
	0x04a0, 0x04a0, 0x04a8, 0x04ad, 0x04b1, 0x04b6, 0x04b6, 0x04bb,
	// Entry C0 - FF
	0x04bb, 0x04c8, 0x04d6, 0x04dc, 0x04e2, 0x04e9, 0x04e9, 0x04f0,
	0x04f0, 0x04f0, 0x04f6, 0x04f6, 0x04f6, 0x04f9, 0x04f9, 0x0501,
	0x0501, 0x0507, 0x050c, 0x0511, 0x0511, 0x0515, 0x0515, 0x0515,
	0x0515, 0x0519, 0x051e, 0x051e, 0x0522, 0x0522, 0x0522, 0x052f,
	0x0538, 0x053d, 0x0541, 0x0541, 0x0541, 0x0549, 0x0549, 0x0549,
	0x054d, 0x054d, 0x0551, 0x0551, 0x0557, 0x055c, 0x055c, 0x0560,
	0x0560, 0x0565, 0x056a, 0x056a, 0x056f, 0x0575, 0x057a, 0x0581,
	0x058a, 0x0590, 0x0594, 0x05a5, 0x05ac, 0x05b5, 0x05bc, 0x05c2,
	// Entry 100 - 13F
	0x05c7, 0x05cb, 0x05cb, 0x05db, 0x05db, 0x05e4, 0x05ea, 0x05f0,
	0x05f5, 0x05fc, 0x0602, 0x0608, 0x060d, 0x0612, 0x0617, 0x0624,
	0x0624, 0x0629, 0x0635, 0x063a, 0x063f, 0x0645, 0x0649, 0x064d,
	0x064d, 0x0659, 0x065f, 0x0665, 0x0671, 0x0671, 0x0677, 0x0677,
	0x067b, 0x0683, 0x0683, 0x0686, 0x0686, 0x0693, 0x06a2, 0x06a2,
	0x06ae, 0x06ae, 0x06b3, 0x06b5, 0x06bb, 0x06be, 0x06c2, 0x06c8,
	0x06c8, 0x06cb, 0x06d2, 0x06d2, 0x06e5, 0x06f1, 0x06f1, 0x06f6,
	0x06ff, 0x0705, 0x070a, 0x0716, 0x072b, 0x072b, 0x072b, 0x072f,
	// Entry 140 - 17F
	0x0736, 0x073b, 0x0740, 0x0745, 0x0745, 0x074f, 0x0755, 0x0759,
	0x0765, 0x0769, 0x076d, 0x0771, 0x0777, 0x077c, 0x0782, 0x0782,
	0x0782, 0x0789, 0x078f, 0x0795, 0x079f, 0x07ab, 0x07ab, 0x07b5,
	0x07bb, 0x07c1, 0x07c3, 0x07c8, 0x07cc, 0x07dd, 0x07dd, 0x07e2,
	0x07e8, 0x07f3, 0x07f3, 0x07f7, 0x07f7, 0x07fb, 0x0800, 0x080c,
	0x080c, 0x080c, 0x0810, 0x0818, 0x0820, 0x082c, 0x0833, 0x083b,
	0x0841, 0x0850, 0x0850, 0x0850, 0x0855, 0x085a, 0x0862, 0x0867,
	0x086c, 0x0872, 0x0879, 0x087f, 0x0884, 0x0892, 0x0897, 0x089d,
	// Entry 180 - 1BF
	0x089d, 0x089d, 0x089d, 0x08a3, 0x08a3, 0x08a8, 0x08ac, 0x08b8,
	0x08b8, 0x08c2, 0x08c9, 0x08ce, 0x08d1, 0x08d5, 0x08da, 0x08da,
	0x08da, 0x08e1, 0x08e1, 0x08e7, 0x08ee, 0x08f5, 0x08fe, 0x0903,
	0x0903, 0x0909, 0x090f, 0x0914, 0x0918, 0x0920, 0x092b, 0x0938,
	0x093f, 0x0945, 0x0950, 0x0956, 0x095f, 0x0965, 0x0969, 0x0969,
	0x0970, 0x0982, 0x0986, 0x098c, 0x0993, 0x0993, 0x0993, 0x0998,
	0x09a2, 0x09a9, 0x09b3, 0x09b7, 0x09c5, 0x09cb, 0x09cf, 0x09d5,
	0x09d5, 0x09db, 0x09e4, 0x09e9, 0x09f4, 0x09f4, 0x09f7, 0x0a02,
	// Entry 1C0 - 1FF
	0x0a06, 0x0a06, 0x0a0e, 0x0a15, 0x0a1a, 0x0a1f, 0x0a24, 0x0a29,
	0x0a33, 0x0a3c, 0x0a44, 0x0a4e, 0x0a55, 0x0a55, 0x0a60, 0x0a60,
	0x0a60, 0x0a6b, 0x0a6b, 0x0a72, 0x0a72, 0x0a72, 0x0a78, 0x0a78,
	0x0a88, 0x0a8d, 0x0a8d, 0x0a96, 0x0a9d, 0x0aa7, 0x0aa7, 0x0aa7,
	0x0aac, 0x0ab1, 0x0ab1, 0x0ab1, 0x0ab1, 0x0ab7, 0x0aba, 0x0ac1,
	0x0ac5, 0x0ace, 0x0ad5, 0x0ada, 0x0ae0, 0x0ae0, 0x0ae7, 0x0aec,
	0x0af4, 0x0af9, 0x0af9, 0x0b06, 0x0b06, 0x0b0a, 0x0b0a, 0x0b10,
	0x0b1f, 0x0b2c, 0x0b2c, 0x0b34, 0x0b38, 0x0b38, 0x0b3e, 0x0b3e,
	// Entry 200 - 23F
	0x0b3e, 0x0b4a, 0x0b53, 0x0b5d, 0x0b67, 0x0b6e, 0x0b76, 0x0b82,
	0x0b87, 0x0b8b, 0x0b8b, 0x0b91, 0x0b95, 0x0b9d, 0x0ba2, 0x0ba2,
	0x0ba8, 0x0ba8, 0x0ba8, 0x0bad, 0x0bb1, 0x0bb7, 0x0bbc, 0x0bc1,
	0x0bc4, 0x0bcb, 0x0bcb, 0x0bd2, 0x0bd9, 0x0bd9, 0x0be1, 0x0bec,
	0x0bf5, 0x0bf5, 0x0bfb, 0x0bfb, 0x0c03, 0x0c03, 0x0c0a, 0x0c10,
	0x0c17, 0x0c1f, 0x0c3a, 0x0c40, 0x0c46, 0x0c4d, 0x0c50, 0x0c53,
	0x0c53, 0x0c53, 0x0c53, 0x0c53, 0x0c58, 0x0c58, 0x0c5d, 0x0c63,
	0x0c69, 0x0c6e, 0x0c73, 0x0c7a, 0x0c7c, 0x0c83, 0x0c83, 0x0c87,
	// Entry 240 - 27F
	0x0c8a, 0x0c8f, 0x0c96, 0x0c9b, 0x0c9b, 0x0ca1, 0x0ca8, 0x0cb2,
	0x0cb2, 0x0cb8, 0x0cbe, 0x0cc2, 0x0cd5, 0x0cd9, 0x0cf0, 0x0d03,
	0x0d16, 0x0d34, 0x0d4b, 0x0d5e, 0x0d74, 0x0d88, 0x0da4, 0x0db8,
	0x0dca, 0x0dca, 0x0dde, 0x0df6, 0x0e05, 0x0e0c, 0x0e23, 0x0e3c,
	0x0e42, 0x0e4d, 0x0e5f, 0x0e72, 0x0e81,
} // Size: 1250 bytes

const bgLangStr string = "" + // Size: 7891 bytes
	"афарабхазкиавестскиафрикаансаканамхарскиарагонскиарабскиасамскиаварскиай" +
	"мараазербайджанскибашкирскибеларускибългарскибисламабамбарабенгалскитиб" +
	"етскибретонскибосненскикаталонскичеченскичаморокорсиканскикриичешкицърк" +
	"овнославянскичувашкиуелскидатскинемскидивехидзонхаевегръцкианглийскиесп" +
	"ерантоиспанскиестонскибаскиперсийскифулафинскифиджийскифарьорскифренски" +
	"фризийскиирландскишотландски галскигалисийскигуаранигуджаратиманкскихау" +
	"заивритхиндихири мотухърватскихаитянски креолскиунгарскиарменскихерерои" +
	"нтерлингваиндонезийскиоксиденталигбосъчуански иинупиакидоисландскиитали" +
	"анскиинуктитутяпонскияванскигрузинскиконгоанскикикуюкванямаказахскигрен" +
	"ландскикхмерскиканнадакорейскиканурикашмирскикюрдскикомикорнуолскикирги" +
	"зкилатинскилюксембургскигандалимбургскилингалалаоскилитовскилуба катанг" +
	"алатвийскималгашкимаршалеземаорскимакедонскималаяламмонголскимаратимала" +
	"йскималтийскибирманскинаурусеверен ндебеленепалскиндонганидерландскинор" +
	"вежки (нюношк)норвежки (букмол)южен ндебеленавахонянджаокситанскиоджибв" +
	"аоромоорияосетскипенджабскипалиполскипущупортугалскикечуаретороманскиру" +
	"ндирумънскирускикиняруандасанскритсардинскисиндхисеверносаамскисангосин" +
	"халскисловашкисловенскисамоанскишонасомалийскиалбанскисръбскисватисесот" +
	"осунданскишведскисуахилитамилскителугутаджикскитайскитигринятуркменскит" +
	"сванатонгатурскицонгататарскитаитянскиуйгурскиукраинскиурдуузбекскивенд" +
	"авиетнамскиволапюквалонскиволофксосаидишйорубазуангкитайскизулускиачинс" +
	"киаколиадангмеадигеафрихилиагемайнуакадскиалеутскиюжноалтайскистароангл" +
	"ийскиангикаарамейскимапучеарапахоаравакасуастурскиавадибалучибалийскиба" +
	"сабеябембабеназападен балочибожпурибиколскибинисиксикабраджбодобурятски" +
	"бугинскибиленскикаддокарибскиатсамсебуаночигачибчачагатайчуукмарийскижа" +
	"ргон чинуукчокточиипувскичерокичейенскикюрдски (централен)коптскикримск" +
	"отатарскисеселва, креолски френскикашубскидакотскидаргватаитаделауерсле" +
	"йвидогрибдинказармадогридолносръбскидуаласредновековен холандскидиолади" +
	"уладазагаембуефикдревноегипетскиекажукеламитскисредновековен английские" +
	"вондофангфилипинскифонсредновековен френскистарофренскисеверен фризскии" +
	"зточнофризийскифриулианскигагагаузкигайогбаягиизгилбертскисредновисокон" +
	"емскистаровисоконемскигондигоронталоготическигребодревногръцкишвейцарск" +
	"и немскигусиигвичинхайдахавайскихилигайнонхитскихмонггорнолужишкихупаиб" +
	"анибибиоилокоингушетскиложбаннгомбамачамеюдео-персийскиюдео-арабскикара" +
	"калпашкикабилскикачинскижжукамбакавикабардиантуапмакондекабовердианскик" +
	"орокхасикотскикойра чииникакокаленджинкимбундукоми-пермякскиконканикоср" +
	"аенкпелекарачай-балкарскикарелскикурукшамбалабафиякьолнскикумикскикутен" +
	"айладинолангилахндаламбалезгинскилакотамонголозисеверен лурилуба-лулуал" +
	"уисеньолундалуомизолуямадурскимагахимайтхилимакасармандингомасайскимокш" +
	"амандармендемеруморисиенсредновековен ирландскимакуа метометамикмакмина" +
	"нгкабауманджурскиманипуримохоукмосимундангмногоезичникрикмирандийскимар" +
	"вариерзиамазандаринеаполитанскинамадолнонемскиневарскиниасниуеанквасион" +
	"гиембунногаистаронорвежкинкосеверен сотонуеркласически невариниамвезини" +
	"анколенуоронзимаосейджиотомански турскипангасинанпахлавипампангапапиаме" +
	"нтопалауаннигерийски пиджинстароперсийскифиникийскипонапеанпрускистароп" +
	"ровансалскикичераджастанскирапа нуираротонгаромборомскиарумънскирвасанд" +
	"авеякутскисамаритански арамейскисамбурусасаксанталингамбайсангусицилиан" +
	"скишотландскиюжнокюрдскисенаселкупкойраборо сенистароирландскиташелхитш" +
	"ансидамоюжносаамскилуле-саамскиинари-саамскисколт-саамскисонинкесогдийс" +
	"кисранан тонгосерерсахосукумасусушумерскикоморскикласически сирийскисир" +
	"ийскитемнетесотеренотетумтигретивтокелайскиклингонскитлингиттамашекниан" +
	"са тонгаток писинтарокоцимшианскитумбукатувалуанскитасавактувинскицентр" +
	"алноатласки тамазигтудмуртскиугаритскиумбундуроотваивотиквунджовалзерск" +
	"и немскиваламоварайуашовалпирикалмиксогаяояпезеянгбенйембакантонскизапо" +
	"текблис символизенагастандартен марокански тамазигтзунибез лингвистично" +
	" съдържаниезазасъвременен стандартен арабскианглийски (САЩ)долносаксонск" +
	"ифламандскимолдовскисърбохърватскиконгоански суахиликитайски (опростен)"

var bgLangIdx = []uint16{ // 612 elements
	// Entry 0 - 3F
	0x0000, 0x0008, 0x0016, 0x0026, 0x0038, 0x0040, 0x0050, 0x0062,
	0x0070, 0x007e, 0x008c, 0x0098, 0x00b4, 0x00c6, 0x00d8, 0x00ea,
	0x00f8, 0x0106, 0x0118, 0x0128, 0x013a, 0x014c, 0x0160, 0x0170,
	0x017c, 0x0192, 0x019a, 0x01a4, 0x01c6, 0x01d4, 0x01e0, 0x01ec,
	0x01f8, 0x0204, 0x0210, 0x0216, 0x0222, 0x0234, 0x0246, 0x0256,
	0x0266, 0x0270, 0x0282, 0x028a, 0x0296, 0x02a8, 0x02ba, 0x02c8,
	0x02da, 0x02ec, 0x030d, 0x0321, 0x032f, 0x0341, 0x034f, 0x0359,
	0x0363, 0x036d, 0x037e, 0x0390, 0x03b3, 0x03c3, 0x03d3, 0x03df,
	// Entry 40 - 7F
	0x03f5, 0x040d, 0x0421, 0x0429, 0x043e, 0x044c, 0x0452, 0x0464,
	0x0478, 0x048a, 0x0498, 0x04a6, 0x04b8, 0x04cc, 0x04d6, 0x04e4,
	0x04f4, 0x050a, 0x051a, 0x0528, 0x0538, 0x0544, 0x0556, 0x0564,
	0x056c, 0x0580, 0x0590, 0x05a0, 0x05ba, 0x05c4, 0x05d8, 0x05e6,
	0x05f2, 0x0602, 0x0619, 0x062b, 0x063b, 0x064d, 0x065b, 0x066f,
	0x067f, 0x0691, 0x069d, 0x06ad, 0x06bf, 0x06d1, 0x06db, 0x06f8,
	0x0708, 0x0714, 0x072c, 0x074b, 0x076a, 0x0781, 0x078d, 0x0799,
	0x07ad, 0x07bb, 0x07c5, 0x07cd, 0x07db, 0x07ef, 0x07f7, 0x0803,
	// Entry 80 - BF
	0x080b, 0x0821, 0x082b, 0x0843, 0x084d, 0x085d, 0x0867, 0x087b,
	0x088b, 0x089d, 0x08a9, 0x08c5, 0x08cf, 0x08e1, 0x08f1, 0x0903,
	0x0915, 0x091d, 0x0931, 0x0941, 0x094f, 0x0959, 0x0965, 0x0977,
	0x0985, 0x0993, 0x09a3, 0x09af, 0x09c1, 0x09cd, 0x09db, 0x09ef,
	0x09fb, 0x0a05, 0x0a11, 0x0a1b, 0x0a2b, 0x0a3d, 0x0a4d, 0x0a5f,
	0x0a67, 0x0a77, 0x0a81, 0x0a95, 0x0aa3, 0x0ab3, 0x0abd, 0x0ac7,
	0x0acf, 0x0adb, 0x0ae5, 0x0af5, 0x0b03, 0x0b11, 0x0b1b, 0x0b29,
	0x0b33, 0x0b33, 0x0b43, 0x0b4b, 0x0b53, 0x0b61, 0x0b61, 0x0b71,
	// Entry C0 - FF
	0x0b71, 0x0b89, 0x0ba5, 0x0bb1, 0x0bc3, 0x0bcf, 0x0bcf, 0x0bdd,
	0x0bdd, 0x0bdd, 0x0be9, 0x0be9, 0x0be9, 0x0bef, 0x0bef, 0x0bff,
	0x0bff, 0x0c09, 0x0c15, 0x0c25, 0x0c25, 0x0c2d, 0x0c2d, 0x0c2d,
	0x0c2d, 0x0c33, 0x0c3d, 0x0c3d, 0x0c45, 0x0c45, 0x0c45, 0x0c60,
	0x0c6e, 0x0c7e, 0x0c86, 0x0c86, 0x0c86, 0x0c94, 0x0c94, 0x0c94,
	0x0c9e, 0x0c9e, 0x0ca6, 0x0ca6, 0x0cb6, 0x0cc6, 0x0cc6, 0x0cd6,
	0x0cd6, 0x0ce0, 0x0cf0, 0x0cf0, 0x0cfa, 0x0d08, 0x0d10, 0x0d1a,
	0x0d28, 0x0d30, 0x0d40, 0x0d59, 0x0d63, 0x0d75, 0x0d81, 0x0d91,
	// Entry 100 - 13F
	0x0db4, 0x0dc2, 0x0dc2, 0x0de0, 0x0e0f, 0x0e1f, 0x0e2f, 0x0e3b,
	0x0e45, 0x0e53, 0x0e5f, 0x0e6b, 0x0e75, 0x0e7f, 0x0e89, 0x0ea1,
	0x0ea1, 0x0eab, 0x0ed8, 0x0ee2, 0x0eec, 0x0ef8, 0x0f00, 0x0f08,
	0x0f08, 0x0f26, 0x0f32, 0x0f44, 0x0f71, 0x0f71, 0x0f7d, 0x0f7d,
	0x0f85, 0x0f99, 0x0f99, 0x0f9f, 0x0f9f, 0x0fc8, 0x0fe0, 0x0fe0,
	0x0ffd, 0x101d, 0x1033, 0x1037, 0x1047, 0x1047, 0x104f, 0x1057,
	0x1057, 0x105f, 0x1073, 0x1073, 0x1097, 0x10b9, 0x10b9, 0x10c3,
	0x10d5, 0x10e7, 0x10f1, 0x1109, 0x112a, 0x112a, 0x112a, 0x1134,
	// Entry 140 - 17F
	0x1140, 0x114a, 0x114a, 0x115a, 0x115a, 0x116e, 0x117a, 0x1184,
	0x119c, 0x119c, 0x11a4, 0x11ac, 0x11b8, 0x11c2, 0x11d6, 0x11d6,
	0x11d6, 0x11e2, 0x11ee, 0x11fa, 0x1215, 0x122c, 0x122c, 0x1244,
	0x1254, 0x1264, 0x126a, 0x1274, 0x127c, 0x128e, 0x128e, 0x1296,
	0x12a4, 0x12c0, 0x12c0, 0x12c8, 0x12c8, 0x12d2, 0x12de, 0x12f3,
	0x12f3, 0x12f3, 0x12fb, 0x130d, 0x131d, 0x1338, 0x1346, 0x1354,
	0x135e, 0x137f, 0x137f, 0x137f, 0x138f, 0x1399, 0x13a7, 0x13b1,
	0x13c1, 0x13d1, 0x13df, 0x13eb, 0x13f5, 0x1401, 0x140b, 0x141d,
	// Entry 180 - 1BF
	0x141d, 0x141d, 0x141d, 0x1429, 0x1429, 0x1433, 0x143b, 0x1452,
	0x1452, 0x1465, 0x1475, 0x147f, 0x1485, 0x148d, 0x1493, 0x1493,
	0x1493, 0x14a3, 0x14a3, 0x14af, 0x14bf, 0x14cd, 0x14dd, 0x14ed,
	0x14ed, 0x14f7, 0x1503, 0x150d, 0x1515, 0x1525, 0x1552, 0x1565,
	0x156d, 0x1579, 0x158f, 0x15a3, 0x15b3, 0x15bf, 0x15c7, 0x15c7,
	0x15d5, 0x15eb, 0x15f3, 0x1609, 0x1617, 0x1617, 0x1617, 0x1621,
	0x1633, 0x1633, 0x164d, 0x1655, 0x166b, 0x167b, 0x1683, 0x168f,
	0x168f, 0x169b, 0x16ab, 0x16b5, 0x16cf, 0x16cf, 0x16d5, 0x16ec,
	// Entry 1C0 - 1FF
	0x16f4, 0x1715, 0x1725, 0x1735, 0x173f, 0x1749, 0x1757, 0x1776,
	0x178a, 0x1798, 0x17a8, 0x17bc, 0x17ca, 0x17ca, 0x17eb, 0x17eb,
	0x17eb, 0x1807, 0x1807, 0x181b, 0x181b, 0x181b, 0x182b, 0x1837,
	0x1859, 0x1861, 0x1861, 0x1879, 0x1888, 0x189a, 0x189a, 0x189a,
	0x18a4, 0x18b0, 0x18b0, 0x18b0, 0x18b0, 0x18c2, 0x18c8, 0x18d6,
	0x18e4, 0x190f, 0x191d, 0x1927, 0x1935, 0x1935, 0x1943, 0x194d,
	0x1963, 0x1977, 0x1977, 0x198d, 0x198d, 0x1995, 0x1995, 0x19a1,
	0x19bc, 0x19d8, 0x19d8, 0x19e8, 0x19ee, 0x19ee, 0x19fa, 0x19fa,
	// Entry 200 - 23F
	0x19fa, 0x1a10, 0x1a27, 0x1a40, 0x1a59, 0x1a67, 0x1a79, 0x1a90,
	0x1a9a, 0x1aa2, 0x1aa2, 0x1aae, 0x1ab6, 0x1ac6, 0x1ad6, 0x1afb,
	0x1b0b, 0x1b0b, 0x1b0b, 0x1b15, 0x1b1d, 0x1b29, 0x1b33, 0x1b3d,
	0x1b43, 0x1b57, 0x1b57, 0x1b6b, 0x1b79, 0x1b79, 0x1b87, 0x1b9e,
	0x1baf, 0x1baf, 0x1bbb, 0x1bbb, 0x1bcf, 0x1bcf, 0x1bdd, 0x1bf3,
	0x1c01, 0x1c11, 0x1c42, 0x1c54, 0x1c66, 0x1c74, 0x1c7c, 0x1c82,
	0x1c82, 0x1c82, 0x1c82, 0x1c82, 0x1c8c, 0x1c8c, 0x1c98, 0x1cb7,
	0x1cc3, 0x1ccd, 0x1cd5, 0x1ce3, 0x1ce3, 0x1cef, 0x1cef, 0x1cf7,
	// Entry 240 - 27F
	0x1cfb, 0x1d05, 0x1d11, 0x1d1b, 0x1d1b, 0x1d2d, 0x1d3b, 0x1d52,
	0x1d52, 0x1d5e, 0x1d98, 0x1da0, 0x1dd4, 0x1ddc, 0x1e14, 0x1e14,
	0x1e14, 0x1e14, 0x1e14, 0x1e14, 0x1e14, 0x1e2f, 0x1e2f, 0x1e2f,
	0x1e2f, 0x1e2f, 0x1e2f, 0x1e2f, 0x1e4b, 0x1e5f, 0x1e5f, 0x1e5f,
	0x1e71, 0x1e8d, 0x1eb0, 0x1ed3,
} // Size: 1248 bytes

const bnLangStr string = "" + // Size: 12336 bytes
	"আফারআবখাজিয়ানআবেস্তীয়আফ্রিকানআকানআমহারিকআর্গোনিজআরবীআসামিআভেরিকআয়মারা" +
	"আজারবাইজানীবাশকিরবেলারুশিয়বুলগেরিয়বিসলামাবামবারাবাংলাতিব্বতিব্রেটনবস" +
	"নীয়ানকাতালানচেচেনচামোরোকর্সিকানক্রিচেকচার্চ স্লাভিকচুবাসওয়েলশডেনিশজা" +
	"র্মানদিবেহিজোঙ্গাইউয়িগ্রিকইংরেজিএস্পেরান্তোস্প্যানিশএস্তোনীয়বাস্কফার" +
	"্সিফুলাহ্ফিনিশফিজিআনফারোসফরাসিপশ্চিম ফ্রিসিয়ানআইরিশস্কটস-গ্যেলিকগ্যাল" +
	"িশিয়গুয়ারানিগুজরাটিম্যাঙ্কসহাউসাহিব্রুহিন্দিহিরি মোতুক্রোয়েশীয়হাইত" +
	"িয়ানহাঙ্গেরীয়আর্মেনিয়হেরেরোইন্টারলিঙ্গুয়াইন্দোনেশীয়ইন্টারলিঙ্গইগ্" +
	"\u200cবোসিচুয়ান য়িইনুপিয়াকইডোআইসল্যান্ডীয়ইতালিয়ইনুক্টিটুটজাপানিজাভা" +
	"নিজজর্জিয়ানকঙ্গোকিকুয়ুকোয়ানিয়ামাকাজাখক্যালাল্লিসুটখমেরকন্নড়কোরিয়" +
	"ানকানুরিকাশ্মীরিকুর্দিশকোমিকর্ণিশকির্গিজলাটিনলুক্সেমবার্গীয়গান্ডালিম্" +
	"বুর্গিশলিঙ্গালালাওলিথুয়েনীয়লুবা-কাটাঙ্গালাত্\u200cভীয়মালাগাসিমার্শা" +
	"লিজমাওরিম্যাসিডোনীয়মালায়ালামমঙ্গোলিয়মারাঠিমালয়মল্টিয়বর্মিনাউরুউত্" +
	"তর এন্দেবিলিনেপালীএন্দোঙ্গাডাচনরওয়েজীয়ান নিনর্স্কনরওয়েজিয়ান বোকমাল" +
	"দক্ষিণ এনডেবেলেনাভাজোনায়াঞ্জাঅক্সিটানওজিবওয়াঅরোমোওড়িয়াওসেটিকপাঞ্জা" +
	"বীপালিপোলিশপাশ্তুপর্তুগীজকেচুয়ারোমান্সরুন্দিরোমানীয়রুশকিনয়ারোয়ান্ড" +
	"াসংস্কৃতসার্ডিনিয়ানসিন্ধিউত্তরাঞ্চলীয় সামিসাঙ্গোসিংহলীস্লোভাকস্লোভেন" +
	"ীয়সামোয়ানশোনাসোমালিআলবেনীয়সার্বীয়সোয়াতিদক্ষিন সোথোসুদানীসুইডিশসোয" +
	"়াহিলিতামিলতেলেগুতাজিকথাইতিগরিনিয়াতুর্কমেনীসোয়ানাটোঙ্গানতুর্কীসঙ্গাত" +
	"াতারতাহিতিয়ানউইঘুরইউক্রেনীয়উর্দুউজবেকীয়ভেন্ডাভিয়েতনামীভোলাপুকওয়াল" +
	"ুনউওলোফজোসায়িদ্দিশইওরুবাঝু্য়াঙচীনাজুলুঅ্যাচাইনিজআকোলিঅদাগ্মেআদেগেআফ্" +
	"রিহিলিএঘেমআইনুআক্কাদিয়ানআলেউতদক্ষিন আলতাইপ্রাচীন ইংরেজীআঙ্গিকাআরামাইক" +
	"মাপুচিআরাপাহোআরাওয়াকআসুআস্তুরিয়আওয়াধিবেলুচীবালিনীয়বাসাবেজাবেম্বাবে" +
	"নাপশ্চিম বালোচিভোজপুরিবিকোলবিনিসিকসিকাব্রাজবোড়োবুরিয়াতবুগিনিব্লিনক্য" +
	"াডোক্যারিবআত্সামচেবুয়ানোচিগাচিবচাচাগাতাইচুকিমারিচিনুক জার্গনচকটোওচিপে" +
	"ওয়ানচেরোকীশাইয়েনমধ্য কুর্দিশকপটিকক্রিমিয়ান তুর্কিসেসেলওয়া ক্রেওল ফ" +
	"্রেঞ্চকাশুবিয়ানডাকোটাদার্গওয়াতাইতাডেলাওয়েরস্ল্যাভদোগ্রীবডিংকাজার্মা" +
	"ডোগরিনিম্নতর সোর্বিয়ানদুয়ালামধ্য ডাচজলা-ফনীডিউলাদাগাজাএম্বুএফিকপ্রাচ" +
	"ীন মিশরীয়ইকাজুকএলামাইটমধ্য ইংরেজিইওন্ডোফ্যাঙ্গফিলিপিনোফনমধ্য ফরাসিপ্র" +
	"াচীন ফরাসিউত্তরাঞ্চলীয় ফ্রিসিয়ানপূর্ব ফ্রিসিয়ফ্রিউলিয়ানগাগাগাউজgan" +
	"গায়োবায়াগীজগিলবার্টিজমধ্য-উচ্চ জার্মানিপ্রাচীন উচ্চ জার্মানিগোন্ডিগো" +
	"রোন্তালোগথিকগ্রেবোপ্রাচীন গ্রীকসুইস জার্মানগুসীগওইচ্’ইনহাইডাhakহাওয়াই" +
	"য়ানহিলিগ্যায়নোনহিট্টিটহ্\u200cমোঙউচ্চ সোর্বিয়ানXiang চীনাহুপাইবানইব" +
	"িবিওইলোকোইঙ্গুশলোজবানগোম্বামাকামেজুদেও ফার্সিজুদেও আরবিকারা-কাল্পাককাব" +
	"াইলেকাচিনঅজ্জুকাম্বাকাউইকাবার্ডিয়ানটাইয়াপমাকোন্দেকাবুভারদিয়ানুকোরোখ" +
	"াশিখোটানিজকোয়রা চীনিকাকোকালেনজিনকিম্বুন্দুকমি-পারমিআককোঙ্কানিকোস্রাইন" +
	"ক্\u200cপেল্লেকারচে-বাল্কারকারেলিয়ানকুরুখশাম্বালাবাফিয়াকল্শকুমিককুটে" +
	"নাইলাডিনোলাঙ্গিলান্ডালাম্বালেজঘিয়ানলাকোটামোঙ্গোলোজিউত্তর লুরিলুবা-লুল" +
	"ুয়ালুইসেনোলুন্ডালুয়োমিজোলুইয়ামাদুরেসেমাগাহিমৈথিলিম্যাকাসারম্যান্ডিঙ" +
	"্গোমাসাইমোকশাম্যাণ্ডারমেন্ডেমেরুমরিসিয়ানমধ্য আইরিশমাখুয়া-মেত্তোমেটাম" +
	"িকম্যাকমিনাঙ্গ্\u200cকাবাউমাঞ্চুমণিপুরীমোহাওকমসিমুদাঙ্গএকাধিক ভাষাক্রি" +
	"কমিরান্ডিজমারোয়ারিএরজিয়ামাজানদেরানিnanনেয়াপোলিটাননামানিম্ন জার্মানি" +
	"নেওয়ারিনিয়াসনিউয়ানকোয়াসিওনিঙ্গেম্বুননোগাইপ্রাচীন নর্সএন’কোউত্তরাঞ্" +
	"চলীয় সোথোনুয়ারপ্রাচীন নেওয়ারীন্যায়ামওয়েজিন্যায়াঙ্কোলেন্যোরোএনজিম" +
	"াওসেজঅটোমান তুর্কিপাঙ্গাসিনানপাহ্লাভিপাম্পাঙ্গাপাপিয়ামেন্টোপালায়ুয়া" +
	"ননাজেরিয় পিজিনপ্রাচীন ফার্সিফোনিশীয়ানপোহ্নপেইয়ানপ্রুশিয়ানপ্রাচীন প" +
	"্রোভেনসালকি‘চেরাজস্থানীরাপানুইরারোটোংগানরম্বোরোমানিআরমেনিয়ানরাওয়াস্য" +
	"ান্ডাওয়েশাখাসামারিটান আরামিকসামবুরুসাসাকসাঁওতালিন্যাগাম্বেসাঙ্গুসিসিল" +
	"িয়ানস্কটসদক্ষিণ কুর্দিশসেনাসেল্কুপকোয়রাবেনো সেন্নীপ্রাচীন আইরিশতাচেল" +
	"হিতশানসিডামোদক্ষিণাঞ্চলীয় সামিলুলে সামিইনারি সামিস্কোল্ট সামিসোনিঙ্কে" +
	"সোগডিয়ানস্রানান টোঙ্গোসেরেরসাহোসুকুমাসুসুসুমেরীয়কমোরিয়ানপ্রাচীন সির" +
	"িওসিরিয়াকটাইম্নেতেসোতেরেনোতেতুমটাইগ্রেটিভটোকেলাউক্লিঙ্গনত্লিঙ্গিটতামা" +
	"শেকনায়াসা টোঙ্গাটোক পিসিনতারোকোসিমশিয়ানতুম্বুকাটুভালুতাসাওয়াকটুভিনি" +
	"য়ানসেন্ট্রাল আটলাস তামাজিগাতউডমুর্টউগারিটিকউম্বুন্দুমূলভাইভোটিকভুঞ্জো" +
	"ওয়ালসেরওয়ালামোওয়ারেওয়াশোওয়ার্লপিরিWu চীনাকাল্মইকসোগাইয়াওইয়াপেসে" +
	"য়াঙ্গবেনয়েম্বাক্যানটোনীজজাপোটেকচিত্র ভাষাজেনাগাআদর্শ মরক্কোন তামাজিগ" +
	"াতজুনিভাষাভিত্তিক বিষয়বস্তু নেইজাজাআধুনিক আদর্শ আরবীঅস্ট্রিয়ান জার্ম" +
	"ানসুইস হাই জার্মানঅস্ট্রেলীয় ইংরেজিকানাডীয় ইংরেজিব্রিটিশ ইংরেজিআমেরি" +
	"কার ইংরেজিল্যাটিন আমেরিকান স্প্যানিশইউরোপীয় স্প্যানিশম্যাক্সিকান স্প্" +
	"যানিশকানাডীয় ফরাসিসুইস ফরাসিলো স্যাক্সনফ্লেমিশব্রাজিলের পর্তুগীজইউরোপ" +
	"ের পর্তুগীজমলদাভিয়সার্বো-ক্রোয়েশিয়কঙ্গো সোয়াহিলিসরলীকৃত চীনাঐতিহ্য" +
	"বাহি চীনা"

var bnLangIdx = []uint16{ // 613 elements
	// Entry 0 - 3F
	0x0000, 0x000c, 0x002a, 0x0045, 0x005d, 0x0069, 0x007e, 0x0096,
	0x00a2, 0x00b1, 0x00c3, 0x00d8, 0x00f9, 0x010b, 0x0129, 0x0144,
	0x0159, 0x016e, 0x017d, 0x0192, 0x01a4, 0x01bc, 0x01d1, 0x01e0,
	0x01f2, 0x020a, 0x0216, 0x021f, 0x0244, 0x0253, 0x0265, 0x0274,
	0x0289, 0x029b, 0x02ad, 0x02bc, 0x02cb, 0x02dd, 0x02fe, 0x0319,
	0x0334, 0x0343, 0x0355, 0x0367, 0x0376, 0x0388, 0x0397, 0x03a6,
	0x03d7, 0x03e6, 0x040b, 0x0429, 0x0444, 0x0459, 0x0471, 0x0480,
	0x0492, 0x04a4, 0x04bd, 0x04de, 0x04f9, 0x0517, 0x0532, 0x0544,
	// Entry 40 - 7F
	0x0571, 0x0592, 0x05b3, 0x05c5, 0x05e7, 0x0602, 0x060b, 0x0632,
	0x0647, 0x0665, 0x0677, 0x068c, 0x06a7, 0x06b6, 0x06cb, 0x06ef,
	0x06fe, 0x0725, 0x0731, 0x0743, 0x075b, 0x076d, 0x0785, 0x079a,
	0x07a6, 0x07b8, 0x07cd, 0x07dc, 0x0809, 0x081b, 0x083c, 0x0854,
	0x085d, 0x087e, 0x08a3, 0x08be, 0x08d6, 0x08f1, 0x0900, 0x0924,
	0x0942, 0x095d, 0x096f, 0x097e, 0x0993, 0x09a2, 0x09b1, 0x09dc,
	0x09ee, 0x0a09, 0x0a12, 0x0a4f, 0x0a86, 0x0ab1, 0x0ac3, 0x0ade,
	0x0af6, 0x0b0e, 0x0b1d, 0x0b32, 0x0b44, 0x0b5c, 0x0b68, 0x0b77,
	// Entry 80 - BF
	0x0b89, 0x0ba1, 0x0bb6, 0x0bcb, 0x0bdd, 0x0bf5, 0x0bfe, 0x0c2b,
	0x0c40, 0x0c64, 0x0c76, 0x0caa, 0x0cbc, 0x0cce, 0x0ce3, 0x0d01,
	0x0d19, 0x0d25, 0x0d37, 0x0d4f, 0x0d67, 0x0d7c, 0x0d9b, 0x0dad,
	0x0dbf, 0x0dda, 0x0de9, 0x0dfb, 0x0e0a, 0x0e13, 0x0e31, 0x0e4c,
	0x0e61, 0x0e76, 0x0e88, 0x0e97, 0x0ea6, 0x0ec4, 0x0ed3, 0x0ef1,
	0x0f00, 0x0f18, 0x0f2a, 0x0f48, 0x0f5d, 0x0f72, 0x0f81, 0x0f8d,
	0x0fa5, 0x0fb7, 0x0fcc, 0x0fd8, 0x0fe4, 0x1002, 0x1011, 0x1026,
	0x1035, 0x1035, 0x1050, 0x105c, 0x1068, 0x1089, 0x1089, 0x1098,
	// Entry C0 - FF
	0x1098, 0x10ba, 0x10e2, 0x10f7, 0x110c, 0x111e, 0x111e, 0x1133,
	0x1133, 0x1133, 0x114b, 0x114b, 0x114b, 0x1154, 0x1154, 0x116f,
	0x116f, 0x1184, 0x1196, 0x11ae, 0x11ae, 0x11ba, 0x11ba, 0x11ba,
	0x11ba, 0x11c6, 0x11d8, 0x11d8, 0x11e4, 0x11e4, 0x11e4, 0x1209,
	0x121e, 0x122d, 0x1239, 0x1239, 0x1239, 0x124e, 0x124e, 0x124e,
	0x125d, 0x125d, 0x126c, 0x126c, 0x1284, 0x1296, 0x1296, 0x12a5,
	0x12a5, 0x12b7, 0x12cc, 0x12cc, 0x12de, 0x12f9, 0x1305, 0x1314,
	0x1329, 0x1335, 0x1341, 0x1363, 0x1372, 0x138d, 0x139f, 0x13b4,
	// Entry 100 - 13F
	0x13d6, 0x13e5, 0x13e5, 0x1416, 0x145a, 0x1478, 0x148a, 0x14a5,
	0x14b4, 0x14cf, 0x14e4, 0x14f9, 0x1508, 0x151a, 0x1529, 0x155d,
	0x155d, 0x1572, 0x1588, 0x159b, 0x15aa, 0x15bc, 0x15cb, 0x15d7,
	0x15d7, 0x1602, 0x1614, 0x1629, 0x1648, 0x1648, 0x165a, 0x165a,
	0x166f, 0x1687, 0x1687, 0x168d, 0x168d, 0x16a9, 0x16ce, 0x16ce,
	0x1714, 0x173c, 0x175d, 0x1763, 0x1775, 0x1778, 0x1787, 0x1796,
	0x1796, 0x179f, 0x17bd, 0x17bd, 0x17ef, 0x182a, 0x182a, 0x183c,
	0x185a, 0x1866, 0x1878, 0x189d, 0x18bf, 0x18bf, 0x18bf, 0x18cb,
	// Entry 140 - 17F
	0x18e3, 0x18f2, 0x18f5, 0x1916, 0x1916, 0x193d, 0x1952, 0x1964,
	0x198f, 0x19a1, 0x19ad, 0x19b9, 0x19cb, 0x19da, 0x19ec, 0x19ec,
	0x19ec, 0x19fe, 0x1a10, 0x1a22, 0x1a44, 0x1a60, 0x1a60, 0x1a82,
	0x1a97, 0x1aa6, 0x1ab5, 0x1ac7, 0x1ad3, 0x1af7, 0x1af7, 0x1b0c,
	0x1b24, 0x1b4e, 0x1b4e, 0x1b5a, 0x1b5a, 0x1b66, 0x1b7b, 0x1b9a,
	0x1b9a, 0x1b9a, 0x1ba6, 0x1bbe, 0x1bdc, 0x1bfb, 0x1c13, 0x1c2b,
	0x1c46, 0x1c6b, 0x1c6b, 0x1c6b, 0x1c89, 0x1c98, 0x1cb0, 0x1cc5,
	0x1cd1, 0x1ce0, 0x1cf5, 0x1d07, 0x1d19, 0x1d2b, 0x1d3d, 0x1d58,
	// Entry 180 - 1BF
	0x1d58, 0x1d58, 0x1d58, 0x1d6a, 0x1d6a, 0x1d7c, 0x1d88, 0x1da4,
	0x1da4, 0x1dc6, 0x1ddb, 0x1ded, 0x1dfc, 0x1e08, 0x1e1a, 0x1e1a,
	0x1e1a, 0x1e32, 0x1e32, 0x1e44, 0x1e56, 0x1e71, 0x1e95, 0x1ea4,
	0x1ea4, 0x1eb3, 0x1ece, 0x1ee0, 0x1eec, 0x1f07, 0x1f23, 0x1f4b,
	0x1f57, 0x1f6f, 0x1f99, 0x1fab, 0x1fc0, 0x1fd2, 0x1fdb, 0x1fdb,
	0x1ff0, 0x200f, 0x201e, 0x2039, 0x2054, 0x2054, 0x2054, 0x2069,
	0x208a, 0x208d, 0x20b1, 0x20bd, 0x20e5, 0x20fd, 0x210f, 0x2124,
	0x2124, 0x213c, 0x215d, 0x216c, 0x218e, 0x218e, 0x219d, 0x21d1,
	// Entry 1C0 - 1FF
	0x21e3, 0x2211, 0x223b, 0x2262, 0x2274, 0x2286, 0x2292, 0x22b7,
	0x22d8, 0x22f0, 0x230e, 0x2335, 0x2356, 0x2356, 0x237e, 0x237e,
	0x237e, 0x23a6, 0x23a6, 0x23c4, 0x23c4, 0x23c4, 0x23e8, 0x2406,
	0x243a, 0x2449, 0x2449, 0x2464, 0x2479, 0x2497, 0x2497, 0x2497,
	0x24a6, 0x24b8, 0x24b8, 0x24b8, 0x24b8, 0x24d6, 0x24e8, 0x250c,
	0x2518, 0x2546, 0x255b, 0x256a, 0x2582, 0x2582, 0x25a0, 0x25b2,
	0x25d0, 0x25df, 0x25df, 0x2607, 0x2607, 0x2613, 0x2613, 0x2628,
	0x2659, 0x267e, 0x267e, 0x2696, 0x269f, 0x269f, 0x26b1, 0x26b1,
	// Entry 200 - 23F
	0x26b1, 0x26e8, 0x2701, 0x271d, 0x273f, 0x2757, 0x2772, 0x279a,
	0x27a9, 0x27b5, 0x27b5, 0x27c7, 0x27d3, 0x27eb, 0x2806, 0x282b,
	0x2843, 0x2843, 0x2843, 0x2858, 0x2864, 0x2876, 0x2885, 0x289a,
	0x28a3, 0x28b8, 0x28b8, 0x28d0, 0x28eb, 0x28eb, 0x2900, 0x2928,
	0x2941, 0x2941, 0x2953, 0x2953, 0x296e, 0x296e, 0x2986, 0x2998,
	0x29b3, 0x29d1, 0x2a18, 0x2a2d, 0x2a45, 0x2a60, 0x2a69, 0x2a72,
	0x2a72, 0x2a72, 0x2a72, 0x2a72, 0x2a81, 0x2a81, 0x2a93, 0x2aab,
	0x2ac3, 0x2ad5, 0x2ae7, 0x2b08, 0x2b17, 0x2b2c, 0x2b2c, 0x2b38,
	// Entry 240 - 27F
	0x2b47, 0x2b5f, 0x2b7a, 0x2b8f, 0x2b8f, 0x2bad, 0x2bc2, 0x2bde,
	0x2bde, 0x2bf0, 0x2c31, 0x2c3d, 0x2c87, 0x2c93, 0x2cc2, 0x2cc2,
	0x2cf9, 0x2d25, 0x2d59, 0x2d84, 0x2dac, 0x2dd7, 0x2e21, 0x2e55,
	0x2e92, 0x2e92, 0x2eba, 0x2ed6, 0x2ef5, 0x2f0a, 0x2f3e, 0x2f6c,
	0x2f84, 0x2fb8, 0x2fe3, 0x3005, 0x3030,
} // Size: 1250 bytes

const caLangStr string = "" + // Size: 4583 bytes
	"àfarabkhazavèsticafrikaansàkanamhàricaragonèsàrabassamèsàvaraimaraazerba" +
	"idjanèsbaixkirbielorúsbúlgarbislamabambarabengalítibetàbretóbosniàcatalà" +
	"txetxèchamorrocorscreetxeceslau eclesiàstictxuvaixgal·lèsdanèsalemanydiv" +
	"ehidzongkaewegrecanglèsesperantoespanyolestoniàbascpersafulfinèsfijiàfer" +
	"oèsfrancèsfrisó occidentalirlandèsgaèlic escocèsgallecguaranígujaratiman" +
	"xhaussahebreuhindihiri motucroathaitiàhongarèsarmenihererointerlinguaind" +
	"onesiinterlingueigboyi sichuaninupiakidoislandèsitaliàinuktitutjaponèsja" +
	"vanèsgeorgiàkongokikuiukuanyamakazakhgrenlandèskhmerkannadacoreàkanurica" +
	"ixmirikurdkomicòrnickirguísllatíluxemburguèsgandalimburguèslingalalaosià" +
	"lituàluba katangaletómalgaixmarshallèsmaorimacedonimalaiàlammongolmarath" +
	"imalaimaltèsbirmànauruàndebele septentrionalnepalèsndonganeerlandèsnorue" +
	"c nynorsknoruec bokmålndebele meridionalnavahonyanjaoccitàojibwaoromoori" +
	"yaossetapanjabipalipolonèspaixtuportuguèsquítxuaretoromànicrundiromanèsr" +
	"usruandèssànscritsardsindhisami septentrionalsangosingalèseslovaceslovès" +
	"amoàshonasomalialbanèsserbiswazisotho meridionalsundanèssuecsuahilitàmil" +
	"telugutadjiktailandèstigrinyaturcmansetswanatongalèsturctsongatàtartahit" +
	"iàuigurucraïnèsurdúuzbekvendavietnamitavolapükvalówòlofxosajiddischiorub" +
	"azhuangxinèszuluatjehacoliadangmeadiguéafrihiliaghemainuaccadialabamaale" +
	"utaalbanès gegaltaic meridionalanglès anticangikaarameuaraucàaraonaarapa" +
	"hoarauacàrab egipciparellengua de signes americanaasturiàawadhibalutxiba" +
	"linèsbavarèsbasabamumghomalabejabembabenabafutbadagabalutxi occidentalbh" +
	"ojpuribicolbinikomblackfootbrajbrahuibodoakooseburiatbuguisekibilinmedum" +
	"bacaddocaribcayugaatsamcebuàchigatxibtxatxagataichuukmaripidgin chinookc" +
	"hoctawchipewyancherokeexeiennekurd soranicoptetàtar de Crimeafrancès cri" +
	"oll de les Seychellescaixubidakotadarguàtaitadelawareslavidogribdinkazar" +
	"madogribaix sòrabdoualaneerlandès mitjàdiolajuladazagaembuefikemiliàegip" +
	"ci anticekajukelamitaanglès mitjàewondoextremenyfangfilipífonfrancès mit" +
	"jàfrancès anticfrisó septentrionalfrisó orientalfriülàgagagaúsxinès gang" +
	"ayogbayagueezgilbertèsgilakialt alemany mitjàalt alemany anticconcani de" +
	" Goagondigorontalogòticgrebogrec anticalemany suíswayúgusígwichinhaidaxi" +
	"nès hakkahawaiàhindi de Fijihiligainonhititahmongalt sòrabxinès xianghup" +
	"aibanibibioilocàingúixcrioll anglès de Jamaicalojbanngombamachamejudeope" +
	"rsajudeoàrabkarakalpakcabilenckatxinjjukambakawikabardíkanembutyapmakond" +
	"ecrioll capverdiàkenyangkorokaingàkhasikhotanèskoyra chiinikakokalenjink" +
	"imbundukomi-permiacconcanikosraeàkpellekaratxaikriocareliàkurukhshambala" +
	"bafiacologniankúmikkutenailadílangipanjabi occidentallambalesguiàlígurla" +
	"kotallombardmongoloziluri septentrionalluba-lulualuisenyolundaluomizoluy" +
	"iaxinès clàssiclazmadurèsmafamagahimaithilimakassarmandingamassaimabamor" +
	"dovià moksamandarmendemerumauriciàgaèlic irlandès mitjàmakhuwa-mettometa" +
	"’micmacminangkabaumanxúmanipurímohawkmorémari occidentalmundangllengüe" +
	"s vàriescreekmirandèsmarwarimyenemordovià erzamazanderanixinès min del s" +
	"udnapolitànamabaix alemanynewariniasniueàbissiongiemboonnogainòrdic anti" +
	"cnovialn’Kosotho septentrionalnuernewari clàssicnyamwesinyankolenyoronze" +
	"maosageturc otomàpangasipahlavipampangapapiamentopalauàpicardpidgin de N" +
	"igèriaalemany pennsilvaniàpersa anticalemany palatífenicipiemontèspòntic" +
	"ponapeàprussiàprovençal anticquitxérajasthanirapanuirarotongàromanyèsrom" +
	"boromaníaromanèsrwosandaweiacutarameu samaritàsamburusasaksantalingambay" +
	"sangusiciliàescocèssasserèskurd meridionalsenecasenaselkupsonghai orient" +
	"alirlandès antictaixelhitxanàrab txadiàsidamosami meridionalsami lulesam" +
	"i d’Inarisami skoltsoninkesogdiàsrananserersahosukumasusúsumericomoriàsi" +
	"ríac clàssicsiríacsilesiàtemnetesoterenatetuntigretivtokelauèstsakhurkli" +
	"ngoniàtlingittalixamazictongatok pisintarokotsimshiàtat meridionaltumbuk" +
	"atuvaluàtasawaqtuviniàamazic del Marroc centraludmurtugaríticumbunduarre" +
	"lvaivènetvepseflamenc occidentalvòticvunjowalserametowaraywashowarlpirix" +
	"inès wucalmucmingreliàsogayaoyapeàyangbenyembacantonèszapotecasímbols Bl" +
	"isszelandèszenagaamazic estàndard marroquízunisense contingut lingüístic" +
	"zazaàrab estàndard modernalemany austríacalt alemany suísanglès australi" +
	"àanglès canadencanglès britànicanglès americàespanyol hispanoamericàesp" +
	"anyol europeuespanyol de Mèxicfrancès canadencfrancès suísbaix saxóflame" +
	"ncportuguès del Brasilportuguès de Portugalmoldauserbocroatsuahili del C" +
	"ongoxinès simplificatxinès tradicional"

var caLangIdx = []uint16{ // 613 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x000b, 0x0013, 0x001c, 0x0021, 0x0029, 0x0032,
	0x0037, 0x003f, 0x0044, 0x004a, 0x0058, 0x005f, 0x0068, 0x006f,
	0x0076, 0x007d, 0x0085, 0x008c, 0x0092, 0x0099, 0x00a0, 0x00a7,
	0x00af, 0x00b3, 0x00b7, 0x00bb, 0x00cd, 0x00d4, 0x00dd, 0x00e3,
	0x00ea, 0x00f0, 0x00f7, 0x00fa, 0x00fe, 0x0105, 0x010e, 0x0116,
	0x011e, 0x0122, 0x0127, 0x012a, 0x0130, 0x0136, 0x013d, 0x0145,
	0x0156, 0x015f, 0x016f, 0x0175, 0x017d, 0x0185, 0x0189, 0x018f,
	0x0195, 0x019a, 0x01a3, 0x01a8, 0x01af, 0x01b8, 0x01be, 0x01c4,
	// Entry 40 - 7F
	0x01cf, 0x01d7, 0x01e2, 0x01e6, 0x01f0, 0x01f7, 0x01fa, 0x0203,
	0x020a, 0x0213, 0x021b, 0x0223, 0x022b, 0x0230, 0x0236, 0x023e,
	0x0244, 0x024f, 0x0254, 0x025b, 0x0261, 0x0267, 0x026f, 0x0273,
	0x0277, 0x027e, 0x0286, 0x028c, 0x0299, 0x029e, 0x02a9, 0x02b0,
	0x02b7, 0x02bd, 0x02c9, 0x02ce, 0x02d5, 0x02e0, 0x02e5, 0x02ed,
	0x02f7, 0x02fd, 0x0304, 0x0309, 0x0310, 0x0316, 0x031d, 0x0332,
	0x033a, 0x0340, 0x034b, 0x0359, 0x0367, 0x0379, 0x037f, 0x0385,
	0x038c, 0x0392, 0x0397, 0x039c, 0x03a2, 0x03a9, 0x03ad, 0x03b5,
	// Entry 80 - BF
	0x03bb, 0x03c5, 0x03cd, 0x03d9, 0x03de, 0x03e6, 0x03e9, 0x03f1,
	0x03fa, 0x03fe, 0x0404, 0x0416, 0x041b, 0x0424, 0x042b, 0x0432,
	0x0438, 0x043d, 0x0443, 0x044b, 0x0450, 0x0455, 0x0465, 0x046e,
	0x0472, 0x0479, 0x047f, 0x0485, 0x048b, 0x0495, 0x049d, 0x04a4,
	0x04ac, 0x04b5, 0x04b9, 0x04bf, 0x04c5, 0x04cd, 0x04d2, 0x04dc,
	0x04e1, 0x04e6, 0x04eb, 0x04f5, 0x04fd, 0x0502, 0x0508, 0x050c,
	0x0514, 0x051a, 0x0520, 0x0526, 0x052a, 0x052f, 0x0534, 0x053b,
	0x0542, 0x0542, 0x054a, 0x054f, 0x0553, 0x0559, 0x0560, 0x0566,
	// Entry C0 - FF
	0x0572, 0x0583, 0x0590, 0x0596, 0x059c, 0x05a3, 0x05a9, 0x05b0,
	0x05b0, 0x05b0, 0x05b6, 0x05b6, 0x05c2, 0x05c6, 0x05e1, 0x05e9,
	0x05e9, 0x05ef, 0x05f6, 0x05fe, 0x0606, 0x060a, 0x060f, 0x060f,
	0x0616, 0x061a, 0x061f, 0x061f, 0x0623, 0x0628, 0x062e, 0x0640,
	0x0648, 0x064d, 0x0651, 0x0651, 0x0654, 0x065d, 0x065d, 0x065d,
	0x0661, 0x0667, 0x066b, 0x0671, 0x0677, 0x067c, 0x0680, 0x0685,
	0x068c, 0x0691, 0x0696, 0x069c, 0x06a1, 0x06a7, 0x06ac, 0x06b3,
	0x06bb, 0x06c0, 0x06c4, 0x06d2, 0x06d9, 0x06e2, 0x06ea, 0x06f1,
	// Entry 100 - 13F
	0x06fc, 0x0701, 0x0701, 0x0711, 0x0732, 0x0739, 0x073f, 0x0746,
	0x074b, 0x0753, 0x0758, 0x075e, 0x0763, 0x0768, 0x076d, 0x0778,
	0x0778, 0x077e, 0x0790, 0x0795, 0x0799, 0x079f, 0x07a3, 0x07a7,
	0x07ae, 0x07ba, 0x07c0, 0x07c7, 0x07d5, 0x07d5, 0x07db, 0x07e4,
	0x07e8, 0x07ef, 0x07ef, 0x07f2, 0x07f2, 0x0801, 0x080f, 0x080f,
	0x0823, 0x0832, 0x083a, 0x083c, 0x0843, 0x084d, 0x0851, 0x0856,
	0x0856, 0x085b, 0x0865, 0x086b, 0x087d, 0x088e, 0x089c, 0x08a1,
	0x08aa, 0x08b0, 0x08b5, 0x08bf, 0x08cc, 0x08d1, 0x08d1, 0x08d6,
	// Entry 140 - 17F
	0x08dd, 0x08e2, 0x08ee, 0x08f5, 0x0902, 0x090c, 0x0912, 0x0917,
	0x0921, 0x092d, 0x0931, 0x0935, 0x093b, 0x0941, 0x0948, 0x0948,
	0x0961, 0x0967, 0x096d, 0x0974, 0x097e, 0x0988, 0x0988, 0x0992,
	0x099a, 0x09a0, 0x09a3, 0x09a8, 0x09ac, 0x09b4, 0x09bb, 0x09bf,
	0x09c6, 0x09d7, 0x09de, 0x09e2, 0x09e9, 0x09ee, 0x09f7, 0x0a03,
	0x0a03, 0x0a03, 0x0a07, 0x0a0f, 0x0a17, 0x0a23, 0x0a2a, 0x0a32,
	0x0a38, 0x0a40, 0x0a44, 0x0a44, 0x0a4c, 0x0a52, 0x0a5a, 0x0a5f,
	0x0a68, 0x0a6e, 0x0a75, 0x0a7a, 0x0a7f, 0x0a91, 0x0a96, 0x0a9e,
	// Entry 180 - 1BF
	0x0a9e, 0x0aa4, 0x0aa4, 0x0aaa, 0x0ab2, 0x0ab7, 0x0abb, 0x0acd,
	0x0acd, 0x0ad7, 0x0adf, 0x0ae4, 0x0ae7, 0x0aeb, 0x0af0, 0x0aff,
	0x0b02, 0x0b0a, 0x0b0e, 0x0b14, 0x0b1c, 0x0b24, 0x0b2c, 0x0b32,
	0x0b36, 0x0b45, 0x0b4b, 0x0b50, 0x0b54, 0x0b5d, 0x0b75, 0x0b82,
	0x0b89, 0x0b8f, 0x0b9a, 0x0ba0, 0x0ba9, 0x0baf, 0x0bb4, 0x0bc3,
	0x0bca, 0x0bdb, 0x0be0, 0x0be9, 0x0bf0, 0x0bf0, 0x0bf5, 0x0c03,
	0x0c0e, 0x0c20, 0x0c29, 0x0c2d, 0x0c39, 0x0c3f, 0x0c43, 0x0c49,
	0x0c49, 0x0c4f, 0x0c58, 0x0c5d, 0x0c6a, 0x0c70, 0x0c76, 0x0c89,
	// Entry 1C0 - 1FF
	0x0c8d, 0x0c9c, 0x0ca4, 0x0cac, 0x0cb1, 0x0cb6, 0x0cbb, 0x0cc6,
	0x0ccd, 0x0cd4, 0x0cdc, 0x0ce6, 0x0ced, 0x0cf3, 0x0d05, 0x0d1a,
	0x0d1a, 0x0d25, 0x0d34, 0x0d3a, 0x0d44, 0x0d4b, 0x0d53, 0x0d5b,
	0x0d6b, 0x0d72, 0x0d72, 0x0d7c, 0x0d83, 0x0d8d, 0x0d96, 0x0d96,
	0x0d9b, 0x0da2, 0x0da2, 0x0da2, 0x0da2, 0x0dab, 0x0dae, 0x0db5,
	0x0dba, 0x0dca, 0x0dd1, 0x0dd6, 0x0ddd, 0x0ddd, 0x0de4, 0x0de9,
	0x0df1, 0x0df9, 0x0e02, 0x0e11, 0x0e17, 0x0e1b, 0x0e1b, 0x0e21,
	0x0e31, 0x0e40, 0x0e40, 0x0e49, 0x0e4c, 0x0e59, 0x0e5f, 0x0e5f,
	// Entry 200 - 23F
	0x0e5f, 0x0e6e, 0x0e77, 0x0e85, 0x0e8f, 0x0e96, 0x0e9d, 0x0ea3,
	0x0ea8, 0x0eac, 0x0eac, 0x0eb2, 0x0eb7, 0x0ebd, 0x0ec5, 0x0ed5,
	0x0edc, 0x0ee4, 0x0ee4, 0x0ee9, 0x0eed, 0x0ef3, 0x0ef8, 0x0efd,
	0x0f00, 0x0f0a, 0x0f11, 0x0f1b, 0x0f22, 0x0f27, 0x0f2d, 0x0f32,
	0x0f3b, 0x0f3b, 0x0f41, 0x0f41, 0x0f4a, 0x0f58, 0x0f5f, 0x0f67,
	0x0f6e, 0x0f76, 0x0f8f, 0x0f95, 0x0f9e, 0x0fa5, 0x0faa, 0x0fad,
	0x0fb3, 0x0fb8, 0x0fca, 0x0fca, 0x0fd0, 0x0fd0, 0x0fd5, 0x0fdb,
	0x0fe0, 0x0fe5, 0x0fea, 0x0ff2, 0x0ffb, 0x1001, 0x100b, 0x100f,
	// Entry 240 - 27F
	0x1012, 0x1018, 0x101f, 0x1024, 0x1024, 0x102d, 0x1035, 0x1043,
	0x104c, 0x1052, 0x106d, 0x1071, 0x108d, 0x1091, 0x10a8, 0x10a8,
	0x10b9, 0x10ca, 0x10dc, 0x10ec, 0x10fd, 0x110d, 0x1125, 0x1135,
	0x1147, 0x1147, 0x1158, 0x1166, 0x1170, 0x1177, 0x118c, 0x11a2,
	0x11a8, 0x11b2, 0x11c3, 0x11d5, 0x11e7,
} // Size: 1250 bytes

const csLangStr string = "" + // Size: 7397 bytes
	"afarštinaabcházštinaavestánštinaafrikánštinaakanštinaamharštinaaragonšti" +
	"naarabštinaásámštinaavarštinaajmarštinaázerbájdžánštinabaškirštinaběloru" +
	"štinabulharštinabislamštinabambarštinabengálštinatibetštinabretonštinab" +
	"osenštinakatalánštinačečenštinačamorokorsičtinakríjštinačeštinastaroslov" +
	"ěnštinačuvaštinavelštinadánštinaněmčinamaledivštinadzongkäeweštinařečti" +
	"naangličtinaesperantošpanělštinaestonštinabaskičtinaperštinafulbštinafin" +
	"štinafidžijštinafaerštinafrancouzštinafríština (západní)irštinaskotská " +
	"gaelštinagalicijštinaguaranštinagudžarátštinamanštinahauštinahebrejština" +
	"hindštinahiri motuchorvatštinahaitštinamaďarštinaarménštinahererštinaint" +
	"erlinguaindonéštinainterlingueigboštinaiština (sečuánská)inupiakštinaido" +
	"islandštinaitalštinainuktitutštinajaponštinajavánštinagruzínštinakonžšti" +
	"nakikujštinakuaňamštinakazaštinagrónštinakhmérštinakannadštinakorejština" +
	"kanurikašmírštinakurdštinakomijštinakornštinakyrgyzštinalatinalucemburšt" +
	"inagandštinalimburštinalingalštinalaoštinalitevštinalubu-katanžštinaloty" +
	"štinamalgaštinamaršálštinamaorštinamakedonštinamalajálamštinamongolštin" +
	"amaráthštinamalajštinamaltštinabarmštinanaurštinandebele (Zimbabwe)nepál" +
	"štinandondštinanizozemštinanorština (nynorsk)norština (bokmål)ndebele (" +
	"Jižní Afrika)navažštinaňandžštinaokcitánštinaodžibvejštinaoromštinaurijš" +
	"tinaosetštinapaňdžábštinapálípolštinapaštštinaportugalštinakečuánštinaré" +
	"torománštinakirundštinarumunštinaruštinakiňarwandštinasanskrtsardštinasi" +
	"ndhštinasámština (severní)sangštinasinhálštinaslovenštinaslovinštinasamo" +
	"jštinašonštinasomálštinaalbánštinasrbštinasiswatštinasotština (jižní)sun" +
	"dštinašvédštinasvahilštinatamilštinatelugštinatádžičtinathajštinatigrini" +
	"jštinaturkmenštinasetswanštinatongánštinaturečtinatsongatatarštinatahitš" +
	"tinaujgurštinaukrajinštinaurdštinauzbečtinavendavietnamštinavolapükvalon" +
	"štinawolofštinaxhoštinajidišjorubštinačuangštinačínštinazuluštinaacehšt" +
	"inaakolštinaadangmeadygejštinaarabština (tuniská)afrihiliaghemainštinaak" +
	"kadštinaalabamštinaaleutštinaalbánština (Gheg)altajština (jižní)staroang" +
	"ličtinaangikaaramejštinamapudungunaraonštinaarapažštinaarabština (alžírs" +
	"ká)arawacké jazykyarabština (marocká)arabština (egyptská)asuznaková řeč " +
	"(americká)asturštinakotavaawadhštinabalúčštinabalijštinabavorštinabasaba" +
	"munbatak tobaghomalabedžabembštinabatavštinabenabafutbadagštinabalúčštin" +
	"a (západní)bhojpurštinabikolštinabinibandžarštinakomsiksikabišnuprijskom" +
	"anipurštinabachtijárštinabradžštinabrahujštinabodoštinaakooseburjatština" +
	"bugištinabulublinštinamedumbacaddokaribštinakajugštinaatsamcebuánštinaki" +
	"gačibčačagatajštinačukštinamarijštinačinuk pidžinčoktštinačipevajštinače" +
	"rokézštinačejenštinakurdština (sorání)koptštinakapiznonštinaturečtina (k" +
	"rymská)kreolština (seychelská)kašubštinadakotštinadargštinataitadelawarš" +
	"tinaslejvština (athabaský jazyk)dogribdinkštinazarmštinadogarštinadolnol" +
	"užická srbštinakadazandusunštinadualštinaholandština (středověká)jola-fo" +
	"nyidjuladazagaembuefikštinaemilijštinaegyptština staráekajukelamitštinaa" +
	"ngličtina (středověká)jupikština (středoaljašská)ewondoextremadurštinafa" +
	"ngfilipínštinafinština (tornedalská)fonštinafrancouzština (kajunská)fran" +
	"couzština (středověká)francouzština (stará)franko-provensálštinafríština" +
	" (severní)fríština (východní)furlanštinagaštinagagauzštinačínština (dial" +
	"ekty Gan)gayogbajadaríjština (zoroastrijská)geezkiribatštinagilačtinahor" +
	"noněmčina (středověká)hornoněmčina (stará)konkánština (Goa)góndštinagoro" +
	"ntalogótštinagrebostarořečtinaněmčina (Švýcarsko)wayúuštinafrafragusiigw" +
	"ichʼinhaidštinačínština (dialekty Hakka)havajštinahindština (Fidži)hilig" +
	"ajnonštinachetitštinahmongštinahornolužická srbštinačínština (dialekty X" +
	"iang)hupaibanštinaibibioilokánštinainguštinaingrijštinajamajská kreolšti" +
	"nalojbanngombamašamejudeoperštinajudeoarabštinajutštinakarakalpačtinakab" +
	"ylštinakačijštinajjukambštinakawikabardinštinakanembutyapmakondekapverdš" +
	"tinakenyangkorokaingangkhásíchotánštinakoyra chiinichovarštinazazakština" +
	"kakokalendžinkimbundštinakomi-permjačtinakonkánštinakosrajštinakpellekar" +
	"ačajevo-balkarštinakriokinaraj-akarelštinakuruchštinašambalabafiakolínšt" +
	"inakumyčtinakutenajštinaladinštinalangilahndštinalambštinalezginštinalin" +
	"gua franca novaligurštinalivonštinalakotštinalombardštinamongštinalozšti" +
	"nalúrština (severní)latgalštinaluba-luluaštinaluiseňolundštinaluoštinami" +
	"zoštinaluhjačínština (klasická)lazštinamadurštinamafamagahijštinamaithil" +
	"ištinamakasarštinamandingštinamasajštinamabamokšanštinamandarmendemeruma" +
	"uricijská kreolštinairština (středověká)makhuwa-meettometa’micmacminangk" +
	"abaumandžuštinamanipurštinamohawkštinamosimarijština (západní)mundangslo" +
	"žené (víceřádkové) jazykykríkštinamirandštinamárvárštinamentavajštinamy" +
	"eneerzjanštinamázandaránštinačínština (dialekty Minnan)neapolštinanamašt" +
	"inadolnoněmčinanévárštinaniasniueštinaao (jazyky Nágálandu)kwasiongiembo" +
	"onnogajštinanorština historickánovialn’kosotština (severní)nuerštinanewa" +
	"rština (klasická)ňamwežštinaňankolštinaňorštinanzimaosageturečtina (osma" +
	"nská)pangasinanštinapahlavštinapapangaupapiamentopalauštinapicardštinani" +
	"gerijský pidžinněmčina (pensylvánská)němčina (plautdietsch)staroperština" +
	"falčtinaféničtinapiemonštinapontštinapohnpeištinapruštinaprovensálštinak" +
	"ičékečuánština (chimborazo)rádžastánštinarapanujštinararotongánštinaroma" +
	"ňolštinarífštinaromboromštinarotumanštinarusínštinarovianštinaarumunšti" +
	"narwasandawštinajakutštinasamarštinasamburusasakštinasantálštinasaurášte" +
	"rštinangambaysangoštinasicilštinaskotštinasassarštinakurdština (jižní)se" +
	"necasenaserištinaselkupštinakoyraboro senniirština (stará)žemaitštinataš" +
	"elhitšanštinaarabština (čadská)sidamoněmčina (slezská)selajarštinasámšti" +
	"na (jižní)sámština (lulejská)sámšt