// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudwatchevents

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon CloudWatch Events.
//
// Deletes the specified rule.
//
// You must remove all targets from a rule using RemoveTargets before you can
// delete the rule.
//
// When you delete a rule, incoming events might continue to match to the deleted
// rule. Please allow a short period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRule
func (c *CloudWatchEvents) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRule = "DescribeRule"

// DescribeRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeRuleRequest method.
//    req, resp := client.DescribeRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRuleRequest(input *DescribeRuleInput) (req *request.Request, output *DescribeRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRuleInput{}
	}

	output = &DescribeRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRule API operation for Amazon CloudWatch Events.
//
// Describes the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DescribeRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRule
func (c *CloudWatchEvents) DescribeRule(input *DescribeRuleInput) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	return out, req.Send()
}

// DescribeRuleWithContext is the same as DescribeRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DescribeRuleWithContext(ctx aws.Context, input *DescribeRuleInput, opts ...request.Option) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableRule = "DisableRule"

// DisableRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisableRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableRuleRequest method.
//    req, resp := client.DisableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRuleRequest(input *DisableRuleInput) (req *request.Request, output *DisableRuleOutput) {
	op := &request.Operation{
		Name:       opDisableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRuleInput{}
	}

	output = &DisableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableRule API operation for Amazon CloudWatch Events.
//
// Disables the specified rule. A disabled rule won't match any events, and
// won't self-trigger if it has a schedule expression.
//
// When you disable a rule, incoming events might continue to match to the disabled
// rule. Please allow a short period of time for changes to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation DisableRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRule
func (c *CloudWatchEvents) DisableRule(input *DisableRuleInput) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	return out, req.Send()
}

// DisableRuleWithContext is the same as DisableRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) DisableRuleWithContext(ctx aws.Context, input *DisableRuleInput, opts ...request.Option) (*DisableRuleOutput, error) {
	req, out := c.DisableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableRule = "EnableRule"

// EnableRuleRequest generates a "aws/request.Request" representing the
// client's request for the EnableRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableRuleRequest method.
//    req, resp := client.EnableRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRuleRequest(input *EnableRuleInput) (req *request.Request, output *EnableRuleOutput) {
	op := &request.Operation{
		Name:       opEnableRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRuleInput{}
	}

	output = &EnableRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableRule API operation for Amazon CloudWatch Events.
//
// Enables the specified rule. If the rule does not exist, the operation fails.
//
// When you enable a rule, incoming events might not immediately start matching
// to a newly enabled rule. Please allow a short period of time for changes
// to take effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation EnableRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRule
func (c *CloudWatchEvents) EnableRule(input *EnableRuleInput) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	return out, req.Send()
}

// EnableRuleWithContext is the same as EnableRule with the addition of
// the ability to pass a context and additional request options.
//
// See EnableRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) EnableRuleWithContext(ctx aws.Context, input *EnableRuleInput, opts ...request.Option) (*EnableRuleOutput, error) {
	req, out := c.EnableRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleNamesByTarget = "ListRuleNamesByTarget"

// ListRuleNamesByTargetRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleNamesByTarget operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRuleNamesByTarget for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRuleNamesByTarget method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRuleNamesByTargetRequest method.
//    req, resp := client.ListRuleNamesByTargetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTargetRequest(input *ListRuleNamesByTargetInput) (req *request.Request, output *ListRuleNamesByTargetOutput) {
	op := &request.Operation{
		Name:       opListRuleNamesByTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleNamesByTargetInput{}
	}

	output = &ListRuleNamesByTargetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleNamesByTarget API operation for Amazon CloudWatch Events.
//
// Lists the rules for the specified target. You can see which of the rules
// in Amazon CloudWatch Events can invoke a specific target in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRuleNamesByTarget for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTarget
func (c *CloudWatchEvents) ListRuleNamesByTarget(input *ListRuleNamesByTargetInput) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	return out, req.Send()
}

// ListRuleNamesByTargetWithContext is the same as ListRuleNamesByTarget with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleNamesByTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListRuleNamesByTargetWithContext(ctx aws.Context, input *ListRuleNamesByTargetInput, opts ...request.Option) (*ListRuleNamesByTargetOutput, error) {
	req, out := c.ListRuleNamesByTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRules for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRules method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon CloudWatch Events.
//
// Lists your Amazon CloudWatch Events rules. You can either list all the rules
// or you can provide a prefix to match to the rule names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRules
func (c *CloudWatchEvents) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTargetsByRule = "ListTargetsByRule"

// ListTargetsByRuleRequest generates a "aws/request.Request" representing the
// client's request for the ListTargetsByRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTargetsByRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTargetsByRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTargetsByRuleRequest method.
//    req, resp := client.ListTargetsByRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRuleRequest(input *ListTargetsByRuleInput) (req *request.Request, output *ListTargetsByRuleOutput) {
	op := &request.Operation{
		Name:       opListTargetsByRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTargetsByRuleInput{}
	}

	output = &ListTargetsByRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTargetsByRule API operation for Amazon CloudWatch Events.
//
// Lists the targets assigned to the specified rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation ListTargetsByRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRule
func (c *CloudWatchEvents) ListTargetsByRule(input *ListTargetsByRuleInput) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	return out, req.Send()
}

// ListTargetsByRuleWithContext is the same as ListTargetsByRule with the addition of
// the ability to pass a context and additional request options.
//
// See ListTargetsByRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) ListTargetsByRuleWithContext(ctx aws.Context, input *ListTargetsByRuleInput, opts ...request.Option) (*ListTargetsByRuleOutput, error) {
	req, out := c.ListTargetsByRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEvents = "PutEvents"

// PutEventsRequest generates a "aws/request.Request" representing the
// client's request for the PutEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutEventsRequest method.
//    req, resp := client.PutEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEventsRequest(input *PutEventsInput) (req *request.Request, output *PutEventsOutput) {
	op := &request.Operation{
		Name:       opPutEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventsInput{}
	}

	output = &PutEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEvents API operation for Amazon CloudWatch Events.
//
// Sends custom events to Amazon CloudWatch Events so that they can be matched
// to rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEvents
func (c *CloudWatchEvents) PutEvents(input *PutEventsInput) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	return out, req.Send()
}

// PutEventsWithContext is the same as PutEvents with the addition of
// the ability to pass a context and additional request options.
//
// See PutEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutEventsWithContext(ctx aws.Context, input *PutEventsInput, opts ...request.Option) (*PutEventsOutput, error) {
	req, out := c.PutEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRule = "PutRule"

// PutRuleRequest generates a "aws/request.Request" representing the
// client's request for the PutRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRuleRequest method.
//    req, resp := client.PutRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRuleRequest(input *PutRuleInput) (req *request.Request, output *PutRuleOutput) {
	op := &request.Operation{
		Name:       opPutRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRuleInput{}
	}

	output = &PutRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRule API operation for Amazon CloudWatch Events.
//
// Creates or updates the specified rule. Rules are enabled by default, or based
// on value of the state. You can disable a rule using DisableRule.
//
// When you create or update a rule, incoming events might not immediately start
// matching to new or updated rules. Please allow a short period of time for
// changes to take effect.
//
// A rule must contain at least an EventPattern or ScheduleExpression. Rules
// with EventPatterns are triggered when a matching event is observed. Rules
// with ScheduleExpressions self-trigger based on the given schedule. A rule
// can have both an EventPattern and a ScheduleExpression, in which case the
// rule triggers on matching events as well as on a schedule.
//
// Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidEventPatternException "InvalidEventPatternException"
//   The event pattern is not valid.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You tried to create more rules or add more targets to a rule than is allowed.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRule
func (c *CloudWatchEvents) PutRule(input *PutRuleInput) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	return out, req.Send()
}

// PutRuleWithContext is the same as PutRule with the addition of
// the ability to pass a context and additional request options.
//
// See PutRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutRuleWithContext(ctx aws.Context, input *PutRuleInput, opts ...request.Option) (*PutRuleOutput, error) {
	req, out := c.PutRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutTargets = "PutTargets"

// PutTargetsRequest generates a "aws/request.Request" representing the
// client's request for the PutTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutTargetsRequest method.
//    req, resp := client.PutTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargetsRequest(input *PutTargetsInput) (req *request.Request, output *PutTargetsOutput) {
	op := &request.Operation{
		Name:       opPutTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutTargetsInput{}
	}

	output = &PutTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutTargets API operation for Amazon CloudWatch Events.
//
// Adds the specified targets to the specified rule, or updates the targets
// if they are already associated with the rule.
//
// Targets are the resources that are invoked when a rule is triggered. Example
// targets include EC2 instances, AWS Lambda functions, Amazon Kinesis streams,
// Amazon ECS tasks, AWS Step Functions state machines, and built-in targets.
// Note that creating rules with built-in targets is supported only in the AWS
// Management Console.
//
// For some target types, PutTargets provides target-specific parameters. If
// the target is an Amazon Kinesis stream, you can optionally specify which
// shard the event goes to by using the KinesisParameters argument. To invoke
// a command on multiple EC2 instances with one rule, you can use the RunCommandParameters
// field.
//
// To be able to make API calls against the resources that you own, Amazon CloudWatch
// Events needs the appropriate permissions. For AWS Lambda and Amazon SNS resources,
// CloudWatch Events relies on resource-based policies. For EC2 instances, Amazon
// Kinesis streams, and AWS Step Functions state machines, CloudWatch Events
// relies on IAM roles that you specify in the RoleARN argument in PutTarget.
// For more information, see Authentication and Access Control (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/auth-and-access-control-cwe.html)
// in the Amazon CloudWatch Events User Guide.
//
// Input, InputPath and InputTransformer are mutually exclusive and optional
// parameters of a target. When a rule is triggered due to a matched event:
//
//    * If none of the following arguments are specified for a target, then
//    the entire event is passed to the target in JSON form (unless the target
//    is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from
//    the event is passed to the target).
//
//    * If Input is specified in the form of valid JSON, then the matched event
//    is overridden with this constant.
//
//    * If InputPath is specified in the form of JSONPath (for example, $.detail),
//    then only the part of the event specified in the path is passed to the
//    target (for example, only the detail part of the event is passed).
//
//    * If InputTransformer is specified, then one or more specified JSONPaths
//    are extracted from the event and used as values in a template that you
//    specify as the input to the target.
//
// When you specify Input, InputPath, or InputTransformer, you must use JSON
// dot notation, not bracket notation.
//
// When you add targets to a rule and the associated rule triggers soon after,
// new or updated targets might not be immediately invoked. Please allow a short
// period of time for changes to take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation PutTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   You tried to create more rules or add more targets to a rule than is allowed.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargets
func (c *CloudWatchEvents) PutTargets(input *PutTargetsInput) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	return out, req.Send()
}

// PutTargetsWithContext is the same as PutTargets with the addition of
// the ability to pass a context and additional request options.
//
// See PutTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) PutTargetsWithContext(ctx aws.Context, input *PutTargetsInput, opts ...request.Option) (*PutTargetsOutput, error) {
	req, out := c.PutTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTargets = "RemoveTargets"

// RemoveTargetsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTargets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTargets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTargets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTargetsRequest method.
//    req, resp := client.RemoveTargetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargetsRequest(input *RemoveTargetsInput) (req *request.Request, output *RemoveTargetsOutput) {
	op := &request.Operation{
		Name:       opRemoveTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTargetsInput{}
	}

	output = &RemoveTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTargets API operation for Amazon CloudWatch Events.
//
// Removes the specified targets from the specified rule. When the rule is triggered,
// those targets are no longer be invoked.
//
// When you remove a target, when the associated rule triggers, removed targets
// might continue to be invoked. Please allow a short period of time for changes
// to take effect.
//
// This action can partially fail if too many requests are made at the same
// time. If that happens, FailedEntryCount is non-zero in the response and each
// entry in FailedEntries provides the ID of the failed target and the error
// code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation RemoveTargets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The rule does not exist.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   There is concurrent modification on a rule or target.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargets
func (c *CloudWatchEvents) RemoveTargets(input *RemoveTargetsInput) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	return out, req.Send()
}

// RemoveTargetsWithContext is the same as RemoveTargets with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) RemoveTargetsWithContext(ctx aws.Context, input *RemoveTargetsInput, opts ...request.Option) (*RemoveTargetsOutput, error) {
	req, out := c.RemoveTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestEventPattern = "TestEventPattern"

// TestEventPatternRequest generates a "aws/request.Request" representing the
// client's request for the TestEventPattern operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestEventPattern for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestEventPattern method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestEventPatternRequest method.
//    req, resp := client.TestEventPatternRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPatternRequest(input *TestEventPatternInput) (req *request.Request, output *TestEventPatternOutput) {
	op := &request.Operation{
		Name:       opTestEventPattern,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestEventPatternInput{}
	}

	output = &TestEventPatternOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestEventPattern API operation for Amazon CloudWatch Events.
//
// Tests whether the specified event pattern matches the provided event.
//
// Most services in AWS treat : or / as the same character in Amazon Resource
// Names (ARNs). However, CloudWatch Events uses an exact match in event patterns
// and rules. Be sure to use the correct ARN characters when creating event
// patterns so that they match the ARN syntax in the event you want to match.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Events's
// API operation TestEventPattern for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidEventPatternException "InvalidEventPatternException"
//   The event pattern is not valid.
//
//   * ErrCodeInternalException "InternalException"
//   This exception occurs due to unexpected causes.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPattern
func (c *CloudWatchEvents) TestEventPattern(input *TestEventPatternInput) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	return out, req.Send()
}

// TestEventPatternWithContext is the same as TestEventPattern with the addition of
// the ability to pass a context and additional request options.
//
// See TestEventPattern for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudWatchEvents) TestEventPatternWithContext(ctx aws.Context, input *TestEventPatternInput, opts ...request.Option) (*TestEventPatternOutput, error) {
	req, out := c.TestEventPatternRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRuleRequest
type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRuleInput) SetName(v string) *DeleteRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DeleteRuleOutput
type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRuleRequest
type DescribeRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeRuleInput) SetName(v string) *DescribeRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DescribeRuleResponse
type DescribeRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Specifies whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s DescribeRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRuleOutput) SetArn(v string) *DescribeRuleOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRuleOutput) SetDescription(v string) *DescribeRuleOutput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *DescribeRuleOutput) SetEventPattern(v string) *DescribeRuleOutput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRuleOutput) SetName(v string) *DescribeRuleOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeRuleOutput) SetRoleArn(v string) *DescribeRuleOutput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *DescribeRuleOutput) SetScheduleExpression(v string) *DescribeRuleOutput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeRuleOutput) SetState(v string) *DescribeRuleOutput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRuleRequest
type DisableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DisableRuleInput) SetName(v string) *DisableRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/DisableRuleOutput
type DisableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRuleOutput) GoString() string {
	return s.String()
}

// The custom parameters to be used when the target is an Amazon ECS cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EcsParameters
type EcsParameters struct {
	_ struct{} `type:"structure"`

	// The number of tasks to create based on the TaskDefinition. The default is
	// one.
	TaskCount *int64 `min:"1" type:"integer"`

	// The ARN of the task definition to use if the event target is an Amazon ECS
	// cluster.
	//
	// TaskDefinitionArn is a required field
	TaskDefinitionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EcsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EcsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsParameters"}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TaskCount", 1))
	}
	if s.TaskDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinitionArn"))
	}
	if s.TaskDefinitionArn != nil && len(*s.TaskDefinitionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskDefinitionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTaskCount sets the TaskCount field's value.
func (s *EcsParameters) SetTaskCount(v int64) *EcsParameters {
	s.TaskCount = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *EcsParameters) SetTaskDefinitionArn(v string) *EcsParameters {
	s.TaskDefinitionArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRuleRequest
type EnableRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *EnableRuleInput) SetName(v string) *EnableRuleInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/EnableRuleOutput
type EnableRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRuleOutput) GoString() string {
	return s.String()
}

// Contains the parameters needed for you to provide custom input to a target
// based on one or more pieces of data extracted from the event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/InputTransformer
type InputTransformer struct {
	_ struct{} `type:"structure"`

	// Map of JSON paths to be extracted from the event. These are key-value pairs,
	// where each value is a JSON path. You must use JSON dot notation, not bracket
	// notation.
	InputPathsMap map[string]*string `type:"map"`

	// Input template where you can use the values of the keys from InputPathsMap
	// to customize the data sent to the target.
	//
	// InputTemplate is a required field
	InputTemplate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputTransformer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputTransformer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputTransformer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputTransformer"}
	if s.InputTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("InputTemplate"))
	}
	if s.InputTemplate != nil && len(*s.InputTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputPathsMap sets the InputPathsMap field's value.
func (s *InputTransformer) SetInputPathsMap(v map[string]*string) *InputTransformer {
	s.InputPathsMap = v
	return s
}

// SetInputTemplate sets the InputTemplate field's value.
func (s *InputTransformer) SetInputTemplate(v string) *InputTransformer {
	s.InputTemplate = &v
	return s
}

// This object enables you to specify a JSON path to extract from the event
// and use as the partition key for the Amazon Kinesis stream, so that you can
// control the shard to which the event goes. If you do not include this parameter,
// the default is to use the eventId as the partition key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/KinesisParameters
type KinesisParameters struct {
	_ struct{} `type:"structure"`

	// The JSON path to be extracted from the event and used as the partition key.
	// For more information, see Amazon Kinesis Streams Key Concepts (http://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key)
	// in the Amazon Kinesis Streams Developer Guide.
	//
	// PartitionKeyPath is a required field
	PartitionKeyPath *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisParameters"}
	if s.PartitionKeyPath == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKeyPath"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKeyPath sets the PartitionKeyPath field's value.
func (s *KinesisParameters) SetPartitionKeyPath(v string) *KinesisParameters {
	s.PartitionKeyPath = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTargetRequest
type ListRuleNamesByTargetInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target resource.
	//
	// TargetArn is a required field
	TargetArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRuleNamesByTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleNamesByTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleNamesByTargetInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.TargetArn != nil && len(*s.TargetArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRuleNamesByTargetInput) SetLimit(v int64) *ListRuleNamesByTargetInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetInput) SetNextToken(v string) *ListRuleNamesByTargetInput {
	s.NextToken = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ListRuleNamesByTargetInput) SetTargetArn(v string) *ListRuleNamesByTargetInput {
	s.TargetArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRuleNamesByTargetResponse
type ListRuleNamesByTargetOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The names of the rules that can invoke the given target.
	RuleNames []*string `type:"list"`
}

// String returns the string representation
func (s ListRuleNamesByTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleNamesByTargetOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRuleNamesByTargetOutput) SetNextToken(v string) *ListRuleNamesByTargetOutput {
	s.NextToken = &v
	return s
}

// SetRuleNames sets the RuleNames field's value.
func (s *ListRuleNamesByTargetOutput) SetRuleNames(v []*string) *ListRuleNamesByTargetOutput {
	s.RuleNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRulesRequest
type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The prefix matching the rule name.
	NamePrefix *string `min:"1" type:"string"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRulesInput) SetLimit(v int64) *ListRulesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListRulesInput) SetNamePrefix(v string) *ListRulesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListRulesResponse
type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The rules that match the specified criteria.
	Rules []*Rule `type:"list"`
}

// String returns the string representation
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*Rule) *ListRulesOutput {
	s.Rules = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRuleRequest
type ListTargetsByRuleInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	Limit *int64 `min:"1" type:"integer"`

	// The token returned by a previous call to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTargetsByRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTargetsByRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTargetsByRuleInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTargetsByRuleInput) SetLimit(v int64) *ListTargetsByRuleInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleInput) SetNextToken(v string) *ListTargetsByRuleInput {
	s.NextToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *ListTargetsByRuleInput) SetRule(v string) *ListTargetsByRuleInput {
	s.Rule = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/ListTargetsByRuleResponse
type ListTargetsByRuleOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether there are additional results to retrieve. If there are
	// no more results, the value is null.
	NextToken *string `min:"1" type:"string"`

	// The targets assigned to the rule.
	Targets []*Target `min:"1" type:"list"`
}

// String returns the string representation
func (s ListTargetsByRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTargetsByRuleOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTargetsByRuleOutput) SetNextToken(v string) *ListTargetsByRuleOutput {
	s.NextToken = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *ListTargetsByRuleOutput) SetTargets(v []*Target) *ListTargetsByRuleOutput {
	s.Targets = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsRequest
type PutEventsInput struct {
	_ struct{} `type:"structure"`

	// The entry that defines an event in your system. You can specify several parameters
	// for the entry such as the source and type of the event, resources associated
	// with the event, and so on.
	//
	// Entries is a required field
	Entries []*PutEventsRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsInput"}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntries sets the Entries field's value.
func (s *PutEventsInput) SetEntries(v []*PutEventsRequestEntry) *PutEventsInput {
	s.Entries = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsResponse
type PutEventsOutput struct {
	_ struct{} `type:"structure"`

	// The successfully and unsuccessfully ingested events results. If the ingestion
	// was successful, the entry has the event ID in it. Otherwise, you can use
	// the error code and error message to identify the problem with the entry.
	Entries []*PutEventsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *PutEventsOutput) SetEntries(v []*PutEventsResultEntry) *PutEventsOutput {
	s.Entries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutEventsOutput) SetFailedEntryCount(v int64) *PutEventsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents an event to be submitted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsRequestEntry
type PutEventsRequestEntry struct {
	_ struct{} `type:"structure"`

	// In the JSON sense, an object containing fields, which may also contain nested
	// subobjects. No constraints are imposed on its contents.
	Detail *string `type:"string"`

	// Free-form string used to decide what fields to expect in the event detail.
	DetailType *string `type:"string"`

	// AWS resources, identified by Amazon Resource Name (ARN), which the event
	// primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The source of the event.
	Source *string `type:"string"`

	// The timestamp of the event, per RFC3339 (https://www.rfc-editor.org/rfc/rfc3339.txt).
	// If no timestamp is provided, the timestamp of the PutEvents call is used.
	Time *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PutEventsRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsRequestEntry) GoString() string {
	return s.String()
}

// SetDetail sets the Detail field's value.
func (s *PutEventsRequestEntry) SetDetail(v string) *PutEventsRequestEntry {
	s.Detail = &v
	return s
}

// SetDetailType sets the DetailType field's value.
func (s *PutEventsRequestEntry) SetDetailType(v string) *PutEventsRequestEntry {
	s.DetailType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PutEventsRequestEntry) SetResources(v []*string) *PutEventsRequestEntry {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PutEventsRequestEntry) SetSource(v string) *PutEventsRequestEntry {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PutEventsRequestEntry) SetTime(v time.Time) *PutEventsRequestEntry {
	s.Time = &v
	return s
}

// Represents an event that failed to be submitted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutEventsResultEntry
type PutEventsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the event submission failed.
	ErrorCode *string `type:"string"`

	// The error message that explains why the event submission failed.
	ErrorMessage *string `type:"string"`

	// The ID of the event.
	EventId *string `type:"string"`
}

// String returns the string representation
func (s PutEventsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutEventsResultEntry) SetErrorCode(v string) *PutEventsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutEventsResultEntry) SetErrorMessage(v string) *PutEventsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *PutEventsResultEntry) SetEventId(v string) *PutEventsResultEntry {
	s.EventId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRuleRequest
type PutRuleInput struct {
	_ struct{} `type:"structure"`

	// A description of the rule.
	Description *string `type:"string"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule that you are creating or updating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role associated with the rule.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// Indicates whether the rule is enabled or disabled.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s PutRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRuleInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutRuleInput) SetDescription(v string) *PutRuleInput {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *PutRuleInput) SetEventPattern(v string) *PutRuleInput {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutRuleInput) SetName(v string) *PutRuleInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PutRuleInput) SetRoleArn(v string) *PutRuleInput {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *PutRuleInput) SetScheduleExpression(v string) *PutRuleInput {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *PutRuleInput) SetState(v string) *PutRuleInput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutRuleResponse
type PutRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	RuleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRuleOutput) GoString() string {
	return s.String()
}

// SetRuleArn sets the RuleArn field's value.
func (s *PutRuleOutput) SetRuleArn(v string) *PutRuleOutput {
	s.RuleArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsRequest
type PutTargetsInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`

	// The targets to update or add to the rule.
	//
	// Targets is a required field
	Targets []*Target `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s PutTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutTargetsInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *PutTargetsInput) SetRule(v string) *PutTargetsInput {
	s.Rule = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *PutTargetsInput) SetTargets(v []*Target) *PutTargetsInput {
	s.Targets = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsResponse
type PutTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*PutTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s PutTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *PutTargetsOutput) SetFailedEntries(v []*PutTargetsResultEntry) *PutTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *PutTargetsOutput) SetFailedEntryCount(v int64) *PutTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be added to a rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/PutTargetsResultEntry
type PutTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target addition failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target addition failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutTargetsResultEntry) SetErrorCode(v string) *PutTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutTargetsResultEntry) SetErrorMessage(v string) *PutTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *PutTargetsResultEntry) SetTargetId(v string) *PutTargetsResultEntry {
	s.TargetId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsRequest
type RemoveTargetsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the targets to remove from the rule.
	//
	// Ids is a required field
	Ids []*string `min:"1" type:"list" required:"true"`

	// The name of the rule.
	//
	// Rule is a required field
	Rule *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTargetsInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil && len(*s.Rule) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rule", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *RemoveTargetsInput) SetIds(v []*string) *RemoveTargetsInput {
	s.Ids = v
	return s
}

// SetRule sets the Rule field's value.
func (s *RemoveTargetsInput) SetRule(v string) *RemoveTargetsInput {
	s.Rule = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsResponse
type RemoveTargetsOutput struct {
	_ struct{} `type:"structure"`

	// The failed target entries.
	FailedEntries []*RemoveTargetsResultEntry `type:"list"`

	// The number of failed entries.
	FailedEntryCount *int64 `type:"integer"`
}

// String returns the string representation
func (s RemoveTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsOutput) GoString() string {
	return s.String()
}

// SetFailedEntries sets the FailedEntries field's value.
func (s *RemoveTargetsOutput) SetFailedEntries(v []*RemoveTargetsResultEntry) *RemoveTargetsOutput {
	s.FailedEntries = v
	return s
}

// SetFailedEntryCount sets the FailedEntryCount field's value.
func (s *RemoveTargetsOutput) SetFailedEntryCount(v int64) *RemoveTargetsOutput {
	s.FailedEntryCount = &v
	return s
}

// Represents a target that failed to be removed from a rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RemoveTargetsResultEntry
type RemoveTargetsResultEntry struct {
	_ struct{} `type:"structure"`

	// The error code that indicates why the target removal failed. If the value
	// is ConcurrentModificationException, too many requests were made at the same
	// time.
	ErrorCode *string `type:"string"`

	// The error message that explains why the target removal failed.
	ErrorMessage *string `type:"string"`

	// The ID of the target.
	TargetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveTargetsResultEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTargetsResultEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *RemoveTargetsResultEntry) SetErrorCode(v string) *RemoveTargetsResultEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *RemoveTargetsResultEntry) SetErrorMessage(v string) *RemoveTargetsResultEntry {
	s.ErrorMessage = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *RemoveTargetsResultEntry) SetTargetId(v string) *RemoveTargetsResultEntry {
	s.TargetId = &v
	return s
}

// Contains information about a rule in Amazon CloudWatch Events.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string `min:"1" type:"string"`

	// The description of the rule.
	Description *string `type:"string"`

	// The event pattern of the rule. For more information, see Events and Event
	// Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	EventPattern *string `type:"string"`

	// The name of the rule.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role that is used for target invocation.
	RoleArn *string `min:"1" type:"string"`

	// The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)".
	ScheduleExpression *string `type:"string"`

	// The state of the rule.
	State *string `type:"string" enum:"RuleState"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Rule) SetArn(v string) *Rule {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Rule) SetDescription(v string) *Rule {
	s.Description = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *Rule) SetEventPattern(v string) *Rule {
	s.EventPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Rule) SetRoleArn(v string) *Rule {
	s.RoleArn = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Rule) SetScheduleExpression(v string) *Rule {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *Rule) SetState(v string) *Rule {
	s.State = &v
	return s
}

// This parameter contains the criteria (either InstanceIds or a tag) used to
// specify which EC2 instances are to be sent the command.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RunCommandParameters
type RunCommandParameters struct {
	_ struct{} `type:"structure"`

	// Currently, we support including only one RunCommandTarget block, which specifies
	// either an array of InstanceIds or a tag.
	//
	// RunCommandTargets is a required field
	RunCommandTargets []*RunCommandTarget `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RunCommandParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandParameters"}
	if s.RunCommandTargets == nil {
		invalidParams.Add(request.NewErrParamRequired("RunCommandTargets"))
	}
	if s.RunCommandTargets != nil && len(s.RunCommandTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunCommandTargets", 1))
	}
	if s.RunCommandTargets != nil {
		for i, v := range s.RunCommandTargets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RunCommandTargets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRunCommandTargets sets the RunCommandTargets field's value.
func (s *RunCommandParameters) SetRunCommandTargets(v []*RunCommandTarget) *RunCommandParameters {
	s.RunCommandTargets = v
	return s
}

// Information about the EC2 instances that are to be sent the command, specified
// as key-value pairs. Each RunCommandTarget block can include only one key,
// but this key may specify multiple values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/RunCommandTarget
type RunCommandTarget struct {
	_ struct{} `type:"structure"`

	// Can be either tag:tag-key or InstanceIds.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// If Key is tag:tag-key, Values is a list of tag values. If Key is InstanceIds,
	// Values is a list of Amazon EC2 instance IDs.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RunCommandTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandTarget"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *RunCommandTarget) SetKey(v string) *RunCommandTarget {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *RunCommandTarget) SetValues(v []*string) *RunCommandTarget {
	s.Values = v
	return s
}

// Targets are the resources to be invoked when a rule is triggered. Target
// types include EC2 instances, AWS Lambda functions, Amazon Kinesis streams,
// Amazon ECS tasks, AWS Step Functions state machines, Run Command, and built-in
// targets.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/Target
type Target struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// Contains the Amazon ECS task definition and task count to be used, if the
	// event target is an Amazon ECS task. For more information about Amazon ECS
	// tasks, see Task Definitions  (http://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html)
	// in the Amazon EC2 Container Service Developer Guide.
	EcsParameters *EcsParameters `type:"structure"`

	// The ID of the target.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Valid JSON text passed to the target. In this case, nothing from the event
	// itself is passed to the target. You must use JSON dot notation, not bracket
	// notation. For more information, see The JavaScript Object Notation (JSON)
	// Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	Input *string `type:"string"`

	// The value of the JSONPath that is used for extracting part of the matched
	// event when passing it to the target. You must use JSON dot notation, not
	// bracket notation. For more information about JSON paths, see JSONPath (http://goessner.net/articles/JsonPath/).
	InputPath *string `type:"string"`

	// Settings to enable you to provide custom input to a target based on certain
	// event data. You can extract one or more key-value pairs from the event and
	// then use that data to send customized input to the target.
	InputTransformer *InputTransformer `type:"structure"`

	// The custom parameter you can use to control shard assignment, when the target
	// is an Amazon Kinesis stream. If you do not include this parameter, the default
	// is to use the eventId as the partition key.
	KinesisParameters *KinesisParameters `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be used for this target
	// when the rule is triggered. If one rule triggers multiple targets, you can
	// use a different IAM role for each target.
	RoleArn *string `min:"1" type:"string"`

	// Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
	RunCommandParameters *RunCommandParameters `type:"structure"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.EcsParameters != nil {
		if err := s.EcsParameters.Validate(); err != nil {
			invalidParams.AddNested("EcsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.InputTransformer != nil {
		if err := s.InputTransformer.Validate(); err != nil {
			invalidParams.AddNested("InputTransformer", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisParameters != nil {
		if err := s.KinesisParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RunCommandParameters != nil {
		if err := s.RunCommandParameters.Validate(); err != nil {
			invalidParams.AddNested("RunCommandParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Target) SetArn(v string) *Target {
	s.Arn = &v
	return s
}

// SetEcsParameters sets the EcsParameters field's value.
func (s *Target) SetEcsParameters(v *EcsParameters) *Target {
	s.EcsParameters = v
	return s
}

// SetId sets the Id field's value.
func (s *Target) SetId(v string) *Target {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *Target) SetInput(v string) *Target {
	s.Input = &v
	return s
}

// SetInputPath sets the InputPath field's value.
func (s *Target) SetInputPath(v string) *Target {
	s.InputPath = &v
	return s
}

// SetInputTransformer sets the InputTransformer field's value.
func (s *Target) SetInputTransformer(v *InputTransformer) *Target {
	s.InputTransformer = v
	return s
}

// SetKinesisParameters sets the KinesisParameters field's value.
func (s *Target) SetKinesisParameters(v *KinesisParameters) *Target {
	s.KinesisParameters = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Target) SetRoleArn(v string) *Target {
	s.RoleArn = &v
	return s
}

// SetRunCommandParameters sets the RunCommandParameters field's value.
func (s *Target) SetRunCommandParameters(v *RunCommandParameters) *Target {
	s.RunCommandParameters = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPatternRequest
type TestEventPatternInput struct {
	_ struct{} `type:"structure"`

	// The event, in JSON format, to test against the event pattern.
	//
	// Event is a required field
	Event *string `type:"string" required:"true"`

	// The event pattern. For more information, see Events and Event Patterns (http://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html)
	// in the Amazon CloudWatch Events User Guide.
	//
	// EventPattern is a required field
	EventPattern *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestEventPatternInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestEventPatternInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestEventPatternInput"}
	if s.Event == nil {
		invalidParams.Add(request.NewErrParamRequired("Event"))
	}
	if s.EventPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("EventPattern"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvent sets the Event field's value.
func (s *TestEventPatternInput) SetEvent(v string) *TestEventPatternInput {
	s.Event = &v
	return s
}

// SetEventPattern sets the EventPattern field's value.
func (s *TestEventPatternInput) SetEventPattern(v string) *TestEventPatternInput {
	s.EventPattern = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/events-2015-10-07/TestEventPatternResponse
type TestEventPatternOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the event matches the event pattern.
	Result *bool `type:"boolean"`
}

// String returns the string representation
func (s TestEventPatternOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestEventPatternOutput) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *TestEventPatternOutput) SetResult(v bool) *TestEventPatternOutput {
	s.Result = &v
	return s
}

const (
	// RuleStateEnabled is a RuleState enum value
	RuleStateEnabled = "ENABLED"

	// RuleStateDisabled is a RuleState enum value
	RuleStateDisabled = "DISABLED"
)
