// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetRepositories = "BatchGetRepositories"

// BatchGetRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetRepositories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchGetRepositories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchGetRepositories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchGetRepositoriesRequest method.
//    req, resp := client.BatchGetRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories
func (c *CodeCommit) BatchGetRepositoriesRequest(input *BatchGetRepositoriesInput) (req *request.Request, output *BatchGetRepositoriesOutput) {
	op := &request.Operation{
		Name:       opBatchGetRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetRepositoriesInput{}
	}

	output = &BatchGetRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetRepositories API operation for AWS CodeCommit.
//
// Returns information about one or more repositories.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation BatchGetRepositories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNamesRequiredException "RepositoryNamesRequiredException"
//   A repository names object is required but was not specified.
//
//   * ErrCodeMaximumRepositoryNamesExceededException "MaximumRepositoryNamesExceededException"
//   The maximum number of allowed repository names was exceeded. Currently, this
//   number is 25.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories
func (c *CodeCommit) BatchGetRepositories(input *BatchGetRepositoriesInput) (*BatchGetRepositoriesOutput, error) {
	req, out := c.BatchGetRepositoriesRequest(input)
	return out, req.Send()
}

// BatchGetRepositoriesWithContext is the same as BatchGetRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) BatchGetRepositoriesWithContext(ctx aws.Context, input *BatchGetRepositoriesInput, opts ...request.Option) (*BatchGetRepositoriesOutput, error) {
	req, out := c.BatchGetRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBranch = "CreateBranch"

// CreateBranchRequest generates a "aws/request.Request" representing the
// client's request for the CreateBranch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateBranch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateBranch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateBranchRequest method.
//    req, resp := client.CreateBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch
func (c *CodeCommit) CreateBranchRequest(input *CreateBranchInput) (req *request.Request, output *CreateBranchOutput) {
	op := &request.Operation{
		Name:       opCreateBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBranchInput{}
	}

	output = &CreateBranchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateBranch API operation for AWS CodeCommit.
//
// Creates a new branch in a repository and points the branch to a commit.
//
// Calling the create branch operation does not set a repository's default branch.
// To do this, call the update default branch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation CreateBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeBranchNameExistsException "BranchNameExistsException"
//   The specified branch name already exists.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified branch name is not valid.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch
func (c *CodeCommit) CreateBranch(input *CreateBranchInput) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	return out, req.Send()
}

// CreateBranchWithContext is the same as CreateBranch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) CreateBranchWithContext(ctx aws.Context, input *CreateBranchInput, opts ...request.Option) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRepository for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRepositoryRequest method.
//    req, resp := client.CreateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository
func (c *CodeCommit) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for AWS CodeCommit.
//
// Creates a new, empty repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation CreateRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameExistsException "RepositoryNameExistsException"
//   The specified repository name already exists.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryDescriptionException "InvalidRepositoryDescriptionException"
//   The specified repository description is not valid.
//
//   * ErrCodeRepositoryLimitExceededException "RepositoryLimitExceededException"
//   A repository resource limit was exceeded.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository
func (c *CodeCommit) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) CreateRepositoryWithContext(ctx aws.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRepository for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRepositoryRequest method.
//    req, resp := client.DeleteRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository
func (c *CodeCommit) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for AWS CodeCommit.
//
// Deletes a repository. If a specified repository was already deleted, a null
// repository ID will be returned.
//
// Deleting a repository also deletes all associated objects and metadata. After
// a repository is deleted, all future push calls to the deleted repository
// will fail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository
func (c *CodeCommit) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	return out, req.Send()
}

// DeleteRepositoryWithContext is the same as DeleteRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DeleteRepositoryWithContext(ctx aws.Context, input *DeleteRepositoryInput, opts ...request.Option) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlob = "GetBlob"

// GetBlobRequest generates a "aws/request.Request" representing the
// client's request for the GetBlob operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBlob for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBlob method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBlobRequest method.
//    req, resp := client.GetBlobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob
func (c *CodeCommit) GetBlobRequest(input *GetBlobInput) (req *request.Request, output *GetBlobOutput) {
	op := &request.Operation{
		Name:       opGetBlob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlobInput{}
	}

	output = &GetBlobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlob API operation for AWS CodeCommit.
//
// Returns the base-64 encoded content of an individual blob within a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetBlob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeBlobIdRequiredException "BlobIdRequiredException"
//   A blob ID is required but was not specified.
//
//   * ErrCodeInvalidBlobIdException "InvalidBlobIdException"
//   The specified blob is not valid.
//
//   * ErrCodeBlobIdDoesNotExistException "BlobIdDoesNotExistException"
//   The specified blob does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeFileTooLargeException "FileTooLargeException"
//   The specified file exceeds the file size limit for AWS CodeCommit. For more
//   information about limits in AWS CodeCommit, see AWS CodeCommit User Guide
//   (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob
func (c *CodeCommit) GetBlob(input *GetBlobInput) (*GetBlobOutput, error) {
	req, out := c.GetBlobRequest(input)
	return out, req.Send()
}

// GetBlobWithContext is the same as GetBlob with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetBlobWithContext(ctx aws.Context, input *GetBlobInput, opts ...request.Option) (*GetBlobOutput, error) {
	req, out := c.GetBlobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBranch = "GetBranch"

// GetBranchRequest generates a "aws/request.Request" representing the
// client's request for the GetBranch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBranch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBranch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBranchRequest method.
//    req, resp := client.GetBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch
func (c *CodeCommit) GetBranchRequest(input *GetBranchInput) (req *request.Request, output *GetBranchOutput) {
	op := &request.Operation{
		Name:       opGetBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBranchInput{}
	}

	output = &GetBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBranch API operation for AWS CodeCommit.
//
// Returns information about a repository branch, including its name and the
// last commit ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified branch name is not valid.
//
//   * ErrCodeBranchDoesNotExistException "BranchDoesNotExistException"
//   The specified branch does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch
func (c *CodeCommit) GetBranch(input *GetBranchInput) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	return out, req.Send()
}

// GetBranchWithContext is the same as GetBranch with the addition of
// the ability to pass a context and additional request options.
//
// See GetBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetBranchWithContext(ctx aws.Context, input *GetBranchInput, opts ...request.Option) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCommit = "GetCommit"

// GetCommitRequest generates a "aws/request.Request" representing the
// client's request for the GetCommit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCommit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCommit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCommitRequest method.
//    req, resp := client.GetCommitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit
func (c *CodeCommit) GetCommitRequest(input *GetCommitInput) (req *request.Request, output *GetCommitOutput) {
	op := &request.Operation{
		Name:       opGetCommit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommitInput{}
	}

	output = &GetCommitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommit API operation for AWS CodeCommit.
//
// Returns information about a commit, including commit message and committer
// information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetCommit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitIdDoesNotExistException "CommitIdDoesNotExistException"
//   The specified commit ID does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit
func (c *CodeCommit) GetCommit(input *GetCommitInput) (*GetCommitOutput, error) {
	req, out := c.GetCommitRequest(input)
	return out, req.Send()
}

// GetCommitWithContext is the same as GetCommit with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommitWithContext(ctx aws.Context, input *GetCommitInput, opts ...request.Option) (*GetCommitOutput, error) {
	req, out := c.GetCommitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDifferences = "GetDifferences"

// GetDifferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetDifferences operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDifferences for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDifferences method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDifferencesRequest method.
//    req, resp := client.GetDifferencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences
func (c *CodeCommit) GetDifferencesRequest(input *GetDifferencesInput) (req *request.Request, output *GetDifferencesOutput) {
	op := &request.Operation{
		Name:       opGetDifferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDifferencesInput{}
	}

	output = &GetDifferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDifferences API operation for AWS CodeCommit.
//
// Returns information about the differences in a valid commit specifier (such
// as a branch, tag, HEAD, commit ID or other fully qualified reference). Results
// can be limited to a specified path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetDifferences for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitRequiredException "CommitRequiredException"
//   A commit was not specified.
//
//   * ErrCodeInvalidCommitException "InvalidCommitException"
//   The specified commit is not valid.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidPathException "InvalidPathException"
//   The specified path is not valid.
//
//   * ErrCodePathDoesNotExistException "PathDoesNotExistException"
//   The specified path does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences
func (c *CodeCommit) GetDifferences(input *GetDifferencesInput) (*GetDifferencesOutput, error) {
	req, out := c.GetDifferencesRequest(input)
	return out, req.Send()
}

// GetDifferencesWithContext is the same as GetDifferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetDifferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetDifferencesWithContext(ctx aws.Context, input *GetDifferencesInput, opts ...request.Option) (*GetDifferencesOutput, error) {
	req, out := c.GetDifferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDifferencesPages iterates over the pages of a GetDifferences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDifferences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDifferences operation.
//    pageNum := 0
//    err := client.GetDifferencesPages(params,
//        func(page *GetDifferencesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) GetDifferencesPages(input *GetDifferencesInput, fn func(*GetDifferencesOutput, bool) bool) error {
	return c.GetDifferencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDifferencesPagesWithContext same as GetDifferencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetDifferencesPagesWithContext(ctx aws.Context, input *GetDifferencesInput, fn func(*GetDifferencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDifferencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDifferencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetDifferencesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetRepository = "GetRepository"

// GetRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the GetRepository operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRepository for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRepository method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRepositoryRequest method.
//    req, resp := client.GetRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository
func (c *CodeCommit) GetRepositoryRequest(input *GetRepositoryInput) (req *request.Request, output *GetRepositoryOutput) {
	op := &request.Operation{
		Name:       opGetRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryInput{}
	}

	output = &GetRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepository API operation for AWS CodeCommit.
//
// Returns information about a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository
func (c *CodeCommit) GetRepository(input *GetRepositoryInput) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	return out, req.Send()
}

// GetRepositoryWithContext is the same as GetRepository with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetRepositoryWithContext(ctx aws.Context, input *GetRepositoryInput, opts ...request.Option) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryTriggers = "GetRepositoryTriggers"

// GetRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryTriggers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRepositoryTriggers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRepositoryTriggers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRepositoryTriggersRequest method.
//    req, resp := client.GetRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers
func (c *CodeCommit) GetRepositoryTriggersRequest(input *GetRepositoryTriggersInput) (req *request.Request, output *GetRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryTriggersInput{}
	}

	output = &GetRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryTriggers API operation for AWS CodeCommit.
//
// Gets information about triggers configured for a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers
func (c *CodeCommit) GetRepositoryTriggers(input *GetRepositoryTriggersInput) (*GetRepositoryTriggersOutput, error) {
	req, out := c.GetRepositoryTriggersRequest(input)
	return out, req.Send()
}

// GetRepositoryTriggersWithContext is the same as GetRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetRepositoryTriggersWithContext(ctx aws.Context, input *GetRepositoryTriggersInput, opts ...request.Option) (*GetRepositoryTriggersOutput, error) {
	req, out := c.GetRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBranches = "ListBranches"

// ListBranchesRequest generates a "aws/request.Request" representing the
// client's request for the ListBranches operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListBranches for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListBranches method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListBranchesRequest method.
//    req, resp := client.ListBranchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches
func (c *CodeCommit) ListBranchesRequest(input *ListBranchesInput) (req *request.Request, output *ListBranchesOutput) {
	op := &request.Operation{
		Name:       opListBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	output = &ListBranchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBranches API operation for AWS CodeCommit.
//
// Gets information about one or more branches in a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation ListBranches for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches
func (c *CodeCommit) ListBranches(input *ListBranchesInput) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	return out, req.Send()
}

// ListBranchesWithContext is the same as ListBranches with the addition of
// the ability to pass a context and additional request options.
//
// See ListBranches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListBranchesWithContext(ctx aws.Context, input *ListBranchesInput, opts ...request.Option) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBranchesPages iterates over the pages of a ListBranches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBranches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBranches operation.
//    pageNum := 0
//    err := client.ListBranchesPages(params,
//        func(page *ListBranchesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) ListBranchesPages(input *ListBranchesInput, fn func(*ListBranchesOutput, bool) bool) error {
	return c.ListBranchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBranchesPagesWithContext same as ListBranchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListBranchesPagesWithContext(ctx aws.Context, input *ListBranchesInput, fn func(*ListBranchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBranchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBranchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListBranchesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRepositories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRepositories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRepositoriesRequest method.
//    req, resp := client.ListRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories
func (c *CodeCommit) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	output = &ListRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositories API operation for AWS CodeCommit.
//
// Gets information about one or more repositories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation ListRepositories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSortByException "InvalidSortByException"
//   The specified sort by value is not valid.
//
//   * ErrCodeInvalidOrderException "InvalidOrderException"
//   The specified sort order is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories
func (c *CodeCommit) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	return out, req.Send()
}

// ListRepositoriesWithContext is the same as ListRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListRepositoriesWithContext(ctx aws.Context, input *ListRepositoriesInput, opts ...request.Option) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoriesPages iterates over the pages of a ListRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRepositories operation.
//    pageNum := 0
//    err := client.ListRepositoriesPages(params,
//        func(page *ListRepositoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) ListRepositoriesPages(input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool) error {
	return c.ListRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoriesPagesWithContext same as ListRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListRepositoriesPagesWithContext(ctx aws.Context, input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRepositoriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutRepositoryTriggers = "PutRepositoryTriggers"

// PutRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the PutRepositoryTriggers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRepositoryTriggers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRepositoryTriggers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRepositoryTriggersRequest method.
//    req, resp := client.PutRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers
func (c *CodeCommit) PutRepositoryTriggersRequest(input *PutRepositoryTriggersInput) (req *request.Request, output *PutRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opPutRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRepositoryTriggersInput{}
	}

	output = &PutRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRepositoryTriggers API operation for AWS CodeCommit.
//
// Replaces all triggers for a repository. This can be used to create or delete
// triggers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PutRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryTriggersListRequiredException "RepositoryTriggersListRequiredException"
//   The list of triggers for the repository is required but was not specified.
//
//   * ErrCodeMaximumRepositoryTriggersExceededException "MaximumRepositoryTriggersExceededException"
//   The number of triggers allowed for the repository was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerNameException "InvalidRepositoryTriggerNameException"
//   The name of the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerDestinationArnException "InvalidRepositoryTriggerDestinationArnException"
//   The Amazon Resource Name (ARN) for the trigger is not valid for the specified
//   destination. The most common reason for this error is that the ARN does not
//   meet the requirements for the service type.
//
//   * ErrCodeInvalidRepositoryTriggerRegionException "InvalidRepositoryTriggerRegionException"
//   The region for the trigger target does not match the region for the repository.
//   Triggers must be created in the same region as the target for the trigger.
//
//   * ErrCodeInvalidRepositoryTriggerCustomDataException "InvalidRepositoryTriggerCustomDataException"
//   The custom data provided for the trigger is not valid.
//
//   * ErrCodeMaximumBranchesExceededException "MaximumBranchesExceededException"
//   The number of branches for the trigger was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerBranchNameException "InvalidRepositoryTriggerBranchNameException"
//   One or more branch names specified for the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerEventsException "InvalidRepositoryTriggerEventsException"
//   One or more events specified for the trigger is not valid. Check to make
//   sure that all events specified match the requirements for allowed events.
//
//   * ErrCodeRepositoryTriggerNameRequiredException "RepositoryTriggerNameRequiredException"
//   A name for the trigger is required but was not specified.
//
//   * ErrCodeRepositoryTriggerDestinationArnRequiredException "RepositoryTriggerDestinationArnRequiredException"
//   A destination ARN for the target service for the trigger is required but
//   was not specified.
//
//   * ErrCodeRepositoryTriggerBranchNameListRequiredException "RepositoryTriggerBranchNameListRequiredException"
//   At least one branch name is required but was not specified in the trigger
//   configuration.
//
//   * ErrCodeRepositoryTriggerEventsListRequiredException "RepositoryTriggerEventsListRequiredException"
//   At least one event for the trigger is required but was not specified.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers
func (c *CodeCommit) PutRepositoryTriggers(input *PutRepositoryTriggersInput) (*PutRepositoryTriggersOutput, error) {
	req, out := c.PutRepositoryTriggersRequest(input)
	return out, req.Send()
}

// PutRepositoryTriggersWithContext is the same as PutRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See PutRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PutRepositoryTriggersWithContext(ctx aws.Context, input *PutRepositoryTriggersInput, opts ...request.Option) (*PutRepositoryTriggersOutput, error) {
	req, out := c.PutRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestRepositoryTriggers = "TestRepositoryTriggers"

// TestRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the TestRepositoryTriggers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TestRepositoryTriggers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TestRepositoryTriggers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TestRepositoryTriggersRequest method.
//    req, resp := client.TestRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers
func (c *CodeCommit) TestRepositoryTriggersRequest(input *TestRepositoryTriggersInput) (req *request.Request, output *TestRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opTestRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestRepositoryTriggersInput{}
	}

	output = &TestRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestRepositoryTriggers API operation for AWS CodeCommit.
//
// Tests the functionality of repository triggers by sending information to
// the trigger target. If real data is available in the repository, the test
// will send data from the last commit. If no data is available, sample data
// will be generated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation TestRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryTriggersListRequiredException "RepositoryTriggersListRequiredException"
//   The list of triggers for the repository is required but was not specified.
//
//   * ErrCodeMaximumRepositoryTriggersExceededException "MaximumRepositoryTriggersExceededException"
//   The number of triggers allowed for the repository was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerNameException "InvalidRepositoryTriggerNameException"
//   The name of the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerDestinationArnException "InvalidRepositoryTriggerDestinationArnException"
//   The Amazon Resource Name (ARN) for the trigger is not valid for the specified
//   destination. The most common reason for this error is that the ARN does not
//   meet the requirements for the service type.
//
//   * ErrCodeInvalidRepositoryTriggerRegionException "InvalidRepositoryTriggerRegionException"
//   The region for the trigger target does not match the region for the repository.
//   Triggers must be created in the same region as the target for the trigger.
//
//   * ErrCodeInvalidRepositoryTriggerCustomDataException "InvalidRepositoryTriggerCustomDataException"
//   The custom data provided for the trigger is not valid.
//
//   * ErrCodeMaximumBranchesExceededException "MaximumBranchesExceededException"
//   The number of branches for the trigger was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerBranchNameException "InvalidRepositoryTriggerBranchNameException"
//   One or more branch names specified for the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerEventsException "InvalidRepositoryTriggerEventsException"
//   One or more events specified for the trigger is not valid. Check to make
//   sure that all events specified match the requirements for allowed events.
//
//   * ErrCodeRepositoryTriggerNameRequiredException "RepositoryTriggerNameRequiredException"
//   A name for the trigger is required but was not specified.
//
//   * ErrCodeRepositoryTriggerDestinationArnRequiredException "RepositoryTriggerDestinationArnRequiredException"
//   A destination ARN for the target service for the trigger is required but
//   was not specified.
//
//   * ErrCodeRepositoryTriggerBranchNameListRequiredException "RepositoryTriggerBranchNameListRequiredException"
//   At least one branch name is required but was not specified in the trigger
//   configuration.
//
//   * ErrCodeRepositoryTriggerEventsListRequiredException "RepositoryTriggerEventsListRequiredException"
//   At least one event for the trigger is required but was not specified.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers
func (c *CodeCommit) TestRepositoryTriggers(input *TestRepositoryTriggersInput) (*TestRepositoryTriggersOutput, error) {
	req, out := c.TestRepositoryTriggersRequest(input)
	return out, req.Send()
}

// TestRepositoryTriggersWithContext is the same as TestRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See TestRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) TestRepositoryTriggersWithContext(ctx aws.Context, input *TestRepositoryTriggersInput, opts ...request.Option) (*TestRepositoryTriggersOutput, error) {
	req, out := c.TestRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDefaultBranch = "UpdateDefaultBranch"

// UpdateDefaultBranchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDefaultBranch operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDefaultBranch for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDefaultBranch method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDefaultBranchRequest method.
//    req, resp := client.UpdateDefaultBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch
func (c *CodeCommit) UpdateDefaultBranchRequest(input *UpdateDefaultBranchInput) (req *request.Request, output *UpdateDefaultBranchOutput) {
	op := &request.Operation{
		Name:       opUpdateDefaultBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDefaultBranchInput{}
	}

	output = &UpdateDefaultBranchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDefaultBranch API operation for AWS CodeCommit.
//
// Sets or changes the default branch name for the specified repository.
//
// If you use this operation to change the default branch name to the current
// default branch name, a success message is returned even though the default
// branch did not change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateDefaultBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified branch name is not valid.
//
//   * ErrCodeBranchDoesNotExistException "BranchDoesNotExistException"
//   The specified branch does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch
func (c *CodeCommit) UpdateDefaultBranch(input *UpdateDefaultBranchInput) (*UpdateDefaultBranchOutput, error) {
	req, out := c.UpdateDefaultBranchRequest(input)
	return out, req.Send()
}

// UpdateDefaultBranchWithContext is the same as UpdateDefaultBranch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDefaultBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateDefaultBranchWithContext(ctx aws.Context, input *UpdateDefaultBranchInput, opts ...request.Option) (*UpdateDefaultBranchOutput, error) {
	req, out := c.UpdateDefaultBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepositoryDescription = "UpdateRepositoryDescription"

// UpdateRepositoryDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepositoryDescription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateRepositoryDescription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateRepositoryDescription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateRepositoryDescriptionRequest method.
//    req, resp := client.UpdateRepositoryDescriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription
func (c *CodeCommit) UpdateRepositoryDescriptionRequest(input *UpdateRepositoryDescriptionInput) (req *request.Request, output *UpdateRepositoryDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryDescriptionInput{}
	}

	output = &UpdateRepositoryDescriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRepositoryDescription API operation for AWS CodeCommit.
//
// Sets or changes the comment or description for a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateRepositoryDescription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryDescriptionException "InvalidRepositoryDescriptionException"
//   The specified repository description is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription
func (c *CodeCommit) UpdateRepositoryDescription(input *UpdateRepositoryDescriptionInput) (*UpdateRepositoryDescriptionOutput, error) {
	req, out := c.UpdateRepositoryDescriptionRequest(input)
	return out, req.Send()
}

// UpdateRepositoryDescriptionWithContext is the same as UpdateRepositoryDescription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepositoryDescription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateRepositoryDescriptionWithContext(ctx aws.Context, input *UpdateRepositoryDescriptionInput, opts ...request.Option) (*UpdateRepositoryDescriptionOutput, error) {
	req, out := c.UpdateRepositoryDescriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepositoryName = "UpdateRepositoryName"

// UpdateRepositoryNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepositoryName operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateRepositoryName for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateRepositoryName method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateRepositoryNameRequest method.
//    req, resp := client.UpdateRepositoryNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName
func (c *CodeCommit) UpdateRepositoryNameRequest(input *UpdateRepositoryNameInput) (req *request.Request, output *UpdateRepositoryNameOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryName,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryNameInput{}
	}

	output = &UpdateRepositoryNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRepositoryName API operation for AWS CodeCommit.
//
// Renames a repository. The repository name must be unique across the calling
// AWS account. In addition, repository names are limited to 100 alphanumeric,
// dash, and underscore characters, and cannot include certain characters. The
// suffix ".git" is prohibited. For a full description of the limits on repository
// names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateRepositoryName for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameExistsException "RepositoryNameExistsException"
//   The specified repository name already exists.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName
func (c *CodeCommit) UpdateRepositoryName(input *UpdateRepositoryNameInput) (*UpdateRepositoryNameOutput, error) {
	req, out := c.UpdateRepositoryNameRequest(input)
	return out, req.Send()
}

// UpdateRepositoryNameWithContext is the same as UpdateRepositoryName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepositoryName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateRepositoryNameWithContext(ctx aws.Context, input *UpdateRepositoryNameInput, opts ...request.Option) (*UpdateRepositoryNameOutput, error) {
	req, out := c.UpdateRepositoryNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input of a batch get repositories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositoriesInput
type BatchGetRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The names of the repositories to get information about.
	//
	// RepositoryNames is a required field
	RepositoryNames []*string `locationName:"repositoryNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetRepositoriesInput"}
	if s.RepositoryNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryNames sets the RepositoryNames field's value.
func (s *BatchGetRepositoriesInput) SetRepositoryNames(v []*string) *BatchGetRepositoriesInput {
	s.RepositoryNames = v
	return s
}

// Represents the output of a batch get repositories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositoriesOutput
type BatchGetRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of repositories returned by the batch get repositories operation.
	Repositories []*RepositoryMetadata `locationName:"repositories" type:"list"`

	// Returns a list of repository names for which information could not be found.
	RepositoriesNotFound []*string `locationName:"repositoriesNotFound" type:"list"`
}

// String returns the string representation
func (s BatchGetRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesOutput) GoString() string {
	return s.String()
}

// SetRepositories sets the Repositories field's value.
func (s *BatchGetRepositoriesOutput) SetRepositories(v []*RepositoryMetadata) *BatchGetRepositoriesOutput {
	s.Repositories = v
	return s
}

// SetRepositoriesNotFound sets the RepositoriesNotFound field's value.
func (s *BatchGetRepositoriesOutput) SetRepositoriesNotFound(v []*string) *BatchGetRepositoriesOutput {
	s.RepositoriesNotFound = v
	return s
}

// Returns information about a specific Git blob object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BlobMetadata
type BlobMetadata struct {
	_ struct{} `type:"structure"`

	// The full ID of the blob.
	BlobId *string `locationName:"blobId" type:"string"`

	// The file mode permissions of the blob. File mode permission codes include:
	//
	//    * 100644 indicates read/write
	//
	//    * 100755 indicates read/write/execute
	//
	//    * 160000 indicates a submodule
	//
	//    * 120000 indicates a symlink
	Mode *string `locationName:"mode" type:"string"`

	// The path to the blob and any associated file name, if any.
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation
func (s BlobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlobMetadata) GoString() string {
	return s.String()
}

// SetBlobId sets the BlobId field's value.
func (s *BlobMetadata) SetBlobId(v string) *BlobMetadata {
	s.BlobId = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *BlobMetadata) SetMode(v string) *BlobMetadata {
	s.Mode = &v
	return s
}

// SetPath sets the Path field's value.
func (s *BlobMetadata) SetPath(v string) *BlobMetadata {
	s.Path = &v
	return s
}

// Returns information about a branch.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BranchInfo
type BranchInfo struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The ID of the last commit made to the branch.
	CommitId *string `locationName:"commitId" type:"string"`
}

// String returns the string representation
func (s BranchInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BranchInfo) GoString() string {
	return s.String()
}

// SetBranchName sets the BranchName field's value.
func (s *BranchInfo) SetBranchName(v string) *BranchInfo {
	s.BranchName = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *BranchInfo) SetCommitId(v string) *BranchInfo {
	s.CommitId = &v
	return s
}

// Returns information about a specific commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Commit
type Commit struct {
	_ struct{} `type:"structure"`

	// Any additional data associated with the specified commit.
	AdditionalData *string `locationName:"additionalData" type:"string"`

	// Information about the author of the specified commit. Information includes
	// the date in timestamp format with GMT offset, the name of the author, and
	// the email address for the author, as configured in Git.
	Author *UserInfo `locationName:"author" type:"structure"`

	// Information about the person who committed the specified commit, also known
	// as the committer. Information includes the date in timestamp format with
	// GMT offset, the name of the committer, and the email address for the committer,
	// as configured in Git.
	//
	// For more information about the difference between an author and a committer
	// in Git, see Viewing the Commit History (http://git-scm.com/book/ch2-3.html)
	// in Pro Git by Scott Chacon and Ben Straub.
	Committer *UserInfo `locationName:"committer" type:"structure"`

	// The commit message associated with the specified commit.
	Message *string `locationName:"message" type:"string"`

	// The parent list for the specified commit.
	Parents []*string `locationName:"parents" type:"list"`

	// Tree information for the specified commit.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s Commit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Commit) GoString() string {
	return s.String()
}

// SetAdditionalData sets the AdditionalData field's value.
func (s *Commit) SetAdditionalData(v string) *Commit {
	s.AdditionalData = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *Commit) SetAuthor(v *UserInfo) *Commit {
	s.Author = v
	return s
}

// SetCommitter sets the Committer field's value.
func (s *Commit) SetCommitter(v *UserInfo) *Commit {
	s.Committer = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Commit) SetMessage(v string) *Commit {
	s.Message = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *Commit) SetParents(v []*string) *Commit {
	s.Parents = v
	return s
}

// SetTreeId sets the TreeId field's value.
func (s *Commit) SetTreeId(v string) *Commit {
	s.TreeId = &v
	return s
}

// Represents the input of a create branch operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranchInput
type CreateBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the new branch to create.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The ID of the commit to point the new branch to.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository in which you want to create the new branch.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBranchInput"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.CommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommitId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *CreateBranchInput) SetBranchName(v string) *CreateBranchInput {
	s.BranchName = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *CreateBranchInput) SetCommitId(v string) *CreateBranchInput {
	s.CommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateBranchInput) SetRepositoryName(v string) *CreateBranchInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranchOutput
type CreateBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchOutput) GoString() string {
	return s.String()
}

// Represents the input of a create repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepositoryInput
type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A comment or description about the new repository.
	//
	// The description field for a repository accepts all HTML characters and all
	// valid Unicode characters. Applications that do not HTML-encode the description
	// and display it in a web page could expose users to potentially malicious
	// code. Make sure that you HTML-encode the description field in any application
	// that uses this API to display the repository description on a web page.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the new repository to be created.
	//
	// The repository name must be unique across the calling AWS account. In addition,
	// repository names are limited to 100 alphanumeric, dash, and underscore characters,
	// and cannot include certain characters. For a full description of the limits
	// on repository names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
	// in the AWS CodeCommit User Guide. The suffix ".git" is prohibited.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *CreateRepositoryInput) SetRepositoryDescription(v string) *CreateRepositoryInput {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateRepositoryInput) SetRepositoryName(v string) *CreateRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a create repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepositoryOutput
type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryMetadata sets the RepositoryMetadata field's value.
func (s *CreateRepositoryOutput) SetRepositoryMetadata(v *RepositoryMetadata) *CreateRepositoryOutput {
	s.RepositoryMetadata = v
	return s
}

// Represents the input of a delete repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepositoryInput
type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryInput) SetRepositoryName(v string) *DeleteRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a delete repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepositoryOutput
type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository that was deleted.
	RepositoryId *string `locationName:"repositoryId" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *DeleteRepositoryOutput) SetRepositoryId(v string) *DeleteRepositoryOutput {
	s.RepositoryId = &v
	return s
}

// Returns information about a set of differences for a commit specifier.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/Difference
type Difference struct {
	_ struct{} `type:"structure"`

	// Information about an afterBlob data type object, including the ID, the file
	// mode permission code, and the path.
	AfterBlob *BlobMetadata `locationName:"afterBlob" type:"structure"`

	// Information about a beforeBlob data type object, including the ID, the file
	// mode permission code, and the path.
	BeforeBlob *BlobMetadata `locationName:"beforeBlob" type:"structure"`

	// Whether the change type of the difference is an addition (A), deletion (D),
	// or modification (M).
	ChangeType *string `locationName:"changeType" type:"string" enum:"ChangeTypeEnum"`
}

// String returns the string representation
func (s Difference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Difference) GoString() string {
	return s.String()
}

// SetAfterBlob sets the AfterBlob field's value.
func (s *Difference) SetAfterBlob(v *BlobMetadata) *Difference {
	s.AfterBlob = v
	return s
}

// SetBeforeBlob sets the BeforeBlob field's value.
func (s *Difference) SetBeforeBlob(v *BlobMetadata) *Difference {
	s.BeforeBlob = v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *Difference) SetChangeType(v string) *Difference {
	s.ChangeType = &v
	return s
}

// Represents the input of a get blob operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlobInput
type GetBlobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the blob, which is its SHA-1 pointer.
	//
	// BlobId is a required field
	BlobId *string `locationName:"blobId" type:"string" required:"true"`

	// The name of the repository that contains the blob.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBlobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBlobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBlobInput"}
	if s.BlobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BlobId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlobId sets the BlobId field's value.
func (s *GetBlobInput) SetBlobId(v string) *GetBlobInput {
	s.BlobId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetBlobInput) SetRepositoryName(v string) *GetBlobInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get blob operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlobOutput
type GetBlobOutput struct {
	_ struct{} `type:"structure"`

	// The content of the blob, usually a file.
	//
	// Content is automatically base64 encoded/decoded by the SDK.
	//
	// Content is a required field
	Content []byte `locationName:"content" type:"blob" required:"true"`
}

// String returns the string representation
func (s GetBlobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlobOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetBlobOutput) SetContent(v []byte) *GetBlobOutput {
	s.Content = v
	return s
}

// Represents the input of a get branch operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranchInput
type GetBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch for which you want to retrieve information.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The name of the repository that contains the branch for which you want to
	// retrieve information.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBranchInput"}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *GetBranchInput) SetBranchName(v string) *GetBranchInput {
	s.BranchName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetBranchInput) SetRepositoryName(v string) *GetBranchInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get branch operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranchOutput
type GetBranchOutput struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	Branch *BranchInfo `locationName:"branch" type:"structure"`
}

// String returns the string representation
func (s GetBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *GetBranchOutput) SetBranch(v *BranchInfo) *GetBranchOutput {
	s.Branch = v
	return s
}

// Represents the input of a get commit operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommitInput
type GetCommitInput struct {
	_ struct{} `type:"structure"`

	// The commit ID.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository to which the commit was made.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommitInput"}
	if s.CommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommitId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitId sets the CommitId field's value.
func (s *GetCommitInput) SetCommitId(v string) *GetCommitInput {
	s.CommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetCommitInput) SetRepositoryName(v string) *GetCommitInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get commit operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommitOutput
type GetCommitOutput struct {
	_ struct{} `type:"structure"`

	// A commit data type object that contains information about the specified commit.
	//
	// Commit is a required field
	Commit *Commit `locationName:"commit" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCommitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitOutput) GoString() string {
	return s.String()
}

// SetCommit sets the Commit field's value.
func (s *GetCommitOutput) SetCommit(v *Commit) *GetCommitOutput {
	s.Commit = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferencesInput
type GetDifferencesInput struct {
	_ struct{} `type:"structure"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit.
	//
	// AfterCommitSpecifier is a required field
	AfterCommitSpecifier *string `locationName:"afterCommitSpecifier" type:"string" required:"true"`

	// The file path in which to check differences. Limits the results to this path.
	// Can also be used to specify the changed name of a directory or folder, if
	// it has changed. If not specified, differences will be shown for all paths.
	AfterPath *string `locationName:"afterPath" type:"string"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, the full commit ID. Optional. If not specified, all
	// changes prior to the afterCommitSpecifier value will be shown. If you do
	// not use beforeCommitSpecifier in your request, consider limiting the results
	// with maxResults.
	BeforeCommitSpecifier *string `locationName:"beforeCommitSpecifier" type:"string"`

	// The file path in which to check for differences. Limits the results to this
	// path. Can also be used to specify the previous name of a directory or folder.
	// If beforePath and afterPath are not specified, differences will be shown
	// for all paths.
	BeforePath *string `locationName:"beforePath" type:"string"`

	// A non-negative integer used to limit the number of returned results.
	MaxResults *int64 `type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`

	// The name of the repository where you want to get differences.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDifferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDifferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDifferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDifferencesInput"}
	if s.AfterCommitSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AfterCommitSpecifier"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitSpecifier sets the AfterCommitSpecifier field's value.
func (s *GetDifferencesInput) SetAfterCommitSpecifier(v string) *GetDifferencesInput {
	s.AfterCommitSpecifier = &v
	return s
}

// SetAfterPath sets the AfterPath field's value.
func (s *GetDifferencesInput) SetAfterPath(v string) *GetDifferencesInput {
	s.AfterPath = &v
	return s
}

// SetBeforeCommitSpecifier sets the BeforeCommitSpecifier field's value.
func (s *GetDifferencesInput) SetBeforeCommitSpecifier(v string) *GetDifferencesInput {
	s.BeforeCommitSpecifier = &v
	return s
}

// SetBeforePath sets the BeforePath field's value.
func (s *GetDifferencesInput) SetBeforePath(v string) *GetDifferencesInput {
	s.BeforePath = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDifferencesInput) SetMaxResults(v int64) *GetDifferencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDifferencesInput) SetNextToken(v string) *GetDifferencesInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetDifferencesInput) SetRepositoryName(v string) *GetDifferencesInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferencesOutput
type GetDifferencesOutput struct {
	_ struct{} `type:"structure"`

	// A differences data type object that contains information about the differences,
	// including whether the difference is added, modified, or deleted (A, D, M).
	Differences []*Difference `locationName:"differences" type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDifferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDifferencesOutput) GoString() string {
	return s.String()
}

// SetDifferences sets the Differences field's value.
func (s *GetDifferencesOutput) SetDifferences(v []*Difference) *GetDifferencesOutput {
	s.Differences = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDifferencesOutput) SetNextToken(v string) *GetDifferencesOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a get repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryInput
type GetRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to get information about.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryInput) SetRepositoryName(v string) *GetRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get repository operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryOutput
type GetRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s GetRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryMetadata sets the RepositoryMetadata field's value.
func (s *GetRepositoryOutput) SetRepositoryMetadata(v *RepositoryMetadata) *GetRepositoryOutput {
	s.RepositoryMetadata = v
	return s
}

// Represents the input of a get repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggersInput
type GetRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository for which the trigger is configured.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryTriggersInput) SetRepositoryName(v string) *GetRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggersOutput
type GetRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the trigger.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// The JSON block of configuration information for each trigger.
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s GetRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *GetRepositoryTriggersOutput) SetConfigurationId(v string) *GetRepositoryTriggersOutput {
	s.ConfigurationId = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *GetRepositoryTriggersOutput) SetTriggers(v []*RepositoryTrigger) *GetRepositoryTriggersOutput {
	s.Triggers = v
	return s
}

// Represents the input of a list branches operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranchesInput
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository that contains the branches.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBranchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBranchesInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesInput) SetNextToken(v string) *ListBranchesInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ListBranchesInput) SetRepositoryName(v string) *ListBranchesInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a list branches operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranchesOutput
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// The list of branch names.
	Branches []*string `locationName:"branches" type:"list"`

	// An enumeration token that returns the batch of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesOutput) GoString() string {
	return s.String()
}

// SetBranches sets the Branches field's value.
func (s *ListBranchesOutput) SetBranches(v []*string) *ListBranchesOutput {
	s.Branches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesOutput) SetNextToken(v string) *ListBranchesOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a list repositories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesInput
type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order in which to sort the results of a list repositories operation.
	Order *string `locationName:"order" type:"string" enum:"OrderEnum"`

	// The criteria used to sort the results of a list repositories operation.
	SortBy *string `locationName:"sortBy" type:"string" enum:"SortByEnum"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInput) SetNextToken(v string) *ListRepositoriesInput {
	s.NextToken = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ListRepositoriesInput) SetOrder(v string) *ListRepositoriesInput {
	s.Order = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListRepositoriesInput) SetSortBy(v string) *ListRepositoriesInput {
	s.SortBy = &v
	return s
}

// Represents the output of a list repositories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesOutput
type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the repositories called by the list repositories operation.
	Repositories []*RepositoryNameIdPair `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesOutput) SetNextToken(v string) *ListRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ListRepositoriesOutput) SetRepositories(v []*RepositoryNameIdPair) *ListRepositoriesOutput {
	s.Repositories = v
	return s
}

// Represents the input ofa put repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggersInput
type PutRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository where you want to create or update the trigger.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The JSON block of configuration information for each trigger.
	//
	// Triggers is a required field
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Triggers == nil {
		invalidParams.Add(request.NewErrParamRequired("Triggers"))
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutRepositoryTriggersInput) SetRepositoryName(v string) *PutRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *PutRepositoryTriggersInput) SetTriggers(v []*RepositoryTrigger) *PutRepositoryTriggersInput {
	s.Triggers = v
	return s
}

// Represents the output of a put repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggersOutput
type PutRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the create or update operation.
	ConfigurationId *string `locationName:"configurationId" type:"string"`
}

// String returns the string representation
func (s PutRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *PutRepositoryTriggersOutput) SetConfigurationId(v string) *PutRepositoryTriggersOutput {
	s.ConfigurationId = &v
	return s
}

// Information about a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryMetadata
type RepositoryMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account associated with the repository.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the repository.
	Arn *string `type:"string"`

	// The URL to use for cloning the repository over HTTPS.
	CloneUrlHttp *string `locationName:"cloneUrlHttp" type:"string"`

	// The URL to use for cloning the repository over SSH.
	CloneUrlSsh *string `locationName:"cloneUrlSsh" type:"string"`

	// The date and time the repository was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The repository's default branch name.
	DefaultBranch *string `locationName:"defaultBranch" min:"1" type:"string"`

	// The date and time the repository was last modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// A comment or description about the repository.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The ID of the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The repository's name.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryMetadata) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RepositoryMetadata) SetAccountId(v string) *RepositoryMetadata {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RepositoryMetadata) SetArn(v string) *RepositoryMetadata {
	s.Arn = &v
	return s
}

// SetCloneUrlHttp sets the CloneUrlHttp field's value.
func (s *RepositoryMetadata) SetCloneUrlHttp(v string) *RepositoryMetadata {
	s.CloneUrlHttp = &v
	return s
}

// SetCloneUrlSsh sets the CloneUrlSsh field's value.
func (s *RepositoryMetadata) SetCloneUrlSsh(v string) *RepositoryMetadata {
	s.CloneUrlSsh = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RepositoryMetadata) SetCreationDate(v time.Time) *RepositoryMetadata {
	s.CreationDate = &v
	return s
}

// SetDefaultBranch sets the DefaultBranch field's value.
func (s *RepositoryMetadata) SetDefaultBranch(v string) *RepositoryMetadata {
	s.DefaultBranch = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RepositoryMetadata) SetLastModifiedDate(v time.Time) *RepositoryMetadata {
	s.LastModifiedDate = &v
	return s
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *RepositoryMetadata) SetRepositoryDescription(v string) *RepositoryMetadata {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *RepositoryMetadata) SetRepositoryId(v string) *RepositoryMetadata {
	s.RepositoryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *RepositoryMetadata) SetRepositoryName(v string) *RepositoryMetadata {
	s.RepositoryName = &v
	return s
}

// Information about a repository name and ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryNameIdPair
type RepositoryNameIdPair struct {
	_ struct{} `type:"structure"`

	// The ID associated with the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The name associated with the repository.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryNameIdPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryNameIdPair) GoString() string {
	return s.String()
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *RepositoryNameIdPair) SetRepositoryId(v string) *RepositoryNameIdPair {
	s.RepositoryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *RepositoryNameIdPair) SetRepositoryName(v string) *RepositoryNameIdPair {
	s.RepositoryName = &v
	return s
}

// Information about a trigger for a repository.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryTrigger
type RepositoryTrigger struct {
	_ struct{} `type:"structure"`

	// The branches that will be included in the trigger configuration. If no branches
	// are specified, the trigger will apply to all branches.
	Branches []*string `locationName:"branches" type:"list"`

	// Any custom data associated with the trigger that will be included in the
	// information sent to the target of the trigger.
	CustomData *string `locationName:"customData" type:"string"`

	// The ARN of the resource that is the target for a trigger. For example, the
	// ARN of a topic in Amazon Simple Notification Service (SNS).
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" type:"string" required:"true"`

	// The repository events that will cause the trigger to run actions in another
	// service, such as sending a notification through Amazon Simple Notification
	// Service (SNS).
	//
	// The valid value "all" cannot be used with any other values.
	//
	// Events is a required field
	Events []*string `locationName:"events" type:"list" required:"true"`

	// The name of the trigger.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s RepositoryTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryTrigger"}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranches sets the Branches field's value.
func (s *RepositoryTrigger) SetBranches(v []*string) *RepositoryTrigger {
	s.Branches = v
	return s
}

// SetCustomData sets the CustomData field's value.
func (s *RepositoryTrigger) SetCustomData(v string) *RepositoryTrigger {
	s.CustomData = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *RepositoryTrigger) SetDestinationArn(v string) *RepositoryTrigger {
	s.DestinationArn = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *RepositoryTrigger) SetEvents(v []*string) *RepositoryTrigger {
	s.Events = v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryTrigger) SetName(v string) *RepositoryTrigger {
	s.Name = &v
	return s
}

// A trigger failed to run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/RepositoryTriggerExecutionFailure
type RepositoryTriggerExecutionFailure struct {
	_ struct{} `type:"structure"`

	// Additional message information about the trigger that did not run.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The name of the trigger that did not run.
	Trigger *string `locationName:"trigger" type:"string"`
}

// String returns the string representation
func (s RepositoryTriggerExecutionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTriggerExecutionFailure) GoString() string {
	return s.String()
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *RepositoryTriggerExecutionFailure) SetFailureMessage(v string) *RepositoryTriggerExecutionFailure {
	s.FailureMessage = &v
	return s
}

// SetTrigger sets the Trigger field's value.
func (s *RepositoryTriggerExecutionFailure) SetTrigger(v string) *RepositoryTriggerExecutionFailure {
	s.Trigger = &v
	return s
}

// Represents the input of a test repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggersInput
type TestRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository in which to test the triggers.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The list of triggers to test.
	//
	// Triggers is a required field
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list" required:"true"`
}

// String returns the string representation
func (s TestRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Triggers == nil {
		invalidParams.Add(request.NewErrParamRequired("Triggers"))
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *TestRepositoryTriggersInput) SetRepositoryName(v string) *TestRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *TestRepositoryTriggersInput) SetTriggers(v []*RepositoryTrigger) *TestRepositoryTriggersInput {
	s.Triggers = v
	return s
}

// Represents the output of a test repository triggers operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggersOutput
type TestRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The list of triggers that were not able to be tested. This list provides
	// the names of the triggers that could not be tested, separated by commas.
	FailedExecutions []*RepositoryTriggerExecutionFailure `locationName:"failedExecutions" type:"list"`

	// The list of triggers that were successfully tested. This list provides the
	// names of the triggers that were successfully tested, separated by commas.
	SuccessfulExecutions []*string `locationName:"successfulExecutions" type:"list"`
}

// String returns the string representation
func (s TestRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetFailedExecutions sets the FailedExecutions field's value.
func (s *TestRepositoryTriggersOutput) SetFailedExecutions(v []*RepositoryTriggerExecutionFailure) *TestRepositoryTriggersOutput {
	s.FailedExecutions = v
	return s
}

// SetSuccessfulExecutions sets the SuccessfulExecutions field's value.
func (s *TestRepositoryTriggersOutput) SetSuccessfulExecutions(v []*string) *TestRepositoryTriggersOutput {
	s.SuccessfulExecutions = v
	return s
}

// Represents the input of an update default branch operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranchInput
type UpdateDefaultBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch to set as the default.
	//
	// DefaultBranchName is a required field
	DefaultBranchName *string `locationName:"defaultBranchName" min:"1" type:"string" required:"true"`

	// The name of the repository to set or change the default branch for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDefaultBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDefaultBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDefaultBranchInput"}
	if s.DefaultBranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultBranchName"))
	}
	if s.DefaultBranchName != nil && len(*s.DefaultBranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultBranchName", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultBranchName sets the DefaultBranchName field's value.
func (s *UpdateDefaultBranchInput) SetDefaultBranchName(v string) *UpdateDefaultBranchInput {
	s.DefaultBranchName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateDefaultBranchInput) SetRepositoryName(v string) *UpdateDefaultBranchInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranchOutput
type UpdateDefaultBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDefaultBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchOutput) GoString() string {
	return s.String()
}

// Represents the input of an update repository description operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescriptionInput
type UpdateRepositoryDescriptionInput struct {
	_ struct{} `type:"structure"`

	// The new comment or description for the specified repository. Repository descriptions
	// are limited to 1,000 characters.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the repository to set or change the comment or description for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryDescriptionInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *UpdateRepositoryDescriptionInput) SetRepositoryDescription(v string) *UpdateRepositoryDescriptionInput {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateRepositoryDescriptionInput) SetRepositoryName(v string) *UpdateRepositoryDescriptionInput {
	s.RepositoryName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescriptionOutput
type UpdateRepositoryDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionOutput) GoString() string {
	return s.String()
}

// Represents the input of an update repository description operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryNameInput
type UpdateRepositoryNameInput struct {
	_ struct{} `type:"structure"`

	// The new name for the repository.
	//
	// NewName is a required field
	NewName *string `locationName:"newName" min:"1" type:"string" required:"true"`

	// The existing name of the repository.
	//
	// OldName is a required field
	OldName *string `locationName:"oldName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryNameInput"}
	if s.NewName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewName"))
	}
	if s.NewName != nil && len(*s.NewName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewName", 1))
	}
	if s.OldName == nil {
		invalidParams.Add(request.NewErrParamRequired("OldName"))
	}
	if s.OldName != nil && len(*s.OldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewName sets the NewName field's value.
func (s *UpdateRepositoryNameInput) SetNewName(v string) *UpdateRepositoryNameInput {
	s.NewName = &v
	return s
}

// SetOldName sets the OldName field's value.
func (s *UpdateRepositoryNameInput) SetOldName(v string) *UpdateRepositoryNameInput {
	s.OldName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryNameOutput
type UpdateRepositoryNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameOutput) GoString() string {
	return s.String()
}

// Information about the user who made a specified commit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UserInfo
type UserInfo struct {
	_ struct{} `type:"structure"`

	// The date when the specified commit was pushed to the repository.
	Date *string `locationName:"date" type:"string"`

	// The email address associated with the user who made the commit, if any.
	Email *string `locationName:"email" type:"string"`

	// The name of the user who made the specified commit.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UserInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserInfo) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *UserInfo) SetDate(v string) *UserInfo {
	s.Date = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UserInfo) SetEmail(v string) *UserInfo {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *UserInfo) SetName(v string) *UserInfo {
	s.Name = &v
	return s
}

const (
	// ChangeTypeEnumA is a ChangeTypeEnum enum value
	ChangeTypeEnumA = "A"

	// ChangeTypeEnumM is a ChangeTypeEnum enum value
	ChangeTypeEnumM = "M"

	// ChangeTypeEnumD is a ChangeTypeEnum enum value
	ChangeTypeEnumD = "D"
)

const (
	// OrderEnumAscending is a OrderEnum enum value
	OrderEnumAscending = "ascending"

	// OrderEnumDescending is a OrderEnum enum value
	OrderEnumDescending = "descending"
)

const (
	// RepositoryTriggerEventEnumAll is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumAll = "all"

	// RepositoryTriggerEventEnumUpdateReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumUpdateReference = "updateReference"

	// RepositoryTriggerEventEnumCreateReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumCreateReference = "createReference"

	// RepositoryTriggerEventEnumDeleteReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumDeleteReference = "deleteReference"
)

const (
	// SortByEnumRepositoryName is a SortByEnum enum value
	SortByEnumRepositoryName = "repositoryName"

	// SortByEnumLastModifiedDate is a SortByEnum enum value
	SortByEnumLastModifiedDate = "lastModifiedDate"
)
