// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateTeamMember = "AssociateTeamMember"

// AssociateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTeamMember operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateTeamMember for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateTeamMember method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateTeamMemberRequest method.
//    req, resp := client.AssociateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMember
func (c *CodeStar) AssociateTeamMemberRequest(input *AssociateTeamMemberInput) (req *request.Request, output *AssociateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opAssociateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateTeamMemberInput{}
	}

	output = &AssociateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateTeamMember API operation for AWS CodeStar.
//
// Adds an IAM user to the team for an AWS CodeStar project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation AssociateTeamMember for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A resource limit has been exceeded.
//
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeTeamMemberAlreadyAssociatedException "TeamMemberAlreadyAssociatedException"
//   The team member is already associated with a role in this project.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
//   * ErrCodeProjectConfigurationException "ProjectConfigurationException"
//   Project configuration information is required but not specified.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMember
func (c *CodeStar) AssociateTeamMember(input *AssociateTeamMemberInput) (*AssociateTeamMemberOutput, error) {
	req, out := c.AssociateTeamMemberRequest(input)
	return out, req.Send()
}

// AssociateTeamMemberWithContext is the same as AssociateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) AssociateTeamMemberWithContext(ctx aws.Context, input *AssociateTeamMemberInput, opts ...request.Option) (*AssociateTeamMemberOutput, error) {
	req, out := c.AssociateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProject
func (c *CodeStar) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for AWS CodeStar.
//
// Reserved for future use. To create a project, use the AWS CodeStar console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation CreateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectAlreadyExistsException "ProjectAlreadyExistsException"
//   An AWS CodeStar project with the same ID already exists in this region for
//   the AWS account. AWS CodeStar project IDs must be unique within a region
//   for the AWS account.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A resource limit has been exceeded.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeProjectCreationFailedException "ProjectCreationFailedException"
//   The project creation request was valid, but a nonspecific exception or error
//   occurred during project creation. The project could not be created in AWS
//   CodeStar.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
//   * ErrCodeProjectConfigurationException "ProjectConfigurationException"
//   Project configuration information is required but not specified.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProject
func (c *CodeStar) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUserProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUserProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUserProfileRequest method.
//    req, resp := client.CreateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfile
func (c *CodeStar) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for AWS CodeStar.
//
// Creates a profile for a user that includes user preferences, such as the
// display name and email address assocciated with the user, in AWS CodeStar.
// The user profile is not project-specific. Information in the user profile
// is displayed wherever the user's information appears to other users in AWS
// CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUserProfileAlreadyExistsException "UserProfileAlreadyExistsException"
//   A user profile with that name already exists in this region for the AWS account.
//   AWS CodeStar user profile names must be unique within a region for the AWS
//   account.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfile
func (c *CodeStar) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProject
func (c *CodeStar) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for AWS CodeStar.
//
// Deletes a project, including project resources. Does not delete users associated
// with the project, but does delete the IAM roles that allowed access to the
// project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DeleteProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProject
func (c *CodeStar) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUserProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUserProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserProfileRequest method.
//    req, resp := client.DeleteUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfile
func (c *CodeStar) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	output = &DeleteUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserProfile API operation for AWS CodeStar.
//
// Deletes a user profile in AWS CodeStar, including all personal preference
// data associated with that profile, such as display name and email address.
// It does not delete the history of that user, for example the history of commits
// made by that user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DeleteUserProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfile
func (c *CodeStar) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	return out, req.Send()
}

// DeleteUserProfileWithContext is the same as DeleteUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DeleteUserProfileWithContext(ctx aws.Context, input *DeleteUserProfileInput, opts ...request.Option) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeProjectRequest method.
//    req, resp := client.DescribeProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProject
func (c *CodeStar) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS CodeStar.
//
// Describes a project and its resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DescribeProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
//   * ErrCodeProjectConfigurationException "ProjectConfigurationException"
//   Project configuration information is required but not specified.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProject
func (c *CodeStar) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserProfile = "DescribeUserProfile"

// DescribeUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUserProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUserProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUserProfileRequest method.
//    req, resp := client.DescribeUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfile
func (c *CodeStar) DescribeUserProfileRequest(input *DescribeUserProfileInput) (req *request.Request, output *DescribeUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfileInput{}
	}

	output = &DescribeUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserProfile API operation for AWS CodeStar.
//
// Describes a user in AWS CodeStar and the user attributes across all projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DescribeUserProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUserProfileNotFoundException "UserProfileNotFoundException"
//   The user profile was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfile
func (c *CodeStar) DescribeUserProfile(input *DescribeUserProfileInput) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	return out, req.Send()
}

// DescribeUserProfileWithContext is the same as DescribeUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DescribeUserProfileWithContext(ctx aws.Context, input *DescribeUserProfileInput, opts ...request.Option) (*DescribeUserProfileOutput, error) {
	req, out := c.DescribeUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTeamMember = "DisassociateTeamMember"

// DisassociateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTeamMember operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateTeamMember for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateTeamMember method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateTeamMemberRequest method.
//    req, resp := client.DisassociateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMember
func (c *CodeStar) DisassociateTeamMemberRequest(input *DisassociateTeamMemberInput) (req *request.Request, output *DisassociateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opDisassociateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateTeamMemberInput{}
	}

	output = &DisassociateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateTeamMember API operation for AWS CodeStar.
//
// Removes a user from a project. Removing a user from a project also removes
// the IAM policies from that user that allowed access to the project and its
// resources. Disassociating a team member does not remove that user's profile
// from AWS CodeStar. It does not remove the user from IAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation DisassociateTeamMember for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMember
func (c *CodeStar) DisassociateTeamMember(input *DisassociateTeamMemberInput) (*DisassociateTeamMemberOutput, error) {
	req, out := c.DisassociateTeamMemberRequest(input)
	return out, req.Send()
}

// DisassociateTeamMemberWithContext is the same as DisassociateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) DisassociateTeamMemberWithContext(ctx aws.Context, input *DisassociateTeamMemberInput, opts ...request.Option) (*DisassociateTeamMemberOutput, error) {
	req, out := c.DisassociateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListProjects for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListProjects method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListProjectsRequest method.
//    req, resp := client.ListProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjects
func (c *CodeStar) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS CodeStar.
//
// Lists all projects in AWS CodeStar associated with your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListProjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token is not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjects
func (c *CodeStar) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResources = "ListResources"

// ListResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListResources operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListResources for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListResources method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListResourcesRequest method.
//    req, resp := client.ListResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResources
func (c *CodeStar) ListResourcesRequest(input *ListResourcesInput) (req *request.Request, output *ListResourcesOutput) {
	op := &request.Operation{
		Name:       opListResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesInput{}
	}

	output = &ListResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResources API operation for AWS CodeStar.
//
// Lists resources associated with a project in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token is not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResources
func (c *CodeStar) ListResources(input *ListResourcesInput) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	return out, req.Send()
}

// ListResourcesWithContext is the same as ListResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListResourcesWithContext(ctx aws.Context, input *ListResourcesInput, opts ...request.Option) (*ListResourcesOutput, error) {
	req, out := c.ListResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTeamMembers = "ListTeamMembers"

// ListTeamMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListTeamMembers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTeamMembers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTeamMembers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTeamMembersRequest method.
//    req, resp := client.ListTeamMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembers
func (c *CodeStar) ListTeamMembersRequest(input *ListTeamMembersInput) (req *request.Request, output *ListTeamMembersOutput) {
	op := &request.Operation{
		Name:       opListTeamMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTeamMembersInput{}
	}

	output = &ListTeamMembersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTeamMembers API operation for AWS CodeStar.
//
// Lists all team members associated with a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListTeamMembers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token is not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembers
func (c *CodeStar) ListTeamMembers(input *ListTeamMembersInput) (*ListTeamMembersOutput, error) {
	req, out := c.ListTeamMembersRequest(input)
	return out, req.Send()
}

// ListTeamMembersWithContext is the same as ListTeamMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTeamMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListTeamMembersWithContext(ctx aws.Context, input *ListTeamMembersInput, opts ...request.Option) (*ListTeamMembersOutput, error) {
	req, out := c.ListTeamMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUserProfiles = "ListUserProfiles"

// ListUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListUserProfiles operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUserProfiles for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUserProfiles method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUserProfilesRequest method.
//    req, resp := client.ListUserProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfiles
func (c *CodeStar) ListUserProfilesRequest(input *ListUserProfilesInput) (req *request.Request, output *ListUserProfilesOutput) {
	op := &request.Operation{
		Name:       opListUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserProfilesInput{}
	}

	output = &ListUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserProfiles API operation for AWS CodeStar.
//
// Lists all the user profiles configured for your AWS account in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation ListUserProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   The next token is not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfiles
func (c *CodeStar) ListUserProfiles(input *ListUserProfilesInput) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	return out, req.Send()
}

// ListUserProfilesWithContext is the same as ListUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) ListUserProfilesWithContext(ctx aws.Context, input *ListUserProfilesInput, opts ...request.Option) (*ListUserProfilesOutput, error) {
	req, out := c.ListUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateProject for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateProject method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateProjectRequest method.
//    req, resp := client.UpdateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProject
func (c *CodeStar) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProject API operation for AWS CodeStar.
//
// Updates a project in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateProject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProject
func (c *CodeStar) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTeamMember = "UpdateTeamMember"

// UpdateTeamMemberRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTeamMember operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateTeamMember for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateTeamMember method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateTeamMemberRequest method.
//    req, resp := client.UpdateTeamMemberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMember
func (c *CodeStar) UpdateTeamMemberRequest(input *UpdateTeamMemberInput) (req *request.Request, output *UpdateTeamMemberOutput) {
	op := &request.Operation{
		Name:       opUpdateTeamMember,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTeamMemberInput{}
	}

	output = &UpdateTeamMemberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTeamMember API operation for AWS CodeStar.
//
// Updates a team member's attributes in an AWS CodeStar project. For example,
// you can change a team member's role in the project, or change whether they
// have remote access to project resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateTeamMember for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A resource limit has been exceeded.
//
//   * ErrCodeProjectNotFoundException "ProjectNotFoundException"
//   The specified AWS CodeStar project was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
//   * ErrCodeInvalidServiceRoleException "InvalidServiceRoleException"
//   The service role is not valid.
//
//   * ErrCodeProjectConfigurationException "ProjectConfigurationException"
//   Project configuration information is required but not specified.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Another modification is being made. That modification must complete before
//   you can make your change.
//
//   * ErrCodeTeamMemberNotFoundException "TeamMemberNotFoundException"
//   The specified team member was not found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMember
func (c *CodeStar) UpdateTeamMember(input *UpdateTeamMemberInput) (*UpdateTeamMemberOutput, error) {
	req, out := c.UpdateTeamMemberRequest(input)
	return out, req.Send()
}

// UpdateTeamMemberWithContext is the same as UpdateTeamMember with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTeamMember for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateTeamMemberWithContext(ctx aws.Context, input *UpdateTeamMemberInput, opts ...request.Option) (*UpdateTeamMemberOutput, error) {
	req, out := c.UpdateTeamMemberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateUserProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateUserProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateUserProfileRequest method.
//    req, resp := client.UpdateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfile
func (c *CodeStar) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserProfile API operation for AWS CodeStar.
//
// Updates a user's profile in AWS CodeStar. The user profile is not project-specific.
// Information in the user profile is displayed wherever the user's information
// appears to other users in AWS CodeStar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeStar's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUserProfileNotFoundException "UserProfileNotFoundException"
//   The user profile was not found.
//
//   * ErrCodeValidationException "ValidationException"
//   The specified input is either not valid, or it could not be validated.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfile
func (c *CodeStar) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeStar) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMemberRequest
type AssociateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// A user- or system-generated token that identifies the entity that requested
	// the team member association to the project. This token can be used to repeat
	// the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The ID of the project to which you will add the IAM user.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The AWS CodeStar project role that will apply to this user. This role determines
	// what actions a user can take in an AWS CodeStar project.
	//
	// ProjectRole is a required field
	ProjectRole *string `locationName:"projectRole" type:"string" required:"true"`

	// Whether the team member is allowed to use an SSH public/private key pair
	// to remotely access project resources, for example Amazon EC2 instances.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM user you want to add to the DevHub
	// project.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTeamMemberInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.ProjectRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectRole"))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateTeamMemberInput) SetClientRequestToken(v string) *AssociateTeamMemberInput {
	s.ClientRequestToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *AssociateTeamMemberInput) SetProjectId(v string) *AssociateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetProjectRole sets the ProjectRole field's value.
func (s *AssociateTeamMemberInput) SetProjectRole(v string) *AssociateTeamMemberInput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *AssociateTeamMemberInput) SetRemoteAccessAllowed(v bool) *AssociateTeamMemberInput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *AssociateTeamMemberInput) SetUserArn(v string) *AssociateTeamMemberInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/AssociateTeamMemberResult
type AssociateTeamMemberOutput struct {
	_ struct{} `type:"structure"`

	// The user- or system-generated token from the initial request that can be
	// used to repeat the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTeamMemberOutput) GoString() string {
	return s.String()
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateTeamMemberOutput) SetClientRequestToken(v string) *AssociateTeamMemberOutput {
	s.ClientRequestToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProjectRequest
type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Reserved for future use.
	Description *string `locationName:"description" type:"string"`

	// Reserved for future use.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// Reserved for future use.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProjectInput) SetClientRequestToken(v string) *CreateProjectInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateProjectInput) SetId(v string) *CreateProjectInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProjectInput) SetName(v string) *CreateProjectInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateProjectResult
type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// Reserved for future use.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Reserved for future use.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// Reserved for future use.
	ProjectTemplateId *string `locationName:"projectTemplateId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateProjectOutput) SetArn(v string) *CreateProjectOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateProjectOutput) SetClientRequestToken(v string) *CreateProjectOutput {
	s.ClientRequestToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateProjectOutput) SetId(v string) *CreateProjectOutput {
	s.Id = &v
	return s
}

// SetProjectTemplateId sets the ProjectTemplateId field's value.
func (s *CreateProjectOutput) SetProjectTemplateId(v string) *CreateProjectOutput {
	s.ProjectTemplateId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfileRequest
type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The name that will be displayed as the friendly name for the user in AWS
	// CodeStar.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The email address that will be displayed as part of the user's profile in
	// AWS CodeStar.
	//
	// EmailAddress is a required field
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" required:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserProfileInput"}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 3))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserProfileInput) SetDisplayName(v string) *CreateUserProfileInput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateUserProfileInput) SetEmailAddress(v string) *CreateUserProfileInput {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateUserProfileInput) SetSshPublicKey(v string) *CreateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserProfileInput) SetUserArn(v string) *CreateUserProfileInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/CreateUserProfileResult
type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date the user profile was created, in timestamp format.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string"`

	// The date the user profile was last modified, in timestamp format.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The SSH public key associated with the user in AWS CodeStar. This is the
	// public portion of the public/private keypair the user can use to access project
	// resources if a project owner allows the user remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateUserProfileOutput) SetCreatedTimestamp(v time.Time) *CreateUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserProfileOutput) SetDisplayName(v string) *CreateUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateUserProfileOutput) SetEmailAddress(v string) *CreateUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *CreateUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *CreateUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateUserProfileOutput) SetSshPublicKey(v string) *CreateUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserProfileOutput) SetUserArn(v string) *CreateUserProfileOutput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProjectRequest
type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// A user- or system-generated token that identifies the entity that requested
	// project deletion. This token can be used to repeat the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Whether to send a delete request for the primary stack in AWS CloudFormation
	// originally used to generate the project and its resources. This option will
	// delete all AWS resources for the project (except for any buckets in Amazon
	// S3) as well as deleting the project itself. Recommended for most use cases.
	DeleteStack *bool `locationName:"deleteStack" type:"boolean"`

	// The ID of the project to be deleted in AWS CodeStar.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DeleteProjectInput) SetClientRequestToken(v string) *DeleteProjectInput {
	s.ClientRequestToken = &v
	return s
}

// SetDeleteStack sets the DeleteStack field's value.
func (s *DeleteProjectInput) SetDeleteStack(v bool) *DeleteProjectInput {
	s.DeleteStack = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteProjectInput) SetId(v string) *DeleteProjectInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteProjectResult
type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted project.
	ProjectArn *string `locationName:"projectArn" type:"string"`

	// The ID of the primary stack in AWS CloudFormation that will be deleted as
	// part of deleting the project and its resources.
	StackId *string `locationName:"stackId" type:"string"`
}

// String returns the string representation
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DeleteProjectOutput) SetProjectArn(v string) *DeleteProjectOutput {
	s.ProjectArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DeleteProjectOutput) SetStackId(v string) *DeleteProjectOutput {
	s.StackId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfileRequest
type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserProfileInput"}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserProfileInput) SetUserArn(v string) *DeleteUserProfileInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DeleteUserProfileResult
type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user deleted from AWS CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteUserProfileOutput) SetUserArn(v string) *DeleteUserProfileOutput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProjectRequest
type DescribeProjectInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeProjectInput) SetId(v string) *DescribeProjectInput {
	s.Id = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeProjectResult
type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the project.
	Arn *string `locationName:"arn" type:"string"`

	// A user- or system-generated token that identifies the entity that requested
	// project creation.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The date and time the project was created, in timestamp format.
	CreatedTimeStamp *time.Time `locationName:"createdTimeStamp" type:"timestamp" timestampFormat:"unix"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string"`

	// The ID of the project.
	Id *string `locationName:"id" min:"2" type:"string"`

	// The display name for the project.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The ID for the AWS CodeStar project template used to create the project.
	ProjectTemplateId *string `locationName:"projectTemplateId" min:"1" type:"string"`

	// The ID of the primary stack in AWS CloudFormation used to generate resources
	// for the project.
	StackId *string `locationName:"stackId" type:"string"`
}

// String returns the string representation
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeProjectOutput) SetArn(v string) *DescribeProjectOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeProjectOutput) SetClientRequestToken(v string) *DescribeProjectOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedTimeStamp sets the CreatedTimeStamp field's value.
func (s *DescribeProjectOutput) SetCreatedTimeStamp(v time.Time) *DescribeProjectOutput {
	s.CreatedTimeStamp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeProjectOutput) SetDescription(v string) *DescribeProjectOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeProjectOutput) SetId(v string) *DescribeProjectOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeProjectOutput) SetName(v string) *DescribeProjectOutput {
	s.Name = &v
	return s
}

// SetProjectTemplateId sets the ProjectTemplateId field's value.
func (s *DescribeProjectOutput) SetProjectTemplateId(v string) *DescribeProjectOutput {
	s.ProjectTemplateId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeProjectOutput) SetStackId(v string) *DescribeProjectOutput {
	s.StackId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfileRequest
type DescribeUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUserProfileInput"}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserArn sets the UserArn field's value.
func (s *DescribeUserProfileInput) SetUserArn(v string) *DescribeUserProfileInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DescribeUserProfileResult
type DescribeUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the user profile was created in AWS CodeStar, in timestamp
	// format.
	//
	// CreatedTimestamp is a required field
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The display name shown for the user in AWS CodeStar projects. For example,
	// this could be set to both first and last name ("Mary Major") or a single
	// name ("Mary"). The display name is also used to generate the initial icon
	// associated with the user in AWS CodeStar projects. If spaces are included
	// in the display name, the first character that appears after the space will
	// be used as the second character in the user initial icon. The initial icon
	// displays a maximum of two characters, so a display name with more than one
	// space (for example "Mary Jane Major") would generate an initial icon using
	// the first character and the first character after the space ("MJ", not "MM").
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The email address for the user. Optional.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string"`

	// The date and time when the user profile was last modified, in timestamp format.
	//
	// LastModifiedTimestamp is a required field
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The SSH public key associated with the user. This SSH public key is associated
	// with the user profile, and can be used in conjunction with the associated
	// private key for access to project resources, such as Amazon EC2 instances,
	// if a project owner grants remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DescribeUserProfileOutput) SetCreatedTimestamp(v time.Time) *DescribeUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DescribeUserProfileOutput) SetDisplayName(v string) *DescribeUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *DescribeUserProfileOutput) SetEmailAddress(v string) *DescribeUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DescribeUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *DescribeUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *DescribeUserProfileOutput) SetSshPublicKey(v string) *DescribeUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DescribeUserProfileOutput) SetUserArn(v string) *DescribeUserProfileOutput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMemberRequest
type DisassociateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS CodeStar project from which you want to remove a team member.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM user or group whom you want to
	// remove from the project.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTeamMemberInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *DisassociateTeamMemberInput) SetProjectId(v string) *DisassociateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DisassociateTeamMemberInput) SetUserArn(v string) *DisassociateTeamMemberInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/DisassociateTeamMemberResult
type DisassociateTeamMemberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTeamMemberOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjectsRequest
type ListProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of data that can be contained in a single set of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token to be used to return the next set of results, if the
	// results cannot be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListProjectsResult
type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of projects.
	//
	// Projects is a required field
	Projects []*ProjectSummary `locationName:"projects" type:"list" required:"true"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResourcesRequest
type ListResourcesInput struct {
	_ struct{} `type:"structure"`

	// he maximum amount of data that can be contained in a single set of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesInput) SetMaxResults(v int64) *ListResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesInput) SetNextToken(v string) *ListResourcesInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListResourcesInput) SetProjectId(v string) *ListResourcesInput {
	s.ProjectId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListResourcesResult
type ListResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An array of resources associated with the project.
	Resources []*Resource `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s ListResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesOutput) SetNextToken(v string) *ListResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListResourcesOutput) SetResources(v []*Resource) *ListResourcesOutput {
	s.Resources = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembersRequest
type ListTeamMembersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of team members you want returned in a response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The ID of the project for which you want to list team members.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTeamMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTeamMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTeamMembersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTeamMembersInput) SetMaxResults(v int64) *ListTeamMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTeamMembersInput) SetNextToken(v string) *ListTeamMembersInput {
	s.NextToken = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ListTeamMembersInput) SetProjectId(v string) *ListTeamMembersInput {
	s.ProjectId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListTeamMembersResult
type ListTeamMembersOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of team member objects for the project.
	//
	// TeamMembers is a required field
	TeamMembers []*TeamMember `locationName:"teamMembers" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTeamMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTeamMembersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTeamMembersOutput) SetNextToken(v string) *ListTeamMembersOutput {
	s.NextToken = &v
	return s
}

// SetTeamMembers sets the TeamMembers field's value.
func (s *ListTeamMembersOutput) SetTeamMembers(v []*TeamMember) *ListTeamMembersOutput {
	s.TeamMembers = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfilesRequest
type ListUserProfilesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The continuation token for the next set of results, if the results cannot
	// be returned in one response.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListUserProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUserProfilesInput) SetMaxResults(v int64) *ListUserProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserProfilesInput) SetNextToken(v string) *ListUserProfilesInput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ListUserProfilesResult
type ListUserProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The continuation token to use when requesting the next set of results, if
	// there are more results to be returned.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// All the user profiles configured in AWS CodeStar for an AWS account.
	//
	// UserProfiles is a required field
	UserProfiles []*UserProfileSummary `locationName:"userProfiles" type:"list" required:"true"`
}

// String returns the string representation
func (s ListUserProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUserProfilesOutput) SetNextToken(v string) *ListUserProfilesOutput {
	s.NextToken = &v
	return s
}

// SetUserProfiles sets the UserProfiles field's value.
func (s *ListUserProfilesOutput) SetUserProfiles(v []*UserProfileSummary) *ListUserProfilesOutput {
	s.UserProfiles = v
	return s
}

// Information about the metadata for a project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/ProjectSummary
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `locationName:"projectArn" type:"string"`

	// The ID of the project.
	ProjectId *string `locationName:"projectId" min:"2" type:"string"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ProjectSummary) SetProjectArn(v string) *ProjectSummary {
	s.ProjectArn = &v
	return s
}

// SetProjectId sets the ProjectId field's value.
func (s *ProjectSummary) SetProjectId(v string) *ProjectSummary {
	s.ProjectId = &v
	return s
}

// Information about a resource for a project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"11" type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// Information about a team member in a project.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/TeamMember
type TeamMember struct {
	_ struct{} `type:"structure"`

	// The role assigned to the user in the project. Project roles have different
	// levels of access. For more information, see Working with Teams (http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
	// in the AWS CodeStar User Guide.
	//
	// ProjectRole is a required field
	ProjectRole *string `locationName:"projectRole" type:"string" required:"true"`

	// Whether the user is allowed to remotely access project resources using an
	// SSH public/private key pair.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s TeamMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TeamMember) GoString() string {
	return s.String()
}

// SetProjectRole sets the ProjectRole field's value.
func (s *TeamMember) SetProjectRole(v string) *TeamMember {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *TeamMember) SetRemoteAccessAllowed(v bool) *TeamMember {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *TeamMember) SetUserArn(v string) *TeamMember {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProjectRequest
type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// The description of the project, if any.
	Description *string `locationName:"description" type:"string"`

	// The ID of the project you want to update.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"2" type:"string" required:"true"`

	// The name of the project you want to update.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 2))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateProjectInput) SetId(v string) *UpdateProjectInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateProjectInput) SetName(v string) *UpdateProjectInput {
	s.Name = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateProjectResult
type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMemberRequest
type UpdateTeamMemberInput struct {
	_ struct{} `type:"structure"`

	// The ID of the project.
	//
	// ProjectId is a required field
	ProjectId *string `locationName:"projectId" min:"2" type:"string" required:"true"`

	// The role assigned to the user in the project. Project roles have different
	// levels of access. For more information, see Working with Teams (http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
	// in the AWS CodeStar User Guide.
	ProjectRole *string `locationName:"projectRole" type:"string"`

	// Whether a team member is allowed to remotely access project resources using
	// the SSH public key associated with the user's profile. Even if this is set
	// to True, the user must associate a public key with their profile before the
	// user can access resources.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user for whom you want to change team
	// membership attributes.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTeamMemberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTeamMemberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTeamMemberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTeamMemberInput"}
	if s.ProjectId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectId"))
	}
	if s.ProjectId != nil && len(*s.ProjectId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectId", 2))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectId sets the ProjectId field's value.
func (s *UpdateTeamMemberInput) SetProjectId(v string) *UpdateTeamMemberInput {
	s.ProjectId = &v
	return s
}

// SetProjectRole sets the ProjectRole field's value.
func (s *UpdateTeamMemberInput) SetProjectRole(v string) *UpdateTeamMemberInput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *UpdateTeamMemberInput) SetRemoteAccessAllowed(v bool) *UpdateTeamMemberInput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateTeamMemberInput) SetUserArn(v string) *UpdateTeamMemberInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateTeamMemberResult
type UpdateTeamMemberOutput struct {
	_ struct{} `type:"structure"`

	// The project role granted to the user.
	ProjectRole *string `locationName:"projectRole" type:"string"`

	// Whether a team member is allowed to remotely access project resources using
	// the SSH public key associated with the user's profile.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user whose team membership attributes
	// were updated.
	UserArn *string `locationName:"userArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UpdateTeamMemberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTeamMemberOutput) GoString() string {
	return s.String()
}

// SetProjectRole sets the ProjectRole field's value.
func (s *UpdateTeamMemberOutput) SetProjectRole(v string) *UpdateTeamMemberOutput {
	s.ProjectRole = &v
	return s
}

// SetRemoteAccessAllowed sets the RemoteAccessAllowed field's value.
func (s *UpdateTeamMemberOutput) SetRemoteAccessAllowed(v bool) *UpdateTeamMemberOutput {
	s.RemoteAccessAllowed = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateTeamMemberOutput) SetUserArn(v string) *UpdateTeamMemberOutput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfileRequest
type UpdateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The name that will be displayed as the friendly name for the user in AWS
	// CodeStar.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserProfileInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 3))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}
	if s.UserArn != nil && len(*s.UserArn) < 32 {
		invalidParams.Add(request.NewErrParamMinLen("UserArn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateUserProfileInput) SetDisplayName(v string) *UpdateUserProfileInput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateUserProfileInput) SetEmailAddress(v string) *UpdateUserProfileInput {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateUserProfileInput) SetSshPublicKey(v string) *UpdateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateUserProfileInput) SetUserArn(v string) *UpdateUserProfileInput {
	s.UserArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UpdateUserProfileResult
type UpdateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date the user profile was created, in timestamp format.
	CreatedTimestamp *time.Time `locationName:"createdTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The name that is displayed as the friendly name for the user in AWS CodeStar.
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The email address that is displayed as part of the user's profile in AWS
	// CodeStar.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string"`

	// The date the user profile was last modified, in timestamp format.
	LastModifiedTimestamp *time.Time `locationName:"lastModifiedTimestamp" type:"timestamp" timestampFormat:"unix"`

	// The SSH public key associated with the user in AWS CodeStar. This is the
	// public portion of the public/private keypair the user can use to access project
	// resources if a project owner allows the user remote access to those resources.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *UpdateUserProfileOutput) SetCreatedTimestamp(v time.Time) *UpdateUserProfileOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateUserProfileOutput) SetDisplayName(v string) *UpdateUserProfileOutput {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateUserProfileOutput) SetEmailAddress(v string) *UpdateUserProfileOutput {
	s.EmailAddress = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *UpdateUserProfileOutput) SetLastModifiedTimestamp(v time.Time) *UpdateUserProfileOutput {
	s.LastModifiedTimestamp = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateUserProfileOutput) SetSshPublicKey(v string) *UpdateUserProfileOutput {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateUserProfileOutput) SetUserArn(v string) *UpdateUserProfileOutput {
	s.UserArn = &v
	return s
}

// Information about a user's profile in AWS CodeStar.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codestar-2017-04-19/UserProfileSummary
type UserProfileSummary struct {
	_ struct{} `type:"structure"`

	// The display name of a user in AWS CodeStar. For example, this could be set
	// to both first and last name ("Mary Major") or a single name ("Mary"). The
	// display name is also used to generate the initial icon associated with the
	// user in AWS CodeStar projects. If spaces are included in the display name,
	// the first character that appears after the space will be used as the second
	// character in the user initial icon. The initial icon displays a maximum of
	// two characters, so a display name with more than one space (for example "Mary
	// Jane Major") would generate an initial icon using the first character and
	// the first character after the space ("MJ", not "MM").
	DisplayName *string `locationName:"displayName" min:"1" type:"string"`

	// The email address associated with the user.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	UserArn *string `locationName:"userArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UserProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfileSummary) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *UserProfileSummary) SetDisplayName(v string) *UserProfileSummary {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UserProfileSummary) SetEmailAddress(v string) *UserProfileSummary {
	s.EmailAddress = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UserProfileSummary) SetSshPublicKey(v string) *UserProfileSummary {
	s.SshPublicKey = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UserProfileSummary) SetUserArn(v string) *UserProfileSummary {
	s.UserArn = &v
	return s
}
