// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package configservice provides the client and types for making API
// requests to AWS Config.
//
// AWS Config provides a way to keep track of the configurations of all the
// AWS resources associated with your AWS account. You can use AWS Config to
// get the current and historical configurations of each AWS resource and also
// to get information about the relationship between the resources. An AWS resource
// can be an Amazon Compute Cloud (Amazon EC2) instance, an Elastic Block Store
// (EBS) volume, an Elastic network Interface (ENI), or a security group. For
// a complete list of resources currently supported by AWS Config, see Supported
// AWS Resources (http://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
//
// You can access and manage AWS Config through the AWS Management Console,
// the AWS Command Line Interface (AWS CLI), the AWS Config API, or the AWS
// SDKs for AWS Config
//
// This reference guide contains documentation for the AWS Config API and the
// AWS CLI commands that you can use to manage AWS Config.
//
// The AWS Config API uses the Signature Version 4 protocol for signing requests.
// For more information about how to sign a request with this protocol, see
// Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// For detailed information about AWS Config features and their associated actions
// or commands, as well as how to work with AWS Management Console, see What
// Is AWS Config? (http://docs.aws.amazon.com/config/latest/developerguide/WhatIsConfig.html)
// in the AWS Config Developer Guide.
//
// See https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12 for more information on this service.
//
// See configservice package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/configservice/
//
// Using the Client
//
// To use the client for AWS Config you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := configservice.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the AWS Config client ConfigService for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/configservice/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.DeleteConfigRule(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("DeleteConfigRule result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.DeleteConfigRuleWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package configservice
