// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ec2"
)

var _ time.Duration
var _ bytes.Buffer
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To allocate an Elastic IP address for EC2-VPC
//
// This example allocates an Elastic IP address to use with an instance in a VPC.
func ExampleEC2_AllocateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AllocateAddressInput{
		Domain: aws.String("vpc"),
	}

	result, err := svc.AllocateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To allocate an Elastic IP address for EC2-Classic
//
// This example allocates an Elastic IP address to use with an instance in EC2-Classic.
func ExampleEC2_AllocateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AllocateAddressInput{}

	result, err := svc.AllocateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign a specific secondary private IP address to an interface
//
// This example assigns the specified secondary private IP address to the specified
// network interface.
func ExampleEC2_AssignPrivateIpAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []*string{
			aws.String("10.0.0.82"),
		},
	}

	result, err := svc.AssignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To assign secondary private IP addresses that Amazon EC2 selects to an interface
//
// This example assigns two secondary private IP addresses to the specified network
// interface. Amazon EC2 automatically assigns these IP addresses from the available
// IP addresses in the CIDR block range of the subnet the network interface is associated
// with.
func ExampleEC2_AssignPrivateIpAddresses_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId:             aws.String("eni-e5aa89a3"),
		SecondaryPrivateIpAddressCount: aws.Int64(2),
	}

	result, err := svc.AssignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-VPC
//
// This example associates the specified Elastic IP address with the specified instance
// in a VPC.
func ExampleEC2_AssociateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
		InstanceId:   aws.String("i-0b263919b6498b123"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address with a network interface
//
// This example associates the specified Elastic IP address with the specified network
// interface.
func ExampleEC2_AssociateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		AllocationId:       aws.String("eipalloc-64d5890a"),
		NetworkInterfaceId: aws.String("eni-1a2b3c4d"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate an Elastic IP address in EC2-Classic
//
// This example associates an Elastic IP address with an instance in EC2-Classic.
func ExampleEC2_AssociateAddress_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateAddressInput{
		InstanceId: aws.String("i-07ffe74c7330ebf53"),
		PublicIp:   aws.String("198.51.100.0"),
	}

	result, err := svc.AssociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a DHCP options set with a VPC
//
// This example associates the specified DHCP options set with the specified VPC.
func ExampleEC2_AssociateDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	result, err := svc.AssociateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate the default DHCP options set with a VPC
//
// This example associates the default DHCP options set with the specified VPC.
func ExampleEC2_AssociateDhcpOptions_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("default"),
		VpcId:         aws.String("vpc-a01106c2"),
	}

	result, err := svc.AssociateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a route table with a subnet
//
// This example associates the specified route table with the specified subnet.
func ExampleEC2_AssociateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AssociateRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
		SubnetId:     aws.String("subnet-9d4a7b6"),
	}

	result, err := svc.AssociateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach an Internet gateway to a VPC
//
// This example attaches the specified Internet gateway to the specified VPC.
func ExampleEC2_AttachInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	result, err := svc.AttachInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a network interface to an instance
//
// This example attaches the specified network interface to the specified instance.
func ExampleEC2_AttachNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachNetworkInterfaceInput{
		DeviceIndex:        aws.Int64(1),
		InstanceId:         aws.String("i-1234567890abcdef0"),
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	result, err := svc.AttachNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a volume to an instance
//
// This example attaches a volume (``vol-1234567890abcdef0``) to an instance (``i-01474ef662b89480``)
// as ``/dev/sdf``.
func ExampleEC2_AttachVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.AttachVolumeInput{
		Device:     aws.String("/dev/sdf"),
		InstanceId: aws.String("i-01474ef662b89480"),
		VolumeId:   aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.AttachVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request
//
// This example cancels the specified Spot fleet request and terminates its associated
// Spot Instances.
func ExampleEC2_CancelSpotFleetRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
		TerminateInstances: aws.Bool(true),
	}

	result, err := svc.CancelSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot fleet request without terminating its Spot Instances
//
// This example cancels the specified Spot fleet request without terminating its associated
// Spot Instances.
func ExampleEC2_CancelSpotFleetRequests_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
		TerminateInstances: aws.Bool(false),
	}

	result, err := svc.CancelSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel Spot Instance requests
//
// This example cancels a Spot Instance request.
func ExampleEC2_CancelSpotInstanceRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CancelSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []*string{
			aws.String("sir-08b93456"),
		},
	}

	result, err := svc.CancelSpotInstanceRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To confirm the product instance
//
// This example determines whether the specified product code is associated with the
// specified instance.
func ExampleEC2_ConfirmProductInstance_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ConfirmProductInstanceInput{
		InstanceId:  aws.String("i-1234567890abcdef0"),
		ProductCode: aws.String("774F4FF8"),
	}

	result, err := svc.ConfirmProductInstance(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To copy a snapshot
//
// This example copies a snapshot with the snapshot ID of ``snap-066877671789bd71b``
// from the ``us-west-2`` region to the ``us-east-1`` region and adds a short description
// to identify the snapshot.
func ExampleEC2_CopySnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CopySnapshotInput{
		Description:       aws.String("This is my copied snapshot."),
		DestinationRegion: aws.String("us-east-1"),
		SourceRegion:      aws.String("us-west-2"),
		SourceSnapshotId:  aws.String("snap-066877671789bd71b"),
	}

	result, err := svc.CopySnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a customer gateway
//
// This example creates a customer gateway with the specified IP address for its outside
// interface.
func ExampleEC2_CreateCustomerGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateCustomerGatewayInput{
		BgpAsn:   aws.Int64(65534),
		PublicIp: aws.String("12.1.2.3"),
		Type:     aws.String("ipsec.1"),
	}

	result, err := svc.CreateCustomerGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a DHCP options set
//
// This example creates a DHCP options set.
func ExampleEC2_CreateDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateDhcpOptionsInput{
		DhcpConfigurations: []*ec2.NewDhcpConfiguration{
			{
				Key: aws.String("domain-name-servers"),
				Values: []*string{
					aws.String("10.2.5.1"),
					aws.String("10.2.5.2"),
				},
			},
		},
	}

	result, err := svc.CreateDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Internet gateway
//
// This example creates an Internet gateway.
func ExampleEC2_CreateInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateInternetGatewayInput{}

	result, err := svc.CreateInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a key pair
//
// This example creates a key pair named my-key-pair.
func ExampleEC2_CreateKeyPair_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	result, err := svc.CreateKeyPair(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a NAT gateway
//
// This example creates a NAT gateway in subnet subnet-1a2b3c4d and associates an Elastic
// IP address with the allocation ID eipalloc-37fc1a52 with the NAT gateway.
func ExampleEC2_CreateNatGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNatGatewayInput{
		AllocationId: aws.String("eipalloc-37fc1a52"),
		SubnetId:     aws.String("subnet-1a2b3c4d"),
	}

	result, err := svc.CreateNatGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL
//
// This example creates a network ACL for the specified VPC.
func ExampleEC2_CreateNetworkAcl_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkAclInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateNetworkAcl(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network ACL entry
//
// This example creates an entry for the specified network ACL. The rule allows ingress
// traffic from anywhere (0.0.0.0/0) on UDP port 53 (DNS) into any associated subnet.
func ExampleEC2_CreateNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkAclEntryInput{
		CidrBlock:    aws.String("0.0.0.0/0"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("udp"),
		RuleAction: aws.String("allow"),
		RuleNumber: aws.Int64(100),
	}

	result, err := svc.CreateNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a network interface
//
// This example creates a network interface for the specified subnet.
func ExampleEC2_CreateNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateNetworkInterfaceInput{
		Description: aws.String("my network interface"),
		Groups: []*string{
			aws.String("sg-903004f8"),
		},
		PrivateIpAddress: aws.String("10.0.2.17"),
		SubnetId:         aws.String("subnet-9d4a7b6c"),
	}

	result, err := svc.CreateNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a placement group
//
// This example creates a placement group with the specified name.
func ExampleEC2_CreatePlacementGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreatePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
		Strategy:  aws.String("cluster"),
	}

	result, err := svc.CreatePlacementGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route
//
// This example creates a route for the specified route table. The route matches all
// traffic (0.0.0.0/0) and routes it to the specified Internet gateway.
func ExampleEC2_CreateRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		GatewayId:            aws.String("igw-c0a643a9"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.CreateRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a route table
//
// This example creates a route table for the specified VPC.
func ExampleEC2_CreateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateRouteTableInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a snapshot
//
// This example creates a snapshot of the volume with a volume ID of ``vol-1234567890abcdef0``
// and a short description to identify the snapshot.
func ExampleEC2_CreateSnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSnapshotInput{
		Description: aws.String("This is my root volume snapshot."),
		VolumeId:    aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.CreateSnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a Spot Instance datafeed
//
// This example creates a Spot Instance data feed for your AWS account.
func ExampleEC2_CreateSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSpotDatafeedSubscriptionInput{
		Bucket: aws.String("my-s3-bucket"),
		Prefix: aws.String("spotdata"),
	}

	result, err := svc.CreateSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a subnet
//
// This example creates a subnet in the specified VPC with the specified CIDR block.
// We recommend that you let us select an Availability Zone for you.
func ExampleEC2_CreateSubnet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateSubnetInput{
		CidrBlock: aws.String("10.0.1.0/24"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.CreateSubnet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To add a tag to a resource
//
// This example adds the tag Stack=production to the specified image, or overwrites
// an existing tag for the AMI where the tag key is Stack.
func ExampleEC2_CreateTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateTagsInput{
		Resources: []*string{
			aws.String("ami-78a54011"),
		},
		Tags: []*ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("production"),
			},
		},
	}

	result, err := svc.CreateTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new volume
//
// This example creates an 80 GiB General Purpose (SSD) volume in the Availability Zone
// ``us-east-1a``.
func ExampleEC2_CreateVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Size:             aws.Int64(80),
		VolumeType:       aws.String("gp2"),
	}

	result, err := svc.CreateVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a new Provisioned IOPS (SSD) volume from a snapshot
//
// This example creates a new Provisioned IOPS (SSD) volume with 1000 provisioned IOPS
// from a snapshot in the Availability Zone ``us-east-1a``.
func ExampleEC2_CreateVolume_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("us-east-1a"),
		Iops:             aws.Int64(1000),
		SnapshotId:       aws.String("snap-066877671789bd71b"),
		VolumeType:       aws.String("io1"),
	}

	result, err := svc.CreateVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a VPC
//
// This example creates a VPC with the specified CIDR block.
func ExampleEC2_CreateVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.CreateVpcInput{
		CidrBlock: aws.String("10.0.0.0/16"),
	}

	result, err := svc.CreateVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a customer gateway
//
// This example deletes the specified customer gateway.
func ExampleEC2_DeleteCustomerGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteCustomerGatewayInput{
		CustomerGatewayId: aws.String("cgw-0e11f167"),
	}

	result, err := svc.DeleteCustomerGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a DHCP options set
//
// This example deletes the specified DHCP options set.
func ExampleEC2_DeleteDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteDhcpOptionsInput{
		DhcpOptionsId: aws.String("dopt-d9070ebb"),
	}

	result, err := svc.DeleteDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an Internet gateway
//
// This example deletes the specified Internet gateway.
func ExampleEC2_DeleteInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
	}

	result, err := svc.DeleteInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a key pair
//
// This example deletes the specified key pair.
func ExampleEC2_DeleteKeyPair_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteKeyPairInput{
		KeyName: aws.String("my-key-pair"),
	}

	result, err := svc.DeleteKeyPair(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a NAT gateway
//
// This example deletes the specified NAT gateway.
func ExampleEC2_DeleteNatGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNatGatewayInput{
		NatGatewayId: aws.String("nat-04ae55e711cec5680"),
	}

	result, err := svc.DeleteNatGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL
//
// This example deletes the specified network ACL.
func ExampleEC2_DeleteNetworkAcl_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkAclInput{
		NetworkAclId: aws.String("acl-5fb85d36"),
	}

	result, err := svc.DeleteNetworkAcl(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network ACL entry
//
// This example deletes ingress rule number 100 from the specified network ACL.
func ExampleEC2_DeleteNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkAclEntryInput{
		Egress:       aws.Bool(true),
		NetworkAclId: aws.String("acl-5fb85d36"),
		RuleNumber:   aws.Int64(100),
	}

	result, err := svc.DeleteNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a network interface
//
// This example deletes the specified network interface.
func ExampleEC2_DeleteNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteNetworkInterfaceInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
	}

	result, err := svc.DeleteNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a placement group
//
// This example deletes the specified placement group.
//
func ExampleEC2_DeletePlacementGroup_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeletePlacementGroupInput{
		GroupName: aws.String("my-cluster"),
	}

	result, err := svc.DeletePlacementGroup(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route
//
// This example deletes the specified route from the specified route table.
func ExampleEC2_DeleteRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteRouteInput{
		DestinationCidrBlock: aws.String("0.0.0.0/0"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.DeleteRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a route table
//
// This example deletes the specified route table.
func ExampleEC2_DeleteRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteRouteTableInput{
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.DeleteRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a snapshot
//
// This example deletes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleEC2_DeleteSnapshot_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSnapshotInput{
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.DeleteSnapshot(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To cancel a Spot Instance data feed subscription
//
// This example deletes a Spot data feed subscription for the account.
func ExampleEC2_DeleteSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSpotDatafeedSubscriptionInput{}

	result, err := svc.DeleteSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a subnet
//
// This example deletes the specified subnet.
func ExampleEC2_DeleteSubnet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteSubnetInput{
		SubnetId: aws.String("subnet-9d4a7b6c"),
	}

	result, err := svc.DeleteSubnet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a tag from a resource
//
// This example deletes the tag Stack=test from the specified image.
func ExampleEC2_DeleteTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteTagsInput{
		Resources: []*string{
			aws.String("ami-78a54011"),
		},
		Tags: []*ec2.Tag{
			{
				Key:   aws.String("Stack"),
				Value: aws.String("test"),
			},
		},
	}

	result, err := svc.DeleteTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a volume
//
// This example deletes an available volume with the volume ID of ``vol-049df61146c4d7901``.
// If the command succeeds, no output is returned.
func ExampleEC2_DeleteVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteVolumeInput{
		VolumeId: aws.String("vol-049df61146c4d7901"),
	}

	result, err := svc.DeleteVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a VPC
//
// This example deletes the specified VPC.
func ExampleEC2_DeleteVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DeleteVpcInput{
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.DeleteVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a single attribute for your AWS account
//
// This example describes the supported-platforms attribute for your AWS account.
func ExampleEC2_DescribeAccountAttributes_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAccountAttributesInput{
		AttributeNames: []*string{
			aws.String("supported-platforms"),
		},
	}

	result, err := svc.DescribeAccountAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all attributes for your AWS account
//
// This example describes the attributes for your AWS account.
func ExampleEC2_DescribeAccountAttributes_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAccountAttributesInput{}

	result, err := svc.DescribeAccountAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses
//
// This example describes your Elastic IP addresses.
func ExampleEC2_DescribeAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-VPC
//
// This example describes your Elastic IP addresses for use with instances in a VPC.
func ExampleEC2_DescribeAddresses_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []*string{
					aws.String("vpc"),
				},
			},
		},
	}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Elastic IP addresses for EC2-Classic
//
// This example describes your Elastic IP addresses for use with instances in EC2-Classic.
func ExampleEC2_DescribeAddresses_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAddressesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("domain"),
				Values: []*string{
					aws.String("standard"),
				},
			},
		},
	}

	result, err := svc.DescribeAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Availability Zones
//
// This example describes the Availability Zones that are available to you. The response
// includes Availability Zones only for the current region.
func ExampleEC2_DescribeAvailabilityZones_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeAvailabilityZonesInput{}

	result, err := svc.DescribeAvailabilityZones(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a customer gateway
//
// This example describes the specified customer gateway.
func ExampleEC2_DescribeCustomerGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeCustomerGatewaysInput{
		CustomerGatewayIds: []*string{
			aws.String("cgw-0e11f167"),
		},
	}

	result, err := svc.DescribeCustomerGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a DHCP options set
//
// This example describes the specified DHCP options set.
func ExampleEC2_DescribeDhcpOptions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeDhcpOptionsInput{
		DhcpOptionsIds: []*string{
			aws.String("dopt-d9070ebb"),
		},
	}

	result, err := svc.DescribeDhcpOptions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the instance type
//
// This example describes the instance type of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("instanceType"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the disableApiTermination attribute
//
// This example describes the ``disableApiTermination`` attribute of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("disableApiTermination"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the block device mapping for an instance
//
// This example describes the ``blockDeviceMapping`` attribute of the specified instance.
//
func ExampleEC2_DescribeInstanceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("blockDeviceMapping"),
		InstanceId: aws.String("i-1234567890abcdef0"),
	}

	result, err := svc.DescribeInstanceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Internet gateway for a VPC
//
// This example describes the Internet gateway for the specified VPC.
func ExampleEC2_DescribeInternetGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeInternetGatewaysInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("attachment.vpc-id"),
				Values: []*string{
					aws.String("vpc-a01106c2"),
				},
			},
		},
	}

	result, err := svc.DescribeInternetGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To display a key pair
//
// This example displays the fingerprint for the specified key.
func ExampleEC2_DescribeKeyPairs_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeKeyPairsInput{
		KeyNames: []*string{
			aws.String("my-key-pair"),
		},
	}

	result, err := svc.DescribeKeyPairs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your moving addresses
//
// This example describes all of your moving Elastic IP addresses.
func ExampleEC2_DescribeMovingAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeMovingAddressesInput{}

	result, err := svc.DescribeMovingAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a NAT gateway
//
// This example describes the NAT gateway for the specified VPC.
func ExampleEC2_DescribeNatGateways_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNatGatewaysInput{
		Filter: []*ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []*string{
					aws.String("vpc-1a2b3c4d"),
				},
			},
		},
	}

	result, err := svc.DescribeNatGateways(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network ACL
//
// This example describes the specified network ACL.
func ExampleEC2_DescribeNetworkAcls_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkAclsInput{
		NetworkAclIds: []*string{
			aws.String("acl-5fb85d36"),
		},
	}

	result, err := svc.DescribeNetworkAcls(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the attachment attribute of a network interface
//
// This example describes the attachment attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("attachment"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the description attribute of a network interface
//
// This example describes the description attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("description"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the groupSet attribute of a network interface
//
// This example describes the groupSet attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("groupSet"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the sourceDestCheck attribute of a network interface
//
// This example describes the sourceDestCheck attribute of the specified network interface.
func ExampleEC2_DescribeNetworkInterfaceAttribute_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfaceAttributeInput{
		Attribute:          aws.String("sourceDestCheck"),
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.DescribeNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a network interface
//

func ExampleEC2_DescribeNetworkInterfaces_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeNetworkInterfacesInput{
		NetworkInterfaceIds: []*string{
			aws.String("eni-e5aa89a3"),
		},
	}

	result, err := svc.DescribeNetworkInterfaces(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your regions
//
// This example describes all the regions that are available to you.
func ExampleEC2_DescribeRegions_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeRegionsInput{}

	result, err := svc.DescribeRegions(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a route table
//
// This example describes the specified route table.
func ExampleEC2_DescribeRouteTables_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeRouteTablesInput{
		RouteTableIds: []*string{
			aws.String("rtb-1f382e7d"),
		},
	}

	result, err := svc.DescribeRouteTables(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe an available schedule
//
// This example describes a schedule that occurs every week on Sunday, starting on the
// specified date. Note that the output contains a single schedule as an example.
func ExampleEC2_DescribeScheduledInstanceAvailability_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeScheduledInstanceAvailabilityInput{
		FirstSlotStartTimeRange: &ec2.SlotDateTimeRangeRequest{
			EarliestTime: parseTime("2006-01-02T15:04:05Z", "2016-01-31T00:00:00Z"),
			LatestTime:   parseTime("2006-01-02T15:04:05Z", "2016-01-31T04:00:00Z"),
		},
		Recurrence: &ec2.ScheduledInstanceRecurrenceRequest{
			Frequency: aws.String("Weekly"),
			Interval:  aws.Int64(1),
			OccurrenceDays: []*int64{
				aws.Int64(1),
			},
		},
	}

	result, err := svc.DescribeScheduledInstanceAvailability(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe your Scheduled Instances
//
// This example describes the specified Scheduled Instance.
func ExampleEC2_DescribeScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeScheduledInstancesInput{
		ScheduledInstanceIds: []*string{
			aws.String("sci-1234-1234-1234-1234-123456789012"),
		},
	}

	result, err := svc.DescribeScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshot attributes
//
// This example describes the ``createVolumePermission`` attribute on a snapshot with
// the snapshot ID of ``snap-066877671789bd71b``.
func ExampleEC2_DescribeSnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotAttributeInput{
		Attribute:  aws.String("createVolumePermission"),
		SnapshotId: aws.String("snap-066877671789bd71b"),
	}

	result, err := svc.DescribeSnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a snapshot
//
// This example describes a snapshot with the snapshot ID of ``snap-1234567890abcdef0``.
func ExampleEC2_DescribeSnapshots_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotsInput{
		SnapshotIds: []*string{
			aws.String("snap-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeSnapshots(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe snapshots using filters
//
// This example describes all snapshots owned by the ID 012345678910 that are in the
// ``pending`` status.
func ExampleEC2_DescribeSnapshots_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSnapshotsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("status"),
				Values: []*string{
					aws.String("pending"),
				},
			},
		},
		OwnerIds: []*string{
			aws.String("012345678910"),
		},
	}

	result, err := svc.DescribeSnapshots(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the datafeed for your AWS account
//
// This example describes the Spot Instance datafeed subscription for your AWS account.
func ExampleEC2_DescribeSpotDatafeedSubscription_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotDatafeedSubscriptionInput{}

	result, err := svc.DescribeSpotDatafeedSubscription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the Spot Instances associated with a Spot fleet
//
// This example lists the Spot Instances associated with the specified Spot fleet.
func ExampleEC2_DescribeSpotFleetInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetInstancesInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
	}

	result, err := svc.DescribeSpotFleetInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot fleet history
//
// This example returns the history for the specified Spot fleet starting at the specified
// time.
func ExampleEC2_DescribeSpotFleetRequestHistory_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetRequestHistoryInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		StartTime:          parseTime("2006-01-02T15:04:05Z", "2015-05-26T00:00:00Z"),
	}

	result, err := svc.DescribeSpotFleetRequestHistory(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot fleet request
//
// This example describes the specified Spot fleet request.
func ExampleEC2_DescribeSpotFleetRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{
			aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		},
	}

	result, err := svc.DescribeSpotFleetRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a Spot Instance request
//
// This example describes the specified Spot Instance request.
func ExampleEC2_DescribeSpotInstanceRequests_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []*string{
			aws.String("sir-08b93456"),
		},
	}

	result, err := svc.DescribeSpotInstanceRequests(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe Spot price history for Linux/UNIX (Amazon VPC)
//
// This example returns the Spot Price history for m1.xlarge, Linux/UNIX (Amazon VPC)
// instances for a particular day in January.
func ExampleEC2_DescribeSpotPriceHistory_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSpotPriceHistoryInput{
		EndTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T08:09:10"),
		InstanceTypes: []*string{
			aws.String("m1.xlarge"),
		},
		ProductDescriptions: []*string{
			aws.String("Linux/UNIX (Amazon VPC)"),
		},
		StartTime: parseTime("2006-01-02T15:04:05Z", "2014-01-06T07:08:09"),
	}

	result, err := svc.DescribeSpotPriceHistory(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the subnets for a VPC
//
// This example describes the subnets for the specified VPC.
func ExampleEC2_DescribeSubnets_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeSubnetsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("vpc-id"),
				Values: []*string{
					aws.String("vpc-a01106c2"),
				},
			},
		},
	}

	result, err := svc.DescribeSubnets(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags for a single resource
//
// This example describes the tags for the specified instance.
func ExampleEC2_DescribeTags_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeTagsInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("resource-id"),
				Values: []*string{
					aws.String("i-1234567890abcdef8"),
				},
			},
		},
	}

	result, err := svc.DescribeTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a volume attribute
//
// This example describes the ``autoEnableIo`` attribute of the volume with the ID ``vol-049df61146c4d7901``.
func ExampleEC2_DescribeVolumeAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeAttributeInput{
		Attribute: aws.String("autoEnableIO"),
		VolumeId:  aws.String("vol-049df61146c4d7901"),
	}

	result, err := svc.DescribeVolumeAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of a single volume
//
// This example describes the status for the volume ``vol-1234567890abcdef0``.
func ExampleEC2_DescribeVolumeStatus_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeStatusInput{
		VolumeIds: []*string{
			aws.String("vol-1234567890abcdef0"),
		},
	}

	result, err := svc.DescribeVolumeStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the status of impaired volumes
//
// This example describes the status for all volumes that are impaired. In this example
// output, there are no impaired volumes.
func ExampleEC2_DescribeVolumeStatus_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumeStatusInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("volume-status.status"),
				Values: []*string{
					aws.String("impaired"),
				},
			},
		},
	}

	result, err := svc.DescribeVolumeStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe all volumes
//
// This example describes all of your volumes in the default region.
func ExampleEC2_DescribeVolumes_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumesInput{}

	result, err := svc.DescribeVolumes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe volumes that are attached to a specific instance
//
// This example describes all volumes that are both attached to the instance with the
// ID i-1234567890abcdef0 and set to delete when the instance terminates.
func ExampleEC2_DescribeVolumes_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVolumesInput{
		Filters: []*ec2.Filter{
			{
				Name: aws.String("attachment.instance-id"),
				Values: []*string{
					aws.String("i-1234567890abcdef0"),
				},
			},
			{
				Name: aws.String("attachment.delete-on-termination"),
				Values: []*string{
					aws.String("true"),
				},
			},
		},
	}

	result, err := svc.DescribeVolumes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsSupport attribute
//
// This example describes the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for your instances to their corresponding IP addresses;
// otherwise, it does not.
func ExampleEC2_DescribeVpcAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: aws.String("enableDnsSupport"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.DescribeVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the enableDnsHostnames attribute
//
// This example describes the enableDnsHostnames attribute. This attribute indicates
// whether the instances launched in the VPC get DNS hostnames. If this attribute is
// true, instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleEC2_DescribeVpcAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcAttributeInput{
		Attribute: aws.String("enableDnsHostnames"),
		VpcId:     aws.String("vpc-a01106c2"),
	}

	result, err := svc.DescribeVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a VPC
//
// This example describes the specified VPC.
func ExampleEC2_DescribeVpcs_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DescribeVpcsInput{
		VpcIds: []*string{
			aws.String("vpc-a01106c2"),
		},
	}

	result, err := svc.DescribeVpcs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach an Internet gateway from a VPC
//
// This example detaches the specified Internet gateway from the specified VPC.
func ExampleEC2_DetachInternetGateway_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachInternetGatewayInput{
		InternetGatewayId: aws.String("igw-c0a643a9"),
		VpcId:             aws.String("vpc-a01106c2"),
	}

	result, err := svc.DetachInternetGateway(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a network interface from an instance
//
// This example detaches the specified network interface from its attached instance.
func ExampleEC2_DetachNetworkInterface_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachNetworkInterfaceInput{
		AttachmentId: aws.String("eni-attach-66c4350a"),
	}

	result, err := svc.DetachNetworkInterface(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To detach a volume from an instance
//
// This example detaches the volume (``vol-049df61146c4d7901``) from the instance it
// is attached to.
func ExampleEC2_DetachVolume_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DetachVolumeInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.DetachVolume(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable route propagation
//
// This example disables the specified virtual private gateway from propagating static
// routes to the specified route table.
func ExampleEC2_DisableVgwRoutePropagation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.DisableVgwRoutePropagation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP address in EC2-VPC
//
// This example disassociates an Elastic IP address from an instance in a VPC.
func ExampleEC2_DisassociateAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateAddressInput{
		AssociationId: aws.String("eipassoc-2bebb745"),
	}

	result, err := svc.DisassociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate an Elastic IP addresses in EC2-Classic
//
// This example disassociates an Elastic IP address from an instance in EC2-Classic.
func ExampleEC2_DisassociateAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.DisassociateAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disassociate a route table
//
// This example disassociates the specified route table from its associated subnet.
func ExampleEC2_DisassociateRouteTable_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.DisassociateRouteTableInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
	}

	result, err := svc.DisassociateRouteTable(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable route propagation
//
// This example enables the specified virtual private gateway to propagate static routes
// to the specified route table.
func ExampleEC2_EnableVgwRoutePropagation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.EnableVgwRoutePropagationInput{
		GatewayId:    aws.String("vgw-9a4cacf3"),
		RouteTableId: aws.String("rtb-22574640"),
	}

	result, err := svc.EnableVgwRoutePropagation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable I/O for a volume
//
// This example enables I/O on volume ``vol-1234567890abcdef0``.
func ExampleEC2_EnableVolumeIO_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.EnableVolumeIOInput{
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.EnableVolumeIO(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the attachment attribute of a network interface
//
// This example modifies the attachment attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Attachment: &ec2.NetworkInterfaceAttachmentChanges{
			AttachmentId:        aws.String("eni-attach-43348162"),
			DeleteOnTermination: aws.Bool(false),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the description attribute of a network interface
//
// This example modifies the description attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Description: &ec2.AttributeValue{
			Value: aws.String("My description"),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the groupSet attribute of a network interface
//
// This example command modifies the groupSet attribute of the specified network interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		Groups: []*string{
			aws.String("sg-903004f8"),
			aws.String("sg-1a2b3c4d"),
		},
		NetworkInterfaceId: aws.String("eni-686ea200"),
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the sourceDestCheck attribute of a network interface
//
// This example command modifies the sourceDestCheck attribute of the specified network
// interface.
func ExampleEC2_ModifyNetworkInterfaceAttribute_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("eni-686ea200"),
		SourceDestCheck: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
	}

	result, err := svc.ModifyNetworkInterfaceAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a snapshot attribute
//
// This example modifies snapshot ``snap-1234567890abcdef0`` to remove the create volume
// permission for a user with the account ID ``123456789012``. If the command succeeds,
// no output is returned.
func ExampleEC2_ModifySnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute:     aws.String("createVolumePermission"),
		OperationType: aws.String("remove"),
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
		UserIds: []*string{
			aws.String("123456789012"),
		},
	}

	result, err := svc.ModifySnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To make a snapshot public
//
// This example makes the snapshot ``snap-1234567890abcdef0`` public.
func ExampleEC2_ModifySnapshotAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySnapshotAttributeInput{
		Attribute: aws.String("createVolumePermission"),
		GroupNames: []*string{
			aws.String("all"),
		},
		OperationType: aws.String("add"),
		SnapshotId:    aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.ModifySnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To increase the target capacity of a Spot fleet request
//
// This example increases the target capacity of the specified Spot fleet request.
func ExampleEC2_ModifySpotFleetRequest_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySpotFleetRequestInput{
		SpotFleetRequestId: aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:     aws.Int64(20),
	}

	result, err := svc.ModifySpotFleetRequest(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To decrease the target capacity of a Spot fleet request
//
// This example decreases the target capacity of the specified Spot fleet request without
// terminating any Spot Instances as a result.
func ExampleEC2_ModifySpotFleetRequest_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySpotFleetRequestInput{
		ExcessCapacityTerminationPolicy: aws.String("NoTermination "),
		SpotFleetRequestId:              aws.String("sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"),
		TargetCapacity:                  aws.Int64(10),
	}

	result, err := svc.ModifySpotFleetRequest(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change a subnet's public IP addressing behavior
//
// This example modifies the specified subnet so that all instances launched into this
// subnet are assigned a public IP address.
func ExampleEC2_ModifySubnetAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifySubnetAttributeInput{
		MapPublicIpOnLaunch: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		SubnetId: aws.String("subnet-1a2b3c4d"),
	}

	result, err := svc.ModifySubnetAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a volume attribute
//
// This example sets the ``autoEnableIo`` attribute of the volume with the ID ``vol-1234567890abcdef0``
// to ``true``. If the command succeeds, no output is returned.
func ExampleEC2_ModifyVolumeAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVolumeAttributeInput{
		AutoEnableIO: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		DryRun:   aws.Bool(true),
		VolumeId: aws.String("vol-1234567890abcdef0"),
	}

	result, err := svc.ModifyVolumeAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsSupport attribute
//
// This example modifies the enableDnsSupport attribute. This attribute indicates whether
// DNS resolution is enabled for the VPC. If this attribute is true, the Amazon DNS
// server resolves DNS hostnames for instances in the VPC to their corresponding IP
// addresses; otherwise, it does not.
func ExampleEC2_ModifyVpcAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.ModifyVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the enableDnsHostnames attribute
//
// This example modifies the enableDnsHostnames attribute. This attribute indicates
// whether instances launched in the VPC get DNS hostnames. If this attribute is true,
// instances in the VPC get DNS hostnames; otherwise, they do not.
func ExampleEC2_ModifyVpcAttribute_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ModifyVpcAttributeInput{
		EnableDnsHostnames: &ec2.AttributeBooleanValue{
			Value: aws.Bool(false),
		},
		VpcId: aws.String("vpc-a01106c2"),
	}

	result, err := svc.ModifyVpcAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To move an address to EC2-VPC
//
// This example moves the specified Elastic IP address to the EC2-VPC platform.
func ExampleEC2_MoveAddressToVpc_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.MoveAddressToVpcInput{
		PublicIp: aws.String("54.123.4.56"),
	}

	result, err := svc.MoveAddressToVpc(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To purchase a Scheduled Instance
//
// This example purchases a Scheduled Instance.
func ExampleEC2_PurchaseScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.PurchaseScheduledInstancesInput{
		PurchaseRequests: []*ec2.PurchaseRequest{
			{
				InstanceCount: aws.Int64(1),
				PurchaseToken: aws.String("eyJ2IjoiMSIsInMiOjEsImMiOi..."),
			},
		},
	}

	result, err := svc.PurchaseScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP address for EC2-VPC
//
// This example releases an Elastic IP address for use with instances in a VPC.
func ExampleEC2_ReleaseAddress_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReleaseAddressInput{
		AllocationId: aws.String("eipalloc-64d5890a"),
	}

	result, err := svc.ReleaseAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To release an Elastic IP addresses for EC2-Classic
//
// This example releases an Elastic IP address for use with instances in EC2-Classic.
func ExampleEC2_ReleaseAddress_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.ReleaseAddressInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.ReleaseAddress(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the network ACL associated with a subnet
//
// This example associates the specified network ACL with the subnet for the specified
// network ACL association.
func ExampleEC2_ReplaceNetworkAclAssociation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceNetworkAclAssociationInput{
		AssociationId: aws.String("aclassoc-e5b95c8c"),
		NetworkAclId:  aws.String("acl-5fb85d36"),
	}

	result, err := svc.ReplaceNetworkAclAssociation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a network ACL entry
//
// This example replaces an entry for the specified network ACL. The new rule 100 allows
// ingress traffic from 203.0.113.12/24 on UDP port 53 (DNS) into any associated subnet.
func ExampleEC2_ReplaceNetworkAclEntry_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceNetworkAclEntryInput{
		CidrBlock:    aws.String("203.0.113.12/24"),
		Egress:       aws.Bool(false),
		NetworkAclId: aws.String("acl-5fb85d36"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(53),
			To:   aws.Int64(53),
		},
		Protocol:   aws.String("udp"),
		RuleAction: aws.String("allow"),
		RuleNumber: aws.Int64(100),
	}

	result, err := svc.ReplaceNetworkAclEntry(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace a route
//
// This example replaces the specified route in the specified table table. The new route
// matches the specified CIDR and sends the traffic to the specified virtual private
// gateway.
func ExampleEC2_ReplaceRoute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceRouteInput{
		DestinationCidrBlock: aws.String("10.0.0.0/16"),
		GatewayId:            aws.String("vgw-9a4cacf3"),
		RouteTableId:         aws.String("rtb-22574640"),
	}

	result, err := svc.ReplaceRoute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replace the route table associated with a subnet
//
// This example associates the specified route table with the subnet for the specified
// route table association.
func ExampleEC2_ReplaceRouteTableAssociation_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ReplaceRouteTableAssociationInput{
		AssociationId: aws.String("rtbassoc-781d0d1a"),
		RouteTableId:  aws.String("rtb-22574640"),
	}

	result, err := svc.ReplaceRouteTableAssociation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the subnet with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by subnet. The Spot fleet launches the instances in the specified subnet with
// the lowest price. If the instances are launched in a default VPC, they receive a
// public IP address by default. If the instances are launched in a nondefault VPC,
// they do not receive a public IP address by default. Note that you can't specify different
// subnets from the same Availability Zone in a Spot fleet request.
func ExampleEC2_RequestSpotFleet_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					SecurityGroups: []*ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
					SubnetId: aws.String("subnet-1a2b3c4d, subnet-3c4d5e6f"),
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet in the Availability Zone with the lowest price
//
// This example creates a Spot fleet request with two launch specifications that differ
// only by Availability Zone. The Spot fleet launches the instances in the specified
// Availability Zone with the lowest price. If your account supports EC2-VPC only, Amazon
// EC2 launches the Spot instances in the default subnet of the Availability Zone. If
// your account supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic
// in the Availability Zone.
func ExampleEC2_RequestSpotFleet_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					SecurityGroups: []*ec2.GroupIdentifier{
						{
							GroupId: aws.String("sg-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch Spot instances in a subnet and assign them public IP addresses
//
// This example assigns public addresses to instances launched in a nondefault VPC.
// Note that when you specify a network interface, you must include the subnet ID and
// security group ID using the network interface.
func ExampleEC2_RequestSpotFleet_shared02() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			IamFleetRole: aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.medium"),
					KeyName:      aws.String("my-key-pair"),
					NetworkInterfaces: []*ec2.InstanceNetworkInterfaceSpecification{
						{
							AssociatePublicIpAddress: aws.Bool(true),
							DeviceIndex:              aws.Int64(0),
							Groups: []*string{
								aws.String("sg-1a2b3c4d"),
							},
							SubnetId: aws.String("subnet-1a2b3c4d"),
						},
					},
				},
			},
			SpotPrice:      aws.String("0.04"),
			TargetCapacity: aws.Int64(2),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To request a Spot fleet using the diversified allocation strategy
//
// This example creates a Spot fleet request that launches 30 instances using the diversified
// allocation strategy. The launch specifications differ by instance type. The Spot
// fleet distributes the instances across the launch specifications such that there
// are 10 instances of each type.
func ExampleEC2_RequestSpotFleet_shared03() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{
			AllocationStrategy: aws.String("diversified"),
			IamFleetRole:       aws.String("arn:aws:iam::123456789012:role/my-spot-fleet-role"),
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("c4.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("m3.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
				{
					ImageId:      aws.String("ami-1a2b3c4d"),
					InstanceType: aws.String("r3.2xlarge"),
					SubnetId:     aws.String("subnet-1a2b3c4d"),
				},
			},
			SpotPrice:      aws.String("0.70"),
			TargetCapacity: aws.Int64(30),
		},
	}

	result, err := svc.RequestSpotFleet(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example creates a one-time Spot Instance request for five instances in the specified
// Availability Zone. If your account supports EC2-VPC only, Amazon EC2 launches the
// instances in the default subnet of the specified Availability Zone. If your account
// supports EC2-Classic, Amazon EC2 launches the instances in EC2-Classic in the specified
// Availability Zone.
func ExampleEC2_RequestSpotInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: aws.String("m3.medium"),
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.SpotPlacement{
				AvailabilityZone: aws.String("us-west-2a"),
			},
			SecurityGroupIds: []*string{
				aws.String("sg-1a2b3c4d"),
			},
		},
		SpotPrice: aws.String("0.03"),
		Type:      aws.String("one-time"),
	}

	result, err := svc.RequestSpotInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a one-time Spot Instance request
//
// This example command creates a one-time Spot Instance request for five instances
// in the specified subnet. Amazon EC2 launches the instances in the specified subnet.
// If the VPC is a nondefault VPC, the instances do not receive a public IP address
// by default.
func ExampleEC2_RequestSpotInstances_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RequestSpotInstancesInput{
		InstanceCount: aws.Int64(5),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn: aws.String("arn:aws:iam::123456789012:instance-profile/my-iam-role"),
			},
			ImageId:      aws.String("ami-1a2b3c4d"),
			InstanceType: aws.String("m3.medium"),
			SecurityGroupIds: []*string{
				aws.String("sg-1a2b3c4d"),
			},
			SubnetId: aws.String("subnet-1a2b3c4d"),
		},
		SpotPrice: aws.String("0.050"),
		Type:      aws.String("one-time"),
	}

	result, err := svc.RequestSpotInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reset a snapshot attribute
//
// This example resets the create volume permissions for snapshot ``snap-1234567890abcdef0``.
// If the command succeeds, no output is returned.
func ExampleEC2_ResetSnapshotAttribute_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.ResetSnapshotAttributeInput{
		Attribute:  aws.String("createVolumePermission"),
		SnapshotId: aws.String("snap-1234567890abcdef0"),
	}

	result, err := svc.ResetSnapshotAttribute(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To restore an address to EC2-Classic
//
// This example restores the specified Elastic IP address to the EC2-Classic platform.
func ExampleEC2_RestoreAddressToClassic_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RestoreAddressToClassicInput{
		PublicIp: aws.String("198.51.100.0"),
	}

	result, err := svc.RestoreAddressToClassic(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in a VPC
//
// This example launches the specified Scheduled Instance in a VPC.
func ExampleEC2_RunScheduledInstances_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			NetworkInterfaces: []*ec2.ScheduledInstancesNetworkInterface{
				{
					AssociatePublicIpAddress: aws.Bool(true),
					DeviceIndex:              aws.Int64(0),
					Groups: []*string{
						aws.String("sg-12345678"),
					},
					SubnetId: aws.String("subnet-12345678"),
				},
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	result, err := svc.RunScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To launch a Scheduled Instance in EC2-Classic
//
// This example launches the specified Scheduled Instance in EC2-Classic.
func ExampleEC2_RunScheduledInstances_shared01() {
	svc := ec2.New(session.New())
	input := &ec2.RunScheduledInstancesInput{
		InstanceCount: aws.Int64(1),
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Name: aws.String("my-iam-role"),
			},
			ImageId:      aws.String("ami-12345678"),
			InstanceType: aws.String("c4.large"),
			KeyName:      aws.String("my-key-pair"),
			Placement: &ec2.ScheduledInstancesPlacement{
				AvailabilityZone: aws.String("us-west-2b"),
			},
			SecurityGroupIds: []*string{
				aws.String("sg-12345678"),
			},
		},
		ScheduledInstanceId: aws.String("sci-1234-1234-1234-1234-123456789012"),
	}

	result, err := svc.RunScheduledInstances(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To unassign a secondary private IP address from a network interface
//
// This example unassigns the specified private IP address from the specified network
// interface.
func ExampleEC2_UnassignPrivateIpAddresses_shared00() {
	svc := ec2.New(session.New())
	input := &ec2.UnassignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("eni-e5aa89a3"),
		PrivateIpAddresses: []*string{
			aws.String("10.0.0.82"),
		},
	}

	result, err := svc.UnassignPrivateIpAddresses(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
