// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package elb provides the client and types for making API
// requests to Elastic Load Balancing.
//
// A load balancer distributes incoming traffic across your EC2 instances. This
// enables you to increase the availability of your application. The load balancer
// also monitors the health of its registered instances and ensures that it
// routes traffic only to healthy instances. You configure your load balancer
// to accept incoming traffic by specifying one or more listeners, which are
// configured with a protocol and port number for connections from clients to
// the load balancer and a protocol and port number for connections from the
// load balancer to the instances.
//
// Elastic Load Balancing supports two types of load balancers: Classic Load
// Balancers and Application Load Balancers (new). A Classic Load Balancer makes
// routing and load balancing decisions either at the transport layer (TCP/SSL)
// or the application layer (HTTP/HTTPS), and supports either EC2-Classic or
// a VPC. An Application Load Balancer makes routing and load balancing decisions
// at the application layer (HTTP/HTTPS), supports path-based routing, and can
// route requests to one or more ports on each EC2 instance or container instance
// in your virtual private cloud (VPC). For more information, see the Elastic
// Load Balancing User Guide (http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/what-is-load-balancing.html).
//
// This reference covers the 2012-06-01 API, which supports Classic Load Balancers.
// The 2015-12-01 API supports Application Load Balancers.
//
// To get started, create a load balancer with one or more listeners using CreateLoadBalancer.
// Register your instances with the load balancer using RegisterInstancesWithLoadBalancer.
//
// All Elastic Load Balancing operations are idempotent, which means that they
// complete at most one time. If you repeat an operation, it succeeds with a
// 200 OK response code.
//
// See https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01 for more information on this service.
//
// See elb package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/elb/
//
// Using the Client
//
// To use the client for Elastic Load Balancing you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := elb.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Elastic Load Balancing client ELB for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/elb/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.AddTags(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("AddTags result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.AddTagsWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package elb
