// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package rds provides the client and types for making API
// requests to Amazon Relational Database Service.
//
// Amazon Relational Database Service (Amazon RDS) is a web service that makes
// it easier to set up, operate, and scale a relational database in the cloud.
// It provides cost-efficient, resizable capacity for an industry-standard relational
// database and manages common database administration tasks, freeing up developers
// to focus on what makes their applications and businesses unique.
//
// Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL,
// Microsoft SQL Server, Oracle, or Amazon Aurora database server. These capabilities
// mean that the code, applications, and tools you already use today with your
// existing databases work with Amazon RDS without modification. Amazon RDS
// automatically backs up your database and maintains the database software
// that powers your DB instance. Amazon RDS is flexible: you can scale your
// database instance's compute resources and storage capacity to meet your application's
// demand. As with all Amazon Web Services, there are no up-front investments,
// and you pay only for the resources you use.
//
// This interface reference for Amazon RDS contains documentation for a programming
// or command line interface you can use to manage Amazon RDS. Note that Amazon
// RDS is asynchronous, which means that some interfaces might require techniques
// such as polling or callback functions to determine when a command has been
// applied. In this reference, the parameter descriptions indicate whether a
// command is applied immediately, on the next instance reboot, or during the
// maintenance window. The reference structure is as follows, and we list following
// some related topics from the user guide.
//
// Amazon RDS API Reference
//
//    * For the alphabetical list of API actions, see API Actions (http://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Operations.html).
//
//    * For the alphabetical list of data types, see Data Types (http://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Types.html).
//
//    * For a list of common query parameters, see Common Parameters (http://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonParameters.html).
//
//    * For descriptions of the error codes, see Common Errors (http://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonErrors.html).
//
// Amazon RDS User Guide
//
//    * For a summary of the Amazon RDS interfaces, see Available RDS Interfaces
//    (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces).
//
//    * For more information about how to use the Query API, see Using the Query
//    API (http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Using_the_Query_API.html).
//
// See https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31 for more information on this service.
//
// See rds package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/rds/
//
// Using the Client
//
// To use the client for Amazon Relational Database Service you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := rds.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon Relational Database Service client RDS for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/rds/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.AddRoleToDBCluster(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("AddRoleToDBCluster result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.AddRoleToDBClusterWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package rds
