// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package redshift provides the client and types for making API
// requests to Amazon Redshift.
//
// Overview
//
// This is an interface reference for Amazon Redshift. It contains documentation
// for one of the programming or command line interfaces you can use to manage
// Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which
// means that some interfaces may require techniques, such as polling or asynchronous
// callback handlers, to determine when a command has been applied. In this
// reference, the parameter descriptions indicate whether a change is applied
// immediately, on the next instance reboot, or during the next maintenance
// window. For a summary of the Amazon Redshift cluster management interfaces,
// go to Using the Amazon Redshift Management Interfaces (http://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html).
//
// Amazon Redshift manages all the work of setting up, operating, and scaling
// a data warehouse: provisioning capacity, monitoring and backing up the cluster,
// and applying patches and upgrades to the Amazon Redshift engine. You can
// focus on using your data to acquire new insights for your business and customers.
//
// If you are a first-time user of Amazon Redshift, we recommend that you begin
// by reading the Amazon Redshift Getting Started Guide (http://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html).
//
// If you are a database developer, the Amazon Redshift Database Developer Guide
// (http://docs.aws.amazon.com/redshift/latest/dg/welcome.html) explains how
// to design, build, query, and maintain the databases that make up your data
// warehouse.
//
// See https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01 for more information on this service.
//
// See redshift package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/redshift/
//
// Using the Client
//
// To use the client for Amazon Redshift you will first need
// to create a new instance of it.
//
// When creating a client for an AWS service you'll first need to have a Session
// already created. The Session provides configuration that can be shared
// between multiple service clients. Additional configuration can be applied to
// the Session and service's client when they are constructed. The aws package's
// Config type contains several fields such as Region for the AWS Region the
// client should make API requests too. The optional Config value can be provided
// as the variadic argument for Sessions and client creation.
//
// Once the service's client is created you can use it to make API requests the
// AWS service. These clients are safe to use concurrently.
//
//   // Create a session to share configuration, and load external configuration.
//   sess := session.Must(session.NewSession())
//
//   // Create the service's client with the session.
//   svc := redshift.New(sess)
//
// See the SDK's documentation for more information on how to use service clients.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws package's Config type for more information on configuration options.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon Redshift client Redshift for more
// information on creating the service's client.
// https://docs.aws.amazon.com/sdk-for-go/api/service/redshift/#New
//
// Once the client is created you can make an API request to the service.
// Each API method takes a input parameter, and returns the service response
// and an error.
//
// The API method will document which error codes the service can be returned
// by the operation if the service models the API operation's errors. These
// errors will also be available as const strings prefixed with "ErrCode".
//
//   result, err := svc.AuthorizeClusterSecurityGroupIngress(params)
//   if err != nil {
//       // Cast err to awserr.Error to handle specific error codes.
//       aerr, ok := err.(awserr.Error)
//       if ok && aerr.Code() == <error code to check for> {
//           // Specific error code handling
//       }
//       return err
//   }
//
//   fmt.Println("AuthorizeClusterSecurityGroupIngress result:")
//   fmt.Println(result)
//
// Using the Client with Context
//
// The service's client also provides methods to make API requests with a Context
// value. This allows you to control the timeout, and cancellation of pending
// requests. These methods also take request Option as variadic parameter to apply
// additional configuration to the API request.
//
//   ctx := context.Background()
//
//   result, err := svc.AuthorizeClusterSecurityGroupIngressWithContext(ctx, params)
//
// See the request package documentation for more information on using Context pattern
// with the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/request/
package redshift
