// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opCloneReceiptRuleSet = "CloneReceiptRuleSet"

// CloneReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CloneReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CloneReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CloneReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CloneReceiptRuleSetRequest method.
//    req, resp := client.CloneReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet
func (c *SES) CloneReceiptRuleSetRequest(input *CloneReceiptRuleSetInput) (req *request.Request, output *CloneReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCloneReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneReceiptRuleSetInput{}
	}

	output = &CloneReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloneReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Creates a receipt rule set by cloning an existing one. All receipt rules
// and configurations are copied to the new receipt rule set and are completely
// independent of the source rule set.
//
// For information about setting up rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CloneReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
//   * ErrCodeAlreadyExistsException "AlreadyExists"
//   Indicates that a resource could not be created because of a naming conflict.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSet
func (c *SES) CloneReceiptRuleSet(input *CloneReceiptRuleSetInput) (*CloneReceiptRuleSetOutput, error) {
	req, out := c.CloneReceiptRuleSetRequest(input)
	return out, req.Send()
}

// CloneReceiptRuleSetWithContext is the same as CloneReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CloneReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CloneReceiptRuleSetWithContext(ctx aws.Context, input *CloneReceiptRuleSetInput, opts ...request.Option) (*CloneReceiptRuleSetOutput, error) {
	req, out := c.CloneReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSet = "CreateConfigurationSet"

// CreateConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateConfigurationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateConfigurationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateConfigurationSetRequest method.
//    req, resp := client.CreateConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet
func (c *SES) CreateConfigurationSetRequest(input *CreateConfigurationSetInput) (req *request.Request, output *CreateConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetInput{}
	}

	output = &CreateConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfigurationSet API operation for Amazon Simple Email Service.
//
// Creates a configuration set.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetAlreadyExistsException "ConfigurationSetAlreadyExists"
//   Indicates that the configuration set could not be created because of a naming
//   conflict.
//
//   * ErrCodeInvalidConfigurationSetException "InvalidConfigurationSet"
//   Indicates that the configuration set is invalid. See the error message for
//   details.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSet
func (c *SES) CreateConfigurationSet(input *CreateConfigurationSetInput) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetWithContext is the same as CreateConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateConfigurationSetWithContext(ctx aws.Context, input *CreateConfigurationSetInput, opts ...request.Option) (*CreateConfigurationSetOutput, error) {
	req, out := c.CreateConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfigurationSetEventDestination = "CreateConfigurationSetEventDestination"

// CreateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfigurationSetEventDestination operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateConfigurationSetEventDestination for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateConfigurationSetEventDestination method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateConfigurationSetEventDestinationRequest method.
//    req, resp := client.CreateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination
func (c *SES) CreateConfigurationSetEventDestinationRequest(input *CreateConfigurationSetEventDestinationInput) (req *request.Request, output *CreateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opCreateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationSetEventDestinationInput{}
	}

	output = &CreateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Creates a configuration set event destination.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be either Amazon CloudWatch or
// Amazon Kinesis Firehose.
//
// An event destination is the AWS service to which Amazon SES publishes the
// email sending events associated with a configuration set. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
//   * ErrCodeEventDestinationAlreadyExistsException "EventDestinationAlreadyExists"
//   Indicates that the event destination could not be created because of a naming
//   conflict.
//
//   * ErrCodeInvalidCloudWatchDestinationException "InvalidCloudWatchDestination"
//   Indicates that the Amazon CloudWatch destination is invalid. See the error
//   message for details.
//
//   * ErrCodeInvalidFirehoseDestinationException "InvalidFirehoseDestination"
//   Indicates that the Amazon Kinesis Firehose destination is invalid. See the
//   error message for details.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestination
func (c *SES) CreateConfigurationSetEventDestination(input *CreateConfigurationSetEventDestinationInput) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// CreateConfigurationSetEventDestinationWithContext is the same as CreateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *CreateConfigurationSetEventDestinationInput, opts ...request.Option) (*CreateConfigurationSetEventDestinationOutput, error) {
	req, out := c.CreateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptFilter = "CreateReceiptFilter"

// CreateReceiptFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptFilter operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReceiptFilter for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReceiptFilter method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReceiptFilterRequest method.
//    req, resp := client.CreateReceiptFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter
func (c *SES) CreateReceiptFilterRequest(input *CreateReceiptFilterInput) (req *request.Request, output *CreateReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptFilterInput{}
	}

	output = &CreateReceiptFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReceiptFilter API operation for Amazon Simple Email Service.
//
// Creates a new IP address filter.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptFilter for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
//   * ErrCodeAlreadyExistsException "AlreadyExists"
//   Indicates that a resource could not be created because of a naming conflict.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilter
func (c *SES) CreateReceiptFilter(input *CreateReceiptFilterInput) (*CreateReceiptFilterOutput, error) {
	req, out := c.CreateReceiptFilterRequest(input)
	return out, req.Send()
}

// CreateReceiptFilterWithContext is the same as CreateReceiptFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptFilterWithContext(ctx aws.Context, input *CreateReceiptFilterInput, opts ...request.Option) (*CreateReceiptFilterOutput, error) {
	req, out := c.CreateReceiptFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptRule = "CreateReceiptRule"

// CreateReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReceiptRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReceiptRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReceiptRuleRequest method.
//    req, resp := client.CreateReceiptRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule
func (c *SES) CreateReceiptRuleRequest(input *CreateReceiptRuleInput) (req *request.Request, output *CreateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleInput{}
	}

	output = &CreateReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReceiptRule API operation for Amazon Simple Email Service.
//
// Creates a receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSnsTopicException "InvalidSnsTopic"
//   Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
//   could not publish to the topic, possibly due to permissions issues. For information
//   about giving permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeInvalidS3ConfigurationException "InvalidS3Configuration"
//   Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is
//   invalid, or that Amazon SES could not publish to the bucket, possibly due
//   to permissions issues. For information about giving permissions, see the
//   Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeInvalidLambdaFunctionException "InvalidLambdaFunction"
//   Indicates that the provided AWS Lambda function is invalid, or that Amazon
//   SES could not execute the provided function, possibly due to permissions
//   issues. For information about giving permissions, see the Amazon SES Developer
//   Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeAlreadyExistsException "AlreadyExists"
//   Indicates that a resource could not be created because of a naming conflict.
//
//   * ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//   Indicates that the provided receipt rule does not exist.
//
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRule
func (c *SES) CreateReceiptRule(input *CreateReceiptRuleInput) (*CreateReceiptRuleOutput, error) {
	req, out := c.CreateReceiptRuleRequest(input)
	return out, req.Send()
}

// CreateReceiptRuleWithContext is the same as CreateReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptRuleWithContext(ctx aws.Context, input *CreateReceiptRuleInput, opts ...request.Option) (*CreateReceiptRuleOutput, error) {
	req, out := c.CreateReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReceiptRuleSet = "CreateReceiptRuleSet"

// CreateReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateReceiptRuleSetRequest method.
//    req, resp := client.CreateReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet
func (c *SES) CreateReceiptRuleSetRequest(input *CreateReceiptRuleSetInput) (req *request.Request, output *CreateReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleSetInput{}
	}

	output = &CreateReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Creates an empty receipt rule set.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation CreateReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExists"
//   Indicates that a resource could not be created because of a naming conflict.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSet
func (c *SES) CreateReceiptRuleSet(input *CreateReceiptRuleSetInput) (*CreateReceiptRuleSetOutput, error) {
	req, out := c.CreateReceiptRuleSetRequest(input)
	return out, req.Send()
}

// CreateReceiptRuleSetWithContext is the same as CreateReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) CreateReceiptRuleSetWithContext(ctx aws.Context, input *CreateReceiptRuleSetInput, opts ...request.Option) (*CreateReceiptRuleSetOutput, error) {
	req, out := c.CreateReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSet = "DeleteConfigurationSet"

// DeleteConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteConfigurationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteConfigurationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteConfigurationSetRequest method.
//    req, resp := client.DeleteConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet
func (c *SES) DeleteConfigurationSetRequest(input *DeleteConfigurationSetInput) (req *request.Request, output *DeleteConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetInput{}
	}

	output = &DeleteConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConfigurationSet API operation for Amazon Simple Email Service.
//
// Deletes a configuration set.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSet
func (c *SES) DeleteConfigurationSet(input *DeleteConfigurationSetInput) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetWithContext is the same as DeleteConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteConfigurationSetWithContext(ctx aws.Context, input *DeleteConfigurationSetInput, opts ...request.Option) (*DeleteConfigurationSetOutput, error) {
	req, out := c.DeleteConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfigurationSetEventDestination = "DeleteConfigurationSetEventDestination"

// DeleteConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfigurationSetEventDestination operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteConfigurationSetEventDestination for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteConfigurationSetEventDestination method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteConfigurationSetEventDestinationRequest method.
//    req, resp := client.DeleteConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination
func (c *SES) DeleteConfigurationSetEventDestinationRequest(input *DeleteConfigurationSetEventDestinationInput) (req *request.Request, output *DeleteConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationSetEventDestinationInput{}
	}

	output = &DeleteConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Deletes a configuration set event destination.
//
// Configuration set event destinations are associated with configuration sets,
// which enable you to publish email sending events. For information about using
// configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
//   * ErrCodeEventDestinationDoesNotExistException "EventDestinationDoesNotExist"
//   Indicates that the event destination does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestination
func (c *SES) DeleteConfigurationSetEventDestination(input *DeleteConfigurationSetEventDestinationInput) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// DeleteConfigurationSetEventDestinationWithContext is the same as DeleteConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteConfigurationSetEventDestinationWithContext(ctx aws.Context, input *DeleteConfigurationSetEventDestinationInput, opts ...request.Option) (*DeleteConfigurationSetEventDestinationOutput, error) {
	req, out := c.DeleteConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentity = "DeleteIdentity"

// DeleteIdentityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentity operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteIdentity for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteIdentity method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteIdentityRequest method.
//    req, resp := client.DeleteIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity
func (c *SES) DeleteIdentityRequest(input *DeleteIdentityInput) (req *request.Request, output *DeleteIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityInput{}
	}

	output = &DeleteIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdentity API operation for Amazon Simple Email Service.
//
// Deletes the specified identity (an email address or a domain) from the list
// of verified identities.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteIdentity for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity
func (c *SES) DeleteIdentity(input *DeleteIdentityInput) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	return out, req.Send()
}

// DeleteIdentityWithContext is the same as DeleteIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteIdentityWithContext(ctx aws.Context, input *DeleteIdentityInput, opts ...request.Option) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIdentityPolicy = "DeleteIdentityPolicy"

// DeleteIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIdentityPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteIdentityPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteIdentityPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteIdentityPolicyRequest method.
//    req, resp := client.DeleteIdentityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy
func (c *SES) DeleteIdentityPolicyRequest(input *DeleteIdentityPolicyInput) (req *request.Request, output *DeleteIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPolicyInput{}
	}

	output = &DeleteIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIdentityPolicy API operation for Amazon Simple Email Service.
//
// Deletes the specified sending authorization policy for the given identity
// (an email address or a domain). This API returns successfully even if a policy
// with the specified name does not exist.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteIdentityPolicy for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicy
func (c *SES) DeleteIdentityPolicy(input *DeleteIdentityPolicyInput) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	return out, req.Send()
}

// DeleteIdentityPolicyWithContext is the same as DeleteIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteIdentityPolicyWithContext(ctx aws.Context, input *DeleteIdentityPolicyInput, opts ...request.Option) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptFilter = "DeleteReceiptFilter"

// DeleteReceiptFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptFilter operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReceiptFilter for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReceiptFilter method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReceiptFilterRequest method.
//    req, resp := client.DeleteReceiptFilterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter
func (c *SES) DeleteReceiptFilterRequest(input *DeleteReceiptFilterInput) (req *request.Request, output *DeleteReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptFilterInput{}
	}

	output = &DeleteReceiptFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReceiptFilter API operation for Amazon Simple Email Service.
//
// Deletes the specified IP address filter.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptFilter for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilter
func (c *SES) DeleteReceiptFilter(input *DeleteReceiptFilterInput) (*DeleteReceiptFilterOutput, error) {
	req, out := c.DeleteReceiptFilterRequest(input)
	return out, req.Send()
}

// DeleteReceiptFilterWithContext is the same as DeleteReceiptFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptFilterWithContext(ctx aws.Context, input *DeleteReceiptFilterInput, opts ...request.Option) (*DeleteReceiptFilterOutput, error) {
	req, out := c.DeleteReceiptFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptRule = "DeleteReceiptRule"

// DeleteReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReceiptRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReceiptRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReceiptRuleRequest method.
//    req, resp := client.DeleteReceiptRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule
func (c *SES) DeleteReceiptRuleRequest(input *DeleteReceiptRuleInput) (req *request.Request, output *DeleteReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleInput{}
	}

	output = &DeleteReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReceiptRule API operation for Amazon Simple Email Service.
//
// Deletes the specified receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRule
func (c *SES) DeleteReceiptRule(input *DeleteReceiptRuleInput) (*DeleteReceiptRuleOutput, error) {
	req, out := c.DeleteReceiptRuleRequest(input)
	return out, req.Send()
}

// DeleteReceiptRuleWithContext is the same as DeleteReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptRuleWithContext(ctx aws.Context, input *DeleteReceiptRuleInput, opts ...request.Option) (*DeleteReceiptRuleOutput, error) {
	req, out := c.DeleteReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReceiptRuleSet = "DeleteReceiptRuleSet"

// DeleteReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteReceiptRuleSetRequest method.
//    req, resp := client.DeleteReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet
func (c *SES) DeleteReceiptRuleSetRequest(input *DeleteReceiptRuleSetInput) (req *request.Request, output *DeleteReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleSetInput{}
	}

	output = &DeleteReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Deletes the specified receipt rule set and all of the receipt rules it contains.
//
// The currently active rule set cannot be deleted.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCannotDeleteException "CannotDelete"
//   Indicates that the delete operation could not be completed.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSet
func (c *SES) DeleteReceiptRuleSet(input *DeleteReceiptRuleSetInput) (*DeleteReceiptRuleSetOutput, error) {
	req, out := c.DeleteReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DeleteReceiptRuleSetWithContext is the same as DeleteReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteReceiptRuleSetWithContext(ctx aws.Context, input *DeleteReceiptRuleSetInput, opts ...request.Option) (*DeleteReceiptRuleSetOutput, error) {
	req, out := c.DeleteReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVerifiedEmailAddress = "DeleteVerifiedEmailAddress"

// DeleteVerifiedEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVerifiedEmailAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVerifiedEmailAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVerifiedEmailAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVerifiedEmailAddressRequest method.
//    req, resp := client.DeleteVerifiedEmailAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress
func (c *SES) DeleteVerifiedEmailAddressRequest(input *DeleteVerifiedEmailAddressInput) (req *request.Request, output *DeleteVerifiedEmailAddressOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedEmailAddressInput{}
	}

	output = &DeleteVerifiedEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVerifiedEmailAddress API operation for Amazon Simple Email Service.
//
// Deletes the specified email address from the list of verified addresses.
//
// The DeleteVerifiedEmailAddress action is deprecated as of the May 15, 2012
// release of Domain Verification. The DeleteIdentity action is now preferred.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DeleteVerifiedEmailAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddress
func (c *SES) DeleteVerifiedEmailAddress(input *DeleteVerifiedEmailAddressInput) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	return out, req.Send()
}

// DeleteVerifiedEmailAddressWithContext is the same as DeleteVerifiedEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVerifiedEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DeleteVerifiedEmailAddressWithContext(ctx aws.Context, input *DeleteVerifiedEmailAddressInput, opts ...request.Option) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActiveReceiptRuleSet = "DescribeActiveReceiptRuleSet"

// DescribeActiveReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActiveReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeActiveReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeActiveReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeActiveReceiptRuleSetRequest method.
//    req, resp := client.DescribeActiveReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet
func (c *SES) DescribeActiveReceiptRuleSetRequest(input *DescribeActiveReceiptRuleSetInput) (req *request.Request, output *DescribeActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActiveReceiptRuleSetInput{}
	}

	output = &DescribeActiveReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActiveReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Returns the metadata and receipt rules for the receipt rule set that is currently
// active.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeActiveReceiptRuleSet for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSet
func (c *SES) DescribeActiveReceiptRuleSet(input *DescribeActiveReceiptRuleSetInput) (*DescribeActiveReceiptRuleSetOutput, error) {
	req, out := c.DescribeActiveReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DescribeActiveReceiptRuleSetWithContext is the same as DescribeActiveReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActiveReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeActiveReceiptRuleSetWithContext(ctx aws.Context, input *DescribeActiveReceiptRuleSetInput, opts ...request.Option) (*DescribeActiveReceiptRuleSetOutput, error) {
	req, out := c.DescribeActiveReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConfigurationSet = "DescribeConfigurationSet"

// DescribeConfigurationSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConfigurationSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeConfigurationSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeConfigurationSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeConfigurationSetRequest method.
//    req, resp := client.DescribeConfigurationSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet
func (c *SES) DescribeConfigurationSetRequest(input *DescribeConfigurationSetInput) (req *request.Request, output *DescribeConfigurationSetOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationSetInput{}
	}

	output = &DescribeConfigurationSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConfigurationSet API operation for Amazon Simple Email Service.
//
// Returns the details of the specified configuration set.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeConfigurationSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSet
func (c *SES) DescribeConfigurationSet(input *DescribeConfigurationSetInput) (*DescribeConfigurationSetOutput, error) {
	req, out := c.DescribeConfigurationSetRequest(input)
	return out, req.Send()
}

// DescribeConfigurationSetWithContext is the same as DescribeConfigurationSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConfigurationSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeConfigurationSetWithContext(ctx aws.Context, input *DescribeConfigurationSetInput, opts ...request.Option) (*DescribeConfigurationSetOutput, error) {
	req, out := c.DescribeConfigurationSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReceiptRule = "DescribeReceiptRule"

// DescribeReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReceiptRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReceiptRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReceiptRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReceiptRuleRequest method.
//    req, resp := client.DescribeReceiptRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule
func (c *SES) DescribeReceiptRuleRequest(input *DescribeReceiptRuleInput) (req *request.Request, output *DescribeReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleInput{}
	}

	output = &DescribeReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReceiptRule API operation for Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeReceiptRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//   Indicates that the provided receipt rule does not exist.
//
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule
func (c *SES) DescribeReceiptRule(input *DescribeReceiptRuleInput) (*DescribeReceiptRuleOutput, error) {
	req, out := c.DescribeReceiptRuleRequest(input)
	return out, req.Send()
}

// DescribeReceiptRuleWithContext is the same as DescribeReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeReceiptRuleWithContext(ctx aws.Context, input *DescribeReceiptRuleInput, opts ...request.Option) (*DescribeReceiptRuleOutput, error) {
	req, out := c.DescribeReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReceiptRuleSet = "DescribeReceiptRuleSet"

// DescribeReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeReceiptRuleSetRequest method.
//    req, resp := client.DescribeReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet
func (c *SES) DescribeReceiptRuleSetRequest(input *DescribeReceiptRuleSetInput) (req *request.Request, output *DescribeReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleSetInput{}
	}

	output = &DescribeReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule set.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation DescribeReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet
func (c *SES) DescribeReceiptRuleSet(input *DescribeReceiptRuleSetInput) (*DescribeReceiptRuleSetOutput, error) {
	req, out := c.DescribeReceiptRuleSetRequest(input)
	return out, req.Send()
}

// DescribeReceiptRuleSetWithContext is the same as DescribeReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) DescribeReceiptRuleSetWithContext(ctx aws.Context, input *DescribeReceiptRuleSetInput, opts ...request.Option) (*DescribeReceiptRuleSetOutput, error) {
	req, out := c.DescribeReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityDkimAttributes = "GetIdentityDkimAttributes"

// GetIdentityDkimAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityDkimAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityDkimAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityDkimAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityDkimAttributesRequest method.
//    req, resp := client.GetIdentityDkimAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes
func (c *SES) GetIdentityDkimAttributesRequest(input *GetIdentityDkimAttributesInput) (req *request.Request, output *GetIdentityDkimAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityDkimAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityDkimAttributesInput{}
	}

	output = &GetIdentityDkimAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityDkimAttributes API operation for Amazon Simple Email Service.
//
// Returns the current status of Easy DKIM signing for an entity. For domain
// name identities, this action also returns the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES has successfully verified that
// these tokens have been published.
//
// This action takes a list of identities as input and returns the following
// information for each:
//
//    * Whether Easy DKIM signing is enabled or disabled.
//
//    * A set of DKIM tokens that represent the identity. If the identity is
//    an email address, the tokens represent the domain of that address.
//
//    * Whether Amazon SES has successfully verified the DKIM tokens published
//    in the domain's DNS. This information is only returned for domain name
//    identities, not for email addresses.
//
// This action is throttled at one request per second and can only get DKIM
// attributes for up to 100 identities at a time.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityDkimAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributes
func (c *SES) GetIdentityDkimAttributes(input *GetIdentityDkimAttributesInput) (*GetIdentityDkimAttributesOutput, error) {
	req, out := c.GetIdentityDkimAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityDkimAttributesWithContext is the same as GetIdentityDkimAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityDkimAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityDkimAttributesWithContext(ctx aws.Context, input *GetIdentityDkimAttributesInput, opts ...request.Option) (*GetIdentityDkimAttributesOutput, error) {
	req, out := c.GetIdentityDkimAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityMailFromDomainAttributes = "GetIdentityMailFromDomainAttributes"

// GetIdentityMailFromDomainAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityMailFromDomainAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityMailFromDomainAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityMailFromDomainAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityMailFromDomainAttributesRequest method.
//    req, resp := client.GetIdentityMailFromDomainAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes
func (c *SES) GetIdentityMailFromDomainAttributesRequest(input *GetIdentityMailFromDomainAttributesInput) (req *request.Request, output *GetIdentityMailFromDomainAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityMailFromDomainAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityMailFromDomainAttributesInput{}
	}

	output = &GetIdentityMailFromDomainAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityMailFromDomainAttributes API operation for Amazon Simple Email Service.
//
// Returns the custom MAIL FROM attributes for a list of identities (email addresses
// and/or domains).
//
// This action is throttled at one request per second and can only get custom
// MAIL FROM attributes for up to 100 identities at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityMailFromDomainAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributes
func (c *SES) GetIdentityMailFromDomainAttributes(input *GetIdentityMailFromDomainAttributesInput) (*GetIdentityMailFromDomainAttributesOutput, error) {
	req, out := c.GetIdentityMailFromDomainAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityMailFromDomainAttributesWithContext is the same as GetIdentityMailFromDomainAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityMailFromDomainAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityMailFromDomainAttributesWithContext(ctx aws.Context, input *GetIdentityMailFromDomainAttributesInput, opts ...request.Option) (*GetIdentityMailFromDomainAttributesOutput, error) {
	req, out := c.GetIdentityMailFromDomainAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityNotificationAttributes = "GetIdentityNotificationAttributes"

// GetIdentityNotificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityNotificationAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityNotificationAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityNotificationAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityNotificationAttributesRequest method.
//    req, resp := client.GetIdentityNotificationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes
func (c *SES) GetIdentityNotificationAttributesRequest(input *GetIdentityNotificationAttributesInput) (req *request.Request, output *GetIdentityNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityNotificationAttributesInput{}
	}

	output = &GetIdentityNotificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityNotificationAttributes API operation for Amazon Simple Email Service.
//
// Given a list of verified identities (email addresses and/or domains), returns
// a structure describing identity notification attributes.
//
// This action is throttled at one request per second and can only get notification
// attributes for up to 100 identities at a time.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityNotificationAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributes
func (c *SES) GetIdentityNotificationAttributes(input *GetIdentityNotificationAttributesInput) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityNotificationAttributesWithContext is the same as GetIdentityNotificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityNotificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityNotificationAttributesWithContext(ctx aws.Context, input *GetIdentityNotificationAttributesInput, opts ...request.Option) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityPolicies = "GetIdentityPolicies"

// GetIdentityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityPoliciesRequest method.
//    req, resp := client.GetIdentityPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies
func (c *SES) GetIdentityPoliciesRequest(input *GetIdentityPoliciesInput) (req *request.Request, output *GetIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoliciesInput{}
	}

	output = &GetIdentityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityPolicies API operation for Amazon Simple Email Service.
//
// Returns the requested sending authorization policies for the given identity
// (an email address or a domain). The policies are returned as a map of policy
// names to policy contents. You can retrieve a maximum of 20 policies at a
// time.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityPolicies for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPolicies
func (c *SES) GetIdentityPolicies(input *GetIdentityPoliciesInput) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	return out, req.Send()
}

// GetIdentityPoliciesWithContext is the same as GetIdentityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityPoliciesWithContext(ctx aws.Context, input *GetIdentityPoliciesInput, opts ...request.Option) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIdentityVerificationAttributes = "GetIdentityVerificationAttributes"

// GetIdentityVerificationAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityVerificationAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityVerificationAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityVerificationAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityVerificationAttributesRequest method.
//    req, resp := client.GetIdentityVerificationAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes
func (c *SES) GetIdentityVerificationAttributesRequest(input *GetIdentityVerificationAttributesInput) (req *request.Request, output *GetIdentityVerificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityVerificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityVerificationAttributesInput{}
	}

	output = &GetIdentityVerificationAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIdentityVerificationAttributes API operation for Amazon Simple Email Service.
//
// Given a list of identities (email addresses and/or domains), returns the
// verification status and (for domain identities) the verification token for
// each identity.
//
// This action is throttled at one request per second and can only get verification
// attributes for up to 100 identities at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetIdentityVerificationAttributes for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes
func (c *SES) GetIdentityVerificationAttributes(input *GetIdentityVerificationAttributesInput) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	return out, req.Send()
}

// GetIdentityVerificationAttributesWithContext is the same as GetIdentityVerificationAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetIdentityVerificationAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetIdentityVerificationAttributesWithContext(ctx aws.Context, input *GetIdentityVerificationAttributesInput, opts ...request.Option) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSendQuota = "GetSendQuota"

// GetSendQuotaRequest generates a "aws/request.Request" representing the
// client's request for the GetSendQuota operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSendQuota for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSendQuota method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSendQuotaRequest method.
//    req, resp := client.GetSendQuotaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota
func (c *SES) GetSendQuotaRequest(input *GetSendQuotaInput) (req *request.Request, output *GetSendQuotaOutput) {
	op := &request.Operation{
		Name:       opGetSendQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendQuotaInput{}
	}

	output = &GetSendQuotaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSendQuota API operation for Amazon Simple Email Service.
//
// Returns the user's current sending limits.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetSendQuota for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuota
func (c *SES) GetSendQuota(input *GetSendQuotaInput) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	return out, req.Send()
}

// GetSendQuotaWithContext is the same as GetSendQuota with the addition of
// the ability to pass a context and additional request options.
//
// See GetSendQuota for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetSendQuotaWithContext(ctx aws.Context, input *GetSendQuotaInput, opts ...request.Option) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSendStatistics = "GetSendStatistics"

// GetSendStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the GetSendStatistics operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSendStatistics for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSendStatistics method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSendStatisticsRequest method.
//    req, resp := client.GetSendStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics
func (c *SES) GetSendStatisticsRequest(input *GetSendStatisticsInput) (req *request.Request, output *GetSendStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetSendStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendStatisticsInput{}
	}

	output = &GetSendStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSendStatistics API operation for Amazon Simple Email Service.
//
// Returns the user's sending statistics. The result is a list of data points,
// representing the last two weeks of sending activity.
//
// Each data point in the list contains statistics for a 15-minute interval.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation GetSendStatistics for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatistics
func (c *SES) GetSendStatistics(input *GetSendStatisticsInput) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	return out, req.Send()
}

// GetSendStatisticsWithContext is the same as GetSendStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See GetSendStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) GetSendStatisticsWithContext(ctx aws.Context, input *GetSendStatisticsInput, opts ...request.Option) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigurationSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListConfigurationSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListConfigurationSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListConfigurationSetsRequest method.
//    req, resp := client.ListConfigurationSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets
func (c *SES) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) (req *request.Request, output *ListConfigurationSetsOutput) {
	op := &request.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	output = &ListConfigurationSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigurationSets API operation for Amazon Simple Email Service.
//
// Lists the configuration sets associated with your AWS account.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second and can return up to 50
// configuration sets at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListConfigurationSets for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSets
func (c *SES) ListConfigurationSets(input *ListConfigurationSetsInput) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	return out, req.Send()
}

// ListConfigurationSetsWithContext is the same as ListConfigurationSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigurationSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListConfigurationSetsWithContext(ctx aws.Context, input *ListConfigurationSetsInput, opts ...request.Option) (*ListConfigurationSetsOutput, error) {
	req, out := c.ListConfigurationSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentities operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListIdentities for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListIdentities method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListIdentitiesRequest method.
//    req, resp := client.ListIdentitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities
func (c *SES) ListIdentitiesRequest(input *ListIdentitiesInput) (req *request.Request, output *ListIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	output = &ListIdentitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentities API operation for Amazon Simple Email Service.
//
// Returns a list containing all of the identities (email addresses and domains)
// for your AWS account, regardless of verification status.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListIdentities for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentities
func (c *SES) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	return out, req.Send()
}

// ListIdentitiesWithContext is the same as ListIdentities with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentitiesWithContext(ctx aws.Context, input *ListIdentitiesInput, opts ...request.Option) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentitiesPages iterates over the pages of a ListIdentities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListIdentities operation.
//    pageNum := 0
//    err := client.ListIdentitiesPages(params,
//        func(page *ListIdentitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SES) ListIdentitiesPages(input *ListIdentitiesInput, fn func(*ListIdentitiesOutput, bool) bool) error {
	return c.ListIdentitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentitiesPagesWithContext same as ListIdentitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentitiesPagesWithContext(ctx aws.Context, input *ListIdentitiesInput, fn func(*ListIdentitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListIdentitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListIdentityPolicies = "ListIdentityPolicies"

// ListIdentityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListIdentityPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListIdentityPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListIdentityPoliciesRequest method.
//    req, resp := client.ListIdentityPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies
func (c *SES) ListIdentityPoliciesRequest(input *ListIdentityPoliciesInput) (req *request.Request, output *ListIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opListIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoliciesInput{}
	}

	output = &ListIdentityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityPolicies API operation for Amazon Simple Email Service.
//
// Returns a list of sending authorization policies that are attached to the
// given identity (an email address or a domain). This API returns only a list.
// If you want the actual policy content, you can use GetIdentityPolicies.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListIdentityPolicies for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPolicies
func (c *SES) ListIdentityPolicies(input *ListIdentityPoliciesInput) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	return out, req.Send()
}

// ListIdentityPoliciesWithContext is the same as ListIdentityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListIdentityPoliciesWithContext(ctx aws.Context, input *ListIdentityPoliciesInput, opts ...request.Option) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReceiptFilters = "ListReceiptFilters"

// ListReceiptFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListReceiptFilters operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListReceiptFilters for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListReceiptFilters method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListReceiptFiltersRequest method.
//    req, resp := client.ListReceiptFiltersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters
func (c *SES) ListReceiptFiltersRequest(input *ListReceiptFiltersInput) (req *request.Request, output *ListReceiptFiltersOutput) {
	op := &request.Operation{
		Name:       opListReceiptFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptFiltersInput{}
	}

	output = &ListReceiptFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReceiptFilters API operation for Amazon Simple Email Service.
//
// Lists the IP address filters associated with your AWS account.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListReceiptFilters for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFilters
func (c *SES) ListReceiptFilters(input *ListReceiptFiltersInput) (*ListReceiptFiltersOutput, error) {
	req, out := c.ListReceiptFiltersRequest(input)
	return out, req.Send()
}

// ListReceiptFiltersWithContext is the same as ListReceiptFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListReceiptFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListReceiptFiltersWithContext(ctx aws.Context, input *ListReceiptFiltersInput, opts ...request.Option) (*ListReceiptFiltersOutput, error) {
	req, out := c.ListReceiptFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListReceiptRuleSets = "ListReceiptRuleSets"

// ListReceiptRuleSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListReceiptRuleSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListReceiptRuleSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListReceiptRuleSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListReceiptRuleSetsRequest method.
//    req, resp := client.ListReceiptRuleSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets
func (c *SES) ListReceiptRuleSetsRequest(input *ListReceiptRuleSetsInput) (req *request.Request, output *ListReceiptRuleSetsOutput) {
	op := &request.Operation{
		Name:       opListReceiptRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptRuleSetsInput{}
	}

	output = &ListReceiptRuleSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReceiptRuleSets API operation for Amazon Simple Email Service.
//
// Lists the receipt rule sets that exist under your AWS account. If there are
// additional receipt rule sets to be retrieved, you will receive a NextToken
// that you can provide to the next call to ListReceiptRuleSets to retrieve
// the additional entries.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListReceiptRuleSets for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSets
func (c *SES) ListReceiptRuleSets(input *ListReceiptRuleSetsInput) (*ListReceiptRuleSetsOutput, error) {
	req, out := c.ListReceiptRuleSetsRequest(input)
	return out, req.Send()
}

// ListReceiptRuleSetsWithContext is the same as ListReceiptRuleSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListReceiptRuleSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListReceiptRuleSetsWithContext(ctx aws.Context, input *ListReceiptRuleSetsInput, opts ...request.Option) (*ListReceiptRuleSetsOutput, error) {
	req, out := c.ListReceiptRuleSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVerifiedEmailAddresses = "ListVerifiedEmailAddresses"

// ListVerifiedEmailAddressesRequest generates a "aws/request.Request" representing the
// client's request for the ListVerifiedEmailAddresses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVerifiedEmailAddresses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVerifiedEmailAddresses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVerifiedEmailAddressesRequest method.
//    req, resp := client.ListVerifiedEmailAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses
func (c *SES) ListVerifiedEmailAddressesRequest(input *ListVerifiedEmailAddressesInput) (req *request.Request, output *ListVerifiedEmailAddressesOutput) {
	op := &request.Operation{
		Name:       opListVerifiedEmailAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVerifiedEmailAddressesInput{}
	}

	output = &ListVerifiedEmailAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVerifiedEmailAddresses API operation for Amazon Simple Email Service.
//
// Returns a list containing all of the email addresses that have been verified.
//
// The ListVerifiedEmailAddresses action is deprecated as of the May 15, 2012
// release of Domain Verification. The ListIdentities action is now preferred.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ListVerifiedEmailAddresses for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddresses
func (c *SES) ListVerifiedEmailAddresses(input *ListVerifiedEmailAddressesInput) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	return out, req.Send()
}

// ListVerifiedEmailAddressesWithContext is the same as ListVerifiedEmailAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See ListVerifiedEmailAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ListVerifiedEmailAddressesWithContext(ctx aws.Context, input *ListVerifiedEmailAddressesInput, opts ...request.Option) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIdentityPolicy = "PutIdentityPolicy"

// PutIdentityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutIdentityPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutIdentityPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutIdentityPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutIdentityPolicyRequest method.
//    req, resp := client.PutIdentityPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy
func (c *SES) PutIdentityPolicyRequest(input *PutIdentityPolicyInput) (req *request.Request, output *PutIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opPutIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutIdentityPolicyInput{}
	}

	output = &PutIdentityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutIdentityPolicy API operation for Amazon Simple Email Service.
//
// Adds or updates a sending authorization policy for the specified identity
// (an email address or a domain).
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error.
//
// Sending authorization is a feature that enables an identity owner to authorize
// other senders to use its identities. For information about using sending
// authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation PutIdentityPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPolicyException "InvalidPolicy"
//   Indicates that the provided policy is invalid. Check the error stack for
//   more information about what caused the error.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicy
func (c *SES) PutIdentityPolicy(input *PutIdentityPolicyInput) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	return out, req.Send()
}

// PutIdentityPolicyWithContext is the same as PutIdentityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutIdentityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) PutIdentityPolicyWithContext(ctx aws.Context, input *PutIdentityPolicyInput, opts ...request.Option) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReorderReceiptRuleSet = "ReorderReceiptRuleSet"

// ReorderReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the ReorderReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReorderReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReorderReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReorderReceiptRuleSetRequest method.
//    req, resp := client.ReorderReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet
func (c *SES) ReorderReceiptRuleSetRequest(input *ReorderReceiptRuleSetInput) (req *request.Request, output *ReorderReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opReorderReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReorderReceiptRuleSetInput{}
	}

	output = &ReorderReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReorderReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Reorders the receipt rules within a receipt rule set.
//
// All of the rules in the rule set must be represented in this request. That
// is, this API will return an error if the reorder request doesn't explicitly
// position all of the rules.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation ReorderReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
//   * ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//   Indicates that the provided receipt rule does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSet
func (c *SES) ReorderReceiptRuleSet(input *ReorderReceiptRuleSetInput) (*ReorderReceiptRuleSetOutput, error) {
	req, out := c.ReorderReceiptRuleSetRequest(input)
	return out, req.Send()
}

// ReorderReceiptRuleSetWithContext is the same as ReorderReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See ReorderReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) ReorderReceiptRuleSetWithContext(ctx aws.Context, input *ReorderReceiptRuleSetInput, opts ...request.Option) (*ReorderReceiptRuleSetOutput, error) {
	req, out := c.ReorderReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendBounce = "SendBounce"

// SendBounceRequest generates a "aws/request.Request" representing the
// client's request for the SendBounce operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SendBounce for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SendBounce method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SendBounceRequest method.
//    req, resp := client.SendBounceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce
func (c *SES) SendBounceRequest(input *SendBounceInput) (req *request.Request, output *SendBounceOutput) {
	op := &request.Operation{
		Name:       opSendBounce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendBounceInput{}
	}

	output = &SendBounceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendBounce API operation for Amazon Simple Email Service.
//
// Generates and sends a bounce message to the sender of an email you received
// through Amazon SES. You can only use this API on an email up to 24 hours
// after you receive it.
//
// You cannot use this API to send generic bounces for mail that was not received
// by Amazon SES.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendBounce for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMessageRejected "MessageRejected"
//   Indicates that the action failed, and the message could not be sent. Check
//   the error stack for more information about what caused the error.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounce
func (c *SES) SendBounce(input *SendBounceInput) (*SendBounceOutput, error) {
	req, out := c.SendBounceRequest(input)
	return out, req.Send()
}

// SendBounceWithContext is the same as SendBounce with the addition of
// the ability to pass a context and additional request options.
//
// See SendBounce for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendBounceWithContext(ctx aws.Context, input *SendBounceInput, opts ...request.Option) (*SendBounceOutput, error) {
	req, out := c.SendBounceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendEmail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SendEmail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SendEmail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SendEmailRequest method.
//    req, resp := client.SendEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail
func (c *SES) SendEmailRequest(input *SendEmailInput) (req *request.Request, output *SendEmailOutput) {
	op := &request.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	output = &SendEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEmail API operation for Amazon Simple Email Service.
//
// Composes an email message based on input data, and then immediately queues
// the message for sending.
//
// There are several important points to know about SendEmail:
//
//    * You can only send email from verified email addresses and domains; otherwise,
//    you will get an "Email address not verified" error. If your account is
//    still in the Amazon SES sandbox, you must also verify every recipient
//    email address except for the recipients provided by the Amazon SES mailbox
//    simulator. For more information, go to the Amazon SES Developer Guide
//    (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
//
//    * The total size of the message cannot exceed 10 MB. This includes any
//    attachments that are part of the message.
//
//    * Amazon SES has a limit on the total number of recipients per message.
//    The combined number of To:, CC: and BCC: email addresses cannot exceed
//    50. If you need to send an email message to a larger audience, you can
//    divide your recipient list into groups of 50 or fewer, and then call Amazon
//    SES repeatedly to send the message to each group.
//
//    * For every message that you send, the total number of recipients (To:,
//    CC: and BCC:) is counted against your sending quota - the maximum number
//    of emails you can send in a 24-hour period. For information about your
//    sending quota, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendEmail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMessageRejected "MessageRejected"
//   Indicates that the action failed, and the message could not be sent. Check
//   the error stack for more information about what caused the error.
//
//   * ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//   Indicates that the message could not be sent because Amazon SES could not
//   read the MX record required to use the specified MAIL FROM domain. For information
//   about editing the custom MAIL FROM domain settings for an identity, see the
//   Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmail
func (c *SES) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	return out, req.Send()
}

// SendEmailWithContext is the same as SendEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendEmailWithContext(ctx aws.Context, input *SendEmailInput, opts ...request.Option) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendRawEmail = "SendRawEmail"

// SendRawEmailRequest generates a "aws/request.Request" representing the
// client's request for the SendRawEmail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SendRawEmail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SendRawEmail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SendRawEmailRequest method.
//    req, resp := client.SendRawEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail
func (c *SES) SendRawEmailRequest(input *SendRawEmailInput) (req *request.Request, output *SendRawEmailOutput) {
	op := &request.Operation{
		Name:       opSendRawEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendRawEmailInput{}
	}

	output = &SendRawEmailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendRawEmail API operation for Amazon Simple Email Service.
//
// Sends an email message, with header and content specified by the client.
// The SendRawEmail action is useful for sending multipart MIME emails. The
// raw text of the message must comply with Internet email standards; otherwise,
// the message cannot be sent.
//
// There are several important points to know about SendRawEmail:
//
//    * You can only send email from verified email addresses and domains; otherwise,
//    you will get an "Email address not verified" error. If your account is
//    still in the Amazon SES sandbox, you must also verify every recipient
//    email address except for the recipients provided by the Amazon SES mailbox
//    simulator. For more information, go to the Amazon SES Developer Guide
//    (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
//
//    * The total size of the message cannot exceed 10 MB. This includes any
//    attachments that are part of the message.
//
//    * Amazon SES has a limit on the total number of recipients per message.
//    The combined number of To:, CC: and BCC: email addresses cannot exceed
//    50. If you need to send an email message to a larger audience, you can
//    divide your recipient list into groups of 50 or fewer, and then call Amazon
//    SES repeatedly to send the message to each group.
//
//    * The To:, CC:, and BCC: headers in the raw message can contain a group
//    list. Note that each recipient in a group list counts towards the 50-recipient
//    limit.
//
//    * Amazon SES overrides any Message-ID and Date headers you provide.
//
//    * For every message that you send, the total number of recipients (To:,
//    CC: and BCC:) is counted against your sending quota - the maximum number
//    of emails you can send in a 24-hour period. For information about your
//    sending quota, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
//
//    * If you are using sending authorization to send on behalf of another
//    user, SendRawEmail enables you to specify the cross-account identity for
//    the email's "Source," "From," and "Return-Path" parameters in one of two
//    ways: you can pass optional parameters SourceArn, FromArn, and/or ReturnPathArn
//    to the API, or you can include the following X-headers in the header of
//    your raw email:
//
// X-SES-SOURCE-ARN
//
// X-SES-FROM-ARN
//
// X-SES-RETURN-PATH-ARN
//
// Do not include these X-headers in the DKIM signature, because they are removed
//    by Amazon SES before sending the email.
//
// For the most common sending authorization use case, we recommend that you
//    specify the SourceIdentityArn and do not specify either the FromIdentityArn
//    or ReturnPathIdentityArn. (The same note applies to the corresponding
//    X-headers.) If you only specify the SourceIdentityArn, Amazon SES will
//    simply set the "From" address and the "Return Path" address to the identity
//    specified in SourceIdentityArn. For more information about sending authorization,
//    see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SendRawEmail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMessageRejected "MessageRejected"
//   Indicates that the action failed, and the message could not be sent. Check
//   the error stack for more information about what caused the error.
//
//   * ErrCodeMailFromDomainNotVerifiedException "MailFromDomainNotVerifiedException"
//   Indicates that the message could not be sent because Amazon SES could not
//   read the MX record required to use the specified MAIL FROM domain. For information
//   about editing the custom MAIL FROM domain settings for an identity, see the
//   Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-edit.html).
//
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmail
func (c *SES) SendRawEmail(input *SendRawEmailInput) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	return out, req.Send()
}

// SendRawEmailWithContext is the same as SendRawEmail with the addition of
// the ability to pass a context and additional request options.
//
// See SendRawEmail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SendRawEmailWithContext(ctx aws.Context, input *SendRawEmailInput, opts ...request.Option) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetActiveReceiptRuleSet = "SetActiveReceiptRuleSet"

// SetActiveReceiptRuleSetRequest generates a "aws/request.Request" representing the
// client's request for the SetActiveReceiptRuleSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetActiveReceiptRuleSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetActiveReceiptRuleSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetActiveReceiptRuleSetRequest method.
//    req, resp := client.SetActiveReceiptRuleSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet
func (c *SES) SetActiveReceiptRuleSetRequest(input *SetActiveReceiptRuleSetInput) (req *request.Request, output *SetActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opSetActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetActiveReceiptRuleSetInput{}
	}

	output = &SetActiveReceiptRuleSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetActiveReceiptRuleSet API operation for Amazon Simple Email Service.
//
// Sets the specified receipt rule set as the active receipt rule set.
//
// To disable your email-receiving through Amazon SES completely, you can call
// this API with RuleSetName set to null.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetActiveReceiptRuleSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSet
func (c *SES) SetActiveReceiptRuleSet(input *SetActiveReceiptRuleSetInput) (*SetActiveReceiptRuleSetOutput, error) {
	req, out := c.SetActiveReceiptRuleSetRequest(input)
	return out, req.Send()
}

// SetActiveReceiptRuleSetWithContext is the same as SetActiveReceiptRuleSet with the addition of
// the ability to pass a context and additional request options.
//
// See SetActiveReceiptRuleSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetActiveReceiptRuleSetWithContext(ctx aws.Context, input *SetActiveReceiptRuleSetInput, opts ...request.Option) (*SetActiveReceiptRuleSetOutput, error) {
	req, out := c.SetActiveReceiptRuleSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityDkimEnabled = "SetIdentityDkimEnabled"

// SetIdentityDkimEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityDkimEnabled operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityDkimEnabled for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityDkimEnabled method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityDkimEnabledRequest method.
//    req, resp := client.SetIdentityDkimEnabledRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled
func (c *SES) SetIdentityDkimEnabledRequest(input *SetIdentityDkimEnabledInput) (req *request.Request, output *SetIdentityDkimEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityDkimEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityDkimEnabledInput{}
	}

	output = &SetIdentityDkimEnabledOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityDkimEnabled API operation for Amazon Simple Email Service.
//
// Enables or disables Easy DKIM signing of email sent from an identity:
//
//    * If Easy DKIM signing is enabled for a domain name identity (e.g., example.com),
//    then Amazon SES will DKIM-sign all email sent by addresses under that
//    domain name (e.g., user@example.com).
//
//    * If Easy DKIM signing is enabled for an email address, then Amazon SES
//    will DKIM-sign all email sent by that email address.
//
// For email addresses (e.g., user@example.com), you can only enable Easy DKIM
// signing if the corresponding domain (e.g., example.com) has been set up for
// Easy DKIM using the AWS Console or the VerifyDomainDkim action.
//
// This action is throttled at one request per second.
//
// For more information about Easy DKIM signing, go to the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityDkimEnabled for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabled
func (c *SES) SetIdentityDkimEnabled(input *SetIdentityDkimEnabledInput) (*SetIdentityDkimEnabledOutput, error) {
	req, out := c.SetIdentityDkimEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityDkimEnabledWithContext is the same as SetIdentityDkimEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityDkimEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityDkimEnabledWithContext(ctx aws.Context, input *SetIdentityDkimEnabledInput, opts ...request.Option) (*SetIdentityDkimEnabledOutput, error) {
	req, out := c.SetIdentityDkimEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityFeedbackForwardingEnabled = "SetIdentityFeedbackForwardingEnabled"

// SetIdentityFeedbackForwardingEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityFeedbackForwardingEnabled operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityFeedbackForwardingEnabled for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityFeedbackForwardingEnabled method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityFeedbackForwardingEnabledRequest method.
//    req, resp := client.SetIdentityFeedbackForwardingEnabledRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled
func (c *SES) SetIdentityFeedbackForwardingEnabledRequest(input *SetIdentityFeedbackForwardingEnabledInput) (req *request.Request, output *SetIdentityFeedbackForwardingEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityFeedbackForwardingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityFeedbackForwardingEnabledInput{}
	}

	output = &SetIdentityFeedbackForwardingEnabledOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityFeedbackForwardingEnabled API operation for Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), enables or disables whether
// Amazon SES forwards bounce and complaint notifications as email. Feedback
// forwarding can only be disabled when Amazon Simple Notification Service (Amazon
// SNS) topics are specified for both bounces and complaints.
//
// Feedback forwarding does not apply to delivery notifications. Delivery notifications
// are only available through Amazon SNS.
//
// This action is throttled at one request per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityFeedbackForwardingEnabled for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabled
func (c *SES) SetIdentityFeedbackForwardingEnabled(input *SetIdentityFeedbackForwardingEnabledInput) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityFeedbackForwardingEnabledWithContext is the same as SetIdentityFeedbackForwardingEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityFeedbackForwardingEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityFeedbackForwardingEnabledWithContext(ctx aws.Context, input *SetIdentityFeedbackForwardingEnabledInput, opts ...request.Option) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityHeadersInNotificationsEnabled = "SetIdentityHeadersInNotificationsEnabled"

// SetIdentityHeadersInNotificationsEnabledRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityHeadersInNotificationsEnabled operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityHeadersInNotificationsEnabled for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityHeadersInNotificationsEnabled method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityHeadersInNotificationsEnabledRequest method.
//    req, resp := client.SetIdentityHeadersInNotificationsEnabledRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled
func (c *SES) SetIdentityHeadersInNotificationsEnabledRequest(input *SetIdentityHeadersInNotificationsEnabledInput) (req *request.Request, output *SetIdentityHeadersInNotificationsEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityHeadersInNotificationsEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityHeadersInNotificationsEnabledInput{}
	}

	output = &SetIdentityHeadersInNotificationsEnabledOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityHeadersInNotificationsEnabled API operation for Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), sets whether Amazon SES
// includes the original email headers in the Amazon Simple Notification Service
// (Amazon SNS) notifications of a specified type.
//
// This action is throttled at one request per second.
//
// For more information about using notifications with Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityHeadersInNotificationsEnabled for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabled
func (c *SES) SetIdentityHeadersInNotificationsEnabled(input *SetIdentityHeadersInNotificationsEnabledInput) (*SetIdentityHeadersInNotificationsEnabledOutput, error) {
	req, out := c.SetIdentityHeadersInNotificationsEnabledRequest(input)
	return out, req.Send()
}

// SetIdentityHeadersInNotificationsEnabledWithContext is the same as SetIdentityHeadersInNotificationsEnabled with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityHeadersInNotificationsEnabled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityHeadersInNotificationsEnabledWithContext(ctx aws.Context, input *SetIdentityHeadersInNotificationsEnabledInput, opts ...request.Option) (*SetIdentityHeadersInNotificationsEnabledOutput, error) {
	req, out := c.SetIdentityHeadersInNotificationsEnabledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityMailFromDomain = "SetIdentityMailFromDomain"

// SetIdentityMailFromDomainRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityMailFromDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityMailFromDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityMailFromDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityMailFromDomainRequest method.
//    req, resp := client.SetIdentityMailFromDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain
func (c *SES) SetIdentityMailFromDomainRequest(input *SetIdentityMailFromDomainInput) (req *request.Request, output *SetIdentityMailFromDomainOutput) {
	op := &request.Operation{
		Name:       opSetIdentityMailFromDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityMailFromDomainInput{}
	}

	output = &SetIdentityMailFromDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityMailFromDomain API operation for Amazon Simple Email Service.
//
// Enables or disables the custom MAIL FROM domain setup for a verified identity
// (an email address or a domain).
//
// To send emails using the specified MAIL FROM domain, you must add an MX record
// to your MAIL FROM domain's DNS settings. If you want your emails to pass
// Sender Policy Framework (SPF) checks, you must also add or update an SPF
// record. For more information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from-set.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityMailFromDomain for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomain
func (c *SES) SetIdentityMailFromDomain(input *SetIdentityMailFromDomainInput) (*SetIdentityMailFromDomainOutput, error) {
	req, out := c.SetIdentityMailFromDomainRequest(input)
	return out, req.Send()
}

// SetIdentityMailFromDomainWithContext is the same as SetIdentityMailFromDomain with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityMailFromDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityMailFromDomainWithContext(ctx aws.Context, input *SetIdentityMailFromDomainInput, opts ...request.Option) (*SetIdentityMailFromDomainOutput, error) {
	req, out := c.SetIdentityMailFromDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetIdentityNotificationTopic = "SetIdentityNotificationTopic"

// SetIdentityNotificationTopicRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityNotificationTopic operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityNotificationTopic for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityNotificationTopic method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityNotificationTopicRequest method.
//    req, resp := client.SetIdentityNotificationTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic
func (c *SES) SetIdentityNotificationTopicRequest(input *SetIdentityNotificationTopicInput) (req *request.Request, output *SetIdentityNotificationTopicOutput) {
	op := &request.Operation{
		Name:       opSetIdentityNotificationTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityNotificationTopicInput{}
	}

	output = &SetIdentityNotificationTopicOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetIdentityNotificationTopic API operation for Amazon Simple Email Service.
//
// Given an identity (an email address or a domain), sets the Amazon Simple
// Notification Service (Amazon SNS) topic to which Amazon SES will publish
// bounce, complaint, and/or delivery notifications for emails sent with that
// identity as the Source.
//
// Unless feedback forwarding is enabled, you must specify Amazon SNS topics
// for bounce and complaint notifications. For more information, see SetIdentityFeedbackForwardingEnabled.
//
// This action is throttled at one request per second.
//
// For more information about feedback notification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetIdentityNotificationTopic for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopic
func (c *SES) SetIdentityNotificationTopic(input *SetIdentityNotificationTopicInput) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	return out, req.Send()
}

// SetIdentityNotificationTopicWithContext is the same as SetIdentityNotificationTopic with the addition of
// the ability to pass a context and additional request options.
//
// See SetIdentityNotificationTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetIdentityNotificationTopicWithContext(ctx aws.Context, input *SetIdentityNotificationTopicInput, opts ...request.Option) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetReceiptRulePosition = "SetReceiptRulePosition"

// SetReceiptRulePositionRequest generates a "aws/request.Request" representing the
// client's request for the SetReceiptRulePosition operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetReceiptRulePosition for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetReceiptRulePosition method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetReceiptRulePositionRequest method.
//    req, resp := client.SetReceiptRulePositionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition
func (c *SES) SetReceiptRulePositionRequest(input *SetReceiptRulePositionInput) (req *request.Request, output *SetReceiptRulePositionOutput) {
	op := &request.Operation{
		Name:       opSetReceiptRulePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetReceiptRulePositionInput{}
	}

	output = &SetReceiptRulePositionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetReceiptRulePosition API operation for Amazon Simple Email Service.
//
// Sets the position of the specified receipt rule in the receipt rule set.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation SetReceiptRulePosition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
//   * ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//   Indicates that the provided receipt rule does not exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePosition
func (c *SES) SetReceiptRulePosition(input *SetReceiptRulePositionInput) (*SetReceiptRulePositionOutput, error) {
	req, out := c.SetReceiptRulePositionRequest(input)
	return out, req.Send()
}

// SetReceiptRulePositionWithContext is the same as SetReceiptRulePosition with the addition of
// the ability to pass a context and additional request options.
//
// See SetReceiptRulePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) SetReceiptRulePositionWithContext(ctx aws.Context, input *SetReceiptRulePositionInput, opts ...request.Option) (*SetReceiptRulePositionOutput, error) {
	req, out := c.SetReceiptRulePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfigurationSetEventDestination = "UpdateConfigurationSetEventDestination"

// UpdateConfigurationSetEventDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfigurationSetEventDestination operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateConfigurationSetEventDestination for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateConfigurationSetEventDestination method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateConfigurationSetEventDestinationRequest method.
//    req, resp := client.UpdateConfigurationSetEventDestinationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination
func (c *SES) UpdateConfigurationSetEventDestinationRequest(input *UpdateConfigurationSetEventDestinationInput) (req *request.Request, output *UpdateConfigurationSetEventDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateConfigurationSetEventDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationSetEventDestinationInput{}
	}

	output = &UpdateConfigurationSetEventDestinationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfigurationSetEventDestination API operation for Amazon Simple Email Service.
//
// Updates the event destination of a configuration set.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be either Amazon CloudWatch or
// Amazon Kinesis Firehose.
//
// Event destinations are associated with configuration sets, which enable you
// to publish email sending events to Amazon CloudWatch or Amazon Kinesis Firehose.
// For information about using configuration sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateConfigurationSetEventDestination for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConfigurationSetDoesNotExistException "ConfigurationSetDoesNotExist"
//   Indicates that the configuration set does not exist.
//
//   * ErrCodeEventDestinationDoesNotExistException "EventDestinationDoesNotExist"
//   Indicates that the event destination does not exist.
//
//   * ErrCodeInvalidCloudWatchDestinationException "InvalidCloudWatchDestination"
//   Indicates that the Amazon CloudWatch destination is invalid. See the error
//   message for details.
//
//   * ErrCodeInvalidFirehoseDestinationException "InvalidFirehoseDestination"
//   Indicates that the Amazon Kinesis Firehose destination is invalid. See the
//   error message for details.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestination
func (c *SES) UpdateConfigurationSetEventDestination(input *UpdateConfigurationSetEventDestinationInput) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	return out, req.Send()
}

// UpdateConfigurationSetEventDestinationWithContext is the same as UpdateConfigurationSetEventDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfigurationSetEventDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateConfigurationSetEventDestinationWithContext(ctx aws.Context, input *UpdateConfigurationSetEventDestinationInput, opts ...request.Option) (*UpdateConfigurationSetEventDestinationOutput, error) {
	req, out := c.UpdateConfigurationSetEventDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReceiptRule = "UpdateReceiptRule"

// UpdateReceiptRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReceiptRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateReceiptRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateReceiptRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateReceiptRuleRequest method.
//    req, resp := client.UpdateReceiptRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule
func (c *SES) UpdateReceiptRuleRequest(input *UpdateReceiptRuleInput) (req *request.Request, output *UpdateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReceiptRuleInput{}
	}

	output = &UpdateReceiptRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReceiptRule API operation for Amazon Simple Email Service.
//
// Updates a receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation UpdateReceiptRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSnsTopicException "InvalidSnsTopic"
//   Indicates that the provided Amazon SNS topic is invalid, or that Amazon SES
//   could not publish to the topic, possibly due to permissions issues. For information
//   about giving permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeInvalidS3ConfigurationException "InvalidS3Configuration"
//   Indicates that the provided Amazon S3 bucket or AWS KMS encryption key is
//   invalid, or that Amazon SES could not publish to the bucket, possibly due
//   to permissions issues. For information about giving permissions, see the
//   Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeInvalidLambdaFunctionException "InvalidLambdaFunction"
//   Indicates that the provided AWS Lambda function is invalid, or that Amazon
//   SES could not execute the provided function, possibly due to permissions
//   issues. For information about giving permissions, see the Amazon SES Developer
//   Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
//   * ErrCodeRuleSetDoesNotExistException "RuleSetDoesNotExist"
//   Indicates that the provided receipt rule set does not exist.
//
//   * ErrCodeRuleDoesNotExistException "RuleDoesNotExist"
//   Indicates that the provided receipt rule does not exist.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   Indicates that a resource could not be created because of service limits.
//   For a list of Amazon SES limits, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/limits.html).
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRule
func (c *SES) UpdateReceiptRule(input *UpdateReceiptRuleInput) (*UpdateReceiptRuleOutput, error) {
	req, out := c.UpdateReceiptRuleRequest(input)
	return out, req.Send()
}

// UpdateReceiptRuleWithContext is the same as UpdateReceiptRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReceiptRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) UpdateReceiptRuleWithContext(ctx aws.Context, input *UpdateReceiptRuleInput, opts ...request.Option) (*UpdateReceiptRuleOutput, error) {
	req, out := c.UpdateReceiptRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyDomainDkim = "VerifyDomainDkim"

// VerifyDomainDkimRequest generates a "aws/request.Request" representing the
// client's request for the VerifyDomainDkim operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyDomainDkim for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyDomainDkim method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyDomainDkimRequest method.
//    req, resp := client.VerifyDomainDkimRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim
func (c *SES) VerifyDomainDkimRequest(input *VerifyDomainDkimInput) (req *request.Request, output *VerifyDomainDkimOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainDkim,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainDkimInput{}
	}

	output = &VerifyDomainDkimOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyDomainDkim API operation for Amazon Simple Email Service.
//
// Returns a set of DKIM tokens for a domain. DKIM tokens are character strings
// that represent your domain's identity. Using these tokens, you will need
// to create DNS CNAME records that point to DKIM public keys hosted by Amazon
// SES. Amazon Web Services will eventually detect that you have updated your
// DNS records; this detection process may take up to 72 hours. Upon successful
// detection, Amazon SES will be able to DKIM-sign email originating from that
// domain.
//
// This action is throttled at one request per second.
//
// To enable or disable Easy DKIM signing for a domain, use the SetIdentityDkimEnabled
// action.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyDomainDkim for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim
func (c *SES) VerifyDomainDkim(input *VerifyDomainDkimInput) (*VerifyDomainDkimOutput, error) {
	req, out := c.VerifyDomainDkimRequest(input)
	return out, req.Send()
}

// VerifyDomainDkimWithContext is the same as VerifyDomainDkim with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyDomainDkim for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyDomainDkimWithContext(ctx aws.Context, input *VerifyDomainDkimInput, opts ...request.Option) (*VerifyDomainDkimOutput, error) {
	req, out := c.VerifyDomainDkimRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyDomainIdentity = "VerifyDomainIdentity"

// VerifyDomainIdentityRequest generates a "aws/request.Request" representing the
// client's request for the VerifyDomainIdentity operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyDomainIdentity for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyDomainIdentity method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyDomainIdentityRequest method.
//    req, resp := client.VerifyDomainIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity
func (c *SES) VerifyDomainIdentityRequest(input *VerifyDomainIdentityInput) (req *request.Request, output *VerifyDomainIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainIdentityInput{}
	}

	output = &VerifyDomainIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyDomainIdentity API operation for Amazon Simple Email Service.
//
// Verifies a domain.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyDomainIdentity for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentity
func (c *SES) VerifyDomainIdentity(input *VerifyDomainIdentityInput) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	return out, req.Send()
}

// VerifyDomainIdentityWithContext is the same as VerifyDomainIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyDomainIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyDomainIdentityWithContext(ctx aws.Context, input *VerifyDomainIdentityInput, opts ...request.Option) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyEmailAddress = "VerifyEmailAddress"

// VerifyEmailAddressRequest generates a "aws/request.Request" representing the
// client's request for the VerifyEmailAddress operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyEmailAddress for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyEmailAddress method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyEmailAddressRequest method.
//    req, resp := client.VerifyEmailAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress
func (c *SES) VerifyEmailAddressRequest(input *VerifyEmailAddressInput) (req *request.Request, output *VerifyEmailAddressOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailAddressInput{}
	}

	output = &VerifyEmailAddressOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// VerifyEmailAddress API operation for Amazon Simple Email Service.
//
// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// The VerifyEmailAddress action is deprecated as of the May 15, 2012 release
// of Domain Verification. The VerifyEmailIdentity action is now preferred.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyEmailAddress for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddress
func (c *SES) VerifyEmailAddress(input *VerifyEmailAddressInput) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	return out, req.Send()
}

// VerifyEmailAddressWithContext is the same as VerifyEmailAddress with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyEmailAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyEmailAddressWithContext(ctx aws.Context, input *VerifyEmailAddressInput, opts ...request.Option) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyEmailIdentity = "VerifyEmailIdentity"

// VerifyEmailIdentityRequest generates a "aws/request.Request" representing the
// client's request for the VerifyEmailIdentity operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See VerifyEmailIdentity for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the VerifyEmailIdentity method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the VerifyEmailIdentityRequest method.
//    req, resp := client.VerifyEmailIdentityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity
func (c *SES) VerifyEmailIdentityRequest(input *VerifyEmailIdentityInput) (req *request.Request, output *VerifyEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailIdentityInput{}
	}

	output = &VerifyEmailIdentityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyEmailIdentity API operation for Amazon Simple Email Service.
//
// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// This action is throttled at one request per second.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Email Service's
// API operation VerifyEmailIdentity for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentity
func (c *SES) VerifyEmailIdentity(input *VerifyEmailIdentityInput) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	return out, req.Send()
}

// VerifyEmailIdentityWithContext is the same as VerifyEmailIdentity with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyEmailIdentity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SES) VerifyEmailIdentityWithContext(ctx aws.Context, input *VerifyEmailIdentityInput, opts ...request.Option) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// When included in a receipt rule, this action adds a header to the received
// email.
//
// For information about adding a header using a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/AddHeaderAction
type AddHeaderAction struct {
	_ struct{} `type:"structure"`

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// HeaderName is a required field
	HeaderName *string `type:"string" required:"true"`

	// Must be less than 2048 characters, and must not contain newline characters
	// ("\r" or "\n").
	//
	// HeaderValue is a required field
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddHeaderAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddHeaderAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddHeaderAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddHeaderAction"}
	if s.HeaderName == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderName"))
	}
	if s.HeaderValue == nil {
		invalidParams.Add(request.NewErrParamRequired("HeaderValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHeaderName sets the HeaderName field's value.
func (s *AddHeaderAction) SetHeaderName(v string) *AddHeaderAction {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *AddHeaderAction) SetHeaderValue(v string) *AddHeaderAction {
	s.HeaderValue = &v
	return s
}

// Represents the body of the message. You can specify text, HTML, or both.
// If you use both, then the message should display correctly in the widest
// variety of email clients.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Body
type Body struct {
	_ struct{} `type:"structure"`

	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	Html *Content `type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Body) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Body"}
	if s.Html != nil {
		if err := s.Html.Validate(); err != nil {
			invalidParams.AddNested("Html", err.(request.ErrInvalidParams))
		}
	}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHtml sets the Html field's value.
func (s *Body) SetHtml(v *Content) *Body {
	s.Html = v
	return s
}

// SetText sets the Text field's value.
func (s *Body) SetText(v *Content) *Body {
	s.Text = v
	return s
}

// When included in a receipt rule, this action rejects the received email by
// returning a bounce response to the sender and, optionally, publishes a notification
// to Amazon Simple Notification Service (Amazon SNS).
//
// For information about sending a bounce message in response to a received
// email, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BounceAction
type BounceAction struct {
	_ struct{} `type:"structure"`

	// Human-readable text to include in the bounce message.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The email address of the sender of the bounced email. This is the address
	// from which the bounce message will be sent.
	//
	// Sender is a required field
	Sender *string `type:"string" required:"true"`

	// The SMTP reply code, as defined by RFC 5321 (https://tools.ietf.org/html/rfc5321).
	//
	// SmtpReplyCode is a required field
	SmtpReplyCode *string `type:"string" required:"true"`

	// The SMTP enhanced status code, as defined by RFC 3463 (https://tools.ietf.org/html/rfc3463).
	StatusCode *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// bounce action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s BounceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BounceAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BounceAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BounceAction"}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Sender == nil {
		invalidParams.Add(request.NewErrParamRequired("Sender"))
	}
	if s.SmtpReplyCode == nil {
		invalidParams.Add(request.NewErrParamRequired("SmtpReplyCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessage sets the Message field's value.
func (s *BounceAction) SetMessage(v string) *BounceAction {
	s.Message = &v
	return s
}

// SetSender sets the Sender field's value.
func (s *BounceAction) SetSender(v string) *BounceAction {
	s.Sender = &v
	return s
}

// SetSmtpReplyCode sets the SmtpReplyCode field's value.
func (s *BounceAction) SetSmtpReplyCode(v string) *BounceAction {
	s.SmtpReplyCode = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BounceAction) SetStatusCode(v string) *BounceAction {
	s.StatusCode = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *BounceAction) SetTopicArn(v string) *BounceAction {
	s.TopicArn = &v
	return s
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/BouncedRecipientInfo
type BouncedRecipientInfo struct {
	_ struct{} `type:"structure"`

	// The reason for the bounce. You must provide either this parameter or RecipientDsnFields.
	BounceType *string `type:"string" enum:"BounceType"`

	// The email address of the recipient of the bounced email.
	//
	// Recipient is a required field
	Recipient *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to receive email for the recipient of the bounced email. For more information
	// about sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	RecipientArn *string `type:"string"`

	// Recipient-related DSN fields, most of which would normally be filled in automatically
	// when provided with a BounceType. You must provide either this parameter or
	// BounceType.
	RecipientDsnFields *RecipientDsnFields `type:"structure"`
}

// String returns the string representation
func (s BouncedRecipientInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BouncedRecipientInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BouncedRecipientInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BouncedRecipientInfo"}
	if s.Recipient == nil {
		invalidParams.Add(request.NewErrParamRequired("Recipient"))
	}
	if s.RecipientDsnFields != nil {
		if err := s.RecipientDsnFields.Validate(); err != nil {
			invalidParams.AddNested("RecipientDsnFields", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBounceType sets the BounceType field's value.
func (s *BouncedRecipientInfo) SetBounceType(v string) *BouncedRecipientInfo {
	s.BounceType = &v
	return s
}

// SetRecipient sets the Recipient field's value.
func (s *BouncedRecipientInfo) SetRecipient(v string) *BouncedRecipientInfo {
	s.Recipient = &v
	return s
}

// SetRecipientArn sets the RecipientArn field's value.
func (s *BouncedRecipientInfo) SetRecipientArn(v string) *BouncedRecipientInfo {
	s.RecipientArn = &v
	return s
}

// SetRecipientDsnFields sets the RecipientDsnFields field's value.
func (s *BouncedRecipientInfo) SetRecipientDsnFields(v *RecipientDsnFields) *BouncedRecipientInfo {
	s.RecipientDsnFields = v
	return s
}

// Represents a request to create a receipt rule set by cloning an existing
// one. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSetRequest
type CloneReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule set to clone.
	//
	// OriginalRuleSetName is a required field
	OriginalRuleSetName *string `type:"string" required:"true"`

	// The name of the rule set to create. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CloneReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloneReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloneReceiptRuleSetInput"}
	if s.OriginalRuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginalRuleSetName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOriginalRuleSetName sets the OriginalRuleSetName field's value.
func (s *CloneReceiptRuleSetInput) SetOriginalRuleSetName(v string) *CloneReceiptRuleSetInput {
	s.OriginalRuleSetName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CloneReceiptRuleSetInput) SetRuleSetName(v string) *CloneReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloneReceiptRuleSetResponse
type CloneReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CloneReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Contains information associated with an Amazon CloudWatch event destination
// to which email sending events are published.
//
// Event destinations, such as Amazon CloudWatch, are associated with configuration
// sets, which enable you to publish email sending events. For information about
// using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloudWatchDestination
type CloudWatchDestination struct {
	_ struct{} `type:"structure"`

	// A list of dimensions upon which to categorize your emails when you publish
	// email sending events to Amazon CloudWatch.
	//
	// DimensionConfigurations is a required field
	DimensionConfigurations []*CloudWatchDimensionConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s CloudWatchDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDestination"}
	if s.DimensionConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionConfigurations"))
	}
	if s.DimensionConfigurations != nil {
		for i, v := range s.DimensionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionConfigurations sets the DimensionConfigurations field's value.
func (s *CloudWatchDestination) SetDimensionConfigurations(v []*CloudWatchDimensionConfiguration) *CloudWatchDestination {
	s.DimensionConfigurations = v
	return s
}

// Contains the dimension configuration to use when you publish email sending
// events to Amazon CloudWatch.
//
// For information about publishing email sending events to Amazon CloudWatch,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CloudWatchDimensionConfiguration
type CloudWatchDimensionConfiguration struct {
	_ struct{} `type:"structure"`

	// The default value of the dimension that is published to Amazon CloudWatch
	// if you do not provide the value of the dimension when you send an email.
	// The default value must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// DefaultDimensionValue is a required field
	DefaultDimensionValue *string `type:"string" required:"true"`

	// The name of an Amazon CloudWatch dimension associated with an email sending
	// metric. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// DimensionName is a required field
	DimensionName *string `type:"string" required:"true"`

	// The place where Amazon SES finds the value of a dimension to publish to Amazon
	// CloudWatch. If you want Amazon SES to use the message tags that you specify
	// using an X-SES-MESSAGE-TAGS header or a parameter to the SendEmail/SendRawEmail
	// API, choose messageTag. If you want Amazon SES to use your own email headers,
	// choose emailHeader.
	//
	// DimensionValueSource is a required field
	DimensionValueSource *string `type:"string" required:"true" enum:"DimensionValueSource"`
}

// String returns the string representation
func (s CloudWatchDimensionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchDimensionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchDimensionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchDimensionConfiguration"}
	if s.DefaultDimensionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultDimensionValue"))
	}
	if s.DimensionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionName"))
	}
	if s.DimensionValueSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueSource"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultDimensionValue sets the DefaultDimensionValue field's value.
func (s *CloudWatchDimensionConfiguration) SetDefaultDimensionValue(v string) *CloudWatchDimensionConfiguration {
	s.DefaultDimensionValue = &v
	return s
}

// SetDimensionName sets the DimensionName field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionName(v string) *CloudWatchDimensionConfiguration {
	s.DimensionName = &v
	return s
}

// SetDimensionValueSource sets the DimensionValueSource field's value.
func (s *CloudWatchDimensionConfiguration) SetDimensionValueSource(v string) *CloudWatchDimensionConfiguration {
	s.DimensionValueSource = &v
	return s
}

// The name of the configuration set.
//
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ConfigurationSet
type ConfigurationSet struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConfigurationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationSet) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationSet) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigurationSet"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ConfigurationSet) SetName(v string) *ConfigurationSet {
	s.Name = &v
	return s
}

// Represents textual data, plus an optional character set specification.
//
// By default, the text must be 7-bit ASCII, due to the constraints of the SMTP
// protocol. If the text must contain any other characters, then you must also
// specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Content
type Content struct {
	_ struct{} `type:"structure"`

	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	//
	// Data is a required field
	Data *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Content) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Content) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Content"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCharset sets the Charset field's value.
func (s *Content) SetCharset(v string) *Content {
	s.Charset = &v
	return s
}

// SetData sets the Data field's value.
func (s *Content) SetData(v string) *Content {
	s.Data = &v
	return s
}

// Represents a request to create a configuration set event destination. A configuration
// set event destination, which can be either Amazon CloudWatch or Amazon Kinesis
// Firehose, describes an AWS service in which Amazon SES publishes the email
// sending events associated with a configuration set. For information about
// using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestinationRequest
type CreateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to which to apply the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// An object that describes the AWS service to which Amazon SES will publish
	// the email sending events associated with the specified configuration set.
	//
	// EventDestination is a required field
	EventDestination *EventDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *CreateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *CreateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestination) *CreateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetEventDestinationResponse
type CreateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to create a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetRequest
type CreateConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the name of the configuration set.
	//
	// ConfigurationSet is a required field
	ConfigurationSet *ConfigurationSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigurationSetInput"}
	if s.ConfigurationSet == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSet"))
	}
	if s.ConfigurationSet != nil {
		if err := s.ConfigurationSet.Validate(); err != nil {
			invalidParams.AddNested("ConfigurationSet", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *CreateConfigurationSetInput) SetConfigurationSet(v *ConfigurationSet) *CreateConfigurationSetInput {
	s.ConfigurationSet = v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateConfigurationSetResponse
type CreateConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to create a new IP address filter. You use IP address
// filters when you receive email with Amazon SES. For more information, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilterRequest
type CreateReceiptFilterInput struct {
	_ struct{} `type:"structure"`

	// A data structure that describes the IP address filter to create, which consists
	// of a name, an IP address range, and whether to allow or block mail from it.
	//
	// Filter is a required field
	Filter *ReceiptFilter `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptFilterInput"}
	if s.Filter == nil {
		invalidParams.Add(request.NewErrParamRequired("Filter"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *CreateReceiptFilterInput) SetFilter(v *ReceiptFilter) *CreateReceiptFilterInput {
	s.Filter = v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptFilterResponse
type CreateReceiptFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptFilterOutput) GoString() string {
	return s.String()
}

// Represents a request to create a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleRequest
type CreateReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing rule after which the new rule will be placed. If
	// this parameter is null, the new rule will be inserted at the beginning of
	// the rule list.
	After *string `type:"string"`

	// A data structure that contains the specified rule's name, actions, recipients,
	// domains, enabled status, scan status, and TLS policy.
	//
	// Rule is a required field
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the rule set to which to add the rule.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfter sets the After field's value.
func (s *CreateReceiptRuleInput) SetAfter(v string) *CreateReceiptRuleInput {
	s.After = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *CreateReceiptRuleInput) SetRule(v *ReceiptRule) *CreateReceiptRuleInput {
	s.Rule = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateReceiptRuleInput) SetRuleSetName(v string) *CreateReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleResponse
type CreateReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request to create an empty receipt rule set. You use receipt
// rule sets to receive email with Amazon SES. For more information, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSetRequest
type CreateReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the rule set to create. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *CreateReceiptRuleSetInput) SetRuleSetName(v string) *CreateReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/CreateReceiptRuleSetResponse
type CreateReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a configuration set event destination. Configuration
// set event destinations are associated with configuration sets, which enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestinationRequest
type DeleteConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set from which to delete the event destination.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// The name of the event destination to delete.
	//
	// EventDestinationName is a required field
	EventDestinationName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestinationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestinationName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestinationName sets the EventDestinationName field's value.
func (s *DeleteConfigurationSetEventDestinationInput) SetEventDestinationName(v string) *DeleteConfigurationSetEventDestinationInput {
	s.EventDestinationName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetEventDestinationResponse
type DeleteConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetRequest
type DeleteConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to delete.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DeleteConfigurationSetInput) SetConfigurationSetName(v string) *DeleteConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteConfigurationSetResponse
type DeleteConfigurationSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete one of your Amazon SES identities (an email
// address or domain).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityRequest
type DeleteIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity to be removed from the list of identities for the AWS Account.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *DeleteIdentityInput) SetIdentity(v string) *DeleteIdentityInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityResponse
type DeleteIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a sending authorization policy for an identity.
// Sending authorization is an Amazon SES feature that enables you to authorize
// other senders to use your identities. For information, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicyRequest
type DeleteIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity that is associated with the policy that you want to delete.
	// You can specify the identity by using its name or by using its Amazon Resource
	// Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The name of the policy to be deleted.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIdentityPolicyInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *DeleteIdentityPolicyInput) SetIdentity(v string) *DeleteIdentityPolicyInput {
	s.Identity = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteIdentityPolicyInput) SetPolicyName(v string) *DeleteIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentityPolicyResponse
type DeleteIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an IP address filter. You use IP address filters
// when you receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilterRequest
type DeleteReceiptFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the IP address filter to delete.
	//
	// FilterName is a required field
	FilterName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptFilterInput"}
	if s.FilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("FilterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterName sets the FilterName field's value.
func (s *DeleteReceiptFilterInput) SetFilterName(v string) *DeleteReceiptFilterInput {
	s.FilterName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptFilterResponse
type DeleteReceiptFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptFilterOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleRequest
type DeleteReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule to delete.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to delete.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DeleteReceiptRuleInput) SetRuleName(v string) *DeleteReceiptRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DeleteReceiptRuleInput) SetRuleSetName(v string) *DeleteReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleResponse
type DeleteReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request to delete a receipt rule set and all of the receipt
// rules it contains. You use receipt rule sets to receive email with Amazon
// SES. For more information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSetRequest
type DeleteReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to delete.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DeleteReceiptRuleSetInput) SetRuleSetName(v string) *DeleteReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteReceiptRuleSetResponse
type DeleteReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to delete an email address from the list of email addresses
// you have attempted to verify under your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddressRequest
type DeleteVerifiedEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// An email address to be removed from the list of verified addresses.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVerifiedEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVerifiedEmailAddressInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *DeleteVerifiedEmailAddressInput) SetEmailAddress(v string) *DeleteVerifiedEmailAddressInput {
	s.EmailAddress = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteVerifiedEmailAddressOutput
type DeleteVerifiedEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents a request to return the metadata and receipt rules for the receipt
// rule set that is currently active. You use receipt rule sets to receive email
// with Amazon SES. For more information, see the Amazon SES Developer Guide
// (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSetRequest
type DescribeActiveReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Represents the metadata and receipt rules for the receipt rule set that is
// currently active.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeActiveReceiptRuleSetResponse
type DescribeActiveReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and a timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// The receipt rules that belong to the active rule set.
	Rules []*ReceiptRule `type:"list"`
}

// String returns the string representation
func (s DescribeActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *DescribeActiveReceiptRuleSetOutput) SetMetadata(v *ReceiptRuleSetMetadata) *DescribeActiveReceiptRuleSetOutput {
	s.Metadata = v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeActiveReceiptRuleSetOutput) SetRules(v []*ReceiptRule) *DescribeActiveReceiptRuleSetOutput {
	s.Rules = v
	return s
}

// Represents a request to return the details of a configuration set. Configuration
// sets enable you to publish email sending events. For information about using
// configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSetRequest
type DescribeConfigurationSetInput struct {
	_ struct{} `type:"structure"`

	// A list of configuration set attributes to return.
	ConfigurationSetAttributeNames []*string `type:"list"`

	// The name of the configuration set to describe.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeConfigurationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConfigurationSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConfigurationSetInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetAttributeNames sets the ConfigurationSetAttributeNames field's value.
func (s *DescribeConfigurationSetInput) SetConfigurationSetAttributeNames(v []*string) *DescribeConfigurationSetInput {
	s.ConfigurationSetAttributeNames = v
	return s
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *DescribeConfigurationSetInput) SetConfigurationSetName(v string) *DescribeConfigurationSetInput {
	s.ConfigurationSetName = &v
	return s
}

// Represents the details of a configuration set. Configuration sets enable
// you to publish email sending events. For information about using configuration
// sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeConfigurationSetResponse
type DescribeConfigurationSetOutput struct {
	_ struct{} `type:"structure"`

	// The configuration set object associated with the specified configuration
	// set.
	ConfigurationSet *ConfigurationSet `type:"structure"`

	// A list of event destinations associated with the configuration set.
	EventDestinations []*EventDestination `type:"list"`
}

// String returns the string representation
func (s DescribeConfigurationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSetOutput) GoString() string {
	return s.String()
}

// SetConfigurationSet sets the ConfigurationSet field's value.
func (s *DescribeConfigurationSetOutput) SetConfigurationSet(v *ConfigurationSet) *DescribeConfigurationSetOutput {
	s.ConfigurationSet = v
	return s
}

// SetEventDestinations sets the EventDestinations field's value.
func (s *DescribeConfigurationSetOutput) SetEventDestinations(v []*EventDestination) *DescribeConfigurationSetOutput {
	s.EventDestinations = v
	return s
}

// Represents a request to return the details of a receipt rule. You use receipt
// rules to receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleRequest
type DescribeReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set to which the receipt rule belongs.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReceiptRuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleName sets the RuleName field's value.
func (s *DescribeReceiptRuleInput) SetRuleName(v string) *DescribeReceiptRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeReceiptRuleInput) SetRuleSetName(v string) *DescribeReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// Represents the details of a receipt rule.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleResponse
type DescribeReceiptRuleOutput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the specified receipt rule's name, actions,
	// recipients, domains, enabled status, scan status, and Transport Layer Security
	// (TLS) policy.
	Rule *ReceiptRule `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *DescribeReceiptRuleOutput) SetRule(v *ReceiptRule) *DescribeReceiptRuleOutput {
	s.Rule = v
	return s
}

// Represents a request to return the details of a receipt rule set. You use
// receipt rule sets to receive email with Amazon SES. For more information,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSetRequest
type DescribeReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to describe.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReceiptRuleSetInput"}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *DescribeReceiptRuleSetInput) SetRuleSetName(v string) *DescribeReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// Represents the details of the specified receipt rule set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSetResponse
type DescribeReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the receipt rule set, which consists of the rule set name
	// and the timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// A list of the receipt rules that belong to the specified receipt rule set.
	Rules []*ReceiptRule `type:"list"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *DescribeReceiptRuleSetOutput) SetMetadata(v *ReceiptRuleSetMetadata) *DescribeReceiptRuleSetOutput {
	s.Metadata = v
	return s
}

// SetRules sets the Rules field's value.
func (s *DescribeReceiptRuleSetOutput) SetRules(v []*ReceiptRule) *DescribeReceiptRuleSetOutput {
	s.Rules = v
	return s
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields.
//
// By default, the string must be 7-bit ASCII. If the text must contain any
// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// The BCC: field(s) of the message.
	BccAddresses []*string `type:"list"`

	// The CC: field(s) of the message.
	CcAddresses []*string `type:"list"`

	// The To: field(s) of the message.
	ToAddresses []*string `type:"list"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// SetBccAddresses sets the BccAddresses field's value.
func (s *Destination) SetBccAddresses(v []*string) *Destination {
	s.BccAddresses = v
	return s
}

// SetCcAddresses sets the CcAddresses field's value.
func (s *Destination) SetCcAddresses(v []*string) *Destination {
	s.CcAddresses = v
	return s
}

// SetToAddresses sets the ToAddresses field's value.
func (s *Destination) SetToAddresses(v []*string) *Destination {
	s.ToAddresses = v
	return s
}

// Contains information about the event destination to which the specified email
// sending events are published.
//
// When you create or update an event destination, you must provide one, and
// only one, destination. The destination can be either Amazon CloudWatch or
// Amazon Kinesis Firehose.
//
// Event destinations are associated with configuration sets, which enable you
// to publish email sending events to Amazon CloudWatch or Amazon Kinesis Firehose.
// For information about using configuration sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/EventDestination
type EventDestination struct {
	_ struct{} `type:"structure"`

	// An object that contains the names, default values, and sources of the dimensions
	// associated with an Amazon CloudWatch event destination.
	CloudWatchDestination *CloudWatchDestination `type:"structure"`

	// Sets whether Amazon SES publishes events to this destination when you send
	// an email with the associated configuration set. Set to true to enable publishing
	// to this destination; set to false to prevent publishing to this destination.
	// The default value is false.
	Enabled *bool `type:"boolean"`

	// An object that contains the delivery stream ARN and the IAM role ARN associated
	// with an Amazon Kinesis Firehose event destination.
	KinesisFirehoseDestination *KinesisFirehoseDestination `type:"structure"`

	// The type of email sending events to publish to the event destination.
	//
	// MatchingEventTypes is a required field
	MatchingEventTypes []*string `type:"list" required:"true"`

	// The name of the event destination. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EventDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventDestination"}
	if s.MatchingEventTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("MatchingEventTypes"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.CloudWatchDestination != nil {
		if err := s.CloudWatchDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseDestination != nil {
		if err := s.KinesisFirehoseDestination.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchDestination sets the CloudWatchDestination field's value.
func (s *EventDestination) SetCloudWatchDestination(v *CloudWatchDestination) *EventDestination {
	s.CloudWatchDestination = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventDestination) SetEnabled(v bool) *EventDestination {
	s.Enabled = &v
	return s
}

// SetKinesisFirehoseDestination sets the KinesisFirehoseDestination field's value.
func (s *EventDestination) SetKinesisFirehoseDestination(v *KinesisFirehoseDestination) *EventDestination {
	s.KinesisFirehoseDestination = v
	return s
}

// SetMatchingEventTypes sets the MatchingEventTypes field's value.
func (s *EventDestination) SetMatchingEventTypes(v []*string) *EventDestination {
	s.MatchingEventTypes = v
	return s
}

// SetName sets the Name field's value.
func (s *EventDestination) SetName(v string) *EventDestination {
	s.Name = &v
	return s
}

// Additional X-headers to include in the Delivery Status Notification (DSN)
// when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ExtensionField
type ExtensionField struct {
	_ struct{} `type:"structure"`

	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the header to add. Must be less than 2048 characters, and must
	// not contain newline characters ("\r" or "\n").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExtensionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtensionField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtensionField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtensionField"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ExtensionField) SetName(v string) *ExtensionField {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExtensionField) SetValue(v string) *ExtensionField {
	s.Value = &v
	return s
}

// Represents a request for the status of Amazon SES Easy DKIM signing for an
// identity. For domain identities, this request also returns the DKIM tokens
// that are required for Easy DKIM signing, and whether Amazon SES successfully
// verified that these tokens were published. For more information about Easy
// DKIM, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributesRequest
type GetIdentityDkimAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more verified identities - email addresses, domains, or
	// both.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDkimAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityDkimAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityDkimAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityDkimAttributesInput) SetIdentities(v []*string) *GetIdentityDkimAttributesInput {
	s.Identities = v
	return s
}

// Represents the status of Amazon SES Easy DKIM signing for an identity. For
// domain identities, this response also contains the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES successfully verified that
// these tokens were published.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityDkimAttributesResponse
type GetIdentityDkimAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The DKIM attributes for an email address or a domain.
	//
	// DkimAttributes is a required field
	DkimAttributes map[string]*IdentityDkimAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDkimAttributesOutput) GoString() string {
	return s.String()
}

// SetDkimAttributes sets the DkimAttributes field's value.
func (s *GetIdentityDkimAttributesOutput) SetDkimAttributes(v map[string]*IdentityDkimAttributes) *GetIdentityDkimAttributesOutput {
	s.DkimAttributes = v
	return s
}

// Represents a request to return the Amazon SES custom MAIL FROM attributes
// for a list of identities. For information about using a custom MAIL FROM
// domain, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributesRequest
type GetIdentityMailFromDomainAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityMailFromDomainAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityMailFromDomainAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityMailFromDomainAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityMailFromDomainAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityMailFromDomainAttributesInput) SetIdentities(v []*string) *GetIdentityMailFromDomainAttributesInput {
	s.Identities = v
	return s
}

// Represents the custom MAIL FROM attributes for a list of identities.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityMailFromDomainAttributesResponse
type GetIdentityMailFromDomainAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of identities to custom MAIL FROM attributes.
	//
	// MailFromDomainAttributes is a required field
	MailFromDomainAttributes map[string]*IdentityMailFromDomainAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityMailFromDomainAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityMailFromDomainAttributesOutput) GoString() string {
	return s.String()
}

// SetMailFromDomainAttributes sets the MailFromDomainAttributes field's value.
func (s *GetIdentityMailFromDomainAttributesOutput) SetMailFromDomainAttributes(v map[string]*IdentityMailFromDomainAttributes) *GetIdentityMailFromDomainAttributesOutput {
	s.MailFromDomainAttributes = v
	return s
}

// Represents a request to return the notification attributes for a list of
// identities you verified with Amazon SES. For information about Amazon SES
// notifications, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributesRequest
type GetIdentityNotificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of one or more identities. You can specify an identity by using its
	// name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityNotificationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityNotificationAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityNotificationAttributesInput) SetIdentities(v []*string) *GetIdentityNotificationAttributesInput {
	s.Identities = v
	return s
}

// Represents the notification attributes for a list of identities.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityNotificationAttributesResponse
type GetIdentityNotificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of Identity to IdentityNotificationAttributes.
	//
	// NotificationAttributes is a required field
	NotificationAttributes map[string]*IdentityNotificationAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesOutput) GoString() string {
	return s.String()
}

// SetNotificationAttributes sets the NotificationAttributes field's value.
func (s *GetIdentityNotificationAttributesOutput) SetNotificationAttributes(v map[string]*IdentityNotificationAttributes) *GetIdentityNotificationAttributesOutput {
	s.NotificationAttributes = v
	return s
}

// Represents a request to return the requested sending authorization policies
// for an identity. Sending authorization is an Amazon SES feature that enables
// you to authorize other senders to use your identities. For information, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPoliciesRequest
type GetIdentityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The identity for which the policies will be retrieved. You can specify an
	// identity by using its name or by using its Amazon Resource Name (ARN). Examples:
	// user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// A list of the names of policies to be retrieved. You can retrieve a maximum
	// of 20 policies at a time. If you do not know the names of the policies that
	// are attached to the identity, you can use ListIdentityPolicies.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityPoliciesInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.PolicyNames == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *GetIdentityPoliciesInput) SetIdentity(v string) *GetIdentityPoliciesInput {
	s.Identity = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *GetIdentityPoliciesInput) SetPolicyNames(v []*string) *GetIdentityPoliciesInput {
	s.PolicyNames = v
	return s
}

// Represents the requested sending authorization policies.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityPoliciesResponse
type GetIdentityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A map of policy names to policies.
	//
	// Policies is a required field
	Policies map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicies sets the Policies field's value.
func (s *GetIdentityPoliciesOutput) SetPolicies(v map[string]*string) *GetIdentityPoliciesOutput {
	s.Policies = v
	return s
}

// Represents a request to return the Amazon SES verification status of a list
// of identities. For domain identities, this request also returns the verification
// token. For information about verifying identities with Amazon SES, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributesRequest
type GetIdentityVerificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityVerificationAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityVerificationAttributesInput"}
	if s.Identities == nil {
		invalidParams.Add(request.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentities sets the Identities field's value.
func (s *GetIdentityVerificationAttributesInput) SetIdentities(v []*string) *GetIdentityVerificationAttributesInput {
	s.Identities = v
	return s
}

// The Amazon SES verification status of a list of identities. For domain identities,
// this response also contains the verification token.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributesResponse
type GetIdentityVerificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of Identities to IdentityVerificationAttributes objects.
	//
	// VerificationAttributes is a required field
	VerificationAttributes map[string]*IdentityVerificationAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesOutput) GoString() string {
	return s.String()
}

// SetVerificationAttributes sets the VerificationAttributes field's value.
func (s *GetIdentityVerificationAttributesOutput) SetVerificationAttributes(v map[string]*IdentityVerificationAttributes) *GetIdentityVerificationAttributesOutput {
	s.VerificationAttributes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuotaInput
type GetSendQuotaInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetSendQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaInput) GoString() string {
	return s.String()
}

// Represents your Amazon SES daily sending quota, maximum send rate, and the
// number of emails you have sent in the last 24 hours.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendQuotaResponse
type GetSendQuotaOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of emails the user is allowed to send in a 24-hour interval.
	// A value of -1 signifies an unlimited quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that Amazon SES can accept from the user's account
	// per second.
	//
	// The rate at which Amazon SES accepts the user's messages might be less than
	// the maximum send rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent during the previous 24 hours.
	SentLast24Hours *float64 `type:"double"`
}

// String returns the string representation
func (s GetSendQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaOutput) GoString() string {
	return s.String()
}

// SetMax24HourSend sets the Max24HourSend field's value.
func (s *GetSendQuotaOutput) SetMax24HourSend(v float64) *GetSendQuotaOutput {
	s.Max24HourSend = &v
	return s
}

// SetMaxSendRate sets the MaxSendRate field's value.
func (s *GetSendQuotaOutput) SetMaxSendRate(v float64) *GetSendQuotaOutput {
	s.MaxSendRate = &v
	return s
}

// SetSentLast24Hours sets the SentLast24Hours field's value.
func (s *GetSendQuotaOutput) SetSentLast24Hours(v float64) *GetSendQuotaOutput {
	s.SentLast24Hours = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatisticsInput
type GetSendStatisticsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetSendStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsInput) GoString() string {
	return s.String()
}

// Represents a list of data points. This list contains aggregated data from
// the previous two weeks of your sending activity with Amazon SES.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetSendStatisticsResponse
type GetSendStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// A list of data points, each of which represents 15 minutes of activity.
	SendDataPoints []*SendDataPoint `type:"list"`
}

// String returns the string representation
func (s GetSendStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsOutput) GoString() string {
	return s.String()
}

// SetSendDataPoints sets the SendDataPoints field's value.
func (s *GetSendStatisticsOutput) SetSendDataPoints(v []*SendDataPoint) *GetSendStatisticsOutput {
	s.SendDataPoints = v
	return s
}

// Represents the DKIM attributes of a verified email address or a domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityDkimAttributes
type IdentityDkimAttributes struct {
	_ struct{} `type:"structure"`

	// True if DKIM signing is enabled for email sent from the identity; false otherwise.
	// The default value is true.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you will need to create DNS CNAME records that point to DKIM public
	// keys hosted by Amazon SES. Amazon Web Services will eventually detect that
	// you have updated your DNS records; this detection process may take up to
	// 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DkimTokens []*string `type:"list"`

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	//
	// DkimVerificationStatus is a required field
	DkimVerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`
}

// String returns the string representation
func (s IdentityDkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityDkimAttributes) GoString() string {
	return s.String()
}

// SetDkimEnabled sets the DkimEnabled field's value.
func (s *IdentityDkimAttributes) SetDkimEnabled(v bool) *IdentityDkimAttributes {
	s.DkimEnabled = &v
	return s
}

// SetDkimTokens sets the DkimTokens field's value.
func (s *IdentityDkimAttributes) SetDkimTokens(v []*string) *IdentityDkimAttributes {
	s.DkimTokens = v
	return s
}

// SetDkimVerificationStatus sets the DkimVerificationStatus field's value.
func (s *IdentityDkimAttributes) SetDkimVerificationStatus(v string) *IdentityDkimAttributes {
	s.DkimVerificationStatus = &v
	return s
}

// Represents the custom MAIL FROM domain attributes of a verified identity
// (email address or domain).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityMailFromDomainAttributes
type IdentityMailFromDomainAttributes struct {
	_ struct{} `type:"structure"`

	// The action that Amazon SES takes if it cannot successfully read the required
	// MX record when you send an email. A value of UseDefaultValue indicates that
	// if Amazon SES cannot read the required MX record, it uses amazonses.com (or
	// a subdomain of that) as the MAIL FROM domain. A value of RejectMessage indicates
	// that if Amazon SES cannot read the required MX record, Amazon SES returns
	// a MailFromDomainNotVerified error and does not send the email.
	//
	// The custom MAIL FROM setup states that result in this behavior are Pending,
	// Failed, and TemporaryFailure.
	//
	// BehaviorOnMXFailure is a required field
	BehaviorOnMXFailure *string `type:"string" required:"true" enum:"BehaviorOnMXFailure"`

	// The custom MAIL FROM domain that the identity is configured to use.
	//
	// MailFromDomain is a required field
	MailFromDomain *string `type:"string" required:"true"`

	// The state that indicates whether Amazon SES has successfully read the MX
	// record required for custom MAIL FROM domain setup. If the state is Success,
	// Amazon SES uses the specified custom MAIL FROM domain when the verified identity
	// sends an email. All other states indicate that Amazon SES takes the action
	// described by BehaviorOnMXFailure.
	//
	// MailFromDomainStatus is a required field
	MailFromDomainStatus *string `type:"string" required:"true" enum:"CustomMailFromStatus"`
}

// String returns the string representation
func (s IdentityMailFromDomainAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityMailFromDomainAttributes) GoString() string {
	return s.String()
}

// SetBehaviorOnMXFailure sets the BehaviorOnMXFailure field's value.
func (s *IdentityMailFromDomainAttributes) SetBehaviorOnMXFailure(v string) *IdentityMailFromDomainAttributes {
	s.BehaviorOnMXFailure = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *IdentityMailFromDomainAttributes) SetMailFromDomain(v string) *IdentityMailFromDomainAttributes {
	s.MailFromDomain = &v
	return s
}

// SetMailFromDomainStatus sets the MailFromDomainStatus field's value.
func (s *IdentityMailFromDomainAttributes) SetMailFromDomainStatus(v string) *IdentityMailFromDomainAttributes {
	s.MailFromDomainStatus = &v
	return s
}

// Represents the notification attributes of an identity, including whether
// an identity has Amazon Simple Notification Service (Amazon SNS) topics set
// for bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityNotificationAttributes
type IdentityNotificationAttributes struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish bounce notifications.
	//
	// BounceTopic is a required field
	BounceTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish complaint notifications.
	//
	// ComplaintTopic is a required field
	ComplaintTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish delivery notifications.
	//
	// DeliveryTopic is a required field
	DeliveryTopic *string `type:"string" required:"true"`

	// Describes whether Amazon SES will forward bounce and complaint notifications
	// as email. true indicates that Amazon SES will forward bounce and complaint
	// notifications as email, while false indicates that bounce and complaint notifications
	// will be published only to the specified bounce and complaint Amazon SNS topics.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Bounce. A value of true specifies that Amazon SES
	// will include headers in bounce notifications, and a value of false specifies
	// that Amazon SES will not include headers in bounce notifications.
	HeadersInBounceNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Complaint. A value of true specifies that Amazon
	// SES will include headers in complaint notifications, and a value of false
	// specifies that Amazon SES will not include headers in complaint notifications.
	HeadersInComplaintNotificationsEnabled *bool `type:"boolean"`

	// Describes whether Amazon SES includes the original email headers in Amazon
	// SNS notifications of type Delivery. A value of true specifies that Amazon
	// SES will include headers in delivery notifications, and a value of false
	// specifies that Amazon SES will not include headers in delivery notifications.
	HeadersInDeliveryNotificationsEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s IdentityNotificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityNotificationAttributes) GoString() string {
	return s.String()
}

// SetBounceTopic sets the BounceTopic field's value.
func (s *IdentityNotificationAttributes) SetBounceTopic(v string) *IdentityNotificationAttributes {
	s.BounceTopic = &v
	return s
}

// SetComplaintTopic sets the ComplaintTopic field's value.
func (s *IdentityNotificationAttributes) SetComplaintTopic(v string) *IdentityNotificationAttributes {
	s.ComplaintTopic = &v
	return s
}

// SetDeliveryTopic sets the DeliveryTopic field's value.
func (s *IdentityNotificationAttributes) SetDeliveryTopic(v string) *IdentityNotificationAttributes {
	s.DeliveryTopic = &v
	return s
}

// SetForwardingEnabled sets the ForwardingEnabled field's value.
func (s *IdentityNotificationAttributes) SetForwardingEnabled(v bool) *IdentityNotificationAttributes {
	s.ForwardingEnabled = &v
	return s
}

// SetHeadersInBounceNotificationsEnabled sets the HeadersInBounceNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInBounceNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInBounceNotificationsEnabled = &v
	return s
}

// SetHeadersInComplaintNotificationsEnabled sets the HeadersInComplaintNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInComplaintNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInComplaintNotificationsEnabled = &v
	return s
}

// SetHeadersInDeliveryNotificationsEnabled sets the HeadersInDeliveryNotificationsEnabled field's value.
func (s *IdentityNotificationAttributes) SetHeadersInDeliveryNotificationsEnabled(v bool) *IdentityNotificationAttributes {
	s.HeadersInDeliveryNotificationsEnabled = &v
	return s
}

// Represents the verification attributes of a single identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/IdentityVerificationAttributes
type IdentityVerificationAttributes struct {
	_ struct{} `type:"structure"`

	// The verification status of the identity: "Pending", "Success", "Failed",
	// or "TemporaryFailure".
	//
	// VerificationStatus is a required field
	VerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string `type:"string"`
}

// String returns the string representation
func (s IdentityVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityVerificationAttributes) GoString() string {
	return s.String()
}

// SetVerificationStatus sets the VerificationStatus field's value.
func (s *IdentityVerificationAttributes) SetVerificationStatus(v string) *IdentityVerificationAttributes {
	s.VerificationStatus = &v
	return s
}

// SetVerificationToken sets the VerificationToken field's value.
func (s *IdentityVerificationAttributes) SetVerificationToken(v string) *IdentityVerificationAttributes {
	s.VerificationToken = &v
	return s
}

// Contains the delivery stream ARN and the IAM role ARN associated with an
// Amazon Kinesis Firehose event destination.
//
// Event destinations, such as Amazon Kinesis Firehose, are associated with
// configuration sets, which enable you to publish email sending events. For
// information about using configuration sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/KinesisFirehoseDestination
type KinesisFirehoseDestination struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Kinesis Firehose stream to which to publish email sending
	// events.
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `type:"string" required:"true"`

	// The ARN of the IAM role under which Amazon SES publishes email sending events
	// to the Amazon Kinesis Firehose stream.
	//
	// IAMRoleARN is a required field
	IAMRoleARN *string `type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisFirehoseDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseDestination"}
	if s.DeliveryStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamARN"))
	}
	if s.IAMRoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("IAMRoleARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *KinesisFirehoseDestination) SetDeliveryStreamARN(v string) *KinesisFirehoseDestination {
	s.DeliveryStreamARN = &v
	return s
}

// SetIAMRoleARN sets the IAMRoleARN field's value.
func (s *KinesisFirehoseDestination) SetIAMRoleARN(v string) *KinesisFirehoseDestination {
	s.IAMRoleARN = &v
	return s
}

// When included in a receipt rule, this action calls an AWS Lambda function
// and, optionally, publishes a notification to Amazon Simple Notification Service
// (Amazon SNS).
//
// To enable Amazon SES to call your AWS Lambda function or to publish to an
// Amazon SNS topic of another account, Amazon SES must have permission to access
// those resources. For information about giving permissions, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// For information about using AWS Lambda actions in receipt rules, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/LambdaAction
type LambdaAction struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Lambda function. An example of
	// an AWS Lambda function ARN is arn:aws:lambda:us-west-2:account-id:function:MyFunction.
	// For more information about AWS Lambda, see the AWS Lambda Developer Guide
	// (http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
	//
	// FunctionArn is a required field
	FunctionArn *string `type:"string" required:"true"`

	// The invocation type of the AWS Lambda function. An invocation type of RequestResponse
	// means that the execution of the function will immediately result in a response,
	// and a value of Event means that the function will be invoked asynchronously.
	// The default value is Event. For information about AWS Lambda invocation types,
	// see the AWS Lambda Developer Guide (http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html).
	//
	// There is a 30-second timeout on RequestResponse invocations. You should use
	// Event invocation in most cases. Use RequestResponse only when you want to
	// make a mail flow decision, such as whether to stop the receipt rule or the
	// receipt rule set.
	InvocationType *string `type:"string" enum:"InvocationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// Lambda action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaAction"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *LambdaAction) SetFunctionArn(v string) *LambdaAction {
	s.FunctionArn = &v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *LambdaAction) SetInvocationType(v string) *LambdaAction {
	s.InvocationType = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *LambdaAction) SetTopicArn(v string) *LambdaAction {
	s.TopicArn = &v
	return s
}

// Represents a request to list the configuration sets associated with your
// AWS account. Configuration sets enable you to publish email sending events.
// For information about using configuration sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSetsRequest
type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// The number of configuration sets to return.
	MaxItems *int64 `type:"integer"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position of the configuration set in the configuration set list.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsInput) GoString() string {
	return s.String()
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListConfigurationSetsInput) SetMaxItems(v int64) *ListConfigurationSetsInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsInput) SetNextToken(v string) *ListConfigurationSetsInput {
	s.NextToken = &v
	return s
}

// A list of configuration sets associated with your AWS account. Configuration
// sets enable you to publish email sending events. For information about using
// configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListConfigurationSetsResponse
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of configuration sets.
	ConfigurationSets []*ConfigurationSet `type:"list"`

	// A token indicating that there are additional configuration sets available
	// to be listed. Pass this token to successive calls of ListConfigurationSets.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigurationSetsOutput) GoString() string {
	return s.String()
}

// SetConfigurationSets sets the ConfigurationSets field's value.
func (s *ListConfigurationSetsOutput) SetConfigurationSets(v []*ConfigurationSet) *ListConfigurationSetsOutput {
	s.ConfigurationSets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigurationSetsOutput) SetNextToken(v string) *ListConfigurationSetsOutput {
	s.NextToken = &v
	return s
}

// Represents a request to return a list of all identities (email addresses
// and domains) that you have attempted to verify under your AWS account, regardless
// of verification status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentitiesRequest
type ListIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// The type of the identities to list. Possible values are "EmailAddress" and
	// "Domain". If this parameter is omitted, then all identities will be listed.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The maximum number of identities per page. Possible values are 1-1000 inclusive.
	MaxItems *int64 `type:"integer"`

	// The token to use for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// SetIdentityType sets the IdentityType field's value.
func (s *ListIdentitiesInput) SetIdentityType(v string) *ListIdentitiesInput {
	s.IdentityType = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListIdentitiesInput) SetMaxItems(v int64) *ListIdentitiesInput {
	s.MaxItems = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesInput) SetNextToken(v string) *ListIdentitiesInput {
	s.NextToken = &v
	return s
}

// A list of all identities that you have attempted to verify under your AWS
// account, regardless of verification status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentitiesResponse
type ListIdentitiesOutput struct {
	_ struct{} `type:"structure"`

	// A list of identities.
	//
	// Identities is a required field
	Identities []*string `type:"list" required:"true"`

	// The token used for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// SetIdentities sets the Identities field's value.
func (s *ListIdentitiesOutput) SetIdentities(v []*string) *ListIdentitiesOutput {
	s.Identities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentitiesOutput) SetNextToken(v string) *ListIdentitiesOutput {
	s.NextToken = &v
	return s
}

// Represents a request to return a list of sending authorization policies that
// are attached to an identity. Sending authorization is an Amazon SES feature
// that enables you to authorize other senders to use your identities. For information,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPoliciesRequest
type ListIdentityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The identity that is associated with the policy for which the policies will
	// be listed. You can specify an identity by using its name or by using its
	// Amazon Resource Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityPoliciesInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *ListIdentityPoliciesInput) SetIdentity(v string) *ListIdentityPoliciesInput {
	s.Identity = &v
	return s
}

// A list of names of sending authorization policies that apply to an identity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListIdentityPoliciesResponse
type ListIdentityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of names of policies that apply to the specified identity.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListIdentityPoliciesOutput) SetPolicyNames(v []*string) *ListIdentityPoliciesOutput {
	s.PolicyNames = v
	return s
}

// Represents a request to list the IP address filters that exist under your
// AWS account. You use IP address filters when you receive email with Amazon
// SES. For more information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFiltersRequest
type ListReceiptFiltersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListReceiptFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptFiltersInput) GoString() string {
	return s.String()
}

// A list of IP address filters that exist under your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptFiltersResponse
type ListReceiptFiltersOutput struct {
	_ struct{} `type:"structure"`

	// A list of IP address filter data structures, which each consist of a name,
	// an IP address range, and whether to allow or block mail from it.
	Filters []*ReceiptFilter `type:"list"`
}

// String returns the string representation
func (s ListReceiptFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptFiltersOutput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *ListReceiptFiltersOutput) SetFilters(v []*ReceiptFilter) *ListReceiptFiltersOutput {
	s.Filters = v
	return s
}

// Represents a request to list the receipt rule sets that exist under your
// AWS account. You use receipt rule sets to receive email with Amazon SES.
// For more information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSetsRequest
type ListReceiptRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListReceiptRuleSets to indicate
	// the position in the receipt rule set list.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListReceiptRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptRuleSetsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReceiptRuleSetsInput) SetNextToken(v string) *ListReceiptRuleSetsInput {
	s.NextToken = &v
	return s
}

// A list of receipt rule sets that exist under your AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListReceiptRuleSetsResponse
type ListReceiptRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// A token indicating that there are additional receipt rule sets available
	// to be listed. Pass this token to successive calls of ListReceiptRuleSets
	// to retrieve up to 100 receipt rule sets at a time.
	NextToken *string `type:"string"`

	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and the timestamp of when the rule set was created.
	RuleSets []*ReceiptRuleSetMetadata `type:"list"`
}

// String returns the string representation
func (s ListReceiptRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptRuleSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReceiptRuleSetsOutput) SetNextToken(v string) *ListReceiptRuleSetsOutput {
	s.NextToken = &v
	return s
}

// SetRuleSets sets the RuleSets field's value.
func (s *ListReceiptRuleSetsOutput) SetRuleSets(v []*ReceiptRuleSetMetadata) *ListReceiptRuleSetsOutput {
	s.RuleSets = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddressesInput
type ListVerifiedEmailAddressesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesInput) GoString() string {
	return s.String()
}

// A list of email addresses that you have verified with Amazon SES under your
// AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ListVerifiedEmailAddressesResponse
type ListVerifiedEmailAddressesOutput struct {
	_ struct{} `type:"structure"`

	// A list of email addresses that have been verified.
	VerifiedEmailAddresses []*string `type:"list"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesOutput) GoString() string {
	return s.String()
}

// SetVerifiedEmailAddresses sets the VerifiedEmailAddresses field's value.
func (s *ListVerifiedEmailAddressesOutput) SetVerifiedEmailAddresses(v []*string) *ListVerifiedEmailAddressesOutput {
	s.VerifiedEmailAddresses = v
	return s
}

// Represents the message to be sent, composed of a subject and a body.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/Message
type Message struct {
	_ struct{} `type:"structure"`

	// The message body.
	//
	// Body is a required field
	Body *Body `type:"structure" required:"true"`

	// The subject of the message: A short summary of the content, which will appear
	// in the recipient's inbox.
	//
	// Subject is a required field
	Subject *Content `type:"structure" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Message"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.Body != nil {
		if err := s.Body.Validate(); err != nil {
			invalidParams.AddNested("Body", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *Message) SetBody(v *Body) *Message {
	s.Body = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *Message) SetSubject(v *Content) *Message {
	s.Subject = v
	return s
}

// Message-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/MessageDsn
type MessageDsn struct {
	_ struct{} `type:"structure"`

	// When the message was received by the reporting mail transfer agent (MTA),
	// in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt) date-time format.
	ArrivalDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The reporting MTA that attempted to deliver the message, formatted as specified
	// in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type; mta-name).
	// The default value is dns; inbound-smtp.[region].amazonaws.com.
	//
	// ReportingMta is a required field
	ReportingMta *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageDsn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageDsn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageDsn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageDsn"}
	if s.ReportingMta == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportingMta"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrivalDate sets the ArrivalDate field's value.
func (s *MessageDsn) SetArrivalDate(v time.Time) *MessageDsn {
	s.ArrivalDate = &v
	return s
}

// SetExtensionFields sets the ExtensionFields field's value.
func (s *MessageDsn) SetExtensionFields(v []*ExtensionField) *MessageDsn {
	s.ExtensionFields = v
	return s
}

// SetReportingMta sets the ReportingMta field's value.
func (s *MessageDsn) SetReportingMta(v string) *MessageDsn {
	s.ReportingMta = &v
	return s
}

// Contains the name and value of a tag that you can provide to SendEmail or
// SendRawEmail to apply to an email.
//
// Message tags, which you use with configuration sets, enable you to publish
// email sending events. For information about using configuration sets, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/MessageTag
type MessageTag struct {
	_ struct{} `type:"structure"`

	// The name of the tag. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the tag. The value must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), underscores (_),
	//    or dashes (-).
	//
	//    * Contain less than 256 characters.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MessageTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MessageTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MessageTag"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *MessageTag) SetName(v string) *MessageTag {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MessageTag) SetValue(v string) *MessageTag {
	s.Value = &v
	return s
}

// Represents a request to add or update a sending authorization policy for
// an identity. Sending authorization is an Amazon SES feature that enables
// you to authorize other senders to use your identities. For information, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicyRequest
type PutIdentityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The identity to which the policy will apply. You can specify an identity
	// by using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see the
	// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIdentityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIdentityPolicyInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *PutIdentityPolicyInput) SetIdentity(v string) *PutIdentityPolicyInput {
	s.Identity = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutIdentityPolicyInput) SetPolicy(v string) *PutIdentityPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutIdentityPolicyInput) SetPolicyName(v string) *PutIdentityPolicyInput {
	s.PolicyName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/PutIdentityPolicyResponse
type PutIdentityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents the raw data of the message.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/RawMessage
type RawMessage struct {
	_ struct{} `type:"structure"`

	// The raw data of the message. The client must ensure that the message format
	// complies with Internet email standards regarding email header fields, MIME
	// types, MIME encoding, and base64 encoding.
	//
	// The To:, CC:, and BCC: headers in the raw message can contain a group list.
	//
	// If you are using SendRawEmail with sending authorization, you can include
	// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
	// addresses. For more information, see the documentation for SendRawEmail.
	//
	// Do not include these X-headers in the DKIM signature, because they are removed
	// by Amazon SES before sending the email.
	//
	// For more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html).
	//
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RawMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RawMessage"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *RawMessage) SetData(v []byte) *RawMessage {
	s.Data = v
	return s
}

// An action that Amazon SES can take when it receives an email on behalf of
// one or more email addresses or domains that you own. An instance of this
// data type can represent only one action.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptAction
type ReceiptAction struct {
	_ struct{} `type:"structure"`

	// Adds a header to the received email.
	AddHeaderAction *AddHeaderAction `type:"structure"`

	// Rejects the received email by returning a bounce response to the sender and,
	// optionally, publishes a notification to Amazon Simple Notification Service
	// (Amazon SNS).
	BounceAction *BounceAction `type:"structure"`

	// Calls an AWS Lambda function, and optionally, publishes a notification to
	// Amazon SNS.
	LambdaAction *LambdaAction `type:"structure"`

	// Saves the received message to an Amazon Simple Storage Service (Amazon S3)
	// bucket and, optionally, publishes a notification to Amazon SNS.
	S3Action *S3Action `type:"structure"`

	// Publishes the email content within a notification to Amazon SNS.
	SNSAction *SNSAction `type:"structure"`

	// Terminates the evaluation of the receipt rule set and optionally publishes
	// a notification to Amazon SNS.
	StopAction *StopAction `type:"structure"`

	// Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
	// SNS.
	WorkmailAction *WorkmailAction `type:"structure"`
}

// String returns the string representation
func (s ReceiptAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptAction"}
	if s.AddHeaderAction != nil {
		if err := s.AddHeaderAction.Validate(); err != nil {
			invalidParams.AddNested("AddHeaderAction", err.(request.ErrInvalidParams))
		}
	}
	if s.BounceAction != nil {
		if err := s.BounceAction.Validate(); err != nil {
			invalidParams.AddNested("BounceAction", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaAction != nil {
		if err := s.LambdaAction.Validate(); err != nil {
			invalidParams.AddNested("LambdaAction", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Action != nil {
		if err := s.S3Action.Validate(); err != nil {
			invalidParams.AddNested("S3Action", err.(request.ErrInvalidParams))
		}
	}
	if s.SNSAction != nil {
		if err := s.SNSAction.Validate(); err != nil {
			invalidParams.AddNested("SNSAction", err.(request.ErrInvalidParams))
		}
	}
	if s.StopAction != nil {
		if err := s.StopAction.Validate(); err != nil {
			invalidParams.AddNested("StopAction", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkmailAction != nil {
		if err := s.WorkmailAction.Validate(); err != nil {
			invalidParams.AddNested("WorkmailAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddHeaderAction sets the AddHeaderAction field's value.
func (s *ReceiptAction) SetAddHeaderAction(v *AddHeaderAction) *ReceiptAction {
	s.AddHeaderAction = v
	return s
}

// SetBounceAction sets the BounceAction field's value.
func (s *ReceiptAction) SetBounceAction(v *BounceAction) *ReceiptAction {
	s.BounceAction = v
	return s
}

// SetLambdaAction sets the LambdaAction field's value.
func (s *ReceiptAction) SetLambdaAction(v *LambdaAction) *ReceiptAction {
	s.LambdaAction = v
	return s
}

// SetS3Action sets the S3Action field's value.
func (s *ReceiptAction) SetS3Action(v *S3Action) *ReceiptAction {
	s.S3Action = v
	return s
}

// SetSNSAction sets the SNSAction field's value.
func (s *ReceiptAction) SetSNSAction(v *SNSAction) *ReceiptAction {
	s.SNSAction = v
	return s
}

// SetStopAction sets the StopAction field's value.
func (s *ReceiptAction) SetStopAction(v *StopAction) *ReceiptAction {
	s.StopAction = v
	return s
}

// SetWorkmailAction sets the WorkmailAction field's value.
func (s *ReceiptAction) SetWorkmailAction(v *WorkmailAction) *ReceiptAction {
	s.WorkmailAction = v
	return s
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptFilter
type ReceiptFilter struct {
	_ struct{} `type:"structure"`

	// A structure that provides the IP addresses to block or allow, and whether
	// to block or allow incoming mail from them.
	//
	// IpFilter is a required field
	IpFilter *ReceiptIpFilter `type:"structure" required:"true"`

	// The name of the IP address filter. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ReceiptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptFilter"}
	if s.IpFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("IpFilter"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.IpFilter != nil {
		if err := s.IpFilter.Validate(); err != nil {
			invalidParams.AddNested("IpFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpFilter sets the IpFilter field's value.
func (s *ReceiptFilter) SetIpFilter(v *ReceiptIpFilter) *ReceiptFilter {
	s.IpFilter = v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptFilter) SetName(v string) *ReceiptFilter {
	s.Name = &v
	return s
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptIpFilter
type ReceiptIpFilter struct {
	_ struct{} `type:"structure"`

	// A single IP address or a range of IP addresses that you want to block or
	// allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example
	// of a single email address is 10.0.0.1. An example of a range of IP addresses
	// is 10.0.0.1/24. For more information about CIDR notation, see RFC 2317 (https://tools.ietf.org/html/rfc2317).
	//
	// Cidr is a required field
	Cidr *string `type:"string" required:"true"`

	// Indicates whether to block or allow incoming mail from the specified IP addresses.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true" enum:"ReceiptFilterPolicy"`
}

// String returns the string representation
func (s ReceiptIpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptIpFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptIpFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptIpFilter"}
	if s.Cidr == nil {
		invalidParams.Add(request.NewErrParamRequired("Cidr"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidr sets the Cidr field's value.
func (s *ReceiptIpFilter) SetCidr(v string) *ReceiptIpFilter {
	s.Cidr = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *ReceiptIpFilter) SetPolicy(v string) *ReceiptIpFilter {
	s.Policy = &v
	return s
}

// Receipt rules enable you to specify which actions Amazon SES should take
// when it receives mail on behalf of one or more email addresses or domains
// that you own.
//
// Each receipt rule defines a set of email addresses or domains to which it
// applies. If the email addresses or domains match at least one recipient address
// of the message, Amazon SES executes all of the receipt rule's actions on
// the message.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptRule
type ReceiptRule struct {
	_ struct{} `type:"structure"`

	// An ordered list of actions to perform on messages that match at least one
	// of the recipient email addresses or domains specified in the receipt rule.
	Actions []*ReceiptAction `type:"list"`

	// If true, the receipt rule is active. The default value is false.
	Enabled *bool `type:"boolean"`

	// The name of the receipt rule. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The recipient domains and email addresses to which the receipt rule applies.
	// If this field is not specified, this rule will match all recipients under
	// all verified domains.
	Recipients []*string `type:"list"`

	// If true, then messages to which this receipt rule applies are scanned for
	// spam and viruses. The default value is false.
	ScanEnabled *bool `type:"boolean"`

	// Specifies whether Amazon SES should require that incoming email is delivered
	// over a connection encrypted with Transport Layer Security (TLS). If this
	// parameter is set to Require, Amazon SES will bounce emails that are not received
	// over TLS. The default is Optional.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`
}

// String returns the string representation
func (s ReceiptRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReceiptRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReceiptRule"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *ReceiptRule) SetActions(v []*ReceiptAction) *ReceiptRule {
	s.Actions = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ReceiptRule) SetEnabled(v bool) *ReceiptRule {
	s.Enabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptRule) SetName(v string) *ReceiptRule {
	s.Name = &v
	return s
}

// SetRecipients sets the Recipients field's value.
func (s *ReceiptRule) SetRecipients(v []*string) *ReceiptRule {
	s.Recipients = v
	return s
}

// SetScanEnabled sets the ScanEnabled field's value.
func (s *ReceiptRule) SetScanEnabled(v bool) *ReceiptRule {
	s.ScanEnabled = &v
	return s
}

// SetTlsPolicy sets the TlsPolicy field's value.
func (s *ReceiptRule) SetTlsPolicy(v string) *ReceiptRule {
	s.TlsPolicy = &v
	return s
}

// Information about a receipt rule set.
//
// A receipt rule set is a collection of rules that specify what Amazon SES
// should do with mail it receives on behalf of your account's verified domains.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReceiptRuleSetMetadata
type ReceiptRuleSetMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time the receipt rule set was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the receipt rule set. The name must:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-).
	//
	//    * Start and end with a letter or number.
	//
	//    * Contain less than 64 characters.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ReceiptRuleSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptRuleSetMetadata) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *ReceiptRuleSetMetadata) SetCreatedTimestamp(v time.Time) *ReceiptRuleSetMetadata {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReceiptRuleSetMetadata) SetName(v string) *ReceiptRuleSetMetadata {
	s.Name = &v
	return s
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/RecipientDsnFields
type RecipientDsnFields struct {
	_ struct{} `type:"structure"`

	// The action performed by the reporting mail transfer agent (MTA) as a result
	// of its attempt to deliver the message to the recipient address. This is required
	// by RFC 3464 (https://tools.ietf.org/html/rfc3464).
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"DsnAction"`

	// An extended explanation of what went wrong; this is usually an SMTP response.
	// See RFC 3463 (https://tools.ietf.org/html/rfc3463) for the correct formatting
	// of this parameter.
	DiagnosticCode *string `type:"string"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The email address to which the message was ultimately delivered. This corresponds
	// to the Final-Recipient in the DSN. If not specified, FinalRecipient will
	// be set to the Recipient specified in the BouncedRecipientInfo structure.
	// Either FinalRecipient or the recipient in BouncedRecipientInfo must be a
	// recipient of the original bounced message.
	//
	// Do not prepend the FinalRecipient email address with rfc 822;, as described
	// in RFC 3798 (https://tools.ietf.org/html/rfc3798).
	FinalRecipient *string `type:"string"`

	// The time the final delivery attempt was made, in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt)
	// date-time format.
	LastAttemptDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The MTA to which the remote MTA attempted to deliver the message, formatted
	// as specified in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type;
	// mta-name). This parameter typically applies only to propagating synchronous
	// bounces.
	RemoteMta *string `type:"string"`

	// The status code that indicates what went wrong. This is required by RFC 3464
	// (https://tools.ietf.org/html/rfc3464).
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RecipientDsnFields) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecipientDsnFields) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecipientDsnFields) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecipientDsnFields"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.ExtensionFields != nil {
		for i, v := range s.ExtensionFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtensionFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RecipientDsnFields) SetAction(v string) *RecipientDsnFields {
	s.Action = &v
	return s
}

// SetDiagnosticCode sets the DiagnosticCode field's value.
func (s *RecipientDsnFields) SetDiagnosticCode(v string) *RecipientDsnFields {
	s.DiagnosticCode = &v
	return s
}

// SetExtensionFields sets the ExtensionFields field's value.
func (s *RecipientDsnFields) SetExtensionFields(v []*ExtensionField) *RecipientDsnFields {
	s.ExtensionFields = v
	return s
}

// SetFinalRecipient sets the FinalRecipient field's value.
func (s *RecipientDsnFields) SetFinalRecipient(v string) *RecipientDsnFields {
	s.FinalRecipient = &v
	return s
}

// SetLastAttemptDate sets the LastAttemptDate field's value.
func (s *RecipientDsnFields) SetLastAttemptDate(v time.Time) *RecipientDsnFields {
	s.LastAttemptDate = &v
	return s
}

// SetRemoteMta sets the RemoteMta field's value.
func (s *RecipientDsnFields) SetRemoteMta(v string) *RecipientDsnFields {
	s.RemoteMta = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecipientDsnFields) SetStatus(v string) *RecipientDsnFields {
	s.Status = &v
	return s
}

// Represents a request to reorder the receipt rules within a receipt rule set.
// You use receipt rule sets to receive email with Amazon SES. For more information,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSetRequest
type ReorderReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// A list of the specified receipt rule set's receipt rules in the order that
	// you want to put them.
	//
	// RuleNames is a required field
	RuleNames []*string `type:"list" required:"true"`

	// The name of the receipt rule set to reorder.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ReorderReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReorderReceiptRuleSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReorderReceiptRuleSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReorderReceiptRuleSetInput"}
	if s.RuleNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleNames"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleNames sets the RuleNames field's value.
func (s *ReorderReceiptRuleSetInput) SetRuleNames(v []*string) *ReorderReceiptRuleSetInput {
	s.RuleNames = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *ReorderReceiptRuleSetInput) SetRuleSetName(v string) *ReorderReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/ReorderReceiptRuleSetResponse
type ReorderReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ReorderReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReorderReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action saves the received message to
// an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
// a notification to Amazon Simple Notification Service (Amazon SNS).
//
// To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS
// KMS key to encrypt your emails, or publish to an Amazon SNS topic of another
// account, Amazon SES must have permission to access those resources. For information
// about giving permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// When you save your emails to an Amazon S3 bucket, the maximum email size
// (including headers) is 30 MB. Emails larger than that will bounce.
//
// For information about specifying Amazon S3 actions in receipt rules, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/S3Action
type S3Action struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket to which to save the received email.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The customer master key that Amazon SES should use to encrypt your emails
	// before saving them to the Amazon S3 bucket. You can use the default master
	// key or a custom master key you created in AWS KMS as follows:
	//
	//    * To use the default master key, provide an ARN in the form of arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses.
	//    For example, if your AWS account ID is 123456789012 and you want to use
	//    the default master key in the US West (Oregon) region, the ARN of the
	//    default master key would be arn:aws:kms:us-west-2:123456789012:alias/aws/ses.
	//    If you use the default master key, you don't need to perform any extra
	//    steps to give Amazon SES permission to use the key.
	//
	//    * To use a custom master key you created in AWS KMS, provide the ARN of
	//    the master key and ensure that you add a statement to your key's policy
	//    to give Amazon SES permission to use it. For more information about giving
	//    permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
	//
	// For more information about key policies, see the AWS KMS Developer Guide
	// (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html). If
	// you do not specify a master key, Amazon SES will not encrypt your emails.
	//
	// Your mail is encrypted by Amazon SES using the Amazon S3 encryption client
	// before the mail is submitted to Amazon S3 for storage. It is not encrypted
	// using Amazon S3 server-side encryption. This means that you must use the
	// Amazon S3 encryption client to decrypt the email after retrieving it from
	// Amazon S3, as the service has no access to use your AWS KMS keys for decryption.
	// This encryption client is currently available with the AWS Java SDK (http://aws.amazon.com/sdk-for-java/)
	// and AWS Ruby SDK (http://aws.amazon.com/sdk-for-ruby/) only. For more information
	// about client-side encryption using AWS KMS master keys, see the Amazon S3
	// Developer Guide (http://alpha-docs-aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
	KmsKeyArn *string `type:"string"`

	// The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory
	// name that enables you to store similar data under the same directory in a
	// bucket.
	ObjectKeyPrefix *string `type:"string"`

	// The ARN of the Amazon SNS topic to notify when the message is saved to the
	// Amazon S3 bucket. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Action"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3Action) SetBucketName(v string) *S3Action {
	s.BucketName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *S3Action) SetKmsKeyArn(v string) *S3Action {
	s.KmsKeyArn = &v
	return s
}

// SetObjectKeyPrefix sets the ObjectKeyPrefix field's value.
func (s *S3Action) SetObjectKeyPrefix(v string) *S3Action {
	s.ObjectKeyPrefix = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *S3Action) SetTopicArn(v string) *S3Action {
	s.TopicArn = &v
	return s
}

// When included in a receipt rule, this action publishes a notification to
// Amazon Simple Notification Service (Amazon SNS). This action includes a complete
// copy of the email content in the Amazon SNS notifications. Amazon SNS notifications
// for all other actions simply provide information about the email. They do
// not include the email content itself.
//
// If you own the Amazon SNS topic, you don't need to do anything to give Amazon
// SES permission to publish emails to it. However, if you don't own the Amazon
// SNS topic, you need to attach a policy to the topic to give Amazon SES permissions
// to access it. For information about giving permissions, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// You can only publish emails that are 150 KB or less (including the header)
// to Amazon SNS. Larger emails will bounce. If you anticipate emails larger
// than 150 KB, use the S3 action instead.
//
// For information about using a receipt rule to publish an Amazon SNS notification,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SNSAction
type SNSAction struct {
	_ struct{} `type:"structure"`

	// The encoding to use for the email within the Amazon SNS notification. UTF-8
	// is easier to use, but may not preserve all special characters when a message
	// was encoded with a different encoding format. Base64 preserves all special
	// characters. The default value is UTF-8.
	Encoding *string `type:"string" enum:"SNSActionEncoding"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example
	// of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	//
	// TopicArn is a required field
	TopicArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SNSAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SNSAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SNSAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SNSAction"}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncoding sets the Encoding field's value.
func (s *SNSAction) SetEncoding(v string) *SNSAction {
	s.Encoding = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *SNSAction) SetTopicArn(v string) *SNSAction {
	s.TopicArn = &v
	return s
}

// Represents a request to send a bounce message to the sender of an email you
// received through Amazon SES.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounceRequest
type SendBounceInput struct {
	_ struct{} `type:"structure"`

	// The address to use in the "From" header of the bounce message. This must
	// be an identity that you have verified with Amazon SES.
	//
	// BounceSender is a required field
	BounceSender *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the address in the "From" header of the bounce. For more information
	// about sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	BounceSenderArn *string `type:"string"`

	// A list of recipients of the bounced message, including the information required
	// to create the Delivery Status Notifications (DSNs) for the recipients. You
	// must specify at least one BouncedRecipientInfo in the list.
	//
	// BouncedRecipientInfoList is a required field
	BouncedRecipientInfoList []*BouncedRecipientInfo `type:"list" required:"true"`

	// Human-readable text for the bounce message to explain the failure. If not
	// specified, the text will be auto-generated based on the bounced recipient
	// information.
	Explanation *string `type:"string"`

	// Message-related DSN fields. If not specified, Amazon SES will choose the
	// values.
	MessageDsn *MessageDsn `type:"structure"`

	// The message ID of the message to be bounced.
	//
	// OriginalMessageId is a required field
	OriginalMessageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendBounceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBounceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendBounceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendBounceInput"}
	if s.BounceSender == nil {
		invalidParams.Add(request.NewErrParamRequired("BounceSender"))
	}
	if s.BouncedRecipientInfoList == nil {
		invalidParams.Add(request.NewErrParamRequired("BouncedRecipientInfoList"))
	}
	if s.OriginalMessageId == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginalMessageId"))
	}
	if s.BouncedRecipientInfoList != nil {
		for i, v := range s.BouncedRecipientInfoList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BouncedRecipientInfoList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MessageDsn != nil {
		if err := s.MessageDsn.Validate(); err != nil {
			invalidParams.AddNested("MessageDsn", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBounceSender sets the BounceSender field's value.
func (s *SendBounceInput) SetBounceSender(v string) *SendBounceInput {
	s.BounceSender = &v
	return s
}

// SetBounceSenderArn sets the BounceSenderArn field's value.
func (s *SendBounceInput) SetBounceSenderArn(v string) *SendBounceInput {
	s.BounceSenderArn = &v
	return s
}

// SetBouncedRecipientInfoList sets the BouncedRecipientInfoList field's value.
func (s *SendBounceInput) SetBouncedRecipientInfoList(v []*BouncedRecipientInfo) *SendBounceInput {
	s.BouncedRecipientInfoList = v
	return s
}

// SetExplanation sets the Explanation field's value.
func (s *SendBounceInput) SetExplanation(v string) *SendBounceInput {
	s.Explanation = &v
	return s
}

// SetMessageDsn sets the MessageDsn field's value.
func (s *SendBounceInput) SetMessageDsn(v *MessageDsn) *SendBounceInput {
	s.MessageDsn = v
	return s
}

// SetOriginalMessageId sets the OriginalMessageId field's value.
func (s *SendBounceInput) SetOriginalMessageId(v string) *SendBounceInput {
	s.OriginalMessageId = &v
	return s
}

// Represents a unique message ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendBounceResponse
type SendBounceOutput struct {
	_ struct{} `type:"structure"`

	// The message ID of the bounce message.
	MessageId *string `type:"string"`
}

// String returns the string representation
func (s SendBounceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBounceOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendBounceOutput) SetMessageId(v string) *SendBounceOutput {
	s.MessageId = &v
	return s
}

// Represents sending statistics data. Each SendDataPoint contains statistics
// for a 15-minute period of sending activity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendDataPoint
type SendDataPoint struct {
	_ struct{} `type:"structure"`

	// Number of emails that have bounced.
	Bounces *int64 `type:"long"`

	// Number of unwanted emails that were rejected by recipients.
	Complaints *int64 `type:"long"`

	// Number of emails that have been sent.
	DeliveryAttempts *int64 `type:"long"`

	// Number of emails rejected by Amazon SES.
	Rejects *int64 `type:"long"`

	// Time of the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SendDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendDataPoint) GoString() string {
	return s.String()
}

// SetBounces sets the Bounces field's value.
func (s *SendDataPoint) SetBounces(v int64) *SendDataPoint {
	s.Bounces = &v
	return s
}

// SetComplaints sets the Complaints field's value.
func (s *SendDataPoint) SetComplaints(v int64) *SendDataPoint {
	s.Complaints = &v
	return s
}

// SetDeliveryAttempts sets the DeliveryAttempts field's value.
func (s *SendDataPoint) SetDeliveryAttempts(v int64) *SendDataPoint {
	s.DeliveryAttempts = &v
	return s
}

// SetRejects sets the Rejects field's value.
func (s *SendDataPoint) SetRejects(v int64) *SendDataPoint {
	s.Rejects = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SendDataPoint) SetTimestamp(v time.Time) *SendDataPoint {
	s.Timestamp = &v
	return s
}

// Represents a request to send a single formatted email using Amazon SES. For
// more information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-formatted.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmailRequest
type SendEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendEmail.
	ConfigurationSetName *string `type:"string"`

	// The destination for this email, composed of To:, CC:, and BCC: fields.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// The message to be sent.
	//
	// Message is a required field
	Message *Message `type:"structure" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address will receive the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address to which bounces and complaints are to be forwarded when
	// feedback forwarding is enabled. If the message cannot be delivered to the
	// recipient, then an error message will be returned from the recipient's ISP;
	// this message will then be forwarded to the email address specified by the
	// ReturnPath parameter. The ReturnPath parameter is never overwritten. This
	// email address must be either individually verified with Amazon SES, or from
	// a domain that has been verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	ReturnPathArn *string `type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
	//
	// If you are sending on behalf of another user and have been permitted to do
	// so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	//
	// In all cases, the email address must be 7-bit ASCII. If the text must contain
	// any other characters, then you must use MIME encoded-word syntax (RFC 2047)
	// instead of a literal string. MIME encoded-word syntax uses the following
	// form: =?charset?encoding?encoded-text?=. For more information, see RFC 2047
	// (http://tools.ietf.org/html/rfc2047).
	//
	// Source is a required field
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	SourceArn *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendEmail. Tags correspond to characteristics of the email
	// that you define, so that you can publish email sending events.
	Tags []*MessageTag `type:"list"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEmailInput"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Message != nil {
		if err := s.Message.Validate(); err != nil {
			invalidParams.AddNested("Message", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendEmailInput) SetConfigurationSetName(v string) *SendEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *SendEmailInput) SetDestination(v *Destination) *SendEmailInput {
	s.Destination = v
	return s
}

// SetMessage sets the Message field's value.
func (s *SendEmailInput) SetMessage(v *Message) *SendEmailInput {
	s.Message = v
	return s
}

// SetReplyToAddresses sets the ReplyToAddresses field's value.
func (s *SendEmailInput) SetReplyToAddresses(v []*string) *SendEmailInput {
	s.ReplyToAddresses = v
	return s
}

// SetReturnPath sets the ReturnPath field's value.
func (s *SendEmailInput) SetReturnPath(v string) *SendEmailInput {
	s.ReturnPath = &v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendEmailInput) SetReturnPathArn(v string) *SendEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendEmailInput) SetSource(v string) *SendEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendEmailInput) SetSourceArn(v string) *SendEmailInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SendEmailInput) SetTags(v []*MessageTag) *SendEmailInput {
	s.Tags = v
	return s
}

// Represents a unique message ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendEmailResponse
type SendEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendEmail action.
	//
	// MessageId is a required field
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendEmailOutput) SetMessageId(v string) *SendEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to send a single raw email using Amazon SES. For more
// information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmailRequest
type SendRawEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set to use when you send an email using SendRawEmail.
	ConfigurationSetName *string `type:"string"`

	// A list of destinations for the message, consisting of To:, CC:, and BCC:
	// addresses.
	Destinations []*string `type:"list"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to specify a particular "From" address in the header of the raw email.
	//
	// Instead of using this parameter, you can use the X-header X-SES-FROM-ARN
	// in the raw message of the email. If you use both the FromArn parameter and
	// the corresponding X-header, Amazon SES uses the value of the FromArn parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	FromArn *string `type:"string"`

	// The raw text of the message. The client is responsible for ensuring the following:
	//
	//    * Message must contain a header and a body, separated by a blank line.
	//
	//    * All required header fields must be present.
	//
	//    * Each part of a multipart MIME message must be formatted properly.
	//
	//    * MIME content types must be among those supported by Amazon SES. For
	//    more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html).
	//
	//    * Must be base64-encoded.
	//
	// RawMessage is a required field
	RawMessage *RawMessage `type:"structure" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-RETURN-PATH-ARN
	// in the raw message of the email. If you use both the ReturnPathArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the ReturnPathArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	ReturnPathArn *string `type:"string"`

	// The identity's email address. If you do not provide a value for this parameter,
	// you must specify a "From" address in the raw text of the message. (You can
	// also specify both.)
	//
	// By default, the string must be 7-bit ASCII. If the text must contain any
	// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
	// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
	// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
	//
	// If you specify the Source parameter and have feedback forwarding enabled,
	// then bounces and complaints will be sent to this email address. This takes
	// precedence over any Return-Path header that you might include in the raw
	// text of the message.
	Source *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-SOURCE-ARN
	// in the raw message of the email. If you use both the SourceArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the SourceArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	SourceArn *string `type:"string"`

	// A list of tags, in the form of name/value pairs, to apply to an email that
	// you send using SendRawEmail. Tags correspond to characteristics of the email
	// that you define, so that you can publish email sending events.
	Tags []*MessageTag `type:"list"`
}

// String returns the string representation
func (s SendRawEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendRawEmailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendRawEmailInput"}
	if s.RawMessage == nil {
		invalidParams.Add(request.NewErrParamRequired("RawMessage"))
	}
	if s.RawMessage != nil {
		if err := s.RawMessage.Validate(); err != nil {
			invalidParams.AddNested("RawMessage", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *SendRawEmailInput) SetConfigurationSetName(v string) *SendRawEmailInput {
	s.ConfigurationSetName = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *SendRawEmailInput) SetDestinations(v []*string) *SendRawEmailInput {
	s.Destinations = v
	return s
}

// SetFromArn sets the FromArn field's value.
func (s *SendRawEmailInput) SetFromArn(v string) *SendRawEmailInput {
	s.FromArn = &v
	return s
}

// SetRawMessage sets the RawMessage field's value.
func (s *SendRawEmailInput) SetRawMessage(v *RawMessage) *SendRawEmailInput {
	s.RawMessage = v
	return s
}

// SetReturnPathArn sets the ReturnPathArn field's value.
func (s *SendRawEmailInput) SetReturnPathArn(v string) *SendRawEmailInput {
	s.ReturnPathArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *SendRawEmailInput) SetSource(v string) *SendRawEmailInput {
	s.Source = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *SendRawEmailInput) SetSourceArn(v string) *SendRawEmailInput {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SendRawEmailInput) SetTags(v []*MessageTag) *SendRawEmailInput {
	s.Tags = v
	return s
}

// Represents a unique message ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SendRawEmailResponse
type SendRawEmailOutput struct {
	_ struct{} `type:"structure"`

	// The unique message identifier returned from the SendRawEmail action.
	//
	// MessageId is a required field
	MessageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SendRawEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendRawEmailOutput) SetMessageId(v string) *SendRawEmailOutput {
	s.MessageId = &v
	return s
}

// Represents a request to set a receipt rule set as the active receipt rule
// set. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSetRequest
type SetActiveReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to make active. Setting this value to null
	// disables all email receiving.
	RuleSetName *string `type:"string"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *SetActiveReceiptRuleSetInput) SetRuleSetName(v string) *SetActiveReceiptRuleSetInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetActiveReceiptRuleSetResponse
type SetActiveReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable Amazon SES Easy DKIM signing for
// an identity. For more information about setting up Easy DKIM, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabledRequest
type SetIdentityDkimEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether DKIM signing is enabled for an identity. Set to true to enable
	// DKIM signing for this identity; false to disable it.
	//
	// DkimEnabled is a required field
	DkimEnabled *bool `type:"boolean" required:"true"`

	// The identity for which DKIM signing should be enabled or disabled.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDkimEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityDkimEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityDkimEnabledInput"}
	if s.DkimEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("DkimEnabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDkimEnabled sets the DkimEnabled field's value.
func (s *SetIdentityDkimEnabledInput) SetDkimEnabled(v bool) *SetIdentityDkimEnabledInput {
	s.DkimEnabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityDkimEnabledInput) SetIdentity(v string) *SetIdentityDkimEnabledInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityDkimEnabledResponse
type SetIdentityDkimEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDkimEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable whether Amazon SES forwards you
// bounce and complaint notifications through email. For information about email
// feedback forwarding, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-email.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabledRequest
type SetIdentityFeedbackForwardingEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES will forward bounce and complaint notifications as
	// email. true specifies that Amazon SES will forward bounce and complaint notifications
	// as email, in addition to any Amazon SNS topic publishing otherwise specified.
	// false specifies that Amazon SES will publish bounce and complaint notifications
	// only through Amazon SNS. This value can only be set to false when Amazon
	// SNS topics are set for both Bounce and Complaint notification types.
	//
	// ForwardingEnabled is a required field
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// The identity for which to set bounce and complaint notification forwarding.
	// Examples: user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityFeedbackForwardingEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityFeedbackForwardingEnabledInput"}
	if s.ForwardingEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("ForwardingEnabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForwardingEnabled sets the ForwardingEnabled field's value.
func (s *SetIdentityFeedbackForwardingEnabledInput) SetForwardingEnabled(v bool) *SetIdentityFeedbackForwardingEnabledInput {
	s.ForwardingEnabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityFeedbackForwardingEnabledInput) SetIdentity(v string) *SetIdentityFeedbackForwardingEnabledInput {
	s.Identity = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityFeedbackForwardingEnabledResponse
type SetIdentityFeedbackForwardingEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to set whether Amazon SES includes the original email
// headers in the Amazon SNS notifications of a specified type. For information
// about notifications, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabledRequest
type SetIdentityHeadersInNotificationsEnabledInput struct {
	_ struct{} `type:"structure"`

	// Sets whether Amazon SES includes the original email headers in Amazon SNS
	// notifications of the specified notification type. A value of true specifies
	// that Amazon SES will include headers in notifications, and a value of false
	// specifies that Amazon SES will not include headers in notifications.
	//
	// This value can only be set when NotificationType is already set to use a
	// particular Amazon SNS topic.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// The identity for which to enable or disable headers in notifications. Examples:
	// user@example.com, example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The notification type for which to enable or disable headers in notifications.
	//
	// NotificationType is a required field
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`
}

// String returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityHeadersInNotificationsEnabledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityHeadersInNotificationsEnabledInput"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.NotificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetEnabled(v bool) *SetIdentityHeadersInNotificationsEnabledInput {
	s.Enabled = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetIdentity(v string) *SetIdentityHeadersInNotificationsEnabledInput {
	s.Identity = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *SetIdentityHeadersInNotificationsEnabledInput) SetNotificationType(v string) *SetIdentityHeadersInNotificationsEnabledInput {
	s.NotificationType = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityHeadersInNotificationsEnabledResponse
type SetIdentityHeadersInNotificationsEnabledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityHeadersInNotificationsEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to enable or disable the Amazon SES custom MAIL FROM
// domain setup for a verified identity. For information about using a custom
// MAIL FROM domain, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomainRequest
type SetIdentityMailFromDomainInput struct {
	_ struct{} `type:"structure"`

	// The action that you want Amazon SES to take if it cannot successfully read
	// the required MX record when you send an email. If you choose UseDefaultValue,
	// Amazon SES will use amazonses.com (or a subdomain of that) as the MAIL FROM
	// domain. If you choose RejectMessage, Amazon SES will return a MailFromDomainNotVerified
	// error and not send the email.
	//
	// The action specified in BehaviorOnMXFailure is taken when the custom MAIL
	// FROM domain setup is in the Pending, Failed, and TemporaryFailure states.
	BehaviorOnMXFailure *string `type:"string" enum:"BehaviorOnMXFailure"`

	// The verified identity for which you want to enable or disable the specified
	// custom MAIL FROM domain.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The custom MAIL FROM domain that you want the verified identity to use. The
	// MAIL FROM domain must 1) be a subdomain of the verified identity, 2) not
	// be used in a "From" address if the MAIL FROM domain is the destination of
	// email feedback forwarding (for more information, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html)),
	// and 3) not be used to receive emails. A value of null disables the custom
	// MAIL FROM setting for the identity.
	MailFromDomain *string `type:"string"`
}

// String returns the string representation
func (s SetIdentityMailFromDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityMailFromDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityMailFromDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityMailFromDomainInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBehaviorOnMXFailure sets the BehaviorOnMXFailure field's value.
func (s *SetIdentityMailFromDomainInput) SetBehaviorOnMXFailure(v string) *SetIdentityMailFromDomainInput {
	s.BehaviorOnMXFailure = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityMailFromDomainInput) SetIdentity(v string) *SetIdentityMailFromDomainInput {
	s.Identity = &v
	return s
}

// SetMailFromDomain sets the MailFromDomain field's value.
func (s *SetIdentityMailFromDomainInput) SetMailFromDomain(v string) *SetIdentityMailFromDomainInput {
	s.MailFromDomain = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityMailFromDomainResponse
type SetIdentityMailFromDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityMailFromDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityMailFromDomainOutput) GoString() string {
	return s.String()
}

// Represents a request to specify the Amazon SNS topic to which Amazon SES
// will publish bounce, complaint, or delivery notifications for emails sent
// with that identity as the Source. For information about Amazon SES notifications,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications-via-sns.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopicRequest
type SetIdentityNotificationTopicInput struct {
	_ struct{} `type:"structure"`

	// The identity for which the Amazon SNS topic will be set. You can specify
	// an identity by using its name or by using its Amazon Resource Name (ARN).
	// Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`

	// The type of notifications that will be published to the specified Amazon
	// SNS topic.
	//
	// NotificationType is a required field
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
	// is omitted from the request or a null value is passed, SnsTopic is cleared
	// and publishing is disabled.
	SnsTopic *string `type:"string"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityNotificationTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityNotificationTopicInput"}
	if s.Identity == nil {
		invalidParams.Add(request.NewErrParamRequired("Identity"))
	}
	if s.NotificationType == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentity sets the Identity field's value.
func (s *SetIdentityNotificationTopicInput) SetIdentity(v string) *SetIdentityNotificationTopicInput {
	s.Identity = &v
	return s
}

// SetNotificationType sets the NotificationType field's value.
func (s *SetIdentityNotificationTopicInput) SetNotificationType(v string) *SetIdentityNotificationTopicInput {
	s.NotificationType = &v
	return s
}

// SetSnsTopic sets the SnsTopic field's value.
func (s *SetIdentityNotificationTopicInput) SetSnsTopic(v string) *SetIdentityNotificationTopicInput {
	s.SnsTopic = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetIdentityNotificationTopicResponse
type SetIdentityNotificationTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicOutput) GoString() string {
	return s.String()
}

// Represents a request to set the position of a receipt rule in a receipt rule
// set. You use receipt rule sets to receive email with Amazon SES. For more
// information, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePositionRequest
type SetReceiptRulePositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule after which to place the specified receipt rule.
	After *string `type:"string"`

	// The name of the receipt rule to reposition.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to reposition.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetReceiptRulePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetReceiptRulePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetReceiptRulePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetReceiptRulePositionInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfter sets the After field's value.
func (s *SetReceiptRulePositionInput) SetAfter(v string) *SetReceiptRulePositionInput {
	s.After = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *SetReceiptRulePositionInput) SetRuleName(v string) *SetReceiptRulePositionInput {
	s.RuleName = &v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *SetReceiptRulePositionInput) SetRuleSetName(v string) *SetReceiptRulePositionInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/SetReceiptRulePositionResponse
type SetReceiptRulePositionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetReceiptRulePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetReceiptRulePositionOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action terminates the evaluation of
// the receipt rule set and, optionally, publishes a notification to Amazon
// Simple Notification Service (Amazon SNS).
//
// For information about setting a stop action in a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/StopAction
type StopAction struct {
	_ struct{} `type:"structure"`

	// The scope to which the Stop action applies. That is, what is being stopped.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"StopScope"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// stop action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s StopAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopAction"}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScope sets the Scope field's value.
func (s *StopAction) SetScope(v string) *StopAction {
	s.Scope = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *StopAction) SetTopicArn(v string) *StopAction {
	s.TopicArn = &v
	return s
}

// Represents a request to update the event destination of a configuration set.
// Configuration sets enable you to publish email sending events. For information
// about using configuration sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestinationRequest
type UpdateConfigurationSetEventDestinationInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration set that you want to update.
	//
	// ConfigurationSetName is a required field
	ConfigurationSetName *string `type:"string" required:"true"`

	// The event destination object that you want to apply to the specified configuration
	// set.
	//
	// EventDestination is a required field
	EventDestination *EventDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigurationSetEventDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigurationSetEventDestinationInput"}
	if s.ConfigurationSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationSetName"))
	}
	if s.EventDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("EventDestination"))
	}
	if s.EventDestination != nil {
		if err := s.EventDestination.Validate(); err != nil {
			invalidParams.AddNested("EventDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationSetName sets the ConfigurationSetName field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetConfigurationSetName(v string) *UpdateConfigurationSetEventDestinationInput {
	s.ConfigurationSetName = &v
	return s
}

// SetEventDestination sets the EventDestination field's value.
func (s *UpdateConfigurationSetEventDestinationInput) SetEventDestination(v *EventDestination) *UpdateConfigurationSetEventDestinationInput {
	s.EventDestination = v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateConfigurationSetEventDestinationResponse
type UpdateConfigurationSetEventDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationSetEventDestinationOutput) GoString() string {
	return s.String()
}

// Represents a request to update a receipt rule. You use receipt rules to receive
// email with Amazon SES. For more information, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRuleRequest
type UpdateReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the updated receipt rule information.
	//
	// Rule is a required field
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the receipt rule set to which the receipt rule belongs.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReceiptRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateReceiptRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateReceiptRuleInput"}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.RuleSetName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleSetName"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRule sets the Rule field's value.
func (s *UpdateReceiptRuleInput) SetRule(v *ReceiptRule) *UpdateReceiptRuleInput {
	s.Rule = v
	return s
}

// SetRuleSetName sets the RuleSetName field's value.
func (s *UpdateReceiptRuleInput) SetRuleSetName(v string) *UpdateReceiptRuleInput {
	s.RuleSetName = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateReceiptRuleResponse
type UpdateReceiptRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request to generate the CNAME records needed to set up Easy
// DKIM with Amazon SES. For more information about setting up Easy DKIM, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkimRequest
type VerifyDomainDkimInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to be verified for Easy DKIM signing.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyDomainDkimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDkimInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyDomainDkimInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyDomainDkimInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *VerifyDomainDkimInput) SetDomain(v string) *VerifyDomainDkimInput {
	s.Domain = &v
	return s
}

// Returns CNAME records that you must publish to the DNS server of your domain
// to set up Easy DKIM with Amazon SES.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkimResponse
type VerifyDomainDkimOutput struct {
	_ struct{} `type:"structure"`

	// A set of character strings that represent the domain's identity. If the identity
	// is an email address, the tokens represent the domain of that address.
	//
	// Using these tokens, you will need to create DNS CNAME records that point
	// to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually
	// detect that you have updated your DNS records; this detection process may
	// take up to 72 hours. Upon successful detection, Amazon SES will be able to
	// DKIM-sign emails originating from that domain.
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	//
	// DkimTokens is a required field
	DkimTokens []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s VerifyDomainDkimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDkimOutput) GoString() string {
	return s.String()
}

// SetDkimTokens sets the DkimTokens field's value.
func (s *VerifyDomainDkimOutput) SetDkimTokens(v []*string) *VerifyDomainDkimOutput {
	s.DkimTokens = v
	return s
}

// Represents a request to begin Amazon SES domain verification and to generate
// the TXT records that you must publish to the DNS server of your domain to
// complete the verification. For information about domain verification, see
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentityRequest
type VerifyDomainIdentityInput struct {
	_ struct{} `type:"structure"`

	// The domain to be verified.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyDomainIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyDomainIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyDomainIdentityInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *VerifyDomainIdentityInput) SetDomain(v string) *VerifyDomainIdentityInput {
	s.Domain = &v
	return s
}

// Returns a TXT record that you must publish to the DNS server of your domain
// to complete domain verification with Amazon SES.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainIdentityResponse
type VerifyDomainIdentityOutput struct {
	_ struct{} `type:"structure"`

	// A TXT record that must be placed in the DNS settings for the domain, in order
	// to complete domain verification.
	//
	// VerificationToken is a required field
	VerificationToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyDomainIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityOutput) GoString() string {
	return s.String()
}

// SetVerificationToken sets the VerificationToken field's value.
func (s *VerifyDomainIdentityOutput) SetVerificationToken(v string) *VerifyDomainIdentityOutput {
	s.VerificationToken = &v
	return s
}

// Represents a request to begin email address verification with Amazon SES.
// For information about email address verification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddressRequest
type VerifyEmailAddressInput struct {
	_ struct{} `type:"structure"`

	// The email address to be verified.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyEmailAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyEmailAddressInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *VerifyEmailAddressInput) SetEmailAddress(v string) *VerifyEmailAddressInput {
	s.EmailAddress = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailAddressOutput
type VerifyEmailAddressOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents a request to begin email address verification with Amazon SES.
// For information about email address verification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentityRequest
type VerifyEmailIdentityInput struct {
	_ struct{} `type:"structure"`

	// The email address to be verified.
	//
	// EmailAddress is a required field
	EmailAddress *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyEmailIdentityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyEmailIdentityInput"}
	if s.EmailAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("EmailAddress"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *VerifyEmailIdentityInput) SetEmailAddress(v string) *VerifyEmailIdentityInput {
	s.EmailAddress = &v
	return s
}

// An empty element returned on a successful request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyEmailIdentityResponse
type VerifyEmailIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action calls Amazon WorkMail and, optionally,
// publishes a notification to Amazon Simple Notification Service (Amazon SNS).
// You will typically not use this action directly because Amazon WorkMail adds
// the rule automatically during its setup procedure.
//
// For information using a receipt rule to call Amazon WorkMail, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/WorkmailAction
type WorkmailAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
	// organization ARN is arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7.
	// For information about Amazon WorkMail organizations, see the Amazon WorkMail
	// Administrator Guide (http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html).
	//
	// OrganizationArn is a required field
	OrganizationArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// WorkMail action is called. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`
}

// String returns the string representation
func (s WorkmailAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkmailAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkmailAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkmailAction"}
	if s.OrganizationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OrganizationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrganizationArn sets the OrganizationArn field's value.
func (s *WorkmailAction) SetOrganizationArn(v string) *WorkmailAction {
	s.OrganizationArn = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *WorkmailAction) SetTopicArn(v string) *WorkmailAction {
	s.TopicArn = &v
	return s
}

const (
	// BehaviorOnMXFailureUseDefaultValue is a BehaviorOnMXFailure enum value
	BehaviorOnMXFailureUseDefaultValue = "UseDefaultValue"

	// BehaviorOnMXFailureRejectMessage is a BehaviorOnMXFailure enum value
	BehaviorOnMXFailureRejectMessage = "RejectMessage"
)

const (
	// BounceTypeDoesNotExist is a BounceType enum value
	BounceTypeDoesNotExist = "DoesNotExist"

	// BounceTypeMessageTooLarge is a BounceType enum value
	BounceTypeMessageTooLarge = "MessageTooLarge"

	// BounceTypeExceededQuota is a BounceType enum value
	BounceTypeExceededQuota = "ExceededQuota"

	// BounceTypeContentRejected is a BounceType enum value
	BounceTypeContentRejected = "ContentRejected"

	// BounceTypeUndefined is a BounceType enum value
	BounceTypeUndefined = "Undefined"

	// BounceTypeTemporaryFailure is a BounceType enum value
	BounceTypeTemporaryFailure = "TemporaryFailure"
)

const (
	// ConfigurationSetAttributeEventDestinations is a ConfigurationSetAttribute enum value
	ConfigurationSetAttributeEventDestinations = "eventDestinations"
)

const (
	// CustomMailFromStatusPending is a CustomMailFromStatus enum value
	CustomMailFromStatusPending = "Pending"

	// CustomMailFromStatusSuccess is a CustomMailFromStatus enum value
	CustomMailFromStatusSuccess = "Success"

	// CustomMailFromStatusFailed is a CustomMailFromStatus enum value
	CustomMailFromStatusFailed = "Failed"

	// CustomMailFromStatusTemporaryFailure is a CustomMailFromStatus enum value
	CustomMailFromStatusTemporaryFailure = "TemporaryFailure"
)

const (
	// DimensionValueSourceMessageTag is a DimensionValueSource enum value
	DimensionValueSourceMessageTag = "messageTag"

	// DimensionValueSourceEmailHeader is a DimensionValueSource enum value
	DimensionValueSourceEmailHeader = "emailHeader"
)

const (
	// DsnActionFailed is a DsnAction enum value
	DsnActionFailed = "failed"

	// DsnActionDelayed is a DsnAction enum value
	DsnActionDelayed = "delayed"

	// DsnActionDelivered is a DsnAction enum value
	DsnActionDelivered = "delivered"

	// DsnActionRelayed is a DsnAction enum value
	DsnActionRelayed = "relayed"

	// DsnActionExpanded is a DsnAction enum value
	DsnActionExpanded = "expanded"
)

const (
	// EventTypeSend is a EventType enum value
	EventTypeSend = "send"

	// EventTypeReject is a EventType enum value
	EventTypeReject = "reject"

	// EventTypeBounce is a EventType enum value
	EventTypeBounce = "bounce"

	// EventTypeComplaint is a EventType enum value
	EventTypeComplaint = "complaint"

	// EventTypeDelivery is a EventType enum value
	EventTypeDelivery = "delivery"
)

const (
	// IdentityTypeEmailAddress is a IdentityType enum value
	IdentityTypeEmailAddress = "EmailAddress"

	// IdentityTypeDomain is a IdentityType enum value
	IdentityTypeDomain = "Domain"
)

const (
	// InvocationTypeEvent is a InvocationType enum value
	InvocationTypeEvent = "Event"

	// InvocationTypeRequestResponse is a InvocationType enum value
	InvocationTypeRequestResponse = "RequestResponse"
)

const (
	// NotificationTypeBounce is a NotificationType enum value
	NotificationTypeBounce = "Bounce"

	// NotificationTypeComplaint is a NotificationType enum value
	NotificationTypeComplaint = "Complaint"

	// NotificationTypeDelivery is a NotificationType enum value
	NotificationTypeDelivery = "Delivery"
)

const (
	// ReceiptFilterPolicyBlock is a ReceiptFilterPolicy enum value
	ReceiptFilterPolicyBlock = "Block"

	// ReceiptFilterPolicyAllow is a ReceiptFilterPolicy enum value
	ReceiptFilterPolicyAllow = "Allow"
)

const (
	// SNSActionEncodingUtf8 is a SNSActionEncoding enum value
	SNSActionEncodingUtf8 = "UTF-8"

	// SNSActionEncodingBase64 is a SNSActionEncoding enum value
	SNSActionEncodingBase64 = "Base64"
)

const (
	// StopScopeRuleSet is a StopScope enum value
	StopScopeRuleSet = "RuleSet"
)

const (
	// TlsPolicyRequire is a TlsPolicy enum value
	TlsPolicyRequire = "Require"

	// TlsPolicyOptional is a TlsPolicy enum value
	TlsPolicyOptional = "Optional"
)

const (
	// VerificationStatusPending is a VerificationStatus enum value
	VerificationStatusPending = "Pending"

	// VerificationStatusSuccess is a VerificationStatus enum value
	VerificationStatusSuccess = "Success"

	// VerificationStatusFailed is a VerificationStatus enum value
	VerificationStatusFailed = "Failed"

	// VerificationStatusTemporaryFailure is a VerificationStatus enum value
	VerificationStatusTemporaryFailure = "TemporaryFailure"

	// VerificationStatusNotStarted is a VerificationStatus enum value
	VerificationStatusNotStarted = "NotStarted"
)
