// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/waf"
)

const opAssociateWebACL = "AssociateWebACL"

// AssociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the AssociateWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AssociateWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AssociateWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AssociateWebACLRequest method.
//    req, resp := client.AssociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACL
func (c *WAFRegional) AssociateWebACLRequest(input *AssociateWebACLInput) (req *request.Request, output *AssociateWebACLOutput) {
	op := &request.Operation{
		Name:       opAssociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateWebACLInput{}
	}

	output = &AssociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateWebACL API operation for AWS WAF Regional.
//
// Associates a web ACL with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation AssociateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFUnavailableEntityException "WAFUnavailableEntityException"
//   The operation failed because the entity referenced is temporarily unavailable.
//   Retry your request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACL
func (c *WAFRegional) AssociateWebACL(input *AssociateWebACLInput) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	return out, req.Send()
}

// AssociateWebACLWithContext is the same as AssociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) AssociateWebACLWithContext(ctx aws.Context, input *AssociateWebACLInput, opts ...request.Option) (*AssociateWebACLOutput, error) {
	req, out := c.AssociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateByteMatchSet = "CreateByteMatchSet"

// CreateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateByteMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateByteMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateByteMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateByteMatchSetRequest method.
//    req, resp := client.CreateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateByteMatchSet
func (c *WAFRegional) CreateByteMatchSetRequest(input *waf.CreateByteMatchSetInput) (req *request.Request, output *waf.CreateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateByteMatchSetInput{}
	}

	output = &waf.CreateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateByteMatchSet API operation for AWS WAF Regional.
//
// Creates a ByteMatchSet. You then use UpdateByteMatchSet to identify the part
// of a web request that you want AWS WAF to inspect, such as the values of
// the User-Agent header or the query string. For example, you can create a
// ByteMatchSet that matches any requests with User-Agent headers that contain
// the string BadBot. You can then configure AWS WAF to reject those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateByteMatchSet request.
//
// Submit a CreateByteMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateByteMatchSet
func (c *WAFRegional) CreateByteMatchSet(input *waf.CreateByteMatchSetInput) (*waf.CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	return out, req.Send()
}

// CreateByteMatchSetWithContext is the same as CreateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateByteMatchSetWithContext(ctx aws.Context, input *waf.CreateByteMatchSetInput, opts ...request.Option) (*waf.CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateIPSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateIPSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateIPSet
func (c *WAFRegional) CreateIPSetRequest(input *waf.CreateIPSetInput) (req *request.Request, output *waf.CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateIPSetInput{}
	}

	output = &waf.CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for AWS WAF Regional.
//
// Creates an IPSet, which you use to specify which web requests you want to
// allow or block based on the IP addresses that the requests originate from.
// For example, if you're receiving a lot of requests from one or more individual
// IP addresses or one or more ranges of IP addresses and you want to block
// the requests, you can create an IPSet that contains those IP addresses and
// then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateIPSet request.
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateIPSet
func (c *WAFRegional) CreateIPSet(input *waf.CreateIPSetInput) (*waf.CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateIPSetWithContext(ctx aws.Context, input *waf.CreateIPSetInput, opts ...request.Option) (*waf.CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRule
func (c *WAFRegional) CreateRuleRequest(input *waf.CreateRuleInput) (req *request.Request, output *waf.CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateRuleInput{}
	}

	output = &waf.CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for AWS WAF Regional.
//
// Creates a Rule, which contains the IPSet objects, ByteMatchSet objects, and
// other predicates that identify the requests that you want to block. If you
// add more than one predicate to a Rule, a request must match all of the specifications
// to be allowed or blocked. For example, suppose you add the following to a
// Rule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// You then add the Rule to a WebACL and specify that you want to blocks requests
// that satisfy the Rule. For a request to be blocked, it must come from the
// IP address 192.0.2.44 and the User-Agent header in the request must contain
// the value BadBot.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to specify the predicates that you want to include
// in the Rule.
//
// Create and update a WebACL that contains the Rule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateRule
func (c *WAFRegional) CreateRule(input *waf.CreateRuleInput) (*waf.CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateRuleWithContext(ctx aws.Context, input *waf.CreateRuleInput, opts ...request.Option) (*waf.CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSizeConstraintSet = "CreateSizeConstraintSet"

// CreateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSizeConstraintSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSizeConstraintSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSizeConstraintSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSizeConstraintSetRequest method.
//    req, resp := client.CreateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSizeConstraintSet
func (c *WAFRegional) CreateSizeConstraintSetRequest(input *waf.CreateSizeConstraintSetInput) (req *request.Request, output *waf.CreateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opCreateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateSizeConstraintSetInput{}
	}

	output = &waf.CreateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSizeConstraintSet API operation for AWS WAF Regional.
//
// Creates a SizeConstraintSet. You then use UpdateSizeConstraintSet to identify
// the part of a web request that you want AWS WAF to check for length, such
// as the length of the User-Agent header or the length of the query string.
// For example, you can create a SizeConstraintSet that matches any requests
// that have a query string that is longer than 100 bytes. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSizeConstraintSet request.
//
// Submit a CreateSizeConstraintSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSizeConstraintSet
func (c *WAFRegional) CreateSizeConstraintSet(input *waf.CreateSizeConstraintSetInput) (*waf.CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// CreateSizeConstraintSetWithContext is the same as CreateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateSizeConstraintSetWithContext(ctx aws.Context, input *waf.CreateSizeConstraintSetInput, opts ...request.Option) (*waf.CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSqlInjectionMatchSet = "CreateSqlInjectionMatchSet"

// CreateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSqlInjectionMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSqlInjectionMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSqlInjectionMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSqlInjectionMatchSetRequest method.
//    req, resp := client.CreateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSqlInjectionMatchSet
func (c *WAFRegional) CreateSqlInjectionMatchSetRequest(input *waf.CreateSqlInjectionMatchSetInput) (req *request.Request, output *waf.CreateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateSqlInjectionMatchSetInput{}
	}

	output = &waf.CreateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests
// that contain snippets of SQL code in a specified part of web requests. AWS
// WAF searches for character sequences that are likely to be malicious strings.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSqlInjectionMatchSet request.
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSqlInjectionMatchSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests in which you want to allow, block, or count malicious SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateSqlInjectionMatchSet
func (c *WAFRegional) CreateSqlInjectionMatchSet(input *waf.CreateSqlInjectionMatchSetInput) (*waf.CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// CreateSqlInjectionMatchSetWithContext is the same as CreateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.CreateSqlInjectionMatchSetInput, opts ...request.Option) (*waf.CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebACL = "CreateWebACL"

// CreateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateWebACLRequest method.
//    req, resp := client.CreateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateWebACL
func (c *WAFRegional) CreateWebACLRequest(input *waf.CreateWebACLInput) (req *request.Request, output *waf.CreateWebACLOutput) {
	op := &request.Operation{
		Name:       opCreateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateWebACLInput{}
	}

	output = &waf.CreateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebACL API operation for AWS WAF Regional.
//
// Creates a WebACL, which contains the Rules that identify the CloudFront web
// requests that you want to allow, block, or count. AWS WAF evaluates Rules
// in order based on the value of Priority for each Rule.
//
// You also specify a default action, either ALLOW or BLOCK. If a web request
// doesn't match any of the Rules in a WebACL, AWS WAF responds to the request
// with the default action.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the ByteMatchSet objects and other predicates that you
// want to include in Rules. For more information, see CreateByteMatchSet, UpdateByteMatchSet,
// CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateWebACL request.
//
// Submit a CreateWebACL request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// For more information about how to use the AWS WAF API, see the AWS WAF Developer
// Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateWebACL
func (c *WAFRegional) CreateWebACL(input *waf.CreateWebACLInput) (*waf.CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	return out, req.Send()
}

// CreateWebACLWithContext is the same as CreateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateWebACLWithContext(ctx aws.Context, input *waf.CreateWebACLInput, opts ...request.Option) (*waf.CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateXssMatchSet = "CreateXssMatchSet"

// CreateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateXssMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateXssMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateXssMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateXssMatchSetRequest method.
//    req, resp := client.CreateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateXssMatchSet
func (c *WAFRegional) CreateXssMatchSetRequest(input *waf.CreateXssMatchSetInput) (req *request.Request, output *waf.CreateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.CreateXssMatchSetInput{}
	}

	output = &waf.CreateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateXssMatchSet API operation for AWS WAF Regional.
//
// Creates an XssMatchSet, which you use to allow, block, or count requests
// that contain cross-site scripting attacks in the specified part of web requests.
// AWS WAF searches for character sequences that are likely to be malicious
// strings.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateXssMatchSet request.
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateXssMatchSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// in which you want to allow, block, or count cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation CreateXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFDisallowedNameException "WAFDisallowedNameException"
//   The name specified is invalid.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateXssMatchSet
func (c *WAFRegional) CreateXssMatchSet(input *waf.CreateXssMatchSetInput) (*waf.CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	return out, req.Send()
}

// CreateXssMatchSetWithContext is the same as CreateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) CreateXssMatchSetWithContext(ctx aws.Context, input *waf.CreateXssMatchSetInput, opts ...request.Option) (*waf.CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteByteMatchSet = "DeleteByteMatchSet"

// DeleteByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteByteMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteByteMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteByteMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteByteMatchSetRequest method.
//    req, resp := client.DeleteByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteByteMatchSet
func (c *WAFRegional) DeleteByteMatchSetRequest(input *waf.DeleteByteMatchSetInput) (req *request.Request, output *waf.DeleteByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteByteMatchSetInput{}
	}

	output = &waf.DeleteByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteByteMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a ByteMatchSet. You can't delete a ByteMatchSet if it's
// still used in any Rules or if it still includes any ByteMatchTuple objects
// (any filters).
//
// If you just want to remove a ByteMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a ByteMatchSet, perform the following steps:
//
// Update the ByteMatchSet to remove filters, if any. For more information,
// see UpdateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteByteMatchSet request.
//
// Submit a DeleteByteMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteByteMatchSet
func (c *WAFRegional) DeleteByteMatchSet(input *waf.DeleteByteMatchSetInput) (*waf.DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	return out, req.Send()
}

// DeleteByteMatchSetWithContext is the same as DeleteByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteByteMatchSetWithContext(ctx aws.Context, input *waf.DeleteByteMatchSetInput, opts ...request.Option) (*waf.DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteIPSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteIPSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteIPSet
func (c *WAFRegional) DeleteIPSetRequest(input *waf.DeleteIPSetInput) (req *request.Request, output *waf.DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteIPSetInput{}
	}

	output = &waf.DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIPSet API operation for AWS WAF Regional.
//
// Permanently deletes an IPSet. You can't delete an IPSet if it's still used
// in any Rules or if it still includes any IP addresses.
//
// If you just want to remove an IPSet from a Rule, use UpdateRule.
//
// To permanently delete an IPSet from AWS WAF, perform the following steps:
//
// Update the IPSet to remove IP address ranges, if any. For more information,
// see UpdateIPSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteIPSet request.
//
// Submit a DeleteIPSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteIPSet
func (c *WAFRegional) DeleteIPSet(input *waf.DeleteIPSetInput) (*waf.DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteIPSetWithContext(ctx aws.Context, input *waf.DeleteIPSetInput, opts ...request.Option) (*waf.DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRule
func (c *WAFRegional) DeleteRuleRequest(input *waf.DeleteRuleInput) (req *request.Request, output *waf.DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteRuleInput{}
	}

	output = &waf.DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRule API operation for AWS WAF Regional.
//
// Permanently deletes a Rule. You can't delete a Rule if it's still used in
// any WebACL objects or if it still includes any predicates, such as ByteMatchSet
// objects.
//
// If you just want to remove a Rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a Rule from AWS WAF, perform the following steps:
//
// Update the Rule to remove predicates, if any. For more information, see UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRule request.
//
// Submit a DeleteRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteRule
func (c *WAFRegional) DeleteRule(input *waf.DeleteRuleInput) (*waf.DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteRuleWithContext(ctx aws.Context, input *waf.DeleteRuleInput, opts ...request.Option) (*waf.DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSizeConstraintSet = "DeleteSizeConstraintSet"

// DeleteSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSizeConstraintSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSizeConstraintSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSizeConstraintSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSizeConstraintSetRequest method.
//    req, resp := client.DeleteSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSizeConstraintSet
func (c *WAFRegional) DeleteSizeConstraintSetRequest(input *waf.DeleteSizeConstraintSetInput) (req *request.Request, output *waf.DeleteSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteSizeConstraintSetInput{}
	}

	output = &waf.DeleteSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSizeConstraintSet API operation for AWS WAF Regional.
//
// Permanently deletes a SizeConstraintSet. You can't delete a SizeConstraintSet
// if it's still used in any Rules or if it still includes any SizeConstraint
// objects (any filters).
//
// If you just want to remove a SizeConstraintSet from a Rule, use UpdateRule.
//
// To permanently delete a SizeConstraintSet, perform the following steps:
//
// Update the SizeConstraintSet to remove filters, if any. For more information,
// see UpdateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSizeConstraintSet request.
//
// Submit a DeleteSizeConstraintSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSizeConstraintSet
func (c *WAFRegional) DeleteSizeConstraintSet(input *waf.DeleteSizeConstraintSetInput) (*waf.DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	return out, req.Send()
}

// DeleteSizeConstraintSetWithContext is the same as DeleteSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteSizeConstraintSetWithContext(ctx aws.Context, input *waf.DeleteSizeConstraintSetInput, opts ...request.Option) (*waf.DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSqlInjectionMatchSet = "DeleteSqlInjectionMatchSet"

// DeleteSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSqlInjectionMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSqlInjectionMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSqlInjectionMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSqlInjectionMatchSetRequest method.
//    req, resp := client.DeleteSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSet
func (c *WAFRegional) DeleteSqlInjectionMatchSetRequest(input *waf.DeleteSqlInjectionMatchSetInput) (req *request.Request, output *waf.DeleteSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteSqlInjectionMatchSetInput{}
	}

	output = &waf.DeleteSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes a SqlInjectionMatchSet. You can't delete a SqlInjectionMatchSet
// if it's still used in any Rules or if it still contains any SqlInjectionMatchTuple
// objects.
//
// If you just want to remove a SqlInjectionMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a SqlInjectionMatchSet from AWS WAF, perform the following
// steps:
//
// Update the SqlInjectionMatchSet to remove filters, if any. For more information,
// see UpdateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSqlInjectionMatchSet request.
//
// Submit a DeleteSqlInjectionMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSet
func (c *WAFRegional) DeleteSqlInjectionMatchSet(input *waf.DeleteSqlInjectionMatchSetInput) (*waf.DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// DeleteSqlInjectionMatchSetWithContext is the same as DeleteSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.DeleteSqlInjectionMatchSetInput, opts ...request.Option) (*waf.DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteWebACLRequest method.
//    req, resp := client.DeleteWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteWebACL
func (c *WAFRegional) DeleteWebACLRequest(input *waf.DeleteWebACLInput) (req *request.Request, output *waf.DeleteWebACLOutput) {
	op := &request.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteWebACLInput{}
	}

	output = &waf.DeleteWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWebACL API operation for AWS WAF Regional.
//
// Permanently deletes a WebACL. You can't delete a WebACL if it still contains
// any Rules.
//
// To delete a WebACL, perform the following steps:
//
// Update the WebACL to remove Rules, if any. For more information, see UpdateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteWebACL request.
//
// Submit a DeleteWebACL request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteWebACL
func (c *WAFRegional) DeleteWebACL(input *waf.DeleteWebACLInput) (*waf.DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	return out, req.Send()
}

// DeleteWebACLWithContext is the same as DeleteWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteWebACLWithContext(ctx aws.Context, input *waf.DeleteWebACLInput, opts ...request.Option) (*waf.DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteXssMatchSet = "DeleteXssMatchSet"

// DeleteXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteXssMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteXssMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteXssMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteXssMatchSetRequest method.
//    req, resp := client.DeleteXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteXssMatchSet
func (c *WAFRegional) DeleteXssMatchSetRequest(input *waf.DeleteXssMatchSetInput) (req *request.Request, output *waf.DeleteXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.DeleteXssMatchSetInput{}
	}

	output = &waf.DeleteXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteXssMatchSet API operation for AWS WAF Regional.
//
// Permanently deletes an XssMatchSet. You can't delete an XssMatchSet if it's
// still used in any Rules or if it still contains any XssMatchTuple objects.
//
// If you just want to remove an XssMatchSet from a Rule, use UpdateRule.
//
// To permanently delete an XssMatchSet from AWS WAF, perform the following
// steps:
//
// Update the XssMatchSet to remove filters, if any. For more information, see
// UpdateXssMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteXssMatchSet request.
//
// Submit a DeleteXssMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DeleteXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFNonEmptyEntityException "WAFNonEmptyEntityException"
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteXssMatchSet
func (c *WAFRegional) DeleteXssMatchSet(input *waf.DeleteXssMatchSetInput) (*waf.DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	return out, req.Send()
}

// DeleteXssMatchSetWithContext is the same as DeleteXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DeleteXssMatchSetWithContext(ctx aws.Context, input *waf.DeleteXssMatchSetInput, opts ...request.Option) (*waf.DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateWebACL = "DisassociateWebACL"

// DisassociateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisassociateWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisassociateWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisassociateWebACLRequest method.
//    req, resp := client.DisassociateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACL
func (c *WAFRegional) DisassociateWebACLRequest(input *DisassociateWebACLInput) (req *request.Request, output *DisassociateWebACLOutput) {
	op := &request.Operation{
		Name:       opDisassociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateWebACLInput{}
	}

	output = &DisassociateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateWebACL API operation for AWS WAF Regional.
//
// Removes a web ACL from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation DisassociateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACL
func (c *WAFRegional) DisassociateWebACL(input *DisassociateWebACLInput) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	return out, req.Send()
}

// DisassociateWebACLWithContext is the same as DisassociateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) DisassociateWebACLWithContext(ctx aws.Context, input *DisassociateWebACLInput, opts ...request.Option) (*DisassociateWebACLOutput, error) {
	req, out := c.DisassociateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetByteMatchSet = "GetByteMatchSet"

// GetByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetByteMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetByteMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetByteMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetByteMatchSetRequest method.
//    req, resp := client.GetByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetByteMatchSet
func (c *WAFRegional) GetByteMatchSetRequest(input *waf.GetByteMatchSetInput) (req *request.Request, output *waf.GetByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetByteMatchSetInput{}
	}

	output = &waf.GetByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetByteMatchSet API operation for AWS WAF Regional.
//
// Returns the ByteMatchSet specified by ByteMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetByteMatchSet
func (c *WAFRegional) GetByteMatchSet(input *waf.GetByteMatchSetInput) (*waf.GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	return out, req.Send()
}

// GetByteMatchSetWithContext is the same as GetByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetByteMatchSetWithContext(ctx aws.Context, input *waf.GetByteMatchSetInput, opts ...request.Option) (*waf.GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeToken = "GetChangeToken"

// GetChangeTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeToken operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetChangeToken for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetChangeToken method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetChangeTokenRequest method.
//    req, resp := client.GetChangeTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeToken
func (c *WAFRegional) GetChangeTokenRequest(input *waf.GetChangeTokenInput) (req *request.Request, output *waf.GetChangeTokenOutput) {
	op := &request.Operation{
		Name:       opGetChangeToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetChangeTokenInput{}
	}

	output = &waf.GetChangeTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeToken API operation for AWS WAF Regional.
//
// When you want to create, update, or delete AWS WAF objects, get a change
// token and include the change token in the create, update, or delete request.
// Change tokens ensure that your application doesn't submit conflicting requests
// to AWS WAF.
//
// Each create, update, or delete request must use a unique change token. If
// your application submits a GetChangeToken request and then submits a second
// GetChangeToken request before submitting a create, update, or delete request,
// the second GetChangeToken request returns the same value as the first GetChangeToken
// request.
//
// When you use a change token in a create, update, or delete request, the status
// of the change token changes to PENDING, which indicates that AWS WAF is propagating
// the change to all AWS WAF servers. Use GetChangeTokenStatus to determine
// the status of your change token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetChangeToken for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeToken
func (c *WAFRegional) GetChangeToken(input *waf.GetChangeTokenInput) (*waf.GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	return out, req.Send()
}

// GetChangeTokenWithContext is the same as GetChangeToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetChangeTokenWithContext(ctx aws.Context, input *waf.GetChangeTokenInput, opts ...request.Option) (*waf.GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeTokenStatus = "GetChangeTokenStatus"

// GetChangeTokenStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeTokenStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetChangeTokenStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetChangeTokenStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetChangeTokenStatusRequest method.
//    req, resp := client.GetChangeTokenStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeTokenStatus
func (c *WAFRegional) GetChangeTokenStatusRequest(input *waf.GetChangeTokenStatusInput) (req *request.Request, output *waf.GetChangeTokenStatusOutput) {
	op := &request.Operation{
		Name:       opGetChangeTokenStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetChangeTokenStatusInput{}
	}

	output = &waf.GetChangeTokenStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeTokenStatus API operation for AWS WAF Regional.
//
// Returns the status of a ChangeToken that you got by calling GetChangeToken.
// ChangeTokenStatus is one of the following values:
//
//    * PROVISIONED: You requested the change token by calling GetChangeToken,
//    but you haven't used it yet in a call to create, update, or delete an
//    AWS WAF object.
//
//    * PENDING: AWS WAF is propagating the create, update, or delete request
//    to all AWS WAF servers.
//
//    * IN_SYNC: Propagation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetChangeTokenStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetChangeTokenStatus
func (c *WAFRegional) GetChangeTokenStatus(input *waf.GetChangeTokenStatusInput) (*waf.GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	return out, req.Send()
}

// GetChangeTokenStatusWithContext is the same as GetChangeTokenStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeTokenStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetChangeTokenStatusWithContext(ctx aws.Context, input *waf.GetChangeTokenStatusInput, opts ...request.Option) (*waf.GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIPSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIPSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetIPSet
func (c *WAFRegional) GetIPSetRequest(input *waf.GetIPSetInput) (req *request.Request, output *waf.GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetIPSetInput{}
	}

	output = &waf.GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for AWS WAF Regional.
//
// Returns the IPSet that is specified by IPSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetIPSet
func (c *WAFRegional) GetIPSet(input *waf.GetIPSetInput) (*waf.GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetIPSetWithContext(ctx aws.Context, input *waf.GetIPSetInput, opts ...request.Option) (*waf.GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRuleRequest method.
//    req, resp := client.GetRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRule
func (c *WAFRegional) GetRuleRequest(input *waf.GetRuleInput) (req *request.Request, output *waf.GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetRuleInput{}
	}

	output = &waf.GetRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRule API operation for AWS WAF Regional.
//
// Returns the Rule that is specified by the RuleId that you included in the
// GetRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetRule
func (c *WAFRegional) GetRule(input *waf.GetRuleInput) (*waf.GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetRuleWithContext(ctx aws.Context, input *waf.GetRuleInput, opts ...request.Option) (*waf.GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest generates a "aws/request.Request" representing the
// client's request for the GetSampledRequests operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSampledRequests for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSampledRequests method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSampledRequestsRequest method.
//    req, resp := client.GetSampledRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSampledRequests
func (c *WAFRegional) GetSampledRequestsRequest(input *waf.GetSampledRequestsInput) (req *request.Request, output *waf.GetSampledRequestsOutput) {
	op := &request.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSampledRequestsInput{}
	}

	output = &waf.GetSampledRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSampledRequests API operation for AWS WAF Regional.
//
// Gets detailed information about a specified number of requests--a sample--that
// AWS WAF randomly selects from among the first 5,000 requests that your AWS
// resource received during a time range that you choose. You can specify a
// sample size of up to 500 requests, and you can specify any time range in
// the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which AWS WAF selected the requests in the sample.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSampledRequests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSampledRequests
func (c *WAFRegional) GetSampledRequests(input *waf.GetSampledRequestsInput) (*waf.GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	return out, req.Send()
}

// GetSampledRequestsWithContext is the same as GetSampledRequests with the addition of
// the ability to pass a context and additional request options.
//
// See GetSampledRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSampledRequestsWithContext(ctx aws.Context, input *waf.GetSampledRequestsInput, opts ...request.Option) (*waf.GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSizeConstraintSet = "GetSizeConstraintSet"

// GetSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSizeConstraintSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSizeConstraintSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSizeConstraintSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSizeConstraintSetRequest method.
//    req, resp := client.GetSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSizeConstraintSet
func (c *WAFRegional) GetSizeConstraintSetRequest(input *waf.GetSizeConstraintSetInput) (req *request.Request, output *waf.GetSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opGetSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSizeConstraintSetInput{}
	}

	output = &waf.GetSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSizeConstraintSet API operation for AWS WAF Regional.
//
// Returns the SizeConstraintSet specified by SizeConstraintSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSizeConstraintSet
func (c *WAFRegional) GetSizeConstraintSet(input *waf.GetSizeConstraintSetInput) (*waf.GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	return out, req.Send()
}

// GetSizeConstraintSetWithContext is the same as GetSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSizeConstraintSetWithContext(ctx aws.Context, input *waf.GetSizeConstraintSetInput, opts ...request.Option) (*waf.GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSqlInjectionMatchSet = "GetSqlInjectionMatchSet"

// GetSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSqlInjectionMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSqlInjectionMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSqlInjectionMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSqlInjectionMatchSetRequest method.
//    req, resp := client.GetSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSqlInjectionMatchSet
func (c *WAFRegional) GetSqlInjectionMatchSetRequest(input *waf.GetSqlInjectionMatchSetInput) (req *request.Request, output *waf.GetSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetSqlInjectionMatchSetInput{}
	}

	output = &waf.GetSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Returns the SqlInjectionMatchSet that is specified by SqlInjectionMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetSqlInjectionMatchSet
func (c *WAFRegional) GetSqlInjectionMatchSet(input *waf.GetSqlInjectionMatchSetInput) (*waf.GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// GetSqlInjectionMatchSetWithContext is the same as GetSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.GetSqlInjectionMatchSetInput, opts ...request.Option) (*waf.GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACL = "GetWebACL"

// GetWebACLRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetWebACLRequest method.
//    req, resp := client.GetWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACL
func (c *WAFRegional) GetWebACLRequest(input *waf.GetWebACLInput) (req *request.Request, output *waf.GetWebACLOutput) {
	op := &request.Operation{
		Name:       opGetWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetWebACLInput{}
	}

	output = &waf.GetWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACL API operation for AWS WAF Regional.
//
// Returns the WebACL that is specified by WebACLId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACL
func (c *WAFRegional) GetWebACL(input *waf.GetWebACLInput) (*waf.GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	return out, req.Send()
}

// GetWebACLWithContext is the same as GetWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetWebACLWithContext(ctx aws.Context, input *waf.GetWebACLInput, opts ...request.Option) (*waf.GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACLForResource = "GetWebACLForResource"

// GetWebACLForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACLForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetWebACLForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetWebACLForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetWebACLForResourceRequest method.
//    req, resp := client.GetWebACLForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResource
func (c *WAFRegional) GetWebACLForResourceRequest(input *GetWebACLForResourceInput) (req *request.Request, output *GetWebACLForResourceOutput) {
	op := &request.Operation{
		Name:       opGetWebACLForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLForResourceInput{}
	}

	output = &GetWebACLForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACLForResource API operation for AWS WAF Regional.
//
// Returns the web ACL for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetWebACLForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFUnavailableEntityException "WAFUnavailableEntityException"
//   The operation failed because the entity referenced is temporarily unavailable.
//   Retry your request.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResource
func (c *WAFRegional) GetWebACLForResource(input *GetWebACLForResourceInput) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	return out, req.Send()
}

// GetWebACLForResourceWithContext is the same as GetWebACLForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACLForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetWebACLForResourceWithContext(ctx aws.Context, input *GetWebACLForResourceInput, opts ...request.Option) (*GetWebACLForResourceOutput, error) {
	req, out := c.GetWebACLForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetXssMatchSet = "GetXssMatchSet"

// GetXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetXssMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetXssMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetXssMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetXssMatchSetRequest method.
//    req, resp := client.GetXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetXssMatchSet
func (c *WAFRegional) GetXssMatchSetRequest(input *waf.GetXssMatchSetInput) (req *request.Request, output *waf.GetXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.GetXssMatchSetInput{}
	}

	output = &waf.GetXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetXssMatchSet API operation for AWS WAF Regional.
//
// Returns the XssMatchSet that is specified by XssMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation GetXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetXssMatchSet
func (c *WAFRegional) GetXssMatchSet(input *waf.GetXssMatchSetInput) (*waf.GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	return out, req.Send()
}

// GetXssMatchSetWithContext is the same as GetXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) GetXssMatchSetWithContext(ctx aws.Context, input *waf.GetXssMatchSetInput, opts ...request.Option) (*waf.GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListByteMatchSets = "ListByteMatchSets"

// ListByteMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListByteMatchSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListByteMatchSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListByteMatchSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListByteMatchSetsRequest method.
//    req, resp := client.ListByteMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListByteMatchSets
func (c *WAFRegional) ListByteMatchSetsRequest(input *waf.ListByteMatchSetsInput) (req *request.Request, output *waf.ListByteMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListByteMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListByteMatchSetsInput{}
	}

	output = &waf.ListByteMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListByteMatchSets API operation for AWS WAF Regional.
//
// Returns an array of ByteMatchSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListByteMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListByteMatchSets
func (c *WAFRegional) ListByteMatchSets(input *waf.ListByteMatchSetsInput) (*waf.ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	return out, req.Send()
}

// ListByteMatchSetsWithContext is the same as ListByteMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListByteMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListByteMatchSetsWithContext(ctx aws.Context, input *waf.ListByteMatchSetsInput, opts ...request.Option) (*waf.ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListIPSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListIPSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListIPSets
func (c *WAFRegional) ListIPSetsRequest(input *waf.ListIPSetsInput) (req *request.Request, output *waf.ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListIPSetsInput{}
	}

	output = &waf.ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for AWS WAF Regional.
//
// Returns an array of IPSetSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListIPSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListIPSets
func (c *WAFRegional) ListIPSets(input *waf.ListIPSetsInput) (*waf.ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListIPSetsWithContext(ctx aws.Context, input *waf.ListIPSetsInput, opts ...request.Option) (*waf.ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourcesForWebACL = "ListResourcesForWebACL"

// ListResourcesForWebACLRequest generates a "aws/request.Request" representing the
// client's request for the ListResourcesForWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListResourcesForWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListResourcesForWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListResourcesForWebACLRequest method.
//    req, resp := client.ListResourcesForWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACL
func (c *WAFRegional) ListResourcesForWebACLRequest(input *ListResourcesForWebACLInput) (req *request.Request, output *ListResourcesForWebACLOutput) {
	op := &request.Operation{
		Name:       opListResourcesForWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourcesForWebACLInput{}
	}

	output = &ListResourcesForWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourcesForWebACL API operation for AWS WAF Regional.
//
// Returns an array of resources associated with the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListResourcesForWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACL
func (c *WAFRegional) ListResourcesForWebACL(input *ListResourcesForWebACLInput) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	return out, req.Send()
}

// ListResourcesForWebACLWithContext is the same as ListResourcesForWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourcesForWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListResourcesForWebACLWithContext(ctx aws.Context, input *ListResourcesForWebACLInput, opts ...request.Option) (*ListResourcesForWebACLOutput, error) {
	req, out := c.ListResourcesForWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRules for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRules method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRules
func (c *WAFRegional) ListRulesRequest(input *waf.ListRulesInput) (req *request.Request, output *waf.ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListRulesInput{}
	}

	output = &waf.ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for AWS WAF Regional.
//
// Returns an array of RuleSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListRules
func (c *WAFRegional) ListRules(input *waf.ListRulesInput) (*waf.ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListRulesWithContext(ctx aws.Context, input *waf.ListRulesInput, opts ...request.Option) (*waf.ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSizeConstraintSets = "ListSizeConstraintSets"

// ListSizeConstraintSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSizeConstraintSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSizeConstraintSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSizeConstraintSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSizeConstraintSetsRequest method.
//    req, resp := client.ListSizeConstraintSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSizeConstraintSets
func (c *WAFRegional) ListSizeConstraintSetsRequest(input *waf.ListSizeConstraintSetsInput) (req *request.Request, output *waf.ListSizeConstraintSetsOutput) {
	op := &request.Operation{
		Name:       opListSizeConstraintSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListSizeConstraintSetsInput{}
	}

	output = &waf.ListSizeConstraintSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSizeConstraintSets API operation for AWS WAF Regional.
//
// Returns an array of SizeConstraintSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListSizeConstraintSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSizeConstraintSets
func (c *WAFRegional) ListSizeConstraintSets(input *waf.ListSizeConstraintSetsInput) (*waf.ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	return out, req.Send()
}

// ListSizeConstraintSetsWithContext is the same as ListSizeConstraintSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSizeConstraintSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListSizeConstraintSetsWithContext(ctx aws.Context, input *waf.ListSizeConstraintSetsInput, opts ...request.Option) (*waf.ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSqlInjectionMatchSets = "ListSqlInjectionMatchSets"

// ListSqlInjectionMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSqlInjectionMatchSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSqlInjectionMatchSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSqlInjectionMatchSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSqlInjectionMatchSetsRequest method.
//    req, resp := client.ListSqlInjectionMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSqlInjectionMatchSets
func (c *WAFRegional) ListSqlInjectionMatchSetsRequest(input *waf.ListSqlInjectionMatchSetsInput) (req *request.Request, output *waf.ListSqlInjectionMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListSqlInjectionMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListSqlInjectionMatchSetsInput{}
	}

	output = &waf.ListSqlInjectionMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSqlInjectionMatchSets API operation for AWS WAF Regional.
//
// Returns an array of SqlInjectionMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListSqlInjectionMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListSqlInjectionMatchSets
func (c *WAFRegional) ListSqlInjectionMatchSets(input *waf.ListSqlInjectionMatchSetsInput) (*waf.ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	return out, req.Send()
}

// ListSqlInjectionMatchSetsWithContext is the same as ListSqlInjectionMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSqlInjectionMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListSqlInjectionMatchSetsWithContext(ctx aws.Context, input *waf.ListSqlInjectionMatchSetsInput, opts ...request.Option) (*waf.ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest generates a "aws/request.Request" representing the
// client's request for the ListWebACLs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListWebACLs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListWebACLs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListWebACLsRequest method.
//    req, resp := client.ListWebACLsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListWebACLs
func (c *WAFRegional) ListWebACLsRequest(input *waf.ListWebACLsInput) (req *request.Request, output *waf.ListWebACLsOutput) {
	op := &request.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListWebACLsInput{}
	}

	output = &waf.ListWebACLsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebACLs API operation for AWS WAF Regional.
//
// Returns an array of WebACLSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListWebACLs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListWebACLs
func (c *WAFRegional) ListWebACLs(input *waf.ListWebACLsInput) (*waf.ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	return out, req.Send()
}

// ListWebACLsWithContext is the same as ListWebACLs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebACLs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListWebACLsWithContext(ctx aws.Context, input *waf.ListWebACLsInput, opts ...request.Option) (*waf.ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListXssMatchSets = "ListXssMatchSets"

// ListXssMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListXssMatchSets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListXssMatchSets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListXssMatchSets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListXssMatchSetsRequest method.
//    req, resp := client.ListXssMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListXssMatchSets
func (c *WAFRegional) ListXssMatchSetsRequest(input *waf.ListXssMatchSetsInput) (req *request.Request, output *waf.ListXssMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListXssMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.ListXssMatchSetsInput{}
	}

	output = &waf.ListXssMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListXssMatchSets API operation for AWS WAF Regional.
//
// Returns an array of XssMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation ListXssMatchSets for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListXssMatchSets
func (c *WAFRegional) ListXssMatchSets(input *waf.ListXssMatchSetsInput) (*waf.ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	return out, req.Send()
}

// ListXssMatchSetsWithContext is the same as ListXssMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListXssMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) ListXssMatchSetsWithContext(ctx aws.Context, input *waf.ListXssMatchSetsInput, opts ...request.Option) (*waf.ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateByteMatchSet = "UpdateByteMatchSet"

// UpdateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateByteMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateByteMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateByteMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateByteMatchSetRequest method.
//    req, resp := client.UpdateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateByteMatchSet
func (c *WAFRegional) UpdateByteMatchSetRequest(input *waf.UpdateByteMatchSetInput) (req *request.Request, output *waf.UpdateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateByteMatchSetInput{}
	}

	output = &waf.UpdateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateByteMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For
// each ByteMatchTuple object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a ByteMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspect, such as
//    a query string or the value of the User-Agent header.
//
//    * The bytes (typically a string that corresponds with ASCII characters)
//    that you want AWS WAF to look for. For more information, including how
//    you specify the values for the AWS WAF API and the AWS CLI or SDKs, see
//    TargetString in the ByteMatchTuple data type.
//
//    * Where to look, such as at the beginning or the end of a query string.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can add a ByteMatchSetUpdate object that matches web requests
// in which User-Agent headers contain the string BadBot. You can then configure
// AWS WAF to block those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Create a ByteMatchSet. For more information, see CreateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateByteMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateByteMatchSet
func (c *WAFRegional) UpdateByteMatchSet(input *waf.UpdateByteMatchSetInput) (*waf.UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	return out, req.Send()
}

// UpdateByteMatchSetWithContext is the same as UpdateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateByteMatchSetWithContext(ctx aws.Context, input *waf.UpdateByteMatchSetInput, opts ...request.Option) (*waf.UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateIPSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateIPSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateIPSet
func (c *WAFRegional) UpdateIPSetRequest(input *waf.UpdateIPSetInput) (req *request.Request, output *waf.UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateIPSetInput{}
	}

	output = &waf.UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIPSet API operation for AWS WAF Regional.
//
// Inserts or deletes IPSetDescriptor objects in an IPSet. For each IPSetDescriptor
// object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an IPSetDescriptor object, you delete the existing object and add
//    a new one.
//
//    * The IP address version, IPv4 or IPv6.
//
//    * The IP address in CIDR notation, for example, 192.0.2.0/24 (for the
//    range of IP addresses from 192.0.2.0 to 192.0.2.255) or 192.0.2.44/32
//    (for the individual IP address 192.0.2.44).
//
// AWS WAF supports /8, /16, /24, and /32 IP address ranges for IPv4, and /24,
// /32, /48, /56, /64 and /128 for IPv6. For more information about CIDR notation,
// see the Wikipedia entry Classless Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// IPv6 addresses can be represented using any of the following formats:
//
//    * 1111:0000:0000:0000:0000:0000:0000:0111/128
//
//    * 1111:0:0:0:0:0:0:0111/128
//
//    * 1111::0111/128
//
//    * 1111::111/128
//
// You use an IPSet to specify which web requests you want to allow or block
// based on the IP addresses that the requests originated from. For example,
// if you're receiving a lot of requests from one or a small number of IP addresses
// and you want to block the requests, you can create an IPSet that specifies
// those IP addresses, and then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// When you update an IPSet, you specify the IP addresses that you want to add
// and/or the IP addresses that you want to delete. If you want to change an
// IP address, you delete the existing IP address and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateIPSet
func (c *WAFRegional) UpdateIPSet(input *waf.UpdateIPSetInput) (*waf.UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateIPSetWithContext(ctx aws.Context, input *waf.UpdateIPSetInput, opts ...request.Option) (*waf.UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateRule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateRule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateRuleRequest method.
//    req, resp := client.UpdateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRule
func (c *WAFRegional) UpdateRuleRequest(input *waf.UpdateRuleInput) (req *request.Request, output *waf.UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateRuleInput{}
	}

	output = &waf.UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRule API operation for AWS WAF Regional.
//
// Inserts or deletes Predicate objects in a Rule. Each Predicate object identifies
// a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests
// that you want to allow, block, or count. If you add more than one predicate
// to a Rule, a request must match all of the specifications to be allowed,
// blocked, or counted. For example, suppose you add the following to a Rule:
//
//    * A ByteMatchSet that matches the value BadBot in the User-Agent header
//
//    * An IPSet that matches the IP address 192.0.2.44
//
// You then add the Rule to a WebACL and specify that you want to block requests
// that satisfy the Rule. For a request to be blocked, the User-Agent header
// in the request must contain the value BadBotand the request must originate
// from the IP address 192.0.2.44.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule.
//
// Create the Rule. See CreateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to add predicates to the Rule.
//
// Create and update a WebACL that contains the Rule. See CreateWebACL.
//
// If you want to replace one ByteMatchSet or IPSet with another, you delete
// the existing one and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateRule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateRule
func (c *WAFRegional) UpdateRule(input *waf.UpdateRuleInput) (*waf.UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateRuleWithContext(ctx aws.Context, input *waf.UpdateRuleInput, opts ...request.Option) (*waf.UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSizeConstraintSet = "UpdateSizeConstraintSet"

// UpdateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSizeConstraintSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSizeConstraintSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSizeConstraintSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSizeConstraintSetRequest method.
//    req, resp := client.UpdateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSizeConstraintSet
func (c *WAFRegional) UpdateSizeConstraintSetRequest(input *waf.UpdateSizeConstraintSetInput) (req *request.Request, output *waf.UpdateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateSizeConstraintSetInput{}
	}

	output = &waf.UpdateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSizeConstraintSet API operation for AWS WAF Regional.
//
// Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet.
// For each SizeConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a SizeConstraintSetUpdate object, you delete the existing object
//    and add a new one.
//
//    * The part of a web request that you want AWS WAF to evaluate, such as
//    the length of a query string or the length of the User-Agent header.
//
//    * Whether to perform any transformations on the request, such as converting
//    it to lowercase, before checking its length. Note that transformations
//    of the request body are not supported because the AWS resource forwards
//    only the first 8192 bytes of your request to AWS WAF.
//
//    * A ComparisonOperator used for evaluating the selected part of the request
//    against the specified Size, such as equals, greater than, less than, and
//    so on.
//
//    * The length, in bytes, that you want AWS WAF to watch for in selected
//    part of the request. The length is computed after applying the transformation.
//
// For example, you can add a SizeConstraintSetUpdate object that matches web
// requests in which the length of the User-Agent header is greater than 100
// bytes. You can then configure AWS WAF to block those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateSizeConstraintSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSizeConstraintSet
func (c *WAFRegional) UpdateSizeConstraintSet(input *waf.UpdateSizeConstraintSetInput) (*waf.UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// UpdateSizeConstraintSetWithContext is the same as UpdateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateSizeConstraintSetWithContext(ctx aws.Context, input *waf.UpdateSizeConstraintSetInput, opts ...request.Option) (*waf.UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSqlInjectionMatchSet = "UpdateSqlInjectionMatchSet"

// UpdateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSqlInjectionMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSqlInjectionMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSqlInjectionMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSqlInjectionMatchSetRequest method.
//    req, resp := client.UpdateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSqlInjectionMatchSet
func (c *WAFRegional) UpdateSqlInjectionMatchSetRequest(input *waf.UpdateSqlInjectionMatchSetInput) (req *request.Request, output *waf.UpdateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateSqlInjectionMatchSetInput{}
	}

	output = &waf.UpdateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSqlInjectionMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet.
// For each SqlInjectionMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change a SqlInjectionMatchTuple, you delete the existing
//    object and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header, the name of the header.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for snippets of malicious
//    SQL code.
//
// You use SqlInjectionMatchSet objects to specify which CloudFront requests
// you want to allow, block, or count. For example, if you're receiving requests
// that contain snippets of SQL code in the query string and you want to block
// the requests, you can create a SqlInjectionMatchSet with the applicable settings,
// and then configure AWS WAF to block the requests.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests that you want AWS WAF to inspect for snippets of SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSqlInjectionMatchSet
func (c *WAFRegional) UpdateSqlInjectionMatchSet(input *waf.UpdateSqlInjectionMatchSetInput) (*waf.UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// UpdateSqlInjectionMatchSetWithContext is the same as UpdateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateSqlInjectionMatchSetWithContext(ctx aws.Context, input *waf.UpdateSqlInjectionMatchSetInput, opts ...request.Option) (*waf.UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebACL operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateWebACL for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateWebACL method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateWebACLRequest method.
//    req, resp := client.UpdateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateWebACL
func (c *WAFRegional) UpdateWebACLRequest(input *waf.UpdateWebACLInput) (req *request.Request, output *waf.UpdateWebACLOutput) {
	op := &request.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateWebACLInput{}
	}

	output = &waf.UpdateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWebACL API operation for AWS WAF Regional.
//
// Inserts or deletes ActivatedRule objects in a WebACL. Each Rule identifies
// web requests that you want to allow, block, or count. When you update a WebACL,
// you specify the following values:
//
//    * A default action for the WebACL, either ALLOW or BLOCK. AWS WAF performs
//    the default action if a request doesn't match the criteria in any of the
//    Rules in a WebACL.
//
//    * The Rules that you want to add and/or delete. If you want to replace
//    one Rule with another, you delete the existing Rule and add the new one.
//
//    * For each Rule, whether you want AWS WAF to allow requests, block requests,
//    or count requests that match the conditions in the Rule.
//
//    * The order in which you want AWS WAF to evaluate the Rules in a WebACL.
//    If you add more than one Rule to a WebACL, AWS WAF evaluates each request
//    against the Rules in order based on the value of Priority. (The Rule that
//    has the lowest value for Priority is evaluated first.) When a web request
//    matches all of the predicates (such as ByteMatchSets and IPSets) in a
//    Rule, AWS WAF immediately takes the corresponding action, allow or block,
//    and doesn't evaluate the request against the remaining Rules in the WebACL,
//    if any.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the predicates that you want to include in Rules. For more
// information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet,
// CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Create a WebACL. See CreateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateWebACL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFReferencedItemException "WAFReferencedItemException"
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateWebACL
func (c *WAFRegional) UpdateWebACL(input *waf.UpdateWebACLInput) (*waf.UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	return out, req.Send()
}

// UpdateWebACLWithContext is the same as UpdateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateWebACLWithContext(ctx aws.Context, input *waf.UpdateWebACLInput, opts ...request.Option) (*waf.UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateXssMatchSet = "UpdateXssMatchSet"

// UpdateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateXssMatchSet operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateXssMatchSet for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateXssMatchSet method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateXssMatchSetRequest method.
//    req, resp := client.UpdateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateXssMatchSet
func (c *WAFRegional) UpdateXssMatchSetRequest(input *waf.UpdateXssMatchSetInput) (req *request.Request, output *waf.UpdateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &waf.UpdateXssMatchSetInput{}
	}

	output = &waf.UpdateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateXssMatchSet API operation for AWS WAF Regional.
//
// Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet. For
// each XssMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change a XssMatchTuple, you delete the existing object and
//    add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header, the name of the header.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for cross-site scripting
//    attacks.
//
// You use XssMatchSet objects to specify which CloudFront requests you want
// to allow, block, or count. For example, if you're receiving requests that
// contain cross-site scripting attacks in the request body and you want to
// block the requests, you can create an XssMatchSet with the applicable settings,
// and then configure AWS WAF to block the requests.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// that you want AWS WAF to inspect for cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (http://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF Regional's
// API operation UpdateXssMatchSet for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeWAFInternalErrorException "WAFInternalErrorException"
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * ErrCodeWAFInvalidAccountException "WAFInvalidAccountException"
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * ErrCodeWAFInvalidOperationException "WAFInvalidOperationException"
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add an IP address to an IPSet, but the IP address already
//      exists in the specified IPSet.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * ErrCodeWAFInvalidParameterException "WAFInvalidParameterException"
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a WebACL with a WafActionType other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatchType other than
//      HEADER, QUERY_STRING, or URI.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * ErrCodeWAFNonexistentContainerException "WAFNonexistentContainerException"
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * ErrCodeWAFNonexistentItemException "WAFNonexistentItemException"
//   The operation failed because the referenced object doesn't exist.
//
//   * ErrCodeWAFStaleDataException "WAFStaleDataException"
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ErrCodeWAFLimitsExceededException "WAFLimitsExceededException"
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (http://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateXssMatchSet
func (c *WAFRegional) UpdateXssMatchSet(input *waf.UpdateXssMatchSetInput) (*waf.UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	return out, req.Send()
}

// UpdateXssMatchSetWithContext is the same as UpdateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAFRegional) UpdateXssMatchSetWithContext(ctx aws.Context, input *waf.UpdateXssMatchSetInput, opts ...request.Option) (*waf.UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACLRequest
type AssociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource to be protected.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A unique identifier (ID) for the web ACL.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AssociateWebACLInput) SetResourceArn(v string) *AssociateWebACLInput {
	s.ResourceArn = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *AssociateWebACLInput) SetWebACLId(v string) *AssociateWebACLInput {
	s.WebACLId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/AssociateWebACLResponse
type AssociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateWebACLOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACLRequest
type DisassociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource from which the web ACL is
	// being removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateWebACLInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DisassociateWebACLInput) SetResourceArn(v string) *DisassociateWebACLInput {
	s.ResourceArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACLResponse
type DisassociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateWebACLOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResourceRequest
type GetWebACLForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource for which to get the web ACL.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebACLForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetWebACLForResourceInput) SetResourceArn(v string) *GetWebACLForResourceInput {
	s.ResourceArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/GetWebACLForResourceResponse
type GetWebACLForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the web ACL that you specified in the GetWebACLForResource
	// request. If there is no associated resource, a null WebACLSummary is returned.
	WebACLSummary *waf.WebACLSummary `type:"structure"`
}

// String returns the string representation
func (s GetWebACLForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLForResourceOutput) GoString() string {
	return s.String()
}

// SetWebACLSummary sets the WebACLSummary field's value.
func (s *GetWebACLForResourceOutput) SetWebACLSummary(v *waf.WebACLSummary) *GetWebACLForResourceOutput {
	s.WebACLSummary = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACLRequest
type ListResourcesForWebACLInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) of the web ACL for which to list the associated
	// resources.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourcesForWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesForWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesForWebACLInput"}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWebACLId sets the WebACLId field's value.
func (s *ListResourcesForWebACLInput) SetWebACLId(v string) *ListResourcesForWebACLInput {
	s.WebACLId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/ListResourcesForWebACLResponse
type ListResourcesForWebACLOutput struct {
	_ struct{} `type:"structure"`

	// An array of ARNs (Amazon Resource Names) of the resources associated with
	// the specified web ACL. An array with zero elements is returned if there are
	// no resources associated with the web ACL.
	ResourceArns []*string `type:"list"`
}

// String returns the string representation
func (s ListResourcesForWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourcesForWebACLOutput) GoString() string {
	return s.String()
}

// SetResourceArns sets the ResourceArns field's value.
func (s *ListResourcesForWebACLOutput) SetResourceArns(v []*string) *ListResourcesForWebACLOutput {
	s.ResourceArns = v
	return s
}

const (
	// ChangeActionInsert is a ChangeAction enum value
	ChangeActionInsert = "INSERT"

	// ChangeActionDelete is a ChangeAction enum value
	ChangeActionDelete = "DELETE"
)

const (
	// ChangeTokenStatusProvisioned is a ChangeTokenStatus enum value
	ChangeTokenStatusProvisioned = "PROVISIONED"

	// ChangeTokenStatusPending is a ChangeTokenStatus enum value
	ChangeTokenStatusPending = "PENDING"

	// ChangeTokenStatusInsync is a ChangeTokenStatus enum value
	ChangeTokenStatusInsync = "INSYNC"
)

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"
)

const (
	// IPSetDescriptorTypeIpv4 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv4 = "IPV4"

	// IPSetDescriptorTypeIpv6 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv6 = "IPV6"
)

const (
	// MatchFieldTypeUri is a MatchFieldType enum value
	MatchFieldTypeUri = "URI"

	// MatchFieldTypeQueryString is a MatchFieldType enum value
	MatchFieldTypeQueryString = "QUERY_STRING"

	// MatchFieldTypeHeader is a MatchFieldType enum value
	MatchFieldTypeHeader = "HEADER"

	// MatchFieldTypeMethod is a MatchFieldType enum value
	MatchFieldTypeMethod = "METHOD"

	// MatchFieldTypeBody is a MatchFieldType enum value
	MatchFieldTypeBody = "BODY"
)

const (
	// ParameterExceptionFieldChangeAction is a ParameterExceptionField enum value
	ParameterExceptionFieldChangeAction = "CHANGE_ACTION"

	// ParameterExceptionFieldWafAction is a ParameterExceptionField enum value
	ParameterExceptionFieldWafAction = "WAF_ACTION"

	// ParameterExceptionFieldPredicateType is a ParameterExceptionField enum value
	ParameterExceptionFieldPredicateType = "PREDICATE_TYPE"

	// ParameterExceptionFieldIpsetType is a ParameterExceptionField enum value
	ParameterExceptionFieldIpsetType = "IPSET_TYPE"

	// ParameterExceptionFieldByteMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchFieldType = "BYTE_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldSqlInjectionMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldSqlInjectionMatchFieldType = "SQL_INJECTION_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldByteMatchTextTransformation is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchTextTransformation = "BYTE_MATCH_TEXT_TRANSFORMATION"

	// ParameterExceptionFieldByteMatchPositionalConstraint is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchPositionalConstraint = "BYTE_MATCH_POSITIONAL_CONSTRAINT"

	// ParameterExceptionFieldSizeConstraintComparisonOperator is a ParameterExceptionField enum value
	ParameterExceptionFieldSizeConstraintComparisonOperator = "SIZE_CONSTRAINT_COMPARISON_OPERATOR"
)

const (
	// ParameterExceptionReasonInvalidOption is a ParameterExceptionReason enum value
	ParameterExceptionReasonInvalidOption = "INVALID_OPTION"

	// ParameterExceptionReasonIllegalCombination is a ParameterExceptionReason enum value
	ParameterExceptionReasonIllegalCombination = "ILLEGAL_COMBINATION"
)

const (
	// PositionalConstraintExactly is a PositionalConstraint enum value
	PositionalConstraintExactly = "EXACTLY"

	// PositionalConstraintStartsWith is a PositionalConstraint enum value
	PositionalConstraintStartsWith = "STARTS_WITH"

	// PositionalConstraintEndsWith is a PositionalConstraint enum value
	PositionalConstraintEndsWith = "ENDS_WITH"

	// PositionalConstraintContains is a PositionalConstraint enum value
	PositionalConstraintContains = "CONTAINS"

	// PositionalConstraintContainsWord is a PositionalConstraint enum value
	PositionalConstraintContainsWord = "CONTAINS_WORD"
)

const (
	// PredicateTypeIpmatch is a PredicateType enum value
	PredicateTypeIpmatch = "IPMatch"

	// PredicateTypeByteMatch is a PredicateType enum value
	PredicateTypeByteMatch = "ByteMatch"

	// PredicateTypeSqlInjectionMatch is a PredicateType enum value
	PredicateTypeSqlInjectionMatch = "SqlInjectionMatch"

	// PredicateTypeSizeConstraint is a PredicateType enum value
	PredicateTypeSizeConstraint = "SizeConstraint"

	// PredicateTypeXssMatch is a PredicateType enum value
	PredicateTypeXssMatch = "XssMatch"
)

const (
	// TextTransformationNone is a TextTransformation enum value
	TextTransformationNone = "NONE"

	// TextTransformationCompressWhiteSpace is a TextTransformation enum value
	TextTransformationCompressWhiteSpace = "COMPRESS_WHITE_SPACE"

	// TextTransformationHtmlEntityDecode is a TextTransformation enum value
	TextTransformationHtmlEntityDecode = "HTML_ENTITY_DECODE"

	// TextTransformationLowercase is a TextTransformation enum value
	TextTransformationLowercase = "LOWERCASE"

	// TextTransformationCmdLine is a TextTransformation enum value
	TextTransformationCmdLine = "CMD_LINE"

	// TextTransformationUrlDecode is a TextTransformation enum value
	TextTransformationUrlDecode = "URL_DECODE"
)

const (
	// WafActionTypeBlock is a WafActionType enum value
	WafActionTypeBlock = "BLOCK"

	// WafActionTypeAllow is a WafActionType enum value
	WafActionTypeAllow = "ALLOW"

	// WafActionTypeCount is a WafActionType enum value
	WafActionTypeCount = "COUNT"
)
